// This file is automatically generated, so please do not edit it.
// @generated by `flutter_rust_bridge`@ 2.11.1.

// ignore_for_file: unused_import, unused_element, unnecessary_import, duplicate_ignore, invalid_use_of_internal_member, annotate_overrides, non_constant_identifier_names, curly_braces_in_flow_control_structures, prefer_const_literals_to_create_immutables, unused_field

import 'api/app.dart';
import 'api/database/bookmark.dart';
import 'api/database/get_settings_kv.dart';
import 'api/database/initialize.dart';
import 'api/database/proxy.dart';
import 'api/internals.dart';
import 'dart:async';
import 'dart:convert';
import 'frb_generated.dart';
import 'frb_generated.io.dart'
    if (dart.library.js_interop) 'frb_generated.web.dart';
import 'package:flutter_rust_bridge/flutter_rust_bridge_for_generated.dart';

/// Main entrypoint of the Rust API
class RustLib extends BaseEntrypoint<RustLibApi, RustLibApiImpl, RustLibWire> {
  @internal
  static final instance = RustLib._();

  RustLib._();

  /// Initialize flutter_rust_bridge
  static Future<void> init({
    RustLibApi? api,
    BaseHandler? handler,
    ExternalLibrary? externalLibrary,
    bool forceSameCodegenVersion = true,
  }) async {
    await instance.initImpl(
      api: api,
      handler: handler,
      externalLibrary: externalLibrary,
      forceSameCodegenVersion: forceSameCodegenVersion,
    );
  }

  /// Initialize flutter_rust_bridge in mock mode.
  /// No libraries for FFI are loaded.
  static void initMock({required RustLibApi api}) {
    instance.initMockImpl(api: api);
  }

  /// Dispose flutter_rust_bridge
  ///
  /// The call to this function is optional, since flutter_rust_bridge (and everything else)
  /// is automatically disposed when the app stops.
  static void dispose() => instance.disposeImpl();

  @override
  ApiImplConstructor<RustLibApiImpl, RustLibWire> get apiImplConstructor =>
      RustLibApiImpl.new;

  @override
  WireConstructor<RustLibWire> get wireConstructor =>
      RustLibWire.fromExternalLibrary;

  @override
  Future<void> executeRustInitializers() async {}

  @override
  ExternalLibraryLoaderConfig get defaultExternalLibraryLoaderConfig =>
      kDefaultExternalLibraryLoaderConfig;

  @override
  String get codegenVersion => '2.11.1';

  @override
  int get rustContentHash => -1131822192;

  static const kDefaultExternalLibraryLoaderConfig =
      ExternalLibraryLoaderConfig(
        stem: 'rust_lib_torrents_digger',
        ioDirectory: 'rust/target/release/',
        webPrefix: 'pkg/',
      );
}

abstract class RustLibApi extends BaseApi {
  Future<BigInt> crateApiDatabaseBookmarkBookmarkATorrent({
    required InternalTorrent torrent,
  });

  Future<bool> crateApiDatabaseBookmarkCheckBookmarkExistence({
    required String infoHash,
  });

  Future<int> crateApiAppCheckNewUpdate();

  Future<BigInt> crateApiDatabaseProxyDeleteProxy({required int proxyId});

  Future<(List<InternalTorrent>, PlatformInt64?)> crateApiAppDigCustomTorrents({
    required BigInt index,
  });

  Future<(List<InternalTorrent>, PlatformInt64?)> crateApiAppDigTorrent({
    required String torrentName,
    required BigInt sourceIndex,
    required BigInt categoryIndex,
    required BigInt filterIndex,
    required BigInt sortingIndex,
    required BigInt sortingOrderIndex,
    PlatformInt64? page,
  });

  Future<List<InternalSource>> crateApiAppFetchSourceDetails();

  Future<String?> crateApiDatabaseGetSettingsKvGetASettingsKv({
    required String key,
  });

  Future<String> crateApiDatabaseGetSettingsKvGetActiveDefaultTrackersList();

  Future<List<InternalTorrent>> crateApiDatabaseBookmarkGetAllBookmarks();

  Future<List<(BigInt, String)>> crateApiAppGetAllDefaultTrackersList();

  Future<String> crateApiAppGetAppCurrentVersion();

  Future<List<String>> crateApiAppGetCustomsDetails();

  Future<String> crateApiAppGetIpDetails();

  Future<String> crateApiAppGetProcessedMagnetLink({
    required String unprocessedMagnet,
  });

  Future<InternalProxy?> crateApiDatabaseProxyGetSavedProxy();

  Future<Map<String, String>> crateApiDatabaseGetSettingsKvGetSettingsKv();

  Future<List<(int, String)>> crateApiDatabaseProxyGetSupportedProxyDetails();

  Future<void> crateApiDatabaseInitializeInitializeTorrentsDiggerDatabase({
    required String torrentsDiggerDatabaseDirectory,
  });

  Future<String> crateApiDatabaseGetSettingsKvInsertOrUpdateKv({
    required String key,
    required String value,
  });

  Future<bool> crateApiAppLoadDefaultTrackersString();

  Future<bool> crateApiDatabaseBookmarkRemoveBookmark({
    required String infoHash,
  });

  Future<BigInt> crateApiDatabaseProxySaveProxyApi({
    required InternalProxy proxyData,
  });

  Future<BigInt> crateApiDatabaseGetSettingsKvSetDefaultTrackersList({
    required int index,
  });
}

class RustLibApiImpl extends RustLibApiImplPlatform implements RustLibApi {
  RustLibApiImpl({
    required super.handler,
    required super.wire,
    required super.generalizedFrbRustBinding,
    required super.portManager,
  });

  @override
  Future<BigInt> crateApiDatabaseBookmarkBookmarkATorrent({
    required InternalTorrent torrent,
  }) {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          sse_encode_box_autoadd_internal_torrent(torrent, serializer);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 1,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_usize,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiDatabaseBookmarkBookmarkATorrentConstMeta,
        argValues: [torrent],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiDatabaseBookmarkBookmarkATorrentConstMeta =>
      const TaskConstMeta(
        debugName: "bookmark_a_torrent",
        argNames: ["torrent"],
      );

  @override
  Future<bool> crateApiDatabaseBookmarkCheckBookmarkExistence({
    required String infoHash,
  }) {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          sse_encode_String(infoHash, serializer);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 2,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_bool,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiDatabaseBookmarkCheckBookmarkExistenceConstMeta,
        argValues: [infoHash],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiDatabaseBookmarkCheckBookmarkExistenceConstMeta =>
      const TaskConstMeta(
        debugName: "check_bookmark_existence",
        argNames: ["infoHash"],
      );

  @override
  Future<int> crateApiAppCheckNewUpdate() {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 3,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_u_8,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiAppCheckNewUpdateConstMeta,
        argValues: [],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiAppCheckNewUpdateConstMeta =>
      const TaskConstMeta(debugName: "check_new_update", argNames: []);

  @override
  Future<BigInt> crateApiDatabaseProxyDeleteProxy({required int proxyId}) {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          sse_encode_i_32(proxyId, serializer);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 4,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_usize,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiDatabaseProxyDeleteProxyConstMeta,
        argValues: [proxyId],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiDatabaseProxyDeleteProxyConstMeta =>
      const TaskConstMeta(debugName: "delete_proxy", argNames: ["proxyId"]);

  @override
  Future<(List<InternalTorrent>, PlatformInt64?)> crateApiAppDigCustomTorrents({
    required BigInt index,
  }) {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          sse_encode_usize(index, serializer);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 5,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData:
              sse_decode_record_list_internal_torrent_opt_box_autoadd_i_64,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiAppDigCustomTorrentsConstMeta,
        argValues: [index],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiAppDigCustomTorrentsConstMeta =>
      const TaskConstMeta(
        debugName: "dig_custom_torrents",
        argNames: ["index"],
      );

  @override
  Future<(List<InternalTorrent>, PlatformInt64?)> crateApiAppDigTorrent({
    required String torrentName,
    required BigInt sourceIndex,
    required BigInt categoryIndex,
    required BigInt filterIndex,
    required BigInt sortingIndex,
    required BigInt sortingOrderIndex,
    PlatformInt64? page,
  }) {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          sse_encode_String(torrentName, serializer);
          sse_encode_usize(sourceIndex, serializer);
          sse_encode_usize(categoryIndex, serializer);
          sse_encode_usize(filterIndex, serializer);
          sse_encode_usize(sortingIndex, serializer);
          sse_encode_usize(sortingOrderIndex, serializer);
          sse_encode_opt_box_autoadd_i_64(page, serializer);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 6,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData:
              sse_decode_record_list_internal_torrent_opt_box_autoadd_i_64,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiAppDigTorrentConstMeta,
        argValues: [
          torrentName,
          sourceIndex,
          categoryIndex,
          filterIndex,
          sortingIndex,
          sortingOrderIndex,
          page,
        ],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiAppDigTorrentConstMeta => const TaskConstMeta(
    debugName: "dig_torrent",
    argNames: [
      "torrentName",
      "sourceIndex",
      "categoryIndex",
      "filterIndex",
      "sortingIndex",
      "sortingOrderIndex",
      "page",
    ],
  );

  @override
  Future<List<InternalSource>> crateApiAppFetchSourceDetails() {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 7,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_list_internal_source,
          decodeErrorData: null,
        ),
        constMeta: kCrateApiAppFetchSourceDetailsConstMeta,
        argValues: [],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiAppFetchSourceDetailsConstMeta =>
      const TaskConstMeta(debugName: "fetch_source_details", argNames: []);

  @override
  Future<String?> crateApiDatabaseGetSettingsKvGetASettingsKv({
    required String key,
  }) {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          sse_encode_String(key, serializer);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 8,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_opt_String,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiDatabaseGetSettingsKvGetASettingsKvConstMeta,
        argValues: [key],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiDatabaseGetSettingsKvGetASettingsKvConstMeta =>
      const TaskConstMeta(debugName: "get_a_settings_kv", argNames: ["key"]);

  @override
  Future<String> crateApiDatabaseGetSettingsKvGetActiveDefaultTrackersList() {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 9,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_String,
          decodeErrorData: sse_decode_String,
        ),
        constMeta:
            kCrateApiDatabaseGetSettingsKvGetActiveDefaultTrackersListConstMeta,
        argValues: [],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta
  get kCrateApiDatabaseGetSettingsKvGetActiveDefaultTrackersListConstMeta =>
      const TaskConstMeta(
        debugName: "get_active_default_trackers_list",
        argNames: [],
      );

  @override
  Future<List<InternalTorrent>> crateApiDatabaseBookmarkGetAllBookmarks() {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 10,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_list_internal_torrent,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiDatabaseBookmarkGetAllBookmarksConstMeta,
        argValues: [],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiDatabaseBookmarkGetAllBookmarksConstMeta =>
      const TaskConstMeta(debugName: "get_all_bookmarks", argNames: []);

  @override
  Future<List<(BigInt, String)>> crateApiAppGetAllDefaultTrackersList() {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 11,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_list_record_usize_string,
          decodeErrorData: null,
        ),
        constMeta: kCrateApiAppGetAllDefaultTrackersListConstMeta,
        argValues: [],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiAppGetAllDefaultTrackersListConstMeta =>
      const TaskConstMeta(
        debugName: "get_all_default_trackers_list",
        argNames: [],
      );

  @override
  Future<String> crateApiAppGetAppCurrentVersion() {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 12,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_String,
          decodeErrorData: null,
        ),
        constMeta: kCrateApiAppGetAppCurrentVersionConstMeta,
        argValues: [],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiAppGetAppCurrentVersionConstMeta =>
      const TaskConstMeta(debugName: "get_app_current_version", argNames: []);

  @override
  Future<List<String>> crateApiAppGetCustomsDetails() {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 13,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_list_String,
          decodeErrorData: null,
        ),
        constMeta: kCrateApiAppGetCustomsDetailsConstMeta,
        argValues: [],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiAppGetCustomsDetailsConstMeta =>
      const TaskConstMeta(debugName: "get_customs_details", argNames: []);

  @override
  Future<String> crateApiAppGetIpDetails() {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 14,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_String,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiAppGetIpDetailsConstMeta,
        argValues: [],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiAppGetIpDetailsConstMeta =>
      const TaskConstMeta(debugName: "get_ip_details", argNames: []);

  @override
  Future<String> crateApiAppGetProcessedMagnetLink({
    required String unprocessedMagnet,
  }) {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          sse_encode_String(unprocessedMagnet, serializer);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 15,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_String,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiAppGetProcessedMagnetLinkConstMeta,
        argValues: [unprocessedMagnet],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiAppGetProcessedMagnetLinkConstMeta =>
      const TaskConstMeta(
        debugName: "get_processed_magnet_link",
        argNames: ["unprocessedMagnet"],
      );

  @override
  Future<InternalProxy?> crateApiDatabaseProxyGetSavedProxy() {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 16,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_opt_box_autoadd_internal_proxy,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiDatabaseProxyGetSavedProxyConstMeta,
        argValues: [],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiDatabaseProxyGetSavedProxyConstMeta =>
      const TaskConstMeta(debugName: "get_saved_proxy", argNames: []);

  @override
  Future<Map<String, String>> crateApiDatabaseGetSettingsKvGetSettingsKv() {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 17,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_Map_String_String_None,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiDatabaseGetSettingsKvGetSettingsKvConstMeta,
        argValues: [],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiDatabaseGetSettingsKvGetSettingsKvConstMeta =>
      const TaskConstMeta(debugName: "get_settings_kv", argNames: []);

  @override
  Future<List<(int, String)>> crateApiDatabaseProxyGetSupportedProxyDetails() {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 18,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_list_record_i_32_string,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiDatabaseProxyGetSupportedProxyDetailsConstMeta,
        argValues: [],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiDatabaseProxyGetSupportedProxyDetailsConstMeta =>
      const TaskConstMeta(
        debugName: "get_supported_proxy_details",
        argNames: [],
      );

  @override
  Future<void> crateApiDatabaseInitializeInitializeTorrentsDiggerDatabase({
    required String torrentsDiggerDatabaseDirectory,
  }) {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          sse_encode_String(torrentsDiggerDatabaseDirectory, serializer);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 19,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_unit,
          decodeErrorData: sse_decode_String,
        ),
        constMeta:
            kCrateApiDatabaseInitializeInitializeTorrentsDiggerDatabaseConstMeta,
        argValues: [torrentsDiggerDatabaseDirectory],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta
  get kCrateApiDatabaseInitializeInitializeTorrentsDiggerDatabaseConstMeta =>
      const TaskConstMeta(
        debugName: "initialize_torrents_digger_database",
        argNames: ["torrentsDiggerDatabaseDirectory"],
      );

  @override
  Future<String> crateApiDatabaseGetSettingsKvInsertOrUpdateKv({
    required String key,
    required String value,
  }) {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          sse_encode_String(key, serializer);
          sse_encode_String(value, serializer);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 20,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_String,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiDatabaseGetSettingsKvInsertOrUpdateKvConstMeta,
        argValues: [key, value],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiDatabaseGetSettingsKvInsertOrUpdateKvConstMeta =>
      const TaskConstMeta(
        debugName: "insert_or_update_kv",
        argNames: ["key", "value"],
      );

  @override
  Future<bool> crateApiAppLoadDefaultTrackersString() {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 21,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_bool,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiAppLoadDefaultTrackersStringConstMeta,
        argValues: [],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiAppLoadDefaultTrackersStringConstMeta =>
      const TaskConstMeta(
        debugName: "load_default_trackers_string",
        argNames: [],
      );

  @override
  Future<bool> crateApiDatabaseBookmarkRemoveBookmark({
    required String infoHash,
  }) {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          sse_encode_String(infoHash, serializer);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 22,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_bool,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiDatabaseBookmarkRemoveBookmarkConstMeta,
        argValues: [infoHash],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiDatabaseBookmarkRemoveBookmarkConstMeta =>
      const TaskConstMeta(debugName: "remove_bookmark", argNames: ["infoHash"]);

  @override
  Future<BigInt> crateApiDatabaseProxySaveProxyApi({
    required InternalProxy proxyData,
  }) {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          sse_encode_box_autoadd_internal_proxy(proxyData, serializer);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 23,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_usize,
          decodeErrorData: sse_decode_String,
        ),
        constMeta: kCrateApiDatabaseProxySaveProxyApiConstMeta,
        argValues: [proxyData],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta get kCrateApiDatabaseProxySaveProxyApiConstMeta =>
      const TaskConstMeta(debugName: "save_proxy_api", argNames: ["proxyData"]);

  @override
  Future<BigInt> crateApiDatabaseGetSettingsKvSetDefaultTrackersList({
    required int index,
  }) {
    return handler.executeNormal(
      NormalTask(
        callFfi: (port_) {
          final serializer = SseSerializer(generalizedFrbRustBinding);
          sse_encode_i_8(index, serializer);
          pdeCallFfi(
            generalizedFrbRustBinding,
            serializer,
            funcId: 24,
            port: port_,
          );
        },
        codec: SseCodec(
          decodeSuccessData: sse_decode_usize,
          decodeErrorData: sse_decode_String,
        ),
        constMeta:
            kCrateApiDatabaseGetSettingsKvSetDefaultTrackersListConstMeta,
        argValues: [index],
        apiImpl: this,
      ),
    );
  }

  TaskConstMeta
  get kCrateApiDatabaseGetSettingsKvSetDefaultTrackersListConstMeta =>
      const TaskConstMeta(
        debugName: "set_default_trackers_list",
        argNames: ["index"],
      );

  @protected
  Map<String, String> dco_decode_Map_String_String_None(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return Map.fromEntries(
      dco_decode_list_record_string_string(
        raw,
      ).map((e) => MapEntry(e.$1, e.$2)),
    );
  }

  @protected
  String dco_decode_String(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return raw as String;
  }

  @protected
  bool dco_decode_bool(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return raw as bool;
  }

  @protected
  PlatformInt64 dco_decode_box_autoadd_i_64(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return dco_decode_i_64(raw);
  }

  @protected
  InternalProxy dco_decode_box_autoadd_internal_proxy(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return dco_decode_internal_proxy(raw);
  }

  @protected
  InternalTorrent dco_decode_box_autoadd_internal_torrent(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return dco_decode_internal_torrent(raw);
  }

  @protected
  int dco_decode_i_32(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return raw as int;
  }

  @protected
  PlatformInt64 dco_decode_i_64(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return dcoDecodeI64(raw);
  }

  @protected
  int dco_decode_i_8(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return raw as int;
  }

  @protected
  InternalProxy dco_decode_internal_proxy(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    final arr = raw as List<dynamic>;
    if (arr.length != 7)
      throw Exception('unexpected arr length: expect 7 but see ${arr.length}');
    return InternalProxy(
      id: dco_decode_i_32(arr[0]),
      proxyName: dco_decode_String(arr[1]),
      proxyType: dco_decode_String(arr[2]),
      proxyServerIp: dco_decode_String(arr[3]),
      proxyServerPort: dco_decode_String(arr[4]),
      proxyUsername: dco_decode_opt_String(arr[5]),
      proxyPassword: dco_decode_opt_String(arr[6]),
    );
  }

  @protected
  InternalQueryOptions dco_decode_internal_query_options(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    final arr = raw as List<dynamic>;
    if (arr.length != 5)
      throw Exception('unexpected arr length: expect 5 but see ${arr.length}');
    return InternalQueryOptions(
      categories: dco_decode_bool(arr[0]),
      filters: dco_decode_bool(arr[1]),
      sortings: dco_decode_bool(arr[2]),
      sortingOrders: dco_decode_bool(arr[3]),
      pagination: dco_decode_bool(arr[4]),
    );
  }

  @protected
  InternalSource dco_decode_internal_source(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    final arr = raw as List<dynamic>;
    if (arr.length != 2)
      throw Exception('unexpected arr length: expect 2 but see ${arr.length}');
    return InternalSource(
      sourceName: dco_decode_String(arr[0]),
      sourceDetails: dco_decode_internal_source_details(arr[1]),
    );
  }

  @protected
  InternalSourceDetails dco_decode_internal_source_details(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    final arr = raw as List<dynamic>;
    if (arr.length != 5)
      throw Exception('unexpected arr length: expect 5 but see ${arr.length}');
    return InternalSourceDetails(
      queryOptions: dco_decode_internal_query_options(arr[0]),
      categories: dco_decode_list_String(arr[1]),
      sourceFilters: dco_decode_list_String(arr[2]),
      sourceSortings: dco_decode_list_String(arr[3]),
      sourceSortingOrders: dco_decode_list_String(arr[4]),
    );
  }

  @protected
  InternalTorrent dco_decode_internal_torrent(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    final arr = raw as List<dynamic>;
    if (arr.length != 8)
      throw Exception('unexpected arr length: expect 8 but see ${arr.length}');
    return InternalTorrent(
      infoHash: dco_decode_String(arr[0]),
      name: dco_decode_String(arr[1]),
      magnet: dco_decode_String(arr[2]),
      size: dco_decode_String(arr[3]),
      date: dco_decode_String(arr[4]),
      seeders: dco_decode_String(arr[5]),
      leechers: dco_decode_String(arr[6]),
      totalDownloads: dco_decode_String(arr[7]),
    );
  }

  @protected
  List<String> dco_decode_list_String(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return (raw as List<dynamic>).map(dco_decode_String).toList();
  }

  @protected
  List<InternalSource> dco_decode_list_internal_source(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return (raw as List<dynamic>).map(dco_decode_internal_source).toList();
  }

  @protected
  List<InternalTorrent> dco_decode_list_internal_torrent(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return (raw as List<dynamic>).map(dco_decode_internal_torrent).toList();
  }

  @protected
  Uint8List dco_decode_list_prim_u_8_strict(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return raw as Uint8List;
  }

  @protected
  List<(int, String)> dco_decode_list_record_i_32_string(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return (raw as List<dynamic>).map(dco_decode_record_i_32_string).toList();
  }

  @protected
  List<(String, String)> dco_decode_list_record_string_string(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return (raw as List<dynamic>).map(dco_decode_record_string_string).toList();
  }

  @protected
  List<(BigInt, String)> dco_decode_list_record_usize_string(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return (raw as List<dynamic>).map(dco_decode_record_usize_string).toList();
  }

  @protected
  String? dco_decode_opt_String(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return raw == null ? null : dco_decode_String(raw);
  }

  @protected
  PlatformInt64? dco_decode_opt_box_autoadd_i_64(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return raw == null ? null : dco_decode_box_autoadd_i_64(raw);
  }

  @protected
  InternalProxy? dco_decode_opt_box_autoadd_internal_proxy(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return raw == null ? null : dco_decode_box_autoadd_internal_proxy(raw);
  }

  @protected
  (int, String) dco_decode_record_i_32_string(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    final arr = raw as List<dynamic>;
    if (arr.length != 2) {
      throw Exception('Expected 2 elements, got ${arr.length}');
    }
    return (dco_decode_i_32(arr[0]), dco_decode_String(arr[1]));
  }

  @protected
  (List<InternalTorrent>, PlatformInt64?)
  dco_decode_record_list_internal_torrent_opt_box_autoadd_i_64(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    final arr = raw as List<dynamic>;
    if (arr.length != 2) {
      throw Exception('Expected 2 elements, got ${arr.length}');
    }
    return (
      dco_decode_list_internal_torrent(arr[0]),
      dco_decode_opt_box_autoadd_i_64(arr[1]),
    );
  }

  @protected
  (String, String) dco_decode_record_string_string(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    final arr = raw as List<dynamic>;
    if (arr.length != 2) {
      throw Exception('Expected 2 elements, got ${arr.length}');
    }
    return (dco_decode_String(arr[0]), dco_decode_String(arr[1]));
  }

  @protected
  (BigInt, String) dco_decode_record_usize_string(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    final arr = raw as List<dynamic>;
    if (arr.length != 2) {
      throw Exception('Expected 2 elements, got ${arr.length}');
    }
    return (dco_decode_usize(arr[0]), dco_decode_String(arr[1]));
  }

  @protected
  int dco_decode_u_8(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return raw as int;
  }

  @protected
  void dco_decode_unit(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return;
  }

  @protected
  BigInt dco_decode_usize(dynamic raw) {
    // Codec=Dco (DartCObject based), see doc to use other codecs
    return dcoDecodeU64(raw);
  }

  @protected
  Map<String, String> sse_decode_Map_String_String_None(
    SseDeserializer deserializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    var inner = sse_decode_list_record_string_string(deserializer);
    return Map.fromEntries(inner.map((e) => MapEntry(e.$1, e.$2)));
  }

  @protected
  String sse_decode_String(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    var inner = sse_decode_list_prim_u_8_strict(deserializer);
    return utf8.decoder.convert(inner);
  }

  @protected
  bool sse_decode_bool(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    return deserializer.buffer.getUint8() != 0;
  }

  @protected
  PlatformInt64 sse_decode_box_autoadd_i_64(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    return (sse_decode_i_64(deserializer));
  }

  @protected
  InternalProxy sse_decode_box_autoadd_internal_proxy(
    SseDeserializer deserializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    return (sse_decode_internal_proxy(deserializer));
  }

  @protected
  InternalTorrent sse_decode_box_autoadd_internal_torrent(
    SseDeserializer deserializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    return (sse_decode_internal_torrent(deserializer));
  }

  @protected
  int sse_decode_i_32(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    return deserializer.buffer.getInt32();
  }

  @protected
  PlatformInt64 sse_decode_i_64(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    return deserializer.buffer.getPlatformInt64();
  }

  @protected
  int sse_decode_i_8(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    return deserializer.buffer.getInt8();
  }

  @protected
  InternalProxy sse_decode_internal_proxy(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    var var_id = sse_decode_i_32(deserializer);
    var var_proxyName = sse_decode_String(deserializer);
    var var_proxyType = sse_decode_String(deserializer);
    var var_proxyServerIp = sse_decode_String(deserializer);
    var var_proxyServerPort = sse_decode_String(deserializer);
    var var_proxyUsername = sse_decode_opt_String(deserializer);
    var var_proxyPassword = sse_decode_opt_String(deserializer);
    return InternalProxy(
      id: var_id,
      proxyName: var_proxyName,
      proxyType: var_proxyType,
      proxyServerIp: var_proxyServerIp,
      proxyServerPort: var_proxyServerPort,
      proxyUsername: var_proxyUsername,
      proxyPassword: var_proxyPassword,
    );
  }

  @protected
  InternalQueryOptions sse_decode_internal_query_options(
    SseDeserializer deserializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    var var_categories = sse_decode_bool(deserializer);
    var var_filters = sse_decode_bool(deserializer);
    var var_sortings = sse_decode_bool(deserializer);
    var var_sortingOrders = sse_decode_bool(deserializer);
    var var_pagination = sse_decode_bool(deserializer);
    return InternalQueryOptions(
      categories: var_categories,
      filters: var_filters,
      sortings: var_sortings,
      sortingOrders: var_sortingOrders,
      pagination: var_pagination,
    );
  }

  @protected
  InternalSource sse_decode_internal_source(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    var var_sourceName = sse_decode_String(deserializer);
    var var_sourceDetails = sse_decode_internal_source_details(deserializer);
    return InternalSource(
      sourceName: var_sourceName,
      sourceDetails: var_sourceDetails,
    );
  }

  @protected
  InternalSourceDetails sse_decode_internal_source_details(
    SseDeserializer deserializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    var var_queryOptions = sse_decode_internal_query_options(deserializer);
    var var_categories = sse_decode_list_String(deserializer);
    var var_sourceFilters = sse_decode_list_String(deserializer);
    var var_sourceSortings = sse_decode_list_String(deserializer);
    var var_sourceSortingOrders = sse_decode_list_String(deserializer);
    return InternalSourceDetails(
      queryOptions: var_queryOptions,
      categories: var_categories,
      sourceFilters: var_sourceFilters,
      sourceSortings: var_sourceSortings,
      sourceSortingOrders: var_sourceSortingOrders,
    );
  }

  @protected
  InternalTorrent sse_decode_internal_torrent(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    var var_infoHash = sse_decode_String(deserializer);
    var var_name = sse_decode_String(deserializer);
    var var_magnet = sse_decode_String(deserializer);
    var var_size = sse_decode_String(deserializer);
    var var_date = sse_decode_String(deserializer);
    var var_seeders = sse_decode_String(deserializer);
    var var_leechers = sse_decode_String(deserializer);
    var var_totalDownloads = sse_decode_String(deserializer);
    return InternalTorrent(
      infoHash: var_infoHash,
      name: var_name,
      magnet: var_magnet,
      size: var_size,
      date: var_date,
      seeders: var_seeders,
      leechers: var_leechers,
      totalDownloads: var_totalDownloads,
    );
  }

  @protected
  List<String> sse_decode_list_String(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs

    var len_ = sse_decode_i_32(deserializer);
    var ans_ = <String>[];
    for (var idx_ = 0; idx_ < len_; ++idx_) {
      ans_.add(sse_decode_String(deserializer));
    }
    return ans_;
  }

  @protected
  List<InternalSource> sse_decode_list_internal_source(
    SseDeserializer deserializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs

    var len_ = sse_decode_i_32(deserializer);
    var ans_ = <InternalSource>[];
    for (var idx_ = 0; idx_ < len_; ++idx_) {
      ans_.add(sse_decode_internal_source(deserializer));
    }
    return ans_;
  }

  @protected
  List<InternalTorrent> sse_decode_list_internal_torrent(
    SseDeserializer deserializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs

    var len_ = sse_decode_i_32(deserializer);
    var ans_ = <InternalTorrent>[];
    for (var idx_ = 0; idx_ < len_; ++idx_) {
      ans_.add(sse_decode_internal_torrent(deserializer));
    }
    return ans_;
  }

  @protected
  Uint8List sse_decode_list_prim_u_8_strict(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    var len_ = sse_decode_i_32(deserializer);
    return deserializer.buffer.getUint8List(len_);
  }

  @protected
  List<(int, String)> sse_decode_list_record_i_32_string(
    SseDeserializer deserializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs

    var len_ = sse_decode_i_32(deserializer);
    var ans_ = <(int, String)>[];
    for (var idx_ = 0; idx_ < len_; ++idx_) {
      ans_.add(sse_decode_record_i_32_string(deserializer));
    }
    return ans_;
  }

  @protected
  List<(String, String)> sse_decode_list_record_string_string(
    SseDeserializer deserializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs

    var len_ = sse_decode_i_32(deserializer);
    var ans_ = <(String, String)>[];
    for (var idx_ = 0; idx_ < len_; ++idx_) {
      ans_.add(sse_decode_record_string_string(deserializer));
    }
    return ans_;
  }

  @protected
  List<(BigInt, String)> sse_decode_list_record_usize_string(
    SseDeserializer deserializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs

    var len_ = sse_decode_i_32(deserializer);
    var ans_ = <(BigInt, String)>[];
    for (var idx_ = 0; idx_ < len_; ++idx_) {
      ans_.add(sse_decode_record_usize_string(deserializer));
    }
    return ans_;
  }

  @protected
  String? sse_decode_opt_String(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs

    if (sse_decode_bool(deserializer)) {
      return (sse_decode_String(deserializer));
    } else {
      return null;
    }
  }

  @protected
  PlatformInt64? sse_decode_opt_box_autoadd_i_64(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs

    if (sse_decode_bool(deserializer)) {
      return (sse_decode_box_autoadd_i_64(deserializer));
    } else {
      return null;
    }
  }

  @protected
  InternalProxy? sse_decode_opt_box_autoadd_internal_proxy(
    SseDeserializer deserializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs

    if (sse_decode_bool(deserializer)) {
      return (sse_decode_box_autoadd_internal_proxy(deserializer));
    } else {
      return null;
    }
  }

  @protected
  (int, String) sse_decode_record_i_32_string(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    var var_field0 = sse_decode_i_32(deserializer);
    var var_field1 = sse_decode_String(deserializer);
    return (var_field0, var_field1);
  }

  @protected
  (List<InternalTorrent>, PlatformInt64?)
  sse_decode_record_list_internal_torrent_opt_box_autoadd_i_64(
    SseDeserializer deserializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    var var_field0 = sse_decode_list_internal_torrent(deserializer);
    var var_field1 = sse_decode_opt_box_autoadd_i_64(deserializer);
    return (var_field0, var_field1);
  }

  @protected
  (String, String) sse_decode_record_string_string(
    SseDeserializer deserializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    var var_field0 = sse_decode_String(deserializer);
    var var_field1 = sse_decode_String(deserializer);
    return (var_field0, var_field1);
  }

  @protected
  (BigInt, String) sse_decode_record_usize_string(
    SseDeserializer deserializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    var var_field0 = sse_decode_usize(deserializer);
    var var_field1 = sse_decode_String(deserializer);
    return (var_field0, var_field1);
  }

  @protected
  int sse_decode_u_8(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    return deserializer.buffer.getUint8();
  }

  @protected
  void sse_decode_unit(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
  }

  @protected
  BigInt sse_decode_usize(SseDeserializer deserializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    return deserializer.buffer.getBigUint64();
  }

  @protected
  void sse_encode_Map_String_String_None(
    Map<String, String> self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_list_record_string_string(
      self.entries.map((e) => (e.key, e.value)).toList(),
      serializer,
    );
  }

  @protected
  void sse_encode_String(String self, SseSerializer serializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_list_prim_u_8_strict(utf8.encoder.convert(self), serializer);
  }

  @protected
  void sse_encode_bool(bool self, SseSerializer serializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    serializer.buffer.putUint8(self ? 1 : 0);
  }

  @protected
  void sse_encode_box_autoadd_i_64(
    PlatformInt64 self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_i_64(self, serializer);
  }

  @protected
  void sse_encode_box_autoadd_internal_proxy(
    InternalProxy self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_internal_proxy(self, serializer);
  }

  @protected
  void sse_encode_box_autoadd_internal_torrent(
    InternalTorrent self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_internal_torrent(self, serializer);
  }

  @protected
  void sse_encode_i_32(int self, SseSerializer serializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    serializer.buffer.putInt32(self);
  }

  @protected
  void sse_encode_i_64(PlatformInt64 self, SseSerializer serializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    serializer.buffer.putPlatformInt64(self);
  }

  @protected
  void sse_encode_i_8(int self, SseSerializer serializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    serializer.buffer.putInt8(self);
  }

  @protected
  void sse_encode_internal_proxy(InternalProxy self, SseSerializer serializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_i_32(self.id, serializer);
    sse_encode_String(self.proxyName, serializer);
    sse_encode_String(self.proxyType, serializer);
    sse_encode_String(self.proxyServerIp, serializer);
    sse_encode_String(self.proxyServerPort, serializer);
    sse_encode_opt_String(self.proxyUsername, serializer);
    sse_encode_opt_String(self.proxyPassword, serializer);
  }

  @protected
  void sse_encode_internal_query_options(
    InternalQueryOptions self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_bool(self.categories, serializer);
    sse_encode_bool(self.filters, serializer);
    sse_encode_bool(self.sortings, serializer);
    sse_encode_bool(self.sortingOrders, serializer);
    sse_encode_bool(self.pagination, serializer);
  }

  @protected
  void sse_encode_internal_source(
    InternalSource self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_String(self.sourceName, serializer);
    sse_encode_internal_source_details(self.sourceDetails, serializer);
  }

  @protected
  void sse_encode_internal_source_details(
    InternalSourceDetails self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_internal_query_options(self.queryOptions, serializer);
    sse_encode_list_String(self.categories, serializer);
    sse_encode_list_String(self.sourceFilters, serializer);
    sse_encode_list_String(self.sourceSortings, serializer);
    sse_encode_list_String(self.sourceSortingOrders, serializer);
  }

  @protected
  void sse_encode_internal_torrent(
    InternalTorrent self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_String(self.infoHash, serializer);
    sse_encode_String(self.name, serializer);
    sse_encode_String(self.magnet, serializer);
    sse_encode_String(self.size, serializer);
    sse_encode_String(self.date, serializer);
    sse_encode_String(self.seeders, serializer);
    sse_encode_String(self.leechers, serializer);
    sse_encode_String(self.totalDownloads, serializer);
  }

  @protected
  void sse_encode_list_String(List<String> self, SseSerializer serializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_i_32(self.length, serializer);
    for (final item in self) {
      sse_encode_String(item, serializer);
    }
  }

  @protected
  void sse_encode_list_internal_source(
    List<InternalSource> self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_i_32(self.length, serializer);
    for (final item in self) {
      sse_encode_internal_source(item, serializer);
    }
  }

  @protected
  void sse_encode_list_internal_torrent(
    List<InternalTorrent> self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_i_32(self.length, serializer);
    for (final item in self) {
      sse_encode_internal_torrent(item, serializer);
    }
  }

  @protected
  void sse_encode_list_prim_u_8_strict(
    Uint8List self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_i_32(self.length, serializer);
    serializer.buffer.putUint8List(self);
  }

  @protected
  void sse_encode_list_record_i_32_string(
    List<(int, String)> self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_i_32(self.length, serializer);
    for (final item in self) {
      sse_encode_record_i_32_string(item, serializer);
    }
  }

  @protected
  void sse_encode_list_record_string_string(
    List<(String, String)> self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_i_32(self.length, serializer);
    for (final item in self) {
      sse_encode_record_string_string(item, serializer);
    }
  }

  @protected
  void sse_encode_list_record_usize_string(
    List<(BigInt, String)> self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_i_32(self.length, serializer);
    for (final item in self) {
      sse_encode_record_usize_string(item, serializer);
    }
  }

  @protected
  void sse_encode_opt_String(String? self, SseSerializer serializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs

    sse_encode_bool(self != null, serializer);
    if (self != null) {
      sse_encode_String(self, serializer);
    }
  }

  @protected
  void sse_encode_opt_box_autoadd_i_64(
    PlatformInt64? self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs

    sse_encode_bool(self != null, serializer);
    if (self != null) {
      sse_encode_box_autoadd_i_64(self, serializer);
    }
  }

  @protected
  void sse_encode_opt_box_autoadd_internal_proxy(
    InternalProxy? self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs

    sse_encode_bool(self != null, serializer);
    if (self != null) {
      sse_encode_box_autoadd_internal_proxy(self, serializer);
    }
  }

  @protected
  void sse_encode_record_i_32_string(
    (int, String) self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_i_32(self.$1, serializer);
    sse_encode_String(self.$2, serializer);
  }

  @protected
  void sse_encode_record_list_internal_torrent_opt_box_autoadd_i_64(
    (List<InternalTorrent>, PlatformInt64?) self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_list_internal_torrent(self.$1, serializer);
    sse_encode_opt_box_autoadd_i_64(self.$2, serializer);
  }

  @protected
  void sse_encode_record_string_string(
    (String, String) self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_String(self.$1, serializer);
    sse_encode_String(self.$2, serializer);
  }

  @protected
  void sse_encode_record_usize_string(
    (BigInt, String) self,
    SseSerializer serializer,
  ) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    sse_encode_usize(self.$1, serializer);
    sse_encode_String(self.$2, serializer);
  }

  @protected
  void sse_encode_u_8(int self, SseSerializer serializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    serializer.buffer.putUint8(self);
  }

  @protected
  void sse_encode_unit(void self, SseSerializer serializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
  }

  @protected
  void sse_encode_usize(BigInt self, SseSerializer serializer) {
    // Codec=Sse (Serialization based), see doc to use other codecs
    serializer.buffer.putBigUint64(self);
  }
}
