// Copyright (c) 2021, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.
// VMOptions=--verbose_debug

import 'package:test/test.dart';
import 'package:vm_service/vm_service.dart';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/set_breakpoint_state_test.dart
//
const LINE_A = 24;
const LINE_B = 25;
// AUTOGENERATED END

void testMain() {
  while (true) {
    print('a'); // LINE_A
    print('b'); // LINE_B
  }
}

late Breakpoint bpt;

final tests = <IsolateTest>[
  hasPausedAtStart,
  (VmService service, IsolateRef isolateRef) async {
    bpt = await service.addBreakpointWithScriptUri(
      isolateRef.id!,
      'set_breakpoint_state_test.dart',
      LINE_A,
    );
    expect(bpt.enabled, true);
  },
  setBreakpointAtLine(LINE_B),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_B),
  (VmService service, IsolateRef isolateRef) async {
    bpt = await service.setBreakpointState(
      isolateRef.id!,
      bpt.id!,
      false,
    );
    expect(bpt.enabled, false);
  },
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_B),
  (VmService service, IsolateRef isolateRef) async {
    bpt = await service.setBreakpointState(
      isolateRef.id!,
      bpt.id!,
      true,
    );
    expect(bpt.enabled, true);
  },
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'set_breakpoint_state_test.dart',
      pauseOnStart: true,
      testeeConcurrent: testMain,
    );
