/*
 * This is the source code of Telegram for Android v. 5.x.x.
 * It is licensed under GNU GPL v. 2 or later.
 * You should have received a copy of the license in this archive (see LICENSE).
 *
 * Copyright Nikolai Kudashov, 2013-2018.
 */

package org.telegram.ui;

import static org.telegram.messenger.AndroidUtilities.dp;
import static org.telegram.messenger.AndroidUtilities.lerp;
import static org.telegram.messenger.LocaleController.formatPluralStringComma;
import static org.telegram.messenger.LocaleController.formatString;
import static org.telegram.messenger.LocaleController.getString;
import static org.telegram.ui.bots.AffiliateProgramFragment.percents;

import android.Manifest;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.ClipData;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.SystemClock;
import android.os.Vibrator;
import android.provider.ContactsContract;
import android.provider.MediaStore;
import android.telephony.TelephonyManager;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.URLSpan;
import android.util.Log;
import android.util.Pair;
import android.util.Property;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.HapticFeedbackConstants;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.DecelerateInterpolator;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Space;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import androidx.core.graphics.ColorUtils;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.dynamicanimation.animation.FloatValueHolder;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import androidx.recyclerview.widget.ChatListItemAnimator;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManagerFixed;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScrollerCustom;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.google.android.exoplayer2.ui.AspectRatioFrameLayout;
import com.google.zxing.common.detector.MathUtils;

import org.telegram.PhoneFormat.PhoneFormat;
import org.telegram.messenger.AccountInstance;
import org.telegram.messenger.AndroidUtilities;
import org.telegram.messenger.ApplicationLoader;
import org.telegram.messenger.BotForumHelper;
import org.telegram.messenger.BotInlineKeyboard;
import org.telegram.messenger.BotWebViewVibrationEffect;
import org.telegram.messenger.BuildConfig;
import org.telegram.messenger.BuildVars;
import org.telegram.messenger.ChannelBoostsController;
import org.telegram.messenger.ChatMessageSharedResources;
import org.telegram.messenger.ChatMessagesMetadataController;
import org.telegram.messenger.ChatObject;
import org.telegram.messenger.ChatThemeController;
import org.telegram.messenger.CodeHighlighting;
import org.telegram.messenger.ContactsController;
import org.telegram.messenger.DialogObject;
import org.telegram.messenger.DocumentObject;
import org.telegram.messenger.DownloadController;
import org.telegram.messenger.Emoji;
import org.telegram.messenger.EmojiData;
import org.telegram.messenger.FactCheckController;
import org.telegram.messenger.FileLoader;
import org.telegram.messenger.FileLog;
import org.telegram.messenger.FlagSecureReason;
import org.telegram.messenger.HashtagSearchController;
import org.telegram.messenger.ImageLoader;
import org.telegram.messenger.ImageLocation;
import org.telegram.messenger.ImageReceiver;
import org.telegram.messenger.LiteMode;
import org.telegram.messenger.LocaleController;
import org.telegram.messenger.MediaController;
import org.telegram.messenger.MediaDataController;
import org.telegram.messenger.MessageObject;
import org.telegram.messenger.MessagePreviewParams;
import org.telegram.messenger.MessageSuggestionParams;
import org.telegram.messenger.MessagesController;
import org.telegram.messenger.MessagesStorage;
import org.telegram.messenger.NotificationCenter;
import org.telegram.messenger.NotificationsController;
import org.telegram.messenger.R;
import org.telegram.messenger.SecretChatHelper;
import org.telegram.messenger.SendMessagesHelper;
import org.telegram.messenger.SharedConfig;
import org.telegram.messenger.SvgHelper;
import org.telegram.messenger.Timer;
import org.telegram.messenger.TranslateController;
import org.telegram.messenger.UserConfig;
import org.telegram.messenger.UserObject;
import org.telegram.messenger.Utilities;
import org.telegram.messenger.VideoEditedInfo;
import org.telegram.messenger.browser.Browser;
import org.telegram.messenger.camera.CameraView;
import org.telegram.messenger.forkgram.ForkUtils;
import org.telegram.messenger.support.LongSparseIntArray;
import org.telegram.messenger.utils.OnPostDrawView;
import org.telegram.messenger.utils.PhotoUtilities;
import org.telegram.messenger.utils.RectFMergeBounding;
import org.telegram.messenger.utils.tlutils.TlUtils;
import org.telegram.messenger.voip.VoIPService;
import org.telegram.tgnet.ConnectionsManager;
import org.telegram.tgnet.TLObject;
import org.telegram.tgnet.TLRPC;
import org.telegram.tgnet.tl.TL_account;
import org.telegram.tgnet.tl.TL_bots;
import org.telegram.tgnet.tl.TL_phone;
import org.telegram.tgnet.tl.TL_stories;
import org.telegram.ui.ActionBar.ActionBar;
import org.telegram.ui.ActionBar.ActionBarLayout;
import org.telegram.ui.ActionBar.ActionBarMenu;
import org.telegram.ui.ActionBar.ActionBarMenuItem;
import org.telegram.ui.ActionBar.ActionBarMenuSubItem;
import org.telegram.ui.ActionBar.ActionBarPopupWindow;
import org.telegram.ui.ActionBar.AdjustPanLayoutHelper;
import org.telegram.ui.ActionBar.AlertDialog;
import org.telegram.ui.ActionBar.BackDrawable;
import org.telegram.ui.ActionBar.BaseFragment;
import org.telegram.ui.ActionBar.BottomSheet;
import org.telegram.ui.ActionBar.EmojiThemes;
import org.telegram.ui.ActionBar.INavigationLayout;
import org.telegram.ui.ActionBar.SimpleTextView;
import org.telegram.ui.ActionBar.Theme;
import org.telegram.ui.ActionBar.ThemeDescription;
import org.telegram.ui.ActionBar.theme.ThemeKey;
import org.telegram.ui.Adapters.FiltersView;
import org.telegram.ui.Adapters.MessagesSearchAdapter;
import org.telegram.ui.Business.BusinessBotButton;
import org.telegram.ui.Business.BusinessLinksActivity;
import org.telegram.ui.Business.BusinessLinksController;
import org.telegram.ui.Business.BusinessLinksEmptyView;
import org.telegram.ui.Business.QuickRepliesActivity;
import org.telegram.ui.Business.QuickRepliesController;
import org.telegram.ui.Business.QuickRepliesEmptyView;
import org.telegram.ui.Cells.BaseCell;
import org.telegram.ui.Cells.BotHelpCell;
import org.telegram.ui.Cells.BotSwitchCell;
import org.telegram.ui.Cells.ChatActionCell;
import org.telegram.ui.Cells.ChatLoadingCell;
import org.telegram.ui.Cells.ChatMessageCell;
import org.telegram.ui.Cells.ChatUnreadCell;
import org.telegram.ui.Cells.CheckBoxCell;
import org.telegram.ui.Cells.ContextLinkCell;
import org.telegram.ui.Cells.DialogCell;
import org.telegram.ui.Cells.MentionCell;
import org.telegram.ui.Cells.ProfileChannelCell;
import org.telegram.ui.Cells.ShareDialogCell;
import org.telegram.ui.Cells.StickerCell;
import org.telegram.ui.Cells.TextSelectionHelper;
import org.telegram.ui.Cells.UserInfoCell;
import org.telegram.ui.Components.*;
import org.telegram.ui.Components.FloatingDebug.FloatingDebugController;
import org.telegram.ui.Components.FloatingDebug.FloatingDebugProvider;
import org.telegram.ui.Components.Forum.ForumUtilities;
import org.telegram.ui.Components.Premium.GiftPremiumBottomSheet;
import org.telegram.ui.Components.Premium.LimitReachedBottomSheet;
import org.telegram.ui.Components.Premium.PremiumFeatureBottomSheet;
import org.telegram.ui.Components.Premium.PremiumPreviewBottomSheet;
import org.telegram.ui.Components.Premium.boosts.BoostDialogs;
import org.telegram.ui.Components.Premium.boosts.GiftInfoBottomSheet;
import org.telegram.ui.Components.Premium.boosts.PremiumPreviewGiftLinkBottomSheet;
import org.telegram.ui.Components.Reactions.ChatSelectionReactionMenuOverlay;
import org.telegram.ui.Components.Reactions.ReactionsEffectOverlay;
import org.telegram.ui.Components.Reactions.ReactionsLayoutInBubble;
import org.telegram.ui.Components.blur3.BlurredBackgroundDrawableViewFactory;
import org.telegram.ui.Components.blur3.BlurredBackgroundWithFadeDrawable;
import org.telegram.ui.Components.blur3.DownscaleScrollableNoiseSuppressor;
import org.telegram.ui.Components.blur3.drawable.color.BlurredBackgroundColorProviderThemed;
import org.telegram.ui.Components.blur3.source.BlurredBackgroundSourceWrapped;
import org.telegram.ui.Components.chat.ChatActivityBottomViewsVisibilityController;
import org.telegram.ui.Components.chat.layouts.ChatActivityActionsButtonsLayout;
import org.telegram.ui.Components.chat.layouts.ChatActivityChannelButtonsLayout;
import org.telegram.ui.Components.chat.ChatInputViewsContainer;
import org.telegram.ui.Components.chat.ChatListViewPaddingsAnimator;
import org.telegram.ui.Components.chat.ViewPositionWatcher;
import org.telegram.ui.Components.chat.WallpaperBitmapProvider;
import org.telegram.ui.Components.blur3.source.BlurredBackgroundSource;
import org.telegram.ui.Components.blur3.source.BlurredBackgroundSourceBitmap;
import org.telegram.ui.Components.blur3.source.BlurredBackgroundSourceRenderNode;
import org.telegram.ui.Components.blur3.drawable.BlurredBackgroundDrawable;
import org.telegram.ui.Components.chat.layouts.ChatActivitySideControlsButtonsLayout;
import org.telegram.ui.Components.inset.WindowInsetsStateHolder;
import org.telegram.ui.Components.quickforward.QuickShareSelectorOverlayLayout;
import org.telegram.ui.Components.spoilers.SpoilerEffect;
import org.telegram.ui.Components.voip.CellFlickerDrawable;
import org.telegram.ui.Components.voip.VoIPHelper;
import org.telegram.ui.Delegates.ChatActivityMemberRequestsDelegate;
import org.telegram.ui.Gifts.GiftSheet;
import org.telegram.ui.Stars.StarReactionsOverlay;
import org.telegram.ui.Stars.StarsController;
import org.telegram.ui.Stars.StarsIntroActivity;
import org.telegram.ui.Stars.StarsReactionsSheet;
import org.telegram.ui.Stars.MessageSuggestionOfferSheet;
import org.telegram.messenger.utils.tlutils.AmountUtils;
import org.telegram.ui.Stories.StoriesListPlaceProvider;
import org.telegram.ui.Stories.StoriesUtilities;
import org.telegram.ui.Stories.PublicStoriesList;
import org.telegram.ui.Stories.recorder.HintView2;
import org.telegram.ui.Stories.recorder.PreviewView;
import org.telegram.ui.Stories.recorder.StoryEntry;
import org.telegram.ui.Stories.recorder.StoryRecorder;
import org.telegram.ui.TON.TONIntroActivity;
import org.telegram.ui.bots.BotAdView;
import org.telegram.ui.bots.BotCommandsMenuContainer;
import org.telegram.ui.bots.BotCommandsMenuView;
import org.telegram.ui.bots.BotWebViewSheet;
import org.telegram.ui.bots.WebViewRequestProps;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import me.vkryl.android.animator.BoolAnimator;
import me.vkryl.android.animator.FactorAnimator;
import me.vkryl.core.BitwiseUtils;
import me.vkryl.core.reference.ReferenceList;

@SuppressWarnings("unchecked")
public class ChatActivity extends BaseFragment implements
        NotificationCenter.NotificationCenterDelegate,
        DialogsActivity.DialogsActivityDelegate,
        LocationActivity.LocationActivityDelegate,
        ChatAttachAlertDocumentLayout.DocumentSelectActivityDelegate,
        ChatActivityInterface,
        FloatingDebugProvider,
        InstantCameraView.Delegate,
        FactorAnimator.Target
{
    private final static boolean PULL_DOWN_BACK_FRAGMENT = false;
    private final static boolean DISABLE_PROGRESS_VIEW = true;
    private final static int SKELETON_DISAPPEAR_MS = 200;

    private static int SKELETON_LIGHT_OVERLAY_ALPHA = 22;
    private static float SKELETON_SATURATION = 1.4f;

    public final static int DEBUG_SHARE_ALERT_MODE_NORMAL = 0,
            DEBUG_SHARE_ALERT_MODE_LESS = 1,
            DEBUG_SHARE_ALERT_MODE_MORE = 2;

    private static boolean IS_ANONYMOUS_FORWARD = false;

    public int shareAlertDebugMode = DEBUG_SHARE_ALERT_MODE_NORMAL;
    public boolean shareAlertDebugTopicsSlowMotion;

    public boolean justCreatedTopic = false;
    public boolean justCreatedChat = false;
    protected TLRPC.Chat currentChat;
    protected TLRPC.User currentUser;
    protected TLRPC.EncryptedChat currentEncryptedChat;
    private boolean userBlocked;

    private long chatInviterId;

    private static final LongSparseArray<ArrayList<ChatMessageCell>> chatMessageCellsCache = new LongSparseArray<ArrayList<ChatMessageCell>>();

    private HashMap<MessageObject, Boolean> alreadyPlayedStickers = new HashMap<>();

    private final WindowInsetsStateHolder windowInsetsStateHolder = new WindowInsetsStateHolder(this::checkInsets);

    private BlurredBackgroundColorProviderThemed blurredBackgroundColorProvider;
    private BlurredBackgroundColorProviderThemed blurredBackgroundColorProviderWhite;

    private final ReferenceList<View> glassAttachedViews = new ReferenceList<>();
    private final @Nullable DownscaleScrollableNoiseSuppressor scrollableViewNoiseSuppressor;
    private final int recommendedAdditionalSizeY;

    private final @Nullable BlurredBackgroundSourceRenderNode glassBackgroundSourceRenderNode;
    private final @Nullable BlurredBackgroundSourceRenderNode glassBackgroundSourceFrostedRenderNode;
    private final @NonNull BlurredBackgroundDrawableViewFactory glassBackgroundDrawableFactory;
    private final @NonNull BlurredBackgroundDrawableViewFactory glassBackgroundDrawableFactoryFrosted;

    private final @Nullable BlurredBackgroundSourceRenderNode navbarContentSourceMessages;  // blurred messages list source
    private final @Nullable BlurredBackgroundDrawable navbarContentSourceMessagesDrawable;  // blurred messages list drawable
    private final @Nullable BlurredBackgroundSourceRenderNode navbarContentSourceWallpaperAndMessagesRenderNode;
    private final @NonNull BlurredBackgroundSourceWrapped navbarContentSourceWallpaper;
    private final @NonNull BlurredBackgroundDrawableViewFactory navbarContentDrawableFactory;

    private Dialog closeChatDialog;
    private boolean showCloseChatDialogLater;
    private FrameLayout progressView;
    private View progressView2;
    private FrameLayout bottomOverlay;
    private ChatInputViewsContainer chatInputViewsContainer;

    private FrameLayout chatInputBubbleContainer;
    private FrameLayout chatInputInAppContainer;
    private WallpaperBitmapProvider wallpaperBitmapProvider = new WallpaperBitmapProvider();

    protected ChatActivityEnterView chatActivityEnterView;
    private ChatActivityEnterTopView chatActivityEnterTopView;
    private int chatActivityEnterViewAnimateFromTop;
    private boolean chatActivityEnterViewAnimateBeforeSending;
    private ActionBarMenuItem.Item timeItem2;
    private ActionBarMenu.LazyItem attachItem;
    private ActionBarMenuItem.Item savedChatsItem, savedChatsGap;;
    private ActionBarMenuItem headerItem;
    private ActionBarMenu.LazyItem editTextItem;
    protected ActionBarMenuItem searchItem;
    private ActionBarMenuItem.Item translateItem;
    private ActionBarMenuItem searchIconItem;
    private ActionBarMenu.LazyItem audioCallIconItem;
    private boolean searchItemVisible;
    private RadialProgressView progressBar;
    private ActionBarMenuItem.Item addContactItem;
    private ActionBarMenuItem.Item clearHistoryItem;
    private ActionBarMenuItem.Item viewAsTopics;
    private ActionBarMenuItem.Item closeTopicItem;
    private ActionBarMenuItem.Item openForumItem;
    private ClippingImageView animatingImageView;
    private ThanosEffect chatListThanosEffect;
    private ChatListViewPaddingsAnimator chatListViewPaddingsAnimator;
    private ChatListRecyclerView chatListView;
    private ChatListItemAnimator chatListItemAnimator;
    private GridLayoutManagerFixed chatLayoutManager;
    private ChatActivityAdapter chatAdapter;
    private UnreadCounterTextView bottomOverlayChatText;
    private boolean bottomOverlayLinks;
    private LinkSpanDrawable.LinksTextView bottomOverlayLinksText;
    private TextView bottomOverlayText;
    private TextView bottomOverlayStartButton;
    private RadialProgressView bottomOverlayProgress;
    private AnimatorSet bottomOverlayAnimation;
    private boolean bottomOverlayChatWaitsReply;
    private HintView2 bottomGiftHintView;
    private HintView2 bottomSuggestHintView;

    private ChatActivityChannelButtonsLayout bottomChannelButtonsLayout;
    private ChatActivityActionsButtonsLayout actionsButtonsLayout;

    @Nullable
    private FrameLayout emptyViewContainer;
    private LinearLayout emptyViewContent;
    private ChatGreetingsView greetingsViewContainer;
    private ChatActionCell greetingsInfo;
    private QuickRepliesEmptyView quickRepliesEmptyView;
    private BusinessLinksEmptyView businessLinksEmptyView;
    public ChatActivityFragmentView contentView;
    private ChatBigEmptyView bigEmptyView;
    private ArrayList<View> actionModeViews = new ArrayList<>();
    public ChatAvatarContainer avatarContainer;
    private NumberTextView selectedMessagesCountTextView;
    private RecyclerListView.OnItemClickListener mentionsOnItemClickListener;
    private SuggestEmojiView suggestEmojiPanel;
    private ActionBarMenuItem.Item muteItem;
    private ActionBarMenuItem.Item muteItemGap;
    private ActionBarMenuItem.Item feeItemGap;
    private ActionBarMenuItem.Item feeItemText;
    private ChatNotificationsPopupWrapper chatNotificationsPopupWrapper;
    private ChatActivitySideControlsButtonsLayout sideControlsButtonsLayout;
    private boolean pagedownButtonShowedByScroll;
    private ActionBarMenuSubItem hideTitleItem;
    private int reactionsMentionCount;
    public Bulletin messageSeenPrivacyBulletin;
    TextView webBotTitle;
    public SearchTagsList actionBarSearchTags;
    public ChatSearchTabs hashtagSearchTabs;
    private ViewPagerFixed searchViewPager;
    private int defaultSearchPage;
    private boolean requestClearSearchPages;
    private HashtagHistoryView hashtagHistoryView;
    private AlertDialog scheduleNowDialog;

    private HintView2 savedMessagesHint;
	private HintView2 savedMessagesSearchHint;
    private HintView2 savedMessagesTagHint;
    private HintView2 groupEmojiPackHint;
    private HintView2 botMessageHint;
    private HintView2 factCheckHint;
    private HintView2 videoConversionTimeHint;
    private float videoConversionTimeHintY;

    private TL_stories.TL_premium_boostsStatus boostsStatus;
    private ChannelBoostsController.CanApplyBoost canApplyBoosts;

    private BackupImageView replyImageView;
    private SimpleTextView replyNameTextView;
    private SimpleTextView replyObjectTextView;
    private SimpleTextView replyObjectHintTextView;
    private boolean showTapForForwardingOptionsHit;
    private Runnable tapForForwardingOptionsHitRunnable;
    private ImageView replyIconImageView;
    private ImageView replyCloseImageView;
    private MentionsContainerView mentionContainer;
    private AnimatorSet mentionListAnimation;
    public ChatAttachAlert chatAttachAlert;
    @Nullable
    private BlurredFrameLayout topChatPanelView;
    @Nullable
    private BlurredFrameLayout topChatPanelView2;
    private AnimatorSet reportSpamViewAnimator;
    private AnimatorSet topChatPanelView2Animator;
    @Nullable
    private TextView addToContactsButton;
    private boolean addToContactsButtonArchive;
    @Nullable
    private TextView reportSpamButton;
    @Nullable
    private TextView restartTopicButton;
    @Nullable
    private TranslateButton translateButton;
    public TopicsTabsView topicsTabs;
    @Nullable
    private BusinessBotButton bizBotButton;
    @Nullable
    private View topViewSeparator1, topViewSeparator2, topViewSeparator3;
    @Nullable
    private LinkSpanDrawable.LinksTextView emojiStatusSpamHint;
    @Nullable
    private ImageView closeReportSpam;
    private BotAdView botAdView;
    private TextView chatWithAdminTextView;
    private FragmentContextView fragmentContextView;
    private FragmentContextView fragmentLocationContextView;
    private TextView emptyView;
    private FlickerLoadingView hashtagLoadingView;
    private StickerEmptyView hashtagSearchEmptyView;
    private HintView gifHintTextView;
    private HintView emojiHintTextView;
    private HintView mediaBanTooltip;
    private HintView scheduledOrNoSoundHint;
    private boolean scheduledOrNoSoundHintShown;
    private HintView scheduledHint;
    private boolean scheduledHintShown;
    private boolean searchAsListHintShown;
    private HintView fwdRestrictedTopHint;
    private HintView fwdRestrictedBottomHint;
    private HintView slowModeHint;
    private HintView pollHintView;
    private HintView timerHintView;
    private ChatMessageCell pollHintCell;
    private int pollHintX;
    private int pollHintY;
    private HintView voiceHintTextView;
    private HintView noSoundHintView;
    private HintView forwardHintView;
    private ChecksHintView checksHintView;
    private View emojiButtonRed;
    private BlurredFrameLayout pinnedMessageView;
    private BluredView blurredView;
    private PinnedLineView pinnedLineView;
    private boolean setPinnedTextTranslationX;
    private AnimatorSet pinnedMessageViewAnimator;
    private BackupImageView[] pinnedMessageImageView = new BackupImageView[2];
    private TrackingWidthSimpleTextView[] pinnedNameTextView = new TrackingWidthSimpleTextView[2];
    private SimpleTextView[] pinnedMessageTextView = new SimpleTextView[2];
    private PinnedMessageButton[] pinnedMessageButton = new PinnedMessageButton[2];
    private NumberTextView pinnedCounterTextView;
    private int pinnedCounterTextViewX;
    private AnimatorSet[] pinnedNextAnimation = new AnimatorSet[2];
    private boolean pinnedMessageButtonShown = false;
    private ImageView closePinned;
    private RadialProgressView pinnedProgress;
    private ImageView pinnedListButton;
    private AnimatorSet pinnedListAnimator;
    @Nullable
    private FrameLayout alertView;
    private Runnable hideAlertViewRunnable;
    private TextView alertNameTextView;
    private TextView alertTextView;
    private AnimatorSet alertViewAnimator;
    private final int searchContainerHeight = 44;
    private FrameLayout searchContainer;
    private ImageView searchCalendarButton;
    private ImageView searchUserButton;
    private AnimatedTextView searchCountText;
    private AnimatedTextView searchExpandList;
    private AnimatedTextView searchOtherButton;
    private ChatActionCell floatingDateView;
    private TopicSeparator.Cell floatingTopicSeparator;
    private float intoTopViewTop;
    private ChatActionCell infoTopView;
    private int hideDateDelay = 500;
    public InstantCameraView instantCameraView;
    private View overlayView;
    private boolean currentFloatingDateOnScreen;
    private boolean currentFloatingTopicOnScreen;
    private boolean currentFloatingTopIsNotMessage;
    private AnimatorSet floatingDateAnimation;
    private ValueAnimator floatingTopicAnimation;
    private float floatingTopicViewAlpha;
    private boolean scrollingFloatingDate;
    private boolean scrollingFloatingTopic;
    private boolean scrollingChatListView;
    private boolean checkTextureViewPosition;
    private boolean searchingForUser;
    private TLRPC.User searchingUserMessages;
    private TLRPC.Chat searchingChatMessages;
    public static boolean scrolling;
    public ReactionsLayoutInBubble.VisibleReaction searchingReaction;
    public ReactionsLayoutInBubble.VisibleReaction getFilterTag() {
        return chatAdapter != null && chatAdapter.isFiltered ? searchingReaction : null;
    }
    public String getFilterQuery() {
        return chatAdapter != null && chatAdapter.isFiltered ? searchingQuery : null;
    }
    public boolean isFiltered() {
        return chatAdapter != null && chatAdapter.isFiltered;
    }
    public ArrayList<MessageObject> getFilteredMessages() {
        return chatAdapter != null ? chatAdapter.filteredMessages : null;
    }
    private boolean searchingFiltered;
    private boolean searching;
    private String searchingQuery;
    private String searchingHashtag;
    private int hashtagSearchSelectedIndex;
    private int searchLastCount;
    private int searchLastIndex;
    private UndoView undoView;
    private UndoView topUndoView;
    private Bulletin pinBulletin;
    private boolean showPinBulletin;
    private int pinBullerinTag;
    protected boolean openKeyboardOnAttachMenuClose;
    private FlagSecureReason flagSecure;
    public boolean isFullyVisible;

    private MessageObject hintMessageObject;
    private int hintMessageType;
    private MessageObject hint2MessageObject;

    private FrameLayout messagesSearchListContainer;
    public RecyclerListView messagesSearchListView;
    private MessagesSearchAdapter messagesSearchAdapter;
    private AnimatorSet messagesSearchListViewAnimation;

    public static final int MODE_DEFAULT = 0;
    public static final int MODE_SCHEDULED = 1;
    public static final int MODE_PINNED = 2;
    public static final int MODE_SAVED = 3;
    public static final int MODE_QUICK_REPLIES = 5;
    public static final int MODE_EDIT_BUSINESS_LINK = 6;
    public static final int MODE_SEARCH = 7;
    public static final int MODE_SUGGESTIONS = 8;

    public static final int SEARCH_THIS_CHAT = 0;
    public static final int SEARCH_MY_MESSAGES = 1;
    public static final int SEARCH_PUBLIC_POSTS = 2;
    public static final int SEARCH_CHANNEL_POSTS = 3;
    private int searchType;

    public TL_account.TL_businessChatLink businessLink = null;

    public String quickReplyShortcut;
    private int chatMode;
    private int scheduledMessagesCount = -1;
    public boolean isSubscriberSuggestions;

    private String reportTitle;
    private byte[] reportOption;
    private String reportMessage;
    public boolean isReport() {
        return !TextUtils.isEmpty(reportTitle);
    }

    @Nullable
    private MessageObject threadMessageObject;
    private MessageObject topicStarterMessageObject;
    private boolean threadMessageVisible = true;
    private ArrayList<MessageObject> threadMessageObjects;
    private MessageObject replyMessageHeaderObject;
    private TLRPC.TL_forumTopic forumTopic;
    private long threadMessageId;
    private int replyOriginalMessageId;
    public TLRPC.Chat replyOriginalChat;
    public boolean isComments;
    public boolean isTopic;
    private boolean threadMessageAdded;
    private boolean scrollToThreadMessage;
    private int threadMaxInboxReadId;
    private int threadMaxOutboxReadId;
    private int replyMaxReadId;
    private Runnable delayedReadRunnable;
    private final SparseArray<MessageObject> pendingSendMessagesDict = new SparseArray<>();
    private final ArrayList<MessageObject> pendingSendMessages = new ArrayList<>();
    private int threadUnreadMessagesCount;
    private boolean convertingToast, convertingToastShown;
    private int convertingToastMessageId;

    public ArrayList<MessageObject> animatingMessageObjects = new ArrayList<>();
    private final HashMap<TLRPC.Document, Integer> animatingDocuments = new HashMap<>();
    private MessageObject needAnimateToMessage;

    private int scrollToPositionOnRecreate = -1;
    private int scrollToOffsetOnRecreate = 0;

    private final ArrayList<MessageObject> pollsToCheck = new ArrayList<>(10);

    private int editTextStart;
    private int editTextEnd;

    private Runnable checkPaddingsRunnable;

    private boolean wasManualScroll;
    private boolean fixPaddingsInLayout;
    private boolean globalIgnoreLayout;

    private int topViewWasVisible;

    private ArrayList<Integer> pinnedMessageIds = new ArrayList<>();
    private int maxPinnedMessageId;
    private HashMap<Integer, MessageObject> pinnedMessageObjects = new HashMap<>();
    private SparseArray<Boolean> loadingPinnedMessages = new SparseArray<>();
    private int currentPinnedMessageId;
    private int[] currentPinnedMessageIndex = new int[1];
    private int forceNextPinnedMessageId;
    private boolean forceScrollToFirst;
    private int loadedPinnedMessagesCount;
    private int totalPinnedMessagesCount;
    public boolean loadingPinnedMessagesList;
    private boolean pinnedEndReached;

    public void reloadPinnedMessages() {
        pinnedMessageIds.clear();
        pinnedMessageObjects.clear();
        currentPinnedMessageId = 0;
        loadedPinnedMessagesCount = 0;
        totalPinnedMessagesCount = 0;
        updatePinnedMessageView(true);
        getMediaDataController().loadPinnedMessages(getDialogId(), 0, chatInfo == null ? 0 : chatInfo.pinned_msg_id);
        loadingPinnedMessagesList = true;
        updatePinnedTopicStarterMessage();
    }

    private AnimatorSet editButtonAnimation;
    private AnimatorSet forwardButtonAnimation;

    SparseIntArray dateObjectsStableIds = new SparseIntArray();
    SparseIntArray conversionObjectsStableIds = new SparseIntArray();
    public static int lastStableId = 10;

    private boolean openSearchKeyboard;

    private boolean waitingForReplyMessageLoad;

    private boolean ignoreAttachOnPause;

    private boolean allowStickersPanel = true;
    private boolean allowContextBotPanel;
    private boolean allowContextBotPanelSecond = true;
    private AnimatorSet runningAnimation;
    private int runningAnimationIndex = -1;

    private MessageObject selectedObjectToEditCaption;
    private MessageObject selectedObject;
    private MessageObject.GroupedMessages selectedObjectGroup;
    private boolean forbidForwardingWithDismiss;
    public MessagePreviewParams messagePreviewParams;
    public MessageSuggestionParams messageSuggestionParams;
    private CharSequence formwardingNameText;
    private MessageObject forwardingMessage;
    private MessageObject.GroupedMessages forwardingMessageGroup;
    private MessageObject.GroupedMessages replyingQuoteGroup;
    public MessageObject replyingTopMessage;
    private ReplyQuote replyingQuote;
    private boolean ignoreDraft;
    private MessageObject replyingMessageObject;
    private int editingMessageObjectReqId;
    public MessageObject editingMessageObject;
    private boolean paused = true;
    private boolean pausedOnLastMessage;
    private boolean wasPaused;
    boolean firstOpen = true;
    private int replyImageSize;
    private int replyImageCacheType;
    private TLRPC.PhotoSize replyImageLocation;
    private TLRPC.PhotoSize replyImageThumbLocation;
    private TLObject replyImageLocationObject;
    private boolean replyImageHasMediaSpoiler;
    private int pinnedImageSize;
    private int pinnedImageCacheType;
    private boolean pinnedImageHasBlur;
    private TLRPC.PhotoSize pinnedImageLocation;
    private TLRPC.PhotoSize pinnedImageThumbLocation;
    private TLObject pinnedImageLocationObject;
    private int linkSearchRequestId;
    public TLRPC.WebPage foundWebPage;
    private ArrayList<CharSequence> foundUrls;
    private String pendingLinkSearchString;
    private Runnable pendingWebPageTimeoutRunnable;
    private Runnable waitingForCharaterEnterRunnable;
    private Runnable onChatMessagesLoaded;

    private TLRPC.ChatInvite chatInvite;
    private Runnable chatInviteRunnable;

    private LongSparseIntArray clearingHistoryArr = new LongSparseIntArray();
    boolean isClearingHistory() {
        return clearingHistoryArr.get(getThreadId(), 0) != 0;
    }

    void setClearingHistory(long threadId, boolean isClearingHistory) {
        clearingHistoryArr.put(threadId, isClearingHistory ? 1 : 0);
    }

    public boolean openAnimationEnded;
    public boolean fragmentOpened;
    private long openAnimationStartTime;

    private boolean scrollToTopOnResume;
    private boolean forceScrollToTop;
    private boolean scrollToTopUnReadOnResume;
    private long dialog_id;
    private Long dialog_id_Long;
    private int lastLoadIndex = 1;
    private SparseArrayWithTouch<MessageObject>[] selectedMessagesIds = new SparseArrayWithTouch[]{
        new SparseArrayWithTouch<MessageObject>(),
        new SparseArrayWithTouch<MessageObject>()};
    private SparseArray<MessageObject>[] selectedMessagesCanCopyIds = new SparseArray[]{new SparseArray<>(), new SparseArray<>()};
    private SparseArray<MessageObject>[] selectedMessagesCanStarIds = new SparseArray[]{new SparseArray<>(), new SparseArray<>()};
    private boolean hasUnfavedSelected;
    private int cantDeleteMessagesCount;
    private int cantForwardMessagesCount;
    private int canForwardMessagesCount;
    private int canEditMessagesCount;
    private int cantSaveMessagesCount;
    private int canSaveMusicCount;
    private int canSaveDocumentsCount;
    private ArrayList<Integer> waitingForLoad = new ArrayList<>();
    private boolean needRemovePreviousSameChatActivity = true;

    private int newUnreadMessageCount;
    private int prevSetUnreadCount = Integer.MIN_VALUE;
    private int newMentionsCount;
    private boolean hasAllMentionsLocal;

    private ArrayList<ChatMessageCell> animateSendingViews = new ArrayList<>();

    private SparseArray<MessageObject>[] messagesDict = new SparseArray[]{new SparseArray<>(), new SparseArray<>()};
    private SparseArray<MessageObject> repliesMessagesDict = new SparseArray<>();
    private SparseArray<ArrayList<Integer>> replyMessageOwners = new SparseArray<>();
    private HashMap<String, ArrayList<MessageObject>> messagesByDays = new HashMap<>();
    private SparseArray<ArrayList<MessageObject>> messagesByDaysSorted = new SparseArray<>();
    private LongSparseArray<MessageObject> conversionMessages = new LongSparseArray<>();
    public ArrayList<MessageObject> messages = new ArrayList<>();
    private SparseArray<MessageObject> waitingForReplies = new SparseArray<>();
    private LongSparseArray<ArrayList<MessageObject>> polls = new LongSparseArray<>();
    private LongSparseArray<MessageObject.GroupedMessages> groupedMessagesMap = new LongSparseArray<>();
    private int[] maxMessageId = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
    private int[] minMessageId = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
    private int[] maxDate = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
    private int[] minDate = new int[2];
    private boolean[] endReached = new boolean[2];
    private boolean[] cacheEndReached = new boolean[2];
    private boolean[] forwardEndReached = new boolean[]{true, true};
    private boolean hideForwardEndReached;
    private boolean loading = true;
    private boolean firstLoading = true;
    private boolean chatWasReset;
    private boolean firstUnreadSent;
    private int loadsCount;
    private int last_message_id = 0;
    private long mergeDialogId;
    private boolean sentBotStart;

    private long startMessageAppearTransitionMs;
    private List<MessageSkeleton> messageSkeletons = new ArrayList<>();
    private int lastSkeletonCount;
    private int lastSkeletonMessageCount;
    private Paint skeletonPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
    private Paint skeletonServicePaint = new Paint(Paint.ANTI_ALIAS_FLAG);
    private ColorMatrix skeletonColorMatrix = new ColorMatrix();
    private Theme.MessageDrawable.PathDrawParams skeletonBackgroundCacheParams = new Theme.MessageDrawable.PathDrawParams();
    private Theme.MessageDrawable skeletonBackgroundDrawable = new Theme.MessageDrawable(Theme.MessageDrawable.TYPE_TEXT, false, false, new Theme.ResourcesProvider() {
        @Override
        public int getColor(int key) {
            return getThemedColor(key);
        }
    });
    private long skeletonLastUpdateTime;
    private int skeletonGradientWidth;
    private int skeletonTotalTranslation;
    private Matrix skeletonMatrix = new Matrix();
    private LinearGradient skeletonGradient;
    private int skeletonColor0;
    private int skeletonColor1;

    private Paint skeletonOutlinePaint = new Paint(Paint.ANTI_ALIAS_FLAG);
    private Matrix skeletonOutlineMatrix = new Matrix();
    private LinearGradient skeletonOutlineGradient;
    public boolean forceDisallowApplyWallpeper;
    public boolean forceDisallowRedrawThemeDescriptions;
    private boolean waitingForGetDifference;
    private int initialMessagesSize;
    private boolean loadInfo;
    private boolean historyPreloaded;
    private int migrated_to;
    private boolean firstMessagesLoaded;
    private boolean clearOnLoad;
    private boolean clearOnLoadButIsNewTopic;
    private int clearOnLoadAndScrollMessageId = -1, clearOnLoadAndScrollOffset;
    private boolean topicChangedFromMessage;
    private Runnable closeInstantCameraAnimation;

    {
        skeletonOutlinePaint.setStyle(Paint.Style.STROKE);
        skeletonOutlinePaint.setStrokeWidth(AndroidUtilities.dp(1));
    }

    private String textToSet;
    private boolean premiumInvoiceBot;
    private boolean showScrollToMessageError;
    private int startLoadFromMessageId;
    private int startReplyTo;
    private int startLoadFromDate;
    private int startLoadFromMessageIdSaved;
    private int startLoadFromMessageOffset = Integer.MAX_VALUE;
    private int startFromVideoTimestamp = -1;
    private int startFromVideoMessageId;
    private boolean needSelectFromMessageId;
    private int returnToMessageId;
    private int returnToLoadIndex;
    private int createUnreadMessageAfterId;
    private boolean createUnreadMessageAfterIdLoading;
    private boolean loadingFromOldPosition;
    private float alertViewEnterProgress;

    private boolean first = true;
    private int first_unread_id;
    private boolean loadingForward;
    private MessageObject unreadMessageObject;
    private MessageObject scrollToMessage;
    public int highlightMessageId = Integer.MAX_VALUE;
    public boolean showNoQuoteAlert;
    public boolean highlightMessageQuoteFirst;
    private long highlightMessageQuoteFirstTime;
    public String highlightMessageQuote;
    public Integer highlightTaskId;
    public int highlightMessageQuoteOffset = -1;
    private int scrollToMessagePosition = -10000;
    private Runnable unselectRunnable;

    private String currentPicturePath;

    private ChatObject.Call groupCall;
    private boolean lastCallCheckFromServer;
    private boolean createGroupCall;
    protected TLRPC.ChatFull chatInfo;
    protected TLRPC.UserFull userInfo;

    public ProfileChannelCell.ChannelMessageFetcher profileChannelMessageFetcher;
    public ProfileBirthdayEffect.BirthdayEffectFetcher birthdayAssetsFetcher;

    private LongSparseArray<TL_bots.BotInfo> botInfo = new LongSparseArray<>();
    private String botUser;
    private long inlineReturn;
    private String voiceChatHash;
    private boolean openVideoChat;
    private boolean livestream;
    private String attachMenuBotToOpen;
    private String attachMenuBotStartCommand;
    private MessageObject botButtons;
    private MessageObject botReplyButtons;
    private int botsCount;
    private boolean hasBotsCommands;
    private boolean hasQuickReplies;
    private boolean hasBotWebView;
    private long chatEnterTime;
    private long chatLeaveTime;

    private boolean locationAlertShown;

    private String startVideoEdit;

    private FrameLayout videoPlayerContainer;
    private ChatMessageCell drawLaterRoundProgressCell;
    private AspectRatioFrameLayout aspectRatioFrameLayout;
    private TextureView videoTextureView;
    private boolean scrollToVideo;
    private Path aspectPath;
    private Paint aspectPaint;
    private Runnable destroyTextureViewRunnable = () -> {
        destroyTextureView();
    };

    private Bitmap scrimBlurBitmap;
    private BitmapShader scrimBlurBitmapShader;
    private Paint scrimBlurBitmapPaint;
    private Matrix scrimBlurMatrix;

    private Paint scrimPaint;
    private Paint actionBarBackgroundPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
    private float scrimPaintAlpha = 0f;
    private boolean scrimProgressDirection;
    private View scrimView;
    private float scrimViewAlpha = 1f;
    private float scrimViewProgress = 0f;
    private Integer scrimViewReaction;
    private Integer scrimViewTask;
    private int scrimViewReactionOffset;
    private boolean scrimViewReactionAnimated;
    private int popupAnimationIndex = -1;
    private AnimatorSet scrimAnimatorSet;
    public ActionBarPopupWindow scrimPopupWindow;
    private boolean scrimPopupWindowHideDimOnDismiss = true;
    private int scrimPopupX, scrimPopupY;
    private ActionBarMenuSubItem[] scrimPopupWindowItems;
    private ActionBarMenuSubItem menuDeleteItem;
    private final Runnable updateDeleteItemRunnable = new Runnable() {
        @Override
        public void run() {
            if (selectedObject == null || menuDeleteItem == null) {
                return;
            }
            int remaining = Math.max(0, selectedObject.messageOwner.ttl_period - (getConnectionsManager().getCurrentTime() - selectedObject.messageOwner.date));
            String remainingStr;
            if (remaining < 24 * 60 * 60) {
                remainingStr = AndroidUtilities.formatDuration(remaining, false, true);
            } else {
                remainingStr = LocaleController.formatPluralString("Days", Math.round(remaining / (24 * 60 * 60.0f)));
            }
            menuDeleteItem.setSubtext(LocaleController.formatString(R.string.AutoDeleteIn, remainingStr));
            AndroidUtilities.runOnUIThread(updateDeleteItemRunnable, 1000);
        }
    };

    private ChatActivityDelegate chatActivityDelegate;
    private RecyclerAnimationScrollHelper chatScrollHelper;

    private int postponedScrollMinMessageId;
    private int postponedScrollToLastMessageQueryIndex;
    private int postponedScrollMessageId;
    private boolean fakePostponedScroll;
    private boolean postponedScrollIsCanceled;
    private static ArrayList<ChatActivityTextSelectionHelper> textSelectionHelpersCache;
    private ChatActivityTextSelectionHelper textSelectionHelper;
    private ChatMessageCell slidingView;
    private boolean maybeStartTrackingSlidingView;
    private boolean startedTrackingSlidingView;

    private boolean canShowPagedownButton;
    private TextSelectionHint textSelectionHint;
    private boolean textSelectionHintWasShowed;
    private float lastTouchY;
    ContentPreviewViewer.ContentPreviewViewerDelegate contentPreviewViewerDelegate;

    private ChatMessageCell dummyMessageCell;
    protected FireworksOverlay fireworksOverlay;

    private boolean swipeBackEnabled = true;

    public static Pattern publicMsgUrlPattern;
    public static Pattern voiceChatUrlPattern;
    public static Pattern privateMsgUrlPattern;
    private boolean waitingForSendingMessageLoad;
    private ValueAnimator changeBoundAnimator;
    private Animator messageEditTextAnimator;

    private boolean openImport;

    public float chatListViewPaddingTop;
    public float paddingTopHeight;
    public int chatListViewPaddingVisibleOffset;

    private int contentPaddingTop;
    private float contentPanTranslation;
    private float contentPanTranslationT;
    private float floatingDateViewOffset;
    private float floatingTopicViewOffset;
    private float topChatPanelViewOffset;
    private float topChatPanelView2Offset;
    private float pinnedMessageEnterOffset;
    private float topViewOffset;
    private TLRPC.Document preloadedGreetingsSticker;
    private boolean forceHistoryEmpty;
    private boolean invalidateChatListViewTopPadding;
    private long activityResumeTime;

    private int transitionAnimationIndex;
    private int transitionAnimationGlobalIndex;
    private int scrollAnimationIndex;
    private int scrollCallbackAnimationIndex;

    public boolean allowExpandPreviewByClick;
    private boolean showSearchAsIcon;
    private boolean showAudioCallAsIcon;
    public MessageEnterTransitionContainer messageEnterTransitionContainer;
    private float pullingDownOffset, pullingBottomOffset;
    private ChatPullingDownDrawable pullingDownDrawable;
    private Animator pullingDownBackAnimator;
    private boolean fromPullingDownTransition;
    private boolean toPullingDownTransition;
    private ChatActivity pullingDownAnimateToActivity;
    private float pullingDownAnimateProgress;
    private AnimatorSet fragmentTransition;
    private ChatActivity backToPreviousFragment;
    private Runnable fragmentTransitionRunnable = new Runnable() {
        @Override
        public void run() {
            if (fragmentTransition != null && !fragmentTransition.isRunning()) {
                fragmentTransition.start();
            }
        }
    };

    private QuickShareSelectorOverlayLayout quickShareSelectorOverlay;
    private ChatSelectionReactionMenuOverlay selectionReactionsOverlay;
    private SecretVoicePlayer secretVoicePlayer;

    private boolean isPauseOnThemePreview;
    private ChatThemeBottomSheet chatThemeBottomSheet;
    private ThemeDelegate parentThemeDelegate;
    private ChatActivity parentChatActivity;
    public ThemeDelegate themeDelegate;
    private ChatActivityMemberRequestsDelegate pendingRequestsDelegate;
    private final ChatMessagesMetadataController chatMessagesMetadataController = new ChatMessagesMetadataController(this);
    private TLRPC.TL_channels_sendAsPeers sendAsPeersObj;

    private TL_account.resolvedBusinessChatLinks resolvedChatLink;

    private boolean switchFromTopics;
    private boolean switchingFromTopics;
    private float switchingFromTopicsProgress;

    public final static int OPTION_RETRY = 0;
    public final static int OPTION_DELETE = 1;
    public final static int OPTION_FORWARD = 2;
    public final static int OPTION_COPY = 3;
    public final static int OPTION_SAVE_TO_GALLERY = 4;
    public final static int OPTION_APPLY_LOCALIZATION_OR_THEME = 5;
    public final static int OPTION_SHARE = 6;
    public final static int OPTION_SAVE_TO_GALLERY2 = 7;
    public final static int OPTION_REPLY = 8;
    public final static int OPTION_ADD_TO_STICKERS_OR_MASKS = 9;
    public final static int OPTION_SAVE_TO_DOWNLOADS_OR_MUSIC = 10;
    public final static int OPTION_ADD_TO_GIFS = 11;
    public final static int OPTION_EDIT = 12;
    public final static int OPTION_PIN = 13;
    public final static int OPTION_UNPIN = 14;
    public final static int OPTION_ADD_CONTACT = 15;
    public final static int OPTION_COPY_PHONE_NUMBER = 16;
    public final static int OPTION_CALL = 17;
    public final static int OPTION_CALL_AGAIN = 18;
    public final static int OPTION_RATE_CALL = 19;
    public final static int OPTION_ADD_STICKER_TO_FAVORITES = 20;
    public final static int OPTION_DELETE_STICKER_FROM_FAVORITES = 21;
    public final static int OPTION_COPY_LINK = 22;
    public final static int OPTION_REPORT_CHAT = 23;
    public final static int OPTION_CANCEL_SENDING = 24;
    public final static int OPTION_UNVOTE = 25;
    public final static int OPTION_STOP_POLL_OR_QUIZ = 26;
    public final static int OPTION_VIEW_REPLIES_OR_THREAD = 27;
    public final static int OPTION_STATISTICS = 28;
    public final static int OPTION_TRANSLATE = 29;
    public final static int OPTION_TRANSCRIBE = 30;
    public final static int OPTION_HIDE_SPONSORED_MESSAGE = 31;
    public final static int OPTION_VIEW_IN_TOPIC = 32;
    public final static int OPTION_ABOUT_REVENUE_SHARING_ADS = 33;
    public final static int OPTION_REPORT_AD = 34;
    public final static int OPTION_REMOVE_ADS = 35;
    public final static int OPTION_SEND_NOW = 100;
    public final static int OPTION_EDIT_SCHEDULE_TIME = 102;
    public final static int OPTION_SPEED_PROMO = 103;
    public final static int OPTION_OPEN_PROFILE = 104;
    public final static int OPTION_FACT_CHECK = 106;
    public final static int OPTION_EDIT_PRICE = 107;
    public final static int OPTION_GIFT = 108;
    public final static int OPTION_EDIT_TODO = 109;
    public final static int OPTION_ADD_TO_TODO = 110;

    public final static int OPTION_SUGGESTION_EDIT_PRICE = 111;
    public final static int OPTION_SUGGESTION_EDIT_TIME = 112;
    public final static int OPTION_SUGGESTION_EDIT_MESSAGE = 113;
    public final static int OPTION_SUGGESTION_ADD_OFFER = 114;

    private final static int[] allowedNotificationsDuringChatListAnimations = new int[]{
            NotificationCenter.messagesRead,
            NotificationCenter.threadMessagesRead,
            NotificationCenter.monoForumMessagesRead,
            NotificationCenter.commentsRead,
            NotificationCenter.messagesReadEncrypted,
            NotificationCenter.messagesReadContent,
            NotificationCenter.didLoadPinnedMessages,
            NotificationCenter.newDraftReceived,
            NotificationCenter.updateMentionsCount,
            NotificationCenter.didUpdateConnectionState,
            //NotificationCenter.updateInterfaces,
            NotificationCenter.updateDefaultSendAsPeer,
            NotificationCenter.closeChats,
            NotificationCenter.chatInfoCantLoad,
            NotificationCenter.userInfoDidLoad,
            NotificationCenter.pinnedInfoDidLoad,
            NotificationCenter.didSetNewWallpapper,
            NotificationCenter.savedMessagesDialogsUpdate,
            NotificationCenter.didApplyNewTheme,
            NotificationCenter.messageReceivedByServer2
    };

    private final DialogInterface.OnCancelListener postponedScrollCancelListener = dialog -> {
        postponedScrollIsCanceled = true;
        postponedScrollMessageId = 0;
        nextScrollToMessageId = 0;
        forceNextPinnedMessageId = 0;
        invalidateMessagesVisiblePart();
        showPinnedProgress(false);
    };

    private NotificationCenter.PostponeNotificationCallback postponeNotificationsWhileLoadingCallback = new NotificationCenter.PostponeNotificationCallback() {
        @Override
        public boolean needPostpone(int id, int currentAccount, Object[] args) {
            if (id == NotificationCenter.didReceiveNewMessages) {
                long did = (Long) args[0];
                if (firstLoading && did == dialog_id) {
                    return true;
                }
            }
            return false;
        }
    };
    private int chatEmojiViewPadding;
    private int fixedKeyboardHeight = -1;
    private Runnable cancelFixedPositionRunnable;
    private boolean invalidateMessagesVisiblePart;
    private boolean scrollByTouch;
    int dialogFolderId;
    int dialogFilterId;
    boolean pulled = false;
    private static boolean replacingChatActivity = false;

    private PinchToZoomHelper pinchToZoomHelper;
    public EmojiAnimationsOverlay emojiAnimationsOverlay;
    public float drawingChatListViewYoffset;
    public int blurredViewTopOffset;
    public int blurredViewBottomOffset;
    public ChatMessageSharedResources sharedResources;

    private ValueAnimator searchExpandAnimator;
    private float searchExpandProgress;

    private boolean notSingleMediaSelected() {
        int mediaCount = 0;
        for (int a = 0; a < 2; a++) {
            for (int b = 0, N = selectedMessagesIds[a].size(); b < N; b++) {
                MessageObject message = selectedMessagesIds[a].valueAt(b);
                if (ForkUtils.HasPhotoOrDocument(message)) {
                    mediaCount++;
                    if (mediaCount >= 2) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private ShareAlert createShareAlert(
            final Context context,
            ArrayList<MessageObject> messages,
            final String text,
            boolean groupAnyItems,
            final boolean includeStory,
            MessageObject messageObject) {

        return new ShareAlert(
            context,
            ChatActivity.this,
            messages,
            text,
            null,
            ChatObject.isChannel(currentChat),
            null,
            null,
            false,
            false,
            includeStory,
            null,
            themeDelegate,
            groupAnyItems) {
                { includeStoryFromMessage = includeStory; }
                @Override
                public void dismissInternal() {
                    AndroidUtilities.requestAdjustResize(getParentActivity(), classGuid);
                    super.dismissInternal();
                    if (chatActivityEnterView.getVisibility() == View.VISIBLE) {
                        fragmentView.requestLayout();
                    }
                }
                @Override
                protected void onShareStory(View cell) {
                    StoryRecorder.SourceView sourceView = null;
                    if (cell instanceof ShareDialogCell) {
                        sourceView = StoryRecorder.SourceView.fromShareCell((ShareDialogCell) cell);
                    }
                    final ArrayList<MessageObject> messageObjects = new ArrayList<>();
                    MessageObject.GroupedMessages groupedMessages = messageObject.getGroupId() != 0 ? groupedMessagesMap.get(messageObject.getGroupId()) : null;
                    if (groupedMessages != null) {
                        messageObjects.addAll(groupedMessages.messages);
                    } else {
                        messageObjects.add(messageObject);
                    }
                    StoryRecorder editor = StoryRecorder.getInstance(getParentActivity(), currentAccount);
                    editor.setOnPrepareCloseListener((t, close, sent, did) -> {
                        if (sent) {
                            AndroidUtilities.runOnUIThread(() -> {
                                String chatTitle = "";
                                if (did < 0) {
                                    TLRPC.Chat chat = getMessagesController().getChat(-did);
                                    if (chat != null) {
                                        chatTitle = chat.title;
                                    }
                                }
                                BulletinFactory.of(ChatActivity.this).createSimpleBulletin(R.raw.contact_check, AndroidUtilities.replaceTags(
                                    TextUtils.isEmpty(chatTitle) ?
                                        LocaleController.getString(R.string.RepostedToProfile) :
                                        LocaleController.formatString(R.string.RepostedToChannelProfile, chatTitle)
                                )).show();
                            });
                            dismiss();
                            editor.replaceSourceView(null);
                        } else {
                            StoryRecorder.SourceView sourceView2 = null;
                            if (cell instanceof ShareDialogCell && cell.isAttachedToWindow()) {
                                sourceView2 = StoryRecorder.SourceView.fromShareCell((ShareDialogCell) cell);
                            }
                            editor.replaceSourceView(sourceView2);
                        }
                        AndroidUtilities.runOnUIThread(close);
                    });
                    editor.openRepost(sourceView, StoryEntry.repostMessage(messageObjects));
                }
                @Override
                protected void onSend(LongSparseArray<TLRPC.Dialog> dids, int count, TLRPC.TL_forumTopic topic, UndoInfo info) {
                    if (dids.size() == 1) {
                        getUndoView().showWithAction(dids.valueAt(0).id, UndoView.ACTION_FWD_MESSAGES, info);
                    } else {
                        getUndoView().showWithAction(0, UndoView.ACTION_FWD_MESSAGES, info, dids.size(), null, null);
                    }
                }
                @Override
                protected void onSend(LongSparseArray<TLRPC.Dialog> dids, int count, TLRPC.TL_forumTopic topic, boolean showToast) {
                    if (showToast == false) {
                        return;
                    }
                    if (dids.size() == 1) {
                        if (dids.valueAt(0).id != getUserConfig().getClientUserId() || !BulletinFactory.of(ChatActivity.this).showForwardedBulletinWithTag(dids.valueAt(0).id, count)) {
                            getUndoView().showWithAction(dids.valueAt(0).id, UndoView.ACTION_FWD_MESSAGES, count, topic, null, null);
                        }
                    } else {
                        getUndoView().showWithAction(0, UndoView.ACTION_FWD_MESSAGES, count, dids.size(), null, null);
                    }
                }
        };
    }

    private void showAnonymShareAlert(boolean groupMedia) {
        ArrayList<MessageObject> messages = new ArrayList<MessageObject>();
        for (int a = 1; a >= 0; a--) {
            ArrayList<Integer> ids = new ArrayList<>();
            for (int b = 0; b < selectedMessagesIds[a].size(); b++) {
                ids.add(selectedMessagesIds[a].keyAt(b));
            }
            Collections.sort(ids);
            for (int b = 0; b < ids.size(); b++) {
                Integer i = ids.get(b);
                MessageObject messageObject = selectedMessagesIds[a].get(i);
                if (messageObject != null) {
                    messages.add(messageObject);
                }
            }
            selectedMessagesCanCopyIds[a].clear();
            selectedMessagesCanStarIds[a].clear();
            selectedMessagesIds[a].clear();
        }
        hideActionMode();
        updatePinnedMessageView(true);
        updateVisibleRows();
        showDialog(createShareAlert(getParentActivity(), messages, "", groupMedia, false, null));
    }

    public static ChatActivity of(long dialogId) {
        Bundle bundle = new Bundle();
        if (dialogId >= 0) {
            bundle.putLong("user_id", dialogId);
        } else {
            bundle.putLong("chat_id", -dialogId);
        }
        return new ChatActivity(bundle);
    }

    public static ChatActivity of(long dialogId, int messageId) {
        Bundle bundle = new Bundle();
        if (dialogId >= 0) {
            bundle.putLong("user_id", dialogId);
        } else {
            bundle.putLong("chat_id", -dialogId);
        }
        bundle.putInt("message_id", messageId);
        return new ChatActivity(bundle);
    }

    public void deleteHistory(int dateSelectedStart, int dateSelectedEnd, boolean forAll) {
        chatAdapter.frozenMessages.clear();
        for (int i = 0; i < messages.size(); i++) {
            MessageObject messageObject = messages.get(i);
            if (messageObject.messageOwner.date <= dateSelectedStart || messageObject.messageOwner.date >= dateSelectedEnd) {
                chatAdapter.frozenMessages.add(messageObject);
            }
        }
        if (chatListView != null) {
            chatListView.setEmptyView(null);
        }
        if (chatAdapter.frozenMessages.isEmpty()) {
            showProgressView(true);
        }
        chatAdapter.isFrozen = true;
        chatAdapter.notifyDataSetChanged(true);
        UndoView undoView = getUndoView();
        if (undoView == null) {
            return;
        }

        undoView.showWithAction(dialog_id, UndoView.ACTION_CLEAR_DATES, () -> {
            getMessagesController().deleteMessagesRange(dialog_id, ChatObject.isChannel(currentChat) ? dialog_id : 0, dateSelectedStart, dateSelectedEnd, forAll, () -> {
                chatAdapter.frozenMessages.clear();
                chatAdapter.isFrozen = false;
                chatAdapter.notifyDataSetChanged(true);
                showProgressView(false);
            });
        }, () -> {
            chatAdapter.frozenMessages.clear();
            chatAdapter.isFrozen = false;
            chatAdapter.notifyDataSetChanged(true);
            showProgressView(false);
        });
    }

    public void showHeaderItem(boolean show) {
        if (show) {
            if (chatActivityEnterView.hasText() && TextUtils.isEmpty(chatActivityEnterView.getSlowModeTimer())) {
                if (attachItem != null) {
                    attachItem.setVisibility(View.VISIBLE);
                }
                if (headerItem != null) {
                    headerItem.setVisibility(View.GONE);
                }
            } else {
                if (attachItem != null) {
                    attachItem.setVisibility(View.GONE);
                }
                if (headerItem != null) {
                    headerItem.setVisibility(View.VISIBLE);
                }
            }
        } else {
            if (attachItem != null) {
                attachItem.setVisibility(View.GONE);
            }
            if (headerItem != null) {
                headerItem.setVisibility(View.GONE);
            }
        }
        if (avatarContainer != null) {
            avatarContainer.ignoreTouches = !show;
        }
    }

    public long getTopicId() {
        return isTopic || chatMode == MODE_SAVED || chatMode == MODE_QUICK_REPLIES || chatMode == MODE_SUGGESTIONS ? threadMessageId : 0L;
    }

    public int getQuickReplyId() {
        return chatMode == MODE_QUICK_REPLIES ? (int) threadMessageId : 0;
    }

    public long getSavedDialogId() {
        return chatMode == MODE_SAVED ? threadMessageId : 0L;
    }

    public boolean isForumInViewAsMessagesMode() {
        return ChatObject.isForum(currentChat) && !isTopic || ChatObject.isMonoForum(currentChat) && getTopicId() == 0L && !isSubscriberSuggestions;
    }

    @Override
    public List<FloatingDebugController.DebugItem> onGetDebugItems() {
        List<FloatingDebugController.DebugItem> items = new ArrayList<>();
        if (ChatObject.isChannel(currentChat)) {
            items.add(new FloatingDebugController.DebugItem(LocaleController.getString(R.string.DebugShareAlert)));
            String mode;
            switch (shareAlertDebugMode) {
                default:
                    mode = LocaleController.getString(R.string.DebugShareAlertDialogsModeNormal);
                    break;
                case DEBUG_SHARE_ALERT_MODE_LESS:
                    mode = LocaleController.getString(R.string.DebugShareAlertDialogsModeLess);
                    break;
                case DEBUG_SHARE_ALERT_MODE_MORE:
                    mode = LocaleController.getString(R.string.DebugShareAlertDialogsModeMore);
                    break;
            }
            items.add(new FloatingDebugController.DebugItem(LocaleController.formatString(R.string.DebugShareAlertSwitchDialogsMode, mode), () -> {
                shareAlertDebugMode++;
                shareAlertDebugMode %= 3;
            }));

            items.add(new FloatingDebugController.DebugItem(LocaleController.getString(R.string.DebugShareAlertTopicsSlowMotion), ()-> shareAlertDebugTopicsSlowMotion = !shareAlertDebugTopicsSlowMotion));
        }
        if (currentUser == null) {
            items.add(new FloatingDebugController.DebugItem(LocaleController.getString(R.string.DebugMessageSkeletons)));
            items.add(new FloatingDebugController.DebugItem(LocaleController.getString(R.string.DebugMessageSkeletonsLightOverlayAlpha), 0, 255, new AnimationProperties.FloatProperty("") {
                @Override
                public void setValue(Object object, float value) {
                    SKELETON_LIGHT_OVERLAY_ALPHA = (int) value;
                }

                @Override
                public Object get(Object object) {
                    return (float) SKELETON_LIGHT_OVERLAY_ALPHA;
                }
            }));
            items.add(new FloatingDebugController.DebugItem(LocaleController.getString(R.string.DebugMessageSkeletonsSaturation), 1f, 10f, new AnimationProperties.FloatProperty("") {
                @Override
                public void setValue(Object object, float value) {
                    SKELETON_SATURATION = value;
                    skeletonColorMatrix.setSaturation(value);
                    skeletonServicePaint.setColorFilter(new ColorMatrixColorFilter(skeletonColorMatrix));
                }

                @Override
                public Object get(Object object) {
                    return SKELETON_SATURATION;
                }
            }));
        }
        return items;
    }

    public boolean allowSendPhotos() {
        if (currentChat != null && !ChatObject.canSendPhoto(currentChat)) {
            return false;
        } else {
            return true;
        }
    }

    public ThemeDelegate createThemeDelegate() {
        return new ThemeDelegate();
    }

    public void updateMessages(ArrayList<MessageObject> messageObjects, boolean replace) {
        for (int i = 0; i < messageObjects.size(); i++) {
            chatAdapter.updateRowWithMessageObject(messageObjects.get(i), false, replace);
        }
    }

    public TextView getOrCreateWebBotTitleView() {
        if (webBotTitle == null) {
            webBotTitle = new TextView(getContext());
            webBotTitle.setTextColor(Theme.getColor(Theme.key_windowBackgroundWhiteBlackText));
            webBotTitle.setTypeface(AndroidUtilities.bold());
            webBotTitle.setGravity(Gravity.CENTER_VERTICAL);
            webBotTitle.setSingleLine(true);
            webBotTitle.setEllipsize(TextUtils.TruncateAt.END);
            actionBar.addView(webBotTitle, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, 0,  72, 0, 72 + 34, 0));
        }
        return webBotTitle;
    }

    private interface ChatActivityDelegate {
        default void openReplyMessage(int mid) {

        }

        default void openHashtagSearch(String hashtag) {


        }

        default void onUnpin(boolean all, boolean hide) {

        }

        default void onReport() {

        }
    }

    MessagePreviewView forwardingPreviewView;

    public class SparseArrayWithTouch<E> extends SparseArray<E> {
        public ArrayList<Integer> withTouch = new ArrayList<>();

        @Override
        public void clear() {
            withTouch.clear();
            super.clear();
        }
    }

    private PhotoViewer.PhotoViewerProvider photoViewerProvider = new PhotoViewer.EmptyPhotoViewerProvider() {

        @Override
        public PhotoViewer.PlaceProviderObject getPlaceForPhoto(MessageObject messageObject, TLRPC.FileLocation fileLocation, int index, boolean needPreview, boolean closing) {
            return ChatActivity.this.getPlaceForPhoto(messageObject, fileLocation, index, needPreview, false);
        }

        @Override
        public boolean validateGroupId(long groupId) {
            MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(groupId);
            return groupedMessages != null && groupedMessages.messages.size() > 1;
        }
    };
    private PhotoViewer.PhotoViewerProvider photoViewerPaidMediaProvider = new PhotoViewer.EmptyPhotoViewerProvider() {

        @Override
        public PhotoViewer.PlaceProviderObject getPlaceForPhoto(MessageObject messageObject, TLRPC.FileLocation fileLocation, int index, boolean needPreview, boolean closing) {
            return ChatActivity.this.getPlaceForPhoto(messageObject, fileLocation, index, needPreview, false);
        }

        @Override
        public boolean validateGroupId(long groupId) {
            MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(groupId);
            return groupedMessages != null && groupedMessages.messages.size() > 1;
        }

        @Override
        public boolean forceAllInGroup() {
            return true;
        }
    };

    private ArrayList<Object> botContextResults;
    private PhotoViewer.PhotoViewerProvider botContextProvider = new PhotoViewer.EmptyPhotoViewerProvider() {

        @Override
        public PhotoViewer.PlaceProviderObject getPlaceForPhoto(MessageObject messageObject, TLRPC.FileLocation fileLocation, int index, boolean needPreview, boolean closing) {
            if (index < 0 || index >= botContextResults.size() || mentionContainer == null || mentionContainer.getListView() == null) {
                return null;
            }
            int count = mentionContainer.getListView().getChildCount();
            Object result = botContextResults.get(index);

            for (int a = 0; a < count; a++) {
                ImageReceiver imageReceiver = null;
                View view = mentionContainer.getListView().getChildAt(a);
                if (view instanceof ContextLinkCell) {
                    ContextLinkCell cell = (ContextLinkCell) view;
                    if (cell.getResult() == result) {
                        imageReceiver = cell.getPhotoImage();
                    }
                }

                if (imageReceiver != null) {
                    int[] coords = new int[2];
                    view.getLocationInWindow(coords);
                    PhotoViewer.PlaceProviderObject object = new PhotoViewer.PlaceProviderObject();
                    object.viewX = coords[0];
                    object.viewY = coords[1];
//                    object.clipTopAddition = (int) (chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(4));
                    object.parentView = mentionContainer.getListView();
                    object.imageReceiver = imageReceiver;
                    object.thumb = imageReceiver.getBitmapSafe();
                    object.radius = imageReceiver.getRoundRadius(true);
                    return object;
                }
            }
            return null;
        }

        @Override
        public void sendButtonPressed(int index, VideoEditedInfo videoEditedInfo, boolean notify, int scheduleDate, int scheduleRepeatPeriod, boolean forceDocument) {
            if (index < 0 || index >= botContextResults.size()) {
                return;
            }
            sendBotInlineResult((TLRPC.BotInlineResult) botContextResults.get(index), notify, scheduleDate, 0);
        }
    };

    private final static int copy = 10;
    private final static int forward = 11;
    private final static int forward_anonym = 111;
    private final static int select_between = 112;
    private final static int delete = 12;
    private final static int chat_enc_timer = 13;
    private final static int chat_menu_attach = 14;
    private final static int chat_menu_search = -1;
    private final static int chat_menu_options = -2;
    private final static int chat_menu_edit_text_options = -3;
    private final static int clear_history = 15;
    private final static int delete_chat = 16;
    private final static int share_contact = 17;
    private final static int mute = 18;
    private final static int report = 21;
    private final static int star = 22;
    private final static int edit = 23;
    private final static int add_shortcut = 24;
    private final static int save_to = 25;
    private final static int auto_delete_timer = 26;
    private final static int change_colors = 27;
    private final static int tag_message = 28;
    private final static int boost_group = 29;

    private final static int bot_help = 30;
    private final static int bot_settings = 31;
    private final static int call = 32;
    private final static int video_call = 33;
    private final static int hideTitle = 34;
    private final static int goToFirstMessage = 35;
    private final static int deleteAllYourMessages = 36;
    private final static int deleteAllUnpinnedMessages = 37;
    private final static int deleteAllYourMessagesInAllTopics = 38;

    private final static int attach_photo = 0;
    private final static int attach_gallery = 1;
    private final static int attach_video = 2;

    private final static int text_bold = 50;
    private final static int text_italic = 51;
    private final static int text_mono = 52;
    private final static int text_link = 53;
    private final static int text_regular = 54;
    private final static int text_strike = 55;
    private final static int text_underline = 56;
    private final static int text_spoiler = 57;
    private final static int text_quote = 58;

    private final static int view_as_topics = 59;

    private final static int search = 40;

    private final static int topic_close = 60;
    private final static int open_forum = 61;

    private final static int translate = 62;
    private final static int scheduled = 63;
    private final static int edit_quick_reply = 64;

    private final static int copy_business_link = 65;
    private final static int share_business_link = 66;
    private final static int rename_business_link = 67;
    private final static int delete_business_link = 68;

    private final static int share = 69;
    private final static int open_direct = 70;
    private final static int remove_fee = 71;
    private final static int charge_fee = 72;

    private final static int id_chat_compose_panel = 1000;

    RecyclerListView.OnItemLongClickListenerExtended onItemLongClickListener = new RecyclerListView.OnItemLongClickListenerExtended() {
        @Override
        public boolean onItemClick(View view, int position, float x, float y) {
            if (textSelectionHelper.isTryingSelect() || textSelectionHelper.isInSelectionMode() || inPreviewMode || isInsideContainer) {
                return false;
            }
            wasManualScroll = true;
            boolean result = true;
            boolean showMenu = true;
            if (view instanceof ChatActionCell) {
                ChatActionCell actionCell = (ChatActionCell) view;
                MessageObject messageObject = actionCell.getMessageObject();
                if (messageObject == null) return false;
                showMenu = messageObject.messageOwner.action instanceof TLRPC.TL_messageActionSetMessagesTTL || actionCell.getMessageObject().type == MessageObject.TYPE_SUGGEST_PHOTO || actionCell.getMessageObject().isWallpaperAction() || actionCell.getMessageObject().type == MessageObject.TYPE_GIFT_STARS;
            }
            if (!actionBar.isActionModeShowed() && (!isReport() || showMenu)) {
                result = createMenu(view, false, true, x, y, true);
            } else {
                boolean outside = false;
                if (view instanceof ChatMessageCell) {
                    outside = !((ChatMessageCell) view).isInsideBackground(x, y);
                }
                processRowSelect(view, outside, x, y);
            }
            if (view instanceof ChatMessageCell && (((ChatMessageCell) view).getMessageObject() != null && ((ChatMessageCell) view).getMessageObject().type != MessageObject.TYPE_JOINED_CHANNEL)) {
                startMultiselect(position);
                result = true;
            }
            return result;
        }
    };

    public RecyclerListView getChatListView() {
        return chatListView;
    }

    private void startMultiselect(int position) {
        if (isInsideContainer) {
            return;
        }
        int indexOfMessage = position - chatAdapter.messagesStartRow;
        if (indexOfMessage < 0 || indexOfMessage >= messages.size()) {
            return;
        }
        MessageObject messageObject = messages.get(indexOfMessage);
        final boolean unselect = selectedMessagesIds[0].get(messageObject.getId(), null) == null && selectedMessagesIds[1].get(messageObject.getId(), null) == null;
        SparseArray<MessageObject> alreadySelectedMessagesIds = new SparseArray<>();
        for (int i = 0; i < selectedMessagesIds[0].size(); i++) {
            alreadySelectedMessagesIds.put(selectedMessagesIds[0].keyAt(i), selectedMessagesIds[0].valueAt(i));
        }
        for (int i = 0; i < selectedMessagesIds[1].size(); i++) {
            alreadySelectedMessagesIds.put(selectedMessagesIds[1].keyAt(i), selectedMessagesIds[1].valueAt(i));
        }
        chatListView.startMultiselect(position, false, new RecyclerListView.onMultiSelectionChanged() {
            boolean limitReached;
            @Override
            public void onSelectionChanged(int position, boolean selected, float x, float y) {
                int i = position - chatAdapter.messagesStartRow;
                if (unselect) {
                    selected = !selected;
                }
                if (i >= 0 && i < messages.size()) {
                    MessageObject messageObject = messages.get(i);
                    if (selected && (selectedMessagesIds[0].indexOfKey(messageObject.getId()) >= 0 || selectedMessagesIds[1].indexOfKey(messageObject.getId()) >= 0)) {
                        return;
                    }
                    if (!selected && selectedMessagesIds[0].indexOfKey(messageObject.getId()) < 0 && selectedMessagesIds[1].indexOfKey(messageObject.getId()) < 0) {
                        return;
                    }
                    if (messageObject.contentType == 0) {
                        if (selected && selectedMessagesIds[0].size() + selectedMessagesIds[1].size() >= 100) {
                            limitReached = true;
                        } else {
                            limitReached = false;
                        }
                        RecyclerView.ViewHolder holder = chatListView.findViewHolderForAdapterPosition(position);
                        if (holder != null && holder.itemView instanceof ChatMessageCell) {
                            processRowSelect(holder.itemView, false, x, y);
                        } else {
                            addToSelectedMessages(messageObject, false);
                            updateActionModeTitle();
                            updateVisibleRows();
                        }
                    }
                }
            }

            @Override
            public boolean canSelect(int position) {
                int i = position - chatAdapter.messagesStartRow;
                if (i >= 0 && i < messages.size()) {
                    MessageObject messageObject = messages.get(i);
                    if (messageObject.contentType == 0) {
                        if (!unselect && alreadySelectedMessagesIds.get(messageObject.getId(), null) == null) {
                            return true;
                        }
                        if (unselect && alreadySelectedMessagesIds.get(messageObject.getId(), null) != null) {
                            return true;
                        }
                    }
                }
                return false;
            }

            @Override
            public int checkPosition(int position, boolean selectionTop) {
                int i = position - chatAdapter.messagesStartRow;
                if (i >= 0 && i < messages.size()) {
                    MessageObject messageObject = messages.get(i);
                    if (messageObject.contentType == 0 && messageObject.hasValidGroupId()) {
                        MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(messageObject.getGroupId());
                        if (groupedMessages != null) {
                            MessageObject messageObject1 = groupedMessages.messages.get(selectionTop ? 0 : groupedMessages.messages.size() - 1);
                            return chatAdapter.messagesStartRow + messages.indexOf(messageObject1);
                        }
                    }
                }
                return position;
            }

            @Override
            public boolean limitReached() {
                return limitReached;
            }

            @Override
            public void getPaddings(int[] paddings) {
                paddings[0] = (int) chatListViewPaddingTop;
                paddings[1] = blurredViewBottomOffset;
            }

            @Override
            public void scrollBy(int dy) {
                chatListView.scrollBy(0, dy);
            }
        });
    }

    RecyclerListView.OnItemClickListenerExtended onItemClickListener = new RecyclerListView.OnItemClickListenerExtended() {
        @Override
        public void onItemClick(View view, int position, float x, float y) {
            if (inPreviewMode) {
                return;
            }
            wasManualScroll = true;
            if (view instanceof ChatActionCell && ((ChatActionCell) view).getMessageObject().isDateObject) {
                if (isInsideContainer) {
                    return;
                }
                Bundle bundle = new Bundle();
                int date = ((ChatActionCell) view).getMessageObject().messageOwner.date;
                bundle.putLong("dialog_id", dialog_id);
                bundle.putLong("topic_id", getTopicId());
                bundle.putInt("type", CalendarActivity.TYPE_CHAT_ACTIVITY);
                CalendarActivity calendarActivity = new CalendarActivity(bundle, SharedMediaLayout.FILTER_PHOTOS_AND_VIDEOS, date);
                calendarActivity.setChatActivity(ChatActivity.this);
                presentFragment(calendarActivity);
                return;
            }
            if (view instanceof ChatActionCell && ((ChatActionCell) view).getMessageObject() != null && ((ChatActionCell) view).getMessageObject().messageOwner.action instanceof TLRPC.TL_messageActionBoostApply) {
                getNotificationCenter().postNotificationName(NotificationCenter.openBoostForUsersDialog, dialog_id);
                return;
            }
            if (view instanceof ChatActionCell && ((ChatActionCell) view).getMessageObject() != null && ((ChatActionCell) view).getMessageObject().messageOwner.action instanceof TLRPC.TL_messageActionSetSameChatWallPaper) {
                int messageId = ((ChatActionCell) view).getMessageObject().getReplyMsgId();
                AndroidUtilities.runOnUIThread(() -> {
                    scrollToMessageId(messageId, 0, true, 0, true, 0);
                }, 16);
                return;
            }
            if (actionBar.isActionModeShowed() || isReport()) {
                boolean outside = false;
                if (view instanceof ChatMessageCell) {
                    if (textSelectionHelper.isSelected(((ChatMessageCell) view).getMessageObject())) {
                        return;
                    }
                    outside = !((ChatMessageCell) view).isInsideBackground(x, y);
                }
                processRowSelect(view, outside, x, y);
                return;
            }
            if (view instanceof ChatMessageCell) {
                MessageObject msg = ((ChatMessageCell) view).getMessageObject();
                if (msg != null && msg.type == MessageObject.TYPE_JOINED_CHANNEL) {
                    msg.toggleChannelRecommendations();
                    msg.forceUpdate = true;
                    ((ChatMessageCell) view).forceResetMessageObject();
                    view.requestLayout();
                    if (position >= 0) {
                        chatAdapter.notifyItemChanged(position);
                    }
                    return;
                }
            }
            createMenu(view, true, false, x, y, false);
        }

        @Override
        public boolean hasDoubleTap(View view, int position) {
            if (MessagesController.getGlobalMainSettings().getBoolean("disableQuickReaction", false)) {
                return false;
            }
            if (chatMode == MODE_QUICK_REPLIES) return false;
            String reactionStringSetting = getMediaDataController().getDoubleTapReaction();
            TLRPC.TL_availableReaction reaction = getMediaDataController().getReactionsMap().get(reactionStringSetting);
            if (reaction == null && (reactionStringSetting == null || !reactionStringSetting.startsWith("animated_"))) {
                return false;
            }
            boolean available = dialog_id >= 0;
            if (!available && chatInfo != null) {
                available = ChatObject.reactionIsAvailable(chatInfo, reaction == null ? reactionStringSetting : reaction.reaction);
            }
            if (!available) {
                return false;
            }
            MessageObject messageObject;
            if (view instanceof ChatMessageCell) {
                messageObject = ((ChatMessageCell) view).getPrimaryMessageObject();
            } else if (view instanceof ChatActionCell) {
                messageObject = ((ChatActionCell) view).getMessageObject();
            } else {
                return false;
            }
            return messageObject != null && !messageObject.isDateObject && !messageObject.isSending() && messageObject.canSetReaction() && !messageObject.isEditing() && !actionBar.isActionModeShowed() && !isSecretChat() && !isInScheduleMode() && !messageObject.isSponsored();
        }

        @Override
        public void onDoubleTap(View view, int position, float x, float y) {
            if (getParentActivity() == null || isSecretChat() || isInScheduleMode() || isInPreviewMode() || chatMode == MODE_QUICK_REPLIES) {
                return;
            }
            MessageObject messageObject;
            if (view instanceof ChatMessageCell) {
                messageObject = ((ChatMessageCell) view).getPrimaryMessageObject();
            } else if (view instanceof ChatActionCell) {
                messageObject = ((ChatActionCell) view).getMessageObject();
                if (messageObject.isDateObject) {
                    return;
                }
            } else {
                return;
            }
            if (messageObject.isSecret() || !messageObject.canSetReaction() || messageObject.isExpiredStory() || messageObject.type == MessageObject.TYPE_JOINED_CHANNEL) {
                return;
            }
            ReactionsEffectOverlay.removeCurrent(false);
            String reactionString = getMediaDataController().getDoubleTapReaction();
            if (reactionString.startsWith("animated_")) {
                boolean available = dialog_id >= 0;
                if (!available && chatInfo != null) {
                    available = ChatObject.reactionIsAvailable(chatInfo, reactionString);
                }
                if (!available) {
                    return;
                }
                selectReaction(view, messageObject, null, null, x, y, ReactionsLayoutInBubble.VisibleReaction.fromEmojicon(reactionString), true, false, false, false);
            } else {
                TLRPC.TL_availableReaction reaction = getMediaDataController().getReactionsMap().get(reactionString);
                if (reaction == null || messageObject.isSponsored()) {
                    return;
                }
                boolean available = dialog_id >= 0;
                if (!available && chatInfo != null) {
                    available = ChatObject.reactionIsAvailable(chatInfo, reaction.reaction);
                }
                if (!available) {
                    return;
                }
                selectReaction(view, messageObject, null, null, x, y, ReactionsLayoutInBubble.VisibleReaction.fromEmojicon(reaction), true, false, false, false);
            }
        }
    };

    private class ChatActivityEnterViewDelegate implements ChatActivityEnterView.ChatActivityEnterViewDelegate {

        int lastSize;
        boolean isEditTextItemVisibilitySuppressed;

        @Override
        public int getContentViewHeight() {
            return contentView.getHeight();
        }

        @Override
        public int measureKeyboardHeight() {
            return contentView.measureKeyboardHeight();
        }

        @Override
        public TLRPC.TL_channels_sendAsPeers getSendAsPeers() {
            if (MessagesController.getGlobalMainSettings().getBoolean("hideSendAs", false)) {
                return null;
            }
            return sendAsPeersObj;
        }

        @Override
        public void onMessageSend(CharSequence message, boolean notify, int scheduleDate, int scheduleRepeatPeriod, long payStars) {
            if (chatListItemAnimator != null) {
                chatActivityEnterViewAnimateFromTop = chatActivityEnterView.getBackgroundTop();
                if (chatActivityEnterViewAnimateFromTop != 0) {
                    chatActivityEnterViewAnimateBeforeSending = true;
                }
            }
            if (mentionContainer != null && mentionContainer.getAdapter() != null) {
                mentionContainer.getAdapter().addHashtagsFromMessage(message);
            }
            if (scheduleDate != 0) {
                if (scheduledMessagesCount == -1) {
                    scheduledMessagesCount = 0;
                }
                if (message != null) {
                    scheduledMessagesCount++;
                }
                if (messagePreviewParams != null && messagePreviewParams.forwardMessages != null && !messagePreviewParams.forwardMessages.messages.isEmpty()) {
                    scheduledMessagesCount += messagePreviewParams.forwardMessages.messages.size();
                }
                updateScheduledInterface(false);
            }
            if (!TextUtils.isEmpty(message) && messagePreviewParams != null && messagePreviewParams.forwardMessages != null && !messagePreviewParams.forwardMessages.messages.isEmpty() && messagePreviewParams.quote == null && payStars <= 0) {
                final ArrayList<MessageObject> messagesToForward = new ArrayList<>();
                messagePreviewParams.forwardMessages.getSelectedMessages(messagesToForward);
                boolean showReplyHint = messagesToForward.size() > 0;
                TLRPC.Peer toPeer = getMessagesController().getPeer(dialog_id);
                for (int i = 0; i < messagesToForward.size(); ++i) {
                    MessageObject msg = messagesToForward.get(i);
                    if (msg != null && msg.messageOwner != null && !MessageObject.peersEqual(msg.messageOwner.peer_id, toPeer)) {
                        showReplyHint = false;
                        break;
                    }
                }

                if (showReplyHint) {
                    Bulletin bulletin = BulletinFactory.of(ChatActivity.this)
                        .createSimpleBulletin(
                            R.raw.hint_swipe_reply,
                            LocaleController.getString(R.string.SwipeToReplyHint),
                            LocaleController.getString(R.string.SwipeToReplyHintMessage)
                        );
                    RLottieImageView imageView = ((Bulletin.TwoLineLottieLayout) bulletin.getLayout()).imageView;
                    imageView.setScaleX(1.8f);
                    imageView.setScaleY(1.8f);
                    bulletin.show(true);
                }
            }
            if (ChatObject.isForum(currentChat) && !isTopic && replyingMessageObject != null) {
                long topicId = replyingMessageObject.replyToForumTopic != null ? replyingMessageObject.replyToForumTopic.id : MessageObject.getTopicId(currentAccount, replyingMessageObject.messageOwner, true);
                if (topicId != 0) {
                    getMediaDataController().cleanDraft(dialog_id, topicId, false);
                }
            }

            hideFieldPanel(notify, scheduleDate, payStars, true);
            if (chatActivityEnterView != null && chatActivityEnterView.getEmojiView() != null) {
                chatActivityEnterView.getEmojiView().onMessageSend();
            }

            if (!getMessagesController().premiumFeaturesBlocked() && getMessagesController().transcribeAudioTrialWeeklyNumber <= 0 && !getMessagesController().didPressTranscribeButtonEnough() && !getUserConfig().isPremium() && !TextUtils.isEmpty(message) && messages != null) {
                for (int i = 1; i < Math.min(5, messages.size()); ++i) {
                    MessageObject msg = messages.get(i);
                    if (msg != null && !msg.isOutOwner() && (msg.isVoice() || msg.isRoundVideo()) && msg.isContentUnread()) {
                        TranscribeButton.showOffTranscribe(msg);
                    }
                }
            }
        }

        @Override
        public void onEditTextScroll() {
            if (suggestEmojiPanel != null) {
                suggestEmojiPanel.forceClose();
            }
        }

        @Override
        public void onContextMenuOpen() {
            if (suggestEmojiPanel != null) {
                suggestEmojiPanel.forceClose();
            }
        }

        @Override
        public void onContextMenuClose() {
            if (suggestEmojiPanel != null) {
                suggestEmojiPanel.fireUpdate();
            }
        }

        @Override
        public void onSwitchRecordMode(boolean video) {
            showVoiceHint(false, video);
        }

        @Override
        public void onPreAudioVideoRecord() {
            showVoiceHint(true, false);
        }

        @Override
        public void onUpdateSlowModeButton(View button, boolean show, CharSequence time) {
            showSlowModeHint(button, show, time);
            if (headerItem != null && headerItem.getVisibility() != View.VISIBLE) {
                headerItem.setVisibility(View.VISIBLE);
                if (attachItem != null) {
                    attachItem.setVisibility(View.GONE);
                }
            }
        }

        @Override
        public boolean checkCanRemoveRestrictionsByBoosts() {
            return ChatActivity.this.checkCanRemoveRestrictionsByBoosts();
        }

        @Override
        public void onTextSelectionChanged(int start, int end) {
            if (editTextItem == null) {
                return;
            }
            ActionBarMenu menu = actionBar.createMenu();
            if (suggestEmojiPanel != null) {
                suggestEmojiPanel.onTextSelectionChanged(start, end);
            }
            if (end - start > 0) {
                if (editTextItem.getTag() == null) {
                    editTextItem.setTag(1);

                    if (editTextItem.getVisibility() != View.VISIBLE) {
                        if (chatMode == MODE_SAVED && getSavedDialogId() == getUserConfig().getClientUserId() || chatMode == 0 && (threadMessageId == 0 || isTopic) && !UserObject.isReplyUser(currentUser) && !isReport()) {
                            editTextItem.setVisibility(View.VISIBLE);
                            checkEditTextItemMenu();
                            if (headerItem != null) {
                                headerItem.setVisibility(View.GONE);
                            }
                            if (attachItem != null) {
                                attachItem.setVisibility(View.GONE);
                            }
                        } else {
                            ValueAnimator valueAnimator = ValueAnimator.ofFloat(AndroidUtilities.dp(48), 0);
                            valueAnimator.setDuration(220);
                            valueAnimator.setInterpolator(CubicBezierInterpolator.DEFAULT);
                            valueAnimator.addListener(new AnimatorListenerAdapter() {
                                @Override
                                public void onAnimationStart(Animator animation) {
                                    actionBar.setMenuOffsetSuppressed(true);
                                    checkEditTextItemMenu();
                                    editTextItem.setVisibility(View.VISIBLE);
                                    menu.translateXItems(AndroidUtilities.dp(48));
                                }

                                @Override
                                public void onAnimationEnd(Animator animation) {
                                    actionBar.setMenuOffsetSuppressed(false);
                                }
                            });
                            valueAnimator.addUpdateListener(animation -> menu.translateXItems((float) animation.getAnimatedValue()));
                            valueAnimator.start();
                        }
                    }
                }
                editTextStart = start;
                editTextEnd = end;
            } else {
                if (editTextItem.getTag() != null) {
                    editTextItem.setTag(null);
                    if (editTextItem.getVisibility() != View.GONE) {
                        if (chatMode == MODE_SAVED && getSavedDialogId() == getUserConfig().getClientUserId() || chatMode == 0 && (threadMessageId == 0 || isTopic) && !UserObject.isReplyUser(currentUser) && !isReport()) {
                            editTextItem.setVisibility(View.GONE);

                            if (chatActivityEnterView.hasText() && TextUtils.isEmpty(chatActivityEnterView.getSlowModeTimer())) {
                                if (headerItem != null) {
                                    headerItem.setVisibility(View.GONE);
                                }
                                if (attachItem != null) {
                                    attachItem.setVisibility(View.VISIBLE);
                                }
                            } else {
                                if (headerItem != null) {
                                    headerItem.setVisibility(View.VISIBLE);
                                }
                                if (attachItem != null) {
                                    attachItem.setVisibility(View.GONE);
                                }
                            }
                        } else {
                            ValueAnimator valueAnimator = ValueAnimator.ofFloat(0, AndroidUtilities.dp(48));
                            valueAnimator.setDuration(220);
                            valueAnimator.setInterpolator(CubicBezierInterpolator.DEFAULT);
                            valueAnimator.addListener(new AnimatorListenerAdapter() {
                                @Override
                                public void onAnimationStart(Animator animation) {
                                    actionBar.setMenuOffsetSuppressed(true);
                                    isEditTextItemVisibilitySuppressed = true;
                                }

                                @Override
                                public void onAnimationEnd(Animator animation) {
                                    editTextItem.setVisibility(View.GONE);
                                    menu.translateXItems(0);

                                    actionBar.setMenuOffsetSuppressed(false);
                                    isEditTextItemVisibilitySuppressed = false;
                                }
                            });
                            valueAnimator.addUpdateListener(animation -> menu.translateXItems((float) animation.getAnimatedValue()));
                            valueAnimator.start();
                        }
                    }
                }
            }
        }

        @Override
        public void onTextChanged(final CharSequence text, boolean bigChange, boolean fromDraft) {
            MediaController.getInstance().setInputFieldHasText(!TextUtils.isEmpty(text) || chatActivityEnterView.isEditingMessage());
            if (mentionContainer != null && mentionContainer.getAdapter() != null) {
                mentionContainer.getAdapter().searchUsernameOrHashtag(text, chatActivityEnterView.getCursorPosition(), messages, false, false);
            }
            if (waitingForCharaterEnterRunnable != null) {
                AndroidUtilities.cancelRunOnUIThread(waitingForCharaterEnterRunnable);
                waitingForCharaterEnterRunnable = null;
            }
            if ((currentChat == null || ChatObject.canSendEmbed(currentChat)) && chatActivityEnterView.isMessageWebPageSearchEnabled() && (!chatActivityEnterView.isEditingMessage() || !chatActivityEnterView.isEditingCaption())) {
                if (bigChange) {
                    searchLinks(text, true);
                } else {
                    checkEditLinkRemoved(text);
                    waitingForCharaterEnterRunnable = new Runnable() {
                        @Override
                        public void run() {
                            if (this == waitingForCharaterEnterRunnable) {
                                searchLinks(text, false);
                                waitingForCharaterEnterRunnable = null;
                            }
                        }
                    };
                    AndroidUtilities.runOnUIThread(waitingForCharaterEnterRunnable, AndroidUtilities.WEB_URL == null ? 3000 : 1000);
                }
            }
            if (emojiAnimationsOverlay != null) {
                emojiAnimationsOverlay.cancelAllAnimations();
            }
            ReactionsEffectOverlay.dismissAll();
            if (!fromDraft) {
                if ((scheduledOrNoSoundHint != null && scheduledOrNoSoundHint.getVisibility() == View.VISIBLE)
                        || (scheduledHint != null && scheduledHint.getVisibility() == View.VISIBLE)) {
                    hideSendButtonHints();
                } else {
                    showScheduledHint();
                }
            }
        }

        @Override
        public void onTextSpansChanged(CharSequence text) {
            searchLinks(text, true);
        }

        @Override
        public void needSendTyping() {
            if (chatMode == MODE_QUICK_REPLIES || chatMode == MODE_EDIT_BUSINESS_LINK || chatMode == MODE_SUGGESTIONS) return;
            getMessagesController().sendTyping(dialog_id, threadMessageId, 0, classGuid);
        }

        @Override
        public void onAttachButtonHidden() {
            if (actionBar.isSearchFieldVisible()) {
                return;
            }
            if (editTextItem != null && !isEditTextItemVisibilitySuppressed) {
                editTextItem.setVisibility(View.GONE);
            }
            if (TextUtils.isEmpty(chatActivityEnterView.getSlowModeTimer())) {
                if (headerItem != null) {
                    headerItem.setVisibility(View.GONE);
                }
                if (attachItem != null) {
                    attachItem.setVisibility(View.VISIBLE);
                }
            }
        }

        @Override
        public void onAttachButtonShow() {
            if (actionBar.isSearchFieldVisible()) {
                return;
            }
            if (headerItem != null) {
                headerItem.setVisibility(View.VISIBLE);
            }
            if (editTextItem != null && !isEditTextItemVisibilitySuppressed) {
                editTextItem.setVisibility(View.GONE);
            }
            if (attachItem != null) {
                attachItem.setVisibility(View.GONE);
            }
        }

        @Override
        public void onMessageEditEnd(boolean loading) {
            if (chatListItemAnimator != null) {
                chatActivityEnterViewAnimateFromTop = chatActivityEnterView.getBackgroundTop();
                if (chatActivityEnterViewAnimateFromTop != 0) {
                    chatActivityEnterViewAnimateBeforeSending = true;
                }
            }
            if (!loading) {
                if (mentionContainer != null) {
                    mentionContainer.getAdapter().setNeedBotContext(true);
                }
                if (editingMessageObject != null) {
                    AndroidUtilities.runOnUIThread(() -> hideFieldPanel(true), 30);
                }
                boolean waitingForKeyboard = false;
                if (chatActivityEnterView.isPopupShowing()) {
                    chatActivityEnterView.setFieldFocused();
                    waitingForKeyboard = true;
                }
                chatActivityEnterView.setAllowStickersAndGifs(true, true, true, waitingForKeyboard);
                if (editingMessageObjectReqId != 0) {
                    getConnectionsManager().cancelRequest(editingMessageObjectReqId, true);
                    editingMessageObjectReqId = 0;
                }
                updatePinnedMessageView(true);
                updateBottomOverlay();
                updateVisibleRows();
            }
        }

        @Override
        public void onWindowSizeChanged(int size) {
            if (size < AndroidUtilities.dp(72) + ActionBar.getCurrentActionBarHeight()) {
                allowStickersPanel = false;
                if (suggestEmojiPanel.getVisibility() == View.VISIBLE) {
                    suggestEmojiPanel.setVisibility(View.INVISIBLE);
                }
            } else {
                allowStickersPanel = true;
                if (suggestEmojiPanel.getVisibility() == View.INVISIBLE && !isInPreviewMode()) {
                    suggestEmojiPanel.setVisibility(View.VISIBLE);
                }
            }

            allowContextBotPanel = !chatActivityEnterView.isPopupShowing();
//                checkContextBotPanel();
            int size2 = size + (chatActivityEnterView.isPopupShowing() ? 1 << 16 : 0);
            if (lastSize != size2) {
                chatActivityEnterViewAnimateFromTop = 0;
                chatActivityEnterViewAnimateBeforeSending = false;
            }
            lastSize = size2;
        }

        @Override
        public void onStickersTab(boolean opened) {
            if (emojiButtonRed != null) {
                emojiButtonRed.setVisibility(View.GONE);
            }
            allowContextBotPanelSecond = !opened;
//                checkContextBotPanel();
        }

        @Override
        public void didPressAttachButton() {
            if (chatAttachAlert != null) {
                chatAttachAlert.setEditingMessageObject(0, null);
            }
            openAttachMenu();
        }

        @Override
        public void didPressSuggestionButton() {
            new MessageSuggestionOfferSheet(getContext(), currentAccount, dialog_id, messageSuggestionParams != null ? messageSuggestionParams: MessageSuggestionParams.empty(), ChatActivity.this, getResourceProvider(), MessageSuggestionOfferSheet.MODE_INPUT, ChatActivity.this::showFieldPanelForSuggestionParams).show();
        }

        @Override
        public void toggleVideoRecordingPause() {
            if (instantCameraView != null) {
                instantCameraView.togglePause();
            }
        }

        @Override
        public boolean isVideoRecordingPaused() {
            return instantCameraView != null && instantCameraView.isPaused();
        }

        @Override
        public void needStartRecordVideo(int state, boolean notify, int scheduleDate, int scheduleRepeatPeriod, int ttl, long effectId, long stars) {
            checkInstantCameraView();
            if (instantCameraView != null) {
                if (state == 0) {
                    instantCameraView.showCamera(false);
                    chatListView.stopScroll();
                    chatAdapter.updateRowsSafe();
                } else if (state == 1 || state == 3 || state == 4) {
                    instantCameraView.send(state, notify, scheduleDate, 0, ttl, effectId, stars);
                } else if (state == 2 || state == 5) {
                    instantCameraView.cancel(state == 2);
                }
            }
        }

        @Override
        public void needChangeVideoPreviewState(int state, float seekProgress) {
            if (instantCameraView != null) {
                instantCameraView.changeVideoPreviewState(state, seekProgress);
            }
        }

        @Override
        public void needStartRecordAudio(int state) {
            int visibility = state == 0 ? View.GONE : View.VISIBLE;
            if (overlayView.getVisibility() != visibility) {
                overlayView.setVisibility(visibility);
            }
        }

        @Override
        public void needShowMediaBanHint() {
            showMediaBannedHint();
        }

        @Override
        public void onStickersExpandedChange() {
            checkRaiseSensors();
            if (chatActivityEnterView.isStickersExpanded()) {
                AndroidUtilities.setAdjustResizeToNothing(getParentActivity(), classGuid);
                if (Bulletin.getVisibleBulletin() != null && Bulletin.getVisibleBulletin().isShowing()) {
                    Bulletin.getVisibleBulletin().hide();
                }
            } else {
                AndroidUtilities.requestAdjustResize(getParentActivity(), classGuid);
            }
            if (mentionContainer != null) {
                mentionContainer.animate().alpha(chatActivityEnterView.isStickersExpanded() || isInPreviewMode() ? 0 : 1f).setInterpolator(CubicBezierInterpolator.DEFAULT).start();
            }
            if (suggestEmojiPanel != null) {
                suggestEmojiPanel.setVisibility(View.VISIBLE);
                suggestEmojiPanel.animate().alpha(chatActivityEnterView.isStickersExpanded() || isInPreviewMode() ? 0 : 1f).setInterpolator(CubicBezierInterpolator.DEFAULT).withEndAction(() -> {
                    if (suggestEmojiPanel != null && chatActivityEnterView.isStickersExpanded()) {
                        suggestEmojiPanel.setVisibility(View.GONE);
                    }
                }).start();
            }
        }

        @Override
        public void scrollToSendingMessage() {
            int id = getSendMessagesHelper().getSendingMessageId(dialog_id);
            if (id != 0) {
                scrollToMessageId(id, 0, true, 0, true, 0);
            }
        }

        @Override
        public boolean hasScheduledMessages() {
            if (getMessagesController().isForum(getDialogId()) && !isTopic) {
                return false;
            }
            return scheduledMessagesCount > 0 && (chatMode == 0 || chatMode == MODE_SAVED && getSavedDialogId() == getUserConfig().getClientUserId());
        }

        @Override
        public void onSendLongClick() {
            if (scheduledOrNoSoundHint != null) {
                scheduledOrNoSoundHint.hide();
            }
            if (scheduledHint != null) {
                scheduledHint.hide();
            }
        }

        @Override
        public void openScheduledMessages() {
            ChatActivity.this.openScheduledMessages();
        }

        @Override
        public void onAudioVideoInterfaceUpdated() {
            updatePagedownButtonVisibility(true);
        }

        @Override
        public void bottomPanelTranslationYChanged(float translation) {
            if (translation != 0) {
                wasManualScroll = true;
            }

            invalidateChatListViewTopPadding();
            invalidateMessagesVisiblePart();
            updateTextureViewPosition(false, false);
            contentView.invalidate();
            updateBulletinLayout();
        }

        @Override
        public void prepareMessageSending() {
            waitingForSendingMessageLoad = true;
        }

        @Override
        public void onTrendingStickersShowed(boolean show) {
            if (show) {
                AndroidUtilities.setAdjustResizeToNothing(getParentActivity(), classGuid);
                fragmentView.requestLayout();
            } else {
                AndroidUtilities.requestAdjustResize(getParentActivity(), classGuid);
            }
        }

        @Override
        public boolean hasForwardingMessages() {
            return messagePreviewParams != null && messagePreviewParams.forwardMessages != null && !messagePreviewParams.forwardMessages.messages.isEmpty();
        }

        @Override
        public void onKeyboardRequested() {
            checkAdjustResize();
        }

        @Override
        public boolean onceVoiceAvailable() {
            return currentUser != null && !UserObject.isUserSelf(currentUser) && !currentUser.bot && currentEncryptedChat == null && chatMode == 0;
        }

        @Override
        public ReplyQuote getReplyQuote() {
            return replyingQuote;
        }
    }

    private final ChatScrollCallback chatScrollHelperCallback = new ChatScrollCallback();

    private final Runnable showScheduledOrNoSoundRunnable = () -> {
        if (getParentActivity() == null || fragmentView == null || chatActivityEnterView == null) {
            return;
        }
        View anchor = chatActivityEnterView.getSendButton();
        if (anchor == null || chatActivityEnterView.getEditField() == null || chatActivityEnterView.getEditField().getText().length() < 5) {
            return;
        }
        SharedConfig.increaseScheduledOrNoSoundHintShowed();
        if (scheduledOrNoSoundHint == null) {
            scheduledOrNoSoundHint = new HintView(getParentActivity(), 4, themeDelegate);
            scheduledOrNoSoundHint.createCloseButton();
            scheduledOrNoSoundHint.setAlpha(0);
            scheduledOrNoSoundHint.setVisibility(View.INVISIBLE);
            scheduledOrNoSoundHint.setText(getString(R.string.ScheduledOrNoSoundHint));
            contentView.addView(scheduledOrNoSoundHint, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 10, 0, 10, 0));
        }
        scheduledOrNoSoundHint.showForView(anchor, true);
        scheduledOrNoSoundHintShown = true;
    };

    private final Runnable showScheduledHintRunnable = () -> {
        if (getParentActivity() == null || fragmentView == null || chatActivityEnterView == null || forwardingPreviewView != null || getMessagesController().getSendPaidMessagesStars(getDialogId()) > 0) {
            return;
        }
        View anchor = chatActivityEnterView.getSendButton();
        if (anchor == null || chatActivityEnterView.getEditField() == null || chatActivityEnterView.getEditField().getText().length() == 0) {
            return;
        }
        SharedConfig.increaseScheduledHintShowed();
        if (scheduledHint == null) {
            scheduledHint = new HintView(getParentActivity(), 4, themeDelegate);
            scheduledHint.createCloseButton();
            scheduledHint.setAlpha(0);
            scheduledHint.setVisibility(View.INVISIBLE);
            scheduledHint.setText(LocaleController.getString(R.string.ScheduledHint));
            contentView.addView(scheduledHint, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 10, 0, 10, 0));
        }
        scheduledHint.showForView(anchor, true);
        scheduledHintShown = true;
    };

    public boolean isInsideContainer;
    public boolean reversed;
    private long wallpaperRandomSeed;

    public ChatActivity(Bundle args) {
        super(args);

        navbarContentSourceWallpaper = new BlurredBackgroundSourceWrapped();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S && SharedConfig.chatBlurEnabled()) {
            scrollableViewNoiseSuppressor = new DownscaleScrollableNoiseSuppressor();
            recommendedAdditionalSizeY = dp(48);

            glassBackgroundSourceFrostedRenderNode = new BlurredBackgroundSourceRenderNode(navbarContentSourceWallpaper);
            glassBackgroundSourceFrostedRenderNode.setOnDrawablesRelativePositionChangeListener(this::invalidateMergedVisibleBlurredPositionsAndSourcesPositions);

            navbarContentSourceMessages = new BlurredBackgroundSourceRenderNode(null);
            navbarContentSourceMessages.setOnDrawablesRelativePositionChangeListener(this::invalidateMergedVisibleBlurredPositionsAndSourcesPositions);
            navbarContentSourceMessagesDrawable = navbarContentSourceMessages.createDrawable();

            glassBackgroundDrawableFactoryFrosted = new BlurredBackgroundDrawableViewFactory(glassBackgroundSourceFrostedRenderNode);
            glassBackgroundDrawableFactoryFrosted.setLiquidGlassEffectAllowed(LiteMode.isEnabled(LiteMode.FLAG_LIQUID_GLASS));

            if (LiteMode.isEnabled(LiteMode.FLAG_LIQUID_GLASS)) {
                glassBackgroundSourceRenderNode = new BlurredBackgroundSourceRenderNode(navbarContentSourceWallpaper);
                glassBackgroundSourceRenderNode.setOnDrawablesRelativePositionChangeListener(this::invalidateMergedVisibleBlurredPositionsAndSourcesPositions);
                glassBackgroundDrawableFactory = new BlurredBackgroundDrawableViewFactory(glassBackgroundSourceRenderNode);
                glassBackgroundDrawableFactory.setLiquidGlassEffectAllowed(LiteMode.isEnabled(LiteMode.FLAG_LIQUID_GLASS));

                navbarContentSourceWallpaperAndMessagesRenderNode = null;
                navbarContentDrawableFactory = new BlurredBackgroundDrawableViewFactory(navbarContentSourceWallpaper);
            } else {
                glassBackgroundSourceRenderNode = null;
                glassBackgroundDrawableFactory = glassBackgroundDrawableFactoryFrosted;
                navbarContentSourceWallpaperAndMessagesRenderNode = new BlurredBackgroundSourceRenderNode(null);
                navbarContentSourceWallpaperAndMessagesRenderNode.setOnDrawablesRelativePositionChangeListener(this::invalidateMergedVisibleBlurredPositionsAndSourcesPositions);
                navbarContentDrawableFactory = new BlurredBackgroundDrawableViewFactory(navbarContentSourceWallpaperAndMessagesRenderNode);
            }
        } else {
            scrollableViewNoiseSuppressor = null;
            recommendedAdditionalSizeY = 0;

            glassBackgroundSourceRenderNode = null;
            glassBackgroundSourceFrostedRenderNode = null;

            navbarContentSourceMessages = null;
            navbarContentSourceMessagesDrawable = null;
            navbarContentSourceWallpaperAndMessagesRenderNode = null;

            glassBackgroundDrawableFactory = new BlurredBackgroundDrawableViewFactory(navbarContentSourceWallpaper);
            glassBackgroundDrawableFactoryFrosted = new BlurredBackgroundDrawableViewFactory(navbarContentSourceWallpaper);
            navbarContentDrawableFactory = new BlurredBackgroundDrawableViewFactory(navbarContentSourceWallpaper);
        }

        navbarContentDrawableFactory.setLinkedViewsRef(glassAttachedViews);
        glassBackgroundDrawableFactory.setLinkedViewsRef(glassAttachedViews);
        glassBackgroundDrawableFactoryFrosted.setLinkedViewsRef(glassAttachedViews);
    }

    @Override
    public boolean onFragmentCreate() {
        final long chatId = arguments.getLong("chat_id", 0);
        final long userId = arguments.getLong("user_id", 0);
        final int encId = arguments.getInt("enc_id", 0);
        dialogFolderId = arguments.getInt("dialog_folder_id", 0);
        dialogFilterId = arguments.getInt("dialog_filter_id", 0);
        chatMode = arguments.getInt("chatMode", 0);
        quickReplyShortcut = arguments.getString("quick_reply", null);
        voiceChatHash = arguments.getString("voicechat", null);
        openVideoChat = arguments.getBoolean("videochat", false);
        livestream = !TextUtils.isEmpty(arguments.getString("livestream", null));
        attachMenuBotToOpen = arguments.getString("attach_bot", null);
        attachMenuBotStartCommand = arguments.getString("attach_bot_start_command", null);
        inlineReturn = arguments.getLong("inline_return", 0);
        final String inlineQuery = arguments.getString("inline_query");
        textToSet = arguments.getString("start_text");
        premiumInvoiceBot = arguments.getBoolean("premium_bot", false);
        startLoadFromMessageId = arguments.getInt("message_id", 0);
        highlightTaskId = arguments.containsKey("task_id") ? arguments.getInt("task_id", 0) : null;
        startReplyTo = arguments.getInt("reply_to", 0);
        startLoadFromDate = arguments.getInt("start_from_date", 0);
        startFromVideoTimestamp = arguments.getInt("video_timestamp", -1);
        threadUnreadMessagesCount = arguments.getInt("unread_count", 0);
        convertingToast = arguments.getBoolean("converting_toast", false);
        convertingToastMessageId = arguments.getInt("converting_toast_from", 0);
        isSubscriberSuggestions = arguments.getBoolean("isSubscriberSuggestions", false);
        if (startFromVideoTimestamp >= 0) {
            startFromVideoMessageId = startLoadFromMessageId;
        }
        reportTitle = arguments.getString("reportTitle", null);
        reportOption = arguments.getByteArray("reportOption");
        reportMessage = arguments.getString("reportMessage", null);
        pulled = arguments.getBoolean("pulled", false);
        historyPreloaded = arguments.getBoolean("historyPreloaded", false);
        if (highlightMessageId != 0 && highlightMessageId != Integer.MAX_VALUE) {
            startLoadFromMessageId = highlightMessageId;
        }
        migrated_to = arguments.getInt("migrated_to", 0);
        scrollToTopOnResume = arguments.getBoolean("scrollToTopOnResume", false);
        needRemovePreviousSameChatActivity = arguments.getBoolean("need_remove_previous_same_chat_activity", true);
        justCreatedChat = arguments.getBoolean("just_created_chat", false);
        wallpaperRandomSeed = Utilities.random.nextLong();
        if (quickReplyShortcut != null) {
            QuickRepliesController.QuickReply quickReply = QuickRepliesController.getInstance(currentAccount).findReply(quickReplyShortcut);
            if (quickReply != null) {
                setQuickReplyId(quickReply.id);
            }
        }

        if (chatId != 0) {
            currentChat = getMessagesController().getChat(chatId);
            if (currentChat == null) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                final MessagesStorage messagesStorage = getMessagesStorage();
                messagesStorage.getStorageQueue().postRunnable(() -> {
                    currentChat = messagesStorage.getChat(chatId);
                    countDownLatch.countDown();
                });
                try {
                    countDownLatch.await();
                } catch (Exception e) {
                    FileLog.e(e);
                }
                if (currentChat != null) {
                    getMessagesController().putChat(currentChat, true);
                } else {
                    return false;
                }
            }
            if (ChatObject.isMonoForum(currentChat)) {
                chatMode = MODE_SUGGESTIONS;
                isSubscriberSuggestions = !ChatObject.canManageMonoForum(currentAccount, currentChat);
            }
            dialog_id = -chatId;
            if (ChatObject.isChannel(currentChat)) {
                if (ChatObject.isNotInChat(currentChat) && !ChatObject.isMonoForum(currentChat) && !isThreadChat() && !isInScheduleMode()) {
                    waitingForGetDifference = true;
                    getMessagesController().startShortPoll(currentChat, classGuid, false, isGettingDifference -> {
                        waitingForGetDifference = isGettingDifference;
                        if (!waitingForGetDifference) {
                            firstLoadMessages();
                        }
                    });
                } else {
                    getMessagesController().startShortPoll(currentChat, classGuid, false);
                }
            }
        } else if (userId != 0) {
            currentUser = getMessagesController().getUser(userId);
            if (currentUser == null) {
                final MessagesStorage messagesStorage = getMessagesStorage();
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                messagesStorage.getStorageQueue().postRunnable(() -> {
                    currentUser = messagesStorage.getUser(userId);
                    countDownLatch.countDown();
                });
                try {
                    countDownLatch.await();
                } catch (Exception e) {
                    FileLog.e(e);
                }
                if (currentUser != null) {
                    getMessagesController().putUser(currentUser, true);
                } else {
                    return false;
                }
            }
            dialog_id = userId;
            botUser = arguments.getString("botUser");
            if (inlineQuery != null) {
                getMessagesController().sendBotStart(currentUser, inlineQuery);
            } else if (premiumInvoiceBot && !TextUtils.isEmpty(botUser)) {
                getMessagesController().sendBotStart(currentUser, botUser);

                botUser = null;
                premiumInvoiceBot = false;
            }
            hasQuickReplies = false;
            if (currentUser != null && chatMode == 0 && !currentUser.bot) {
                QuickRepliesController.getInstance(currentAccount).load();
//                hasQuickReplies = QuickRepliesController.getInstance(currentAccount).hasReplies();
            }
        } else if (encId != 0) {
            currentEncryptedChat = getMessagesController().getEncryptedChat(encId);
            final MessagesStorage messagesStorage = getMessagesStorage();
            if (currentEncryptedChat == null) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                messagesStorage.getStorageQueue().postRunnable(() -> {
                    currentEncryptedChat = messagesStorage.getEncryptedChat(encId);
                    countDownLatch.countDown();
                });
                try {
                    countDownLatch.await();
                } catch (Exception e) {
                    FileLog.e(e);
                }
                if (currentEncryptedChat != null) {
                    getMessagesController().putEncryptedChat(currentEncryptedChat, true);
                } else {
                    return false;
                }
            }
            currentUser = getMessagesController().getUser(currentEncryptedChat.user_id);
            if (currentUser == null) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                messagesStorage.getStorageQueue().postRunnable(() -> {
                    currentUser = messagesStorage.getUser(currentEncryptedChat.user_id);
                    countDownLatch.countDown();
                });
                try {
                    countDownLatch.await();
                } catch (Exception e) {
                    FileLog.e(e);
                }
                if (currentUser != null) {
                    getMessagesController().putUser(currentUser, true);
                } else {
                    return false;
                }
            }
            dialog_id = DialogObject.makeEncryptedDialogId(encId);
            maxMessageId[0] = maxMessageId[1] = Integer.MIN_VALUE;
            minMessageId[0] = minMessageId[1] = Integer.MAX_VALUE;
        } else if (chatMode == MODE_EDIT_BUSINESS_LINK) {
            String businessLinkArgument = arguments.getString("business_link");
            if (businessLinkArgument == null) {
                return false;
            }
            businessLink = BusinessLinksController.getInstance(currentAccount).findLink(businessLinkArgument);
            if (businessLink == null) {
                return false;
            }
            forceEmptyHistory();
        } else if (chatMode == MODE_SEARCH) {
            searchType = arguments.getInt("searchType", 0);
            searchingHashtag = arguments.getString("searchHashtag", null);
            searchingQuery = searchingHashtag;
            if (searchType == 0 || searchingHashtag == null) {
                return false;
            }
        } else {
            return false;
        }

        dialog_id_Long = dialog_id;

        transitionAnimationGlobalIndex = NotificationCenter.getGlobalInstance().setAnimationInProgress(transitionAnimationGlobalIndex, new int[0]);

        if (currentUser != null && Build.VERSION.SDK_INT < 23) {
            MediaController.getInstance().startMediaObserver();
        }

        getNotificationCenter().addPostponeNotificationsCallback(postponeNotificationsWhileLoadingCallback);

        if (chatMode != MODE_SCHEDULED) {
            if (threadMessageId == 0) {
                getNotificationCenter().addObserver(this, NotificationCenter.screenshotTook);
                getNotificationCenter().addObserver(this, NotificationCenter.encryptedChatUpdated);
                getNotificationCenter().addObserver(this, NotificationCenter.messagesReadEncrypted);
                getNotificationCenter().addObserver(this, NotificationCenter.updateMentionsCount);
                getNotificationCenter().addObserver(this, NotificationCenter.newDraftReceived);
                getNotificationCenter().addObserver(this, NotificationCenter.chatOnlineCountDidLoad);
                getNotificationCenter().addObserver(this, NotificationCenter.peerSettingsDidLoad);
                getNotificationCenter().addObserver(this, NotificationCenter.didLoadPinnedMessages);
                getNotificationCenter().addObserver(this, NotificationCenter.commentsRead);
                getNotificationCenter().addObserver(this, NotificationCenter.changeRepliesCounter);
                getNotificationCenter().addObserver(this, NotificationCenter.messagesRead);
                getNotificationCenter().addObserver(this, NotificationCenter.didLoadChatInviter);
                getNotificationCenter().addObserver(this, NotificationCenter.groupCallUpdated);
            } else {
                getNotificationCenter().addObserver(this, NotificationCenter.threadMessagesRead);
                if (isTopic) {
                    getNotificationCenter().addObserver(this, NotificationCenter.updateMentionsCount);
                    getNotificationCenter().addObserver(this, NotificationCenter.didLoadPinnedMessages);
                }
            }
            getNotificationCenter().addObserver(this, NotificationCenter.monoForumMessagesRead);
            getNotificationCenter().addObserver(this, NotificationCenter.botKeyboardDidLoad);
            getNotificationCenter().addObserver(this, NotificationCenter.removeAllMessagesFromDialog);
            getNotificationCenter().addObserver(this, NotificationCenter.messagesReadContent);
            getNotificationCenter().addObserver(this, NotificationCenter.chatSearchResultsAvailable);
            getNotificationCenter().addObserver(this, NotificationCenter.chatSearchResultsLoading);
            getNotificationCenter().addObserver(this, NotificationCenter.didUpdateMessagesViews);
            getNotificationCenter().addObserver(this, NotificationCenter.didUpdatePollResults);
            getNotificationCenter().addObserver(this, NotificationCenter.availableEffectsUpdate);
            getNotificationCenter().addObserver(this, NotificationCenter.starReactionAnonymousUpdate);
            if (currentEncryptedChat != null) {
                getNotificationCenter().addObserver(this, NotificationCenter.didVerifyMessagesStickers);
            }
        }
        getNotificationCenter().addObserver(this, NotificationCenter.premiumFloodWaitReceived);
        getNotificationCenter().addObserver(this, NotificationCenter.messagesDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.loadingMessagesFailed);
        NotificationCenter.getGlobalInstance().addObserver(this, NotificationCenter.emojiLoaded);
        NotificationCenter.getGlobalInstance().addObserver(this, NotificationCenter.invalidateMotionBackground);
        getNotificationCenter().addObserver(this, NotificationCenter.didUpdateConnectionState);
        getNotificationCenter().addObserver(this, NotificationCenter.updateInterfaces);
        getNotificationCenter().addObserver(this, NotificationCenter.updateDefaultSendAsPeer);
        getNotificationCenter().addObserver(this, NotificationCenter.userIsPremiumBlockedUpadted);
        if (chatMode != MODE_PINNED) {
            getNotificationCenter().addObserver(this, NotificationCenter.didReceiveNewMessages);
        }
        if (chatMode == 0) {
            getNotificationCenter().addObserver(this, NotificationCenter.didLoadSponsoredMessages);
        }
        getNotificationCenter().addObserver(this, NotificationCenter.didLoadSendAsPeers);
        getNotificationCenter().addObserver(this, NotificationCenter.closeChats);
        getNotificationCenter().addObserver(this, NotificationCenter.closeChatActivity);
        getNotificationCenter().addObserver(this, NotificationCenter.messagesDeleted);
        getNotificationCenter().addObserver(this, NotificationCenter.historyCleared);
        getNotificationCenter().addObserver(this, NotificationCenter.messageReceivedByServer);
        getNotificationCenter().addObserver(this, NotificationCenter.messageReceivedByAck);
        getNotificationCenter().addObserver(this, NotificationCenter.messageSendError);
        getNotificationCenter().addObserver(this, NotificationCenter.chatInfoDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.groupRestrictionsUnlockedByBoosts);
        getNotificationCenter().addObserver(this, NotificationCenter.customStickerCreated);
        getNotificationCenter().addObserver(this, NotificationCenter.contactsDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.messagePlayingProgressDidChanged);
        getNotificationCenter().addObserver(this, NotificationCenter.messagePlayingDidReset);
        getNotificationCenter().addObserver(this, NotificationCenter.messagePlayingGoingToStop);
        getNotificationCenter().addObserver(this, NotificationCenter.messagePlayingPlayStateChanged);
        getNotificationCenter().addObserver(this, NotificationCenter.blockedUsersDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.fileNewChunkAvailable);
        getNotificationCenter().addObserver(this, NotificationCenter.didCreatedNewDeleteTask);
        getNotificationCenter().addObserver(this, NotificationCenter.messagePlayingDidStart);
        getNotificationCenter().addObserver(this, NotificationCenter.updateMessageMedia);
        getNotificationCenter().addObserver(this, NotificationCenter.voiceTranscriptionUpdate);
        getNotificationCenter().addObserver(this, NotificationCenter.animatedEmojiDocumentLoaded);
        getNotificationCenter().addObserver(this, NotificationCenter.replaceMessagesObjects);
        getNotificationCenter().addObserver(this, NotificationCenter.notificationsSettingsUpdated);
        getNotificationCenter().addObserver(this, NotificationCenter.replyMessagesDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.didReceivedWebpages);
        getNotificationCenter().addObserver(this, NotificationCenter.didReceivedWebpagesInUpdates);
        getNotificationCenter().addObserver(this, NotificationCenter.botInfoDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.chatInfoCantLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.userInfoDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.pinnedInfoDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.topicsDidLoaded);
        getNotificationCenter().addObserver(this, NotificationCenter.chatWasBoostedByUser);
        NotificationCenter.getGlobalInstance().addObserver(this, NotificationCenter.didSetNewWallpapper);
        NotificationCenter.getGlobalInstance().addObserver(this, NotificationCenter.didApplyNewTheme);
        NotificationCenter.getGlobalInstance().addObserver(this, NotificationCenter.goingToPreviewTheme);
        getNotificationCenter().addObserver(this, NotificationCenter.channelRightsUpdated);
        getNotificationCenter().addObserver(this, NotificationCenter.audioRecordTooShort);
        getNotificationCenter().addObserver(this, NotificationCenter.didUpdateReactions);
        getNotificationCenter().addObserver(this, NotificationCenter.savedReactionTagsUpdate);
        getNotificationCenter().addObserver(this, NotificationCenter.updateAllMessages);
        getNotificationCenter().addObserver(this, NotificationCenter.didUpdateExtendedMedia);
        getNotificationCenter().addObserver(this, NotificationCenter.videoLoadingStateChanged);
        getNotificationCenter().addObserver(this, NotificationCenter.scheduledMessagesUpdated);
        getNotificationCenter().addObserver(this, NotificationCenter.diceStickersDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.dialogDeleted);
        getNotificationCenter().addObserver(this, NotificationCenter.chatAvailableReactionsUpdated);
        getNotificationCenter().addObserver(this, NotificationCenter.dialogsUnreadReactionsCounterChanged);
        getNotificationCenter().addObserver(this, NotificationCenter.groupStickersDidLoad);
        getNotificationCenter().addObserver(this, NotificationCenter.dialogTranslate);
        getNotificationCenter().addObserver(this, NotificationCenter.dialogIsTranslatable);
        getNotificationCenter().addObserver(this, NotificationCenter.messageTranslated);
        getNotificationCenter().addObserver(this, NotificationCenter.messageTranslating);
        getNotificationCenter().addObserver(this, NotificationCenter.onReceivedChannelDifference);
        getNotificationCenter().addObserver(this, NotificationCenter.storiesUpdated);
        getNotificationCenter().addObserver(this, NotificationCenter.channelRecommendationsLoaded);
        getNotificationCenter().addObserver(this, NotificationCenter.updateTranscriptionLock);
        getNotificationCenter().addObserver(this, NotificationCenter.savedMessagesDialogsUpdate);
        getNotificationCenter().addObserver(this, NotificationCenter.quickRepliesDeleted);
        getNotificationCenter().addObserver(this, NotificationCenter.quickRepliesUpdated);
        getNotificationCenter().addObserver(this, NotificationCenter.factCheckLoaded);
        getNotificationCenter().addObserver(this, NotificationCenter.messagesFeeUpdated);
        getNotificationCenter().addObserver(this, NotificationCenter.starBalanceUpdated);
        getNotificationCenter().addObserver(this, NotificationCenter.botForumTopicDidCreate);
        getNotificationCenter().addObserver(this, NotificationCenter.botForumDraftUpdate);
        getNotificationCenter().addObserver(this, NotificationCenter.botForumDraftDelete);
        if (chatMode == MODE_EDIT_BUSINESS_LINK) {
            getNotificationCenter().addObserver(this, NotificationCenter.businessLinksUpdated);
        }
        if (chatMode == MODE_SEARCH) {
            getNotificationCenter().addObserver(this, NotificationCenter.hashtagSearchUpdated);
        }

        if (actionBarSearchTags != null) {
            actionBarSearchTags.attach();
        }

        super.onFragmentCreate();

        if (chatMode == MODE_PINNED) {
            ArrayList<MessageObject> messageObjects = new ArrayList<>();
            for (int a = 0, N = pinnedMessageIds.size(); a < N; a++) {
                Integer id = pinnedMessageIds.get(a);
                MessageObject object = pinnedMessageObjects.get(id);
                if (object != null) {
                    MessageObject o = new MessageObject(object.currentAccount, object.messageOwner, true, false);
                    o.replyMessageObject = object.replyMessageObject;
                    o.mediaExists = object.mediaExists;
                    o.attachPathExists = object.attachPathExists;
                    messageObjects.add(o);
                }
            }
            int loadIndex = lastLoadIndex++;
            waitingForLoad.add(loadIndex);
            getNotificationCenter().postNotificationName(NotificationCenter.messagesDidLoad, dialog_id, messageObjects.size(), messageObjects, false, 0, last_message_id, 0, 0, 2, true, classGuid, loadIndex, pinnedMessageIds.get(0), 0, MODE_PINNED);
        } else if (!forceHistoryEmpty) {
            loading = true;
        }
        if (isThreadChat() && !isTopic) {
            if (highlightMessageId == startLoadFromMessageId) {
                needSelectFromMessageId = true;
            }
        } else {
            getMessagesController().setLastCreatedDialogId(dialog_id, chatMode == MODE_SCHEDULED, true);
            if (chatMode == 0 || chatMode == MODE_SAVED) {
                if (currentEncryptedChat == null) {
                    getMediaDataController().loadBotKeyboard(MessagesStorage.TopicKey.of(dialog_id, getTopicId()));
                }
                getMessagesController().loadPeerSettings(currentUser, currentChat);

                if (startLoadFromMessageId == 0) {
                    SharedPreferences sharedPreferences = MessagesController.getNotificationsSettings(currentAccount);
                    int messageId = sharedPreferences.getInt("diditem" + NotificationsController.getSharedPrefKey(dialog_id, getTopicId()), 0);
                    if (messageId != 0) {
                        wasManualScroll = true;
                        loadingFromOldPosition = true;
                        startLoadFromMessageOffset = sharedPreferences.getInt("diditemo" + NotificationsController.getSharedPrefKey(dialog_id, getTopicId()), 0);
                        startLoadFromMessageId = messageId;
                    }
                } else {
                    showScrollToMessageError = true;
                    needSelectFromMessageId = true;
                }
            }
        }

        loadInfo = false;
        if (currentChat != null) {
            chatInfo = getMessagesController().getChatFull(currentChat.id);
            groupCall = getMessagesController().getGroupCall(currentChat.id, true);
            if (ChatObject.isChannel(currentChat) && !getMessagesController().isChannelAdminsLoaded(currentChat.id) && !ChatObject.isMonoForum(currentChat)) {
                getMessagesController().loadChannelAdmins(currentChat.id, true);
            }
            fillInviterId(false);
            if (chatMode != MODE_PINNED) {
                getMessagesStorage().loadChatInfo(currentChat.id, ChatObject.isChannel(currentChat), null, true, false, startLoadFromMessageId);
            }
            if (chatMode == 0 && chatInfo != null && ChatObject.isChannel(currentChat) && chatInfo.migrated_from_chat_id != 0 && !isThreadChat()) {
                mergeDialogId = -chatInfo.migrated_from_chat_id;
                maxMessageId[1] = chatInfo.migrated_from_max_id;
            }
            loadInfo = chatInfo == null;
            checkGroupCallJoin(false);
            gotChatInfo();
        } else if (currentUser != null) {
            if (chatMode != MODE_PINNED) {
                getMessagesController().loadUserInfo(currentUser, true, classGuid, startLoadFromMessageId);
            }
            loadInfo = userInfo == null;
        }

        if (forceHistoryEmpty) {
            endReached[0] = endReached[1] = true;
            forwardEndReached[0] = forwardEndReached[1] = true;
            firstLoading = false;
            loading = false;
            checkDispatchHideSkeletons(false);
        }
        if (chatMode != MODE_PINNED && !forceHistoryEmpty) {
            if (SharedConfig.deviceIsHigh()) {
                initialMessagesSize = (isThreadChat() && !isTopic) ? 30 : 25;
            } else {
                initialMessagesSize = (isThreadChat() && !isTopic) ? 20 : 15;
            }
            if (!waitingForGetDifference) {
                firstLoadMessages();
            }
        }

        if (chatMode == 0) {
            if (userId != 0 && currentUser.bot) {
                AndroidUtilities.runOnUIThread(()-> getMediaDataController().loadBotInfo(userId, userId, true, classGuid));
            } else if (chatInfo instanceof TLRPC.TL_chatFull) {
                for (int a = 0; a < chatInfo.participants.participants.size(); a++) {
                    TLRPC.ChatParticipant participant = chatInfo.participants.participants.get(a);
                    TLRPC.User user = getMessagesController().getUser(participant.user_id);
                    if (user != null && user.bot) {
                        getMediaDataController().loadBotInfo(user.id, -chatInfo.id, true, classGuid);
                    }
                }
            }
            if (AndroidUtilities.isTablet() && !isComments) {
                getNotificationCenter().postNotificationName(NotificationCenter.openedChatChanged, dialog_id, getTopicId(), false);
            }

            if (currentUser != null && !UserObject.isReplyUser(currentUser)) {
                userBlocked = getMessagesController().blockePeers.indexOfKey(currentUser.id) >= 0;
            }

            if (currentEncryptedChat != null && AndroidUtilities.getMyLayerVersion(currentEncryptedChat.layer) != SecretChatHelper.CURRENT_SECRET_CHAT_LAYER) {
                getSecretChatHelper().sendNotifyLayerMessage(currentEncryptedChat, null);
            }
        }
        if (chatInfo != null && chatInfo.linked_chat_id != 0) {
            TLRPC.Chat chat = getMessagesController().getChat(chatInfo.linked_chat_id);
            if (chat != null && chat.megagroup) {
                getMessagesController().startShortPoll(chat, classGuid, false, null);
            }
        }

        if (currentUser != null) {
            TLRPC.UserFull userFull = getMessagesController().getUserFull(currentUser.id);
            if (userFull != null && userFull.theme != null) {
                ChatThemeController.getInstance(currentAccount).putThemeIfNeeded(userFull.theme);
            }
        }


        themeDelegate = parentThemeDelegate != null ? parentThemeDelegate : new ThemeDelegate();
        if (themeDelegate.isThemeChangeAvailable(false)) {
            NotificationCenter.getGlobalInstance().addObserver(this, NotificationCenter.needSetDayNightTheme);
        }

        if (chatInvite != null) {
            int timeout = chatInvite.expires - getConnectionsManager().getCurrentTime();
            if (timeout < 0) {
                timeout = 10;
            }
            AndroidUtilities.runOnUIThread(chatInviteRunnable = () -> {
                chatInviteRunnable = null;
                if (getParentActivity() == null) {
                    return;
                }
                AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                if (ChatObject.isChannel(currentChat) && !currentChat.megagroup) {
                    builder.setMessage(getString(R.string.JoinByPeekChannelText));
                    builder.setTitle(getString(R.string.JoinByPeekChannelTitle));
                } else {
                    builder.setMessage(getString(R.string.JoinByPeekGroupText));
                    builder.setTitle(getString(R.string.JoinByPeekGroupTitle));
                }
                builder.setPositiveButton(getString(R.string.JoinByPeekJoin), (dialogInterface, i) -> {
                    if (bottomOverlayChatText != null) {
                        bottomOverlayChatText.callOnClick();
                    }
                });
                builder.setNegativeButton(LocaleController.getString(R.string.Cancel), (dialogInterface, i) -> finishFragment());
                showDialog(builder.create());
            }, timeout * 1000L);
        }

        if (ChatObject.isMonoForum(currentChat)) {
            // reload balance if needed
            StarsController.getTonInstance(currentAccount).canUseTon();
        }

        if (isTopic || getMessagesController().isMonoForumWithManageRights(dialog_id) && getTopicId() != 0) {
            getMessagesController().getTopicsController().getTopicRepliesCount(dialog_id, getTopicId());
        }
        if (chatMode != MODE_EDIT_BUSINESS_LINK) {
            getMessagesController().getSavedMessagesController().preloadDialogs(false);
        }
        if (chatMode == MODE_SAVED) {
            getMessagesController().getSavedMessagesController().checkSavedDialogCount(getTopicId());
        }

        return true;
    }

    protected void updateSearchingHashtag(String hashtag) {
        if (chatMode != MODE_SEARCH) {
            return;
        }
        if (!TextUtils.equals(searchingHashtag, hashtag)) {
            showMessagesSearchListView(true);
            searchingHashtag = hashtag;
            searchingQuery = searchingHashtag;
            checkHashtagStories(false);
            clearChatData(true);
            startMessageAppearTransitionMs = 0;
            firstMessagesLoaded = false;
            HashtagSearchController.getInstance(currentAccount).clearSearchResults(searchType);
            messagesSearchAdapter.notifyDataSetChanged();
            messagesSearchListView.requestLayout();
            if (messagesSearchListView.getLayoutManager() != null) {
                messagesSearchListView.getLayoutManager().scrollToPosition(0);
            }
            updateSearchListEmptyView();
            hashtagSearchEmptyView.showProgress(true);
            firstLoadMessages();
        }
    }

    public void resetForReload() {
        getConnectionsManager().cancelRequestsForGuid(classGuid);
        getMessagesStorage().cancelTasksForGuid(classGuid);
        classGuid = ConnectionsManager.generateClassGuid();

        startLoadFromMessageId = 0;
        firstMessagesLoaded = false;
        clearOnLoad = true;
        waitingForLoad.clear();
    }

    public void savePositionForTopicChange(long intoTopic) {
        if (chatListView == null || chatLayoutManager == null || chatLayoutManager.hasPendingScrollPosition()) {
            clearOnLoadAndScrollMessageId = -1;
            return;
        }
        int centerY = 0;//(chatListView.getHeight() / 2) - chatListView.getPaddingBottom() - chatListView.getPaddingTop();
        int top = 0;
        int messageId = -1;
        int bestDistance = Integer.MAX_VALUE;
        for (int i = chatListView.getChildCount() - 1; i >= 0; i--) {
            final View v = chatListView.getChildAt(i);
            final int vposition = chatListView.getChildAdapterPosition(v);
            if (vposition < 0) continue;
            if (v instanceof ChatMessageCell) {
                final MessageObject messageObject = ((ChatMessageCell) v).getMessageObject();
                if (messageObject == null || messageObject.getTopicId() != intoTopic)
                    continue;
                final int thisTop = getScrollingOffsetForView(v);
                final int distance = Math.abs(thisTop + centerY);
                if (distance < bestDistance) {
                    messageId = messageObject.getId();
                    top = thisTop;
                    bestDistance = distance;
                }
            }
        }
        clearOnLoadAndScrollMessageId = messageId;
        clearOnLoadAndScrollOffset = top;
    }

    public void firstLoadMessages() {
        if (firstMessagesLoaded) {
            return;
        }
        firstMessagesLoaded = true;
        final Runnable load = () -> {
            waitingForLoad.add(lastLoadIndex);
            if (chatMode == MODE_SEARCH) {
                HashtagSearchController.getInstance(currentAccount).searchHashtag(searchingHashtag, classGuid, searchType, lastLoadIndex++);
            } else if (startLoadFromDate != 0) {
                getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 30, 0, startLoadFromDate, true, 0, classGuid, 4, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
            } else if (startLoadFromMessageId != 0 && (!isThreadChat() || startLoadFromMessageId == highlightMessageId || isTopic)) {
                startLoadFromMessageIdSaved = startLoadFromMessageId;
                if (migrated_to != 0) {
                    mergeDialogId = migrated_to;
                    getMessagesController().loadMessages(mergeDialogId, 0, loadInfo, initialMessagesSize, startLoadFromMessageId, 0, true, 0, classGuid, MessagesController.LOAD_AROUND_MESSAGE, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                } else {
                    getMessagesController().loadMessages(dialog_id, mergeDialogId, loadInfo, initialMessagesSize, startLoadFromMessageId, 0, true, 0, classGuid, MessagesController.LOAD_AROUND_MESSAGE, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                }
            } else {
                if (historyPreloaded) {
                    lastLoadIndex++;
                } else {
                    getMessagesController().loadMessages(dialog_id, mergeDialogId, loadInfo, initialMessagesSize, startLoadFromMessageId, 0, true, 0, classGuid, 2, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                }
            }
            if ((chatMode == 0 || chatMode == MODE_SAVED && getSavedDialogId() == getUserConfig().getClientUserId()) && (!isThreadChat() || isTopic)) {
                waitingForLoad.add(lastLoadIndex);
                getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 1, 0, 0, true, 0, classGuid, 2, 0, MODE_SCHEDULED, chatMode == MODE_SAVED ? 0 : threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
            }
        };
        getMessagesController().checkSensitive(this, dialog_id, load, this::finishFragment);
    }

    private void fillInviterId(boolean load) {
        if (currentChat == null || chatInfo == null || ChatObject.isNotInChat(currentChat) || currentChat.creator) {
            return;
        }
        if (chatInfo.inviterId != 0) {
            chatInviterId = chatInfo.inviterId;
            return;
        }
        if (chatInfo.participants != null) {
            if (chatInfo.participants.self_participant != null) {
                chatInviterId = chatInfo.participants.self_participant.inviter_id;
                return;
            }
            long selfId = getUserConfig().getClientUserId();
            for (int a = 0, N = chatInfo.participants.participants.size(); a < N; a++) {
                TLRPC.ChatParticipant participant = chatInfo.participants.participants.get(a);
                if (participant.user_id == selfId) {
                    chatInviterId = participant.inviter_id;
                    return;
                }
            }
        }
        if (load && chatInviterId == 0) {
            getMessagesController().checkChatInviter(currentChat.id, false);
        }
    }

    private void hideUndoViews() {
        if (undoView != null) {
            undoView.hide(true, 0);
        }
        if (pinBulletin != null) {
            pinBulletin.hide(false, 0);
        }
        if (topUndoView != null) {
            topUndoView.hide(true, 0);
        }
    }

    public int getOtherSameChatsDiff() {
        if (parentLayout == null || parentLayout.getFragmentStack() == null) {
            return 0;
        }
        int cur = parentLayout.getFragmentStack().indexOf(this);
        if (cur == -1) {
            cur = parentLayout.getFragmentStack().size();
        }
        int i = cur;
        for (int a = 0; a < parentLayout.getFragmentStack().size(); a++) {
            BaseFragment fragment = parentLayout.getFragmentStack().get(a);
            if (fragment != this && fragment instanceof ChatActivity) {
                ChatActivity chatActivity = (ChatActivity) fragment;
                if (chatActivity.dialog_id == dialog_id) {
                    i = a;
                    break;
                }
            }
        }
        return i - cur;
    }

    @Override
    public void onBeginSlide() {
        super.onBeginSlide();

        if (selectionReactionsOverlay != null && selectionReactionsOverlay.isVisible()) {
            selectionReactionsOverlay.setHiddenByScroll(true);
        }
    }

    @Override
    public void onFragmentDestroy() {
        super.onFragmentDestroy();
        if (chatActivityEnterView != null) {
            chatActivityEnterView.onDestroy();
        }
        if (avatarContainer != null) {
            avatarContainer.onDestroy();
        }
        if (mentionContainer != null && mentionContainer.getAdapter() != null) {
            mentionContainer.getAdapter().onDestroy();
        }
        if (chatAttachAlert != null) {
            chatAttachAlert.dismissInternal();
        }
        ContentPreviewViewer.getInstance().clearDelegate(contentPreviewViewerDelegate);
        getNotificationCenter().onAnimationFinish(transitionAnimationIndex);
        NotificationCenter.getGlobalInstance().onAnimationFinish(transitionAnimationGlobalIndex);
        getNotificationCenter().onAnimationFinish(scrollAnimationIndex);
        getNotificationCenter().onAnimationFinish(scrollCallbackAnimationIndex);
        hideUndoViews();
        if (chatInviteRunnable != null) {
            AndroidUtilities.cancelRunOnUIThread(chatInviteRunnable);
            chatInviteRunnable = null;
        }
        getNotificationCenter().removePostponeNotificationsCallback(postponeNotificationsWhileLoadingCallback);
        getMessagesController().setLastCreatedDialogId(dialog_id, chatMode == MODE_SCHEDULED, false);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagesDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.loadingMessagesFailed);
        getNotificationCenter().removeObserver(this, NotificationCenter.premiumFloodWaitReceived);
        NotificationCenter.getGlobalInstance().removeObserver(this, NotificationCenter.emojiLoaded);
        NotificationCenter.getGlobalInstance().removeObserver(this, NotificationCenter.invalidateMotionBackground);
        getNotificationCenter().removeObserver(this, NotificationCenter.didUpdateConnectionState);
        getNotificationCenter().removeObserver(this, NotificationCenter.updateInterfaces);
        getNotificationCenter().removeObserver(this, NotificationCenter.updateDefaultSendAsPeer);
        getNotificationCenter().removeObserver(this, NotificationCenter.userIsPremiumBlockedUpadted);
        getNotificationCenter().removeObserver(this, NotificationCenter.didReceiveNewMessages);
        getNotificationCenter().removeObserver(this, NotificationCenter.closeChats);
        getNotificationCenter().removeObserver(this, NotificationCenter.closeChatActivity);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagesRead);
        getNotificationCenter().removeObserver(this, NotificationCenter.threadMessagesRead);
        getNotificationCenter().removeObserver(this, NotificationCenter.monoForumMessagesRead);
        getNotificationCenter().removeObserver(this, NotificationCenter.commentsRead);
        getNotificationCenter().removeObserver(this, NotificationCenter.changeRepliesCounter);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagesDeleted);
        getNotificationCenter().removeObserver(this, NotificationCenter.historyCleared);
        getNotificationCenter().removeObserver(this, NotificationCenter.messageReceivedByServer);
        getNotificationCenter().removeObserver(this, NotificationCenter.messageReceivedByAck);
        getNotificationCenter().removeObserver(this, NotificationCenter.messageSendError);
        getNotificationCenter().removeObserver(this, NotificationCenter.chatInfoDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.groupRestrictionsUnlockedByBoosts);
        getNotificationCenter().removeObserver(this, NotificationCenter.customStickerCreated);
        getNotificationCenter().removeObserver(this, NotificationCenter.didLoadChatInviter);
        getNotificationCenter().removeObserver(this, NotificationCenter.groupCallUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.encryptedChatUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagesReadEncrypted);
        getNotificationCenter().removeObserver(this, NotificationCenter.removeAllMessagesFromDialog);
        getNotificationCenter().removeObserver(this, NotificationCenter.contactsDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagePlayingProgressDidChanged);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagePlayingDidReset);
        getNotificationCenter().removeObserver(this, NotificationCenter.screenshotTook);
        getNotificationCenter().removeObserver(this, NotificationCenter.blockedUsersDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.fileNewChunkAvailable);
        getNotificationCenter().removeObserver(this, NotificationCenter.didCreatedNewDeleteTask);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagePlayingDidStart);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagePlayingGoingToStop);
        getNotificationCenter().removeObserver(this, NotificationCenter.updateMessageMedia);
        getNotificationCenter().removeObserver(this, NotificationCenter.voiceTranscriptionUpdate);
        getNotificationCenter().removeObserver(this, NotificationCenter.animatedEmojiDocumentLoaded);
        getNotificationCenter().removeObserver(this, NotificationCenter.replaceMessagesObjects);
        getNotificationCenter().removeObserver(this, NotificationCenter.notificationsSettingsUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.replyMessagesDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.didReceivedWebpages);
        getNotificationCenter().removeObserver(this, NotificationCenter.didReceivedWebpagesInUpdates);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagesReadContent);
        getNotificationCenter().removeObserver(this, NotificationCenter.botInfoDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.botKeyboardDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.chatSearchResultsAvailable);
        getNotificationCenter().removeObserver(this, NotificationCenter.chatSearchResultsLoading);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagePlayingPlayStateChanged);
        getNotificationCenter().removeObserver(this, NotificationCenter.didUpdateMessagesViews);
        getNotificationCenter().removeObserver(this, NotificationCenter.chatInfoCantLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.didLoadPinnedMessages);
        getNotificationCenter().removeObserver(this, NotificationCenter.peerSettingsDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.newDraftReceived);
        getNotificationCenter().removeObserver(this, NotificationCenter.userInfoDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.pinnedInfoDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.topicsDidLoaded);
        getNotificationCenter().removeObserver(this, NotificationCenter.chatWasBoostedByUser);
        NotificationCenter.getGlobalInstance().removeObserver(this, NotificationCenter.didSetNewWallpapper);
        NotificationCenter.getGlobalInstance().removeObserver(this, NotificationCenter.didApplyNewTheme);
        NotificationCenter.getGlobalInstance().removeObserver(this, NotificationCenter.goingToPreviewTheme);
        getNotificationCenter().removeObserver(this, NotificationCenter.channelRightsUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.updateMentionsCount);
        getNotificationCenter().removeObserver(this, NotificationCenter.audioRecordTooShort);
        getNotificationCenter().removeObserver(this, NotificationCenter.didUpdatePollResults);
        getNotificationCenter().removeObserver(this, NotificationCenter.didUpdateReactions);
        getNotificationCenter().removeObserver(this, NotificationCenter.savedReactionTagsUpdate);
        getNotificationCenter().removeObserver(this, NotificationCenter.updateAllMessages);
        getNotificationCenter().removeObserver(this, NotificationCenter.didUpdateExtendedMedia);
        getNotificationCenter().removeObserver(this, NotificationCenter.chatOnlineCountDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.videoLoadingStateChanged);
        getNotificationCenter().removeObserver(this, NotificationCenter.scheduledMessagesUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.diceStickersDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.dialogDeleted);
        getNotificationCenter().removeObserver(this, NotificationCenter.chatAvailableReactionsUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.didLoadSponsoredMessages);
        getNotificationCenter().removeObserver(this, NotificationCenter.didLoadSendAsPeers);
        getNotificationCenter().removeObserver(this, NotificationCenter.dialogsUnreadReactionsCounterChanged);
        getNotificationCenter().removeObserver(this, NotificationCenter.groupStickersDidLoad);
        getNotificationCenter().removeObserver(this, NotificationCenter.dialogTranslate);
        getNotificationCenter().removeObserver(this, NotificationCenter.dialogIsTranslatable);
        getNotificationCenter().removeObserver(this, NotificationCenter.messageTranslated);
        getNotificationCenter().removeObserver(this, NotificationCenter.messageTranslating);
        getNotificationCenter().removeObserver(this, NotificationCenter.onReceivedChannelDifference);
        getNotificationCenter().removeObserver(this, NotificationCenter.storiesUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.channelRecommendationsLoaded);
        getNotificationCenter().removeObserver(this, NotificationCenter.updateTranscriptionLock);
        getNotificationCenter().removeObserver(this, NotificationCenter.savedMessagesDialogsUpdate);
        getNotificationCenter().removeObserver(this, NotificationCenter.quickRepliesDeleted);
        getNotificationCenter().removeObserver(this, NotificationCenter.quickRepliesUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.availableEffectsUpdate);
        getNotificationCenter().removeObserver(this, NotificationCenter.starReactionAnonymousUpdate);
        getNotificationCenter().removeObserver(this, NotificationCenter.factCheckLoaded);
        getNotificationCenter().removeObserver(this, NotificationCenter.messagesFeeUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.starBalanceUpdated);
        getNotificationCenter().removeObserver(this, NotificationCenter.botForumTopicDidCreate);
        getNotificationCenter().removeObserver(this, NotificationCenter.botForumDraftUpdate);
        getNotificationCenter().removeObserver(this, NotificationCenter.botForumDraftDelete);
        if (chatMode == MODE_EDIT_BUSINESS_LINK) {
            getNotificationCenter().removeObserver(this, NotificationCenter.businessLinksUpdated);
        }
        if (chatMode == MODE_SEARCH) {
            getNotificationCenter().removeObserver(this, NotificationCenter.hashtagSearchUpdated);
        }

        if (actionBarSearchTags != null) {
            actionBarSearchTags.detach();
        }
        if (currentEncryptedChat != null) {
            getNotificationCenter().removeObserver(this, NotificationCenter.didVerifyMessagesStickers);
        }
        NotificationCenter.getGlobalInstance().removeObserver(this, NotificationCenter.needSetDayNightTheme);

        if (chatMode == 0 && AndroidUtilities.isTablet()) {
            getNotificationCenter().postNotificationName(NotificationCenter.openedChatChanged, dialog_id, getTopicId(), true);
        }
        if (currentUser != null) {
            MediaController.getInstance().stopMediaObserver();
        }

        if (flagSecure != null) {
            flagSecure.detach();
        }
        if (currentUser != null) {
            getMessagesController().cancelLoadFullUser(currentUser.id);
        }
        AndroidUtilities.removeAdjustResize(getParentActivity(), classGuid);
        if (chatAttachAlert != null) {
            chatAttachAlert.onDestroy();
        }
        AndroidUtilities.unlockOrientation(getParentActivity());
        if (ChatObject.isChannel(currentChat)) {
            getMessagesController().startShortPoll(currentChat, classGuid, true);
            if (chatInfo != null && chatInfo.linked_chat_id != 0) {
                TLRPC.Chat chat = getMessagesController().getChat(chatInfo.linked_chat_id);
                getMessagesController().startShortPoll(chat, classGuid, true);
            }
        }
        if (textSelectionHelper != null) {
            textSelectionHelper.clear();
        }
        if (chatListItemAnimator != null) {
            chatListItemAnimator.onDestroy();
        }
        if (pinchToZoomHelper != null) {
            pinchToZoomHelper.clear();
        }
        chatThemeBottomSheet = null;

        INavigationLayout parentLayout = getParentLayout();
        if (parentLayout != null && parentLayout.getFragmentStack() != null) {
            BackButtonMenu.clearPulledDialogs(this, parentLayout.getFragmentStack().indexOf(this) - (replacingChatActivity ? 0 : 1));
        }
        replacingChatActivity = false;

        if (progressDialogCurrent != null) {
            progressDialogCurrent.cancel();
            progressDialogCurrent = null;
        }
        chatMessagesMetadataController.onFragmentDestroy();
        if (birthdayAssetsFetcher != null) {
            birthdayAssetsFetcher.detach(true);
            birthdayAssetsFetcher = null;
        }
        if (starReactionsOverlay != null) {
            starReactionsOverlay.setMessageCell(null);
            AndroidUtilities.removeFromParent(starReactionsOverlay);
            starReactionsOverlay = null;
        }
    }

    private static class ChatActivityTextSelectionHelper extends TextSelectionHelper.ChatListTextSelectionHelper {
        ChatActivity chatActivity;
        public void setChatActivity(ChatActivity chatActivity) {
            cancelAllAnimators();
            clear();
            textSelectionOverlay = null;
            this.chatActivity = chatActivity;
        }

        @Override
        public int getParentTopPadding() {
            return chatActivity == null ? 0 : (int) chatActivity.chatListViewPaddingTop;
        }

        @Override
        public int getParentBottomPadding() {
            return chatActivity == null ? 0 : chatActivity.blurredViewBottomOffset;
        }

        @Override
        protected int getThemedColor(int key) {
            return Theme.getColor(key, chatActivity.themeDelegate);
        }

        @Override
        protected Theme.ResourcesProvider getResourcesProvider() {
            if (chatActivity != null) {
                return chatActivity.themeDelegate;
            }
            return null;
        }

        @Override
        protected boolean canShowQuote() {
            if (chatActivity != null && chatActivity.getDialogId() == UserObject.VERIFY) {
                return false;
            }
            final boolean noforwards = (
                chatActivity != null && chatActivity.getMessagesController().isChatNoForwards(chatActivity.getCurrentChat()) ||
                selectedView != null && selectedView.getMessageObject() != null && selectedView.getMessageObject().messageOwner != null && selectedView.getMessageObject().messageOwner.noforwards
            );
            return !isFactCheck && (
                chatActivity != null && chatActivity.getCurrentEncryptedChat() == null &&
                (selectedView == null ||
                    selectedView.getMessageObject() != null && selectedView.getMessageObject().type != MessageObject.TYPE_STORY &&
                    !selectedView.getMessageObject().isVoiceTranscriptionOpen() && !selectedView.getMessageObject().isInvoice() &&
                    !chatActivity.textSelectionHelper.isDescription
                ) &&
                !chatActivity.getMessagesController().getTranslateController().isTranslatingDialog(chatActivity.dialog_id) &&
                !UserObject.isService(chatActivity.dialog_id) &&
                (!noforwards || (chatActivity.getCurrentChat() == null || ChatObject.canWriteToChat(chatActivity.getCurrentChat())))
            );
        }

        @Override
        protected boolean canCopy() {
            if (chatActivity != null && chatActivity.getDialogId() == UserObject.VERIFY) {
                return true;
            }
            return chatActivity == null || !(
                chatActivity.getDialogId() < 0 && chatActivity.getMessagesController().isChatNoForwards(-chatActivity.getDialogId()) ||
                selectedView != null && selectedView.getMessageObject() != null && (selectedView.getMessageObject().messageOwner != null && selectedView.getMessageObject().messageOwner.noforwards)
            );
        }

        @Override
        protected void onQuoteClick(MessageObject messageObject, int start, int end, CharSequence text) {
            if (messageObject == null) {
                return;
            }
            if (chatActivity != null) {
                end = Math.min(end, start + chatActivity.getMessagesController().quoteLengthMax);
                if (messageObject.getGroupId() != 0) {
                    MessageObject.GroupedMessages group = chatActivity.getGroup(messageObject.getGroupId());
                    if (group != null && !group.isDocuments) {
                        messageObject = group.captionMessage;
                    }
                }
                if (messageObject == null) {
                    return;
                }
                ReplyQuote quote = ReplyQuote.from(messageObject, start, end);
                if (quote.getText() == null) {
                    return;
                }
                if (chatActivity.chatActivityEnterView == null || chatActivity.chatActivityEnterView.getVisibility() != View.VISIBLE) {
                    chatActivity.replyingQuote = quote;
                    chatActivity.replyingMessageObject = messageObject;
                    chatActivity.forbidForwardingWithDismiss = false;
                    chatActivity.messagePreviewParams = new MessagePreviewParams(chatActivity.currentEncryptedChat != null, chatActivity.getMessagesController().isChatNoForwards(chatActivity.currentChat), ChatObject.isMonoForum(chatActivity.currentChat));
                    chatActivity.messagePreviewParams.updateReply(chatActivity.replyingMessageObject, chatActivity.getGroup(messageObject.getGroupId()), chatActivity.getDialogId(), chatActivity.replyingQuote);
                    Bundle args = new Bundle();
                    args.putBoolean("onlySelect", true);
                    args.putInt("dialogsType", DialogsActivity.DIALOGS_TYPE_FORWARD);
                    args.putBoolean("quote", true);
                    args.putInt("messagesCount", 1);
                    args.putBoolean("canSelectTopics", true);
                    DialogsActivity fragment = new DialogsActivity(args);
                    fragment.setDelegate(chatActivity);
                    chatActivity.presentFragment(fragment);
                } else {
                    if (chatActivity.actionBar != null && chatActivity.actionBar.isActionModeShowed()) {
                        chatActivity.clearSelectionMode();
                    }
                    chatActivity.showFieldPanelForReplyQuote(messageObject, quote);
                    if (chatActivity.chatActivityEnterView != null) {
                        chatActivity.chatActivityEnterView.openKeyboard();
                    }
                }
            }
        }
    }

    @Override
    public View createView(Context context) {
        Timer t = Timer.create("ChatActivity.createView");

        blurredBackgroundColorProvider = new BlurredBackgroundColorProviderThemed(themeDelegate, Theme.key_chat_messagePanelBackground);
        blurredBackgroundColorProviderWhite = new BlurredBackgroundColorProviderThemed(themeDelegate, Theme.key_windowBackgroundWhite);

        if (textSelectionHelper == null) {
            if (textSelectionHelpersCache != null && !textSelectionHelpersCache.isEmpty()) {
                textSelectionHelper = textSelectionHelpersCache.remove(0);
            } else {
                Timer.Task t1 = Timer.start(t, "new ChatActivityTextSelectionHelper");
                textSelectionHelper = new ChatActivityTextSelectionHelper();
                Timer.done(t1);
            }
            textSelectionHelper.setChatActivity(this);
        }

        if (isReport()) {
            actionBar.setBackgroundColor(getThemedColor(Theme.key_actionBarActionModeDefault));
            actionBar.setItemsColor(getThemedColor(Theme.key_actionBarActionModeDefaultIcon), false);
            actionBar.setItemsBackgroundColor(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), false);
            actionBar.setTitleColor(getThemedColor(Theme.key_actionBarActionModeDefaultIcon));
            actionBar.setSubtitleColor(getThemedColor(Theme.key_actionBarActionModeDefaultIcon));
        }
        if (isInsideContainer) {
            actionBar.setVisibility(View.GONE);
        }
        actionBarBackgroundPaint.setColor(getThemedColor(Theme.key_actionBarDefault));
        sharedResources = new ChatMessageSharedResources(context);

        ArrayList<ChatMessageCell> chatMessagesCache = chatMessageCellsCache.get(currentAccount);
        if (chatMessagesCache == null) {
            chatMessageCellsCache.put(currentAccount, chatMessagesCache = new ArrayList<>());
        }
        if (chatMessagesCache.size() < 10) {
            int n = 15 - chatMessagesCache.size();
            Timer.Task t2 = Timer.start(t, "create ChatMessageCell n=" + n);
            for (int a = 0; a < n; a++) {
                chatMessagesCache.add(new ChatMessageCell(context, currentAccount,true, sharedResources, themeDelegate));
            }
            Timer.done(t2);
        }
        for (int a = 1; a >= 0; a--) {
            selectedMessagesIds[a].clear();
            selectedMessagesCanCopyIds[a].clear();
            selectedMessagesCanStarIds[a].clear();
        }
        scheduledOrNoSoundHint = null;
        scheduledHint = null;
        infoTopView = null;
        aspectRatioFrameLayout = null;
        videoTextureView = null;
        mediaBanTooltip = null;
        noSoundHintView = null;
        forwardHintView = null;
        checksHintView = null;
        textSelectionHint = null;
        emojiButtonRed = null;
        gifHintTextView = null;
        emojiHintTextView = null;
        pollHintView = null;
        timerHintView = null;
        videoPlayerContainer = null;
        voiceHintTextView = null;
        blurredView = null;
        dummyMessageCell = null;
        cantDeleteMessagesCount = 0;
        canEditMessagesCount = 0;
        cantForwardMessagesCount = 0;
        canForwardMessagesCount = 0;
        cantSaveMessagesCount = 0;
        canSaveMusicCount = 0;
        canSaveDocumentsCount = 0;

        hasOwnBackground = true;
        if (chatAttachAlert != null) {
            try {
                if (chatAttachAlert.isShowing()) {
                    chatAttachAlert.dismiss();
                }
            } catch (Exception ignore) {

            }
            chatAttachAlert.onDestroy();
            chatAttachAlert = null;
        }

        Theme.createChatResources(context, false);

        actionBar.setAddToContainer(false);
        if (inPreviewMode) {
            actionBar.setBackButtonDrawable(null);
        } else {
            actionBar.setBackButtonDrawable(new BackDrawable(isReport()));
        }
        actionBar.setActionBarMenuOnItemClick(new ActionBar.ActionBarMenuOnItemClick() {
            @Override
            public void onItemClick(final int id) {
                if (id == -1) {
                    if (actionBar.isActionModeShowed()) {
                        clearSelectionMode();
                    } else {
                        if (chatMode == MODE_QUICK_REPLIES && (messages.isEmpty() || threadMessageId == 0)) {
                            showQuickRepliesRemoveAlert();
                            return;
                        }
                        if (chatMode == MODE_EDIT_BUSINESS_LINK && chatActivityEnterView.businessLinkHasChanges()) {
                            showBusinessLinksDiscardAlert(() -> {
                                finishFragment();
                            });
                            return;
                        }
                        if (!checkRecordLocked(true)) {
                            finishFragment();
                        }
                    }
                } else if (id == view_as_topics) {
                    if (getUserConfig().getClientUserId() == dialog_id) {
                        getMessagesController().setSavedViewAs(true);
                        avatarContainer.openProfile(false, true, true);
                    } else {
                        getMessagesController().getTopicsController().toggleViewForumAsMessages(-dialog_id, false);
                        TopicsFragment.prepareToSwitchAnimation(ChatActivity.this);
                    }
                } else if (id == copy) {
                    SpannableStringBuilder str = new SpannableStringBuilder();
                    long previousUid = 0;
                    for (int a = 1; a >= 0; a--) {
                        ArrayList<Integer> ids = new ArrayList<>();
                        for (int b = 0; b < selectedMessagesCanCopyIds[a].size(); b++) {
                            ids.add(selectedMessagesCanCopyIds[a].keyAt(b));
                        }
                        if (currentEncryptedChat == null) {
                            Collections.sort(ids);
                        } else {
                            Collections.sort(ids, Collections.reverseOrder());
                        }
                        for (int b = 0; b < ids.size(); b++) {
                            Integer messageId = ids.get(b);
                            MessageObject messageObject = selectedMessagesCanCopyIds[a].get(messageId);
                            if (str.length() != 0) {
                                str.append("\n\n");
                            }
                            str.append(getMessageContent(messageObject, previousUid, ids.size() != 1 && (currentUser == null || !currentUser.self)));
                            previousUid = messageObject.getFromChatId();
                        }
                    }
                    if (str.length() != 0) {
                        AndroidUtilities.addToClipboard(str);
                        createUndoView();
                        undoView.showWithAction(0, UndoView.ACTION_TEXT_COPIED, null);
                    }
                    clearSelectionMode();
                } else if (id == delete) {
                    if (getParentActivity() == null) {
                        return;
                    }
                    createDeleteMessagesAlert(null, null);
                } else if (id == select_between) {
                    // For selecting messages between the first and the last.
                    ArrayList<Integer> ids = new ArrayList<>();
                    for (int a = 1; a >= 0; a--) {
                        for (int b = 0; b < selectedMessagesIds[a].size(); b++) {
                            ids.add(selectedMessagesIds[a].keyAt(b));
                        }
                    }
                    Collections.sort(ids);
                    Integer begin = ids.get(0);
                    Integer end = ids.get(ids.size() - 1);
                    for (int i = 0; i < messages.size(); i++) {
                        Integer msgId = messages.get(i).getId();
                        if (msgId > begin && msgId < end && !selectedMessagesIds[0].withTouch.contains(msgId)) {
                            addToSelectedMessages(messages.get(i), false);
                            updateActionModeTitle();
                            updateVisibleRows();
                        }
                    }
                } else if (id == forward) {
                    // IS_ANONYMOUS_FORWARD = id == forward_anonym;
                    openForward(true);
                } else if (id == forward_anonym) {
                    showAnonymShareAlert(false);
                } else if (id == share) {
                    share();
                } else if (id == open_direct) {
                    if (currentChat == null) return;
                    presentFragment(ChatActivity.of(-currentChat.linked_monoforum_id));
                } else if (id == charge_fee ) {
                    long user_id = dialog_id;
                    long parent_id = 0;
                    if (ChatObject.isMonoForum(currentChat) && ChatObject.canManageMonoForum(currentAccount, currentChat)) {
                        user_id = getThreadId();
                        parent_id = dialog_id;
                    }
                    StarsController.getInstance(currentAccount).stopPaidMessages(user_id, parent_id, false, false);
                } else if (id == remove_fee) {
                    long _user_id = dialog_id;
                    long _parent_id = 0;
                    if (ChatObject.isMonoForum(currentChat) && ChatObject.canManageMonoForum(currentAccount, currentChat)) {
                        _user_id = getThreadId();
                        _parent_id = dialog_id;
                    }
                    final long user_id = _user_id;
                    final long parent_id = _parent_id;
                    StarsController.getInstance(currentAccount).getPaidRevenue(user_id, parent_id, revenue -> {
                        if (getContext() == null) return;
                        AlertsCreator.showAlertWithCheckbox(
                            getContext(),
                            getString(R.string.RemoveMessageFeeTitle),
                            AndroidUtilities.replaceTags(formatString(ChatObject.isMonoForum(currentChat) ? R.string.RemoveMessageFeeMessageChannel : R.string.RemoveMessageFeeMessage, DialogObject.getShortName(user_id))),
                            revenue > 0 ? formatPluralStringComma("RemoveMessageFeeRefund", (int) (long) revenue) : null,
                            getString(R.string.Confirm),
                            refund -> StarsController.getInstance(currentAccount).stopPaidMessages(user_id, parent_id, revenue > 0 && refund, true),
                            resourceProvider
                        );
                    });
                } else if (id == tag_message) {
                    if (tagSelector == null) {
                        showTagSelector();
                    } else {
                        hideTagSelector();
                    }
                } else if (id == save_to) {
                    ArrayList<MessageObject> messageObjects = new ArrayList<>();
                    for (int a = 1; a >= 0; a--) {
                        for (int b = 0; b < selectedMessagesIds[a].size(); b++) {
                            messageObjects.add(selectedMessagesIds[a].valueAt(b));
                        }
                        selectedMessagesIds[a].clear();
                        selectedMessagesCanCopyIds[a].clear();
                        selectedMessagesCanStarIds[a].clear();
                    }
                    boolean isMusic = canSaveMusicCount > 0;
                    hideActionMode();
                    updatePinnedMessageView(true);
                    updateVisibleRows();
                    MediaController.saveFilesFromMessages(getParentActivity(), getAccountInstance(), messageObjects, (count) -> {
                        if (count > 0) {
                            if (getParentActivity() == null) {
                                return;
                            }
                            BulletinFactory.of(ChatActivity.this).createDownloadBulletin(isMusic ? BulletinFactory.FileType.AUDIOS : BulletinFactory.FileType.UNKNOWNS, count, themeDelegate).show();
                        }
                    });
                } else if (id == chat_enc_timer) {
                    if (getParentActivity() == null) {
                        return;
                    }
                    showDialog(AlertsCreator.createTTLAlert(getParentActivity(), currentEncryptedChat, themeDelegate).create());
                } else if (id == clear_history || id == delete_chat || id == auto_delete_timer) {
                    if (getParentActivity() == null) {
                        return;
                    }

                    if (id == clear_history && ChatObject.isMonoForum(currentChat)) {
                        if (getThreadId() != 0) {
                            final TLRPC.User user = getMessagesController().getUser(getThreadId());
                            if (user != null) {
                                AlertsCreator.createClearDaysDialogAlert(ChatActivity.this, -1, user, currentChat, true, revoke -> {
                                    if (user.id != getThreadId()) {
                                        return;
                                    }
                                    performHistoryClear(false, true);
                                }, getResourceProvider());
                            }
                        }
                        return;
                    }

                    boolean canDeleteHistory = chatInfo != null && chatInfo.can_delete_channel;
                    if (id == auto_delete_timer || id == clear_history && currentEncryptedChat == null && ((currentUser != null && !UserObject.isUserSelf(currentUser) && !UserObject.isDeleted(currentUser)) || (chatInfo != null && chatInfo.can_delete_channel))) {
                        AlertsCreator.createClearDaysDialogAlert(ChatActivity.this, -1, currentUser, currentChat, canDeleteHistory, new MessagesStorage.BooleanCallback() {
                            @Override
                            public void run(boolean revoke) {
                                if (revoke && (currentUser != null || canDeleteHistory)) {
                                    getMessagesStorage().getMessagesCount(dialog_id, (count) -> {
                                        if (count >= 50) {
                                            AlertsCreator.createClearOrDeleteDialogAlert(ChatActivity.this, true, false, true, currentChat, currentUser, false, false, canDeleteHistory, (param) -> performHistoryClear(true, canDeleteHistory), themeDelegate);
                                        } else {
                                            performHistoryClear(true, canDeleteHistory);
                                        }
                                    });
                                } else {
                                    performHistoryClear(revoke, canDeleteHistory);
                                }
                            }
                        }, getResourceProvider());
                        return;
                    }
                    AlertsCreator.createClearOrDeleteDialogAlert(ChatActivity.this, id == clear_history, currentChat, currentUser, currentEncryptedChat != null, true, canDeleteHistory, (param) -> {
                        if (id == clear_history && ChatObject.isChannel(currentChat) && (!currentChat.megagroup || ChatObject.isPublic(currentChat))) {
                            getMessagesController().deleteDialog(dialog_id, 2, param);
                        } else {
                            if (id != clear_history) {
                                getNotificationCenter().removeObserver(ChatActivity.this, NotificationCenter.closeChats);
                                getNotificationCenter().postNotificationName(NotificationCenter.closeChats);
                                finishFragment();
                                getNotificationCenter().postNotificationName(NotificationCenter.needDeleteDialog, dialog_id, currentUser, currentChat, param);
                            } else {
                                performHistoryClear(param, canDeleteHistory);
                            }
                        }
                    }, themeDelegate);
                } else if (id == share_contact) {
                    if (currentUser == null || getParentActivity() == null) {
                        return;
                    }
                    if (addToContactsButton != null && addToContactsButton.getTag() != null) {
                        shareMyContact((Integer) addToContactsButton.getTag(), null);
                    } else {
                        Bundle args = new Bundle();
                        args.putLong("user_id", currentUser.id);
                        args.putBoolean("addContact", true);
                        presentFragment(new ContactAddActivity(args));
                    }
                } else if (id == mute) {
                    toggleMute(false);
                } else if (id == add_shortcut) {
                    try {
                        getMediaDataController().installShortcut(currentUser.id, MediaDataController.SHORTCUT_TYPE_USER_OR_CHAT);
                    } catch (Exception e) {
                        FileLog.e(e);
                    }
                } else if (id == boost_group) {
                    if (ChatObject.hasAdminRights(currentChat)) {
                        BoostsActivity boostsActivity = new BoostsActivity(dialog_id);
                        boostsActivity.setBoostsStatus(boostsStatus);
                        presentFragment(boostsActivity);
                    } else {
                        getNotificationCenter().postNotificationName(NotificationCenter.openBoostForUsersDialog, dialog_id);
                    }
                } else if (id == report) {
                    ReportBottomSheet.openChat(ChatActivity.this);
                } else if (id == star) {
                    for (int a = 0; a < 2; a++) {
                        for (int b = 0; b < selectedMessagesCanStarIds[a].size(); b++) {
                            MessageObject msg = selectedMessagesCanStarIds[a].valueAt(b);
                            getMediaDataController().addRecentSticker(MediaDataController.TYPE_FAVE, msg, msg.getDocument(), (int) (System.currentTimeMillis() / 1000), !hasUnfavedSelected);
                        }
                    }
                    clearSelectionMode();
                } else if (id == edit) {
                    MessageObject messageObject = null;
                    for (int a = 1; a >= 0; a--) {
                        if (messageObject == null && selectedMessagesIds[a].size() == 1) {
                            ArrayList<Integer> ids = new ArrayList<>();
                            for (int b = 0; b < selectedMessagesIds[a].size(); b++) {
                                ids.add(selectedMessagesIds[a].keyAt(b));
                            }
                            messageObject = messagesDict[a].get(ids.get(0));
                        }
                        selectedMessagesIds[a].clear();
                        selectedMessagesCanCopyIds[a].clear();
                        selectedMessagesCanStarIds[a].clear();
                    }
                    if (messageObject != null && messageObject.isTodo()) {
                        selectedObject = messageObject;
                        processSelectedOption(OPTION_EDIT_TODO);
                    } else {
                        startEditingMessageObject(messageObject);
                    }
                    hideActionMode();
                    updatePinnedMessageView(true);
                    updateVisibleRows();
                } else if (id == edit_quick_reply) {
                    QuickRepliesController.QuickReply currentQuickReply = QuickRepliesController.getInstance(currentAccount).findReply(getQuickReplyId());
                    QuickRepliesActivity.openRenameReplyAlert(getContext(), currentAccount, quickReplyShortcut, currentQuickReply, getResourceProvider(), false, name -> {
                        if (currentQuickReply != null) {
                            QuickRepliesController.getInstance(currentAccount).renameReply(currentQuickReply.id, name);
                        }
                        quickReplyShortcut = name;
                        avatarContainer.setTitle(name);
                    });
                } else if (id == chat_menu_attach) {
                    ActionBarMenuSubItem attach = new ActionBarMenuSubItem(context, false, true, true, getResourceProvider());
                    attach.setTextAndIcon(LocaleController.getString(R.string.AttachMenu), R.drawable.input_attach);
                    attach.setOnClickListener(view -> {
                        headerItem.closeSubMenu();
                        if (chatAttachAlert != null) {
                            chatAttachAlert.setEditingMessageObject(0, null);
                        }
                        openAttachMenu();
                    });
                    headerItem.toggleSubMenu(attach, attachItem.createView());
                } else if (id == bot_help) {
                    getSendMessagesHelper().sendMessage(SendMessagesHelper.SendMessageParams.of("/help", dialog_id, null, null, null, false, null, null, null, true, 0, 0, null, false));
                } else if (id == bot_settings) {
                    getSendMessagesHelper().sendMessage(SendMessagesHelper.SendMessageParams.of("/settings", dialog_id, null, null, null, false, null, null, null, true, 0, 0, null, false));
                } else if (id == search) {
                    openSearchWithText(isSupportedTags() ? "" : null);
                } else if (id == translate) {
                    getMessagesController().getTranslateController().setHideTranslateDialog(getDialogId(), false, true);
                    if (!getMessagesController().getTranslateController().toggleTranslatingDialog(getDialogId(), true)) {
                        updateTopPanel(true);
                    }
                } else if (id == call || id == video_call) {
                    if (currentUser != null && getParentActivity() != null) {
                        VoIPHelper.startCall(currentUser, id == video_call, userInfo != null && userInfo.video_calls_available, getParentActivity(), getMessagesController().getUserFull(currentUser.id), getAccountInstance());
                    }
                } else if (id == text_bold) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedBold();
                    }
                } else if (id == text_italic) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedItalic();
                    }
                } else if (id == text_spoiler) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedSpoiler();
                    }
                } else if (id == text_quote) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedQuote();
                    }
                } else if (id == text_mono) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedMono();
                    }
                } else if (id == text_strike) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedStrike();
                    }
                } else if (id == text_underline) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedUnderline();
                    }
                } else if (id == text_link) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedUrl();
                    }
                } else if (id == text_regular) {
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setSelectionOverride(editTextStart, editTextEnd);
                        chatActivityEnterView.getEditField().makeSelectedRegular();
                    }
                } else if (id == change_colors) {
                    showChatThemeBottomSheet();
                } else if (id == topic_close) {
                    if (forumTopic == null)
                        return;
                    getMessagesController().getTopicsController().toggleCloseTopic(currentChat.id, forumTopic.id, forumTopic.closed = true);
                    updateTopicButtons();
                    updateBottomOverlay();
                    updateTopPanel(true);
                } else if (id == open_forum) {
                    TopicsFragment.prepareToSwitchAnimation(ChatActivity.this);
//                    Bundle bundle = new Bundle();
//                    bundle.putLong("chat_id", -dialog_id);
//                    presentFragment(new TopicsFragment(bundle));
                } else if (id == copy_business_link) {
                    AndroidUtilities.addToClipboard(businessLink.link);
                    BulletinFactory.of(LaunchActivity.getLastFragment()).createCopyLinkBulletin().show();
                } else if (id == share_business_link) {
                    Runnable shareTask = () -> {
                        Intent intent = new Intent(getContext(), LaunchActivity.class);
                        intent.setAction(Intent.ACTION_SEND);
                        intent.setType("text/plain");
                        intent.putExtra(Intent.EXTRA_TEXT, businessLink.link);
                        startActivityForResult(intent, 500);
                    };
                    if (chatActivityEnterView.businessLinkHasChanges()) {
                        showBusinessLinksDiscardAlert(shareTask);
                    } else {
                        shareTask.run();
                    }
                } else if (id == rename_business_link) {
                    BusinessLinksActivity.openRenameAlert(getContext(), currentAccount, businessLink, resourceProvider, false);
                } else if (id == delete_business_link) {
                    AlertDialog dialog = new AlertDialog.Builder(getContext(), getResourceProvider())
                            .setTitle(getString(R.string.BusinessLinksDeleteTitle))
                            .setMessage(getString(R.string.BusinessLinksDeleteMessage))
                            .setPositiveButton(getString(R.string.Remove), (di, w) -> {
                                finishFragment();
                                getNotificationCenter().postNotificationName(NotificationCenter.needDeleteBusinessLink, businessLink);
                            })
                            .setNegativeButton(getString(R.string.Cancel), null)
                            .create();
                    showDialog(dialog);
                    TextView button = (TextView) dialog.getButton(DialogInterface.BUTTON_POSITIVE);
                    if (button != null) {
                        button.setTextColor(getThemedColor(Theme.key_text_RedBold));
                    }
                } else if (id == hideTitle) {
                    SharedConfig.hideTitleDialog = !SharedConfig.hideTitleDialog;
                    updateTitle(false);
                    checkAndUpdateAvatar();
                    if (hideTitleItem != null) {
                        if (SharedConfig.hideTitleDialog) {
                            hideTitleItem.setText(LocaleController.getString("ShowTitle", R.string.ShowTitle));
                        } else {
                            hideTitleItem.setText(LocaleController.getString("HideTitle", R.string.HideTitle));
                        }
                    }

                    SharedPreferences preferences = MessagesController.getGlobalMainSettings();
                    preferences.edit().putBoolean("hideTitle", SharedConfig.hideTitleDialog).commit();
                } else if (id == goToFirstMessage) {
                    // This is timestamp of launch date of the Telegram.
                    // August 2013.
                    jumpToDate(1375350800);
                } else if (id == deleteAllYourMessages) {
                    org.telegram.messenger.forkgram.ForkDialogs.CreateDeleteAllYourMessagesAlert(
                        currentAccount,
                        dialog_id,
                        getParentActivity());
                } else if (id == deleteAllYourMessagesInAllTopics) {
                    org.telegram.messenger.forkgram.ForkDialogs.CreateDeleteAllYourMessagesInAllTopicsAlert(
                        currentAccount,
                        dialog_id,
                        getParentActivity());
                } else if (id == deleteAllUnpinnedMessages) {
                    org.telegram.messenger.forkgram.ForkDialogs.CreateDeleteAllUnpinnedMessagesAlert(
                        currentAccount,
                        dialog_id,
                        getParentActivity());
                }
            }
        });
        View backButton = actionBar.getBackButton();
        backButton.setOnTouchListener(new LongPressListenerWithMovingGesture() {
            @Override
            public void onLongPress() {
                scrimPopupWindow = BackButtonMenu.show(ChatActivity.this, backButton, dialog_id, getTopicId(), themeDelegate);
                if (scrimPopupWindow != null) {
                    setSubmenu(scrimPopupWindow);
                    scrimPopupWindow.setOnDismissListener(() -> {
                        setSubmenu(null);
                        scrimPopupWindow = null;
                        menuDeleteItem = null;
                        scrimPopupWindowItems = null;
                        chatLayoutManager.setCanScrollVertically(true);
                        if (scrimPopupWindowHideDimOnDismiss) {
                            dimBehindView(false);
                        } else {
                            scrimPopupWindowHideDimOnDismiss = true;
                        }
                        if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                            chatActivityEnterView.getEditField().setAllowDrawCursor(true);
                        }
                    });
                    chatListView.stopScroll();
                    chatLayoutManager.setCanScrollVertically(false);
                    dimBehindView(backButton, 0.3f);
                    hideHints(false);
                    if (topUndoView != null) {
                        topUndoView.hide(true, 1);
                    }
                    if (undoView != null) {
                        undoView.hide(true, 1);
                    }
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().setAllowDrawCursor(false);
                    }
                }
            }
        });
        actionBar.setInterceptTouchEventListener((view, motionEvent) -> {
            if (chatThemeBottomSheet != null) {
                chatThemeBottomSheet.close();
                return true;
            }
            return false;
        });

        if (avatarContainer != null) {
            avatarContainer.onDestroy();
        }
        avatarContainer = new ChatAvatarContainer(context, this, currentEncryptedChat != null, themeDelegate) {
            @Override
            protected boolean useAnimatedSubtitle() {
                return chatMode == MODE_SAVED;
            }

            @Override
            protected boolean canSearch() {
                return !isInsideContainer && !isInPreviewMode() && !inBubbleMode && searchItem != null && !searching && (!isThreadChat() || isTopic);
            }

            @Override
            protected void openSearch() {
                openSearchWithText(isSupportedTags() ? "" : null);
            }
        };
        avatarContainer.allowShorterStatus = true;
        avatarContainer.premiumIconHiddable = true;
        avatarContainer.allowDrawStories = dialog_id < 0 && !isTopic;
        avatarContainer.setClipChildren(false);
        AndroidUtilities.updateViewVisibilityAnimated(avatarContainer, true, 1f, false);
        updateTopicTitleIcon();
        if (inPreviewMode || inBubbleMode || isInsideContainer) {
            avatarContainer.setOccupyStatusBar(false);
        }
        if (isReport()) {
            actionBar.setTitle(reportTitle);
            actionBar.setSubtitle(getString(R.string.ReportSelectMessages));
        } else if (startLoadFromDate != 0) {
            final int date = startLoadFromDate;
            actionBar.setOnClickListener((v) -> {
                jumpToDate(date);
            });
            actionBar.setTitle(LocaleController.formatDateChat(startLoadFromDate, false));
            actionBar.setSubtitle(getString(R.string.Loading));

            TLRPC.TL_messages_getHistory gh1 = new TLRPC.TL_messages_getHistory();
            gh1.peer = getMessagesController().getInputPeer(dialog_id);
            gh1.offset_date = startLoadFromDate;
            gh1.limit = 1;
            gh1.add_offset = -1;

            int req = getConnectionsManager().sendRequest(gh1, (response, error) -> {
                if (response instanceof TLRPC.messages_Messages) {
                    List<TLRPC.Message> l = ((TLRPC.messages_Messages) response).messages;
                    if (!l.isEmpty()) {

                        TLRPC.TL_messages_getHistory gh2 = new TLRPC.TL_messages_getHistory();
                        gh2.peer = getMessagesController().getInputPeer(dialog_id);
                        gh2.offset_date = startLoadFromDate + 60 * 60 * 24;
                        gh2.limit = 1;

                        getConnectionsManager().sendRequest(gh2, (response1, error1) -> {
                            if (response1 instanceof TLRPC.messages_Messages) {
                                List<TLRPC.Message> l2 = ((TLRPC.messages_Messages) response1).messages;
                                int count = 0;
                                if (!l2.isEmpty()) {
                                    count = ((TLRPC.messages_Messages) response).offset_id_offset - ((TLRPC.messages_Messages) response1).offset_id_offset;
                                } else {
                                    count = ((TLRPC.messages_Messages) response).offset_id_offset;
                                }
                                int finalCount = count;
                                AndroidUtilities.runOnUIThread(() -> {
                                    if (finalCount != 0) {
                                        AndroidUtilities.runOnUIThread(() -> actionBar.setSubtitle(LocaleController.formatPluralString("messages", finalCount)));
                                    } else {
                                        actionBar.setSubtitle(getString(R.string.NoMessagesForThisDay));
                                    }
                                });
                            }
                        });
                    } else {
                        actionBar.setSubtitle(getString(R.string.NoMessagesForThisDay));
                    }
                }
            });
            getConnectionsManager().bindRequestToGuid(req, classGuid);
        } else {
            actionBar.addView(avatarContainer, 0, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.MATCH_PARENT, Gravity.TOP | Gravity.LEFT, !inPreviewMode ? 56 : (chatMode == MODE_PINNED ? 10 : 0), 0, 40, 0));
        }

        ActionBarMenu menu = actionBar.createMenu();

        if (chatMode == MODE_QUICK_REPLIES && !QuickRepliesController.isSpecial(quickReplyShortcut)) {
            menu.addItem(edit_quick_reply, R.drawable.group_edit).setContentDescription(LocaleController.getString(R.string.Edit));
        }

        if (currentEncryptedChat == null && (chatMode == 0 || chatMode == MODE_SAVED || chatMode == MODE_SUGGESTIONS) && !isReport()) {
            searchIconItem = menu.addItem(search, isSupportedTags() ? R.drawable.navbar_search_tag : R.drawable.ic_ab_search);
            searchIconItem.setContentDescription(LocaleController.getString(R.string.Search));
            searchItem = menu.addItem(chat_menu_search, R.drawable.ic_ab_search, themeDelegate);
            searchItem.setIsSearchField(true);
            searchItem.setActionBarMenuItemSearchListener(getSearchItemListener());
            searchItem.setSearchFieldHint(isSupportedTags() ? LocaleController.getString(R.string.SavedTagSearchHint) : LocaleController.getString(R.string.Search));
            if (chatMode == MODE_SAVED || chatMode == MODE_SUGGESTIONS || threadMessageId == 0 && !UserObject.isReplyUser(currentUser) || threadMessageObject != null && threadMessageObject.getRepliesCount() < 10) {
                searchItem.setVisibility(View.GONE);
            } else {
                searchItem.setVisibility(View.VISIBLE);
            }
            searchItemVisible = false;
        }

        if (chatMode == 0 && (threadMessageId == 0 || isTopic) && !UserObject.isReplyUser(currentUser) && !isReport()) {
            TLRPC.UserFull userFull = null;
            if (currentUser != null) {
                audioCallIconItem = menu.lazilyAddItem(call, R.drawable.ic_call, themeDelegate);
                audioCallIconItem.setContentDescription(LocaleController.getString(R.string.Call));
                userFull = getMessagesController().getUserFull(currentUser.id);
                if (userFull != null && userFull.phone_calls_available) {
                    showAudioCallAsIcon = !inPreviewMode;
                    audioCallIconItem.setVisibility(View.VISIBLE);
                } else {
                    showAudioCallAsIcon = false;
                    audioCallIconItem.setVisibility(View.GONE);
                }
                if (avatarContainer != null) {
                    avatarContainer.setTitleExpand(showAudioCallAsIcon);
                }
            }
        }

        editTextItem = menu.lazilyAddItem(chat_menu_edit_text_options, R.drawable.ic_ab_other, themeDelegate);
        editTextItem.setContentDescription(LocaleController.getString(R.string.AccDescrMoreOptions));
        editTextItem.setTag(null);
        editTextItem.setVisibility(View.GONE);

        if (((chatMode == 0 && (threadMessageId == 0 || isTopic)) || chatMode == MODE_SUGGESTIONS) && !UserObject.isReplyUser(currentUser) && !isReport()) {
            TLRPC.UserFull userFull = null;
            if (currentUser != null) {
                userFull = getMessagesController().getUserFull(currentUser.id);
            }
            headerItem = menu.addItem(chat_menu_options, R.drawable.ic_ab_other, themeDelegate);
            headerItem.setContentDescription(LocaleController.getString(R.string.AccDescrMoreOptions));

            if (currentUser != null && currentUser.self && chatMode != MODE_SAVED) {
                savedChatsItem = headerItem.lazilyAddSubItem(view_as_topics, R.drawable.msg_topics, LocaleController.getString(R.string.SavedViewAsChats));
                savedChatsGap = headerItem.lazilyAddColoredGap();
                savedChatsItem.setVisibility(getMessagesController().getSavedMessagesController().hasDialogs() ? View.VISIBLE : View.GONE);
                savedChatsGap.setVisibility(getMessagesController().getSavedMessagesController().hasDialogs() ? View.VISIBLE : View.GONE);
            } else if (chatMode != MODE_SAVED && (currentUser == null || !currentUser.self)) {
                chatNotificationsPopupWrapper = new ChatNotificationsPopupWrapper(context, currentAccount, headerItem.getPopupLayout().getSwipeBack(), false, false, new ChatNotificationsPopupWrapper.Callback() {
                    @Override
                    public void dismiss() {
                        headerItem.toggleSubMenu();
                    }

                    @Override
                    public void toggleSound() {
                        SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                        boolean enabled = !preferences.getBoolean("sound_enabled_" + NotificationsController.getSharedPrefKey(dialog_id, getTopicId()), true);
                        preferences.edit().putBoolean("sound_enabled_" + NotificationsController.getSharedPrefKey(dialog_id, getTopicId()), enabled).apply();
                        if (BulletinFactory.canShowBulletin(ChatActivity.this)) {
                            BulletinFactory.createSoundEnabledBulletin(ChatActivity.this, enabled ? NotificationsController.SETTING_SOUND_ON : NotificationsController.SETTING_SOUND_OFF, getResourceProvider()).show();
                        }
                        updateTitleIcons();
                    }

                    @Override
                    public void muteFor(int timeInSeconds) {
                        if (timeInSeconds == 0) {
                            if (getMessagesController().isDialogMuted(dialog_id, getTopicId())) {
                                ChatActivity.this.toggleMute(true);
                            }
                            if (BulletinFactory.canShowBulletin(ChatActivity.this)) {
                                BulletinFactory.createMuteBulletin(ChatActivity.this, NotificationsController.SETTING_MUTE_UNMUTE, timeInSeconds, getResourceProvider()).show();
                            }
                        } else {
                            getNotificationsController().muteUntil(dialog_id, getTopicId(), timeInSeconds);
                            if (BulletinFactory.canShowBulletin(ChatActivity.this)) {
                                BulletinFactory.createMuteBulletin(ChatActivity.this, NotificationsController.SETTING_MUTE_CUSTOM, timeInSeconds, getResourceProvider()).show();
                            }
                        }
                    }

                    @Override
                    public void showCustomize() {
                        if (dialog_id != 0 && chatMode != MODE_SAVED) {
                            if (currentUser != null) {
                                getMessagesController().putUser(currentUser, true);
                            }
                            Bundle args = new Bundle();
                            args.putLong("dialog_id", dialog_id);
                            if (getTopicId() != 0) {
                                args.putLong("topic_id", getTopicId());
                            }
                            presentFragment(new ProfileNotificationsActivity(args, themeDelegate));
                        }
                    }

                    @Override
                    public void toggleMute() {
                        ChatActivity.this.toggleMute(true);
                        BulletinFactory.createMuteBulletin(ChatActivity.this, getMessagesController().isDialogMuted(dialog_id, getTopicId()), themeDelegate).show();
                    }
                }, getResourceProvider());
                muteItem = headerItem.lazilyAddSwipeBackItem(R.drawable.msg_mute, null, null, chatNotificationsPopupWrapper.windowLayout);
                muteItem.setOnClickListener(view -> {
                    boolean muted = MessagesController.getInstance(currentAccount).isDialogMuted(dialog_id, getTopicId());
                    if (muted) {
                        updateTitleIcons(true);
                        AndroidUtilities.runOnUIThread(() -> {
                            ChatActivity.this.toggleMute(true);
                        }, 150);
                        headerItem.toggleSubMenu();
                        if (ChatActivity.this.getParentActivity() != null) {
                            BulletinFactory.createMuteBulletin(ChatActivity.this, false, themeDelegate).show();
                        }
                    } else {
                        muteItem.openSwipeBack();
                    }
                });
                muteItemGap = headerItem.lazilyAddColoredGap();
            }
            if (currentChat != null) {
                headerItem.lazilyAddSubItem(open_direct, R.drawable.msg_markunread, getString(R.string.ChannelOpenDirect));
                headerItem.setSubItemShown(open_direct, ChatObject.isChannel(currentChat) && !ChatObject.isMonoForum(currentChat) && currentChat.linked_monoforum_id != 0 && ChatObject.canManageMonoForum(currentAccount, -currentChat.linked_monoforum_id));
            }

            if (searchItem != null) {
                headerItem.lazilyAddSubItem(search, R.drawable.msg_search, LocaleController.getString(R.string.Search));
            }
            if (ChatObject.isBoostSupported(currentChat) && (getUserConfig().isPremium() || ChatObject.isBoosted(chatInfo) || ChatObject.hasAdminRights(currentChat))) {
                RLottieDrawable drawable = new RLottieDrawable(R.raw.boosts, "" + R.raw.boosts, dp(24), dp(24));
                headerItem.lazilyAddSubItem(boost_group, drawable, LocaleController.getString(ChatObject.isChannelAndNotMegaGroup(currentChat) ? R.string.BoostingBoostChannelMenu : R.string.BoostingBoostGroupMenu));
            }
            translateItem = headerItem.lazilyAddSubItem(translate, R.drawable.msg_translate, LocaleController.getString(R.string.TranslateMessage));
            updateTranslateItemVisibility();
            if (currentChat != null && !currentChat.creator && !ChatObject.hasAdminRights(currentChat)) {
                headerItem.lazilyAddSubItem(report, R.drawable.msg_report, LocaleController.getString(R.string.ReportChat));
            }
            if (currentUser != null && currentUser.id != UserObject.VERIFY && currentUser.id != UserObject.REPLY_BOT) {
                addContactItem = headerItem.lazilyAddSubItem(share_contact, R.drawable.msg_addcontact, LocaleController.getString(R.string.AddToContacts));
            }
            if (currentEncryptedChat != null) {
                timeItem2 = headerItem.lazilyAddSubItem(chat_enc_timer, R.drawable.msg_autodelete, LocaleController.getString(R.string.SetTimer));
            }
            if (currentChat != null && !isTopic) {
                viewAsTopics = headerItem.lazilyAddSubItem(view_as_topics, R.drawable.msg_topics, LocaleController.getString(R.string.TopicViewAsTopics));
            }
            if (themeDelegate.isThemeChangeAvailable(true)) {
                headerItem.lazilyAddSubItem(change_colors, R.drawable.msg_background, LocaleController.getString(R.string.SetWallpapers));
            }
            if (currentUser != null && currentUser.self && getDialogId() != UserObject.VERIFY) {
                headerItem.lazilyAddSubItem(add_shortcut, R.drawable.msg_home, LocaleController.getString(R.string.AddShortcut));
            }
            if (!isTopic && !ChatObject.isMonoForum(currentChat)) {
                clearHistoryItem = headerItem.lazilyAddSubItem(clear_history, R.drawable.msg_clear, LocaleController.getString(R.string.ClearHistory));
            }
            boolean addedSettings = false;
            if (!isTopic) {
                if (ChatObject.isChannel(currentChat) && !currentChat.creator) {
                    if (!ChatObject.isNotInChat(currentChat)) {
                        if (currentChat.monoforum) {
                            headerItem.lazilyAddSubItem(delete_chat, R.drawable.msg_leave, LocaleController.getString(R.string.LeaveConversationMenu));
                        } else if (currentChat.megagroup) {
                            headerItem.lazilyAddSubItem(delete_chat, R.drawable.msg_leave, LocaleController.getString(R.string.LeaveMegaMenu));
                        } else {
                            headerItem.lazilyAddSubItem(delete_chat, R.drawable.msg_leave, LocaleController.getString(R.string.LeaveChannelMenu));
                        }
                    }
                } else if (!ChatObject.isChannel(currentChat) && getDialogId() != UserObject.VERIFY) {
                    if (currentChat != null) {
                        headerItem.lazilyAddSubItem(delete_chat, R.drawable.msg_leave, LocaleController.getString(R.string.DeleteAndExit));
                    } else if (currentUser != null && currentUser.bot) {
                        headerItem.lazilyAddSubItem(bot_settings, R.drawable.msg_settings_old, LocaleController.getString(R.string.BotSettings));
                        addedSettings = true;
                        headerItem.lazilyAddSubItem(bot_help, R.drawable.msg_help, LocaleController.getString(R.string.BotHelp));
                        if (!MessagesController.isSupportUser(currentUser)) {
                            headerItem.lazilyAddSubItem(report, R.drawable.msg_report, LocaleController.getString(R.string.ReportBot)).setColors(getThemedColor(Theme.key_text_RedRegular), getThemedColor(Theme.key_text_RedRegular));
                        }
                        headerItem.lazilyAddSubItem(delete_chat, R.drawable.msg_block2, LocaleController.getString(R.string.DeleteAndBlock)).setColors(getThemedColor(Theme.key_text_RedRegular), getThemedColor(Theme.key_text_RedRegular));
                        updateBotButtons();
                    } else {
                        headerItem.lazilyAddSubItem(delete_chat, R.drawable.msg_delete, LocaleController.getString(R.string.DeleteChatUser));
                    }
                }
            }
            if (ChatObject.isMegagroup(currentChat) || currentChat != null && !ChatObject.isChannel(currentChat)) {
                headerItem.addSubItem(
                    deleteAllYourMessages,
                    R.drawable.msg_delete,
                    LocaleController.getString("DeleteAllYourMessages", R.string.DeleteAllYourMessages),
                    themeDelegate);
                // Add option to delete messages in all topics for forum groups
                if (ChatObject.isForum(currentChat)) {
                    headerItem.addSubItem(
                        deleteAllYourMessagesInAllTopics,
                        R.drawable.msg_delete,
                        LocaleController.getString("DeleteAllYourMessagesInAllTopics", R.string.DeleteAllYourMessagesInAllTopics),
                        themeDelegate);
                }
            }
            if (MessagesController.getGlobalMainSettings().getBoolean("addItemToDeleteAllUnpinnedMessages", false)
                && ((currentUser != null && currentEncryptedChat == null) || currentChat != null)) {
                headerItem.addSubItem(
                    deleteAllUnpinnedMessages,
                    R.drawable.msg_delete,
                    LocaleController.getString("DeleteAllUnpinnedMessages", R.string.DeleteAllUnpinnedMessages),
                    themeDelegate);
            }
            if (ChatObject.isMonoForum(currentChat) && ChatObject.canManageMonoForum(currentAccount, currentChat)) {
                headerItem.lazilyAddSubItem(remove_fee, R.drawable.menu_paid_off, getString(R.string.DirectRemoveFee));
                headerItem.lazilyAddSubItem(charge_fee, R.drawable.menu_feature_paid, getString(R.string.DirectChargeFee));
                headerItem.setSubItemShown(remove_fee, false);
                headerItem.setSubItemShown(charge_fee, false);

                feeItemGap = headerItem.lazilyAddColoredGap();
                feeItemText = headerItem.lazilyAddText("", 13);
                feeItemGap.setVisibility(View.GONE);
                feeItemText.setVisibility(View.GONE);
            }
            String hideTitleString = "";
            if (SharedConfig.hideTitleDialog) {
                hideTitleString = LocaleController.getString("ShowTitle", R.string.ShowTitle);
            } else {
                hideTitleString = LocaleController.getString("HideTitle", R.string.HideTitle);
            }
            hideTitleItem = headerItem.addSubItem(hideTitle, R.drawable.hide_title, hideTitleString, themeDelegate);


            headerItem.addSubItem(goToFirstMessage, R.drawable.to_first, LocaleController.getString("GoToFirstMessage", R.string.GoToFirstMessage), themeDelegate);

            if (currentUser != null && chatMode != MODE_SAVED) {
                headerItem.lazilyAddSubItem(call, R.drawable.msg_callback, LocaleController.getString(R.string.Call));
                headerItem.lazilyAddSubItem(video_call, R.drawable.msg_videocall, LocaleController.getString(R.string.VideoCall));
                if (userFull != null && userFull.phone_calls_available) {
                    headerItem.showSubItem(call);
                    if (userFull.video_calls_available) {
                        headerItem.showSubItem(video_call);
                    } else {
                        headerItem.hideSubItem(video_call);
                    }
                } else {
                    headerItem.hideSubItem(call);
                    headerItem.hideSubItem(video_call);
                }
            }
        } else if (chatMode == MODE_EDIT_BUSINESS_LINK) {
            headerItem = menu.addItem(chat_menu_options, R.drawable.ic_ab_other, themeDelegate);
            headerItem.setContentDescription(LocaleController.getString(R.string.AccDescrMoreOptions));

            headerItem.lazilyAddSubItem(copy_business_link, R.drawable.msg_copy, getString(R.string.Copy));
            headerItem.lazilyAddSubItem(share_business_link, R.drawable.msg_share, getString(R.string.LinkActionShare));
            headerItem.lazilyAddSubItem(rename_business_link, R.drawable.msg_edit, getString(R.string.Rename));
            headerItem.lazilyAddSubItem(delete_business_link, R.drawable.msg_delete, getString(R.string.Delete)).setColors(Theme.getColor(Theme.key_text_RedRegular), Theme.getColor(Theme.key_text_RedRegular));
        }
        if (ChatObject.isForum(currentChat) && isTopic && getParentLayout() != null && getParentLayout().getFragmentStack() != null && chatMode == MODE_DEFAULT) {
            boolean hasMyForum = false;
            for (int i = 0; i < getParentLayout().getFragmentStack().size(); ++i) {
                BaseFragment fragment = getParentLayout().getFragmentStack().get(i);
                if (fragment instanceof TopicsFragment && ((TopicsFragment) fragment).getDialogId() == dialog_id) {
                    hasMyForum = true;
                    break;
                }
            }

            if (!hasMyForum) {
                openForumItem = headerItem.lazilyAddSubItem(open_forum, R.drawable.msg_discussion, LocaleController.getString(R.string.OpenAllTopics));
            }
        }
        if (currentChat != null && forumTopic != null && chatMode == 0) {
            closeTopicItem = headerItem.lazilyAddSubItem(topic_close, R.drawable.msg_topic_close, LocaleController.getString(R.string.CloseTopic));
            closeTopicItem.setVisibility(currentChat != null && ChatObject.canManageTopic(currentAccount, currentChat, forumTopic) && forumTopic != null && !forumTopic.closed ? View.VISIBLE : View.GONE);
        }
        menu.setVisibility(inMenuMode ? View.GONE : View.VISIBLE);

        updateTitle(false);
        avatarContainer.updateOnlineCount();
        avatarContainer.updateSubtitle();
        updateTitleIcons();

        if (chatMode == 0 && (!isThreadChat() || isTopic) && !isReport()) {
            attachItem = menu.lazilyAddItem(chat_menu_attach, R.drawable.ic_ab_other, themeDelegate);
            attachItem.setOverrideMenuClick(true);
            attachItem.setAllowCloseAnimation(false);
            attachItem.setContentDescription(LocaleController.getString(R.string.AccDescrMoreOptions));
            attachItem.setVisibility(View.GONE);
        }

        if (inPreviewMode) {
            if (headerItem != null) {
                headerItem.setAlpha(0.0f);
            }
            if (attachItem != null) {
                attachItem.setAlpha(0.0f);
            }
        }

        actionModeViews.clear();
        selectedMessagesCountTextView = null;
        checkActionBarMenu(false);

        scrimPaint = new Paint();

        if (chatListThanosEffect != null) {
            AndroidUtilities.removeFromParent(chatListThanosEffect);
            chatListThanosEffect = null;
        }
        removingFromParent = false;
        fragmentView = contentView = new ChatActivityFragmentView(context, parentLayout);
        invalidateBlurredSourcesView = new OnPostDrawView(context, this::invalidateMergedVisibleBlurredPositionsAndSourcesImpl);
        contentView.addView(invalidateBlurredSourcesView);

        final ViewPositionWatcher viewPositionWatcher = new ViewPositionWatcher(contentView);

        glassBackgroundDrawableFactory.setSourceRootView(viewPositionWatcher, contentView);
        glassBackgroundDrawableFactoryFrosted.setSourceRootView(viewPositionWatcher, contentView);
        navbarContentDrawableFactory.setSourceRootView(viewPositionWatcher, contentView);

        contentView.needBlur = false;
        contentView.needBlurBottom = false;
        contentView.setOccupyStatusBar(!inBubbleMode && !isInsideContainer && !inPreviewMode);

        BlurredBackgroundWithFadeDrawable fadeDrawable = new BlurredBackgroundWithFadeDrawable(
                navbarContentDrawableFactory.create(chatInputViewsContainer, null));
        if (!SharedConfig.chatBlurEnabled() || LiteMode.isEnabled(LiteMode.FLAG_LIQUID_GLASS)) {
            fadeDrawable.setFadeHeight(dp(72), true);
        }

        chatInputViewsContainer = new ChatInputViewsContainer(context);
        chatInputViewsContainer.setClipChildren(false);
        chatInputViewsContainer.setBackgroundWithFadeDrawable(fadeDrawable);
        chatInputViewsContainer.setWindowInsetsProvider(windowInsetsStateHolder);
        chatInputViewsContainer.setInputIslandBubbleDrawable(
            glassBackgroundDrawableFactory.create(chatInputViewsContainer, blurredBackgroundColorProvider));
        chatInputViewsContainer.setUnderKeyboardBackgroundDrawable(
            glassBackgroundDrawableFactoryFrosted.create(chatInputViewsContainer, blurredBackgroundColorProvider));


        chatInputBubbleContainer = chatInputViewsContainer.getInputIslandBubbleContainer();
        chatInputBubbleContainer.setClipChildren(false);

        chatInputInAppContainer = chatInputViewsContainer.getInAppKeyboardBubbleContainer();

        updateBackground();

        emptyViewContainer = null;

        CharSequence oldMessage;
        if (chatActivityEnterView != null) {
            chatActivityEnterView.onDestroy();
            if (!chatActivityEnterView.isEditingMessage()) {
                oldMessage = chatActivityEnterView.getFieldText();
            } else {
                oldMessage = null;
            }
        } else {
            oldMessage = null;
        }
        if (mentionContainer != null && mentionContainer.getAdapter() != null) {
            mentionContainer.getAdapter().onDestroy();
        }

        chatListView = new ChatListRecyclerView(context, themeDelegate) {
            private int lastWidth;

            private final ArrayList<ChatMessageCell> drawTimeAfter = new ArrayList<>();
            private final ArrayList<ChatMessageCell> drawNamesAfter = new ArrayList<>();
            private final ArrayList<ChatMessageCell> drawCaptionAfter = new ArrayList<>();
            private final ArrayList<ChatMessageCell> drawReactionsAfter = new ArrayList<>();
            private final ArrayList<MessageObject.GroupedMessages> drawingGroups = new ArrayList<>(10);

            private int startedTrackingX;
            private int startedTrackingY;
            private int startedTrackingPointerId;
            private long lastTrackingAnimationTime;
            private float trackAnimationProgress;
            private float endTrackingX;
            private boolean wasTrackingVibrate;

            private float springMultiplier = 2000f;

            private Paint outlineActionBackgroundPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
            private Paint outlineActionBackgroundDarkenPaint = new Paint(Paint.ANTI_ALIAS_FLAG);

            private FloatValueHolder slidingDrawableVisibilityProgress = new FloatValueHolder(0);
            private SpringAnimation slidingDrawableVisibilitySpring = new SpringAnimation(slidingDrawableVisibilityProgress)
                    .setMinValue(0f)
                    .setMaxValue(springMultiplier)
                    .setSpring(new SpringForce(0)
                            .setStiffness(SpringForce.STIFFNESS_MEDIUM)
                            .setDampingRatio(SpringForce.DAMPING_RATIO_NO_BOUNCY))
                    .addUpdateListener((animation, value, velocity) -> invalidate());
            private FloatValueHolder slidingFillProgress = new FloatValueHolder(0);
            private SpringAnimation slidingFillProgressSpring = new SpringAnimation(slidingFillProgress)
                    .setMinValue(0f)
                    .setSpring(new SpringForce(0)
                            .setStiffness(400f)
                            .setDampingRatio(SpringForce.DAMPING_RATIO_MEDIUM_BOUNCY))
                    .addUpdateListener((animation, value, velocity) -> invalidate());
            private FloatValueHolder slidingOuterRingProgress = new FloatValueHolder(0);
            private SpringAnimation slidingOuterRingSpring = new SpringAnimation(slidingOuterRingProgress)
                    .setMinValue(0f)
                    .setSpring(new SpringForce(0)
                            .setStiffness(200f)
                            .setDampingRatio(SpringForce.DAMPING_RATIO_NO_BOUNCY))
                    .addUpdateListener((animation, value, velocity) -> invalidate());
            private boolean slidingBeyondMax;
            private Path path = new Path();

            private boolean ignoreLayout;
            private boolean invalidated;

            int lastH = 0;

            {
                outlineActionBackgroundPaint.setStyle(Paint.Style.STROKE);
                outlineActionBackgroundPaint.setStrokeCap(Paint.Cap.ROUND);
                outlineActionBackgroundPaint.setStrokeWidth(AndroidUtilities.dp(2));
                outlineActionBackgroundDarkenPaint.setStyle(Paint.Style.STROKE);
                outlineActionBackgroundDarkenPaint.setStrokeCap(Paint.Cap.ROUND);
                outlineActionBackgroundDarkenPaint.setStrokeWidth(AndroidUtilities.dp(2));
            }

            @Override
            public void requestLayout() {
                if (ignoreLayout) {
                    return;
                }
                super.requestLayout();
            }

            @Override
            public void setTranslationY(float translationY) {
                if (translationY != getTranslationY()) {
                    super.setTranslationY(translationY);
                    invalidateChatListViewTopPadding();
                    invalidateMessagesVisiblePart();
                }
            }

            @Override
            protected boolean allowSelectChildAtPosition(View child) {
                if (child != null && (child.getVisibility() == View.INVISIBLE || child.getVisibility() == View.GONE)) return false;
                return super.allowSelectChildAtPosition(child);
            }

            @Override
            protected void onMeasure(int widthSpec, int heightSpec) {
//                saveScrollPosition();
                super.onMeasure(widthSpec, heightSpec);
            }

            @Override
            protected void onLayout(boolean changed, int l, int t, int r, int b) {
                super.onLayout(changed, l, t, r, b);

                if (lastWidth != r - l) {
                    if (lastWidth != 0) {
                        hideHints(false);
                    }
                    lastWidth = r - l;
                }

                int height = getMeasuredHeight();
                if (lastH != height) {
                    ignoreLayout = true;
                    if (chatListItemAnimator != null) {
                        chatListItemAnimator.endAnimations();
                    }
                    chatScrollHelper.cancel();
                    ignoreLayout = false;
                    lastH = height;
                }

                forceScrollToTop = false;
                if (textSelectionHelper != null && textSelectionHelper.isInSelectionMode()) {
                    textSelectionHelper.invalidate();
                }
                invalidateClipRectForBackgroundAndChatList();
                isSkeletonVisible();
            }

            private void setGroupTranslationX(ChatMessageCell view, float dx) {
                MessageObject.GroupedMessages group = view.getCurrentMessagesGroup();
                if (group == null) {
                    return;
                }
                int count = getChildCount();
                for (int a = 0; a < count; a++) {
                    View child = getChildAt(a);
                    if (child == view || !(child instanceof ChatMessageCell)) {
                        continue;
                    }
                    ChatMessageCell cell = (ChatMessageCell) child;
                    if (cell.getCurrentMessagesGroup() == group) {
                        cell.setSlidingOffset(dx);
                        cell.invalidate();
                    }
                }
                invalidate();
            }

            @Override
            public boolean requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
                if (scrimPopupWindow != null) {
                    return false;
                }
                return super.requestChildRectangleOnScreen(child, rect, immediate);
            }

            @Override
            public boolean onInterceptTouchEvent(MotionEvent e) {
                textSelectionHelper.checkSelectionCancel(e);
                if (isFastScrollAnimationRunning()) {
                    return false;
                }
                if (quickShareSelectorOverlay != null && quickShareSelectorOverlay.isActive()) {
                    return false;
                }
                boolean result = super.onInterceptTouchEvent(e);
                if (actionBar.isActionModeShowed() || isReport()) {
                    return result;
                }
                processTouchEvent(e);
                return result;
            }

            @Override
            public void setItemAnimator(ItemAnimator animator) {
                if (isFastScrollAnimationRunning()) {
                    return;
                }
                super.setItemAnimator(animator);
            }

            private void drawReplyButton(Canvas canvas) {
                if (slidingView == null || Thread.currentThread() != Looper.getMainLooper().getThread()) {
                    return;
                }
                Paint chatActionBackgroundPaint = getThemedPaint(Theme.key_paint_chatActionBackground);
                Paint chatActionBackgroundDarkenPaint = Theme.chat_actionBackgroundGradientDarkenPaint;
                if (outlineActionBackgroundPaint.getColor() != chatActionBackgroundPaint.getColor()) {
                    outlineActionBackgroundPaint.setColor(chatActionBackgroundPaint.getColor());
                }
                if (outlineActionBackgroundDarkenPaint.getColor() != chatActionBackgroundDarkenPaint.getColor()) {
                    outlineActionBackgroundDarkenPaint.setColor(chatActionBackgroundDarkenPaint.getColor());
                }
                if (outlineActionBackgroundPaint.getShader() != chatActionBackgroundPaint.getShader()) {
                    outlineActionBackgroundPaint.setShader(chatActionBackgroundPaint.getShader());
                }
                if (outlineActionBackgroundDarkenPaint.getShader() != chatActionBackgroundDarkenPaint.getShader()) {
                    outlineActionBackgroundDarkenPaint.setShader(chatActionBackgroundDarkenPaint.getShader());
                }

                float fillProgress = slidingFillProgress.getValue() / springMultiplier;
                int wasDarkenColor = outlineActionBackgroundDarkenPaint.getColor();

                if (fillProgress > 1) {
                    slidingBeyondMax = true;
                }

                float translationX = slidingView.getNonAnimationTranslationX(false);
                if (slidingDrawableVisibilityProgress.getValue() == 0) {
                    slidingFillProgressSpring.cancel();
                    slidingFillProgressSpring.getSpring().setFinalPosition(0);
                    slidingFillProgress.setValue(0f);
                    slidingOuterRingSpring.cancel();
                    slidingOuterRingSpring.getSpring().setFinalPosition(0);
                    slidingOuterRingProgress.setValue(0f);
                    slidingBeyondMax = false;
                }
                float progress;
                if (slidingFillProgressSpring.getSpring().getFinalPosition() != springMultiplier) {
                    progress = androidx.core.math.MathUtils.clamp((-translationX - AndroidUtilities.dp(20)) / AndroidUtilities.dp(30), 0, 1);
                } else {
                    progress = 1f;
                }

                if (progress == 1f && slidingFillProgressSpring.getSpring().getFinalPosition() != springMultiplier) {
                    slidingFillProgressSpring.getSpring().setFinalPosition(springMultiplier);
                    slidingFillProgressSpring.start();

                    slidingOuterRingSpring.getSpring().setFinalPosition(springMultiplier);
                    slidingOuterRingSpring.start();
                }

                boolean visible = translationX <= -AndroidUtilities.dp(20);
                float endVisibleValue = visible ? springMultiplier : 0;
                if (endVisibleValue != slidingDrawableVisibilitySpring.getSpring().getFinalPosition()) {
                    slidingDrawableVisibilitySpring.getSpring().setFinalPosition(endVisibleValue);
                    if (!slidingDrawableVisibilitySpring.isRunning()) {
                        slidingDrawableVisibilitySpring.start();
                    }
                }

                float iconProgress = slidingDrawableVisibilityProgress.getValue() / springMultiplier;
                float x = getMeasuredWidth() + translationX * (slidingView.getMessageObject() != null && slidingView.getMessageObject().isOut() ? 0.5f : 1f);
                float y = slidingView.getTop() + slidingView.getMeasuredHeight() / 2f;
                float scale = slidingBeyondMax ? fillProgress : iconProgress;

                float clearScale = slidingBeyondMax ? 0f : 1f - fillProgress;

                boolean isDark = ColorUtils.calculateLuminance(getThemedColor(Theme.key_windowBackgroundWhite)) <= 0.5f;
                if (iconProgress != 0) {
                    AndroidUtilities.rectTmp.set((int) (x - AndroidUtilities.dp(16) * scale + outlineActionBackgroundPaint.getStrokeWidth() / 2f), (int) (y - AndroidUtilities.dp(16) * scale + outlineActionBackgroundPaint.getStrokeWidth() / 2f), (int) (x + AndroidUtilities.dp(16) * scale - outlineActionBackgroundPaint.getStrokeWidth() / 2f), (int) (y + AndroidUtilities.dp(16) * scale - outlineActionBackgroundPaint.getStrokeWidth() / 2f));
                    Theme.applyServiceShaderMatrix(getMeasuredWidth(), AndroidUtilities.displaySize.y, 0, getY() + AndroidUtilities.rectTmp.top);
                    if (fillProgress == 0) {
                        int outlineAlpha = outlineActionBackgroundPaint.getAlpha();
                        outlineActionBackgroundPaint.setAlpha((int) (outlineAlpha * iconProgress));
                        canvas.drawArc(AndroidUtilities.rectTmp, -90, 360 * progress, false, outlineActionBackgroundPaint);
                        outlineActionBackgroundPaint.setAlpha(outlineAlpha);

                        if (themeDelegate.hasGradientService()) {
                            outlineAlpha = outlineActionBackgroundDarkenPaint.getAlpha();
                            if (isDark) {
                                outlineActionBackgroundDarkenPaint.setColor(Color.WHITE);
                            }
                            outlineActionBackgroundDarkenPaint.setAlpha((int) (outlineAlpha * iconProgress));
                            canvas.drawArc(AndroidUtilities.rectTmp, -90, 360 * progress, false, outlineActionBackgroundDarkenPaint);
                        }
                    }
                }
                AndroidUtilities.rectTmp.set((int) (x - AndroidUtilities.dp(16) * scale), (int) (y - AndroidUtilities.dp(16) * scale), (int) (x + AndroidUtilities.dp(16) * scale), (int) (y + AndroidUtilities.dp(16) * scale));
                Theme.applyServiceShaderMatrix(getMeasuredWidth(), AndroidUtilities.displaySize.y, 0, getY() + AndroidUtilities.rectTmp.top);
                path.rewind();
                path.addRoundRect(AndroidUtilities.rectTmp, AndroidUtilities.dp(16) * scale, AndroidUtilities.dp(16) * scale, Path.Direction.CW);

                int wasAlpha = chatActionBackgroundPaint.getAlpha();
                chatActionBackgroundPaint.setAlpha((int) (iconProgress * 0.6f * progress * wasAlpha));
                canvas.drawPath(path, chatActionBackgroundPaint);
                chatActionBackgroundPaint.setAlpha(wasAlpha);

                if (themeDelegate.hasGradientService()) {
                    wasAlpha = Theme.chat_actionBackgroundGradientDarkenPaint.getAlpha();
                    if (isDark) {
                        Theme.chat_actionBackgroundGradientDarkenPaint.setColor(Color.WHITE);
                    }
                    Theme.chat_actionBackgroundGradientDarkenPaint.setAlpha((int) (iconProgress * 0.6f * progress * wasAlpha));
                    canvas.drawPath(path, Theme.chat_actionBackgroundGradientDarkenPaint);
                    Theme.chat_actionBackgroundGradientDarkenPaint.setAlpha(wasAlpha);
                }

                if (clearScale != 0f) {
                    AndroidUtilities.rectTmp.set((int) (x - AndroidUtilities.dp(16) * clearScale), (int) (y - AndroidUtilities.dp(16) * clearScale), (int) (x + AndroidUtilities.dp(16) * clearScale), (int) (y + AndroidUtilities.dp(16) * clearScale));
                    path.rewind();
                    path.addRoundRect(AndroidUtilities.rectTmp, AndroidUtilities.dp(16), AndroidUtilities.dp(16), Path.Direction.CW);

                    canvas.save();
                    canvas.clipPath(path, Region.Op.DIFFERENCE);
                }

                AndroidUtilities.rectTmp.set((int) (x - AndroidUtilities.dp(16) * scale), (int) (y - AndroidUtilities.dp(16) * scale), (int) (x + AndroidUtilities.dp(16) * scale), (int) (y + AndroidUtilities.dp(16) * scale));
                Theme.applyServiceShaderMatrix(getMeasuredWidth(), AndroidUtilities.displaySize.y, 0, getY() + AndroidUtilities.rectTmp.top);
                path.rewind();
                path.addRoundRect(AndroidUtilities.rectTmp, AndroidUtilities.dp(16) * scale, AndroidUtilities.dp(16) * scale, Path.Direction.CW);

                wasAlpha = chatActionBackgroundPaint.getAlpha();
                chatActionBackgroundPaint.setAlpha((int) (iconProgress * 0.4f * wasAlpha));
                canvas.drawPath(path, chatActionBackgroundPaint);
                chatActionBackgroundPaint.setAlpha(wasAlpha);

                if (themeDelegate.hasGradientService()) {
                    wasAlpha = Theme.chat_actionBackgroundGradientDarkenPaint.getAlpha();
                    if (isDark) {
                        Theme.chat_actionBackgroundGradientDarkenPaint.setColor(Color.WHITE);
                    }
                    Theme.chat_actionBackgroundGradientDarkenPaint.setAlpha((int) (iconProgress * 0.4f * wasAlpha));
                    canvas.drawPath(path, Theme.chat_actionBackgroundGradientDarkenPaint);
                    Theme.chat_actionBackgroundGradientDarkenPaint.setAlpha(wasAlpha);
                }
                if (clearScale != 0f) {
                    canvas.restore();
                }

                float outerRingProgress = slidingOuterRingProgress.getValue() / springMultiplier;
                if (outerRingProgress != 0 && outerRingProgress != 1) {
                    float outScale = 1f + outerRingProgress;

                    float wasWidth = outlineActionBackgroundPaint.getStrokeWidth();
                    float width = (1f - outerRingProgress) * wasWidth;
                    if (width != 0f) {
                        AndroidUtilities.rectTmp.set((int) (x - AndroidUtilities.dp(16) * outScale + width), (int) (y - AndroidUtilities.dp(16) * outScale + width), (int) (x + AndroidUtilities.dp(16) * outScale - width), (int) (y + AndroidUtilities.dp(16) * outScale - width));
                        Theme.applyServiceShaderMatrix(getMeasuredWidth(), AndroidUtilities.displaySize.y, 0, getY() + AndroidUtilities.rectTmp.top);

                        wasAlpha = outlineActionBackgroundPaint.getAlpha();
                        outlineActionBackgroundPaint.setAlpha((int) (wasAlpha * iconProgress));

                        outlineActionBackgroundPaint.setStrokeWidth(width);
                        canvas.drawRoundRect(AndroidUtilities.rectTmp, AndroidUtilities.dp(16) * outScale, AndroidUtilities.dp(16) * outScale, outlineActionBackgroundPaint);
                        outlineActionBackgroundPaint.setStrokeWidth(wasWidth);

                        outlineActionBackgroundPaint.setAlpha(wasAlpha);

                        if (themeDelegate.hasGradientService()) {
                            wasAlpha = outlineActionBackgroundDarkenPaint.getAlpha();
                            if (isDark) {
                                outlineActionBackgroundDarkenPaint.setColor(Color.WHITE);
                            }
                            outlineActionBackgroundDarkenPaint.setAlpha((int) (wasAlpha * iconProgress));

                            outlineActionBackgroundDarkenPaint.setStrokeWidth(width);
                            canvas.drawRoundRect(AndroidUtilities.rectTmp, AndroidUtilities.dp(16) * outScale, AndroidUtilities.dp(16) * outScale, outlineActionBackgroundDarkenPaint);
                            outlineActionBackgroundDarkenPaint.setStrokeWidth(wasWidth);
                        }
                    }
                }

                int alpha = (int) (iconProgress * 0xFF);
                Drawable replyIconDrawable = getThemedDrawable(Theme.key_drawable_replyIcon);
                replyIconDrawable.setAlpha(alpha);
                replyIconDrawable.setBounds((int) (x - replyIconDrawable.getIntrinsicWidth() / 2 * scale), (int) (y - replyIconDrawable.getIntrinsicHeight() / 2 * scale), (int) (x + replyIconDrawable.getIntrinsicWidth() / 2 * scale), (int) (y + replyIconDrawable.getIntrinsicHeight() / 2 * scale));
                replyIconDrawable.draw(canvas);
                replyIconDrawable.setAlpha(255);

                outlineActionBackgroundDarkenPaint.setColor(wasDarkenColor);
                chatActionBackgroundDarkenPaint.setColor(wasDarkenColor);
            }

            private void processTouchEvent(MotionEvent e) {
                if (e != null) {
                    wasManualScroll = true;
                }
                if (e != null && e.getAction() == MotionEvent.ACTION_DOWN && !startedTrackingSlidingView && !maybeStartTrackingSlidingView && slidingView == null && !inPreviewMode) {
                    View view = getPressedChildView();
                    if (view instanceof ChatMessageCell) {
                        if (slidingView != null) {
                            slidingView.setSlidingOffset(0);
                        }
                        slidingView = (ChatMessageCell) view;
                        MessageObject message = slidingView.getMessageObject();
                        boolean allowReplyOnOpenTopic = canSendMessageToTopic(message);
                        if (
                                chatMode != 0 && chatMode != MODE_QUICK_REPLIES && chatMode != MODE_SUGGESTIONS && (chatMode != MODE_SAVED || threadMessageId != getUserConfig().getClientUserId()) ||
                                threadMessageObjects != null && threadMessageObjects.contains(message) ||
                                getMessageType(message) == 1 && (message.getDialogId() == mergeDialogId || message.needDrawBluredPreview()) ||
                                currentEncryptedChat == null && message.getId() < 0 ||
                                bottomChannelButtonsLayout != null && bottomChannelButtonsLayout.getVisibility() == View.VISIBLE && !(bottomOverlayChatWaitsReply && allowReplyOnOpenTopic || message.wasJustSent) ||
                                currentChat != null && (ChatObject.isNotInChat(currentChat) && !isThreadChat() ||
                                ChatObject.isChannel(currentChat) && !ChatObject.canPost(currentChat) && !currentChat.megagroup ||
                                !ChatObject.canSendMessages(currentChat) ||
                                (ChatObject.isForum(currentChat) && !allowReplyOnOpenTopic)) ||
                                textSelectionHelper.isInSelectionMode()
                        ) {
                            slidingView.setSlidingOffset(0);
                            slidingView = null;
                            return;
                        }
                        startedTrackingPointerId = e.getPointerId(0);
                        maybeStartTrackingSlidingView = true;
                        startedTrackingX = (int) e.getX();
                        startedTrackingY = (int) e.getY();
                    }
                } else if (slidingView != null && e != null && e.getAction() == MotionEvent.ACTION_MOVE && e.getPointerId(0) == startedTrackingPointerId) {
                    int dx = Math.max(AndroidUtilities.dp(-80), Math.min(0, (int) (e.getX() - startedTrackingX)));
                    int dy = Math.abs((int) e.getY() - startedTrackingY);
                    if (getScrollState() == SCROLL_STATE_IDLE && maybeStartTrackingSlidingView && !startedTrackingSlidingView && dx <= -AndroidUtilities.getPixelsInCM(0.4f, true) && Math.abs(dx) / 3 > dy) {
                        MotionEvent event = MotionEvent.obtain(0, 0, MotionEvent.ACTION_CANCEL, 0, 0, 0);
                        slidingView.onTouchEvent(event);
                        super.onInterceptTouchEvent(event);
                        event.recycle();
                        chatLayoutManager.setCanScrollVertically(false);
                        maybeStartTrackingSlidingView = false;
                        startedTrackingSlidingView = true;
                        startedTrackingX = (int) e.getX();
                        if (getParent() != null) {
                            getParent().requestDisallowInterceptTouchEvent(true);
                        }
                    } else if (startedTrackingSlidingView) {
                        if (Math.abs(dx) >= AndroidUtilities.dp(50)) {
                            if (!wasTrackingVibrate) {
                                try {
                                    performHapticFeedback(HapticFeedbackConstants.KEYBOARD_TAP, HapticFeedbackConstants.FLAG_IGNORE_GLOBAL_SETTING);
                                } catch (Exception ignore) {}
                                wasTrackingVibrate = true;
                            }
                        } else {
                            wasTrackingVibrate = false;
                        }
                        slidingView.setSlidingOffset(dx);
                        MessageObject messageObject = slidingView.getMessageObject();
                        if (messageObject.isRoundVideo() || messageObject.isVideo()) {
                            updateTextureViewPosition(false, false);
                        }
                        setGroupTranslationX(slidingView, dx);
                        invalidate();
                    }
                } else if (slidingView != null && (e == null || e.getPointerId(0) == startedTrackingPointerId && (e.getAction() == MotionEvent.ACTION_CANCEL || e.getAction() == MotionEvent.ACTION_UP || e.getAction() == MotionEvent.ACTION_POINTER_UP))) {
                    if (e != null && e.getAction() != MotionEvent.ACTION_CANCEL && Math.abs(slidingView.getNonAnimationTranslationX(false)) >= AndroidUtilities.dp(50)) {
                        showFieldPanelForReply(slidingView.getMessageObject());
                    }
                    endTrackingX = slidingView.getSlidingOffsetX();
                    if (endTrackingX == 0) {
                        slidingView = null;
                    }
                    lastTrackingAnimationTime = System.currentTimeMillis();
                    trackAnimationProgress = 0.0f;
                    invalidate();
                    maybeStartTrackingSlidingView = false;
                    startedTrackingSlidingView = false;
                    chatLayoutManager.setCanScrollVertically(true);
                }
            }

            @Override
            public boolean onTouchEvent(MotionEvent e) {
                textSelectionHelper.checkSelectionCancel(e);
                if (e.getAction() == MotionEvent.ACTION_DOWN) {
                    scrollByTouch = true;
                }
                if (pullingDownOffset != 0 && (e.getAction() == MotionEvent.ACTION_UP || e.getAction() == MotionEvent.ACTION_CANCEL)) {
                    float progress = Math.min(1f, pullingDownOffset / AndroidUtilities.dp(110));
                    if (e.getAction() == MotionEvent.ACTION_UP && progress == 1 && pullingDownDrawable != null && !pullingDownDrawable.emptyStub) {
                        if (pullingDownDrawable.animationIsRunning()) {
                            ValueAnimator animator = ValueAnimator.ofFloat(pullingDownOffset, pullingDownOffset + AndroidUtilities.dp(8));
                            pullingDownBackAnimator = animator;
                            animator.addUpdateListener(valueAnimator -> {
                                pullingDownOffset = (float) valueAnimator.getAnimatedValue();
                                chatListView.invalidate();
                            });
                            animator.setDuration(200);
                            animator.setInterpolator(CubicBezierInterpolator.DEFAULT);
                            animator.start();
                            pullingDownDrawable.runOnAnimationFinish(() -> {
                                animateToNextChat();
                            });
                        } else {
                            animateToNextChat();
                        }
                    } else {
                        if (pullingDownDrawable != null && pullingDownDrawable.emptyStub && (System.currentTimeMillis() - pullingDownDrawable.lastShowingReleaseTime) < 500 && pullingDownDrawable.animateSwipeToRelease) {
                            AnimatorSet animatorSet = new AnimatorSet();
                            pullingDownBackAnimator = animatorSet;
                            if (pullingDownDrawable != null) {
                                animatorPullingDownContainerVisibility.setValue(false, true);
                            }
                            ValueAnimator animator = ValueAnimator.ofFloat(pullingDownOffset, AndroidUtilities.dp(111));
                            animator.addUpdateListener(valueAnimator -> {
                                pullingDownOffset = (float) valueAnimator.getAnimatedValue();
                                chatListView.invalidate();
                            });
                            animator.setDuration(400);
                            animator.setInterpolator(CubicBezierInterpolator.DEFAULT);

                            ValueAnimator animator2 = ValueAnimator.ofFloat(AndroidUtilities.dp(111), 0);
                            animator2.addUpdateListener(valueAnimator -> {
                                pullingDownOffset = (float) valueAnimator.getAnimatedValue();
                                chatListView.invalidate();
                            });
                            animator2.setStartDelay(600);
                            animator2.setDuration(ChatListItemAnimator.DEFAULT_DURATION);
                            animator2.setInterpolator(ChatListItemAnimator.DEFAULT_INTERPOLATOR);

                            animatorSet.playSequentially(animator, animator2);
                            animatorSet.start();
                        } else {
                            ValueAnimator animator = ValueAnimator.ofFloat(pullingDownOffset, 0);
                            pullingDownBackAnimator = animator;
                            if (pullingDownDrawable != null) {
                                animatorPullingDownContainerVisibility.setValue(false, true);
                            }
                            animator.addUpdateListener(valueAnimator -> {
                                pullingDownOffset = (float) valueAnimator.getAnimatedValue();
                                chatListView.invalidate();
                            });
                            animator.setDuration(ChatListItemAnimator.DEFAULT_DURATION);
                            animator.setInterpolator(ChatListItemAnimator.DEFAULT_INTERPOLATOR);
                            animator.start();
                        }
                    }
                }
                if (isFastScrollAnimationRunning()) {
                    return false;
                }
                boolean result = super.onTouchEvent(e);
                if (actionBar.isActionModeShowed() || isReport()) {
                    return result;
                }
                processTouchEvent(e);
                return startedTrackingSlidingView || result;
            }

            @Override
            public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
                super.requestDisallowInterceptTouchEvent(disallowIntercept);
                if (slidingView != null) {
                    processTouchEvent(null);
                }
            }

            @Override
            protected void onChildPressed(View child, float x, float y, boolean pressed) {
                super.onChildPressed(child, x, y, pressed);
                if (child instanceof ChatMessageCell) {
                    ChatMessageCell chatMessageCell = (ChatMessageCell) child;
                    MessageObject object = chatMessageCell.getMessageObject();
                    if (object.isMusic() || object.isDocument()) {
                        return;
                    }
                    MessageObject.GroupedMessages groupedMessages = chatMessageCell.getCurrentMessagesGroup();
                    if (groupedMessages != null) {
                        int count = getChildCount();
                        for (int a = 0; a < count; a++) {
                            View item = getChildAt(a);
                            if (item == child || !(item instanceof ChatMessageCell)) {
                                continue;
                            }
                            ChatMessageCell cell = (ChatMessageCell) item;
                            if (cell.getCurrentMessagesGroup() == groupedMessages) {
                                cell.setPressed(pressed);
                            }
                        }
                    }
                }
            }

            @Override
            public void onDraw(Canvas c) {
                super.onDraw(c);
                if (slidingView != null) {
                    float translationX = slidingView.getSlidingOffsetX();
                    if (!maybeStartTrackingSlidingView && !startedTrackingSlidingView && endTrackingX != 0 && translationX != 0) {
                        long newTime = System.currentTimeMillis();
                        long dt = newTime - lastTrackingAnimationTime;
                        trackAnimationProgress += dt / 180.0f;
                        if (trackAnimationProgress > 1.0f) {
                            trackAnimationProgress = 1.0f;
                        }
                        lastTrackingAnimationTime = newTime;
                        translationX = endTrackingX * (1.0f - AndroidUtilities.decelerateInterpolator.getInterpolation(trackAnimationProgress));
                        if (translationX == 0) {
                            endTrackingX = 0;
                        }
                        setGroupTranslationX(slidingView, translationX);
                        slidingView.setSlidingOffset(translationX);
                        MessageObject messageObject = slidingView.getMessageObject();
                        if (messageObject.isRoundVideo() || messageObject.isVideo()) {
                            updateTextureViewPosition(false, false);
                        }

                        if (trackAnimationProgress == 1f || trackAnimationProgress == 0f) {
                            slidingView.setSlidingOffset(0);
                            slidingView = null;
                        }
                        invalidate();
                    }
                    drawReplyButton(c);
                }

                if (pullingDownOffset != 0 && !isInPreviewMode() && !isInsideContainer && chatMode != MODE_SAVED && chatMode != MODE_SCHEDULED) {
                    c.save();
                    float transitionOffset = 0;
                    if (pullingDownAnimateProgress != 0) {
                        transitionOffset = (
                            chatListView.getMeasuredHeight()
                                - pullingDownOffset
                                + (pullingDownAnimateToActivity == null ? 0 : pullingDownAnimateToActivity.pullingBottomOffset)
                        ) * pullingDownAnimateProgress;
                    }

                    c.translate(0, getMeasuredHeight() - blurredViewBottomOffset - transitionOffset);
                    if (pullingDownDrawable == null) {
                        pullingDownDrawable = new ChatPullingDownDrawable(currentAccount, fragmentView, dialog_id, dialogFolderId, dialogFilterId, getTopicId(), themeDelegate);
                        pullingDownDrawable.progressToBottomPanel = animatorPullingDownContainerVisibility.getFloatValue();
                        if (nextChannels != null && !nextChannels.isEmpty()) {
                            pullingDownDrawable.updateDialog(nextChannels.get(0));
                        } else if (isTopic) {
                            pullingDownDrawable.updateTopic();
                        } else {
                            pullingDownDrawable.updateDialog();
                        }
                        pullingDownDrawable.onAttach();
                    }
                    pullingDownDrawable.setWidth(getMeasuredWidth() - (isSideMenued() ? dp(SIDE_MENU_WIDTH) : 0));
                    float progress = Math.min(1f, pullingDownOffset / AndroidUtilities.dp(110));
                    c.translate(isSideMenued() ? lerp(dp(32), dp(SIDE_MENU_WIDTH), getSideMenuAlpha()) : 0,
                        -(windowInsetsStateHolder.getAnimatedMaxBottomInset() + dp(10) +
                        chatInputViewsContainer.getInputBubbleHeight()));
                    pullingDownDrawable.draw(c, chatListView, progress, 1f - pullingDownAnimateProgress);

                    c.restore();

                    if (pullingDownAnimateToActivity != null) {
                        c.saveLayerAlpha(0, 0, pullingDownAnimateToActivity.chatListView.getMeasuredWidth(), pullingDownAnimateToActivity.chatListView.getMeasuredHeight(), (int) (255 * pullingDownAnimateProgress), Canvas.ALL_SAVE_FLAG);
                        c.translate(0, getMeasuredHeight() - pullingDownOffset - transitionOffset);
                        pullingDownAnimateToActivity.chatListView.draw(c);
                        c.restore();
                    }
                } else if (pullingDownDrawable != null) {
                    pullingDownDrawable.reset();
                }
            }

            @Override
            public void draw(Canvas canvas) {
                if ((startMessageAppearTransitionMs == 0 || System.currentTimeMillis() - startMessageAppearTransitionMs <= SKELETON_DISAPPEAR_MS) && !AndroidUtilities.isTablet() && !isComments && currentUser == null) {
                    boolean noAvatar = (currentChat == null || ChatObject.isChannelAndNotMegaGroup(currentChat)) && chatMode != MODE_SEARCH;
                    if (pullingDownOffset != 0) {
                        canvas.save();
                        canvas.translate(0, -pullingDownOffset);
                    }
                    updateSkeletonColors();
                    updateSkeletonGradient();

                    int lastTop = getHeight() - blurredViewBottomOffset - (int) windowInsetsStateHolder.getAnimatedMaxBottomInset() - dp(44 + 7 + 9 - 3);
                    int j = 0;

                    int childMaxTop = Integer.MAX_VALUE;
                    for (int i = 0; i < getChildCount(); i++) {
                        int top = getChildAt(i).getTop();
                        if (top < childMaxTop) {
                            childMaxTop = top;
                        }
                    }
                    if (startMessageAppearTransitionMs == 0 && childMaxTop <= 0) {
                        checkDispatchHideSkeletons(fragmentBeginToShow);
                    }

                    Paint servicePaint = getThemedPaint(Theme.key_paint_chatActionBackground);
                    if (skeletonServicePaint.getColor() != servicePaint.getColor()) {
                        skeletonServicePaint.setColor(servicePaint.getColor());
                    }
                    if (skeletonServicePaint.getShader() != servicePaint.getShader()) {
                        skeletonServicePaint.setShader(servicePaint.getShader());
                        skeletonColorMatrix.setSaturation(SKELETON_SATURATION);
                        skeletonServicePaint.setColorFilter(new ColorMatrixColorFilter(skeletonColorMatrix));
                    }

                    for (int i = 0; i < getChildCount(); i++) {
                        View v = getChildAt(i);
//                        if (v instanceof ChatMessageCell) {
//                            ChatMessageCell cell = (ChatMessageCell) v;
//                            if ((cell.getCurrentMessagesGroup() == null || cell.getCurrentMessagesGroup().findPrimaryMessageObject() == cell.getMessageObject())) {
//                                if (cell.shouldDrawAlphaLayer() || System.currentTimeMillis() - startMessageAppearTransitionMs >= SKELETON_DISAPPEAR_MS) {
//                                    float progress = cell.getAlpha();
//
//                                    MessageSkeleton skeleton;
//                                    if (j >= messageSkeletons.size()) {
//                                        skeleton = getNewSkeleton(noAvatar);
//                                        messageSkeletons.add(skeleton);
//                                    } else {
//                                        skeleton = messageSkeletons.get(j);
//                                    }
//
//                                    Rect bounds = cell.getCurrentBackgroundDrawable(true).getBounds();
//                                    MessageObject.GroupedMessages group = cell.getCurrentMessagesGroup();
//
//                                    int alpha = skeletonPaint.getAlpha();
//                                    int wasServiceAlpha = servicePaint.getAlpha();
//                                    servicePaint.setAlpha((int) (wasServiceAlpha * 0.4f * (1f - progress)));
//                                    skeletonPaint.setAlpha((int) (alpha * (1f - progress)));
//                                    int bottom = (int) AndroidUtilities.lerp(Math.min(skeleton.lastBottom, lastTop - AndroidUtilities.dp(3f)), v.getBottom() + (group != null ? group.transitionParams.top + group.transitionParams.offsetTop : 0), progress);
//                                    int left = noAvatar ? AndroidUtilities.dp(3f) : AndroidUtilities.dp(51);
//                                    int top = (int) AndroidUtilities.lerp(bottom - skeleton.height, bounds.top + v.getTop() + (group != null ? group.transitionParams.top + group.transitionParams.offsetTop : 0), progress);
//                                    int right = skeleton.width;
//
//                                    boolean lerp = cell.getMessageObject() == null || !cell.getMessageObject().isOut();
//                                    skeletonBackgroundDrawable.setBounds(lerp ? AndroidUtilities.lerp(left, cell.getBackgroundDrawableLeft(), progress) : left, top,
//                                            lerp ? AndroidUtilities.lerp(right, cell.getBackgroundDrawableRight(), progress) : right, bottom);
//                                    Theme.applyServiceShaderMatrix(getMeasuredWidth(), AndroidUtilities.displaySize.y, 0, getY() + skeletonBackgroundDrawable.getBounds().top);
//                                    skeletonBackgroundDrawable.drawCached(canvas, skeletonBackgroundCacheParams, servicePaint);
//                                    skeletonBackgroundDrawable.drawCached(canvas, skeletonBackgroundCacheParams, skeletonPaint);
//                                    if (!noAvatar) {
//                                        Theme.applyServiceShaderMatrix(getMeasuredWidth(), AndroidUtilities.displaySize.y, 0, getY() + bottom - AndroidUtilities.dp(42));
//                                        canvas.drawCircle(AndroidUtilities.dp(48 - 21), bottom - AndroidUtilities.dp(21), AndroidUtilities.dp(21), servicePaint);
//                                        canvas.drawCircle(AndroidUtilities.dp(48 - 21), bottom - AndroidUtilities.dp(21), AndroidUtilities.dp(21), skeletonPaint);
//                                    }
//                                    servicePaint.setAlpha(wasServiceAlpha);
//                                    skeletonPaint.setAlpha(alpha);
//                                    j++;
//
//                                    if (top < lastTop) {
//                                        lastTop = top;
//                                    }
//
//                                    continue;
//                                }
//                                j++;
//                            }
//                        }
                        if (v instanceof ChatMessageCell) {
                            MessageObject.GroupedMessages group = ((ChatMessageCell) v).getCurrentMessagesGroup();
                            Rect bounds = ((ChatMessageCell) v).getCurrentBackgroundDrawable(true).getBounds();
                            int newTop = (int) (v.getTop() + bounds.top + (group != null ? group.transitionParams.top + group.transitionParams.offsetTop : 0));
                            int top = startMessageAppearTransitionMs == 0 && isSkeletonVisible() ? lerp(lastTop, newTop, v.getAlpha()) : v.getAlpha() == 1f ? newTop : lastTop;
                            if (top < lastTop) {
                                lastTop = top;
                            }
                        } else if (v instanceof ChatActionCell) {
                            int top = startMessageAppearTransitionMs == 0 && isSkeletonVisible() ? lerp(lastTop, v.getTop(), v.getAlpha()) : v.getAlpha() == 1f ? v.getTop() : lastTop;
                            if (top < lastTop) {
                                lastTop = top;
                            }
                        }
                    }

                    if (isSkeletonVisible()) {
                        boolean drawService = SharedConfig.getDevicePerformanceClass() != SharedConfig.PERFORMANCE_CLASS_LOW && Theme.hasGradientService();
                        boolean darkOverlay = ColorUtils.calculateLuminance(getThemedColor(Theme.key_windowBackgroundWhite)) <= 0.7f && Theme.hasGradientService();
                        boolean blackOverlay = ColorUtils.calculateLuminance(getThemedColor(Theme.key_windowBackgroundWhite)) <= 0.01f && Theme.hasGradientService();
                        if (drawService) {
                            Theme.applyServiceShaderMatrix(getMeasuredWidth(), AndroidUtilities.displaySize.y, 0, getY() - contentPanTranslation);
                        }
                        int wasDarkenAlpha = Theme.chat_actionBackgroundGradientDarkenPaint.getAlpha();
                        if (blackOverlay) {
                            Theme.chat_actionBackgroundGradientDarkenPaint.setAlpha((int) (wasDarkenAlpha * 4f));
                        }

                        float topSkeletonAlpha = startMessageAppearTransitionMs != 0 ? 1f - (System.currentTimeMillis() - startMessageAppearTransitionMs) / (float) SKELETON_DISAPPEAR_MS : 1f;
                        int alpha = skeletonPaint.getAlpha();
                        int wasServiceAlpha = skeletonServicePaint.getAlpha();
                        int wasOutlineAlpha = skeletonOutlinePaint.getAlpha();
                        float adaptDark = 1f;
                        if (themeDelegate != null && themeDelegate.isDark && skeletonServicePaint.getShader() != null) {
                            adaptDark *= .3f;
                        }
                        skeletonServicePaint.setAlpha((int) (0xFF * topSkeletonAlpha * adaptDark));
                        skeletonPaint.setAlpha((int) (topSkeletonAlpha * adaptDark * alpha));
                        skeletonOutlinePaint.setAlpha((int) (topSkeletonAlpha * alpha));
                        while (lastTop > blurredViewTopOffset) {
                            lastTop -= AndroidUtilities.dp(3f);

                            MessageSkeleton skeleton;
                            if (j >= messageSkeletons.size()) {
                                skeleton = getNewSkeleton(noAvatar);
                                messageSkeletons.add(skeleton);
                            } else {
                                skeleton = messageSkeletons.get(j);
                            }
                            skeleton.lastBottom = startMessageAppearTransitionMs != 0 ? messages.size() <= 2 ? Math.min(skeleton.lastBottom, lastTop) : skeleton.lastBottom : lastTop;

                            lastTop -= skeleton.height;

                            j++;
                        }

                        lastTop = messageSkeletons.isEmpty() ? getHeight() - blurredViewBottomOffset : messageSkeletons.get(0).lastBottom + AndroidUtilities.dp(3f);
                        int left = dp(noAvatar ? 3 : 51);
                        if (isSideMenued()) {
                            left = lerp(left, dp(SIDE_MENU_WIDTH), getSideMenuAlpha());
                        }
                        for (int i = 0; i < messageSkeletons.size() && lastTop > blurredViewTopOffset; i++) {
                            lastTop -= dp(3f);

                            MessageSkeleton skeleton = messageSkeletons.get(i);

                            int bottom = skeleton.lastBottom;
                            skeletonBackgroundDrawable.setBounds(left, bottom - skeleton.height, skeleton.width, bottom);
                            if (drawService) {
                                skeletonBackgroundDrawable.drawCached(canvas, skeletonBackgroundCacheParams, skeletonServicePaint);
                            }
                            skeletonBackgroundDrawable.drawCached(canvas, skeletonBackgroundCacheParams, skeletonPaint);
                            if (darkOverlay) {
                                skeletonBackgroundDrawable.drawCached(canvas, skeletonBackgroundCacheParams, Theme.chat_actionBackgroundGradientDarkenPaint);
                            }
                            skeletonBackgroundDrawable.drawCached(canvas, skeletonBackgroundCacheParams, skeletonOutlinePaint);

                            if (!noAvatar) {
                                if (drawService) {
                                    canvas.drawCircle(dp(48 - 21), bottom - dp(21), dp(21), skeletonServicePaint);
                                }
                                canvas.drawCircle(dp(48 - 21), bottom - dp(21), dp(21), skeletonPaint);
                                if (darkOverlay) {
                                    canvas.drawCircle(dp(48 - 21), bottom - dp(21), dp(21), Theme.chat_actionBackgroundGradientDarkenPaint);
                                }
                                canvas.drawCircle(dp(48 - 21), bottom - dp(21), dp(21), skeletonOutlinePaint);
                            }

                            lastTop -= skeleton.height;
                        }

                        skeletonServicePaint.setAlpha(wasServiceAlpha);
                        skeletonPaint.setAlpha(alpha);
                        skeletonOutlinePaint.setAlpha(wasOutlineAlpha);
                        Theme.chat_actionBackgroundGradientDarkenPaint.setAlpha(wasDarkenAlpha);
                        invalidated = false;
                        invalidate();
                    } else if (System.currentTimeMillis() - startMessageAppearTransitionMs > SKELETON_DISAPPEAR_MS) {
                        messageSkeletons.clear();
                    }
                    lastSkeletonCount = messageSkeletons.size();
                    lastSkeletonMessageCount = messages.size();
                    if (pullingDownOffset != 0) {
                        canvas.restore();
                    }
                }
                super.draw(canvas);
            }

            private void updateSkeletonColors() {
                boolean dark = ColorUtils.calculateLuminance(getThemedColor(Theme.key_windowBackgroundWhite)) <= 0.7f;
                int color0 = ColorUtils.blendARGB(getThemedColor(Theme.key_listSelector), Color.argb(dark ? 0x21 : 0x03, 0xFF, 0xFF, 0xFF), dark ? 0.9f : 0.5f);
                int color1 = ColorUtils.setAlphaComponent(getThemedColor(Theme.key_listSelector), dark ? 24 : SKELETON_LIGHT_OVERLAY_ALPHA);
                if (skeletonColor1 != color1 || skeletonColor0 != color0) {
                    skeletonColor0 = color0;
                    skeletonColor1 = color1;
                    skeletonGradient = new LinearGradient(0, 0, skeletonGradientWidth = AndroidUtilities.dp(200), 0, new int[]{color1, color0, color0, color1}, new float[]{0.0f, 0.4f, 0.6f, 1f}, Shader.TileMode.CLAMP);
                    skeletonTotalTranslation = -skeletonGradientWidth * 2;
                    skeletonPaint.setShader(skeletonGradient);

                    int outlineColor = Color.argb(dark ? 0x2B : 0x60, 0xFF, 0xFF, 0xFF);
                    skeletonOutlineGradient = new LinearGradient(0, 0, skeletonGradientWidth, 0, new int[]{Color.TRANSPARENT, outlineColor, outlineColor, Color.TRANSPARENT}, new float[]{0.0f, 0.4f, 0.6f, 1f}, Shader.TileMode.CLAMP);
                    skeletonOutlinePaint.setShader(skeletonOutlineGradient);
                }
            }

            private void updateSkeletonGradient() {
                long newUpdateTime = SystemClock.elapsedRealtime();
                long dt = Math.abs(skeletonLastUpdateTime - newUpdateTime);
                if (dt > 17) {
                    dt = 16;
                }
                if (dt < 4) {
                    dt = 0;
                }
                int width = getWidth();
                skeletonLastUpdateTime = newUpdateTime;
                skeletonTotalTranslation += dt * width / 400.0f;
                if (skeletonTotalTranslation >= width * 2) {
                    skeletonTotalTranslation = -skeletonGradientWidth * 2;
                }
                skeletonMatrix.setTranslate(skeletonTotalTranslation, 0);
                if (skeletonGradient != null) {
                    skeletonGradient.setLocalMatrix(skeletonMatrix);
                }
                skeletonOutlineMatrix.setTranslate(skeletonTotalTranslation, 0);
                if (skeletonOutlineGradient != null) {
                    skeletonOutlineGradient.setLocalMatrix(skeletonOutlineMatrix);
                }
            }


            @Override
            protected void dispatchDraw(Canvas canvas) {
                drawLaterRoundProgressCell = null;
                invalidated = false;

                canvas.save();
                if ((fragmentTransition == null || (fromPullingDownTransition && !toPullingDownTransition)) && !isInsideContainer) {
                    // canvas.clipRect(0, chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(4), getMeasuredWidth(), getMeasuredHeight() - blurredViewBottomOffset);
                }
                selectorRect.setEmpty();
                if (pullingDownOffset != 0) {
                    int restoreToCount = canvas.save();
                    float transitionOffset = 0;
                    if (pullingDownAnimateProgress != 0) {
                        transitionOffset = (chatListView.getMeasuredHeight() - pullingDownOffset) * pullingDownAnimateProgress;
                    }
                    canvas.translate(0, drawingChatListViewYoffset = -pullingDownOffset - transitionOffset);
                    drawChatBackgroundElements(canvas);
                    super.dispatchDraw(canvas);
                    drawChatForegroundElements(canvas);
                    canvas.restoreToCount(restoreToCount);
                } else {
                    drawChatBackgroundElements(canvas);
                    super.dispatchDraw(canvas);
                    drawChatForegroundElements(canvas);
                }
                canvas.restore();
            }

            protected void drawChatForegroundElements(Canvas canvas) {
                int size = drawTimeAfter.size();
                if (size > 0) {
                    for (int a = 0; a < size; a++) {
                        ChatMessageCell cell = drawTimeAfter.get(a);
                        canvas.save();
                        canvas.translate(cell.getLeft() + cell.getNonAnimationTranslationX(false), cell.getY() + cell.getPaddingTop());
                        cell.drawTime(canvas, cell.shouldDrawAlphaLayer() ? cell.getAlpha() : 1f, true);
                        canvas.restore();
                    }
                    drawTimeAfter.clear();
                }
                size = drawNamesAfter.size();
                if (size > 0) {
                    for (int a = 0; a < size; a++) {
                        ChatMessageCell cell = drawNamesAfter.get(a);
                        float canvasOffsetX = cell.getLeft() + cell.getNonAnimationTranslationX(false);
                        float canvasOffsetY = cell.getY() + cell.getPaddingTop();
                        float alpha = cell.shouldDrawAlphaLayer() ? cell.getAlpha() : 1f;

                        canvas.save();
                        canvas.translate(canvasOffsetX, canvasOffsetY);
                        cell.setInvalidatesParent(true);
                        cell.drawNamesLayout(canvas, alpha);
                        cell.setInvalidatesParent(false);
                        canvas.restore();
                    }
                    drawNamesAfter.clear();
                }
                size = drawCaptionAfter.size();
                if (size > 0) {
                    for (int a = 0; a < size; a++) {
                        ChatMessageCell cell = drawCaptionAfter.get(a);
                        boolean selectionOnly = false;
                        if (cell.getCurrentPosition() != null) {
                            selectionOnly = (cell.getCurrentPosition().flags & MessageObject.POSITION_FLAG_LEFT) == 0;
                        }
                        float alpha = cell.shouldDrawAlphaLayer() ? cell.getAlpha() : 1f;
                        float canvasOffsetX = cell.getLeft() + cell.getNonAnimationTranslationX(false);
                        float canvasOffsetY = cell.getY() + cell.getPaddingTop();
                        canvas.save();
                        MessageObject.GroupedMessages groupedMessages = cell.getCurrentMessagesGroup();
                        if (groupedMessages != null && groupedMessages.transitionParams.backgroundChangeBounds) {
                            float x = cell.getNonAnimationTranslationX(true);
                            float l = (groupedMessages.transitionParams.left + x + groupedMessages.transitionParams.offsetLeft);
                            float t = (groupedMessages.transitionParams.top + groupedMessages.transitionParams.offsetTop);
                            float r = (groupedMessages.transitionParams.right + x + groupedMessages.transitionParams.offsetRight);
                            float b = (groupedMessages.transitionParams.bottom + groupedMessages.transitionParams.offsetBottom);

                            if (!groupedMessages.transitionParams.backgroundChangeBounds) {
                                t += cell.getTranslationY();
                                b += cell.getTranslationY();
                            }
                            canvas.clipRect(
                                    l + AndroidUtilities.dp(8), t + AndroidUtilities.dp(8),
                                    r - AndroidUtilities.dp(8), b - AndroidUtilities.dp(8)
                            );
                        }
                        if (cell.getTransitionParams().wasDraw) {
                            canvas.translate(canvasOffsetX, canvasOffsetY);
                            cell.setInvalidatesParent(true);
                            cell.drawCaptionLayout(canvas, selectionOnly, alpha);
                            cell.setInvalidatesParent(false);
                        }
                        canvas.restore();
                    }
                    drawCaptionAfter.clear();
                }
                size = drawReactionsAfter.size();
                if (size > 0) {
                    for (int a = 0; a < size; a++) {
                        ChatMessageCell cell = drawReactionsAfter.get(a);
                        boolean selectionOnly = false;
                        if (cell.getCurrentPosition() != null) {
                            selectionOnly = (cell.getCurrentPosition().flags & MessageObject.POSITION_FLAG_LEFT) == 0;
                        }
                        float alpha = cell.shouldDrawAlphaLayer() ? cell.getAlpha() : 1f;
                        float canvasOffsetX = cell.getLeft() + cell.getNonAnimationTranslationX(false);
                        float canvasOffsetY = cell.getY() + cell.getPaddingTop();
                        canvas.save();
                        MessageObject.GroupedMessages groupedMessages = cell.getCurrentMessagesGroup();
                        if (groupedMessages != null && groupedMessages.transitionParams.backgroundChangeBounds) {
                            float x = cell.getNonAnimationTranslationX(true);
                            float l = (groupedMessages.transitionParams.left + x + groupedMessages.transitionParams.offsetLeft);
                            float t = (groupedMessages.transitionParams.top + groupedMessages.transitionParams.offsetTop);
                            float r = (groupedMessages.transitionParams.right + x + groupedMessages.transitionParams.offsetRight);
                            float b = (groupedMessages.transitionParams.bottom + groupedMessages.transitionParams.offsetBottom);

                            if (!groupedMessages.transitionParams.backgroundChangeBounds) {
                                t += cell.getTranslationY();
                                b += cell.getTranslationY();
                            }
                            canvas.clipRect(
                                    l + AndroidUtilities.dp(8), t + AndroidUtilities.dp(8),
                                    r - AndroidUtilities.dp(8), b - AndroidUtilities.dp(8)
                            );
                        }
                        if (!selectionOnly && cell.getTransitionParams().wasDraw) {
                            canvas.translate(canvasOffsetX, canvasOffsetY);
                            cell.setInvalidatesParent(true);
                            cell.drawReactionsLayout(canvas, alpha, null);
                            cell.drawCommentLayout(canvas, alpha);
                            cell.setInvalidatesParent(false);
                        }
                        canvas.restore();
                    }
                    drawReactionsAfter.clear();
                }
            }

            protected void drawChatBackgroundElements(Canvas canvas) {
                final int count = getChildCount();
                MessageObject.GroupedMessages lastDrawnGroup = null;

                for (int a = 0; a < count; a++) {
                    View child = getChildAt(a);
                    if (child.getVisibility() == View.INVISIBLE || child.getVisibility() == View.GONE) {
                        continue;
                    }
                    if (chatAdapter.isBot && child instanceof BotHelpCell) {
                        BotHelpCell botCell = (BotHelpCell) child;
                        float top = (getMeasuredHeight() - chatListViewPaddingTop - blurredViewBottomOffset) / 2 - child.getMeasuredHeight() / 2 + chatListViewPaddingTop;
                        if (!botCell.animating() && !chatListView.fastScrollAnimationRunning) {
                            if (child.getTop() > top) {
                                child.setTranslationY(top - child.getTop());
                            } else {
                                child.setTranslationY(0);
                            }
                        }
                        break;
                    } else if (child instanceof UserInfoCell) {
                        UserInfoCell cell = (UserInfoCell) child;
                        float top = (getMeasuredHeight() - chatListViewPaddingTop - blurredViewBottomOffset) / 2 - child.getMeasuredHeight() / 2 + chatListViewPaddingTop;
                        if (!cell.animating() && !chatListView.fastScrollAnimationRunning) {
                            if (child.getTop() > top) {
                                child.setTranslationY(top - child.getTop());
                            } else {
                                child.setTranslationY(0);
                            }
                        }
                    } else if (child instanceof ChatMessageCell) {
                        ChatMessageCell cell = (ChatMessageCell) child;
                        MessageObject.GroupedMessages group = cell.getCurrentMessagesGroup();
                        if (group == null || group != lastDrawnGroup) {
                            lastDrawnGroup = group;
                            MessageObject.GroupedMessagePosition position = cell.getCurrentPosition();
                            MessageBackgroundDrawable backgroundDrawable = cell.getBackgroundDrawable();
                            if ((backgroundDrawable.isAnimationInProgress() || cell.isDrawingSelectionBackground()) && (position == null || (position.flags & MessageObject.POSITION_FLAG_RIGHT) != 0)) {
                                if (cell.isHighlighted() || cell.isHighlightedAnimated()) {
                                    if (position == null) {
                                        Paint backgroundPaint = getThemedPaint(Theme.key_paint_chatMessageBackgroundSelected);
                                        if (themeDelegate != null && themeDelegate.isDark || backgroundPaint == null) {
                                            backgroundPaint = Theme.chat_replyLinePaint;
                                            backgroundPaint.setColor(getThemedColor(Theme.key_chat_selectedBackground));
                                        } else {
                                            float viewTop = (isKeyboardVisible() ? chatListView.getTop() : actionBar.getMeasuredHeight()) - contentView.getBackgroundTranslationY();
                                            int backgroundHeight = contentView.getBackgroundSizeY();
                                            if (themeDelegate != null) {
                                                themeDelegate.applyServiceShaderMatrix(getMeasuredWidth(), backgroundHeight, cell.getX(), viewTop);
                                            } else {
                                                Theme.applyServiceShaderMatrix(getMeasuredWidth(), backgroundHeight, cell.getX(), viewTop);
                                            }
                                        }
                                        canvas.save();
                                        canvas.translate(0, cell.getTranslationY());
                                        int wasAlpha = backgroundPaint.getAlpha();
                                        backgroundPaint.setAlpha((int) (wasAlpha * cell.getHighlightAlpha() * cell.getAlpha()));
                                        canvas.drawRect(0, cell.getTop(), getMeasuredWidth(), cell.getBottom(), backgroundPaint);
                                        backgroundPaint.setAlpha(wasAlpha);
                                        canvas.restore();
                                    }
                                } else {
                                    int y = (int) cell.getY();
                                    int height;
                                    canvas.save();
                                    if (position == null) {
                                        height = cell.getMeasuredHeight();
                                    } else {
                                        height = y + cell.getMeasuredHeight();
                                        long time = 0;
                                        float touchX = 0;
                                        float touchY = 0;
                                        for (int i = 0; i < count; i++) {
                                            View inner = getChildAt(i);
                                            if (inner instanceof ChatMessageCell) {
                                                ChatMessageCell innerCell = (ChatMessageCell) inner;
                                                MessageObject.GroupedMessages innerGroup = innerCell.getCurrentMessagesGroup();
                                                if (innerGroup == group) {
                                                    MessageBackgroundDrawable drawable = innerCell.getBackgroundDrawable();
                                                    y = Math.min(y, (int) innerCell.getY());
                                                    height = Math.max(height, (int) innerCell.getY() + innerCell.getMeasuredHeight());
                                                    long touchTime = drawable.getLastTouchTime();
                                                    if (touchTime > time) {
                                                        touchX = drawable.getTouchX() + innerCell.getX();
                                                        touchY = drawable.getTouchY() + innerCell.getY();
                                                        time = touchTime;
                                                    }
                                                }
                                            }
                                        }
                                        backgroundDrawable.setTouchCoordsOverride(touchX, touchY - y);
                                        height -= y;
                                    }
                                    canvas.clipRect(0, y, getMeasuredWidth(), y + height);
                                    Paint selectedBackgroundPaint = getThemedPaint(Theme.key_paint_chatMessageBackgroundSelected);
                                    if (themeDelegate != null && !themeDelegate.isDark && selectedBackgroundPaint != null) {
                                        backgroundDrawable.setCustomPaint(selectedBackgroundPaint);
                                        float viewTop = (isKeyboardVisible() ? chatListView.getTop() : actionBar.getMeasuredHeight()) - contentView.getBackgroundTranslationY();
                                        int backgroundHeight = contentView.getBackgroundSizeY();
                                        if (themeDelegate != null) {
                                            themeDelegate.applyServiceShaderMatrix(getMeasuredWidth(), backgroundHeight, cell.getX(), viewTop);
                                        } else {
                                            Theme.applyServiceShaderMatrix(getMeasuredWidth(), backgroundHeight, cell.getX(), viewTop);
                                        }
                                    } else {
                                        backgroundDrawable.setCustomPaint(null);
                                        backgroundDrawable.setColor(getThemedColor(Theme.key_chat_selectedBackground));
                                    }
                                    backgroundDrawable.setBounds(0, y, getMeasuredWidth(), y + height);
                                    backgroundDrawable.draw(canvas);
                                    canvas.restore();
                                }
                            }
                        }
                        if ((scrimView != cell || scrimViewTask != null) && group == null && cell.drawBackgroundInParent()) {
                            canvas.save();
                            canvas.translate(cell.getX(), cell.getY() + cell.getPaddingTop());
                            if (cell.getScaleX() != 1f) {
                                canvas.scale(
                                    cell.getScaleX(), cell.getScaleY(),
                                    cell.getPivotX(), (cell.getHeight() >> 1)
                                );
                            }
                            cell.drawBackgroundInternal(canvas, true);
                            canvas.restore();
                        }
                    } else if (child instanceof ChatActionCell) {
                        ChatActionCell cell = (ChatActionCell) child;
                        if (cell.hasGradientService()) {
                            canvas.save();
                            canvas.translate(cell.getX(), cell.getY() + cell.getPaddingTop());
                            canvas.scale(cell.getScaleX(), cell.getScaleY(), cell.getMeasuredWidth() / 2f, cell.getMeasuredHeight() / 2f);
                            canvas.translate(getSideMenuWidth() / 2f, 0);
                            cell.drawBackground(canvas, true);
                            cell.drawReactions(canvas, true, null);
                            canvas.restore();
                        }
                    }
                }
                MessageObject.GroupedMessages scrimGroup = null;
                if (scrimView instanceof ChatMessageCell) {
                    scrimGroup = ((ChatMessageCell) scrimView).getCurrentMessagesGroup();
                }
                for (int k = 0; k < 3; k++) {
                    drawingGroups.clear();
                    if (k == 2 && !chatListView.isFastScrollAnimationRunning()) {
                        continue;
                    }
                    for (int i = 0; i < count; i++) {
                        View child = chatListView.getChildAt(i);
                        if (child instanceof ChatMessageCell) {
                            ChatMessageCell cell = (ChatMessageCell) child;
                            if (child.getY() > chatListView.getHeight() || child.getY() + child.getHeight() < 0 || cell.getVisibility() == View.GONE) {
                                continue;
                            }
                            MessageObject.GroupedMessages group = cell.getCurrentMessagesGroup();
                            if (group == null || (k == 0 && group.messages.size() == 1) || (k == 1 && !group.transitionParams.drawBackgroundForDeletedItems)) {
                                continue;
                            }
                            if ((k == 0 && cell.getMessageObject().deleted) || (k == 1 && !cell.getMessageObject().deleted)) {
                                continue;
                            }
                            if ((k == 2 && !cell.willRemovedAfterAnimation()) || (k != 2 && cell.willRemovedAfterAnimation())) {
                                continue;
                            }

                            if (!drawingGroups.contains(group)) {
                                group.transitionParams.left = 0;
                                group.transitionParams.top = 0;
                                group.transitionParams.right = 0;
                                group.transitionParams.bottom = 0;

                                group.transitionParams.pinnedBotton = false;
                                group.transitionParams.pinnedTop = false;
                                group.transitionParams.cell = cell;
                                drawingGroups.add(group);
                            }

                            group.transitionParams.pinnedTop = cell.isPinnedTop();
                            group.transitionParams.pinnedBotton = cell.isPinnedBottom();

                            int left = (cell.getLeft() + cell.getBackgroundDrawableLeft());
                            int right = (cell.getLeft() + cell.getBackgroundDrawableRight());
                            int top = (cell.getTop() + cell.getPaddingTop() + cell.getBackgroundDrawableTop());
                            int bottom = (cell.getTop() + cell.getPaddingTop() + cell.getBackgroundDrawableBottom());

                            if ((cell.getCurrentPosition().flags & MessageObject.POSITION_FLAG_TOP) == 0) {
                                top -= AndroidUtilities.dp(10);
                            }

                            if ((cell.getCurrentPosition().flags & MessageObject.POSITION_FLAG_BOTTOM) == 0) {
                                bottom += AndroidUtilities.dp(10);
                            }

                            if (cell.willRemovedAfterAnimation()) {
                                group.transitionParams.cell = cell;
                            }

                            if (group.transitionParams.top == 0 || top < group.transitionParams.top) {
                                group.transitionParams.top = top;
                            }
                            if (group.transitionParams.bottom == 0 || bottom > group.transitionParams.bottom) {
                                group.transitionParams.bottom = bottom;
                            }
                            if (group.transitionParams.left == 0 || left < group.transitionParams.left) {
                                group.transitionParams.left = left;
                            }
                            if (group.transitionParams.right == 0 || right > group.transitionParams.right) {
                                group.transitionParams.right = right;
                            }
                        }
                    }

                    for (int i = 0; i < drawingGroups.size(); i++) {
                        final MessageObject.GroupedMessages group = drawingGroups.get(i);
                        if (group == scrimGroup) {
                             // continue;
                        }
                        float x = group.transitionParams.cell.getNonAnimationTranslationX(true);
                        float l = (group.transitionParams.left + x + group.transitionParams.offsetLeft);
                        float t = (group.transitionParams.top + group.transitionParams.offsetTop);
                        float r = (group.transitionParams.right + x + group.transitionParams.offsetRight);
                        float b = (group.transitionParams.bottom + group.transitionParams.offsetBottom);

                        if (!group.transitionParams.backgroundChangeBounds) {
                            t += group.transitionParams.cell.getTranslationY();
                            b += group.transitionParams.cell.getTranslationY();
                        }

                        /*
                        if (t < chatListViewPaddingTop - chatListViewPaddingVisibleOffset - dp(20)) {
                            t = chatListViewPaddingTop - chatListViewPaddingVisibleOffset - dp(20);
                        }
                        */

                        if (b > chatListView.getMeasuredHeight() + dp(20)) {
                            b = chatListView.getMeasuredHeight() + dp(20);
                        }

                        boolean useScale = group.transitionParams.cell.getScaleX() != 1f || group.transitionParams.cell.getScaleY() != 1f;
                        if (useScale) {
                            canvas.save();
                            canvas.scale(group.transitionParams.cell.getScaleX(), group.transitionParams.cell.getScaleY(), l + (r - l) / 2, t + (b - t) / 2);
                        }
                        boolean selected = true;
                        for (int a = 0, N = group.messages.size(); a < N; a++) {
                            MessageObject object = group.messages.get(a);
                            int index = object.getDialogId() == dialog_id ? 0 : 1;
                            if (selectedMessagesIds[index].indexOfKey(object.getId()) < 0) {
                                selected = false;
                                break;
                            }
                        }
                        group.transitionParams.cell.drawBackground(canvas, (int) l, (int) t, (int) r, (int) b, group.transitionParams.pinnedTop, group.transitionParams.pinnedBotton, selected, 0);
                        if (group != scrimGroup) {
                            group.transitionParams.cell = null;
                        }
                        group.transitionParams.drawCaptionLayout = group.hasCaption;
                        if (useScale) {
                            canvas.restore();
                            for (int ii = 0; ii < count; ii++) {
                                View child = chatListView.getChildAt(ii);
                                if (child instanceof ChatMessageCell && ((ChatMessageCell) child).getCurrentMessagesGroup() == group) {
                                    ChatMessageCell cell = ((ChatMessageCell) child);
                                    int left = cell.getLeft();
                                    int top = cell.getTop();
                                    child.setPivotX(l - left + (r - l) / 2);
                                    child.setPivotY(t - top + (b - t) / 2);
                                }
                            }
                        }
                    }
                }
            }

            @Override
            public boolean drawChild(Canvas canvas, View child, long drawingTime) {
                if (isSkeletonVisible()) {
                    invalidated = false;
                    invalidate();
                }

                int clipLeft = 0;
                int clipBottom = 0;
                boolean skipDraw = child == scrimView && scrimViewTask == null;
                ChatMessageCell cell;
                ChatActionCell actionCell = null;
                float cilpTop = 0; // chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(4);
                boolean isAnimatingBounds = false;
                if (child instanceof ChatMessageCell) {
                    cell = (ChatMessageCell) child;
                    isAnimatingBounds = cell.transitionParams.animateBackgroundBoundsInner;
                }
                if (!SizeNotifierFrameLayout.drawingBlur && (child.getY() > getMeasuredHeight() || child.getY() + child.getMeasuredHeight() < cilpTop) && !isAnimatingBounds || child.getVisibility() == View.INVISIBLE || child.getVisibility() == View.GONE) {
                    skipDraw = true;
                }

                MessageObject.GroupedMessages group = null;

                if (child instanceof ChatMessageCell) {
                    cell = (ChatMessageCell) child;
                    if (animateSendingViews.contains(cell)) {
                        skipDraw = true;
                    }
                    MessageObject.GroupedMessagePosition position = cell.getCurrentPosition();
                    group = cell.getCurrentMessagesGroup();
                    if (position != null) {
                        if (position.pw != position.spanSize && position.spanSize == 1000 && position.siblingHeights == null && group.hasSibling) {
                            clipLeft = cell.getBackgroundDrawableLeft();
                        } else if (position.siblingHeights != null) {
                            clipBottom = child.getBottom() - AndroidUtilities.dp(1 + (cell.isPinnedBottom() ? 1 : 0));
                        }
                    }
                    if (cell.needDelayRoundProgressDraw()) {
                        drawLaterRoundProgressCell = cell;
                    }
                    if (!skipDraw && scrimView instanceof ChatMessageCell && scrimViewTask == null) {
                        ChatMessageCell cell2 = (ChatMessageCell) scrimView;
                        if (cell2.getCurrentMessagesGroup() != null && cell2.getCurrentMessagesGroup() == group) {
                            skipDraw = true;
                        }
                    }
                    if (skipDraw) {
                        cell.getPhotoImage().skipDraw();
                    }
                } else if (child instanceof ChatActionCell) {
                    actionCell = (ChatActionCell) child;
                    cell = null;
                } else {
                    cell = null;
                }
                if (clipLeft != 0) {
                    canvas.save();
                } else if (clipBottom != 0) {
                    canvas.save();
                }

                if (skipDraw) {
                    /*if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                        if (DownscaleScrollableNoiseSuppressor.isRecordingCanvas(canvas)) {
                            skipDraw = false;
                        }
                    }*/
                    skipDraw = false;
                }

                boolean result;
                if (!skipDraw) {
                    boolean clipToGroupBounds = (cell != null && !cell.transitionParams.needsStopClipping) && (group != null && group.transitionParams.backgroundChangeBounds);
                    if (clipToGroupBounds) {
                        canvas.save();
                        float x = cell.getNonAnimationTranslationX(true);
                        float l = (group.transitionParams.left + x + group.transitionParams.offsetLeft);
                        float t = (group.transitionParams.top + group.transitionParams.offsetTop);
                        float r = (group.transitionParams.right + x + group.transitionParams.offsetRight);
                        float b = (group.transitionParams.bottom + group.transitionParams.offsetBottom);

                        canvas.clipRect(
                                l + AndroidUtilities.dp(4),
                                t + AndroidUtilities.dp(4),
                                r - AndroidUtilities.dp(4),
                                b - AndroidUtilities.dp(4)
                        );
                    }
                    if (cell != null && cell.transitionParams.needsStopClipping) {
                        canvas.save();
                        canvas.translate(cell.getX(), cell.getY());
                        cell.drawInternal(canvas);
                        canvas.restore();
                        result = cell.transitionParams.animateChange;
                    } else if (cell != null && clipToGroupBounds) {
                        cell.clipToGroupBounds = true;
                        result = super.drawChild(canvas, child, drawingTime);
                        cell.clipToGroupBounds = false;
                    } else {
                        result = super.drawChild(canvas, child, drawingTime);
                    }
                    if (clipToGroupBounds) {
                        canvas.restore();
                    }
                    if (cell != null && cell.hasOutboundsContent()) {
                        canvas.save();
                        canvas.translate(cell.getX(), cell.getY() + cell.getPaddingTopAnimated());
                        cell.drawOutboundsContent(canvas);
                        canvas.restore();
                    } else if (actionCell != null) {
                        canvas.save();
                        canvas.translate(actionCell.getX(), actionCell.getY());
                        actionCell.drawOutboundsContent(canvas);
                        canvas.restore();
                    }
                } else {
                    result = false;
                }
                if (clipLeft != 0 || clipBottom != 0) {
                    canvas.restore();
                }

                if (child.getTranslationY() != 0) {
                    canvas.save();
                    canvas.translate(0, child.getTranslationY());
                }

                if (cell != null) {
                    cell.drawCheckBox(canvas);
                }

                if (child.getTranslationY() != 0) {
                    canvas.restore();
                }

                if (child.getTranslationY() != 0) {
                    canvas.save();
                    canvas.translate(0, child.getTranslationY());
                }

                if (cell != null) {
                    MessageObject message = cell.getMessageObject();
                    MessageObject.GroupedMessagePosition position = cell.getCurrentPosition();
                    if (!skipDraw) {
                        if (position != null || cell.getTransitionParams().animateBackgroundBoundsInner) {
                            if (position == null || (position.last || position.minX == 0 && position.minY == 0)) {
                                if (position == null || position.last) {
                                    drawTimeAfter.add(cell);
                                }
                                if ((position == null || (position.minX == 0 && position.minY == 0)) && cell.hasNameLayout()) {
                                    drawNamesAfter.add(cell);
                                }
                            }
                            if (position != null || cell.getTransitionParams().transformGroupToSingleMessage || cell.getTransitionParams().animateBackgroundBoundsInner) {
                                if (position == null || (position.flags & cell.captionFlag()) != 0) {
                                    drawCaptionAfter.add(cell);
                                }
                                if (position == null || (position.flags & MessageObject.POSITION_FLAG_BOTTOM) != 0 && (position.flags & MessageObject.POSITION_FLAG_LEFT) != 0) {
                                    drawReactionsAfter.add(cell);
                                }
                            }
                        }

                        if (videoPlayerContainer != null && (message.isRoundVideo() || message.isVideo()) && !message.isVoiceTranscriptionOpen() && MediaController.getInstance().isPlayingMessage(message)) {
                            ImageReceiver imageReceiver = cell.getPhotoImage();
                            float newX = imageReceiver.getImageX() + cell.getX();
                            float newY = cell.getY() + cell.getPaddingTop() + imageReceiver.getImageY() + chatListView.getY() - videoPlayerContainer.getTop();
                            if (videoPlayerContainer.getTranslationX() != newX || videoPlayerContainer.getTranslationY() != newY) {
                                videoPlayerContainer.setTranslationX(newX);
                                videoPlayerContainer.setTranslationY(newY);
                                fragmentView.invalidate();
                                videoPlayerContainer.invalidate();
                            }
                        }
                    }
                    ImageReceiver imageReceiver = cell.getAvatarImage();
                    if (imageReceiver != null && getSideMenuAlpha() < 1.f) {
                        MessageObject.GroupedMessages groupedMessages = getValidGroupedMessage(message);
                        boolean updateVisibility = !cell.getMessageObject().deleted && chatListView.getChildAdapterPosition(cell) != RecyclerView.NO_POSITION;

                        boolean replaceAnimation = chatListView.isFastScrollAnimationRunning() || (groupedMessages != null && groupedMessages.transitionParams.backgroundChangeBounds);
                        int top = (replaceAnimation ? child.getTop() : (int) child.getY()) + child.getPaddingTop();
                        if (cell.drawPinnedBottom()) {
                            int p;
                            if (cell.willRemovedAfterAnimation()) {
                                p = chatScrollHelper.positionToOldView.indexOfValue(child);
                                if (p >= 0) {
                                    p = chatScrollHelper.positionToOldView.keyAt(p);
                                }
                            } else {
                                ViewHolder holder = chatListView.getChildViewHolder(child);
                                p = holder.getAdapterPosition();
                            }

                            if (p >= 0) {
                                int nextPosition;
                                if (groupedMessages != null && position != null) {
                                    int idx = groupedMessages.posArray.indexOf(position);
                                    int size = groupedMessages.posArray.size();
                                    if ((position.flags & MessageObject.POSITION_FLAG_BOTTOM) != 0) {
                                        nextPosition = p - size + idx;
                                    } else {
                                        nextPosition = p - 1;
                                        for (int a = idx + 1; a < size; a++) {
                                            if (groupedMessages.posArray.get(a).minY > position.maxY) {
                                                break;
                                            } else {
                                                nextPosition--;
                                            }
                                        }
                                    }
                                } else {
                                    nextPosition = p - 1;
                                }
                                if (cell.willRemovedAfterAnimation()) {
                                     View view = chatScrollHelper.positionToOldView.get(nextPosition);
                                     if (view != null) {
                                         if (child.getTranslationY() != 0) {
                                             canvas.restore();
                                         }
                                         imageReceiver.setVisible(false, false);
                                         return result;
                                     }
                                } else {
                                    ViewHolder holder = chatListView.findViewHolderForAdapterPosition(nextPosition);
                                    if (holder != null) {
                                        if (child.getTranslationY() != 0) {
                                            canvas.restore();
                                        }
                                        imageReceiver.setVisible(false, false);
                                        return result;
                                    }
                                }
                            }
                        }
                        float tx = cell.getSlidingOffsetX() + cell.getCheckBoxTranslation();
                        int y = (int) ((replaceAnimation ? child.getTop() : child.getY()) + (child instanceof ChatMessageCell ? ((ChatMessageCell) child).getPaddingTopAnimated() : child.getPaddingTop()) + cell.getLayoutHeight() + cell.getTransitionParams().deltaBottom);
                        int maxY = chatListView.getMeasuredHeight() - chatListView.getPaddingBottom();
                        boolean canUpdateTx = cell.isCheckBoxVisible() && tx == 0;
                        if (cell.isPlayingRound() || cell.getTransitionParams().animatePlayingRound) {
                            if (cell.getTransitionParams().animatePlayingRound) {
                                float progressLocal = cell.getTransitionParams().animateChangeProgress;
                                if (!cell.isPlayingRound()) {
                                    progressLocal = 1f - progressLocal;
                                }
                                int fromY = y;
                                int toY = Math.min(y, maxY);
                                y = (int) (fromY * progressLocal + toY * (1f - progressLocal));
                            }
                        } else {
                            if (y > maxY) {
                                y = maxY;
                            }
                        }

                        if (!replaceAnimation && child.getTranslationY() != 0) {
                            canvas.restore();
                        }
                        if (cell.drawPinnedTop()) {
                            int p;
                            if (cell.willRemovedAfterAnimation()) {
                                p = chatScrollHelper.positionToOldView.indexOfValue(child);
                                if (p >= 0) {
                                    p = chatScrollHelper.positionToOldView.keyAt(p);
                                }
                            } else {
                                ViewHolder holder = chatListView.getChildViewHolder(child);
                                p = holder.getAdapterPosition();
                            }
                            if (p >= 0) {
                                int tries = 0;
                                while (true) {
                                    if (tries >= 20) {
                                        break;
                                    }
                                    tries++;

                                    int prevPosition;
                                    if (groupedMessages != null && position != null) {
                                        int idx = groupedMessages.posArray.indexOf(position);
                                        if (idx < 0) {
                                            break;
                                        }
                                        int size = groupedMessages.posArray.size();
                                        if ((position.flags & MessageObject.POSITION_FLAG_TOP) != 0) {
                                            prevPosition = p + idx + 1;
                                        } else {
                                            prevPosition = p + 1;
                                            for (int a = idx - 1; a >= 0; a--) {
                                                if (groupedMessages.posArray.get(a).maxY < position.minY) {
                                                    break;
                                                } else {
                                                    prevPosition++;
                                                }
                                            }
                                        }
                                    } else {
                                        prevPosition = p + 1;
                                    }
                                    if (cell.willRemovedAfterAnimation()) {
                                        View view = chatScrollHelper.positionToOldView.get(prevPosition);
                                        if (view != null) {
                                            top = view.getTop() + view.getPaddingTop();
                                            if (view instanceof ChatMessageCell) {
                                                cell = (ChatMessageCell) view;
                                                float newTx = cell.getSlidingOffsetX() + cell.getCheckBoxTranslation();
                                                if (canUpdateTx && newTx > 0) {
                                                    tx = newTx;
                                                }
                                                if (!cell.drawPinnedTop()) {
                                                    break;
                                                } else {
                                                    p = prevPosition;
                                                }
                                            } else {
                                                break;
                                            }
                                        } else {
                                            break;
                                        }
                                    } else {
                                        ViewHolder holder = chatListView.findViewHolderForAdapterPosition(prevPosition);
                                        if (holder != null) {
                                            top = holder.itemView.getTop() + holder.itemView.getPaddingTop();
                                            if (holder.itemView instanceof ChatMessageCell) {
                                                cell = (ChatMessageCell) holder.itemView;
                                                float newTx = cell.getSlidingOffsetX() + cell.getCheckBoxTranslation();
                                                if (canUpdateTx && newTx > 0) {
                                                    tx = newTx;
                                                }
                                                if (!cell.drawPinnedTop()) {
                                                    break;
                                                } else {
                                                    p = prevPosition;
                                                }
                                            } else {
                                                break;
                                            }
                                        } else {
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        if (y - dp(48) < top) {
                            y = top + dp(48);
                        }
                        if (!cell.drawPinnedBottom()) {
                            int cellBottom = replaceAnimation ? cell.getBottom() : (int) (cell.getY() + cell.getMeasuredHeight() + cell.getTransitionParams().deltaBottom);
                            if (y > cellBottom) {
                                y = cellBottom;
                            }
                        }
                        canvas.save();
                        if (tx != 0) {
                            canvas.translate(tx, 0);
                        }
                        if (cell.getCurrentMessagesGroup() != null) {
                            if (cell.getCurrentMessagesGroup().transitionParams.backgroundChangeBounds) {
                                y -= cell.getTranslationY();
                            }
                        }
                        if (updateVisibility) {
                            imageReceiver.setImageY(y - dp(44));
                        }
                        if (cell.shouldDrawAlphaLayer()) {
                            imageReceiver.setAlpha((1f - getSideMenuAlpha()) * cell.getAlpha());
                            canvas.scale(
                                    cell.getScaleX(), cell.getScaleY(),
                                    cell.getX() + cell.getPivotX(), cell.getY() + (cell.getHeight() >> 1)
                            );
                        } else {
                            imageReceiver.setAlpha(1f - getSideMenuAlpha());
                        }
                        if (updateVisibility) {
                            imageReceiver.setVisible(true, false);
                        }
                        if (getSideMenuAlpha() > 0f) {
                            canvas.scale(1f - getSideMenuAlpha(), 1f - getSideMenuAlpha(), imageReceiver.getImageX2(), imageReceiver.getImageY2());
                            canvas.translate(dp(24) * getSideMenuAlpha(), 0f);
                        }
                        imageReceiver.draw(canvas);
                        canvas.restore();

                        if (!replaceAnimation && child.getTranslationY() != 0) {
                            canvas.save();
                        }
                    }
                }

                if (child.getTranslationY() != 0) {
                    canvas.restore();
                }
                return result;
            }

            @Override
            public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
                if (currentEncryptedChat != null) {
                    return;
                }
                super.onInitializeAccessibilityNodeInfo(info);
                AccessibilityNodeInfo.CollectionInfo collection = info.getCollectionInfo();
                if (collection != null) {
                    info.setCollectionInfo(AccessibilityNodeInfo.CollectionInfo.obtain(collection.getRowCount(), 1, false));
                }
            }

            @Override
            public AccessibilityNodeInfo createAccessibilityNodeInfo() {
                if (currentEncryptedChat != null) {
                    return null;
                }
                return super.createAccessibilityNodeInfo();
            }
        };
        if (currentEncryptedChat != null) {
            chatListView.setImportantForAccessibility(View.IMPORTANT_FOR_ACCESSIBILITY_NO_HIDE_DESCENDANTS);
        }
        chatListView.setHideIfEmpty(false);
        chatListView.setAccessibilityEnabled(false);
        chatListView.setNestedScrollingEnabled(false);
        chatListView.setInstantClick(true);
        chatListView.setDisableHighlightState(true);
        chatListView.setTag(1);
        chatListView.setVerticalScrollBarEnabled(!SharedConfig.chatBlurEnabled());
        chatListView.setAdapter(chatAdapter = new ChatActivityAdapter(context));
        chatListView.setClipToPadding(false);
        if (ChatObject.isMonoForum(currentChat) || ChatObject.areTabsEnabled(currentChat)) {
            chatListView.setClipChildren(false);
        }
        chatListView.setAnimateEmptyView(true, RecyclerListView.EMPTY_VIEW_ANIMATION_TYPE_ALPHA_SCALE);
        chatListView.setScrollBarStyle(View.SCROLLBARS_OUTSIDE_OVERLAY);
        chatListViewPaddingsAnimator = new ChatListViewPaddingsAnimator(chatListView);
        chatListViewPaddingTop = 0;
        paddingTopHeight = 0;
        invalidateChatListViewTopPadding();
        if (MessagesController.getGlobalMainSettings().getBoolean("view_animations", true)) {
            chatListItemAnimator = new ChatListItemAnimator(this, chatListView, themeDelegate) {

                Runnable finishRunnable;

                @Override
                public void checkIsRunning() {
                    if (scrollAnimationIndex == -1) {
                        scrollAnimationIndex = getNotificationCenter().setAnimationInProgress(scrollAnimationIndex, allowedNotificationsDuringChatListAnimations, false);
                    }
                }

                @Override
                public void onAnimationStart() {
                    scrollAnimationIndex = getNotificationCenter().setAnimationInProgress(scrollAnimationIndex, allowedNotificationsDuringChatListAnimations, false);
                    if (finishRunnable != null) {
                        AndroidUtilities.cancelRunOnUIThread(finishRunnable);
                        finishRunnable = null;
                    }
                    if (BuildVars.LOGS_ENABLED) {
                        FileLog.d("chatItemAnimator disable notifications");
                    }
                    chatActivityEnterView.getAdjustPanLayoutHelper().runDelayedAnimation();
                    chatActivityEnterView.runEmojiPanelAnimation();
                }

                @Override
                protected void onAllAnimationsDone() {
                    super.onAllAnimationsDone();
                    if (finishRunnable != null) {
                        AndroidUtilities.cancelRunOnUIThread(finishRunnable);
                        finishRunnable = null;
                    }
                    AndroidUtilities.runOnUIThread(finishRunnable = () -> {
                        finishRunnable = null;
                        if (scrollAnimationIndex != -1) {
                            getNotificationCenter().onAnimationFinish(scrollAnimationIndex);
                            scrollAnimationIndex = -1;
                        }
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("chatItemAnimator enable notifications");
                        }
                    });
                }


                @Override
                public void endAnimations() {
                    super.endAnimations();
                    if (finishRunnable != null) {
                        AndroidUtilities.cancelRunOnUIThread(finishRunnable);
                    }
                    AndroidUtilities.runOnUIThread(finishRunnable = () -> {
                        finishRunnable = null;
                        if (scrollAnimationIndex != -1) {
                            getNotificationCenter().onAnimationFinish(scrollAnimationIndex);
                            scrollAnimationIndex = -1;
                        }
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("chatItemAnimator enable notifications");
                        }
                    });
                }
            };
            chatListItemAnimator.setOnSnapMessage(this::supportsThanosEffect, this::getChatThanosEffect);
        }

        chatLayoutManager = new GridLayoutManagerFixed(context, 1000, LinearLayoutManager.VERTICAL, !reversed) {

            boolean computingScroll;

            @Override
            public int getStartForFixGap() {
                int padding = (int) chatListViewPaddingTop;
                return padding;
            }

            @Override
            protected int getParentStart() {
                if (computingScroll) {
                    return (int) chatListViewPaddingTop;
                }
                return 0;
            }

            @Override
            public int getStartAfterPadding() {
                if (computingScroll) {
                    return (int) chatListViewPaddingTop;
                }
                return super.getStartAfterPadding();
            }

            @Override
            public int getTotalSpace() {
                if (computingScroll) {
                    return (int) (getHeight() - chatListViewPaddingTop - getPaddingBottom());
                }
                return super.getTotalSpace();
            }

            @Override
            public int computeVerticalScrollExtent(RecyclerView.State state) {
                computingScroll = true;
                int r = super.computeVerticalScrollExtent(state);
                computingScroll = false;
                return r;
            }

            @Override
            public int computeVerticalScrollOffset(RecyclerView.State state) {
                computingScroll = true;
                int r = super.computeVerticalScrollOffset(state);
                computingScroll = false;
                return r;
            }

            @Override
            public int computeVerticalScrollRange(RecyclerView.State state) {
                computingScroll = true;
                int r = super.computeVerticalScrollRange(state);
                computingScroll = false;
                return r;
            }

            @Override
            public void scrollToPositionWithOffset(int position, int offset, boolean bottom) {
                if (!bottom) {
                    offset = (int) (offset - getPaddingTop() + chatListViewPaddingTop);
                }
                super.scrollToPositionWithOffset(position, offset, bottom);
            }

            @Override
            public boolean supportsPredictiveItemAnimations() {
                return true;
            }

            @Override
            public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
                scrollByTouch = false;
                LinearSmoothScrollerCustom linearSmoothScroller = new LinearSmoothScrollerCustom(recyclerView.getContext(), LinearSmoothScrollerCustom.POSITION_MIDDLE);
                linearSmoothScroller.setTargetPosition(position);
                startSmoothScroll(linearSmoothScroller);
            }

            @Override
            public boolean shouldLayoutChildFromOpositeSide(View child) {
                if (child instanceof ChatMessageCell) {
                    return !((ChatMessageCell) child).getMessageObject().isOutOwner();
                }
                return false;
            }


            @Override
            protected boolean hasSiblingChild(int position) {
                if (position >= chatAdapter.messagesStartRow && position < chatAdapter.messagesEndRow) {
                    int index = position - chatAdapter.messagesStartRow;
                    if (index >= 0 && index < chatAdapter.getMessages().size()) {
                        MessageObject message = chatAdapter.getMessages().get(index);
                        MessageObject.GroupedMessages group = getValidGroupedMessage(message);
                        if (group != null) {
                            MessageObject.GroupedMessagePosition pos = group.getPosition(message);
                            if (pos.minX == pos.maxX || pos.minY != pos.maxY || pos.minY == 0) {
                                return false;
                            }
                            int count = group.posArray.size();
                            for (int a = 0; a < count; a++) {
                                MessageObject.GroupedMessagePosition p = group.posArray.get(a);
                                if (p == pos) {
                                    continue;
                                }
                                if (p.minY <= pos.minY && p.maxY >= pos.minY) {
                                    return true;
                                }
                            }
                        }
                    }
                }
                return false;
            }

            @Override
            public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
                if (BuildVars.DEBUG_PRIVATE_VERSION) {
                    super.onLayoutChildren(recycler, state);
                } else {
                    try {
                        super.onLayoutChildren(recycler, state);
                    } catch (Exception e) {
                        FileLog.e(e);
                        AndroidUtilities.runOnUIThread(() -> chatAdapter.notifyDataSetChanged(false));
                    }
                }
            }

            @Override
            public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
                if (dy < 0 && pullingDownOffset != 0) {
                    pullingDownOffset += dy;
                    if (pullingDownOffset < 0) {
                        dy = (int) pullingDownOffset;
                        pullingDownOffset = 0;
                        chatListView.invalidate();
                    } else {
                        dy = 0;
                    }
                }

                int n = chatListView.getChildCount();
                int scrolled = 0;
                boolean foundTopView = false;
                for (int i = 0; i < n; i++) {
                    View child = chatListView.getChildAt(i);
                    float padding = chatListViewPaddingTop;
                    if (chatListView.getChildAdapterPosition(child) == (reversed ? 0 : chatAdapter.getItemCount() - 1)) {
                        int dyLocal = dy;
                        if (child.getTop() - dy > padding) {
                            dyLocal = (int) (child.getTop() - padding);
                        }
                        scrolled = super.scrollVerticallyBy(dyLocal, recycler, state);
                        foundTopView = true;
                        break;
                    }
                }
                if (!foundTopView) {
                    scrolled = super.scrollVerticallyBy(dy, recycler, state);
                }
                if (dy > 0 && scrolled == 0 && (ChatObject.isChannel(currentChat) && !currentChat.megagroup || isTopic && !UserObject.isBotForum(currentUser)) && chatMode != MODE_SAVED && chatMode != MODE_SCHEDULED && chatListView.getScrollState() == RecyclerView.SCROLL_STATE_DRAGGING && !chatListView.isFastScrollAnimationRunning() && !chatListView.isMultiselect() && !isReport() && !MessagesController.getGlobalMainSettings().getBoolean("disableSlideToNextChannel", false)) {
                    if (pullingDownOffset == 0 && pullingDownDrawable != null) {
                        if (nextChannels != null && !nextChannels.isEmpty()) {
                            pullingDownDrawable.updateDialog(nextChannels.get(0));
                        } else if (isTopic) {
                            pullingDownDrawable.updateTopic();
                        } else {
                            pullingDownDrawable.updateDialog();
                        }
                    }
                    if (pullingDownBackAnimator != null) {
                        pullingDownBackAnimator.removeAllListeners();
                        pullingDownBackAnimator.cancel();
                    }

                    float k;
                    if (pullingDownOffset < AndroidUtilities.dp(110)) {
                        float progress = pullingDownOffset / AndroidUtilities.dp(110);
                        k = 0.65f * (1f - progress) + 0.45f * progress;
                    } else if (pullingDownOffset < AndroidUtilities.dp(160)) {
                        float progress = (pullingDownOffset - AndroidUtilities.dp(110)) / AndroidUtilities.dp(50);
                        k = 0.45f * (1f - progress) + 0.05f * progress;
                    } else {
                        k = 0.05f;
                    }

                    pullingDownOffset += dy * k;
                    ReactionsEffectOverlay.onScrolled((int) (dy * k));
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S && scrollableViewNoiseSuppressor != null) {
                        scrollableViewNoiseSuppressor.onScrolled(0, (dy * k));
                    }
                    chatListView.invalidate();
                }
                if (pullingDownOffset == 0) {
                    chatListView.setOverScrollMode(View.OVER_SCROLL_ALWAYS);
                } else {
                    chatListView.setOverScrollMode(View.OVER_SCROLL_NEVER);
                }
                if (pullingDownDrawable != null) {
                    animatorPullingDownContainerVisibility.setValue(pullingDownOffset > 0 && chatListView.getScrollState() == RecyclerView.SCROLL_STATE_DRAGGING, true);
                }
                return scrolled;
            }
        };
        chatLayoutManager.setSpanSizeLookup(new GridLayoutManagerFixed.SpanSizeLookup() {
            @Override
            public int getSpanSize(int position) {
                if (position >= chatAdapter.messagesStartRow && position < chatAdapter.messagesEndRow) {
                    int idx = position - chatAdapter.messagesStartRow;
                    if (idx >= 0 && idx < chatAdapter.getMessages().size()) {
                        MessageObject message = chatAdapter.getMessages().get(idx);
                        MessageObject.GroupedMessages groupedMessages = getValidGroupedMessage(message);
                        if (groupedMessages != null) {
                            return groupedMessages.getPosition(message).spanSize;
                        }
                    }
                }
                return 1000;
            }
        });
        chatListView.setLayoutManager(chatLayoutManager);
        chatListView.addItemDecoration(new RecyclerView.ItemDecoration() {
            @Override
            public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
                outRect.bottom = 0;
                if (view instanceof ChatMessageCell) {
                    ChatMessageCell cell = (ChatMessageCell) view;
                    MessageObject.GroupedMessages group = cell.getCurrentMessagesGroup();
                    if (group != null) {
                        MessageObject.GroupedMessagePosition position = cell.getCurrentPosition();
                        if (position != null && position.siblingHeights != null) {
                            float maxHeight = Math.max(AndroidUtilities.displaySize.x, AndroidUtilities.displaySize.y) * 0.5f;
                            int h = cell.getExtraInsetHeight();
                            for (int a = 0; a < position.siblingHeights.length; a++) {
                                h += (int) Math.ceil(maxHeight * position.siblingHeights[a]);
                            }
                            h += (position.maxY - position.minY) * Math.round(7 * AndroidUtilities.density);
                            int count = group.posArray.size();
                            for (int a = 0; a < count; a++) {
                                MessageObject.GroupedMessagePosition pos = group.posArray.get(a);
                                if (pos.minY != position.minY || pos.minX == position.minX && pos.maxX == position.maxX && pos.minY == position.minY && pos.maxY == position.maxY) {
                                    continue;
                                }
                                if (pos.minY == position.minY) {
                                    h -= (int) Math.ceil(maxHeight * pos.ph) - AndroidUtilities.dp(4);
                                    break;
                                }
                            }
                            outRect.bottom = -h;
                        }
                    }
                }
            }
        });
        chatListView.setOnItemLongClickListener(onItemLongClickListener);
        chatListView.setOnItemClickListener(onItemClickListener);
        chatListView.setOnScrollListener(new RecyclerView.OnScrollListener() {

            private float totalDy = 0;
            private boolean scrollUp;
            private final int scrollValue = AndroidUtilities.dp(100);

            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == RecyclerView.SCROLL_STATE_IDLE) {
                    if (pollHintCell != null) {
                        pollHintView.showForMessageCell(pollHintCell, -1, pollHintX, pollHintY, true);
                        pollHintCell = null;
                    }
                    scrollingFloatingDate = false;
                    scrollingFloatingTopic = false;
                    scrollingChatListView = false;
                    checkTextureViewPosition = false;
                    hideFloatingDateView(true);
                    hideFloatingTopicView(true);
                    if (SharedConfig.getDevicePerformanceClass() == SharedConfig.PERFORMANCE_CLASS_LOW) {
                        scrolling = true;
                        NotificationCenter.getGlobalInstance().postNotificationName(NotificationCenter.startAllHeavyOperations, 512);
                    }
                    NotificationCenter.getGlobalInstance().postNotificationName(NotificationCenter.startSpoilers);
                    chatListView.setOverScrollMode(RecyclerView.OVER_SCROLL_ALWAYS);
                    textSelectionHelper.stopScrolling();
                    updateVisibleRows();
                    invalidateMergedVisibleBlurredPositionsAndSources(BLUR_INVALIDATE_FLAG_SCROLL);
                    scrollByTouch = false;
                } else {
                    if (groupEmojiPackHint != null && groupEmojiPackHint.shown()) {
                        groupEmojiPackHint.hide();
                    }
                    if (searchOtherButton != null && searchOtherButton.getVisibility() == View.VISIBLE && isKeyboardVisible()) {
                        AndroidUtilities.hideKeyboard(getParentActivity().getCurrentFocus());
                    }
                    if (newState == RecyclerView.SCROLL_STATE_SETTLING) {
                        wasManualScroll = true;
                        scrollingChatListView = true;
                    } else if (newState == RecyclerView.SCROLL_STATE_DRAGGING) {
                        pollHintCell = null;
                        wasManualScroll = true;
                        scrollingFloatingDate = true;
                        scrollingFloatingTopic = true;
                        checkTextureViewPosition = true;
                        scrollingChatListView = true;
                    }
                    if (SharedConfig.getDevicePerformanceClass() == SharedConfig.PERFORMANCE_CLASS_LOW) {
                        scrolling = false;
                        NotificationCenter.getGlobalInstance().postNotificationName(NotificationCenter.stopAllHeavyOperations, 512);
                    }
                    NotificationCenter.getGlobalInstance().postNotificationName(NotificationCenter.stopSpoilers);

                    if (selectionReactionsOverlay != null && selectionReactionsOverlay.isVisible()) {
                        selectionReactionsOverlay.setHiddenByScroll(true);
                    }
                }
            }

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                chatListView.invalidate();
                if (contentView != null) {
                    contentView.updateBlurContent();
                }
                if (chatListThanosEffect != null) {
                    chatListThanosEffect.scroll(dx, dy);
                }
                scrollUp = dy < 0;
                int firstVisibleItem = chatLayoutManager.findFirstVisibleItemPosition();
                if (dy != 0 && (scrollByTouch && recyclerView.getScrollState() == RecyclerView.SCROLL_STATE_SETTLING) || recyclerView.getScrollState() == RecyclerView.SCROLL_STATE_DRAGGING) {
                    if (forceNextPinnedMessageId != 0) {
                        if ((!scrollUp || forceScrollToFirst)) {
                            forceNextPinnedMessageId = 0;
                        } else if (!chatListView.isFastScrollAnimationRunning() && firstVisibleItem != RecyclerView.NO_POSITION) {
                            int lastVisibleItem = chatLayoutManager.findLastVisibleItemPosition();
                            MessageObject messageObject = null;
                            boolean foundForceNextPinnedView = false;
                            for (int i = lastVisibleItem; i >= firstVisibleItem; i--) {
                                View view = chatLayoutManager.findViewByPosition(i);
                                if (view instanceof ChatMessageCell) {
                                    messageObject = ((ChatMessageCell) view).getMessageObject();
                                } else if (view instanceof ChatActionCell) {
                                    messageObject = ((ChatActionCell) view).getMessageObject();
                                }
                                if (messageObject != null) {
                                    if (forceNextPinnedMessageId == messageObject.getId()) {
                                        foundForceNextPinnedView = true;
                                        break;
                                    }
                                }
                            }
                            if (!foundForceNextPinnedView && messageObject != null && messageObject.getId() < forceNextPinnedMessageId) {
                                forceNextPinnedMessageId = 0;
                            }
                        }
                    }
                }
                if (recyclerView.getScrollState() == RecyclerView.SCROLL_STATE_DRAGGING) {
                    forceScrollToFirst = false;
                    if (!wasManualScroll && dy != 0) {
                        wasManualScroll = true;
                    }
                }
                if (dy != 0) {
                    invalidateMergedVisibleBlurredPositionsAndSources(BLUR_INVALIDATE_FLAG_SCROLL);
                    contentView.invalidateBlur();
                    hideHints(true);
                }
                if (dy != 0 && scrollingFloatingDate && !currentFloatingTopIsNotMessage) {
                    if (highlightMessageId != Integer.MAX_VALUE) {
                        removeSelectedMessageHighlight();
                        updateVisibleRows();
                    }
                    showFloatingDateView(true);
                }
                if (isAllChats() && dy != 0 && scrollingFloatingTopic && !currentFloatingTopIsNotMessage) {
                    if (highlightMessageId != Integer.MAX_VALUE) {
                        removeSelectedMessageHighlight();
                        updateVisibleRows();
                    }
                    showFloatingTopicView(true);
                }
                checkScrollForLoad(true);
                if (firstVisibleItem != RecyclerView.NO_POSITION) {
                    int totalItemCount = chatAdapter.getItemCount();
                    if (firstVisibleItem == 0 && forwardEndReached[0]) {
                        if (dy >= 0) {
                            canShowPagedownButton = false;
                            updatePagedownButtonVisibility(true);
                        }
                    } else {
                        final boolean isPageDownButtonVisible = sideControlsButtonsLayout.isButtonVisible(
                            ChatActivitySideControlsButtonsLayout.BUTTON_PAGE_DOWN);

                        if (dy > 0) {
                            if (!isPageDownButtonVisible) {
                                totalDy += dy;
                                if (totalDy > scrollValue) {
                                    totalDy = 0;
                                    canShowPagedownButton = true;
                                    updatePagedownButtonVisibility(true);
                                    pagedownButtonShowedByScroll = true;
                                }
                            }
                        } else {
                            if (pagedownButtonShowedByScroll && isPageDownButtonVisible) {
                                totalDy += dy;
                                if (totalDy < -scrollValue) {
                                    canShowPagedownButton = false;
                                    updatePagedownButtonVisibility(true);
                                    totalDy = 0;
                                }
                            }
                        }
                    }
                }
                invalidateMessagesVisiblePart();
                textSelectionHelper.onParentScrolled();
                emojiAnimationsOverlay.onScrolled(dy);
                ReactionsEffectOverlay.onScrolled(dy);
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S && scrollableViewNoiseSuppressor != null) {
                    scrollableViewNoiseSuppressor.onScrolled(dx, dy);
                }

                checkTranslation(false);

                if (savedMessagesTagHint != null) {
                    if (savedMessagesTagHint.shown()) {
                        savedMessagesTagHint.hide();
                    } else if (!savedMessagesTagHintShown) {
                        lastScrollTime = System.currentTimeMillis();
                        AndroidUtilities.cancelRunOnUIThread(ChatActivity.this::checkSavedMessagesTagHint);
                        AndroidUtilities.runOnUIThread(ChatActivity.this::checkSavedMessagesTagHint, 2000);
                    }
                }
                if (videoConversionTimeHint != null && videoConversionTimeHint.shown()) {
                    videoConversionTimeHint.hide();
                }
                if (botMessageHint != null && botMessageHint.shown()) {
                    botMessageHint.hide();
                } else {
                    AndroidUtilities.cancelRunOnUIThread(ChatActivity.this::checkBotMessageHint);
                    AndroidUtilities.runOnUIThread(ChatActivity.this::checkBotMessageHint, 2000);
                }
                if (factCheckHint != null) {
                    factCheckHint.hide();
                }
                if (chatActivityEnterView != null) {
                    chatActivityEnterView.hideHints();
                }
                if (starReactionsOverlay != null) {
                    starReactionsOverlay.invalidate();
                }
            }
        });

        contentView.addView(chatListView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));
        if (getDialogId() != getUserConfig().getClientUserId()) {
            selectionReactionsOverlay = new ChatSelectionReactionMenuOverlay(this, context);
            contentView.addView(selectionReactionsOverlay, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));
        }

        animatingImageView = new ClippingImageView(context);
        animatingImageView.setVisibility(View.GONE);
        contentView.addView(animatingImageView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));

        progressView = new FrameLayout(context);
        progressView.setVisibility(View.INVISIBLE);
        contentView.addView(progressView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.TOP | Gravity.LEFT));

        progressView2 = new View(context) {
            private final RectF rect = new RectF();
            @Override
            protected void dispatchDraw(Canvas canvas) {
                rect.set(0, 0, getWidth(), getHeight());
                applyServiceShaderMatrix();
                canvas.drawRoundRect(rect, dp(18), dp(18), getThemedPaint(Theme.key_paint_chatActionBackground));
                if (themeDelegate != null ? themeDelegate.hasGradientService() : Theme.hasGradientService()) {
                    canvas.drawRoundRect(rect, dp(18), dp(18), getThemedPaint(Theme.key_paint_chatActionBackgroundDarken));
                }
                super.dispatchDraw(canvas);
            }
            public void applyServiceShaderMatrix() {
                applyServiceShaderMatrix(getMeasuredWidth(), getServiceHeight(this), getX(), getServiceTop(this));
            }
            private void applyServiceShaderMatrix(int measuredWidth, int backgroundHeight, float x, float viewTop) {
                if (themeDelegate != null) {
                    themeDelegate.applyServiceShaderMatrix(measuredWidth, backgroundHeight, x, viewTop);
                } else {
                    Theme.applyServiceShaderMatrix(measuredWidth, backgroundHeight, x, viewTop);
                }
            }
        };
        progressView.addView(progressView2, LayoutHelper.createFrame(36, 36, Gravity.CENTER));

        progressBar = new RadialProgressView(context, themeDelegate);
        progressBar.setSize(AndroidUtilities.dp(28));
        progressBar.setProgressColor(getThemedColor(Theme.key_chat_serviceText));
        progressView.addView(progressBar, LayoutHelper.createFrame(32, 32, Gravity.CENTER));

        floatingTopicSeparator = new TopicSeparator.Cell(context, currentAccount, themeDelegate) {
            @Override
            public void setTranslationY(float translationY) {
                if (getTranslationY() != translationY) {
                    invalidate();
                }
                super.setTranslationY(translationY);
            }

            @Override
            public boolean onTouchEvent(MotionEvent event) {
                if (getAlpha() == 0 || actionBar.isActionModeShowed() || isReport()) {
                    return false;
                }
                return super.onTouchEvent(event);
            }
        };
        floatingTopicSeparator.setOnTopicClickListener(topicId -> {
            if (topicsTabs != null) {
                topicsTabs.selectTopic(topicId, true);
            }
        });
        floatingTopicSeparator.setAlpha(0.f);
        contentView.addView(floatingTopicSeparator, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.TOP | Gravity.CENTER_HORIZONTAL, 0, 4, 0, 0));

        floatingDateView = new ChatActionCell(context, false, themeDelegate) {
            @Override
            public boolean isFloating() {
                return true;
            }

            @Override
            public void setTranslationY(float translationY) {
                if (getTranslationY() != translationY) {
                    invalidate();
                }
                super.setTranslationY(translationY);
            }

            @Override
            public boolean onInterceptTouchEvent(MotionEvent ev) {
                if (getAlpha() == 0 || actionBar.isActionModeShowed() || isReport()) {
                    return false;
                }
                return super.onInterceptTouchEvent(ev);
            }

            @Override
            public boolean onTouchEvent(MotionEvent event) {
                if (getAlpha() == 0 || actionBar.isActionModeShowed() || isReport()) {
                    return false;
                }
                return super.onTouchEvent(event);
            }

            @Override
            protected void onDraw(Canvas canvas) {
                if (scrimBlurBitmap != null) return;
                float clipTop = chatListView.getY() + chatListViewPaddingTop - getY();
                clipTop -= AndroidUtilities.dp(4);
                if (clipTop > 0) {
                    if (clipTop < getMeasuredHeight()) {
                        canvas.save();
                        canvas.clipRect(0, clipTop, getMeasuredWidth(), getMeasuredHeight());
                        super.onDraw(canvas);
                        canvas.restore();
                    }
                } else {
                    super.onDraw(canvas);
                }
            }
        };
        floatingDateView.setCustomDate((int) (System.currentTimeMillis() / 1000), false, false);
        floatingDateView.setAlpha(0.0f);
        floatingDateView.setImportantForAccessibility(View.IMPORTANT_FOR_ACCESSIBILITY_NO);
        floatingDateView.setInvalidateColors(true);
        contentView.addView(floatingDateView, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.TOP | Gravity.CENTER_HORIZONTAL, 0, 4, 0, 0));
        floatingDateView.setOnClickListener(view -> {
            if (floatingDateView.getAlpha() == 0 || actionBar.isActionModeShowed() || isReport()) {
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis((long) floatingDateView.getCustomDate() * 1000);
            int year = calendar.get(Calendar.YEAR);
            int monthOfYear = calendar.get(Calendar.MONTH);
            int dayOfMonth = calendar.get(Calendar.DAY_OF_MONTH);

            calendar.clear();
            calendar.set(year, monthOfYear, dayOfMonth);
            jumpToDate((int) (calendar.getTime().getTime() / 1000));
        });

        if (currentChat != null) {
            pendingRequestsDelegate = new ChatActivityMemberRequestsDelegate(this, contentView, currentChat, this::invalidateChatListViewTopPadding);
            pendingRequestsDelegate.setChatInfo(chatInfo, false);
            contentView.addView(pendingRequestsDelegate.getView(), ViewGroup.LayoutParams.MATCH_PARENT, pendingRequestsDelegate.getViewHeight());
            pendingRequestsDelegate.setLeftMargin(getSideMenuWidth());
        }

        floatingDateView.setOnLongClickListener(view -> {
            if (getParentActivity() == null) {
                return false;
            }
            AndroidUtilities.hideKeyboard(searchItem.getSearchField());
            showDialog(AlertsCreator.createCalendarPickerDialog(getParentActivity(), 1375315200000L, this::jumpToDate, themeDelegate).create());
            return true;
        });

        pinnedMessageView = null;

        undoView = null;
        topUndoView = null;
        topChatPanelView = null;
        topChatPanelView2 = null;
        reportSpamButton = null;
        emojiStatusSpamHint = null;
        topViewSeparator1 = null;
        topViewSeparator2 = null;
        topViewSeparator3 = null;
        addToContactsButton = null;
        restartTopicButton = null;
        closeReportSpam = null;
        translateButton = null;
        topicsTabs = null;
        botAdView = null;
        bizBotButton = null;

        sideControlsButtonsLayout = new ChatActivitySideControlsButtonsLayout(context, resourceProvider, blurredBackgroundColorProvider, glassBackgroundDrawableFactory);
        sideControlsButtonsLayout.setOnClickListener(this::onSideControlButtonOnClick);
        sideControlsButtonsLayout.setOnLongClickListener(this::onSideControlButtonOnLongClick);
        contentView.addView(sideControlsButtonsLayout, LayoutHelper.createFrame(57, 300, Gravity.RIGHT | Gravity.BOTTOM));

        updateMessageListAccessibilityVisibility();
        mentionContainer = new MentionsContainerView(context, dialog_id, threadMessageId, ChatActivity.this, themeDelegate) {

            @Override
            protected boolean canOpen() {
                return bottomOverlay.getVisibility() != View.VISIBLE || searchingForUser;
            }

            @Override
            protected void onOpen() {
                if (allowStickersPanel && (!getAdapter().isBotContext() || (allowContextBotPanel || allowContextBotPanelSecond))) {
                    if (currentEncryptedChat != null && getAdapter().isBotContext()) {
                        SharedPreferences preferences = MessagesController.getGlobalMainSettings();
                        if (!preferences.getBoolean("secretbot", false)) {
                            AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                            builder.setTitle(LocaleController.getString(R.string.AppName));
                            builder.setMessage(LocaleController.getString(R.string.SecretChatContextBotAlert));
                            builder.setPositiveButton(LocaleController.getString(R.string.OK), null);
                            showDialog(builder.create());
                            preferences.edit().putBoolean("secretbot", true).commit();
                        }
                    }
                }
                updateMessageListAccessibilityVisibility();
            }

            @Override
            protected void onClose() {
                updateMessageListAccessibilityVisibility();
            }

            @Override
            protected void onContextSearch(boolean searching) {
                if (chatActivityEnterView != null) {
                    chatActivityEnterView.setCaption(getAdapter().getBotCaption());
                    chatActivityEnterView.showContextProgress(searching);
                }
            }

            @Override
            protected void onContextClick(TLRPC.BotInlineResult result) {
                if (getParentActivity() == null || result.content == null) {
                    return;
                }
                if (result.type.equals("video") || result.type.equals("web_player_video")) {
                    int[] size = MessageObject.getInlineResultWidthAndHeight(result);
                    EmbedBottomSheet.show(ChatActivity.this, null, botContextProvider, result.title != null ? result.title : "", result.description, result.content.url, result.content.url, size[0], size[1], isKeyboardVisible());
                } else {
                    processExternalUrl(0, result.content.url, null, null, false, false);
                }
            }

            private boolean wasAtTop = true;
            @Override
            protected void onScrolled(boolean atTop, boolean atBottom) {
                if (wasAtTop != atTop) {
                    AndroidUtilities.updateViewShow(suggestEmojiPanel, !isInPreviewMode() && atTop, false, true);
                    wasAtTop = atTop;
                }
            }

            @Override
            public boolean dispatchTouchEvent(MotionEvent ev) {
                if (getAlpha() <= 0f) return false;
                return super.dispatchTouchEvent(ev);
            }
        };
        if (isInPreviewMode()) {
            mentionContainer.setAlpha(0f);
        }
        mentionContainer.setDialogId(dialog_id);
        mentionContainer.setBackgroundDrawable(glassBackgroundDrawableFactoryFrosted.create(mentionContainer, blurredBackgroundColorProviderWhite));
        contentView.addView(mentionContainer, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 110, Gravity.LEFT | Gravity.BOTTOM));

        contentPreviewViewerDelegate = new ContentPreviewViewer.ContentPreviewViewerDelegate() {
            @Override
            public void sendSticker(TLRPC.Document sticker, String query, Object parent, boolean notify, int scheduleDate, int scheduleRepeatPeriod) {
                chatActivityEnterView.onStickerSelected(sticker, query, parent, null, true, notify, scheduleDate, scheduleRepeatPeriod);
            }

            @Override
            public boolean needSend(int contentType) {
                return true;
            }

            @Override
            public boolean canSchedule() {
                return ChatActivity.this.canScheduleMessage();
            }

            @Override
            public boolean isInScheduleMode() {
                return chatMode == MODE_SCHEDULED;
            }

            @Override
            public void openSet(TLRPC.InputStickerSet set, boolean clearsInputField) {
                if (set == null || getParentActivity() == null) {
                    return;
                }
                TLRPC.TL_inputStickerSetID inputStickerSet = new TLRPC.TL_inputStickerSetID();
                inputStickerSet.access_hash = set.access_hash;
                inputStickerSet.id = set.id;
                StickersAlert alert = new StickersAlert(getParentActivity(), ChatActivity.this, inputStickerSet, null, chatActivityEnterView, themeDelegate, false);
                alert.setCalcMandatoryInsets(isKeyboardVisible());
                alert.setClearsInputField(clearsInputField);
                showDialog(alert);
            }

            @Override
            public long getDialogId() {
                return dialog_id;
            }
        };
        mentionContainer.getListView().setOnTouchListener((v, event) -> ContentPreviewViewer.getInstance().onTouch(event, mentionContainer.getListView(), 0, mentionsOnItemClickListener, mentionContainer.getAdapter().isStickers() ? contentPreviewViewerDelegate : null, themeDelegate));
        if (!ChatObject.isChannel(currentChat) || currentChat.megagroup) {
            mentionContainer.getAdapter().setBotInfo(botInfo);
        }
        mentionContainer.getAdapter().setParentFragment(this);
        mentionContainer.getAdapter().setChatInfo(chatInfo);
        mentionContainer.getAdapter().setNeedUsernames(currentChat != null);
        mentionContainer.getAdapter().setNeedBotContext(true);
        mentionContainer.getAdapter().setBotsCount(currentChat != null ? botsCount : 1);
        mentionContainer.getListView().setOnItemClickListener(mentionsOnItemClickListener = (view, position) -> {
            if (position == 0 || mentionContainer.getAdapter().isBannedInline()) {
                return;
            }
            position--;
            Object object = mentionContainer.getAdapter().getItem(position);
            int start = mentionContainer.getAdapter().getResultStartPosition();
            int len = mentionContainer.getAdapter().getResultLength();
            if (mentionContainer.getAdapter().isLocalHashtagHint(position)) {
                chatActivityEnterView.replaceWithText(start, len, mentionContainer.getAdapter().getHashtagHint() + "@" + ChatObject.getPublicUsername(currentChat) + " ", false);
                return;
            } else if (mentionContainer.getAdapter().isGlobalHashtagHint(position)) {
                chatActivityEnterView.replaceWithText(start, len, mentionContainer.getAdapter().getHashtagHint() + " ", false);
                return;
            }
            if (object instanceof QuickRepliesController.QuickReply) {
                if (!getUserConfig().isPremium()) {
                    showDialog(new PremiumFeatureBottomSheet(this, getContext(), currentAccount, true, PremiumPreviewFragment.PREMIUM_FEATURE_BUSINESS_QUICK_REPLIES, false, null));
                    return;
                }
                AlertsCreator.ensurePaidMessageConfirmation(currentAccount, dialog_id, Math.max(1, ((QuickRepliesController.QuickReply) object).getMessagesCount()), payStars -> {
                    TLRPC.TL_messages_sendQuickReplyMessages req = new TLRPC.TL_messages_sendQuickReplyMessages();
                    req.peer = getMessagesController().getInputPeer(dialog_id);
                    req.shortcut_id = ((QuickRepliesController.QuickReply) object).id;
                    getConnectionsManager().sendRequest(req, null);
                    if (chatActivityEnterView != null) {
                        chatActivityEnterView.setFieldText(null);
                    }
                });
            } else if (object instanceof TLRPC.TL_document) {
                if (chatMode == 0 && checkSlowMode(view)) {
                    return;
                }
                MessageObject.SendAnimationData sendAnimationData;
                if (view instanceof StickerCell) {
                    sendAnimationData = ((StickerCell) view).getSendAnimationData();
                } else {
                    sendAnimationData = null;
                }
                TLRPC.TL_document document = (TLRPC.TL_document) object;
                Object parent = mentionContainer.getAdapter().getItemParent(position);
                String query = MessageObject.findAnimatedEmojiEmoticon(document);
                AlertsCreator.ensurePaidMessageConfirmation(currentAccount, getDialogId(), 1, price -> {
                    if (chatMode == MODE_SCHEDULED) {
                        AlertsCreator.createScheduleDatePickerDialog(getParentActivity(), dialog_id, (notify, scheduleDate, scheduleRepeatPeriod) -> SendMessagesHelper.getInstance(currentAccount).sendSticker(document, query, dialog_id, replyingMessageObject, getThreadMessage(), null, replyingQuote, null, notify, scheduleDate, 0, false, parent, quickReplyShortcut, getQuickReplyId(), 0, getSendMonoForumPeerId(), getSendMessageSuggestionParams()), themeDelegate);
                    } else {
                        getSendMessagesHelper().sendSticker(document, query, dialog_id, replyingMessageObject, getThreadMessage(), null, replyingQuote, sendAnimationData, true, 0, 0, false, parent, quickReplyShortcut, getQuickReplyId(), price, getSendMonoForumPeerId(), getSendMessageSuggestionParams());
                    }
                    hideFieldPanel(false);
                    chatActivityEnterView.addStickerToRecent(document);
                    chatActivityEnterView.setFieldText("");
                });
            } else if (object instanceof TLRPC.Chat) {
                TLRPC.Chat chat = (TLRPC.Chat) object;
                if (searchingForUser && searchContainer != null && searchContainer.getVisibility() == View.VISIBLE) {
                    searchUserMessages(null, chat);
                } else {
                    String username = ChatObject.getPublicUsername(chat);
                    if (username != null) {
                        chatActivityEnterView.replaceWithText(start, len, "@" + username + " ", false);
                    }
                }
            } else if (object instanceof TLRPC.User) {
                TLRPC.User user = (TLRPC.User) object;
                if (searchingForUser && searchContainer != null && searchContainer.getVisibility() == View.VISIBLE) {
                    searchUserMessages(user, null);
                } else {
                    SharedPreferences preferences = MessagesController.getGlobalMainSettings();
                    final boolean mentionByName = !user.bot && preferences.getBoolean("mentionByName", false);
                    if (UserObject.getPublicUsername(user) != null && !mentionByName) {
                        chatActivityEnterView.replaceWithText(start, len, "@" + UserObject.getPublicUsername(user) + " ", false);
                    } else {
                        String name = UserObject.getFirstName(user, false);
                        Spannable spannable = new SpannableString(name + " ");
                        spannable.setSpan(new URLSpanUserMention("" + user.id, 3), 0, spannable.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                        chatActivityEnterView.replaceWithText(start, len, spannable, false);
                    }
                }
            } else if (object instanceof String) {
                if (mentionContainer.getAdapter().isBotCommands()) {
                    if (chatMode == MODE_SCHEDULED) {
                        AlertsCreator.createScheduleDatePickerDialog(getParentActivity(), dialog_id, (notify, scheduleDate, scheduleRepeatPeriod) -> {
                            getSendMessagesHelper().sendMessage(SendMessagesHelper.SendMessageParams.of((String) object, dialog_id, replyingMessageObject, getThreadMessage(), null, false, null, null, null, notify, scheduleDate, 0, null, false));
                            chatActivityEnterView.setFieldText("");
                            hideFieldPanel(false);
                        }, themeDelegate);
                    } else {
                        if (checkSlowMode(view)) {
                            return;
                        }
                        AlertsCreator.ensurePaidMessageConfirmation(currentAccount, dialog_id, 1, payStars -> {
                            final SendMessagesHelper.SendMessageParams params = SendMessagesHelper.SendMessageParams.of((String) object, dialog_id, replyingMessageObject, getThreadMessage(), null, false, null, null, null, true, 0, 0, null, false);
                            params.quick_reply_shortcut = quickReplyShortcut;
                            params.quick_reply_shortcut_id = getQuickReplyId();
                            params.payStars = payStars;
                            params.monoForumPeer = getSendMonoForumPeerId();
                            params.suggestionParams = messageSuggestionParams;
                            getSendMessagesHelper().sendMessage(params);
                            chatActivityEnterView.setFieldText("");
                            hideFieldPanel(false);
                        });
                    }
                } else {
                    chatActivityEnterView.replaceWithText(start, len, object + " ", false);
                }
            } else if (object instanceof TLRPC.BotInlineResult) {
                if (chatActivityEnterView.getFieldText() == null || chatMode != MODE_SCHEDULED && checkSlowMode(view)) {
                    return;
                }
                TLRPC.BotInlineResult result = (TLRPC.BotInlineResult) object;
                if (currentEncryptedChat != null) {
                    int error = 0;
                    if (result.send_message instanceof TLRPC.TL_botInlineMessageMediaAuto && "game".equals(result.type)) {
                        error = 1;
                    } else if (result.send_message instanceof TLRPC.TL_botInlineMessageMediaInvoice) {
                        error = 2;
                    }
                    if (error != 0) {
                        AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                        builder.setTitle(LocaleController.getString(R.string.SendMessageTitle));
                        if (error == 1) {
                            builder.setMessage(LocaleController.getString(R.string.GameCantSendSecretChat));
                        } else {
                            builder.setMessage(LocaleController.getString(R.string.InvoiceCantSendSecretChat));
                        }
                        builder.setNegativeButton(LocaleController.getString(R.string.OK), null);
                        showDialog(builder.create());
                        return;
                    }
                }
                if ((result.type.equals("photo") && (result.photo != null || result.content != null) ||
                        result.type.equals("gif") && (result.document != null || result.content != null) ||
                        result.type.equals("video") && (result.document != null/* || result.content_url != null*/))) {
                    ArrayList<Object> arrayList = botContextResults = new ArrayList<>(mentionContainer.getAdapter().getSearchResultBotContext());
                    PhotoViewer.getInstance().setParentActivity(ChatActivity.this, themeDelegate);
                    PhotoViewer.getInstance().openPhotoForSelect(arrayList, mentionContainer.getAdapter().getItemPosition(position), 3, false, botContextProvider, ChatActivity.this);
                } else {
                    AlertsCreator.ensurePaidMessageConfirmation(currentAccount, getDialogId(), 1, price -> {
                        if (chatMode == MODE_SCHEDULED) {
                            AlertsCreator.createScheduleDatePickerDialog(getParentActivity(), dialog_id, (notify, scheduleDate, scheduleRepeatPeriod) -> sendBotInlineResult(result, notify, scheduleDate, price), themeDelegate);
                        } else {
                            sendBotInlineResult(result, true, 0, price);
                        }
                    });
                }
            } else if (object instanceof TLRPC.TL_inlineBotWebView) {
                processInlineBotWebView((TLRPC.TL_inlineBotWebView) object);
            } else if (object instanceof TLRPC.TL_inlineBotSwitchPM) {
                processInlineBotContextPM((TLRPC.TL_inlineBotSwitchPM) object);
            } else if (object instanceof MediaDataController.KeywordResult) {
                String code = ((MediaDataController.KeywordResult) object).emoji;
                chatActivityEnterView.addEmojiToRecent(code);
                if (code != null && code.startsWith("animated_")) {
                    try {
                        Paint.FontMetricsInt fontMetrics = null;
                        try {
                            fontMetrics = chatActivityEnterView.getEditField().getPaint().getFontMetricsInt();
                        } catch (Exception e) {
                            FileLog.e(e, false);
                        }
                        long documentId = Long.parseLong(code.substring(9));
                        TLRPC.Document document = AnimatedEmojiDrawable.findDocument(currentAccount, documentId);
                        SpannableString emoji = new SpannableString(MessageObject.findAnimatedEmojiEmoticon(document));
                        AnimatedEmojiSpan span;
                        if (document != null) {
                            span = new AnimatedEmojiSpan(document, fontMetrics);
                        } else {
                            span = new AnimatedEmojiSpan(documentId, fontMetrics);
                        }
                        emoji.setSpan(span, 0, emoji.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                        chatActivityEnterView.replaceWithText(start, len, emoji, false);
                    } catch (Exception ignore) {
                        chatActivityEnterView.replaceWithText(start, len, code, true);
                    }
                } else {
                    chatActivityEnterView.replaceWithText(start, len, code, true);
                }
                mentionContainer.updateVisibility(false);
            }
        });
        mentionContainer.getListView().setOnItemLongClickListener((view, position) -> {
            if (getParentActivity() == null || !mentionContainer.getAdapter().isLongClickEnabled()) {
                return false;
            }
            if (position == 0 || mentionContainer.getAdapter().isBannedInline()) {
                return false;
            }
            position--;
            Object object = mentionContainer.getAdapter().getItem(position);
            if (object instanceof String) {
                if (mentionContainer.getAdapter().isBotCommands()) {
                    if (URLSpanBotCommand.enabled) {
                        chatActivityEnterView.setFieldText("");
                        chatActivityEnterView.setCommand(null, (String) object, true, currentChat != null && currentChat.megagroup);
                        return true;
                    }
                    return false;
                } else {
                    AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                    builder.setTitle(LocaleController.getString(R.string.AppName));
                    builder.setMessage(LocaleController.getString(R.string.ClearSearch));
                    builder.setPositiveButton(LocaleController.getString(R.string.ClearButton), (dialogInterface, i) -> mentionContainer.getAdapter().clearRecentHashtags());
                    builder.setNegativeButton(LocaleController.getString(R.string.Cancel), null);
                    showDialog(builder.create());
                    return true;
                }
            }
            return false;
        });

        if (!isInsideContainer) {
            fragmentLocationContextView = new FragmentContextView(context, this, null, true, themeDelegate);
            fragmentContextView = new FragmentContextView(context, this, null, false, themeDelegate);
            contentView.addView(fragmentLocationContextView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 38, Gravity.TOP | Gravity.LEFT, 0, -36, 0, 0));
            contentView.addView(fragmentContextView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 38, Gravity.TOP | Gravity.LEFT, 0, -36, 0, 0));

            fragmentContextView.setAdditionalContextView(fragmentLocationContextView);
            fragmentLocationContextView.setAdditionalContextView(fragmentContextView);

            fragmentContextView.setEnabled(!inPreviewMode);
            fragmentLocationContextView.setEnabled(!inPreviewMode);

            if (chatMode != 0) {
                fragmentContextView.setSupportsCalls(false);
            }
        }




        messagesSearchListContainer = new FrameLayout(context);

        BlurredBackgroundDrawable searchContainerDrawable = (glassBackgroundDrawableFactoryFrosted != null ? glassBackgroundDrawableFactoryFrosted : glassBackgroundDrawableFactory).create(messagesSearchListContainer, blurredBackgroundColorProviderWhite);
        searchContainerDrawable.setPadding(dp(5));
        searchContainerDrawable.setRadius(dp(22));

        messagesSearchListContainer.setBackground(searchContainerDrawable);
        messagesSearchListContainer.setClipToOutline(true);
        messagesSearchListContainer.setOutlineProvider(searchContainerDrawable.getViewOutlineProvider());
        messagesSearchListContainer.setVisibility(View.GONE);
        messagesSearchListContainer.setPadding(dp(5), dp(5), dp(5), dp(5));
        messagesSearchListContainer.setAlpha(0.0f);
        contentView.addView(messagesSearchListContainer, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.LEFT | Gravity.TOP, 0, 0, 0, 48));

        messagesSearchListView = new RecyclerListView(context, themeDelegate) {
            @Override
            protected void onAttachedToWindow() {
                super.onAttachedToWindow();
                if (messagesSearchAdapter != null) {
                    messagesSearchAdapter.attach();
                }
            }

            @Override
            protected void onDetachedFromWindow() {
                super.onDetachedFromWindow();
                if (messagesSearchAdapter != null) {
                    messagesSearchAdapter.detach();
                }
            }
        };
        LinearLayoutManager messagesSearchLayoutManager = new LinearLayoutManager(context);
        messagesSearchLayoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        messagesSearchListView.setLayoutManager(messagesSearchLayoutManager);
        messagesSearchListView.setAdapter(messagesSearchAdapter = new MessagesSearchAdapter(context, this, themeDelegate, searchType, dialog_id == getUserConfig().getClientUserId()));
        checkHashtagStories(true);
        DefaultItemAnimator itemAnimator = new DefaultItemAnimator();
        itemAnimator.setSupportsChangeAnimations(false);
        itemAnimator.setDelayAnimations(false);
        itemAnimator.setInterpolator(CubicBezierInterpolator.EASE_OUT_QUINT);
        itemAnimator.setDurations(350);
        messagesSearchListView.setItemAnimator(itemAnimator);
        messagesSearchListContainer.addView(messagesSearchListView, LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT);
        messagesSearchListView.setOnItemClickListener((view, position) -> {
            if (chatMode == MODE_SEARCH) {
                Object obj = messagesSearchAdapter.getItem(position);
                if (position == 0 && messagesSearchAdapter.containsStories && messagesSearchAdapter.storiesList != null) {
                    Bundle args = new Bundle();
                    args.putInt("type", MediaActivity.TYPE_STORIES_SEARCH);
                    args.putString("hashtag", messagesSearchAdapter.storiesList.query);
                    if (messagesSearchAdapter.storiesList.username != null) {
                        args.putString("username", messagesSearchAdapter.storiesList.username);
                    }
                    args.putInt("storiesCount", messagesSearchAdapter.storiesList.getCount());
                    presentFragment(new MediaActivity(args, null));
                } else if (obj instanceof MessageObject) {
                    openMessageInOriginalDialog((MessageObject) obj);
                }
            } else if (searchingReaction != null) {
                if (position < 0 || position >= getMediaDataController().searchResultMessages.size())
                    return;
                MessageObject msg = getMediaDataController().searchResultMessages.get(position);
                setFilterMessages(searchingFiltered = false, true, false);
                getMediaDataController().setSearchedPosition(position);
                updateSearchButtons(getMediaDataController().getMask(), getMediaDataController().getSearchPosition(), getMediaDataController().getSearchCount());
                AndroidUtilities.runOnUIThread(() -> {
                    scrollToMessageId(msg.getId(), 0, true, 0, true, 0, null, () -> {
                        progressDialog = new AlertDialog(getParentActivity(), AlertDialog.ALERT_TYPE_SPINNER, themeDelegate);
                        progressDialog.setOnShowListener(dialogInterface -> showPinnedProgress(false));
                        progressDialog.setOnCancelListener(postponedScrollCancelListener);
                        progressDialog.showDelayed(500);
                    });
                    if (waitingForLoad.isEmpty()) {
                        showMessagesSearchListView(false);
                    }
                });
            } else {
                getMediaDataController().jumpToSearchedMessage(classGuid, position);
                showMessagesSearchListView(false);
            }
        });
        messagesSearchListView.setOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                if (recyclerView.getScrollState() == RecyclerView.SCROLL_STATE_DRAGGING) {
                    AndroidUtilities.hideKeyboard(contentView);
                }
                int lastVisibleItem = messagesSearchLayoutManager.findLastVisibleItemPosition();
                int visibleItemCount = lastVisibleItem == RecyclerView.NO_POSITION ? 0 : lastVisibleItem;
                if (visibleItemCount > 0 && lastVisibleItem > messagesSearchAdapter.loadedCount - 5) {
                    if (chatMode == MODE_SEARCH) {
                        if (!loading && !endReached[0]) {
                            loading = true;
                            waitingForLoad.add(lastLoadIndex);
                            HashtagSearchController.getInstance(currentAccount).searchHashtag(searchingHashtag, classGuid, searchType, lastLoadIndex++);
                        }
                    } else {
                        getMediaDataController().loadMoreSearchMessages(true);
                    }
                }
            }
        });
        hashtagLoadingView = new FlickerLoadingView(context, themeDelegate);
        hashtagLoadingView.setViewType(FlickerLoadingView.DIALOG_CELL_TYPE);

        hashtagSearchEmptyView = new StickerEmptyView(getContext(), hashtagLoadingView, StickerEmptyView.STICKER_TYPE_SEARCH);
        hashtagSearchEmptyView.setClickable(true);
        hashtagSearchEmptyView.title.setText(LocaleController.getString(R.string.NoResult));
        hashtagSearchEmptyView.setVisibility(View.GONE);
        hashtagSearchEmptyView.addView(hashtagLoadingView, 0);
        hashtagSearchEmptyView.showProgress(true, false);
        messagesSearchListContainer.addView(hashtagSearchEmptyView, new FrameLayout.LayoutParams(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.CENTER));

        if (parentThemeDelegate == null && !isInsideContainer) {
            searchViewPager = new ViewPagerFixed(context, resourceProvider) {
                @Override
                public boolean onTouchEvent(MotionEvent ev) {
                    return false;
                }

                @Override
                protected boolean canScroll(MotionEvent e) {
                    return hashtagSearchTabs != null && hashtagSearchTabs.shown();
                }

                @Override
                public void onTabAnimationUpdate(boolean manual) {
                    super.onTabAnimationUpdate(manual);
                    contentView.invalidateBlur();
                    contentView.updateBlurContent();
                }

                @Override
                protected void onTabScrollEnd(int position) {
                    super.onTabScrollEnd(position);
                    if (position == 0 && requestClearSearchPages) {
                        requestClearSearchPages = false;
                        searchViewPager.clearViews();
                    }
                }

                @Override
                protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                    for (int i = 0; i < getChildCount(); i++) {
                        View child = getChildAt(i);
                        if (child instanceof ChatActivityContainer) {
                            int p = actionBar.getHeight(); // + hashtagSearchTabs.getHeight();
                            ChatActivity chatActivity = ((ChatActivityContainer) child).chatActivity;
                            if (chatActivity.contentView != null) {
                                chatActivity.contentView.setPadding(0, p, 0, 0);
                            }
                        }
                    }
                }
            };
            searchViewPager.setAdapter(new ViewPagerFixed.Adapter() {
                @Override
                public int getItemCount() {
                    return 3;
                }

                @Override
                public int getItemViewType(int position) {
                    return position;
                }

                @Override
                public View createView(int viewType) {
                    if (viewType == SEARCH_THIS_CHAT) {
                        return new FirstViewPage(context);
                    } else {
                        Bundle args = new Bundle();
                        args.putInt("chatMode", ChatActivity.MODE_SEARCH);
                        args.putInt("searchType", viewType);
                        args.putString("searchHashtag", searchingHashtag);
                        ChatActivityContainer container = new ChatActivityContainer(context, getParentLayout(), args) {
                            boolean activityCreated = false;

                            @Override
                            protected void initChatActivity() {
                                if (!activityCreated) {
                                    activityCreated = true;
                                    super.initChatActivity();
                                }
                            }
                        };
                        container.chatActivity.navbarContentSourceWallpaper.setSource(navbarContentSourceWallpaper);
                        container.chatActivity.parentThemeDelegate = themeDelegate;
                        container.chatActivity.parentChatActivity = ChatActivity.this;
                        container.chatActivity.chatActivityDelegate = new ChatActivityDelegate() {
                            @Override
                            public void openHashtagSearch(String hashtag) {
                                ChatActivity.this.openHashtagSearch(hashtag);
                            }
                        };
                        return container;
                    }
                }

                @Override
                public void bindView(View view, int position, int viewType) {
                    if (view instanceof ChatActivityContainer) {
                        ((ChatActivityContainer) view).chatActivity.updateSearchingHashtag(searchingHashtag);
                    } else if (view instanceof PublicStoriesList) {
                        ((PublicStoriesList) view).setTabs(parentChatActivity != null ? parentChatActivity.hashtagSearchTabs.isShown() : hashtagSearchTabs.isShown());
                        ((PublicStoriesList) view).setQuery("", searchingHashtag);
                    }
                    ViewCompat.requestApplyInsets(view);
                }

                @Override
                public String getItemTitle(int position) {
                    switch (position) {
                        case SEARCH_MY_MESSAGES:
                            return LocaleController.getString(R.string.SearchMyMessages);
                        case SEARCH_PUBLIC_POSTS:
                            return LocaleController.getString(R.string.SearchPublicPosts);
                        default:
                        case SEARCH_THIS_CHAT:
                            return LocaleController.getString(R.string.SearchThisChat);
                    }
                }
            });
            searchViewPager.setAllowDisallowInterceptTouch(false);
            contentView.addView(searchViewPager, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.LEFT | Gravity.TOP, 0, 0, 0, 0));

            hashtagSearchTabs = new ChatSearchTabs(context, contentView) {
                @Override
                protected void onShownUpdate(boolean finish) {
                    setBackgroundColor(actionBar.getBackgroundColor());
                    if (tagSelector != null) {
                        tagSelector.setTranslationY(contentPanTranslation + getCurrentHeight());
                    }
                    if (finish) {
                        invalidateChatListViewTopPadding = true;
                        updateChatListViewTopPadding();
                    } else {
                        invalidateChatListViewTopPadding();
                    }
                }
            };
            hashtagSearchTabs.setVisibility(View.GONE);
            hashtagSearchTabs.setTabs(searchViewPager.createTabsView(true, 8));
            contentView.addView(hashtagSearchTabs, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 40, Gravity.FILL_HORIZONTAL | Gravity.TOP));
        }

        contentView.addView(actionBar);

        overlayView = new View(context);
        overlayView.setOnTouchListener((v, event) -> {
            if (event.getAction() == MotionEvent.ACTION_DOWN) {
                checkRecordLocked(false);
            }
            overlayView.getParent().requestDisallowInterceptTouchEvent(true);
            return true;
        });
        contentView.addView(overlayView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.LEFT | Gravity.TOP));
        overlayView.setVisibility(View.GONE);
        contentView.setClipChildren(false);

        instantCameraView = null;

        chatActivityEnterView = new ChatActivityEnterView(getParentActivity(), contentView, this, chatMode != MODE_EDIT_BUSINESS_LINK, themeDelegate) {

            int lastContentViewHeight;
            int messageEditTextPredrawHeigth;
            int messageEditTextPredrawScrollY;

            @Override
            protected void onChangedIslandTotalHeight(float h) {
                checkUi_inputIslandHeight();
            }

            @Override
            public void setAlpha(float alpha) {
                super.setAlpha(alpha);
            }

            @Override
            public boolean onInterceptTouchEvent(MotionEvent ev) {
                if (getAlpha() != 1.0f) {
                    return false;
                }
                return super.onInterceptTouchEvent(ev);
            }

            @Override
            public boolean onTouchEvent(MotionEvent event) {
                if (getAlpha() != 1.0f) {
                    return false;
                }
                return super.onTouchEvent(event);
            }

            @Override
            public boolean dispatchTouchEvent(MotionEvent ev) {
                if (getAlpha() != 1.0f) {
                    return false;
                }
                return super.dispatchTouchEvent(ev);
            }

            @Override
            protected boolean pannelAnimationEnabled() {
                if (!openAnimationEnded) {
                    return false;
                }
                return true;
            }

            @Override
            public void openKeyboard() {
                if (forwardingPreviewView != null) {
                    return;
                }
                super.openKeyboard();
            }

            @Override
            public void setVisibility(int visibility) {
                super.setVisibility(visibility);
                bottomViewsVisibilityController.setViewVisible(MESSAGE_INPUT_CONTAINER, visibility == VISIBLE, getMeasuredWidth() > 0);
            }

            @Override
            public void checkAnimation() {
                if (actionBar.isActionModeShowed() || isReport()) {
                    if (messageEditTextAnimator != null) {
                        messageEditTextAnimator.cancel();
                    }
                    if (changeBoundAnimator != null) {
                        changeBoundAnimator.cancel();
                    }

                    chatActivityEnterViewAnimateFromTop = 0;
                    shouldAnimateEditTextWithBounds = false;
                } else {
                    int t = getBackgroundTop();
                    if (chatActivityEnterViewAnimateFromTop != 0 && t != chatActivityEnterViewAnimateFromTop && lastContentViewHeight == contentView.getMeasuredHeight()) {
                        int dy = animatedTop + chatActivityEnterViewAnimateFromTop - t;
                        setAnimatedTop(dy);
                        messageEditTextContainer.invalidate();
                        if (changeBoundAnimator != null) {
                            changeBoundAnimator.removeAllListeners();
                            changeBoundAnimator.cancel();
                        }

                        // chatListView.setTranslationY(dy);
                        if (topView != null && topView.getVisibility() == View.VISIBLE) {
                            topView.setTranslationY(animatedTop + (1f - getTopViewEnterProgress()) * topView.getLayoutParams().height);
                        }

                        changeBoundAnimator = ValueAnimator.ofFloat(dy, 0);
                        changeBoundAnimator.addUpdateListener(a -> {
                            float top = (float) a.getAnimatedValue();
                            setAnimatedTop((int) top);
                            if (topView != null && topView.getVisibility() == View.VISIBLE) {
                                topView.setTranslationY(top + (1f - getTopViewEnterProgress()) * topView.getLayoutParams().height);
                            } else {
                                invalidateChatListViewTopPadding();
                                invalidateMessagesVisiblePart();
                            }
                            messageEditTextContainer.invalidate();
                            invalidate();
                        });
                        changeBoundAnimator.addListener(new AnimatorListenerAdapter() {
                            @Override
                            public void onAnimationEnd(Animator animation) {
                                setAnimatedTop(0);
                                if (topView != null && topView.getVisibility() == View.VISIBLE) {
                                    topView.setTranslationY(animatedTop + (1f - getTopViewEnterProgress()) * topView.getLayoutParams().height);
                                }
                                changeBoundAnimator = null;
                            }
                        });
                        changeBoundAnimator.setDuration(ChatListItemAnimator.DEFAULT_DURATION);
                        changeBoundAnimator.setInterpolator(ChatListItemAnimator.DEFAULT_INTERPOLATOR);
                        if (!waitingForSendingMessageLoad) {
                            changeBoundAnimator.start();
                        }
                        invalidateChatListViewTopPadding();
                        invalidateMessagesVisiblePart();
                        chatActivityEnterViewAnimateFromTop = 0;
                    } else if (lastContentViewHeight != contentView.getMeasuredHeight()) {
                        chatActivityEnterViewAnimateFromTop = 0;
                    }
                    if (shouldAnimateEditTextWithBounds) {
                        float dy = (messageEditTextPredrawHeigth - messageEditText.getMeasuredHeight()) + (messageEditTextPredrawScrollY - messageEditText.getScrollY());
                        messageEditText.setOffsetY(messageEditText.getOffsetY() - dy);
                        ValueAnimator a = ValueAnimator.ofFloat(messageEditText.getOffsetY(), 0);
                        a.addUpdateListener(animation -> messageEditText.setOffsetY((float) animation.getAnimatedValue()));
                        if (messageEditTextAnimator != null) {
                            messageEditTextAnimator.cancel();
                        }
                        messageEditTextAnimator = a;
                        a.setDuration(ChatListItemAnimator.DEFAULT_DURATION);
                       // a.setStartDelay(chatActivityEnterViewAnimateBeforeSending ? 20 : 0);
                        a.setInterpolator(ChatListItemAnimator.DEFAULT_INTERPOLATOR);
                        a.start();
                        shouldAnimateEditTextWithBounds = false;
                    }
                    lastContentViewHeight = contentView.getMeasuredHeight();

                    chatActivityEnterViewAnimateBeforeSending = false;
                }
            }

            @Override
            protected void onLineCountChanged(int oldLineCount, int newLineCount) {
                if (chatActivityEnterView != null) {
                    if (chatListView != null && (searchExpandProgress > 0 || actionBar != null && actionBar.isActionModeShowed())) {
                        return;
                    }
                    shouldAnimateEditTextWithBounds = true;
                    messageEditTextPredrawHeigth = messageEditText.getMeasuredHeight();
                    messageEditTextPredrawScrollY = messageEditText.getScrollY();
                    contentView.invalidate();
                    chatActivityEnterViewAnimateFromTop = chatActivityEnterView.getBackgroundTop();
                }
            }

            @Override
            public void hideTopView(boolean animated) {
                super.hideTopView(animated);
                if (onHideFieldPanelRunnable != null) {
                    AndroidUtilities.runOnUIThread(onHideFieldPanelRunnable);
                    onHideFieldPanelRunnable = null;
                }
            }
        };
        chatActivityEnterView.setVisibility(View.VISIBLE);
        chatActivityEnterView.getEditField().adaptiveCreateLinkDialog = true;
        if (chatMode == MODE_EDIT_BUSINESS_LINK) {
            chatActivityEnterView.setDelegate(new ChatActivityEnterView.ChatActivityEnterViewDelegate() {
                @Override
                public void onMessageSend(CharSequence message, boolean notify, int scheduleDate, int scheduleRepeatPeriod, long payStars) {}

                @Override
                public void needSendTyping() {}

                @Override
                public void onTextChanged(CharSequence text, boolean bigChange, boolean fromDraft) {}
                 @Override
                public void onTextSelectionChanged(int start, int end) {}

                @Override
                public void onTextSpansChanged(CharSequence text) {}

                @Override
                public void onAttachButtonHidden() {}

                @Override
                public void onAttachButtonShow() {}

                @Override
                public void onWindowSizeChanged(int size) {}

                @Override
                public void onStickersTab(boolean opened) {}

                @Override
                public void onMessageEditEnd(boolean loading) {}

                @Override
                public void didPressAttachButton() {}

                @Override
                public void needStartRecordVideo(int state, boolean notify, int scheduleDate, int scheduleRepeatPeriod, int ttl, long effectId, long stars) {}

                @Override
                public void toggleVideoRecordingPause() {}

                @Override
                public boolean isVideoRecordingPaused() {
                    return false;
                }

                @Override
                public void needChangeVideoPreviewState(int state, float seekProgress) {}

                @Override
                public void onSwitchRecordMode(boolean video) {}

                @Override
                public void onPreAudioVideoRecord() {}

                @Override
                public void needStartRecordAudio(int state) {}

                @Override
                public void needShowMediaBanHint() {}

                @Override
                public void onStickersExpandedChange() {}

                @Override
                public void onUpdateSlowModeButton(View button, boolean show, CharSequence time) {}

                @Override
                public void onSendLongClick() {}

                @Override
                public void onAudioVideoInterfaceUpdated() {}
            });
        } else {
            chatActivityEnterView.setDelegate(new ChatActivityEnterViewDelegate());
        }
        chatActivityEnterView.setInAppInsetsController(windowInsetsStateHolder);
        chatActivityEnterView.setDialogId(dialog_id, currentAccount);
        if (chatInfo != null) {
            chatActivityEnterView.setChatInfo(chatInfo);
        }
        chatActivityEnterView.setId(id_chat_compose_panel);
        chatActivityEnterView.setBotsCount(botsCount, hasBotsCommands, hasQuickReplies, false);
        chatActivityEnterView.updateBotWebView(false);
        chatActivityEnterView.setMinimumHeight(AndroidUtilities.dp(51));
        chatActivityEnterView.setAllowStickersAndGifs(true, true, currentEncryptedChat == null || AndroidUtilities.getPeerLayerVersion(currentEncryptedChat.layer) >= 46);
        chatActivityEnterView.shouldDrawBackground = false;
        if (textToSet != null) {
            chatActivityEnterView.setFieldText(textToSet);
            textToSet = null;
        }
        if (inPreviewMode || isInsideContainer) {
            chatActivityEnterView.setVisibility(View.INVISIBLE);
        }
        if (!ChatObject.isChannel(currentChat) || currentChat.megagroup) {
            chatActivityEnterView.setBotInfo(botInfo, false);
        }
        // contentView.addView(chatActivityEnterView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.BOTTOM));


        chatActivityEnterView.setViewParentForEmoji(chatInputInAppContainer);

        chatInputBubbleContainer.addView(chatActivityEnterView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.BOTTOM, 7, 0, 7, 0));
        contentView.addView(chatInputViewsContainer.getFadeView(), LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));
        contentView.addView(chatInputViewsContainer, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));

        if (chatMode != MODE_EDIT_BUSINESS_LINK) {
            chatActivityEnterView.checkChannelRights();
        }

        actionsButtonsLayout = new ChatActivityActionsButtonsLayout(context, resourceProvider, blurredBackgroundColorProvider, glassBackgroundDrawableFactory);
        actionsButtonsLayout.setForwardButtonOnClickListener(v -> openForward(false));
        actionsButtonsLayout.setGroupMediaButtonOnClickListener(v -> showAnonymShareAlert(true));
        actionsButtonsLayout.setReplyButtonOnClickListener(v -> {
            MessageObject messageObject = null;
            for (int a = 1; a >= 0; a--) {
                if (messageObject == null && selectedMessagesIds[a].size() != 0) {
                    messageObject = messagesDict[a].get(selectedMessagesIds[a].keyAt(0));
                }
                selectedMessagesIds[a].clear();
                selectedMessagesCanCopyIds[a].clear();
                selectedMessagesCanStarIds[a].clear();
            }
            hideActionMode();
            if (messageObject != null && (messageObject.messageOwner.id > 0 || messageObject.messageOwner.id < 0 && currentEncryptedChat != null)) {
                showFieldPanelForReply(messageObject);
            }
            updatePinnedMessageView(true);
            updateVisibleRows();
            updateSelectedMessageReactions();
        });
        bottomViewsVisibilityController.setViewVisible(MESSAGE_ACTION_CONTAINER, false, false);
        chatInputBubbleContainer.addView(actionsButtonsLayout, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 106, Gravity.BOTTOM, 0, 0, 0, -56));
        chatActivityEnterView.setSuggestionButtonVisible(ChatObject.isMonoForum(currentChat), false);

        chatActivityEnterTopView = new ChatActivityEnterTopView(context) {
            @Override
            public void setTranslationY(float translationY) {
                super.setTranslationY(translationY);
                if (chatActivityEnterView != null) {
                    chatActivityEnterView.invalidate();
                }
                if (getVisibility() != GONE) {
                    hideHints(true);
                    if (chatListView != null) {
                        // chatListView.setTranslationY(translationY);
                    }
                    if (progressView != null) {
                        progressView.setTranslationY(translationY);
                    }
                    invalidateChatListViewTopPadding();
                    invalidateMessagesVisiblePart();
                    if (fragmentView != null) {
                        fragmentView.invalidate();
                    }
                }
            }

            @Override
            public boolean hasOverlappingRendering() {
                return false;
            }

            @Override
            public void setVisibility(int visibility) {
                super.setVisibility(visibility);
                if (visibility == GONE) {
                    if (chatListView != null) {
                        // chatListView.setTranslationY(0);
                    }
                    if (progressView != null) {
                        progressView.setTranslationY(0);
                    }
                }
            }
        };
        chatActivityEnterView.addTopView(chatActivityEnterTopView, 48);

        if (chatMode == MODE_EDIT_BUSINESS_LINK) {
            chatActivityEnterView.setEditingBusinessLink(businessLink);
        }

        final FrameLayout replyLayout = new FrameLayout(context);
        chatActivityEnterTopView.addReplyView(replyLayout, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.NO_GRAVITY, 0, 0, 52, 0));

        boolean[] byButtonPress = new boolean[1];
        replyLayout.setOnClickListener(v -> {
            final boolean isButtonPress = byButtonPress[0];
            if (isButtonPress) {
                byButtonPress[0] = false;
            }

            if (fieldPanelShown == 5) {
                new MessageSuggestionOfferSheet(context, currentAccount, dialog_id, messageSuggestionParams != null ? messageSuggestionParams: MessageSuggestionParams.empty(), this, getResourceProvider(), MessageSuggestionOfferSheet.MODE_INPUT, this::showFieldPanelForSuggestionParams).show();
            } else if (fieldPanelShown == 1 && editingMessageObject != null) {
                if (editingMessageObject.needResendWhenEdit() && !isButtonPress) {
                    showSuggestionOfferForEditMessage(messageSuggestionParams != null ? messageSuggestionParams: MessageSuggestionParams.empty());
                } else if (editingMessageObject.canEditMedia() && editingMessageObjectReqId == 0) {
                    Utilities.Callback<Integer> open = type -> {
                        if (chatAttachAlert == null) {
                            createChatAttachView();
                        }
                        chatAttachAlert.setEditingMessageObject(type, editingMessageObject);
                        openAttachMenu();
                    };
                    open.run(ChatAttachAlert.EDITMEDIA_TYPE_ANY);
//                    if (editingMessageObject.hasValidGroupId()) {
//                        open.run(-1);
//                    } else {
//                        ItemOptions.makeOptions(ChatActivity.this, replyLayout, true)
//                            .add(editingMessageObject.isMediaEmpty() ? R.drawable.msg_addphoto : R.drawable.msg_photos, getString(editingMessageObject.isMediaEmpty() ? R.string.MessageAddPhotoVideo : R.string.MessageReplacePhotoVideo), () -> open.run(ChatAttachAlert.EDITMEDIA_TYPE_PHOTOVIDEO))
//                            .add(editingMessageObject.isMediaEmpty() ? R.drawable.menu_sendfile_plus : R.drawable.msg_sendfile, getString(editingMessageObject.isMediaEmpty() ? R.string.MessageAddFile : R.string.MessageReplaceFile), () -> open.run(ChatAttachAlert.EDITMEDIA_TYPE_FILE))
//                            .add(editingMessageObject.isMediaEmpty() ? R.drawable.files_music : R.drawable.files_music, getString(editingMessageObject.isMediaEmpty() ? R.string.MessageAddMusic : R.string.MessageReplaceMusic), () -> open.run(ChatAttachAlert.EDITMEDIA_TYPE_MUSIC))
//                            .setDrawScrim(false).setGravity(Gravity.LEFT).forceTop(true).translate(0, dp(48))
//                            .show();
//                    }
                } else {
                    scrollToMessageId(editingMessageObject.getId(), 0, true, 0, true, 0);
                }
            } else if (messagePreviewParams != null) {
                forbidForwardingWithDismiss = false;
                if (fieldPanelShown == 2) {
                    if (DialogObject.isEncryptedDialog(dialog_id) || messagePreviewParams.hasSecretMessages || chatMode == MODE_QUICK_REPLIES) {
                        if (replyingMessageObject != null) {
                            scrollToMessageId(replyingMessageObject.getId(), 0, true, 0, true, 0);
                        }
                    } else {
                        forbidForwardingWithDismiss = messagePreviewParams.quote == null;
                        SharedConfig.replyingOptionsHintHintShowed();
                        openForwardingPreview(MessagePreviewView.TAB_REPLY);
                    }
                } else if (fieldPanelShown == 3) {
                    SharedConfig.forwardingOptionsHintHintShowed();
                    openForwardingPreview(MessagePreviewView.TAB_FORWARD);
                } else if (fieldPanelShown == 4) {
                    openForwardingPreview(MessagePreviewView.TAB_LINK);
                }
            }
        });
        replyLayout.setOnLongClickListener(v -> {
            if (fieldPanelShown == 1 && editingMessageObject != null) {
                scrollToMessageId(editingMessageObject.getId(), 0, true, 0, true, 0);
                return true;
            } else if (messagePreviewParams != null) {
                if (fieldPanelShown == 2) {
                    if (replyingMessageObject != null) {
                        scrollToMessageId(replyingMessageObject.getId(), 0, true, 0, true, 0);
                        return true;
                    }
                }
            }
            return false;
        });

        replyIconImageView = new ImageView(context);
        replyIconImageView.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_replyPanelIcons), PorterDuff.Mode.MULTIPLY));
        replyIconImageView.setScaleType(ImageView.ScaleType.CENTER);
        replyLayout.addView(replyIconImageView, LayoutHelper.createFrame(52, 46, Gravity.TOP | Gravity.LEFT));

        replyCloseImageView = new ImageView(context);
        replyCloseImageView.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_glass_defaultIcon), PorterDuff.Mode.MULTIPLY));
        replyCloseImageView.setImageResource(R.drawable.input_clear);
        replyCloseImageView.setScaleType(ImageView.ScaleType.CENTER);
        replyCloseImageView.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_inappPlayerClose) & 0x19ffffff, 1, AndroidUtilities.dp(18)));
        chatActivityEnterTopView.addView(replyCloseImageView, LayoutHelper.createFrame(52, 46, Gravity.RIGHT | Gravity.TOP, 0, 0.5f, 0, 0));
        replyCloseImageView.setOnClickListener(v -> {
            messageSuggestionParams = null;
            if (fieldPanelShown == 2) {
                replyingQuote = null;
                replyingMessageObject = null;
                if (messagePreviewParams != null) {
                    messagePreviewParams.updateReply(null, null, dialog_id, null);
                }
                fallbackFieldPanel();
            } else if (fieldPanelShown == 3) {
                openAnotherForward();
            } else if (fieldPanelShown == 4) {
                foundWebPage = null;
                if (messagePreviewParams != null) {
                    messagePreviewParams.updateLink(currentAccount, null, null, replyingMessageObject == threadMessageObject ? null : replyingMessageObject, replyingQuote, editingMessageObject);
                }
                chatActivityEnterView.setWebPage(null, false);
                editResetMediaManual();
                fallbackFieldPanel();
            } else {
                if (ChatObject.isForum(currentChat) && !isTopic && replyingMessageObject != null) {
                    long topicId = MessageObject.getTopicId(currentAccount, replyingMessageObject.messageOwner, true);
                    if (topicId != 0) {
                        getMediaDataController().cleanDraft(dialog_id, topicId, false);
                    }
                }
                showFieldPanel(false, null, null, null, null, true, 0, null, true, 0, true);
            }
        });

        replyNameTextView = new SimpleTextView(context);
        replyNameTextView.setTextSize(14);
        replyNameTextView.setTextColor(getThemedColor(Theme.key_chat_replyPanelName));
        replyNameTextView.setTypeface(AndroidUtilities.bold());
        replyLayout.addView(replyNameTextView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 18, Gravity.TOP | Gravity.LEFT, 52, 6, 0, 0));

        replyObjectTextView = new SimpleTextView(context);
        replyObjectTextView.setTextSize(14);
        replyObjectTextView.setTextColor(getThemedColor(Theme.key_glass_defaultText));
        replyObjectTextView.setLinkTextColor(getThemedColor(Theme.key_chat_messageLinkIn));
        replyLayout.addView(replyObjectTextView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 18, Gravity.TOP | Gravity.LEFT, 52, 24, 0, 0));

        replyObjectHintTextView = new SimpleTextView(context);
        replyObjectHintTextView.setTextSize(14);
        replyObjectHintTextView.setTextColor(getThemedColor(Theme.key_glass_defaultText));
        replyObjectHintTextView.setText(LocaleController.getString(R.string.TapForForwardingOptions));
        replyObjectHintTextView.setAlpha(0f);
        replyLayout.addView(replyObjectHintTextView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 18, Gravity.TOP | Gravity.LEFT, 52, 24, 0, 0));

        SpoilerEffect replySpoilerEffect = new SpoilerEffect();
        replyImageView = new BackupImageView(context) {
            Path path = new Path();

            @Override
            public void draw(Canvas canvas) {
                super.draw(canvas);

                if (replyImageHasMediaSpoiler) {
                    path.rewind();
                    AndroidUtilities.rectTmp.set(imageReceiver.getImageX(), imageReceiver.getImageY(), imageReceiver.getImageX2(), imageReceiver.getImageY2());
                    path.addRoundRect(AndroidUtilities.rectTmp, AndroidUtilities.dp(2), AndroidUtilities.dp(2), Path.Direction.CW);

                    canvas.save();
                    canvas.clipPath(path);

                    int sColor = Color.WHITE;
                    replySpoilerEffect.setColor(ColorUtils.setAlphaComponent(sColor, (int) (Color.alpha(sColor) * 0.325f)));
                    replySpoilerEffect.setBounds((int) imageReceiver.getImageX(), (int) imageReceiver.getImageY(), (int) imageReceiver.getImageX2(), (int) imageReceiver.getImageY2());
                    replySpoilerEffect.draw(canvas);
                    invalidate();

                    canvas.restore();
                }
            }
        };
        replyImageView.setRoundRadius(AndroidUtilities.dp(2));
        replyLayout.addView(replyImageView, LayoutHelper.createFrame(34, 34, Gravity.TOP | Gravity.LEFT, 52, 6, 0, 0));

        contentView.addView(
            suggestEmojiPanel = new SuggestEmojiView(context, currentAccount, chatActivityEnterView, themeDelegate),
            LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 160, Gravity.LEFT | Gravity.BOTTOM, 7, 0, 7, 0)
        );
        suggestEmojiPanel.setVisibility(allowStickersPanel && !isInPreviewMode() && (chatActivityEnterView == null || !chatActivityEnterView.isStickersExpanded()) ? View.VISIBLE : View.GONE);

        final ChatActivityEnterTopView.EditView editView = new ChatActivityEnterTopView.EditView(context);
        editView.setMotionEventSplittingEnabled(false);
        editView.setOrientation(LinearLayout.HORIZONTAL);
        editView.setOnClickListener(v -> {
            if (editingMessageObject != null) {
                scrollToMessageId(editingMessageObject.getId(), 0, true, 0, true, 0);
            }
        });
        chatActivityEnterTopView.addEditView(editView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.NO_GRAVITY, 0, 0, 48, 0));

        for (int i = 0; i < 2; i++) {
            final boolean firstButton = i == 0;

            final ChatActivityEnterTopView.EditViewButton button = new ChatActivityEnterTopView.EditViewButton(context) {
                @Override
                public void setEditButton(boolean editButton) {
                    super.setEditButton(editButton);
                    if (firstButton) {
                        getTextView().setMaxWidth(editButton ? AndroidUtilities.dp(116) : Integer.MAX_VALUE);
                    }
                }

                @Override
                public void updateColors() {
                    final int leftInset = firstButton ? AndroidUtilities.dp(14) : 0;
                    setBackground(Theme.createCircleSelectorDrawable(getThemedColor(Theme.key_chat_replyPanelName) & 0x19ffffff, leftInset, 0));
                    getImageView().setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_replyPanelName), PorterDuff.Mode.MULTIPLY));
                    getTextView().setTextColor(getThemedColor(Theme.key_chat_replyPanelName));
                }
            };
            button.setOrientation(LinearLayout.HORIZONTAL);
            ViewHelper.setPadding(button, 10, 0, 10, 0);
            editView.addButton(button, LayoutHelper.createLinear(LayoutHelper.WRAP_CONTENT, LayoutHelper.MATCH_PARENT));

            final ImageView imageView = new ImageView(context);
            imageView.setScaleType(ImageView.ScaleType.CENTER);
            imageView.setImageResource(firstButton ? R.drawable.msg_photoeditor : R.drawable.msg_replace);
            button.addImageView(imageView, LayoutHelper.createLinear(24, LayoutHelper.MATCH_PARENT));

            button.addSpaceView(new Space(context), LayoutHelper.createLinear(10, LayoutHelper.MATCH_PARENT));

            final TextView textView = new TextView(context);
            textView.setMaxLines(1);
            textView.setSingleLine(true);
            textView.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
            textView.setTypeface(AndroidUtilities.bold());
            textView.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
            textView.setEllipsize(TextUtils.TruncateAt.END);
            button.addTextView(textView, LayoutHelper.createLinear(LayoutHelper.WRAP_CONTENT, LayoutHelper.MATCH_PARENT));

            button.updateColors();
            button.setOnClickListener(v -> {
                if (editingMessageObject == null || !editingMessageObject.canEditMedia() || editingMessageObjectReqId != 0) {
                    return;
                }
                if (button.isEditButton()) {
                    openEditingMessageInPhotoEditor();
                } else {
                    byButtonPress[0] = true;
                    replyLayout.callOnClick();
                }
            });
        }
        searchContainer = null;

        bottomOverlay = new FrameLayout(context) {
            @Override
            public void setVisibility(int visibility) {
                super.setVisibility(visibility);
                bottomViewsVisibilityController.setViewVisible(BOTTOM_OVERLAY_TEXT_CONTAINER, visibility == VISIBLE, getMeasuredWidth() > 0);
            }
        };
        bottomOverlay.setWillNotDraw(false);
        bottomOverlay.setVisibility(View.INVISIBLE);
        bottomOverlay.setFocusable(true);
        bottomOverlay.setFocusableInTouchMode(true);
        bottomOverlay.setClickable(true);
        chatInputBubbleContainer.addView(bottomOverlay, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 44, Gravity.BOTTOM, 7, 0, 7, 0));

        bottomOverlayText = new TextView(context);
        bottomOverlayText.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
        bottomOverlayText.setGravity(Gravity.CENTER);
        bottomOverlayText.setMaxLines(2);
        bottomOverlayText.setEllipsize(TextUtils.TruncateAt.END);
        bottomOverlayText.setLineSpacing(AndroidUtilities.dp(2), 1);
        bottomOverlayText.setTextColor(getThemedColor(Theme.key_chat_secretChatStatusText));
        bottomOverlayText.setPadding(dp(24), 0, dp(24), 0);
        bottomOverlay.addView(bottomOverlayText, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.CENTER));


        bottomChannelButtonsLayout = new ChatActivityChannelButtonsLayout(context, resourceProvider, blurredBackgroundColorProvider, glassBackgroundDrawableFactory) {
            @Override
            public void setVisibility(int visibility) {
                super.setVisibility(visibility);
                bottomViewsVisibilityController.setViewVisible(BOTTOM_OVERLAY_CHAT_CONTAINER, visibility == VISIBLE, getMeasuredWidth() > 0);
            }
        };
        bottomChannelButtonsLayout.setVisibility(View.INVISIBLE);
        bottomChannelButtonsLayout.setClipChildren(false);
        bottomChannelButtonsLayout.setAccentColor(getThemedColor(Theme.key_featuredStickers_addButton));
        bottomChannelButtonsLayout.setButtonOnClickListener(ChatActivityChannelButtonsLayout.BUTTON_SEARCH, v -> {
            openSearchWithText(isSupportedTags() ? "" : null);
        });
        bottomChannelButtonsLayout.setButtonOnClickListener(ChatActivityChannelButtonsLayout.BUTTON_GIGA_GROUP_INFO, v -> {
            createUndoView();
            undoView.showWithAction(dialog_id, UndoView.ACTION_TEXT_INFO, LocaleController.getString(R.string.BroadcastGroupInfo));
        });
        bottomChannelButtonsLayout.setButtonOnClickListener(ChatActivityChannelButtonsLayout.BUTTON_GIFT, v -> {
            MessagesController.getGlobalMainSettings().edit().putInt("channelgifthint", 3).apply();
            showDialog(new GiftSheet(getContext(), currentAccount, getDialogId(), null, null));
        });
        bottomChannelButtonsLayout.setButtonOnClickListener(ChatActivityChannelButtonsLayout.BUTTON_DIRECT, v -> {
            MessagesController.getGlobalMainSettings().edit().putInt("channelsuggesthint", 3).apply();
            if (currentChat != null && currentChat.linked_monoforum_id != 0) {
                getMessagesController().putMonoForumLinkedChat(currentChat.id, currentChat.linked_monoforum_id);
                Bundle bundle = new Bundle();
                bundle.putLong("chat_id", currentChat.linked_monoforum_id);
                bundle.putInt("chatMode", MODE_SUGGESTIONS);
                bundle.putBoolean("isSubscriberSuggestions", true);
                presentFragment(new ChatActivity(bundle));
            }
        });
        bottomChannelButtonsLayout.setButtonOnFullyVisibleListener(ChatActivityChannelButtonsLayout.BUTTON_GIFT, (v, id, firstTime) -> {
            if (bottomGiftHintView == null && firstTime && MessagesController.getGlobalMainSettings().getInt("channelgifthint", 0) < 2 && (bottomSuggestHintView == null || !bottomSuggestHintView.shown())) {
                AndroidUtilities.runOnUIThread(() -> {
                    if (getContext() == null) return;
                    final float offset = windowInsetsStateHolder.getInsets(WindowInsetsCompat.Type.navigationBars()).bottom / AndroidUtilities.density;
                    final float translate = (contentView.getWidth() - (v.getX() + v.getWidth()) + v.getWidth() / 2f) / AndroidUtilities.density;

                    bottomGiftHintView = new HintView2(getContext(), HintView2.DIRECTION_BOTTOM);
                    bottomGiftHintView.setPadding(dp(7.33f), 0, dp(7.33f), 0);
                    bottomGiftHintView.setMultilineText(false);
                    bottomGiftHintView.setText(getString(R.string.Gift2ChannelSendHint));
                    bottomGiftHintView.setJoint(1, -translate + 7.33f);
                    contentView.addView(bottomGiftHintView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 100, Gravity.BOTTOM | Gravity.FILL_HORIZONTAL, 0, 0, 0, offset + 50));
                    bottomGiftHintView.setOnHiddenListener(() -> AndroidUtilities.removeFromParent(bottomGiftHintView));
                    bottomGiftHintView.show();
                    MessagesController.getGlobalMainSettings().edit().putInt("channelgifthint", MessagesController.getGlobalMainSettings().getInt("channelgifthint", 0) + 1).apply();
                }, 400);
            }
        });
        bottomChannelButtonsLayout.setButtonOnFullyVisibleListener(ChatActivityChannelButtonsLayout.BUTTON_DIRECT, (v, id, firstTime) -> {
            if (bottomSuggestHintView == null && firstTime && MessagesController.getGlobalMainSettings().getInt("channelsuggesthint", 0) < 2) {
                AndroidUtilities.runOnUIThread(() -> {
                    if (getContext() == null) return;
                    final float offset = windowInsetsStateHolder.getInsets(WindowInsetsCompat.Type.navigationBars()).bottom / AndroidUtilities.density;
                    final float translate = (contentView.getWidth() - (v.getX() + v.getWidth()) + v.getWidth() / 2f) / AndroidUtilities.density;

                    bottomSuggestHintView = new HintView2(getContext(), HintView2.DIRECTION_BOTTOM);
                    bottomSuggestHintView.setPadding(dp(7.33f), 0, dp(7.33f), 0);
                    bottomSuggestHintView.setMultilineText(false);
                    bottomSuggestHintView.setText(getString(R.string.Suggest2ChannelSendHint), true);
                    bottomSuggestHintView.setJoint(1, -translate + 7.33f);
                    contentView.addView(bottomSuggestHintView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 100, Gravity.BOTTOM | Gravity.FILL_HORIZONTAL, 0, 0, 0, offset + 50));
                    bottomSuggestHintView.setOnHiddenListener(() -> AndroidUtilities.removeFromParent(bottomSuggestHintView));
                    bottomSuggestHintView.show();
                    MessagesController.getGlobalMainSettings().edit().putInt("channelsuggesthint", MessagesController.getGlobalMainSettings().getInt("channelsuggesthint", 0) + 1).apply();
                }, 400);
            }
        });
        bottomChannelButtonsLayout.setOnButtonsTotalWidthChanged((l, r) -> {
            chatInputViewsContainer.setInputBubbleOffsets(l, r);
        });

        chatInputBubbleContainer.addView(bottomChannelButtonsLayout, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 56, Gravity.BOTTOM, 0, 0, 0, (44 - 56) / 2));

        bottomOverlayStartButton = new TextView(context) {
            CellFlickerDrawable cellFlickerDrawable;

            @Override
            protected void onDraw(Canvas canvas) {
                super.onDraw(canvas);
                if (cellFlickerDrawable == null) {
                    cellFlickerDrawable = new CellFlickerDrawable();
                    cellFlickerDrawable.drawFrame = false;
                    cellFlickerDrawable.repeatProgress = 2f;
                }
                cellFlickerDrawable.setParentWidth(getMeasuredWidth());
                AndroidUtilities.rectTmp.set(0, 0, getMeasuredWidth(), getMeasuredHeight());
                cellFlickerDrawable.draw(canvas, AndroidUtilities.rectTmp, AndroidUtilities.dp(22), null);
                invalidate();
            }
        };
        bottomOverlayStartButton.setBackground(Theme.AdaptiveRipple.filledRect(getThemedColor(Theme.key_featuredStickers_addButton), 22));
        bottomOverlayStartButton.setTextColor(getThemedColor(Theme.key_featuredStickers_buttonText));
        bottomOverlayStartButton.setText(LocaleController.getString(R.string.BotStart));
        bottomOverlayStartButton.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 16);
        bottomOverlayStartButton.setGravity(Gravity.CENTER);
        bottomOverlayStartButton.setTypeface(AndroidUtilities.bold());
        bottomOverlayStartButton.setVisibility(View.GONE);
        bottomOverlayStartButton.setOnClickListener(v -> bottomOverlayChatText.callOnClick());
        bottomChannelButtonsLayout.getContainer().addView(bottomOverlayStartButton, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 38, Gravity.CENTER, 3, 3, 3, 3));

        if (currentUser != null && currentUser.bot && currentUser.id != UserObject.VERIFY && !UserObject.isDeleted(currentUser) && !UserObject.isReplyUser(currentUser) && !isInScheduleMode() && chatMode != MODE_PINNED && chatMode != MODE_SAVED && !isReport() && !UserObject.isBotForum(currentUser)) {
            bottomOverlayStartButton.setVisibility(View.VISIBLE);
            bottomChannelButtonsLayout.setVisibility(View.VISIBLE);
        }

        bottomOverlayLinksText = new LinkSpanDrawable.LinksTextView(context, themeDelegate);
        bottomOverlayLinksText.setVisibility(View.GONE);
        bottomOverlayLinksText.setGravity(Gravity.CENTER);
        bottomOverlayLinksText.setTextAlignment(View.TEXT_ALIGNMENT_CENTER);
        bottomOverlayLinksText.setTextColor(getThemedColor(Theme.key_graySectionText));
        bottomOverlayLinksText.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 13);
        bottomChannelButtonsLayout.getContainer().addView(bottomOverlayLinksText, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.CENTER));
        bottomOverlayLinksText.setBackground(Theme.createSelectorDrawable(getThemedColor(Theme.key_listSelector), Theme.RIPPLE_MASK_ALL));
        bottomOverlayLinksText.setOnClickListener(v -> {
            if (chatMode == MODE_DEFAULT && getMessagesController().freezeUntilDate > getConnectionsManager().getCurrentTime() && !AccountFrozenAlert.isSpamBot(currentAccount, currentUser)) {
                AccountFrozenAlert.show(getContext(), currentAccount, getResourceProvider());
            }
        });

        bottomOverlayChatText = new UnreadCounterTextView(context) {
            @Override
            protected void updateCounter() {
                if (ChatObject.isChannel(currentChat) && !currentChat.megagroup && chatInfo != null && chatInfo.linked_chat_id != 0) {
                    TLRPC.Dialog dialog = getMessagesController().dialogs_dict.get(-chatInfo.linked_chat_id);
                    if (dialog != null) {
                        setCounter(dialog.unread_count);
                        return;
                    }
                }
                setCounter(0);
            }

            @Override
            protected Theme.ResourcesProvider getResourceProvider() {
                return themeDelegate;
            }
        };
        bottomChannelButtonsLayout.getContainer().addView(bottomOverlayChatText, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, 0));
        bottomOverlayChatText.setOnClickListener(view -> {
            if (getParentActivity() == null || pullingDownOffset != 0) {
                return;
            }
            if (MessagesController.getGlobalMainSettings().getBoolean("hideBottomButton", false)) {
                return;
            }
            if (chatMode == MODE_SAVED) {
                Bundle args = new Bundle();
                long dialogId = getSavedDialogId();
                if (dialogId >= 0) {
                    args.putLong("user_id", dialogId);
                } else {
                    args.putLong("chat_id", -dialogId);
                }
                presentFragment(new ChatActivity(args));
            } else if (isReport()) {
                ArrayList<Integer> ids = new ArrayList<>();
                for (int b = 0; b < selectedMessagesIds[0].size(); b++) {
                    ids.add(selectedMessagesIds[0].keyAt(b));
                }
                showBottomOverlayProgress(true, true);
                ReportBottomSheet.continueReport(this, reportOption, reportMessage, ids, status -> {
                    showBottomOverlayProgress(true, false);
                    if (status) {
                        finishFragment();
                    }
                });
            } else if (chatMode == MODE_PINNED) {
                finishFragment();
                chatActivityDelegate.onUnpin(true, bottomOverlayChatText.getTag() == null);
            } else if (currentUser != null && currentUser.id == UserObject.VERIFY) {
                toggleMute(true);
            } else if (currentUser != null && userBlocked) {
                if (currentUser.bot) {
                    String botUserLast = botUser;
                    botUser = null;
                    getMessagesController().unblockPeer(currentUser.id, () -> {
                        if (botUserLast != null && botUserLast.length() != 0) {
                            getMessagesController().sendBotStart(currentUser, botUserLast);
                        } else {
                            getSendMessagesHelper().sendMessage(SendMessagesHelper.SendMessageParams.of("/start", dialog_id, null, null, null, false, null, null, null, true, 0, 0, null, false));
                        }
                    });
                } else {
                    AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                    builder.setMessage(LocaleController.getString(R.string.AreYouSureUnblockContact));
                    builder.setPositiveButton(LocaleController.getString(R.string.OK), (dialogInterface, i) -> getMessagesController().unblockPeer(currentUser.id));
                    builder.setTitle(LocaleController.getString(R.string.AppName));
                    builder.setNegativeButton(LocaleController.getString(R.string.Cancel), null);
                    showDialog(builder.create());
                }
            } else if (UserObject.isReplyUser(currentUser)) {
                toggleMute(true);
            } else if (currentUser != null && currentUser.bot && botUser != null) {
                if (botUser.length() != 0) {
                    getMessagesController().sendBotStart(currentUser, botUser);
                } else {
                    getSendMessagesHelper().sendMessage(SendMessagesHelper.SendMessageParams.of("/start", dialog_id, null, null, null, false, null, null, null, true, 0, 0, null, false));
                }
                botUser = null;
                updateBottomOverlay();
            } else {
                if (ChatObject.isChannel(currentChat) && !(currentChat instanceof TLRPC.TL_channelForbidden)) {
                    if (ChatObject.isNotInChat(currentChat)) {
                        if (currentChat.join_request) {
//                            showDialog(new JoinGroupAlert(context, currentChat, null, this));
                            showBottomOverlayProgress(true, true);
                            MessagesController.getInstance(currentAccount).addUserToChat(
                                currentChat.id,
                                UserConfig.getInstance(currentAccount).getCurrentUser(),
                                0,
                                null,
                                null,
                                true,
                                () -> {
                                    showBottomOverlayProgress(false, true);
                                },
                                err -> {
                                    SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                                    preferences.edit().putLong("dialog_join_requested_time_" + dialog_id, System.currentTimeMillis()).commit();
                                    if (err != null && "INVITE_REQUEST_SENT".equals(err.text)) {
                                        JoinGroupAlert.showBulletin(context, this, ChatObject.isChannel(currentChat) && !currentChat.megagroup);
                                    }
                                    showBottomOverlayProgress(false, true);
                                    return false;
                                }
                            );
                        } else {
                            if (chatInviteRunnable != null) {
                                AndroidUtilities.cancelRunOnUIThread(chatInviteRunnable);
                                chatInviteRunnable = null;
                            }
                            showBottomOverlayProgress(true, true);
                            getMessagesController().addUserToChat(currentChat.id, getUserConfig().getCurrentUser(), 0, null, ChatActivity.this, null);
                            NotificationCenter.getGlobalInstance().postNotificationName(NotificationCenter.closeSearchByActiveAction);

                            if (hasReportSpam() && reportSpamButton.getTag(R.id.object_tag) != null) {
                                SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                                preferences.edit().putInt("dialog_bar_vis3" + dialog_id, 3).commit();
                                getNotificationCenter().postNotificationName(NotificationCenter.peerSettingsDidLoad, dialog_id);
                            }
                        }
                    } else {
                        toggleMute(true);
                    }
                } else {
                    boolean canDeleteHistory = chatInfo != null && chatInfo.can_delete_channel;
                    AlertsCreator.createClearOrDeleteDialogAlert(ChatActivity.this, false, currentChat, currentUser, currentEncryptedChat != null, true, canDeleteHistory, (param) -> {
                        getNotificationCenter().removeObserver(ChatActivity.this, NotificationCenter.closeChats);
                        getNotificationCenter().postNotificationName(NotificationCenter.closeChats);
                        finishFragment();
                        getNotificationCenter().postNotificationName(NotificationCenter.needDeleteDialog, dialog_id, currentUser, currentChat, param);
                    }, themeDelegate);
                }
            }
        });

        bottomOverlayProgress = new RadialProgressView(context, themeDelegate);
        bottomOverlayProgress.setSize(AndroidUtilities.dp(22));
        bottomOverlayProgress.setProgressColor(getThemedColor(Theme.key_chat_fieldOverlayText));
        bottomOverlayProgress.setVisibility(View.INVISIBLE);
        bottomOverlayProgress.setScaleX(0.1f);
        bottomOverlayProgress.setScaleY(0.1f);
        bottomOverlayProgress.setAlpha(1.0f);
        bottomChannelButtonsLayout.getContainer().addView(bottomOverlayProgress, LayoutHelper.createFrame(30, 30, Gravity.CENTER));

        contentView.addView(messageEnterTransitionContainer = new MessageEnterTransitionContainer(contentView, currentAccount));

        if (currentChat != null) {
            slowModeHint = new HintView(getParentActivity(), 2, themeDelegate);
            slowModeHint.setAlpha(0.0f);
            slowModeHint.setVisibility(View.INVISIBLE);
            contentView.addView(slowModeHint, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 19, 0, 19, 0));
        }

        chatAdapter.updateRowsSafe();

        if (loading && messages.isEmpty()) {
            showProgressView(chatAdapter.botInfoRow < 0);
            chatListView.setEmptyView(null);
        } else {
            showProgressView(false);
            createEmptyView(false);
            chatListView.setEmptyView(emptyViewContainer);
        }

        checkBotKeyboard();
        updateBottomOverlay();
        updateSecretStatus();
        updateTopPanel(false);
        updatePinnedMessageView(false);
        updateInfoTopView(false);

        chatScrollHelper = new RecyclerAnimationScrollHelper(chatListView, chatLayoutManager) {
            @Override
            public void setScrollDirection(int scrollDirection) {
                if (reversed) {
                    if (scrollDirection == RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN) {
                        scrollDirection = RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP;
                    } else if (scrollDirection == RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP) {
                        scrollDirection = RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN;
                    }
                }
                super.setScrollDirection(scrollDirection);
            }
        };
        chatScrollHelper.setScrollListener(this::invalidateMessagesVisiblePart);
        chatScrollHelper.setAnimationCallback(chatScrollHelperCallback);

        flagSecure = new FlagSecureReason(getParentActivity().getWindow(), () ->
            currentEncryptedChat != null ||
            getMessagesController().isChatNoForwards(currentChat)
        );

        if (oldMessage != null) {
            chatActivityEnterView.setFieldText(oldMessage);
        }

        fixLayoutInternal();

        textSelectionHelper.setCallback(new TextSelectionHelper.Callback() {
            @Override
            public void onStateChanged(boolean isSelected) {
                swipeBackEnabled = !isSelected;
                if (isSelected) {
                    if (slidingView != null) {
                        slidingView.setSlidingOffset(0);
                        slidingView = null;
                    }
                    maybeStartTrackingSlidingView = false;
                    startedTrackingSlidingView = false;
                    if (textSelectionHint != null) {
                        textSelectionHint.hide();
                    }
                }
                updatePagedownButtonVisibility(true);
            }

            @Override
            public void onTextCopied() {
                if (actionBar != null && actionBar.isActionModeShowed()) {
                    clearSelectionMode();
                }
                createUndoView();
                undoView.showWithAction(0, UndoView.ACTION_TEXT_COPIED, null);
            }
        });

        View overlay = textSelectionHelper.getOverlayView(context);
        if (overlay != null) {
            if (overlay.getParent() instanceof ViewGroup) {
                ((ViewGroup) overlay.getParent()).removeView(overlay);
            }
            contentView.addView(overlay);
        }
        textSelectionHelper.setParentView(chatListView);

        hashtagHistoryView = new HashtagHistoryView(context, resourceProvider, currentAccount) {
            @Override
            protected void onClick(String hashtag) {
                openHashtagSearch(hashtag);
            }

            @Override
            protected void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (recyclerView.getScrollState() == RecyclerView.SCROLL_STATE_DRAGGING) {
                    AndroidUtilities.hideKeyboard(contentView);
                }
            }
        };
        hashtagHistoryView.setVisibility(View.GONE);
        hashtagHistoryView.setAlpha(0f);
        contentView.addView(hashtagHistoryView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.LEFT | Gravity.TOP, 0, 0, 0, 0));

        contentView.addView(fireworksOverlay = new FireworksOverlay(context), LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));

        checkInstantSearch();
        if (replyingMessageObject != null) {
            chatActivityEnterView.setReplyingMessageObject(replyingMessageObject, replyingQuote);
        }

        ViewGroup decorView = (ViewGroup) getParentActivity().getWindow().getDecorView();
        pinchToZoomHelper = new PinchToZoomHelper(decorView, contentView) {
            @Override
            protected void drawOverlays(Canvas canvas, float alpha, float parentOffsetX, float parentOffsetY, float clipTop, float clipBottom) {
                if (alpha > 0) {
                    View view = getChild();
                    if (view instanceof ChatMessageCell) {
                        ChatMessageCell cell = (ChatMessageCell) view;

                        int top = (int) Math.max(clipTop, parentOffsetY);
                        int bottom = (int) Math.min(clipBottom, parentOffsetY + cell.getMeasuredHeight());
                        AndroidUtilities.rectTmp.set(parentOffsetX, top, parentOffsetX + cell.getMeasuredWidth(), bottom);
                        canvas.saveLayerAlpha(AndroidUtilities.rectTmp, (int) (255 * alpha), Canvas.ALL_SAVE_FLAG);
                        canvas.translate(parentOffsetX, parentOffsetY + cell.getPaddingTop());
                        cell.drawFromPinchToZoom = true;
                        cell.drawOverlays(canvas);
                        if (cell.shouldDrawTimeOnMedia() && cell.getCurrentMessagesGroup() == null) {
                            cell.drawTime(canvas, 1f, false);
                        }
                        cell.drawFromPinchToZoom = false;
                        canvas.restore();
                    }
                }
            }
        };
        pinchToZoomHelper.setCallback(new PinchToZoomHelper.Callback() {

            @Override
            public TextureView getCurrentTextureView() {
                return videoTextureView;
            }

            @Override
            public void onZoomStarted(MessageObject messageObject) {
                chatListView.cancelClickRunnables(true);
                chatListView.stopScroll();
                if (MediaController.getInstance().isPlayingMessage(messageObject)) {
                    contentView.removeView(videoPlayerContainer);
                    videoPlayerContainer = null;
                    videoTextureView = null;
                    aspectRatioFrameLayout = null;
                }

                for (int i = 0; i < chatListView.getChildCount(); i++) {
                    if (chatListView.getChildAt(i) instanceof ChatMessageCell) {
                        ChatMessageCell cell = (ChatMessageCell) chatListView.getChildAt(i);
                        if (cell.getMessageObject() != null && cell.getMessageObject().getId() == messageObject.getId()) {
                            cell.getPhotoImage().setVisible(false, true);
                        }
                    }
                }
            }

            @Override
            public void onZoomFinished(MessageObject messageObject) {
                if (messageObject == null) {
                    return;
                }
                if (MediaController.getInstance().isPlayingMessage(messageObject)) {
                    for (int i = 0; i < chatListView.getChildCount(); i++) {
                        if (chatListView.getChildAt(i) instanceof ChatMessageCell) {
                            ChatMessageCell cell = (ChatMessageCell) chatListView.getChildAt(i);
                            if (cell.getMessageObject() != null && cell.getMessageObject().getId() == messageObject.getId()) {
                                AnimatedFileDrawable animation = cell.getPhotoImage().getAnimation();
                                if (animation.isRunning()) {
                                    animation.stop();
                                }
                                if (animation != null) {
                                    Bitmap bitmap = animation.getAnimatedBitmap();
                                    if (bitmap != null) {
                                        try {
                                            Bitmap src = pinchToZoomHelper.getVideoBitmap(bitmap.getWidth(), bitmap.getHeight());
                                            Canvas canvas = new Canvas(bitmap);
                                            canvas.drawBitmap(src, 0, 0, null);
                                            src.recycle();
                                        } catch (Throwable e) {
                                            FileLog.e(e);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    createTextureView(true);
                    MediaController.getInstance().setTextureView(videoTextureView, aspectRatioFrameLayout, videoPlayerContainer, true);
                }
                chatListView.invalidate();
            }

        });
        pinchToZoomHelper.setClipBoundsListener(topBottom -> {
            topBottom[1] = chatListView.getBottom() - blurredViewBottomOffset;
            topBottom[0] = chatListView.getTop() + chatListViewPaddingTop - AndroidUtilities.dp(4);
        });
        emojiAnimationsOverlay = new EmojiAnimationsOverlay(ChatActivity.this, contentView, chatListView, currentAccount, dialog_id, threadMessageId) {
            @Override
            public void onAllEffectsEnd() {
                updateMessagesVisiblePart(false);
            }
        };
        actionBar.setDrawBlurBackground(contentView);

        if (isTopic) {
            reactionsMentionCount = forumTopic.unread_reactions_count;
            updateReactionsMentionButton(false);
        } else {
            TLRPC.Dialog dialog = getMessagesController().dialogs_dict.get(dialog_id);
            if (dialog != null) {
                reactionsMentionCount = dialog.unread_reactions_count;
                updateReactionsMentionButton(false);
            }
        }

        if (getDialogId() == getUserConfig().getClientUserId() && chatMode != MODE_SAVED) {
            savedMessagesHint = new HintView2(context, HintView2.DIRECTION_TOP);
            savedMessagesHint.setMultilineText(true);
            savedMessagesHint.setTextAlign(Layout.Alignment.ALIGN_CENTER);
            savedMessagesHint.setText(AndroidUtilities.replaceTags(LocaleController.getString(R.string.SavedMessagesHint)));
            savedMessagesHint.setMaxWidthPx(HintView2.cutInFancyHalf(savedMessagesHint.getText(), savedMessagesHint.getTextPaint()));
            if (AndroidUtilities.isTablet()) {
                savedMessagesHint.setJoint(0, 77);
            } else {
                savedMessagesHint.setJoint(0.5f, 0);
            }
            savedMessagesHint.setCloseButton(true);
			savedMessagesHint.setOnHiddenListener(() -> {
                if (searchContainer == null || searchContainer.getVisibility() != View.VISIBLE) {
                    if (savedMessagesSearchHint != null) {
                        savedMessagesSearchHint.show();
                    }
                }
			});
			savedMessagesHint.setDuration(-1);
            savedMessagesHint.setPadding(dp(8), 0, dp(8), 0);
            contentView.addView(savedMessagesHint, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 120, Gravity.TOP | Gravity.FILL_HORIZONTAL, 0, -8, 0, 0));

            savedMessagesSearchHint = new HintView2(context, HintView2.DIRECTION_TOP)
                    .setMultilineText(true)
                    .setTextAlign(Layout.Alignment.ALIGN_CENTER)
                    .setDuration(-1)
                    .setHideByTouch(true)
                    .useScale(true)
                    .setCloseButton(true)
                    .setJointPx(1, -dp(56))
                    .setRounding(8);
			savedMessagesSearchHint.setText(LocaleController.getString(R.string.SavedTagSearchTooltipHint));
			contentView.addView(savedMessagesSearchHint, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 120, Gravity.TOP | Gravity.FILL_HORIZONTAL, 16, -8, 16, 0));

            if (getUserConfig().isPremium()) {
                savedMessagesTagHint = new HintView2(context, HintView2.DIRECTION_BOTTOM)
                        .setMultilineText(true)
                        .setTextAlign(Layout.Alignment.ALIGN_CENTER)
                        .setDuration(-1)
                        .setHideByTouch(true)
                        .useScale(true)
                        .setCloseButton(true)
                        .setRounding(8);
                savedMessagesTagHint.setText(LocaleController.getString(R.string.SavedTagLongpressHint));
                contentView.addView(savedMessagesTagHint, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 120, Gravity.TOP | Gravity.FILL_HORIZONTAL, 16, 0, 16, 0));
            }
        }

        if (getDialogId() == getUserConfig().getClientUserId()) {
            actionBarSearchTags = new SearchTagsList(context, ChatActivity.this, contentView, currentAccount, getSavedDialogId(), themeDelegate, true) {
                @Override
                protected boolean setFilter(ReactionsLayoutInBubble.VisibleReaction reaction) {
                    searchingReaction = reaction;
                    searchingFiltered = reaction != null;
                    if (reaction == null) {
                        getMediaDataController().clearFoundMessageObjects();
                        setFilterMessages(false);
                        updateSearchButtons(0, 0, -1);
                    }
                    updateSearchUpDownButtonVisibility(true);
                    updatePagedownButtonVisibility(true);
                    searchingQuery = searchItem.getSearchField().getText().toString();
                    getMediaDataController().searchMessagesInChat(searchingQuery, dialog_id, mergeDialogId, classGuid, 0, threadMessageId, false, searchingUserMessages, searchingChatMessages, !TextUtils.isEmpty(searchingQuery) || searchingReaction != null, searchingReaction);
                    AndroidUtilities.hideKeyboard(searchItem.getSearchField());
                    return true;
                }

                @Override
                public void updateTags(boolean notify) {
                    super.updateTags(notify);
                    show(searchItem != null && searchItem.isSearchFieldVisible() && hasFilters() && searchingHashtag == null);
                }

                @Override
                protected void onShownUpdate(boolean finish) {
                    setBackgroundColor(actionBar.getBackgroundColor());
                    if (tagSelector != null) {
                        tagSelector.setTranslationY(contentPanTranslation + getCurrentHeight());
                    }
                    if (finish) {
                        invalidateChatListViewTopPadding = true;
                        updateChatListViewTopPadding();
                    }
                }
            };
            actionBarSearchTags.setVisibility(View.GONE);
            actionBarSearchTags.attach();
            contentView.addView(actionBarSearchTags, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 40, Gravity.FILL_HORIZONTAL | Gravity.TOP));
        }

        if (chatMode == MODE_SEARCH) {
            messagesSearchListContainer.setVisibility(View.VISIBLE);
            messagesSearchListContainer.setAlpha(1.0f);
            messagesSearchListContainer.setTag(1);
            searchExpandList.setText(LocaleController.getString(R.string.SearchAsChat), false);
            updateSearchListEmptyView();
        }

        final boolean useTabsView = !isSubscriberSuggestions && ChatObject.isMonoForum(currentChat)
            || ChatObject.isForum(currentChat) && ChatObject.areTabsEnabled(currentChat)
            || UserObject.isBotForum(currentUser);

        if (useTabsView) {
            createTopicsTabs();
        }

        if (context instanceof LaunchActivity) {
            windowInsetsStateHolder.setupAnimatedInsetsProvider(((LaunchActivity) context).getRootAnimatedInsetsListener(), fragmentView);
        }

        onBottomItemsVisibilityChanged();
        ViewCompat.setOnApplyWindowInsetsListener(fragmentView, this::onApplyWindowInsets);
        Timer.finish(t);

        return fragmentView;
    }

    private boolean lastImeVisible;

    @NonNull
    private WindowInsetsCompat onApplyWindowInsets(@NonNull View v, @NonNull WindowInsetsCompat insets) {
        windowInsetsStateHolder.setInsets(insets);
        checkUi_chatListViewPaddings();

        final boolean keyboardVisible = insets.isVisible(WindowInsetsCompat.Type.ime());
        if (lastImeVisible != keyboardVisible) {
            lastImeVisible = keyboardVisible;
            contentView.notifyHeightChanged();
        }

        if (searchViewPager != null) {
            ViewCompat.dispatchApplyWindowInsets(searchViewPager, insets);
        }

        return WindowInsetsCompat.CONSUMED;
    }

    private boolean lastInAppInputVisible;
    private void checkInsets() {
        chatInputViewsContainer.checkInsets();
        updatePagedownButtonsPosition();
        updateBotforumTabsBottomMargin();
        checkUi_botMenuPosition();
        checkUi_BlurHeight();
        checkUi_emptyContainerPosition();
        checkUi_chatListViewPaddings();
        invalidateClipRectForBackgroundAndChatList();

        final boolean inAppInputVisible = windowInsetsStateHolder.inAppViewIsVisible();
        if (lastInAppInputVisible != inAppInputVisible) {
            lastInAppInputVisible = inAppInputVisible;
            checkSystemBarColors();
        }
    }

    private void checkBotMessageHint() {
        if (botMessageHint != null) {
            return;
        }
        ChatMessageCell cell = null;
        for (int i = chatListView.getChildCount() - 1; i >= 0; --i) {
            View child = chatListView.getChildAt(i);
            if (child instanceof ChatMessageCell) {
                ChatMessageCell messageCell = ((ChatMessageCell) child);
                MessageObject msg = messageCell.getPrimaryMessageObject();
                if (msg != null && msg.messageOwner != null && msg.messageOwner.via_business_bot_id != 0) {
                    cell = messageCell;
                }
            }
        }
        showBotMessageHint(cell, false);
    }

    private boolean bizbothint;
    private void showBotMessageHint(ChatMessageCell cell, boolean byClick) {
        if (
            getContext() == null || cell == null || cell.timeLayout == null ||
            cell.getPrimaryMessageObject() == null || cell.getPrimaryMessageObject().messageOwner == null ||
            cell.getPrimaryMessageObject().messageOwner.via_business_bot_id == 0) {
            return;
        }
        if (!byClick) {
            if (getMessagesController().getMainSettings().getBoolean("bizbothint", false)) {
                return;
            }
            getMessagesController().getMainSettings().edit().putBoolean("bizbothint", true).apply();
            if (bizbothint) return;
            bizbothint = true;
        }
        if (botMessageHint != null) {
            if (byClick) {
                HintView2 hint = botMessageHint;
                hint.setOnHiddenListener(() -> contentView.removeView(hint));
                hint.hide();
                botMessageHint = null;
            } else {
                return;
            }
        }
        botMessageHint = new HintView2(getContext(), HintView2.DIRECTION_BOTTOM)
            .setMultilineText(true)
            .setTextAlign(Layout.Alignment.ALIGN_NORMAL)
            .setDuration(-1)
            .setHideByTouch(true)
            .useScale(true)
            .setCloseButton(true)
            .setRounding(8);
        botMessageHint.setText(AndroidUtilities.replaceTags(LocaleController.getString(R.string.MessageBizBot)));
        botMessageHint.setMaxWidthPx(HintView2.cutInFancyHalf(botMessageHint.getText(), botMessageHint.getTextPaint()));
        contentView.addView(botMessageHint, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 120, Gravity.TOP | Gravity.FILL_HORIZONTAL, 16, 0, 16, 0));
        contentView.post(() -> {
            int[] loc = new int[2];
            cell.getLocationInWindow(loc);
            botMessageHint.setTranslationY(loc[1] - botMessageHint.getTop() - dp(120) + cell.getTimeY());
            botMessageHint.setJointPx(0, -dp(16) + loc[0] + cell.timeX + cell.timeWidth - cell.signWidth / 2f);
            botMessageHint.show();
        });
    }

    private void hideHints() {
        if (savedMessagesTagHint != null && savedMessagesTagHint.shown()) {
            savedMessagesTagHint.hide();
        }
        if (videoConversionTimeHint != null && videoConversionTimeHint.shown()) {
            videoConversionTimeHint.hide();
        }
        if (chatActivityEnterView != null) {
            chatActivityEnterView.hideHints();
        }
    }

    public void setTagFilter(ReactionsLayoutInBubble.VisibleReaction reaction) {
        if (actionBarSearchTags != null) {
            actionBarSearchTags.setChosen(reaction, true);
        }
        searchItemVisible = searching = !TextUtils.isEmpty(searchingQuery) || searchingReaction != null;
        updateBottomOverlay();
        updateSearchUpDownButtonVisibility(true);
    }

    public void setSearchQuery(String text) {
        if (searchItem != null) {
            searchItem.setSearchFieldText(searchingQuery = text, false);
        }
    }

    public void hitSearch() {
        searchWas = true;
        updateSearchButtons(0, 0, -1);
        getMediaDataController().searchMessagesInChat(searchingQuery, dialog_id, mergeDialogId, classGuid, 0, threadMessageId, searchingUserMessages, searchingChatMessages, searchingReaction);
        searchItemVisible = searching = !TextUtils.isEmpty(searchingQuery) || searchingReaction != null;
        updateBottomOverlay();
        updateSearchUpDownButtonVisibility(true);
    }

    public void clearSearch() {
        if (searchItemListener != null) {
            searchItemListener.onSearchCollapse();
        }
        searching = false;
        searchItemVisible = false;
        updateBottomOverlay();
        updateSearchUpDownButtonVisibility(true);
    }

    protected void onSearchLoadingUpdate(boolean loading) {

    }

    private void setFilterMessages(boolean filter) {
        setFilterMessages(filter, false, true);
    }
    private void setFilterMessages(boolean filter, boolean ignoreMessageNotFound, boolean animated) {
        if (chatAdapter == null || chatAdapter.isFiltered == filter) return;
        chatAdapter.isFiltered = filter;
        createEmptyView(true);
        if (filter) {
            updateFilteredMessages(false);
        }
        if (!saveScrollOnFilterToggle(animated, ignoreMessageNotFound)) {
            chatAdapter.isFiltered = !filter;
        }
        if (searchOtherButton != null) {
            searchOtherButton.setText(LocaleController.getString(chatAdapter.isFiltered ? R.string.SavedTagShowOtherMessages : R.string.SavedTagHideOtherMessages));
        }
        updateSearchUpDownButtonVisibility(true);
        showProgressView(!chatAdapter.isFiltered ? loading && messages.isEmpty() && chatAdapter.botInfoRow < 0 : getMediaDataController().isSearchLoading() && chatAdapter.filteredMessages.isEmpty());
        if (chatListView != null) {
            createEmptyView(false);
            if (!(!chatAdapter.isFiltered ? !loading && messages.isEmpty() && chatAdapter.botInfoRow < 0 : !getMediaDataController().isSearchLoading() && chatAdapter.filteredMessages.isEmpty())) {
                emptyViewContainer.setVisibility(View.GONE);
                chatListView.setEmptyView(null);
            } else {
                chatListView.setEmptyView(emptyViewContainer);
                chatListView.checkIfEmpty();
            }
        }
    }

    private boolean saveScrollOnFilterToggle(boolean animated, boolean ignoreMessageNotFound) {
        final ArrayList<MessageObject> newMessagesArray = chatAdapter.getMessages();

        int index = -1;
        int centerId = 0;
        int centerStableId = 0;
        int offset = 0;
        int cy = chatListView.getMeasuredHeight() / 2;
        ArrayList<View> views = new ArrayList<>();
        HashMap<View, Integer> distances = new HashMap<>();
        for (int i = 0; i < chatListView.getChildCount(); ++i) {
            View child = chatListView.getChildAt(i);
//            int ccy = (child.getTop() + child.getBottom()) / 2;
//            views.put(Math.abs(ccy - cy), child); // base on center
            int dist = (int) (chatListView.getMeasuredHeight() * .97f) - dp(42) - child.getBottom();
            if (dist < 0) continue;
            distances.put(child, dist);
            views.add(child);
        }
        Collections.sort(views, Comparator.comparingInt(distances::get));
        HashSet<Integer> ids = new HashSet<Integer>();
        HashSet<Integer> stableIds = new HashSet<Integer>();
        for (int i = 0; i < newMessagesArray.size(); ++i) {
            MessageObject m = newMessagesArray.get(i);
            if (!m.isDateObject) {
                ids.add(m.getId());
            }
            stableIds.add(m.stableId);
        }
        for (int i = 0; i < views.size(); ++i) {
            View child = views.get(i);
            MessageObject msg;
            if (child instanceof ChatMessageCell) {
                msg = ((ChatMessageCell) child).getMessageObject();
            } else if (child instanceof ChatActionCell) {
                msg = ((ChatActionCell) child).getMessageObject();
            } else {
                continue;
            }
            if (msg == null) continue;
            int id = msg.getId();
            if (ids.contains(id)) {
                centerId = id;
                offset = getScrollingOffsetForView(child);
                break;
            } else if (stableIds.contains(msg.stableId)) {
                centerStableId = msg.stableId;
                offset = getScrollingOffsetForView(child);
                break;
            }
        }
        if (centerId == 0 && centerStableId == 0) {
            if (!chatAdapter.isFiltered && !ignoreMessageNotFound) {
                for (int j = 0; j < views.size(); ++j) {
                    View centerView = views.get(j);
                    MessageObject msg;
                    if (centerView instanceof ChatMessageCell) {
                        msg = ((ChatMessageCell) centerView).getMessageObject();
                    } else {
                        continue;
                    }
                    if (msg == null) {
                        continue;
                    }
                    int id = msg.getId();

                    waitingForLoad.clear();
                    removeSelectedMessageHighlight();
                    scrollToMessagePosition = -10000;
                    startLoadFromMessageId = id;
                    showScrollToMessageError = false;
                    createUnreadMessageAfterIdLoading = false;
                    postponedScrollIsCanceled = false;
                    waitingForLoad.add(lastLoadIndex);
                    postponedScrollToLastMessageQueryIndex = lastLoadIndex;
                    fakePostponedScroll = true;
                    postponedScrollMinMessageId = minMessageId[0];
                    postponedScrollMessageId = id;
                    getMessagesController().loadMessages(dialog_id, 0, false, 50, startLoadFromMessageId, 0, true, 0, classGuid, 3, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                    return false;
                }
            }
            for (int j = 0; j < views.size(); ++j) {
                View centerView = views.get(j);
                MessageObject msg;
                if (centerView instanceof ChatMessageCell) {
                    msg = ((ChatMessageCell) centerView).getMessageObject();
                } else {
                    continue;
                }
                if (msg == null) {
                    continue;
                }
                int id = msg.getId();
                int mid = -1;
                int leastDist = Integer.MAX_VALUE;
                for (int i = 0; i < newMessagesArray.size(); ++i) {
                    MessageObject msg2 = newMessagesArray.get(i);
                    if (msg2.getId() == 0) continue;
                    final int dist = Math.abs(msg2.getId() - id);
                    if (dist < leastDist) {
                        leastDist = dist;
                        mid = msg2.getId();

                        index = i;
                        offset = 0;
                    }
                }
                if (mid != -1) {
                    break;
                }
            }
        }
        if (centerStableId != 0) {
            for (int i = 0; i < newMessagesArray.size(); ++i) {
                if (newMessagesArray.get(i).stableId == centerStableId) {
                    index = i;
                    break;
                }
            }
        } else if (centerId != 0) {
            for (int i = 0; i < newMessagesArray.size(); ++i) {
                if (newMessagesArray.get(i).getId() == centerId) {
                    index = i;
                    break;
                }
            }
        }
        chatAdapter.updateRowsSafe();
        if (index >= 0) {
            int newPosition = chatAdapter.messagesStartRow + index;
            chatLayoutManager.scrollToPositionWithOffset(newPosition, offset);
        }
        chatAdapter.notifyDataSetChanged(animated);
        return true;
    }

    private LongSparseArray<ArrayList<MessageObject>> filteredMessagesByDays;
    private LongSparseArray<MessageObject> filteredMessagesDict;

    private void putFilteredDate(int index, MessageObject baseMsg) {
        TLRPC.Message dateMsg = new TLRPC.TL_message();
        dateMsg.message = LocaleController.formatDateChat(baseMsg.messageOwner.date);
        dateMsg.id = 0;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(((long) baseMsg.messageOwner.date) * 1000);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        dateMsg.date = (int) (calendar.getTimeInMillis() / 1000);
        MessageObject dateObj = new MessageObject(currentAccount, dateMsg, false, false);
        dateObj.type = 10;
        dateObj.contentType = 1;
        dateObj.isDateObject = true;
        dateObj.stableId = getStableIdForDateObject(baseMsg.dateKeyInt);
        chatAdapter.filteredMessages.add(index, dateObj);
    }

    private void createHint2MessageObject() {
        if (hint2MessageObject != null) return;
        TLRPC.Message dateMsg = new TLRPC.TL_message();
        if (chatMode == MODE_SAVED) {
            dateMsg.message = LocaleController.getString(R.string.SavedMessagesProfileHint);
        } else {
            dateMsg.message = LocaleController.getString(R.string.BusinessRepliesHint);
        }
        dateMsg.id = 0;
        hint2MessageObject = new MessageObject(currentAccount, dateMsg, false, false);
        hint2MessageObject.type = 10;
        hint2MessageObject.contentType = 1;
    }

    private void updateFilteredMessages(boolean notify) {
        ArrayList<MessageObject> results = new ArrayList<>(MediaDataController.getInstance(currentAccount).getFoundMessageObjects());
        if (filteredMessagesDict == null) {
            filteredMessagesDict = new LongSparseArray<>();
        }
        if (filteredMessagesByDays == null) {
            filteredMessagesByDays = new LongSparseArray<>();
        } else {
            filteredMessagesByDays.clear();
        }
        LongSparseArray<MessageObject.GroupedMessages> newGroups = null;
        LongSparseArray<MessageObject.GroupedMessages> changedGroups = null;
        chatAdapter.filteredMessages.clear();
        filteredMessagesDict.clear();
        for (int i = 0; i < results.size(); ++i) {
            MessageObject msg = results.get(i);
            MessageObject from = null;
            if (from == null) {
                for (int j = 0; j < messages.size(); ++j) {
                    MessageObject m = messages.get(j);
                    if (m.getDialogId() == msg.getDialogId() && m.getId() == msg.getId()) {
                        from = m;
                        break;
                    }
                }
            }
            if (msg.stableId == 0) {
                if (from == null) {
                    msg.checkMediaExistance();
                } else {
                    msg.mediaExists = from.mediaExists;
                    msg.attachPathExists = from.attachPathExists;
                }
            }
            if (from != null) {
                msg.isSaved = from.isSaved;
                if (chatAdapter.isFiltered && msg.stableId != 0) {
                    from.copyStableParams(msg);
                } else {
                    msg.copyStableParams(from);
                }
            } else if (msg.stableId == 0) {
                msg.stableId = lastStableId++;
            }
            msg.isOutOwnerCached = null;
            if (msg.messageOwner != null) {
                msg.messageOwner.out = true;
            }
            msg.isOutOwner();

            if (msg.hasValidGroupId()) {
                MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(msg.getGroupIdForUse());
                if (groupedMessages == null) {
                    groupedMessages = new MessageObject.GroupedMessages();
                    groupedMessages.reversed = reversed;
                    groupedMessages.groupId = msg.getGroupId();
                    groupedMessagesMap.put(groupedMessages.groupId, groupedMessages);
                } else if (newGroups == null || newGroups.indexOfKey(msg.getGroupId()) < 0) {
                    if (changedGroups == null) {
                        changedGroups = new LongSparseArray<>();
                    }
                    changedGroups.put(msg.getGroupId(), groupedMessages);
                }
                if (newGroups == null) {
                    newGroups = new LongSparseArray<>();
                }
                newGroups.put(groupedMessages.groupId, groupedMessages);
                if (groupedMessages.getPosition(msg) == null) {
                    boolean found = false;
                    for (int j = 0; j < groupedMessages.messages.size(); ++j) {
                        if (groupedMessages.messages.get(j).getId() == msg.getId()) {
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        groupedMessages.messages.add(msg);
                    }
                }
            } else if (msg.getGroupIdForUse() != 0) {
                msg.messageOwner.grouped_id = 0;
                msg.localSentGroupId = 0;
            }

            chatAdapter.filteredMessages.add(msg);
            filteredMessagesDict.put(msg.getId(), msg);
        }
        if (newGroups != null) {
            for (int i = 0; i < newGroups.size(); ++i) {
                MessageObject.GroupedMessages group = newGroups.valueAt(i);
                Collections.sort(group.messages, (a, b) -> a.getId() - b.getId());
                group.calculate();
            }
        }
        ArrayList<MessageObject> messagesResults = new ArrayList<>();
        if (searchingReaction != null && TextUtils.isEmpty(searchingQuery)) {
            for (int i = 0; i < messages.size(); ++i) {
                MessageObject msg = messages.get(i);
                if (msg != null && msg.messageOwner != null && msg.messageOwner.reactions != null && msg.messageOwner.reactions.reactions_as_tags) {
                    for (int j = 0; j < msg.messageOwner.reactions.results.size(); ++j) {
                        if (searchingReaction.isSame(msg.messageOwner.reactions.results.get(j).reaction)) {
                            messagesResults.add(msg);
                            break;
                        }
                    }
                }
            }
        }
        for (int i = 0; i < messagesResults.size(); ++i) {
            MessageObject msg = messagesResults.get(i);
            if (filteredMessagesDict.containsKey(msg.getId())) {
                continue;
            }
            msg.isOutOwnerCached = null;
            if (msg.messageOwner != null) {
                msg.messageOwner.out = true;
            }
            chatAdapter.filteredMessages.add(msg);
            filteredMessagesDict.put(msg.getId(), msg);
        }
        for (int i = 0; i < chatAdapter.filteredMessages.size(); ++i) {
            MessageObject obj = chatAdapter.filteredMessages.get(i);
            if (!obj.hasValidGroupId()) {
                continue;
            }
            MessageObject.GroupedMessages group = groupedMessagesMap.get(obj.getGroupId());
            if (group != null) {
                for (int j = group.messages.size() - 1; j >= 0; --j) {
                    MessageObject groupmsg = group.messages.get(j);
                    if (groupmsg == obj || filteredMessagesDict.containsKey(groupmsg.getId()))
                        continue;
                    chatAdapter.filteredMessages.add(i, groupmsg);
                    filteredMessagesDict.put(groupmsg.getId(), groupmsg);
                    i++;
                }
            } else {

            }
        }
        Collections.sort(chatAdapter.filteredMessages, (a, b) -> b.getId() - a.getId());
        MessageObject lastFilteredMessage = null;
        for (int i = 0; i < chatAdapter.filteredMessages.size(); ++i) {
            MessageObject msg = chatAdapter.filteredMessages.get(i);
            if (reversed && msg != null && i == 0) {
                putFilteredDate(i++, msg);
            }
            if (!reversed && lastFilteredMessage != null && msg.dateKeyInt != lastFilteredMessage.dateKeyInt) {
                putFilteredDate(i++, lastFilteredMessage);
            }
            ArrayList<MessageObject> dayArray = filteredMessagesByDays.get(msg.dateKeyInt);
            if (dayArray == null) {
                filteredMessagesByDays.put(msg.dateKeyInt, dayArray = new ArrayList<>());
            }
            dayArray.add(msg);
            if (reversed && lastFilteredMessage != null && msg.dateKeyInt != lastFilteredMessage.dateKeyInt) {
                putFilteredDate(i++, msg);
            }
            lastFilteredMessage = msg;
            if (!reversed && lastFilteredMessage != null && i >= chatAdapter.filteredMessages.size() - 1) {
                putFilteredDate(chatAdapter.filteredMessages.size(), lastFilteredMessage);
                i++;
            }
        }
        chatAdapter.filteredEndReached = MediaDataController.getInstance(currentAccount).searchEndReached();
        if (notify) {
            chatAdapter.updateRowsSafe();
            chatAdapter.notifyDataSetChanged(true);
            showProgressView(!chatAdapter.isFiltered ? loading && messages.isEmpty() && chatAdapter.botInfoRow < 0 : getMediaDataController().isSearchLoading() && chatAdapter.filteredMessages.isEmpty());
            if (chatListView != null) {
                createEmptyView(false);
                if (!(!chatAdapter.isFiltered ? !loading && messages.isEmpty() && chatAdapter.botInfoRow < 0 : !getMediaDataController().isSearchLoading() && chatAdapter.filteredMessages.isEmpty())) {
                    emptyViewContainer.setVisibility(View.GONE);
                    chatListView.setEmptyView(null);
                } else {
                    chatListView.setEmptyView(emptyViewContainer);
                    chatListView.checkIfEmpty();
                }
            }
        }
    }

    private void createBottomMessagesActionButtons() {

    }

    private void checkInstantSearch() {
        final long searchFromUserId = getArguments().getInt("search_from_user_id", 0);
        if (searchFromUserId != 0) {
            TLRPC.User user = getMessagesController().getUser(searchFromUserId);
            if (user != null) {
                openSearchWithText("");
                if (searchUserButton != null) {
                    searchUserButton.callOnClick();
                }
                searchUserMessages(user, null);
            }
        } else {
            final long searchFromChatId = getArguments().getInt("search_from_chat_id", 0);
            if (searchFromChatId != 0) {
                TLRPC.Chat chat = getMessagesController().getChat(searchFromChatId);
                if (chat != null) {
                    openSearchWithText("");
                    if (searchUserButton != null) {
                        searchUserButton.callOnClick();
                    }
                    searchUserMessages(null, chat);
                }
            }
        }
    }

    private void createTopPanel() {
        if (contentView == null || topChatPanelView != null || getContext() == null) {
            return;
        }

        topChatPanelView = new BlurredFrameLayout(getContext(), contentView) {

            private boolean ignoreLayout;

            @Override
            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                int width = MeasureSpec.getSize(widthMeasureSpec);
                int leftMargin = 0;
                if (isSideMenued()) {
                    width -= dp(SIDE_MENU_WIDTH);
                    leftMargin += dp(32);
                }
                if (addToContactsButton != null && addToContactsButton.getVisibility() == VISIBLE && reportSpamButton != null && reportSpamButton.getVisibility() == VISIBLE) {
                    width = (width - dp(31)) / 2;
                }
                ignoreLayout = true;
                if (reportSpamButton != null && reportSpamButton.getVisibility() == VISIBLE) {
                    FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) reportSpamButton.getLayoutParams();
                    layoutParams.width = width;
                    if (addToContactsButton != null && addToContactsButton.getVisibility() == VISIBLE) {
                        reportSpamButton.setPadding(dp(4), 0, dp(4), 0);
                        layoutParams.leftMargin = leftMargin + width;
                        layoutParams.width -= dp(15);
                    } else {
                        reportSpamButton.setPadding(dp(48), 0, dp(48), 0);
                        layoutParams.leftMargin = leftMargin;
                    }
                }
                if (addToContactsButton != null && addToContactsButton.getVisibility() == VISIBLE) {
                    FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) addToContactsButton.getLayoutParams();
                    layoutParams.width = width;
                    if (reportSpamButton != null && reportSpamButton.getVisibility() == VISIBLE) {
                        addToContactsButton.setPadding(dp(11), 0, dp(4), 0);
                    } else {
                        addToContactsButton.setPadding(dp(48), 0, dp(48), 0);
                    }
                    layoutParams.leftMargin = leftMargin;
                }
                ignoreLayout = false;
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }


            @Override
            public void requestLayout() {
                if (ignoreLayout) {
                    return;
                }
                super.requestLayout();
            }
        };
        topChatPanelView.backgroundColor = getThemedColor(Theme.key_chat_topPanelBackground);
        topChatPanelView.backgroundPaddingBottom = dp(2);
        topChatPanelView.setTag(1);
        topChatPanelViewOffset = -AndroidUtilities.dp(50);
        invalidateChatListViewTopPadding();
        topChatPanelView.setClickable(true);
        topChatPanelView.setVisibility(View.GONE);
        topChatPanelView.setBackgroundResource(R.drawable.blockpanel);
        topChatPanelView.getBackground().setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_topPanelBackground), PorterDuff.Mode.MULTIPLY));
        int index = Math.min(8, contentView.getChildCount());
        if (pinnedMessageView != null && pinnedMessageView.getParent() == contentView) {
            index = contentView.indexOfChild(pinnedMessageView) + 1;
        }
        contentView.addView(topChatPanelView, index, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 50, Gravity.TOP | Gravity.LEFT));

        reportSpamButton = new TextView(getContext());
        reportSpamButton.setTextColor(getThemedColor(Theme.key_text_RedBold));
        reportSpamButton.setBackground(Theme.createSelectorDrawable(getThemedColor(Theme.key_text_RedBold) & 0x19ffffff, 3));
        reportSpamButton.setTag(Theme.key_text_RedBold);
        reportSpamButton.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
        reportSpamButton.setTypeface(AndroidUtilities.bold());
        reportSpamButton.setSingleLine(true);
        reportSpamButton.setMaxLines(1);
        reportSpamButton.setGravity(Gravity.CENTER);
        topChatPanelView.addView(reportSpamButton, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 48, Gravity.LEFT | Gravity.TOP, 0, 0, 0, 1));
        reportSpamButton.setOnClickListener(v2 -> AlertsCreator.showBlockReportSpamAlert(ChatActivity.this, dialog_id, currentUser, currentChat, currentEncryptedChat, reportSpamButton.getTag(R.id.object_tag) != null, chatInfo, param -> {
            if (param == 0) {
                updateTopPanel(true);
            } else {
                finishFragment();
            }
        }, themeDelegate));

        emojiStatusSpamHint = new LinkSpanDrawable.LinksTextView(getContext(), themeDelegate);
        emojiStatusSpamHint.setTextColor(getThemedColor(Theme.key_chat_topPanelMessage));
        emojiStatusSpamHint.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 13.3f);
        emojiStatusSpamHint.setGravity(Gravity.CENTER);
        emojiStatusSpamHint.setVisibility(View.GONE);
        emojiStatusSpamHint.setLinkTextColor(getThemedColor(Theme.key_windowBackgroundWhiteLinkText));
        topChatPanelView.addView(emojiStatusSpamHint, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 25, 0, 25, 1));

        topViewSeparator1 = new View(getContext());
        topViewSeparator1.setVisibility(View.GONE);
        topViewSeparator1.setBackgroundColor(getThemedColor(Theme.key_divider));
        topViewSeparator1.setAlpha(.5f);
        topChatPanelView.addView(topViewSeparator1, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 1f / AndroidUtilities.density, Gravity.LEFT | Gravity.BOTTOM, 0, 0, 0, 2));
        topViewSeparator2 = new View(getContext());
        topViewSeparator2.setVisibility(View.GONE);
        topViewSeparator2.setBackgroundColor(getThemedColor(Theme.key_divider));
        topChatPanelView.addView(topViewSeparator2, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 1f / AndroidUtilities.density, Gravity.LEFT | Gravity.TOP, 10, 48, 10, 1));
        topViewSeparator3 = new View(getContext());
        topViewSeparator3.setVisibility(View.GONE);
        topViewSeparator3.setBackgroundColor(getThemedColor(Theme.key_divider));
        topChatPanelView.addView(topViewSeparator3, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 1f / AndroidUtilities.density, Gravity.LEFT | Gravity.BOTTOM, 0, 0, 0, 38));

        addToContactsButton = new TextView(getContext());
        addToContactsButton.setTextColor(getThemedColor(Theme.key_chat_addContact));
        addToContactsButton.setVisibility(View.GONE);
        addToContactsButton.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
        addToContactsButton.setTypeface(AndroidUtilities.bold());
        addToContactsButton.setSingleLine(true);
        addToContactsButton.setMaxLines(1);
        addToContactsButton.setPadding(AndroidUtilities.dp(4), 0, AndroidUtilities.dp(4), 0);
        addToContactsButton.setGravity(Gravity.CENTER);
        addToContactsButton.setBackground(Theme.createSelectorDrawable(getThemedColor(Theme.key_chat_addContact) & 0x19ffffff, 3));
        topChatPanelView.addView(addToContactsButton, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 48, Gravity.LEFT | Gravity.TOP, 0, 0, 0, 1));
        addToContactsButton.setOnClickListener(v -> {
            if (addToContactsButtonArchive) {
                getMessagesController().addDialogToFolder(dialog_id, 0, 0, 0);
                createUndoView();
                undoView.showWithAction(dialog_id, UndoView.ACTION_CHAT_UNARCHIVED, null);
                SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                SharedPreferences.Editor editor = preferences.edit();
                editor.putBoolean("dialog_bar_archived" + dialog_id, false);
                editor.putBoolean("dialog_bar_block" + dialog_id, false);
                editor.putBoolean("dialog_bar_report" + dialog_id, false);
                editor.commit();
                updateTopPanel(false);
                getNotificationsController().clearDialogNotificationsSettings(dialog_id, getTopicId());
            } else if (addToContactsButton.getTag() != null && (Integer) addToContactsButton.getTag() == 4) {
                if (chatInfo != null && chatInfo.participants != null) {
                    LongSparseArray<TLObject> users = new LongSparseArray<>();
                    for (int a = 0; a < chatInfo.participants.participants.size(); a++) {
                        users.put(chatInfo.participants.participants.get(a).user_id, null);
                    }
                    long chatId = chatInfo.id;
                    InviteMembersBottomSheet bottomSheet = new InviteMembersBottomSheet(getContext(), currentAccount, users, chatInfo.id, ChatActivity.this, themeDelegate);
                    bottomSheet.setDelegate((users1, fwdCount) -> {
                        getMessagesController().addUsersToChat(currentChat, ChatActivity.this, users1, fwdCount, null, null, null);
                        getMessagesController().hidePeerSettingsBar(dialog_id, currentUser, currentChat);
                        updateTopPanel(true);
                        updateInfoTopView(true);
                    });
                    bottomSheet.show();
                }
            } else if (addToContactsButton.getTag() != null) {
                shareMyContact(1, null);
            } else {
                Bundle args = new Bundle();
                args.putLong("user_id", currentUser.id);
                args.putBoolean("addContact", true);
                ContactAddActivity activity = new ContactAddActivity(args);
                activity.setDelegate(() -> {
                    if (undoView != null || getContext() == null) {
                        return;
                    }
                    createUndoView();
                    undoView.showWithAction(dialog_id, UndoView.ACTION_CONTACT_ADDED, currentUser);
                });
                presentFragment(activity);
            }
        });

        restartTopicButton = new TextView(getContext());
        restartTopicButton.setTextColor(getThemedColor(Theme.key_chat_addContact));
        restartTopicButton.setVisibility(View.GONE);
        restartTopicButton.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
        restartTopicButton.setTypeface(AndroidUtilities.bold());
        restartTopicButton.setSingleLine(true);
        restartTopicButton.setMaxLines(1);
        restartTopicButton.setPadding(AndroidUtilities.dp(4), 0, AndroidUtilities.dp(4), 0);
        restartTopicButton.setGravity(Gravity.CENTER);
        restartTopicButton.setText(LocaleController.getString(R.string.RestartTopic).toUpperCase());
        restartTopicButton.setBackground(Theme.createSelectorDrawable(getThemedColor(Theme.key_chat_addContact) & 0x19ffffff, 3));
        topChatPanelView.addView(restartTopicButton, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 48, Gravity.LEFT | Gravity.TOP, 0, 0, 0, 1));
        restartTopicButton.setOnClickListener(v -> {
            if (forumTopic != null) {
                getMessagesController().getTopicsController().toggleCloseTopic(currentChat.id, forumTopic.id, forumTopic.closed = false);
            }
            updateTopicButtons();
            updateBottomOverlay();
            updateTopPanel(true);
        });

        closeReportSpam = new ImageView(getContext());
        closeReportSpam.setImageResource(R.drawable.miniplayer_close);
        closeReportSpam.setContentDescription(LocaleController.getString(R.string.Close));
        closeReportSpam.setBackground(Theme.AdaptiveRipple.circle(getThemedColor(Theme.key_chat_topPanelClose)));
        closeReportSpam.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_topPanelClose), PorterDuff.Mode.MULTIPLY));
        closeReportSpam.setScaleType(ImageView.ScaleType.CENTER);
        topChatPanelView.addView(closeReportSpam, LayoutHelper.createFrame(36, 36, Gravity.RIGHT | Gravity.TOP, 0, 6, 2, 0));
        closeReportSpam.setOnClickListener(v -> {
            long did = dialog_id;
            if (currentEncryptedChat != null) {
                did = currentUser.id;
            }
            shownBotVerification = false;
            getMessagesController().hidePeerSettingsBar(did, currentUser, currentChat);
            updateTopPanel(true);
            updateInfoTopView(true);
        });
    }

    private void createTopPanel2() {
        if (contentView == null || topChatPanelView2 != null || getContext() == null) {
            return;
        }

        topChatPanelView2 = new BlurredFrameLayout(getContext(), contentView);
        topChatPanelView2.backgroundColor = getThemedColor(Theme.key_chat_topPanelBackground);
        topChatPanelView2.backgroundPaddingBottom = AndroidUtilities.dp(2);
        topChatPanelView2.setPadding(0, 0, 0, dp(2));
        topChatPanelView2.setTag(1);
        topChatPanelView2Offset = -AndroidUtilities.dp(50);
        invalidateChatListViewTopPadding();
        topChatPanelView2.setClickable(true);
        topChatPanelView2.setVisibility(View.GONE);
        topChatPanelView2.setBackgroundResource(R.drawable.blockpanel);
        topChatPanelView2.getBackground().setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_topPanelBackground), PorterDuff.Mode.MULTIPLY));
        int index = 8;
        if (pinnedMessageView != null && pinnedMessageView.getParent() == contentView) {
            index = contentView.indexOfChild(pinnedMessageView) + 1;
        }
        contentView.addView(topChatPanelView2, index, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 50, Gravity.TOP | Gravity.LEFT));
    }

    private void createTranslateButton() {
        if (translateButton != null || getContext() == null) {
            return;
        }

        createTopPanel();
        if (topChatPanelView == null) {
            return;
        }
        translateButton = new TranslateButton(getContext(), this, themeDelegate) {
            @Override
            protected void onButtonClick() {
                if (getUserConfig().isPremium() || currentChat != null && currentChat.autotranslation) {
                    getMessagesController().getTranslateController().toggleTranslatingDialog(getDialogId());
                } else {
                    MessagesController.getNotificationsSettings(currentAccount).edit().putInt("dialog_show_translate_count" + getDialogId(), 14).commit();
                    showDialog(new PremiumFeatureBottomSheet(ChatActivity.this, PremiumPreviewFragment.PREMIUM_FEATURE_TRANSLATIONS, false));
                }
                updateTopPanel(true);
            }

            @Override
            protected void onCloseClick() {
                MessagesController.getNotificationsSettings(currentAccount).edit().putInt("dialog_show_translate_count" + getDialogId(), 140).commit();
                updateTopPanel(true);
            }
        };
        topChatPanelView.addView(translateButton, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 36, Gravity.LEFT | Gravity.BOTTOM, 0, 0, 0, 2));
    }

    private boolean isAllChats() {
        return topicsTabs != null && threadMessageId == 0;
    }
    private boolean isSideMenued() {
        return topicsTabs != null || !isSubscriberSuggestions && ChatObject.isMonoForum(currentChat) || ChatObject.isForum(currentChat) && ChatObject.areTabsEnabled(currentChat);
    }
    private boolean isSideMenuEnabled() {
        return topicsTabs != null && topicsTabs.sidemenuEnabled;
    }
    private float getSideMenuAlpha() {
        return topicsTabs != null ? topicsTabs.sidemenuT : 0f;
    }
    private int getSideMenuWidth() {
        return (int) (dp(SIDE_MENU_WIDTH) * getSideMenuAlpha());
    }

    public static final int SIDE_MENU_WIDTH = 64 + 7;

    private boolean isSideMenuAnimating() {
        return topicsTabs != null && topicsTabs.sidemenuAnimating;
    }

    private void createTopicsTabs() {
        if (topicsTabs != null || getContext() == null) {
            return;
        }
        if (pinnedMessageView == null) {
            createPinnedMessageView();
        }
        topicsTabs = new TopicsTabsView(getContext(), this, contentView, currentAccount, getDialogId(), getResourceProvider()) {
            @Override
            public void updateSidemenuPosition() {
                super.updateSidemenuPosition();
                invalidateChatListViewTopPadding();
                AndroidUtilities.forEachViews(chatListView, view -> {
                    if (view instanceof ChatMessageCell) {
                        final ChatMessageCell cell = (ChatMessageCell) view;
                        cell.isAllChats = isAllChats();
                        cell.isSideMenued = isSideMenued();
                        final boolean newSideMenuEnabled = isSideMenuEnabled();
                        if (cell.isSideMenuEnabled != newSideMenuEnabled) {
                            cell.isSideMenuEnabled = newSideMenuEnabled;
                            final int position = chatListView.getChildAdapterPosition(view);
                            cell.relayout();
                            if (position >= 0) {
                                chatAdapter.notifyItemChanged(position);
                            }
                        }
                        cell.sideMenuAlpha = getSideMenuAlpha();
                        final int newSideMenuWidth = getSideMenuWidth();
                        if (cell.sideMenuWidth != newSideMenuWidth) {
                            cell.sideMenuWidth = newSideMenuWidth;
                            cell.updateTranslation();
                            cell.invalidate();
                        }
                    } else if (view instanceof ChatActionCell) {
                        final ChatActionCell cell = (ChatActionCell) view;
                        cell.isAllChats = isAllChats();
                        cell.isSideMenued = isSideMenued();
                        cell.isSideMenuEnabled = isSideMenuEnabled();
                        cell.sideMenuAlpha = getSideMenuAlpha();
                        final int newSideMenuWidth = getSideMenuWidth();
                        if (cell.sideMenuWidth != newSideMenuWidth) {
                            cell.sideMenuWidth = newSideMenuWidth;
                            cell.invalidate();
                        }
                    } else if (view instanceof ChatUnreadCell) {
                        ((ChatUnreadCell) view).getTextView().setTranslationX(getSideMenuWidth() / 2f);
                    }
                });
                if (floatingDateView != null) {
                    floatingDateView.setTranslationX(getSideMenuWidth() / 2f);
                }
                if (floatingTopicSeparator != null) {
                    floatingTopicSeparator.setTranslationX(getSideMenuWidth() / 2f);
                }
                if (emptyViewContainer != null) {
                    emptyViewContainer.setTranslationX(getSideMenuWidth() / 2.f);
                }
                if (pendingRequestsDelegate != null) {
                    pendingRequestsDelegate.setLeftMargin(getSideMenuWidth());
                }
                if (bizBotButton != null) {
                    bizBotButton.setLeftMargin(getSideMenuWidth());
                }
                if (restartTopicButton != null) {
                    restartTopicButton.setTranslationX(getSideMenuWidth() / 2.0f);
                }
                if (emojiStatusSpamHint != null) {
                    emojiStatusSpamHint.setTranslationX(getSideMenuWidth() / 2.0f);
                }
            }
        };

        topicsTabs.setSideMenuBackgroundDrawable(glassBackgroundDrawableFactory.create(topicsTabs, blurredBackgroundColorProvider));

        int index = 8;
        if (topChatPanelView != null && topChatPanelView.getParent() == contentView) {
            index = Math.max(index, contentView.indexOfChild(topChatPanelView) + 1);
        }
        if (topChatPanelView2 != null && topChatPanelView2.getParent() == contentView) {
            index = Math.max(index, contentView.indexOfChild(topChatPanelView2) + 1);
        }
        View pendingRequestsView = pendingRequestsDelegate != null ? pendingRequestsDelegate.getView() : null;
        if (pendingRequestsView != null && pendingRequestsView.getParent() == contentView) {
            index = Math.max(index, contentView.indexOfChild(pendingRequestsView) + 1);
        }
        if (pinnedMessageView != null && pinnedMessageView.getParent() == contentView) {
            index = Math.max(index, contentView.indexOfChild(pinnedMessageView) + 1);
        }
        if (fragmentContextView != null && fragmentContextView.getParent() == contentView) {
            index = Math.max(index, contentView.indexOfChild(fragmentContextView) + 1);
        }
        if (fragmentLocationContextView != null && fragmentLocationContextView.getParent() == contentView) {
            index = Math.max(index, contentView.indexOfChild(fragmentLocationContextView) + 1);
        }
        topicsTabs.setCurrentTopic(getTopicId());
        topicsTabs.setOnNewTopicSelected(() -> {
            presentFragment(TopicCreateFragment.create(-dialog_id, 0).setOpenInChatActivity(this));
        });
        topicsTabs.setOnTopicSelected((topicId, fromMessage) -> {
            if (topicId == getTopicId()) return;
            TLRPC.TL_forumTopic topic = topicsTabs.getTopic(topicId);
            TLRPC.Message message = topic == null ? null : topic.topicStartMessage;
            if (message == null && topic != null) {
                TLRPC.TL_forumTopic topicLocal = getMessagesController().getTopicsController().findTopic(-getDialogId(), topic.id);
                if (topicLocal != null) {
                    topic = topicLocal;
                    message = topic.topicStartMessage;
                }
            }
            if (message == null && topicId != 0) {
                return;
            }

            topicChangedFromMessage = fromMessage;
            if (fromMessage || true) {
                if (topicId == 0) {
                    savePositionForTopicChange(getTopicId());
                } else if (getTopicId() == 0) {
                    savePositionForTopicChange(topicId);
                } else {
                    clearOnLoadAndScrollMessageId = -1;
                }
            } else {
                clearOnLoadAndScrollMessageId = -1;
            }
            getConnectionsManager().cancelRequestsForGuid(classGuid);
            getMessagesStorage().cancelTasksForGuid(classGuid);
            classGuid = ConnectionsManager.generateClassGuid();

            saveDraft();
            messagePreviewParams = null;
            startLoadFromMessageId = 0;//clearOnLoadAndScrollMessageId >= 0 ? clearOnLoadAndScrollMessageId : 0;
            firstMessagesLoaded = false;
            clearOnLoad = true;
            waitingForLoad.clear();

            justCreatedTopic = false;
            if (message != null && topicId != 0) {
                ArrayList<MessageObject> messageObjects = new ArrayList<>();
                messageObjects.add(new MessageObject(getCurrentAccount(), message, false, false));
                setThreadMessages(messageObjects, currentChat, topic.id, topic.read_inbox_max_id, topic.read_outbox_max_id, topic);
            } else {
                this.forumTopic = null;
                threadMessageObjects = null;
                replyingMessageObject = threadMessageObject = null;
                threadMaxInboxReadId = 0;
                threadMaxOutboxReadId = 0;
                replyMaxReadId = 0;
                threadMessageId = 0;
                replyOriginalMessageId = 0;
                replyOriginalChat = null;
                isTopic = false;
                isComments = false;
            }

            firstLoadMessages();

            updateTitle(true);
            avatarContainer.updateSubtitle(true);
            if (topic != null) {
                updateTopicTitleIcon();
            } else {
                avatarContainer.checkAndUpdateAvatar();
            }
            topicsTabs.setCurrentTopic(getTopicId());
            updateTopPanel(true);
            updateBottomOverlay(true);
            getMessagesController().setForumLastTopicId(-getDialogId(), getTopicId());
            reloadPinnedMessages();
            hideFloatingDateView(true);
            hideFieldPanel(true);
            applyDraftMaybe(true, true);
            if (chatActivityEnterView != null) {
                chatActivityEnterView.hidePopup(false);
                chatActivityEnterView.updateFieldHint(true);
                if (getParentActivity() != null) {
                    AndroidUtilities.hideKeyboard(getParentActivity().getCurrentFocus());
                }
            }
            if (topic != null) {
                getMessagesController().getTopicsController().getTopicRepliesCount(dialog_id, topic.id);
            }

            reactionsMentionCount = topic != null ? topic.unread_reactions_count : 0;
            updateReactionsMentionButton(false);
            updateTopicButtons();
            if (searchItemListener != null && actionBar.isSearchFieldVisible()) {
                searchItemListener.onSearchPressed(null);
            }
        });
        topicsTabs.setOnDialogSelected((dialogId, fromMessage) -> {
            if (dialogId == getTopicId()) return;

            topicChangedFromMessage = fromMessage;
            if (fromMessage || true) {
                if (dialogId == 0) {
                    savePositionForTopicChange(getTopicId());
                } else if (getTopicId() == 0) {
                    savePositionForTopicChange(dialogId);
                } else {
                    clearOnLoadAndScrollMessageId = -1;
                }
            } else {
                clearOnLoadAndScrollMessageId = -1;
            }
            getConnectionsManager().cancelRequestsForGuid(classGuid);
            getMessagesStorage().cancelTasksForGuid(classGuid);
            classGuid = ConnectionsManager.generateClassGuid();

            saveDraft();
            messagePreviewParams = null;
            startLoadFromMessageId = 0;//clearOnLoadAndScrollMessageId >= 0 ? clearOnLoadAndScrollMessageId : 0;
            firstMessagesLoaded = false;
            clearOnLoad = true;
            waitingForLoad.clear();

            setSavedDialog(dialogId);
            TLRPC.TL_forumTopic topic = getMessagesController().getTopicsController().findTopic(-getDialogId(), dialogId);
            if (dialogId != 0 && topic != null) {
                threadMaxInboxReadId = topic.read_inbox_max_id;
                threadMaxOutboxReadId = topic.read_outbox_max_id;
                replyMaxReadId = Math.max(1, topic.read_inbox_max_id);

                getMessagesController().getTopicsController().getTopicRepliesCount(dialog_id, DialogObject.getPeerDialogId(topic.from_id));

                /*
                this.forumTopic = forumTopic;
                threadMessageObjects = messageObjects;
                replyingMessageObject = threadMessageObject = threadMessageObjects.get(threadMessageObjects.size() - 1);
                threadMaxInboxReadId = maxInboxReadId;
                threadMaxOutboxReadId = maxOutboxReadId;
                replyMaxReadId = Math.max(1, maxInboxReadId);
                threadMessageId = threadMessageObject.getId();
                replyOriginalMessageId = originalMessage;
                replyOriginalChat = originalChat;
                isTopic = forumTopic != null;
                isComments = replyingMessageObject.messageOwner.fwd_from != null && replyingMessageObject.messageOwner.fwd_from.channel_post != 0 && !isTopic;
                if (isTopic) {
                    replyingMessageObject.isTopicMainMessage = true;
                }
                updatePinnedTopicStarterMessage();
                updateTopPanel(false);
                updateBottomOverlay();
                */
            } else {
                this.forumTopic = null;
                threadMessageObjects = null;
                replyingMessageObject = threadMessageObject = null;
                threadMaxInboxReadId = 0;
                threadMaxOutboxReadId = 0;
                replyMaxReadId = 0;
                threadMessageId = 0;
                replyOriginalMessageId = 0;
                replyOriginalChat = null;
                isTopic = false;
                isComments = false;
            }

            firstLoadMessages();

            updateTitle(true);
            avatarContainer.updateSubtitle(true);
            avatarContainer.checkAndUpdateAvatar();
            topicsTabs.setCurrentTopic(dialogId);
            updateTopPanel(true);
            updateBottomOverlay(true);
            getMessagesController().setForumLastTopicId(-getDialogId(), getTopicId());
            hideFloatingTopicView(true);
            hideFieldPanel(true);
            if (chatActivityEnterView != null) {
                chatActivityEnterView.hidePopup(false);
                chatActivityEnterView.updateFieldHint(true);
                if (getParentActivity() != null) {
                    AndroidUtilities.hideKeyboard(getParentActivity().getCurrentFocus());
                }
            }
            applyDraftMaybe(true, true);

            reactionsMentionCount = topic != null ? topic.unread_reactions_count : 0;
            updateReactionsMentionButton(false);
            updateTopicButtons();
            if (searchItemListener != null && actionBar.isSearchFieldVisible()) {
                searchItemListener.onSearchPressed(null);
            }
            //
        });
        contentView.addView(topicsTabs, index, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.TOP | Gravity.LEFT));
        topicsTabs.updateSidemenuPosition();
        if (mentionContainer != null) {
            mentionContainer.bringToFront();
        }
    }

    private void toggleIsAllChats() {
        final boolean isAllChats = isAllChats();
        AndroidUtilities.forEachViews(chatListView, view -> {
            if (view instanceof ChatMessageCell) {
                final ChatMessageCell cell = (ChatMessageCell) view;
                if ((cell.isAllChats && cell.isSideMenuEnabled) != isAllChats && isSideMenuEnabled()) {
                    cell.isAllChats = isAllChats;
                    cell.isSideMenuEnabled = isSideMenuEnabled();
                    cell.relayout();
                }
            } else if (view instanceof ChatActionCell) {
                final ChatActionCell cell = (ChatActionCell) view;
                cell.isAllChats = isAllChats;
            }
        });
    }

    private void createBotAdView() {
        if (botAdView != null || getContext() == null) {
            return;
        }

        createTopPanel2();
        if (topChatPanelView2 == null) {
            return;
        }
        botAdView = new BotAdView(getContext(), themeDelegate);
        topChatPanelView2.addView(botAdView);
    }

    private void createBizBotButton() {
        if (bizBotButton != null || getContext() == null) {
            return;
        }

        createTopPanel();
        if (topChatPanelView == null) {
            return;
        }
        bizBotButton = new BusinessBotButton(getContext(), this, themeDelegate);
        topChatPanelView.addView(bizBotButton, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 48, Gravity.LEFT | Gravity.BOTTOM, 0, 0, 0, 2));
        bizBotButton.setLeftMargin(getSideMenuWidth());
    }

    private void createUndoView() {
        if (undoView != null || getContext() == null) {
            return;
        }
        undoView = new UndoView(getContext(), this, false, themeDelegate);
        undoView.setAdditionalTranslationY(AndroidUtilities.dp(51));
        contentView.addView(undoView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.WRAP_CONTENT, Gravity.BOTTOM | Gravity.LEFT, 8, 0, 8, 8));
    }

    @Override
    public INavigationLayout.BackButtonState getBackButtonState() {
        return INavigationLayout.BackButtonState.BACK;
    }

    private void createActionMode() {
        if (selectedMessagesCountTextView != null || getContext() == null) {
            return;
        }
        final ActionBarMenu actionMode = actionBar.createActionMode();

        selectedMessagesCountTextView = new NumberTextView(actionMode.getContext());
        selectedMessagesCountTextView.setTextSize(18);
        selectedMessagesCountTextView.setTypeface(AndroidUtilities.bold());
        selectedMessagesCountTextView.setTextColor(getThemedColor(Theme.key_actionBarActionModeDefaultIcon));
        selectedMessagesCountTextView.setOnTouchListener((v, event) -> true);
        actionMode.addView(selectedMessagesCountTextView, LayoutHelper.createLinear(0, LayoutHelper.MATCH_PARENT, 1.0f, 65, 0, 0, 0));

        boolean replaceForward = MessagesController.getGlobalMainSettings().getBoolean("replaceForward", true);

        if (currentEncryptedChat == null) {
            final boolean isSavedMessages = getDialogId() == getUserConfig().getClientUserId() && (chatMode == 0 || chatMode == MODE_SAVED);
            actionModeViews.add(actionMode.addItemWithWidth(save_to, R.drawable.msg_download, AndroidUtilities.dp(54), LocaleController.getString(R.string.SaveToMusic)));
            actionModeViews.add(actionMode.addItemWithWidth(edit, R.drawable.msg_edit, AndroidUtilities.dp(54), LocaleController.getString(R.string.Edit)));
            if (isSavedMessages) {
                actionModeViews.add(actionMode.addItemWithWidth(tag_message, R.drawable.menu_tag_edit, AndroidUtilities.dp(54), LocaleController.getString(R.string.AccDescrTagMessage)));
            }
            actionModeViews.add(actionMode.addItemWithWidth(select_between, R.drawable.profile_list, AndroidUtilities.dp(54), LocaleController.getString("Edit", R.string.Edit)));
            actionModeViews.add(actionMode.addItemWithWidth(star, R.drawable.msg_fave, AndroidUtilities.dp(54), LocaleController.getString(R.string.AddToFavorites)));
            actionModeViews.add(actionMode.addItemWithWidth(copy, R.drawable.msg_copy, AndroidUtilities.dp(54), LocaleController.getString(R.string.Copy)));
            //if (!isSavedMessages && getDialogId() != UserObject.VERIFY) {
            if (!replaceForward) {
                actionModeViews.add(actionMode.addItemWithWidth(forward, R.drawable.msg_forward, AndroidUtilities.dp(54), LocaleController.getString(R.string.Forward)));
            } else {
                actionModeViews.add(actionMode.addItemWithWidth(forward_anonym, R.drawable.ic_ab_forward_anonym, AndroidUtilities.dp(54), LocaleController.getString("Forward", R.string.Forward)));
            }
            actionModeViews.add(actionMode.addItemWithWidth(share, R.drawable.msg_shareout, AndroidUtilities.dp(54), LocaleController.getString(R.string.ShareFile)));
            actionModeViews.add(actionMode.addItemWithWidth(delete, R.drawable.msg_delete, AndroidUtilities.dp(54), LocaleController.getString(R.string.Delete)));
        } else {
            actionModeViews.add(actionMode.addItemWithWidth(edit, R.drawable.msg_edit, AndroidUtilities.dp(54), LocaleController.getString(R.string.Edit)));
            actionModeViews.add(actionMode.addItemWithWidth(star, R.drawable.msg_fave, AndroidUtilities.dp(54), LocaleController.getString(R.string.AddToFavorites)));
            actionModeViews.add(actionMode.addItemWithWidth(copy, R.drawable.msg_copy, AndroidUtilities.dp(54), LocaleController.getString(R.string.Copy)));
            actionModeViews.add(actionMode.addItemWithWidth(delete, R.drawable.msg_delete, AndroidUtilities.dp(54), LocaleController.getString(R.string.Delete)));
        }
        updateMultipleSelection(actionMode);
        actionMode.setItemVisibility(edit, canEditMessagesCount == 1 && selectedMessagesIds[0].size() + selectedMessagesIds[1].size() == 1 ? View.VISIBLE : View.GONE);
        actionMode.setItemVisibility(copy, !getMessagesController().isChatNoForwards(currentChat) && selectedMessagesCanCopyIds[0].size() + selectedMessagesCanCopyIds[1].size() != 0 ? View.VISIBLE : View.GONE);
        actionMode.setItemVisibility(star, selectedMessagesCanStarIds[0].size() + selectedMessagesCanStarIds[1].size() != 0 ? View.VISIBLE : View.GONE);
        actionMode.setItemVisibility(delete, cantDeleteMessagesCount == 0 ? View.VISIBLE : View.GONE);
        actionMode.setItemVisibility(tag_message, getUserConfig().isPremium() ? View.VISIBLE : View.GONE);
        actionMode.setItemVisibility(share, View.GONE);
    }

    private void hideTagSelector() {
        if (tagSelector == null) return;
        final ReactionsContainerLayout thisTagSelector = tagSelector;
        tagSelector = null;
        thisTagSelector.dismissWindow();
        if (thisTagSelector.getReactionsWindow() != null && thisTagSelector.getReactionsWindow().containerView != null) {
            thisTagSelector.getReactionsWindow().containerView.animate().alpha(0).setDuration(180).start();
        }
        thisTagSelector.animate().alpha(0.01f).translationY(-dp(12)).scaleX(.7f).scaleY(.7f).withEndAction(() -> {
            contentView.removeView(thisTagSelector);
        }).setDuration(180).start();
    }

    private ReactionsContainerLayout tagSelector;
    private void showTagSelector() {
        if (getDialogId() != getUserConfig().getClientUserId() || !getUserConfig().isPremium()) return;
        if (tagSelector != null) return;
        tagSelector = new ReactionsContainerLayout(ReactionsContainerLayout.TYPE_TAGS, this, getContext(), currentAccount, themeDelegate) {

            private int[] loc = new int[2];

            private ValueAnimator va;
            private boolean firstLayout = true;
            private void updateBubbleOffset(float x, boolean animated) {
                if (va != null) {
                    va.cancel();
                    va = null;
                }
                if (!animated) {
                    setBubbleOffset(x);
                } else {
                    va = ValueAnimator.ofFloat(bubblesOffset, x);
                    va.addUpdateListener(anm -> {
                        setBubbleOffset((float) anm.getAnimatedValue());
                        invalidate();
                    });
                    va.setInterpolator(CubicBezierInterpolator.EASE_OUT_QUINT);
                    va.setDuration(420);
                    va.start();
                }
            }

            @Override
            protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
                super.onLayout(changed, left, top, right, bottom);
                final ActionBarMenu actionMode = actionBar.createActionMode();
                View item = actionMode.getItem(tag_message);
                if (item != null) {
                    getLocationInWindow(loc);
                    float x = getX();
                    float x2 = x + getWidth();
                    item.getLocationInWindow(loc);
                    float cx = loc[0] + item.getWidth() / 2f + dp(20) * (LocaleController.isRTL ? -1 : 1);

                    if (LocaleController.isRTL) {
                        updateBubbleOffset(cx - x, !firstLayout);
                    } else {
                        updateBubbleOffset(cx - x2, !firstLayout);
                    }
                    firstLayout = false;
                }
            }
        };
        tagSelector.setPadding(AndroidUtilities.dp(4), AndroidUtilities.dp(24), AndroidUtilities.dp(4), AndroidUtilities.dp(0));
        tagSelector.setDelegate(new ReactionsContainerLayout.ReactionsContainerDelegate() {
            @Override
            public void onReactionClicked(View view, ReactionsLayoutInBubble.VisibleReaction visibleReaction, boolean longpress, boolean addToRecent) {
                if (tagSelector == null) return;
                if (getDialogId() == getUserConfig().getClientUserId() && !getUserConfig().isPremium()) {
                    new PremiumFeatureBottomSheet(ChatActivity.this, PremiumPreviewFragment.PREMIUM_FEATURE_SAVED_TAGS, true).show();
                    clearSelectionMode(false);
                    return;
                }
                boolean updateFilteredMessages = false;
                boolean notifyFilteredMessages = false;
                boolean remove = tagSelector.getSelectedReactions().contains(visibleReaction);
                HashSet<Long> groupsChecked = new HashSet<>();
                int messagesCount = 0;
                for (int a = 0; a < selectedMessagesIds.length; ++a) {
                    for (int k = 0; k < selectedMessagesIds[a].size(); ++k) {
                        MessageObject messageObject = selectedMessagesIds[a].valueAt(k);
                        if (messageObject.hasValidGroupId()) {
                            MessageObject.GroupedMessages group = getValidGroupedMessage(messageObject);
                            if (group == null || groupsChecked.contains(group.groupId))
                                continue;
                            groupsChecked.add(group.groupId);
                            messageObject = group.findPrimaryMessageObject();
                            if (messageObject == null) continue;
                        }
                        if (messageObject.hasReaction(visibleReaction) == remove) {
                            selectReaction(findMessageCell(messageObject.getId(), false), messageObject, null, null, 0, 0, visibleReaction, false, false, false, true);
                            if (!remove) {
                                messagesCount++;
                            }
                        }
                        if (messageObject != null && messageObject.messageOwner != null) {
                            if (chatAdapter.isFiltered) {
                                MessageObject realMessage = messagesDict[0].get(messageObject.getId());
                                if (realMessage != null && realMessage.messageOwner != null) {
                                    realMessage.messageOwner.reactions = messageObject.messageOwner.reactions;
                                }
                            } else if (!chatAdapter.isFiltered && searchingReaction != null) {
                                updateFilteredMessages = true;
                            }
                        }
                        if (chatAdapter.isFiltered && !messageObject.hasReaction(searchingReaction)) {
                            final MessageObject msg = messageObject;
                            final MessageObject.GroupedMessages groupedMessages = getValidGroupedMessage(msg);
                            if (groupedMessages != null) {
                                for (int i = 0; i < groupedMessages.messages.size(); ++i) {
                                    MessageObject gmsg = groupedMessages.messages.get(i);
                                    getMediaDataController().removeMessageFromResults(gmsg.getId());
                                }
                            } else {
                                getMediaDataController().removeMessageFromResults(msg.getId());
                            }
                            if (messagesSearchAdapter != null) {
                                messagesSearchAdapter.notifyDataSetChanged();
                            }
                            updateFilteredMessages = true;
                            notifyFilteredMessages = true;
                        }
                    }
                }
                if (updateFilteredMessages) {
                    updateFilteredMessages(notifyFilteredMessages);
                }
                clearSelectionMode(true);

                if (messagesCount > 0) {
                    TLRPC.Document document;
                    if (visibleReaction.documentId == 0) {
                        TLRPC.TL_availableReaction availableReaction = MediaDataController.getInstance(UserConfig.selectedAccount).getReactionsMap().get(visibleReaction.emojicon);
                        if (availableReaction == null) {
                            return;
                        }
                        document = availableReaction.activate_animation;
                    } else {
                        document = AnimatedEmojiDrawable.findDocument(UserConfig.selectedAccount, visibleReaction.documentId);
                    }

                    if (document == null) {
                        return;
                    }

                    BulletinFactory.of(ChatActivity.this).createMessagesTaggedBulletin(messagesCount, document, null).show(true);
                }
            }
        });
        tagSelector.setTop(true);
        tagSelector.setClipChildren(false);
        tagSelector.setClipToPadding(false);
        tagSelector.setVisibility(View.VISIBLE);
        tagSelector.setHint(LocaleController.getString(tagSelector.getSelectedReactions().isEmpty() ? R.string.SavedTagReactionsSelectedAddHint : R.string.SavedTagReactionsSelectedEditHint));
        contentView.addView(tagSelector, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, 92.5f, Gravity.CENTER_HORIZONTAL | Gravity.TOP, 0, 0, 0, 0));
        tagSelector.setMessage(null, null, true);
        tagSelector.setTranslationY(-dp(12));
        tagSelector.setScaleY(.4f);
        tagSelector.setScaleX(.4f);
        tagSelector.animate().scaleY(1f).scaleX(1f).translationY(0).setDuration(420).setInterpolator(CubicBezierInterpolator.EASE_OUT_QUINT).start();
        updateSelectedMessageReactions();
        tagSelector.setTranslationY(contentPanTranslation + (actionBarSearchTags != null ? actionBarSearchTags.getCurrentHeight() : 0));
    }

    private void createSearchContainer() {
        if (searchContainer != null || getContext() == null) {
            return;
        }

        searchContainer = new FrameLayout(getContext()) {

            @Override
            protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
                if (child == searchCountText) {
                    int leftMargin = 18;
                    if (searchCalendarButton != null && searchCalendarButton.getVisibility() != GONE) {
                        leftMargin += 48;
                    }
                    if (searchUserButton != null && searchUserButton.getVisibility() != GONE) {
                        leftMargin += 48;
                    }
                    ((MarginLayoutParams) child.getLayoutParams()).leftMargin = AndroidUtilities.dp(leftMargin);
                }
                super.measureChildWithMargins(child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
            }
        };
        searchContainer.setClickable(false);
        searchContainer.setWillNotDraw(false);
        bottomViewsVisibilityController.setViewVisible(MESSAGE_SEARCH_CONTAINER, false, false);
        searchContainer.setClipToPadding(false);

        searchCountText = new AnimatedTextView(getContext(), true, true, true);
        searchCountText.setAnimationProperties(.25f, 0, 280, CubicBezierInterpolator.EASE_OUT_QUINT);
//        searchCountText.setScaleProperty(.5f);
        searchCountText.setTextSize(dp(15));
        searchCountText.setTypeface(AndroidUtilities.bold());
        searchCountText.setTextColor(getThemedColor(Theme.key_chat_searchPanelText));
        searchCountText.setGravity(Gravity.LEFT);
        searchContainer.addView(searchCountText, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, 30, Gravity.CENTER_VERTICAL, 0, -1, 97.33f, 0));
        chatInputBubbleContainer.addView(searchContainer, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, searchContainerHeight, Gravity.BOTTOM, 7, 0, 7, 0));
        if (hashtagHistoryView != null) {
            hashtagHistoryView.bringToFront();
        }

        searchExpandList = new AnimatedTextView(getContext(), true, false, true);
        searchExpandList.setAnimationProperties(0, 0, 420, CubicBezierInterpolator.EASE_OUT_QUINT);
        searchExpandList.setScaleProperty(.7f);
        searchExpandList.setTextSize(dp(15));
        searchExpandList.setGravity(Gravity.RIGHT);
        searchExpandList.setTypeface(AndroidUtilities.bold());
        searchExpandList.setTextColor(getThemedColor(Theme.key_windowBackgroundWhiteBlueText2));
        searchExpandList.setText(LocaleController.getString(messagesSearchListContainer != null && messagesSearchListContainer.getTag() != null ? R.string.SearchAsChat : R.string.SearchAsList));
        searchExpandList.adaptWidth = false;
        searchExpandList.setPadding(dp(15.33f), 0, dp(15.33f), 0);
        searchExpandList.setOnClickListener(v -> {
            toggleMesagesSearchListView();
        });
        searchExpandList.setAlpha(0.5f);
        searchExpandList.setClickable(false);
        searchContainer.addView(searchExpandList, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.MATCH_PARENT, Gravity.RIGHT | Gravity.FILL_VERTICAL));

        searchOtherButton = new AnimatedTextView(getContext(), true, true, true);
        searchOtherButton.setGravity(Gravity.CENTER);
        searchOtherButton.setTypeface(AndroidUtilities.bold());
        searchOtherButton.setTextColor(getThemedColor(Theme.key_chat_fieldOverlayText));
        searchOtherButton.setTextSize(AndroidUtilities.dp(15));
        searchOtherButton.setBackground(Theme.createSelectorWithBackgroundDrawable(getThemedColor(Theme.key_windowBackgroundWhite), Theme.blendOver(getThemedColor(Theme.key_windowBackgroundWhite), getThemedColor(Theme.key_listSelector))));
        searchOtherButton.setText(LocaleController.getString(chatAdapter.isFiltered ? R.string.SavedTagHideOtherMessages : R.string.SavedTagShowOtherMessages));
        searchOtherButton.setOnClickListener(v -> {
            setFilterMessages(!chatAdapter.isFiltered);
        });
        searchOtherButton.setVisibility(View.GONE);
        searchOtherButton.setAlpha(0f);
        searchContainer.addView(searchOtherButton, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.FILL));

        if (currentChat != null && (!ChatObject.isChannel(currentChat) || currentChat.megagroup) && chatMode != MODE_SEARCH && !ChatObject.isMonoForum(currentChat)) {
            searchUserButton = new ImageView(getContext());
            searchUserButton.setScaleType(ImageView.ScaleType.CENTER);
            searchUserButton.setImageResource(R.drawable.msg_usersearch);
            searchUserButton.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_searchPanelIcons), PorterDuff.Mode.MULTIPLY));
            searchUserButton.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), 1));
            searchContainer.addView(searchUserButton, LayoutHelper.createFrame(44, 44, Gravity.LEFT | Gravity.TOP, 48, 0, 0, 0));
            searchUserButton.setOnClickListener(view -> {
                if (mentionContainer != null) {
                    mentionContainer.setReversed(true);
                    mentionContainer.getAdapter().setSearchingMentions(true);
                    checkUi_botMenuPosition();
                }
                searchCalendarButton.setVisibility(View.GONE);
                searchUserButton.setVisibility(View.GONE);
                searchingForUser = true;
                searchingUserMessages = null;
                searchingChatMessages = null;
                searchItem.setSearchFieldHint(LocaleController.getString(R.string.SearchMembers));
                searchItem.setSearchFieldCaption(LocaleController.getString(R.string.SearchFrom));
                AndroidUtilities.showKeyboard(searchItem.getSearchField());
                searchItem.clearSearchText();
            });
            searchUserButton.setContentDescription(LocaleController.getString(R.string.AccDescrSearchByUser));
        }

        if (chatMode != MODE_SEARCH) {
            searchCalendarButton = new ImageView(getContext());
            searchCalendarButton.setScaleType(ImageView.ScaleType.CENTER);
            searchCalendarButton.setImageResource(R.drawable.msg_calendar);
            searchCalendarButton.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_searchPanelIcons), PorterDuff.Mode.MULTIPLY));
            searchCalendarButton.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_actionBarActionModeDefaultSelector), 1));
            searchContainer.addView(searchCalendarButton, LayoutHelper.createFrame(44, 44, Gravity.LEFT | Gravity.TOP, 2.66f, 0, 0, 0));
            searchCalendarButton.setOnClickListener(view -> {
                if (getParentActivity() == null) {
                    return;
                }
                if (searchItem != null) {
                    AndroidUtilities.hideKeyboard(searchItem.getSearchField());
                }
                showDialog(AlertsCreator.createCalendarPickerDialog(getParentActivity(), 1375315200000L, new MessagesStorage.IntCallback() {
                    @Override
                    public void run(int param) {
                        jumpToDate(param);
                    }
                }, themeDelegate).create());
            });
            searchCalendarButton.setContentDescription(LocaleController.getString(R.string.JumpToDate));
        }
    }

    private void showSearchShowOther(boolean show) {
        searchOtherButton.setVisibility(View.VISIBLE);
        searchOtherButton.animate().alpha(show ? 1f : 0f).withEndAction(() -> {
            searchOtherButton.setVisibility(show ? View.VISIBLE : View.GONE);
        }).setDuration(170).start();
    }

    public void onPageDownClicked() {
        wasManualScroll = true;
        textSelectionHelper.cancelTextSelectionRunnable();
        final Runnable inCaseLoading = () -> {
            sideControlsButtonsLayout.setButtonLoading(ChatActivitySideControlsButtonsLayout.BUTTON_PAGE_DOWN, true, true);
        };
        if (createUnreadMessageAfterId != 0) {
            scrollToMessageId(createUnreadMessageAfterId, 0, false, returnToLoadIndex, true, 0, null, inCaseLoading);
        } else if (returnToMessageId > 0) {
            scrollToMessageId(returnToMessageId, 0, true, returnToLoadIndex, true, 0, null, inCaseLoading);
        } else {
            scrollToLastMessage(true, true, inCaseLoading);
            if (!pinnedMessageIds.isEmpty()) {
                forceScrollToFirst = true;
                forceNextPinnedMessageId = pinnedMessageIds.get(0);
            }
        }
    }

    public ActionBarMenuItem getHeaderItem() {
        return headerItem;
    }

    private void playReactionAnimation(Integer messageId) {
        if (fragmentView == null) {
            return;
        }
        BaseCell cell = findMessageCell(messageId, false);
        if (cell instanceof ChatMessageCell) {
            final ChatMessageCell messageCell = (ChatMessageCell) cell;
            final TLRPC.MessagePeerReaction reaction = messageCell.getMessageObject().getRandomUnreadReaction();
            if (reaction != null && (messageCell.reactionsLayoutInBubble.hasUnreadReactions || reaction.big)) {
                ReactionsEffectOverlay.show(ChatActivity.this, null, cell, null,0, 0, ReactionsLayoutInBubble.VisibleReaction.fromTL(reaction.reaction), currentAccount, reaction.big ? ReactionsEffectOverlay.LONG_ANIMATION : ReactionsEffectOverlay.SHORT_ANIMATION);
                ReactionsEffectOverlay.startAnimation();
            }
            messageCell.markReactionsAsRead();
        } else if (cell instanceof ChatActionCell) {
            final ChatActionCell actionCell = (ChatActionCell) cell;
            final TLRPC.MessagePeerReaction reaction = actionCell.getMessageObject().getRandomUnreadReaction();
            if (reaction != null && (actionCell.reactionsLayoutInBubble.hasUnreadReactions || reaction.big)) {
                ReactionsEffectOverlay.show(ChatActivity.this, null, cell, null,0, 0, ReactionsLayoutInBubble.VisibleReaction.fromTL(reaction.reaction), currentAccount, reaction.big ? ReactionsEffectOverlay.LONG_ANIMATION : ReactionsEffectOverlay.SHORT_ANIMATION);
                ReactionsEffectOverlay.startAnimation();
            }
            actionCell.markReactionsAsRead();
        }
    }

    private void dimBehindView(View view, boolean enable) {
        dimBehindView(view, false, enable);
    }

    private void dimBehindView(View view, boolean blur, boolean enable) {
        setScrimView(view);
        dimBehindView(enable ? 0.2f : 0, blur, view != sideControlsButtonsLayout);
    }

    private void dimBehindView(View view, float value) {
        setScrimView(view);
        dimBehindView(value, false, view != sideControlsButtonsLayout);
    }

    private void setScrimView(View scrimView) {
        if (this.scrimView == scrimView) {
            return;
        }
        if (this.scrimView != null) {
            if (this.scrimView instanceof ChatActionCell) {
                ((ChatActionCell) this.scrimView).setInvalidateWithParent(null);
            }
        }
        this.scrimView = scrimView;
        if (this.scrimView instanceof ChatActionCell) {
            ((ChatActionCell) this.scrimView).setInvalidateWithParent(fragmentView);
        }
    }
    public void dimBehindView(boolean enable) {
        dimBehindView(enable ? 0.2f : 0, false, true);
    }

    private void checkInstantCameraView() {
        if (instantCameraView != null || !CameraView.isCameraAllowed() || getContext() == null) {
            return;
        }
        instantCameraView = new InstantCameraView(getContext(), this, themeDelegate, true) {
            @Override
            public void startAnimation(boolean open, boolean fromPaused) {
                super.startAnimation(open, fromPaused);
                animatorRoundMessageCameraVisibility.setValue(open, true);
            }
        };
        instantCameraView.setClipToPadding(false);
        instantCameraView.setButtonsBackground(glassBackgroundDrawableFactory, blurredBackgroundColorProvider);

        int index = contentView.indexOfChild(chatInputViewsContainer);
        if (index < 0) {
            index = contentView.getChildCount();
        }
        index = Math.min(index + 1, contentView.getChildCount());

        contentView.addView(instantCameraView, index, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.LEFT | Gravity.TOP));
    }

    private void dimBehindView(float value, boolean blur, boolean hidePagedownButtons) {
        boolean enable = value > 0;
        if (scrimView instanceof ChatMessageCell) {
            ChatMessageCell cell = (ChatMessageCell) scrimView;
            cell.setInvalidatesParent(enable);
            if (enable) {
                restartSticker(cell);
            }
        }
        contentView.invalidate();
        chatListView.invalidate();
        if (scrimAnimatorSet != null) {
            scrimAnimatorSet.removeAllListeners();
            scrimAnimatorSet.cancel();
        }
        scrimAnimatorSet = new AnimatorSet();
        ArrayList<Animator> animators = new ArrayList<>();
        ValueAnimator scrimPaintAlphaAnimator;
        final float max = Math.max(scrimPaintAlpha, value);
        if (enable) {
            scrimViewAlpha = 1f;
            scrimViewProgress = 0;
            if (scrimViewAlphaAnimator != null) {
                scrimViewAlphaAnimator.cancel();
            }
            scrimProgressDirection = true;
            animators.add(scrimPaintAlphaAnimator = ValueAnimator.ofFloat(0, value));

            if (blur) {
                AndroidUtilities.makeGlobalBlurBitmap(bitmap -> {
                    scrimBlurBitmap = bitmap;

                    scrimBlurBitmapPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
                    scrimBlurBitmapPaint.setShader(scrimBlurBitmapShader = new BitmapShader(scrimBlurBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
                    ColorMatrix colorMatrix = new ColorMatrix();
                    AndroidUtilities.adjustSaturationColorMatrix(colorMatrix, Theme.isCurrentThemeDark() ? .08f : +.25f);
                    AndroidUtilities.adjustBrightnessColorMatrix(colorMatrix, Theme.isCurrentThemeDark() ? -.02f : -.07f);
                    scrimBlurBitmapPaint.setColorFilter(new ColorMatrixColorFilter(colorMatrix));
                    scrimBlurMatrix = new Matrix();
                }, 14);
            }
        } else {
            scrimViewProgress = scrimPaintAlpha / max;
            scrimProgressDirection = false;
            animators.add(scrimPaintAlphaAnimator = ValueAnimator.ofFloat(scrimPaintAlpha, 0));
        }
        scrimPaintAlphaAnimator.addUpdateListener(a -> {
            scrimPaintAlpha = (float) a.getAnimatedValue();
            scrimViewProgress = scrimPaintAlpha / max;
            if (fragmentView != null) {
                fragmentView.invalidate();
            }
        });
        if (!enable || hidePagedownButtons) {
            if (sideControlsButtonsLayout != null) {
                animators.add(ObjectAnimator.ofFloat(sideControlsButtonsLayout, View.ALPHA, enable ? 0 : 1));
            }
        }
        scrimAnimatorSet.playTogether(animators);
        scrimAnimatorSet.setInterpolator(CubicBezierInterpolator.EASE_OUT_QUINT);
        scrimAnimatorSet.setDuration(320);
        final ChatMessageCell cell = scrimView instanceof ChatMessageCell ? (ChatMessageCell) scrimView : null;
        scrimAnimatorSet.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                if (!enable) {
                    if (scrimBlurBitmap != null) {
                        scrimBlurBitmapShader = null;
                        scrimBlurBitmapPaint = null;
                        scrimBlurBitmap.recycle();
                        scrimBlurBitmap = null;
                    }
                    if (cell != null) {
                        cell.invalidate();
                    }
                    setScrimView(null);
                    scrimViewTask = null;
                    scrimViewReaction = null;
                    contentView.invalidate();
                    chatListView.invalidate();
                }
            }
        });
        if (scrimView != null && scrimViewAlpha <= 0f) {
            setScrimView(null);
        }
        scrimAnimatorSet.start();
    }

    private class PinnedMessageButton extends TextView {
        public PinnedMessageButton(Context context) {
            super(context);

            setSingleLine(true);
            setLines(1);
            setMaxLines(1);
            setEllipsize(TextUtils.TruncateAt.END);
            setTextColor(getThemedColor(Theme.key_featuredStickers_buttonText));
            setBackground(Theme.AdaptiveRipple.filledRect(getThemedColor(Theme.key_featuredStickers_addButton), 16));
            setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
            setTypeface(AndroidUtilities.bold());
            setGravity(Gravity.CENTER);
            setPadding(AndroidUtilities.dp(14), 0, AndroidUtilities.dp(14), 0);
        }

        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(
                View.MeasureSpec.makeMeasureSpec(Math.min(View.MeasureSpec.getSize(widthMeasureSpec), (int) (AndroidUtilities.displaySize.x * 0.45f)), View.MeasureSpec.AT_MOST),
                heightMeasureSpec
            );
        }
    }

    private boolean filledEditTextItemMenu = false;
    private void checkEditTextItemMenu() {
        if (filledEditTextItemMenu || editTextItem == null) {
            return;
        }

        ActionBarMenuItem item = editTextItem.createView();
        item.addSubItem(text_spoiler, LocaleController.getString(R.string.Spoiler));
        if (chatMode == 0) {
            item.addSubItem(text_quote, LocaleController.getString(R.string.Quote));
        }
        SpannableStringBuilder stringBuilder = new SpannableStringBuilder(LocaleController.getString(R.string.Bold));
        stringBuilder.setSpan(new TypefaceSpan(AndroidUtilities.bold()), 0, stringBuilder.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        item.addSubItem(text_bold, stringBuilder);
        stringBuilder = new SpannableStringBuilder(LocaleController.getString(R.string.Italic));
        stringBuilder.setSpan(new TypefaceSpan(AndroidUtilities.getTypeface("fonts/ritalic.ttf")), 0, stringBuilder.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        item.addSubItem(text_italic, stringBuilder);
        stringBuilder = new SpannableStringBuilder(LocaleController.getString(R.string.Mono));
        stringBuilder.setSpan(new TypefaceSpan(Typeface.MONOSPACE), 0, stringBuilder.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        item.addSubItem(text_mono, stringBuilder);
        if (currentEncryptedChat == null || AndroidUtilities.getPeerLayerVersion(currentEncryptedChat.layer) >= 101) {
            stringBuilder = new SpannableStringBuilder(LocaleController.getString(R.string.Strike));
            TextStyleSpan.TextStyleRun run = new TextStyleSpan.TextStyleRun();
            run.flags |= TextStyleSpan.FLAG_STYLE_STRIKE;
            stringBuilder.setSpan(new TextStyleSpan(run), 0, stringBuilder.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            item.addSubItem(text_strike, stringBuilder);

            stringBuilder = new SpannableStringBuilder(LocaleController.getString(R.string.Underline));
            run = new TextStyleSpan.TextStyleRun();
            run.flags |= TextStyleSpan.FLAG_STYLE_UNDERLINE;
            stringBuilder.setSpan(new TextStyleSpan(run), 0, stringBuilder.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            item.addSubItem(text_underline, stringBuilder);
        }
        item.addSubItem(text_link, LocaleController.getString(R.string.CreateLink));
        item.addSubItem(text_regular, LocaleController.getString(R.string.Regular));

        filledEditTextItemMenu = true;
    }

    private void updatePagedownButtonsPosition() {
        if (sideControlsButtonsLayout != null) {
            float baseTranslationY2 = -windowInsetsStateHolder.getAnimatedMaxBottomInset()
                - chatInputViewsContainer.getInputBubbleHeight()
                - dp(ChatInputViewsContainer.INPUT_BUBBLE_BOTTOM + 4);
            sideControlsButtonsLayout.setTranslationY(baseTranslationY2);
        }

        if (suggestEmojiPanel != null) {
            float baseTranslationY2 = -windowInsetsStateHolder.getAnimatedMaxBottomInset()
                - dp(ChatInputViewsContainer.INPUT_BUBBLE_BOTTOM + 7);
            suggestEmojiPanel.setTranslationY(baseTranslationY2);
        }
    }

    private void updateReactionsMentionButton(boolean animated) {
        if (getParentActivity() == null) {
            return;
        }
        boolean visible = reactionsMentionCount > 0 && (chatMode == 0 || chatMode == MODE_SUGGESTIONS);
        sideControlsButtonsLayout.showButton(ChatActivitySideControlsButtonsLayout.BUTTON_REACTIONS, visible, animated);
        sideControlsButtonsLayout.setButtonCount(ChatActivitySideControlsButtonsLayout.BUTTON_REACTIONS, reactionsMentionCount, animated);
    }

    public void fallbackFieldPanel() {
        if (messageSuggestionParams != null) {
            showFieldPanelForSuggestionParams(messageSuggestionParams);
        } else if (foundWebPage != null) {
            showFieldPanelForWebPage(true, foundWebPage, false);
        } else if (replyingQuote != null) {
            showFieldPanelForReplyQuote(replyingMessageObject, replyingQuote);
        } else if (replyingMessageObject != null && replyingMessageObject != threadMessageObject) {
            showFieldPanelForReply(replyingMessageObject);
        } else if (messagePreviewParams != null && messagePreviewParams.forwardMessages != null) {
            showFieldPanelForForward(true, messagePreviewParams.forwardMessages.messages);
        } else if (editingMessageObject != null) {
            showFieldPanelForEdit(true, editingMessageObject);
        } else {
            showFieldPanelForWebPage(false, null, true);
        }
    }

    private boolean keyboardWasVisible;
    private void openForwardingPreview(int startTab) {
        if (messagePreviewParams == null || forwardingPreviewView != null) {
            return;
        }
        if (messagePreviewParams.linkMessage != null) {
            messagePreviewParams.updateLink(currentAccount, foundWebPage, chatActivityEnterView.getFieldText(), replyingMessageObject == threadMessageObject ? null : replyingMessageObject, replyingQuote, editingMessageObject);
        }


        if (messagePreviewParams.isEmpty()) {
            return;
        }

//        if (chatActivityEnterView != null) {
//            chatActivityEnterView.freezeEmojiView(false);
//        }
        keyboardWasVisible = chatActivityEnterView.isKeyboardVisible();
        forwardingPreviewView = new MessagePreviewView(contentView.getContext(), this, messagePreviewParams, currentUser, currentChat, currentAccount, themeDelegate, startTab, replyingQuote != null && replyingQuote.outdated) {

            @Override
            protected void removeLink() {
                dismiss(true);
                foundWebPage = null;
                if (chatActivityEnterView != null) {
                    chatActivityEnterView.setWebPage(null, false);
                }
                if (messagePreviewParams != null) {
                    messagePreviewParams.updateLink(currentAccount, null, null, replyingMessageObject == threadMessageObject ? null : replyingMessageObject, replyingQuote, editingMessageObject);
                }
                fallbackFieldPanel();
            }

            @Override
            protected void removeQuote() {
                dismiss(true);
                replyingQuote = null;
                showFieldPanelForReply(replyingMessageObject);
            }

            @Override
            protected void removeReply() {
                dismiss(true);
                replyingMessageObject = null;
                replyingQuote = null;
                messagePreviewParams.updateReply(null, null, dialog_id, null);
                fallbackFieldPanel();
            }

            @Override
            protected void removeForward() {
                super.removeForward();
                dismiss(true);
                messagePreviewParams.updateForward(null, dialog_id);
                fallbackFieldPanel();
            }

            @Override
            protected void onFullDismiss(boolean canShowKeyboard) {
                if (messagePreviewParams != null) {
                    messagePreviewParams.attach(null);
                }
                if (canShowKeyboard) {
                    AndroidUtilities.runOnUIThread(() -> {
                        if (chatActivityEnterView != null) {
                            chatActivityEnterView.freezeEmojiView(false);
                        }
                    }, 15);
                }
            }

            @Override
            protected void onQuoteSelectedPart() {
                if (replyingQuote == null || replyingQuote.message == null || messagePreviewParams.quote != null && messagePreviewParams.quote.message != null && replyingQuote.message.getId() != messagePreviewParams.quote.message.getId()) {
                    replyingQuote = messagePreviewParams.quote;
                }
            }

            @Override
            protected void onDismiss(boolean canShowKeyboard) {
                forwardingPreviewView = null;
                checkShowBlur(true);
                if (messagePreviewParams != null) {
                    if (replyingQuote == null) {
                        replyingQuote = messagePreviewParams.quote;
                    }
                    if (messagePreviewParams.quote == null) {
                        replyingQuote = null;
                    }
                    if (replyingQuote != null) {
                        replyingQuote.outdated = false;
                        replyingQuote.start = messagePreviewParams.quoteStart;
                        replyingQuote.end = messagePreviewParams.quoteEnd;
                        replyingQuote.update();
                        if (fieldPanelShown == 2) {
                            showFieldPanelForReplyQuote(replyingMessageObject, replyingQuote);
                        }
                    } else {
                        ArrayList<MessageObject> selectedMessage = new ArrayList<>();
                        if (messagePreviewParams.forwardMessages != null) {
                            messagePreviewParams.forwardMessages.getSelectedMessages(selectedMessage);
                        }
                        fallbackFieldPanel();
                    }
                }
                forbidForwardingWithDismiss = false;

                if (keyboardWasVisible && canShowKeyboard) {
                    AndroidUtilities.runOnUIThread(() -> {
                        if (chatActivityEnterView != null) {
                            chatActivityEnterView.openKeyboard();
                        }
                    }, 50);
                    keyboardWasVisible = false;
                }

                AndroidUtilities.requestAdjustResize(getParentActivity(), classGuid);
            }

            @Override
            protected void selectAnotherChat(boolean forward) {
                dismiss(false);
                if (messagePreviewParams != null) {
                    if (!forward) {
                        ignoreDraft = true;
                    }
                    int hasPoll = 0;
                    boolean hasInvoice = false;
                    if (messagePreviewParams.forwardMessages != null) {
                        for (int a = 0, N = messagePreviewParams.forwardMessages.messages.size(); a < N; a++) {
                            MessageObject messageObject = messagePreviewParams.forwardMessages.messages.get(a);
                            if (messageObject.isTodo()) {
                                hasPoll = 3;
                            } else if (messageObject.isPoll()) {
                                if (hasPoll != 2) {
                                    hasPoll = messageObject.isPublicPoll() ? 2 : 1;
                                }
                            } else if (messageObject.isInvoice()) {
                                hasInvoice = true;
                            }
                            selectedMessagesIds[0].put(messageObject.getId(), messageObject);
                        }
                    }
                    final Bundle args = new Bundle();
                    args.putBoolean("onlySelect", true);
                    args.putInt("dialogsType", DialogsActivity.DIALOGS_TYPE_FORWARD);
                    args.putBoolean("quote", !forward);
                    final boolean reply = !forward && messagePreviewParams.replyMessage != null && !messagePreviewParams.replyMessage.messages.isEmpty() && messagePreviewParams.quote == null;
                    args.putBoolean("reply_to", reply);
                    if (reply) {
                        final long author = DialogObject.getPeerDialogId(messagePreviewParams.replyMessage.messages.get(0).getFromPeer());
                        if (author != 0 && author != getDialogId() && author != getUserConfig().getClientUserId() && author > 0) {
                            args.putLong("reply_to_author", author);
                        }
                    }
                    args.putInt("hasPoll", hasPoll);
                    args.putBoolean("hasInvoice", hasInvoice);
                    args.putInt("messagesCount", messagePreviewParams.forwardMessages == null ? 0 : messagePreviewParams.forwardMessages.messages.size());
                    args.putBoolean("canSelectTopics", true);
                    final DialogsActivity fragment = new DialogsActivity(args);
                    fragment.setDelegate(ChatActivity.this);
                    presentFragment(fragment);
                }
            }

            @Override
            protected void didSendPressed() {
                super.didSendPressed();
                dismiss(true);
                chatActivityEnterView.getSendButton().callOnClick();
            }
        };
        messagePreviewParams.attach(forwardingPreviewView);
        TLRPC.Peer defPeer = chatInfo != null ? chatInfo.default_send_as : null;
        if (defPeer == null && sendAsPeersObj != null && !sendAsPeersObj.peers.isEmpty()) {
            defPeer = sendAsPeersObj.peers.get(0).peer;
        }
        forwardingPreviewView.setSendAsPeer(defPeer);
        checkShowBlur(true);
        contentView.addView(forwardingPreviewView);

        if (keyboardWasVisible) {
            chatActivityEnterView.freezeEmojiView(true);
            chatActivityEnterView.showEmojiView();
            openKeyboardOnAttachMenuClose = true;
        }
        AndroidUtilities.setAdjustResizeToNothing(getParentActivity(), classGuid);
        fragmentView.requestLayout();
    }

    private void animateToNextChat() {
        if (pullingDownDrawable == null) {
            return;
        }
        if (isTopic) {
            if (pullingDownDrawable.getTopic() != null) {
                addToPulledTopicsMyself();
                addToPulledDialogs(currentChat, pullingDownDrawable.nextTopic, dialog_id, dialogFolderId, dialogFilterId);
                Bundle bundle = new Bundle();
                bundle.putInt("dialog_folder_id", pullingDownDrawable.dialogFolderId);
                bundle.putInt("dialog_filter_id", pullingDownDrawable.dialogFilterId);
                bundle.putBoolean("pulled", true);
                ChatActivity chatActivity = ForumUtilities.getChatActivityForTopic(ChatActivity.this, -dialog_id, pullingDownDrawable.getTopic(), 0, bundle);
                chatActivity.setPullingDownTransition(true);
                replacingChatActivity = true;
                presentFragment(chatActivity, true);
            }
        } else if (pullingDownDrawable.getChatId() != 0) {
            addToPulledDialogsMyself();
            addToPulledDialogs(pullingDownDrawable.nextChat, null, pullingDownDrawable.nextDialogId, pullingDownDrawable.dialogFolderId, pullingDownDrawable.dialogFilterId);
            Bundle bundle = new Bundle();
            bundle.putLong("chat_id", pullingDownDrawable.getChatId());
            bundle.putInt("dialog_folder_id", pullingDownDrawable.dialogFolderId);
            bundle.putInt("dialog_filter_id", pullingDownDrawable.dialogFilterId);
            bundle.putBoolean("pulled", true);
            SharedPreferences sharedPreferences = MessagesController.getNotificationsSettings(currentAccount);
            sharedPreferences.edit().remove("diditem" + pullingDownDrawable.nextDialogId).apply();
            ChatActivity chatActivity = new ChatActivity(bundle);
            if (nextChannels != null && nextChannels.size() > 1) {
                chatActivity.setNextChannels(new ArrayList<>(nextChannels.subList(1, nextChannels.size())));
            }
            chatActivity.setPullingDownTransition(true);
            replacingChatActivity = true;
            presentFragment(chatActivity, true);
        }
    }

    private ArrayList<TLRPC.Chat> nextChannels;
    public void setNextChannels(ArrayList<TLRPC.Chat> channels) {
        nextChannels = channels;
    }

    private void addToPulledDialogsMyself() {
        if (getParentLayout() == null) {
            return;
        }
        int stackIndex = getParentLayout().getFragmentStack().indexOf(this);
        BackButtonMenu.addToPulledDialogs(this, stackIndex, currentChat, currentUser, null, dialog_id, dialogFilterId, dialogFolderId);
    }
    private void addToPulledDialogs(TLRPC.Chat chat, TLRPC.TL_forumTopic topic, long dialogId, int folderId, int filterId) {
        if (getParentLayout() == null) {
            return;
        }
        int stackIndex = getParentLayout().getFragmentStack().indexOf(this);
        BackButtonMenu.addToPulledDialogs(this, stackIndex, chat, null, topic, dialogId, folderId, filterId);
    }

    private void addToPulledTopicsMyself() {
        if (getParentLayout() == null) {
            return;
        }
        int stackIndex = getParentLayout().getFragmentStack().indexOf(this);
        BackButtonMenu.addToPulledDialogs(this, stackIndex, currentChat, currentUser, forumTopic, dialog_id, dialogFilterId, dialogFolderId);
    }

    private void setPullingDownTransition(boolean fromPullingDownTransition) {
        this.fromPullingDownTransition = fromPullingDownTransition;
    }

    public void setSwitchFromTopics(boolean switchFromTopics) {
        this.switchFromTopics = switchFromTopics;
    }
    private void updateBulletinLayout() {
        Bulletin bulletin = Bulletin.getVisibleBulletin();
        if (bulletin != null && bulletinDelegate != null) {
            bulletin.updatePosition();
        }
    }

    private void searchUserMessages(TLRPC.User user, TLRPC.Chat chat) {
        searchingUserMessages = user;
        searchingChatMessages = chat;
        if (searchItem == null || mentionContainer == null || searchingUserMessages == null && searchingChatMessages == null) {
            return;
        }
        String name;
        if (searchingUserMessages != null) {
            name = searchingUserMessages.first_name;
            if (TextUtils.isEmpty(name)) {
                name = searchingUserMessages.last_name;
            }
        } else {
            name = searchingChatMessages.title;
        }
        if (name == null) {
            return;
        }
        if (name.length() > 10) {
            name = name.substring(0, 10);
        }
        searchingForUser = false;
        String from = LocaleController.getString(R.string.SearchFrom);
        Spannable spannable = new SpannableString(from + " " + name);
        spannable.setSpan(new ForegroundColorSpan(getThemedColor(Theme.key_actionBarDefaultSubtitle)), from.length() + 1, spannable.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        searchItem.setSearchFieldCaption(spannable);
        mentionContainer.getAdapter().searchUsernameOrHashtag(null, 0, null, false, true);
        searchItem.setSearchFieldHint(null);
        searchItem.clearSearchText();
        getMediaDataController().searchMessagesInChat(searchingQuery = "", dialog_id, mergeDialogId, classGuid, 0, threadMessageId, searchingUserMessages, searchingChatMessages, searchingReaction);
    }

    private void updateTranslateItemVisibility() {
        if (translateItem == null) {
            return;
        }
        translateItem.setVisibility(getMessagesController().getTranslateController().isTranslateDialogHidden(getDialogId()) && getMessagesController().getTranslateController().isDialogTranslatable(getDialogId()) ? View.VISIBLE : View.GONE);
    }

    private Animator infoTopViewAnimator;

    private void updateInfoTopView(boolean animated) {
        if (contentView == null) {
            return;
        }
        SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);

        CharSequence text = null;
        View.OnClickListener onClickListener = null;
        if (currentChat != null && chatInviterId != 0) {
            boolean show = preferences.getInt("dialog_bar_vis3" + dialog_id, 0) == 2;
            boolean showReport = preferences.getBoolean("dialog_bar_report" + dialog_id, false);
            boolean showBlock = preferences.getBoolean("dialog_bar_block" + dialog_id, false);
            if (show && (showReport || showBlock)) {
                TLRPC.User user = getMessagesController().getUser(chatInviterId);
                if (user != null) {
                    text = ChatObject.isChannel(currentChat) && !currentChat.megagroup ? LocaleController.getString(R.string.ActionUserInvitedToChannel) : LocaleController.getString(R.string.ActionUserInvitedToGroup);
                    text = MessageObject.replaceWithLink(text, "un1", user);
                    onClickListener = (v) -> {
                        Bundle args = new Bundle();
                        args.putLong("user_id", chatInviterId);
                        presentFragment(new ProfileActivity(args));
                    };
                }
            } else {
                hideInfoView();
            }
        }
        if (text != null) {
            if (infoTopViewAnimator != null) {
                infoTopViewAnimator.cancel();
            }
            if (infoTopView == null) {
                infoTopView = new ChatActionCell(contentView.getContext(), false, themeDelegate);
                infoTopView.setCustomText(text);
                infoTopView.setInvalidateColors(true);
                infoTopView.setOnClickListener(onClickListener);
                contentView.addView(infoTopView, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.TOP | Gravity.CENTER_HORIZONTAL, 0, 0, 0, 0));
            }
            if (animated) {
                if (infoTopView.getTag() == null) {
                    ValueAnimator a = ValueAnimator.ofFloat(0, 1f);
                    infoTopView.setTag(1);
                    infoTopView.setAlpha(0f);
                    View distanceTopViewFinal = infoTopView;
                    a.addUpdateListener(animation -> {
                        float alpha = (float) animation.getAnimatedValue();
                        topViewOffset = (alpha) * AndroidUtilities.dp(30);
                        invalidateChatListViewTopPadding();
                        distanceTopViewFinal.setAlpha(alpha);
                    });
                    a.addListener(new AnimatorListenerAdapter() {
                        @Override
                        public void onAnimationEnd(Animator animation) {
                            topViewOffset = AndroidUtilities.dp(30);
                            invalidateChatListViewTopPadding();
                        }
                    });
                    a.setDuration(150);
                    infoTopViewAnimator = a;
                    a.start();
                }
            } else {
                infoTopView.setTag(1);
                topViewOffset = AndroidUtilities.dp(30);
                invalidateChatListViewTopPadding();
            }
        }
    }

    private void checkTopUndoView() {
        if (topUndoView != null) {
            return;
        }
        topUndoView = new UndoView(getContext(), this, true, themeDelegate) {
            @Override
            public void didPressUrl(CharacterStyle span) {
                didPressMessageUrl(span, false, null, null);
            }

            @Override
            public void showWithAction(long did, int action, Object infoObject, Object infoObject2, Runnable actionRunnable, Runnable cancelRunnable) {
                setAdditionalTranslationY(fragmentContextView != null && fragmentContextView.isCallTypeVisible() ? AndroidUtilities.dp(fragmentContextView.getStyleHeight()) : 0);
                super.showWithAction(did, action, infoObject, infoObject2, actionRunnable, cancelRunnable);
            }
        };
        contentView.addView(topUndoView, 17, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.WRAP_CONTENT, Gravity.TOP | Gravity.LEFT, 8, 8, 8, 0));
    }

    private void createPinnedMessageView() {
        if (currentEncryptedChat != null || pinnedMessageView != null || getContext() == null) {
            return;
        }
        final int possibleLeftMarginDp = 0; // isSideMenued() ? SIDE_MENU_WIDTH : 0;
        pinnedMessageView = new BlurredFrameLayout(getContext(), contentView) {

            float lastY;
            float startY;

            {
                setOnLongClickListener(v -> {
                    if (AndroidUtilities.isTablet() || isThreadChat()) {
                        return false;
                    }
                    startY = lastY;
                    openPinnedMessagesList(true);
                    return true;
                });
            }

            @Override
            public boolean onTouchEvent(MotionEvent event) {
                lastY = event.getY();
                if (event.getAction() == MotionEvent.ACTION_UP) {
                    finishPreviewFragment();
                } else if (event.getAction() == MotionEvent.ACTION_MOVE) {
                    float dy = startY - lastY;
                    movePreviewFragment(dy);
                    if (dy < 0) {
                        startY = lastY;
                    }
                }
                return super.onTouchEvent(event);
            }

            @Override
            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                if (setPinnedTextTranslationX) {
                    for (int a = 0; a < pinnedNextAnimation.length; a++) {
                        if (pinnedNextAnimation[a] != null) {
                            pinnedNextAnimation[a].start();
                        }
                    }
                    setPinnedTextTranslationX = false;
                }
            }

            @Override
            protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
                if (child == pinnedLineView) {
                    canvas.save();
                    canvas.clipRect(0, 0, getMeasuredWidth(), AndroidUtilities.dp(48));
                }
                boolean result;
                if (child == pinnedMessageTextView[0] || child == pinnedMessageTextView[1]) {
                    canvas.save();
                    canvas.clipRect(0,0,getMeasuredWidth() - AndroidUtilities.dp(38),getMeasuredHeight());
                    result = super.drawChild(canvas, child, drawingTime);
                    canvas.restore();
                } else {
                    result = super.drawChild(canvas, child, drawingTime);
                    if (child == pinnedLineView) {
                        canvas.restore();
                    }
                }

                return result;
            }
        };
        pinnedMessageView.setTag(1);
        pinnedMessageEnterOffset = -AndroidUtilities.dp(50);
        pinnedMessageView.setVisibility(View.GONE);
        pinnedMessageView.setBackgroundResource(R.drawable.blockpanel);
        pinnedMessageView.backgroundColor = getThemedColor(Theme.key_chat_topPanelBackground);
        pinnedMessageView.backgroundPaddingBottom = AndroidUtilities.dp(2);
        pinnedMessageView.getBackground().mutate().setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_topPanelBackground), PorterDuff.Mode.MULTIPLY));
        int index = 8;
        if (topChatPanelView != null && topChatPanelView.getParent() == contentView) {
            index = contentView.indexOfChild(topChatPanelView);
        }
        contentView.addView(pinnedMessageView, index, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 50, Gravity.TOP | Gravity.LEFT));
        pinnedMessageView.setOnClickListener(v -> {
            wasManualScroll = true;
            if (isThreadChat() && !isTopic) {
                scrollToMessageId((int) threadMessageId, 0, true, 0, true, 0);
            } else if (currentPinnedMessageId != 0) {
                int currentPinned = currentPinnedMessageId;

                int forceNextPinnedMessageId = 0;
                if (!pinnedMessageIds.isEmpty()) {
                    if (currentPinned == pinnedMessageIds.get(pinnedMessageIds.size() - 1)) {
                        forceNextPinnedMessageId = pinnedMessageIds.get(0) + 1;
                        forceScrollToFirst = true;
                    } else {
                        forceNextPinnedMessageId = currentPinned - 1;
                        forceScrollToFirst = false;
                    }
                }
                this.forceNextPinnedMessageId = forceNextPinnedMessageId;
                if (!forceScrollToFirst) {
                    forceNextPinnedMessageId = -forceNextPinnedMessageId;
                }
                scrollToMessageId(currentPinned, 0, true, 0, true, forceNextPinnedMessageId);
                updateMessagesVisiblePart(false);
            }
        });
        pinnedMessageView.setEnabled(!isInPreviewMode());

        View selector = new View(getContext());
        selector.setBackground(Theme.getSelectorDrawable(false));
        pinnedMessageView.addView(selector, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.LEFT | Gravity.TOP, 0, 0, 0, 2));

        pinnedLineView = new PinnedLineView(getContext(), themeDelegate);
        pinnedMessageView.addView(pinnedLineView, LayoutHelper.createFrame(2, 48, Gravity.LEFT | Gravity.TOP, 8, 0, 0, 0));
        pinnedMessageView.setClipChildren(false);

        pinnedCounterTextView = new NumberTextView(getContext());
        pinnedCounterTextView.setAddNumber();
        pinnedCounterTextView.setTextSize(14);
        pinnedCounterTextView.setTextColor(getThemedColor(Theme.key_chat_topPanelTitle));
        pinnedCounterTextView.setTypeface(AndroidUtilities.bold());
        pinnedMessageView.addView(pinnedCounterTextView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 18, Gravity.TOP | Gravity.LEFT, 18, 7, 44 + possibleLeftMarginDp, 0));

        for (int a = 0; a < 2; a++) {
            pinnedNameTextView[a] = new TrackingWidthSimpleTextView(getContext());
            pinnedNameTextView[a].setTextSize(14);
            pinnedNameTextView[a].setTextColor(getThemedColor(Theme.key_chat_topPanelTitle));
            pinnedNameTextView[a].setTypeface(AndroidUtilities.bold());
            pinnedMessageView.addView(pinnedNameTextView[a], LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 18, Gravity.TOP | Gravity.LEFT, 18, 7.3f, 44 + possibleLeftMarginDp, 0));

            pinnedMessageTextView[a] = new SimpleTextView(getContext()) {
                @Override
                public void setTranslationY(float translationY) {
                    super.setTranslationY(translationY);
                    if (this == pinnedMessageTextView[0] && pinnedNextAnimation[1] != null) {
                        if (forceScrollToFirst && translationY < 0) {
                            pinnedLineView.setTranslationY(translationY / 2);
                        } else {
                            pinnedLineView.setTranslationY(0);
                        }
                    }
                }
            };
            pinnedMessageTextView[a].setTextSize(14);
            pinnedMessageTextView[a].setTextColor(getThemedColor(Theme.key_chat_topPanelMessage));
            pinnedMessageView.addView(pinnedMessageTextView[a], LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, 18, Gravity.TOP | Gravity.LEFT, 18, 25.3f, 44 + possibleLeftMarginDp, 0));

            pinnedMessageButton[a] = new PinnedMessageButton(getContext());
            pinnedMessageView.addView(pinnedMessageButton[a], LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, 28, Gravity.TOP | Gravity.RIGHT, 0, 10, 14, 0));

            pinnedMessageImageView[a] = new BackupImageView(getContext()) {
                private SpoilerEffect spoilerEffect = new SpoilerEffect();
                private Path path = new Path();
                private float[] radii = new float[8];

                @Override
                protected void onDraw(Canvas canvas) {
                    super.onDraw(canvas);

                    if (hasBlur) {
                        canvas.save();
                        AndroidUtilities.rectTmp.set(0, 0, getWidth(), getHeight());

                        int[] rad = imageReceiver.getRoundRadius();
                        radii[0] = radii[1] = rad[0];
                        radii[2] = radii[3] = rad[1];
                        radii[4] = radii[5] = rad[2];
                        radii[6] = radii[7] = rad[3];

                        path.rewind();
                        path.addRoundRect(AndroidUtilities.rectTmp, radii, Path.Direction.CW);
                        canvas.clipPath(path);

                        int sColor = Color.WHITE;
                        spoilerEffect.setColor(ColorUtils.setAlphaComponent(sColor, (int) (Color.alpha(sColor) * 0.325f)));
                        spoilerEffect.setBounds(0, 0, getWidth(), getHeight());
                        spoilerEffect.draw(canvas);

                        canvas.restore();
                        invalidate();
                    }
                }
            };
            pinnedMessageImageView[a].setBlurAllowed(true);
            pinnedMessageImageView[a].setRoundRadius(AndroidUtilities.dp(2));
            pinnedMessageView.addView(pinnedMessageImageView[a], LayoutHelper.createFrame(32, 32, Gravity.TOP | Gravity.LEFT, 17, 8, 0, 0));
            if (a == 1) {
                pinnedNameTextView[a].setVisibility(View.INVISIBLE);
                pinnedMessageButton[a].setVisibility(View.INVISIBLE);
                pinnedMessageTextView[a].setVisibility(View.INVISIBLE);
                pinnedMessageImageView[a].setVisibility(View.INVISIBLE);
            }
        }

        pinnedListButton = new ImageView(getContext());
        pinnedListButton.setImageResource(R.drawable.msg_pinnedlist);
        pinnedListButton.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_topPanelClose), PorterDuff.Mode.MULTIPLY));
        pinnedListButton.setScaleType(ImageView.ScaleType.CENTER);
        pinnedListButton.setContentDescription(LocaleController.getString(R.string.AccPinnedMessagesList));
        pinnedListButton.setVisibility(View.INVISIBLE);
        pinnedListButton.setAlpha(0.0f);
        pinnedListButton.setScaleX(0.4f);
        pinnedListButton.setScaleY(0.4f);
        pinnedListButton.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_inappPlayerClose) & 0x19ffffff));
        pinnedMessageView.addView(pinnedListButton, LayoutHelper.createFrame(36, 48, Gravity.RIGHT | Gravity.TOP, 0, 0, 7, 0));
        pinnedListButton.setOnClickListener(v -> openPinnedMessagesList(false));

        closePinned = new ImageView(getContext());
        closePinned.setImageResource(R.drawable.miniplayer_close);
        closePinned.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_topPanelClose), PorterDuff.Mode.MULTIPLY));
        closePinned.setScaleType(ImageView.ScaleType.CENTER);
        closePinned.setVisibility(View.GONE);
        closePinned.setContentDescription(LocaleController.getString(R.string.Close));

        pinnedProgress = new RadialProgressView(getContext(), themeDelegate);
        pinnedProgress.setVisibility(View.GONE);
        pinnedProgress.setSize(AndroidUtilities.dp(16));
        pinnedProgress.setStrokeWidth(2f);
        pinnedProgress.setProgressColor(getThemedColor(Theme.key_chat_topPanelLine));
        pinnedMessageView.addView(pinnedProgress, LayoutHelper.createFrame(36, 48, Gravity.RIGHT | Gravity.TOP, 0, 0, 2, 0));

        closePinned.setBackgroundDrawable(Theme.createSelectorDrawable(getThemedColor(Theme.key_inappPlayerClose) & 0x19ffffff, 1, AndroidUtilities.dp(14)));
        pinnedMessageView.addView(closePinned, LayoutHelper.createFrame(36, 48, Gravity.RIGHT | Gravity.TOP, 0, 0, 2, 0));
        closePinned.setOnClickListener(v -> {
            if (getParentActivity() == null) {
                return;
            }
            boolean allowPin;
            if (currentChat != null) {
                allowPin = ChatObject.canPinMessages(currentChat) && (!currentChat.monoforum /*|| ChatObject.canManageMonoForum(currentAccount, currentChat)*/);
            } else if (currentEncryptedChat == null) {
                if (userInfo != null) {
                    allowPin = userInfo.can_pin_message;
                } else {
                    allowPin = false;
                }
            } else {
                allowPin = false;
            }
            if (allowPin) {
                AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                builder.setTitle(LocaleController.getString(R.string.UnpinMessageAlertTitle));
                builder.setMessage(LocaleController.getString(R.string.UnpinMessageAlert));
                builder.setPositiveButton(LocaleController.getString(R.string.UnpinMessage), (dialogInterface, i) -> {
                    MessageObject messageObject = pinnedMessageObjects.get(currentPinnedMessageId);
                    if (messageObject == null) {
                        messageObject = messagesDict[0].get(currentPinnedMessageId);
                    }
                    unpinMessage(messageObject);
                });
                builder.setNegativeButton(LocaleController.getString(R.string.Cancel), null);
                showDialog(builder.create());
            } else if (!pinnedMessageIds.isEmpty()) {
                SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                preferences.edit().putInt("pin_" + dialog_id, pinnedMessageIds.get(0)).commit();
                updatePinnedMessageView(true);
            }
        });

        updatePinnedListButton(false);
    }

    private void openAnotherForward() {
        if (messagePreviewParams == null || messagePreviewParams.isEmpty() || messagePreviewParams.forwardMessages == null || messagePreviewParams.forwardMessages.messages == null) {
            return;
        }
        boolean fewSenders = false;
        long lastPeerId = 0;
        long dialogId = 0;
        for (int a = 0, N = messagePreviewParams.forwardMessages.messages.size(); a < N; a++) {
            MessageObject message = messagePreviewParams.forwardMessages.messages.get(a);
            if (lastPeerId == 0) {
                dialogId = message.getDialogId();
                lastPeerId = message.getFromChatId();
            } else if (lastPeerId != message.getFromChatId()) {
                fewSenders = true;
                break;
            }
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
        builder.setButtonsVertical(true);
        String message;
        if (dialogId > 0) {
            TLRPC.User user = getMessagesController().getUser(dialogId);
            if (user == null) {
                return;
            }
            message = LocaleController.formatString("CancelForwardPrivate", R.string.CancelForwardPrivate, LocaleController.formatPluralString("MessagesBold", messagePreviewParams.forwardMessages.messages.size()), ContactsController.formatName(user.first_name, user.last_name));
        } else {
            TLRPC.Chat chat = getMessagesController().getChat(-dialogId);
            if (chat == null) {
                return;
            }
            message = LocaleController.formatString("CancelForwardChat", R.string.CancelForwardChat, LocaleController.formatPluralString("MessagesBold", messagePreviewParams.forwardMessages.messages.size()), chat == null ? "" : chat.title);
        }
        builder.setMessage(AndroidUtilities.replaceTags(message));
        builder.setTitle(LocaleController.formatPluralString("messages", messagePreviewParams.forwardMessages.messages.size()));
        builder.setPositiveButton(LocaleController.getString(R.string.CancelForwarding), (dialogInterface, i) -> {
            forbidForwardingWithDismiss = false;
            if (messagePreviewParams != null) {
                messagePreviewParams.updateForward(null, dialog_id);
            }
            fallbackFieldPanel();
        });

        builder.setNegativeButton(LocaleController.getString(R.string.ShowForwardingOptions), (dialogInterface, i) -> {
            openForwardingPreview(MessagePreviewView.TAB_FORWARD);
        });
        AlertDialog dialog = builder.create();
        showDialog(dialog);
        TextView button = (TextView) dialog.getButton(DialogInterface.BUTTON_POSITIVE);
        if (button != null) {
            button.setTextColor(getThemedColor(Theme.key_text_RedBold));
        }
    }

    private void openPinnedMessagesList(boolean preview) {
        if (getParentActivity() == null || parentLayout == null || parentLayout.getLastFragment() != this || pinnedMessageIds.isEmpty()) {
            return;
        }
        Bundle bundle = new Bundle();
        if (currentChat != null) {
            bundle.putLong("chat_id", currentChat.id);
        } else {
            bundle.putLong("user_id", currentUser.id);
        }
        bundle.putInt("chatMode", MODE_PINNED);
        ChatActivity fragment = new ChatActivity(bundle);
        fragment.pinnedMessageIds = new ArrayList<>(pinnedMessageIds);
        fragment.pinnedMessageObjects = new HashMap<>(pinnedMessageObjects);
        for (int a = 0, N = pinnedMessageIds.size(); a < N; a++) {
            Integer id = pinnedMessageIds.get(a);
            MessageObject object = pinnedMessageObjects.get(id);
            MessageObject object2 = messagesDict[0].get(id);
            if (object == null) {
                object = object2;
            } else if (object2 != null) {
                object.mediaExists = object2.mediaExists;
                object.attachPathExists = object2.attachPathExists;
            }
            if (object != null) {
                fragment.pinnedMessageObjects.put(id, object);
                fragment.updatePinnedTopicStarterMessage();
            }
        }
        fragment.loadedPinnedMessagesCount = loadedPinnedMessagesCount;
        fragment.totalPinnedMessagesCount = isTopic ? pinnedMessageIds.size() : totalPinnedMessagesCount;
        fragment.pinnedEndReached = pinnedEndReached;
        fragment.userInfo = userInfo;
        fragment.chatInfo = chatInfo;
        fragment.chatActivityDelegate = new ChatActivityDelegate() {
            @Override
            public void openReplyMessage(int mid) {
                scrollToMessageId(mid, 0, true, 0, true, 0);
            }

            @Override
            public void openHashtagSearch(String text) {
                ChatActivity.this.openHashtagSearch(text);
            }

            @Override
            public void onUnpin(boolean all, boolean hide) {
                if (all) {
                    ArrayList<Integer> ids = new ArrayList<>(pinnedMessageIds);
                    ArrayList<MessageObject> objects = new ArrayList<>(pinnedMessageObjects.values());
                    if (hide) {
                        SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                        if (pinnedMessageIds.isEmpty()) {
                            preferences.edit().remove("pin_" + dialog_id).commit();
                        } else {
                            preferences.edit().putInt("pin_" + dialog_id, pinnedMessageIds.get(0)).commit();
                        }
                        updatePinnedMessageView(true);
                    } else {
                        getNotificationCenter().postNotificationName(NotificationCenter.didLoadPinnedMessages, dialog_id, ids, false, null, null, 0, 0, true);
                    }
                    if (pinBulletin != null) {
                        pinBulletin.hide();
                    }
                    showPinBulletin = true;
                    int tag = ++pinBullerinTag;
                    int oldTotalPinnedCount = getPinnedMessagesCount();
                    pinBulletin = BulletinFactory.createUnpinAllMessagesBulletin(ChatActivity.this, oldTotalPinnedCount, hide,
                            () -> {
                                if (hide) {
                                    SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                                    preferences.edit().remove("pin_" + dialog_id).commit();
                                    updatePinnedMessageView(true);
                                } else {
                                    getNotificationCenter().postNotificationName(NotificationCenter.didLoadPinnedMessages, dialog_id, ids, true, objects, null, 0, oldTotalPinnedCount, pinnedEndReached);
                                }
                                if (tag == pinBullerinTag) {
                                    pinBulletin = null;
                                }
                            },
                            () -> {
                                if (!hide) {
                                    if (isTopic) {
                                        for (int i = 0; i < pinnedMessageIds.size(); i++) {
                                            getMessagesController().pinMessage(currentChat, currentUser, pinnedMessageIds.get(i), true, false, false);
                                        }
                                    } else {
                                        getMessagesController().unpinAllMessages(currentChat, currentUser);
                                    }
                                }
                                if (tag == pinBullerinTag) {
                                    pinBulletin = null;
                                }
                            }, themeDelegate);
                } else {
                    MessageObject messageObject = pinnedMessageObjects.get(currentPinnedMessageId);
                    if (messageObject == null) {
                        messageObject = messagesDict[0].get(currentPinnedMessageId);
                    }
                    unpinMessage(messageObject);
                }
            }
        };
        if (preview) {
            presentFragmentAsPreview(fragment);
            checkShowBlur(true);
        } else {
            presentFragment(fragment, false);
        }
    }

    private void checkShowBlur(boolean animated) {
        boolean show = (parentLayout != null && parentLayout.isInPreviewMode() && !parentLayout.hasIntegratedBlurInPreview() && !inPreviewMode) || (forwardingPreviewView != null && forwardingPreviewView.isShowing());

        if (show && (blurredView == null || blurredView.getTag() == null)) {

            if (blurredView == null) {
                blurredView = new BluredView(fragmentView.getContext(), fragmentView, themeDelegate) {
                    @Override
                    public void setAlpha(float alpha) {
                        super.setAlpha(alpha);
                        if (fragmentView != null) {
                            fragmentView.invalidate();
                        }
                    }

                    @Override
                    public void setVisibility(int visibility) {
                        super.setVisibility(visibility);
                        if (fragmentView != null) {
                            fragmentView.invalidate();
                        }
                    }
                };
                contentView.addView(blurredView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));
            } else {
                int idx = contentView.indexOfChild(blurredView);
                if (idx != contentView.getChildCount() - 1) {
                    contentView.removeView(blurredView);
                    contentView.addView(blurredView);
                }
                blurredView.update();
                blurredView.setVisibility(View.VISIBLE);
            }

            blurredView.setOnClickListener(e -> {
                finishPreviewFragment();
            });
            blurredView.setAlpha(0.0f);
            blurredView.animate().setListener(null).cancel();
            blurredView.animate().alpha(1f).setListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    if (fragmentView == null || chatListView == null) {
                        return;
                    }
                    chatListView.invalidate();
                    fragmentView.invalidate();
                }
            }).start();

            blurredView.setTag(1);
        } else if (!show && blurredView != null && blurredView.getTag() != null) {
            blurredView.animate().setListener(null).cancel();
            blurredView.animate().setListener(new HideViewAfterAnimation(blurredView)).alpha(0).start();
            blurredView.setTag(null);
            chatListView.invalidate();
            if (fragmentView != null) {
                fragmentView.invalidate();
            }
        }
    }

    @Override
    public int getPreviewHeight() {
        if (chatMode == MODE_PINNED && messages.size() == 2) {
            return getHeightForMessage(messages.get(0), false) + AndroidUtilities.dp(80) + ActionBar.getCurrentActionBarHeight();
        }
        return super.getPreviewHeight();
    }

    boolean animateProgressViewTo;

    private Boolean liteModeChat;
    private boolean getLiteModeChat() {
        if (liteModeChat == null) {
            liteModeChat = LiteMode.isEnabled(LiteMode.FLAGS_CHAT);
        }
        return liteModeChat;
    }


    private void showProgressView(boolean show) {
        if (progressView == null) {
            return;
        }
        if (DISABLE_PROGRESS_VIEW && !AndroidUtilities.isTablet() && !isComments && currentUser == null && getLiteModeChat()) {
            animateProgressViewTo = show;
            return;
        }
        if (fragmentOpened && SharedConfig.animationsEnabled()) {
            if (show == animateProgressViewTo) {
                return;
            }
            animateProgressViewTo = show;
            if (show) {
                if (progressView.getVisibility() != View.VISIBLE) {
                    progressView.setVisibility(View.VISIBLE);
                    progressView.setAlpha(0f);
                    progressView.setScaleX(0.3f);
                    progressView.setScaleY(0.3f);
                }
                progressView.animate().setListener(null).cancel();
                progressView.animate().alpha(1f).scaleX(1f).scaleY(1f).setDuration(150).start();
            } else {
                progressView.animate().setListener(null).cancel();
                progressView.animate().alpha(0).scaleX(0.3f).scaleY(0.3f).setDuration(150).setListener(new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        progressView.setVisibility(View.INVISIBLE);
                    }
                }).start();
            }
        } else {
            animateProgressViewTo = show;
            progressView.setVisibility(show ? View.VISIBLE : View.INVISIBLE);
        }
    }

    private void hideInfoView() {
        if (infoTopViewAnimator != null) {
            infoTopViewAnimator.cancel();
        }
        if (infoTopView != null && infoTopView.getTag() != null) {
            infoTopView.setTag(null);
            View topViewFinal = infoTopView;
            ValueAnimator a = ValueAnimator.ofFloat(1f, 0);
            a.addUpdateListener(animation -> {
                float alpha = (float) animation.getAnimatedValue();
                topViewOffset = (alpha) * AndroidUtilities.dp(30);
                invalidateChatListViewTopPadding();
                invalidateMessagesVisiblePart();
                topViewFinal.setAlpha(alpha);
            });
            a.addListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    topViewOffset = 0;
                    if (animation == infoTopViewAnimator) {
                        ViewGroup parent = (ViewGroup) topViewFinal.getParent();
                        if (parent != null) {
                            parent.removeView(topViewFinal);
                        }
                        infoTopView = null;
                        infoTopViewAnimator = null;
                    }
                }
            });
            a.setDuration(150);
            infoTopViewAnimator = a;
            a.start();
        }
    }

    private void updateChatListViewTopPadding() {
        if (!invalidateChatListViewTopPadding || chatListView == null || (fixedKeyboardHeight > 0 && searchExpandProgress == 0)) {
            return;
        }
        float topPanelViewH = Math.max(0, topChatPanelView != null && topChatPanelView.getVisibility() == View.VISIBLE ? (topChatPanelView.getLayoutParams().height - AndroidUtilities.dp(2)) : 0);
        topPanelViewH += Math.max(-topPanelViewH, topChatPanelViewOffset);
        float topPanelView2H = Math.max(0, topChatPanelView2 != null && topChatPanelView2.getVisibility() == View.VISIBLE ? (topChatPanelView2.getLayoutParams().height - AndroidUtilities.dp(2)) : 0);
        topPanelView2H += Math.max(-topPanelView2H, topChatPanelView2Offset);
        float pinnedViewH = 0;
        if (pinnedMessageView != null && pinnedMessageView.getVisibility() == View.VISIBLE) {
            pinnedViewH = Math.max(0, AndroidUtilities.dp(48) + pinnedMessageEnterOffset);
        }
        if (actionBarSearchTags != null) {
            pinnedViewH = Math.max(pinnedViewH, actionBarSearchTags.getCurrentHeight());
        }
        if (hashtagSearchTabs != null) {
            pinnedViewH = Math.max(pinnedViewH, hashtagSearchTabs.getCurrentHeight());
        }
        float pendingViewH = 0;
        View pendingRequestsView = pendingRequestsDelegate != null ? pendingRequestsDelegate.getView() : null;
        if (pendingRequestsView != null && pendingRequestsView.getVisibility() == View.VISIBLE) {
            pendingViewH = Math.max(0, pendingRequestsView.getHeight() + pendingRequestsDelegate.getViewEnterOffset() - AndroidUtilities.dp(4));
        }
        float oldPadding = chatListViewPaddingTop;
        chatListViewPaddingTop = dp(4) + contentPaddingTop + (paddingTopHeight = topPanelViewH + pinnedViewH + pendingViewH + topPanelView2H) + (topicsTabs != null ? dp(48) * (1.0f - topicsTabs.sidemenuT) : 0);
        chatListViewPaddingTop += blurredViewTopOffset;
        chatListViewPaddingVisibleOffset = 0;
        chatListViewPaddingTop += contentPanTranslation;

        float searchExpandOffset = 0;
        if (searchExpandProgress != 0 && chatActivityEnterView != null && chatActivityEnterView.getVisibility() == View.VISIBLE) {
            chatListViewPaddingTop -= (searchExpandOffset = searchExpandProgress * (chatActivityEnterView.getMeasuredHeight() - AndroidUtilities.dp(searchContainerHeight)));
        }

        if (infoTopView != null) {
            infoTopView.setTranslationY(chatListView.getTranslationY() + chatListViewPaddingTop + topViewOffset - dp(30));
            chatListViewPaddingTop += topViewOffset;
            chatListViewPaddingVisibleOffset += topViewOffset;
        }

        if (floatingDateView != null) {
            floatingDateView.setTranslationY(chatListView.getTranslationY() - searchExpandOffset + chatListViewPaddingTop + floatingDateViewOffset - dp(4));
        }
        updateFloatingTopicView();

        // int p = isInsideContainer && chatMode != MODE_SEARCH ? dp(4) : 0; // chatListView.getMeasuredHeight() * 2 / 3;

        if (chatListView != null && chatLayoutManager != null && chatAdapter != null) {
            int p = chatListView.getPaddingTop();
            int b = chatListView.getPaddingBottom();

            checkUi_chatListViewPaddings();

            // final int b = blurredViewBottomOffset + AndroidUtilities.navigationBarHeight + dp(9 + 44 + 7); //  + (isInsideContainer && searchContainer != null && searchContainer.getVisibility() == View.VISIBLE ? dp(50) : 0);
            if (chatListView.getPaddingTop() != p || chatListView.getPaddingBottom() != b) {
                //int top = 0;
                //MessageObject scrollToMessageObject = null;
                //for (int i = 0; i < chatListView.getChildCount(); i++) {
                //    View v = chatListView.getChildAt(i);
                //    if (v instanceof ChatMessageCell) {
                //        scrollToMessageObject = ((ChatMessageCell) v).getMessageObject();
                //        top = getScrollingOffsetForView(v);
                //        break;
                //    } else if (v instanceof ChatActionCell) {
                //        scrollToMessageObject = ((ChatActionCell) v).getMessageObject();
                //        top = getScrollingOffsetForView(v);
                //        break;
                //    }
                //}

                //if (scrollToMessageObject != null) {
                //    chatAdapter.updateRowsSafe();
                //    int index = messages.indexOf(scrollToMessageObject);
                //    if (index >= 0) {
                //        chatLayoutManager.scrollToPositionWithOffset(chatAdapter.messagesStartRow + index, top);
                //    }
                //}

                invalidateMessagesVisiblePart();
                invalidateMergedVisibleBlurredPositionsAndSourcesPositions();
            }

            chatListView.setTopGlowOffset((int) (chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(4)));

            if (oldPadding != chatListViewPaddingTop) {
                int n = chatListView.getChildCount();
                for (int i = 0; i < n; i++) {
                    View child = chatListView.getChildAt(i);
                    int adapterPosition = chatListView.getChildAdapterPosition(child);
                    if (adapterPosition == chatAdapter.getItemCount() - 1) {
                        float padding = chatListViewPaddingTop;
                        if (child.getTop() > padding) {
                            chatListView.scrollBy(0, (int) (child.getTop() - padding));
                        }
                        break;
                    }
                }
            }

            if (!isThreadChat() && !wasManualScroll && unreadMessageObject != null && chatListView != null && !(translateButton != null && translateButton.getVisibility() == View.VISIBLE)) {
                chatListView.scrollBy(0, (int) (oldPadding - chatListViewPaddingTop));
            }
        }

        invalidateChatListViewTopPadding = false;
        Bulletin.updateCurrentPosition();
        checkUi_chatListViewPaddings();
    }

    private void checkUi_chatListViewPaddings() {
        if (chatListView == null) {
            return;
        }


        final int paddingBottomTarget = (int) (
            blurredViewBottomOffset + dp(9 + 7)
            + inputIslandHeightTarget
            + windowInsetsStateHolder.getInsets(WindowInsetsCompat.Type.ime() | WindowInsetsCompat.Type.systemBars()).bottom
        );

        final float paddingBottomAnimated = blurredViewBottomOffset + dp(9 + 7)
            + inputIslandHeightCurrent
            + windowInsetsStateHolder.getAnimatedMaxBottomInset();


        final int paddingTop = (int) chatListViewPaddingTop;
        if (topicsTabs != null) {
            topicsTabs.setSideMenuBackgroundMarginTop(Math.max(0, paddingTop - blurredViewTopOffset - dp(5)));
        }
        chatListViewPaddingsAnimator.setPaddings(paddingTop, paddingBottomAnimated, paddingBottomTarget, wasManualScroll);
    }


    private void invalidateChatListViewTopPadding() {
        if (!invalidateChatListViewTopPadding) {
            invalidateChatListViewTopPadding = true;
            if (contentView != null) {
                contentView.invalidate();
            }
            if (chatListView != null) {
                chatListView.invalidate();
            }
        }

        int topPanelHeight = topChatPanelView != null && topChatPanelView.getVisibility() == View.VISIBLE ? ((topChatPanelView.getLayoutParams() == null ? AndroidUtilities.dp(50) : topChatPanelView.getLayoutParams().height) - AndroidUtilities.dp(2)) : 0;
        topPanelHeight = topPanelHeight + (int) Math.max(-topPanelHeight, topChatPanelViewOffset);
        float translation = contentPanTranslation + contentPaddingTop + Math.max(0, topPanelHeight);
        if (topicsTabs != null) {
            translation += dp(48) * (1.f - topicsTabs.sidemenuT);
        }
        if (pinnedMessageView != null) {
            translation += pinnedMessageEnterOffset;
            pinnedMessageView.setTranslationY(translation);
            translation += AndroidUtilities.dp(48);
        }
        int topPanel2Height = topChatPanelView2 != null && topChatPanelView2.getVisibility() == View.VISIBLE ? ((topChatPanelView2.getLayoutParams() == null ? AndroidUtilities.dp(50) : topChatPanelView2.getLayoutParams().height) - AndroidUtilities.dp(2)) : 0;
        topPanel2Height = topPanel2Height + (int) Math.max(-topPanel2Height, topChatPanelView2Offset);
        translation += Math.max(0, topPanel2Height);
        View pendingRequestsView = pendingRequestsDelegate != null ? pendingRequestsDelegate.getView() : null;
        if (pendingRequestsView != null) {
            translation += pendingRequestsDelegate.getViewEnterOffset();
            pendingRequestsView.setTranslationY(translation);
        }
        float p = 0;
        if (topicsTabs != null) {
            p += dp(48) * (1.f - topicsTabs.sidemenuT);
        }
        p += actionBarSearchTags != null ? actionBarSearchTags.getCurrentHeight() : 0;
        p += hashtagSearchTabs != null ? hashtagSearchTabs.getCurrentHeight() : 0;
        if (fragmentContextView != null) {
            float from = 0;
            if (fragmentLocationContextView != null && fragmentLocationContextView.getVisibility() == View.VISIBLE) {
                from += AndroidUtilities.dp(36);
            }
            fragmentContextView.setTranslationY(contentPanTranslation + p + from + fragmentContextView.getTopPadding());
        }

        if (fragmentLocationContextView != null) {
            float from = 0;
            if (fragmentContextView != null && fragmentContextView.getVisibility() == View.VISIBLE) {
                from += AndroidUtilities.dp(fragmentContextView.getStyleHeight()) + fragmentContextView.getTopPadding();
            }
            fragmentLocationContextView.setTranslationY(contentPanTranslation + p + from + fragmentLocationContextView.getTopPadding());
        }
        if (topChatPanelView != null) {
            topChatPanelView.setTranslationY(contentPanTranslation + p + contentPaddingTop + topChatPanelViewOffset);
        }
        if (topChatPanelView2 != null) {
            topChatPanelView2.setTranslationY(contentPanTranslation + p + contentPaddingTop + topChatPanelView2Offset + topPanelHeight + Math.max(0, topChatPanelViewOffset) + Math.max(0, pinnedMessageView != null ? dp(48) + pinnedMessageEnterOffset : 0));
        }
        if (alertView != null && alertView.getVisibility() == View.VISIBLE) {
            alertView.setTranslationY(contentPanTranslation + p + contentPaddingTop - AndroidUtilities.dp(50) * (1f - alertViewEnterProgress));
        }
        if (undoView != null) {
            undoView.setAdditionalTranslationY(
                windowInsetsStateHolder.getAnimatedMaxBottomInset() + dp(9 + 7)
                    + chatInputViewsContainer.getInputBubbleHeight());
        }
        if (messagesSearchListContainer != null) {
            messagesSearchListContainer.setTranslationY(getHashtagTabsHeight() + contentPanTranslation);
            messagesSearchListContainer.setPadding(0, (actionBarSearchTags != null && actionBarSearchTags.shown() ? actionBarSearchTags.getHeight() : 0), 0, getHashtagTabsHeight());
        }
        if (hashtagHistoryView != null) {
            hashtagHistoryView.setTranslationY(getHashtagTabsHeight() + contentPanTranslation);
        }
    }

    private TextureView createTextureView(boolean add) {
        if (parentLayout == null) {
            return null;
        }
        AndroidUtilities.cancelRunOnUIThread(destroyTextureViewRunnable);
        if (videoPlayerContainer == null) {
            videoPlayerContainer = new FrameLayout(getParentActivity()) {
                @Override
                public void setTranslationY(float translationY) {
                    super.setTranslationY(translationY);
                    contentView.invalidate();
                }
            };
            videoPlayerContainer.setOutlineProvider(new ViewOutlineProvider() {

                @TargetApi(Build.VERSION_CODES.LOLLIPOP)
                @Override
                public void getOutline(View view, Outline outline) {
                    ImageReceiver imageReceiver = (ImageReceiver) view.getTag(R.id.parent_tag);
                    if (imageReceiver != null) {
                        int[] rad = imageReceiver.getRoundRadius();
                        int maxRad = 0;
                        for (int a = 0; a < 4; a++) {
                            maxRad = Math.max(maxRad, rad[a]);
                        }
                        outline.setRoundRect(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight(), maxRad);
                    } else {
                        outline.setOval(0, 0, AndroidUtilities.roundPlayingMessageSize(isSideMenued()), AndroidUtilities.roundPlayingMessageSize(isSideMenued()));
                    }
                }
            });
            videoPlayerContainer.setClipToOutline(true);
            videoPlayerContainer.setWillNotDraw(false);

            aspectRatioFrameLayout = new AspectRatioFrameLayout(getParentActivity());
            aspectRatioFrameLayout.setBackgroundColor(0);
            if (add) {
                videoPlayerContainer.addView(aspectRatioFrameLayout, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.CENTER));
            }

            videoTextureView = new TextureView(getParentActivity());
            videoTextureView.setOpaque(false);
            aspectRatioFrameLayout.addView(videoTextureView, LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT));
        }
        ViewGroup parent = (ViewGroup) videoPlayerContainer.getParent();
        if (parent != null && parent != contentView) {
            parent.removeView(videoPlayerContainer);
            parent = null;
        }
        if (parent == null) {
            contentView.addView(videoPlayerContainer, 1, new FrameLayout.LayoutParams(AndroidUtilities.roundPlayingMessageSize(isSideMenued()), AndroidUtilities.roundPlayingMessageSize(isSideMenued())));
        }
        videoPlayerContainer.setTag(null);
        aspectRatioFrameLayout.setDrawingReady(false);
        return videoTextureView;
    }

    private void destroyTextureView() {
        if (videoPlayerContainer == null || videoPlayerContainer.getParent() == null) {
            return;
        }
        chatListView.invalidateViews();
        aspectRatioFrameLayout.setDrawingReady(false);
        videoPlayerContainer.setTag(null);
        contentView.removeView(videoPlayerContainer);
    }

    private boolean hasSelectedNoforwardsMessage() {
        try {
            for (int i = 0; i < selectedMessagesIds.length; ++i) {
                for (int j = 0; j < selectedMessagesIds[i].size(); ++j) {
                    MessageObject msg = selectedMessagesIds[i].valueAt(j);
                    if (msg != null && msg.messageOwner != null && msg.messageOwner.noforwards) {
                        return true;
                    }
                }
            }
        } catch (Exception ignore) {}
        return false;
    }

    private void share() {
        MessageObject msg = null;
        for (int a = 1; a >= 0; a--) {
            if (msg == null && selectedMessagesIds[a].size() != 0) {
                msg = messagesDict[a].get(selectedMessagesIds[a].keyAt(0));
            }
            selectedMessagesIds[a].clear();
            selectedMessagesCanCopyIds[a].clear();
            selectedMessagesCanStarIds[a].clear();
        }
        if (getParentActivity() != null && msg != null && (msg.isVoice() || msg.isRoundVideo()) && msg.getDocument() != null) {
            TLRPC.Document document = msg.getDocument();
            File file = FileLoader.getInstance(currentAccount).getPathToAttach(document, null, false, true);
            if ((msg.messageOwner != null && msg.messageOwner.attachPath != null) && (file == null || !file.exists())) {
                file = new File(msg.messageOwner.attachPath);
            }
            if (file != null && file.exists()) {
                Intent intent = new Intent(Intent.ACTION_SEND);
                if (msg.isVideo() || msg.isRoundVideo()) {
                    intent.setType("video/mp4");
                } else {
                    if (msg != null) {
                        intent.setType(msg.getMimeType());
                    } else {
                        intent.setType("image/jpeg");
                    }
                }
                if (Build.VERSION.SDK_INT >= 24) {
                    try {
                        intent.putExtra(Intent.EXTRA_STREAM, FileProvider.getUriForFile(getParentActivity(), ApplicationLoader.getApplicationId() + ".provider", file));
                        intent.setFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
                    } catch (Exception ignore) {
                        intent.putExtra(Intent.EXTRA_STREAM, Uri.fromFile(file));
                    }
                } else {
                    intent.putExtra(Intent.EXTRA_STREAM, Uri.fromFile(file));
                }
                getParentActivity().startActivityForResult(Intent.createChooser(intent, LocaleController.getString(R.string.ShareFile)), 500);
            }
        }
        hideActionMode();
        updatePinnedMessageView(true);
        updateVisibleRows();
        updateSelectedMessageReactions();
    }

    private void openForward(boolean fromActionBar) {
        if (getMessagesController().isChatNoForwards(currentChat) || hasSelectedNoforwardsMessage()) {
            // We should update text if user changed locale without re-opening chat activity
            String str;
            if (getMessagesController().isChatNoForwards(currentChat)) {
                if (ChatObject.isChannel(currentChat) && !currentChat.megagroup) {
                    str = LocaleController.getString(R.string.ForwardsRestrictedInfoChannel);
                } else {
                    str = LocaleController.getString(R.string.ForwardsRestrictedInfoGroup);
                }
            } else {
                str = LocaleController.getString(R.string.ForwardsRestrictedInfoBot);
            }
            if (fromActionBar) {
                if (fwdRestrictedTopHint == null) {
                    SizeNotifierFrameLayout frameLayout = contentView;
                    int index = frameLayout.indexOfChild(chatInputViewsContainer);
                    if (index == -1) {
                        return;
                    }
                    fwdRestrictedTopHint = new HintView(getParentActivity(), 7, true);
                    frameLayout.addView(fwdRestrictedTopHint, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 12, 0, 12, 0));
                    fwdRestrictedTopHint.setAlpha(0.0f);
                    fwdRestrictedTopHint.setVisibility(View.INVISIBLE);
                }

                fwdRestrictedTopHint.setText(str);
                fwdRestrictedTopHint.showForView(actionBar.getActionMode().getItem(forward), true);
            } else {
                if (fwdRestrictedBottomHint == null) {
                    SizeNotifierFrameLayout frameLayout = contentView;
                    int index = frameLayout.indexOfChild(chatInputViewsContainer);
                    if (index == -1) {
                        return;
                    }
                    fwdRestrictedBottomHint = new HintView(getParentActivity(), 9);
                    frameLayout.addView(fwdRestrictedBottomHint, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 12, 0, 12, 0));
                    fwdRestrictedBottomHint.setAlpha(0.0f);
                    fwdRestrictedBottomHint.setVisibility(View.INVISIBLE);
                }

                fwdRestrictedBottomHint.setText(str);
                fwdRestrictedBottomHint.showForView(actionsButtonsLayout.getForwardButton(), true);
            }
            return;
        }
        int hasPoll = 0;
        boolean hasInvoice = false;
        for (int a = 0; a < 2; a++) {
            for (int b = 0; b < selectedMessagesIds[a].size(); b++) {
                MessageObject messageObject = selectedMessagesIds[a].valueAt(b);
                if (messageObject.isTodo()) {
                    hasPoll = 3;
                } else if (messageObject.isPoll()) {
                    hasPoll = messageObject.isPublicPoll() ? 2 : 1;
                    if (hasPoll == 2) {
                        break;
                    }
                } else if (messageObject.isInvoice()) {
                    hasInvoice = true;
                }
            }
            if (hasPoll == 2) {
                break;
            }
        }
        if (selectionReactionsOverlay != null && selectionReactionsOverlay.isVisible()) {
            selectionReactionsOverlay.setHiddenByScroll(true);
        }
        Bundle args = new Bundle();
        args.putBoolean("onlySelect", true);
        args.putInt("dialogsType", DialogsActivity.DIALOGS_TYPE_FORWARD);
        args.putInt("messagesCount", canForwardMessagesCount);
        args.putInt("hasPoll", hasPoll);
        args.putBoolean("hasInvoice", hasInvoice);
        args.putBoolean("canSelectTopics", true);
        DialogsActivity fragment = new DialogsActivity(args);
        fragment.setDelegate(ChatActivity.this);
        presentFragment(fragment);
    }

    public void showBottomOverlayProgress(boolean show, boolean animated) {
        if (show && bottomOverlayProgress.getTag() != null || !show && bottomOverlayProgress.getTag() == null) {
            return;
        }
        if (bottomOverlayAnimation != null) {
            bottomOverlayAnimation.cancel();
            bottomOverlayAnimation = null;
        }
        bottomOverlayProgress.setTag(show ? 1 : null);
        if (animated) {
            bottomOverlayAnimation = new AnimatorSet();
            if (show) {
                bottomOverlayProgress.setVisibility(View.VISIBLE);
                bottomOverlayAnimation.playTogether(
                        ObjectAnimator.ofFloat(bottomOverlayChatText, View.SCALE_X, 0.1f),
                        ObjectAnimator.ofFloat(bottomOverlayChatText, View.SCALE_Y, 0.1f),
                        ObjectAnimator.ofFloat(bottomOverlayChatText, View.ALPHA, 0.0f),
                        ObjectAnimator.ofFloat(bottomOverlayProgress, View.SCALE_X, 1.0f),
                        ObjectAnimator.ofFloat(bottomOverlayProgress, View.SCALE_Y, 1.0f),
                        ObjectAnimator.ofFloat(bottomOverlayProgress, View.ALPHA, 1.0f));
                bottomOverlayAnimation.setStartDelay(200);
            } else {
                View text = bottomOverlayLinks ? bottomOverlayLinksText : bottomOverlayChatText;
                bottomOverlayAnimation.playTogether(
                        ObjectAnimator.ofFloat(bottomOverlayProgress, View.SCALE_X, 0.1f),
                        ObjectAnimator.ofFloat(bottomOverlayProgress, View.SCALE_Y, 0.1f),
                        ObjectAnimator.ofFloat(bottomOverlayProgress, View.ALPHA, 0.0f),
                        ObjectAnimator.ofFloat(text, View.SCALE_X, 1.0f),
                        ObjectAnimator.ofFloat(text, View.SCALE_Y, 1.0f),
                        ObjectAnimator.ofFloat(text, View.ALPHA, 1.0f));
            }
            bottomOverlayAnimation.addListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    if (bottomOverlayAnimation != null && bottomOverlayAnimation.equals(animation)) {
                        if (!show) {
                            bottomOverlayProgress.setVisibility(View.INVISIBLE);
                        } else {
                            (bottomOverlayLinks ? bottomOverlayLinksText : bottomOverlayChatText).setVisibility(View.INVISIBLE);
                        }
                    }
                }

                @Override
                public void onAnimationCancel(Animator animation) {
                    if (bottomOverlayAnimation != null && bottomOverlayAnimation.equals(animation)) {
                        bottomOverlayAnimation = null;
                    }
                }
            });
            bottomOverlayAnimation.setDuration(150);
            bottomOverlayAnimation.start();
        } else {
            bottomOverlayProgress.setVisibility(show ? View.VISIBLE : View.INVISIBLE);
            bottomOverlayProgress.setScaleX(show ? 1.0f : 0.1f);
            bottomOverlayProgress.setScaleY(show ? 1.0f : 0.1f);
            bottomOverlayProgress.setAlpha(show ? 1.0f : 1.0f);
            bottomOverlayChatText.setVisibility(show || bottomOverlayLinks ? View.INVISIBLE : View.VISIBLE);
            bottomOverlayLinksText.setVisibility(show || !bottomOverlayLinks ? View.INVISIBLE : View.VISIBLE);
            bottomOverlayChatText.setScaleX(show || bottomOverlayLinks ? 0.1f : 1.0f);
            bottomOverlayLinksText.setScaleX(show || !bottomOverlayLinks ? 0.1f : 1.0f);
            bottomOverlayChatText.setScaleY(show || bottomOverlayLinks ? 0.1f : 1.0f);
            bottomOverlayLinksText.setScaleY(show || !bottomOverlayLinks ? 0.1f : 1.0f);
            bottomOverlayChatText.setAlpha(show || bottomOverlayLinks ? 0.0f : 1.0f);
            bottomOverlayLinksText.setAlpha(show || !bottomOverlayLinks ? 0.0f : 1.0f);
        }
    }

    private void sendBotInlineResult(TLRPC.BotInlineResult result, boolean notify, int scheduleDate, long stars) {
        if (mentionContainer == null) {
            return;
        }
        long uid = mentionContainer.getAdapter().getContextBotId();
        HashMap<String, String> params = new HashMap<>();
        params.put("id", result.id);
        params.put("query_id", "" + result.query_id);
        params.put("bot", "" + uid);
        params.put("bot_name", mentionContainer.getAdapter().getContextBotName());
        SendMessagesHelper.prepareSendingBotContextResult(this, getAccountInstance(), result, params, dialog_id, replyingMessageObject, getThreadMessage(), null, replyingQuote, notify, scheduleDate, 0, quickReplyShortcut, getQuickReplyId(), stars);
        chatActivityEnterView.setFieldText("");
        hideFieldPanel(false);
        getMediaDataController().increaseInlineRating(uid);
    }

    private void checkBotCommands() {
        URLSpanBotCommand.enabled = false;
        if (currentUser != null && currentUser.bot) {
            URLSpanBotCommand.enabled = !UserObject.isReplyUser(currentUser);
        } else if (chatInfo instanceof TLRPC.TL_chatFull) {
            for (int a = 0; a < chatInfo.participants.participants.size(); a++) {
                TLRPC.ChatParticipant participant = chatInfo.participants.participants.get(a);
                TLRPC.User user = getMessagesController().getUser(participant.user_id);
                if (user != null && user.bot) {
                    URLSpanBotCommand.enabled = true;
                    break;
                }
            }
        } else if (chatInfo instanceof TLRPC.TL_channelFull) {
            URLSpanBotCommand.enabled = !chatInfo.bot_info.isEmpty() && currentChat != null && currentChat.megagroup;
        }
    }

    public MessageObject.GroupedMessages getValidGroupedMessage(MessageObject message) {
        MessageObject.GroupedMessages groupedMessages = null;
        if (message.getGroupId() != 0) {
            groupedMessages = groupedMessagesMap.get(message.getGroupId());
            if (groupedMessages != null && (groupedMessages.messages.size() <= 1 || groupedMessages.getPosition(message) == null)) {
                groupedMessages = null;
            }
        }
        return groupedMessages;
    }

    public void jumpToDate(int date) {
        if (messages.isEmpty()) {
            return;
        }
        MessageObject firstMessage = messages.get(0);
        MessageObject lastMessage = messages.get(messages.size() - 1);
        if (firstMessage.messageOwner.date >= date && lastMessage.messageOwner.date <= date || lastMessage.messageOwner.date >= date && endReached[0]) {
            for (int a = messages.size() - 1; a >= 0; a--) {
                MessageObject message = messages.get(a);
                if (message.messageOwner.date >= date && message.getId() != 0) {
                    scrollToMessageId(message.getId(), 0, false, message.getDialogId() == mergeDialogId ? 1 : 0, true, 0);
                    break;
                }
            }
        } else if (!DialogObject.isEncryptedDialog(dialog_id)) {
            int scrollDirection = RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UNSET;
            int end = chatLayoutManager.findLastVisibleItemPosition();
            for (int i = chatLayoutManager.findFirstVisibleItemPosition(); i <= end; i++) {
                if (i >= chatAdapter.messagesStartRow && i < chatAdapter.messagesEndRow) {
                    TLRPC.Message message = messages.get(i - chatAdapter.messagesStartRow).messageOwner;
                    if (message != null) {
                        boolean scrollDown = message.date < date;
                        if (isSecretChat()) {
                            scrollDown = !scrollDown;
                        }
                        scrollDirection = scrollDown ? RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN : RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP;
                        break;
                    }
                }
            }
            chatScrollHelper.setScrollDirection(scrollDirection);

            if (progressDialog != null) {
                progressDialog.dismiss();
            }
            updatePinnedListButton(false);
            progressDialog = new AlertDialog(getParentActivity(), AlertDialog.ALERT_TYPE_SPINNER, themeDelegate);
            progressDialog.setOnCancelListener(postponedScrollCancelListener);
            progressDialog.showDelayed(1000);

            postponedScrollToLastMessageQueryIndex = lastLoadIndex;
            fakePostponedScroll = false;
            waitingForLoad.add(lastLoadIndex);
            postponedScrollMessageId = 0;
            postponedScrollIsCanceled = false;
            getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 30, 0, date, true, 0, classGuid, 4, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
            floatingDateView.setAlpha(0.0f);
            floatingDateView.setTag(null);
            floatingTopicViewAlpha = 0.0f;
            updateFloatingTopicView();
            floatingTopicSeparator.setTag(null);
        }
    }

    private boolean approved;
    public void processInlineBotWebView(TLRPC.TL_inlineBotWebView object) {
        final Runnable open = () -> {
            final TLRPC.User bot = mentionContainer.getAdapter().getFoundContextBot();
            final WebViewRequestProps props = WebViewRequestProps.of(currentAccount, currentUser != null ? currentUser.id : currentChat.id, bot.id, object.text, object.url, BotWebViewSheet.TYPE_SIMPLE_WEB_VIEW_BUTTON, 0, getSendMonoForumPeerId(), false, null, false, null, null, BotWebViewSheet.FLAG_FROM_INLINE_SWITCH, false, false);
            if (LaunchActivity.instance != null && LaunchActivity.instance.getBottomSheetTabs() != null && LaunchActivity.instance.getBottomSheetTabs().tryReopenTab(props) != null) {
                return;
            }
            final String restriction_reason = bot == null ? null : MessagesController.getInstance(currentAccount).getRestrictionReason(bot.restriction_reason);
            if (!TextUtils.isEmpty(restriction_reason)) {
                MessagesController.getInstance(currentAccount).showCantOpenAlert(this, restriction_reason);
                return;
            }
//            if (AndroidUtilities.isTablet() || true) {
                BotWebViewSheet webViewSheet = new BotWebViewSheet(getContext(), getResourceProvider());
                webViewSheet.setDefaultFullsize(false);
                webViewSheet.setNeedsContext(true);
                webViewSheet.setParentActivity(getParentActivity());
                webViewSheet.requestWebView(ChatActivity.this, props);
                webViewSheet.show();
//            } else {
//                BotWebViewAttachedSheet webViewSheet = createBotViewer();
//                webViewSheet.setDefaultFullsize(false);
//                webViewSheet.setNeedsContext(true);
//                webViewSheet.setParentActivity(getParentActivity());
//                webViewSheet.requestWebView(ChatActivity.this, props);
//                webViewSheet.show();
//            }

        };
        if (approved) {
            open.run();
        } else {
            WebAppDisclaimerAlert.show(getContext(), ignored -> {
                approved = true;
                open.run();
            }, null, null);
        }
    }

    public void processInlineBotContextPM(TLRPC.TL_inlineBotSwitchPM object) {
        if (object == null || mentionContainer == null) {
            return;
        }
        TLRPC.User user = mentionContainer.getAdapter().getContextBotUser();
        if (user == null) {
            return;
        }
        chatActivityEnterView.setFieldText("");
        if (dialog_id == user.id) {
            inlineReturn = dialog_id;
            getMessagesController().sendBotStart(currentUser, object.start_param);
        } else {
            Bundle args = new Bundle();
            args.putLong("user_id", user.id);
            args.putString("inline_query", object.start_param);
            args.putLong("inline_return", dialog_id);
            if (!getMessagesController().checkCanOpenChat(args, ChatActivity.this)) {
                return;
            }
            presentFragment(new ChatActivity(args));
        }
    }

    private void createChatAttachView() {
        if (getParentActivity() == null || getContext() == null) {
            return;
        }
        if (chatAttachAlert == null) {
            chatAttachAlert = new ChatAttachAlert(getParentActivity(), this, false, false, true, themeDelegate) {
                @Override
                public void dismissInternal() {
                    if (chatAttachAlert != null && chatAttachAlert.isShowing()) {
                        AndroidUtilities.requestAdjustResize(getParentActivity(), classGuid);
                    }
                    super.dismissInternal();
                    onEditTextDialogClose(false, true);
                }

                @Override
                public void onDismissAnimationStart() {
                    if (chatAttachAlert != null) {
                        chatAttachAlert.setFocusable(false);
                    }
                    if (chatActivityEnterView != null && chatActivityEnterView.getEditField() != null) {
                        chatActivityEnterView.getEditField().requestFocus();
                    }
                    if (chatAttachAlert != null && chatAttachAlert.isShowing()) {
                        AndroidUtilities.requestAdjustResize(getParentActivity(), classGuid);
                    }
                    onEditTextDialogClose(false, false);
                }
            };
            chatAttachAlert.setDelegate(new ChatAttachAlert.ChatAttachViewDelegate() {
                @Override
                public void didPressedButton(int button, boolean arg, boolean notify, int scheduleDate, int scheduleRepeatPeriod, long effectId, boolean invertMedia, boolean forceDocument, long payStars) {
                    if (getParentActivity() == null || chatAttachAlert == null) {
                        return;
                    }
                    editingMessageObject = chatAttachAlert.getEditingMessageObject();
                    if (editingMessageObject != null && editingMessageObject.messageOwner != null) {
                        editingMessageObject.messageOwner.invert_media = invertMedia;
                    }
                    if (button == 8 || button == 7 || button == 4 && !chatAttachAlert.getPhotoLayout().getSelectedPhotos().isEmpty()) {
                        if (chatAttachAlert != null && button != 8) {
                            chatAttachAlert.dismiss(true);
                        }
                        final HashMap<Object, Object> selectedPhotos = chatAttachAlert.getPhotoLayout().getSelectedPhotos();
                        final ArrayList<Object> selectedPhotosOrder = chatAttachAlert.getPhotoLayout().getSelectedPhotosOrder();
                        if (!selectedPhotos.isEmpty()) {
                            final int albumsCount = (int) Math.ceil(selectedPhotos.size() / 10f);
                            for (int i = 0; i < albumsCount; ++i) {
                                int count = Math.min(10, selectedPhotos.size() - (i * 10));
                                ArrayList<SendMessagesHelper.SendingMediaInfo> photos = new ArrayList<>();
                                for (int a = 0; a < count; a++) {
                                    if (i * 10 + a >= selectedPhotosOrder.size()) {
                                        continue;
                                    }
                                    MediaController.PhotoEntry photoEntry = (MediaController.PhotoEntry) selectedPhotos.get(selectedPhotosOrder.get(i * 10 + a));

                                    SendMessagesHelper.SendingMediaInfo info = new SendMessagesHelper.SendingMediaInfo();
                                    if (!photoEntry.isVideo && photoEntry.imagePath != null) {
                                        info.path = photoEntry.imagePath;
                                        if (photoEntry.highQuality) {
                                            info.originalPhotoEntry = photoEntry.clone();
                                        }
                                    } else if (photoEntry.path != null) {
                                        info.path = photoEntry.path;
                                    }
                                    info.thumbPath = photoEntry.thumbPath;
                                    info.coverPath = photoEntry.coverPath;
                                    info.coverPhoto = photoEntry.coverPhoto;
                                    info.isVideo = photoEntry.isVideo;
                                    info.caption = photoEntry.caption != null ? photoEntry.caption.toString() : null;
                                    info.entities = photoEntry.entities;
                                    info.masks = photoEntry.stickers;
                                    info.ttl = photoEntry.ttl;
                                    info.videoEditedInfo = photoEntry.editedInfo;
                                    info.canDeleteAfter = photoEntry.canDeleteAfter;
                                    info.updateStickersOrder = SendMessagesHelper.checkUpdateStickersOrder(photoEntry.caption);
                                    info.hasMediaSpoilers = photoEntry.hasSpoiler;
                                    info.stars = photoEntry.starsAmount;
                                    info.highQuality = photoEntry.highQuality;
                                    photos.add(info);
                                    photoEntry.reset();
                                }
                                boolean updateStickersOrder = false;
                                if (i == 0) {
                                    fillEditingMediaWithCaption(photos.get(0).caption, photos.get(0).entities);
                                    updateStickersOrder = photos.get(0).updateStickersOrder;
                                }

                                if (editingMessageObject != null && editingMessageObject.needResendWhenEdit()) {
                                    MessageSuggestionParams params = messageSuggestionParams != null ?
                                        messageSuggestionParams : MessageSuggestionParams.of(editingMessageObject.messageOwner.suggested_post);
                                    SendMessagesHelper.prepareSendingMedia(getAccountInstance(), photos, dialog_id, editingMessageObject, getThreadMessage(), null, replyingQuote, button == 4 || forceDocument, arg, null, notify, scheduleDate, scheduleRepeatPeriod, chatMode, updateStickersOrder, null, quickReplyShortcut, getQuickReplyId(), effectId, invertMedia, payStars, getSendMonoForumPeerId(), params);
                                } else {
                                    SendMessagesHelper.prepareSendingMedia(getAccountInstance(), photos, dialog_id, replyingMessageObject, getThreadMessage(), null, replyingQuote, button == 4 || forceDocument, arg, editingMessageObject, notify, scheduleDate, scheduleRepeatPeriod, chatMode, updateStickersOrder, null, quickReplyShortcut, getQuickReplyId(), effectId, invertMedia, payStars, getSendMonoForumPeerId(), messageSuggestionParams);
                                }
                            }
                            afterMessageSend();
                            chatActivityEnterView.setFieldText("");
                        }
                        if (scheduleDate != 0) {
                            if (scheduledMessagesCount == -1) {
                                scheduledMessagesCount = 0;
                            }
                            scheduledMessagesCount += selectedPhotos.size();
                            updateScheduledInterface(true);
                        }
                        return;
                    } else if (chatAttachAlert != null) {
                        chatAttachAlert.dismissWithButtonClick(button);
                    }
                    processSelectedAttach(button);
                }

                @Override
                public View getRevealView() {
                    return chatActivityEnterView.getAttachButton();
                }

                @Override
                public void didSelectBot(TLRPC.User user) {
                    String username = UserObject.getPublicUsername(user);
                    if (chatActivityEnterView == null || user == null || TextUtils.isEmpty(username)) {
                        return;
                    }
                    chatActivityEnterView.setFieldText("@" + username + " ");
                    chatActivityEnterView.openKeyboard();
                }

                @Override
                public void onCameraOpened() {
                    chatActivityEnterView.closeKeyboard();
                }

                @Override
                public boolean needEnterComment() {
                    return needEnterText();
                }

                @Override
                public void doOnIdle(Runnable runnable) {
                    ChatActivity.this.doOnIdle(runnable);
                }
            });
        }
    }

    public boolean needEnterText() {
        boolean keyboardVisible = chatActivityEnterView.isKeyboardVisible();
        if (keyboardVisible) {
            chatActivityEnterView.showEmojiView();
            openKeyboardOnAttachMenuClose = true;
        }
        AndroidUtilities.setAdjustResizeToNothing(getParentActivity(), classGuid);
        fragmentView.requestLayout();
        return keyboardVisible;
    }

    public void onEditTextDialogClose(boolean resetAdjust, boolean reset) {
        if (openKeyboardOnAttachMenuClose) {
            AndroidUtilities.runOnUIThread(() -> chatActivityEnterView.openKeyboard(), 200);
            if (reset) {
                openKeyboardOnAttachMenuClose = false;
            }
        }
        if (resetAdjust && !isInsideContainer) {
            AndroidUtilities.requestAdjustResize(getParentActivity(), classGuid);
        }
    }

    public void doOnIdle(Runnable runnable) {
        NotificationCenter.getInstance(currentAccount).doOnIdle(runnable);
    }

    public void performHistoryClear(boolean revoke, boolean canDeleteHistory) {
        final long threadId = getThreadId();
        performHistoryClear(threadId, revoke, canDeleteHistory);
    }

    public void performHistoryClear(long threadId, boolean revoke, boolean canDeleteHistory) {
        setClearingHistory(threadId, true);
        createUndoView();
        if (undoView == null) {
            return;
        }
        undoView.showWithAction(dialog_id, UndoView.ACTION_CLEAR, () -> {
            if (!pinnedMessageIds.isEmpty()) {
                SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
                preferences.edit().putInt("pin_" + dialog_id, pinnedMessageIds.get(0)).commit();
                pinnedMessageIds.clear();
                pinnedMessageObjects.clear();
                currentPinnedMessageId = 0;
                loadedPinnedMessagesCount = 0;
                totalPinnedMessagesCount = 0;
                updatePinnedMessageView(true);
            }

            if (ChatObject.isMonoForum(currentChat) && ChatObject.canManageMonoForum(currentAccount, currentChat)) {
                if (threadId != 0) {
                    getMessagesStorage().removeTopic(-currentChat.id, threadId);
                    getMessagesController().deleteSavedDialog(threadId, getMessagesController().getInputPeer(-currentChat.id));
                    getMessagesController().getTopicsController().onTopicsDeletedServerSide(currentChat.id, threadId);
                }
            } else {
                getMessagesController().deleteDialog(dialog_id, 1, revoke);
            }
            setClearingHistory(threadId, false);
            if (threadId == getThreadId()) {
                clearHistory(false, null);
                chatAdapter.notifyDataSetChanged();
            }
        }, () -> {
            setClearingHistory(threadId, false);
            if (threadId == getThreadId()) {
                chatAdapter.notifyDataSetChanged();
            }
        });
        chatAdapter.notifyDataSetChanged();
    }

    public long getDialogId() {
        return dialog_id;
    }
    public int getDialogFolderId() {
        return dialogFolderId;
    }
    public int getDialogFilterId() {
        return dialogFilterId;
    }

    public boolean openedWithLivestream() {
        return livestream;
    }

    @Nullable
    public UndoView getUndoView() {
        createUndoView();
        return undoView;
    }

    public long getMergeDialogId() {
        return mergeDialogId;
    }

    public boolean hasReportSpam() {
        return topChatPanelView != null && topChatPanelView.getTag() == null && reportSpamButton.getVisibility() != View.GONE;
    }

    public void setChatInvite(TLRPC.ChatInvite invite) {
        chatInvite = invite;
    }

    public void setBotUser(String value) {
        if (inlineReturn != 0) {
            getMessagesController().sendBotStart(currentUser, value);
        } else {
            sentBotStart = true;
            getMessagesController().sendBotStart(currentUser, botUser = value);
            updateBottomOverlay();
        }
    }

    private void afterMessageSend() {
        messageSuggestionParams = null;
        if (threadMessageId == 0 || isTopic) {
            if (isTopic) {
                replyingMessageObject = threadMessageObject;
            } else {
                replyingMessageObject = null;
            }
            replyingQuote = null;
            if (chatActivityEnterView != null) {
                chatActivityEnterView.setReplyingMessageObject(null, null);
            }
        }
        hideFieldPanel(false);
        if (chatMode == 0) {
            getMediaDataController().cleanDraft(dialog_id, threadMessageId, true);
        }
    }

    private void toggleMesagesSearchListView() {
        if (messagesSearchListContainer != null) {
            showMessagesSearchListView(messagesSearchListContainer.getTag() == null);
        }
    }

    private void showMessagesSearchListView(boolean show) {
        if (messagesSearchListContainer == null || show && messagesSearchListContainer.getTag() != null || !show && messagesSearchListContainer.getTag() == null) {
            return;
        }
        if (messagesSearchListViewAnimation != null) {
            messagesSearchListViewAnimation.cancel();
            messagesSearchListViewAnimation = null;
        }
        if (show) {
            messagesSearchListContainer.setVisibility(View.VISIBLE);
        }
        if (!show && chatMode == MODE_SEARCH) {
            LinearLayoutManager messagesSearchLayoutManager = (LinearLayoutManager) messagesSearchListView.getLayoutManager();
            Object item = messagesSearchAdapter.getItem((messagesSearchLayoutManager.findFirstVisibleItemPosition() + messagesSearchLayoutManager.findLastVisibleItemPosition()) / 2);

            Object firstItem = messagesSearchAdapter.getItem(messagesSearchLayoutManager.findFirstVisibleItemPosition());
            Object lastItem = messagesSearchAdapter.getItem(messagesSearchLayoutManager.findLastVisibleItemPosition());
            if (item != null && firstItem != null && lastItem != null) {
                ArrayList<MessageObject> messages = chatAdapter.getMessages();
                int chatFirstItemPosition = chatLayoutManager.findFirstVisibleItemPosition();
                int chatLastItemPosition = chatLayoutManager.findLastVisibleItemPosition();

                int messageId = ((MessageObject) item).messageOwner.id;
                boolean firstItemVisible = false;
                int firstItemMid = ((MessageObject) firstItem).messageOwner.id;
                boolean lastItemVisible = false;
                int lastItemMid = ((MessageObject) lastItem).messageOwner.id;
                int messageIndex = -1;
                for (int i = 0; i < messages.size(); i++) {
                    if (messages.get(i).messageOwner.id == firstItemMid) {
                        int firstMessagePosition = chatAdapter.messagesStartRow + i;
                        firstItemVisible = chatFirstItemPosition <= firstMessagePosition && chatLastItemPosition >= firstMessagePosition;
                        if (firstItemVisible) {
                            break;
                        }
                    }
                    if (messages.get(i).messageOwner.id == lastItemMid) {
                        int lastMessagePosition = chatAdapter.messagesStartRow + i;
                        lastItemVisible = chatFirstItemPosition <= lastMessagePosition && chatLastItemPosition >= lastMessagePosition;
                        if (lastItemVisible) {
                            break;
                        }
                    }
                    if (messages.get(i).messageOwner.id == messageId) {
                        messageIndex = i;
                    }
                }

                if (!firstItemVisible && !lastItemVisible && messageIndex != -1) {
                    int messageHeight = getHeightForMessage(messages.get(messageIndex), true);
                    int offset = (chatListView.getHeight() - messageHeight) / 2;
                    chatLayoutManager.scrollToPositionWithOffset(chatAdapter.messagesStartRow + messageIndex, offset);
                }
            }
        }
        messagesSearchListContainer.setTag(show ? 1 : null);
        messagesSearchListContainer.setPadding(0, (actionBarSearchTags != null && actionBarSearchTags.shown() ? actionBarSearchTags.getHeight() : 0), 0, getHashtagTabsHeight());
        messagesSearchListViewAnimation = new AnimatorSet();
        messagesSearchListViewAnimation.playTogether(ObjectAnimator.ofFloat(messagesSearchListContainer, View.ALPHA, show ? 1.0f : 0.0f));
        messagesSearchListViewAnimation.setInterpolator(CubicBezierInterpolator.EASE_IN);
        messagesSearchListViewAnimation.setDuration(180);
        messagesSearchListViewAnimation.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                if (animation.equals(messagesSearchListViewAnimation)) {
                    messagesSearchListViewAnimation = null;
                    if (!show) {
                        messagesSearchListContainer.setVisibility(View.GONE);
                    }
                }
            }

            @Override
            public void onAnimationCancel(Animator animation) {
                if (animation.equals(messagesSearchListViewAnimation)) {
                    messagesSearchListViewAnimation = null;
                }
            }
        });
        messagesSearchListViewAnimation.start();
        if (searchExpandList != null) {
            searchExpandList.setText(LocaleController.getString(messagesSearchListContainer != null && messagesSearchListContainer.getTag() != null ? R.string.SearchAsChat : R.string.SearchAsList), !LocaleController.isRTL);
        }
        hideHints();
        updateSearchCountText();
    }

    public boolean playFirstUnreadVoiceMessage() {
        if (chatActivityEnterView != null && chatActivityEnterView.isRecordingAudioVideo()) {
            return true;
        }
        for (int a = messages.size() - 1; a >= 0; a--) {
            MessageObject messageObject = messages.get(a);
            if ((messageObject.isVoice() || messageObject.isRoundVideo()) && messageObject.isContentUnread() && !messageObject.isOut()) {
                MediaController.getInstance().setVoiceMessagesPlaylist(MediaController.getInstance().playMessage(messageObject) ? createVoiceMessagesPlaylist(messageObject, true) : null, true);
                return true;
            }
        }
        if (Build.VERSION.SDK_INT >= 23 && getParentActivity() != null) {
            if (getParentActivity().checkSelfPermission(Manifest.permission.RECORD_AUDIO) != PackageManager.PERMISSION_GRANTED) {
                getParentActivity().requestPermissions(new String[]{Manifest.permission.RECORD_AUDIO}, 3);
                return true;
            }
        }
        return false;
    }

    private void openScheduledMessages() {
        openScheduledMessages(0, false);
    }
    private void openScheduledMessages(int fromMessageId, boolean showConvertToast) {
        if (parentLayout == null || parentLayout.getLastFragment() != this) {
            return;
        }
        Bundle bundle = new Bundle();
        if (currentEncryptedChat != null) {
            bundle.putInt("enc_id", currentEncryptedChat.id);
        } else if (currentChat != null) {
            bundle.putLong("chat_id", currentChat.id);
        } else {
            bundle.putLong("user_id", currentUser.id);
        }
        bundle.putInt("chatMode", MODE_SCHEDULED);
        if (showConvertToast) {
            bundle.putInt("converting_toast_from", fromMessageId);
            bundle.putBoolean("converting_toast", true);
        }
        ChatActivity fragment = new ChatActivity(bundle);
        if (isTopic) {
            ForumUtilities.applyTopic(fragment, MessagesStorage.TopicKey.of(getDialogId(), getTopicId()));
        }
        fragment.chatActivityDelegate = new ChatActivityDelegate() {
            @Override
            public void openReplyMessage(int mid) {
                scrollToMessageId(mid, 0, true, 0, true, 0);
            }

            @Override
            public void openHashtagSearch(String text) {
                ChatActivity.this.openHashtagSearch(text);
            }
        };
        presentFragment(fragment, false);
    }

    public void shareMyContact(int type, MessageObject messageObject) {
        AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
        builder.setTitle(LocaleController.getString(R.string.ShareYouPhoneNumberTitle));
        if (currentUser != null) {
            if (currentUser.bot) {
                builder.setMessage(LocaleController.getString(R.string.AreYouSureShareMyContactInfoBot));
            } else {
                builder.setMessage(AndroidUtilities.replaceTags(LocaleController.formatString("AreYouSureShareMyContactInfoUser", R.string.AreYouSureShareMyContactInfoUser, PhoneFormat.getInstance().format("+" + getUserConfig().getCurrentUser().phone), ContactsController.formatName(currentUser.first_name, currentUser.last_name))));
            }
        } else {
            builder.setMessage(LocaleController.getString(R.string.AreYouSureShareMyContactInfo));
        }
        builder.setPositiveButton(LocaleController.getString(R.string.ShareContact), (dialogInterface, i) -> {
            if (type == 1) {
                TLRPC.TL_contacts_acceptContact req = new TLRPC.TL_contacts_acceptContact();
                req.id = getMessagesController().getInputUser(currentUser);
                getConnectionsManager().sendRequest(req, (response, error) -> {
                    if (error != null) {
                        return;
                    }
                    getMessagesController().processUpdates((TLRPC.Updates) response, false);
                });
            } else {
                SendMessagesHelper.SendMessageParams params = SendMessagesHelper.SendMessageParams.of(getUserConfig().getCurrentUser(), dialog_id, messageObject, getThreadMessage(), null, null, true, 0, 0);
                params.quick_reply_shortcut_id = getQuickReplyId();
                params.quick_reply_shortcut = quickReplyShortcut;
                SendMessagesHelper.getInstance(currentAccount).sendMessage(params);
                if (chatMode == 0) {
                    moveScrollToLastMessage(false);
                }
                hideFieldPanel(false);
            }
        });
        builder.setNegativeButton(LocaleController.getString(R.string.Cancel), null);
        showDialog(builder.create());
    }

    private void showVoiceHint(boolean hide, boolean video) {
        if (getParentActivity() == null || fragmentView == null || hide && voiceHintTextView == null || chatMode != 0 || chatActivityEnterView == null  || chatActivityEnterView.getAudioVideoButtonContainer() == null || chatActivityEnterView.getAudioVideoButtonContainer().getVisibility() != View.VISIBLE || isInPreviewMode()) {
            return;
        }
        if (voiceHintTextView == null) {
            SizeNotifierFrameLayout frameLayout = contentView;
            int index = frameLayout.indexOfChild(chatInputViewsContainer);
            if (index == -1) {
                return;
            }
            voiceHintTextView = new HintView(getParentActivity(), 9, themeDelegate);
            frameLayout.addView(voiceHintTextView, index + 1,  LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 10, 0, 10, 0));
        }
        if (hide) {
            voiceHintTextView.hide();
            return;
        }

        if (chatActivityEnterView.hasRecordVideo()) {
            voiceHintTextView.setText(video ? LocaleController.getString(R.string.HoldToVideo) : LocaleController.getString(R.string.HoldToAudio));
        } else {
            voiceHintTextView.setText(LocaleController.getString(R.string.HoldToAudioOnly));
        }

        voiceHintTextView.showForView(chatActivityEnterView.getAudioVideoButtonContainer(), true);
    }

    public boolean checkSlowMode(View view) {
        CharSequence time = chatActivityEnterView.getSlowModeTimer();
        if (time != null) {
            showSlowModeHint(view, true, time);
            return true;
        }
        return false;
    }

    public boolean checkSlowModeAlert() {
        CharSequence time = chatActivityEnterView.getSlowModeTimer();
        if (time != null) {
            new AlertDialog.Builder(getContext())
                .setTitle(LocaleController.getString(R.string.Slowmode))
                .setMessage(AndroidUtilities.replaceTags(LocaleController.formatString("SlowModeHint", R.string.SlowModeHint, time)))
                .setPositiveButton(LocaleController.getString(R.string.OK), null)
                .show();
            return false;
        }
        return true;
    }

    private void hideHints(boolean scroll) {
        if (!scroll) {
            if (slowModeHint != null) {
                slowModeHint.hide();
            }
            if (scheduledOrNoSoundHint != null) {
                scheduledOrNoSoundHint.hide();
            }
            if (scheduledHint != null) {
                scheduledHint.hide();
            }
        }
        if (fwdRestrictedBottomHint != null) {
            fwdRestrictedBottomHint.hide();
        }
        if (fwdRestrictedTopHint != null) {
            fwdRestrictedTopHint.hide();
        }
        if (noSoundHintView != null) {
            noSoundHintView.hide();
        }
        if (forwardHintView != null) {
            forwardHintView.hide();
        }
        if (pollHintView != null) {
            pollHintView.hide();
        }
        if (timerHintView != null) {
            timerHintView.hide();
        }
        if (checksHintView != null) {
            checksHintView.hide();
        }
        if (bottomGiftHintView != null) {
            bottomGiftHintView.hide();
        }
        if (bottomSuggestHintView != null) {
            bottomSuggestHintView.hide();
        }
    }

    private void hideSendButtonHints() {
        if (scheduledOrNoSoundHint != null) {
            scheduledOrNoSoundHint.hide();
        }
        if (scheduledHint != null) {
            scheduledHint.hide();
        }
    }

    private void showSlowModeHint(View view, boolean show, CharSequence time) {
        if (getParentActivity() == null || fragmentView == null || !show && (slowModeHint == null || slowModeHint.getVisibility() != View.VISIBLE)) {
            return;
        }
        slowModeHint.setText(AndroidUtilities.replaceTags(LocaleController.formatString("SlowModeHint", R.string.SlowModeHint, time)));
        if (show) {
            slowModeHint.showForView(view, true);
        }
    }

    public void showTimerHint() {
        if (getParentActivity() == null || fragmentView == null || chatInfo == null) {
            return;
        }
        if (timerHintView == null) {
            timerHintView = new HintView(getParentActivity(), 7, true, themeDelegate);
            timerHintView.setAlpha(0.0f);
            timerHintView.setVisibility(View.INVISIBLE);
            timerHintView.setShowingDuration(4000);
            contentView.addView(timerHintView, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 19, 0, 19, 0));
        }
        String time;
        if (chatInfo.ttl_period > 24 * 60 * 60) {
            time = LocaleController.formatPluralString("Days", chatInfo.ttl_period / (24 * 60 * 60));
        } else if (chatInfo.ttl_period >= 60 * 60) {
            time = LocaleController.formatPluralString("Hours", chatInfo.ttl_period / (60 * 60));
        } else if (chatInfo.ttl_period >= 60) {
            time = LocaleController.formatPluralString("Minutes", chatInfo.ttl_period / 60);
        } else {
            time = LocaleController.formatPluralString("Seconds", chatInfo.ttl_period);
        }
        timerHintView.setText(LocaleController.formatString("AutoDeleteSetInfo", R.string.AutoDeleteSetInfo, time));
        timerHintView.showForView(avatarContainer.getTimeItem(), true);
    }

    private void showScheduledHint() {
        boolean disableNoSound = (UserObject.isUserSelf(currentUser) || (chatInfo != null && chatInfo.slowmode_next_send_date > 0) && chatMode == 0);
        if (scheduledHintShown || scheduledOrNoSoundHintShown || disableNoSound || SharedConfig.scheduledHintShows >= 3 || chatActivityEnterView.isEditingMessage()) {
            return;
        }
        AndroidUtilities.cancelRunOnUIThread(showScheduledHintRunnable);
        AndroidUtilities.runOnUIThread(showScheduledHintRunnable, 4000);
    }

    private void showScheduledOrNoSoundHint() {
        boolean disableNoSound = UserObject.isUserSelf(currentUser) || (chatInfo != null && chatInfo.slowmode_next_send_date > 0) && chatMode == 0 || chatMode == MODE_EDIT_BUSINESS_LINK;
        long scheduledOrNoSoundHintTimeFromLastSeen = System.currentTimeMillis() - SharedConfig.scheduledOrNoSoundHintSeenAt;
        long scheduledHintTimeFromLastSeen = System.currentTimeMillis() - SharedConfig.scheduledHintSeenAt;
        if (disableNoSound || SharedConfig.scheduledOrNoSoundHintShows >= 3 || scheduledOrNoSoundHintTimeFromLastSeen < 86400000L || scheduledHintTimeFromLastSeen < 86400000L || chatActivityEnterView.isEditingMessage()) {
            return;
        }
        AndroidUtilities.cancelRunOnUIThread(showScheduledOrNoSoundRunnable);
        AndroidUtilities.runOnUIThread(showScheduledOrNoSoundRunnable, 200);
    }

    private void showMediaBannedHint() {
        if (getParentActivity() == null || currentChat == null && userInfo == null || fragmentView == null || mediaBanTooltip != null && mediaBanTooltip.getVisibility() == View.VISIBLE) {
            return;
        }
        SizeNotifierFrameLayout frameLayout = contentView;
        int index = frameLayout.indexOfChild(chatInputViewsContainer);
        if (index == -1) {
            return;
        }

        try {
            fragmentView.performHapticFeedback(HapticFeedbackConstants.KEYBOARD_TAP, HapticFeedbackConstants.FLAG_IGNORE_GLOBAL_SETTING);
        } catch (Exception e) {
            FileLog.e(e);
        }

        if (mediaBanTooltip == null) {
            mediaBanTooltip = new HintView(getParentActivity(), 9, themeDelegate);
            mediaBanTooltip.setVisibility(View.GONE);
            frameLayout.addView(mediaBanTooltip, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 10, 0, 10, 0));
        }

        if (userInfo != null && userInfo.voice_messages_forbidden) {
            mediaBanTooltip.setText(AndroidUtilities.replaceTags(LocaleController.formatString(chatActivityEnterView.isInVideoMode() ? R.string.VideoMessagesRestrictedByPrivacy : R.string.VoiceMessagesRestrictedByPrivacy, currentUser.first_name)));
        } else if (!ChatObject.canSendVoice(currentChat) && !ChatObject.canSendRoundVideo(currentChat)) {
            if (checkCanRemoveRestrictionsByBoosts()) {
                return;
            }
            if (chatActivityEnterView.isInVideoMode()) {
                mediaBanTooltip.setText(ChatObject.getRestrictedErrorText(currentChat, ChatObject.ACTION_SEND_ROUND));
            } else {
                mediaBanTooltip.setText(ChatObject.getRestrictedErrorText(currentChat, ChatObject.ACTION_SEND_VOICE));
            }
        } else if (ChatObject.isActionBannedByDefault(currentChat, ChatObject.ACTION_SEND_VOICE)) {
            mediaBanTooltip.setText(LocaleController.getString(R.string.GlobalAttachVoiceRestricted));
        } else if (ChatObject.isActionBannedByDefault(currentChat, ChatObject.ACTION_SEND_ROUND)) {
            mediaBanTooltip.setText(LocaleController.getString(R.string.GlobalAttachRoundRestricted));
        } else if (ChatObject.isActionBannedByDefault(currentChat, ChatObject.ACTION_SEND_MEDIA)) {
            mediaBanTooltip.setText(LocaleController.getString(R.string.GlobalAttachMediaRestricted));
        } else {
            if (currentChat.banned_rights == null) {
                return;
            }
            if (AndroidUtilities.isBannedForever(currentChat.banned_rights)) {
                mediaBanTooltip.setText(LocaleController.getString(R.string.AttachMediaRestrictedForever));
            } else {
                mediaBanTooltip.setText(LocaleController.formatString("AttachMediaRestricted", R.string.AttachMediaRestricted, LocaleController.formatDateForBan(currentChat.banned_rights.until_date)));
            }
        }

        View sendBtn = chatActivityEnterView.getSendButton();
        View audioVideoBtn = chatActivityEnterView.getAudioVideoButtonContainer();
        View viewForTooltip = sendBtn;
        if (sendBtn.getAlpha() < audioVideoBtn.getAlpha()) {
            viewForTooltip = audioVideoBtn;
        }
        mediaBanTooltip.showForView(viewForTooltip, true);
    }

    private void showNoSoundHint() {
        if (scrollingChatListView || SharedConfig.noSoundHintShowed || chatListView == null || getParentActivity() == null || fragmentView == null || noSoundHintView != null && noSoundHintView.getTag() != null) {
            return;
        }

        if (noSoundHintView == null) {
            SizeNotifierFrameLayout frameLayout = contentView;
            int index = frameLayout.indexOfChild(chatInputViewsContainer);
            if (index == -1) {
                return;
            }
            noSoundHintView = new HintView(getParentActivity(), HintView.TYPE_NOSOUND, themeDelegate);
            noSoundHintView.setShowingDuration(10000);
            frameLayout.addView(noSoundHintView, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 19, 0, 19, 0));
            noSoundHintView.setAlpha(0.0f);
            noSoundHintView.setVisibility(View.INVISIBLE);
        }

        int count = chatListView.getChildCount();
        for (int a = 0; a < count; a++) {
            View child = chatListView.getChildAt(a);
            if (!(child instanceof ChatMessageCell)) {
                continue;
            }
            ChatMessageCell messageCell = (ChatMessageCell) child;
            MessageObject messageObject = messageCell.getMessageObject();
            if (messageObject == null || !messageObject.isVideo()) {
                continue;
            }
            ImageReceiver imageReceiver = messageCell.getPhotoImage();
            AnimatedFileDrawable animation = imageReceiver.getAnimation();
            if (animation == null || animation.getCurrentProgressMs() < 3000) {
                continue;
            }
            if (noSoundHintView.showForMessageCell(messageCell, true)) {
                SharedConfig.setNoSoundHintShowed(true);
                break;
            }
        }
    }

    private void checkChecksHint() {
        if (getMessagesController().pendingSuggestions.contains("NEWCOMER_TICKS")) {
            AndroidUtilities.runOnUIThread(this::showChecksHint, 1000);
        }
    }

    private void showChecksHint() {
        if (scrollingChatListView || chatListView == null || getParentActivity() == null || fragmentView == null || checksHintView != null && checksHintView.getTag() != null) {
            return;
        }

        if (checksHintView == null) {
            SizeNotifierFrameLayout frameLayout = contentView;
            int index = frameLayout.indexOfChild(chatInputViewsContainer);
            if (index == -1) {
                return;
            }
            checksHintView = new ChecksHintView(getParentActivity(), themeDelegate);
            frameLayout.addView(checksHintView, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 10, 0, 10, 0));
            checksHintView.setAlpha(0.0f);
            checksHintView.setVisibility(View.INVISIBLE);
        }

        int count = chatListView.getChildCount();
        for (int a = 0; a < count; a++) {
            View child = chatListView.getChildAt(a);
            if (!(child instanceof ChatMessageCell)) {
                continue;
            }
            ChatMessageCell messageCell = (ChatMessageCell) child;
            MessageObject messageObject = messageCell.getMessageObject();
            if (messageObject == null || !messageObject.isOutOwner() || !messageObject.isSent()) {
                continue;
            }
            if (checksHintView.showForMessageCell(messageCell, true)) {
                getMessagesController().removeSuggestion(0, "NEWCOMER_TICKS");
                break;
            }
        }
    }

    private void showForwardHint(ChatMessageCell cell) {
        if (scrollingChatListView || chatListView == null || getParentActivity() == null || fragmentView == null) {
            return;
        }

        if (forwardHintView == null) {
            SizeNotifierFrameLayout frameLayout = contentView;
            int index = frameLayout.indexOfChild(chatInputViewsContainer);
            if (index == -1) {
                return;
            }
            forwardHintView = new HintView(getParentActivity(), 1, themeDelegate);
            frameLayout.addView(forwardHintView, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.TOP, 19, 0, 19, 0));
            forwardHintView.setAlpha(0.0f);
            forwardHintView.setVisibility(View.INVISIBLE);
        }
        forwardHintView.showForMessageCell(cell, true);
    }

    private void showTextSelectionHint(MessageObject messageObject) {
        if (getParentActivity() == null || getMessagesController().isChatNoForwards(messageObject.getChatId()) || (messageObject != null && messageObject.messageOwner != null && messageObject.messageOwner.noforwards)) {
            return;
        }
        CharSequence text;
        boolean canShowText = false;
        if (messageObject.textLayoutBlocks != null && !messageObject.textLayoutBlocks.isEmpty()) {
            text = messageObject.messageText;
            if (messageObject.textLayoutBlocks.size() > 1) {
                canShowText = true;
            }
        } else {
            text = messageObject.caption;
        }

        if (!canShowText && text != null) {
            canShowText = true; // text.length() > 200;
        }
        if (!canShowText || SharedConfig.textSelectionHintShows > 2 || textSelectionHintWasShowed || lastTouchY > chatActivityEnterView.getTop() - AndroidUtilities.dp(60)) {
            return;
        }
        textSelectionHintWasShowed = true;
        SharedConfig.increaseTextSelectionHintShowed();
        if (textSelectionHint == null) {
            textSelectionHint = new TextSelectionHint(getParentActivity(), themeDelegate) {

                @Override
                protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                    updatePosition();
                }

                @Override
                protected void onDraw(Canvas canvas) {
                    super.onDraw(canvas);
                    updatePosition();
                }

                public void updatePosition() {
                    int start = -(getMeasuredHeight() + AndroidUtilities.dp(16));
                    int end = chatActivityEnterView.getTop() - contentView.getMeasuredHeight();
                    setTranslationY(end - (end + start) * (1f - getPrepareProgress()));
                }
            };
            contentView.addView(textSelectionHint, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, 56, Gravity.BOTTOM | Gravity.LEFT, 8, 0, 8, 8));
        }
        textSelectionHint.show();
    }

    public boolean showEmojiHint() {
        if (chatActivityEnterView == null || chatActivityEnterView.getVisibility() != View.VISIBLE) {
            return false;
        }
        SharedPreferences preferences = MessagesController.getGlobalMainSettings();
        int moreemojihint;
        if ((moreemojihint = preferences.getInt("moreemojihint", 0)) > 3 && UserConfig.getInstance(currentAccount).isPremium()) {
            return false;
        }
        if (UserConfig.getInstance(currentAccount).isPremium()) {
            preferences.edit().putInt("moreemojihint", moreemojihint + 1).commit();
        }

        if (getParentActivity() == null || fragmentView == null || emojiHintTextView != null) {
            return false;
        }
        if (!allowContextBotPanelSecond) {
            if (chatActivityEnterView != null) {
                chatActivityEnterView.setOpenGifsTabFirst();
            }
            return false;
        }
        SizeNotifierFrameLayout frameLayout = contentView;
        int index = frameLayout.indexOfChild(chatInputViewsContainer);
        if (index == -1) {
            return false;
        }
        chatActivityEnterView.setOpenGifsTabFirst();
//        emojiButtonRed = new View(getParentActivity());
//        emojiButtonRed.setBackgroundResource(R.drawable.redcircle);
//        frameLayout.addView(emojiButtonRed, index + 1, LayoutHelper.createFrame(10, 10, Gravity.BOTTOM | Gravity.LEFT, 30, 0, 0, 27));

        emojiHintTextView = new HintView(getParentActivity(), 9, themeDelegate);
        final String emojiPlaceholder = "<<EMOJI>>";
        String textString = LocaleController.formatString("TapHereEmoji", R.string.TapHereEmoji, emojiPlaceholder);
        SpannableStringBuilder text = new SpannableStringBuilder(textString);
        int i = textString.indexOf(emojiPlaceholder);
        if (i >= 0) {
            SpannableString emoji = new SpannableString("x");
            Drawable emojiDrawable = getContext().getResources().getDrawable(R.drawable.smiles_tab_smiles).mutate();
            emojiDrawable.setBounds(0, 0, AndroidUtilities.dp(20), AndroidUtilities.dp(20));
            emojiDrawable.setColorFilter(new PorterDuffColorFilter(getThemedColor(Theme.key_chat_gifSaveHintText), PorterDuff.Mode.MULTIPLY));
            emoji.setSpan(new ImageSpan(emojiDrawable, ImageSpan.ALIGN_BOTTOM), 0, emoji.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            text.replace(i, i + emojiPlaceholder.length(), emoji);
            emojiHintTextView.textView.setPadding(AndroidUtilities.dp(8), AndroidUtilities.dp(0), AndroidUtilities.dp(8), AndroidUtilities.dp(6));
        }
        emojiHintTextView.setText(text);
        frameLayout.addView(emojiHintTextView, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.BOTTOM, 5, 0, 5, 3));

        AnimatorSet AnimatorSet = new AnimatorSet();
        AnimatorSet.playTogether(
                ObjectAnimator.ofFloat(emojiHintTextView, View.ALPHA, 0.0f, 1.0f)
        );
        AnimatorSet.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                AndroidUtilities.runOnUIThread(() -> {
                    if (emojiHintTextView == null) {
                        return;
                    }
                    AnimatorSet AnimatorSet = new AnimatorSet();
                    AnimatorSet.playTogether(
                            ObjectAnimator.ofFloat(emojiHintTextView, View.ALPHA, 0.0f)
                    );
                    AnimatorSet.addListener(new AnimatorListenerAdapter() {
                        @Override
                        public void onAnimationEnd(Animator animation) {
                            if (emojiHintTextView != null) {
                                emojiHintTextView.setVisibility(View.GONE);
                                frameLayout.removeView(emojiHintTextView);
                                emojiHintTextView = null;
                            }
                        }
                    });
                    AnimatorSet.setDuration(300);
                    AnimatorSet.start();
                }, 2000);
            }
        });
        AnimatorSet.setDuration(300);
        AnimatorSet.start();

        View emojiButton = chatActivityEnterView.getEmojiButton();
        if (emojiButton != null) {
            emojiHintTextView.showForView(emojiButton, true);
        }
        return true;
    }

    private boolean showGifHint() {
        if (chatActivityEnterView == null || chatActivityEnterView.getVisibility() != View.VISIBLE) {
            return false;
        }
        SharedPreferences preferences = MessagesController.getGlobalMainSettings();
        if (preferences.getBoolean("gifhint", false)) {
            return false;
        }
        preferences.edit().putBoolean("gifhint", true).commit();

        if (getParentActivity() == null || fragmentView == null || gifHintTextView != null) {
            return false;
        }
        if (!allowContextBotPanelSecond) {
            if (chatActivityEnterView != null) {
                chatActivityEnterView.setOpenGifsTabFirst();
            }
            return false;
        }
        SizeNotifierFrameLayout frameLayout = contentView;
        int index = frameLayout.indexOfChild(chatInputViewsContainer);
        if (index == -1) {
            return false;
        }
        chatActivityEnterView.setOpenGifsTabFirst();
        emojiButtonRed = new View(getParentActivity());
        emojiButtonRed.setBackgroundResource(R.drawable.redcircle);
        frameLayout.addView(emojiButtonRed, index + 1, LayoutHelper.createFrame(10, 10, Gravity.BOTTOM | Gravity.LEFT, 37, 0, 0, 27));

        gifHintTextView = new HintView(getParentActivity(), 9, themeDelegate);
        gifHintTextView.setText(LocaleController.getString(R.string.TapHereGifs));
        frameLayout.addView(gifHintTextView, index + 1, LayoutHelper.createFrame(LayoutHelper.WRAP_CONTENT, LayoutHelper.WRAP_CONTENT, Gravity.LEFT | Gravity.BOTTOM, 5, 0, 5, 3));

        AnimatorSet AnimatorSet = new AnimatorSet();
        AnimatorSet.playTogether(
                ObjectAnimator.ofFloat(gifHintTextView, View.ALPHA, 0.0f, 1.0f),
                ObjectAnimator.ofFloat(emojiButtonRed, View.ALPHA, 0.0f, 1.0f)
        );
        AnimatorSet.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                AndroidUtilities.runOnUIThread(() -> {
                    if (gifHintTextView == null) {
                        return;
                    }
                    AnimatorSet AnimatorSet = new AnimatorSet();
                    AnimatorSet.playTogether(
                            ObjectAnimator.ofFloat(gifHintTextView, View.ALPHA, 0.0f)
                    );
                    AnimatorSet.addListener(new AnimatorListenerAdapter() {
                        @Override
                        public void onAnimationEnd(Animator animation) {
                            if (gifHintTextView != null) {
                                gifHintTextView.setVisibility(View.GONE);
                            }
                        }
                    });
                    AnimatorSet.setDuration(300);
                    AnimatorSet.start();
                }, 2000);
            }
        });
        AnimatorSet.setDuration(300);
        AnimatorSet.start();

        View emojiButton = chatActivityEnterView.getEmojiButton();
        if (emojiButton != null) {
            gifHintTextView.showForView(emojiButton, true);
        }
        return true;
    }

    private void openAttachMenu() {
        if (getParentActivity() == null || chatActivityEnterView != null && !TextUtils.isEmpty(chatActivityEnterView.getSlowModeTimer())) {
            return;
        }
        createChatAttachView();
        chatAttachAlert.getPhotoLayout().loadGalleryPhotos();
        if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
            chatActivityEnterView.closeKeyboard();
        }
        if (currentChat != null && messageSuggestionParams != null) {
            chatAttachAlert.setMaxSelectedPhotos(1, true);
        } else if (currentChat != null && !ChatObject.hasAdminRights(currentChat) && currentChat.slowmode_enabled) {
            chatAttachAlert.setMaxSelectedPhotos(10, true);
        } else {
            chatAttachAlert.setMaxSelectedPhotos(-1, true);
        }
        chatAttachAlert.enableDefaultMode();
        chatAttachAlert.init();
        chatAttachAlert.getCommentView().setText(chatActivityEnterView.getFieldText());
        chatAttachAlert.parentThemeDelegate = themeDelegate;
        showDialog(chatAttachAlert);
    }

    public void openAttachMenuForCreatingSticker() {
        ContentPreviewViewer.getInstance().setStickerSetForCustomSticker(null);
        if (getParentActivity() == null) {
            return;
        }
        createChatAttachView();
        chatAttachAlert.getPhotoLayout().loadGalleryPhotos();
        if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
            chatActivityEnterView.closeKeyboard();
        }
        chatAttachAlert.setMaxSelectedPhotos(1, false);
        chatAttachAlert.setOpenWithFrontFaceCamera(true);
        chatAttachAlert.enableStickerMode(null);
        chatAttachAlert.init();
        chatAttachAlert.parentThemeDelegate = themeDelegate;
        if (visibleDialog != null) {
            chatAttachAlert.show();
        } else {
            showDialog(chatAttachAlert);
        }
    }

    private void showFloatingDateView(boolean scroll) {
        if (floatingDateView == null || chatMode == MODE_QUICK_REPLIES) {
            return;
        }
        if (floatingDateView.getTag() == null) {
            if (floatingDateAnimation != null) {
                floatingDateAnimation.cancel();
            }
            floatingDateView.setTag(1);
            floatingDateAnimation = new AnimatorSet();
            floatingDateAnimation.setDuration(150);
            floatingDateAnimation.playTogether(ObjectAnimator.ofFloat(floatingDateView, View.ALPHA, 1.0f));
            floatingDateAnimation.addListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    if (animation.equals(floatingDateAnimation)) {
                        floatingDateAnimation = null;
                    }
                }
            });
            floatingDateAnimation.start();
        }
        if (!scroll) {
            invalidateMessagesVisiblePart();
            hideDateDelay = 1000;
        }
    }

    private void hideFloatingDateView(boolean animated) {
        if (floatingDateView.getTag() != null && !currentFloatingDateOnScreen && (!scrollingFloatingDate || currentFloatingTopIsNotMessage)) {
            floatingDateView.setTag(null);
            if (animated) {
                floatingDateAnimation = new AnimatorSet();
                floatingDateAnimation.setDuration(150);
                floatingDateAnimation.playTogether(ObjectAnimator.ofFloat(floatingDateView, View.ALPHA, 0.0f));
                floatingDateAnimation.addListener(new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        if (animation.equals(floatingDateAnimation)) {
                            floatingDateAnimation = null;
                        }
                    }
                });
                floatingDateAnimation.setStartDelay(hideDateDelay);
                floatingDateAnimation.start();
            } else {
                if (floatingDateAnimation != null) {
                    floatingDateAnimation.cancel();
                    floatingDateAnimation = null;
                }
                floatingDateView.setAlpha(0.0f);
            }
            hideDateDelay = 500;
        }
    }

    private void showFloatingTopicView(boolean scroll) {
        if (floatingTopicSeparator == null || chatMode == MODE_QUICK_REPLIES) {
            return;
        }
        if (floatingTopicSeparator.getTag() == null) {
            if (floatingTopicAnimation != null) {
                floatingTopicAnimation.cancel();
            }
            floatingTopicSeparator.setTag(1);
            floatingTopicAnimation = ValueAnimator.ofFloat(floatingTopicViewAlpha, 1.0f);
            floatingTopicAnimation.setDuration(150);
            floatingTopicAnimation.addUpdateListener(anm -> {
                floatingTopicViewAlpha = (float) anm.getAnimatedValue();
                updateFloatingTopicView();
            });
            floatingTopicAnimation.addListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    if (animation.equals(floatingTopicAnimation)) {
                        floatingTopicViewAlpha = 1.0f;
                        updateFloatingTopicView();
                        floatingTopicAnimation = null;
                    }
                }
            });
            floatingTopicAnimation.start();
        }
        if (!scroll) {
            invalidateMessagesVisiblePart();
            hideDateDelay = 1000;
        }
    }

    private void updateFloatingTopicView() {
        if (floatingTopicSeparator == null) return;
        floatingTopicSeparator.setTranslationX(getSideMenuWidth() / 2f);
        floatingTopicSeparator.setTranslationY(chatListView.getTranslationY() + chatListViewPaddingTop + floatingTopicViewOffset - dp(4) + dp(28));
        final float alpha = Utilities.clamp(AndroidUtilities.ilerp(floatingTopicViewOffset, -floatingTopicSeparator.getHeight(), 0f), 1f, 0f);
        floatingTopicSeparator.setAlpha(floatingTopicViewAlpha * alpha);
        final float scale = lerp(0.5f, 1f, alpha);
        floatingTopicSeparator.setScaleX(scale);
        floatingTopicSeparator.setScaleY(scale);
    }

    private void hideFloatingTopicView(boolean animated) {
        if (floatingTopicSeparator.getTag() != null && !currentFloatingTopicOnScreen && (!scrollingFloatingTopic || currentFloatingTopIsNotMessage)) {
            floatingTopicSeparator.setTag(null);
            if (animated) {
                floatingTopicAnimation = ValueAnimator.ofFloat(floatingTopicViewAlpha, 0.0f);
                floatingTopicAnimation.setDuration(150);
                floatingTopicAnimation.addUpdateListener(anm -> {
                    floatingTopicViewAlpha = (float) anm.getAnimatedValue();
                    updateFloatingTopicView();
                });
                floatingTopicAnimation.addListener(new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        if (animation.equals(floatingTopicAnimation)) {
                            floatingTopicViewAlpha = 0.0f;
                            updateFloatingTopicView();
                            floatingTopicAnimation = null;
                        }
                    }
                });
                floatingTopicAnimation.setStartDelay(hideDateDelay);
                floatingTopicAnimation.start();
            } else {
                if (floatingTopicAnimation != null) {
                    floatingTopicAnimation.cancel();
                    floatingTopicAnimation = null;
                }
                floatingTopicViewAlpha = 0.0f;
                updateFloatingTopicView();
            }
            hideDateDelay = 500;
        }
    }

    private boolean removingFromParent;
    @Override
    public void onRemoveFromParent() {
        removingFromParent = true;
        MessageObject messageObject = MediaController.getInstance().getPlayingMessageObject();
        if (messageObject != null && messageObject.isVideo()) {
            MediaController.getInstance().cleanupPlayer(true, true);
        } else {
            MediaController.getInstance().setTextureView(videoTextureView, null, null, false);
        }
        if (starReactionsOverlay != null) {
            starReactionsOverlay.setMessageCell(null);
            AndroidUtilities.removeFromParent(starReactionsOverlay);
            starReactionsOverlay = null;
        }
        super.onRemoveFromParent();
    }

    protected void setIgnoreAttachOnPause(boolean value) {
        ignoreAttachOnPause = value;
    }

    public ChatActivityEnterView getChatActivityEnterViewForStickers() {
        return bottomChannelButtonsLayout.getVisibility() != View.VISIBLE && (currentChat == null || ChatObject.canSendStickers(currentChat)) ? chatActivityEnterView : null;
    }

    public ChatActivityEnterView getChatActivityEnterView() {
        return chatActivityEnterView;
    }

    public boolean isKeyboardVisible() {
        return contentView.getKeyboardHeight() > AndroidUtilities.dp(20);
    }

    private void checkScrollForLoad(boolean scroll) {
        if (chatLayoutManager == null || paused || chatAdapter.isFrozen || waitingForGetDifference) {
            return;
        }
        int firstVisibleItem = RecyclerListView.NO_POSITION;
        int lastVisibleItem = RecyclerListView.NO_POSITION;
        int visibleItemCount = 0;
        for (int i = 0; i < chatListView.getChildCount(); i++) {
            int position = chatListView.getChildAdapterPosition(chatListView.getChildAt(i));
            if (position != RecyclerListView.NO_POSITION) {
                if (firstVisibleItem == RecyclerListView.NO_POSITION || position < firstVisibleItem) {
                    firstVisibleItem = position;
                }
                if (lastVisibleItem == RecyclerListView.NO_POSITION || position > lastVisibleItem) {
                    lastVisibleItem = position;
                }
                visibleItemCount++;
            }
        }
        if (chatAdapter.isFiltered) {
            if (chatAdapter.loadingUpRow >= 0 && firstVisibleItem >= 0 && chatAdapter.loadingUpRow >= firstVisibleItem && chatAdapter.loadingUpRow <= lastVisibleItem) {
                getMediaDataController().loadMoreSearchMessages(false);
            }
            return;
        }
        final int firstVisibleItemFinal = firstVisibleItem;
        final int visibleItemCountFinal = visibleItemCount;
        int totalItemCount = chatAdapter.getItemCount();
        int checkLoadCount;
        if (scroll) {
            checkLoadCount = 25;
        } else {
            checkLoadCount = 5;
        }

        if (chatMode == MODE_SEARCH) {
            if (totalItemCount - firstVisibleItemFinal - visibleItemCountFinal <= checkLoadCount && !loading) {
                if (!endReached[0]) {
                    loading = true;
                    waitingForLoad.add(lastLoadIndex);
                    HashtagSearchController.getInstance(currentAccount).searchHashtag(searchingHashtag, classGuid, searchType, lastLoadIndex++);
                }
            }

            return;
        }

        AndroidUtilities.runOnUIThread(() -> {
            if (totalItemCount - firstVisibleItemFinal - visibleItemCountFinal <= checkLoadCount && !loading) {
                if (!endReached[0]) {
                    loading = true;
                    waitingForLoad.add(lastLoadIndex);
                    if (messagesByDays.size() != 0) {
                        getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 50, maxMessageId[0], 0, !cacheEndReached[0], minDate[0], classGuid, 0, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                    } else {
                        getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 50, 0, 0, !cacheEndReached[0], minDate[0], classGuid, 0, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                    }
                } else if (mergeDialogId != 0 && !endReached[1]) {
                    loading = true;
                    waitingForLoad.add(lastLoadIndex);
                    getMessagesController().loadMessages(mergeDialogId, 0, false, 50, maxMessageId[1], 0, !cacheEndReached[1], minDate[1], classGuid, 0, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                }
            }
            if (visibleItemCountFinal > 0 && !loadingForward && firstVisibleItemFinal <= 10) {
                if (mergeDialogId != 0 && !forwardEndReached[1]) {
                    waitingForLoad.add(lastLoadIndex);
                    getMessagesController().loadMessages(mergeDialogId, 0, false, 50, minMessageId[1], 0, true, maxDate[1], classGuid, 1, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                    loadingForward = true;
                } else if (!forwardEndReached[0]) {
                    waitingForLoad.add(lastLoadIndex);
                    getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 50, minMessageId[0], 0, true, maxDate[0], classGuid, 1, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
                    loadingForward = true;
                }
            }
        });
    }

    private void processSelectedAttach(int which) {
        if (which == attach_photo) {
            if (Build.VERSION.SDK_INT >= 23 && getParentActivity().checkSelfPermission(Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
                getParentActivity().requestPermissions(new String[]{Manifest.permission.CAMERA}, 19);
                return;
            }
            try {
                Intent takePictureIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
                File image = AndroidUtilities.generatePicturePath();
                if (image != null) {
                    if (Build.VERSION.SDK_INT >= 24) {
                        takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT, FileProvider.getUriForFile(getParentActivity(), ApplicationLoader.getApplicationId() + ".provider", image));
                        takePictureIntent.addFlags(Intent.FLAG_GRANT_WRITE_URI_PERMISSION);
                        takePictureIntent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
                    } else {
                        takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT, Uri.fromFile(image));
                    }
                    currentPicturePath = image.getAbsolutePath();
                }
                startActivityForResult(takePictureIntent, 0);
            } catch (Exception e) {
                FileLog.e(e);
            }
        } else if (which == attach_gallery) {
            final Activity activity = getParentActivity();
            if (Build.VERSION.SDK_INT >= 33) {
                if (activity.checkSelfPermission(Manifest.permission.READ_MEDIA_IMAGES) != PackageManager.PERMISSION_GRANTED) {
                    try {
                        getParentActivity().requestPermissions(new String[]{Manifest.permission.READ_MEDIA_IMAGES, Manifest.permission.READ_MEDIA_VIDEO}, BasePermissionsActivity.REQUEST_CODE_EXTERNAL_STORAGE);
                    } catch (Throwable ignore) {}
                    return;
                }
            } else if (Build.VERSION.SDK_INT >= 23) {
                if (activity.checkSelfPermission(Manifest.permission.READ_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
                    try {
                        getParentActivity().requestPermissions(new String[]{Manifest.permission.READ_EXTERNAL_STORAGE}, BasePermissionsActivity.REQUEST_CODE_EXTERNAL_STORAGE);
                    } catch (Throwable ignore) {}
                    return;
                }
            }
            boolean allowGifs;
            if (ChatObject.isChannel(currentChat) && currentChat.banned_rights != null && currentChat.banned_rights.send_gifs) {
                allowGifs = false;
            } else {
                allowGifs = true;
            }
            PhotoAlbumPickerActivity fragment = new PhotoAlbumPickerActivity(PhotoAlbumPickerActivity.SELECT_TYPE_ALL, allowGifs, true, ChatActivity.this);
            if (currentChat != null && !ChatObject.hasAdminRights(currentChat) && currentChat.slowmode_enabled) {
                fragment.setMaxSelectedPhotos(10, true);
            } else {
                fragment.setMaxSelectedPhotos(editingMessageObject != null ? 1 : 0, editingMessageObject == null);
            }
            fragment.setDelegate(new PhotoAlbumPickerActivity.PhotoAlbumPickerActivityDelegate() {
                @Override
                public void didSelectPhotos(ArrayList<SendMessagesHelper.SendingMediaInfo> photos, boolean notify, int scheduleDate) {

                }

                @Override
                public void startPhotoSelectActivity() {
                    try {
                        Intent videoPickerIntent = new Intent();
                        videoPickerIntent.setType("video/*");
                        videoPickerIntent.setAction(Intent.ACTION_GET_CONTENT);
                        videoPickerIntent.putExtra(MediaStore.EXTRA_SIZE_LIMIT, FileLoader.DEFAULT_MAX_FILE_SIZE);

                        Intent photoPickerIntent = new Intent(Intent.ACTION_PICK);
                        photoPickerIntent.setType("image/*");
                        Intent chooserIntent = Intent.createChooser(photoPickerIntent, null);
                        chooserIntent.putExtra(Intent.EXTRA_INITIAL_INTENTS, new Intent[]{videoPickerIntent});

                        startActivityForResult(chooserIntent, 1);
                    } catch (Exception e) {
                        FileLog.e(e);
                    }
                }
            });
            presentFragment(fragment);
        } else if (which == attach_video) {
            if (Build.VERSION.SDK_INT >= 23 && getParentActivity().checkSelfPermission(Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
                try {
                    getParentActivity().requestPermissions(new String[]{Manifest.permission.CAMERA}, BasePermissionsActivity.REQUEST_CODE_OPEN_CAMERA);
                } catch (Throwable ignore) {

                }
                return;
            }
            try {
                Intent takeVideoIntent = new Intent(MediaStore.ACTION_VIDEO_CAPTURE);
                File video = AndroidUtilities.generateVideoPath();
                if (video != null) {
                    if (Build.VERSION.SDK_INT >= 24) {
                        takeVideoIntent.putExtra(MediaStore.EXTRA_OUTPUT, FileProvider.getUriForFile(getParentActivity(), ApplicationLoader.getApplicationId() + ".provider", video));
                        takeVideoIntent.addFlags(Intent.FLAG_GRANT_WRITE_URI_PERMISSION);
                        takeVideoIntent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
                    } else {
                        takeVideoIntent.putExtra(MediaStore.EXTRA_OUTPUT, Uri.fromFile(video));
                    }
                    takeVideoIntent.putExtra(MediaStore.EXTRA_SIZE_LIMIT, FileLoader.DEFAULT_MAX_FILE_SIZE);
                    currentPicturePath = video.getAbsolutePath();
                }
                startActivityForResult(takeVideoIntent, 2);
            } catch (Exception e) {
                FileLog.e(e);
            }
        }
    }

    public boolean allowSendGifs() {
        if (ChatObject.isChannel(currentChat) && currentChat.banned_rights != null && currentChat.banned_rights.send_gifs) {
            return false;
        } else {
            return true;
        }
    }

    public void openPollCreate(Boolean quiz) {
        PollCreateActivity pollCreateActivity = new PollCreateActivity(ChatActivity.this, false, quiz);
        pollCreateActivity.setDelegate((poll, params, notify, scheduleDate) -> {
            if (checkSlowModeAlert()) {
                SendMessagesHelper.SendMessageParams params2 = SendMessagesHelper.SendMessageParams.of(poll, dialog_id, replyingMessageObject, getThreadMessage(), null, params, notify, scheduleDate, 0);
                params2.quick_reply_shortcut = quickReplyShortcut;
                params2.quick_reply_shortcut_id = getQuickReplyId();
                getSendMessagesHelper().sendMessage(params2);
                afterMessageSend();
            }
        });
        presentFragment(pollCreateActivity);
    }

    @Override
    public void didSelectFiles(ArrayList<String> files, String caption, ArrayList<TLRPC.MessageEntity> captionEntities, ArrayList<MessageObject> fmessages, boolean notify, int scheduleDate, int scheduleRepeatPeriod, long effectId, boolean invertMedia, long payStars) {
        fillEditingMediaWithCaption(caption, null);
        if (checkSlowModeAlert()) {
            if (!fmessages.isEmpty() && !TextUtils.isEmpty(caption)) {
                SendMessagesHelper.SendMessageParams params = SendMessagesHelper.SendMessageParams.of(caption, dialog_id, null, null, null, true, captionEntities, null, null, true, 0, 0, null, false);
                params.quick_reply_shortcut = quickReplyShortcut;
                params.quick_reply_shortcut_id = getQuickReplyId();
                params.invert_media = invertMedia;
                params.payStars = payStars;
                params.monoForumPeer = getSendMonoForumPeerId();
                params.suggestionParams = messageSuggestionParams;
                SendMessagesHelper.getInstance(currentAccount).sendMessage(params);
                caption = null;
            }
            getSendMessagesHelper().sendMessage(fmessages, dialog_id, false, false, true, 0, null, -1, payStars, getSendMonoForumPeerId(), getSendMessageSuggestionParams());
            SendMessagesHelper.prepareSendingDocuments(getAccountInstance(), files, files, null, caption, captionEntities, null, dialog_id, replyingMessageObject, getThreadMessage(), null, replyingQuote, editingMessageObject, notify, scheduleDate, scheduleRepeatPeriod, null, quickReplyShortcut, getQuickReplyId(), effectId, invertMedia, payStars, getSendMonoForumPeerId(), getSendMessageSuggestionParams());
            afterMessageSend();
        }
    }

    @Override
    public void didSelectPhotos(ArrayList<SendMessagesHelper.SendingMediaInfo> photos, boolean notify, int scheduleDate, int scheduleRepeatPeriod, long payStars) {
        fillEditingMediaWithCaption(photos.get(0).caption, photos.get(0).entities);
        SendMessagesHelper.prepareSendingMedia(getAccountInstance(), photos, dialog_id, replyingMessageObject, getThreadMessage(), null, replyingQuote, true, true, editingMessageObject, notify, scheduleDate, scheduleRepeatPeriod, chatMode, photos.get(0).updateStickersOrder, null, quickReplyShortcut, getQuickReplyId(), 0, false, payStars, getSendMonoForumPeerId(), getSendMessageSuggestionParams());
        afterMessageSend();
        if (scheduleDate != 0) {
            if (scheduledMessagesCount == -1) {
                scheduledMessagesCount = 0;
            }
            scheduledMessagesCount += photos.size();
            updateScheduledInterface(true);
        }
    }

    public void didSelectSearchPhotos(ArrayList<SendMessagesHelper.SendingMediaInfo> photos, boolean notify, int scheduleDate) {
        if (photos.isEmpty()) {
            return;
        }
        if (!checkSlowModeAlert()) {
            return;
        }
        boolean hasNoGifs = false;
        for (int a = 0; a < photos.size(); a++) {
            SendMessagesHelper.SendingMediaInfo info = photos.get(a);
            if (info.inlineResult == null && info.videoEditedInfo == null) {
                hasNoGifs = true;
                break;
            }
        }
        if (!hasNoGifs && !TextUtils.isEmpty(photos.get(0).caption)) {
            SendMessagesHelper.SendMessageParams params = SendMessagesHelper.SendMessageParams.of(photos.get(0).caption, dialog_id, replyingMessageObject, getThreadMessage(), null, false, photos.get(0).entities, null, null, notify, scheduleDate, 0, null, false);
            params.quick_reply_shortcut = quickReplyShortcut;
            params.quick_reply_shortcut_id = getQuickReplyId();
            SendMessagesHelper.getInstance(currentAccount).sendMessage(params);
        }
        for (int a = 0; a < photos.size(); a++) {
            SendMessagesHelper.SendingMediaInfo info = photos.get(a);
            if (info.inlineResult != null && info.videoEditedInfo == null) {
                SendMessagesHelper.prepareSendingBotContextResult(this, getAccountInstance(), info.inlineResult, info.params, dialog_id, replyingMessageObject, getThreadMessage(), null, replyingQuote, notify, scheduleDate, 0, quickReplyShortcut, getQuickReplyId(), 0);
                photos.remove(a);
                a--;
            }
        }
        if (photos.isEmpty()) {
            return;
        }
        fillEditingMediaWithCaption(photos.get(0).caption, photos.get(0).entities);
        SendMessagesHelper.prepareSendingMedia(getAccountInstance(), photos, dialog_id, replyingMessageObject, getThreadMessage(), null, replyingQuote, false, true, editingMessageObject, notify, scheduleDate, 0, chatMode, photos.get(0).updateStickersOrder, null, quickReplyShortcut, getQuickReplyId(), 0, false, 0, getSendMonoForumPeerId(), messageSuggestionParams);
        afterMessageSend();
        if (scheduleDate != 0) {
            if (scheduledMessagesCount == -1) {
                scheduledMessagesCount = 0;
            }
            scheduledMessagesCount += photos.size();
            updateScheduledInterface(true);
        }
    }

    @Override
    public void startDocumentSelectActivity() {
        try {
            Intent photoPickerIntent = new Intent(Intent.ACTION_GET_CONTENT);
            photoPickerIntent.putExtra(Intent.EXTRA_ALLOW_MULTIPLE, true);
            photoPickerIntent.setType("*/*");
            startActivityForResult(photoPickerIntent, 21);
        } catch (Exception e) {
            FileLog.e(e);
        }
    }

    @Override
    public boolean dismissDialogOnPause(Dialog dialog) {
        return dialog != chatAttachAlert && dialog != chatThemeBottomSheet && !(dialog instanceof BotWebViewSheet) && super.dismissDialogOnPause(dialog);
    }

    int waitingForWebpageId;
    private void cancelSearchLinks() {
        if (linkSearchRequestId != 0) {
            getConnectionsManager().cancelRequest(linkSearchRequestId, true);
        }
    }

    private void editResetMediaManual() {
        if (editingMessageObject != null && editingMessageObject.messageOwner != null && editingMessageObject.messageOwner.media != null) {
            editingMessageObject.messageOwner.media.manual = false;
        }
    }

    public void checkEditLinkRemoved(final CharSequence charSequence) {
        final boolean manual = editingMessageObject != null && editingMessageObject.messageOwner != null && editingMessageObject.messageOwner.media != null && editingMessageObject.messageOwner.media.webpage != null && !(editingMessageObject.messageOwner.media.webpage instanceof TLRPC.TL_webPageEmpty) && editingMessageObject.messageOwner.media.manual;
        if (messagePreviewParams != null && editingMessageObject != null && (editingMessageObject.type == MessageObject.TYPE_TEXT || editingMessageObject.type == MessageObject.TYPE_EMOJIS) && foundWebPage != null) {
            if (messagePreviewParams.hasLink(charSequence, foundWebPage.url)) {
                return;
            }
            if (manual) {
                foundWebPage = null;
                if (chatActivityEnterView != null) {
                    chatActivityEnterView.setWebPage(null, true);
                }
                if (messagePreviewParams != null) {
                    messagePreviewParams.updateLink(currentAccount, null, chatActivityEnterView.getFieldText(), replyingMessageObject == threadMessageObject ? null : replyingMessageObject, replyingQuote, editingMessageObject);
                }
                editResetMediaManual();
                fallbackFieldPanel();
            }
        }
    }

    public void searchLinks(final CharSequence charSequence, final boolean force) {
        if (currentEncryptedChat != null && getMessagesController().secretWebpagePreview == 0 || editingMessageObject != null && (!editingMessageObject.isWebpage() || editingMessageObject.messageOwner.media.webpage instanceof TLRPC.TL_webPagePending)) {
            return;
        }
        if (currentChat != null && !ChatObject.canSendEmbed(currentChat)) {
            if (foundWebPage != null) {
                foundWebPage = null;
                if (chatActivityEnterView != null) {
                    chatActivityEnterView.setWebPage(null, true);
                }
                fallbackFieldPanel();
                editResetMediaManual();
            }
            return;
        }
        checkEditLinkRemoved(charSequence);
        if (force && foundWebPage != null) {
            if (foundWebPage.url != null) {
                int index = TextUtils.indexOf(charSequence, foundWebPage.url);
                char lastChar = 0;
                boolean lenEqual = false;
                if (index == -1) {
                    if (foundWebPage.display_url != null) {
                        index = TextUtils.indexOf(charSequence, foundWebPage.display_url);
                        lenEqual = index != -1 && index + foundWebPage.display_url.length() == charSequence.length();
                        lastChar = index != -1 && !lenEqual ? charSequence.charAt(index + foundWebPage.display_url.length()) : 0;
                    }
                } else {
                    lenEqual = index + foundWebPage.url.length() == charSequence.length();
                    lastChar = !lenEqual ? charSequence.charAt(index + foundWebPage.url.length()) : 0;
                }
                if (index != -1 && (lenEqual || lastChar == ' ' || lastChar == ',' || lastChar == '.' || lastChar == '!' || lastChar == '/')) {
                    if (messagePreviewParams != null) {
                        messagePreviewParams.updateLink(currentAccount, foundWebPage, chatActivityEnterView.getFieldText(), replyingMessageObject == threadMessageObject ? null : replyingMessageObject, replyingQuote, editingMessageObject);
                    }
                    return;
                }
            }
            pendingLinkSearchString = null;
            foundUrls = null;
            foundWebPage = null;
            if (chatActivityEnterView != null) {
                chatActivityEnterView.setWebPage(null, true);
            }
            fallbackFieldPanel();
            editResetMediaManual();
        }
        final MessagesController messagesController = getMessagesController();
        Utilities.searchQueue.postRunnable(() -> {
            boolean requestAnyway = false;
            if (linkSearchRequestId != 0) {
                getConnectionsManager().cancelRequest(linkSearchRequestId, true);
                linkSearchRequestId = 0;
                requestAnyway = true;
            }
            ArrayList<CharSequence> urls = null;
            CharSequence textToCheck;
            try {
                Matcher m = AndroidUtilities.WEB_URL.matcher(charSequence);
                while (m.find()) {
                    if (m.start() > 0) {
                        if (charSequence.charAt(m.start() - 1) == '@') {
                            continue;
                        }
                    }
                    if (urls == null) {
                        urls = new ArrayList<>();
                    }
                    urls.add(charSequence.subSequence(m.start(), m.end()));
                }
                if (charSequence instanceof Spannable) {
                    URLSpanReplacement[] spans = ((Spannable) charSequence).getSpans(0, charSequence.length(), URLSpanReplacement.class);
                    if (spans != null && spans.length > 0) {
                        if (urls == null) {
                            urls = new ArrayList<>();
                        }
                        for (int a = 0; a < spans.length; a++) {
                            urls.add(spans[a].getURL());
                        }
                    }
                }
                if (urls != null && foundUrls != null && urls.size() == foundUrls.size()) {
                    boolean clear = true;
                    for (int a = 0; a < urls.size(); a++) {
                        if (!TextUtils.equals(urls.get(a), foundUrls.get(a))) {
                            clear = false;
                        }
                    }
                    if (clear && !requestAnyway) {
                        return;
                    }
                }
                foundUrls = urls;
                if (urls == null) {
                    AndroidUtilities.runOnUIThread(() -> {
                        foundWebPage = null;
                        fallbackFieldPanel();
                    });
                    return;
                }
                textToCheck = TextUtils.join(" ", urls);
            } catch (Exception e) {
                FileLog.e(e);
                String text = charSequence.toString().toLowerCase();
                if (charSequence.length() < 13 || !text.contains("http://") && !text.contains("https://")) {
                    AndroidUtilities.runOnUIThread(() -> {
                        foundWebPage = null;
                        fallbackFieldPanel();
                    });
                    return;
                }
                textToCheck = charSequence;
            }
            final String firstUrl = urls == null || urls.isEmpty() ? null : urls.get(0).toString();

            if (currentEncryptedChat != null && messagesController.secretWebpagePreview == 2) {
                AndroidUtilities.runOnUIThread(() -> {
                    AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                    builder.setTitle(LocaleController.getString(R.string.AppName));
                    builder.setPositiveButton(LocaleController.getString(R.string.OK), (dialog, which) -> {
                        messagesController.secretWebpagePreview = 1;
                        MessagesController.getGlobalMainSettings().edit().putInt("secretWebpage2", getMessagesController().secretWebpagePreview).commit();
                        foundUrls = null;
                        searchLinks(charSequence, force);
                    });
                    builder.setNegativeButton(LocaleController.getString(R.string.Cancel), null);
                    builder.setMessage(LocaleController.getString(R.string.SecretLinkPreviewAlert));
                    showDialog(builder.create());

                    messagesController.secretWebpagePreview = 0;
                    MessagesController.getGlobalMainSettings().edit().putInt("secretWebpage2", messagesController.secretWebpagePreview).commit();
                });
                return;
            }

            final TL_account.getWebPagePreview req = new TL_account.getWebPagePreview();
            if (textToCheck instanceof String) {
                req.message = (String) textToCheck;
            } else {
                req.message = textToCheck.toString();
            }
            if (foundWebPage != null && req.message.equals(foundWebPage.displayedText)) {
                return;
            }
            final int myId = ++waitingForWebpageId;
            requestLinkPreviewCached(req, (success, webpage) -> AndroidUtilities.runOnUIThread(() -> {
                if (waitingForWebpageId != myId) {
                    return;
                }
                if (success) {
                    foundWebPage = webpage;
                    foundWebPage.display_url = req.message;
                    if (foundWebPage instanceof TLRPC.TL_webPage || foundWebPage instanceof TLRPC.TL_webPagePending) {
                        if (foundWebPage instanceof TLRPC.TL_webPagePending) {
                            pendingLinkSearchString = req.message;
                        }
                        if (currentEncryptedChat != null && foundWebPage instanceof TLRPC.TL_webPagePending) {
                            foundWebPage.url = req.message;
                        }
                        if (messagePreviewParams != null) {
                            messagePreviewParams.updateLink(currentAccount, null, chatActivityEnterView.getFieldText(), replyingMessageObject == threadMessageObject ? null : replyingMessageObject, replyingQuote, editingMessageObject);
                        }
                        showFieldPanelForWebPage(true, foundWebPage, false);
                    } else {
                        if (foundWebPage != null) {
                            foundWebPage = null;
                            if (messagePreviewParams != null) {
                                messagePreviewParams.updateLink(currentAccount, null, chatActivityEnterView.getFieldText(), replyingMessageObject == threadMessageObject ? null : replyingMessageObject, replyingQuote, editingMessageObject);
                            }
                            fallbackFieldPanel();
                        }
                    }
                } else {
                    foundWebPage = null;
                    fallbackFieldPanel();
                }
            }));
        });
    }

    private HashMap<String, TLRPC.WebPage> lastLinkPreviewResults;

    private void requestLinkPreviewCached(TL_account.getWebPagePreview req, Utilities.Callback2<Boolean, TLRPC.WebPage> done) {
        if (lastLinkPreviewResults == null) {
            lastLinkPreviewResults = new HashMap<>();
        }
        TLRPC.WebPage result = lastLinkPreviewResults.get(req.message);
        if (result != null) {
            done.run(true, result);
        } else {
            requestLinkPreview(req, (success, webpage) -> {
                if (success && !(webpage instanceof TLRPC.TL_webPagePending)) {
                    Iterator<String> keys = lastLinkPreviewResults.keySet().iterator();
                    while (keys.hasNext() && lastLinkPreviewResults.size() > 5) {
                        keys.next();
                        keys.remove();
                    }
                    lastLinkPreviewResults.put(req.message, webpage);
                }
                done.run(success, webpage);
            });
        }
    }

    private void requestLinkPreview(TL_account.getWebPagePreview req, Utilities.Callback2<Boolean, TLRPC.WebPage> done) {
        cancelSearchLinks();
        linkSearchRequestId = getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> {
            linkSearchRequestId = 0;
            TLRPC.TL_messageMediaWebPage media = null;
            if (response instanceof TL_account.webPagePreview) {
                final TL_account.webPagePreview preview = (TL_account.webPagePreview) response;
                getMessagesController().putUsers(preview.users, false);
                getMessagesController().putChats(preview.chats, false);
                if (preview.media instanceof TLRPC.TL_messageMediaWebPage) {
                    media = (TLRPC.TL_messageMediaWebPage) preview.media;
                }
            }
            if (media != null) {
                if (media.webpage != null && "telegram_story".equals(media.webpage.type)) {
                    TLRPC.TL_webPageAttributeStory _attrStory = null;
                    if (media.webpage.attributes != null) {
                        for (int i = 0; i < media.webpage.attributes.size(); ++i) {
                            if (media.webpage.attributes.get(i) instanceof TLRPC.TL_webPageAttributeStory) {
                                _attrStory = (TLRPC.TL_webPageAttributeStory) media.webpage.attributes.get(i);
                                break;
                            }
                        }
                    }
                    if (_attrStory == null) {
                        done.run(false, null);
                        return;
                    }
                    if (_attrStory != null && _attrStory.storyItem != null) {
                        done.run(true, media.webpage);
                        return;
                    }
                    final TLRPC.TL_webPageAttributeStory attrStory = _attrStory;
                    final TLRPC.TL_messageMediaWebPage finalMedia = media;
                    getMessagesStorage().getStorageQueue().postRunnable(() -> {
                        try {
                            LongSparseArray<ArrayList<MessageObject>> array = new LongSparseArray<>();
                            TLRPC.TL_message message = new TLRPC.TL_message();
                            message.message = "";
                            message.id = 0;
                            message.media = finalMedia;
                            ArrayList<MessageObject> list = new ArrayList<>();
                            list.add(new MessageObject(currentAccount, message, false, false));
                            array.put(DialogObject.getPeerDialogId(attrStory.peer), list);
                            getMessagesController().getStoriesController().getStoriesStorage().fillMessagesWithStories(array, () -> {
                                MessageObject result = null;
                                if (array.size() == 1 && array.valueAt(0) != null && array.valueAt(0).size() == 1) {
                                    result = array.valueAt(0).get(0);
                                }
                                if (result != null && result.messageOwner != null && result.messageOwner.media != null && result.messageOwner.media.webpage != null && result.messageOwner.media.webpage.attributes != null) {
                                    for (int i = 0; i < result.messageOwner.media.webpage.attributes.size(); ++i) {
                                        TLRPC.WebPageAttribute attr = result.messageOwner.media.webpage.attributes.get(i);
                                        if (attr instanceof TLRPC.TL_webPageAttributeStory) {
                                            if (((TLRPC.TL_webPageAttributeStory) attr).storyItem != null) {
                                                final TLRPC.WebPage webpage = result.messageOwner.media.webpage;
                                                AndroidUtilities.runOnUIThread(() -> { done.run(true, webpage); });
                                                return;
                                            }
                                        }
                                    }
                                }
                                AndroidUtilities.runOnUIThread(() -> { done.run(false, null); });
                            }, classGuid, false, null);
                        } catch (Exception ignore) {}
                    });
                } else {
                    done.run(media.webpage != null, media.webpage);
                }
            } else {
                done.run(false, null);
            }
        }));

        getConnectionsManager().bindRequestToGuid(linkSearchRequestId, classGuid);
    }

    private void forwardMessages(ArrayList<MessageObject> arrayList, boolean fromMyName, boolean hideCaption, boolean notify, int scheduleDate, long payStars) {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        if (!checkSlowModeAlert()) {
            return;
        }
        if ((scheduleDate != 0) == (chatMode == MODE_SCHEDULED)) {
            waitingForSendingMessageLoad = true;
        }
        int result = getSendMessagesHelper().sendMessage(arrayList, dialog_id, fromMyName, hideCaption, notify, scheduleDate, getThreadMessage(), -1, payStars, getSendMonoForumPeerId(), getSendMessageSuggestionParams());
        AlertsCreator.showSendMediaAlert(result, this, themeDelegate);
        if (result != 0) {
            AndroidUtilities.runOnUIThread(() -> {
                waitingForSendingMessageLoad = false;
                hideFieldPanel(true);
            });
        }
    }

    public boolean shouldShowImport() {
        return openImport;
    }

    public void setOpenImport() {
        openImport = true;
    }

    private void checkBotKeyboard() {
        if (chatActivityEnterView == null || botButtons == null || userBlocked) {
            return;
        }
        if (botButtons.messageOwner.reply_markup instanceof TLRPC.TL_replyKeyboardForceReply) {
            SharedPreferences preferences = MessagesController.getMainSettings(currentAccount);
            String tk = isTopic ? dialog_id + "_" + getTopicId() : "" + dialog_id;
            if (preferences.getInt("answered_" + tk, 0) != botButtons.getId() && (replyingMessageObject == null || chatActivityEnterView.getFieldText() == null)) {
                botReplyButtons = botButtons;
                chatActivityEnterView.setButtons(botButtons);
                showFieldPanelForReply(botButtons);
            }
        } else {
            if (replyingMessageObject != null && botReplyButtons == replyingMessageObject) {
                botReplyButtons = null;
                hideFieldPanel(true);
            }
            chatActivityEnterView.setButtons(botButtons);
        }
    }

    public static class ReplyQuote {
        public final long peerId;
        public MessageObject message;
        public int start, end;
        public int task_id;
        public boolean outdated;
        public boolean todo;

        public String text;
        public ArrayList<TLRPC.MessageEntity> entities;
        public int offset, length;

        public TLRPC.TodoItem task;

        private ReplyQuote(long peerId, @NonNull MessageObject message, int start, int end) {
            this.peerId = peerId;
            this.message = message;
            this.start = start;
            this.end = end;
            this.todo = false;
            this.task_id = -1;

            update();
        }

        private ReplyQuote(long peerId, @NonNull MessageObject message, int task_id) {
            this.peerId = peerId;
            this.message = message;
            this.start = -1;
            this.end = -1;
            this.todo = true;
            this.task_id = task_id;

            update();
        }

        public static ReplyQuote from(MessageObject messageObject, String text, int offset) {
            if (messageObject == null || messageObject.messageOwner == null || messageObject.messageOwner.message == null || text == null) {
                return null;
            }
            int start = MessageObject.findQuoteStart(messageObject.messageOwner.message, text, offset);
            if (start < 0) {
                return null;
            }
            return new ReplyQuote(
                messageObject.getDialogId(),
                messageObject,
                start, start + text.length()
            );
        }

        public static ReplyQuote from(MessageObject messageObject, int task_id) {
            if (messageObject == null || messageObject.messageOwner == null || !(messageObject.messageOwner.media instanceof TLRPC.TL_messageMediaToDo)) {
                return null;
            }
            return new ReplyQuote(
                messageObject.getDialogId(),
                messageObject,
                task_id
            );
        }

        public static ReplyQuote from(MessageObject messageObject) {
            if (messageObject == null || messageObject.messageOwner == null || messageObject.messageOwner.message == null) {
                return null;
            }
            return from(messageObject, 0, Math.min(MessagesController.getInstance(messageObject.currentAccount).quoteLengthMax, messageObject.messageOwner.message.length()));
        }

        public static ReplyQuote from(MessageObject messageObject, int start, int end) {
            if (messageObject == null) {
                return null;
            }
            return new ReplyQuote(
                messageObject.getDialogId(),
                messageObject,
                start, end
            );
        }

        private boolean update() {
            if (message == null || message.messageOwner == null || message.messageOwner.message == null) {
                FileLog.e("ReplyQuote: message is null");
                return false;
            }
            if (todo) {
                final TLRPC.TodoItem foundItem = MessageObject.findTodoItem(message, task_id);
                if (foundItem == null) {
                    FileLog.e("ReplyQuote: todo task is not found");
                    return false;
                }

                task = foundItem;
                return true;
            } else {
                if (end < start || end > message.messageOwner.message.length() || start > message.messageOwner.message.length() || start < 0 || end < 0) {
                    FileLog.e("ReplyQuote: start/end are invalid (" + start + ", " + end + ", len=" + message.messageOwner.message.length() + ")");
                    return false;
                }
                final String fulltext = message.messageOwner.message;
                int realStart = Math.max(0, start);
                while (realStart < end && Character.isWhitespace(fulltext.charAt(realStart)))
                    realStart++;
                int realEnd = Math.min(end, fulltext.length());
                while (realEnd > realStart && Character.isWhitespace(fulltext.charAt(realEnd - 1)))
                    realEnd--;
                if (realStart == realEnd) {
                    FileLog.e("ReplyQuote: message is full of whitespace");
                    return false;
                }
                text = message.messageOwner.message.substring(realStart, realEnd);
                if (entities != null) {
                    entities.clear();
                }
                if (message.messageOwner.entities != null && !message.messageOwner.entities.isEmpty()) {
                    for (int i = 0; i < message.messageOwner.entities.size(); ++i) {
                        TLRPC.MessageEntity entity = message.messageOwner.entities.get(i);
                        if (!AndroidUtilities.intersect1dInclusive(realStart, realEnd, entity.offset, entity.offset + entity.length)) {
                            continue;
                        }

                        TLRPC.MessageEntity newEntity;
                        if (entity instanceof TLRPC.TL_messageEntityBold) {
                            newEntity = new TLRPC.TL_messageEntityBold();
                        } else if (entity instanceof TLRPC.TL_messageEntityItalic) {
                            newEntity = new TLRPC.TL_messageEntityItalic();
                        } else if (entity instanceof TLRPC.TL_messageEntityUnderline) {
                            newEntity = new TLRPC.TL_messageEntityUnderline();
                        } else if (entity instanceof TLRPC.TL_messageEntityStrike) {
                            newEntity = new TLRPC.TL_messageEntityStrike();
                        } else if (entity instanceof TLRPC.TL_messageEntitySpoiler) {
                            newEntity = new TLRPC.TL_messageEntitySpoiler();
                        } else if (entity instanceof TLRPC.TL_messageEntityCustomEmoji) {
                            newEntity = new TLRPC.TL_messageEntityCustomEmoji();
                            ((TLRPC.TL_messageEntityCustomEmoji) newEntity).document_id = ((TLRPC.TL_messageEntityCustomEmoji) entity).document_id;
                            ((TLRPC.TL_messageEntityCustomEmoji) newEntity).document = ((TLRPC.TL_messageEntityCustomEmoji) entity).document;
                        } else {
                            continue;
                        }

                        int entityStart = entity.offset - realStart;
                        int entityEnd = entity.offset + entity.length - realStart;
                        if (entityStart < 0 && entityEnd < 0 || entityStart > realEnd && entityEnd > realEnd) {
                            continue;
                        }

                        newEntity.offset = Math.max(0, entityStart);
                        newEntity.length = Math.min(entityEnd, realEnd - realStart) - newEntity.offset;

                        if (entities == null) {
                            entities = new ArrayList<>();
                        }
                        entities.add(newEntity);
                    }
                }

                offset = realStart;
                length = realEnd - realStart;
                return true;
            }
        }

        // returns whether quote alert should be shown
        public boolean checkEdit(MessageObject message) {
            if (message == null || message.messageOwner == null || message.messageOwner.message == null) {
                FileLog.e("ReplyQuote.checkEdit: message is null");
                return outdated = false;
            }
            if (end < start || end > message.messageOwner.message.length() || start > message.messageOwner.message.length() || start < 0 || end < 0) {
                FileLog.e("ReplyQuote.checkEdit: start/end are invalid (" + start + ", " + end + ", len=" + message.messageOwner.message.length() + ")");
                return outdated = false;
            }
            String newText = message.messageOwner.message.substring(start, end);
            if (TextUtils.equals(text, newText)) {
                this.message = message;
                update(); // maybe some entities changed
                return outdated = false;
            }
            int newStart = message.messageOwner.message.indexOf(text);
            if (newStart >= 0) {
                this.message = message;
                end = end - start + newStart;
                start = newStart;
                update();
                return outdated = false;
            }
            this.message = message;
            start = 0;
            end = message.messageOwner.message.length();
            update();
            return outdated = true;
        }

        public String getText() {
            return text;
        }

        public boolean isValid() {
            if (todo) {
                return task != null;
            } else {
                return !TextUtils.isEmpty(text);
            }
        }

        public ArrayList<TLRPC.MessageEntity> getEntities() {
            return entities;
        }

        public boolean limited() {
            return text != null && message != null && text.length() > MessagesController.getInstance(message.currentAccount).quoteLengthMax;
        }
    }

    public void hideFieldPanel(boolean animated) {
        showFieldPanel(false, null, null, null, null, true, 0, null, false, 0, animated);
    }

    public void hideFieldPanel(boolean notify, int scheduleDate, long payStars, boolean animated) {
        showFieldPanel(false, null, null, null, null, notify, scheduleDate, null, false, payStars, animated);
    }

    public void showFieldPanelForWebPage(boolean show, TLRPC.WebPage webPage, boolean cancel) {
        showFieldPanel(show, null, null, null, webPage, true, 0, null, cancel, 0, true);
    }

    public void showFieldPanelForForward(boolean show, ArrayList<MessageObject> messageObjectsToForward) {
        showFieldPanel(show, null, null, messageObjectsToForward, null, true, 0, null, false, 0, true);
    }

    public void showFieldPanelForReply(MessageObject messageObjectToReply) {
        showFieldPanel(true, messageObjectToReply, null, null, null, true, 0, null, false, 0, true);
    }

    private Runnable onHideFieldPanelRunnable;
    public void showFieldPanelForReplyQuote(MessageObject messageObjectToReply, ReplyQuote quote) {
        showFieldPanel(true, messageObjectToReply, null, null, null, true, 0, quote, false, 0, true);
    }

    public void showFieldPanelForEdit(boolean show, MessageObject messageObjectToEdit) {
        showFieldPanel(show, null, messageObjectToEdit, null, null, true, 0, null, false, 0, true);
    }

    public void showFieldPanelForSuggestionParams(MessageSuggestionParams suggestionParams) {
        showFieldPanel(true, null, null, null, null, true, 0, null, false, 0, suggestionParams, true);
    }

    public void showFieldPanel(boolean show, MessageObject messageObjectToReply, MessageObject messageObjectToEdit, ArrayList<MessageObject> messageObjectsToForward, TLRPC.WebPage webPage, boolean notify, int scheduleDate, ReplyQuote quote, boolean cancel, long payStars, boolean animated) {
        showFieldPanel(show, messageObjectToReply, messageObjectToEdit, messageObjectsToForward, webPage, notify, scheduleDate, quote, cancel, payStars, null, animated);
    }

    private int fieldPanelShown;

    public void showFieldPanel(boolean show, MessageObject messageObjectToReply, MessageObject messageObjectToEdit, ArrayList<MessageObject> messageObjectsToForward, TLRPC.WebPage webPage, boolean notify, int scheduleDate, ReplyQuote quote, boolean cancel, long payStars, MessageSuggestionParams suggestionParams, boolean animated) {
        if (chatActivityEnterView == null) {
            return;
        }

        chatActivityEnterView.setSuggestionButtonVisible(!show && ChatObject.isMonoForum(currentChat), animated);

        if (mentionContainer != null) {
            mentionContainer.getAdapter().setAllowStickers(!show || messageObjectToEdit == null);
        }

        boolean showHint = false;
        if (show) {
            if (messageObjectToReply == null && messageObjectsToForward == null && messageObjectToEdit == null && webPage == null && suggestionParams == null) {
                messagePreviewParams = null;
                return;
            }
            hideHints(false);
            if (searchItem != null && actionBar.isSearchFieldVisible()) {
                actionBar.closeSearchField(false);
                chatActivityEnterView.setFieldFocused();
                AndroidUtilities.runOnUIThread(() -> {
                    if (chatActivityEnterView != null && fieldPanelShown != 5) {
                        chatActivityEnterView.openKeyboard();
                    }
                }, 100);
            }
            boolean openKeyboard = false;
//            if (messageObjectToReply != null && messageObjectToReply.getDialogId() != dialog_id && quote == null) {
//                messageObjectsToForward = new ArrayList<>();
//                messageObjectsToForward.add(messageObjectToReply);
//                messageObjectToReply = null;
//                openKeyboard = true;
//            }

            chatActivityEnterTopView.getReplyView().setLayoutParams(LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.NO_GRAVITY, 0, 0, 52, 0));
            chatActivityEnterTopView.getEditView().setLayoutParams(LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.NO_GRAVITY, 0, 0, 48, 0));
            chatActivityEnterTopView.setEditSuggestionMode(false);
            chatActivityEnterTopView.setEditMode(false);
            messageSuggestionParams = null;
            if (messageObjectToEdit != null) {
                fieldPanelShown = 1;
                forbidForwardingWithDismiss = false;
                if (messagePreviewParams != null) {
                    messagePreviewParams.updateForward(null, dialog_id);
                    messagePreviewParams.updateReply(null, null, dialog_id, null);
                }
                if (threadMessageId == 0 || isTopic) {
                    if (isTopic) {
                        replyingMessageObject = threadMessageObject;
                    } else {
                        replyingMessageObject = null;
                    }
                    replyingQuote = null;
                    chatActivityEnterView.setReplyingMessageObject(null, null);
                    updateBottomOverlay();
                }
                boolean wereNoEdit = editingMessageObject == null;
                editingMessageObject = messageObjectToEdit;
                final boolean mediaEmpty = messageObjectToEdit.isMediaEmpty();
                chatActivityEnterView.setEditingMessageObject(messageObjectToEdit, getValidGroupedMessage(messageObjectToEdit), !mediaEmpty);
                chatActivityEnterView.setForceShowSendButton(false, false);
                final boolean canEditMedia = messageObjectToEdit.canEditMedia();
                replyCloseImageView.setContentDescription(LocaleController.getString(R.string.AccDescrCancelEdit));
                if (messageObjectToEdit.needResendWhenEdit()) {
                    messageSuggestionParams = MessageSuggestionParams.of(messageObjectToEdit.messageOwner != null ? messageObjectToEdit.messageOwner.suggested_post : null);
                }
                if (!mediaEmpty && canEditMedia) {
                    String editButtonText = null;
                    String replaceButtonText;
                    if (messageObjectToEdit.isPhoto()) {
                        editButtonText = LocaleController.getString(R.string.EditMessageEditPhoto);
                        replaceButtonText = LocaleController.getString(R.string.EditMessageReplacePhoto);
                    } else if (messageObjectToEdit.isVideo()) {
                        editButtonText = LocaleController.getString(R.string.EditMessageEditVideo);
                        replaceButtonText = LocaleController.getString(R.string.EditMessageReplaceVideo);
                    } else if (messageObjectToEdit.isGif()) {
                        replaceButtonText = LocaleController.getString(R.string.EditMessageReplaceGif);
                    } else if (messageObjectToEdit.isMusic()) {
                        replaceButtonText = LocaleController.getString(R.string.EditMessageReplaceAudio);
                    } else {
                        replaceButtonText = LocaleController.getString(R.string.EditMessageReplaceFile);
                    }
                    final ChatActivityEnterTopView.EditViewButton[] buttons = chatActivityEnterTopView.getEditView().getButtons();
                    buttons[0].setEditButton(editButtonText != null);
                    buttons[0].getTextView().setText(editButtonText != null ? editButtonText : replaceButtonText);
                    buttons[0].getImageView().setImageResource(editButtonText != null ? R.drawable.msg_photoeditor : R.drawable.msg_replace);
                    buttons[1].setVisibility(editButtonText != null ? View.VISIBLE : View.GONE);
                    if (editButtonText != null) {
                        buttons[1].getTextView().setText(replaceButtonText);
                    }
                    chatActivityEnterTopView.setEditMode(true);
                } else {
                    replyIconImageView.setImageResource(canEditMedia ? R.drawable.nav_edit_attach : R.drawable.group_edit);
                    replyIconImageView.setContentDescription(LocaleController.getString(R.string.AccDescrEditing));
                    if (mediaEmpty || canEditMedia) {
                        replyNameTextView.setText(LocaleController.getString(R.string.EditMessage));
                    } else {
                        replyNameTextView.setText(LocaleController.getString(R.string.EditCaption));
                    }
                    if (canEditMedia) {
                        replyObjectTextView.setText(LocaleController.getString(mediaEmpty ? R.string.AddMessageMedia : R.string.EditMessageMedia));
                    } else if (messageObjectToEdit.messageText != null || messageObjectToEdit.caption != null) {
                        CharSequence mess = messageObjectToEdit.caption != null ? messageObjectToEdit.caption : messageObjectToEdit.messageText;
                        if (mess.length() > 150) {
                            mess = mess.subSequence(0, 150);
                        }
                        mess = AndroidUtilities.replaceNewLines(mess);
                        Spannable cs = new SpannableStringBuilder(Emoji.replaceEmoji(mess, replyObjectTextView.getPaint().getFontMetricsInt(), false));
                        MediaDataController.addTextStyleRuns(messageObjectToEdit, cs);
                        if (messageObjectToEdit.messageOwner != null) {
                            cs = MessageObject.replaceAnimatedEmoji(cs, messageObjectToEdit.messageOwner.entities, replyObjectTextView.getPaint().getFontMetricsInt());
                        }
                        replyObjectTextView.setText(AnimatedEmojiSpan.cloneSpans(cs));
                    }
                }

                if (editingMessageObject.needResendWhenEdit()) {
                    replyIconImageView.setImageResource(R.drawable.filled_paid_suggest_24);
                    replyNameTextView.setText(LocaleController.getString(R.string.PostSuggestionsOfferChangeTitle));

                    final boolean isTon = messageSuggestionParams.amount != null && messageSuggestionParams.amount.currency == AmountUtils.Currency.TON;
                    final ColoredImageSpan[] spanArr = new ColoredImageSpan[1];

                    final String amountString = messageSuggestionParams.amount != null ? messageSuggestionParams.amount.asDecimalString(): "0";

                    if (messageSuggestionParams.isEmpty()) {
                        replyObjectTextView.setText(LocaleController.getString(R.string.SuggestAPostBelowSubtitle));
                    } else if (messageSuggestionParams.time <= 0) {
                        replyObjectTextView.setText(StarsIntroActivity.replaceStarsWithPlain(isTon,
                                LocaleController.formatString(R.string.SuggestAPostBelowSubtitleStars, amountString ), 0.66f, spanArr));
                    } else {
                        replyObjectTextView.setText(StarsIntroActivity.replaceStarsWithPlain(isTon,
                                LocaleController.formatSpannable(R.string.SuggestAPostBelowSubtitleStarsAndTime, amountString,
                                        Emoji.replaceEmoji("\uD83D\uDCC6 " + MessageSuggestionOfferSheet.formatDateTime(messageSuggestionParams.time), replyObjectTextView.getPaint().getFontMetricsInt(), true)
                                ), 0.66f, spanArr));
                    }

                    if (isTon && spanArr[0] != null) {
                        spanArr[0].setColorKey(Theme.key_chat_replyPanelIcons);
                    }

                    if (chatActivityEnterTopView.isEditMode()) {
                        chatActivityEnterTopView.setEditSuggestionMode(true);
                        chatActivityEnterTopView.getReplyView().setLayoutParams(LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.NO_GRAVITY, 0, 0, 52 + 48 * 2, 0));
                        chatActivityEnterTopView.getEditView().setLayoutParams(LayoutHelper.createFrame(48 * 2, LayoutHelper.MATCH_PARENT, Gravity.RIGHT, 0, 0, 48, 0));
                    } else {
                        chatActivityEnterTopView.getReplyView().setLayoutParams(LayoutHelper.createFrame(LayoutHelper.MATCH_PARENT, LayoutHelper.MATCH_PARENT, Gravity.NO_GRAVITY, 0, 0, 52 + 48, 0));
                        chatActivityEnterTopView.getEditView().setLayoutParams(LayoutHelper.createFrame(48, LayoutHelper.MATCH_PARENT, Gravity.RIGHT, 0, 0, 48, 0));

                        chatActivityEnterTopView.setEditSuggestionMode(true);

                        final ChatActivityEnterTopView.EditViewButton[] buttons = chatActivityEnterTopView.getEditView().getButtons();
                        buttons[0].getImageView().setImageResource(R.drawable.nav_edit_attach);
                        buttons[0].setEditButton(false);
                        buttons[1].setVisibility(View.GONE);
                    }
                }

                if (wereNoEdit) {
                    if (messageObjectToEdit.messageOwner != null && messageObjectToEdit.messageOwner.media != null && messageObjectToEdit.messageOwner.media.webpage != null) {
                        foundWebPage = messageObjectToEdit.messageOwner.media.webpage;
                        chatActivityEnterView.setWebPage(foundWebPage, false);
                        showFieldPanelForWebPage(true, foundWebPage, false);
                        return;
                    } else {
                        foundWebPage = null;
                        if (messagePreviewParams != null) {
                            messagePreviewParams.updateLink(currentAccount, null, chatActivityEnterView.getFieldText(), replyingMessageObject == threadMessageObject ? null : replyingMessageObject, replyingQuote, editingMessageObject);
                        }
                        if (chatActivityEnterView != null) {
                            chatActivityEnterView.setWebPage(null, false);
                        }
                    }
                }
                updateBottomOverlay();
            } else if (messageObjectToReply != null) {
                editingMessageObject = null;

                // set it for a case when replying in in View as messages mode
                MessageObject topicTopMessageObject = null;
                if (isForumInViewAsMessagesMode() && ChatObject.isForum(currentChat)) {
                    long topicId = MessageObject.getTopicId(currentAccount, messageObjectToReply.messageOwner, true);
                    if (topicId != 0) {
                        TLRPC.TL_forumTopic topic = getMessagesController().getTopicsController().findTopic(currentChat.id, topicId);
                        if (topic != null && topic.topicStartMessage != null) {
                            topicTopMessageObject = new MessageObject(currentAccount, topic.topicStartMessage, false, false);
                            topicTopMessageObject.isTopicMainMessage = true;
                            topicTopMessageObject.replyToForumTopic = topic;
                        }
                    }
                }

                replyingMessageObject = messageObjectToReply;
                replyingQuote = quote;
                if (replyingQuote != null && !replyingQuote.isValid()) {
                    replyingQuote = null;
                }
                chatActivityEnterView.setReplyingMessageObject(messageObjectToReply, quote, topicTopMessageObject);
                chatActivityEnterView.setEditingMessageObject(null, null, false);
                forbidForwardingWithDismiss = false;
                if (messagePreviewParams == null) {
                    messagePreviewParams = new MessagePreviewParams(currentEncryptedChat != null, getMessagesController().isChatNoForwards(currentChat), ChatObject.isMonoForum(currentChat));
                    messagePreviewParams.attach(forwardingPreviewView);
                }
                messagePreviewParams.updateReply(replyingMessageObject, replyingQuoteGroup != null ? replyingQuoteGroup : getGroup(replyingMessageObject.getGroupId()), dialog_id, replyingQuote);
                if (messagePreviewParams.isEmpty() && editingMessageObject == null) {
                    messagePreviewParams = null;
                }
                fieldPanelShown = 2;
                String restrictionReason = MessagesController.getInstance(currentAccount).getRestrictionReason(messageObjectToReply.messageOwner.restriction_reason);
                chatActivityEnterView.setForceShowSendButton(false, false);
                CharSequence name = null;
                if (messageObjectToReply.isForwarded() && messageObjectToReply.getDialogId() != dialog_id) {
                    if (messageObjectToReply.messageOwner.fwd_from.from_id != null) {
                        name = MessageObject.peerNameWithIcon(currentAccount, messageObjectToReply.messageOwner.fwd_from.from_id);
                    } else {
                        name = null;
                    }
                }
                if (currentEncryptedChat != null) {
                    if (messageObjectToReply.isOutOwner()) {
                        name = UserObject.getUserName(getUserConfig().getCurrentUser());
                    } else {
                        name = UserObject.getUserName(currentUser);
                    }
                } else if (name == null && messageObjectToReply.isFromUser()) {
                    if (messageObjectToReply.messageOwner.from_id.channel_id != 0) {
                        TLRPC.Chat chat = getMessagesController().getChat(messageObjectToReply.messageOwner.from_id.channel_id);
                        if (chat == null) {
                            return;
                        }
                        name = new SpannableStringBuilder(ChatObject.isChannelAndNotMegaGroup(chat) ? MessageObject.channelSpan() : MessageObject.groupSpan()).append(" ").append(chat.title);
                    } else {
                        TLRPC.User user = getMessagesController().getUser(messageObjectToReply.messageOwner.from_id.user_id);
                        if (user == null) {
                            return;
                        }
                        name = UserObject.getUserName(user);
                    }
                } else if (name == null) {
                    TLRPC.Chat chat = null;
                    TLRPC.User user = null;
                    if (ChatObject.isChannel(currentChat) && currentChat.megagroup && messageObjectToReply.isForwardedChannelPost()) {
                        chat = getMessagesController().getChat(messageObjectToReply.messageOwner.fwd_from.from_id.channel_id);
                    } else {
                        final long did = messageObjectToReply.getSenderId();
                        if (did < 0) {
                            chat = getMessagesController().getChat(-did);
                        } else {
                            user = getMessagesController().getUser(did);
                        }
                    }
                    if (chat == null && user == null) {
                        return;
                    }
                    if (chat != null) {
                        name = new SpannableStringBuilder(ChatObject.isChannelAndNotMegaGroup(chat) ? MessageObject.channelSpan() : MessageObject.groupSpan()).append(" ").append(chat.title);
                    } else {
                        name = UserObject.getUserName(user);
                    }
                }
                CharSequence nameText;
                if (quote != null && quote.todo) {
                    replyIconImageView.setImageResource(R.drawable.filled_reply_quote);
                    final TLRPC.MessageMedia media = MessageObject.getMedia(quote.message);
                    if (media instanceof TLRPC.TL_messageMediaToDo) {
                        final TLRPC.TL_messageMediaToDo mediaTodo = (TLRPC.TL_messageMediaToDo) media;
                        nameText = LocaleController.formatSpannable(R.string.ReplyToTaskIn, MessageObject.formatTextWithEntities(mediaTodo.todo.title, false, replyNameTextView.getPaint()));
                    } else {
                        nameText = LocaleController.getString(R.string.ReplyToTask);
                    }
                } else if (quote != null && !quote.todo) {
                    replyIconImageView.setImageResource(R.drawable.filled_reply_quote);
                    nameText = AndroidUtilities.replaceCharSequence("%s", LocaleController.getString(R.string.ReplyToQuote), name == null ? "" : name);
                } else {
                    if (messagePreviewParams == null || messagePreviewParams.hasSecretMessages || chatMode == MODE_QUICK_REPLIES) {
                        replyIconImageView.setImageResource(R.drawable.ic_ab_reply);
                    } else {
                        replyIconImageView.setImageResource(R.drawable.filled_reply_settings);
                    }
                    nameText = AndroidUtilities.replaceCharSequence("%s", LocaleController.getString(R.string.ReplyTo), name == null ? "" : name);
                }
                nameText = Emoji.replaceEmoji(nameText, replyNameTextView.getPaint().getFontMetricsInt(), false);
                replyNameTextView.setText(nameText);
                replyIconImageView.setContentDescription(LocaleController.getString(R.string.AccDescrReplying));
                replyCloseImageView.setContentDescription(LocaleController.getString(R.string.AccDescrCancelReply));

                replyObjectHintTextView.setText(LocaleController.getString(R.string.TapForReplyOptions));
                if (!SharedConfig.replyingOptionsHintShown) {
                    showHint = true;
                }

                CharSequence replyObjectText = null;
                CharSequence sourceText = null;
                ArrayList<TLRPC.MessageEntity> entities = messageObjectToReply != null && messageObjectToReply.messageOwner != null ? messageObjectToReply.messageOwner.entities : null;
                if (replyingQuote != null && replyingQuote.todo) {
                    replyObjectText = MessageObject.formatTextWithEntities(replyingQuote.task.title, false, replyObjectTextView.getPaint());
                } else if (replyingQuote != null) {
                    if (replyingQuote.outdated) {
                        replyObjectText = new SpannableStringBuilder(LocaleController.getString(R.string.QuoteOutdated));
                        ((SpannableStringBuilder) replyObjectText).setSpan(new TypefaceSpan(AndroidUtilities.getTypeface(AndroidUtilities.TYPEFACE_ROBOTO_MEDIUM_ITALIC)), 0, replyObjectText.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                    } else {
                        replyObjectText = new SpannableStringBuilder(replyingQuote.getText());
                        entities = replyingQuote.getEntities();
                        replyObjectText = AndroidUtilities.replaceNewLines(replyObjectText);
                        if (entities != null) {
                            replyObjectText = MessageObject.replaceAnimatedEmoji(replyObjectText, entities, replyObjectTextView.getPaint().getFontMetricsInt());
                        }
                        replyObjectText = Emoji.replaceEmoji(replyObjectText, replyObjectTextView.getPaint().getFontMetricsInt(), false);
                    }
                } else if (!TextUtils.isEmpty(restrictionReason)) {
                    replyObjectText = restrictionReason;
                    sourceText = restrictionReason;
                } else if (MessageObject.isTopicActionMessage(messageObjectToReply)) {
                    ForumUtilities.applyTopicToMessage(messageObjectToReply);
                    if (messageObjectToReply.messageTextForReply != null) {
                        replyObjectText = messageObjectToReply.messageTextForReply;
                    } else {
                        replyObjectText = messageObjectToReply.messageTextShort;
                    }
                    AnimatedEmojiSpan.applyFontMetricsForString(replyObjectText, replyObjectTextView.getPaint());
                } else if (messageObjectToReply.replyToForumTopic != null) {
                    replyObjectText = ForumUtilities.getTopicSpannedName(messageObjectToReply.replyToForumTopic, replyObjectTextView.getPaint(), false);
                } else if (messageObjectToReply.messageOwner.media instanceof TLRPC.TL_messageMediaGame) {
                    replyObjectText = Emoji.replaceEmoji(messageObjectToReply.messageOwner.media.game.title, replyObjectTextView.getPaint().getFontMetricsInt(), false);
                    sourceText = messageObjectToReply.messageOwner.media.game.title;
                } else if (messageObjectToReply.messageText != null || messageObjectToReply.caption != null) {
                    CharSequence mess = messageObjectToReply.caption != null ? messageObjectToReply.caption.toString() : messageObjectToReply.messageText.toString();
                    sourceText = mess;
                    if (mess.length() > 150) {
                        mess = mess.subSequence(0, 150);
                    }
                    mess = AndroidUtilities.replaceNewLines(mess);
                    if (messageObjectToReply.messageOwner != null && messageObjectToReply.messageOwner.entities != null) {
                        mess = MessageObject.replaceAnimatedEmoji(mess, messageObjectToReply.messageOwner.entities, replyObjectTextView.getPaint().getFontMetricsInt());
                    }
                    replyObjectText = Emoji.replaceEmoji(mess, replyObjectTextView.getPaint().getFontMetricsInt(), false);
                }
                if (replyObjectText != null) {
                    if (replyObjectText instanceof Spannable && sourceText != null) {
                        MediaDataController.addTextStyleRuns(entities, sourceText, (Spannable) replyObjectText);
                    }

                    replyObjectTextView.setText(AnimatedEmojiSpan.cloneSpans(replyObjectText));
                }
                updateBottomOverlay();
            } else if (messageObjectsToForward != null) {
                if (messageObjectsToForward.isEmpty()) {
                    return;
                }
                fieldPanelShown = 3;
                if (messagePreviewParams == null) {
                    messagePreviewParams = new MessagePreviewParams(currentEncryptedChat != null, getMessagesController().isChatNoForwards(currentChat), ChatObject.isMonoForum(currentChat));
                    messagePreviewParams.attach(forwardingPreviewView);
                }
                messagePreviewParams.updateForward(messageObjectsToForward, dialog_id);
                if (messagePreviewParams.isEmpty() && editingMessageObject == null) {
                    messagePreviewParams = null;
                }
                editingMessageObject = null;
                chatActivityEnterView.setEditingMessageObject(null, null, false);
                forbidForwardingWithDismiss = false;
                chatActivityEnterView.setForceShowSendButton(true, false);
                ArrayList<Long> uids = new ArrayList<>();
                replyIconImageView.setImageResource(R.drawable.filled_forward);
                replyIconImageView.setContentDescription(LocaleController.getString(R.string.AccDescrForwarding));
                replyCloseImageView.setContentDescription(LocaleController.getString(R.string.AccDescrCancelForward));
                MessageObject object = messageObjectsToForward.get(0);
                if (object.isFromUser()) {
                    uids.add(object.messageOwner.from_id.user_id);
                } else {
                    TLRPC.Chat chat = getMessagesController().getChat(object.messageOwner.peer_id.channel_id);
                    if (ChatObject.isChannel(chat) && chat.megagroup && object.isForwardedChannelPost()) {
                        uids.add(-object.messageOwner.fwd_from.from_id.channel_id);
                    } else {
                        uids.add(-object.messageOwner.peer_id.channel_id);
                    }
                }

                int type = object.isAnimatedEmoji() || object.isDice() ? 0 : object.type;
                for (int a = 1; a < messageObjectsToForward.size(); a++) {
                    object = messageObjectsToForward.get(a);
                    long uid;
                    if (object.isFromUser()) {
                        uid = object.messageOwner.from_id.user_id;
                    } else {
                        TLRPC.Chat chat = getMessagesController().getChat(object.messageOwner.peer_id.channel_id);
                        if (ChatObject.isChannel(chat) && chat.megagroup && object.isForwardedChannelPost()) {
                            uid = -object.messageOwner.fwd_from.from_id.channel_id;
                        } else {
                            uid = -object.messageOwner.peer_id.channel_id;
                        }
                    }
                    if (!uids.contains(uid)) {
                        uids.add(uid);
                    }
                    if (messageObjectsToForward.get(a).type != type) {
                        type = -1;
                    }
                }
                int userNamesCount = 0;
                StringBuilder userNames = new StringBuilder();
                for (int a = 0; a < uids.size(); a++) {
                    Long uid = uids.get(a);
                    TLRPC.Chat chat = null;
                    TLRPC.User user = null;
                    if (uid > 0) {
                        user = getMessagesController().getUser(uid);
                    } else {
                        chat = getMessagesController().getChat(-uid);
                    }
                    if (user == null && chat == null) {
                        continue;
                    }
                    if (uids.size() == 1) {
                        if (user != null) {
                            userNames.append(UserObject.getUserName(user));
                        } else {
                            userNames.append(chat.title);
                        }
                        userNamesCount++;
                    } else if (uids.size() == 2 || userNames.length() == 0) {
                        if (userNames.length() > 0) {
                            userNames.append(", ");
                        }
                        if (user != null) {
                            if (!TextUtils.isEmpty(user.first_name)) {
                                userNames.append(user.first_name);
                            } else if (!TextUtils.isEmpty(user.last_name)) {
                                userNames.append(user.last_name);
                            } else {
                                userNames.append(" ");
                            }
                        } else {
                            userNames.append(chat.title);
                        }
                        userNamesCount++;
                    } else {
                        userNames.append(" ");
                        userNames.append(LocaleController.formatPluralString("AndOther", uids.size() - 1));
                        userNamesCount++;
                        break;
                    }
                }
                formwardingNameText = userNames;
                CharSequence text = "";
                if (type == -1 || type == MessageObject.TYPE_TEXT || type == MessageObject.TYPE_DATE || type == MessageObject.TYPE_ACTION_PHOTO || type == MessageObject.TYPE_EMOJIS) {
                    text = LocaleController.formatPluralString("PreviewForwardMessagesCount", messageObjectsToForward.size());
                } else if (type == MessageObject.TYPE_PHOTO) {
                    text = LocaleController.formatPluralString("PreviewForwardPhoto", messageObjectsToForward.size());
                    if (messageObjectsToForward.size() == 1) {
                        messageObjectToReply = messageObjectsToForward.get(0);
                    }
                } else if (type == MessageObject.TYPE_GIVEAWAY) {
                    text = LocaleController.getString(R.string.BoostingGiveaway);
                } else if (type == MessageObject.TYPE_GIVEAWAY_RESULTS) {
                    text = LocaleController.getString(R.string.BoostingGiveawayResults);
                } else if (type == MessageObject.TYPE_GEO) {
                    text = LocaleController.formatPluralString("PreviewForwardLocation", messageObjectsToForward.size());
                } else if (type == MessageObject.TYPE_VIDEO) {
                    text = LocaleController.formatPluralString("PreviewForwardVideo", messageObjectsToForward.size());
                    if (messageObjectsToForward.size() == 1) {
                        messageObjectToReply = messageObjectsToForward.get(0);
                    }
                } else if (type == MessageObject.TYPE_CONTACT) {
                    text = LocaleController.formatPluralString("PreviewForwardContact", messageObjectsToForward.size());
                } else if (type == MessageObject.TYPE_VOICE) {
                    text = LocaleController.formatPluralString("PreviewForwardAudio", messageObjectsToForward.size());
                } else if (type == MessageObject.TYPE_ROUND_VIDEO) {
                    text = LocaleController.formatPluralString("PreviewForwardRound", messageObjectsToForward.size());
                } else if (type == MessageObject.TYPE_MUSIC) {
                    text = LocaleController.formatPluralString("PreviewForwardMusic", messageObjectsToForward.size());
                } else if (type == MessageObject.TYPE_STICKER || type == MessageObject.TYPE_ANIMATED_STICKER) {
                    text = LocaleController.formatPluralString("PreviewForwardSticker", messageObjectsToForward.size());
                } else if (type == MessageObject.TYPE_POLL) {
                    text = LocaleController.formatPluralString(object != null && object.isTodo() ? "PreviewForwardTodo" : "PreviewForwardPoll", messageObjectsToForward.size());
                } else if (type == MessageObject.TYPE_GIF || type == MessageObject.TYPE_FILE) {
                    if (messageObjectsToForward.size() == 1 & type == MessageObject.TYPE_FILE) {
                        messageObjectToReply = messageObjectsToForward.get(0);
                    }
                    if (messageObjectsToForward.size() == 1 && type == MessageObject.TYPE_GIF) {
                        text = LocaleController.getString(R.string.AttachGif);
                    } else {
                        text = LocaleController.formatPluralString("PreviewForwardFile", messageObjectsToForward.size());
                    }
                } else if (type == MessageObject.TYPE_STORY) {
                    if (messageObjectsToForward.size() == 1) {
                        text = LocaleController.getString(R.string.Story);
                    } else {
                        text = LocaleController.formatPluralString("Stories", messageObjectsToForward.size());
                    }
                }
                replyNameTextView.setText(text);

                if (messagePreviewParams != null && messagePreviewParams.hideForwardSendersName) {
                    replyObjectTextView.setText(LocaleController.getString(R.string.HiddenSendersNameDescription));
                } else {
                    if ((type == -1 || type == MessageObject.TYPE_TEXT || type == MessageObject.TYPE_DATE || type == MessageObject.TYPE_ACTION_PHOTO || type == MessageObject.TYPE_EMOJIS) && (messageObjectsToForward.size() == 1 && messageObjectsToForward.get(0).messageText != null)) {
                        MessageObject messageObject = messageObjectsToForward.get(0);
                        CharSequence mess = new SpannableStringBuilder(messageObject.messageText.toString());
                        if (mess.length() > 150) {
                            mess = mess.subSequence(0, 150);
                        }
                        mess = Emoji.replaceEmoji(mess, replyObjectTextView.getPaint().getFontMetricsInt(), false);
                        if (mess instanceof Spannable) {
                            MediaDataController.addTextStyleRuns(messageObject.messageOwner.entities, messageObject.messageText, (Spannable) mess);
                            if (messageObject.messageOwner != null) {
                                mess = MessageObject.replaceAnimatedEmoji(mess, messageObject.messageOwner.entities, replyObjectTextView.getPaint().getFontMetricsInt());
                            }
                        }
                        if (userNamesCount == 1) {
                            mess = TextUtils.concat(userNames, ": ", mess);
                        }
                        replyObjectTextView.setText(mess);
                    } else {
                        replyObjectTextView.setText(LocaleController.formatString("ForwardingFromNames", R.string.ForwardingFromNames, userNames));
                    }
                }
                replyObjectHintTextView.setText(LocaleController.getString(R.string.TapForForwardingOptions));
                if (!SharedConfig.forwardingOptionsHintShown) {
                    showHint = true;
                }
            } else if (webPage != null) {
                fieldPanelShown = 4;
                replyIconImageView.setImageResource(R.drawable.filled_link);
                if (messagePreviewParams == null) {
                    messagePreviewParams = new MessagePreviewParams(currentEncryptedChat != null, getMessagesController().isChatNoForwards(currentChat), ChatObject.isMonoForum(currentChat));
                    messagePreviewParams.attach(forwardingPreviewView);
                }
                messagePreviewParams.updateLink(currentAccount, foundWebPage, chatActivityEnterView.getFieldText(), replyingMessageObject == threadMessageObject ? null : replyingMessageObject, replyingQuote, editingMessageObject);
                if (messagePreviewParams.isEmpty() && editingMessageObject == null) {
                    messagePreviewParams = null;
                }
                if (webPage instanceof TLRPC.TL_webPagePending) {
                    replyNameTextView.setText(LocaleController.getString(R.string.GettingLinkInfo));
                    replyObjectTextView.setText(pendingLinkSearchString);
                } else {
                    if (webPage.site_name != null) {
                        replyNameTextView.setText(webPage.site_name);
                    } else if (webPage.title != null) {
                        replyNameTextView.setText(webPage.title);
                    } else {
                        replyNameTextView.setText(LocaleController.getString(R.string.LinkPreview));
                    }
                    if (webPage.title != null) {
                        replyObjectTextView.setText(webPage.title);
                    } else if (webPage.description != null) {
                        replyObjectTextView.setText(webPage.description);
                    } else if (webPage.author != null) {
                        replyObjectTextView.setText(webPage.author);
                    } else {
                        replyObjectTextView.setText(webPage.display_url);
                    }
                    chatActivityEnterView.setWebPage(webPage, true);
                }
            } else if (suggestionParams != null) {
                messageSuggestionParams = suggestionParams;
                messagePreviewParams = null;
                fieldPanelShown = 5;

                if (foundWebPage != null) {
                    foundWebPage = null;
                    chatActivityEnterView.setWebPage(null, !cancel);
                }
                chatActivityEnterView.setReplyingMessageObject(threadMessageObject, null);
                chatActivityEnterView.setEditingMessageObject(null, null, false);
                topViewWasVisible = 0;
                replyingMessageObject = threadMessageObject;
                replyingQuote = null;
                editingMessageObject = null;
                replyImageLocation = null;
                replyImageLocationObject = null;

                replyIconImageView.setImageResource(R.drawable.filled_paid_suggest_24);
                replyNameTextView.setText(LocaleController.getString(R.string.SuggestAPostBelow));


                final boolean isTon = suggestionParams.amount != null && suggestionParams.amount.currency == AmountUtils.Currency.TON;
                final ColoredImageSpan[] spanArr = new ColoredImageSpan[1];

                final String amountString = suggestionParams.amount != null ? suggestionParams.amount.asDecimalString(): "0";

                if (suggestionParams.isEmpty()) {
                    replyObjectTextView.setText(LocaleController.getString(R.string.SuggestAPostBelowSubtitle));
                } else if (suggestionParams.time <= 0) {
                    replyObjectTextView.setText(StarsIntroActivity.replaceStarsWithPlain(isTon,
                        LocaleController.formatString(R.string.SuggestAPostBelowSubtitleStars, amountString ), 0.66f, spanArr));
                } else {
                    replyObjectTextView.setText(StarsIntroActivity.replaceStarsWithPlain(isTon,
                        LocaleController.formatSpannable(R.string.SuggestAPostBelowSubtitleStarsAndTime, amountString,
                            Emoji.replaceEmoji("\uD83D\uDCC6 " + MessageSuggestionOfferSheet.formatDateTime(suggestionParams.time), replyObjectTextView.getPaint().getFontMetricsInt(), true)
                    ), 0.66f, spanArr));
                }

                if (isTon && spanArr[0] != null) {
                    spanArr[0].setColorKey(Theme.key_chat_replyPanelIcons);
                }
            }


            MessageObject thumbMediaMessageObject;
            if (messageObjectToReply != null) {
                thumbMediaMessageObject = messageObjectToReply;
            } else if (messageObjectToEdit != null) {
                if (!chatActivityEnterTopView.isEditMode()) {
                    thumbMediaMessageObject = messageObjectToEdit;
                } else {
                    thumbMediaMessageObject = null;
                }
            } else {
                thumbMediaMessageObject = null;
            }

            FrameLayout.LayoutParams layoutParams1 = (FrameLayout.LayoutParams) replyNameTextView.getLayoutParams();
            FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams) replyObjectTextView.getLayoutParams();
            FrameLayout.LayoutParams layoutParams3 = (FrameLayout.LayoutParams) replyObjectHintTextView.getLayoutParams();

            int cacheType = 1;
            int size = 0;
            TLRPC.PhotoSize photoSize = null;
            TLRPC.PhotoSize thumbPhotoSize = null;
            TLObject photoSizeObject = null;
            if (thumbMediaMessageObject != null && TextUtils.isEmpty(MessagesController.getInstance(currentAccount).getRestrictionReason(thumbMediaMessageObject.messageOwner.restriction_reason))) {
                photoSize = FileLoader.getClosestPhotoSizeWithSize(thumbMediaMessageObject.photoThumbs2, 320);
                thumbPhotoSize = FileLoader.getClosestPhotoSizeWithSize(thumbMediaMessageObject.photoThumbs2, AndroidUtilities.dp(40));
                photoSizeObject = thumbMediaMessageObject.photoThumbsObject2;
                if (photoSize == null) {
                    if (thumbMediaMessageObject.mediaExists) {
                        photoSize = FileLoader.getClosestPhotoSizeWithSize(thumbMediaMessageObject.photoThumbs, AndroidUtilities.getPhotoSize());
                        if (photoSize != null) {
                            size = photoSize.size;
                        }
                    } else {
                        photoSize = FileLoader.getClosestPhotoSizeWithSize(thumbMediaMessageObject.photoThumbs, 320);
                    }
                    thumbPhotoSize = FileLoader.getClosestPhotoSizeWithSize(thumbMediaMessageObject.photoThumbs, AndroidUtilities.dp(40));
                    photoSizeObject = thumbMediaMessageObject.photoThumbsObject;
                }
            }
            if (photoSize == thumbPhotoSize) {
                thumbPhotoSize = null;
            }
            if (photoSize == null || photoSize instanceof TLRPC.TL_photoSizeEmpty || photoSize.location instanceof TLRPC.TL_fileLocationUnavailable || thumbMediaMessageObject.isAnyKindOfSticker() || thumbMediaMessageObject.isSecretMedia() || thumbMediaMessageObject.isWebpageDocument() || forwardingPreviewView != null) {
                replyImageView.setImageBitmap(null);
                replyImageLocation = null;
                replyImageLocationObject = null;
                replyImageView.setVisibility(View.INVISIBLE);
                layoutParams1.leftMargin = layoutParams2.leftMargin = layoutParams3.leftMargin = AndroidUtilities.dp(52);
            } else {
                if (thumbMediaMessageObject.isRoundVideo()) {
                    replyImageView.setRoundRadius(AndroidUtilities.dp(17));
                } else {
                    replyImageView.setRoundRadius(AndroidUtilities.dp(2));
                }
                replyImageSize = size;
                replyImageCacheType = cacheType;
                replyImageLocation = photoSize;
                replyImageThumbLocation = thumbPhotoSize;
                replyImageLocationObject = photoSizeObject;
                replyImageHasMediaSpoiler = thumbMediaMessageObject.hasMediaSpoilers();
                replyImageView.setImage(ImageLocation.getForObject(replyImageLocation, photoSizeObject), replyImageHasMediaSpoiler ? "5_5_b" : "50_50", ImageLocation.getForObject(thumbPhotoSize, photoSizeObject), replyImageHasMediaSpoiler ? "5_5_b" : "50_50_b", null, size, cacheType, thumbMediaMessageObject);
                replyImageView.setVisibility(View.VISIBLE);
                layoutParams1.leftMargin = layoutParams2.leftMargin = layoutParams3.leftMargin = AndroidUtilities.dp(96);
            }
            replyNameTextView.setLayoutParams(layoutParams1);
            replyObjectTextView.setLayoutParams(layoutParams2);
            replyObjectTextView.setLayoutParams(layoutParams3);
            chatActivityEnterView.showTopView(true, openKeyboard);
        } else {
            fieldPanelShown = 0;
            if (replyingMessageObject == null && messagePreviewParams == null && foundWebPage == null && editingMessageObject == null && !chatActivityEnterView.isTopViewVisible() && topicsTabs == null) {
                messagePreviewParams = null;
                return;
            }
            if (replyingMessageObject != null && replyingMessageObject.messageOwner.reply_markup instanceof TLRPC.TL_replyKeyboardForceReply) {
                SharedPreferences preferences = MessagesController.getMainSettings(currentAccount);
                String tk = isTopic ? dialog_id + "_" + getTopicId() : "" + dialog_id;
                preferences.edit().putInt("answered_" + tk, replyingMessageObject.getId()).commit();
            }
            if (foundWebPage != null) {
                foundWebPage = null;
                chatActivityEnterView.setWebPage(null, !cancel);
            }
            if (messagePreviewParams != null && messagePreviewParams.forwardMessages != null) {
                forbidForwardingWithDismiss = false;
//                if (messagePreviewParams.quote == null) {
                    ArrayList<MessageObject> messagesToForward = new ArrayList<>();
                    if (messagePreviewParams.forwardMessages != null) {
                        messagePreviewParams.forwardMessages.getSelectedMessages(messagesToForward);
                    }
                    forwardMessages(messagesToForward, messagePreviewParams.hideForwardSendersName, messagePreviewParams.hideCaption, notify, scheduleDate != 0 && scheduleDate != 0x7ffffffe ? scheduleDate + 1 : scheduleDate, payStars);
//                }
            }
            if (forwardingPreviewView == null) {
                messagePreviewParams = null;
            }
            chatActivityEnterView.setForceShowSendButton(false, animated);
            if (!waitingForSendingMessageLoad) {
                chatActivityEnterView.hideTopView(animated);
            }
            chatActivityEnterView.setReplyingMessageObject(threadMessageObject, null);
            chatActivityEnterView.setEditingMessageObject(null, null, false);
            topViewWasVisible = 0;
            replyingMessageObject = threadMessageObject;
            replyingQuote = null;
            editingMessageObject = null;
            replyImageLocation = null;
            replyImageLocationObject = null;
            messageSuggestionParams = null;
            updateBottomOverlay();
        }

        if (showHint) {
            if (tapForForwardingOptionsHitRunnable == null) {
                AndroidUtilities.runOnUIThread(tapForForwardingOptionsHitRunnable = () -> {
                    showTapForForwardingOptionsHit = !showTapForForwardingOptionsHit;
                    replyObjectTextView.setPivotX(0);
                    replyObjectHintTextView.setPivotX(0);
                    if (showTapForForwardingOptionsHit) {
                        replyObjectTextView.animate().alpha(0f).scaleX(0.98f).scaleY(0.98f).setDuration(150).start();
                        replyObjectHintTextView.animate().alpha(1f).scaleX(1f).scaleY(1f).setDuration(150).start();
                    } else {
                        replyObjectTextView.animate().alpha(1f).scaleX(1f).scaleY(1f).setDuration(150).start();
                        replyObjectHintTextView.animate().alpha(0f).scaleX(0.98f).scaleY(0.98f).setDuration(150).start();
                    }
                    AndroidUtilities.runOnUIThread(tapForForwardingOptionsHitRunnable, 6000);
                }, 6000);
            }
        } else {
            if (tapForForwardingOptionsHitRunnable != null) {
                AndroidUtilities.cancelRunOnUIThread(tapForForwardingOptionsHitRunnable);
                tapForForwardingOptionsHitRunnable = null;
            }
            replyObjectTextView.setAlpha(1f);
            replyObjectHintTextView.setAlpha(0);
        }
        if (chatActivityEnterView != null) {
            chatActivityEnterView.updateSendButtonPaid();
        }
    }

    private void moveScrollToLastMessage(boolean skipSponsored) {
        if (chatListView != null && !messages.isEmpty() && !pinchToZoomHelper.isInOverlayMode()) {
            int position = 0;
            if (skipSponsored) {
                position += getSponsoredMessagesCount();
            }
            chatLayoutManager.scrollToPositionWithOffset(position, 0);
            chatListView.stopScroll();
        }
    }

    private Runnable sendSecretMessageRead(MessageObject messageObject, boolean readNow) {
        if (messageObject == null || messageObject.isOut() || !messageObject.isSecretMedia() || messageObject.messageOwner.destroyTime != 0 || messageObject.messageOwner.ttl <= 0) {
            return null;
        }
        if (readNow) {
            final boolean delete = messageObject.messageOwner.ttl != 0x7FFFFFFF;
            final int ttl = messageObject.messageOwner.ttl == 0x7FFFFFFF ? 0 : messageObject.messageOwner.ttl;
            messageObject.messageOwner.destroyTime = ttl + getConnectionsManager().getCurrentTime();
            if (currentEncryptedChat != null) {
                getMessagesController().markMessageAsRead(dialog_id, messageObject.messageOwner.random_id, ttl);
            } else {
                getMessagesController().markMessageAsRead2(dialog_id, messageObject.getId(), null, ttl, 0, delete);
            }
            return null;
        } else {
            return () -> {
                final boolean delete = messageObject.messageOwner.ttl != 0x7FFFFFFF;
                final int ttl = messageObject.messageOwner.ttl == 0x7FFFFFFF ? 0 : messageObject.messageOwner.ttl;
                messageObject.messageOwner.destroyTime = ttl + getConnectionsManager().getCurrentTime();
                messageObject.messageOwner.destroyTimeMillis = ttl * 1000L + getConnectionsManager().getCurrentTimeMillis();
                if (currentEncryptedChat != null) {
                    getMessagesController().markMessageAsRead(dialog_id, messageObject.messageOwner.random_id, ttl);
                } else {
                    getMessagesController().markMessageAsRead2(dialog_id, messageObject.getId(), null, ttl, 0, delete);
                }
            };
        }
    }

    private Runnable sendSecretMediaDelete(MessageObject messageObject) {
        if (messageObject == null || messageObject.isOut() || !messageObject.isSecretMedia() || messageObject.messageOwner.ttl != 0x7FFFFFFF) {
            return null;
        }
        final long taskId = getMessagesController().createDeleteShowOnceTask(dialog_id, messageObject.getId());
        messageObject.forceExpired = true;
        if (messageObject.isOutOwner() || !messageObject.isRoundOnce() && !messageObject.isVoiceOnce()) {
            ArrayList<MessageObject> msgs = new ArrayList<>();
            msgs.add(messageObject);
            updateMessages(msgs, true);
        }
        return () -> getMessagesController().doDeleteShowOnceTask(taskId, dialog_id, messageObject.getId());
    }

    private void clearChatData(boolean full) {
        messages.clear();
        messagesByDays.clear();
        messagesByDaysSorted.clear();
        waitingForLoad.clear();
        groupedMessagesMap.clear();
        threadMessageAdded = false;

        if (chatAdapter != null) {
            showProgressView(chatAdapter.botInfoRow < 0);
        }
        if (chatListView != null) {
            chatListView.setEmptyView(null);
        }
        for (int a = 0; a < 2; a++) {
            messagesDict[a].clear();
            if (currentEncryptedChat == null) {
                maxMessageId[a] = Integer.MAX_VALUE;
                minMessageId[a] = Integer.MIN_VALUE;
            } else {
                maxMessageId[a] = Integer.MIN_VALUE;
                minMessageId[a] = Integer.MAX_VALUE;
            }
            maxDate[a] = Integer.MIN_VALUE;
            minDate[a] = 0;
            endReached[a] = false;
            cacheEndReached[a] = false;
            forwardEndReached[a] = true;
        }
        if (full) {
            first = true;
            firstLoading = true;
            loading = true;
            loadingForward = false;
        }
        waitingForReplyMessageLoad = false;
        startLoadFromMessageId = 0;
        showScrollToMessageError = false;
        last_message_id = 0;
        unreadMessageObject = null;
        createUnreadMessageAfterId = 0;
        createUnreadMessageAfterIdLoading = false;
        needSelectFromMessageId = false;
        if (chatAdapter != null && !chatAdapter.isFiltered) {
            chatAdapter.notifyDataSetChanged(false);
        }
    }

    public void scrollToLastMessage(boolean skipSponsored, boolean top) {
        scrollToLastMessage(skipSponsored, top, null);
    }

    public void scrollToLastMessage(boolean skipSponsored, boolean top, Runnable inCaseLoading) {
        if (chatListView.isFastScrollAnimationRunning()) {
            return;
        }
        forceNextPinnedMessageId = 0;
        nextScrollToMessageId = 0;
        forceScrollToFirst = false;
        chatScrollHelper.setScrollDirection(RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN);
        if (forwardEndReached[0] && first_unread_id == 0 && startLoadFromMessageId == 0) {
            sideControlsButtonsLayout.setButtonLoading(ChatActivitySideControlsButtonsLayout.BUTTON_PAGE_DOWN, false, true);
            if (chatLayoutManager.findFirstCompletelyVisibleItemPosition() == 0) {
                canShowPagedownButton = false;
                updatePagedownButtonVisibility(true);
                removeSelectedMessageHighlight();
                updateVisibleRows();
            } else {
                chatAdapter.updateRowsSafe();
                chatScrollHelperCallback.scrollTo = null;
                int position = 0;
                if (skipSponsored) {
                    while (position < messages.size()) {
                        if (!messages.get(position).isSponsored()) {
                            break;
                        }
                        position++;
                        top = false;
                    }
                }
                if (top && messages != null && !messages.isEmpty() && messages.get(position) != null) {
                    long groupId = messages.get(position).getGroupId();
                    while (groupId != 0 && position + 1 < messages.size()) {
                        if (groupId != messages.get(position + 1).getGroupId()) {
                            break;
                        }
                        position++;
                    }
                }
                if (messages != null && !messages.isEmpty()) {
                    position = Math.min(position, messages.size() - 1);
                }
                final int finalPosition = position;
                final boolean finalTop = top;
                Runnable scroll = () -> {
                    chatScrollHelper.scrollToPosition(chatScrollHelperCallback.position = finalPosition, chatScrollHelperCallback.offset = 0, chatScrollHelperCallback.bottom = !finalTop, true, true);
                    canShowPagedownButton = false;
                    updatePagedownButtonVisibility(true);
                };
                if (SCROLL_DEBUG_DELAY && inCaseLoading != null) {
                    inCaseLoading.run();
                    AndroidUtilities.runOnUIThread(() -> {
                        resetProgressDialogLoading();
                        scroll.run();
                    }, 7500);
                } else {
                    scroll.run();
                }
            }
        } else {
            if (progressDialog != null) {
                progressDialog.dismiss();
            }

            updatePinnedListButton(false);
            if (inCaseLoading != null) {
                inCaseLoading.run();
            } else {
                resetProgressDialogLoading();
                progressDialog = new AlertDialog(getParentActivity(), AlertDialog.ALERT_TYPE_SPINNER, themeDelegate);
                progressDialog.setOnCancelListener(postponedScrollCancelListener);
                progressDialog.showDelayed(1000);
            }

            postponedScrollToLastMessageQueryIndex = lastLoadIndex;
            fakePostponedScroll = false;
            postponedScrollMessageId = 0;
            postponedScrollIsCanceled = false;
            waitingForLoad.clear();

            waitingForLoad.add(lastLoadIndex);
            AndroidUtilities.runOnUIThread(() -> {
                getMessagesController().loadMessages(dialog_id, mergeDialogId, false, 30, 0, 0, true, 0, classGuid, 0, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
            }, SCROLL_DEBUG_DELAY ? 7500 : 0);
        }
    }

    public void updateTextureViewPosition(boolean needVisibleUpdate, boolean needScroll) {
        if (fragmentView == null || paused) {
            return;
        }
        boolean foundTextureViewMessage = false;
        int count = chatListView.getChildCount();
        for (int a = 0; a < count; a++) {
            View view = chatListView.getChildAt(a);
            if (view instanceof ChatMessageCell) {
                ChatMessageCell messageCell = (ChatMessageCell) view;
                MessageObject messageObject = messageCell.getMessageObject();
                if (videoPlayerContainer != null && (messageObject.isRoundVideo() || messageObject.isVideo()) && !messageObject.isVoiceTranscriptionOpen() && MediaController.getInstance().isPlayingMessage(messageObject)) {
                    ImageReceiver imageReceiver = messageCell.getPhotoImage();
                    videoPlayerContainer.setTranslationX(imageReceiver.getImageX() + messageCell.getX());
                    float translationY = messageCell.getY() + messageCell.getPaddingTop() + imageReceiver.getImageY() + chatListView.getY() - videoPlayerContainer.getTop();
                    videoPlayerContainer.setTranslationY(translationY);
                    FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) videoPlayerContainer.getLayoutParams();
                    if (messageObject.isRoundVideo()) {
                        videoPlayerContainer.setTag(R.id.parent_tag, null);
                        if (layoutParams.width != AndroidUtilities.roundPlayingMessageSize(isSideMenued()) || layoutParams.height != AndroidUtilities.roundPlayingMessageSize(isSideMenued())) {
                            layoutParams.width = layoutParams.height = AndroidUtilities.roundPlayingMessageSize(isSideMenued());
                            aspectRatioFrameLayout.setResizeMode(AspectRatioFrameLayout.RESIZE_MODE_FIT);
                            videoPlayerContainer.setLayoutParams(layoutParams);
                        }
                        float scale = (AndroidUtilities.roundPlayingMessageSize(isSideMenued()) + AndroidUtilities.roundMessageInset * 2) / (float) AndroidUtilities.roundPlayingMessageSize(isSideMenued());
                        float transitionScale = messageCell.getPhotoImage().getImageWidth() / AndroidUtilities.roundPlayingMessageSize(isSideMenued());
                        if (videoPlayerContainer.getScaleX() != transitionScale) {
                            videoPlayerContainer.invalidate();
                            fragmentView.invalidate();
                        }
                        videoPlayerContainer.setPivotX(0);
                        videoPlayerContainer.setPivotY(0);
                        videoPlayerContainer.setScaleX(transitionScale);
                        videoPlayerContainer.setScaleY(transitionScale);
                        videoTextureView.setScaleX(scale);
                        videoTextureView.setScaleY(scale);
                    } else {
                        videoPlayerContainer.setTag(R.id.parent_tag, imageReceiver);
                        if (layoutParams.width != imageReceiver.getImageWidth() || layoutParams.height != imageReceiver.getImageHeight()) {
                            aspectRatioFrameLayout.setResizeMode(AspectRatioFrameLayout.RESIZE_MODE_FILL);
                            layoutParams.width = (int) imageReceiver.getImageWidth();
                            layoutParams.height = (int) imageReceiver.getImageHeight();
                            videoPlayerContainer.setLayoutParams(layoutParams);
                        }
                        videoTextureView.setScaleX(1f);
                        videoTextureView.setScaleY(1f);
                    }
                    fragmentView.invalidate();
                    videoPlayerContainer.invalidate();
                    foundTextureViewMessage = true;
                    break;
                }
            }
        }
        if (needVisibleUpdate && videoPlayerContainer != null) {
            MessageObject messageObject = MediaController.getInstance().getPlayingMessageObject();
            if (messageObject != null && messageObject.eventId == 0) {
                if (!foundTextureViewMessage) {
                    if (checkTextureViewPosition && messageObject.isVideo()) {
                        MediaController.getInstance().cleanupPlayer(true, true);
                    } else {
                        videoPlayerContainer.setTranslationY(-AndroidUtilities.roundPlayingMessageSize(isSideMenued()) - 100);
                        fragmentView.invalidate();
                        if (messageObject.isRoundVideo() || messageObject.isVideo()) {
                            if (checkTextureViewPosition || PipRoundVideoView.getInstance() != null) {
                                MediaController.getInstance().setCurrentVideoVisible(false);
                            } else if (needScroll) {
                                scrollToMessageId(messageObject.getId(), 0, false, 0, true, 0);
                            }
                        }
                    }
                } else {
                    MediaController.getInstance().setCurrentVideoVisible(true);
                    if (messageObject.isRoundVideo() || scrollToVideo) {
                     //   scrollToMessageId(messageObject.getId(), 0, false, 0, true, 0);
                    } else {
                        chatListView.invalidate();
                    }
                }
            }
        }
    }

    public void invalidateMessagesVisiblePart() {
        invalidateMessagesVisiblePart = true;
        if (fragmentView != null) {
            fragmentView.invalidate();
        }
    }

    private Integer findClosest(ArrayList<Integer> arrayList, int target, int[] index) {
        if (arrayList.isEmpty()) {
            return 0;
        }
        Integer val = arrayList.get(0);
        if (target >= val) {
            index[0] = 0;
            return val;
        }
        int n = arrayList.size();
        val = arrayList.get(n - 1);
        if (target <= val) {
            index[0] = n - 1;
            return val;
        }

        int i = 0, j = n, mid = 0;
        while (i < j) {
            mid = (i + j) / 2;

            val = arrayList.get(mid);
            if (val == target) {
                index[0] = mid;
                return val;
            }
            if (target < val) {
                if (mid > 0) {
                    Integer val2 = arrayList.get(mid - 1);
                    if (target > val2) {
                        index[0] = mid - 1;
                        return val2;
                    }
                }
                i = mid + 1;
            } else {
                if (mid > 0) {
                    Integer val2 = arrayList.get(mid - 1);
                    if (target < val2) {
                        index[0] = mid;
                        return val;
                    }
                }
                j = mid;
            }
        }
        index[0] = mid;
        return arrayList.get(mid);
    }

    public void updateMessagesVisiblePart(boolean inLayout) {
        if (chatListView == null || fragmentView == null) {
            return;
        }
        int count = chatListView.getChildCount();
        int height = chatListView.getMeasuredHeight();
        int minPositionHolder = Integer.MAX_VALUE;
        int minPositionDateHolder = Integer.MAX_VALUE;
        int minPositionTopicHolder = Integer.MAX_VALUE;
        int minTopicPositionHolder = Integer.MAX_VALUE;
        View minDateChild = null;
        View minTopicChild = null;
        View minChild = null;
        View minMessageChild = null;
        View minTopicMessageChild = null;
        boolean foundTextureViewMessage = false;
        boolean previousThreadMessageVisible = threadMessageVisible;
        int previousPinnedMessageId = currentPinnedMessageId;
        int maxVisibleId = Integer.MIN_VALUE;
        MessageObject maxVisibleMessageObject = null;
        threadMessageVisible = firstLoading;

        Integer currentReadMaxId = null;
        long threadId = threadMessageId;
        if (threadId != 0 && currentChat != null) {
            currentReadMaxId = replyMaxReadId;
        } else {
            currentReadMaxId = getMessagesController().dialogs_read_inbox_max.get(dialog_id_Long);
        }
        if (currentReadMaxId == null) {
            currentReadMaxId = 0;
        }
        int maxPositiveUnreadId = Integer.MIN_VALUE;
        int maxNegativeUnreadId = Integer.MAX_VALUE;
        int maxUnreadDate = Integer.MIN_VALUE;
        int recyclerChatViewHeight = (contentView.getMeasuredHeight() - (inPreviewMode || isInsideContainer ? 0 : AndroidUtilities.dp(48)) - chatListView.getTop());
        pollsToCheck.clear();
        float clipTop = chatListViewPaddingTop;
        float clipTopicTop = chatListViewPaddingTop + dp(28);
        long currentTime = System.currentTimeMillis();
        int maxAdapterPosition = -1;
        int minAdapterPosition = -1;

        boolean blurEnabled = SharedConfig.chatBlurEnabled() && Color.alpha(Theme.getColor(Theme.key_chat_BlurAlpha)) != 255;

        MessageObject messageStarter = isTopic ? topicStarterMessageObject : threadMessageObject;

        float clipTopFinal = clipTop - chatListViewPaddingVisibleOffset;
        float clipBottomFinal = chatListView.getMeasuredHeight() - blurredViewBottomOffset;

        boolean checkPremiumFloodWait = !UserConfig.getInstance(currentAccount).isPremium();

        for (int a = 0; a < count; a++) {
            View view = chatListView.getChildAt(a);
            MessageObject messageObject = null;
            int adapterPosition = chatListView.getChildAdapterPosition(view);
            if (adapterPosition >= 0) {
                if (adapterPosition > maxAdapterPosition || maxAdapterPosition == -1) {
                    maxAdapterPosition = adapterPosition;
                }
                if (adapterPosition < minAdapterPosition || minAdapterPosition == -1) {
                    minAdapterPosition = adapterPosition;
                }
            }
            final int top = (int) view.getY();
            final int bottom = top + view.getMeasuredHeight();
            ChatMessageCell messageCell = null;
            if (view instanceof ChatMessageCell) {
                messageCell = (ChatMessageCell) view;
            }
            if (messageCell != null) {
                messageCell.isBlurred = (top < clipTop && bottom > clipTop) || (bottom > chatListView.getMeasuredHeight() - blurredViewBottomOffset && top < chatListView.getMeasuredHeight() - blurredViewBottomOffset);
            }

            if (bottom <= clipTopFinal || top > clipBottomFinal) {
                if (messageCell != null) {
                    if (blurEnabled) {
                        messageCell.setVisibleOnScreen(false, 0, 0);
                    } else {
                        messageCell.setVisibleOnScreen(true, 0, 0);
                    }
                }
                continue;
            }
            if (messageCell != null) {
                messageCell.setVisibleOnScreen(true, clipTopFinal - top, bottom - clipBottomFinal);
                if (checkPremiumFloodWait) {
                    if (messageCell.checkLoadCaughtPremiumFloodWait()) {
                        showPremiumFloodWaitBulletin(false);
                        checkPremiumFloodWait = false;
                    } else if (messageCell.checkUploadCaughtPremiumFloodWait()) {
                        showPremiumFloodWaitBulletin(true);
                        checkPremiumFloodWait = false;
                    }
                }
            }

            int viewTop = top >= 0 ? 0 : -top;
            int viewBottom = view.getMeasuredHeight();
            if (viewBottom > height) {
                viewBottom = viewTop + height;
            }
            int keyboardOffset = contentView.getKeyboardHeight();
            if (keyboardOffset < AndroidUtilities.dp(20) && chatActivityEnterView.isPopupShowing() || chatActivityEnterView.panelAnimationInProgress()) {
                keyboardOffset = chatActivityEnterView.getEmojiPadding();
            }

            final boolean visibleToBeRead = !BaseFragment.hasSheets(this) && (currentChat == null || !ChatObject.isChannelAndNotMegaGroup(currentChat) || view.getMeasuredHeight() > 0 && top + view.getMeasuredHeight() * (messageCell == null || messageCell.getCurrentPosition() == null ? .80f : 1f) < clipBottomFinal);

            final float visibleTop = getServiceTop(view);
            final int visibleBackgroundHeight = getServiceHeight(view);
            boolean hasTopicSeparator = false;

            if (messageCell != null) {
                messageObject = messageCell.getMessageObject();
                if (messageObject.getDialogId() == dialog_id && messageObject.getId() > maxVisibleId) {
                    maxVisibleId = messageObject.getId();
                    maxVisibleMessageObject = messageObject;
                }
                hasTopicSeparator = messageCell.topicSeparator != null;

                messageCell.setParentBounds((SharedConfig.chatBlurEnabled() && contentView.DRAW_USING_RENDERNODE() ? 0 : chatListViewPaddingTop) - chatListViewPaddingVisibleOffset - dp(4), chatListView.getMeasuredHeight() - blurredViewBottomOffset);
                messageCell.setVisiblePart(viewTop, viewBottom - viewTop, recyclerChatViewHeight, 0, view.getY() + (isKeyboardVisible() ? chatListView.getTop() : actionBar.getMeasuredHeight()) - contentView.getBackgroundTranslationY() - (1f - contentPanTranslationT) * chatListViewPaddingTop, contentView.getMeasuredWidth(), contentView.getBackgroundSizeY(), blurredViewTopOffset, blurredViewBottomOffset);

                if (messageObject.isSponsored()) {
                    final float rTop = ViewPositionWatcher.computeYCoordinateInParent(messageCell, contentView);
                    final boolean isVisible = messageObject.viewsReloaded || rTop < contentView.getMeasuredHeight() - dp(9 + 32) - windowInsetsStateHolder.getAnimatedMaxBottomInset() - inputIslandHeightCurrent;
                    messageCell.setSponsoredMessageVisible(isVisible, isVisible);
                    if (isVisible) {
                        markSponsoredAsRead(messageObject);
                    }
                }

                if (!threadMessageVisible && messageStarter != null && (messageObject == messageStarter || isTopic && messageObject != null && messageObject.getId() == messageStarter.getId()) && messageCell.getBottom() > chatListViewPaddingTop) {
                    threadMessageVisible = true;
                }
                if (videoPlayerContainer != null && (messageObject.isVideo() || messageObject.isRoundVideo()) && !messageObject.isVoiceTranscriptionOpen() && MediaController.getInstance().isPlayingMessage(messageObject)) {
                    ImageReceiver imageReceiver = messageCell.getPhotoImage();
                    if (top + imageReceiver.getImageY2() < 0) {
                        foundTextureViewMessage = false;
                    } else {
                        videoPlayerContainer.setTranslationX(imageReceiver.getImageX() + messageCell.getX());

                        float translationY = messageCell.getY() + messageCell.getPaddingTop() + imageReceiver.getImageY() + chatListView.getY() - videoPlayerContainer.getTop();
                        videoPlayerContainer.setTranslationY(translationY);
                        fragmentView.invalidate();
                        videoPlayerContainer.invalidate();
                        foundTextureViewMessage = true;
                    }
                }
                if (startFromVideoTimestamp >= 0 && fragmentOpened && !chatListView.isFastScrollAnimationRunning() && startFromVideoMessageId == messageObject.getId() && (messageObject.isVideo() || messageObject.isRoundVideo() || messageObject.isVoice() || messageObject.isMusic())) {
                    messageObject.forceSeekTo = startFromVideoTimestamp / (float) messageObject.getDuration();
                    MessageObject finalMessage = messageObject;
                    AndroidUtilities.runOnUIThread(() -> {
                        if (finalMessage.isVideo()) {
                            openPhotoViewerForMessage(null, finalMessage);
                        } else {
                            MediaController.getInstance().playMessage(finalMessage);
                        }
                    }, 40);
                    startFromVideoTimestamp = -1;
                }

                if (messageObject != null && fragmentOpened && openAnimationEnded && (chatListItemAnimator == null || !chatListItemAnimator.isRunning()) && messageCell.checkUnreadReactions(clipTop, chatListView.getMeasuredHeight() - blurredViewBottomOffset)) {
                    reactionsMentionCount--;
                    getMessagesStorage().markMessageReactionsAsRead(getDialogId(), getTopicId(), messageObject.getId(), true);
                    if (reactionsMentionCount <= 0) {
                        getMessagesController().markReactionsAsRead(dialog_id, getTopicId());
                    }
                    if (reactionsMentionCount >= 0) {
                        TLRPC.MessagePeerReaction reaction = messageCell.getMessageObject().getRandomUnreadReaction();
                        if (reaction != null) {
                            ReactionsLayoutInBubble.VisibleReaction visibleReaction =  ReactionsLayoutInBubble.VisibleReaction.fromTL(reaction.reaction);
                            ReactionsEffectOverlay.show(ChatActivity.this, null, messageCell, null, 0, 0, visibleReaction, currentAccount, reaction.big ? ReactionsEffectOverlay.LONG_ANIMATION : ReactionsEffectOverlay.SHORT_ANIMATION);
                            ReactionsEffectOverlay.startAnimation();
                        }
                        messageCell.markReactionsAsRead();
                    } else {
                        messageCell.markReactionsAsRead();
                        reactionsMentionCount = 0;
                    }
                    updateReactionsMentionButton(true);
                }
                getDownloadController().checkUnviewedDownloads(messageCell.getId(), dialog_id);
                boolean allowPlayEffect = messageObject.getEffect() != null || ((messageObject.messageOwner.media != null && !messageObject.messageOwner.media.nopremium) || (messageObject.isAnimatedEmojiStickerSingle() && dialog_id > 0));
                if ((chatListItemAnimator == null || !chatListItemAnimator.isRunning()) && (!messageObject.isOutOwner() || messageObject.forcePlayEffect) && allowPlayEffect && !messageObject.messageOwner.premiumEffectWasPlayed && (messageObject.isPremiumSticker() || messageCell.getEffect() != null || messageObject.isAnimatedEmojiStickerSingle()) && emojiAnimationsOverlay.isIdle() && emojiAnimationsOverlay.checkPosition(messageCell, chatListViewPaddingTop, chatListView.getMeasuredHeight() - blurredViewBottomOffset)) {
                    emojiAnimationsOverlay.onTapItem(messageCell, ChatActivity.this, false);
                } else if (messageObject.isAnimatedAnimatedEmoji()) {
                    emojiAnimationsOverlay.preloadAnimation(messageCell);
                }
            } else if (view instanceof ChatActionCell) {
                ChatActionCell cell = (ChatActionCell) view;
                messageObject = cell.getMessageObject();
                if (messageObject != null && messageObject.getDialogId() == dialog_id && messageObject.getId() > maxVisibleId) {
                    maxVisibleId = Math.max(maxVisibleId, messageObject.getId());
                }
                hasTopicSeparator = cell.topicSeparator != null;
                if (messageObject != null && fragmentOpened && openAnimationEnded && (chatListItemAnimator == null || !chatListItemAnimator.isRunning()) && cell.checkUnreadReactions(clipTop, chatListView.getMeasuredHeight() - blurredViewBottomOffset)) {
                    reactionsMentionCount--;
                    getMessagesStorage().markMessageReactionsAsRead(getDialogId(), getTopicId(), messageObject.getId(), true);
                    if (reactionsMentionCount <= 0) {
                        getMessagesController().markReactionsAsRead(dialog_id, getTopicId());
                    }
                    if (reactionsMentionCount >= 0) {
                        TLRPC.MessagePeerReaction reaction = cell.getMessageObject().getRandomUnreadReaction();
                        if (reaction != null) {
                            ReactionsLayoutInBubble.VisibleReaction visibleReaction =  ReactionsLayoutInBubble.VisibleReaction.fromTL(reaction.reaction);
                            ReactionsEffectOverlay.show(ChatActivity.this, null, cell, null, 0, 0, visibleReaction, currentAccount, reaction.big ? ReactionsEffectOverlay.LONG_ANIMATION : ReactionsEffectOverlay.SHORT_ANIMATION);
                            ReactionsEffectOverlay.startAnimation();
                        }
                        cell.markReactionsAsRead();
                    } else {
                        reactionsMentionCount = 0;
                    }
                    updateReactionsMentionButton(true);
                }
                cell.setVisiblePart(visibleTop, visibleBackgroundHeight);
            } else if (view instanceof BotHelpCell) {
                view.invalidate();
            } else if (view instanceof ChatLoadingCell) {
                ((ChatLoadingCell) view).setVisiblePart(visibleTop, visibleBackgroundHeight);
            } else if (view instanceof UserInfoCell) {
                ((UserInfoCell) view).setVisiblePart(visibleTop, visibleBackgroundHeight);
            }
            if (isAllChats()) {
                final int topicBottom = hasTopicSeparator ? top + view.getPaddingTop() : bottom;
                if (bottom <= clipTopicTop) {
                    if (view instanceof ChatActionCell) {
                        ((ChatActionCell) view).setShowTopic(false);
                    } else if (view instanceof ChatMessageCell) {
                        ((ChatMessageCell) view).setShowTopic(false);
                    }
                } else {
                    if (topicBottom < minTopicPositionHolder) {
                        minTopicPositionHolder = topicBottom;
                        if (view instanceof ChatActionCell) {
                            minTopicMessageChild = view;
                        } else if (view instanceof ChatMessageCell) {
                            minTopicMessageChild = view;
                        }
                    }
                }
                if (topicBottom >= clipTopicTop) {
                    if (hasTopicSeparator && (chatListItemAnimator == null || (!chatListItemAnimator.willRemoved(view) && !chatListItemAnimator.willAddedFromAlpha(view)))) {
                        if (view instanceof ChatActionCell) {
                            ((ChatActionCell) view).setShowTopic(true);
                            if (topicBottom < minPositionTopicHolder) {
                                minPositionTopicHolder = topicBottom;
                                minTopicChild = view;
                            }
                        } else if (view instanceof ChatMessageCell) {
                            ((ChatMessageCell) view).setShowTopic(true);
                            if (topicBottom < minPositionTopicHolder) {
                                minPositionTopicHolder = topicBottom;
                                minTopicChild = view;
                            }
                        }
                    }
                }
            }
            if (chatMode != MODE_SCHEDULED && messageObject != null) {
                int id = messageObject.getId();
                if (
                    !isThreadChat() && visibleToBeRead && (!messageObject.isOut() && messageObject.isUnread() || messageObject.messageOwner.from_scheduled && id > currentReadMaxId) ||
                     (isThreadChat() || ChatObject.isMonoForum(currentChat)) && id > 0 && id > currentReadMaxId && id > replyMaxReadId
                ) {
                    MessageObject.GroupedMessages group = getValidGroupedMessage(messageObject);
                    if (group != null) {
                        for (MessageObject msg : group.messages) {
                            final int msg_id = msg.getId();
                            if (msg_id > 0) {
                                maxPositiveUnreadId = Math.max(maxPositiveUnreadId, msg_id);
                            }
                            if (msg_id < 0 && !isThreadChat()) {
                                maxNegativeUnreadId = Math.min(maxNegativeUnreadId, msg_id);
                            }
                            maxUnreadDate = Math.max(maxUnreadDate, msg.messageOwner.date);
                        }
                    } else {
                        if (id > 0) {
                            maxPositiveUnreadId = Math.max(maxPositiveUnreadId, messageObject.getId());
                        }
                        if (id < 0 && !isThreadChat()) {
                            maxNegativeUnreadId = Math.min(maxNegativeUnreadId, messageObject.getId());
                        }
                        maxUnreadDate = Math.max(maxUnreadDate, messageObject.messageOwner.date);
                    }
                }
                if (messageObject.type == MessageObject.TYPE_POLL && messageObject.getId() > 0) {
                    pollsToCheck.add(messageObject);
                }
            }
            if (bottom <= clipTop) {
                if (view instanceof ChatActionCell && messageObject != null && messageObject.isDateObject) {
                    view.setAlpha(0);
                }
            } else {
                int position = view.getBottom();
                if (position < minPositionHolder) {
                    minPositionHolder = position;
                    if (view instanceof ChatMessageCell || view instanceof ChatActionCell) {
                        minMessageChild = view;
                    }
                    minChild = view;
                }
                if (chatListItemAnimator == null || (!chatListItemAnimator.willRemoved(view) && !chatListItemAnimator.willAddedFromAlpha(view))) {
                    if (view instanceof ChatActionCell && messageObject != null && messageObject.isDateObject) {
                        if (view.getAlpha() != 1.0f) {
                            view.setAlpha(1.0f);
                        }
                        if (position < minPositionDateHolder) {
                            minPositionDateHolder = position;
                            minDateChild = view;
                        }
                    }
                }
            }
        }
        currentPinnedMessageId = 0;
        if (!pinnedMessageIds.isEmpty() || (isTopic && maxPinnedMessageId != 0)) {
            if (maxVisibleId == Integer.MIN_VALUE) {
                if (startLoadFromMessageId != 0) {
                    maxVisibleId = startLoadFromMessageId;
                } else if (!pinnedMessageIds.isEmpty()) {
                    maxVisibleId = pinnedMessageIds.get(0) + 1;
                }
            } else if (maxVisibleId < 0) {
                int idx = messages.indexOf(maxVisibleMessageObject);
                if (idx >= 0) {
                    for (int a = idx - 1; a >= 0; a--) {
                        MessageObject object = messages.get(a);
                        if (object.getId() > 0) {
                            maxVisibleId = object.getId();
                            break;
                        }
                    }
                    if (maxVisibleId < 0) {
                        for (int a = idx + 1, N = messages.size(); a < N; a++) {
                            MessageObject object = messages.get(a);
                            if (object.getId() > 0) {
                                maxVisibleId = object.getId();
                                break;
                            }
                        }
                    }
                }
            }
            currentPinnedMessageId = findClosest(pinnedMessageIds, forceNextPinnedMessageId != 0 ? forceNextPinnedMessageId : maxVisibleId, currentPinnedMessageIndex);
            if (!inMenuMode && !loadingPinnedMessagesList && !pinnedEndReached && (isTopic || (!pinnedMessageIds.isEmpty() && currentPinnedMessageIndex[0] > pinnedMessageIds.size() - 2))) {
                getMediaDataController().loadPinnedMessages(dialog_id, maxPinnedMessageId, 0);
                loadingPinnedMessagesList = true;
            }
        }
        getMessagesController().addToPollsQueue(dialog_id, pollsToCheck);
        chatMessagesMetadataController.checkMessages(chatAdapter, maxAdapterPosition, minAdapterPosition, currentTime);
        if (videoPlayerContainer != null) {
            if (!foundTextureViewMessage) {
                MessageObject messageObject = MediaController.getInstance().getPlayingMessageObject();
                if (messageObject != null) {
                    if (checkTextureViewPosition && messageObject.isVideo()) {
                        MediaController.getInstance().cleanupPlayer(true, true);
                    } else {
                        videoPlayerContainer.setTranslationY(-AndroidUtilities.roundPlayingMessageSize(isSideMenued()) - 100);
                        fragmentView.invalidate();
                        if ((messageObject.isRoundVideo() || messageObject.isVideo()) && messageObject.eventId == 0 && checkTextureViewPosition && !chatListView.isFastScrollAnimationRunning()) {
                            MediaController.getInstance().setCurrentVideoVisible(false);
                        }
                    }
                }
            } else {
                MediaController.getInstance().setCurrentVideoVisible(true);
            }
        }
        if (minMessageChild != null) {
            MessageObject messageObject;
            if (minMessageChild instanceof ChatMessageCell) {
                messageObject = ((ChatMessageCell) minMessageChild).getMessageObject();
            } else {
                messageObject = ((ChatActionCell) minMessageChild).getMessageObject();
            }
            if (messageObject != null && messageObject.messageOwner != null) {
                floatingDateView.setCustomDate(messageObject.messageOwner.date, chatMode == MODE_SCHEDULED, true);
            }
        }
        if (minTopicMessageChild != null) {
            MessageObject messageObject;
            if (minTopicMessageChild instanceof ChatMessageCell) {
                messageObject = ((ChatMessageCell) minTopicMessageChild).getMessageObject();
            } else {
                messageObject = ((ChatActionCell) minTopicMessageChild).getMessageObject();
            }
            if (messageObject != null && messageObject.messageOwner != null) {
                floatingTopicSeparator.set(messageObject);
            }
        }
        currentFloatingDateOnScreen = false;
        currentFloatingTopicOnScreen = false;
        currentFloatingTopIsNotMessage = !(minChild instanceof ChatMessageCell || minChild instanceof ChatActionCell);
        if (minDateChild != null) {
            boolean showFloatingView = false;
            if (minDateChild.getY() > clipTop || currentFloatingTopIsNotMessage) {
                if (minDateChild.getAlpha() != 1.0f) {
                    minDateChild.setAlpha(1.0f);
                }
                if (chatListView.getChildAdapterPosition(minDateChild) == chatAdapter.messagesStartRow + (reversed ? 0 : messages.size() - 1)) {
                    if (minDateChild.getAlpha() != 1.0f) {
                        minDateChild.setAlpha(1.0f);
                    }
                    if (floatingDateAnimation != null) {
                        floatingDateAnimation.cancel();
                        floatingDateAnimation = null;
                    }
                    floatingDateView.setTag(null);
                    floatingDateView.setAlpha(0);
                    currentFloatingDateOnScreen = false;
                } else {
                    hideFloatingDateView(!currentFloatingTopIsNotMessage);
                }
            } else {
                if (minDateChild.getAlpha() != 0.0f) {
                    minDateChild.setAlpha(0.0f);
                }
                showFloatingView = true;
            }
            float offset = minDateChild.getY() + minDateChild.getMeasuredHeight() - clipTop;
            if (offset > floatingDateView.getMeasuredHeight() && offset < floatingDateView.getMeasuredHeight() * 2) {
                if (chatListView.getChildAdapterPosition(minDateChild) == chatAdapter.messagesStartRow + (reversed ? 0 : messages.size() - 1)) {
                    showFloatingView = false;
                    if (minDateChild.getAlpha() != 1.0f) {
                        minDateChild.setAlpha(1.0f);
                    }
                    if (floatingDateAnimation != null) {
                        floatingDateAnimation.cancel();
                        floatingDateAnimation = null;
                    }
                    floatingDateView.setTag(null);
                    floatingDateView.setAlpha(0);
                } else {
                    floatingDateViewOffset = -floatingDateView.getMeasuredHeight() * 2 + offset;
                }
            } else {
                floatingDateViewOffset = 0;
            }
            if (chatMode == MODE_QUICK_REPLIES) {
                showFloatingView = false;
            }
            if (showFloatingView) {
                if (floatingDateAnimation != null) {
                    floatingDateAnimation.cancel();
                    floatingDateAnimation = null;
                }
                if (floatingDateView.getTag() == null) {
                    floatingDateView.setTag(1);
                }
                if (floatingDateView.getAlpha() != 1.0f) {
                    floatingDateView.setAlpha(1.0f);
                }
                currentFloatingDateOnScreen = true;
            }
        } else {
            hideFloatingDateView(true);
            floatingDateViewOffset = 0;
        }
        if (minTopicChild != null) {
            boolean showFloatingView = false;
            if (minTopicChild.getY() > clipTopicTop || currentFloatingTopIsNotMessage) {
                if (minTopicChild instanceof ChatActionCell) {
                    ((ChatActionCell) minTopicChild).setShowTopic(true);
                } else if (minTopicChild instanceof ChatMessageCell) {
                    ((ChatMessageCell) minTopicChild).setShowTopic(true);
                }
                if (chatListView.getChildAdapterPosition(minTopicChild) == chatAdapter.messagesStartRow + (reversed ? 0 : messages.size() - 1)) {
                    if (minTopicChild instanceof ChatActionCell) {
                        ((ChatActionCell) minTopicChild).setShowTopic(true);
                    } else if (minTopicChild instanceof ChatMessageCell) {
                        ((ChatMessageCell) minTopicChild).setShowTopic(true);
                    }
                    if (floatingTopicAnimation != null) {
                        floatingTopicAnimation.cancel();
                        floatingTopicAnimation = null;
                    }
                    floatingTopicSeparator.setTag(null);
                    currentFloatingTopicOnScreen = false;
                } else {
                    hideFloatingTopicView(!currentFloatingTopIsNotMessage);
                }
            } else {
                if (minTopicChild instanceof ChatActionCell) {
                    ((ChatActionCell) minTopicChild).setShowTopic(false);
                } else if (minTopicChild instanceof ChatMessageCell) {
                    ((ChatMessageCell) minTopicChild).setShowTopic(false);
                }
                showFloatingView = true;
            }
            float offset = minTopicChild.getY() + minTopicChild.getPaddingTop() - clipTopicTop;
            if (offset > floatingTopicSeparator.getMeasuredHeight() && offset < floatingTopicSeparator.getMeasuredHeight() * 2) {
                if (chatListView.getChildAdapterPosition(minTopicChild) == chatAdapter.messagesStartRow + (reversed ? 0 : messages.size() - 1)) {
                    showFloatingView = false;
                    if (minTopicChild instanceof ChatActionCell) {
                        ((ChatActionCell) minTopicChild).setShowTopic(true);
                    } else if (minTopicChild instanceof ChatMessageCell) {
                        ((ChatMessageCell) minTopicChild).setShowTopic(true);
                    }
                    if (floatingTopicAnimation != null) {
                        floatingTopicAnimation.cancel();
                        floatingTopicAnimation = null;
                    }
                    floatingTopicSeparator.setTag(null);
                } else {
                    floatingTopicViewOffset = -floatingTopicSeparator.getMeasuredHeight() * 2 + offset;
                }
            } else {
                floatingTopicViewOffset = 0;
            }
            if (chatMode == MODE_QUICK_REPLIES) {
                showFloatingView = false;
            }
            if (showFloatingView) {
                if (floatingTopicAnimation != null) {
                    floatingTopicAnimation.cancel();
                    floatingTopicAnimation = null;
                }
                if (floatingTopicSeparator.getTag() == null) {
                    floatingTopicSeparator.setTag(1);
                }
                currentFloatingTopicOnScreen = true;
            }
        } else {
            hideFloatingTopicView(true);
            floatingTopicViewOffset = 0;
        }

        if (isThreadChat() && (!isTopic || pinnedOnlyStarterMessage())) {
            if (previousThreadMessageVisible != threadMessageVisible) {
                AndroidUtilities.runOnUIThread(() -> {
                    updatePinnedMessageView(openAnimationStartTime != 0 && SystemClock.elapsedRealtime() >= openAnimationStartTime + 150);
                });
            }
        } else {
            if (currentPinnedMessageId != 0) {
                MessageObject object = pinnedMessageObjects.get(currentPinnedMessageId);
                if (object == null) {
                    object = messagesDict[0].get(currentPinnedMessageId);
                }
                if (object == null) {
                    if (loadingPinnedMessages.indexOfKey(currentPinnedMessageId) < 0) {
                        loadingPinnedMessages.put(currentPinnedMessageId, true);
                        ArrayList<Integer> ids = new ArrayList<>();
                        ids.add(currentPinnedMessageId);
                        getMediaDataController().loadPinnedMessages(dialog_id, ChatObject.isChannel(currentChat) ? currentChat.id : 0, ids, true);
                    }
                    currentPinnedMessageId = previousPinnedMessageId;
                }
            } else if (previousPinnedMessageId != 0 && !pinnedMessageIds.isEmpty()) {
                currentPinnedMessageId = previousPinnedMessageId;
            }
            boolean animated = (fromPullingDownTransition && fragmentView.getVisibility() == View.VISIBLE) || (openAnimationStartTime != 0 && SystemClock.elapsedRealtime() >= openAnimationStartTime + 150);
            if (previousPinnedMessageId != currentPinnedMessageId) {
                int animateToNext;
                if (previousPinnedMessageId == 0) {
                    animateToNext = 0;
                } else if (previousPinnedMessageId > currentPinnedMessageId) {
                    animateToNext = 1;
                } else {
                    animateToNext = 2;
                }

                AndroidUtilities.runOnUIThread(() -> {
                    updatePinnedMessageView(animated, animateToNext);
                });
            } else if (isTopic && currentPinnedMessageId != 0 && (pinnedMessageView == null || pinnedMessageView.getTag() != null)) {
                AndroidUtilities.runOnUIThread(() -> {
                    updatePinnedMessageView(animated, 0);
                });
            } else {
                updatePinnedListButton(animated);
            }
        }
        if (floatingDateView != null) {
            floatingDateView.setTranslationX(getSideMenuWidth() / 2f);
            floatingDateView.setTranslationY(chatListView.getTranslationY() + chatListViewPaddingTop + floatingDateViewOffset - dp(4));
        }
        updateFloatingTopicView();
        invalidateChatListViewTopPadding();
        if (!firstLoading && !paused && !inPreviewMode && (chatMode == 0 || chatMode == MODE_SUGGESTIONS) && !getMessagesController().ignoreSetOnline) {
            int scheduledRead = 0;
            if ((maxPositiveUnreadId != Integer.MIN_VALUE || maxNegativeUnreadId != Integer.MAX_VALUE)) {
                int counterDecrement = 0;
                for (int a = 0; a < messages.size(); a++) {
                    MessageObject messageObject = messages.get(a);
                    int id = messageObject.getId();
                    if (maxPositiveUnreadId != Integer.MIN_VALUE) {
                        if (id > 0 && id <= maxPositiveUnreadId && (messageObject.messageOwner.from_scheduled && id > currentReadMaxId || messageObject.isUnread() && !messageObject.isOut())) {
                            if (messageObject.messageOwner.from_scheduled) {
                                scheduledRead++;
                            } else {
                                messageObject.setIsRead();
                            }
                            counterDecrement++;
                        }
                    }
                    if (maxNegativeUnreadId != Integer.MAX_VALUE) {
                        if (id < 0 && id >= maxNegativeUnreadId && messageObject.isUnread()) {
                            messageObject.setIsRead();
                            counterDecrement++;
                        }
                    }
                }
                if (forwardEndReached[0] && maxPositiveUnreadId == minMessageId[0] || maxNegativeUnreadId == minMessageId[0]) {
                    newUnreadMessageCount = 0;
                } else {
                    newUnreadMessageCount -= counterDecrement;
                    if (newUnreadMessageCount < 0) {
                        newUnreadMessageCount = 0;
                    }
                }
                if (inLayout) {
                    AndroidUtilities.runOnUIThread(this::inlineUpdate1);
                } else {
                    inlineUpdate1();
                }
                getMessagesController().markDialogAsRead(dialog_id, maxPositiveUnreadId, maxNegativeUnreadId, maxUnreadDate, false, threadId, counterDecrement, maxPositiveUnreadId == minMessageId[0] || maxNegativeUnreadId == minMessageId[0], scheduledRead);
                firstUnreadSent = true;
            } else if (!firstUnreadSent && currentEncryptedChat == null) {
                if (chatLayoutManager.findFirstVisibleItemPosition() == 0) {
                    newUnreadMessageCount = 0;
                    if (inLayout) {
                        AndroidUtilities.runOnUIThread(this::inlineUpdate2);
                    } else {
                        inlineUpdate2();
                    }
                    getMessagesController().markDialogAsRead(dialog_id, minMessageId[0], minMessageId[0], maxDate[0], false, threadId, 0, true, scheduledRead);
                    if (isTopic && replyOriginalChat != null) {
                        getMessagesStorage().updateRepliesMaxReadId(replyOriginalChat.id, replyOriginalMessageId, Math.max(maxPositiveUnreadId, replyMaxReadId), 0, true);
                    }
                    firstUnreadSent = true;
                }
            }

            if (threadId != 0 && maxPositiveUnreadId > 0 && replyMaxReadId != maxPositiveUnreadId && (replyOriginalChat != null || UserObject.isBotForum(currentUser) || ChatObject.isMonoForum(currentChat) && ChatObject.canManageMonoForum(currentAccount, currentChat))) {
                replyMaxReadId = maxPositiveUnreadId;
                long chatId = currentChat != null ? currentChat.id : -currentUser.id;
                getMessagesStorage().updateRepliesMaxReadId(chatId, threadId, replyMaxReadId, newUnreadMessageCount, true);
            } else if (threadId != 0 && maxPositiveUnreadId > 0 && replyMaxReadId != maxPositiveUnreadId && replyOriginalChat != null) {
                replyMaxReadId = maxPositiveUnreadId;
                getMessagesStorage().updateRepliesMaxReadId(replyOriginalChat.id, replyOriginalMessageId, replyMaxReadId, newUnreadMessageCount, true);
                if (!isTopic) {
                    getNotificationCenter().postNotificationName(NotificationCenter.commentsRead, replyOriginalChat.id, replyOriginalMessageId, replyMaxReadId);
                }
            }
        }
        if (progressView2 != null) {
            progressView2.invalidate();
        }
    }

    private float getServiceTop(View view) {
        return view.getY() + (isKeyboardVisible() ? chatListView.getTop() : actionBar.getMeasuredHeight()) - contentView.getBackgroundTranslationY() - (1f - contentPanTranslationT) * chatListViewPaddingTop;
    }

    public int getServiceHeight(View view) {
        return contentView.getBackgroundSizeY();
    }

    private boolean pinnedOnlyStarterMessage() {
        return pinnedMessageIds.size() == 1 && topicStarterMessageObject != null && pinnedMessageIds.get(0) == topicStarterMessageObject.getId();
    }

    private void inlineUpdate1() {
        if (prevSetUnreadCount != newUnreadMessageCount) {
            prevSetUnreadCount = newUnreadMessageCount;
            sideControlsButtonsLayout.setButtonCount(ChatActivitySideControlsButtonsLayout.BUTTON_PAGE_DOWN, newUnreadMessageCount, openAnimationEnded);
        }
    }

    private void inlineUpdate2() {
        if (prevSetUnreadCount != newUnreadMessageCount) {
            prevSetUnreadCount = newUnreadMessageCount;
            sideControlsButtonsLayout.setButtonCount(ChatActivitySideControlsButtonsLayout.BUTTON_PAGE_DOWN,  newUnreadMessageCount, true);
        }
    }

    private void toggleMute(boolean instant) {
        boolean muted = getMessagesController().isDialogMuted(dialog_id, getTopicId());
        if (!muted) {
            if (instant) {
                getNotificationsController().muteDialog(dialog_id, getTopicId(), true);
            } else {
                BottomSheet alert = AlertsCreator.createMuteAlert(this, dialog_id, getTopicId(), themeDelegate);
                alert.setCalcMandatoryInsets(isKeyboardVisible());
                showDialog(alert);
            }
        } else {
            getNotificationsController().muteDialog(dialog_id, getTopicId(), false);
            if (!instant) {
                BulletinFactory.createMuteBulletin(this, false, themeDelegate).show();
            }
        }
    }

    private int getScrollOffsetForMessage(MessageObject object) {
        return getScrollOffsetForMessage(getHeightForMessage(object, !TextUtils.isEmpty(highlightMessageQuote))) - scrollOffsetForQuote(object);
    }
    private int getScrollOffsetForMessage(int messageHeight) {
        return (int) Math.max(-AndroidUtilities.dp(2), (chatListView.getMeasuredHeight() - blurredViewBottomOffset - chatListViewPaddingTop - windowInsetsStateHolder.getCurrentMaxBottomInset() - dp(44 + 9) - messageHeight) / 2);
    }

    private int scrollOffsetForQuote(MessageObject object) {
        if (TextUtils.isEmpty(highlightMessageQuote) || object == null) {
            if (dummyMessageCell != null) {
                dummyMessageCell.computedGroupCaptionY = 0;
                dummyMessageCell.computedCaptionLayout = null;
            }
            return 0;
        }

        int offsetY;
        CharSequence text;
        ArrayList<MessageObject.TextLayoutBlock> textLayoutBlocks;
        if (object.getGroupId() != 0) {
            MessageObject.GroupedMessages group = getGroup(object.getGroupId());
            if (dummyMessageCell == null || dummyMessageCell.computedCaptionLayout == null || group == null || group.captionMessage == null) {
                if (dummyMessageCell != null) {
                    dummyMessageCell.computedGroupCaptionY = 0;
                    dummyMessageCell.computedCaptionLayout = null;
                }
                return 0;
            }
            offsetY = dummyMessageCell.computedGroupCaptionY;
            text = group.captionMessage.caption;
            textLayoutBlocks = dummyMessageCell.computedCaptionLayout.textLayoutBlocks;
        } else if (!TextUtils.isEmpty(object.caption) && dummyMessageCell != null && dummyMessageCell.captionLayout != null) {
            offsetY = (int) dummyMessageCell.captionY;
            text = object.caption;
            textLayoutBlocks = dummyMessageCell.captionLayout.textLayoutBlocks;
        } else {
            offsetY = 0;
            text = object.messageText;
            textLayoutBlocks = object.textLayoutBlocks;
            if (dummyMessageCell != null && dummyMessageCell.linkPreviewAbove) {
                offsetY += dummyMessageCell.linkPreviewHeight + AndroidUtilities.dp(10);
            }
        }
        if (dummyMessageCell != null) {
            dummyMessageCell.computedGroupCaptionY = 0;
            dummyMessageCell.computedCaptionLayout = null;
        }
        if (textLayoutBlocks == null || text == null) {
            return 0;
        }

        int index = MessageObject.findQuoteStart(text.toString(), highlightMessageQuote, highlightMessageQuoteOffset);
        if (index < 0) {
            return 0;
        }

        for (int i = 0; i < textLayoutBlocks.size(); ++i) {
            MessageObject.TextLayoutBlock block = textLayoutBlocks.get(i);
            StaticLayout layout = block.textLayout;
            String layoutText = layout.getText().toString();
            if (index > block.charactersOffset) {
                final float y;
                if (index - block.charactersOffset > layoutText.length() - 1) {
                    y = offsetY + (int) (block.textYOffset(textLayoutBlocks) + block.padTop + block.height);
                } else {
                    y = offsetY + block.textYOffset(textLayoutBlocks) + block.padTop + layout.getLineTop(layout.getLineForOffset(index - block.charactersOffset));
                }
                if (y > AndroidUtilities.displaySize.y * (isKeyboardVisible() ? .7f : .5f)) {
                    return (int) (y - AndroidUtilities.displaySize.y * (isKeyboardVisible() ? .7f : .5f));
                }
                return 0;
            }
        }
        return 0;
    }

    private int getHeightForMessage(MessageObject object, boolean withGroupCaption) {
        if (getParentActivity() == null) {
            return 0;
        }
        if (dummyMessageCell == null) {
            dummyMessageCell = new ChatMessageCell(getParentActivity(), currentAccount, true, sharedResources, themeDelegate);
        }
        dummyMessageCell.isChat = currentChat != null || UserObject.isUserSelf(currentUser);
        dummyMessageCell.isSavedChat = chatMode == MODE_SAVED;
        dummyMessageCell.isSavedPreviewChat = chatMode == MODE_SAVED && isInsideContainer;
        dummyMessageCell.isBot = currentUser != null && currentUser.bot;
        dummyMessageCell.isMegagroup = ChatObject.isChannel(currentChat) && currentChat.megagroup;
        dummyMessageCell.isAllChats = isAllChats();
        dummyMessageCell.isSideMenued = isSideMenued();
        dummyMessageCell.isSideMenuEnabled = isSideMenuEnabled();
        return dummyMessageCell.computeHeight(object, groupedMessagesMap.get(object.getGroupId()), withGroupCaption);
    }

    private void startMessageUnselect() {
        if (unselectRunnable != null) {
            AndroidUtilities.cancelRunOnUIThread(unselectRunnable);
        }
        unselectRunnable = () -> {
            highlightMessageId = Integer.MAX_VALUE;
            highlightMessageQuoteFirst = false;
            highlightMessageQuoteFirstTime = 0;
            highlightMessageQuote = null;
            highlightTaskId = null;
            highlightMessageQuoteOffset = -1;
            showNoQuoteAlert = false;
            updateVisibleRows();
            unselectRunnable = null;
        };
        AndroidUtilities.runOnUIThread(unselectRunnable, highlightMessageQuote != null ? 2500 : 1000);
    }

    private void removeSelectedMessageHighlight() {
        if (highlightMessageQuote != null || highlightTaskId != null) {
            return;
        }
        if (unselectRunnable != null) {
            AndroidUtilities.cancelRunOnUIThread(unselectRunnable);
            unselectRunnable = null;
        }
        highlightMessageId = Integer.MAX_VALUE;
        highlightMessageQuoteFirst = false;
        highlightMessageQuoteFirstTime = 0;
        highlightMessageQuote = null;
        highlightTaskId = null;
    }

    private AlertDialog progressDialog;
    private int nextScrollToMessageId;
    private int nextScrollFromMessageId;
    private boolean nextScrollSelect;
    private int nextScrollLoadIndex;
    private boolean nextScrollForce;
    private int nextScrollForcePinnedMessageId;

    public static final int PROGRESS_REPLY = 0;
    public static final int PROGRESS_LINK = 1;
    public static final int PROGRESS_INSTANT = 2;
    public static final int PROGRESS_BOT_BUTTON = 3;
    public static final int PROGRESS_GIFT = 4;
    public static final int PROGRESS_PAID_MEDIA = 5;
    public static final int PROGRESS_FORWARD = 6;

    private int progressDialogAtMessageId;
    private int progressDialogAtMessageType;
    private CharacterStyle progressDialogLinkSpan;
    private String progressDialogBotButtonUrl;
    private Browser.Progress progressDialogCurrent;
    private void resetProgressDialogLoading() {
        progressDialogLinkSpan = null;
        progressDialogAtMessageId = 0;
        progressDialogAtMessageType = -1;
        progressDialogBotButtonUrl = null;
        progressDialogCurrent = null;

        sideControlsButtonsLayout.setButtonLoading(ChatActivitySideControlsButtonsLayout.BUTTON_PAGE_DOWN, false, true);
    }

    public static final boolean SCROLL_DEBUG_DELAY = false;
    private boolean pinnedProgressIsShowing;
    Runnable updatePinnedProgressRunnable;

    public void scrollToMessageId(int id, int fromMessageId, boolean select, int loadIndex, boolean forceScroll, int forcePinnedMessageId) {
        scrollToMessageId(id, fromMessageId, select, loadIndex, forceScroll, forcePinnedMessageId, null, null);
    }

    public void scrollToMessageId(int id, int fromMessageId, boolean select, int loadIndex, boolean forceScroll, int forcePinnedMessageId, Integer taskId, Runnable inCaseLoading) {
        if (waitingForGetDifference) {
            return;
        }
        if (id == 0 || NotificationCenter.getInstance(currentAccount).isAnimationInProgress() || getParentActivity() == null) {
            if (NotificationCenter.getInstance(currentAccount).isAnimationInProgress()) {
                nextScrollToMessageId = id;
                nextScrollFromMessageId = fromMessageId;
                nextScrollSelect = select;
                nextScrollLoadIndex = loadIndex;
                nextScrollForce = forceScroll;
                nextScrollForcePinnedMessageId = forcePinnedMessageId;
                NotificationCenter.getInstance(currentAccount).doOnIdle(() -> {
                    if (nextScrollToMessageId != 0) {
                        scrollToMessageId(nextScrollToMessageId, nextScrollFromMessageId, nextScrollSelect, nextScrollLoadIndex, nextScrollForce, nextScrollForcePinnedMessageId);
                        nextScrollToMessageId = 0;
                    }
                });
            }
            return;
        }

        forceNextPinnedMessageId = Math.abs(forcePinnedMessageId);
        forceScrollToFirst = forcePinnedMessageId > 0;
        wasManualScroll = true;
        MessageObject object = chatAdapter.isFiltered ? (filteredMessagesDict != null ? filteredMessagesDict.get(id) : null) : messagesDict[loadIndex].get(id);
        boolean query = false;
        int scrollDirection = RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UNSET;
        int scrollFromIndex = 0;
        if (fromMessageId != 0) {
            boolean scrollDown = fromMessageId < id;
            if (isSecretChat()) {
                scrollDown = !scrollDown;
            }
            scrollDirection = scrollDown ? RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN : RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP;
        } else if (chatAdapter.getMessages().size() > 0) {
            if (isThreadChat() && id == threadMessageId) {
                scrollDirection = RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP;
            } else {
                int end = chatLayoutManager.findLastVisibleItemPosition();
                for (int i = chatLayoutManager.findFirstVisibleItemPosition(); i <= end; i++) {
                    if (i >= chatAdapter.messagesStartRow && i < chatAdapter.messagesEndRow) {
                        MessageObject messageObject = chatAdapter.getMessages().get(i - chatAdapter.messagesStartRow);
                        if (messageObject.getId() == 0 || messageObject.isSponsored()) {
                            continue;
                        }
                        scrollFromIndex = i - chatAdapter.messagesStartRow;
                        boolean scrollDown = messageObject.getId() < id;
                        if (isSecretChat()) {
                            scrollDown = !scrollDown;
                        }
                        scrollDirection = scrollDown ? RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN : RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP;
                        break;
                    }
                }
            }
        }

        chatScrollHelper.setScrollDirection(scrollDirection);
        if (!SCROLL_DEBUG_DELAY && object != null) {
            MessageObject.GroupedMessages groupedMessages = groupedMessagesMap.get(object.getGroupId());
            if (object.getGroupId() != 0 && groupedMessages != null) {
                MessageObject primary = groupedMessages.findPrimaryMessageObject();
                if (primary != null) {
                    object = primary;
                }
            }

            int index = chatAdapter.getMessages().indexOf(object);
            if (index != -1) {
                if (scrollFromIndex > 0) {
                    scrollDirection = scrollFromIndex > index ? RecyclerAnimationScrollHelper.SCROLL_DIRECTION_DOWN : RecyclerAnimationScrollHelper.SCROLL_DIRECTION_UP;
                    chatScrollHelper.setScrollDirection(scrollDirection);
                }
                removeSelectedMessageHighlight();
                if (select) {
                    highlightMessageId = id;
                    highlightTaskId = taskId;
                }

                chatAdapter.updateRowsSafe();
                int position = chatAdapter.messagesStartRow + chatAdapter.getMessages().indexOf(object);

                updateVisibleRows();
                boolean found = false;
                int offsetY = 0;
                int count = chatListView.getChildCount();
                for (int a = 0; a < count; a++) {
                    View view = chatListView.getChildAt(a);
                    if (view instanceof ChatMessageCell) {
                        ChatMessageCell cell = (ChatMessageCell) view;
                        MessageObject messageObject = cell.getMessageObject();
                        if (messageObject != null && messageObject.getId() == object.getId()) {
                            found = true;
                            view.sendAccessibilityEvent(AccessibilityEvent.TYPE_VIEW_FOCUSED);
                            offsetY = scrollOffsetForQuote(messageObject);
                        }
                    } else if (view instanceof ChatActionCell) {
                        ChatActionCell cell = (ChatActionCell) view;
                        MessageObject messageObject = cell.getMessageObject();
                        if (messageObject != null && messageObject.getId() == object.getId()) {
                            found = true;
                            view.sendAccessibilityEvent(AccessibilityEvent.TYPE_VIEW_FOCUSED);
                        }
                    }

                    if (found) {
                        int yOffset = getScrollOffsetForMessage(view.getHeight()) - offsetY;
                        int scrollY = (int) (view.getTop() - chatListViewPaddingTop - yOffset);
                        int maxScrollOffset = chatListView.computeVerticalScrollRange() - chatListView.computeVerticalScrollOffset() - chatListView.computeVerticalScrollExtent();
                        if (maxScrollOffset < 0) {
                            maxScrollOffset = 0;
                        }
                        if (scrollY > maxScrollOffset) {
                            scrollY = maxScrollOffset;
                        }
                        if (scrollY != 0) {
                            scrollByTouch = false;
                            chatListView.smoothScrollBy(0, scrollY);
                            chatListView.setOverScrollMode(RecyclerListView.OVER_SCROLL_NEVER);
                        }
                        break;
                    }
                }
                if (!found) {
                    int yOffset = getScrollOffsetForMessage(object);
                    chatScrollHelperCallback.scrollTo = object;
                    chatScrollHelperCallback.lastBottom = false;
                    chatScrollHelperCallback.lastItemOffset = yOffset;
                    chatScrollHelperCallback.lastPadding = (int) chatListViewPaddingTop;
                    chatScrollHelper.setScrollDirection(scrollDirection);
                    chatScrollHelper.scrollToPosition(chatScrollHelperCallback.position = position, chatScrollHelperCallback.offset = yOffset, chatScrollHelperCallback.bottom = false, true);
                    canShowPagedownButton = true;
                    updatePagedownButtonVisibility(true);
                }
            } else {
                query = true;
            }
        } else {
            query = true;
        }

        if (query) {
            if (isThreadChat() && id == threadMessageId) {
                scrollToThreadMessage = true;
                id = 1;
            }
            if (progressDialog != null) {
                progressDialog.dismiss();
            }

            showPinnedProgress(forceNextPinnedMessageId != 0);

            if (inCaseLoading != null) {
                inCaseLoading.run();
            } else if (forceNextPinnedMessageId == 0) {
                progressDialog = new AlertDialog(getParentActivity(), AlertDialog.ALERT_TYPE_SPINNER, themeDelegate);
                progressDialog.setOnShowListener(dialogInterface -> showPinnedProgress(false));
                progressDialog.setOnCancelListener(postponedScrollCancelListener);
                progressDialog.showDelayed(400);
            }

            waitingForLoad.clear();
            removeSelectedMessageHighlight();
            scrollToMessagePosition = -10000;
            startLoadFromMessageId = id;
            showScrollToMessageError = !forceScroll;
            if (id == createUnreadMessageAfterId) {
                createUnreadMessageAfterIdLoading = true;
            }
            postponedScrollIsCanceled = false;
            waitingForLoad.add(lastLoadIndex);
            postponedScrollToLastMessageQueryIndex = lastLoadIndex;
            fakePostponedScroll = false;
            postponedScrollMinMessageId = minMessageId[0];
            postponedScrollMessageId = id;
            getMessagesController().loadMessages(loadIndex == 0 ? dialog_id : mergeDialogId, 0, false, ((isThreadChat() && !isTopic) || AndroidUtilities.isTablet()) ? 30 : 20, startLoadFromMessageId, 0, true, 0, classGuid, 3, 0, chatMode, threadMessageId, replyMaxReadId, lastLoadIndex++, isTopic);
        } else {
            View child = chatListView.getChildAt(0);
            if (child != null && child.getTop() <= 0) {
                showFloatingDateView(false);
                showFloatingTopicView(false);
            }
        }
        returnToMessageId = fromMessageId;
        returnToLoadIndex = loadIndex;
        needSelectFromMessageId = select;
    }

    private void showPinnedProgress(boolean show) {
        if (show) {
            if (updatePinnedProgressRunnable == null) {
                updatePinnedProgressRunnable = () -> {
                    pinnedProgressIsShowing = true;
                    updatePinnedListButton(true);
                };
                AndroidUtilities.runOnUIThread(updatePinnedProgressRunnable, 100);
            }
        } else {
            if (updatePinnedProgressRunnable != null) {
                AndroidUtilities.cancelRunOnUIThread(updatePinnedProgressRunnable);
            }
            updatePinnedProgressRunnable = null;
            pinnedProgressIsShowing = false;
            updatePinnedListButton(true);
        }
    }

    private void updatePagedownButtonVisibility(boolean animated) {
        if (sideControlsButtonsLayout == null) {
            return;
        }
        boolean show = canShowPagedownButton && !textSelectionHelper.isInSelectionMode() && !chatActivityEnterView.isRecordingAudioVideo() && !isInsideContainer && (!searching || getMediaDataController().searchResultMessages.isEmpty());
        if (show) {
            if (animated && (openAnimationStartTime == 0 || SystemClock.elapsedRealtime() < openAnimationStartTime + 150)) {
                animated = false;
            }
            pagedownButtonShowedByScroll = false;
        } else {
            returnToMessageId = 0;
            newUnreadMessageCount = 0;
        }

        sideControlsButtonsLayout.showButton(ChatActivitySideControlsButtonsLayout.BUTTON_PAGE_DOWN, show, animated);
    }

    private void updateSearchUpDownButtonVisibility(boolean animated) {
        if (sideControlsButtonsLayout == null) {
            return;
        }
        boolean show = !getMediaDataController().searchResultMessages.isEmpty() && searching && !searchingFiltered || chatMode == MODE_SEARCH && searchType == SEARCH_PUBLIC_POSTS && !messages.isEmpty();

        sideControlsButtonsLayout.showButton(ChatActivitySideControlsButtonsLayout.BUTTON_SEARCH_UP, show, animated);
        sideControlsButtonsLayout.showButton(ChatActivitySideControlsButtonsLayout.BUTTON_SEARCH_DOWN, show, animated);
        if (show) {
            sideControlsButtonsLayout.showButton(ChatActivitySideControlsButtonsLayout.BUTTON_PAGE_DOWN, false, animated);
        }

        if (!show) {
            returnToMessageId = 0;
        }

        contentView.invalidate();
    }

    private void showMentionDownButton(boolean show, boolean animated) {
        if (sideControlsButtonsLayout == null) {
            return;
        }

        sideControlsButtonsLayout.showButton(ChatActivitySideControlsButtonsLayout.BUTTON_MENTION, show && !ChatObject.isMonoForum(currentChat), animated);
        if (!show) {
            returnToMessageId = 0;
        }
    }

    private boolean shouldHaveLightNavigationBarIcons;

    public boolean isShouldHaveLightNavigationBarIcons() {
        return shouldHaveLightNavigationBarIcons && (!windowInsetsStateHolder.inAppViewIsVisible() || themeDelegate != null && themeDelegate.isDark);
    }

    public class ChatActivityFragmentView extends SizeNotifierFrameLayout {

        public ChatActivity getChatActivity() {
            return ChatActivity.this;
        }

        public ChatActivityFragmentView(Context context, INavigationLayout parentLayout) {
            super(context, parentLayout);
            adjustPanLayoutHelper = new AdjustPanLayoutHelper(this) {

                @Override
                protected void onTransitionStart(boolean keyboardVisible, int contentHeight) {
                    wasManualScroll = true;
                    if (chatActivityEnterView != null) {
                        chatActivityEnterView.onAdjustPanTransitionStart(keyboardVisible, contentHeight);
                    }
                    if (mentionContainer != null) {
                        // mentionContainer.onPanTransitionStart();
                    }
                    if (mediaBanTooltip != null) {
                        mediaBanTooltip.hide(false);
                    }
                    if (factCheckHint != null) {
                        factCheckHint.hide();
                    }
                }

                @Override
                protected void onTransitionEnd() {
                    if (chatActivityEnterView != null) {
                        chatActivityEnterView.onAdjustPanTransitionEnd();
                    }
                    if (mentionContainer != null) {
                        // mentionContainer.onPanTransitionEnd();
                    }
                    if (voiceHintTextView != null && voiceHintTextView.getVisibility() == View.VISIBLE) {
                        voiceHintTextView.showForView(chatActivityEnterView.getAudioVideoButtonContainer(), false);
                    }
                }

                @Override
                protected void onPanTranslationUpdate(float y, float progress, boolean keyboardVisible) {
                    if (getParentLayout() != null && getParentLayout().isPreviewOpenAnimationInProgress()) {
                        return;
                    }
                    contentPanTranslation = y;
                    contentPanTranslationT = progress;
                    if (contentView != null) {
                        contentView.updateBlurContent();
                    }
                    if (chatAttachAlert != null && chatAttachAlert.isShowing()) {
                        setNonNoveTranslation(y);
                    } else {
                        actionBar.setTranslationY(y);
                        if (tagSelector != null) {
                            tagSelector.setTranslationY(contentPanTranslation + (actionBarSearchTags != null ? actionBarSearchTags.getCurrentHeight() : 0));
                        }
                        if (savedMessagesSearchHint != null) {
                            savedMessagesSearchHint.setTranslationY(y);
                        }
                        if (savedMessagesHint != null) {
                            savedMessagesHint.setTranslationY(y);
                        }
                        if (actionBarSearchTags != null) {
                            actionBarSearchTags.setTranslationY(y);
                        }
                        if (topicsTabs != null) {
                            topicsTabs.setTranslationY(y);
                        }
                        if (hashtagSearchTabs != null) {
                            hashtagSearchTabs.setTranslationY(y);
                        }
                        if (emptyViewContainer != null) {
                            emptyViewContainer.setTranslationY(y / 2);
                        }
                        if (hashtagHistoryView != null) {
                            hashtagHistoryView.setTranslationY(getHashtagTabsHeight() + y);
                            hashtagHistoryView.emptyView.setTranslationY(-y / 2);
                        }
                        if (messagesSearchListContainer != null) {
                            messagesSearchListContainer.setTranslationY(getHashtagTabsHeight() + y);
                        }
                        if (hashtagSearchEmptyView != null) {
                            hashtagSearchEmptyView.setTranslationY(-y / 2);
                        }
                        if (searchViewPager != null) {
                            View page = searchViewPager.getCurrentView();
                            if (page instanceof ChatActivityContainer) {
                                ChatActivity child = ((ChatActivityContainer) page).chatActivity;
                                if (child.messagesSearchListContainer != null) {
                                    child.messagesSearchListContainer.setTranslationY(getHashtagTabsHeight() + y);
                                }
                                if (child.hashtagSearchEmptyView != null) {
                                    child.hashtagSearchEmptyView.setTranslationY(-y / 2);
                                }
                            }
                        }
                        progressView.setTranslationY(y / 2);
                        contentView.setBackgroundTranslation((int) y);
                        if (instantCameraView != null) {
                            instantCameraView.onPanTranslationUpdate(y);
                        }
                        if (blurredView != null) {
                            blurredView.drawable.onPanTranslationUpdate(y);
                        }
                        setFragmentPanTranslationOffset((int) y);
                        invalidateChatListViewTopPadding();
                        invalidateMessagesVisiblePart();
                    }
                    chatListView.invalidate();
                    updateBulletinLayout();
                    if (chatActivityEnterView != null) {
                        chatActivityEnterView.onAdjustPanTransitionUpdate(y, progress, keyboardVisible);
                    }
                    if (mentionContainer != null) {
                        // mentionContainer.onPanTransitionUpdate(y);
                    }
                    if (AndroidUtilities.isTablet() && getParentActivity() instanceof LaunchActivity) {
                        BaseFragment mainFragment = ((LaunchActivity)getParentActivity()).getActionBarLayout().getLastFragment();
                        if (mainFragment instanceof DialogsActivity) {
                            ((DialogsActivity)mainFragment).setPanTranslationOffset(y);
                        }
                    }
                    if (voiceHintTextView != null && voiceHintTextView.getVisibility() == View.VISIBLE) {
                        voiceHintTextView.showForView(chatActivityEnterView.getAudioVideoButtonContainer(), false);
                    }
                    if (fragmentContextView != null) {
                        fragmentContextView.onPanTranslationUpdate(y);
                    }
                }

                @Override
                protected boolean heightAnimationEnabled() {
                    INavigationLayout actionBarLayout = getParentLayout();
                    if (isInsideContainer || inPreviewMode || inBubbleMode || AndroidUtilities.isInMultiwindow || actionBarLayout == null || fixedKeyboardHeight > 0) {
                        return false;
                    }
                    if (System.currentTimeMillis() - activityResumeTime < 250) {
                        return false;
                    }
                    if ((ChatActivity.this == actionBarLayout.getLastFragment() && actionBarLayout.isTransitionAnimationInProgress()) || actionBarLayout.isPreviewOpenAnimationInProgress() || isPaused || !openAnimationEnded || (chatAttachAlert != null && chatAttachAlert.isShowing())) {
                        return false;
                    }
                    if (chatActivityEnterView != null && chatActivityEnterView.getTrendingStickersAlert() != null && chatActivityEnterView.getTrendingStickersAlert().isShowing()) {
                        return false;
                    }
                    return true;
                }

                @Override
                protected int startOffset() {
                    int keyboardSize = getKeyboardHeight();
                    if (keyboardSize <= AndroidUtilities.dp(20) && chatActivityEnterView.isPopupShowing()) {
                        return chatActivityEnterView.getEmojiPadding();
                    }
                    return 0;
                }
            };
        }

        @Override
        public void drawBlurRect(Canvas canvas, float y, Rect rectTmp, Paint blurScrimPaint, boolean top) {
            int blurAlpha = Color.alpha(Theme.getColor(SharedConfig.getDevicePerformanceClass() == SharedConfig.PERFORMANCE_CLASS_HIGH ? Theme.key_chat_BlurAlpha : Theme.key_chat_BlurAlphaSlow, getResourceProvider()));
            final BlurredBackgroundSource blurSource = glassBackgroundSourceFrostedRenderNode;
            if (blurSource != null && blurAlpha < 255) {
                canvas.save();
                canvas.translate(0, -y);
                blurSource.draw(canvas,
                    rectTmp.left,
                    rectTmp.top + y,
                    rectTmp.right,
                    rectTmp.bottom + y
                );
                canvas.restore();
            } else {
                blurAlpha = 255;
            }

            final int oldScrimAlpha = blurScrimPaint.getAlpha();
            blurScrimPaint.setAlpha(blurAlpha);
            canvas.drawRect(rectTmp, blurScrimPaint);
            blurScrimPaint.setAlpha(oldScrimAlpha);
        }

        @Override
        public void onUpdateBackgroundDrawable(Drawable drawable) {
            super.onUpdateBackgroundDrawable(drawable);
            if (drawable instanceof MotionBackgroundDrawable) {
                ((MotionBackgroundDrawable) drawable).setFastRenderAllowed();
            }

            final BlurredBackgroundSource source = wallpaperBitmapProvider.updateSourceFromBackgroundViewDrawable(drawable);
            final int navigationBarColor = wallpaperBitmapProvider.getNavigationBarColor(source);
            final float brightness = AndroidUtilities.computePerceivedBrightness(navigationBarColor);
            final boolean isDark = brightness <= 0.9f;
            shouldHaveLightNavigationBarIcons = isDark;

            navbarContentSourceWallpaper.setSource(source);
            if (chatInputViewsContainer != null) {
                chatInputViewsContainer.invalidate();
                chatInputViewsContainer.getFadeView().invalidate();
            }
            invalidateAllGlassAttachedViews();
            checkSystemBarColors();
        }

        int inputFieldHeight = 0;
        int lastHeight;

        int lastWidth;

        ArrayList<ChatMessageCell> drawTimeAfter = new ArrayList<>();
        ArrayList<ChatMessageCell> drawNamesAfter = new ArrayList<>();
        ArrayList<ChatMessageCell> drawCaptionAfter = new ArrayList<>();
        ArrayList<ChatMessageCell> drawReactionsAfter = new ArrayList<>();

        Paint backgroundPaint;
        int backgroundColor;

        @Override
        protected boolean invalidateOptimized() {
            return true;
        }

        private final RectF tmpViewRectF = new RectF();

        public void drawList(Canvas blurCanvas, RectF position) {
            final long drawingTime = SystemClock.uptimeMillis();

            blurCanvas.save();
            blurCanvas.clipRect(position);
            blurCanvas.translate(0, chatListView.getY());
            chatListView.drawChatBackgroundElements(blurCanvas);
            for (int i = 0; i < chatListView.getChildCount(); i++) {
                View child = chatListView.getChildAt(i);
                tmpViewRectF.set(child.getX(), child.getY() + chatListView.getY(), child.getX() + child.getWidth(), child.getY() + chatListView.getY() + child.getHeight());
                if (!tmpViewRectF.intersect(position)) {
                    continue;
                }

                if (child instanceof ChatMessageCell) {
                    blurCanvas.save();
                    blurCanvas.translate(child.getX(), child.getY());
                    ChatMessageCell cell = (ChatMessageCell) child;
                    if (cell.drawBackgroundInParent()) {
                        blurCanvas.save();
                        blurCanvas.translate(0, cell.starsPriceTopPadding);
                        cell.drawBackgroundInternal(blurCanvas, true);
                        blurCanvas.restore();
                    }
                    blurCanvas.restore();
                    chatListView.drawChild(blurCanvas, child, drawingTime);
                    if (cell.hasOutboundsContent()) {
                        blurCanvas.save();
                        blurCanvas.translate(cell.getX(), cell.getY());
                        cell.drawOutboundsContent(blurCanvas);
                        blurCanvas.restore();
                    }
                } else if (child instanceof ChatActionCell) {
                    ChatActionCell cell = (ChatActionCell) child;
                    chatListView.drawChild(blurCanvas, child, drawingTime);
                    blurCanvas.save();
                    blurCanvas.translate(child.getX(), child.getY());
                    cell.drawOutboundsContent(blurCanvas);
                    blurCanvas.restore();
                } else {
                    chatListView.drawChild(blurCanvas, child, drawingTime);
                }
            }
            chatListView.drawChatForegroundElements(blurCanvas);
            blurCanvas.restore();
        }


        @Override
        public void addView(View child, int index, ViewGroup.LayoutParams params) {
            super.addView(child, index, params);
            if (chatActivityEnterView != null && child == chatActivityEnterView.botCommandsMenuContainer) {
                BotCommandsMenuContainer botCommandsMenuContainer = (BotCommandsMenuContainer) child;
                final BlurredBackgroundDrawable drawable = glassBackgroundDrawableFactory.create(botCommandsMenuContainer.listView, blurredBackgroundColorProviderWhite);
                botCommandsMenuContainer.setBackgroundDrawable(drawable);
            }
            if (chatActivityEnterView != null && child == chatActivityEnterView.controlsView) {
                chatActivityEnterView.controlsView.setBlurredBackgroundFactory(glassBackgroundDrawableFactory);
            }
        }

        @Override
        protected int getScrollOffset() {
            return chatListView.computeVerticalScrollOffset();
        }

        @Override
        protected float getBottomOffset() {
            return chatListView.getBottom();
        }

        @Override
        protected float getListTranslationY() {
            return chatListView.getTranslationY();
        }

        @Override
        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            if (isInsideContainer) {
                adjustPanLayoutHelper.setResizableView(contentView);
            } else if (parentLayout != null && parentLayout.isSheet()) {
                adjustPanLayoutHelper.setResizableView((FrameLayout) parentLayout.getView().getParent().getParent().getParent().getParent());
            }
            adjustPanLayoutHelper.onAttach();
            chatActivityEnterView.setAdjustPanLayoutHelper(adjustPanLayoutHelper);
            MessageObject messageObject = MediaController.getInstance().getPlayingMessageObject();
            if (messageObject != null && (messageObject.isRoundVideo() || messageObject.isVideo()) && messageObject.eventId == 0 && messageObject.getDialogId() == dialog_id) {
                MediaController.getInstance().setTextureView(createTextureView(false), aspectRatioFrameLayout, videoPlayerContainer, true);
            }
            if (pullingDownDrawable != null) {
                pullingDownDrawable.onAttach();
            }
            emojiAnimationsOverlay.onAttachedToWindow();
        }

        @Override
        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            adjustPanLayoutHelper.onDetach();
            if (pullingDownDrawable != null) {
                pullingDownDrawable.onDetach();
                pullingDownDrawable = null;
            }
            emojiAnimationsOverlay.onDetachedFromWindow();
            AndroidUtilities.runOnUIThread(() -> {
                ReactionsEffectOverlay.removeCurrent(true);
            });
        }

        private float x, y;
        private long pressTime;
        private boolean pressActionBar;

        @Override
        public boolean dispatchTouchEvent(MotionEvent ev) {
            float expandY;
            if (AndroidUtilities.isInMultiwindow || isInBubbleMode()) {
                expandY = chatActivityEnterView.getEmojiView() != null ? chatActivityEnterView.getEmojiView().getY() : chatActivityEnterView.getY();
            } else {
                expandY = chatActivityEnterView.getY();
            }
            if ((scrimView != null && scrimView != actionBar.getBackButton()) || chatActivityEnterView != null && chatActivityEnterView.isStickersExpanded() && ev.getY() < expandY) {
                return false;
            }

            lastTouchY = ev.getY();
            TextSelectionHelper.TextSelectionOverlay selectionOverlay = textSelectionHelper.getOverlayView(getContext());
            ev.offsetLocation(-selectionOverlay.getX(), -selectionOverlay.getY());
            if (textSelectionHelper.isInSelectionMode() && textSelectionHelper.getOverlayView(getContext()).onTouchEvent(ev)) {
                return true;
            } else {
                ev.offsetLocation(selectionOverlay.getX(), selectionOverlay.getY());
            }

            if (selectionOverlay.checkOnTap(ev)) {
                ev.setAction(MotionEvent.ACTION_CANCEL);
            }

            boolean r = false;
            if (searchViewPager != null) {
                if (searchingHashtag != null && !hashtagHistoryView.isShowing()) {
                    r = searchViewPager.onTouchEventInternal(ev) || r;
                    if (searchViewPager.isTouch()) {
                        ev.setAction(MotionEvent.ACTION_CANCEL);
                    }
                } else {
                    searchViewPager.resetTouch();
                }
            }

            if (ev.getAction() == MotionEvent.ACTION_DOWN && textSelectionHelper.isInSelectionMode() && (ev.getY() < chatListView.getTop() || ev.getY() > chatListView.getBottom())) {
                ev.offsetLocation(-selectionOverlay.getX(), -selectionOverlay.getY());
                if (textSelectionHelper.getOverlayView(getContext()).onTouchEvent(ev)) {
                    ev.offsetLocation(selectionOverlay.getX(), selectionOverlay.getY());
                    return super.dispatchTouchEvent(ev);
                } else {
                    return true;
                }
            }

            if (pinchToZoomHelper.isInOverlayMode()) {
                return pinchToZoomHelper.onTouchEvent(ev);
            }

            if (AvatarPreviewer.hasVisibleInstance()) {
                AvatarPreviewer.getInstance().onTouchEvent(ev);
                return true;
            }

            if (isInPreviewMode() && allowExpandPreviewByClick) {
                if (ev.getAction() == MotionEvent.ACTION_DOWN) {
                    boolean pressedOnPageDownButtons = false, pressedOnAction = false;
                    int[] off = new int[2];
                    getLocationInWindow(off);
                    int[] pos = new int[2];

                    if (sideControlsButtonsLayout != null) {
                        for (int a = 0; a < 3; a++) {
                            final int buttonId = a == 0 ?
                                ChatActivitySideControlsButtonsLayout.BUTTON_PAGE_DOWN: a == 1 ?
                                    ChatActivitySideControlsButtonsLayout.BUTTON_MENTION:
                                    ChatActivitySideControlsButtonsLayout.BUTTON_REACTIONS;

                            if (sideControlsButtonsLayout.getButtonLocationInWindow(buttonId, pos)) {
                                AndroidUtilities.rectTmp2.set(pos[0] - off[0], pos[1] - off[1], pos[0] - off[0] + dp(56), pos[1] - off[1] + dp(61));
                                if (AndroidUtilities.rectTmp2.contains((int) ev.getX(), (int) ev.getY())) {
                                    pressedOnPageDownButtons = true;
                                    break;
                                }
                            }
                        }
                    }

                    if (avatarContainer != null) {
                        avatarContainer.getLocationInWindow(pos);
                        AndroidUtilities.rectTmp2.set(pos[0] - off[0], pos[1] - off[1], pos[0] - off[0] + avatarContainer.getMeasuredWidth(), pos[1] - off[1] + avatarContainer.getMeasuredHeight());
                        if (AndroidUtilities.rectTmp2.contains((int) ev.getX(), (int) ev.getY())) {
                            pressedOnAction = true;
                        }
                    }
                    if (!pressedOnPageDownButtons) {
                        x = ev.getX();
                        y = ev.getY();
                        pressTime = SystemClock.elapsedRealtime();
                        pressActionBar = pressedOnAction;
                        if (avatarContainer != null) {
                            avatarContainer.bounce.setPressed(pressActionBar);
                        }
                        r = true;
                    } else {
                        pressTime = -1;
                    }
                } else if (ev.getAction() == MotionEvent.ACTION_UP) {
                    if (avatarContainer != null) {
                        avatarContainer.bounce.setPressed(false);
                    }
                    if (pressActionBar || MathUtils.distance(x, y, ev.getX(), ev.getY()) < AndroidUtilities.dp(6) && SystemClock.elapsedRealtime() - pressTime <= ViewConfiguration.getTapTimeout()) {
                        if (pressActionBar) {
                            final INavigationLayout layout = parentLayout;
                            removeSelfFromStack(false);
                            layout.presentFragment(ProfileActivity.of(dialog_id));
                        } else {
                            parentLayout.expandPreviewFragment();
                        }
                        ev.setAction(MotionEvent.ACTION_CANCEL);
                    }
                    pressTime = -1;
                } else if (ev.getAction() == MotionEvent.ACTION_CANCEL) {
                    pressTime = -1;
                }
            }

            return super.dispatchTouchEvent(ev) || r;
        }

        @Override
        protected void onDraw(Canvas canvas) {
            if (getTag(BlurBehindDrawable.TAG_DRAWING_AS_BACKGROUND) != null) {
                return;
            }
            if (getTag(BlurBehindDrawable.TAG_DRAWING_AS_BACKGROUND) == null && (blurredView != null && blurredView.fullyDrawing() && blurredView.getTag() != null)) {
                return;
            }
            super.onDraw(canvas);
        }

        @Override
        protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
            if ((scrimView != null || messageEnterTransitionContainer.isRunning()) && (child == sideControlsButtonsLayout || child == floatingDateView || child == floatingTopicSeparator || child == fireworksOverlay || child == quickShareSelectorOverlay || child == gifHintTextView || child == emojiHintTextView || child == undoView || child == topUndoView)) {
                return false;
            }
            if (child == fragmentContextView && fragmentContextView.isCallStyle()) {
                return true;
            }
            if (child == undoView && PhotoViewer.getInstance().isVisible()) {
                return true;
            }
            if (toPullingDownTransition && child == chatListView) {
                return true;
            }
            if (switchingFromTopics && child == actionBar) {
                return true;
            }
            if (child == instantCameraView) {
                return true;
            }
            if (getTag(BlurBehindDrawable.TAG_DRAWING_AS_BACKGROUND) != null) {
                boolean needBlur;
                if (((int) getTag(BlurBehindDrawable.TAG_DRAWING_AS_BACKGROUND)) == BlurBehindDrawable.STATIC_CONTENT) {
                    needBlur = child == actionBar || child == fragmentContextView || child == pinnedMessageView;
                } else {
                    needBlur = child == chatListView || child == chatInputViewsContainer || child == bottomChannelButtonsLayout;
                }
                if (!needBlur) {
                    return false;
                }
            } else if (getTag(BlurBehindDrawable.TAG_DRAWING_AS_BACKGROUND) == null && ((blurredView != null && blurredView.fullyDrawing() && blurredView.getTag() != null))) {
                boolean needBlur = child == actionBar || child == chatListView || child == pinnedMessageView || child == fragmentContextView;
                if (needBlur) {
                    return false;
                }
            }
            boolean result;
            MessageObject messageObject = MediaController.getInstance().getPlayingMessageObject();
            boolean isRoundVideo = false;
            boolean isVideo = messageObject != null && messageObject.eventId == 0 && ((isRoundVideo = messageObject.isRoundVideo()) || messageObject.isVideo());
            if (child == videoPlayerContainer) {
                canvas.save();
                float transitionOffset = 0;
                if (pullingDownAnimateProgress != 0) {
                    transitionOffset = (chatListView.getMeasuredHeight() - pullingDownOffset) * pullingDownAnimateProgress;
                }
                canvas.translate(0, -pullingDownOffset - transitionOffset);
                if (messageObject != null && messageObject.type == MessageObject.TYPE_ROUND_VIDEO) {
                    if (Theme.chat_roundVideoShadow != null && aspectRatioFrameLayout.isDrawingReady()) {
                        int x = (int) child.getX() - AndroidUtilities.dp(3);
                        int y = (int) child.getY() - AndroidUtilities.dp(2);
                        canvas.save();
                        canvas.scale(videoPlayerContainer.getScaleX(), videoPlayerContainer.getScaleY(), child.getX(), child.getY());
                        Theme.chat_roundVideoShadow.setAlpha(255);
                        Theme.chat_roundVideoShadow.setBounds(x, y, x + AndroidUtilities.roundPlayingMessageSize(isSideMenued()) + AndroidUtilities.dp(6), y + AndroidUtilities.roundPlayingMessageSize(isSideMenued()) + AndroidUtilities.dp(6));
                        Theme.chat_roundVideoShadow.draw(canvas);
                        canvas.restore();
                    }
                    result = super.drawChild(canvas, child, drawingTime);
                } else {
                    if (child.getTag() == null) {
                        float oldTranslation = child.getTranslationY();
                        child.setTranslationY(-AndroidUtilities.dp(1000));
                        result = super.drawChild(canvas, child, drawingTime);
                        child.setTranslationY(oldTranslation);
                    } else {
                        result = false;
                    }
                }
                canvas.restore();
            } else {
                if (child == chatInputViewsContainer && instantCameraView != null && instantCameraView.getVisibility() == VISIBLE) {
                    super.drawChild(canvas, instantCameraView, drawingTime);
                }
                result = super.drawChild(canvas, child, drawingTime);
                if (isVideo && child == chatListView && messageObject.type != MessageObject.TYPE_ROUND_VIDEO && videoPlayerContainer != null && videoPlayerContainer.getTag() != null) {
                    canvas.save();
                    float transitionOffset = 0;
                    if (pullingDownAnimateProgress != 0) {
                        transitionOffset = (chatListView.getMeasuredHeight() - pullingDownOffset) * pullingDownAnimateProgress;
                    }
                    canvas.translate(0, -pullingDownOffset - transitionOffset + pullingBottomOffset);
                    super.drawChild(canvas, videoPlayerContainer, drawingTime);
                    if (drawLaterRoundProgressCell != null) {
                        canvas.save();
                        canvas.translate(drawLaterRoundProgressCell.getX(), drawLaterRoundProgressCell.getTop() + chatListView.getY());
                        if (isRoundVideo) {
                            drawLaterRoundProgressCell.drawRoundProgress(canvas);
                            invalidate();
                            drawLaterRoundProgressCell.invalidate();
                        } else {
                            drawLaterRoundProgressCell.drawOverlays(canvas);
                            if (drawLaterRoundProgressCell.needDrawTime()) {
                                drawLaterRoundProgressCell.drawTime(canvas, drawLaterRoundProgressCell.getAlpha(), true);
                            }
                        }
                        canvas.restore();
                    }
                    canvas.restore();
                }
            }
            if (child == actionBar && parentLayout != null) {
                parentLayout.drawHeaderShadow(canvas, actionBar.getVisibility() == VISIBLE ? (int) actionBar.getTranslationY() + actionBar.getMeasuredHeight() + (actionBarSearchTags != null ? actionBarSearchTags.getCurrentHeight() : 0) + (hashtagSearchTabs != null ? hashtagSearchTabs.getCurrentHeight() : 0) : 0);
            }
            return result;
        }

        @Override
        protected boolean isActionBarVisible() {
            return actionBar.getVisibility() == VISIBLE;
        }

        private void drawChildElement(Canvas canvas, float listTop, ChatMessageCell cell, int type) {
            int restoreCount = canvas.save();
            float canvasOffsetX = chatListView.getLeft() + cell.getX();
            float canvasOffsetY = chatListView.getY() + cell.getY() + cell.getPaddingTop();
            float alpha = cell.shouldDrawAlphaLayer() ? cell.getAlpha() : 1f;
            canvas.clipRect(chatListView.getLeft(), listTop, chatListView.getRight(), chatListView.getY() + chatListView.getMeasuredHeight() - blurredViewBottomOffset - windowInsetsStateHolder.getCurrentMaxBottomInset() - inputIslandHeightCurrent - dp(9));
            canvas.translate(canvasOffsetX, canvasOffsetY);
            cell.setInvalidatesParent(true);
            if (type == 0) {
                cell.drawTime(canvas, alpha, true);
            } else if (type == 1) {
                cell.drawNamesLayout(canvas, alpha);
            } else if (type == 2) {
                cell.drawCaptionLayout(canvas, cell.getCurrentPosition() != null && (cell.getCurrentPosition().flags & MessageObject.POSITION_FLAG_LEFT) == 0, alpha);
            } else if (type == 3) {
                final boolean selectionOnly = cell.getCurrentPosition() != null && (cell.getCurrentPosition().flags & MessageObject.POSITION_FLAG_LEFT) == 0;
                cell.drawCommentLayout(canvas, alpha);
                if (!selectionOnly) {
                    cell.drawReactionsLayout(canvas, alpha, null);
                }
            } else if (type == 4) {
                final boolean selectionOnly = cell.getCurrentPosition() != null && (cell.getCurrentPosition().flags & MessageObject.POSITION_FLAG_LEFT) == 0;
                if (!selectionOnly) {
                    if (scrimViewReaction != null) {
                        final float scrimProgress = scrimPaintAlpha * scrimViewAlpha / 0.2f;

                        canvas.save();
                        cell.drawScrimReaction(canvas, scrimViewReaction, scrimProgress, scrimProgressDirection);
                        canvas.restore();

                        canvas.restore();
                        canvas.save();
                        canvas.translate(canvasOffsetX, canvasOffsetY);
                        cell.drawScrimReactionPreview(this, canvas, scrimViewReactionOffset, scrimViewReaction, scrimProgress);
                        canvas.restore();
                    }
                }
            }
            cell.setInvalidatesParent(false);
            canvas.restoreToCount(restoreCount);
        }

        @Override
        protected void dispatchDraw(Canvas canvas) {
            final int width = getMeasuredWidth();
            final int height = getMeasuredHeight();

            if (Build.VERSION.SDK_INT >= 31 && canvas.isHardwareAccelerated() && scrollableViewNoiseSuppressor != null) {
                if (navbarContentSourceMessages != null && !navbarContentSourceMessages.inRecording()) {
                    if (navbarContentSourceMessages.needUpdateDisplayList(width, height) || glassSourcesInvalidated) {
                        final Canvas c = navbarContentSourceMessages.beginRecording(width, height);
                        scrollableViewNoiseSuppressor.draw(c, DownscaleScrollableNoiseSuppressor.DRAW_FROSTED_GLASS_NO_SATURATION);
                        navbarContentSourceMessages.endRecording();
                    }
                }
                if (navbarContentSourceWallpaperAndMessagesRenderNode != null && !navbarContentSourceWallpaperAndMessagesRenderNode.inRecording() && navbarContentSourceMessagesDrawable != null) {
                    if (navbarContentSourceWallpaperAndMessagesRenderNode.needUpdateDisplayList(width, height) || glassSourcesInvalidated) {
                        final Canvas c = navbarContentSourceWallpaperAndMessagesRenderNode.beginRecording(width, height);
                        navbarContentSourceWallpaper.draw(c, 0, 0, width, height);
                        navbarContentSourceMessagesDrawable.setBounds(0, 0, width, height);
                        navbarContentSourceMessagesDrawable.setAlpha(themeDelegate != null && themeDelegate.isDark() ? 80 : 180);
                        navbarContentSourceMessagesDrawable.draw(c);
                        navbarContentSourceWallpaperAndMessagesRenderNode.endRecording();
                    }
                }
                if (glassBackgroundSourceRenderNode != null && !glassBackgroundSourceRenderNode.inRecording()) {
                    if (glassBackgroundSourceRenderNode.needUpdateDisplayList(width, height) || glassSourcesInvalidated) {
                        final Canvas c = glassBackgroundSourceRenderNode.beginRecording(width, height);
                        navbarContentSourceWallpaper.draw(c, 0, 0, width, height);
                        scrollableViewNoiseSuppressor.draw(c, DownscaleScrollableNoiseSuppressor.DRAW_GLASS);
                        glassBackgroundSourceRenderNode.endRecording();
                    }
                }
                if (glassBackgroundSourceFrostedRenderNode != null && !glassBackgroundSourceFrostedRenderNode.inRecording()) {
                    if (glassBackgroundSourceFrostedRenderNode.needUpdateDisplayList(width, height) || glassSourcesInvalidated) {
                        final Canvas c = glassBackgroundSourceFrostedRenderNode.beginRecording(width, height);
                        navbarContentSourceWallpaper.draw(c, 0, 0, width, height);
                        scrollableViewNoiseSuppressor.draw(c, DownscaleScrollableNoiseSuppressor.DRAW_FROSTED_GLASS);
                        glassBackgroundSourceFrostedRenderNode.endRecording();
                    }
                }

                glassSourcesInvalidated = false;
            }

            chatActivityEnterView.checkAnimation();
            updateChatListViewTopPadding();
            if (invalidateMessagesVisiblePart || (chatListItemAnimator != null && chatListItemAnimator.isRunning())) {
                invalidateMessagesVisiblePart = false;
                updateMessagesVisiblePart(false);
            }
            updateTextureViewPosition(false, false);
            updatePagedownButtonsPosition();
            if (scheduledOrNoSoundHint != null && scheduledOrNoSoundHint.isShowing()) {
                scheduledOrNoSoundHint.updatePosition();
            }
            if (scheduledHint != null && scheduledHint.isShowing()) {
                scheduledHint.updatePosition();
            }
            int restoreToCount = -1;
            if (switchingFromTopics) {
                restoreToCount = canvas.saveLayerAlpha(0, actionBar.getBottom(), getMeasuredWidth(), getMeasuredHeight(), (int) (255 * switchingFromTopicsProgress), Canvas.ALL_SAVE_FLAG);
                float s = 0.8f + 0.2f * switchingFromTopicsProgress;
                canvas.scale(s, s, getMeasuredWidth() / 2f, getMeasuredHeight() / 2f);
            }
            super.dispatchDraw(canvas);
            if (fragmentContextView != null && fragmentContextView.isCallStyle()) {
                float alpha = (blurredView != null && blurredView.getVisibility() == View.VISIBLE) ? 1f - blurredView.getAlpha() : 1f;
                if (alpha > 0) {
                    if (alpha == 1f) {
                        canvas.save();
                    } else {
                        canvas.saveLayerAlpha(fragmentContextView.getX(), fragmentContextView.getY() - AndroidUtilities.dp(30), fragmentContextView.getX() + fragmentContextView.getMeasuredWidth(), fragmentContextView.getY() + fragmentContextView.getMeasuredHeight(), (int) (255 * alpha), Canvas.ALL_SAVE_FLAG);
                    }
                    canvas.translate(fragmentContextView.getX(), fragmentContextView.getY());
                    fragmentContextView.setDrawOverlay(true);
                    fragmentContextView.draw(canvas);
                    fragmentContextView.setDrawOverlay(false);
                    canvas.restore();
                }
                fragmentView.invalidate();
            }
            for (int a = 0, N = animateSendingViews.size(); a < N; a++) {
                ChatMessageCell cell = animateSendingViews.get(a);
                MessageObject.SendAnimationData data = cell.getMessageObject().sendAnimationData;
                if (data != null) {
                    canvas.save();
                    final int actionBarBottom = actionBar.getVisibility() == VISIBLE ? (int) actionBar.getTranslationY() + actionBar.getMeasuredHeight() + (actionBarSearchTags != null ? actionBarSearchTags.getCurrentHeight() : 0) + (hashtagSearchTabs != null ? hashtagSearchTabs.getCurrentHeight() : 0) + (inPreviewMode ? AndroidUtilities.statusBarHeight : 0) : 0;
                    canvas.clipRect(0, actionBarBottom + paddingTopHeight, getWidth(), getHeight());
                    ImageReceiver imageReceiver = cell.getPhotoImage();
                    cell.getLocationInWindow(AndroidUtilities.pointTmp2);
                    int finalY = AndroidUtilities.pointTmp2[1];
                    finalY -= cell.getTranslationY() * (1.0f - data.progress);
                    finalY += chatActivityEnterView.topViewVisible() * AndroidUtilities.dp(48);
                    if (!data.fromPreview) {
                        canvas.translate(data.currentX, lerp(data.y, finalY + imageReceiver.getCenterY(), data.progress));
                    } else {
                        canvas.translate(data.currentX, lerp(data.y, finalY, data.progress));
                    }
                    canvas.scale(data.currentScale, data.currentScale);
                    if (!data.fromPreview) {
                        canvas.translate(-imageReceiver.getCenterX(), -imageReceiver.getCenterY());
                    }
                    cell.setTimeAlpha(data.timeAlpha);
                    cell.draw(canvas);
                    canvas.restore();
                }
            }
            if (scrimViewReaction == null || scrimView == null) {
                if (scrimBlurBitmapPaint != null) {
                    scrimBlurMatrix.reset();
                    final float s = (float) getMeasuredWidth() / scrimBlurBitmap.getWidth();
                    scrimBlurMatrix.postScale(s, s);
                    scrimBlurBitmapShader.setLocalMatrix(scrimBlurMatrix);
                    scrimBlurBitmapPaint.setAlpha((int) (0xFF * scrimViewProgress));
                    canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimBlurBitmapPaint);
                } else {
                    scrimPaint.setAlpha((int) (0xFF * scrimPaintAlpha * (scrimView != null ? scrimViewAlpha : 1f)));
                    canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimPaint);
                }
            }

            if (scrimViewReaction != null && scrimViewReactionAnimated) {
                invalidate();
            }

            if (scrimView != null) {
                if (scrimView == sideControlsButtonsLayout) {
                    if (scrimViewAlpha < 1f) {
                        scrimPaint.setAlpha((int) (255 * scrimPaintAlpha * (1f - scrimViewAlpha)));
                        canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimPaint);
                    }
                } else if (scrimView instanceof ImageView) {
                    int c = canvas.save();
                    if (scrimViewAlpha < 1f) {
                        canvas.saveLayerAlpha(scrimView.getLeft(), scrimView.getTop(), scrimView.getRight(), scrimView.getBottom(), (int) (255 * scrimViewAlpha), Canvas.ALL_SAVE_FLAG);
                    }
                    canvas.translate(scrimView.getLeft(), scrimView.getTop());
                    if (scrimView == actionBar.getBackButton()) {
                        int r = Math.max(scrimView.getMeasuredWidth(), scrimView.getMeasuredHeight()) / 2;
                        canvas.drawCircle(r, r, r * 0.7f, actionBarBackgroundPaint);
                    }
                    scrimView.draw(canvas);
                    canvas.restoreToCount(c);

                    if (scrimViewAlpha < 1f) {
                        scrimPaint.setAlpha((int) (255 * scrimPaintAlpha * (1f - scrimViewAlpha)));
                        canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimPaint);
                    }
                } else {
                    float listTop = chatListView.getY() + chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(4);
                    MessageObject.GroupedMessages scrimGroup;
                    if (scrimView instanceof ChatMessageCell) {
                        scrimGroup = ((ChatMessageCell) scrimView).getCurrentMessagesGroup();
                    } else {
                        scrimGroup = null;
                    }
                    boolean groupedBackgroundWasDraw = false;
                    int count = chatListView.getChildCount();
                    for (int num = 0; num < count; num++) {
                        View child = chatListView.getChildAt(num);
                        MessageObject.GroupedMessages group;
                        MessageObject.GroupedMessagePosition position;
                        ChatMessageCell cell;
                        ChatActionCell actionCell;
                        if (child instanceof ChatMessageCell) {
                            cell = (ChatMessageCell) child;
                            actionCell = null;
                            group = cell.getCurrentMessagesGroup();
                            position = cell.getCurrentPosition();
                        } else {
                            position = null;
                            group = null;
                            cell = null;
                            actionCell = child instanceof ChatActionCell ? ((ChatActionCell) child) : null;
                        }
                        if (child != scrimView && (scrimGroup == null || scrimGroup != group) || child.getAlpha() == 0f) {
                            continue;
                        }
                        if (!groupedBackgroundWasDraw && cell != null && scrimGroup != null && scrimGroup.transitionParams.cell != null) {
                            float x = scrimGroup.transitionParams.cell.getNonAnimationTranslationX(true);

                            float l = (scrimGroup.transitionParams.left + x + scrimGroup.transitionParams.offsetLeft);
                            float t = (scrimGroup.transitionParams.top + scrimGroup.transitionParams.offsetTop);
                            float r = (scrimGroup.transitionParams.right + x + scrimGroup.transitionParams.offsetRight);
                            float b = (scrimGroup.transitionParams.bottom + scrimGroup.transitionParams.offsetBottom);

                            if (!scrimGroup.transitionParams.backgroundChangeBounds) {
                                t += scrimGroup.transitionParams.cell.getTranslationY();
                                b += scrimGroup.transitionParams.cell.getTranslationY();
                            }

                            if (t < chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(20)) {
                                t = chatListViewPaddingTop - chatListViewPaddingVisibleOffset - AndroidUtilities.dp(20);
                            }

                            if (b > chatListView.getMeasuredHeight() + AndroidUtilities.dp(20)) {
                                b = chatListView.getMeasuredHeight() + AndroidUtilities.dp(20);
                            }

                            boolean selected = true;
                            for (int a = 0, N = scrimGroup.messages.size(); a < N; a++) {
                                MessageObject object = scrimGroup.messages.get(a);
                                int index = object.getDialogId() == dialog_id ? 0 : 1;
                                if (selectedMessagesIds[index].indexOfKey(object.getId()) < 0) {
                                    selected = false;
                                    break;
                                }
                            }

                            canvas.save();
                            float viewClipBottom2 = getMeasuredHeight()
                                    - windowInsetsStateHolder.getCurrentMaxBottomInset()
                                    - inputIslandHeightCurrent
                                    - dp(9)
                                    - (mentionContainer != null ? mentionContainer.clipBottom() : 0);

                            canvas.clipRect(0, listTop + (mentionContainer != null ? mentionContainer.clipTop() : 0), getMeasuredWidth(), viewClipBottom2);
                            canvas.translate(0, chatListView.getY());
                            scrimGroup.transitionParams.cell.drawBackground(canvas, (int) l, (int) t, (int) r, (int) b, scrimGroup.transitionParams.pinnedTop, scrimGroup.transitionParams.pinnedBotton, selected, 0);
                            canvas.restore();
                            groupedBackgroundWasDraw = true;
                        }

                        if (cell != null && cell.getPhotoImage().isAnimationRunning()) {
                            invalidate();
                        }

                        float viewClipLeft = chatListView.getLeft();
                        float viewClipTop = listTop;
                        float viewClipRight = chatListView.getRight();
                        float viewClipBottom = getMeasuredHeight()
                            - windowInsetsStateHolder.getCurrentMaxBottomInset()
                            - inputIslandHeightCurrent
                            - dp(9);

                        float clipTop = 0, clipBottom = 0;
                        if (mentionContainer != null) {
                            clipTop = Math.max(clipTop, mentionContainer.clipTop());
                            clipBottom = Math.max(clipBottom, mentionContainer.clipBottom());
                        }
                        if (chatActivityEnterView != null && chatActivityEnterView.botCommandsMenuContainer != null) {
                            clipBottom = Math.max(clipBottom, chatActivityEnterView.botCommandsMenuContainer.clipBottom());
                        }
                        viewClipTop += clipTop;
                        viewClipBottom -= clipBottom;

                        if (cell == null || !cell.getTransitionParams().animateBackgroundBoundsInner) {
                            viewClipLeft = Math.max(viewClipLeft, chatListView.getLeft() + child.getX());
                            viewClipTop = Math.max(viewClipTop, chatListView.getY() + child.getY());
                            viewClipRight = Math.min(viewClipRight, chatListView.getLeft() + child.getX() + child.getMeasuredWidth());
                            viewClipBottom = Math.min(viewClipBottom, chatListView.getY() + child.getY() + child.getMeasuredHeight());
                        }

                        viewClipLeft = Math.max(viewClipLeft, getSideMenuWidth());

                        if (scrimViewTask != null) {
                            final int index = cell.getTodoIndex(scrimViewTask);
                            viewClipTop = Math.max(viewClipTop, chatListView.getY() + cell.getY() + cell.getPollButtonTop(index));
                            viewClipBottom = Math.min(viewClipBottom, chatListView.getY() + cell.getY() + cell.getPollButtonBottom(index));
                        }

                        if (viewClipTop < viewClipBottom) {
                            if (child.getAlpha() != 1f) {
                                canvas.saveLayerAlpha(viewClipLeft, viewClipTop, viewClipRight, viewClipBottom, (int) (255 * child.getAlpha()), Canvas.ALL_SAVE_FLAG);
                            } else {
                                canvas.save();
                            }
                            if (cell != null) {
                                cell.setInvalidatesParent(true);
                                cell.setScrimReaction(scrimViewReaction);
                            } else if (actionCell != null) {
                                actionCell.setInvalidatesParent(true);
                                actionCell.setScrimReaction(scrimViewReaction);
                            }
                            canvas.clipRect(viewClipLeft, viewClipTop, viewClipRight, viewClipBottom);
                            canvas.translate(chatListView.getLeft() + child.getX(), chatListView.getY() + child.getY());
                            if (cell != null && scrimGroup == null && cell.drawBackgroundInParent()) {
                                canvas.save();
                                canvas.translate(0, cell.getPaddingTop());
                                cell.drawBackgroundInternal(canvas, true);
                                canvas.restore();
                            }
                            child.draw(canvas);
                            if (cell != null && cell.hasOutboundsContent()) {
                                canvas.save();
                                canvas.translate(0, cell.getPaddingTop());
                                cell.drawOutboundsContent(canvas);
                                canvas.restore();
                            }
                            if (actionCell != null) {
                                actionCell.drawOutboundsContent(canvas);
                            }

                            canvas.restore();

                            if (cell != null) {
                                cell.setInvalidatesParent(false);
                                cell.setScrimReaction(null);
                            } else if (actionCell != null) {
                                actionCell.setInvalidatesParent(false);
                                actionCell.setScrimReaction(null);
                            }
                        }

                        if (position != null || (cell != null && cell.getTransitionParams().animateBackgroundBoundsInner)) {
                            if (position == null || position.last || position.minX == 0 && position.minY == 0) {
                                if (position == null || position.last) {
                                    drawTimeAfter.add(cell);
                                }
                                if (position == null || (position.minX == 0 && position.minY == 0 && cell.hasNameLayout())) {
                                    drawNamesAfter.add(cell);
                                }
                            }
                            if (position == null || (position.flags & cell.captionFlag()) != 0) {
                                drawCaptionAfter.add(cell);
                            }
                            if (position == null || (position.flags & MessageObject.POSITION_FLAG_BOTTOM) != 0 && (position.flags & MessageObject.POSITION_FLAG_LEFT) != 0) {
                                drawReactionsAfter.add(cell);
                            }
                        }
                        if (scrimViewReaction != null && cell != null && scrimGroup == null) {
                            if (scrimBlurBitmapPaint != null) {
                                scrimBlurMatrix.reset();
                                final float s = (float) getMeasuredWidth() / scrimBlurBitmap.getWidth();
                                scrimBlurMatrix.postScale(s, s);
                                scrimBlurBitmapShader.setLocalMatrix(scrimBlurMatrix);
                                scrimBlurBitmapPaint.setAlpha((int) (0xFF * scrimViewProgress));
                                canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimBlurBitmapPaint);
                            } else {
                                scrimPaint.setAlpha((int) (255 * scrimPaintAlpha * scrimViewAlpha));
                                canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimPaint);
                            }

                            if (viewClipTop < viewClipBottom) {
                                final float scrimProgress = scrimPaintAlpha * scrimViewAlpha / 0.2f;

                                float alpha = child.getAlpha() * scrimViewAlpha;
                                if (alpha < 1f) {
                                    canvas.saveLayerAlpha(viewClipLeft, viewClipTop, viewClipRight, viewClipBottom, (int) (255 * alpha), Canvas.ALL_SAVE_FLAG);
                                } else {
                                    canvas.save();
                                }
                                canvas.clipRect(viewClipLeft, viewClipTop, viewClipRight, viewClipBottom);
                                canvas.translate(chatListView.getLeft() + child.getX(), chatListView.getY() + child.getY() + child.getPaddingTop());
                                cell.drawScrimReaction(canvas, scrimViewReaction, scrimProgress, scrimProgressDirection);
                                canvas.restore();

                                canvas.save();
                                canvas.translate(chatListView.getLeft() + child.getX(), chatListView.getY() + child.getY() + child.getPaddingTop());
                                cell.drawScrimReactionPreview(this, canvas, scrimViewReactionOffset, scrimViewReaction, scrimProgress);
                                canvas.restore();
                            }
                        } else if (scrimViewReaction != null && actionCell != null) {
                            if (scrimBlurBitmapPaint != null) {
                                scrimBlurMatrix.reset();
                                final float s = (float) getMeasuredWidth() / scrimBlurBitmap.getWidth();
                                scrimBlurMatrix.postScale(s, s);
                                scrimBlurBitmapShader.setLocalMatrix(scrimBlurMatrix);
                                scrimBlurBitmapPaint.setAlpha((int) (0xFF * scrimViewProgress));
                                canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimBlurBitmapPaint);
                            } else {
                                scrimPaint.setAlpha((int) (255 * scrimPaintAlpha * scrimViewAlpha));
                                canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimPaint);
                            }

                            if (viewClipTop < viewClipBottom) {
                                final float scrimProgress = scrimPaintAlpha * scrimViewAlpha / 0.2f;

                                float alpha = child.getAlpha() * scrimViewAlpha;
                                if (alpha < 1f) {
                                    canvas.saveLayerAlpha(viewClipLeft, viewClipTop, viewClipRight, viewClipBottom, (int) (255 * alpha), Canvas.ALL_SAVE_FLAG);
                                } else {
                                    canvas.save();
                                }
                                canvas.clipRect(viewClipLeft, viewClipTop, viewClipRight, viewClipBottom);
                                canvas.translate(chatListView.getLeft() + child.getX(), chatListView.getY() + child.getY() + child.getPaddingTop());
                                actionCell.drawScrimReaction(canvas, scrimViewReaction, scrimProgress, scrimProgressDirection);
                                canvas.restore();

                                canvas.save();
                                canvas.translate(chatListView.getLeft() + child.getX(), chatListView.getY() + child.getY() + child.getPaddingTop());
                                actionCell.drawScrimReactionPreview(this, canvas, scrimViewReactionOffset, scrimViewReaction, scrimProgress);
                                canvas.restore();
                            }
                        }
                    }

                    int size = drawTimeAfter.size();
                    if (size > 0) {
                        for (int a = 0; a < size; a++) {
                            drawChildElement(canvas, listTop, drawTimeAfter.get(a), 0);
                        }
                        drawTimeAfter.clear();
                    }
                    size = drawNamesAfter.size();
                    if (size > 0) {
                        for (int a = 0; a < size; a++) {
                            drawChildElement(canvas, listTop, drawNamesAfter.get(a), 1);
                        }
                        drawNamesAfter.clear();
                    }
                    size = drawCaptionAfter.size();
                    if (size > 0) {
                        for (int a = 0; a < size; a++) {
                            ChatMessageCell cell = drawCaptionAfter.get(a);
                            if (cell.getCurrentPosition() == null && !cell.getTransitionParams().animateBackgroundBoundsInner) {
                                continue;
                            }
                            drawChildElement(canvas, listTop, cell, 2);
                        }
                        drawCaptionAfter.clear();
                    }
                    size = drawReactionsAfter.size();
                    if (size > 0) {
                        for (int a = 0; a < size; a++) {
                            ChatMessageCell cell = drawReactionsAfter.get(a);
                            if (cell.getCurrentPosition() == null && !cell.getTransitionParams().animateBackgroundBoundsInner) {
                                continue;
                            }
                            drawChildElement(canvas, listTop, cell, 3);
                        }
                    }
                    if (scrimViewReaction != null && scrimGroup != null) {
                        if (scrimBlurBitmapPaint != null) {
                            scrimBlurMatrix.reset();
                            final float s = (float) getMeasuredWidth() / scrimBlurBitmap.getWidth();
                            scrimBlurMatrix.postScale(s, s);
                            scrimBlurBitmapShader.setLocalMatrix(scrimBlurMatrix);
                            scrimBlurBitmapPaint.setAlpha((int) (0xFF * scrimViewProgress));
                            canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimBlurBitmapPaint);
                        } else {
                            scrimPaint.setAlpha((int) (255 * scrimPaintAlpha * scrimViewAlpha));
                            canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimPaint);
                        }
                    }
                    size = drawReactionsAfter.size();
                    if (size > 0) {
                        for (int a = 0; a < size; a++) {
                            ChatMessageCell cell = drawReactionsAfter.get(a);
                            if (cell.getCurrentPosition() == null && !cell.getTransitionParams().animateBackgroundBoundsInner) {
                                continue;
                            }
                            drawChildElement(canvas, listTop, cell, 4);
                        }
                        drawReactionsAfter.clear();
                    }
                }

                if (scrimViewReaction == null && scrimViewAlpha < 1f) {
                    if (scrimBlurBitmapPaint != null) {
                        scrimBlurMatrix.reset();
                        final float s = (float) getMeasuredWidth() / scrimBlurBitmap.getWidth();
                        scrimBlurMatrix.postScale(s, s);
                        scrimBlurBitmapShader.setLocalMatrix(scrimBlurMatrix);
                        scrimBlurBitmapPaint.setAlpha((int) (0xFF * scrimViewProgress));
                        canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimBlurBitmapPaint);
                    } else {
                        scrimPaint.setAlpha((int) (255 * scrimPaintAlpha * (1f - scrimViewAlpha)));
                        canvas.drawRect(0, 0, getMeasuredWidth(), getMeasuredHeight(), scrimPaint);
                    }
                }
            }

            if (scrimView != null || messageEnterTransitionContainer.isRunning()) {
                if (mentionContainer == null || mentionContainer.getVisibility() != View.VISIBLE) {
                    super.drawChild(canvas, sideControlsButtonsLayout, SystemClock.uptimeMillis());
                }
                if (floatingDateView != null && floatingDateView.getTag() != null) {
                    super.drawChild(canvas, floatingDateView, SystemClock.uptimeMillis());
                }
                if (floatingTopicSeparator != null && floatingTopicSeparator.getTag() != null) {
                    super.drawChild(canvas, floatingTopicSeparator, SystemClock.uptimeMillis());
                }
                if (fireworksOverlay != null) {
                    super.drawChild(canvas, fireworksOverlay, SystemClock.uptimeMillis());
                }
                if (quickShareSelectorOverlay != null) {
                    super.drawChild(canvas, quickShareSelectorOverlay, SystemClock.uptimeMillis());
                }
                if (gifHintTextView != null) {
                    super.drawChild(canvas, gifHintTextView, SystemClock.uptimeMillis());
                }
                if (emojiHintTextView != null) {
                    super.drawChild(canvas, emojiHintTextView, SystemClock.uptimeMillis());
                }
                if (undoView != null && undoView.getVisibility() == View.VISIBLE) {
                    super.drawChild(canvas, undoView, SystemClock.uptimeMillis());
                }
                if (topUndoView != null && topUndoView.getVisibility() == View.VISIBLE) {
                    super.drawChild(canvas, topUndoView, SystemClock.uptimeMillis());
                }
                if (savedMessagesTagHint != null && savedMessagesTagHint.getVisibility() == View.VISIBLE) {
                    super.drawChild(canvas, savedMessagesTagHint, SystemClock.uptimeMillis());
                }
                if (videoConversionTimeHint != null && videoConversionTimeHint.getVisibility() == View.VISIBLE) {
                    super.drawChild(canvas, videoConversionTimeHint, SystemClock.uptimeMillis());
                }
                if (botMessageHint != null && botMessageHint.getVisibility() == View.VISIBLE) {
                    super.drawChild(canvas, botMessageHint, SystemClock.uptimeMillis());
                }
                if (chatActivityEnterView != null && chatActivityEnterView.birthdayHint != null) {
                    canvas.save();
                    canvas.translate(chatActivityEnterView.getX() + chatActivityEnterView.birthdayHint.getX(), chatActivityEnterView.getY() + chatActivityEnterView.birthdayHint.getY());
                    chatActivityEnterView.birthdayHint.draw(canvas);
                    canvas.restore();
                }
            }

            if (fixedKeyboardHeight > 0 && keyboardHeight < AndroidUtilities.dp(20)) {
                int color = getThemedColor(Theme.key_windowBackgroundWhite);
                if (backgroundPaint == null) {
                    backgroundPaint = new Paint();
                }
                if (backgroundColor != color) {
                    backgroundPaint.setColor(backgroundColor = color);
                }
                canvas.drawRect(0,getMeasuredHeight() - fixedKeyboardHeight, getMeasuredWidth(), getMeasuredHeight(), backgroundPaint);
            }
            if (pullingDownDrawable != null && pullingDownDrawable.needDrawBottomPanel()) {
                int top, bottom;
                top = (int) chatInputViewsContainer.getInputBubbleTop();
                bottom = (int) chatInputViewsContainer.getInputBubbleBottom();

                top -= (int) ((pullingDownAnimateToActivity == null ? 0 : pullingDownAnimateToActivity.pullingBottomOffset) * pullingDownAnimateProgress);
                pullingDownDrawable.drawBottomPanel(canvas, top, bottom, getMeasuredWidth());
            }
            if (pullingDownAnimateToActivity != null) {
                canvas.saveLayerAlpha(0, 0, getMeasuredWidth(), getMeasuredHeight(), (int) (255 * pullingDownAnimateProgress), Canvas.ALL_SAVE_FLAG);
                pullingDownAnimateToActivity.fragmentView.draw(canvas);
                canvas.restore();
            }

            emojiAnimationsOverlay.draw(canvas);

            if (restoreToCount >= 0) {
                canvas.restore();
            }
            if (switchingFromTopics) {
                canvas.save();
                canvas.translate(actionBar.getX(), actionBar.getY());
                canvas.saveLayerAlpha(0, 0, actionBar.getWidth(), actionBar.getHeight(), (int) (255 * switchingFromTopicsProgress), Canvas.ALL_SAVE_FLAG);
                actionBar.draw(canvas);
                canvas.restore();
                canvas.restore();
            }

            /*if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S && scrollableViewNoiseSuppressor != null) {
                scrollableViewNoiseSuppressor.drawDebugPositions(canvas);
            }*/
        }

        @Override
        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            invalidateBlurredSourcesView.bringToFrontIfNeeded();

            int allHeight;
            int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
            int heightSize = allHeight = View.MeasureSpec.getSize(heightMeasureSpec);

            if (navbarContentSourceWallpaper.getSource() instanceof BlurredBackgroundSourceBitmap) {
                ((BlurredBackgroundSourceBitmap) navbarContentSourceWallpaper.getSource())
                    .setParentSize(widthSize, heightSize, ActionBar.getCurrentActionBarHeight() + AndroidUtilities.statusBarHeight);
            }
            if (lastWidth != widthSize) {
                globalIgnoreLayout = false;
                lastWidth = widthMeasureSpec;
                if (!inPreviewMode && currentUser != null && currentUser.self) {
                    SimpleTextView textView = avatarContainer.getTitleTextView();
                    int textWidth = (int) textView.getPaint().measureText(textView.getText(), 0, textView.getText().length());
                    if (widthSize - AndroidUtilities.dp(96 + 56) > textWidth + AndroidUtilities.dp(10)) {
                        showSearchAsIcon = !showAudioCallAsIcon;
                    } else {
                        showSearchAsIcon = false;
                    }
                } /*else if (chatMode == MODE_SUGGESTIONS) {
                    showSearchAsIcon = true;
                }*/ else {
                    showSearchAsIcon = false;
                }
                if (showSearchAsIcon || showAudioCallAsIcon) {
                    if (avatarContainer != null && avatarContainer.getLayoutParams() != null) {
                        ((ViewGroup.MarginLayoutParams) avatarContainer.getLayoutParams()).rightMargin = AndroidUtilities.dp(chatMode == MODE_SAVED ? 40 : 96);
                    }
                } else {
                    if (avatarContainer != null && avatarContainer.getLayoutParams() != null) {
                        ((ViewGroup.MarginLayoutParams) avatarContainer.getLayoutParams()).rightMargin = AndroidUtilities.dp(40);
                    }
                }
                if (showSearchAsIcon) {
                    if (!actionBar.isSearchFieldVisible() && searchIconItem != null) {
                        searchIconItem.setVisibility(View.VISIBLE);
                    }
                    if (headerItem != null) {
                        headerItem.hideSubItem(search);
                    }
                } else {
                    if (headerItem != null) {
                        headerItem.showSubItem(search);
                    }
                    if (searchIconItem != null) {
                        searchIconItem.setVisibility(View.GONE);
                    }
                }
                if (!actionBar.isSearchFieldVisible() && audioCallIconItem != null) {
                    audioCallIconItem.setVisibility((showAudioCallAsIcon && !showSearchAsIcon) ? View.VISIBLE : View.GONE);
                }
                if (headerItem != null) {
                    TLRPC.UserFull userInfo = getCurrentUserInfo();
                    if (showAudioCallAsIcon) {
                        headerItem.hideSubItem(call);
                    } else if (userInfo != null && userInfo.phone_calls_available) {
                        headerItem.showSubItem(call, true);
                    }
                }
                globalIgnoreLayout = false;
            }

            setMeasuredDimension(widthSize, heightSize);
            heightSize -= getPaddingTop();

            if (webBotTitle != null) {
                ((LayoutParams) webBotTitle.getLayoutParams()).topMargin = AndroidUtilities.statusBarHeight;
                webBotTitle.setTextSize(!AndroidUtilities.isTablet() && getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE ? 18 : 20);
            }
            measureChildWithMargins(actionBar, widthMeasureSpec, 0, heightMeasureSpec, 0);
            int actionBarHeight = actionBar.getMeasuredHeight();
            if (actionBar.getVisibility() == VISIBLE) {
                heightSize -= actionBarHeight;
            }
            int keyboardHeightOld = keyboardHeight + chatEmojiViewPadding;
            boolean keyboardVisibleOld = keyboardHeight + chatEmojiViewPadding >= AndroidUtilities.dp(20);
            if (lastHeight != allHeight) {
                measureKeyboardHeight();
            }
            int keyboardSize = getKeyboardHeight();
            if (fixedKeyboardHeight > 0 && keyboardSize <= AndroidUtilities.dp(20)) {
                chatEmojiViewPadding = fixedKeyboardHeight;
            } else {
                if (keyboardSize <= AndroidUtilities.dp(20)) {
                    chatEmojiViewPadding = chatActivityEnterView.isPopupShowing() ? chatActivityEnterView.getEmojiPadding() : 0;
                } else {
                    chatEmojiViewPadding = 0;
                }
            }
            setEmojiKeyboardHeight(chatEmojiViewPadding);

            boolean keyboardVisible = keyboardHeight + chatEmojiViewPadding >= AndroidUtilities.dp(20);
            boolean waitingChatListItemAnimator = false;
            if (MediaController.getInstance().getPlayingMessageObject() != null && MediaController.getInstance().getPlayingMessageObject().isRoundVideo() && keyboardVisibleOld != keyboardVisible) {
                for (int i = 0; i < chatListView.getChildCount(); i++) {
                    View child = chatListView.getChildAt(i);
                    if (child instanceof ChatMessageCell) {
                        ChatMessageCell cell = (ChatMessageCell) child;
                        MessageObject messageObject = cell.getMessageObject();
                        if (messageObject.isRoundVideo() && MediaController.getInstance().isPlayingMessage(messageObject)) {
                            int p = chatListView.getChildAdapterPosition(child);
                            if (p >= 0) {
                                chatLayoutManager.scrollToPositionWithOffset(p, (int) ((chatListView.getMeasuredHeight() - chatListViewPaddingTop - blurredViewBottomOffset + (keyboardHeight + chatEmojiViewPadding - keyboardHeightOld) - (keyboardVisible ? AndroidUtilities.roundMessageSize : AndroidUtilities.roundPlayingMessageSize(isSideMenued()))) / 2), false);
                                chatAdapter.notifyItemChanged(p);
                                adjustPanLayoutHelper.delayAnimation();
                                waitingChatListItemAnimator = true;
                                break;
                            }
                        }
                    }
                }
            }

            if (!waitingChatListItemAnimator) {
                chatActivityEnterView.runEmojiPanelAnimation();
            }

            int childCount = getChildCount();
            measureChildWithMargins(chatActivityEnterView, widthMeasureSpec, 0, heightMeasureSpec, 0);

            if (inPreviewMode || isInsideContainer) {
                inputFieldHeight = 0;
            } else {
                inputFieldHeight = chatActivityEnterView.getMeasuredHeight();
            }

            blurredViewTopOffset = 0;
            blurredViewBottomOffset = 0;
            if (SharedConfig.chatBlurEnabled() && !isInsideContainer) {
                if (scrollableViewNoiseSuppressor != null && Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                    blurredViewTopOffset = actionBarHeight + recommendedAdditionalSizeY;
                    blurredViewBottomOffset = recommendedAdditionalSizeY;
                }
            }
            for (int i = 0; i < childCount; i++) {
                View child = getChildAt(i);

                if (child == null || child.getVisibility() == GONE || child == chatActivityEnterView || child == actionBar) {
                    continue;
                }
                if (child == backgroundView) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(allHeight, View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == blurredView) {
                    int h = allHeight;
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(h, View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == chatListView || child == chatListThanosEffect) {
                    int contentWidthSpec = MeasureSpec.makeMeasureSpec(widthSize, MeasureSpec.EXACTLY);
                    int h = heightSize + blurredViewTopOffset + blurredViewBottomOffset + chatListViewPaddingsAnimator.getCurrentAdditionalHeight();
                    int contentHeightSpec = MeasureSpec.makeMeasureSpec(
                        Math.max(dp(10), h), View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == progressView) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(Math.max(AndroidUtilities.dp(10), heightSize - inputFieldHeight - (inPreviewMode ? AndroidUtilities.statusBarHeight : 0) + AndroidUtilities.dp(2 + (chatActivityEnterView.isTopViewVisible() ? 48 : 0))), View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == instantCameraView) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(allHeight, View.MeasureSpec.EXACTLY);
                    instantCameraView.setInternalPadding(windowInsetsStateHolder.getCurrentMaxBottomInset()
                        + (int) inputIslandHeightTarget + dp(9 + 3));

                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == overlayView) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(allHeight
                        - windowInsetsStateHolder.getCurrentMaxBottomInset()
                        - (int) inputIslandHeightTarget
                        - dp(9 + 3), View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == emptyViewContainer) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(heightSize, View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == messagesSearchListContainer) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(allHeight
                            - (isInsideContainer ? 0 : actionBarHeight)
                            - AndroidUtilities.dp(44 + 9 + 1) // input field with margins
                            - windowInsetsStateHolder.getCurrentNavigationBarInset(),
                        View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (chatActivityEnterView.isPopupView(child)) {
                    int height = chatActivityEnterView.getPopupViewHeight(child);
                    if (inBubbleMode) {
                        int maxHeight = (heightSize - inputFieldHeight + actionBarHeight + getPaddingTop());
                        if (height < 0) {
                            height = Math.max(Math.min(maxHeight, AndroidUtilities.dp(350)), maxHeight / 2);
                        }
                        child.measure(View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY), View.MeasureSpec.makeMeasureSpec(height, View.MeasureSpec.EXACTLY));
                    } else if (AndroidUtilities.isInMultiwindow) {
                        int maxHeight = (heightSize - inputFieldHeight + actionBarHeight - AndroidUtilities.statusBarHeight + getPaddingTop());
                        if (height < 0) {
                            height = Math.max(Math.min(maxHeight, AndroidUtilities.dp(350)), maxHeight / 2);
                        }
                        child.measure(View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY), View.MeasureSpec.makeMeasureSpec(height, View.MeasureSpec.EXACTLY));
                    } else {
                        child.measure(View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY), View.MeasureSpec.makeMeasureSpec(child.getLayoutParams().height, View.MeasureSpec.EXACTLY));
                    }
                } else if (child == mentionContainer) {
                    FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) mentionContainer.getLayoutParams();
                    if (mentionContainer.getAdapter().isBannedInline()) {
                        child.measure(View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY), View.MeasureSpec.makeMeasureSpec(heightSize, View.MeasureSpec.AT_MOST));
                    } else {
                        mentionContainer.setIgnoreLayout(true);
                        layoutParams.height = heightSize;
                        layoutParams.topMargin = 0;
                        mentionContainer.setIgnoreLayout(false);
                        child.measure(View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY), View.MeasureSpec.makeMeasureSpec(layoutParams.height, View.MeasureSpec.EXACTLY));
                    }
                } else if (child == textSelectionHelper.getOverlayView(getContext())) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int h = heightSize + blurredViewTopOffset;
                    if (keyboardSize > AndroidUtilities.dp(20) && getLayoutParams().height < 0 && !isInsideContainer) {
                        h += keyboardSize;
                        textSelectionHelper.setKeyboardSize(keyboardSize);
                    } else {
                        textSelectionHelper.setKeyboardSize(0);
                    }
                    child.measure(contentWidthSpec, View.MeasureSpec.makeMeasureSpec(h, View.MeasureSpec.EXACTLY));
                } else if (child instanceof MessagePreviewView) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int h = allHeight - AndroidUtilities.statusBarHeight;
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(h, View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == hashtagHistoryView) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(allHeight - (isInsideContainer ? 0 : actionBarHeight) - (hashtagSearchTabs != null ? hashtagSearchTabs.getHeight() : 0), View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == searchViewPager) {
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(allHeight, View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else if (child == topicsTabs) {
                    int height = allHeight;
                    if (actionBar.getVisibility() == VISIBLE) {
                        height -= actionBar.getMeasuredHeight();
                    }
                    int contentWidthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, View.MeasureSpec.EXACTLY);
                    int contentHeightSpec = View.MeasureSpec.makeMeasureSpec(height, View.MeasureSpec.EXACTLY);
                    child.measure(contentWidthSpec, contentHeightSpec);
                } else {
                    measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
                }
            }
            if (fixPaddingsInLayout) {
                globalIgnoreLayout = true;
                invalidateChatListViewTopPadding();
                invalidateMessagesVisiblePart();
                fixPaddingsInLayout = false;
                chatListView.measure(View.MeasureSpec.makeMeasureSpec(chatListView.getMeasuredWidth(), View.MeasureSpec.EXACTLY), View.MeasureSpec.makeMeasureSpec(chatListView.getMeasuredHeight(), View.MeasureSpec.EXACTLY));
                globalIgnoreLayout = false;
            }
            if (scrollToPositionOnRecreate != -1) {
                final int scrollTo = scrollToPositionOnRecreate;
                AndroidUtilities.runOnUIThread(() -> chatLayoutManager.scrollToPositionWithOffset(scrollTo, scrollToOffsetOnRecreate));
                scrollToPositionOnRecreate = -1;
            }

            updateBulletinLayout();
            checkInsets();

            lastHeight = allHeight;
        }

        @Override
        public void requestLayout() {
            if (globalIgnoreLayout) {
                return;
            }
            super.requestLayout();
        }

        @Override
        public int getKeyboardHeight() {
            if (isInsideContainer) return 0;
            return super.getKeyboardHeight();
        }

        @Override
        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            final int count = getChildCount();
            int paddingBottom = 0;

            for (int i = 0; i < count; i++) {
                final View child = getChildAt(i);
                if (child == null || child.getVisibility() == GONE) {
                    continue;
                }
                final FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams) child.getLayoutParams();

                final int width = child.getMeasuredWidth();
                final int height = child.getMeasuredHeight();

                int childLeft;
                int childTop;

                int gravity = lp.gravity;
                if (gravity == -1) {
                    gravity = Gravity.TOP | Gravity.LEFT;
                }

                final int absoluteGravity = gravity & Gravity.HORIZONTAL_GRAVITY_MASK;
                final int verticalGravity = gravity & Gravity.VERTICAL_GRAVITY_MASK;

                switch (absoluteGravity & Gravity.HORIZONTAL_GRAVITY_MASK) {
                    case Gravity.CENTER_HORIZONTAL:
                        childLeft = (r - l - width) / 2 + lp.leftMargin - lp.rightMargin;
                        break;
                    case Gravity.RIGHT:
                        childLeft = r - width - lp.rightMargin;
                        break;
                    case Gravity.LEFT:
                    default:
                        childLeft = lp.leftMargin;
                }

                switch (verticalGravity) {
                    case Gravity.TOP:
                        childTop = lp.topMargin + getPaddingTop();
                        if (child != actionBar && actionBar.getVisibility() == VISIBLE) {
                            childTop += actionBar.getMeasuredHeight();
                        }
                        break;
                    case Gravity.CENTER_VERTICAL:
                        childTop = ((b - paddingBottom) - t - height) / 2 + lp.topMargin - lp.bottomMargin;
                        break;
                    case Gravity.BOTTOM:
                        childTop = ((b - paddingBottom) - t) - height - lp.bottomMargin;
                        break;
                    default:
                        childTop = lp.topMargin;
                }

                if (child == blurredView || child == backgroundView || child == quickShareSelectorOverlay || child == chatInputViewsContainer || child == chatInputViewsContainer.getFadeView()) {
                    childTop = 0;
                } else if (child instanceof HintView || child instanceof ChecksHintView) {
                    childTop = 0;
                } else if (child == emptyViewContainer) {
                    childTop += (actionBar.getVisibility() == VISIBLE ? actionBar.getMeasuredHeight() / 2 : 0);
                } else if (chatActivityEnterView.isPopupView(child)) {
                    if (AndroidUtilities.isInMultiwindow || inBubbleMode) {
                        childTop = chatActivityEnterView.getTop() - child.getMeasuredHeight() + AndroidUtilities.dp(1);
                    } else {
                        childTop = chatActivityEnterView.getBottom();
                    }
                } else if (chatActivityEnterView != null && chatActivityEnterView.isRecordCircleOrControlsView(child)) {
                    childTop -= windowInsetsStateHolder.getCurrentMaxBottomInset() + dp(7);
                } else if (child == emojiButtonRed) {
                    childTop -= windowInsetsStateHolder.getCurrentMaxBottomInset() + dp(7);
                } else if (chatActivityEnterView != null && child == chatActivityEnterView.recordedAudioPanel) {
                    childTop -= windowInsetsStateHolder.getCurrentMaxBottomInset() + dp(9);
                } else if (child == gifHintTextView || child == voiceHintTextView || child == mediaBanTooltip || child == emojiHintTextView) {
                    childTop -= inputFieldHeight;
                } else if (child == chatListView || child == chatListThanosEffect || child == floatingDateView || child == floatingTopicSeparator || child == infoTopView) {
                    childTop -= blurredViewTopOffset + chatListViewPaddingsAnimator.getCurrentAdditionalHeight();
                } else if (child == progressView) {
                    if (chatActivityEnterView.isTopViewVisible()) {
                        childTop -= AndroidUtilities.dp(48);
                    }
                } else if (child == actionBar) {
                    childTop -= getPaddingTop();
                } else if (child == videoPlayerContainer) {
                    childTop = actionBar.getMeasuredHeight();
                } else if (child == instantCameraView || child == overlayView || child == animatingImageView) {
                    childTop = 0;
                } else if (child == textSelectionHelper.getOverlayView(getContext())) {
                    childTop -= blurredViewTopOffset;
                } else if (child instanceof MessagePreviewView) {
                    childTop = AndroidUtilities.statusBarHeight;
                } else if (child == searchViewPager) {
                    childTop = 0;
                } else if (child == messagesSearchListContainer) {
                    if (isInsideContainer && parentChatActivity != null) {
                        childTop += chatMode != MODE_SEARCH ? contentPaddingTop : actionBar.getMeasuredHeight();
                    }
                }
                child.layout(childLeft, childTop, childLeft + width, childTop + height);
            }

            invalidateChatListViewTopPadding();
            invalidateMessagesVisiblePart();
            updateTextureViewPosition(false, false);

            if (getParentActivity() instanceof LaunchActivity && !((LaunchActivity) getParentActivity()).drawerLayoutContainer.allowDrawContent) {
                updateChatListViewTopPadding();
            }

            notifyHeightChanged();
        }

        private void setNonNoveTranslation(float y) {
            contentView.setTranslationY(y);
            actionBar.setTranslationY(0);
            if (tagSelector != null) {
                tagSelector.setTranslationY((actionBarSearchTags != null ? actionBarSearchTags.getCurrentHeight() : 0));
            }
            if (savedMessagesSearchHint != null) {
                savedMessagesSearchHint.setTranslationY(0);
            }
            if (savedMessagesHint != null) {
                savedMessagesHint.setTranslationY(0);
            }
            if (actionBarSearchTags != null) {
                actionBarSearchTags.setTranslationY(0);
            }
            if (topicsTabs != null) {
                topicsTabs.setTranslationY(0);
            }
            if (hashtagSearchTabs != null) {
                hashtagSearchTabs.setTranslationY(0);
            }
            emptyViewContainer.setTranslationY(0);
            progressView.setTranslationY(0);
            contentPanTranslation = 0;
            contentPanTranslationT = 0;
            contentView.setBackgroundTranslation(0);
            if (contentView != null) {
                contentView.updateBlurContent();
            }
            if (instantCameraView != null) {
                instantCameraView.onPanTranslationUpdate(0);
            }
            if (blurredView != null) {
                blurredView.drawable.onPanTranslationUpdate(0);
            }
            setFragmentPanTranslationOffset(0);
            invalidateChatListViewTopPadding();
        }

        @Override
        public void setPadding(int left, int top, int right, int bottom) {
            contentPaddingTop = top;
            invalidateChatListViewTopPadding();
            invalidateMessagesVisiblePart();
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent event) {
            if (event.getKeyCode() == KeyEvent.KEYCODE_BACK && event.getAction() == 1 && forwardingPreviewView != null && forwardingPreviewView.isShowing()) {
                forwardingPreviewView.dismiss(true);
                return true;
            }
            return super.dispatchKeyEvent(event);
        }

        protected Drawable getNewDrawable() {
            Drawable drawable = themeDelegate.getWallpaperDrawable();
            return drawable != null ? drawable : super.getNewDrawable();
        }

        protected boolean getNewDrawableMotion() {
            if (themeDelegate.wallpaper == null) {
                return super.getNewDrawableMotion();
            }
            return themeDelegate.wallpaper.settings != null && themeDelegate.wallpaper.settings.motion;
        }

        @Override
        public void invalidateBlur() {
            /*super.invalidateBlur();
            if (parentChatActivity != null) {
                parentChatActivity.contentView.invalidateBlur();
            }*/
        }

        @Override
        public void updateBlurContent() {
            /*super.updateBlurContent();
            if (parentChatActivity != null) {
                parentChatActivity.contentView.updateBlurContent();
            }*/
        }
    };

    private void updateSecretStatus() {
        if (bottomOverlay == null) {
            return;
        }
        boolean hideKeyboard = false;
        bottomOverlayText.setBackground(null);
        bottomOverlayText.setOnClickListener(null);
        if (chatMode == MODE_SAVED && getSavedDialogId() == UserObject.ANONYMOUS) {
            bottomOverlayText.setText(LocaleController.getString(R.string.AuthorHiddenDescription));
            bottomOverlay.setVisibility(View.VISIBLE);
            if (mentionListAnimation != null) {
                mentionListAnimation.cancel();
                mentionListAnimation = null;
            }
            mentionContainer.setVisibility(View.GONE);
            mentionContainer.setTag(null);
            updateMessageListAccessibilityVisibility();
            hideKeyboard = true;
            if (suggestEmojiPanel != null) {
                suggestEmojiPanel.forceClose();
            }
        } else if (currentChat != null && !ChatObject.canSendMessages(currentChat) && !ChatObject.canSendAnyMedia(currentChat) && !currentChat.gigagroup && (!ChatObject.isChannel(currentChat) || currentChat.megagroup)) {
            if (currentChat.default_banned_rights != null && currentChat.default_banned_rights.send_messages) {
                boolean unlockByBoosts = ChatObject.isPossibleRemoveChatRestrictionsByBoosts(currentChat);
                if (unlockByBoosts) {
                    Drawable drawable = ContextCompat.getDrawable(getContext(), R.drawable.filled_limit_boost).mutate();
                    DrawableCompat.setTint(drawable, getThemedColor(Theme.key_featuredStickers_addButton));
                    drawable.setBounds(0, 0, dp(14), dp(14));
                    CombinedDrawable combinedDrawable = new CombinedDrawable(null, drawable, dp(-6), dp(-6));
                    combinedDrawable.setIconSize(dp(14), dp(14));
                    combinedDrawable.setCustomSize(dp(14), dp(14));

                    SpannableStringBuilder builder = new SpannableStringBuilder("d " + LocaleController.getString(R.string.BoostingBoostToSendMessages));
                    builder.setSpan(new ForegroundColorSpan(getThemedColor(Theme.key_featuredStickers_addButton)), 0, builder.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                    builder.setSpan(new TypefaceSpan(AndroidUtilities.bold()), 0, builder.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                    builder.setSpan(new ImageSpan(combinedDrawable, ImageSpan.ALIGN_BASELINE), 0, 1, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);

                    bottomOverlayText.setBackground(Theme.createSelectorWithBackgroundDrawable(0, Theme.getColor(Theme.key_listSelector)));
                    bottomOverlayText.setText(builder);
                    bottomOverlayText.setOnClickListener(v -> LimitReachedBottomSheet.openBoostsForRemoveRestrictions(this, boostsStatus, canApplyBoosts, dialog_id, false));
                } else {
                    bottomOverlayText.setText(LocaleController.getString(R.string.GlobalSendMessageRestricted));
                }
            } else if (AndroidUtilities.isBannedForever(currentChat.banned_rights)) {
                bottomOverlayText.setText(LocaleController.getString(R.string.SendMessageRestrictedForever));
            } else {
                bottomOverlayText.setText(LocaleController.formatString("SendMessageRestricted", R.string.SendMessageRestricted, LocaleController.formatDateForBan(currentChat.banned_rights.until_date)));
            }
            bottomOverlay.setVisibility(View.VISIBLE);
            if (mentionListAnimation != null) {
                mentionListAnimation.cancel();
                mentionListAnimation = null;
            }
            mentionContainer.setVisibility(View.GONE);
            mentionContainer.setTag(null);
            updateMessageListAccessibilityVisibility();
            hideKeyboard = true;
            if (suggestEmojiPanel != null) {
                suggestEmojiPanel.forceClose();
            }
        } else {
            createEmptyView(false);
            if (currentEncryptedChat == null || bigEmptyView == null) {
                bottomOverlay.setVisibility(View.INVISIBLE);
                if (suggestEmojiPanel != null && chatActivityEnterView != null && chatActivityEnterView.hasText()) {
                    suggestEmojiPanel.fireUpdate();
                }
                return;
            }
            if (currentEncryptedChat instanceof TLRPC.TL_encryptedChatRequested) {
                bottomOverlayText.setText(LocaleController.getString(R.string.EncryptionProcessing));
                bottomOverlay.setVisibility(View.VISIBLE);
                chatActivityEnterView.setVisibility(View.INVISIBLE);
                hideKeyboard = true;
            } else if (currentEncryptedChat instanceof TLRPC.TL_encryptedChatWaiting) {
                bottomOverlayText.setText(AndroidUtilities.replaceTags(LocaleController.formatString("AwaitingEncryption", R.string.AwaitingEncryption, "<b>" + currentUser.first_name + "</b>")));
                bottomOverlay.setVisibility(View.VISIBLE);
                chatActivityEnterView.setVisibility(View.INVISIBLE);
                hideKeyboard = true;
            } else if (currentEncryptedChat instanceof TLRPC.TL_encryptedChatDiscarded) {
                bottomOverlayText.setText(LocaleController.getString(R.string.EncryptionRejected));
                bottomOverlay.setVisibility(View.VISIBLE);
                chatActivityEnterView.setVisibility(View.INVISIBLE);
                chatActivityEnterView.setFieldText("");
                getMediaDataController().cleanDraft(dialog_id, threadMessageId, false);
                hideKeyboard = true;
            } else if (currentEncryptedChat instanceof TLRPC.TL_encryptedChat) {
                bottomOverlay.setVisibility(View.INVISIBLE);
                if (!inPreviewMode && !isInsideContainer && chatMode != MODE_SAVED) {
                    chatActivityEnterView.setVisibility(View.VISIBLE);
                }
            }
            checkRaiseSensors();
            checkActionBarMenu(false);
        }
        if (inPreviewMode) {
            bottomOverlay.setVisibility(View.INVISIBLE);
        }
        if (hideKeyboard) {
            chatActivityEnterView.hidePopup(false);
            if (getParentActivity() != null) {
                AndroidUtilities.hideKeyboard(getParentActivity().getCurrentFocus());
            }
        }
    }

    @Override
    public void onRequestPermissionsResultFragment(int requestCode, String[] permissions, int[] grantResults) {
        if (chatActivityEnterView != null) {
            chatActivityEnterView.onRequestPermissionsResultFragment(requestCode, permissions, grantResults);
        }
        if (mentionContainer != null && mentionContainer.getAdapter() != null) {
            mentionContainer.getAdapter().onRequestPermissionsResultFragment(requestCode, permissions, grantResults);
        }
        if (requestCode == BasePermissionsActivity.REQUEST_CODE_EXTERNAL_STORAGE) {
            if (chatAttachAlert != null) {
                chatAttachAlert.getPhotoLayout().checkStorage();
            }
            if (chatThemeBottomSheet != null && chatThemeBottomSheet.chatAttachAlert != null) {
                chatThemeBottomSheet.chatAttachAlert.getPhotoLayout().checkStorage();
            }
        } else if ((requestCode == BasePermissionsActivity.REQUEST_CODE_ATTACH_CONTACT || requestCode == 30) && chatAttachAlert != null) {
            chatAttachAlert.onRequestPermissionsResultFragment(requestCode, permissions, grantResults);
        } else if ((requestCode == 17 || requestCode == 18) && chatAttachAlert != null) {
            chatAttachAlert.getPhotoLayout().checkCamera(grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED);
            chatAttachAlert.getPhotoLayout().checkStorage();
        } else if (requestCode == 21) {
            if (getParentActivity() == null) {
                return;
            }
            if (grantResults != null && grantResults.length != 0 && grantResults[0] != PackageManager.PERMISSION_GRANTED) {
                AlertDialog.Builder builder = new AlertDialog.Builder(getParentActivity(), themeDelegate);
                builder.setTitle(LocaleController.getString(R.string.AppName));
                builder.setMessage(LocaleController.getString(R.string.PermissionNoAudioVideoWithHint));
                builder.setNegativeButton(LocaleController.getString(R.string.PermissionOpenSettings), (dialog, which) -> {
                    try {
                        Intent intent = new Intent(android.provider.Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
                        intent.setData(Uri.parse("package:" + ApplicationLoader.applicationContext.getPackageName()));
                        getParentActivity().startActivity(intent);
                    } catch (Exception e) {
                        FileLog.e(e);
                    }
                });
                builder.setPositiveButton(LocaleController.getString(R.string.OK), null);
                builder.show();
            }
        } else if (requestCode == 19 && grantResults != null && grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            processSelectedAttach(attach_photo);
        } else if (requestCode == BasePermissionsActivity.REQUEST_CODE_OPEN_CAMERA && grantResults != null && grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            processSelectedAttach(attach_video);
        } else if ((requestCode == 101 || requestCode == 102) && currentUser != null || requestCode == 103 && currentChat != null) {
            boolean allGranted = true;
            for (int a = 0; a < grantResults.length; a++) {
                if (grantResults[a] != PackageManager.PERMISSION_GRANTED) {
                    allGranted = false;
                    break;
                }
            }
            if (grantResults.length > 0 && allGranted) {
                if (requestCode == 103) {
                    VoIPHelper.startCall(currentChat, null, null, createGroupCall, getParentActivity(), ChatActivity.this, getAccountInstance());
                } else {
                    VoIPHelper.startCall(currentUser, requestCode == 102, userInfo != null && userInfo.video_calls_available, getParentActivity(), getMessagesController().getUserFull(currentUser.id), getAccountInstance());
                }
            } else {
                VoIPHelper.permissionDenied(getParentActivity(), null, requestCode);
            }
        }
    }

    private void checkActionBarMenu(boolean animated) {
        if (currentEncryptedChat != null && !(currentEncryptedChat instanceof TLRPC.TL_encryptedChat) ||
                currentChat != null && (chatMode != 0 || threadMessageId != 0 || chatInfo == null || chatInfo.ttl_period == 0) ||
                currentUser != null && (UserObject.isDeleted(currentUser) || currentEncryptedChat == null && (userInfo == null || userInfo.ttl_period == 0))) {
            if (timeItem2 != null) {
                timeItem2.setVisibility(View.GONE);
            }
            if (avatarContainer != null) {
                avatarContainer.hideTimeItem(animated);
            }
        } else {
            if (timeItem2 != null) {
                timeItem2.setVisibility(View.VISIBLE);
            }
            if (avatarContainer != null) {
                avatarContainer.showTimeItem(animated);
            }
        }
        if (viewAsTopics != null) {
            viewAsTopics.setVisibility(currentChat != null && currentChat.forum ? View.VISIBLE : View.GONE);
        }
        if (avatarContainer != null) {
            avatarContainer.setStars(currentChat != null && (currentChat.flags2 & 2048) != 0, animated);
            if (currentEncryptedChat != null) {
                avatarContainer.setTime(currentEncryptedChat.ttl, animated);
            } else if (userInfo != null) {
                avatarContainer.setTime(userInfo.ttl_period, animated);
            } else if (chatInfo != null) {
                avatarContainer.setTime(chatInfo.ttl_period, animated);
            }
        }
        if (clearHistoryItem != null && chatInfo != null) {
            boolean visible = chatInfo.can_delete_channel || !ChatObject.isChannel(currentChat) || currentChat.megagroup && !ChatObject.isPublic(currentChat);
            clearHistoryItem.setVisibility(visible ? View.VISIBLE : View.GONE);
        }
        checkAndUpdateAvatar();
    }

    private int getMessageType(MessageObject messageObject) {
        if (messageObject == null) {
            return -1;
        }
        if (currentEncryptedChat == null) {
            if (messageObject.isEditing()) {
                return -1;
            } else if (messageObject.getId() <= 0 && messageObject.isOut()) {
                if (messageObject.isSendError()) {
                    if (!messageObject.isMediaEmpty()) {
                        return 0;
                    } else {
                        return 20;
                    }
                } else {
                    return -1;
                }
            } else {
                if (messageObject.isAnimatedEmoji()) {
                    return 2;
                } else if (messageObject.type == MessageObject.TYPE_LOADING) {
                    return -1;
                } else if (messageObject.type == MessageObject.TYPE_DATE || messageObject.type == MessageObject.TYPE_GIFT_THEME_UPDATE || messageObject.type == MessageObject.TYPE_ACTION_PHOTO || messageObject.type == MessageObject.TYPE_SUGGEST_PHOTO || messageObject.type == MessageObject.TYPE_GIFT_STARS || messageObject.isWallpaperAction()) {
                    if (messageObject.getId() == 0) {
                        return -1;
                    }
                    return 1;
                } else {
                    if (messageObject.isVoice()) {
                        return 2;
                    } else if (messageObject.isSticker() || messageObject.isAnimatedSticker()) {
                        TLRPC.InputStickerSet inputStickerSet = messageObject.getInputStickerSet();
                        if (inputStickerSet instanceof TLRPC.TL_inputStickerSetID) {
                            if (!getMediaDataController().isStickerPackInstalled(inputStickerSet.id)) {
                                return 7;
                            }
                        } else if (inputStickerSet instanceof TLRPC.TL_inputStickerSetShortName) {
                            if (!getMediaDataController().isStickerPackInstalled(inputStickerSet.short_name)) {
                                return 7;
                            }
                        }
                        return 9;
                    } else if (!messageObject.isRoundVideo() && (messageObject.messageOwner.media instanceof TLRPC.TL_messageMediaPhoto || messageObject.getDocument() != null || messageObject.isMusic() || messageObject.isVideo())) {
                        boolean canSave = false;
                        if (!TextUtils