/*
 * This is the source code of Telegram for Android v. 5.x.x.
 * It is licensed under GNU GPL v. 2 or later.
 * You should have received a copy of the license in this archive (see LICENSE).
 *
 * Copyright Nikolai Kudashov, 2013-2018.
 */

package org.telegram.messenger;

import static org.telegram.messenger.AndroidUtilities.dp;
import static org.telegram.messenger.LocaleController.getString;
import static org.telegram.messenger.NotificationsController.TYPE_CHANNEL;
import static org.telegram.messenger.NotificationsController.TYPE_PRIVATE;
import static org.telegram.messenger.NotificationsController.TYPE_REACTIONS_MESSAGES;
import static org.telegram.messenger.Utilities.tryParseLong;
import static org.telegram.ui.Stars.StarsController.findAttribute;
import static org.telegram.ui.Stories.HighlightMessageSheet.parseTiers;
import static org.telegram.ui.Stories.HighlightMessageSheet.parseTiersString;
import static org.telegram.ui.Stories.HighlightMessageSheet.tiersEqual;
import static org.telegram.ui.Stories.HighlightMessageSheet.tiersToString;

import android.Manifest;
import android.app.Activity;
import android.appwidget.AppWidgetManager;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Paint;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.SystemClock;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.view.Gravity;
import android.widget.FrameLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.graphics.ColorUtils;
import androidx.core.util.Consumer;

import org.telegram.SQLite.SQLiteCursor;
import org.telegram.SQLite.SQLiteDatabase;
import org.telegram.SQLite.SQLiteException;
import org.telegram.SQLite.SQLitePreparedStatement;
import org.telegram.messenger.browser.Browser;
import org.telegram.messenger.support.LongSparseIntArray;
import org.telegram.messenger.support.LongSparseLongArray;
import org.telegram.messenger.voip.GroupCallMessagesController;
import org.telegram.messenger.voip.VoIPDebugToSend;
import org.telegram.messenger.voip.VoIPPreNotificationService;
import org.telegram.messenger.voip.VoIPService;
import org.telegram.tgnet.ConnectionsManager;
import org.telegram.tgnet.NativeByteBuffer;
import org.telegram.tgnet.RequestDelegate;
import org.telegram.tgnet.SerializedData;
import org.telegram.tgnet.TLObject;
import org.telegram.tgnet.TLRPC;
import org.telegram.tgnet.Vector;
import org.telegram.tgnet.tl.TL_account;
import org.telegram.tgnet.tl.TL_bots;
import org.telegram.tgnet.tl.TL_forum;
import org.telegram.tgnet.tl.TL_phone;
import org.telegram.tgnet.tl.TL_stars;
import org.telegram.tgnet.tl.TL_stories;
import org.telegram.tgnet.tl.TL_chatlists;
import org.telegram.ui.ActionBar.ActionBarLayout;
import org.telegram.ui.ActionBar.AlertDialog;
import org.telegram.ui.ActionBar.BaseFragment;
import org.telegram.ui.ActionBar.Theme;
import org.telegram.ui.Business.QuickRepliesController;
import org.telegram.ui.Cells.CheckBoxCell;
import org.telegram.ui.ChatActivity;
import org.telegram.ui.ChatReactionsEditActivity;
import org.telegram.ui.ChatRightsEditActivity;
import org.telegram.ui.Components.AlertsCreator;
import org.telegram.ui.Components.AnimatedEmojiDrawable;
import org.telegram.ui.Components.BulletinFactory;
import org.telegram.ui.Components.ImageUpdater;
import org.telegram.ui.Components.JoinCallAlert;
import org.telegram.ui.Components.LayoutHelper;
import org.telegram.ui.Components.MotionBackgroundDrawable;
import org.telegram.ui.Components.Premium.LimitReachedBottomSheet;
import org.telegram.ui.Components.Reactions.ReactionsLayoutInBubble;
import org.telegram.ui.Components.SwipeGestureSettingsView;
import org.telegram.ui.Components.TranscribeButton;
import org.telegram.ui.DialogsActivity;
import org.telegram.ui.EditWidgetActivity;
import org.telegram.ui.LaunchActivity;
import org.telegram.ui.PremiumPreviewFragment;
import org.telegram.ui.ProfileActivity;
import org.telegram.ui.SecretMediaViewer;
import org.telegram.ui.Stars.BotStarsController;
import org.telegram.ui.Stars.StarsController;
import org.telegram.ui.Stories.StoriesController;
import org.telegram.ui.ThemeActivity;
import org.telegram.ui.TopicsFragment;
import org.telegram.ui.bots.BotWebViewAttachedSheet;
import org.telegram.ui.bots.BotWebViewSheet;
import org.telegram.ui.bots.WebViewRequestProps;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class MessagesController extends BaseController implements NotificationCenter.NotificationCenterDelegate {

    public int lastKnownSessionsCount;
    private final ConcurrentHashMap<Long, TLRPC.Chat> chats = new ConcurrentHashMap<>(100, 1.0f, 2);
    private final ConcurrentHashMap<Integer, TLRPC.EncryptedChat> encryptedChats = new ConcurrentHashMap<>(10, 1.0f, 2);
    private final ConcurrentHashMap<Long, TLRPC.User> users = new ConcurrentHashMap<>(100, 1.0f, 3);
    private final ConcurrentHashMap<String, TLObject> objectsByUsernames = new ConcurrentHashMap<>(100, 1.0f, 2);
    private final ConcurrentHashMap<Long, Long> monoForumLinkedChannels = new ConcurrentHashMap<>(3, 1.0f, 2);
    public static int stableIdPointer = 100;

    private final HashMap<Long, TLRPC.Chat> activeVoiceChatsMap = new HashMap<>();

    private final ArrayList<Long> joiningToChannels = new ArrayList<>();

    private final LongSparseArray<TLRPC.TL_chatInviteExported> exportedChats = new LongSparseArray<>();

    public ArrayList<TLRPC.RecentMeUrl> hintDialogs = new ArrayList<>();
    public final SparseArray<ArrayList<TLRPC.Dialog>> dialogsByFolder = new SparseArray<>();
    protected final ArrayList<TLRPC.Dialog> allDialogs = new ArrayList<>();
    public ArrayList<TLRPC.Dialog> dialogsForward = new ArrayList<>();
    public ArrayList<TLRPC.Dialog> dialogsServerOnly = new ArrayList<>();
    public ArrayList<TLRPC.Dialog> dialogsCanAddUsers = new ArrayList<>();
    public ArrayList<TLRPC.Dialog> dialogsMyChannels = new ArrayList<>();
    public ArrayList<TLRPC.Dialog> dialogsMyGroups = new ArrayList<>();
    public ArrayList<TLRPC.Dialog> dialogsChannelsOnly = new ArrayList<>();
    public ArrayList<TLRPC.Dialog> dialogsUsersOnly = new ArrayList<>();
    public ArrayList<TLRPC.Dialog> dialogsForBlock = new ArrayList<>();
    public ArrayList<TLRPC.Dialog> dialogsGroupsOnly = new ArrayList<>();
    public DialogFilter[] selectedDialogFilter = new DialogFilter[2];
    private int dialogsLoadedTillDate = Integer.MAX_VALUE;
    public int unreadUnmutedDialogs;
    public ConcurrentHashMap<Long, Integer> dialogs_read_inbox_max = new ConcurrentHashMap<>(100, 1.0f, 2);
    public ConcurrentHashMap<Long, Integer> dialogs_read_outbox_max = new ConcurrentHashMap<>(100, 1.0f, 2);
    public LongSparseArray<TLRPC.Dialog> dialogs_dict = new LongSparseArray<>();
    public LongSparseArray<ArrayList<MessageObject>> dialogMessage = new LongSparseArray<>();
    public LongSparseArray<MessageObject> dialogMessagesByRandomIds = new LongSparseArray<>();
    public LongSparseIntArray deletedHistory = new LongSparseIntArray();
    public SparseArray<MessageObject> dialogMessagesByIds = new SparseArray<>();
    public ConcurrentHashMap<Long, ConcurrentHashMap<Integer, ArrayList<PrintingUser>>> printingUsers = new ConcurrentHashMap<>(20, 1.0f, 2);
    public LongSparseArray<LongSparseArray<CharSequence>> printingStrings = new LongSparseArray<>();
    public LongSparseArray<LongSparseArray<Integer>> printingStringsTypes = new LongSparseArray<>();
    public LongSparseArray<LongSparseArray<Boolean>>[] sendingTypings = new LongSparseArray[12];
    public ConcurrentHashMap<Long, Integer> onlinePrivacy = new ConcurrentHashMap<>(20, 1.0f, 2);
    private LongSparseIntArray pendingUnreadCounter = new LongSparseIntArray();
    private int lastPrintingStringCount;
    private SparseArray<ChatlistUpdatesStat> chatlistFoldersUpdates = new SparseArray<>();
    public int largeQueueMaxActiveOperations = 2;
    public int smallQueueMaxActiveOperations = 5;
    public int stealthModeFuture;
    public int stealthModePast;
    public int stealthModeCooldown;
    public StoriesController storiesController;
    public SavedMessagesController savedMessagesController;
    public UnconfirmedAuthController unconfirmedAuthController;
    private boolean hasArchivedChats;
    private boolean hasStories;
    public long storiesChangelogUserId = 777000;
    private ChannelBoostsController channelBoostsControler;
    public long giveawayAddPeersMax = 10;
    public long giveawayPeriodMax = 7;
    public long giveawayCountriesMax = 10;
    public long giveawayBoostsPerPremium = 4;
    public long boostsPerSentGift = 3;

    public static TLRPC.Peer getPeerFromInputPeer(TLRPC.InputPeer peer) {
        if (peer.chat_id != 0) {
            TLRPC.TL_peerChat peerChat = new TLRPC.TL_peerChat();
            peerChat.chat_id = peer.chat_id;
            return peerChat;
        } else if (peer.channel_id != 0) {
            TLRPC.TL_peerChannel peerChannel = new TLRPC.TL_peerChannel();
            peerChannel.channel_id = peer.channel_id;
            return peerChannel;
        } else {
            TLRPC.TL_peerUser peerUser = new TLRPC.TL_peerUser();
            peerUser.user_id = peer.user_id;
            return peerUser;
        }
    }

    public ChannelBoostsController getBoostsController() {
        if (channelBoostsControler != null) {
            return channelBoostsControler;
        }
        synchronized (lockObjects[currentAccount]) {
            if (channelBoostsControler != null) {
                return channelBoostsControler;
            }
            channelBoostsControler = new ChannelBoostsController(currentAccount);
        }
        return channelBoostsControler;
    }

    class ChatlistUpdatesStat {
        public ChatlistUpdatesStat() {
            this.loading = true;
        }
        public ChatlistUpdatesStat(TL_chatlists.TL_chatlists_chatlistUpdates value) {
            this.lastRequestTime = System.currentTimeMillis();
            this.lastValue = value;
        }
        boolean loading = false;
        long lastRequestTime;
        TL_chatlists.TL_chatlists_chatlistUpdates lastValue;
    }

    private boolean dialogsInTransaction;

    private LongSparseArray<Boolean> loadingPeerSettings = new LongSparseArray<>();

    private ArrayList<Long> createdDialogIds = new ArrayList<>();
    private ArrayList<Long> createdScheduledDialogIds = new ArrayList<>();
    private ArrayList<Long> createdDialogMainThreadIds = new ArrayList<>();
    private ArrayList<Long> visibleDialogMainThreadIds = new ArrayList<>();
    private ArrayList<Long> visibleScheduledDialogMainThreadIds = new ArrayList<>();

    private LongSparseIntArray shortPollChannels = new LongSparseIntArray();
    private LongSparseArray<ArrayList<Integer>> needShortPollChannels = new LongSparseArray<>();
    private LongSparseIntArray shortPollOnlines = new LongSparseIntArray();
    private LongSparseArray<ArrayList<Integer>> needShortPollOnlines = new LongSparseArray<>();

    private LongSparseArray<TLRPC.Dialog> deletingDialogs = new LongSparseArray<>();
    private LongSparseArray<TLRPC.Dialog> clearingHistoryDialogs = new LongSparseArray<>();

    public boolean loadingBlockedPeers = false;
    public LongSparseIntArray blockePeers = new LongSparseIntArray();
    public int totalBlockedCount = -1;
    public boolean blockedEndReached;

    private LongSparseArray<ArrayList<Integer>> channelViewsToSend = new LongSparseArray<>();
    private LongSparseArray<SparseArray<MessageObject>> pollsToCheck = new LongSparseArray<>();
    private int pollsToCheckSize;
    private long lastViewsCheckTime;
    public SparseIntArray premiumFeaturesTypesToPosition = new SparseIntArray();
    public SparseIntArray businessFeaturesTypesToPosition = new SparseIntArray();
    
    public ArrayList<DialogFilter> dialogFilters = new ArrayList<>();
    public ArrayList<DialogFilter> frozenDialogFilters = null;
    public ArrayList<Long> hiddenUndoChats = new ArrayList<>();
    public SparseArray<DialogFilter> dialogFiltersById = new SparseArray<>();
    private boolean loadingSuggestedFilters;
    private boolean loadingRemoteFilters;
    public boolean dialogFiltersLoaded;
    public ArrayList<TLRPC.TL_dialogFilterSuggested> suggestedFilters = new ArrayList<>();

    private final LongSparseArray<ArrayList<TLRPC.Updates>> updatesQueueChannels = new LongSparseArray<>();
    private LongSparseLongArray updatesStartWaitTimeChannels = new LongSparseLongArray();
    private LongSparseIntArray channelsPts = new LongSparseIntArray();
    private LongSparseArray<Boolean> gettingDifferenceChannels = new LongSparseArray<>();
    private LongSparseArray<Boolean> gettingChatInviters = new LongSparseArray<>();

    private LongSparseArray<Boolean> gettingUnknownChannels = new LongSparseArray<>();
    private LongSparseArray<Boolean> gettingUnknownDialogs = new LongSparseArray<>();
    private LongSparseArray<Boolean> checkingLastMessagesDialogs = new LongSparseArray<>();

    private ArrayList<TLRPC.Updates> updatesQueueSeq = new ArrayList<>();
    private ArrayList<TLRPC.Updates> updatesQueuePts = new ArrayList<>();
    private ArrayList<TLRPC.Updates> updatesQueueQts = new ArrayList<>();
    private long updatesStartWaitTimeSeq;
    private long updatesStartWaitTimePts;
    private long updatesStartWaitTimeQts;
    private final LongSparseArray<TLRPC.UserFull> fullUsers = new LongSparseArray<>();
    private final LongSparseArray<TLRPC.ChatFull> fullChats = new LongSparseArray<>();
    private final LongSparseArray<ChatObject.Call> groupCalls = new LongSparseArray<>();
    private final LongSparseArray<ChatObject.Call> groupCallsByChatId = new LongSparseArray<>();
    public VoIPDebugToSend voipDebug;
    private final LongSparseArray<TLRPC.PeerSettings> userPeerSettings = new LongSparseArray<>();
    private HashSet<Long> loadingFullUsers = new HashSet<>();
    private LongSparseLongArray loadedFullUsers = new LongSparseLongArray();
    private HashSet<Long> loadingFullChats = new HashSet<>();
    private HashSet<Long> loadingGroupCalls = new HashSet<>();
    private HashSet<Long> loadingFullParticipants = new HashSet<>();
    private HashSet<Long> loadedFullParticipants = new HashSet<>();
    public LongSparseLongArray loadedFullChats = new LongSparseLongArray();
    private LongSparseArray<LongSparseArray<TLRPC.ChannelParticipant>> channelAdmins = new LongSparseArray<>();
    private LongSparseIntArray loadingChannelAdmins = new LongSparseIntArray();

    private SparseIntArray migratedChats = new SparseIntArray();

    private LongSparseArray<SponsoredMessagesInfo> sponsoredMessages = new LongSparseArray<>();
    private LongSparseArray<SendAsPeersInfo> sendAsPeers = new LongSparseArray<>();
    private LongSparseArray<SendAsPeersInfo> sendAsPeersLiveStories = new LongSparseArray<>();

    private HashMap<String, ArrayList<MessageObject>> reloadingWebpages = new HashMap<>();
    private LongSparseArray<ArrayList<MessageObject>> reloadingWebpagesPending = new LongSparseArray<>();
    private HashMap<String, ArrayList<MessageObject>> reloadingScheduledWebpages = new HashMap<>();
    private LongSparseArray<ArrayList<MessageObject>> reloadingScheduledWebpagesPending = new LongSparseArray<>();
    private HashMap<String, ArrayList<MessageObject>> reloadingSavedWebpages = new HashMap<>();
    private LongSparseArray<ArrayList<MessageObject>> reloadingSavedWebpagesPending = new LongSparseArray<>();

    private LongSparseArray<Long> lastScheduledServerQueryTime = new LongSparseArray<>();
    private LongSparseArray<Long> lastQuickReplyServerQueryTime = new LongSparseArray<>();
    private LongSparseArray<Long> lastSavedServerQueryTime = new LongSparseArray<>();
    private LongSparseArray<Long> lastServerQueryTime = new LongSparseArray<>();

    private LongSparseArray<ArrayList<Integer>> reloadingMessages = new LongSparseArray<>();

    private ArrayList<ReadTask> readTasks = new ArrayList<>();
    private LongSparseArray<ReadTask> readTasksMap = new LongSparseArray<>();
    private ArrayList<ReadTask> repliesReadTasks = new ArrayList<>();
    private HashMap<String, ReadTask> threadsReadTasksMap = new HashMap<>();

    private boolean gettingNewDeleteTask;
    private int currentDeletingTaskTime;
    private LongSparseArray<ArrayList<Integer>> currentDeletingTaskMids;
    private LongSparseArray<ArrayList<Integer>> currentDeletingTaskMediaMids;
    private Runnable currentDeleteTaskRunnable;

    public boolean dialogsLoaded;
    private SparseIntArray nextDialogsCacheOffset = new SparseIntArray();
    private SparseBooleanArray loadingDialogs = new SparseBooleanArray();
    private SparseBooleanArray dialogsEndReached = new SparseBooleanArray();
    private SparseBooleanArray serverDialogsEndReached = new SparseBooleanArray();

    private boolean loadingUnreadDialogs;
    private boolean migratingDialogs;
    public boolean gettingDifference;
    private boolean getDifferenceFirstSync = true;
    public boolean updatingState;
    public boolean firstGettingTask;
    public boolean registeringForPush;
    private long lastPushRegisterSendTime;
    private boolean resetingDialogs;
    private TLRPC.TL_messages_peerDialogs resetDialogsPinned;
    private TLRPC.messages_Dialogs resetDialogsAll;
    private SparseIntArray loadingPinnedDialogs = new SparseIntArray();

    public ArrayList<FaqSearchResult> faqSearchArray = new ArrayList<>();
    public TLRPC.WebPage faqWebPage;

    private int loadingNotificationSettings;
    private boolean loadingNotificationSignUpSettings;

    private int nextPromoInfoCheckTime;
    private boolean checkingPromoInfo;
    private int checkingPromoInfoRequestId;
    private int lastCheckPromoId;
    private TLRPC.Dialog promoDialog;
    private boolean isLeftPromoChannel;
    private long promoDialogId;
    public int promoDialogType;
    public String promoPsaMessage;
    public String promoPsaType;
    private String proxyDialogAddress;

    private boolean checkingTosUpdate;
    private int nextTosCheckTime;

    public int secretWebpagePreview;
    public boolean suggestContacts = true;

    private volatile static long lastThemeCheckTime;
    private Runnable themeCheckRunnable = Theme::checkAutoNightThemeConditions;

    private volatile static long lastPasswordCheckTime;
    private Runnable passwordCheckRunnable = () -> getUserConfig().checkSavedPassword();

    private long lastStatusUpdateTime;
    private int statusRequest;
    private int statusSettingState;
    private boolean offlineSent;
    private String uploadingAvatar;

    private HashMap<String, Object> uploadingThemes = new HashMap<>();

    public String uploadingWallpaper;
    public Theme.OverrideWallpaperInfo uploadingWallpaperInfo;

    private UserNameResolver userNameResolver;

    public ArrayList<DialogFilter> getDialogFilters() {
        if (frozenDialogFilters != null) {
            return frozenDialogFilters;
        }
        return dialogFilters;
    }

    private final CacheFetcher<Integer, TLRPC.TL_help_appConfig> appConfigFetcher = new CacheFetcher<Integer, TLRPC.TL_help_appConfig>() {
        @Override
        protected void getRemote(int currentAccount, Integer arguments, long hash, Utilities.Callback4<Boolean, TLRPC.TL_help_appConfig, Long, Boolean> onResult) {
            TLRPC.TL_help_getAppConfig req = new TLRPC.TL_help_getAppConfig();
            req.hash = (int) hash;
            getConnectionsManager().sendRequest(req, (res, err) -> {
                if (res instanceof TLRPC.TL_help_appConfigNotModified) {
                    onResult.run(true, null, 0L, true);
                } else if (res instanceof TLRPC.TL_help_appConfig) {
                    onResult.run(false, (TLRPC.TL_help_appConfig) res, (long) ((TLRPC.TL_help_appConfig) res).hash, true);
                } else {
                    FileLog.e("getting appconfig error " + (err != null ? err.code + " " + err.text : ""));
                    onResult.run(false, null, 0L, err == null || !(err.code == -2000 || err.code == -2001));
                }
            });
        }

        @Override
        protected void getLocal(int currentAccount, Integer arguments, Utilities.Callback2<Long, TLRPC.TL_help_appConfig> onResult) {
            getMessagesStorage().getStorageQueue().postRunnable(() -> {
                SQLiteCursor cursor = null;
                try {
                    SQLiteDatabase database = MessagesStorage.getInstance(currentAccount).getDatabase();
                    if (database != null) {
                        TLRPC.help_AppConfig maybeResult = null;
                        cursor = database.queryFinalized("SELECT data FROM app_config");
                        if (cursor.next()) {
                            NativeByteBuffer data = cursor.byteBufferValue(0);
                            if (data != null) {
                                maybeResult = TLRPC.help_AppConfig.TLdeserialize(data, data.readInt32(false), true);
                                data.reuse();
                            }
                        }

                        if (maybeResult instanceof TLRPC.TL_help_appConfig) {
                            TLRPC.TL_help_appConfig result = (TLRPC.TL_help_appConfig) maybeResult;
                            onResult.run((long) result.hash, result);
                        } else {
                            onResult.run(0L, null);
                        }
                    }
                } catch (Exception e) {
                    FileLog.e(e);
                    onResult.run(0L, null);
                } finally {
                    if (cursor != null) {
                        cursor.dispose();
                    }
                }
            });
        }

        @Override
        protected void setLocal(int currentAccount, Integer arguments, TLRPC.TL_help_appConfig data, long hash) {
            MessagesStorage.getInstance(currentAccount).getStorageQueue().postRunnable(() -> {
                try {
                    SQLiteDatabase database = MessagesStorage.getInstance(currentAccount).getDatabase();
                    if (database != null) {
                        database.executeFast("DELETE FROM app_config").stepThis().dispose();
                        if (data != null) {
                            SQLitePreparedStatement state = database.executeFast("INSERT INTO app_config VALUES(?)");
                            state.requery();
                            NativeByteBuffer buffer = new NativeByteBuffer(data.getObjectSize());
                            data.serializeToStream(buffer);
                            state.bindByteBuffer(1, buffer);
                            state.step();
                            buffer.reuse();
                            state.dispose();
                        }
                    }
                } catch (Exception e) {
                    FileLog.e(e);
                }
            });
        }

        @Override
        protected boolean useCache(Integer arguments) {
            return false;
        }
    };

    public boolean enableJoined;
    public String linkPrefix;
    public int maxGroupCount;
    public int maxBroadcastCount = 100;
    public int maxMegagroupCount;
    public int minGroupConvertSize = 200;
    public int maxEditTime;
    public int ratingDecay;
    public int revokeTimeLimit;
    public int revokeTimePmLimit;
    public boolean canRevokePmInbox;
    public int maxRecentStickersCount;
    public int maxFaveStickersCount;
    public int maxRecentGifsCount;
    public int callReceiveTimeout;
    public int callRingTimeout;
    public int callConnectTimeout;
    public int callPacketTimeout;
    public int maxFolderPinnedDialogsCountDefault;
    public int maxFolderPinnedDialogsCountPremium;
    public int mapProvider;
    public int availableMapProviders;
    public int updateCheckDelay;
    public int chatReadMarkSizeThreshold;
    public int chatReadMarkExpirePeriod;
    public int pmReadDateExpirePeriod;
    public String mapKey;
    public int maxMessageLength;
    public int maxCaptionLength;
    public int roundVideoSize;
    public int roundVideoBitrate;
    public int roundAudioBitrate;
    public boolean blockedCountry;
    public boolean preloadFeaturedStickers;
    public String youtubePipType;
    public boolean keepAliveService;
    public boolean backgroundConnection;
    public float animatedEmojisZoom;
    public boolean filtersEnabled;
    public boolean getfileExperimentalParams;
    public boolean smsjobsStickyNotificationEnabled;
    public boolean collectDeviceStats;
    public boolean showFiltersTooltip;
    public String venueSearchBot;
    public String storyVenueSearchBot;
    public String gifSearchBot;
    public String imageSearchBot;
    public String dcDomainName;
    public int webFileDatacenterId;
    public String suggestedLangCode;
    public boolean qrLoginCamera;
    public boolean saveGifsWithStickers;
    private String installReferer;
    public Set<String> pendingSuggestions;
    public Set<String> dismissedSuggestions;
    public TLRPC.TL_pendingSuggestion customPendingSuggestion;
    public Set<String> exportUri;
    public Set<String> exportGroupUri;
    public Set<String> exportPrivateUri;
    public boolean autoarchiveAvailable;
    public int groupCallVideoMaxParticipants;
    public boolean suggestStickersApiOnly;
    public ArrayList<String> gifSearchEmojies = new ArrayList<>();
    public HashSet<String> diceEmojies;
    public Set<String> autologinDomains;
    public Set<String> authDomains;
    public String autologinToken;
    public HashMap<String, DiceFrameSuccess> diceSuccess = new HashMap<>();
    public HashMap<String, EmojiSound> emojiSounds = new HashMap<>();
    public HashMap<Long, ArrayList<TLRPC.TL_sendMessageEmojiInteraction>> emojiInteractions = new HashMap<>();
    public boolean remoteConfigLoaded;
    public int ringtoneDurationMax;
    public int ringtoneSizeMax;
    public boolean storiesExportNopublicLink;
    public int authorizationAutoconfirmPeriod;
    public int quoteLengthMax;
    public boolean giveawayGiftsPurchaseAvailable;
    public PeerColors peerColors;
    public PeerColors profilePeerColors;
    public int transcribeAudioTrialWeeklyNumber;
    public int transcribeAudioTrialDurationMax;
    public int transcribeAudioTrialCooldownUntil;
    public int transcribeAudioTrialCurrentNumber;
    public int recommendedChannelsLimitDefault;
    public int recommendedChannelsLimitPremium;
    public int boostsChannelLevelMax;
    public int channelRestrictSponsoredLevelMin;
    public int channelAutotranslationLevelMin;
    public Set<String> webAppAllowedProtocols;
    public Set<String> ignoreRestrictionReasons;

    public int channelsLimitDefault;
    public int channelsLimitPremium;
    public int savedGifsLimitDefault;
    public int savedGifsLimitPremium;
    public int stickersFavedLimitDefault;
    public int stickersFavedLimitPremium;
    public int maxPinnedDialogsCountDefault;
    public int maxPinnedDialogsCountPremium;
    public int dialogFiltersLimitDefault;
    public int dialogFiltersLimitPremium;
    public int dialogFiltersChatsLimitDefault;
    public int dialogFiltersChatsLimitPremium;
    public int dialogFiltersPinnedLimitDefault;
    public int dialogFiltersPinnedLimitPremium;
    public int publicLinksLimitDefault;
    public int publicLinksLimitPremium;
    public int captionLengthLimitDefault;
    public int captionLengthLimitPremium;
    public int storyCaptionLengthLimitDefault;
    public int storyCaptionLengthLimitPremium;
    public int aboutLengthLimitDefault;
    public int aboutLengthLimitPremium;
    public int reactionsUserMaxDefault;
    public int reactionsUserMaxPremium;
    public int reactionsInChatMax;
    public int forumUpgradeParticipantsMin;
    public int topicsPinnedLimit;
    public long telegramAntispamUserId;
    public int telegramAntispamGroupSizeMin;
    public int hiddenMembersGroupSizeMin;
    private int chatlistUpdatePeriod;
    public int storyExpiringLimitDefault;
    public int storyExpiringLimitPremium;
    public int storiesSentWeeklyLimitDefault;
    public int storiesSentWeeklyLimitPremium;
    public int storiesSentMonthlyLimitDefault;
    public int storiesSentMonthlyLimitPremium;
    public int storiesSuggestedReactionsLimitDefault;
    public int storiesSuggestedReactionsLimitPremium;
    public int channelBgIconLevelMin;
    public int channelProfileIconLevelMin;
    public int channelEmojiStatusLevelMin;
    public int channelWallpaperLevelMin;
    public int channelCustomWallpaperLevelMin;
    public int groupProfileBgIconLevelMin;
    public int groupEmojiStatusLevelMin;
    public int groupEmojiStickersLevelMin;
    public int groupWallpaperLevelMin;
    public int groupCustomWallpaperLevelMin;
    public int groupTranscribeLevelMin;
    public int quickRepliesLimit;
    public int quickReplyMessagesLimit;
    public float uploadPremiumSpeedupUpload;
    public float uploadPremiumSpeedupDownload;
    public int uploadPremiumSpeedupNotifyPeriod;
    public int introTitleLengthLimit;
    public int introDescriptionLengthLimit;
    public int businessChatLinksLimit;
    public boolean channelRevenueWithdrawalEnabled;
    public boolean newNoncontactPeersRequirePremiumWithoutOwnpremium;
    public int reactionsUniqMax;
    public String premiumManageSubscriptionUrl;
    public boolean androidDisableRoundCamera2;
    public int storiesPinnedToTopCountMax;
    public boolean showAnnualPerMonth = false;
    public boolean canEditFactcheck;
    public int factcheckLengthLimit;
    public long starsRevenueWithdrawalMin;
    public long starsPaidPostAmountMax;
    public int botPreviewMediasMax;
    public String tonProxyAddress;
    public String weatherSearchUsername;
    public boolean storyWeatherPreload;
    public boolean starsGiftsEnabled;
    public boolean stargiftsBlocked;
    public long starsPaidReactionAmountMax;
    public long starsSubscriptionAmountMax;
    public float starsUsdSellRate1000;
    public float starsUsdWithdrawRate1000;
    public boolean sponsoredLinksInappAllow;
    public Set<String> starrefStartParamPrefixes = new HashSet<>();
    public boolean starrefProgramAllowed;
    public boolean starrefConnectAllowed;
    public int starrefMinCommissionPermille;
    public int starrefMaxCommissionPermille;
    public int botVerificationDescriptionLengthLimit;
    public long paidReactionsPrivacyTime;
    public Long paidReactionsPrivacy;
    public int savedDialogsPinnedLimitDefault;
    public int savedDialogsPinnedLimitPremium;
    public boolean savedViewAsChats;
    public boolean storyQualityFull;
    public int uploadMaxFileParts;
    public int uploadMaxFilePartsPremium;
    public String premiumBotUsername;
    public String premiumInvoiceSlug;
    public String verifyAgeBotUsername;
    public String verifyAgeCountry;
    public int verifyAgeMin;

    private final SharedPreferences notificationsPreferences;
    private final SharedPreferences mainPreferences;
    private final SharedPreferences emojiPreferences;

    public volatile boolean ignoreSetOnline;
    public boolean premiumLocked;
    public int transcribeButtonPressed;
    public boolean starsLocked;

    public boolean starsPurchaseAvailable() {
        return !starsLocked;
    }
    public boolean premiumFeaturesBlocked() {
        return premiumLocked && !getUserConfig().isPremium();
    }
    public boolean premiumPurchaseBlocked() {
        return premiumLocked;
    }

    public List<String> directPaymentsCurrency = new ArrayList<>();

    public NewMessageCallback newMessageCallback;

    private long recentEmojiStatusUpdateRunnableTimeout, recentEmojiStatusUpdateRunnableTime;
    private Runnable recentEmojiStatusUpdateRunnable;
    private final ConcurrentHashMap<Long, Integer> emojiStatusUntilValues = new ConcurrentHashMap<Long, Integer>();
    private TopicsController topicsController;
    private CacheByChatsController cacheByChatsController;
    private TranslateController translateController;
    public boolean uploadMarkupVideo;
    public boolean giftAttachMenuIcon;
    public boolean giftTextFieldIcon;

    public int chatlistInvitesLimitDefault;
    public int chatlistInvitesLimitPremium;
    public int chatlistJoinedLimitDefault;
    public int chatlistJoinedLimitPremium;
    public String storiesPosting;
    public String storiesEntities;
    public int stargiftsMessageLengthMax;
    public int stargiftsConvertPeriodMax;
    public boolean videoIgnoreAltDocuments;
    public boolean disableBotFullscreenBlur;
    public String tonBlockchainExplorerUrl;
    public long starsPaidMessageAmountMax;
    public int starsPaidMessageCommissionPermille;
    public int stargiftsPinnedToTopLimit;
    public boolean starsPaidMessagesAvailable;
    public long freezeSinceDate;
    public long freezeUntilDate;
    public String freezeAppealUrl;
    public int conferenceCallSizeLimit;
    public boolean callRequestsDisabled;
    public int pollAnswersMax;
    public int todoItemsMax;
    public int todoTitleLengthMax;
    public int todoItemLengthMax;
    public String translationsManualEnabled; // "enabled", "alternative", "system", "disabled"
    public String translationsAutoEnabled; // "enabled", "alternative", "system", "disabled"
    public HashSet<Long> whitelistedBots;
    public int[] starsGroupcallMessageLimits;
    public int starsGroupcallMessageAmountMax;

    public boolean isTranslationsManualEnabled() {
        return !"disabled".equals(translationsManualEnabled);
    }
    public boolean isTranslationsAutoEnabled() {
        return !"disabled".equals(translationsAutoEnabled);
    }

    public final AppGlobalConfig config = new AppGlobalConfig();

    public boolean enableGiftsInProfile;

    public int checkResetLangpack;
    public boolean folderTags;

    public void getNextReactionMention(long dialogId, long topicId, int count, Consumer<Integer> callback) {
        final MessagesStorage messagesStorage = getMessagesStorage();
        messagesStorage.getStorageQueue().postRunnable(() -> {
            boolean needRequest = true;
            try {
                SQLiteCursor cursor;
                if (topicId != 0) {
                    cursor = getMessagesStorage().getDatabase().queryFinalized(String.format(Locale.US, "SELECT message_id FROM reaction_mentions_topics WHERE state = 1 AND dialog_id = %d AND topic_id = %d LIMIT 1", dialogId, topicId));
                } else {
                    cursor = getMessagesStorage().getDatabase().queryFinalized(String.format(Locale.US, "SELECT message_id FROM reaction_mentions WHERE state = 1 AND dialog_id = %d LIMIT 1", dialogId));
                }
                int messageId = 0;
                if (cursor.next()) {
                    messageId = cursor.intValue(0);
                    needRequest = false;
                }
                cursor.dispose();
                if (messageId != 0) {
                    getMessagesStorage().markMessageReactionsAsRead(dialogId, topicId, messageId, false);
                    int finalMessageId = messageId;
                    AndroidUtilities.runOnUIThread(() -> callback.accept(finalMessageId));
                }

            } catch (SQLiteException e) {
                e.printStackTrace();
            }
            if (needRequest) {
                TLRPC.TL_messages_getUnreadReactions req = new TLRPC.TL_messages_getUnreadReactions();
                req.peer = getMessagesController().getInputPeer(dialogId);
                req.limit = 1;
                req.add_offset = count - 1;
                if (isMonoForum(dialogId) && topicId != 0) {
                    req.saved_peer_id = getInputPeer(topicId);
                    req.flags |= 2;
                }
                getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> {
                    TLRPC.messages_Messages res = (TLRPC.messages_Messages) response;
                    int messageId = 0;
                    if (error != null && res != null && res.messages != null && !res.messages.isEmpty()) {
                        messageId = res.messages.get(0).id;
                    }
                    int finalMessageId = messageId;
                    AndroidUtilities.runOnUIThread(() -> callback.accept(finalMessageId));
                }));
            }
        });
    }

    public void updatePremium(boolean premium) {
        if (dialogFilters.isEmpty()) {
            return;
        }
        if (!premium) {
            if (!dialogFilters.get(0).isDefault()) {
                for (int i = 1; i < dialogFilters.size(); i++) {
                    if (dialogFilters.get(i).isDefault()) {
                        DialogFilter defaultFilter = dialogFilters.remove(i);
                        dialogFilters.add(0, defaultFilter);
                        break;
                    }
                }
            }
            lockFiltersInternal();
        } else {
            for (int i = 0; i < dialogFilters.size(); i++) {
                dialogFilters.get(i).locked = false;
            }
        }

        getMessagesStorage().saveDialogFiltersOrder();
        getNotificationCenter().postNotificationName(NotificationCenter.dialogFiltersUpdated);
        getStoriesController().onPremiumChanged();
    }

    public void lockFiltersInternal() {
        boolean changed = false;
        if (!getUserConfig().isPremium() && dialogFilters.size() - 1 > dialogFiltersLimitDefault) {
            int n = dialogFilters.size() - 1 - dialogFiltersLimitDefault;
            ArrayList<DialogFilter> filtersSortedById = new ArrayList<>(dialogFilters);
            Collections.reverse(filtersSortedById);
            for (int i = 0; i < filtersSortedById.size(); i++) {
                if (i < n) {
                    if (!filtersSortedById.get(i).locked) {
                        changed = true;
                    }
                    filtersSortedById.get(i).locked = true;
                } else {
                    if (filtersSortedById.get(i).locked) {
                        changed = true;
                    }
                    filtersSortedById.get(i).locked = false;
                }
            }
        }
        if (changed) {
            getNotificationCenter().postNotificationName(NotificationCenter.dialogFiltersUpdated);
        }
    }

    public int getCaptionMaxLengthLimit() {
        return getUserConfig().isPremium() ? captionLengthLimitPremium : captionLengthLimitDefault;
    }

    public int getAboutLimit() {
        return getUserConfig().isPremium() ? aboutLengthLimitPremium : aboutLengthLimitDefault;
    }

    public int getMaxUserReactionsCount() {
        return getUserConfig().isPremium() ? reactionsUserMaxPremium : reactionsUserMaxDefault;
    }

    public int getChatReactionsCount() {
        return getUserConfig().isPremium() ? reactionsInChatMax : 1;
    }

    public int getChatMaxUniqReactions(long dialogId) {
        TLRPC.ChatFull chatFull = MessagesController.getInstance(currentAccount).getChatFull(-dialogId);
        if (chatFull != null && (chatFull instanceof TLRPC.TL_chatFull ? (chatFull.flags & 1048576) != 0 : (chatFull.flags2 & 8192) != 0)) {
            return chatFull.reactions_limit;
        }
        return reactionsUniqMax;
    }

    public boolean isPremiumUser(TLRPC.User currentUser) {
        return !premiumFeaturesBlocked() && currentUser.premium && !isSupportUser(currentUser);
    }

    public boolean didPressTranscribeButtonEnough() {
        return transcribeButtonPressed >= 2;
    }

    public void pressTranscribeButton() {
        if (transcribeButtonPressed < 2) {
            transcribeButtonPressed++;
            if (mainPreferences != null) {
                mainPreferences.edit().putInt("transcribeButtonPressed", transcribeButtonPressed).apply();
            }
        }
    }

    public void putLastGiftAuctionUpdate() {
        if (mainPreferences != null) {
            mainPreferences.edit().putLong("lastGiftAuctionTimeUpdate", System.currentTimeMillis()).apply();
        }
    }

    public boolean giftAuctionUpdateWasRecently() {
        final long t = mainPreferences != null ? mainPreferences.getLong("lastGiftAuctionTimeUpdate", 0) : 0;
        return System.currentTimeMillis() - t < 86400 * 1000;
    }


    public ArrayList<TLRPC.TL_messages_stickerSet> filterPremiumStickers(ArrayList<TLRPC.TL_messages_stickerSet> stickerSets) {
        if (!premiumFeaturesBlocked()) {
            return stickerSets;
        }
        for (int i = 0; i < stickerSets.size(); i++) {
            TLRPC.TL_messages_stickerSet newSet = MessagesController.getInstance(currentAccount).filterPremiumStickers(stickerSets.get(i));
            if (newSet == null) {
                stickerSets.remove(i);
                i--;
            } else {
                stickerSets.set(i, newSet);
            }
        }
        return stickerSets;
    }

    public TLRPC.TL_messages_stickerSet filterPremiumStickers(TLRPC.TL_messages_stickerSet stickerSet) {
        if (!premiumFeaturesBlocked() || stickerSet == null) {
            return stickerSet;
        }
        try {

            boolean hasPremiumSticker = false;
            for (int i = 0; i < stickerSet.documents.size(); i++) {
                if (MessageObject.isPremiumSticker(stickerSet.documents.get(i))) {
                    hasPremiumSticker = true;
                    break;
                }
            }
            if (hasPremiumSticker) {
                NativeByteBuffer nativeByteBuffer = new NativeByteBuffer(stickerSet.getObjectSize());
                stickerSet.serializeToStream(nativeByteBuffer);
                nativeByteBuffer.position(0);
                TLRPC.TL_messages_stickerSet newStickersSet = new TLRPC.TL_messages_stickerSet();
                nativeByteBuffer.readInt32(true);
                newStickersSet.readParams(nativeByteBuffer, true);
                nativeByteBuffer.reuse();
                stickerSet = newStickersSet;

                for (int i = 0; i < stickerSet.documents.size(); i++) {
                    if (MessageObject.isPremiumSticker(stickerSet.documents.get(i))) {
                        stickerSet.documents.remove(i);
                        stickerSet.packs.remove(i);
                        i--;
                        if (stickerSet.documents.isEmpty()) {
                            return null;
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return stickerSet;
    }

    public TopicsController getTopicsController() {
        return topicsController;
    }

    public TranslateController getTranslateController() {
        return translateController;
    }

    public boolean isForum(long dialogId) {
        if (dialogId < 0) {
            TLRPC.Chat chatLocal = getChat(-dialogId);
            return chatLocal != null && chatLocal.forum;
        } else {
            TLRPC.User userLocal = getUser(dialogId);
            return UserObject.isBotForum(userLocal);
        }
    }

    public boolean isMonoForum(long dialogId) {
        TLRPC.Chat chatLocal = getChat(-dialogId);
        return chatLocal != null && chatLocal.monoforum;
    }

    public boolean isMonoForumWithManageRights(long dialogId) {
        TLRPC.Chat chatLocal = getChat(-dialogId);
        return ChatObject.isMonoForum(chatLocal) && ChatObject.canManageMonoForum(currentAccount, chatLocal);
    }

    public boolean isForum(MessageObject msg) {
        return msg != null && isForum(msg.getDialogId());
    }

    public boolean isForum(TLRPC.Message msg) {
        return msg != null && isForum(MessageObject.getDialogId(msg));
    }

    public void markAllTopicsAsRead(long did) {
        getMessagesStorage().loadTopics(did, topics -> {
            AndroidUtilities.runOnUIThread(() -> {
                if (topics != null) {
                    for (int i = 0; i < topics.size(); i++) {
                        TLRPC.TL_forumTopic topic = topics.get(i);
                        getMessagesController().markDialogAsRead(did, topic.top_message, 0, topic.topMessage != null ? topic.topMessage.date : 0, false, isMonoForum(did) ? DialogObject.getPeerDialogId(topic.from_id) : topic.id, 0, true, 0);
                        getMessagesStorage().updateRepliesMaxReadId(-did, isMonoForum(did) ? DialogObject.getPeerDialogId(topic.from_id) : topic.id, topic.top_message, 0, true);
                    }
                }
                getMessagesStorage().getStorageQueue().postRunnable(() -> {
                    getMessagesStorage().resetAllUnreadCounters(false);
                    AndroidUtilities.runOnUIThread(() -> {
                        getMessagesController().sortDialogs(null);
                        getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload, true);
                    });
                });
            });
        });
    }

    public SparseArray<ImageUpdater> photoSuggestion = new SparseArray<>();

    public String getFullName(long dialogId) {
        if (dialogId > 0) {
           TLRPC.User user = getUser(dialogId);
           if (user != null) {
               return ContactsController.formatName(user.first_name, user.last_name);
           }
        } else {
            TLRPC.Chat chat = getChat(-dialogId);
            if (chat != null) {
                return chat.title;
            }
        }
        return null;
    }

    public UserNameResolver getUserNameResolver() {
        if (userNameResolver == null) {
            userNameResolver = new UserNameResolver(currentAccount);
        }
        return userNameResolver;
    }

    public class SponsoredMessagesInfo {
        public ArrayList<MessageObject> messages;
        public Integer posts_between;
        public long loadTime;
        public boolean loading;
    }

    private class SendAsPeersInfo {
        private TLRPC.TL_channels_sendAsPeers sendAsPeers;
        private long loadTime;
        private boolean loading;
    }

    public static class FaqSearchResult {

        public String title;
        public String[] path;
        public String url;
        public int num;

        public FaqSearchResult(String t, String[] p, String u) {
            title = t;
            path = p;
            url = u;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof FaqSearchResult)) {
                return false;
            }
            FaqSearchResult result = (FaqSearchResult) obj;
            return title.equals(result.title);
        }

        @Override
        public String toString() {
            SerializedData data = new SerializedData();
            data.writeInt32(num);
            data.writeInt32(0);
            data.writeString(title);
            data.writeInt32(path != null ? path.length : 0);
            if (path != null) {
                for (int a = 0; a < path.length; a++) {
                    data.writeString(path[a]);
                }
            }
            data.writeString(url);
            return Utilities.bytesToHex(data.toByteArray());
        }
    }

    public static class EmojiSound {
        public long id;
        public long accessHash;
        public byte[] fileReference;

        public EmojiSound(long i, long ah, String fr) {
            id = i;
            accessHash = ah;
            fileReference = Base64.decode(fr, Base64.URL_SAFE);
        }

        public EmojiSound(long i, long ah, byte[] fr) {
            id = i;
            accessHash = ah;
            fileReference = fr;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof EmojiSound)) {
                return false;
            }
            EmojiSound emojiSound = (EmojiSound) obj;
            return id == emojiSound.id && accessHash == emojiSound.accessHash && Arrays.equals(fileReference, emojiSound.fileReference);
        }
    }

    public void clearQueryTime() {
        lastServerQueryTime.clear();
        lastScheduledServerQueryTime.clear();
        lastQuickReplyServerQueryTime.clear();
        lastSavedServerQueryTime.clear();
    }

    public static class DiceFrameSuccess {
        public int frame;
        public int num;

        public DiceFrameSuccess(int f, int n) {
            frame = f;
            num = n;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof DiceFrameSuccess)) {
                return false;
            }
            DiceFrameSuccess frameSuccess = (DiceFrameSuccess) obj;
            return frame == frameSuccess.frame && num == frameSuccess.num;
        }
    }

    private static class UserActionUpdatesSeq extends TLRPC.Updates {

    }

    private static class UserActionUpdatesPts extends TLRPC.Updates {

    }

    public static int UPDATE_MASK_NAME = 1;
    public static int UPDATE_MASK_AVATAR = 2;
    public static int UPDATE_MASK_STATUS = 4;
    public static int UPDATE_MASK_CHAT_AVATAR = 8;
    public static int UPDATE_MASK_CHAT_NAME = 16;
    public static int UPDATE_MASK_CHAT_MEMBERS = 32;
    public static int UPDATE_MASK_USER_PRINT = 64;
    public static int UPDATE_MASK_USER_PHONE = 128;
    public static int UPDATE_MASK_READ_DIALOG_MESSAGE = 256;
    public static int UPDATE_MASK_SELECT_DIALOG = 512;
    public static int UPDATE_MASK_PHONE = 1024;
    public static int UPDATE_MASK_NEW_MESSAGE = 2048;
    public static int UPDATE_MASK_SEND_STATE = 4096;
    public static int UPDATE_MASK_CHAT = 8192;
    //public static int UPDATE_MASK_CHAT_ADMINS = 16384;
    public static int UPDATE_MASK_MESSAGE_TEXT = 32768;
    public static int UPDATE_MASK_CHECK = 65536;
    public static int UPDATE_MASK_REORDER = 131072;
    public static int UPDATE_MASK_EMOJI_INTERACTIONS = 262144;
    public static int UPDATE_MASK_EMOJI_STATUS = 524288;
    public static int UPDATE_MASK_REACTIONS_READ = 1048576;
    public static int UPDATE_MASK_ALL = UPDATE_MASK_AVATAR | UPDATE_MASK_STATUS | UPDATE_MASK_NAME | UPDATE_MASK_CHAT_AVATAR | UPDATE_MASK_CHAT_NAME | UPDATE_MASK_CHAT_MEMBERS | UPDATE_MASK_USER_PRINT | UPDATE_MASK_USER_PHONE | UPDATE_MASK_READ_DIALOG_MESSAGE | UPDATE_MASK_PHONE | UPDATE_MASK_REACTIONS_READ;

    public static int PROMO_TYPE_PROXY = 0;
    public static int PROMO_TYPE_PSA = 1;
    public static int PROMO_TYPE_OTHER = 2;

    private static class ReadTask {
        public long dialogId;
        public long replyId;
        public long monoForumPeerId;
        public int maxId;
        public int maxDate;
        public long sendRequestTime;
    }

    public static class PrintingUser {
        public long lastTime;
        public long userId;
        public TLRPC.SendMessageAction action;
    }

    public static int DIALOG_FILTER_FLAG_CONTACTS = 0x00000001;
    public static int DIALOG_FILTER_FLAG_NON_CONTACTS = 0x00000002;
    public static int DIALOG_FILTER_FLAG_GROUPS = 0x00000004;
    public static int DIALOG_FILTER_FLAG_CHANNELS = 0x00000008;
    public static int DIALOG_FILTER_FLAG_BOTS = 0x00000010;
    public static int DIALOG_FILTER_FLAG_EXCLUDE_MUTED = 0x00000020;
    public static int DIALOG_FILTER_FLAG_EXCLUDE_READ = 0x00000040;
    public static int DIALOG_FILTER_FLAG_EXCLUDE_ARCHIVED = 0x00000080;
    public static int DIALOG_FILTER_FLAG_ONLY_ARCHIVED = 0x00000100;
    public static int DIALOG_FILTER_FLAG_ALL_CHATS = DIALOG_FILTER_FLAG_CONTACTS | DIALOG_FILTER_FLAG_NON_CONTACTS | DIALOG_FILTER_FLAG_GROUPS | DIALOG_FILTER_FLAG_CHANNELS | DIALOG_FILTER_FLAG_BOTS;

    public static int DIALOG_FILTER_FLAG_CHATLIST = 0x00000200;
    public static int DIALOG_FILTER_FLAG_CHATLIST_ADMIN = 0x00000400;

    public static class DialogFilter {
        public int id;
        public String name;
        public ArrayList<TLRPC.MessageEntity> entities = new ArrayList<>();
        public int unreadCount;
        public volatile int pendingUnreadCount;
        public int order;
        public int flags;
        public ArrayList<Long> alwaysShow = new ArrayList<>();
        public ArrayList<Long> neverShow = new ArrayList<>();
        public LongSparseIntArray pinnedDialogs = new LongSparseIntArray();
        public ArrayList<TLRPC.Dialog> dialogs = new ArrayList<>();
        public ArrayList<TLRPC.Dialog> dialogsForward = new ArrayList<>();
        public int color;
        public boolean title_noanimate;

        public ArrayList<TL_chatlists.TL_exportedChatlistInvite> invites = null;

        private static int dialogFilterPointer = 10;
        public int localId = dialogFilterPointer++;
        public boolean locked;

        public boolean includesDialog(AccountInstance accountInstance, long dialogId) {
            MessagesController messagesController = accountInstance.getMessagesController();
            TLRPC.Dialog dialog = messagesController.dialogs_dict.get(dialogId);
            if (dialog == null) {
                return false;
            }
            return includesDialog(accountInstance, dialogId, dialog);
        }

        public boolean includesDialog(AccountInstance accountInstance, long dialogId, TLRPC.Dialog d) {
            if (neverShow.contains(dialogId)) {
                return false;
            }
            if (alwaysShow.contains(dialogId)) {
                return true;
            }
            if (d.folder_id != 0 && (flags & DIALOG_FILTER_FLAG_EXCLUDE_ARCHIVED) != 0) {
                return false;
            }
            MessagesController messagesController = accountInstance.getMessagesController();
            ContactsController contactsController = accountInstance.getContactsController();
            boolean skip = false;

            if ((flags & DIALOG_FILTER_FLAG_EXCLUDE_MUTED) != 0 && messagesController.isDialogMuted(d.id, 0) && d.unread_mentions_count == 0 ||
                    (flags & DIALOG_FILTER_FLAG_EXCLUDE_READ) != 0 && messagesController.getDialogUnreadCount(d) == 0 && !d.unread_mark && d.unread_mentions_count == 0) {
                return false;
            }
            if (dialogId > 0) {
                TLRPC.User user = messagesController.getUser(dialogId);
                if (user != null) {
                    if (!user.bot) {
                        if (user.self || user.contact || contactsController.isContact(dialogId)) {
                            if ((flags & DIALOG_FILTER_FLAG_CONTACTS) != 0) {
                                return true;
                            }
                        } else {
                            if ((flags & DIALOG_FILTER_FLAG_NON_CONTACTS) != 0) {
                                return true;
                            }
                        }
                    } else {
                        if ((flags & DIALOG_FILTER_FLAG_BOTS) != 0) {
                            return true;
                        }
                    }
                }
            } else if (dialogId < 0) {
                TLRPC.Chat chat = messagesController.getChat(-dialogId);
                if (chat != null) {
                    if (ChatObject.isChannel(chat) && !chat.megagroup) {
                        if ((flags & DIALOG_FILTER_FLAG_CHANNELS) != 0) {
                            return true;
                        }
                    } else {
                        if ((flags & DIALOG_FILTER_FLAG_GROUPS) != 0) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        public boolean alwaysShow(int currentAccount, TLRPC.Dialog dialog) {
            if (dialog == null) {
                return false;
            }

            long dialogId = dialog.id;

            if (DialogObject.isEncryptedDialog(dialog.id)) {
                TLRPC.EncryptedChat encryptedChat = MessagesController.getInstance(currentAccount).getEncryptedChat(DialogObject.getEncryptedChatId(dialogId));
                if (encryptedChat != null) {
                    dialogId = encryptedChat.user_id;
                }
            }

            return alwaysShow.contains(dialogId);
        }

        public boolean isDefault() {
            return id == 0;
        }

        public boolean isChatlist() {
            return (flags & DIALOG_FILTER_FLAG_CHATLIST) > 0;
        }

        public boolean isMyChatlist() {
            return isChatlist() && (flags & DIALOG_FILTER_FLAG_CHATLIST_ADMIN) > 0;
        }
    }

    private DialogFilter sortingDialogFilter;
    private final Comparator<TLRPC.Dialog> dialogDateComparator = (dialog1, dialog2) -> {
        int pinnedNum1 = sortingDialogFilter == null ? Integer.MIN_VALUE : sortingDialogFilter.pinnedDialogs.get(dialog1.id, Integer.MIN_VALUE);
        int pinnedNum2 = sortingDialogFilter == null ? Integer.MIN_VALUE : sortingDialogFilter.pinnedDialogs.get(dialog2.id, Integer.MIN_VALUE);
        if (dialog1 instanceof TLRPC.TL_dialogFolder && !(dialog2 instanceof TLRPC.TL_dialogFolder)) {
            return -1;
        } else if (!(dialog1 instanceof TLRPC.TL_dialogFolder) && dialog2 instanceof TLRPC.TL_dialogFolder) {
            return 1;
        } else if (pinnedNum1 == Integer.MIN_VALUE && pinnedNum2 != Integer.MIN_VALUE) {
            return 1;
        } else if (pinnedNum1 != Integer.MIN_VALUE && pinnedNum2 == Integer.MIN_VALUE) {
            return -1;
        } else if (pinnedNum1 != Integer.MIN_VALUE) {
            if (pinnedNum1 > pinnedNum2) {
                return 1;
            } else if (pinnedNum1 < pinnedNum2) {
                return -1;
            } else {
                return 0;
            }
        }
        MediaDataController mediaDataController = getMediaDataController();
        long date1 = DialogObject.getLastMessageOrDraftDate(dialog1, mediaDataController.getDraft(dialog1.id, 0));
        long date2 = DialogObject.getLastMessageOrDraftDate(dialog2, mediaDataController.getDraft(dialog2.id, 0));

        if (date1 < date2) {
            return 1;
        } else if (date1 > date2) {
            return -1;
        }
        return 0;
    };

    public void sortDialogsList(ArrayList<TLRPC.Dialog> dialogs) {
        if (dialogs == null) {
            return;
        }
        Collections.sort(dialogs, dialogComparator);
    }

    private Comparator<TLRPC.Dialog> dialogComparator = (dialog1, dialog2) -> {
        boolean unmutedPrimary = getGlobalMainSettings().getBoolean("unmutedOnTop", false);

        if (dialog1 instanceof TLRPC.TL_dialogFolder && !(dialog2 instanceof TLRPC.TL_dialogFolder)) {
            return -1;
        } else if (!(dialog1 instanceof TLRPC.TL_dialogFolder) && dialog2 instanceof TLRPC.TL_dialogFolder) {
            return 1;
        } else if (!dialog1.pinned && dialog2.pinned) {
            return 1;
        } else if (dialog1.pinned && !dialog2.pinned) {
            return -1;
        } else if (dialog1.pinned) {
            if (dialog1.pinnedNum < dialog2.pinnedNum) {
                return 1;
            } else if (dialog1.pinnedNum > dialog2.pinnedNum) {
                return -1;
            } else {
                return 0;
            }
        }
        MediaDataController mediaDataController = getMediaDataController();
        long date1 = DialogObject.getLastMessageOrDraftDate(dialog1, mediaDataController.getDraft(dialog1.id, 0));
        long date2 = DialogObject.getLastMessageOrDraftDate(dialog2, mediaDataController.getDraft(dialog2.id, 0));

        if (unmutedPrimary) {
            final boolean mute1 = isDialogMuted(dialog1.id, 0);
            final boolean mute2 = isDialogMuted(dialog2.id, 0);
            final boolean unread1 = dialog1.unread_count > 0;
            final boolean unread2 = dialog2.unread_count > 0;

            final boolean newMention1 = unread1 && !mute1;
            final boolean newMention2 = unread2 && !mute2;

            if (!newMention1 && newMention2) {
                return 1;
            } else if (newMention1 && !newMention2) {
                return -1;
            } else if (newMention1 && newMention2) {
                if (date1 < date2) {
                    return 1;
                } else if (date1 > date2) {
                    return -1;
                } else {
                    return 0;
                }
            }
        }

        if (date1 < date2) {
            return 1;
        } else if (date1 > date2) {
            return -1;
        }
        return 0;
    };

    private Comparator<TLRPC.Update> updatesComparator = (lhs, rhs) -> {
        int ltype = getUpdateType(lhs);
        int rtype = getUpdateType(rhs);
        if (ltype != rtype) {
            return AndroidUtilities.compare(ltype, rtype);
        } else if (ltype == 0) {
            return AndroidUtilities.compare(getUpdatePts(lhs), getUpdatePts(rhs));
        } else if (ltype == 1) {
            return AndroidUtilities.compare(getUpdateQts(lhs), getUpdateQts(rhs));
        } else if (ltype == 2) {
            long lChannel = getUpdateChannelId(lhs);
            long rChannel = getUpdateChannelId(rhs);
            if (lChannel == rChannel) {
                return AndroidUtilities.compare(getUpdatePts(lhs), getUpdatePts(rhs));
            } else {
                return AndroidUtilities.compare(lChannel, rChannel);
            }
        }
        return 0;
    };

    private static volatile MessagesController[] Instance = new MessagesController[UserConfig.MAX_ACCOUNT_COUNT];
    private static final Object[] lockObjects = new Object[UserConfig.MAX_ACCOUNT_COUNT];
    static {
        for (int i = 0; i < UserConfig.MAX_ACCOUNT_COUNT; i++) {
            lockObjects[i] = new Object();
        }
    }

    public static MessagesController getInstance(int num) {
        MessagesController localInstance = Instance[num];
        if (localInstance == null) {
            synchronized (lockObjects[num]) {
                localInstance = Instance[num];
                if (localInstance == null) {
                    Instance[num] = localInstance = new MessagesController(num);
                }
            }
        }
        return localInstance;
    }

    public SharedPreferences getMainSettings() {
        return mainPreferences;
    }

    public static SharedPreferences getNotificationsSettings(int account) {
        return getInstance(account).notificationsPreferences;
    }

    public static SharedPreferences getGlobalNotificationsSettings() {
        return getInstance(0).notificationsPreferences;
    }

    public static SharedPreferences getMainSettings(int account) {
        return getInstance(account).mainPreferences;
    }

    public static SharedPreferences getGlobalMainSettings() {
        return getInstance(0).mainPreferences;
    }

    public static SharedPreferences getEmojiSettings(int account) {
        return getInstance(account).emojiPreferences;
    }

    public static SharedPreferences getGlobalEmojiSettings() {
        return getInstance(0).emojiPreferences;
    }

    public MessagesController(int num) {
        super(num);
        ImageLoader.getInstance();
        getMessagesStorage();
        getLocationController();
        AndroidUtilities.runOnUIThread(() -> {
            MessagesController messagesController = getMessagesController();
            getNotificationCenter().addObserver(messagesController, NotificationCenter.fileUploaded);
            getNotificationCenter().addObserver(messagesController, NotificationCenter.fileUploadFailed);
            getNotificationCenter().addObserver(messagesController, NotificationCenter.fileUploadProgressChanged);
            getNotificationCenter().addObserver(messagesController, NotificationCenter.fileLoaded);
            getNotificationCenter().addObserver(messagesController, NotificationCenter.fileLoadFailed);
            getNotificationCenter().addObserver(messagesController, NotificationCenter.messageReceivedByServer);
            getNotificationCenter().addObserver(messagesController, NotificationCenter.updateMessageMedia);
        });
        addSupportUser();
        if (currentAccount == 0) {
            notificationsPreferences = ApplicationLoader.applicationContext.getSharedPreferences("Notifications", Activity.MODE_PRIVATE);
            mainPreferences = ApplicationLoader.applicationContext.getSharedPreferences("mainconfig", Activity.MODE_PRIVATE);
            emojiPreferences = ApplicationLoader.applicationContext.getSharedPreferences("emoji", Activity.MODE_PRIVATE);
        } else {
            notificationsPreferences = ApplicationLoader.applicationContext.getSharedPreferences("Notifications" + currentAccount, Activity.MODE_PRIVATE);
            mainPreferences = ApplicationLoader.applicationContext.getSharedPreferences("mainconfig" + currentAccount, Activity.MODE_PRIVATE);
            emojiPreferences = ApplicationLoader.applicationContext.getSharedPreferences("emoji" + currentAccount, Activity.MODE_PRIVATE);
        }
        long time = System.currentTimeMillis();

        remoteConfigLoaded = mainPreferences.getBoolean("remoteConfigLoaded", false);
        secretWebpagePreview = mainPreferences.getInt("secretWebpage2", 2);
        maxGroupCount = mainPreferences.getInt("maxGroupCount", 200);
        maxMegagroupCount = mainPreferences.getInt("maxMegagroupCount", 10000);
        maxRecentGifsCount = mainPreferences.getInt("maxRecentGifsCount", 200);
        maxRecentStickersCount = mainPreferences.getInt("maxRecentStickersCount", 30);
        maxFaveStickersCount = mainPreferences.getInt("maxFaveStickersCount", 5);
        maxEditTime = mainPreferences.getInt("maxEditTime", 3600);
        ratingDecay = mainPreferences.getInt("ratingDecay", 2419200);
        linkPrefix = mainPreferences.getString("linkPrefix", "t.me");
        callReceiveTimeout = mainPreferences.getInt("callReceiveTimeout", 20000);
        callRingTimeout = mainPreferences.getInt("callRingTimeout", 90000);
        callConnectTimeout = mainPreferences.getInt("callConnectTimeout", 30000);
        callPacketTimeout = mainPreferences.getInt("callPacketTimeout", 10000);
        updateCheckDelay = mainPreferences.getInt("updateCheckDelay", 24 * 60 * 60);
        maxFolderPinnedDialogsCountDefault = mainPreferences.getInt("maxFolderPinnedDialogsCountDefault", 100);
        maxFolderPinnedDialogsCountPremium = mainPreferences.getInt("maxFolderPinnedDialogsCountPremium", 100);
        maxMessageLength = mainPreferences.getInt("maxMessageLength", 4096);
        maxCaptionLength = mainPreferences.getInt("maxCaptionLength", 1024);
        mapProvider = mainPreferences.getInt("mapProvider", 0);
        availableMapProviders = mainPreferences.getInt("availableMapProviders", 3);
        mapKey = mainPreferences.getString("pk", null);
        installReferer = mainPreferences.getString("installReferer", null);
        revokeTimeLimit = mainPreferences.getInt("revokeTimeLimit", 2147483647);
        revokeTimePmLimit = mainPreferences.getInt("revokeTimePmLimit", 2147483647);
        canRevokePmInbox = mainPreferences.getBoolean("canRevokePmInbox", canRevokePmInbox);
        preloadFeaturedStickers = mainPreferences.getBoolean("preloadFeaturedStickers", false);
        youtubePipType = mainPreferences.getString("youtubePipType", "disabled");
        keepAliveService = mainPreferences.getBoolean("keepAliveService", true);
        backgroundConnection = mainPreferences.getBoolean("keepAliveService", true);
        promoDialogId = mainPreferences.getLong("proxy_dialog", 0);
        nextPromoInfoCheckTime = mainPreferences.getInt("nextPromoInfoCheckTime", 0);
        promoDialogType = mainPreferences.getInt("promo_dialog_type", 0);
        promoPsaMessage = mainPreferences.getString("promo_psa_message", null);
        promoPsaType = mainPreferences.getString("promo_psa_type", null);
        proxyDialogAddress = mainPreferences.getString("proxyDialogAddress", null);
        venueSearchBot = mainPreferences.getString("venueSearchBot", "foursquare");
        storyVenueSearchBot = mainPreferences.getString("storyVenueSearchBot", "foursquare");
        gifSearchBot = mainPreferences.getString("gifSearchBot", "gif");
        imageSearchBot = mainPreferences.getString("imageSearchBot", "pic");
        blockedCountry = mainPreferences.getBoolean("blockedCountry", false);
        suggestedLangCode = mainPreferences.getString("suggestedLangCode", "en");
        animatedEmojisZoom = mainPreferences.getFloat("animatedEmojisZoom", 0.625f);
        qrLoginCamera = mainPreferences.getBoolean("qrLoginCamera", true);
        saveGifsWithStickers = mainPreferences.getBoolean("saveGifsWithStickers", false);
        youtubePipType = "inapp";
        filtersEnabled = mainPreferences.getBoolean("filtersEnabled", false);
        getfileExperimentalParams = mainPreferences.getBoolean("getfileExperimentalParams", false);
        smsjobsStickyNotificationEnabled = mainPreferences.getBoolean("smsjobsStickyNotificationEnabled", false);
        showFiltersTooltip = mainPreferences.getBoolean("showFiltersTooltip", false);
        autoarchiveAvailable = mainPreferences.getBoolean("autoarchiveAvailable", false);
        groupCallVideoMaxParticipants = mainPreferences.getInt("groipCallVideoMaxParticipants", 30);
        chatReadMarkSizeThreshold = mainPreferences.getInt("chatReadMarkSizeThreshold", 100);
        chatReadMarkExpirePeriod = mainPreferences.getInt("chatReadMarkExpirePeriod", 7 * 86400);
        ringtoneDurationMax = mainPreferences.getInt("ringtoneDurationMax", 5);
        ringtoneSizeMax = mainPreferences.getInt("ringtoneSizeMax", 1024_00);
        pmReadDateExpirePeriod = mainPreferences.getInt("pmReadDateExpirePeriod", 7 * 86400);
        suggestStickersApiOnly = mainPreferences.getBoolean("suggestStickersApiOnly", false);
        roundVideoSize = mainPreferences.getInt("roundVideoSize", 384);
        roundVideoBitrate = mainPreferences.getInt("roundVideoBitrate", 1000);
        roundAudioBitrate = mainPreferences.getInt("roundAudioBitrate", 64);
        pendingSuggestions = mainPreferences.getStringSet("pendingSuggestions", null);
        dismissedSuggestions = mainPreferences.getStringSet("dismissedSuggestions", null);
        channelsLimitDefault = mainPreferences.getInt("channelsLimitDefault", 500);
        channelsLimitPremium = mainPreferences.getInt("channelsLimitPremium", 2 * channelsLimitDefault);
        savedGifsLimitDefault = mainPreferences.getInt("savedGifsLimitDefault", 200);
        savedGifsLimitPremium = mainPreferences.getInt("savedGifsLimitPremium", 400);
        stickersFavedLimitDefault = mainPreferences.getInt("stickersFavedLimitDefault", 5);
        stickersFavedLimitPremium = mainPreferences.getInt("stickersFavedLimitPremium", 200);
        maxPinnedDialogsCountDefault = mainPreferences.getInt("maxPinnedDialogsCountDefault", 5);
        maxPinnedDialogsCountPremium = mainPreferences.getInt("maxPinnedDialogsCountPremium", 5);
        maxPinnedDialogsCountDefault = mainPreferences.getInt("maxPinnedDialogsCountDefault", 5);
        maxPinnedDialogsCountPremium = mainPreferences.getInt("maxPinnedDialogsCountPremium", 5);
        dialogFiltersLimitDefault = mainPreferences.getInt("dialogFiltersLimitDefault", 10);
        dialogFiltersLimitPremium = mainPreferences.getInt("dialogFiltersLimitPremium", 20);
        dialogFiltersChatsLimitDefault = mainPreferences.getInt("dialogFiltersChatsLimitDefault", 100);
        dialogFiltersChatsLimitPremium = mainPreferences.getInt("dialogFiltersChatsLimitPremium", 200);
        dialogFiltersPinnedLimitDefault = mainPreferences.getInt("dialogFiltersPinnedLimitDefault", 5);
        dialogFiltersPinnedLimitPremium = mainPreferences.getInt("dialogFiltersPinnedLimitPremium", 10);
        publicLinksLimitDefault = mainPreferences.getInt("publicLinksLimitDefault", 10);
        publicLinksLimitPremium = mainPreferences.getInt("publicLinksLimitPremium", 20);
        captionLengthLimitDefault = mainPreferences.getInt("captionLengthLimitDefault", 1024);
        captionLengthLimitPremium = mainPreferences.getInt("captionLengthLimitPremium", 4096);
        storyCaptionLengthLimitDefault = mainPreferences.getInt("storyCaptionLengthLimit", 200);
        storyCaptionLengthLimitPremium = mainPreferences.getInt("storyCaptionLengthLimitPremium", 2048);
        aboutLengthLimitDefault = mainPreferences.getInt("aboutLengthLimitDefault", 70);
        aboutLengthLimitPremium = mainPreferences.getInt("aboutLengthLimitPremium", 140);
        reactionsUserMaxDefault = mainPreferences.getInt("reactionsUserMaxDefault", 1);
        reactionsUserMaxPremium = mainPreferences.getInt("reactionsUserMaxPremium", 3);
        reactionsInChatMax = mainPreferences.getInt("reactionsInChatMax", 3);
        uploadMaxFileParts = mainPreferences.getInt("uploadMaxFileParts", (int) (FileLoader.DEFAULT_MAX_FILE_SIZE / 1024L / 512L));
        uploadMaxFilePartsPremium = mainPreferences.getInt("uploadMaxFilePartsPremium", uploadMaxFileParts * 2);
        premiumInvoiceSlug = mainPreferences.getString("premiumInvoiceSlug", null);
        verifyAgeBotUsername = mainPreferences.getString("verifyAgeBotUsername", null);
        verifyAgeCountry = mainPreferences.getString("verifyAgeCountry", "GB");
        verifyAgeMin = mainPreferences.getInt("verifyAgeMin", 18);
        premiumBotUsername = mainPreferences.getString("premiumBotUsername", null);
        premiumLocked = mainPreferences.getBoolean("premiumLocked", false);
        AndroidUtilities.runOnUIThread(() -> {
            if (getGlobalMainSettings().getBoolean("lockPremium", false)) {
                premiumLocked = true;
            }
        }, 10);
        starsLocked = mainPreferences.getBoolean("starsLocked", true);
        transcribeButtonPressed = mainPreferences.getInt("transcribeButtonPressed", 0);
        forumUpgradeParticipantsMin = mainPreferences.getInt("forumUpgradeParticipantsMin", 200);
        topicsPinnedLimit = mainPreferences.getInt("topicsPinnedLimit", 3);
        telegramAntispamUserId = mainPreferences.getLong("telegramAntispamUserId", -1);
        telegramAntispamGroupSizeMin = mainPreferences.getInt("telegramAntispamGroupSizeMin", 100);
        hiddenMembersGroupSizeMin = mainPreferences.getInt("hiddenMembersGroupSizeMin", 100);
        chatlistUpdatePeriod = mainPreferences.getInt("chatlistUpdatePeriod", 3600);
        uploadMarkupVideo = mainPreferences.getBoolean("uploadMarkupVideo", true);
        giftAttachMenuIcon = mainPreferences.getBoolean("giftAttachMenuIcon", false);
        giftTextFieldIcon = mainPreferences.getBoolean("giftTextFieldIcon", false);
        checkResetLangpack = mainPreferences.getInt("checkResetLangpack", 0);
        smallQueueMaxActiveOperations = mainPreferences.getInt("smallQueueMaxActiveOperations", 5);
        largeQueueMaxActiveOperations = mainPreferences.getInt("largeQueueMaxActiveOperations", 2);
        stealthModeFuture = mainPreferences.getInt("stories_stealth_future_period", 25 * 60);
        storiesChangelogUserId = mainPreferences.getLong("stories_changelog_user_id", 777000);
        giveawayAddPeersMax = mainPreferences.getLong("giveaway_add_peers_max", 10);
        giveawayCountriesMax = mainPreferences.getLong("giveaway_countries_max", 10);
        giveawayBoostsPerPremium = mainPreferences.getLong("giveaway_boosts_per_premium", 4);
        boostsPerSentGift = mainPreferences.getLong("boosts_per_sent_gift", 3);
        giveawayPeriodMax = mainPreferences.getLong("giveaway_period_max", 7);
        stealthModePast = mainPreferences.getInt("stories_stealth_past_period", 5 * 60);
        stealthModeCooldown = mainPreferences.getInt("stories_stealth_cooldown_period", 60 * 60);
        boolean isTest = ConnectionsManager.native_isTestBackend(currentAccount) != 0;
        chatlistInvitesLimitDefault = mainPreferences.getInt("chatlistInvitesLimitDefault", 3);
        storyExpiringLimitDefault = mainPreferences.getInt("storyExpiringLimitDefault", 50);
        storyExpiringLimitPremium = mainPreferences.getInt("storyExpiringLimitPremium", 100);
        storiesSentWeeklyLimitDefault = mainPreferences.getInt("storiesSentWeeklyLimitDefault", 7);
        storiesSuggestedReactionsLimitDefault = mainPreferences.getInt("storiesSuggestedReactionsLimitDefault", 1);
        storiesSuggestedReactionsLimitPremium = mainPreferences.getInt("storiesSuggestedReactionsLimitPremium", 5);
        storiesSentWeeklyLimitPremium = mainPreferences.getInt("storiesSentWeeklyLimitPremium", 70);
        storiesSentMonthlyLimitDefault = mainPreferences.getInt("storiesSentMonthlyLimitDefault", 30);
        storiesSentMonthlyLimitPremium = mainPreferences.getInt("storiesSentMonthlyLimitPremium", 300);
        channelBgIconLevelMin = mainPreferences.getInt("channelBgIconLevelMin", 1);
        channelProfileIconLevelMin = mainPreferences.getInt("channelProfileIconLevelMin", 1);
        channelEmojiStatusLevelMin = mainPreferences.getInt("channelEmojiStatusLevelMin", 1);
        groupProfileBgIconLevelMin = mainPreferences.getInt("groupProfileBgIconLevelMin", 1);
        groupEmojiStatusLevelMin = mainPreferences.getInt("groupEmojiStatusLevelMin", 1);
        groupEmojiStickersLevelMin = mainPreferences.getInt("groupEmojiStickersLevelMin", 1);
        groupWallpaperLevelMin = mainPreferences.getInt("groupWallpaperLevelMin", 1);
        groupCustomWallpaperLevelMin = mainPreferences.getInt("groupCustomWallpaperLevelMin", 1);
        groupTranscribeLevelMin = mainPreferences.getInt("groupTranscribeLevelMin", 1);
        quickRepliesLimit = mainPreferences.getInt("quickRepliesLimit", 10);
        quickReplyMessagesLimit = mainPreferences.getInt("quickReplyMessagesLimit", 20);
        channelWallpaperLevelMin = mainPreferences.getInt("channelWallpaperLevelMin", 1);
        channelCustomWallpaperLevelMin = mainPreferences.getInt("channelCustomWallpaperLevelMin", 1);
        chatlistInvitesLimitPremium = mainPreferences.getInt("chatlistInvitesLimitPremium",  isTest ? 5 : 20);
        chatlistJoinedLimitDefault = mainPreferences.getInt("chatlistJoinedLimitDefault", 2);
        chatlistJoinedLimitPremium = mainPreferences.getInt("chatlistJoinedLimitPremium",  isTest ? 5 : 20);
        stargiftsMessageLengthMax = mainPreferences.getInt("stargiftsMessageLengthMax", 255);
        stargiftsConvertPeriodMax = mainPreferences.getInt("stargiftsConvertPeriodMax", isTest ? 300 : 90 * 86400);
        videoIgnoreAltDocuments = mainPreferences.getBoolean("videoIgnoreAltDocuments", false);
        disableBotFullscreenBlur = mainPreferences.getBoolean("disableBotFullscreenBlur", false);
        tonBlockchainExplorerUrl = mainPreferences.getString("tonBlockchainExplorerUrl", "https://tonviewer.com/");
        starsPaidMessageAmountMax = mainPreferences.getLong("starsPaidMessageAmountMax", 10_000L);
        starsPaidMessageCommissionPermille = mainPreferences.getInt("starsPaidMessageCommissionPermille", 850);
        stargiftsPinnedToTopLimit = mainPreferences.getInt("stargiftsPinnedToTopLimit", 6);
        starsPaidMessagesAvailable = mainPreferences.getBoolean("starsPaidMessagesAvailable", true);
        freezeSinceDate = mainPreferences.getLong("freezeSinceDate", 0L);
        freezeUntilDate = mainPreferences.getLong("freezeUntilDate", 0L);
        conferenceCallSizeLimit = mainPreferences.getInt("conferenceCallSizeLimit", isTest ? 5 : 100);
        callRequestsDisabled = mainPreferences.getBoolean("callRequestsDisabled", false);
        pollAnswersMax = mainPreferences.getInt("pollAnswersMax", 12);
        todoItemsMax = mainPreferences.getInt("todoItemsMax", isTest ? 10 : 30);
        todoTitleLengthMax = mainPreferences.getInt("todoTitleLengthMax", 32);
        todoItemLengthMax = mainPreferences.getInt("todoItemLengthMax", 64);
        translationsManualEnabled = mainPreferences.getString("translationsManualEnabled", "enabled");
        translationsAutoEnabled = mainPreferences.getString("translationsAutoEnabled", "enabled");
        whitelistedBots = mainPreferences.getStringSet("whitelistedBots", new HashSet<>()).stream().map(s -> tryParseLong(s, 0)).collect(Collectors.toCollection(HashSet::new));
        starsGroupcallMessageAmountMax = mainPreferences.getInt("starsGroupcallMessageAmountMax", 10_000);
        starsGroupcallMessageLimits = parseTiersString(mainPreferences.getString("starsGroupcallMessageLimits", null));
        freezeAppealUrl = mainPreferences.getString("freezeAppealUrl", "t.me/spambot");
        enableGiftsInProfile = mainPreferences.getBoolean("enableGiftsInProfile", true);
        storiesPosting = mainPreferences.getString("storiesPosting", "enabled");
        storiesEntities = mainPreferences.getString("storiesEntities", "premium");
        storiesExportNopublicLink = mainPreferences.getBoolean("storiesExportNopublicLink", false);
        authorizationAutoconfirmPeriod = mainPreferences.getInt("authorization_autoconfirm_period", 604800);
        quoteLengthMax = mainPreferences.getInt("quoteLengthMax", 1024);
        giveawayGiftsPurchaseAvailable = mainPreferences.getBoolean("giveawayGiftsPurchaseAvailable", false);
        peerColors = PeerColors.fromString(PeerColors.TYPE_NAME, mainPreferences.getString("peerColors", ""));
        profilePeerColors = PeerColors.fromString(PeerColors.TYPE_PROFILE, mainPreferences.getString("profilePeerColors", ""));
        transcribeAudioTrialWeeklyNumber = mainPreferences.getInt("transcribeAudioTrialWeeklyNumber", BuildVars.DEBUG_PRIVATE_VERSION ? 2 : 0);
        transcribeAudioTrialCurrentNumber = mainPreferences.getInt("transcribeAudioTrialCurrentNumber", transcribeAudioTrialWeeklyNumber);
        transcribeAudioTrialDurationMax = mainPreferences.getInt("transcribeAudioTrialDurationMax", 300);
        transcribeAudioTrialCooldownUntil = mainPreferences.getInt("transcribeAudioTrialCooldownUntil", 0);
        recommendedChannelsLimitDefault = mainPreferences.getInt("recommendedChannelsLimitDefault", 10);
        recommendedChannelsLimitPremium = mainPreferences.getInt("recommendedChannelsLimitPremium", 100);
        boostsChannelLevelMax = mainPreferences.getInt("boostsChannelLevelMax", 100);
        channelRestrictSponsoredLevelMin = mainPreferences.getInt("channelRestrictSponsoredLevelMin", 30);
        channelAutotranslationLevelMin = mainPreferences.getInt("channelAutotranslationLevelMin", 3);
        savedDialogsPinnedLimitDefault = mainPreferences.getInt("savedDialogsPinnedLimitDefault", 4);
        savedDialogsPinnedLimitPremium = mainPreferences.getInt("savedDialogsPinnedLimitPremium", 6);
        storyQualityFull = mainPreferences.getBoolean("storyQualityFull", true);
        savedViewAsChats = mainPreferences.getBoolean("savedViewAsChats", false);
        folderTags = mainPreferences.getBoolean("folderTags", false);
        uploadPremiumSpeedupUpload = mainPreferences.getFloat("uploadPremiumSpeedupUpload", 10.0f);
        uploadPremiumSpeedupDownload = mainPreferences.getFloat("uploadPremiumSpeedupDownload", 10.0f);
        uploadPremiumSpeedupNotifyPeriod = mainPreferences.getInt("uploadPremiumSpeedupNotifyPeriod2", 3600);
        introTitleLengthLimit = mainPreferences.getInt("introTitleLengthLimit", 32);
        introDescriptionLengthLimit = mainPreferences.getInt("introDescriptionLengthLimit", 72);
        businessChatLinksLimit = mainPreferences.getInt("businessChatLinksLimit", 100);
        channelRevenueWithdrawalEnabled = mainPreferences.getBoolean("channelRevenueWithdrawalEnabled", false);
        newNoncontactPeersRequirePremiumWithoutOwnpremium = mainPreferences.getBoolean("newNoncontactPeersRequirePremiumWithoutOwnpremium", false);
        reactionsUniqMax = mainPreferences.getInt("reactionsUniqMax", 11);
        premiumManageSubscriptionUrl = mainPreferences.getString("premiumManageSubscriptionUrl", ApplicationLoader.isStandaloneBuild() ? "https://t.me/premiumbot?start=status" : "https://play.google.com/store/account/subscriptions?sku=telegram_premium&package=org.telegram.messenger");
        androidDisableRoundCamera2 = mainPreferences.getBoolean("androidDisableRoundCamera2", true);
        storiesPinnedToTopCountMax = mainPreferences.getInt("storiesPinnedToTopCountMax", 3);
        showAnnualPerMonth = mainPreferences.getBoolean("showAnnualPerMonth", false);
        canEditFactcheck = mainPreferences.getBoolean("canEditFactcheck", false);
        factcheckLengthLimit = mainPreferences.getInt("factcheckLengthLimit", 1024);
        starsRevenueWithdrawalMin = mainPreferences.getLong("starsRevenueWithdrawalMin", 1000);
        starsPaidPostAmountMax = mainPreferences.getLong("starsPaidPostAmountMax", 10_000);
        botPreviewMediasMax = mainPreferences.getInt("botPreviewMediasMax", 10);
        webAppAllowedProtocols = mainPreferences.getStringSet("webAppAllowedProtocols", new HashSet<>(Arrays.asList("http", "https")));
        ignoreRestrictionReasons = mainPreferences.getStringSet("ignoreRestrictionReasons", new HashSet<>(Arrays.asList()));
        tonProxyAddress = mainPreferences.getString("tonProxyAddress", "magic.org");
        weatherSearchUsername = mainPreferences.getString("weatherSearchUsername", "izweatherbot");
        storyWeatherPreload = mainPreferences.getBoolean("storyWeatherPreload", true);
        starsGiftsEnabled = mainPreferences.getBoolean("starsGiftsEnabled", true);
        stargiftsBlocked = mainPreferences.getBoolean("stargiftsBlocked", true); // !BuildVars.DEBUG_VERSION);
        starsPaidReactionAmountMax = mainPreferences.getLong("starsPaidReactionAmountMax", 10_000L);
        starsSubscriptionAmountMax = mainPreferences.getLong("starsSubscriptionAmountMax", 2500L);
        starsUsdSellRate1000 = mainPreferences.getFloat("starsUsdSellRate1000", 2000);
        starsUsdWithdrawRate1000 = mainPreferences.getFloat("starsUsdWithdrawRate1000", 1200);
        sponsoredLinksInappAllow = mainPreferences.getBoolean("sponsoredLinksInappAllow", false);
        starrefProgramAllowed = mainPreferences.getBoolean("starrefProgramAllowed", false);
        starrefConnectAllowed = mainPreferences.getBoolean("starrefConnectAllowed", false);
        starrefStartParamPrefixes = mainPreferences.getStringSet("starrefStartParamPrefixes", new HashSet<>(Arrays.asList("_tgr_")));
        starrefMinCommissionPermille = mainPreferences.getInt("starrefMinCommissionPermille", 1);
        starrefMaxCommissionPermille = mainPreferences.getInt("starrefMaxCommissionPermille", 400);
        botVerificationDescriptionLengthLimit = mainPreferences.getInt("botVerificationDescriptionLengthLimit", 70);
        paidReactionsPrivacyTime = mainPreferences.getLong("paidReactionsAnonymousTime", 0);
        config.load(mainPreferences);

        final boolean paidReactionsActual = (System.currentTimeMillis() - paidReactionsPrivacyTime) < 1000 * 60 * 60 * 2;
        paidReactionsPrivacy = null;
        if ((System.currentTimeMillis() - paidReactionsPrivacyTime) < 1000 * 60 * 60 * 2) {
            if (mainPreferences.contains("paidReactionsDialogId")) {
                paidReactionsPrivacy = mainPreferences.getLong("paidReactionsDialogId", 0);
            } else {
                paidReactionsPrivacy = mainPreferences.getBoolean("paidReactionsAnonymous", false) ? UserObject.ANONYMOUS : 0;
            }
        }
        scheduleTranscriptionUpdate();
        if (mainPreferences.contains("dcDomainName2")) {
            dcDomainName = mainPreferences.getString("dcDomainName2", "apv3.stel.com");
        } else {
            dcDomainName = isTest ? "tapv3.stel.com" : "apv3.stel.com";
        }
        if (mainPreferences.contains("webFileDatacenterId")) {
            webFileDatacenterId = mainPreferences.getInt("webFileDatacenterId", 4);
        } else {
            webFileDatacenterId = isTest ? 2 : 4;
        }

        Set<String> currencySet = mainPreferences.getStringSet("directPaymentsCurrency", null);
        if (currencySet != null) {
            directPaymentsCurrency.clear();
            directPaymentsCurrency.addAll(currencySet);
        }

        loadPremiumFeaturesPreviewOrder(premiumFeaturesTypesToPosition, mainPreferences.getString("premiumFeaturesTypesToPosition", null));
        loadPremiumFeaturesPreviewOrder(businessFeaturesTypesToPosition, mainPreferences.getString("businessFeaturesTypesToPosition", null));
        if (pendingSuggestions != null) {
            pendingSuggestions = new HashSet<>(pendingSuggestions);
        } else {
            pendingSuggestions = new HashSet<>();
        }
        if (dismissedSuggestions != null) {
            dismissedSuggestions = new HashSet<>(dismissedSuggestions);
        } else {
            dismissedSuggestions = new HashSet<>();
        }

        exportUri = mainPreferences.getStringSet("exportUri2", null);
        if (exportUri != null) {
            exportUri = new HashSet<>(exportUri);
        } else {
            exportUri = new HashSet<>();
            exportUri.add("content://(\\d+@)?com\\.whatsapp\\.provider\\.media/export_chat/");
            exportUri.add("content://(\\d+@)?com\\.whatsapp\\.w4b\\.provider\\.media/export_chat/");
            exportUri.add("content://jp\\.naver\\.line\\.android\\.line\\.common\\.FileProvider/export-chat/");
            exportUri.add(".*WhatsApp.*\\.txt$");
            exportUri.add(".*WhatsApp.*\\.zip$");
        }

        exportGroupUri = mainPreferences.getStringSet("exportGroupUri", null);
        if (exportGroupUri != null) {
            exportGroupUri = new HashSet<>(exportGroupUri);
        } else {
            exportGroupUri = new HashSet<>();
            exportGroupUri.add("@g.us/");
        }

        exportPrivateUri = mainPreferences.getStringSet("exportPrivateUri", null);
        if (exportPrivateUri != null) {
            exportPrivateUri = new HashSet<>(exportPrivateUri);
        } else {
            exportPrivateUri = new HashSet<>();
            exportPrivateUri.add("@s.whatsapp.net/");
        }

        autologinDomains = mainPreferences.getStringSet("autologinDomains", null);
        if (autologinDomains != null) {
            autologinDomains = new HashSet<>(autologinDomains);
        } else {
            autologinDomains = new HashSet<>();
        }

        authDomains = mainPreferences.getStringSet("authDomains", null);
        if (authDomains != null) {
            authDomains = new HashSet<>(authDomains);
        } else {
            authDomains = new HashSet<>();
        }

        autologinToken = mainPreferences.getString("autologinToken", null);

        Set<String> emojies = mainPreferences.getStringSet("diceEmojies", null);
        if (emojies == null) {
            diceEmojies = new HashSet<>();
            diceEmojies.add("\uD83C\uDFB2");
            diceEmojies.add("\uD83C\uDFAF");
        } else {
            diceEmojies = new HashSet<>(emojies);
        }
        String text = mainPreferences.getString("diceSuccess", null);
        if (text == null) {
            diceSuccess.put("\uD83C\uDFAF", new DiceFrameSuccess(62, 6));
        } else {
            try {
                byte[] bytes = Base64.decode(text, Base64.DEFAULT);
                if (bytes != null) {
                    SerializedData data = new SerializedData(bytes);
                    int count = data.readInt32(true);
                    for (int a = 0; a < count; a++) {
                        diceSuccess.put(data.readString(true), new DiceFrameSuccess(data.readInt32(true), data.readInt32(true)));
                    }
                    data.cleanup();
                }
            } catch (Exception e) {
                FileLog.e(e);
            }
        }

        text = mainPreferences.getString("emojiSounds", null);
        if (text != null) {
            try {
                byte[] bytes = Base64.decode(text, Base64.DEFAULT);
                if (bytes != null) {
                    SerializedData data = new SerializedData(bytes);
                    int count = data.readInt32(true);
                    for (int a = 0; a < count; a++) {
                        emojiSounds.put(data.readString(true), new EmojiSound(data.readInt64(true), data.readInt64(true), data.readByteArray(true)));
                    }
                    data.cleanup();
                }
            } catch (Exception e) {
                FileLog.e(e);
            }
        }

        text = mainPreferences.getString("gifSearchEmojies", null);
        if (text == null) {
            gifSearchEmojies.add("👍");
            gifSearchEmojies.add("👎");
            gifSearchEmojies.add("😍");
            gifSearchEmojies.add("😂");
            gifSearchEmojies.add("😮");
            gifSearchEmojies.add("🙄");
            gifSearchEmojies.add("😥");
            gifSearchEmojies.add("😡");
            gifSearchEmojies.add("🥳");
            gifSearchEmojies.add("😎");
        } else {
            try {
                byte[] bytes = Base64.decode(text, Base64.DEFAULT);
                if (bytes != null) {
                    SerializedData data = new SerializedData(bytes);
                    int count = data.readInt32(true);
                    for (int a = 0; a < count; a++) {
                        gifSearchEmojies.add(data.readString(true));
                    }
                    data.cleanup();
                }
            } catch (Exception e) {
                FileLog.e(e);
            }
        }
        AndroidUtilities.runOnUIThread(this::loadAppConfig, 2000);
        AndroidUtilities.runOnUIThread(() -> checkPeerColors(false), 400);

        topicsController = new TopicsController(num);
        cacheByChatsController = new CacheByChatsController(num);
        translateController = new TranslateController(this);

        Utilities.globalQueue.postRunnable(() -> {
            enableJoined = notificationsPreferences.getBoolean("EnableContactJoined", true);
            nextTosCheckTime = notificationsPreferences.getInt("nextTosCheckTime", 0);
        });
    }


    private void sendLoadPeersRequest(TLObject req, ArrayList<TLObject> requests, TLRPC.messages_Dialogs pinnedDialogs, TLRPC.messages_Dialogs pinnedRemoteDialogs, ArrayList<TLRPC.User> users, ArrayList<TLRPC.Chat> chats, ArrayList<DialogFilter> filtersToSave, SparseArray<DialogFilter> filtersToDelete, ArrayList<Integer> filtersOrder, HashMap<Integer, HashSet<Long>> filterDialogRemovals, HashSet<Integer> filtersUnreadCounterReset, Runnable onDone) {
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response instanceof TLRPC.TL_messages_chats) {
                TLRPC.TL_messages_chats res = (TLRPC.TL_messages_chats) response;
                chats.addAll(res.chats);
            } else if (response instanceof Vector) {
                Vector vector = (Vector) response;
                for (int a = 0, N = vector.objects.size(); a < N; a++) {
                    TLRPC.User user = (TLRPC.User) vector.objects.get(a);
                    users.add(user);
                }
            } else if (response instanceof TLRPC.TL_messages_peerDialogs) {
                TLRPC.TL_messages_peerDialogs peerDialogs = (TLRPC.TL_messages_peerDialogs) response;
                pinnedDialogs.dialogs.addAll(peerDialogs.dialogs);
                pinnedDialogs.messages.addAll(peerDialogs.messages);
                pinnedRemoteDialogs.dialogs.addAll(peerDialogs.dialogs);
                pinnedRemoteDialogs.messages.addAll(peerDialogs.messages);
                users.addAll(peerDialogs.users);
                chats.addAll(peerDialogs.chats);
            }
            requests.remove(req);
            if (requests.isEmpty()) {
                getMessagesStorage().processLoadedFilterPeers(pinnedDialogs, pinnedRemoteDialogs, users, chats, filtersToSave, filtersToDelete, filtersOrder, filterDialogRemovals, filtersUnreadCounterReset, onDone);
            }
        });
    }

    protected void loadFilterPeers(HashMap<Long, TLRPC.InputPeer> dialogsToLoadMap, HashMap<Long, TLRPC.InputPeer> usersToLoadMap, HashMap<Long, TLRPC.InputPeer> chatsToLoadMap, TLRPC.messages_Dialogs pinnedDialogs, TLRPC.messages_Dialogs pinnedRemoteDialogs, ArrayList<TLRPC.User> users, ArrayList<TLRPC.Chat> chats, ArrayList<DialogFilter> filtersToSave, SparseArray<DialogFilter> filtersToDelete, ArrayList<Integer> filtersOrder, HashMap<Integer, HashSet<Long>> filterDialogRemovals, HashSet<Integer> filtersUnreadCounterReset, Runnable onDone) {
        Utilities.stageQueue.postRunnable(() -> {
            ArrayList<TLObject> requests = new ArrayList<>();
            TLRPC.TL_users_getUsers req = null;
            for (HashMap.Entry<Long, TLRPC.InputPeer> entry : usersToLoadMap.entrySet()) {
                if (req == null) {
                    req = new TLRPC.TL_users_getUsers();
                    requests.add(req);
                }
                req.id.add(getInputUser(entry.getValue()));
                if (req.id.size() == 100) {
                    sendLoadPeersRequest(req, requests, pinnedDialogs, pinnedRemoteDialogs, users, chats, filtersToSave, filtersToDelete, filtersOrder, filterDialogRemovals, filtersUnreadCounterReset, onDone);
                    req = null;
                }
            }
            if (req != null) {
                sendLoadPeersRequest(req, requests, pinnedDialogs, pinnedRemoteDialogs, users, chats, filtersToSave, filtersToDelete, filtersOrder, filterDialogRemovals, filtersUnreadCounterReset, onDone);
            }
            TLRPC.TL_messages_getChats req2 = null;
            TLRPC.TL_channels_getChannels req3 = null;
            for (HashMap.Entry<Long, TLRPC.InputPeer> entry : chatsToLoadMap.entrySet()) {
                TLRPC.InputPeer inputPeer = entry.getValue();
                if (inputPeer.chat_id != 0) {
                    if (req2 == null) {
                        req2 = new TLRPC.TL_messages_getChats();
                        requests.add(req2);
                    }
                    req2.id.add(entry.getKey());
                    if (req2.id.size() == 100) {
                        sendLoadPeersRequest(req2, requests, pinnedDialogs, pinnedRemoteDialogs, users, chats, filtersToSave, filtersToDelete, filtersOrder, filterDialogRemovals, filtersUnreadCounterReset, onDone);
                        req2 = null;
                    }
                } else if (inputPeer.channel_id != 0) {
                    if (req3 == null) {
                        req3 = new TLRPC.TL_channels_getChannels();
                        requests.add(req3);
                    }
                    req3.id.add(getInputChannel(inputPeer));
                    if (req3.id.size() == 100) {
                        sendLoadPeersRequest(req3, requests, pinnedDialogs, pinnedRemoteDialogs, users, chats, filtersToSave, filtersToDelete, filtersOrder, filterDialogRemovals, filtersUnreadCounterReset, onDone);
                        req3 = null;
                    }
                }
            }
            if (req2 != null) {
                sendLoadPeersRequest(req2, requests, pinnedDialogs, pinnedRemoteDialogs, users, chats, filtersToSave, filtersToDelete, filtersOrder, filterDialogRemovals, filtersUnreadCounterReset, onDone);
            }
            if (req3 != null) {
                sendLoadPeersRequest(req3, requests, pinnedDialogs, pinnedRemoteDialogs, users, chats, filtersToSave, filtersToDelete, filtersOrder, filterDialogRemovals, filtersUnreadCounterReset, onDone);
            }

            TLRPC.TL_messages_getPeerDialogs req4 = null;
            for (HashMap.Entry<Long, TLRPC.InputPeer> entry : dialogsToLoadMap.entrySet()) {
                if (req4 == null) {
                    req4 = new TLRPC.TL_messages_getPeerDialogs();
                    requests.add(req4);
                }
                TLRPC.TL_inputDialogPeer inputDialogPeer = new TLRPC.TL_inputDialogPeer();
                inputDialogPeer.peer = entry.getValue();
                req4.peers.add(inputDialogPeer);
                if (req4.peers.size() == 100) {
                    sendLoadPeersRequest(req4, requests, pinnedDialogs, pinnedRemoteDialogs, users, chats, filtersToSave, filtersToDelete, filtersOrder, filterDialogRemovals, filtersUnreadCounterReset, onDone);
                    req4 = null;
                }
            }
            if (req4 != null) {
                sendLoadPeersRequest(req4, requests, pinnedDialogs, pinnedRemoteDialogs, users, chats, filtersToSave, filtersToDelete, filtersOrder, filterDialogRemovals, filtersUnreadCounterReset, onDone);
            }
        });
    }

    protected void processLoadedDialogFilters(ArrayList<DialogFilter> filters, TLRPC.messages_Dialogs pinnedDialogs, TLRPC.messages_Dialogs pinnedRemoteDialogs, ArrayList<TLRPC.User> users, ArrayList<TLRPC.Chat> chats, ArrayList<TLRPC.EncryptedChat> encryptedChats, int remote, Runnable onDone) {
        Utilities.stageQueue.postRunnable(() -> {

            LongSparseArray<TLRPC.Dialog> new_dialogs_dict = new LongSparseArray<>();
            SparseArray<TLRPC.EncryptedChat> enc_chats_dict;
            LongSparseArray<ArrayList<MessageObject>> new_dialogMessage = new LongSparseArray<>();
            LongSparseArray<TLRPC.User> usersDict = new LongSparseArray<>();
            LongSparseArray<TLRPC.Chat> chatsDict = new LongSparseArray<>();

            for (int a = 0; a < pinnedDialogs.users.size(); a++) {
                TLRPC.User u = pinnedDialogs.users.get(a);
                usersDict.put(u.id, u);
            }
            for (int a = 0; a < pinnedDialogs.chats.size(); a++) {
                TLRPC.Chat c = pinnedDialogs.chats.get(a);
                chatsDict.put(c.id, c);
            }
            if (encryptedChats != null) {
                enc_chats_dict = new SparseArray<>();
                for (int a = 0, N = encryptedChats.size(); a < N; a++) {
                    TLRPC.EncryptedChat encryptedChat = encryptedChats.get(a);
                    enc_chats_dict.put(encryptedChat.id, encryptedChat);
                }
            } else {
                enc_chats_dict = null;
            }

            ArrayList<MessageObject> newMessages = new ArrayList<>();
            for (int a = 0; a < pinnedDialogs.messages.size(); a++) {
                TLRPC.Message message = pinnedDialogs.messages.get(a);
                if (message.peer_id.channel_id != 0) {
                    TLRPC.Chat chat = chatsDict.get(message.peer_id.channel_id);
                    if (chat != null && chat.left && (promoDialogId == 0 || promoDialogId != -chat.id)) {
                        continue;
                    }
                } else if (message.peer_id.chat_id != 0) {
                    TLRPC.Chat chat = chatsDict.get(message.peer_id.chat_id);
                    if (chat != null && chat.migrated_to != null) {
                        continue;
                    }
                }
                MessageObject messageObject = new MessageObject(currentAccount, message, usersDict, chatsDict, false, false);
                newMessages.add(messageObject);
                long dialogId = messageObject.getDialogId();
                if (new_dialogMessage.containsKey(dialogId)) {
                    new_dialogMessage.get(dialogId).add(messageObject);
                } else {
                    ArrayList<MessageObject> arrayList = new ArrayList<>(1);
                    arrayList.add(messageObject);
                    new_dialogMessage.put(dialogId, arrayList);
                }
            }
            //getFileLoader().checkMediaExistance(newMessages);

            for (int a = 0; a < pinnedDialogs.dialogs.size(); a++) {
                TLRPC.Dialog d = pinnedDialogs.dialogs.get(a);
                DialogObject.initDialog(d);
                if (d.id == 0) {
                    continue;
                }
                if (DialogObject.isEncryptedDialog(d.id) && enc_chats_dict != null) {
                    if (enc_chats_dict.get(DialogObject.getEncryptedChatId(d.id)) == null) {
                        continue;
                    }
                }
                if (promoDialogId != 0 && promoDialogId == d.id) {
                    promoDialog = d;
                }
                if (d.last_message_date == 0) {
                    ArrayList<MessageObject> arrayList = new_dialogMessage.get(d.id);
                    if (arrayList != null) {
                        int maxDate = Integer.MIN_VALUE;
                        for (int i = 0; i < arrayList.size(); ++i) {
                            MessageObject msg = arrayList.get(i);
                            if (msg != null && msg.messageOwner != null && maxDate < msg.messageOwner.date) {
                                maxDate = msg.messageOwner.date;
                            }
                        }
                        if (maxDate > Integer.MIN_VALUE) {
                            d.last_message_date = maxDate;
                        }
                    }
                }
                if (DialogObject.isChannel(d)) {
                    TLRPC.Chat chat = chatsDict.get(-d.id);
                    if (chat != null) {
                        if (chat.left && (promoDialogId == 0 || promoDialogId != d.id)) {
                            continue;
                        }
                    }
                    channelsPts.put(-d.id, d.pts);
                } else if (d.id < 0) {
                    TLRPC.Chat chat = chatsDict.get(-d.id);
                    if (chat != null && chat.migrated_to != null) {
                        continue;
                    }
                }
                new_dialogs_dict.put(d.id, d);

                Integer value = dialogs_read_inbox_max.get(d.id);
                if (value == null) {
                    value = 0;
                }
                dialogs_read_inbox_max.put(d.id, Math.max(value, d.read_inbox_max_id));

                value = dialogs_read_outbox_max.get(d.id);
                if (value == null) {
                    value = 0;
                }
                dialogs_read_outbox_max.put(d.id, Math.max(value, d.read_outbox_max_id));
            }

            if (pinnedRemoteDialogs != null && !pinnedRemoteDialogs.dialogs.isEmpty()) {
                ImageLoader.saveMessagesThumbs(pinnedRemoteDialogs.messages);
                for (int a = 0; a < pinnedRemoteDialogs.messages.size(); a++) {
                    TLRPC.Message message = pinnedRemoteDialogs.messages.get(a);
                    if (message.action instanceof TLRPC.TL_messageActionChatDeleteUser) {
                        TLRPC.User user = usersDict.get(message.action.user_id);
                        if (user != null && user.bot) {
                            message.reply_markup = new TLRPC.TL_replyKeyboardHide();
                            message.flags |= 64;
                        }
                    }

                    if (message.action instanceof TLRPC.TL_messageActionChatMigrateTo || message.action instanceof TLRPC.TL_messageActionChannelCreate) {
                        message.unread = false;
                        message.media_unread = false;
                    } else {
                        ConcurrentHashMap<Long, Integer> read_max = message.out ? dialogs_read_outbox_max : dialogs_read_inbox_max;
                        Integer value = read_max.get(message.dialog_id);
                        if (value == null) {
                            value = getMessagesStorage().getDialogReadMax(message.out, message.dialog_id);
                            read_max.put(message.dialog_id, value);
                        }
                        message.unread = value < message.id;
                    }
                }
                getMessagesStorage().putDialogs(pinnedRemoteDialogs, 0);
            }

            AndroidUtilities.runOnUIThread(() -> {
                if (remote != 2) {
                    dialogFilters = filters;
                    dialogFiltersById.clear();
                    for (int a = 0, N = dialogFilters.size(); a < N; a++) {
                        DialogFilter filter = dialogFilters.get(a);
                        dialogFiltersById.put(filter.id, filter);
                    }
                    Collections.sort(dialogFilters, (o1, o2) -> {
                        if (o1.order > o2.order) {
                            return 1;
                        } else if (o1.order < o2.order) {
                            return -1;
                        }
                        return 0;
                    });
                    putUsers(users, true);
                    putChats(chats, true);
                    dialogFiltersLoaded = true;
                    getNotificationCenter().postNotificationName(NotificationCenter.dialogFiltersUpdated);
                    if (remote == 0) {
                        loadRemoteFilters(false);
                    }

                    if (pinnedRemoteDialogs != null && !pinnedRemoteDialogs.dialogs.isEmpty()) {
                        applyDialogsNotificationsSettings(pinnedRemoteDialogs.dialogs);
                    }

                    if (encryptedChats != null) {
                        for (int a = 0; a < encryptedChats.size(); a++) {
                            TLRPC.EncryptedChat encryptedChat = encryptedChats.get(a);
                            if (encryptedChat instanceof TLRPC.TL_encryptedChat && AndroidUtilities.getMyLayerVersion(encryptedChat.layer) < SecretChatHelper.CURRENT_SECRET_CHAT_LAYER) {
                                getSecretChatHelper().sendNotifyLayerMessage(encryptedChat, null);
                            }
                            putEncryptedChat(encryptedChat, true);
                        }
                    }

                    for (int a = 0; a < new_dialogs_dict.size(); a++) {
                        long key = new_dialogs_dict.keyAt(a);
                        TLRPC.Dialog newDialog = new_dialogs_dict.valueAt(a);
                        TLRPC.Dialog currentDialog = dialogs_dict.get(key);

                        if (pinnedRemoteDialogs != null && pinnedRemoteDialogs.dialogs.contains(newDialog)) {
                            if (newDialog.draft instanceof TLRPC.TL_draftMessage) {
                                getMediaDataController().saveDraft(newDialog.id, 0, newDialog.draft, null, false);
                            }
                            if (currentDialog != null) {
                                currentDialog.notify_settings = newDialog.notify_settings;
                            }
                        }

                        ArrayList<MessageObject> newMsgs = new_dialogMessage.get(newDialog.id);
                        if (currentDialog == null) {
                            dialogs_dict.put(key, newDialog);
                            dialogMessage.put(key, newMsgs);
                            if (newMsgs != null) {
                                for (int i = 0; i < newMsgs.size(); ++i) {
                                    MessageObject msg = newMsgs.get(i);
                                    if (msg != null && msg.messageOwner.peer_id.channel_id == 0) {
                                        dialogMessagesByIds.put(msg.getId(), msg);
                                        if (msg.messageOwner.random_id != 0) {
                                            dialogMessagesByRandomIds.put(msg.messageOwner.random_id, msg);
                                        }
                                    }
                                }
                            }
                            getTranslateController().checkDialogMessage(key);
                        } else {
                            currentDialog.pinned = newDialog.pinned;
                            currentDialog.pinnedNum = newDialog.pinnedNum;
                            ArrayList<MessageObject> oldMsgs = dialogMessage.get(key);
                            boolean oldMsgsDeleted = false;
                            for (int i = 0; oldMsgs != null && i < oldMsgs.size(); ++i) {
                                if (oldMsgs.get(i) != null && oldMsgs.get(i).deleted) {
                                    oldMsgsDeleted = true;
                                    break;
                                }
                            }
                            if (oldMsgsDeleted || oldMsgs == null || currentDialog.top_message > 0) {
                                if (newDialog.top_message >= currentDialog.top_message || (oldMsgs == null) != (newMsgs == null) || oldMsgs != null && newMsgs != null && oldMsgs.size() != newMsgs.size()) {
                                    dialogs_dict.put(key, newDialog);
                                    dialogMessage.put(key, newMsgs);
                                    if (oldMsgs != null) {
                                        for (int i = 0; i < oldMsgs.size(); ++i) {
                                            MessageObject oldMsg = oldMsgs.get(i);
                                            if (oldMsg == null) {
                                                continue;
                                            }
                                            if (oldMsg.messageOwner.peer_id.channel_id == 0) {
                                                dialogMessagesByIds.remove(oldMsg.getId());
                                            }
                                            if (oldMsg.messageOwner.random_id != 0) {
                                                dialogMessagesByRandomIds.remove(oldMsg.messageOwner.random_id);
                                            }
                                        }
                                    }
                                    if (newMsgs != null) {
                                        for (int i = 0; i < newMsgs.size(); ++i) {
                                            MessageObject newMsg = newMsgs.get(i);
                                            if (newMsg != null && newMsg.messageOwner.peer_id.channel_id == 0) {
                                                for (int j = 0; oldMsgs != null && j < oldMsgs.size(); ++j) {
                                                    MessageObject oldMsg = oldMsgs.get(j);
                                                    if (oldMsg != null && oldMsg.getId() == newMsg.getId()) {
                                                        newMsg.deleted = oldMsg.deleted;
                                                        break;
                                                    }
                                                }
                                                dialogMessagesByIds.put(newMsg.getId(), newMsg);
                                                if (newMsg.messageOwner.random_id != 0) {
                                                    dialogMessagesByRandomIds.put(newMsg.messageOwner.random_id, newMsg);
                                                }
                                            }
                                        }
                                    }
                                    getTranslateController().checkDialogMessage(key);
                                }
                            } else {
//                                if (newMsg == null || newMsg.messageOwner.date > oldMsg.messageOwner.date) {
                                dialogs_dict.put(key, newDialog);
                                dialogMessage.put(key, newMsgs);
                                if (oldMsgs != null) {
                                    for (int i = 0; i < oldMsgs.size(); ++i) {
                                        MessageObject oldMsg = oldMsgs.get(i);
                                        if (oldMsg == null) {
                                            continue;
                                        }
                                        if (oldMsg.messageOwner.peer_id.channel_id == 0) {
                                            dialogMessagesByIds.remove(oldMsg.getId());
                                        }
                                        if (oldMsg.messageOwner.random_id != 0) {
                                            dialogMessagesByRandomIds.remove(oldMsg.messageOwner.random_id);
                                        }
                                    }
                                }
                                if (newMsgs != null) {
                                    for (int i = 0; i < newMsgs.size(); ++i) {
                                        MessageObject newMsg = newMsgs.get(i);
                                        if (newMsg != null && newMsg.messageOwner.peer_id.channel_id == 0) {
                                            for (int j = 0; oldMsgs != null && j < oldMsgs.size(); ++j) {
                                                MessageObject oldMsg = oldMsgs.get(j);
                                                if (oldMsg != null && oldMsg.getId() == newMsg.getId()) {
                                                    newMsg.deleted = oldMsg.deleted;
                                                    break;
                                                }
                                            }
                                            dialogMessagesByIds.put(newMsg.getId(), newMsg);
                                            if (newMsg.messageOwner.random_id != 0) {
                                                dialogMessagesByRandomIds.put(newMsg.messageOwner.random_id, newMsg);
                                            }
                                        }
                                    }
                                }
                                getTranslateController().checkDialogMessage(key);
                            }
                        }
                    }

                    allDialogs.clear();
                    for (int a = 0, size = dialogs_dict.size(); a < size; a++) {
                        TLRPC.Dialog dialog = dialogs_dict.valueAt(a);
                        if (deletingDialogs.indexOfKey(dialog.id) >= 0) {
                            continue;
                        }
                        allDialogs.add(dialog);
                    }
                    sortDialogs(null);
                    getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                }
                if (remote != 0) {
                    getUserConfig().filtersLoaded = true;
                    getUserConfig().saveConfig(false);
                    loadingRemoteFilters = false;
                    getNotificationCenter().postNotificationName(NotificationCenter.filterSettingsUpdated);
                }

                lockFiltersInternal();

                if (onDone != null) {
                    onDone.run();
                }
            });
        });
    }

    public void loadSuggestedFilters() {
        if (loadingSuggestedFilters) {
            return;
        }
        loadingSuggestedFilters = true;

        TLRPC.TL_messages_getSuggestedDialogFilters req = new TLRPC.TL_messages_getSuggestedDialogFilters();
        getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> {
            loadingSuggestedFilters = false;
            suggestedFilters.clear();
            if (response instanceof Vector) {
                suggestedFilters.addAll(((Vector<TLRPC.TL_dialogFilterSuggested>) response).objects);
            }
            getNotificationCenter().postNotificationName(NotificationCenter.suggestedFiltersLoaded);
        }));
    }

    private Utilities.Callback<Boolean> onLoadedRemoteFilters;

    public void loadRemoteFilters(boolean force) {
        loadRemoteFilters(force, null);
    }

    public void loadRemoteFilters(boolean force, Utilities.Callback<Boolean> whenDone) {
        if (whenDone != null) {
            onLoadedRemoteFilters = whenDone;
        }
        if (loadingRemoteFilters || !getUserConfig().isClientActivated() || !force && getUserConfig().filtersLoaded) {
            return;
        }
        if (force) {
            getUserConfig().filtersLoaded = false;
            getUserConfig().saveConfig(false);
        }
        TLRPC.TL_messages_getDialogFilters req = new TLRPC.TL_messages_getDialogFilters();
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response instanceof Vector) {
                ArrayList<TLRPC.DialogFilter> filters = new ArrayList<>();
                Vector vector = (Vector) response;
                for (int i = 0; i < vector.objects.size(); ++i) {
                    filters.add((TLRPC.DialogFilter) vector.objects.get(i));
                }
                getMessagesStorage().checkLoadedRemoteFilters(filters, () -> {
                    if (onLoadedRemoteFilters != null) {
                        onLoadedRemoteFilters.run(true);
                        onLoadedRemoteFilters = null;
                    }
                });
            } else if (response instanceof TLRPC.TL_messages_dialogFilters) {
                TLRPC.TL_messages_dialogFilters res = (TLRPC.TL_messages_dialogFilters) response;
                if (folderTags != res.tags_enabled) {
                    setFolderTags(res.tags_enabled);
                    AndroidUtilities.runOnUIThread(() -> {
                        getNotificationCenter().postNotificationName(NotificationCenter.dialogFiltersUpdated);
                    });
                }
                getMessagesStorage().checkLoadedRemoteFilters(res.filters, () -> {
                    if (onLoadedRemoteFilters != null) {
                        onLoadedRemoteFilters.run(true);
                        onLoadedRemoteFilters = null;
                    }
                });
            } else {
                AndroidUtilities.runOnUIThread(() -> {
                    loadingRemoteFilters = false;
                    if (onLoadedRemoteFilters != null) {
                        onLoadedRemoteFilters.run(false);
                        onLoadedRemoteFilters = null;
                    }
                });
            }
        });
    }

    private boolean loggedDeviceStats;
    public void logDeviceStats() {
        if (collectDeviceStats && !loggedDeviceStats) {
            ArrayList<File> storageDirs = AndroidUtilities.getRootDirs();
            if (!storageDirs.isEmpty()) {
                String dir = storageDirs.get(0).getAbsolutePath();
                if (!TextUtils.isEmpty(SharedConfig.storageCacheDir)) {
                    for (int a = 0, N = storageDirs.size(); a < N; a++) {
                        String path = storageDirs.get(a).getAbsolutePath();
                        if (path.startsWith(SharedConfig.storageCacheDir)) {
                            dir = path;
                            break;
                        }
                    }
                }
                final boolean value = dir.contains("/storage/emulated/");

                TLRPC.TL_help_saveAppLog req = new TLRPC.TL_help_saveAppLog();
                TLRPC.TL_inputAppEvent event = new TLRPC.TL_inputAppEvent();
                event.time = getConnectionsManager().getCurrentTime();
                event.type = "android_sdcard_exists";
                TLRPC.TL_jsonBool bool = new TLRPC.TL_jsonBool();
                bool.value = value;
                event.data = bool;
                event.peer = value ? 1 : 0;
                req.events.add(event);

                getConnectionsManager().sendRequest(req, (response, error) -> {});
            }
            loggedDeviceStats = true;
        }
    }

    public void selectDialogFilter(DialogFilter filter, int index) {
        if (selectedDialogFilter[index] == filter) {
            return;
        }
        DialogFilter prevFilter = selectedDialogFilter[index];
        selectedDialogFilter[index] = filter;
        if (selectedDialogFilter[index == 0 ? 1 : 0] == filter) {
            selectedDialogFilter[index == 0 ? 1 : 0] = null;
        }
        if (selectedDialogFilter[index] == null) {
            if (prevFilter != null) {
                prevFilter.dialogs.clear();
                prevFilter.dialogsForward.clear();
            }
        } else {
            sortDialogs(null);
        }
    }

    public void onFilterUpdate(DialogFilter filter) {
        for (int a = 0; a < 2; a++) {
            if (selectedDialogFilter[a] == filter) {
                sortDialogs(null);
                getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload, true);
                break;
            }
        }
    }

    public void addFilter(DialogFilter filter, boolean atBegin) {
        if (atBegin) {
            int order = 254;
            for (int a = 0, N = dialogFilters.size(); a < N; a++) {
                order = Math.min(order, dialogFilters.get(a).order);
            }
            filter.order = order - 1;
            if (dialogFilters.get(0).isDefault()) {
                dialogFilters.add(1, filter);
            } else {
                dialogFilters.add(0, filter);
            }
        } else {
            int order = 0;
            for (int a = 0, N = dialogFilters.size(); a < N; a++) {
                order = Math.max(order, dialogFilters.get(a).order);
            }
            filter.order = order + 1;
            dialogFilters.add(filter);
        }
        dialogFiltersById.put(filter.id, filter);
        if (dialogFilters.size() == 1 && SharedConfig.getChatSwipeAction(currentAccount) != SwipeGestureSettingsView.SWIPE_GESTURE_FOLDERS) {
            SharedConfig.updateChatListSwipeSetting(SwipeGestureSettingsView.SWIPE_GESTURE_FOLDERS);
        }
        lockFiltersInternal();
    }

    public static TLRPC.TL_emojiStatusCollectible emojiStatusCollectibleFromGift(TL_stars.TL_starGiftUnique gift) {
        final TLRPC.TL_emojiStatusCollectible status = new TLRPC.TL_emojiStatusCollectible();
        status.collectible_id = gift.id;
        final TL_stars.starGiftAttributeModel model = findAttribute(gift.attributes, TL_stars.starGiftAttributeModel.class);
        final TL_stars.starGiftAttributeBackdrop backdrop = findAttribute(gift.attributes, TL_stars.starGiftAttributeBackdrop.class);
        final TL_stars.starGiftAttributePattern pattern = findAttribute(gift.attributes, TL_stars.starGiftAttributePattern.class);
        status.title = gift.title + " #" + gift.num;
        if (model != null) {
            status.document_id = model.document.id;
        }
        if (pattern != null) {
            status.pattern_document_id = pattern.document.id;
        }
        if (backdrop != null) {
            status.center_color = backdrop.center_color;
            status.edge_color = backdrop.edge_color;
            status.text_color = backdrop.text_color;
            status.pattern_color = backdrop.pattern_color;
        }
        return status;
    }

    public void updateEmojiStatus(TLRPC.EmojiStatus newStatus) {
        updateEmojiStatus(newStatus, null);
    }
    public void updateEmojiStatus(TLRPC.EmojiStatus newStatus, TL_stars.StarGift gift) {
        updateEmojiStatus(0, newStatus, gift);
    }

    public void updateEmojiStatus(long dialogId, TLRPC.EmojiStatus newStatus, TL_stars.StarGift gift) {
        final boolean myself = dialogId == 0 || dialogId == getUserConfig().getClientUserId();
        TLRPC.EmojiStatus new_emoji_status = newStatus;
        if (new_emoji_status instanceof TLRPC.TL_inputEmojiStatusCollectible && gift instanceof TL_stars.TL_starGiftUnique) {
            new_emoji_status = emojiStatusCollectibleFromGift((TL_stars.TL_starGiftUnique) gift);
        }

        TLObject r;
        if (myself) {
            TL_account.updateEmojiStatus req = new TL_account.updateEmojiStatus();
            req.emoji_status = newStatus;
            r = req;

            TLRPC.User user = getUserConfig().getCurrentUser();
            if (user != null) {
                user.emoji_status = new_emoji_status;
                getNotificationCenter().postNotificationName(NotificationCenter.userEmojiStatusUpdated, user);
            }
        } else {
            TLRPC.TL_channels_updateEmojiStatus req = new TLRPC.TL_channels_updateEmojiStatus();
            req.channel = getInputChannel(-dialogId);
            req.emoji_status = newStatus;
            r = req;

            TLRPC.Chat chat = getChat(-dialogId);
            if (chat != null) {
                chat.flags |= 512;
                chat.emoji_status = new_emoji_status;
                putChat(chat, true);
            }
        }
        getMessagesController().updateEmojiStatusUntilUpdate(dialogId, new_emoji_status);
        getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, MessagesController.UPDATE_MASK_EMOJI_STATUS);
        getConnectionsManager().sendRequest(r, null);
    }

    public void removeFilter(DialogFilter filter) {
        dialogFilters.remove(filter);
        dialogFiltersById.remove(filter.id);
        getNotificationCenter().postNotificationName(NotificationCenter.dialogFiltersUpdated);
    }

    private Runnable loadAppConfigRunnable = this::loadAppConfig;

    public void loadAppConfig() {
        loadAppConfig(true);
    }

    public void loadAppConfig(boolean force) {
        AndroidUtilities.cancelRunOnUIThread(loadAppConfigRunnable);
        if (force) {
            appConfigFetcher.forceRequest(currentAccount, 0);
        }
        appConfigFetcher.fetch(currentAccount, 0, config -> AndroidUtilities.runOnUIThread(() -> {
            if (config != null && config.config instanceof TLRPC.TL_jsonObject) {
                applyAppConfig((TLRPC.TL_jsonObject) config.config);
            }
            AndroidUtilities.cancelRunOnUIThread(loadAppConfigRunnable);
            AndroidUtilities.runOnUIThread(loadAppConfigRunnable, 4 * 60 * 1000 + 10);
        }));
    }

    private void applyAppConfig(TLRPC.TL_jsonObject object) {
        SharedPreferences.Editor editor = mainPreferences.edit();
        boolean changed = false;
        boolean storiesChanged = false;
        boolean keelAliveChanged = false;
        resetAppConfig();
        TLRPC.TL_jsonObject liteAppOptions = null;
        int transcribeAudioTrialWeeklyNumber = 0;
        int transcribeAudioTrialCooldownUntil = 0;

        changed = config.apply(editor, object);

        for (int a = 0, N = object.value.size(); a < N; a++) {
            TLRPC.TL_jsonObjectValue value = object.value.get(a);
            switch (value.key) {
                case "boosts_per_sent_gift": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        long val = (long) ((TLRPC.TL_jsonNumber) value.value).value;
                        if (val != boostsPerSentGift) {
                            boostsPerSentGift = val;
                            editor.putLong("boosts_per_sent_gift", boostsPerSentGift);
                            changed = true;
                        }
                    }
                    break;
                }
                case "giveaway_boosts_per_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        long val = (long) ((TLRPC.TL_jsonNumber) value.value).value;
                        if (val != giveawayBoostsPerPremium) {
                            giveawayBoostsPerPremium = val;
                            editor.putLong("giveaway_boosts_per_premium", giveawayBoostsPerPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "giveaway_period_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        long val = (long) ((TLRPC.TL_jsonNumber) value.value).value;
                        if (val != giveawayPeriodMax) {
                            giveawayPeriodMax = val;
                            editor.putLong("giveaway_period_max", giveawayPeriodMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "giveaway_add_peers_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        long val = (long) ((TLRPC.TL_jsonNumber) value.value).value;
                        if (val != giveawayAddPeersMax) {
                            giveawayAddPeersMax = val;
                            editor.putLong("giveaway_add_peers_max", giveawayAddPeersMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "giveaway_countries_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        long val = (long) ((TLRPC.TL_jsonNumber) value.value).value;
                        if (val != giveawayCountriesMax) {
                            giveawayCountriesMax = val;
                            editor.putLong("giveaway_countries_max", giveawayCountriesMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stories_changelog_user_id": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        storiesChangelogUserId = (long) ((TLRPC.TL_jsonNumber) value.value).value;
                        editor.putLong("stories_changelog_user_id", storiesChangelogUserId);
                    }
                    break;
                }
                case "stories_stealth_future_period": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        stealthModeFuture = (int) ((TLRPC.TL_jsonNumber) value.value).value;
                        editor.putInt("stories_stealth_future_period", stealthModeFuture);
                    }
                    break;
                }
                case "stories_stealth_past_period": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        stealthModePast = (int) ((TLRPC.TL_jsonNumber) value.value).value;
                        editor.putInt("stories_stealth_past_period", stealthModePast);
                    }
                    break;
                }
                case "stories_stealth_cooldown_period": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        stealthModeCooldown = (int) ((TLRPC.TL_jsonNumber) value.value).value;
                        editor.putInt("stories_stealth_cooldown_period", stealthModeCooldown);
                    }
                    break;
                }
                case "large_queue_max_active_operations_count": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        largeQueueMaxActiveOperations = (int) ((TLRPC.TL_jsonNumber) value.value).value;
                        editor.putInt("largeQueueMaxActiveOperations", largeQueueMaxActiveOperations);
                    }
                    break;
                }
                case "small_queue_max_active_operations_count": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        smallQueueMaxActiveOperations = (int) ((TLRPC.TL_jsonNumber) value.value).value;
                        editor.putInt("smallQueueMaxActiveOperations", smallQueueMaxActiveOperations);
                    }
                    break;
                }
                case "premium_gift_text_field_icon": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        if (giftTextFieldIcon != ((TLRPC.TL_jsonBool) value.value).value) {
                            giftTextFieldIcon = ((TLRPC.TL_jsonBool) value.value).value;
                            editor.putBoolean("giftTextFieldIcon", giftTextFieldIcon);
                            changed = true;

                            NotificationCenter.getInstance(currentAccount).postNotificationName(NotificationCenter.didUpdatePremiumGiftFieldIcon);
                        }
                    }
                    break;
                }
                case "premium_gift_attach_menu_icon": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        if (giftAttachMenuIcon != ((TLRPC.TL_jsonBool) value.value).value) {
                            giftAttachMenuIcon = ((TLRPC.TL_jsonBool) value.value).value;
                            editor.putBoolean("giftAttachMenuIcon", giftAttachMenuIcon);
                            changed = true;
                        }
                    }
                    break;
                }
                case "lite_app_options": {
                    if (value.value instanceof TLRPC.TL_jsonObject) {
                        liteAppOptions = (TLRPC.TL_jsonObject) value.value;
                    }
                    break;
                }
                case "lite_device_class": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        int performanceClass = (int) ((TLRPC.TL_jsonNumber) value.value).value;
                        if (performanceClass > 0) {
                            SharedConfig.overrideDevicePerformanceClass(performanceClass - 1);
                        }
                    }
                    break;
                }
                case "upload_markup_video": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        if (uploadMarkupVideo != ((TLRPC.TL_jsonBool) value.value).value) {
                            uploadMarkupVideo = ((TLRPC.TL_jsonBool) value.value).value;
                            editor.putBoolean("uploadMarkupVideo", uploadMarkupVideo);
                            changed = true;
                        }
                    }
                    break;
                }
                case "login_google_oauth_client_id": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        String str = ((TLRPC.TL_jsonString) value.value).value;
                        /*if (!Objects.equals(BuildVars.GOOGLE_AUTH_CLIENT_ID, str)) {
                            BuildVars.GOOGLE_AUTH_CLIENT_ID = str;
                            editor.putString("googleAuthClientId", BuildVars.GOOGLE_AUTH_CLIENT_ID);
                            changed = true;
                        }*/
                    }
                    break;
                }
                case "premium_playmarket_direct_currency_list": {
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        TLRPC.TL_jsonArray arr = (TLRPC.TL_jsonArray) value.value;
                        HashSet<String> currencySet = new HashSet<>();
                        for (TLRPC.JSONValue el : arr.value) {
                            if (el instanceof TLRPC.TL_jsonString) {
                                TLRPC.TL_jsonString currencyEl = (TLRPC.TL_jsonString) el;
                                String currency = currencyEl.value;
                                currencySet.add(currency);
                            }
                        }

                        if (!(directPaymentsCurrency.containsAll(currencySet) && currencySet.containsAll(directPaymentsCurrency))) {
                            directPaymentsCurrency.clear();
                            directPaymentsCurrency.addAll(currencySet);
                            editor.putStringSet("directPaymentsCurrency", currencySet);
                            changed = true;

                            NotificationCenter.getGlobalInstance().postNotificationName(NotificationCenter.billingProductDetailsUpdated);
                        }
                    }
                    break;
                }
                case "premium_purchase_blocked": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        if (premiumLocked != ((TLRPC.TL_jsonBool) value.value).value) {
                            premiumLocked = ((TLRPC.TL_jsonBool) value.value).value;
                            editor.putBoolean("premiumLocked", premiumLocked);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stars_purchase_blocked": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        if (starsLocked != ((TLRPC.TL_jsonBool) value.value).value) {
                            starsLocked = ((TLRPC.TL_jsonBool) value.value).value;
                            editor.putBoolean("starsLocked", starsLocked);
                            changed = true;
                        }
                    }
                    break;
                }
                case "premium_bot_username": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        String string = ((TLRPC.TL_jsonString) value.value).value;
                        if (!string.equals(premiumBotUsername)) {
                            premiumBotUsername = string;
                            editor.putString("premiumBotUsername", premiumBotUsername);
                            changed = true;
                        }
                    }
                    break;
                }
                case "verify_age_bot_username": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        String string = ((TLRPC.TL_jsonString) value.value).value;
                        if (!string.equals(verifyAgeBotUsername)) {
                            verifyAgeBotUsername = string;
                            editor.putString("verifyAgeBotUsername", verifyAgeBotUsername);
                            changed = true;
                        }
                    }
                    break;
                }
                case "verify_age_country": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        String string = ((TLRPC.TL_jsonString) value.value).value;
                        if (!string.equals(verifyAgeCountry)) {
                            verifyAgeCountry = string;
                            editor.putString("verifyAgeCountry", verifyAgeCountry);
                            changed = true;
                        }
                    }
                    break;
                }
                case "verify_age_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        int num = (int) ((TLRPC.TL_jsonNumber) value.value).value;
                        if (num != verifyAgeMin) {
                            editor.putInt("verifyAgeMin", verifyAgeMin = num);
                            changed = true;
                        }
                    }
                    break;
                }
                case "premium_invoice_slug": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        String string = ((TLRPC.TL_jsonString) value.value).value;
                        if (!string.equals(premiumInvoiceSlug)) {
                            premiumInvoiceSlug = string;
                            editor.putString("premiumInvoiceSlug", premiumInvoiceSlug);
                            changed = true;
                        }
                    }
                    break;
                }
                case "premium_promo_order": {
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        TLRPC.TL_jsonArray order = (TLRPC.TL_jsonArray) value.value;
                        changed = savePremiumFeaturesPreviewOrder("premiumFeaturesTypesToPosition", premiumFeaturesTypesToPosition, editor, order.value);
                    }
                    break;
                }
                case "business_promo_order": {
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        TLRPC.TL_jsonArray order = (TLRPC.TL_jsonArray) value.value;
                        changed = savePremiumFeaturesPreviewOrder("businessFeaturesTypesToPosition", businessFeaturesTypesToPosition, editor, order.value);
                    }
                    break;
                }
                case "emojies_animated_zoom": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (animatedEmojisZoom != number.value) {
                            animatedEmojisZoom = (float) number.value;
                            editor.putFloat("animatedEmojisZoom", animatedEmojisZoom);
                            changed = true;
                        }
                    }
                    break;
                }
                case "getfile_experimental_params": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != getfileExperimentalParams) {
                            getfileExperimentalParams = bool.value;
                            editor.putBoolean("getfileExperimentalParams", getfileExperimentalParams);
                            changed = true;
                        }
                    }
                    break;
                }
                case "smsjobs_sticky_notification_enabled": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != smsjobsStickyNotificationEnabled) {
                            smsjobsStickyNotificationEnabled = bool.value;
                            editor.putBoolean("smsjobsStickyNotificationEnabled", smsjobsStickyNotificationEnabled);
                            changed = true;
                        }
                    }
                    break;
                }
                case "dialog_filters_enabled": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != filtersEnabled) {
                            filtersEnabled = bool.value;
                            editor.putBoolean("filtersEnabled", filtersEnabled);
                            changed = true;
                        }
                    }
                    break;
                }
                case "dialog_filters_tooltip": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != showFiltersTooltip) {
                            showFiltersTooltip = bool.value;
                            editor.putBoolean("showFiltersTooltip", showFiltersTooltip);
                            changed = true;
                            getNotificationCenter().postNotificationName(NotificationCenter.filterSettingsUpdated);
                        }
                    }
                    break;
                }
                case "youtube_pip": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        TLRPC.TL_jsonString string = (TLRPC.TL_jsonString) value.value;
                        if (!string.value.equals(youtubePipType)) {
                            youtubePipType = string.value;
                            editor.putString("youtubePipType", youtubePipType);
                            changed = true;
                        }
                    }
                    break;
                }
                case "background_connection": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != backgroundConnection) {
                            backgroundConnection = bool.value;
                            editor.putBoolean("backgroundConnection", backgroundConnection);
                            changed = true;
                            keelAliveChanged = true;
                        }
                    }
                    break;
                }
                case "keep_alive_service": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != keepAliveService) {
                            keepAliveService = bool.value;
                            editor.putBoolean("keepAliveService", keepAliveService);
                            changed = true;
                            keelAliveChanged = true;
                        }
                    }
                    break;
                }
                case "qr_login_camera": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != qrLoginCamera) {
                            qrLoginCamera = bool.value;
                            editor.putBoolean("qrLoginCamera", qrLoginCamera);
                            changed = true;
                        }
                    }
                    break;
                }
                case "save_gifs_with_stickers": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != saveGifsWithStickers) {
                            saveGifsWithStickers = bool.value;
                            editor.putBoolean("saveGifsWithStickers", saveGifsWithStickers);
                            changed = true;
                        }
                    }
                    break;
                }
                case "url_auth_domains": {
                    HashSet<String> newDomains = new HashSet<>();
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        TLRPC.TL_jsonArray array = (TLRPC.TL_jsonArray) value.value;
                        for (int b = 0, N2 = array.value.size(); b < N2; b++) {
                            TLRPC.JSONValue val = array.value.get(b);
                            if (val instanceof TLRPC.TL_jsonString) {
                                TLRPC.TL_jsonString string = (TLRPC.TL_jsonString) val;
                                newDomains.add(string.value);
                            }
                        }
                    }
                    if (!authDomains.equals(newDomains)) {
                        authDomains = newDomains;
                        editor.putStringSet("authDomains", authDomains);
                        changed = true;
                    }
                    break;
                }
                case "autologin_domains": {
                    HashSet<String> newDomains = new HashSet<>();
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        TLRPC.TL_jsonArray array = (TLRPC.TL_jsonArray) value.value;
                        for (int b = 0, N2 = array.value.size(); b < N2; b++) {
                            TLRPC.JSONValue val = array.value.get(b);
                            if (val instanceof TLRPC.TL_jsonString) {
                                TLRPC.TL_jsonString string = (TLRPC.TL_jsonString) val;
                                newDomains.add(string.value);
                            }
                        }
                    }
                    if (!autologinDomains.equals(newDomains)) {
                        autologinDomains = newDomains;
                        editor.putStringSet("autologinDomains", autologinDomains);
                        changed = true;
                    }
                    break;
                }
                case "emojies_send_dice": {
                    HashSet<String> newEmojies = new HashSet<>();
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        TLRPC.TL_jsonArray array = (TLRPC.TL_jsonArray) value.value;
                        for (int b = 0, N2 = array.value.size(); b < N2; b++) {
                            TLRPC.JSONValue val = array.value.get(b);
                            if (val instanceof TLRPC.TL_jsonString) {
                                TLRPC.TL_jsonString string = (TLRPC.TL_jsonString) val;
                                newEmojies.add(string.value.replace("\uFE0F", ""));
                            }
                        }
                    }
                    if (!diceEmojies.equals(newEmojies)) {
                        diceEmojies = newEmojies;
                        editor.putStringSet("diceEmojies", diceEmojies);
                        changed = true;
                    }
                    break;
                }
                case "gif_search_emojies": {
                    ArrayList<String> newEmojies = new ArrayList<>();
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        TLRPC.TL_jsonArray array = (TLRPC.TL_jsonArray) value.value;
                        for (int b = 0, N2 = array.value.size(); b < N2; b++) {
                            TLRPC.JSONValue val = array.value.get(b);
                            if (val instanceof TLRPC.TL_jsonString) {
                                TLRPC.TL_jsonString string = (TLRPC.TL_jsonString) val;
                                newEmojies.add(string.value.replace("\uFE0F", ""));
                            }
                        }
                    }
                    if (!gifSearchEmojies.equals(newEmojies)) {
                        gifSearchEmojies = newEmojies;
                        SerializedData serializedData = new SerializedData();
                        serializedData.writeInt32(gifSearchEmojies.size());
                        for (int b = 0, N2 = gifSearchEmojies.size(); b < N2; b++) {
                            serializedData.writeString(gifSearchEmojies.get(b));
                        }
                        editor.putString("gifSearchEmojies", Base64.encodeToString(serializedData.toByteArray(), Base64.DEFAULT));
                        serializedData.cleanup();
                        changed = true;
                    }
                    break;
                }
                case "emojies_send_dice_success": {
                    try {
                        HashMap<String, DiceFrameSuccess> newEmojies = new HashMap<>();
                        if (value.value instanceof TLRPC.TL_jsonObject) {
                            TLRPC.TL_jsonObject jsonObject = (TLRPC.TL_jsonObject) value.value;
                            for (int b = 0, N2 = jsonObject.value.size(); b < N2; b++) {
                                TLRPC.TL_jsonObjectValue val = jsonObject.value.get(b);
                                if (val.value instanceof TLRPC.TL_jsonObject) {
                                    TLRPC.TL_jsonObject jsonObject2 = (TLRPC.TL_jsonObject) val.value;
                                    int n = Integer.MAX_VALUE;
                                    int f = Integer.MAX_VALUE;
                                    for (int c = 0, N3 = jsonObject2.value.size(); c < N3; c++) {
                                        TLRPC.TL_jsonObjectValue val2 = jsonObject2.value.get(c);
                                        if (val2.value instanceof TLRPC.TL_jsonNumber) {
                                            if ("value".equals(val2.key)) {
                                                n = (int) ((TLRPC.TL_jsonNumber) val2.value).value;
                                            } else if ("frame_start".equals(val2.key)) {
                                                f = (int) ((TLRPC.TL_jsonNumber) val2.value).value;
                                            }
                                        }
                                    }
                                    if (f != Integer.MAX_VALUE && n != Integer.MAX_VALUE) {
                                        newEmojies.put(val.key.replace("\uFE0F", ""), new DiceFrameSuccess(f, n));
                                    }
                                }
                            }
                        }
                        if (!diceSuccess.equals(newEmojies)) {
                            diceSuccess = newEmojies;
                            SerializedData serializedData = new SerializedData();
                            serializedData.writeInt32(diceSuccess.size());
                            for (HashMap.Entry<String, DiceFrameSuccess> entry : diceSuccess.entrySet()) {
                                serializedData.writeString(entry.getKey());
                                DiceFrameSuccess frameSuccess = entry.getValue();
                                serializedData.writeInt32(frameSuccess.frame);
                                serializedData.writeInt32(frameSuccess.num);
                            }
                            editor.putString("diceSuccess", Base64.encodeToString(serializedData.toByteArray(), Base64.DEFAULT));
                            serializedData.cleanup();
                            changed = true;
                        }
                    } catch (Exception e) {
                        FileLog.e(e);
                    }
                    break;
                }
                case "autoarchive_setting_available": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != autoarchiveAvailable) {
                            autoarchiveAvailable = bool.value;
                            editor.putBoolean("autoarchiveAvailable", autoarchiveAvailable);
                            changed = true;
                        }
                    }
                    break;
                }
                case "groupcall_video_participants_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != groupCallVideoMaxParticipants) {
                            groupCallVideoMaxParticipants = (int) number.value;
                            editor.putInt("groipCallVideoMaxParticipants", groupCallVideoMaxParticipants);
                            changed = true;
                        }
                    }
                    break;
                }
                case "chat_read_mark_size_threshold": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != chatReadMarkSizeThreshold) {
                            chatReadMarkSizeThreshold = (int) number.value;
                            editor.putInt("chatReadMarkSizeThreshold", chatReadMarkSizeThreshold);
                            changed = true;
                        }
                    }
                    break;
                }
                case "chat_read_mark_expire_period": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != chatReadMarkExpirePeriod) {
                            chatReadMarkExpirePeriod = (int) number.value;
                            editor.putInt("chatReadMarkExpirePeriod", chatReadMarkExpirePeriod);
                            changed = true;
                        }
                    }
                    break;
                }
                case "pm_read_date_expire_period": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != pmReadDateExpirePeriod) {
                            pmReadDateExpirePeriod = (int) number.value;
                            editor.putInt("pmReadDateExpirePeriod", pmReadDateExpirePeriod);
                            changed = true;
                        }
                    }
                    break;
                }
                case "inapp_update_check_delay": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != updateCheckDelay) {
                            updateCheckDelay = (int) number.value;
                            editor.putInt("updateCheckDelay", updateCheckDelay);
                            changed = true;
                        }
                    } else if (value.value instanceof TLRPC.TL_jsonString) {
                        TLRPC.TL_jsonString number = (TLRPC.TL_jsonString) value.value;
                        int delay = Utilities.parseInt(number.value);
                        if (delay != updateCheckDelay) {
                            updateCheckDelay = delay;
                            editor.putInt("updateCheckDelay", updateCheckDelay);
                            changed = true;
                        }
                    }
                    break;
                }
                case "round_video_encoding": {
                    if (value.value instanceof TLRPC.TL_jsonObject) {
                        TLRPC.TL_jsonObject jsonObject = (TLRPC.TL_jsonObject) value.value;
                        for (int b = 0, N2 = jsonObject.value.size(); b < N2; b++) {
                            TLRPC.TL_jsonObjectValue value2 = jsonObject.value.get(b);
                            switch (value2.key) {
                                case "diameter": {
                                    if (value2.value instanceof TLRPC.TL_jsonNumber) {
                                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value2.value;
                                        if (number.value != roundVideoSize) {
                                            roundVideoSize = (int) number.value;
                                            editor.putInt("roundVideoSize", roundVideoSize);
                                            changed = true;
                                        }
                                    }
                                    break;
                                }
                                case "video_bitrate": {
                                    if (value2.value instanceof TLRPC.TL_jsonNumber) {
                                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value2.value;
                                        if (number.value != roundVideoBitrate) {
                                            roundVideoBitrate = (int) number.value;
                                            editor.putInt("roundVideoBitrate", roundVideoBitrate);
                                            changed = true;
                                        }
                                    }
                                    break;
                                }
                                case "audio_bitrate": {
                                    if (value2.value instanceof TLRPC.TL_jsonNumber) {
                                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value2.value;
                                        if (number.value != roundAudioBitrate) {
                                            roundAudioBitrate = (int) number.value;
                                            editor.putInt("roundAudioBitrate", roundAudioBitrate);
                                            changed = true;
                                        }
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    break;
                }
                case "stickers_emoji_suggest_only_api": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != suggestStickersApiOnly) {
                            suggestStickersApiOnly = bool.value;
                            editor.putBoolean("suggestStickersApiOnly", suggestStickersApiOnly);
                            changed = true;
                        }
                    }
                    break;
                }
                case "export_regex": {
                    HashSet<String> newExport = new HashSet<>();
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        TLRPC.TL_jsonArray array = (TLRPC.TL_jsonArray) value.value;
                        for (int b = 0, N2 = array.value.size(); b < N2; b++) {
                            TLRPC.JSONValue val = array.value.get(b);
                            if (val instanceof TLRPC.TL_jsonString) {
                                TLRPC.TL_jsonString string = (TLRPC.TL_jsonString) val;
                                newExport.add(string.value);
                            }
                        }
                    }
                    if (!exportUri.equals(newExport)) {
                        exportUri = newExport;
                        editor.putStringSet("exportUri2", exportUri);
                        changed = true;
                    }
                    break;
                }
                case "export_group_urls": {
                    HashSet<String> newExport = new HashSet<>();
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        TLRPC.TL_jsonArray array = (TLRPC.TL_jsonArray) value.value;
                        for (int b = 0, N2 = array.value.size(); b < N2; b++) {
                            TLRPC.JSONValue val = array.value.get(b);
                            if (val instanceof TLRPC.TL_jsonString) {
                                TLRPC.TL_jsonString string = (TLRPC.TL_jsonString) val;
                                newExport.add(string.value);
                            }
                        }
                    }
                    if (!exportGroupUri.equals(newExport)) {
                        exportGroupUri = newExport;
                        editor.putStringSet("exportGroupUri", exportGroupUri);
                        changed = true;
                    }
                    break;
                }
                case "export_private_urls": {
                    HashSet<String> newExport = new HashSet<>();
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        TLRPC.TL_jsonArray array = (TLRPC.TL_jsonArray) value.value;
                        for (int b = 0, N2 = array.value.size(); b < N2; b++) {
                            TLRPC.JSONValue val = array.value.get(b);
                            if (val instanceof TLRPC.TL_jsonString) {
                                TLRPC.TL_jsonString string = (TLRPC.TL_jsonString) val;
                                newExport.add(string.value);
                            }
                        }
                    }
                    if (!exportPrivateUri.equals(newExport)) {
                        exportPrivateUri = newExport;
                        editor.putStringSet("exportPrivateUri", exportPrivateUri);
                        changed = true;
                    }
                    break;
                }
                case "emojies_sounds": {
                    try {
                        HashMap<String, EmojiSound> newEmojies = new HashMap<>();
                        if (value.value instanceof TLRPC.TL_jsonObject) {
                            TLRPC.TL_jsonObject jsonObject = (TLRPC.TL_jsonObject) value.value;
                            for (int b = 0, N2 = jsonObject.value.size(); b < N2; b++) {
                                TLRPC.TL_jsonObjectValue val = jsonObject.value.get(b);
                                if (val.value instanceof TLRPC.TL_jsonObject) {
                                    TLRPC.TL_jsonObject jsonObject2 = (TLRPC.TL_jsonObject) val.value;
                                    long i = 0;
                                    long ah = 0;
                                    String fr = null;
                                    for (int c = 0, N3 = jsonObject2.value.size(); c < N3; c++) {
                                        TLRPC.TL_jsonObjectValue val2 = jsonObject2.value.get(c);
                                        if (val2.value instanceof TLRPC.TL_jsonString) {
                                            if ("id".equals(val2.key)) {
                                                i = Utilities.parseLong(((TLRPC.TL_jsonString) val2.value).value);
                                            } else if ("access_hash".equals(val2.key)) {
                                                ah = Utilities.parseLong(((TLRPC.TL_jsonString) val2.value).value);
                                            } else if ("file_reference_base64".equals(val2.key)) {
                                                fr = ((TLRPC.TL_jsonString) val2.value).value;
                                            }
                                        }
                                    }
                                    if (i != 0 && ah != 0 && fr != null) {
                                        newEmojies.put(val.key.replace("\uFE0F", ""), new EmojiSound(i, ah, fr));
                                    }
                                }
                            }
                        }
                        if (!emojiSounds.equals(newEmojies)) {
                            emojiSounds = newEmojies;
                            SerializedData serializedData = new SerializedData();
                            serializedData.writeInt32(emojiSounds.size());
                            for (HashMap.Entry<String, EmojiSound> entry : emojiSounds.entrySet()) {
                                serializedData.writeString(entry.getKey());
                                EmojiSound emojiSound = entry.getValue();
                                serializedData.writeInt64(emojiSound.id);
                                serializedData.writeInt64(emojiSound.accessHash);
                                serializedData.writeByteArray(emojiSound.fileReference);
                            }
                            editor.putString("emojiSounds", Base64.encodeToString(serializedData.toByteArray(), Base64.DEFAULT));
                            serializedData.cleanup();
                            changed = true;
                        }
                    } catch (Exception e) {
                        FileLog.e(e);
                    }
                    break;
                }
                case "ringtone_size_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != ringtoneSizeMax) {
                            ringtoneSizeMax = (int) number.value;
                            editor.putInt("ringtoneSizeMax", ringtoneSizeMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "ringtone_duration_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != ringtoneDurationMax) {
                            ringtoneDurationMax = (int) number.value;
                            editor.putInt("ringtoneDurationMax", ringtoneDurationMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "channels_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != channelsLimitDefault) {
                            channelsLimitDefault = (int) number.value;
                            editor.putInt("channelsLimitDefault", channelsLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "channels_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != channelsLimitPremium) {
                            channelsLimitPremium = (int) number.value;
                            editor.putInt("channelsLimitPremium", channelsLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "saved_gifs_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != savedGifsLimitDefault) {
                            savedGifsLimitDefault = (int) number.value;
                            editor.putInt("savedGifsLimitDefault", savedGifsLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "saved_gifs_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != savedGifsLimitPremium) {
                            savedGifsLimitPremium = (int) number.value;
                            editor.putInt("savedGifsLimitPremium", savedGifsLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stickers_faved_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != stickersFavedLimitDefault) {
                            stickersFavedLimitDefault = (int) number.value;
                            editor.putInt("stickersFavedLimitDefault", stickersFavedLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stickers_faved_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != stickersFavedLimitPremium) {
                            stickersFavedLimitPremium = (int) number.value;
                            editor.putInt("stickersFavedLimitPremium", stickersFavedLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "pinned_dialogs_count_max_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != maxPinnedDialogsCountDefault) {
                            maxPinnedDialogsCountDefault = (int) number.value;
                            editor.putInt("maxPinnedDialogsCountDefault", maxPinnedDialogsCountDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "pinned_dialogs_count_max_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != maxPinnedDialogsCountPremium) {
                            maxPinnedDialogsCountPremium = (int) number.value;
                            editor.putInt("maxPinnedDialogsCountPremium", maxPinnedDialogsCountPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "dialog_filters_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != dialogFiltersLimitDefault) {
                            dialogFiltersLimitDefault = (int) number.value;
                            editor.putInt("dialogFiltersLimitDefault", dialogFiltersLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "dialog_filters_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != dialogFiltersLimitPremium) {
                            dialogFiltersLimitPremium = (int) number.value;
                            editor.putInt("dialogFiltersLimitPremium", dialogFiltersLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "dialog_filters_chats_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != dialogFiltersChatsLimitDefault) {
                            dialogFiltersChatsLimitDefault = (int) number.value;
                            editor.putInt("dialogFiltersChatsLimitDefault", dialogFiltersChatsLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "dialog_filters_chats_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != dialogFiltersChatsLimitPremium) {
                            dialogFiltersChatsLimitPremium = (int) number.value;
                            editor.putInt("dialogFiltersChatsLimitPremium", dialogFiltersChatsLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "dialog_filters_pinned_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != dialogFiltersPinnedLimitDefault) {
                            dialogFiltersPinnedLimitDefault = (int) number.value;
                            editor.putInt("dialogFiltersPinnedLimitDefault", dialogFiltersPinnedLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "dialog_filters_pinned_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != dialogFiltersPinnedLimitPremium) {
                            dialogFiltersPinnedLimitPremium = (int) number.value;
                            editor.putInt("dialogFiltersPinnedLimitPremium", dialogFiltersPinnedLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "upload_max_fileparts_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != uploadMaxFileParts) {
                            uploadMaxFileParts = (int) number.value;
                            editor.putInt("uploadMaxFileParts", uploadMaxFileParts);
                            changed = true;
                        }
                    }
                    break;
                }
                case "upload_max_fileparts_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != uploadMaxFilePartsPremium) {
                            uploadMaxFilePartsPremium = (int) number.value;
                            editor.putInt("uploadMaxFilePartsPremium", uploadMaxFilePartsPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "channels_public_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != publicLinksLimitDefault) {
                            publicLinksLimitDefault = (int) number.value;
                            editor.putInt("publicLinksLimit", publicLinksLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "channels_public_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != publicLinksLimitPremium) {
                            publicLinksLimitPremium = (int) number.value;
                            editor.putInt("publicLinksLimitPremium", publicLinksLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "caption_length_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != captionLengthLimitDefault) {
                            captionLengthLimitDefault = (int) number.value;
                            editor.putInt("captionLengthLimitDefault", captionLengthLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "caption_length_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != captionLengthLimitPremium) {
                            captionLengthLimitPremium = (int) number.value;
                            editor.putInt("captionLengthLimitPremium", captionLengthLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "story_caption_length_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != storyCaptionLengthLimitDefault) {
                            storyCaptionLengthLimitDefault = (int) number.value;
                            editor.putInt("storyCaptionLengthLimit", storyCaptionLengthLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "story_caption_length_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != storyCaptionLengthLimitPremium) {
                            storyCaptionLengthLimitPremium = (int) number.value;
                            editor.putInt("storyCaptionLengthLimitPremium", storyCaptionLengthLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "about_length_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != aboutLengthLimitDefault) {
                            aboutLengthLimitDefault = (int) number.value;
                            editor.putInt("aboutLengthLimitDefault", aboutLengthLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "about_length_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != aboutLengthLimitPremium) {
                            aboutLengthLimitPremium = (int) number.value;
                            editor.putInt("aboutLengthLimitPremium", aboutLengthLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "reactions_user_max_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != reactionsUserMaxDefault) {
                            reactionsUserMaxDefault = (int) number.value;
                            editor.putInt("reactionsUserMaxDefault", reactionsUserMaxDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "reactions_user_max_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != reactionsUserMaxPremium) {
                            reactionsUserMaxPremium = (int) number.value;
                            editor.putInt("reactionsUserMaxPremium", reactionsUserMaxPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "reactions_in_chat_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != reactionsInChatMax) {
                            reactionsInChatMax = (int) number.value;
                            editor.putInt("reactionsInChatMax", reactionsInChatMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "forum_upgrade_participants_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != forumUpgradeParticipantsMin) {
                            forumUpgradeParticipantsMin = (int) number.value;
                            editor.putInt("forumUpgradeParticipantsMin", forumUpgradeParticipantsMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "topics_pinned_limit": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != topicsPinnedLimit) {
                            topicsPinnedLimit = (int) number.value;
                            editor.putInt("topicsPinnedLimit", topicsPinnedLimit);
                            changed = true;
                        }
                    }
                    break;
                }
                case "telegram_antispam_user_id": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        TLRPC.TL_jsonString string = (TLRPC.TL_jsonString) value.value;
                        try {
                            long number = Long.parseLong(string.value);
                            if (number != telegramAntispamUserId) {
                                telegramAntispamUserId = number;
                                editor.putLong("telegramAntispamUserId", telegramAntispamUserId);
                                changed = true;
                            }
                        } catch (Exception e) {
                            FileLog.e(e);
                        }
                    }
                    break;
                }
                case "telegram_antispam_group_size_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != telegramAntispamGroupSizeMin) {
                            telegramAntispamGroupSizeMin = (int) number.value;
                            editor.putInt("telegramAntispamGroupSizeMin", telegramAntispamGroupSizeMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "hidden_members_group_size_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != hiddenMembersGroupSizeMin) {
                            hiddenMembersGroupSizeMin = (int) number.value;
                            editor.putInt("hiddenMembersGroupSizeMin", hiddenMembersGroupSizeMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "chatlist_update_period": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber number = (TLRPC.TL_jsonNumber) value.value;
                        if (number.value != chatlistUpdatePeriod) {
                            chatlistUpdatePeriod = (int) number.value;
                            editor.putInt("chatlistUpdatePeriod", chatlistUpdatePeriod);
                            changed = true;
                        }
                    }
                    break;
                }
                case "android_collect_device_stats": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != collectDeviceStats) {
                            collectDeviceStats = bool.value;
                            changed = true;
                        }
                    }
                    break;
                }
                case "android_check_reset_langpack": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != checkResetLangpack) {
                            checkResetLangpack = (int) num.value;
                            editor.putInt("checkResetLangpack", checkResetLangpack);
                            LocaleController.getInstance().checkPatchLangpack(currentAccount);
                            changed = true;
                        }
                    }
                    break;
                }
                case "chatlist_invites_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != chatlistInvitesLimitDefault) {
                            chatlistInvitesLimitDefault = (int) num.value;
                            editor.putInt("chatlistInvitesLimitDefault", chatlistInvitesLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "story_expiring_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != storyExpiringLimitDefault) {
                            storyExpiringLimitDefault = (int) num.value;
                            editor.putInt("storyExpiringLimitDefault", storyExpiringLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "story_expiring_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != storyExpiringLimitPremium) {
                            storyExpiringLimitPremium = (int) num.value;
                            editor.putInt("storyExpiringLimitPremium", storyExpiringLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stories_suggested_reactions_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != storiesSuggestedReactionsLimitDefault) {
                            storiesSuggestedReactionsLimitDefault = (int) num.value;
                            editor.putInt("storiesSuggestedReactionsLimitDefault", storiesSuggestedReactionsLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stories_suggested_reactions_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != storiesSuggestedReactionsLimitPremium) {
                            storiesSuggestedReactionsLimitPremium = (int) num.value;
                            editor.putInt("storiesSuggestedReactionsLimitPremium", storiesSuggestedReactionsLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stories_sent_weekly_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != storiesSentWeeklyLimitDefault) {
                            storiesSentWeeklyLimitDefault = (int) num.value;
                            editor.putInt("storiesSentWeeklyLimitDefault", storiesSentWeeklyLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stories_sent_weekly_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != storiesSentWeeklyLimitPremium) {
                            storiesSentWeeklyLimitPremium = (int) num.value;
                            editor.putInt("storiesSentWeeklyLimitPremium", storiesSentWeeklyLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stories_sent_monthly_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != storiesSentMonthlyLimitDefault) {
                            storiesSentMonthlyLimitDefault = (int) num.value;
                            editor.putInt("storiesSentMonthlyLimitDefault", storiesSentMonthlyLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stories_sent_monthly_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != storiesSentMonthlyLimitPremium) {
                            storiesSentMonthlyLimitPremium = (int) num.value;
                            editor.putInt("storiesSentMonthlyLimitPremium", storiesSentMonthlyLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "chatlist_invites_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != chatlistInvitesLimitPremium) {
                            chatlistInvitesLimitPremium = (int) num.value;
                            editor.putInt("chatlistInvitesLimitPremium", chatlistInvitesLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "chatlists_joined_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != chatlistJoinedLimitDefault) {
                            chatlistJoinedLimitDefault = (int) num.value;
                            editor.putInt("chatlistJoinedLimitDefault", chatlistJoinedLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "chatlists_joined_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != chatlistJoinedLimitPremium) {
                            chatlistJoinedLimitPremium = (int) num.value;
                            editor.putInt("chatlistJoinedLimitPremium", chatlistJoinedLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stargifts_message_length_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != stargiftsMessageLengthMax) {
                            stargiftsMessageLengthMax = (int) num.value;
                            editor.putInt("stargiftsMessageLengthMax", stargiftsMessageLengthMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stargifts_convert_period_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != stargiftsConvertPeriodMax) {
                            stargiftsConvertPeriodMax = (int) num.value;
                            editor.putInt("stargiftsConvertPeriodMax", stargiftsConvertPeriodMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "video_ignore_alt_documents": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != videoIgnoreAltDocuments) {
                            videoIgnoreAltDocuments = bool.value;
                            editor.putBoolean("videoIgnoreAltDocuments", videoIgnoreAltDocuments);
                            changed = true;
                        }
                    }
                    break;
                }
                case "bot_fullscreen_blur_disable": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != disableBotFullscreenBlur) {
                            disableBotFullscreenBlur = bool.value;
                            editor.putBoolean("disableBotFullscreenBlur", disableBotFullscreenBlur);
                            changed = true;
                        }
                    }
                    break;
                }
                case "ton_blockchain_explorer_url": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        TLRPC.TL_jsonString str = (TLRPC.TL_jsonString) value.value;
                        if (!TextUtils.equals(str.value, tonBlockchainExplorerUrl)) {
                            tonBlockchainExplorerUrl = str.value;
                            editor.putString("tonBlockchainExplorerUrl", tonBlockchainExplorerUrl);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stars_paid_message_amount_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (starsPaidMessageAmountMax != (long) num.value) {
                            starsPaidMessageAmountMax = (long) num.value;
                            editor.putLong("starsPaidMessageAmountMax", starsPaidMessageAmountMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stars_paid_message_commission_permille": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (starsPaidMessageCommissionPermille != (int) num.value) {
                            starsPaidMessageCommissionPermille = (int) num.value;
                            editor.putInt("starsPaidMessageCommissionPermille", starsPaidMessageCommissionPermille);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stargifts_pinned_to_top_limit": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (stargiftsPinnedToTopLimit != (int) num.value) {
                            stargiftsPinnedToTopLimit = (int) num.value;
                            editor.putInt("stargiftsPinnedToTopLimit", stargiftsPinnedToTopLimit);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stars_paid_messages_available": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool num = (TLRPC.TL_jsonBool) value.value;
                        if (starsPaidMessagesAvailable != num.value) {
                            starsPaidMessagesAvailable = num.value;
                            editor.putBoolean("starsPaidMessagesAvailable", starsPaidMessagesAvailable);
                            changed = true;
                        }
                    }
                    break;
                }
                case "enable_gifts_in_profile": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool num = (TLRPC.TL_jsonBool) value.value;
                        if (enableGiftsInProfile != num.value) {
                            enableGiftsInProfile = num.value;
                            editor.putBoolean("enableGiftsInProfile", enableGiftsInProfile);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stories_posting": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        TLRPC.TL_jsonString str = (TLRPC.TL_jsonString) value.value;
                        if (!TextUtils.equals(str.value, storiesPosting)) {
                            storiesPosting = str.value;
                            editor.putString("storiesPosting", storiesPosting);
                            changed = storiesChanged = true;
                        }
                    }
                    break;
                }
                case "stories_entities": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        TLRPC.TL_jsonString str = (TLRPC.TL_jsonString) value.value;
                        if (!TextUtils.equals(str.value, storiesEntities)) {
                            storiesEntities = str.value;
                            editor.putString("storiesEntities", storiesEntities);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stories_export_nopublic_link": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (storiesExportNopublicLink != bool.value) {
                            storiesExportNopublicLink = bool.value;
                            editor.putBoolean("storiesExportNopublicLink", storiesExportNopublicLink);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stories_venue_search_username": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        TLRPC.TL_jsonString str = (TLRPC.TL_jsonString) value.value;
                        if (!TextUtils.equals(storyVenueSearchBot, str.value)) {
                            storyVenueSearchBot = str.value;
                            editor.putString("storyVenueSearchBot", storyVenueSearchBot);
                            changed = true;
                        }
                    }
                    break;
                }
                case "authorization_autoconfirm_period": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (authorizationAutoconfirmPeriod != num.value) {
                            authorizationAutoconfirmPeriod = (int) num.value;
                            editor.putInt("authorizationAutoconfirmPeriod", authorizationAutoconfirmPeriod);
                            changed = true;
                        }
                    }
                    break;
                }
                case "quote_length_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (quoteLengthMax != num.value) {
                            quoteLengthMax = (int) num.value;
                            editor.putInt("quoteLengthMax", quoteLengthMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "giveaway_gifts_purchase_available": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        if (giveawayGiftsPurchaseAvailable != ((TLRPC.TL_jsonBool) value.value).value) {
                            giveawayGiftsPurchaseAvailable = ((TLRPC.TL_jsonBool) value.value).value;
                            editor.putBoolean("giveawayGiftsPurchaseAvailable", giveawayGiftsPurchaseAvailable);
                            changed = true;
                        }
                    }
                    break;
                }
                case "transcribe_audio_trial_weekly_number": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        transcribeAudioTrialWeeklyNumber = (int) num.value;
                    }
                    break;
                }
                case "transcribe_audio_trial_duration_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (transcribeAudioTrialDurationMax != num.value) {
                            transcribeAudioTrialDurationMax = (int) num.value;
                            editor.putInt("transcribeAudioTrialDurationMax", transcribeAudioTrialDurationMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "transcribe_audio_trial_cooldown_until": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        transcribeAudioTrialCooldownUntil = (int) num.value;
                    }
                    break;
                }
                case "recommended_channels_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (recommendedChannelsLimitDefault != num.value) {
                            recommendedChannelsLimitDefault = (int) num.value;
                            editor.putInt("recommendedChannelsLimitDefault", recommendedChannelsLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "recommended_channels_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (recommendedChannelsLimitPremium != num.value) {
                            recommendedChannelsLimitPremium = (int) num.value;
                            editor.putInt("recommendedChannelsLimitPremium", recommendedChannelsLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "boosts_channel_level_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (boostsChannelLevelMax != num.value) {
                            boostsChannelLevelMax = (int) num.value;
                            editor.putInt("boostsChannelLevelMax", boostsChannelLevelMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "channel_restrict_sponsored_level_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (channelRestrictSponsoredLevelMin != num.value) {
                            channelRestrictSponsoredLevelMin = (int) num.value;
                            editor.putInt("channelRestrictSponsoredLevelMin", channelRestrictSponsoredLevelMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "channel_autotranslation_level_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (channelAutotranslationLevelMin != num.value) {
                            channelAutotranslationLevelMin = (int) num.value;
                            editor.putInt("channelAutotranslationLevelMin", channelAutotranslationLevelMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "channel_bg_icon_level_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != channelBgIconLevelMin) {
                            channelBgIconLevelMin = (int) num.value;
                            editor.putInt("channelBgIconLevelMin", channelBgIconLevelMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "channel_profile_bg_icon_level_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != channelProfileIconLevelMin) {
                            channelProfileIconLevelMin = (int) num.value;
                            editor.putInt("channelProfileIconLevelMin", channelProfileIconLevelMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "channel_emoji_status_level_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != channelEmojiStatusLevelMin) {
                            channelEmojiStatusLevelMin = (int) num.value;
                            editor.putInt("channelEmojiStatusLevelMin", channelEmojiStatusLevelMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "group_custom_wallpaper_level_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != groupCustomWallpaperLevelMin) {
                            groupCustomWallpaperLevelMin = (int) num.value;
                            editor.putInt("groupCustomWallpaperLevelMin", groupCustomWallpaperLevelMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "group_transcribe_level_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != groupTranscribeLevelMin) {
                            groupTranscribeLevelMin = (int) num.value;
                            editor.putInt("groupTranscribeLevelMin", groupTranscribeLevelMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "quick_replies_limit": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != quickRepliesLimit) {
                            quickRepliesLimit = (int) num.value;
                            editor.putInt("quickRepliesLimit", quickRepliesLimit);
                            changed = true;
                        }
                    }
                    break;
                }
                case "quick_reply_messages_limit": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != quickReplyMessagesLimit) {
                            quickReplyMessagesLimit = (int) num.value;
                            editor.putInt("quickReplyMessagesLimit", quickReplyMessagesLimit);
                            changed = true;
                        }
                    }
                    break;
                }
                case "group_wallpaper_level_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != groupWallpaperLevelMin) {
                            groupWallpaperLevelMin = (int) num.value;
                            editor.putInt("groupWallpaperLevelMin", groupWallpaperLevelMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "group_emoji_status_level_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != groupEmojiStatusLevelMin) {
                            groupEmojiStatusLevelMin = (int) num.value;
                            editor.putInt("groupEmojiStatusLevelMin", groupEmojiStatusLevelMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "group_emoji_stickers_level_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != groupEmojiStickersLevelMin) {
                            groupEmojiStickersLevelMin = (int) num.value;
                            editor.putInt("groupEmojiStickersLevelMin", groupEmojiStickersLevelMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "group_profile_bg_icon_level_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != groupProfileBgIconLevelMin) {
                            groupProfileBgIconLevelMin = (int) num.value;
                            editor.putInt("groupProfileBgIconLevelMin", groupProfileBgIconLevelMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "channel_wallpaper_level_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != channelWallpaperLevelMin) {
                            channelWallpaperLevelMin = (int) num.value;
                            editor.putInt("channelWallpaperLevelMin", channelWallpaperLevelMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "channel_custom_wallpaper_level_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != channelCustomWallpaperLevelMin) {
                            channelCustomWallpaperLevelMin = (int) num.value;
                            editor.putInt("channelCustomWallpaperLevelMin", channelCustomWallpaperLevelMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "saved_dialogs_pinned_limit_default": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != savedDialogsPinnedLimitDefault) {
                            savedDialogsPinnedLimitDefault = (int) num.value;
                            editor.putInt("savedDialogsPinnedLimitDefault", savedDialogsPinnedLimitDefault);
                            changed = true;
                        }
                    }
                    break;
                }
                case "saved_dialogs_pinned_limit_premium": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != savedDialogsPinnedLimitPremium) {
                            savedDialogsPinnedLimitPremium = (int) num.value;
                            editor.putInt("savedDialogsPinnedLimitPremium", savedDialogsPinnedLimitPremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "upload_premium_speedup_upload": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (Math.abs(num.value - uploadPremiumSpeedupUpload) >= 0.01f) {
                            uploadPremiumSpeedupUpload = (float) num.value;
                            editor.putFloat("uploadPremiumSpeedupUpload", uploadPremiumSpeedupUpload);
                            changed = true;
                        }
                    }
                    break;
                }
                case "upload_premium_speedup_download": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (Math.abs(num.value - uploadPremiumSpeedupDownload) >= 0.01f) {
                            uploadPremiumSpeedupDownload = (float) num.value;
                            editor.putFloat("uploadPremiumSpeedupDownload", uploadPremiumSpeedupDownload);
                            changed = true;
                        }
                    }
                    break;
                }
                case "upload_premium_speedup_notify_period": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != uploadPremiumSpeedupNotifyPeriod) {
                            uploadPremiumSpeedupNotifyPeriod = (int) num.value;
                            editor.putInt("uploadPremiumSpeedupNotifyPeriod2", uploadPremiumSpeedupNotifyPeriod);
                            changed = true;
                        }
                    }
                    break;
                }
                case "intro_title_length_limit": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != introTitleLengthLimit) {
                            introTitleLengthLimit = (int) num.value;
                            editor.putInt("introTitleLengthLimit", introTitleLengthLimit);
                            changed = true;
                        }
                    }
                    break;
                }
                case "intro_description_length_limit": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != introDescriptionLengthLimit) {
                            introDescriptionLengthLimit = (int) num.value;
                            editor.putInt("introDescriptionLengthLimit", introDescriptionLengthLimit);
                            changed = true;
                        }
                    }
                    break;
                }
                case "business_chat_links_limit": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != businessChatLinksLimit) {
                            businessChatLinksLimit = (int) num.value;
                            editor.putInt("businessChatLinksLimit", businessChatLinksLimit);
                            changed = true;
                        }
                    }
                    break;
                }
                case "channel_revenue_withdrawal_enabled": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool num = (TLRPC.TL_jsonBool) value.value;
                        if (num.value != channelRevenueWithdrawalEnabled) {
                            channelRevenueWithdrawalEnabled = num.value;
                            editor.putBoolean("channelRevenueWithdrawalEnabled", channelRevenueWithdrawalEnabled);
                            changed = true;
                        }
                    }
                    break;
                }
                case "new_noncontact_peers_require_premium_without_ownpremium": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool num = (TLRPC.TL_jsonBool) value.value;
                        if (num.value != newNoncontactPeersRequirePremiumWithoutOwnpremium) {
                            newNoncontactPeersRequirePremiumWithoutOwnpremium = num.value;
                            editor.putBoolean("newNoncontactPeersRequirePremiumWithoutOwnpremium", newNoncontactPeersRequirePremiumWithoutOwnpremium);
                            changed = true;
                        }
                    }
                    break;
                }
                case "reactions_uniq_max": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != reactionsUniqMax) {
                            reactionsUniqMax = (int) num.value;
                            editor.putInt("reactionsUniqMax", reactionsUniqMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "premium_manage_subscription_url": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        TLRPC.TL_jsonString str = (TLRPC.TL_jsonString) value.value;
                        if (!TextUtils.equals(str.value, premiumManageSubscriptionUrl)) {
                            premiumManageSubscriptionUrl = str.value;
                            editor.putString("premiumManageSubscriptionUrl", premiumManageSubscriptionUrl);
                            changed = true;
                        }
                    }
                    break;
                }
                case "android_disable_round_camera2": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != androidDisableRoundCamera2) {
                            androidDisableRoundCamera2 = bool.value;
                            editor.putBoolean("androidDisableRoundCamera2", androidDisableRoundCamera2);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stories_pinned_to_top_count_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != storiesPinnedToTopCountMax) {
                            storiesPinnedToTopCountMax = (int) num.value;
                            editor.putInt("storiesPinnedToTopCountMax", storiesPinnedToTopCountMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "show_annual_per_month": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != showAnnualPerMonth) {
                            showAnnualPerMonth = bool.value;
                            editor.putBoolean("showAnnualPerMonth", showAnnualPerMonth);
                            changed = true;
                        }
                    }
                    break;
                }
                case "can_edit_factcheck": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != canEditFactcheck) {
                            canEditFactcheck = bool.value;
                            editor.putBoolean("canEditFactcheck", canEditFactcheck);
                            changed = true;
                        }
                    }
                    break;
                }
                case "factcheck_length_limit": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if ((int) num.value != factcheckLengthLimit) {
                            factcheckLengthLimit = (int) num.value;
                            editor.putInt("factcheckLengthLimit", factcheckLengthLimit);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stars_revenue_withdrawal_min": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if ((long) num.value != starsRevenueWithdrawalMin) {
                            starsRevenueWithdrawalMin = (long) num.value;
                            editor.putLong("starsRevenueWithdrawalMin", starsRevenueWithdrawalMin);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stars_paid_post_amount_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if ((long) num.value != starsPaidPostAmountMax) {
                            starsPaidPostAmountMax = (long) num.value;
                            editor.putLong("starsPaidPostAmountMax", starsPaidPostAmountMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "bot_preview_medias_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if ((int) num.value != botPreviewMediasMax) {
                            botPreviewMediasMax = (int) num.value;
                            editor.putInt("botPreviewMediasMax", botPreviewMediasMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "ton_proxy_address": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        TLRPC.TL_jsonString str = (TLRPC.TL_jsonString) value.value;
                        if (!TextUtils.equals(str.value, tonProxyAddress)) {
                            tonProxyAddress = str.value;
                            editor.putString("tonProxyAddress", tonProxyAddress);
                            changed = true;
                        }
                    }
                    break;
                }
                case "web_app_allowed_protocols": {
                    HashSet<String> newProtocols = new HashSet<>();
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        TLRPC.TL_jsonArray array = (TLRPC.TL_jsonArray) value.value;
                        for (int b = 0, N2 = array.value.size(); b < N2; b++) {
                            TLRPC.JSONValue val = array.value.get(b);
                            if (val instanceof TLRPC.TL_jsonString) {
                                TLRPC.TL_jsonString string = (TLRPC.TL_jsonString) val;
                                newProtocols.add(string.value.toLowerCase());
                            }
                        }
                    }
                    if (!webAppAllowedProtocols.equals(newProtocols)) {
                        webAppAllowedProtocols = newProtocols;
                        editor.putStringSet("webAppAllowedProtocols", webAppAllowedProtocols);
                        changed = true;
                    }
                    break;
                }
                case "starref_start_param_prefixes": {
                    HashSet<String> newPrefixes = new HashSet<>();
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        TLRPC.TL_jsonArray array = (TLRPC.TL_jsonArray) value.value;
                        for (int b = 0, N2 = array.value.size(); b < N2; b++) {
                            TLRPC.JSONValue val = array.value.get(b);
                            if (val instanceof TLRPC.TL_jsonString) {
                                TLRPC.TL_jsonString string = (TLRPC.TL_jsonString) val;
                                newPrefixes.add(string.value.toLowerCase());
                            }
                        }
                    }
                    if (!starrefStartParamPrefixes.equals(newPrefixes)) {
                        starrefStartParamPrefixes = newPrefixes;
                        editor.putStringSet("starrefStartParamPrefixes", starrefStartParamPrefixes);
                        changed = true;
                    }
                    break;
                }
                case "weather_search_username": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        TLRPC.TL_jsonString str = (TLRPC.TL_jsonString) value.value;
                        if (!TextUtils.equals(str.value, weatherSearchUsername)) {
                            weatherSearchUsername = str.value;
                            editor.putString("weatherSearchUsername", weatherSearchUsername);
                            changed = true;
                        }
                    }
                    break;
                }
                case "story_weather_preload": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != storyWeatherPreload) {
                            storyWeatherPreload = bool.value;
                            editor.putBoolean("storyWeatherPreload", storyWeatherPreload);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stars_gifts_enabled": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != starsGiftsEnabled) {
                            starsGiftsEnabled = bool.value;
                            editor.putBoolean("starsGiftsEnabled", starsGiftsEnabled);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stargifts_blocked": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != stargiftsBlocked) {
                            stargiftsBlocked = bool.value;
                            editor.putBoolean("stargiftsBlocked", stargiftsBlocked);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stars_paid_reaction_amount_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if ((long) num.value != starsPaidReactionAmountMax) {
                            starsPaidReactionAmountMax = (long) num.value;
                            editor.putLong("starsPaidReactionAmountMax", starsPaidReactionAmountMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stars_subscription_amount_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if ((long) num.value != starsSubscriptionAmountMax) {
                            starsSubscriptionAmountMax = (long) num.value;
                            editor.putLong("starsSubscriptionAmountMax", starsSubscriptionAmountMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stars_usd_sell_rate_x1000": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (Math.abs(num.value - starsUsdSellRate1000) > 0.001f) {
                            starsUsdSellRate1000 = (float) num.value;
                            editor.putFloat("starsUsdSellRate1000", starsUsdSellRate1000);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stars_usd_withdraw_rate_x1000": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (Math.abs(num.value - starsUsdWithdrawRate1000) > 0.001f) {
                            starsUsdWithdrawRate1000 = (float) num.value;
                            editor.putFloat("starsUsdWithdrawRate1000", starsUsdWithdrawRate1000);
                            changed = true;
                        }
                    }
                    break;
                }
                case "sponsored_links_inapp_allow": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != sponsoredLinksInappAllow) {
                            sponsoredLinksInappAllow = bool.value;
                            editor.putBoolean("sponsoredLinksInappAllow", sponsoredLinksInappAllow);
                            changed = true;
                        }
                    }
                    break;
                }
                case "ignore_restriction_reasons": {
                    HashSet<String> newReasons = new HashSet<>();
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        TLRPC.TL_jsonArray array = (TLRPC.TL_jsonArray) value.value;
                        for (int b = 0, N2 = array.value.size(); b < N2; b++) {
                            TLRPC.JSONValue val = array.value.get(b);
                            if (val instanceof TLRPC.TL_jsonString) {
                                TLRPC.TL_jsonString string = (TLRPC.TL_jsonString) val;
                                newReasons.add(string.value.toLowerCase());
                            }
                        }
                    }
                    if (!ignoreRestrictionReasons.equals(newReasons)) {
                        ignoreRestrictionReasons = newReasons;
                        editor.putStringSet("ignoreRestrictionReasons", ignoreRestrictionReasons);
                        changed = true;
                    }
                    break;
                }
                case "starref_program_allowed": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != starrefProgramAllowed) {
                            starrefProgramAllowed = bool.value;
                            editor.putBoolean("starrefProgramAllowed", starrefProgramAllowed);
                            changed = true;
                        }
                    }
                    break;
                }
                case "starref_connect_allowed": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != starrefConnectAllowed) {
                            starrefConnectAllowed = bool.value;
                            editor.putBoolean("starrefConnectAllowed", starrefConnectAllowed);
                            changed = true;
                        }
                    }
                    break;
                }
                case "starref_min_commission_permille": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != starrefMinCommissionPermille) {
                            starrefMinCommissionPermille = (int) num.value;
                            editor.putInt("starrefMinCommissionPermille", starrefMinCommissionPermille);
                            changed = true;
                        }
                    }
                    break;
                }
                case "starref_max_commission_permille": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != starrefMaxCommissionPermille) {
                            starrefMaxCommissionPermille = (int) num.value;
                            editor.putInt("starrefMaxCommissionPermille", starrefMaxCommissionPermille);
                            changed = true;
                        }
                    }
                    break;
                }
                case "bot_verification_description_length_limit": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != botVerificationDescriptionLengthLimit) {
                            botVerificationDescriptionLengthLimit = (int) num.value;
                            editor.putInt("botVerificationDescriptionLengthLimit", botVerificationDescriptionLengthLimit);
                            changed = true;
                        }
                    }
                    break;
                }
                case "freeze_since_date": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != freezeSinceDate) {
                            freezeSinceDate = (long) num.value;
                            editor.putLong("freezeSinceDate", freezeSinceDate);
                            changed = true;
                        }
                    }
                    break;
                }
                case "freeze_until_date": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != freezeUntilDate) {
                            freezeUntilDate = (long) num.value;
                            editor.putLong("freezeUntilDate", freezeUntilDate);
                            changed = true;
                        }
                    }
                    break;
                }
                case "freeze_appeal_url": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        TLRPC.TL_jsonString num = (TLRPC.TL_jsonString) value.value;
                        if (!TextUtils.equals(num.value, freezeAppealUrl)) {
                            freezeAppealUrl = num.value;
                            editor.putString("freezeAppealUrl", freezeAppealUrl);
                            changed = true;
                        }
                    }
                    break;
                }
                case "conference_call_size_limit": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != conferenceCallSizeLimit) {
                            conferenceCallSizeLimit = (int) num.value;
                            editor.putInt("conferenceCallSizeLimit", conferenceCallSizeLimit);
                            changed = true;
                        }
                    }
                    break;
                }
                case "call_requests_disabled": {
                    if (value.value instanceof TLRPC.TL_jsonBool) {
                        TLRPC.TL_jsonBool bool = (TLRPC.TL_jsonBool) value.value;
                        if (bool.value != callRequestsDisabled) {
                            callRequestsDisabled = bool.value;
                            editor.putBoolean("callRequestsDisabled", callRequestsDisabled);
                            changed = true;
                        }
                    }
                    break;
                }
                case "poll_answers_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != pollAnswersMax) {
                            pollAnswersMax = (int) num.value;
                            editor.putInt("pollAnswersMax", pollAnswersMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "todo_items_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != todoItemsMax) {
                            todoItemsMax = (int) num.value;
                            editor.putInt("todoItemsMax", todoItemsMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "todo_title_length_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != todoTitleLengthMax) {
                            todoTitleLengthMax = (int) num.value;
                            editor.putInt("todoTitleLengthMax", todoTitleLengthMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "todo_item_length_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (num.value != todoItemLengthMax) {
                            todoItemLengthMax = (int) num.value;
                            editor.putInt("todoItemLengthMax", todoItemLengthMax);
                            changed = true;
                        }
                    }
                    break;
                }
                case "translations_manual_enabled": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        TLRPC.TL_jsonString str = (TLRPC.TL_jsonString) value.value;
                        if (!TextUtils.equals(translationsManualEnabled, str.value)) {
                            translationsManualEnabled = str.value;
                            editor.putString("translationsManualEnabled", translationsManualEnabled);
                            changed = true;
                        }
                    }
                    break;
                }
                case "translations_auto_enabled": {
                    if (value.value instanceof TLRPC.TL_jsonString) {
                        TLRPC.TL_jsonString str = (TLRPC.TL_jsonString) value.value;
                        if (!TextUtils.equals(translationsAutoEnabled, str.value)) {
                            translationsAutoEnabled = str.value;
                            editor.putString("translationsAutoEnabled", translationsAutoEnabled);
                            changed = true;
                        }
                    }
                    break;
                }
                case "whitelisted_bots": {
                    final HashSet<Long> set = new HashSet<>();
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        final ArrayList<TLRPC.JSONValue> array = ((TLRPC.TL_jsonArray) value.value).value;
                        for (int i = 0; i < array.size(); ++i) {
                            if (array.get(i) instanceof TLRPC.TL_jsonNumber) {
                                set.add((long) ((TLRPC.TL_jsonNumber) array.get(i)).value);
                            }
                        }
                    }
                    if (!set.equals(whitelistedBots)) {
                        whitelistedBots = set;
                        editor.putStringSet("whitelistedBots", set.stream().map(id -> String.valueOf(id)).collect(Collectors.toCollection(HashSet::new)));
                        changed = true;
                    }
                    break;
                }
                case "stars_groupcall_message_amount_max": {
                    if (value.value instanceof TLRPC.TL_jsonNumber) {
                        final TLRPC.TL_jsonNumber num = (TLRPC.TL_jsonNumber) value.value;
                        if (starsGroupcallMessageAmountMax != (int) num.value) {
                            editor.putInt("starsGroupcallMessageAmountMax", starsGroupcallMessageAmountMax = (int) num.value);
                            changed = true;
                        }
                    }
                    break;
                }
                case "stars_groupcall_message_limits": {
                    if (value.value instanceof TLRPC.TL_jsonArray) {
                        final int[] tiers = parseTiers((TLRPC.TL_jsonArray) value.value);
                        if (!tiersEqual(tiers, starsGroupcallMessageLimits)) {
                            editor.putString("starsGroupcallMessageLimits", tiersToString(starsGroupcallMessageLimits = tiers));
                            changed = true;
                        }
                    }
                    break;
                }
            }
        }

        if (transcribeAudioTrialWeeklyNumber != this.transcribeAudioTrialWeeklyNumber) {
            this.transcribeAudioTrialWeeklyNumber = transcribeAudioTrialWeeklyNumber;
            editor.putInt("transcribeAudioTrialWeeklyNumber", transcribeAudioTrialWeeklyNumber);
            if (transcribeAudioTrialCurrentNumber <= 0 && (transcribeAudioTrialCooldownUntil == 0 || getConnectionsManager().getCurrentTime() > transcribeAudioTrialCooldownUntil)) {
                transcribeAudioTrialCurrentNumber = transcribeAudioTrialWeeklyNumber;
                editor.putInt("transcribeAudioTrialCurrentNumber", transcribeAudioTrialCurrentNumber);
            } else if (transcribeAudioTrialCurrentNumber > transcribeAudioTrialWeeklyNumber) {
                transcribeAudioTrialCurrentNumber = transcribeAudioTrialWeeklyNumber;
                editor.putInt("transcribeAudioTrialCurrentNumber", transcribeAudioTrialCurrentNumber);
            }
            changed = true;
        }
        if (transcribeAudioTrialCooldownUntil != this.transcribeAudioTrialCooldownUntil) {
            this.transcribeAudioTrialCooldownUntil = transcribeAudioTrialCooldownUntil;
            editor.putInt("transcribeAudioTrialCooldownUntil", transcribeAudioTrialCooldownUntil);
            changed = true;
            scheduleTranscriptionUpdate();
        }

        if (changed) {
            editor.apply();
            AndroidUtilities.runOnUIThread(() -> {
                getNotificationCenter().postNotificationName(NotificationCenter.appConfigUpdated);
            });
        }
        if (liteAppOptions != null) {
            LiteMode.updatePresets(liteAppOptions);
        }
        if (keelAliveChanged) {
            ApplicationLoader.startPushService();
            ConnectionsManager connectionsManager = getConnectionsManager();
            connectionsManager.setPushConnectionEnabled(connectionsManager.isPushConnectionEnabled());
        }
        if (storiesChanged) {
            AndroidUtilities.runOnUIThread(() -> {
                getNotificationCenter().postNotificationName(NotificationCenter.storiesEnabledUpdate);
            });
        }
        logDeviceStats();
    }

    public void updateTranscribeAudioTrialCurrentNumber(int num) {
        if (num != transcribeAudioTrialCurrentNumber) {
            transcribeAudioTrialCurrentNumber = num;
            mainPreferences.edit()
                .putInt("transcribeAudioTrialCurrentNumber", transcribeAudioTrialCurrentNumber)
                .apply();
        }
    }

    public void updateTranscribeAudioTrialCooldownUntil(int until) {
        if (until != transcribeAudioTrialCooldownUntil) {
            transcribeAudioTrialCooldownUntil = until;
            mainPreferences.edit()
                .putInt("transcribeAudioTrialCooldownUntil", transcribeAudioTrialCooldownUntil)
                .apply();
            scheduleTranscriptionUpdate();
        }
    }

    private void scheduleTranscriptionUpdate() {
        AndroidUtilities.runOnUIThread(() -> {
            AndroidUtilities.cancelRunOnUIThread(notifyTranscriptionAudioCooldownUpdate);
            final long wait = transcribeAudioTrialCooldownUntil - getConnectionsManager().getCurrentTime();
            if (wait > 0) {
                AndroidUtilities.runOnUIThread(notifyTranscriptionAudioCooldownUpdate, wait);
            }
        });
    }
    private final Runnable notifyTranscriptionAudioCooldownUpdate = () -> getNotificationCenter().postNotificationName(NotificationCenter.updateTranscriptionLock);

    public static class PeerColors {

        public static final int TYPE_NAME = 0;
        public static final int TYPE_PROFILE = 1;

        public final int type;
        public final int hash;

        public final ArrayList<PeerColor> colors = new ArrayList<>();
        private final LongSparseArray<PeerColor> colorsById = new LongSparseArray<>();

        public boolean needUpdate() {
            boolean noLevels = true;
            boolean hasStandardColors = false;
            for (int i = 0; i < colors.size(); ++i) {
                if (colors.get(i).channelLvl > 0) {
                    noLevels = false;
                }
                if (colors.get(i).id < 7) {
                    hasStandardColors = true;
                }
            }

            if (type == TYPE_PROFILE && !noLevels) {
                noLevels = true;
                for (PeerColor color : colors) {
                    if (color.groupLvl > 0) {
                        noLevels = false;
                        break;
                    }
                }
            }
            return noLevels || type == TYPE_NAME && !hasStandardColors;
        }

        public int colorsAvailable(int lvl, boolean isGroup) {
            int count = 0;
            for (int i = 0; i < colors.size(); ++i) {
                MessagesController.PeerColor peerColor = colors.get(i);
                if (!peerColor.hidden && lvl >= peerColor.getLvl(isGroup)) {
                    count++;
                }
            }
            return count;
        }

        public int maxLevel() {
            return maxLevel(false);
        }

        public int maxLevel(boolean isGroup) {
            int maxLvl = 0;
            for (int i = 0; i < colors.size(); ++i) {
                MessagesController.PeerColor peerColor = colors.get(i);
                if (!peerColor.hidden) {
                    maxLvl = Math.max(maxLvl, peerColor.getLvl(isGroup));
                }
            }
            return maxLvl;
        }

        public int minLevel() {
            return minLevel(false);
        }

        public int minLevel(boolean isGroup) {
            int minLvl = maxLevel(isGroup);
            for (int i = 0; i < colors.size(); ++i) {
                MessagesController.PeerColor peerColor = colors.get(i);
                if (!peerColor.hidden) {
                    minLvl = Math.min(minLvl, peerColor.getLvl(isGroup));
                }
            }
            return minLvl;
        }

        private PeerColors(int type, int hash) {
            this.type = type;
            this.hash = hash;
        }

        @Nullable
        public PeerColor getColor(int colorId) {
            return colorsById.get(colorId);
        }

        @NonNull
        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (hash != 0) {
                sb.append("@").append(hash).append("^");
            }
            for (int i = 0; i < colors.size(); ++i) {
                PeerColor color = colors.get(i);
                if (i > 0) sb.append(";");
                color.appendString(sb);
            }
            return sb.toString();
        }

        public static PeerColors fromString(int type, String str) {
            if (str == null) return null;
            int hash = 0;
            if (str.startsWith("@")) {
                int index = str.indexOf("^");
                if (index >= 0) {
                    hash = Utilities.parseInt(str.substring(1, index));
                    str = str.substring(index + 1);
                }
            }
            final PeerColors peerColors = new PeerColors(type, hash);
            final String[] colorParts = str.split(";");
            for (int i = 0; i < colorParts.length; ++i) {
                PeerColor peerColor = PeerColor.fromString(colorParts[i]);
                if (peerColor == null)
                    continue;
                peerColor.isDefaultName = peerColor.id < 7 && type == TYPE_NAME;
                if (!peerColor.hidden)
                    peerColors.colors.add(peerColor);
                peerColors.colorsById.put(peerColor.id, peerColor);
            }
            return peerColors;
        }

        private static int color(String str) {
            return Integer.parseUnsignedInt("ff" + str, 16);
        }

        public static PeerColors fromTL(int type, TLRPC.TL_help_peerColors tl) {
            if (tl == null) return null;
            try {
                PeerColors peerColors = new PeerColors(type, tl.hash);
                for (int i = 0; i < tl.colors.size(); ++i) {
                    PeerColor peerColor = PeerColor.fromTL(tl.colors.get(i));
                    if (peerColor == null) continue;
                    peerColor.isDefaultName = peerColor.id < 7 && type == TYPE_NAME;
                    if (!peerColor.hidden)
                        peerColors.colors.add(peerColor);
                    peerColors.colorsById.put(peerColor.id, peerColor);
                }
                return peerColors;
            } catch (Exception e) {
                FileLog.e(e);
            }
            return null;
        }

        public static PeerColors fromJSON(
            int type,
            TLRPC.TL_jsonObject peer_colors,
            TLRPC.TL_jsonObject dark_peer_colors,
            TLRPC.TL_jsonArray peer_colors_available
        ) {
            try {
                PeerColors peerColors = new PeerColors(type, 0);
                if (peer_colors != null) {
                    for (TLRPC.TL_jsonObjectValue pair : peer_colors.value) {
                        final int id = Utilities.parseInt(pair.key);
                        if (!(pair.value instanceof TLRPC.TL_jsonArray))
                            continue;
                        ArrayList<TLRPC.JSONValue> val = ((TLRPC.TL_jsonArray) pair.value).value;
                        if (val.isEmpty())
                            continue;

                        PeerColor peerColor = new PeerColor();
                        try {
                            peerColor.id = id;
                            for (int i = 0; i < 6; ++i)
                                peerColor.colors[i] = peerColor.darkColors[i] = val.size() > i ? color(((TLRPC.TL_jsonString) val.get(i)).value) : peerColor.colors[0];
                        } catch (Exception e2) {
                            FileLog.e(e2);
                            continue;
                        }
                        peerColor.isDefaultName = peerColor.id < 7 && type == TYPE_NAME;
                        peerColors.colorsById.put(id, peerColor);
                    }
                }
                if (dark_peer_colors != null) {
                    for (TLRPC.TL_jsonObjectValue pair : dark_peer_colors.value) {
                        final int id = Utilities.parseInt(pair.key);
                        if (!(pair.value instanceof TLRPC.TL_jsonArray))
                            continue;
                        ArrayList<TLRPC.JSONValue> val = ((TLRPC.TL_jsonArray) pair.value).value;
                        if (val.isEmpty())
                            continue;

                        PeerColor peerColor = peerColors.colorsById.get(id);
                        if (peerColor == null) continue;
                        try {
                            peerColor.id = id;
                            for (int i = 0; i < 6; ++i)
                                peerColor.darkColors[i] = val.size() > i ? color(((TLRPC.TL_jsonString) val.get(i)).value) : peerColor.darkColors[0];
                        } catch (Exception e2) {
                            FileLog.e(e2);
                            continue;
                        }
                        peerColors.colorsById.put(id, peerColor);
                    }
                }
                peerColors.colors.clear();
                if (peer_colors_available != null) {
                    for (TLRPC.JSONValue idvalue : peer_colors_available.value) {
                        if (!(idvalue instanceof TLRPC.TL_jsonNumber))
                            continue;
                        final int id = (int) ((TLRPC.TL_jsonNumber) idvalue).value;
                        PeerColor color = peerColors.colorsById.get(id);
                        if (color == null) continue;
                        peerColors.colors.add(color);
                    }
                }
                return peerColors;
            } catch (Exception e) {
                FileLog.e(e);
            }
            return null;
        }
    }

    public static class PeerColor {
        public int patternColor = 0;
        public int textColor = 0;
        public boolean isDefaultName;
        public int id;
        public boolean hidden;
        public int channelLvl;
        public int groupLvl;
        private final int[] colors = new int[6];
        private final int[] darkColors = new int[6];
        public int getColor(int i, Theme.ResourcesProvider resourcesProvider) {
            if (i < 0 || i > 5) return 0;
            if (isDefaultName && id >= 0 && id < 7) {
                return Theme.getColor(Theme.keys_avatar_nameInMessage[id], resourcesProvider);
            }
            final boolean isDark = resourcesProvider != null ? resourcesProvider.isDark() : Theme.isCurrentThemeDark();
            return (isDark ? darkColors : colors)[i];
        }
        public int getLvl(boolean isGroup) {
            return isGroup ? groupLvl : channelLvl;
        }
        public int getColor1(boolean isDark) {
            return (isDark ? darkColors : colors)[0];
        }
        public int getColor2(boolean isDark) {
            return (isDark ? darkColors : colors)[1];
        }
        public int getColor3(boolean isDark) {
            return (isDark ? darkColors : colors)[2];
        }
        public int getColor4(boolean isDark) {
            return (isDark ? darkColors : colors)[3];
        }
        public int getColor5(boolean isDark) {
            return (isDark ? darkColors : colors)[4];
        }
        public int getColor6(boolean isDark) {
            return (isDark ? darkColors : colors)[5];
        }
        public int getColor1() {
            return (Theme.isCurrentThemeDark() ? darkColors : colors)[0];
        }
        public int getColor2() {
            return (Theme.isCurrentThemeDark() ? darkColors : colors)[1];
        }
        public int getColor3() {
            return (Theme.isCurrentThemeDark() ? darkColors : colors)[2];
        }
        public int getColor4() {
            return (Theme.isCurrentThemeDark() ? darkColors : colors)[3];
        }
        public int getColor5() {
            return (Theme.isCurrentThemeDark() ? darkColors : colors)[4];
        }
        public boolean hasColor2() {
            return getColor2() != getColor1();
        }
        public boolean hasColor3() {
            return getColor3() != getColor1();
        }
        public boolean hasColor2(boolean isDark) {
            return getColor2(isDark) != getColor1(isDark);
        }
        public boolean hasColor3(boolean isDark) {
            return getColor3(isDark) != getColor1(isDark);
        }
        public boolean hasColor6(boolean isDark) {
            return getColor6(isDark) != getColor1(isDark);
        }
        public int getBgColor1(boolean isDark) {
            return hasColor6(isDark) ? getColor3(isDark) : getColor2(isDark);
        }
        public int getBgColor2(boolean isDark) {
            return hasColor6(isDark) ? getColor4(isDark) : getColor2(isDark);
        }
        public int getStoryColor1(boolean isDark) {
            return hasColor6(isDark) ? getColor5(isDark) : getColor3(isDark);
        }
        public int getStoryColor2(boolean isDark) {
            return hasColor6(isDark) ? getColor6(isDark) : getColor4(isDark);
        }
        public int getAvatarColor1() {
            return ColorUtils.blendARGB(getBgColor2(false), getStoryColor2(false), .5f);
        }
        public int getAvatarColor2() {
            return ColorUtils.blendARGB(getBgColor1(false), getStoryColor1(false), .5f);
        }
        public void appendString(StringBuilder sb) {
            sb.append("#");
            if (hidden) sb.append("H");
            if (channelLvl != 0 || groupLvl != 0) {
                sb.append("[").append(channelLvl).append(",").append(groupLvl).append("]");
            }
            sb.append(id);
            sb.append("{");
            sb.append(colors[0]);
            if (colors[1] != colors[0]) {
                sb.append(",");
                sb.append(colors[1]);
                if (colors[2] != colors[0] || colors[3] != colors[0]) {
                    sb.append(",");
                    sb.append(colors[2]);
                    sb.append(",");
                    sb.append(colors[3]);
                    if (colors[4] != colors[0] || colors[5] != colors[0]) {
                        sb.append(",");
                        sb.append(colors[4]);
                        sb.append(",");
                        sb.append(colors[5]);
                    }
                }
            }
            if (darkColors[0] != colors[0] || darkColors[1] != colors[1] || darkColors[2] != colors[2]) {
                sb.append("@");
                sb.append(darkColors[0]);
                if (darkColors[1] != darkColors[0]) {
                    sb.append(",");
                    sb.append(darkColors[1]);
                    if (darkColors[2] != darkColors[0] || darkColors[3] != darkColors[0]) {
                        sb.append(",");
                        sb.append(darkColors[2]);
                        sb.append(",");
                        sb.append(darkColors[3]);
                        if (darkColors[4] != darkColors[0] || darkColors[5] != darkColors[0]) {
                            sb.append(",");
                            sb.append(darkColors[4]);
                            sb.append(",");
                            sb.append(darkColors[5]);
                        }
                    }
                }
            }
            sb.append("}");
        }

        public static PeerColor fromPeerCollectible(TLRPC.PeerColor peer_color) {
            if (!(peer_color instanceof TLRPC.TL_peerColorCollectible)) return null;
            final TLRPC.TL_peerColorCollectible color = (TLRPC.TL_peerColorCollectible) peer_color;
            final PeerColor peerColor = new PeerColor();
            peerColor.id = -1;
            peerColor.hidden = true;
            // TODO
            return peerColor;
        }

        public static PeerColor fromCollectible(TLRPC.EmojiStatus status) {
            if (!(status instanceof TLRPC.TL_emojiStatusCollectible)) return null;
            final TLRPC.TL_emojiStatusCollectible s = (TLRPC.TL_emojiStatusCollectible) status;
            final PeerColor peerColor = new PeerColor();
            peerColor.id = -1;
            peerColor.hidden = true;
            peerColor.colors[0] = s.edge_color | 0xFF000000;
            peerColor.colors[1] = s.center_color | 0xFF000000;
            peerColor.colors[2] = s.edge_color | 0xFF000000;
            peerColor.colors[3] = s.center_color | 0xFF000000;
            peerColor.colors[4] = s.text_color | 0xFF000000;
            peerColor.colors[5] = s.text_color | 0xFF000000;
            System.arraycopy(peerColor.colors, 0, peerColor.darkColors, 0, 6);
            peerColor.patternColor = s.pattern_color | 0xFF000000;
            peerColor.textColor = s.text_color | 0xFF000000;
            return peerColor;
        }

        public static PeerColor fromTL(TLRPC.TL_help_peerColorOption tl) {
            if (tl == null) return null;

            final PeerColor peerColor = new PeerColor();
            peerColor.id = tl.color_id;
            peerColor.hidden = tl.hidden;
            if ((tl.flags & 8) != 0) {
                peerColor.channelLvl = tl.channel_min_level;
            }
            if ((tl.flags & 16) != 0) {
                peerColor.groupLvl = tl.group_min_level;
            }

            System.arraycopy(optionToColors(tl.colors), 0, peerColor.colors, 0, 6);
            System.arraycopy(optionToColors(tl.dark_colors), 0, peerColor.darkColors, 0, 6);
            return peerColor;
        }

        public static int[] optionToColors(TLRPC.help_PeerColorSet set) {
            final int[] colors = new int[] {0, 0, 0, 0, 0, 0};
            ArrayList<Integer> finalColorList = null;
            if (set instanceof TLRPC.TL_help_peerColorSet) {
                finalColorList = ((TLRPC.TL_help_peerColorSet) set).colors;
            } else if (set instanceof TLRPC.TL_help_peerColorProfileSet) {
                ArrayList<Integer> colorList1 = ((TLRPC.TL_help_peerColorProfileSet) set).palette_colors;
                ArrayList<Integer> colorList2 = ((TLRPC.TL_help_peerColorProfileSet) set).bg_colors;
                ArrayList<Integer> colorList3 = ((TLRPC.TL_help_peerColorProfileSet) set).story_colors;
                finalColorList = new ArrayList<Integer>();
                if (colorList1 != null) {
                    for (int i = 0; i < Math.min(2, colorList1.size()); ++i)
                        finalColorList.add(colorList1.get(i));
                }
                if (colorList2 != null) {
                    for (int i = 0; i < Math.min(2, colorList2.size()); ++i)
                        finalColorList.add(colorList2.get(i));
                }
                if (colorList3 != null) {
                    for (int i = 0; i < Math.min(2, colorList3.size()); ++i)
                        finalColorList.add(colorList3.get(i));
                }
            }
            if (finalColorList != null) {
                if (finalColorList.size() > 0) {
                    Arrays.fill(colors, 0xFF000000 | finalColorList.get(0));
                }
                for (int i = 0; i < Math.min(colors.length, finalColorList.size()); ++i) {
                    colors[i] = 0xFF000000 | finalColorList.get(i);
                }
            }
            return colors;
        }

        public static PeerColor fromString(String string) {
            if (string == null || string.isEmpty() || string.charAt(0) != '#')
                return null;
            int startIndex = 1;
            boolean hidden = string.length() > 1 && string.charAt(startIndex) == 'H';
            if (hidden) {
                startIndex++;
            }
            int channelLvl = 0;
            int groupLvl = 0;
            if (string.length() > startIndex && string.charAt(startIndex) == '[') {
                int eindex = string.indexOf(']');
                if (eindex > startIndex) {
                    String subStr = string.substring(startIndex + 1, eindex);
                    if (subStr.contains(",")) {
                        String[] splits = subStr.split(",");
                        channelLvl = Utilities.parseInt(splits[0]);
                        groupLvl = Utilities.parseInt(splits[1]);
                    } else {
                        channelLvl = Utilities.parseInt(subStr);
                    }
                    startIndex = eindex + 1;
                }
            }
            int index = string.indexOf('{');
            if (index < 0) return null;
            try {
                final PeerColor peerColor = new PeerColor();
                peerColor.id = Utilities.parseInt(string.substring(startIndex, index));
                peerColor.hidden = hidden;
                peerColor.channelLvl = channelLvl;
                peerColor.groupLvl = groupLvl;
                final String[] parts = string.substring(index + 1, string.length() - 1).split("@");
                String[] colorsString = parts[0].split(",");
                for (int i = 0; i < 6; ++i)
                    peerColor.colors[i] = colorsString.length >= i + 1 ? Utilities.parseInt(colorsString[i]) : peerColor.colors[0];
                if (parts.length >= 2) {
                    colorsString = parts[1].split(",");
                    for (int i = 0; i < 6; ++i)
                        peerColor.darkColors[i] = colorsString.length >= i + 1 ? Utilities.parseInt(colorsString[i]) : peerColor.darkColors[0];
                } else {
                    for (int i = 0; i < 6; ++i)
                        peerColor.darkColors[i] = peerColor.colors[i];
                }
                return peerColor;
            } catch (Exception e) {
                FileLog.e(e);
            }
            return null;
        }
    }

    private void resetAppConfig() {
        getfileExperimentalParams = false;
        channelRevenueWithdrawalEnabled = false;
        collectDeviceStats = false;
        smsjobsStickyNotificationEnabled = false;
        showAnnualPerMonth = false;
        canEditFactcheck = false;
        starsLocked = true;
        factcheckLengthLimit = 1024;
        videoIgnoreAltDocuments = false;
        freezeSinceDate = 0L;
        freezeUntilDate = 0L;
        freezeAppealUrl = "t.me/spambot";
        verifyAgeBotUsername = null;
        verifyAgeCountry = "GB";
        ignoreRestrictionReasons = new HashSet<String>();
        mainPreferences.edit()
            .remove("starsLocked")
            .remove("getfileExperimentalParams")
            .remove("smsjobsStickyNotificationEnabled")
            .remove("channelRevenueWithdrawalEnabled")
            .remove("showAnnualPerMonth")
            .remove("canEditFactcheck")
            .remove("factcheckLengthLimit")
            .remove("videoIgnoreAltDocuments")
            .remove("freezeSinceDate")
            .remove("freezeUntilDate")
            .remove("freezeAppealUrl")
            .remove("verifyAgeBotUsername")
            .remove("verifyAgeCountry")
            .remove("ignoreRestrictionReasons")
            .apply();
    }

    private boolean savePremiumFeaturesPreviewOrder(String key, SparseIntArray array, SharedPreferences.Editor editor, ArrayList<TLRPC.JSONValue> value) {
        StringBuilder stringBuilder = new StringBuilder();
        array.clear();
        for (int i = 0; i < value.size(); i++) {
            String s = null;
            if (value.get(i) instanceof TLRPC.TL_jsonString) {
                s = ((TLRPC.TL_jsonString) value.get(i)).value;
            }
            if (s != null) {
                int type = PremiumPreviewFragment.serverStringToFeatureType(s);
                if (type >= 0) {
                    array.put(type, i);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('_');
                    }
                    stringBuilder.append(type);
                }
            }
        }

        boolean changed;
        if (stringBuilder.length() > 0) {
            String string = stringBuilder.toString();
            changed = !string.equals(mainPreferences.getString(key, null));
            editor.putString(key, string);
        } else {
            editor.remove(key);
            changed = mainPreferences.getString(key, null) != null;
        }
        return changed;
    }

    private void loadPremiumFeaturesPreviewOrder(SparseIntArray array, String string) {
        array.clear();
        if (string != null) {
            String[] types = string.split("_");
            for (int i = 0; i < types.length; i++) {
                int type = Integer.parseInt(types[i]);
                array.put(type, i);
            }
        }
    }

    public void removeSuggestion(long did, String suggestion) {
        if (TextUtils.isEmpty(suggestion)) {
            return;
        }
        if (did == 0) {
            if (customPendingSuggestion != null && TextUtils.equals(suggestion, customPendingSuggestion.suggestion)) {
                customPendingSuggestion = null;
                getNotificationCenter().postNotificationName(NotificationCenter.newSuggestionsAvailable);
            } else if (pendingSuggestions.remove(suggestion) || !dismissedSuggestions.contains(suggestion)) {
                dismissedSuggestions.add(suggestion);
                SharedPreferences.Editor editor = mainPreferences.edit();
                editor.putStringSet("pendingSuggestions", pendingSuggestions);
                editor.putStringSet("dismissedSuggestions", dismissedSuggestions);
                editor.commit();
                getNotificationCenter().postNotificationName(NotificationCenter.newSuggestionsAvailable);
            } else {
                return;
            }
        }
        TLRPC.TL_help_dismissSuggestion req = new TLRPC.TL_help_dismissSuggestion();
        req.suggestion = suggestion;
        if (did == 0) {
            req.peer = new TLRPC.TL_inputPeerEmpty();
        } else {
            req.peer = getInputPeer(did);
        }
        getConnectionsManager().sendRequest(req, (response, error) -> {

        });
    }

    public void updateConfig(final TLRPC.TL_config config) {
        AndroidUtilities.runOnUIThread(() -> {
            getDownloadController().loadAutoDownloadConfig(false);
            loadAppConfig(true);
            checkPeerColors(true);
            remoteConfigLoaded = true;
            maxMegagroupCount = config.megagroup_size_max;
            maxGroupCount = config.chat_size_max;
            maxEditTime = config.edit_time_limit;
            ratingDecay = config.rating_e_decay;
//            maxRecentGifsCount = config.saved_gifs_limit;
            maxRecentStickersCount = config.stickers_recent_limit;
//            maxFaveStickersCount = config.stickers_faved_limit;
            revokeTimeLimit = config.revoke_time_limit;
            revokeTimePmLimit = config.revoke_pm_time_limit;
            canRevokePmInbox = config.revoke_pm_inbox;
            linkPrefix = config.me_url_prefix;
            boolean forceTryIpV6 = config.force_try_ipv6;
            if (linkPrefix.endsWith("/")) {
                linkPrefix = linkPrefix.substring(0, linkPrefix.length() - 1);
            }
            if (linkPrefix.startsWith("https://")) {
                linkPrefix = linkPrefix.substring(8);
            } else if (linkPrefix.startsWith("http://")) {
                linkPrefix = linkPrefix.substring(7);
            }
            callReceiveTimeout = config.call_receive_timeout_ms;
            callRingTimeout = config.call_ring_timeout_ms;
            callConnectTimeout = config.call_connect_timeout_ms;
            callPacketTimeout = config.call_packet_timeout_ms;
//            maxPinnedDialogsCount = config.pinned_dialogs_count_max;
//            maxFolderPinnedDialogsCount = config.pinned_infolder_count_max;
            maxMessageLength = config.message_length_max;
            maxCaptionLength = config.caption_length_max;
            preloadFeaturedStickers = config.preload_featured_stickers;
            if (config.venue_search_username != null) {
                venueSearchBot = config.venue_search_username;
            }
            if (config.gif_search_username != null) {
                gifSearchBot = config.gif_search_username;
            }
            if (imageSearchBot != null) {
                imageSearchBot = config.img_search_username;
            }
            blockedCountry = config.blocked_mode;
            dcDomainName = config.dc_txt_domain_name;
            webFileDatacenterId = config.webfile_dc_id;
            if (config.suggested_lang_code != null) {
                boolean loadRemote = suggestedLangCode == null || !suggestedLangCode.equals(config.suggested_lang_code);
                suggestedLangCode = config.suggested_lang_code;
                if (loadRemote) {
                    LocaleController.getInstance().loadRemoteLanguages(currentAccount);
                }
            }
            Theme.loadRemoteThemes(currentAccount, false);
            Theme.checkCurrentRemoteTheme(false);

            if (config.static_maps_provider == null) {
                config.static_maps_provider = "telegram";
            }

            mapKey = null;
            mapProvider = 2;
            availableMapProviders = 0;
            FileLog.d("map providers = " + config.static_maps_provider);
            String[] providers = config.static_maps_provider.split(",");
            for (int a = 0; a < providers.length; a++) {
                String[] mapArgs = providers[a].split("\\+");
                if (mapArgs.length > 0) {
                    String[] typeAndKey = mapArgs[0].split(":");
                    if (typeAndKey.length > 0) {
                        if ("yandex".equals(typeAndKey[0])) {
                            if (a == 0) {
                                if (mapArgs.length > 1) {
                                    mapProvider = 3;
                                } else {
                                    mapProvider = 1;
                                }
                            }
                            availableMapProviders |= 4;
                        } else if ("google".equals(typeAndKey[0])) {
                            if (a == 0) {
                                if (mapArgs.length > 1) {
                                    mapProvider = 4;
                                }
                            }
                            availableMapProviders |= 1;
                        } else if ("telegram".equals(typeAndKey[0])) {
                            if (a == 0) {
                                mapProvider = 2;
                            }
                            availableMapProviders |= 2;
                        }
                        if (typeAndKey.length > 1) {
                            mapKey = typeAndKey[1];
                        }
                    }
                }
            }

            SharedPreferences.Editor editor = mainPreferences.edit();
            editor.putBoolean("remoteConfigLoaded", remoteConfigLoaded);
            editor.putInt("maxGroupCount", maxGroupCount);
            editor.putInt("maxMegagroupCount", maxMegagroupCount);
            editor.putInt("maxEditTime", maxEditTime);
            editor.putInt("ratingDecay", ratingDecay);
            editor.putInt("maxRecentGifsCount", maxRecentGifsCount);
            editor.putInt("maxRecentStickersCount", maxRecentStickersCount);
            editor.putInt("maxFaveStickersCount", maxFaveStickersCount);
            editor.putInt("callReceiveTimeout", callReceiveTimeout);
            editor.putInt("callRingTimeout", callRingTimeout);
            editor.putInt("callConnectTimeout", callConnectTimeout);
            editor.putInt("callPacketTimeout", callPacketTimeout);
            editor.putString("linkPrefix", linkPrefix);
//            editor.putInt("maxPinnedDialogsCount", maxPinnedDialogsCount);
            editor.putInt("maxFolderPinnedDialogsCountDefault", maxFolderPinnedDialogsCountDefault);
            editor.putInt("maxFolderPinnedDialogsCountPremium", maxFolderPinnedDialogsCountPremium);
            editor.putInt("maxMessageLength", maxMessageLength);
            editor.putInt("maxCaptionLength", maxCaptionLength);
            editor.putBoolean("preloadFeaturedStickers", preloadFeaturedStickers);
            editor.putInt("revokeTimeLimit", revokeTimeLimit);
            editor.putInt("revokeTimePmLimit", revokeTimePmLimit);
            editor.putInt("mapProvider", mapProvider);
            if (mapKey != null) {
                editor.putString("pk", mapKey);
            } else {
                editor.remove("pk");
            }
            editor.putBoolean("canRevokePmInbox", canRevokePmInbox);
            editor.putBoolean("blockedCountry", blockedCountry);
            editor.putString("venueSearchBot", venueSearchBot);
            editor.putString("gifSearchBot", gifSearchBot);
            editor.putString("imageSearchBot", imageSearchBot);
            editor.putString("dcDomainName2", dcDomainName);
            editor.putInt("webFileDatacenterId", webFileDatacenterId);
            editor.putString("suggestedLangCode", suggestedLangCode);
            editor.putBoolean("forceTryIpV6", forceTryIpV6);
            editor.putString("autologinToken", autologinToken = config.autologin_token);
            editor.commit();

            getConnectionsManager().setForceTryIpV6(forceTryIpV6);
            LocaleController.getInstance().checkUpdateForCurrentRemoteLocale(currentAccount, config.lang_pack_version, config.base_lang_pack_version);
            getNotificationCenter().postNotificationName(NotificationCenter.configLoaded);
        });
    }

    public void addSupportUser() {
        TLRPC.TL_userForeign_old2 user = new TLRPC.TL_userForeign_old2();
        user.phone = "333";
        user.id = 333000;
        user.first_name = "Telegram";
        user.last_name = "";
        user.status = null;
        user.photo = new TLRPC.TL_userProfilePhotoEmpty();
        putUser(user, true);

        user = new TLRPC.TL_userForeign_old2();
        user.phone = "42777";
        user.id = 777000;
        user.verified = true;
        user.first_name = "Telegram";
        user.last_name = "Notifications";
        user.status = null;
        user.photo = new TLRPC.TL_userProfilePhotoEmpty();
        putUser(user, true);
    }

    public TLRPC.InputUser getInputUser(TLRPC.User user) {
        if (user == null) {
            return new TLRPC.TL_inputUserEmpty();
        }
        TLRPC.InputUser inputUser;
        if (user.id == getUserConfig().getClientUserId()) {
            inputUser = new TLRPC.TL_inputUserSelf();
        } else {
            inputUser = new TLRPC.TL_inputUser();
            inputUser.user_id = user.id;
            inputUser.access_hash = user.access_hash;
        }
        return inputUser;
    }

    public TLRPC.InputUser getInputUser(TLRPC.InputPeer peer) {
        if (peer == null) {
            return new TLRPC.TL_inputUserEmpty();
        }
        if (peer instanceof TLRPC.TL_inputPeerSelf) {
            return new TLRPC.TL_inputUserSelf();
        }
        TLRPC.TL_inputUser inputUser = new TLRPC.TL_inputUser();
        inputUser.user_id = peer.user_id;
        inputUser.access_hash = peer.access_hash;
        return inputUser;
    }

    public TLRPC.InputUser getInputUser(long userId) {
        return getInputUser(getUser(userId));
    }

    public static TLRPC.InputChannel getInputChannel(TLRPC.Chat chat) {
        if (chat instanceof TLRPC.TL_channel || chat instanceof TLRPC.TL_channelForbidden) {
            TLRPC.InputChannel inputChat = new TLRPC.TL_inputChannel();
            inputChat.channel_id = chat.id;
            inputChat.access_hash = chat.access_hash;
            return inputChat;
        } else {
            return new TLRPC.TL_inputChannelEmpty();
        }
    }

    public static TLRPC.InputChannel getInputChannel(TLRPC.InputPeer peer) {
        TLRPC.TL_inputChannel inputChat = new TLRPC.TL_inputChannel();
        inputChat.channel_id = peer.channel_id;
        inputChat.access_hash = peer.access_hash;
        return inputChat;
    }

    public TLRPC.InputChannel getInputChannel(long chatId) {
        return getInputChannel(getChat(chatId));
    }

    public TLRPC.InputPeer getInputPeer(TLRPC.Peer peer) {
        TLRPC.InputPeer inputPeer;
        if (peer instanceof TLRPC.TL_peerChat) {
            inputPeer = new TLRPC.TL_inputPeerChat();
            inputPeer.chat_id = peer.chat_id;
        } else if (peer instanceof TLRPC.TL_peerChannel) {
            inputPeer = new TLRPC.TL_inputPeerChannel();
            inputPeer.channel_id = peer.channel_id;
            TLRPC.Chat chat = getChat(peer.channel_id);
            if (chat != null) {
                inputPeer.access_hash = chat.access_hash;
            }
        } else {
            inputPeer = new TLRPC.TL_inputPeerUser();
            inputPeer.user_id = peer.user_id;
            TLRPC.User user = getUser(peer.user_id);
            if (user != null) {
                inputPeer.access_hash = user.access_hash;
            }
        }
        return inputPeer;
    }

    public TLRPC.InputPeer getInputPeer(long id) {
        TLRPC.InputPeer inputPeer;
        if (id == getUserConfig().getClientUserId()) {
            inputPeer = new TLRPC.TL_inputPeerSelf();
        } else if (id < 0) {
            TLRPC.Chat chat = getChat(-id);
            if (ChatObject.isChannel(chat)) {
                inputPeer = new TLRPC.TL_inputPeerChannel();
                inputPeer.channel_id = -id;
                inputPeer.access_hash = chat.access_hash;
            } else {
                inputPeer = new TLRPC.TL_inputPeerChat();
                inputPeer.chat_id = -id;
            }
        } else {
            TLRPC.User user = getUser(id);
            inputPeer = new TLRPC.TL_inputPeerUser();
            inputPeer.user_id = id;
            if (user != null) {
                inputPeer.access_hash = user.access_hash;
            }
        }
        return inputPeer;
    }

    public static TLRPC.InputPeer getInputPeer(TLRPC.Chat chat) {
        TLRPC.InputPeer inputPeer;
        if (ChatObject.isChannel(chat)) {
            inputPeer = new TLRPC.TL_inputPeerChannel();
            inputPeer.channel_id = chat.id;
            inputPeer.access_hash = chat.access_hash;
        } else {
            inputPeer = new TLRPC.TL_inputPeerChat();
            inputPeer.chat_id = chat.id;
        }
        return inputPeer;
    }

    public static TLRPC.InputPeer getInputPeer(TLRPC.User user) {
        TLRPC.InputPeer inputPeer = new TLRPC.TL_inputPeerUser();
        inputPeer.user_id = user.id;
        inputPeer.access_hash = user.access_hash;
        return inputPeer;
    }

    public static TLRPC.InputPeer getInputPeer(TLObject userOrChat) {
        if (userOrChat instanceof TLRPC.User) {
            return getInputPeer((TLRPC.User) userOrChat);
        } else if (userOrChat instanceof TLRPC.Chat) {
            return getInputPeer((TLRPC.Chat) userOrChat);
        } else {
            return null;
        }
    }

    public TLRPC.Peer getPeer(long id) {
        TLRPC.Peer inputPeer;
        if (id < 0) {
            TLRPC.Chat chat = getChat(-id);
            if (chat instanceof TLRPC.TL_channel || chat instanceof TLRPC.TL_channelForbidden) {
                inputPeer = new TLRPC.TL_peerChannel();
                inputPeer.channel_id = -id;
            } else {
                inputPeer = new TLRPC.TL_peerChat();
                inputPeer.chat_id = -id;
            }
        } else {
            inputPeer = new TLRPC.TL_peerUser();
            inputPeer.user_id = id;
        }
        return inputPeer;
    }

    public TLRPC.InputDocument getInputDocument(TLRPC.Document document) {
        if (document == null) return null;
        TLRPC.TL_inputDocument id = new TLRPC.TL_inputDocument();
        id.id = document.id;
        id.access_hash = document.access_hash;
        id.file_reference = document.file_reference;
        if (id.file_reference == null) {
            id.file_reference = new byte[0];
        }
        return id;
    }


    public String getPeerName(long dialogId) {
        return getPeerName(dialogId, false);
    }
    public String getPeerName(long dialogId, boolean firstName) {
        if (dialogId >= 0) {
            TLRPC.User user = getUser(dialogId);
            if (firstName) {
                return AndroidUtilities.removeRTL(AndroidUtilities.removeDiacritics(UserObject.getFirstName(user, true)));
            } else {
                return AndroidUtilities.removeRTL(AndroidUtilities.removeDiacritics(UserObject.getUserName(user)));
            }
        } else {
            TLRPC.Chat chat = getChat(-dialogId);
            return AndroidUtilities.removeRTL(AndroidUtilities.removeDiacritics(chat == null ? "" : chat.title));
        }
    }

    @Override
    public void didReceivedNotification(int id, int account, Object... args) {
        if (id == NotificationCenter.fileUploaded) {
            String location = (String) args[0];
            TLRPC.InputFile file = (TLRPC.InputFile) args[1];

            if (uploadingAvatar != null && uploadingAvatar.equals(location)) {
                TLRPC.TL_photos_uploadProfilePhoto req = new TLRPC.TL_photos_uploadProfilePhoto();
                req.file = file;
                req.flags |= 1;
                getConnectionsManager().sendRequest(req, (response, error) -> {
                    if (error == null) {
                        TLRPC.User user = getUser(getUserConfig().getClientUserId());
                        if (user == null) {
                            user = getUserConfig().getCurrentUser();
                            putUser(user, true);
                        } else {
                            getUserConfig().setCurrentUser(user);
                        }
                        if (user == null) {
                            return;
                        }
                        TLRPC.TL_photos_photo photo = (TLRPC.TL_photos_photo) response;
                        ArrayList<TLRPC.PhotoSize> sizes = photo.photo.sizes;
                        TLRPC.PhotoSize smallSize = FileLoader.getClosestPhotoSizeWithSize(sizes, 100);
                        TLRPC.PhotoSize bigSize = FileLoader.getClosestPhotoSizeWithSize(sizes, 1000);
                        user.photo = new TLRPC.TL_userProfilePhoto();
                        user.photo.photo_id = photo.photo.id;
                        if (smallSize != null) {
                            user.photo.photo_small = smallSize.location;
                        }
                        if (bigSize != null) {
                            user.photo.photo_big = bigSize.location;
                        }
                        getDialogPhotos(user.id).reset();
                        getDialogPhotos(user.id).load(0, DialogPhotos.STEP);
                        ArrayList<TLRPC.User> users = new ArrayList<>();
                        users.add(user);
                        getMessagesStorage().putUsersAndChats(users, null, false, true);
                        AndroidUtilities.runOnUIThread(() -> {
                            getNotificationCenter().postNotificationName(NotificationCenter.mainUserInfoChanged);
                            getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_AVATAR);
                            getUserConfig().saveConfig(true);
                        });
                    }
                });
            } else if (uploadingWallpaper != null && uploadingWallpaper.equals(location)) {
                TL_account.uploadWallPaper req = new TL_account.uploadWallPaper();
                req.file = file;
                req.mime_type = "image/jpeg";
                Theme.OverrideWallpaperInfo overrideWallpaperInfo = uploadingWallpaperInfo;
                String uploadingWallpaperFinal = uploadingWallpaper;
                TLRPC.TL_wallPaperSettings settings = new TLRPC.TL_wallPaperSettings();
                settings.blur = overrideWallpaperInfo.isBlurred;
                settings.motion = overrideWallpaperInfo.isMotion;
                req.settings = settings;
                uploadingWallpaperInfo.uploadingProgress = 1f;
                uploadingWallpaperInfo.requestIds = new ArrayList<>();
                uploadingWallpaperInfo.requestIds.add(getConnectionsManager().sendRequest(req, (response, error) -> {
                    TLRPC.WallPaper wallPaper = (TLRPC.WallPaper) response;
                    File path = new File(ApplicationLoader.getFilesDirFixed(), overrideWallpaperInfo.originalFileName);
                    if (wallPaper != null) {
                        try {
                            AndroidUtilities.copyFile(path, getFileLoader().getPathToAttach(wallPaper.document, true));
                        } catch (Exception ignore) {

                        }
                    }
                    AndroidUtilities.runOnUIThread(() -> {
                        if (uploadingWallpaper != null && uploadingWallpaperInfo.requestIds != null && wallPaper != null) {
                            wallPaper.settings = settings;
                            wallPaper.flags |= 4;
                            overrideWallpaperInfo.slug = wallPaper.slug;
                            overrideWallpaperInfo.saveOverrideWallpaper();
                            ArrayList<TLRPC.WallPaper> wallpapers = new ArrayList<>();
                            wallpapers.add(wallPaper);
                            getMessagesStorage().putWallpapers(wallpapers, 2);
                            TLRPC.PhotoSize image = FileLoader.getClosestPhotoSizeWithSize(wallPaper.document.thumbs, 320);
                            if (image != null) {
                                String newKey = image.location.volume_id + "_" + image.location.local_id + "@100_100";
                                String oldKey = Utilities.MD5(path.getAbsolutePath()) + "@100_100";
                                ImageLoader.getInstance().replaceImageInCache(oldKey, newKey, ImageLocation.getForDocument(image, wallPaper.document), false);
                            }
                            NotificationCenter.getGlobalInstance().postNotificationName(NotificationCenter.wallpapersNeedReload, wallPaper.slug);
                            if (uploadingWallpaperInfo.requestIds != null && overrideWallpaperInfo.dialogId != 0) {
                                uploadingWallpaperInfo.requestIds.add(ChatThemeController.getInstance(currentAccount).setWallpaperToPeer(overrideWallpaperInfo.dialogId, uploadingWallpaperFinal, overrideWallpaperInfo, null, null));
                            }
                        }
                    });
                }));
            } else {
                Object object = uploadingThemes.get(location);
                Theme.ThemeInfo themeInfo;
                Theme.ThemeAccent accent;

                TLRPC.InputFile uploadedThumb;
                TLRPC.InputFile uploadedFile;
                if (object instanceof Theme.ThemeInfo) {
                    themeInfo = (Theme.ThemeInfo) object;
                    accent = null;
                    if (location.equals(themeInfo.uploadingThumb)) {
                        themeInfo.uploadedThumb = file;
                        themeInfo.uploadingThumb = null;
                    } else if (location.equals(themeInfo.uploadingFile)) {
                        themeInfo.uploadedFile = file;
                        themeInfo.uploadingFile = null;
                    }
                    uploadedThumb = themeInfo.uploadedThumb;
                    uploadedFile = themeInfo.uploadedFile;
                } else if (object instanceof Theme.ThemeAccent) {
                    accent = (Theme.ThemeAccent) object;
                    if (location.equals(accent.uploadingThumb)) {
                        accent.uploadedThumb = file;
                        accent.uploadingThumb = null;
                    } else if (location.equals(accent.uploadingFile)) {
                        accent.uploadedFile = file;
                        accent.uploadingFile = null;
                    }
                    themeInfo = accent.parentTheme;
                    uploadedThumb = accent.uploadedThumb;
                    uploadedFile = accent.uploadedFile;
                } else {
                    themeInfo = null;
                    accent = null;
                    uploadedThumb = null;
                    uploadedFile = null;
                }
                uploadingThemes.remove(location);

                if (uploadedFile != null && uploadedThumb != null) {
                    File f = new File(location);
                    TL_account.uploadTheme req = new TL_account.uploadTheme();
                    req.mime_type = "application/x-tgtheme-android";
                    req.file_name = "theme.attheme";
                    req.file = uploadedFile;
                    req.file.name = "theme.attheme";
                    req.thumb = uploadedThumb;
                    req.thumb.name = "theme-preview.jpg";
                    req.flags |= 1;
                    TLRPC.TL_theme info;
                    TLRPC.TL_inputThemeSettings settings;
                    if (accent != null) {
                        accent.uploadedFile = null;
                        accent.uploadedThumb = null;
                        info = accent.info;
                        settings = new TLRPC.TL_inputThemeSettings();
                        settings.base_theme = Theme.getBaseThemeByKey(themeInfo.name);
                        settings.accent_color = accent.accentColor;
                        if (accent.accentColor2 != 0) {
                            settings.flags |= 8;
                            settings.outbox_accent_color = accent.accentColor2;
                        }
                        if (accent.myMessagesAccentColor != 0) {
                            settings.message_colors.add(accent.myMessagesAccentColor);
                            settings.flags |= 1;
                            if (accent.myMessagesGradientAccentColor1 != 0) {
                                settings.message_colors.add(accent.myMessagesGradientAccentColor1);
                                if (accent.myMessagesGradientAccentColor2 != 0) {
                                    settings.message_colors.add(accent.myMessagesGradientAccentColor2);
                                    if (accent.myMessagesGradientAccentColor3 != 0) {
                                        settings.message_colors.add(accent.myMessagesGradientAccentColor3);
                                    }
                                }
                            }
                            settings.message_colors_animated = accent.myMessagesAnimated;
                        }
                        settings.flags |= 2;
                        settings.wallpaper_settings = new TLRPC.TL_wallPaperSettings();
                        if (!TextUtils.isEmpty(accent.patternSlug)) {
                            TLRPC.TL_inputWallPaperSlug inputWallPaperSlug = new TLRPC.TL_inputWallPaperSlug();
                            inputWallPaperSlug.slug = accent.patternSlug;
                            settings.wallpaper = inputWallPaperSlug;
                            settings.wallpaper_settings.intensity = (int) (accent.patternIntensity * 100);
                            settings.wallpaper_settings.flags |= 8;
                        } else {
                            TLRPC.TL_inputWallPaperNoFile inputWallPaperNoFile = new TLRPC.TL_inputWallPaperNoFile();
                            inputWallPaperNoFile.id = 0;
                            settings.wallpaper = inputWallPaperNoFile;
                        }
                        settings.wallpaper_settings.motion = accent.patternMotion;
                        if (accent.backgroundOverrideColor != 0) {
                            settings.wallpaper_settings.background_color = (int) accent.backgroundOverrideColor;
                            settings.wallpaper_settings.flags |= 1;
                        }
                        if (accent.backgroundGradientOverrideColor1 != 0) {
                            settings.wallpaper_settings.second_background_color = (int) accent.backgroundGradientOverrideColor1;
                            settings.wallpaper_settings.flags |= 16;
                            settings.wallpaper_settings.rotation = AndroidUtilities.getWallpaperRotation(accent.backgroundRotation, true);
                        }
                        if (accent.backgroundGradientOverrideColor2 != 0) {
                            settings.wallpaper_settings.third_background_color = (int) accent.backgroundGradientOverrideColor2;
                            settings.wallpaper_settings.flags |= 32;
                        }
                        if (accent.backgroundGradientOverrideColor3 != 0) {
                            settings.wallpaper_settings.fourth_background_color = (int) accent.backgroundGradientOverrideColor3;
                            settings.wallpaper_settings.flags |= 64;
                        }
                    } else {
                        themeInfo.uploadedFile = null;
                        themeInfo.uploadedThumb = null;
                        info = themeInfo.info;
                        settings = null;
                    }
                    getConnectionsManager().sendRequest(req, (response, error) -> {
                        String title = info != null ? info.title : themeInfo.getName();
                        int index = title.lastIndexOf(".attheme");
                        String n = index > 0 ? title.substring(0, index) : title;
                        if (response != null) {
                            TLRPC.Document document = (TLRPC.Document) response;
                            TLRPC.TL_inputDocument inputDocument = new TLRPC.TL_inputDocument();
                            inputDocument.access_hash = document.access_hash;
                            inputDocument.id = document.id;
                            inputDocument.file_reference = document.file_reference;
                            if (info == null || !info.creator) {
                                TL_account.createTheme req2 = new TL_account.createTheme();
                                req2.document = inputDocument;
                                req2.flags |= 4;
                                req2.slug = info != null && !TextUtils.isEmpty(info.slug) ? info.slug : "";
                                req2.title = n;
                                if (settings != null) {
                                    req2.settings = settings;
                                    req2.flags |= 8;
                                }
                                getConnectionsManager().sendRequest(req2, (response1, error1) -> AndroidUtilities.runOnUIThread(() -> {
                                    if (response1 instanceof TLRPC.TL_theme) {
                                        Theme.setThemeUploadInfo(themeInfo, accent, (TLRPC.TL_theme) response1, currentAccount, false);
                                        installTheme(themeInfo, accent, themeInfo == Theme.getCurrentNightTheme());
                                        getNotificationCenter().postNotificationName(NotificationCenter.themeUploadedToServer, themeInfo, accent);
                                    } else {
                                        getNotificationCenter().postNotificationName(NotificationCenter.themeUploadError, themeInfo, accent);
                                    }
                                }));
                            } else {
                                TL_account.updateTheme req2 = new TL_account.updateTheme();
                                TLRPC.TL_inputTheme inputTheme = new TLRPC.TL_inputTheme();
                                inputTheme.id = info.id;
                                inputTheme.access_hash = info.access_hash;
                                req2.theme = inputTheme;

                                req2.slug = info.slug;
                                req2.flags |= 1;

                                req2.title = n;
                                req2.flags |= 2;

                                req2.document = inputDocument;
                                req2.flags |= 4;

                                if (settings != null) {
                                    req2.settings = settings;
                                    req2.flags |= 8;
                                }

                                req2.format = "android";
                                getConnectionsManager().sendRequest(req2, (response1, error1) -> AndroidUtilities.runOnUIThread(() -> {
                                    if (response1 instanceof TLRPC.TL_theme) {
                                        Theme.setThemeUploadInfo(themeInfo, accent, (TLRPC.TL_theme) response1, currentAccount, false);
                                        getNotificationCenter().postNotificationName(NotificationCenter.themeUploadedToServer, themeInfo, accent);
                                    } else {
                                        getNotificationCenter().postNotificationName(NotificationCenter.themeUploadError, themeInfo, accent);
                                    }
                                }));
                            }
                        } else {
                            AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.themeUploadError, themeInfo, accent));
                        }
                    });
                }
            }
        } else if (id == NotificationCenter.fileUploadFailed) {
            String location = (String) args[0];
            if (uploadingAvatar != null && uploadingAvatar.equals(location)) {
                uploadingAvatar = null;
            } else if (uploadingWallpaper != null && uploadingWallpaper.equals(location)) {
                uploadingWallpaper = null;
                uploadingWallpaperInfo = null;
            } else {
                Object object = uploadingThemes.remove(location);
                if (object instanceof Theme.ThemeInfo) {
                    Theme.ThemeInfo themeInfo = (Theme.ThemeInfo) object;
                    themeInfo.uploadedFile = null;
                    themeInfo.uploadedThumb = null;
                    getNotificationCenter().postNotificationName(NotificationCenter.themeUploadError, themeInfo, null);
                } else if (object instanceof Theme.ThemeAccent) {
                    Theme.ThemeAccent accent = (Theme.ThemeAccent) object;
                    accent.uploadingThumb = null;
                    getNotificationCenter().postNotificationName(NotificationCenter.themeUploadError, accent.parentTheme, accent);
                }
            }
        } if (id == NotificationCenter.fileUploadProgressChanged) {
            String location = (String) args[0];
            if (uploadingWallpaper != null && uploadingWallpaper.equals(location)) {
                Long loadedSize = (Long) args[1];
                Long totalSize = (Long) args[2];
                uploadingWallpaperInfo.uploadingProgress = loadedSize / (float) totalSize;
            }
        } else if (id == NotificationCenter.messageReceivedByServer) {
            Boolean scheduled = (Boolean) args[6];
            if (scheduled) {
                return;
            }
            Integer msgId = (Integer) args[0];
            Integer newMsgId = (Integer) args[1];
            Long did = (Long) args[3];
            ArrayList<MessageObject> dialogMessages = dialogMessage.get(did);
            for (int i = 0; dialogMessages != null && i < dialogMessages.size(); ++i) {
                MessageObject obj = dialogMessages.get(i);
                if (obj != null && (obj.getId() == msgId || obj.messageOwner.local_id == msgId)) {
                    obj.messageOwner.id = newMsgId;
                    obj.messageOwner.send_state = MessageObject.MESSAGE_SEND_STATE_SENT;
                }
                obj = dialogMessagesByIds.get(msgId);
                if (obj != null) {
                    dialogMessagesByIds.remove(msgId);
                    dialogMessagesByIds.put(newMsgId, obj);
                }
            }
            TLRPC.Dialog dialog = dialogs_dict.get(did);
            if (dialog != null && dialog.top_message == msgId) {
                dialog.top_message = newMsgId;
                getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
            }
            if (DialogObject.isChatDialog(did)) {
                TLRPC.ChatFull chatFull = fullChats.get(-did);
                TLRPC.Chat chat = getChat(-did);
                if (chat != null && !ChatObject.hasAdminRights(chat) && chatFull != null && chatFull.slowmode_seconds != 0) {
                    chatFull.slowmode_next_send_date = getConnectionsManager().getCurrentTime() + chatFull.slowmode_seconds;
                    chatFull.flags |= 262144;
                    getMessagesStorage().updateChatInfo(chatFull, false);
                }
            }
        } else if (id == NotificationCenter.updateMessageMedia) {
            TLRPC.Message message = (TLRPC.Message) args[0];
            if (message.peer_id.channel_id == 0) {
                MessageObject existMessageObject = dialogMessagesByIds.get(message.id);
                if (existMessageObject != null) {
                    existMessageObject.messageOwner.media = MessageObject.getMedia(message);
                    if (MessageObject.getMedia(message).ttl_seconds != 0 && (MessageObject.getMedia(message).photo instanceof TLRPC.TL_photoEmpty || MessageObject.getMedia(message).document instanceof TLRPC.TL_documentEmpty)) {
                        existMessageObject.setType();
                        getNotificationCenter().postNotificationName(NotificationCenter.notificationsSettingsUpdated);
                    }
                }
            }
        } else if (id == NotificationCenter.currentUserPremiumStatusChanged) {
            loadAppConfig(false);
            getContactsController().reloadContactsStatusesMaybe(true);
            if (storyQualityFull && !getUserConfig().isPremium() || getUserConfig().isPremium()) {
                getNotificationCenter().postNotificationName(NotificationCenter.storyQualityUpdate);
            }
        }
    }

    public void cleanup() {
        getContactsController().cleanup();
        MediaController.getInstance().cleanup();
        getNotificationsController().cleanup();
        getSendMessagesHelper().cleanup();
        getSecretChatHelper().cleanup();
        getLocationController().cleanup();
        getMediaDataController().cleanup();
        getColorPalette().cleanup();
        getTranslateController().cleanup();
        getSavedMessagesController().cleanup();
        if (storiesController != null) {
            storiesController.cleanup();
        }
        if (unconfirmedAuthController != null) {
            unconfirmedAuthController.cleanup();
        }

        showFiltersTooltip = false;

        DialogsActivity.dialogsLoaded[currentAccount] = false;

        SharedPreferences.Editor editor = notificationsPreferences.edit();
        editor.clear().commit();
        editor = emojiPreferences.edit();
        editor.putLong("lastGifLoadTime", 0).putLong("lastStickersLoadTime", 0).putLong("lastStickersLoadTimeMask", 0).putLong("lastStickersLoadTimeFavs", 0).commit();
        editor = mainPreferences.edit();
        editor.remove("archivehint").remove("proximityhint").remove("archivehint_l").remove("gifhint").remove("reminderhint").remove("soundHint").remove("dcDomainName2").remove("webFileDatacenterId").remove("themehint").remove("showFiltersTooltip").remove("transcribeButtonPressed").commit();

        SharedPreferences preferences = ApplicationLoader.applicationContext.getSharedPreferences("shortcut_widget", Activity.MODE_PRIVATE);
        SharedPreferences.Editor widgetEditor = null;
        AppWidgetManager appWidgetManager = null;
        ArrayList<Integer> chatsWidgets = null;
        ArrayList<Integer> contactsWidgets = null;
        Map<String, ?> values = preferences.getAll();
        for (Map.Entry<String, ?> entry : values.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("account")) {
                Integer value = (Integer) entry.getValue();
                if (value == currentAccount) {
                    int widgetId = Utilities.parseInt(key);
                    if (widgetEditor == null) {
                        widgetEditor = preferences.edit();
                        appWidgetManager = AppWidgetManager.getInstance(ApplicationLoader.applicationContext);
                    }
                    widgetEditor.putBoolean("deleted" + widgetId, true);
                    if (preferences.getInt("type" + widgetId, 0) == EditWidgetActivity.TYPE_CHATS) {
                        if (chatsWidgets == null) {
                            chatsWidgets = new ArrayList<>();
                        }
                        chatsWidgets.add(widgetId);
                    } else {
                        if (contactsWidgets == null) {
                            contactsWidgets = new ArrayList<>();
                        }
                        contactsWidgets.add(widgetId);
                    }
                }
            }
        }
        if (widgetEditor != null) {
            widgetEditor.commit();
        }
        if (chatsWidgets != null) {
            for (int a = 0, N = chatsWidgets.size(); a < N; a++) {
                ChatsWidgetProvider.updateWidget(ApplicationLoader.applicationContext, appWidgetManager, chatsWidgets.get(a));
            }
        }
        if (contactsWidgets != null) {
            for (int a = 0, N = contactsWidgets.size(); a < N; a++) {
                ContactsWidgetProvider.updateWidget(ApplicationLoader.applicationContext, appWidgetManager, contactsWidgets.get(a));
            }
        }

        lastScheduledServerQueryTime.clear();
        lastQuickReplyServerQueryTime.clear();
        lastSavedServerQueryTime.clear();
        lastServerQueryTime.clear();
        reloadingWebpages.clear();
        reloadingWebpagesPending.clear();
        reloadingScheduledWebpages.clear();
        reloadingScheduledWebpagesPending.clear();
        reloadingSavedWebpages.clear();
        reloadingSavedWebpagesPending.clear();
        sponsoredMessages.clear();
        sendAsPeers.clear();
        sendAsPeersLiveStories.clear();
        dialogs_dict.clear();
        dialogs_read_inbox_max.clear();
        loadingPinnedDialogs.clear();
        dialogs_read_outbox_max.clear();
        exportedChats.clear();
        fullUsers.clear();
        fullChats.clear();
        activeVoiceChatsMap.clear();
        loadingGroupCalls.clear();
        groupCallsByChatId.clear();
        dialogsByFolder.clear();
        unreadUnmutedDialogs = 0;
        joiningToChannels.clear();
        migratedChats.clear();
        channelViewsToSend.clear();
        pollsToCheck.clear();
        pollsToCheckSize = 0;
        dialogsServerOnly.clear();
        dialogsForward.clear();
        allDialogs.clear();
        dialogsLoadedTillDate = Integer.MAX_VALUE;
        dialogsCanAddUsers.clear();
        dialogsMyChannels.clear();
        dialogsMyGroups.clear();
        dialogsChannelsOnly.clear();
        dialogsGroupsOnly.clear();
        dialogsUsersOnly.clear();
        dialogsForBlock.clear();
        dialogMessagesByIds.clear();
        dialogMessagesByRandomIds.clear();
        channelAdmins.clear();
        loadingChannelAdmins.clear();
        users.clear();
        objectsByUsernames.clear();
        chats.clear();
        dialogMessage.clear();
        deletedHistory.clear();
        printingUsers.clear();
        printingStrings.clear();
        printingStringsTypes.clear();
        onlinePrivacy.clear();
        loadingPeerSettings.clear();
        deletingDialogs.clear();
        clearingHistoryDialogs.clear();
        lastPrintingStringCount = 0;
        selectedDialogFilter[0] = selectedDialogFilter[1] = null;
        dialogFilters.clear();
        dialogFiltersById.clear();
        loadingSuggestedFilters = false;
        loadingRemoteFilters = false;
        suggestedFilters.clear();
        dialogFiltersLoaded = false;
        ignoreSetOnline = false;

        Utilities.stageQueue.postRunnable(() -> {
            readTasks.clear();
            readTasksMap.clear();
            repliesReadTasks.clear();
            threadsReadTasksMap.clear();
            updatesQueueSeq.clear();
            updatesQueuePts.clear();
            updatesQueueQts.clear();
            gettingUnknownChannels.clear();
            gettingUnknownDialogs.clear();
            updatesStartWaitTimeSeq = 0;
            updatesStartWaitTimePts = 0;
            updatesStartWaitTimeQts = 0;
            createdDialogIds.clear();
            createdScheduledDialogIds.clear();
            gettingDifference = false;
            resetDialogsPinned = null;
            resetDialogsAll = null;
        });
        createdDialogMainThreadIds.clear();
        visibleDialogMainThreadIds.clear();
        visibleScheduledDialogMainThreadIds.clear();
        blockePeers.clear();
        for (int a = 0; a < sendingTypings.length; a++) {
            if (sendingTypings[a] == null) {
                continue;
            }
            sendingTypings[a].clear();
        }
        loadingFullUsers.clear();
        loadedFullUsers.clear();
        reloadingMessages.clear();
        loadingFullChats.clear();
        loadingFullParticipants.clear();
        loadedFullParticipants.clear();
        loadedFullChats.clear();

        dialogsLoaded = false;
        nextDialogsCacheOffset.clear();
        loadingDialogs.clear();
        dialogsEndReached.clear();
        serverDialogsEndReached.clear();

        checkingTosUpdate = false;
        nextTosCheckTime = 0;
        nextPromoInfoCheckTime = 0;
        checkingPromoInfo = false;
        loadingUnreadDialogs = false;

        currentDeletingTaskTime = 0;
        currentDeletingTaskMids = null;
        currentDeletingTaskMediaMids = null;
        gettingNewDeleteTask = false;
        loadingBlockedPeers = false;
        totalBlockedCount = -1;
        blockedEndReached = false;
        firstGettingTask = false;
        updatingState = false;
        resetingDialogs = false;
        lastStatusUpdateTime = 0;
        offlineSent = false;
        registeringForPush = false;
        getDifferenceFirstSync = true;
        uploadingAvatar = null;
        uploadingWallpaper = null;
        uploadingWallpaperInfo = null;
        uploadingThemes.clear();
        gettingChatInviters.clear();
        statusRequest = 0;
        statusSettingState = 0;

        Utilities.stageQueue.postRunnable(() -> {
            FileLog.d("cleanup: isUpdating = false");
            getConnectionsManager().setIsUpdating(false);
            updatesQueueChannels.clear();
            updatesStartWaitTimeChannels.clear();
            gettingDifferenceChannels.clear();
            channelsPts.clear();
            shortPollChannels.clear();
            needShortPollChannels.clear();
            shortPollOnlines.clear();
            needShortPollOnlines.clear();
        });

        if (currentDeleteTaskRunnable != null) {
            Utilities.stageQueue.cancelRunnable(currentDeleteTaskRunnable);
            currentDeleteTaskRunnable = null;
        }

        addSupportUser();
        AndroidUtilities.runOnUIThread(() -> {
            getNotificationCenter().postNotificationName(NotificationCenter.suggestedFiltersLoaded);
            getNotificationCenter().postNotificationName(NotificationCenter.dialogFiltersUpdated);
            getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
        });
    }

    public boolean isChatNoForwards(TLRPC.Chat chat) {
        if (chat == null) {
            return false;
        }
        if (chat.migrated_to != null) {
            TLRPC.Chat migratedTo = getChat(chat.migrated_to.channel_id);
            if (migratedTo != null) {
                return migratedTo.noforwards;
            }
        }
        return chat.noforwards;
    }

    public boolean isChatNoForwards(long chatId) {
        return isChatNoForwards(getChat(chatId));
    }

    public TLRPC.User getUser(Long id) {
        if (id == 0) {
            return UserConfig.getInstance(currentAccount).getCurrentUser();
        }
        return users.get(id);
    }

    public TLObject getUserOrChat(long dialogId) {
        if (users.containsKey(dialogId)) {
            return users.get(dialogId);
        } else if (chats.containsKey(-dialogId)) {
            return chats.get(-dialogId);
        }
        return null;
    }

    public TLObject getUserOrChat(String username) {
        if (username == null || username.length() == 0) {
            return null;
        }
        return objectsByUsernames.get(username.toLowerCase());
    }

    public TLRPC.User getUser(String username) {
        TLObject obj = getUserOrChat(username);
        if (obj instanceof TLRPC.User)
            return (TLRPC.User) obj;
        return null;
    }

    public ConcurrentHashMap<Long, TLRPC.User> getUsers() {
        return users;
    }

    public ConcurrentHashMap<Long, TLRPC.Chat> getChats() {
        return chats;
    }

    public TLRPC.Chat getChat(Long id) {
        return chats.get(id);
    }

    public TLRPC.EncryptedChat getEncryptedChat(Integer id) {
        return encryptedChats.get(id);
    }

    public TLRPC.EncryptedChat getEncryptedChatDB(int chatId, boolean created) {
        TLRPC.EncryptedChat chat = encryptedChats.get(chatId);
        if (chat == null || created && (chat instanceof TLRPC.TL_encryptedChatWaiting || chat instanceof TLRPC.TL_encryptedChatRequested)) {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ArrayList<TLObject> result = new ArrayList<>();
            getMessagesStorage().getEncryptedChat(chatId, countDownLatch, result);
            try {
                countDownLatch.await();
            } catch (Exception e) {
                FileLog.e(e);
            }
            if (result.size() == 2) {
                chat = (TLRPC.EncryptedChat) result.get(0);
                TLRPC.User user = (TLRPC.User) result.get(1);
                putEncryptedChat(chat, false);
                putUser(user, true);
            }
        }
        return chat;
    }

    public boolean isDialogVisible(long dialogId, boolean scheduled) {
        return scheduled ? visibleScheduledDialogMainThreadIds.contains(dialogId) : visibleDialogMainThreadIds.contains(dialogId);
    }

    public void setLastVisibleDialogId(final long dialogId, boolean scheduled, boolean set) {
        ArrayList<Long> arrayList = scheduled ? visibleScheduledDialogMainThreadIds : visibleDialogMainThreadIds;
        if (set) {
            if (arrayList.contains(dialogId)) {
                return;
            }
            arrayList.add(dialogId);
        } else {
            arrayList.remove(dialogId);
        }
    }

    public void setLastCreatedDialogId(final long dialogId, boolean scheduled, boolean set) {
        if (!scheduled) {
            ArrayList<Long> arrayList = createdDialogMainThreadIds;
            if (set) {
                if (arrayList.contains(dialogId)) {
                    return;
                }
                arrayList.add(dialogId);
            } else {
                arrayList.remove(dialogId);

                SparseArray<MessageObject> array = pollsToCheck.get(dialogId);
                if (array != null) {
                    for (int a = 0, N = array.size(); a < N; a++) {
                        MessageObject object = array.valueAt(a);
                        object.pollVisibleOnScreen = false;
                    }
                }
            }
        }
        Utilities.stageQueue.postRunnable(() -> {
            ArrayList<Long> arrayList2 = scheduled ? createdScheduledDialogIds : createdDialogIds;
            if (set) {
                if (arrayList2.contains(dialogId)) {
                    return;
                }
                arrayList2.add(dialogId);
            } else {
                arrayList2.remove(dialogId);
            }
        });
    }

    public TLRPC.TL_chatInviteExported getExportedInvite(long chatId) {
        return exportedChats.get(chatId);
    }

    public boolean putUser(TLRPC.User user, boolean fromCache) {
        return putUser(user, fromCache, false);
    }

    public boolean putUser(TLRPC.User user, boolean fromCache, boolean force) {
        if (user == null) {
            return false;
        }
        fromCache = fromCache && user.id / 1000 != 333 && user.id != 777000;
        TLRPC.User oldUser = users.get(user.id);
        if (oldUser == user && !force) {
            return false;
        }
        if (oldUser != null && !TextUtils.isEmpty(oldUser.username)) {
            objectsByUsernames.remove(oldUser.username.toLowerCase());
        }
        if (oldUser != null && oldUser.usernames != null) {
            for (int i = 0; i < oldUser.usernames.size(); ++i) {
                TLRPC.TL_username u = oldUser.usernames.get(i);
                if (u != null && u.username != null) {
                    objectsByUsernames.remove(u.username.toLowerCase());
                }
            }
        }
        if (!TextUtils.isEmpty(user.username)) {
            objectsByUsernames.put(user.username.toLowerCase(), user);
        }
        if (user != null && user.usernames != null) {
            for (int i = 0; i < user.usernames.size(); ++i) {
                TLRPC.TL_username u = user.usernames.get(i);
                if (u != null && u.username != null && u.active) {
                    objectsByUsernames.put(u.username.toLowerCase(), user);
                }
            }
        }
        updateEmojiStatusUntilUpdate(user.id, user.emoji_status);
        if (user.min) {
            if (oldUser != null) {
                if (!fromCache) {
                    getUserNameResolver().update(oldUser, user);
                    if (user.bot) {
                        if (user.username != null) {
                            oldUser.username = user.username;
                            oldUser.flags |= 8;
                        } else {
                            oldUser.flags = oldUser.flags & ~8;
                            oldUser.username = null;
                        }
                    }
                    if (user.apply_min_photo) {
                        if (user.photo != null) {
                            oldUser.photo = user.photo;
                            oldUser.flags |= 32;
                        } else {
                            oldUser.flags = oldUser.flags & ~32;
                            oldUser.photo = null;
                        }
                    }
                }
            } else {
                users.put(user.id, user);
            }
        } else {
            if (!fromCache) {
                users.put(user.id, user);
                if (user.id == getUserConfig().getClientUserId()) {
                    getUserConfig().setCurrentUser(user);
                    getUserConfig().saveConfig(true);
                }
                getUserNameResolver().update(oldUser, user);
                if (oldUser != null && user.status != null && oldUser.status != null && user.status.expires != oldUser.status.expires) {
                    return true;
                }
            } else if (oldUser == null) {
                users.put(user.id, user);
            } else if (oldUser.min) {
                if (oldUser.bot) {
                    if (oldUser.username != null) {
                        user.username = oldUser.username;
                        user.flags |= 8;
                    } else {
                        user.flags = user.flags & ~8;
                        user.username = null;
                    }
                }
                if (oldUser.apply_min_photo) {
                    if (oldUser.photo != null) {
                        user.photo = oldUser.photo;
                        user.flags |= 32;
                    } else {
                        user.flags = user.flags & ~32;
                        user.photo = null;
                    }
                }
                users.put(user.id, user);
            }
        }
        return false;
    }

    public void reloadUser(long userId) {
        TLRPC.TL_users_getUsers req = new TLRPC.TL_users_getUsers();
        TLRPC.InputUser inputPeer = getInputUser(userId);
        if (inputPeer == null) return;
        req.id.add(inputPeer);
        ConnectionsManager.getInstance(currentAccount).sendRequest(req, (res, err) -> {
            if (res instanceof Vector) {
                ArrayList<Object> objects = ((Vector) res).objects;
                ArrayList<TLRPC.User> users = new ArrayList<>();
                for (int i = 0; i < objects.size(); ++i) {
                    if (objects.get(i) instanceof TLRPC.User) {
                        users.add((TLRPC.User) objects.get(i));
                    }
                }
                getMessagesController().putUsers(users, false);
            }
        });
    }
    public void putUsers(ArrayList<TLRPC.User> users, boolean fromCache) {
        if (users == null || users.isEmpty()) {
            return;
        }
        boolean updateStatus = false;
        int count = users.size();
        for (int a = 0; a < count; a++) {
            TLRPC.User user = users.get(a);
            if (putUser(user, fromCache)) {
                updateStatus = true;
            }
        }
        if (updateStatus) {
            AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_STATUS));
        }
    }

    public void putChat(final TLRPC.Chat chat, boolean fromCache) {
        if (chat == null) {
            return;
        }
        TLRPC.Chat oldChat = chats.get(chat.id);
        if (oldChat == chat) {
            return;
        }
        if (oldChat != null && !TextUtils.isEmpty(oldChat.username)) {
            objectsByUsernames.remove(oldChat.username.toLowerCase());
        }
        if (oldChat != null && oldChat.usernames != null) {
            for (int i = 0; i < oldChat.usernames.size(); ++i) {
                TLRPC.TL_username u = oldChat.usernames.get(i);
                if (u != null && !TextUtils.isEmpty(u.username)) {
                    objectsByUsernames.remove(u.username.toLowerCase());
                }
            }
        }
        if (!TextUtils.isEmpty(chat.username)) {
            objectsByUsernames.put(chat.username.toLowerCase(), chat);
        }
        if (chat.usernames != null) {
            for (int i = 0; i < chat.usernames.size(); ++i) {
                TLRPC.TL_username u = chat.usernames.get(i);
                if (u != null && !TextUtils.isEmpty(u.username) && u.active) {
                    objectsByUsernames.put(u.username.toLowerCase(), chat);
                }
            }
        }
        updateEmojiStatusUntilUpdate(-chat.id, chat.emoji_status);
        if (chat.min) {
            if (oldChat != null) {
                if (!fromCache) {
                    getUserNameResolver().update(oldChat, chat);
                    oldChat.title = chat.title;
                    oldChat.photo = chat.photo;
                    oldChat.broadcast = chat.broadcast;
                    oldChat.verified = chat.verified;
                    oldChat.megagroup = chat.megagroup;
                    oldChat.call_not_empty = chat.call_not_empty;
                    oldChat.call_active = chat.call_active;
                    oldChat.monoforum = chat.monoforum;
                    oldChat.broadcast_messages_allowed = chat.broadcast_messages_allowed;
                    if ((chat.flags2 & 262144) != 0) {
                        oldChat.linked_monoforum_id = chat.linked_monoforum_id;
                        oldChat.flags2 |= 262144;
                    }
                    if (chat.default_banned_rights != null) {
                        oldChat.default_banned_rights = chat.default_banned_rights;
                        oldChat.flags |= 262144;
                    }
                    if (chat.admin_rights != null) {
                        oldChat.admin_rights = chat.admin_rights;
                        oldChat.flags |= 16384;
                    }
                    if (chat.banned_rights != null) {
                        oldChat.banned_rights = chat.banned_rights;
                        oldChat.flags |= 32768;
                    }
                    if (chat.username != null) {
                        oldChat.username = chat.username;
                        oldChat.flags |= 64;
                    } else {
                        oldChat.flags = oldChat.flags & ~64;
                        oldChat.username = null;
                    }
                    if (chat.participants_count != 0) {
                        oldChat.participants_count = chat.participants_count;
                    }
                    addOrRemoveActiveVoiceChat(oldChat);
                    if (oldChat.forum != chat.forum) {
                        oldChat.forum = chat.forum;
                        if (oldChat.forum) {
                            oldChat.flags |= 1073741824;
                        } else {
                            oldChat.flags = oldChat.flags & ~1073741824;
                        }
                        getNotificationCenter().postNotificationName(NotificationCenter.chatSwitchedForum, chat.id, chat.forum, chat.forum_tabs);
                    }
                }
            } else {
                chats.put(chat.id, chat);
                addOrRemoveActiveVoiceChat(chat);
            }
        } else {
            if (!fromCache) {
                if (oldChat != null) {
                    if (chat.version != oldChat.version) {
                        loadedFullChats.delete(chat.id);
                    }
                    if (oldChat.participants_count != 0 && chat.participants_count == 0) {
                        chat.participants_count = oldChat.participants_count;
                        chat.flags |= 131072;
                    }

                    int oldFlags = oldChat.banned_rights != null ? oldChat.banned_rights.flags : 0;
                    int newFlags = chat.banned_rights != null ? chat.banned_rights.flags : 0;
                    int oldFlags2 = oldChat.default_banned_rights != null ? oldChat.default_banned_rights.flags : 0;
                    int newFlags2 = chat.default_banned_rights != null ? chat.default_banned_rights.flags : 0;
                    oldChat.default_banned_rights = chat.default_banned_rights;
                    if (oldChat.default_banned_rights == null) {
                        oldChat.flags &= ~262144;
                    } else {
                        oldChat.flags |= 262144;
                    }
                    oldChat.banned_rights = chat.banned_rights;
                    if (oldChat.banned_rights == null) {
                        oldChat.flags &= ~32768;
                    } else {
                        oldChat.flags |= 32768;
                    }
                    oldChat.admin_rights = chat.admin_rights;
                    if (oldChat.admin_rights == null) {
                        oldChat.flags &= ~16384;
                    } else {
                        oldChat.flags |= 16384;
                    }
                    if (chat.stories_hidden_min) {
                        chat.stories_hidden = oldChat.stories_hidden;
                    }
                    if (oldFlags != newFlags || oldFlags2 != newFlags2) {
                        AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.channelRightsUpdated, chat));
                    }
                }
                chats.put(chat.id, chat);
            } else if (oldChat == null) {
                chats.put(chat.id, chat);
            } else if (oldChat.min) {
                chat.title = oldChat.title;
                chat.photo = oldChat.photo;
                chat.broadcast = oldChat.broadcast;
                chat.verified = oldChat.verified;
                chat.megagroup = oldChat.megagroup;

                if (oldChat.default_banned_rights != null) {
                    chat.default_banned_rights = oldChat.default_banned_rights;
                    chat.flags |= 262144;
                }
                if (oldChat.admin_rights != null) {
                    chat.admin_rights = oldChat.admin_rights;
                    chat.flags |= 16384;
                }
                if (oldChat.banned_rights != null) {
                    chat.banned_rights = oldChat.banned_rights;
                    chat.flags |= 32768;
                }
                if (oldChat.username != null) {
                    chat.username = oldChat.username;
                    chat.flags |= 64;
                } else {
                    chat.flags = chat.flags & ~64;
                    chat.username = null;
                }
                if (oldChat.participants_count != 0 && chat.participants_count == 0) {
                    chat.participants_count = oldChat.participants_count;
                    chat.flags |= 131072;
                }
                chats.put(chat.id, chat);
            }
            addOrRemoveActiveVoiceChat(chat);
        }
        if (oldChat != null && oldChat.forum != chat.forum) {
            AndroidUtilities.runOnUIThread(() -> {
                getNotificationCenter().postNotificationName(NotificationCenter.chatSwitchedForum, chat.id, chat.forum, chat.forum_tabs);
            });
        }
    }

    public void putChats(ArrayList<TLRPC.Chat> chats, boolean fromCache) {
        if (chats == null || chats.isEmpty()) {
            return;
        }
        int count = chats.size();
        for (int a = 0; a < count; a++) {
            TLRPC.Chat chat = chats.get(a);
            putChat(chat, fromCache);
        }
    }

    private void addOrRemoveActiveVoiceChat(TLRPC.Chat chat) {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            AndroidUtilities.runOnUIThread(() -> addOrRemoveActiveVoiceChatInternal(chat));
        } else {
            addOrRemoveActiveVoiceChatInternal(chat);
        }
    }

    private void addOrRemoveActiveVoiceChatInternal(TLRPC.Chat chat) {
        TLRPC.Chat currentChat = activeVoiceChatsMap.get(chat.id);
        if (chat.call_active && chat.call_not_empty && chat.migrated_to == null && !ChatObject.isNotInChat(chat)) {
            if (currentChat != null) {
                return;
            }
            activeVoiceChatsMap.put(chat.id, chat);
            getNotificationCenter().postNotificationName(NotificationCenter.activeGroupCallsUpdated);
        } else {
            if (currentChat == null) {
                return;
            }
            activeVoiceChatsMap.remove(chat.id);
            getNotificationCenter().postNotificationName(NotificationCenter.activeGroupCallsUpdated);
        }
    }

    public ArrayList<Long> getActiveGroupCalls() {
        return new ArrayList<>(activeVoiceChatsMap.keySet());
    }

    public void setReferer(String referer) {
        if (referer == null) {
            return;
        }
        installReferer = referer;
        mainPreferences.edit().putString("installReferer", referer).commit();
    }

    public void putEncryptedChat(TLRPC.EncryptedChat encryptedChat, boolean fromCache) {
        if (encryptedChat == null) {
            return;
        }
        if (fromCache) {
            encryptedChats.putIfAbsent(encryptedChat.id, encryptedChat);
        } else {
            encryptedChats.put(encryptedChat.id, encryptedChat);
        }
    }

    public void putEncryptedChats(ArrayList<TLRPC.EncryptedChat> encryptedChats, boolean fromCache) {
        if (encryptedChats == null || encryptedChats.isEmpty()) {
            return;
        }
        int count = encryptedChats.size();
        for (int a = 0; a < count; a++) {
            TLRPC.EncryptedChat encryptedChat = encryptedChats.get(a);
            putEncryptedChat(encryptedChat, fromCache);
        }
    }

    public long getSendPaidMessagesStars(long did) {
        if (did > 0) {
            if (did == getUserConfig().getClientUserId()) {
                return 0;
            }
            final TLRPC.UserFull userFull = getUserFull(did);
            if (userFull != null) {
                return userFull.send_paid_messages_stars;
            }
            final TLRPC.User user = getUser(did);
            if (user != null && user.send_paid_messages_stars > 0) {
                return DialogObject.getMessagesStarsPrice(isUserContactBlocked(user.id));
            }
        } else if (did < 0) {
            final TLRPC.Chat chat = getChat(-did);
            if (ChatObject.hasAdminRights(chat)) {
                return 0;
            }
            if (ChatObject.isMonoForum(chat) && ChatObject.canManageMonoForum(currentAccount, chat)) {
                return 0;
            }

            TLRPC.ChatFull chatFull = getChatFull(-did);
            if (chatFull != null) {
                return chatFull.send_paid_messages_stars;
            } else if (chat != null) {
                return chat.send_paid_messages_stars;
            }
            return 0;
        }
        return 0;
    }

    public void putMonoForumLinkedChat(long chatId, long monoForumChatId) {
        monoForumLinkedChannels.put(chatId, monoForumChatId);
        monoForumLinkedChannels.put(monoForumChatId, chatId);
    }

    public TLRPC.Chat getMonoForumLinkedChat(long chatId) {
        TLRPC.Chat chat2 = getChat(chatId);
        if (chat2 != null) {
            final TLRPC.Chat chat = getChat(chat2.linked_monoforum_id);
            if (chat != null) {
                return chat;
            }
        }
        final Long linkedChatId = monoForumLinkedChannels.get(chatId);
        if (linkedChatId != null) {
            final TLRPC.Chat chat = getChat(linkedChatId);
            if (chat != null) {
                return chat;
            }
        }

        return null;
    }

    public TLRPC.UserFull getUserFull(long uid) {
        return fullUsers.get(uid);
    }

    public TLRPC.ChatFull getChatFull(long chatId) {
        return fullChats.get(chatId);
    }

    public void putGroupCall(long chatId, ChatObject.Call call) {
        groupCalls.put(call.call.id, call);
        groupCallsByChatId.put(chatId, call);
        TLRPC.ChatFull chatFull = getChatFull(chatId);
        if (chatFull != null) {
            chatFull.call = call.getInputGroupCall();
        }
        getNotificationCenter().postNotificationName(NotificationCenter.groupCallUpdated, chatId, call.call.id, false);
        loadFullChat(chatId, 0, true);
    }

    public ChatObject.Call getGroupCall(long chatId, boolean load) {
        return getGroupCall(chatId, load, null);
    }

    public ChatObject.Call getGroupCall(long chatId, boolean load, Runnable onLoad) {
        TLRPC.ChatFull chatFull = getChatFull(chatId);
        if (chatFull == null || chatFull.call == null) {
            return null;
        }
        ChatObject.Call result = groupCalls.get(chatFull.call.id);
        if (result == null && load && !loadingGroupCalls.contains(chatId)) {
            loadingGroupCalls.add(chatId);
            if (chatFull.call != null) {
                final TL_phone.getGroupCall req = new TL_phone.getGroupCall();
                req.call = chatFull.call;
                req.limit = 20;
                getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> {
                    if (response != null) {
                        final TL_phone.groupCall groupCall = (TL_phone.groupCall) response;
                        putUsers(groupCall.users, false);
                        putChats(groupCall.chats, false);

                        final ChatObject.Call call = new ChatObject.Call();
                        call.setCall(getAccountInstance(), chatId, groupCall);
                        groupCalls.put(groupCall.call.id, call);
                        groupCallsByChatId.put(chatId, call);
                        getNotificationCenter().postNotificationName(NotificationCenter.groupCallUpdated, chatId, groupCall.call.id, false);
                        if (onLoad != null) {
                            onLoad.run();
                        }
                    }
                    loadingGroupCalls.remove(chatId);
                }));
            }
        }
        if (result != null && result.call instanceof TLRPC.TL_groupCallDiscarded) {
            return null;
        }
        return result;
    }

    public void cancelLoadFullUser(long userId) {
        loadingFullUsers.remove(userId);
    }

    public void cancelLoadFullChat(long chatId) {
        loadingFullChats.remove(chatId);
    }

    public void clearFullUsers() {
        loadedFullUsers.clear();
        loadedFullChats.clear();
    }

    private final LongSparseArray<Long> peerDialogsRequested = new LongSparseArray<Long>();
    private final long peerDialogRequestTimeout = 1000 * 60 * 4;

    private void reloadDialogsReadValue(ArrayList<TLRPC.Dialog> dialogs, long did) {
        if (did == 0 && (dialogs == null || dialogs.isEmpty())) {
            return;
        }
        TLRPC.TL_messages_getPeerDialogs req = new TLRPC.TL_messages_getPeerDialogs();
        if (dialogs != null) {
            for (int a = 0; a < dialogs.size(); a++) {
                TLRPC.InputPeer inputPeer = getInputPeer(dialogs.get(a).id);
                if (inputPeer instanceof TLRPC.TL_inputPeerChannel && inputPeer.access_hash == 0) {
                    continue;
                }
                TLRPC.TL_inputDialogPeer inputDialogPeer = new TLRPC.TL_inputDialogPeer();
                inputDialogPeer.peer = inputPeer;
                final long _did = DialogObject.getPeerDialogId(inputPeer);
                Long lastRequest = peerDialogsRequested.get(_did);
                if (lastRequest == null || System.currentTimeMillis() - lastRequest > peerDialogRequestTimeout) {
                    req.peers.add(inputDialogPeer);
                    peerDialogsRequested.put(_did, System.currentTimeMillis());
                }
            }
        } else {
            TLRPC.InputPeer inputPeer = getInputPeer(did);
            if (inputPeer instanceof TLRPC.TL_inputPeerChannel && inputPeer.access_hash == 0) {
                return;
            }
            TLRPC.TL_inputDialogPeer inputDialogPeer = new TLRPC.TL_inputDialogPeer();
            inputDialogPeer.peer = inputPeer;
            final long _did = DialogObject.getPeerDialogId(inputPeer);
            Long lastRequest = peerDialogsRequested.get(_did);
            if (lastRequest == null || System.currentTimeMillis() - lastRequest > peerDialogRequestTimeout) {
                req.peers.add(inputDialogPeer);
                peerDialogsRequested.put(_did, System.currentTimeMillis());
            }
        }
        if (req.peers.isEmpty()) {
            return;
        }
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response != null) {
                TLRPC.TL_messages_peerDialogs res = (TLRPC.TL_messages_peerDialogs) response;
                ArrayList<TLRPC.Update> arrayList = new ArrayList<>();
                for (int a = 0; a < res.dialogs.size(); a++) {
                    TLRPC.Dialog dialog = res.dialogs.get(a);
                    DialogObject.initDialog(dialog);

                    Integer value = dialogs_read_inbox_max.get(dialog.id);
                    if (value == null) {
                        value = 0;
                    }
                    dialogs_read_inbox_max.put(dialog.id, Math.max(dialog.read_inbox_max_id, value));
                    if (value == 0) {
                        if (dialog.peer.channel_id != 0) {
                            TLRPC.TL_updateReadChannelInbox update = new TLRPC.TL_updateReadChannelInbox();
                            update.channel_id = dialog.peer.channel_id;
                            update.max_id = dialog.read_inbox_max_id;
                            update.still_unread_count = dialog.unread_count;
                            arrayList.add(update);
                        } else {
                            TLRPC.TL_updateReadHistoryInbox update = new TLRPC.TL_updateReadHistoryInbox();
                            update.peer = dialog.peer;
                            update.max_id = dialog.read_inbox_max_id;
                            arrayList.add(update);
                        }
                    }

                    value = dialogs_read_outbox_max.get(dialog.id);
                    if (value == null) {
                        value = 0;
                    }
                    dialogs_read_outbox_max.put(dialog.id, Math.max(dialog.read_outbox_max_id, value));
                    if (dialog.read_outbox_max_id > value) {
                        if (dialog.peer.channel_id != 0) {
                            TLRPC.TL_updateReadChannelOutbox update = new TLRPC.TL_updateReadChannelOutbox();
                            update.channel_id = dialog.peer.channel_id;
                            update.max_id = dialog.read_outbox_max_id;
                            arrayList.add(update);
                        } else {
                            TLRPC.TL_updateReadHistoryOutbox update = new TLRPC.TL_updateReadHistoryOutbox();
                            update.peer = dialog.peer;
                            update.max_id = dialog.read_outbox_max_id;
                            arrayList.add(update);
                        }
                    }
                }
                if (!arrayList.isEmpty()) {
                    processUpdateArray(arrayList, null, null, false, 0);
                }
            }
        });
    }

    public TLRPC.ChannelParticipant getAdminInChannel(long uid, long chatId) {
        LongSparseArray<TLRPC.ChannelParticipant> array = channelAdmins.get(chatId);
        if (array == null) {
            return null;
        }
        return array.get(uid);
    }

    public String getAdminRank(long chatId, long uid) {
        if (chatId == uid) {
            return "";
        }
        LongSparseArray<TLRPC.ChannelParticipant> array = channelAdmins.get(chatId);
        if (array == null) {
            return null;
        }
        TLRPC.ChannelParticipant participant = array.get(uid);
        if (participant == null) {
            return null;
        }
        return participant.rank != null ? participant.rank : "";
    }

    public boolean isChannelAdminsLoaded(long chatId) {
        return channelAdmins.get(chatId) != null;
    }

    public void loadChannelAdmins(long chatId, boolean cache) {
        int loadTime = loadingChannelAdmins.get(chatId);
        if ((SystemClock.elapsedRealtime() / 1000) - loadTime < 60) {
            return;
        }
        loadingChannelAdmins.put(chatId, (int) (SystemClock.elapsedRealtime() / 1000));
        if (cache) {
            getMessagesStorage().loadChannelAdmins(chatId);
        } else {
            TLRPC.TL_channels_getParticipants req = new TLRPC.TL_channels_getParticipants();
            req.channel = getInputChannel(chatId);
            req.limit = 100;
            req.filter = new TLRPC.TL_channelParticipantsAdmins();
            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (response instanceof TLRPC.TL_channels_channelParticipants) {
                    processLoadedAdminsResponse(chatId, (TLRPC.TL_channels_channelParticipants) response);
                }
            });
        }
    }

    public void processLoadedAdminsResponse(long chatId, TLRPC.TL_channels_channelParticipants participants) {
        LongSparseArray<TLRPC.ChannelParticipant> array1 = new LongSparseArray<>(participants.participants.size());
        for (int a = 0; a < participants.participants.size(); a++) {
            TLRPC.ChannelParticipant participant = participants.participants.get(a);
            array1.put(MessageObject.getPeerId(participant.peer), participant);
        }
        processLoadedChannelAdmins(array1, chatId, false);
    }

    public void processLoadedChannelAdmins(final LongSparseArray<TLRPC.ChannelParticipant> array, long chatId, boolean cache) {
        if (!cache) {
            getMessagesStorage().putChannelAdmins(chatId, array);
        }
        AndroidUtilities.runOnUIThread(() -> {
            channelAdmins.put(chatId, array);
            if (cache) {
                loadingChannelAdmins.delete(chatId);
                loadChannelAdmins(chatId, false);
                getNotificationCenter().postNotificationName(NotificationCenter.didLoadChatAdmins, chatId);
            }
        });
    }

    public void loadFullChat(long chatId, int classGuid, boolean force) {
        long lastLoadedTime = loadedFullChats.get(chatId, 0);
        boolean loaded = lastLoadedTime > 0;
        if (loadingFullChats.contains(chatId) || !force && loaded) {
            return;
        }
        loadingFullChats.add(chatId);
        TLObject request;
        long dialogId = -chatId;
        TLRPC.Chat chat = getChat(chatId);
        if (ChatObject.isChannel(chat)) {
            TLRPC.TL_channels_getFullChannel req = new TLRPC.TL_channels_getFullChannel();
            req.channel = getInputChannel(chat);
            request = req;
            loadChannelAdmins(chatId, !loaded);
        } else {
            TLRPC.TL_messages_getFullChat req = new TLRPC.TL_messages_getFullChat();
            req.chat_id = chatId;
            request = req;
            if (dialogs_read_inbox_max.get(dialogId) == null || dialogs_read_outbox_max.get(dialogId) == null) {
                reloadDialogsReadValue(null, dialogId);
            }
        }
        int reqId = getConnectionsManager().sendRequest(request, (response, error) -> {
            if (error == null) {
                TLRPC.TL_messages_chatFull res = (TLRPC.TL_messages_chatFull) response;
                getMessagesStorage().putUsersAndChats(res.users, res.chats, true, true);
                getMessagesStorage().updateChatInfo(res.full_chat, false);
                getStoriesController().updateStoriesFromFullPeer(dialogId, res.full_chat.stories);
                ChatThemeController.getInstance(currentAccount).saveChatWallpaper(-chatId, res.full_chat.wallpaper);
                if (ChatObject.isChannel(chat)) {
                    Integer value = dialogs_read_inbox_max.get(dialogId);
                    if (value == null) {
                        value = getMessagesStorage().getDialogReadMax(false, dialogId);
                    }

                    dialogs_read_inbox_max.put(dialogId, Math.max(res.full_chat.read_inbox_max_id, value));
                    if (res.full_chat.read_inbox_max_id > value) {
                        ArrayList<TLRPC.Update> arrayList = new ArrayList<>();
                        TLRPC.TL_updateReadChannelInbox update = new TLRPC.TL_updateReadChannelInbox();
                        update.channel_id = chatId;
                        update.max_id = res.full_chat.read_inbox_max_id;
                        update.still_unread_count = res.full_chat.unread_count;
                        arrayList.add(update);
                        processUpdateArray(arrayList, null, null, false, 0);
                    }

                    value = dialogs_read_outbox_max.get(dialogId);
                    if (value == null) {
                        value = getMessagesStorage().getDialogReadMax(true, dialogId);
                    }
                    dialogs_read_outbox_max.put(dialogId, Math.max(res.full_chat.read_outbox_max_id, value));
                    if (res.full_chat.read_outbox_max_id > value) {
                        ArrayList<TLRPC.Update> arrayList = new ArrayList<>();
                        TLRPC.TL_updateReadChannelOutbox update = new TLRPC.TL_updateReadChannelOutbox();
                        update.channel_id = chatId;
                        update.max_id = res.full_chat.read_outbox_max_id;
                        arrayList.add(update);
                        processUpdateArray(arrayList, null, null, false, 0);
                    }
                }

                AndroidUtilities.runOnUIThread(() -> {
                    TLRPC.ChatFull old = fullChats.get(chatId);
                    if (old != null) {
                        res.full_chat.inviterId = old.inviterId;
                    }
                    fullChats.put(chatId, res.full_chat);
                    getTranslateController().updateDialogFull(-chatId);

                    applyDialogNotificationsSettings(-chatId, 0, res.full_chat.notify_settings);
                    for (int a = 0; a < res.full_chat.bot_info.size(); a++) {
                        TL_bots.BotInfo botInfo = res.full_chat.bot_info.get(a);
                        getMediaDataController().putBotInfo(-chatId, botInfo);
                    }
                    int index = blockePeers.indexOfKey(-chatId);
                    if (res.full_chat.blocked) {
                        if (index < 0) {
                            blockePeers.put(-chatId, 1);
                            getNotificationCenter().postNotificationName(NotificationCenter.blockedUsersDidLoad);
                        }
                    } else {
                        if (index >= 0) {
                            blockePeers.removeAt(index);
                            getNotificationCenter().postNotificationName(NotificationCenter.blockedUsersDidLoad);
                        }
                    }
                    exportedChats.put(chatId, res.full_chat.exported_invite);
                    loadingFullChats.remove(chatId);
                    loadedFullChats.put(chatId,  System.currentTimeMillis());

                    putUsers(res.users, false);
                    putChats(res.chats, false);
                    if (res.full_chat.stickerset != null) {
                        getMediaDataController().getGroupStickerSetById(res.full_chat.stickerset);
                    }
                    if (res.full_chat.emojiset != null) {
                        getMediaDataController().getGroupStickerSetById(res.full_chat.emojiset);
                    }
                    getNotificationCenter().postNotificationName(NotificationCenter.chatInfoDidLoad, res.full_chat, classGuid, false, true);

                    TLRPC.Dialog dialog = dialogs_dict.get(-chatId);
                    if (dialog != null) {
                        if ((res.full_chat.flags & 2048) != 0) {
                            if (dialog.folder_id != res.full_chat.folder_id) {
                                dialog.folder_id = res.full_chat.folder_id;
                                sortDialogs(null);
                                getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                            }
                        }
                        if (dialog.ttl_period != res.full_chat.ttl_period) {
                            dialog.ttl_period = res.full_chat.ttl_period;
                            getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                        }
                        if (dialog.view_forum_as_messages != res.full_chat.view_forum_as_messages) {
                            dialog.view_forum_as_messages = res.full_chat.view_forum_as_messages;
                            getMessagesStorage().setDialogViewThreadAsMessages(dialogId, res.full_chat.view_forum_as_messages);
                        }
                    }
                });
            } else {
                AndroidUtilities.runOnUIThread(() -> {
                    checkChannelError(error.text, chatId);
                    loadingFullChats.remove(chatId);
                });
            }
        });
        if (classGuid != 0) {
            getConnectionsManager().bindRequestToGuid(reqId, classGuid);
        }
    }

    public void loadFullUser(final TLRPC.User user, int classGuid, boolean force) {
        loadFullUser(user, classGuid, force, null);
    }
    public void loadFullUser(final TLRPC.User user, int classGuid, boolean force, Utilities.Callback<TLRPC.UserFull> whenReceivedFullUser) {
        if (user == null || whenReceivedFullUser == null && (loadingFullUsers.contains(user.id) || !force && loadedFullUsers.get(user.id) > 0)) {
            return;
        }
        loadingFullUsers.add(user.id);
        TLRPC.TL_users_getFullUser req = new TLRPC.TL_users_getFullUser();
        req.id = getInputUser(user);
        long dialogId = user.id;
        if (dialogs_read_inbox_max.get(dialogId) == null || dialogs_read_outbox_max.get(dialogId) == null) {
            reloadDialogsReadValue(null, dialogId);
        }
        int reqId = getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error == null) {
                TLRPC.TL_users_userFull res = (TLRPC.TL_users_userFull) response;
                TLRPC.UserFull userFull = res.full_user;
                putUsers(res.users, false);
                putChats(res.chats, false);
                res.full_user.user = getUser(res.full_user.id);
                getMessagesStorage().updateUserInfo(userFull, false);
                getStoriesController().updateStoriesFromFullPeer(dialogId, userFull.stories);
                ChatThemeController.getInstance(currentAccount).saveChatWallpaper(res.full_user.id, res.full_user.wallpaper);

                if (whenReceivedFullUser != null) {
                    whenReceivedFullUser.run(userFull);
                }

                AndroidUtilities.runOnUIThread(() -> {
                    savePeerSettings(userFull.user.id, userFull.settings, false);

                    applyDialogNotificationsSettings(user.id, 0, userFull.notify_settings);
                    if (userFull.bot_info instanceof TL_bots.TL_botInfo) {
                        userFull.bot_info.user_id = user.id;
                        getMediaDataController().putBotInfo(user.id, userFull.bot_info);
                    }
                    int index = blockePeers.indexOfKey(user.id);
                    if (userFull.blocked) {
                        if (index < 0) {
                            blockePeers.put(user.id, 1);
                            getNotificationCenter().postNotificationName(NotificationCenter.blockedUsersDidLoad);
                        }
                    } else {
                        if (index >= 0) {
                            blockePeers.removeAt(index);
                            getNotificationCenter().postNotificationName(NotificationCenter.blockedUsersDidLoad);
                        }
                    }
                    fullUsers.put(user.id, userFull);
                    getTranslateController().updateDialogFull(user.id);
                    StarsController.getInstance(currentAccount).invalidateProfileGifts(userFull);
                    loadingFullUsers.remove(user.id);
                    loadedFullUsers.put(user.id, System.currentTimeMillis());
                    String names = user.first_name + user.last_name + UserObject.getPublicUsername(user);
                    ArrayList<TLRPC.User> users = new ArrayList<>();
                    users.add(userFull.user);
                    putUsers(users, false);
                    getMessagesStorage().putUsersAndChats(users, null, false, true);
                    if (!names.equals(userFull.user.first_name + userFull.user.last_name + UserObject.getPublicUsername(userFull.user))) {
                        getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_NAME);
                    }
                    if (userFull.user.photo != null && userFull.user.photo.has_video) {
                        getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_AVATAR);
                    }
                    if (userFull.bot_info instanceof TL_bots.TL_botInfo) {
                        userFull.bot_info.user_id = userFull.id;
                        getNotificationCenter().postNotificationName(NotificationCenter.botInfoDidLoad, userFull.bot_info, classGuid);
                    }
                    getNotificationCenter().postNotificationName(NotificationCenter.userInfoDidLoad, user.id, userFull);

                    TLRPC.Dialog dialog = dialogs_dict.get(user.id);
                    if (dialog != null) {
                        if ((userFull.flags & 2048) != 0 && dialog.folder_id != userFull.folder_id) {
                            dialog.folder_id = userFull.folder_id;
                            sortDialogs(null);
                            getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                        }
                        if ((userFull.flags & 16384) != 0 && dialog.ttl_period != userFull.ttl_period) {
                            dialog.ttl_period = userFull.ttl_period;
                            getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                        }
                    }
                });
            } else {
                AndroidUtilities.runOnUIThread(() -> loadingFullUsers.remove(user.id));
            }
        });
        getConnectionsManager().bindRequestToGuid(reqId, classGuid);
    }

    private void reloadMessages(ArrayList<Integer> mids, long dialogId, int mode) {
        if (mids.isEmpty()) {
            return;
        }
        final boolean scheduled = mode == ChatActivity.MODE_SCHEDULED;
        final boolean saved = mode == ChatActivity.MODE_SAVED;
        TLObject request;
        ArrayList<Integer> result = new ArrayList<>();
        TLRPC.Chat chat;
        if (DialogObject.isChatDialog(dialogId)) {
            chat = getChat(-dialogId);
        } else {
            chat = null;
        }
        if (ChatObject.isChannel(chat)) {
            TLRPC.TL_channels_getMessages req = new TLRPC.TL_channels_getMessages();
            req.channel = getInputChannel(chat);
            req.id = result;
            request = req;
        } else {
            TLRPC.TL_messages_getMessages req = new TLRPC.TL_messages_getMessages();
            req.id = result;
            request = req;
        }
        ArrayList<Integer> arrayList = reloadingMessages.get(dialogId);
        for (int a = 0; a < mids.size(); a++) {
            Integer mid = mids.get(a);
            if (arrayList != null && arrayList.contains(mid)) {
                continue;
            }
            result.add(mid);
        }
        if (result.isEmpty()) {
            return;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<>();
            reloadingMessages.put(dialogId, arrayList);
        }
        arrayList.addAll(result);
        getConnectionsManager().sendRequest(request, (response, error) -> {
            if (error == null) {
                TLRPC.messages_Messages messagesRes = (TLRPC.messages_Messages) response;

                LongSparseArray<TLRPC.User> usersLocal = new LongSparseArray<>();
                for (int a = 0; a < messagesRes.users.size(); a++) {
                    TLRPC.User u = messagesRes.users.get(a);
                    usersLocal.put(u.id, u);
                }
                LongSparseArray<TLRPC.Chat> chatsLocal = new LongSparseArray<>();
                for (int a = 0; a < messagesRes.chats.size(); a++) {
                    TLRPC.Chat c = messagesRes.chats.get(a);
                    chatsLocal.put(c.id, c);
                }

                Integer inboxValue = dialogs_read_inbox_max.get(dialogId);
                if (inboxValue == null) {
                    inboxValue = getMessagesStorage().getDialogReadMax(false, dialogId);
                    dialogs_read_inbox_max.put(dialogId, inboxValue);
                }

                Integer outboxValue = dialogs_read_outbox_max.get(dialogId);
                if (outboxValue == null) {
                    outboxValue = getMessagesStorage().getDialogReadMax(true, dialogId);
                    dialogs_read_outbox_max.put(dialogId, outboxValue);
                }

                ArrayList<MessageObject> objects = new ArrayList<>();
                for (int a = 0; a < messagesRes.messages.size(); a++) {
                    TLRPC.Message message = messagesRes.messages.get(a);
                    message.dialog_id = dialogId;
                    if (!scheduled) {
                        message.unread = (message.out ? outboxValue : inboxValue) < message.id;
                    }
                    objects.add(new MessageObject(currentAccount, message, usersLocal, chatsLocal, true, true));
                }

                ImageLoader.saveMessagesThumbs(messagesRes.messages);
                getMessagesStorage().putMessages(messagesRes, dialogId, -1, 0, false, mode, 0);

                AndroidUtilities.runOnUIThread(() -> {
                    ArrayList<Integer> arrayList1 = reloadingMessages.get(dialogId);
                    if (arrayList1 != null) {
                        arrayList1.removeAll(result);
                        if (arrayList1.isEmpty()) {
                            reloadingMessages.remove(dialogId);
                        }
                    }
                    ArrayList<MessageObject> dialogObjs = dialogMessage.get(dialogId);
                    if (dialogObjs != null) {
                        for (int i = 0; i < dialogObjs.size(); ++i) {
                            MessageObject dialogObj = dialogObjs.get(i);
                            for (int a = 0; a < objects.size(); a++) {
                                MessageObject obj = objects.get(a);
                                if (dialogObj.getId() == obj.getId()) {
                                    dialogObjs.set(i, obj);
                                    if (obj.messageOwner.peer_id.channel_id == 0) {
                                        MessageObject obj2 = dialogMessagesByIds.get(obj.getId());
                                        dialogMessagesByIds.remove(obj.getId());
                                        if (obj2 != null) {
                                            dialogMessagesByIds.put(obj2.getId(), obj2);
                                        }
                                    }
                                    getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                                    break;
                                }
                            }
                        }
                    }
                    getNotificationCenter().postNotificationName(NotificationCenter.replaceMessagesObjects, dialogId, objects);
                });
            }
        });
    }

    public void hidePeerSettingsBar(final long dialogId, TLRPC.User currentUser, TLRPC.Chat currentChat) {
        if (currentUser == null && currentChat == null) {
            return;
        }
        SharedPreferences.Editor editor = notificationsPreferences.edit();
        editor.putInt("dialog_bar_vis3" + dialogId, 3);
        editor.remove("dialog_bar_invite" + dialogId);
        editor.commit();
        if (!DialogObject.isEncryptedDialog(dialogId)) {
            TLRPC.TL_messages_hidePeerSettingsBar req = new TLRPC.TL_messages_hidePeerSettingsBar();
            if (currentUser != null) {
                req.peer = getInputPeer(currentUser.id);
            } else {
                req.peer = getInputPeer(-currentChat.id);
            }
            getConnectionsManager().sendRequest(req, (response, error) -> {

            });
        }
    }

    public void reportSpam(final long dialogId, TLRPC.User currentUser, TLRPC.Chat currentChat, TLRPC.EncryptedChat currentEncryptedChat, boolean geo) {
        if (currentUser == null && currentChat == null && currentEncryptedChat == null) {
            return;
        }
        SharedPreferences.Editor editor = notificationsPreferences.edit();
        editor.putInt("dialog_bar_vis3" + dialogId, 3);
        editor.commit();
        if (DialogObject.isEncryptedDialog(dialogId)) {
            if (currentEncryptedChat == null || currentEncryptedChat.access_hash == 0) {
                return;
            }
            TLRPC.TL_messages_reportEncryptedSpam req = new TLRPC.TL_messages_reportEncryptedSpam();
            req.peer = new TLRPC.TL_inputEncryptedChat();
            req.peer.chat_id = currentEncryptedChat.id;
            req.peer.access_hash = currentEncryptedChat.access_hash;
            getConnectionsManager().sendRequest(req, (response, error) -> {

            }, ConnectionsManager.RequestFlagFailOnServerErrors);
        } else {
            if (geo) {
                TL_account.reportPeer req = new TL_account.reportPeer();
                if (currentChat != null) {
                    req.peer = getInputPeer(-currentChat.id);
                } else if (currentUser != null) {
                    req.peer = getInputPeer(currentUser.id);
                }
                req.message = "";
                req.reason = new TLRPC.TL_inputReportReasonGeoIrrelevant();
                getConnectionsManager().sendRequest(req, (response, error) -> {

                }, ConnectionsManager.RequestFlagFailOnServerErrors);
            } else {
                TLRPC.TL_messages_reportSpam req = new TLRPC.TL_messages_reportSpam();
                if (currentChat != null) {
                    req.peer = getInputPeer(-currentChat.id);
                } else if (currentUser != null) {
                    req.peer = getInputPeer(currentUser.id);
                }
                getConnectionsManager().sendRequest(req, (response, error) -> {

                }, ConnectionsManager.RequestFlagFailOnServerErrors);
            }
        }
    }

    private void savePeerSettings(long dialogId, TLRPC.PeerSettings settings, boolean update) {
        if (settings == null) {
            return;
        }
        final SharedPreferences.Editor editor = notificationsPreferences.edit();
        if (settings.business_bot_id != 0) {
            editor.putLong("dialog_botid" + dialogId, settings.business_bot_id);
            editor.putString("dialog_boturl" + dialogId, settings.business_bot_manage_url);
            editor.putInt("dialog_botflags" + dialogId, (settings.business_bot_paused ? 1 : 0) + (settings.business_bot_can_reply ? 2 : 0));
        } else {
            editor.remove("dialog_botid" + dialogId).remove("dialog_boturl" + dialogId).remove("dialog_botflags" + dialogId);
        }
        editor.putLong("dialog_bar_paying_" + dialogId, settings.charge_paid_message_stars);
        if (notificationsPreferences.getInt("dialog_bar_vis3" + dialogId, 0) == 3) {
            editor.apply();
            getNotificationCenter().postNotificationName(NotificationCenter.peerSettingsDidLoad, dialogId);
            return;
        }
        boolean bar_hidden = settings.flags == 0;
        if (BuildVars.LOGS_ENABLED) {
            FileLog.d("peer settings loaded for " + dialogId + " add = " + settings.add_contact + " block = " + settings.block_contact + " spam = " + settings.report_spam + " share = " + settings.share_contact + " geo = " + settings.report_geo + " hide = " + bar_hidden + " distance = " + settings.geo_distance + " invite = " + settings.invite_members);
        }
        editor.putInt("dialog_bar_vis3" + dialogId, bar_hidden ? 1 : 2);
        editor.putBoolean("dialog_bar_share" + dialogId, settings.share_contact);
        editor.putBoolean("dialog_bar_report" + dialogId, settings.report_spam);
        editor.putBoolean("dialog_bar_add" + dialogId, settings.add_contact);
        editor.putBoolean("dialog_bar_block" + dialogId, settings.block_contact);
        editor.putBoolean("dialog_bar_exception" + dialogId, settings.need_contacts_exception);
        editor.putBoolean("dialog_bar_location" + dialogId, settings.report_geo);
        editor.putBoolean("dialog_bar_archived" + dialogId, settings.autoarchived);
        editor.putBoolean("dialog_bar_invite" + dialogId, settings.invite_members);
        editor.putString("dialog_bar_chat_with_admin_title" + dialogId, settings.request_chat_title);
        editor.putBoolean("dialog_bar_chat_with_channel" + dialogId, settings.request_chat_broadcast);
        editor.putInt("dialog_bar_chat_with_date" + dialogId, settings.request_chat_date);
        if (notificationsPreferences.getInt("dialog_bar_distance" + dialogId, -1) != -2) {
            if ((settings.flags & 64) != 0) {
                editor.putInt("dialog_bar_distance" + dialogId, settings.geo_distance);
            } else {
                editor.remove("dialog_bar_distance" + dialogId);
            }
        }
        if (dialogId == getUserConfig().getClientUserId()) {
            settings.business_bot_id = UserObject.REPLY_BOT;
            settings.business_bot_manage_url = "https://telegram.org/";
        }
        editor.apply();
        userPeerSettings.put(dialogId, settings);
        getNotificationCenter().postNotificationName(NotificationCenter.peerSettingsDidLoad, dialogId);
    }

    public TLRPC.PeerSettings getPeerSettings(long dialogId) {
        TLRPC.UserFull userFull = getUserFull(dialogId);
        if (userFull != null && userFull.settings != null) {
            return userFull.settings;
        }
        return userPeerSettings.get(dialogId);
    }

    public void loadPeerSettings(TLRPC.User currentUser, TLRPC.Chat currentChat) {
        loadPeerSettings(currentUser, currentChat, false);
    }
    public void loadPeerSettings(TLRPC.User currentUser, TLRPC.Chat currentChat, boolean force) {
        if (currentUser == null && currentChat == null) {
            return;
        }
        long dialogId;
        if (currentUser != null) {
            dialogId = currentUser.id;
        } else {
            dialogId = -currentChat.id;
        }
        if (loadingPeerSettings.indexOfKey(dialogId) >= 0) {
            return;
        }
        if (BuildVars.LOGS_ENABLED) {
            FileLog.d("request spam button for " + dialogId);
        }
        int vis = notificationsPreferences.getInt("dialog_bar_vis3" + dialogId, 0);
        if (!force && (vis == 1 || vis == 3)) {
            if (BuildVars.LOGS_ENABLED) {
                FileLog.d("dialog bar already hidden for " + dialogId);
            }
            return;
        }
        loadingPeerSettings.put(dialogId, true);
        TLRPC.TL_messages_getPeerSettings req = new TLRPC.TL_messages_getPeerSettings();
        if (currentUser != null) {
            req.peer = getInputPeer(currentUser.id);
        } else {
            req.peer = getInputPeer(-currentChat.id);
        }
        getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> {
            loadingPeerSettings.remove(dialogId);
            if (response != null) {
                TLRPC.TL_messages_peerSettings res = (TLRPC.TL_messages_peerSettings) response;
                TLRPC.PeerSettings settings = res.settings;
                putUsers(res.users, false);
                putChats(res.chats, false);

                savePeerSettings(dialogId, settings, false);
            }
        }));
    }

    protected void processNewChannelDifferenceParams(int pts, int pts_count, long channelId) {
        if (BuildVars.LOGS_ENABLED) {
            FileLog.d("processNewChannelDifferenceParams pts = " + pts + " pts_count = " + pts_count + " channeldId = " + channelId);
        }
        int channelPts = channelsPts.get(channelId);
        if (channelPts == 0) {
            channelPts = getMessagesStorage().getChannelPtsSync(channelId);
            if (channelPts == 0) {
                channelPts = 1;
            }
            channelsPts.put(channelId, channelPts);
        }
        if (channelPts + pts_count == pts) {
            if (BuildVars.LOGS_ENABLED) {
                FileLog.d("APPLY CHANNEL PTS");
            }
            channelsPts.put(channelId, pts);
            getMessagesStorage().saveChannelPts(channelId, pts);
        } else if (channelPts != pts) {
            long updatesStartWaitTime = updatesStartWaitTimeChannels.get(channelId);
            boolean gettingDifferenceChannel = gettingDifferenceChannels.get(channelId, false);
            if (gettingDifferenceChannel || updatesStartWaitTime == 0 || Math.abs(System.currentTimeMillis() - updatesStartWaitTime) <= 1500) {
                if (BuildVars.LOGS_ENABLED) {
                    FileLog.d("ADD CHANNEL UPDATE TO QUEUE pts = " + pts + " pts_count = " + pts_count);
                }
                if (updatesStartWaitTime == 0) {
                    updatesStartWaitTimeChannels.put(channelId, System.currentTimeMillis());
                }
                UserActionUpdatesPts updates = new UserActionUpdatesPts();
                updates.pts = pts;
                updates.pts_count = pts_count;
                updates.chat_id = channelId;
                ArrayList<TLRPC.Updates> arrayList = updatesQueueChannels.get(channelId);
                if (arrayList == null) {
                    arrayList = new ArrayList<>();
                    updatesQueueChannels.put(channelId, arrayList);
                }
                arrayList.add(updates);
            } else {
                getChannelDifference(channelId);
            }
        }
    }

    public void processNewDifferenceParams(int seq, int pts, int date, int pts_count) {
        if (BuildVars.LOGS_ENABLED) {
            FileLog.d("processNewDifferenceParams seq = " + seq + " pts = " + pts + " date = " + date + " pts_count = " + pts_count);
        }
        if (pts != -1) {
            if (getMessagesStorage().getLastPtsValue() + pts_count == pts) {
                if (BuildVars.LOGS_ENABLED) {
                    FileLog.d("APPLY PTS");
                }
                getMessagesStorage().setLastPtsValue(pts);
                getMessagesStorage().saveDiffParams(getMessagesStorage().getLastSeqValue(), getMessagesStorage().getLastPtsValue(), getMessagesStorage().getLastDateValue(), getMessagesStorage().getLastQtsValue());
            } else if (getMessagesStorage().getLastPtsValue() != pts) {
                if (gettingDifference || updatesStartWaitTimePts == 0 || Math.abs(System.currentTimeMillis() - updatesStartWaitTimePts) <= 1500) {
                    if (BuildVars.LOGS_ENABLED) {
                        FileLog.d("ADD UPDATE TO QUEUE pts = " + pts + " pts_count = " + pts_count);
                    }
                    if (updatesStartWaitTimePts == 0) {
                        updatesStartWaitTimePts = System.currentTimeMillis();
                    }
                    UserActionUpdatesPts updates = new UserActionUpdatesPts();
                    updates.pts = pts;
                    updates.pts_count = pts_count;
                    updatesQueuePts.add(updates);
                } else {
                    getDifference();
                }
            }
        }
        if (seq != -1) {
            if (getMessagesStorage().getLastSeqValue() + 1 == seq) {
                if (BuildVars.LOGS_ENABLED) {
                    FileLog.d("APPLY SEQ");
                }
                getMessagesStorage().setLastSeqValue(seq);
                if (date != -1) {
                    getMessagesStorage().setLastDateValue(date);
                }
                getMessagesStorage().saveDiffParams(getMessagesStorage().getLastSeqValue(), getMessagesStorage().getLastPtsValue(), getMessagesStorage().getLastDateValue(), getMessagesStorage().getLastQtsValue());
            } else if (getMessagesStorage().getLastSeqValue() != seq) {
                if (gettingDifference || updatesStartWaitTimeSeq == 0 || Math.abs(System.currentTimeMillis() - updatesStartWaitTimeSeq) <= 1500) {
                    if (BuildVars.LOGS_ENABLED) {
                        FileLog.d("ADD UPDATE TO QUEUE seq = " + seq);
                    }
                    if (updatesStartWaitTimeSeq == 0) {
                        updatesStartWaitTimeSeq = System.currentTimeMillis();
                    }
                    UserActionUpdatesSeq updates = new UserActionUpdatesSeq();
                    updates.seq = seq;
                    updatesQueueSeq.add(updates);
                } else {
                    getDifference();
                }
            }
        }
    }

    public void didAddedNewTask(int minDate, long dialogId, SparseArray<ArrayList<Integer>> mids) {
        Utilities.stageQueue.postRunnable(() -> {
            if (currentDeletingTaskMids == null && currentDeletingTaskMediaMids == null && !gettingNewDeleteTask || currentDeletingTaskTime != 0 && minDate < currentDeletingTaskTime) {
                getNewDeleteTask(null, null);
            }
        });
        if (mids != null) {
            AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.didCreatedNewDeleteTask, dialogId, mids));
        }
    }

    public void getNewDeleteTask(LongSparseArray<ArrayList<Integer>> oldTask, LongSparseArray<ArrayList<Integer>> oldTaskMedia) {
        Utilities.stageQueue.postRunnable(() -> {
            gettingNewDeleteTask = true;
            getMessagesStorage().getNewTask(oldTask, oldTaskMedia);
        });
    }

    private boolean checkDeletingTask(boolean runnable) {
        int currentServerTime = getConnectionsManager().getCurrentTime();

        if ((currentDeletingTaskMids != null || currentDeletingTaskMediaMids != null) && (runnable || currentDeletingTaskTime != 0 && currentDeletingTaskTime <= currentServerTime)) {
            currentDeletingTaskTime = 0;
            if (currentDeleteTaskRunnable != null && !runnable) {
                Utilities.stageQueue.cancelRunnable(currentDeleteTaskRunnable);
            }
            currentDeleteTaskRunnable = null;
            LongSparseArray<ArrayList<Integer>> task = currentDeletingTaskMids != null ? currentDeletingTaskMids.clone() : null;
            LongSparseArray<ArrayList<Integer>> taskMedia = currentDeletingTaskMediaMids != null ? currentDeletingTaskMediaMids.clone() : null;
            AndroidUtilities.runOnUIThread(() -> {
                if (task != null) {
                    for (int a = 0, N = task.size(); a < N; a++) {
                        ArrayList<Integer> mids = task.valueAt(a);
                        deleteMessages(mids, null, null, task.keyAt(a), 0, true, 0, !mids.isEmpty() && mids.get(0) > 0);
                    }
                }
                if (taskMedia != null) {
                    final boolean checkViewer = SecretMediaViewer.hasInstance() && SecretMediaViewer.getInstance().isVisible();
                    final MessageObject viewerObject = checkViewer ? SecretMediaViewer.getInstance().getCurrentMessageObject() : null;
                    for (int a = 0, N = taskMedia.size(); a < N; a++) {
                        long dialogId = taskMedia.keyAt(a);
                        ArrayList<Integer> mids = taskMedia.valueAt(a);
                        if (checkViewer && viewerObject != null && viewerObject.currentAccount == currentAccount && viewerObject.getDialogId() == dialogId && mids.contains(viewerObject.getId())) {
                            final int id = viewerObject.getId();
                            mids.remove((Integer) id);
                            viewerObject.forceExpired = true;
                            final long taskId = createDeleteShowOnceTask(dialogId, id);
                            SecretMediaViewer.getInstance().setOnClose(() -> doDeleteShowOnceTask(taskId, dialogId, id));
                            getNotificationCenter().postNotificationName(NotificationCenter.updateMessageMedia, viewerObject.messageOwner);
                        }
                        if (!mids.isEmpty()) {
                            getMessagesStorage().emptyMessagesMedia(dialogId, mids);
                        }
                    }
                }
                Utilities.stageQueue.postRunnable(() -> {
                    getNewDeleteTask(task, taskMedia);
                    currentDeletingTaskTime = 0;
                    currentDeletingTaskMids = null;
                    currentDeletingTaskMediaMids = null;
                });
            });
            return true;
        }
        return false;
    }

    public void processLoadedDeleteTask(int taskTime, LongSparseArray<ArrayList<Integer>> task, LongSparseArray<ArrayList<Integer>> taskMedia) {
        Utilities.stageQueue.postRunnable(() -> {
            gettingNewDeleteTask = false;
            if (task != null || taskMedia != null) {
                currentDeletingTaskTime = taskTime;
                currentDeletingTaskMids = task;
                currentDeletingTaskMediaMids = taskMedia;

                if (currentDeleteTaskRunnable != null) {
                    Utilities.stageQueue.cancelRunnable(currentDeleteTaskRunnable);
                    currentDeleteTaskRunnable = null;
                }

                if (!checkDeletingTask(false)) {
                    currentDeleteTaskRunnable = () -> checkDeletingTask(true);
                    int currentServerTime = getConnectionsManager().getCurrentTime();
                    Utilities.stageQueue.postRunnable(currentDeleteTaskRunnable, (long) Math.abs(currentServerTime - currentDeletingTaskTime) * 1000);
                }
            } else {
                currentDeletingTaskTime = 0;
                currentDeletingTaskMids = null;
                currentDeletingTaskMediaMids = null;
            }
        });
    }

    private LongSparseArray<DialogPhotos> dialogPhotos = new LongSparseArray<>();

    public DialogPhotos getDialogPhotos(long dialogId) {
        DialogPhotos photos = dialogPhotos.get(dialogId);
        if (photos == null) {
            dialogPhotos.put(dialogId, photos = new DialogPhotos(dialogId));
        }
        return photos;
    }

    public class DialogPhotos {

        public final long dialogId;
        public final ArrayList<TLRPC.Photo> photos = new ArrayList<>();
        public boolean fromCache = true;
        public boolean loaded = false;

        public final static int STEP = 80;

        public DialogPhotos(long dialogId) {
            this.dialogId = dialogId;
        }

        public void loadAfter(int position, boolean after) {
            if (photos.isEmpty()) {
                load(0, STEP);
                return;
            }
            if (position < 0) {
                position += photos.size();
            }
            if (position >= photos.size()) {
                position -= photos.size();
            }
            if (position < 0 || position >= photos.size()) {
                return;
            }

            boolean hasEmpty = false;
            for (int i = 0; i < photos.size(); ++i) {
                if (photos.get(i) == null) {
                    hasEmpty = true;
                    break;
                }
            }

            if (!hasEmpty) {
                return;
            }

            if (after) {
                int p = position;
                while (photos.get(p) != null) {
                    p++;
                    if (p >= photos.size()) {
                        p = 0;
                    }
                }
                int count;
                for (count = 0; count <= STEP && p + count < photos.size() && photos.get(p + count) == null; ++count);
                if (count > 0) {
                    load(p, count);
                }
            } else {
                int p = position;
                while (photos.get(p) != null) {
                    p--;
                    if (p < 0) {
                        p = photos.size() - 1;
                    }
                }
                int count;
                for (count = 0; count <= STEP && p - count >= 0 && photos.get(p - count) == null; ++count);
                if (count > 0) {
                    load(p - count, count);
                }
            }
        }


        private boolean loading;
        private int lastLoadOffset = -1, lastLoadCount = -1;
        public void load(int offset, int count) {
            if (loading || count <= 0 || offset < 0) {
                return;
            }
            if (count == lastLoadCount && offset == lastLoadOffset) {
                return;
            }

            loading = true;
            lastLoadOffset = offset;
            lastLoadCount = count;
            int reqId;
            if (dialogId >= 0) {
                TLRPC.User user = getUser(dialogId);
                if (user == null) {
                    loading = false;
                    return;
                }
                TLRPC.TL_photos_getUserPhotos req = new TLRPC.TL_photos_getUserPhotos();
                req.offset = offset;
                req.limit = count;
                req.max_id = 0;
                req.user_id = getInputUser(user);
                reqId = getConnectionsManager().sendRequest(req, (response, error) -> {
                    if (error == null) {
                        final TLRPC.photos_Photos res = (TLRPC.photos_Photos) response;
                        getMessagesStorage().putUsersAndChats(res.users, null, true, true);
                        AndroidUtilities.runOnUIThread(() -> {
                            putUsers(res.users, false);
                            onLoaded(offset, count, res);
                        });
                    }
                });
            } else {
                TLRPC.TL_messages_search req = new TLRPC.TL_messages_search();
                req.filter = new TLRPC.TL_inputMessagesFilterChatPhotos();
                req.add_offset = offset;
                req.limit = count;
                req.offset_id = 0;
                req.q = "";
                req.peer = getInputPeer(dialogId);
                reqId = getConnectionsManager().sendRequest(req, (response, error) -> {
                    if (error == null) {
                        TLRPC.messages_Messages messages = (TLRPC.messages_Messages) response;
                        getMessagesStorage().putUsersAndChats(messages.users, messages.chats, true, true);
                        AndroidUtilities.runOnUIThread(() -> {
                            putUsers(messages.users, false);
                            putChats(messages.chats, false);
                            TLRPC.photos_Photos res = new TLRPC.TL_photos_photos();
                            res.count = messages.count;
                            for (int a = 0; a < messages.messages.size(); a++) {
                                TLRPC.Message message = messages.messages.get(a);
                                if (message.action == null || message.action.photo == null) {
                                    continue;
                                }
                                res.photos.add(message.action.photo);
                            }
                            onLoaded(offset, count, res);
                        });
                    }
                });
            }
        }

        private void onLoaded(int offset, int count, TLRPC.photos_Photos res) {
            boolean wasLoaded = loaded;
            loading = false;
            loaded = true;
            fromCache = false;

            res.count = Math.max(res.count, res.photos.size());

            boolean reset = res.count != photos.size() || offset + count > photos.size();
            if (!reset) {
                for (int i = 0; i < res.photos.size(); ++i) {
                    if (photos.get(offset + i) != null && photos.get(offset + i).id != res.photos.get(i).id) {
                        reset = true;
                        break;
                    }
                }
            }

            if (reset) {
                photos.clear();
                for (int i = 0; i < res.count; ++i) {
                    int lindex = i - offset;
                    photos.add(lindex >= 0 && lindex < res.photos.size() ? res.photos.get(lindex) : null);
                }
            } else {
                for (int i = 0; i < res.photos.size(); ++i) {
                    photos.set(offset + i, res.photos.get(i));
                }
            }

            saveCache();
            getNotificationCenter().postNotificationName(NotificationCenter.dialogPhotosUpdate, this);

            if (!wasLoaded && offset == 0 && count < photos.size() && photos.size() - count > STEP) {
                load(photos.size() - STEP, STEP);
            }
        }

        public void addPhotoAtStart(TLRPC.Photo photo) {
            if (true) {
                return;
            }
            if (photo == null || !loaded && !fromCache) {
                return;
            }

            removePhotoInternal(photo.id);
            photos.add(0, photo);
            saveCache();

            getNotificationCenter().postNotificationName(NotificationCenter.dialogPhotosUpdate, this);
        }

        public void removePhoto(long photoId) {
            if (removePhotoInternal(photoId)) {
                saveCache();
                getNotificationCenter().postNotificationName(NotificationCenter.dialogPhotosUpdate, this);
            }
        }

        public void moveToStart(int index) {
            if (index < 0 || index >= photos.size()) {
                return;
            }

            photos.add(0, photos.remove(index));
            saveCache();
            getNotificationCenter().postNotificationName(NotificationCenter.dialogPhotosUpdate, this);
        }

        private boolean removePhotoInternal(long photoId) {
            boolean changed = false;
            for (int i = 0; i < photos.size(); ++i) {
                TLRPC.Photo p = photos.get(i);
                if (p != null && p.id == photoId) {
                    photos.remove(i);
                    i--;
                    changed = true;
                }
            }
            return changed;
        }

        public int getCount() {
            return photos.size();
        }

        public void loadCache() {
            getMessagesStorage().getStorageQueue().postRunnable(() -> {
                SQLiteDatabase database = getMessagesStorage().getDatabase();
                SQLiteCursor cursor = null;
                int count = 0;
                final HashMap<Integer, TLRPC.Photo> photoEntries = new HashMap<>();
                try {
                    cursor = database.queryFinalized(String.format(Locale.US, "SELECT count FROM dialog_photos_count WHERE uid = %d", dialogId));
                    if (cursor.next()) {
                        count = cursor.intValue(0);
                    }
                    cursor.dispose();
                    cursor = null;

                    cursor = database.queryFinalized(String.format(Locale.US, "SELECT num, data FROM dialog_photos WHERE uid = %d", dialogId));
                    while (cursor.next()) {
                        int position = cursor.intValue(0);
                        TLRPC.Photo photo = null;
                        NativeByteBuffer data = cursor.byteBufferValue(1);
                        if (data != null) {
                            int magic = data.readInt32(false);
                            if (magic == TLRPC.TL_null.constructor) {
                                photo = null;
                            } else {
                                photo = TLRPC.Photo.TLdeserialize(data, magic, false);
                            }
                        }
                        if (photo != null) {
                            count = Math.max(position + 1, count);
                            photoEntries.put(position, photo);
                        }
                    }
                    cursor.dispose();
                    cursor = null;
                } catch (Exception e) {

                } finally {
                    if (cursor != null) {
                        cursor.dispose();
                        cursor = null;
                    }
                }

                count = Math.max(count, photoEntries.size());
                final int finalCount = count;
                AndroidUtilities.runOnUIThread(() -> {
                    photos.clear();
                    lastLoadOffset = -1;
                    lastLoadCount = -1;
                    for (int i = 0; i < finalCount; ++i) {
                        photos.add(null);
                    }
                    for (Map.Entry<Integer, TLRPC.Photo> entry : photoEntries.entrySet()) {
                        photos.set(entry.getKey(), entry.getValue());
                    }
                    getNotificationCenter().postNotificationName(NotificationCenter.dialogPhotosUpdate, this);

                    load(0, STEP);
                });
            });
        }

        private void saveCache() {
            getMessagesStorage().getStorageQueue().postRunnable(() -> {
                SQLiteDatabase database = getMessagesStorage().getDatabase();
                SQLitePreparedStatement state = null;
                try {
                    database.executeFast("DELETE FROM dialog_photos WHERE uid = " + dialogId).stepThis().dispose();
                    database.executeFast("DELETE FROM dialog_photos_count WHERE uid = " + dialogId).stepThis().dispose();

                    database.executeFast("REPLACE INTO dialog_photos_count VALUES(" + dialogId + ", " + photos.size() + ")").stepThis().dispose();

                    state = database.executeFast("REPLACE INTO dialog_photos VALUES(?, ?, ?, ?)");
                    for (int i = 0; i < photos.size(); ++i) {
                        TLRPC.Photo photo = photos.get(i);
                        if (photo == null) {
                            continue;
                        }
                        if (photo.file_reference == null) {
                            photo.file_reference = new byte[0];
                        }

                        state.requery();
                        NativeByteBuffer data = new NativeByteBuffer(photo.getObjectSize());
                        photo.serializeToStream(data);
                        state.bindLong(1, dialogId);
                        state.bindLong(2, photo.id);
                        state.bindInteger(3, i);
                        state.bindByteBuffer(4, data);
                        state.step();
                        data.reuse();
                    }
                    state.dispose();
                    state = null;
                } catch (Exception e) {

                } finally {
                    if (state != null) {
                        state.dispose();
                        state = null;
                    }
                }
            });
        }

        public void reset() {
            photos.clear();
            lastLoadOffset = -1;
            lastLoadCount = -1;
            fromCache = true;
            saveCache();
        }
    }

    public void blockPeer(long id) {
        TLRPC.User user = null;
        TLRPC.Chat chat = null;
        if (id > 0) {
            user = getUser(id);
            if (user == null) {
                return;
            }
        } else {
            chat = getChat(-id);
            if (chat == null) {
                return;
            }
        }
        if (blockePeers.indexOfKey(id) >= 0) {
            return;
        }
        blockePeers.put(id, 1);
        if (user != null) {
            if (user.bot) {
                getMediaDataController().removeInline(id);
            } else {
                getMediaDataController().removePeer(id);
            }
        }
        if (totalBlockedCount >= 0) {
            totalBlockedCount++;
        }
        getNotificationCenter().postNotificationName(NotificationCenter.blockedUsersDidLoad);
        TLRPC.TL_contacts_block req = new TLRPC.TL_contacts_block();
        if (user != null) {
            req.id = getInputPeer(user);
        } else {
            req.id = getInputPeer(chat);
        }
        getConnectionsManager().sendRequest(req, (response, error) -> {

        });
    }

    public void setParticipantBannedRole(long chatId, TLRPC.User user, TLRPC.Chat chat, TLRPC.TL_chatBannedRights rights, boolean isChannel, BaseFragment parentFragment) {
        setParticipantBannedRole(chatId, user, chat, rights, isChannel, parentFragment, null);
    }

    public void setParticipantBannedRole(long chatId, TLRPC.User user, TLRPC.Chat chat, TLRPC.TL_chatBannedRights rights, boolean isChannel, BaseFragment parentFragment, Runnable whenDone) {
        if (user == null && chat == null || rights == null) {
            return;
        }
        TLRPC.TL_channels_editBanned req = new TLRPC.TL_channels_editBanned();
        req.channel = getInputChannel(chatId);
        if (user != null) {
            req.participant = getInputPeer(user);
        } else {
            req.participant = getInputPeer(chat);
        }
        req.banned_rights = rights;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error == null) {
                processUpdates((TLRPC.Updates) response, false);
                AndroidUtilities.runOnUIThread(() -> loadFullChat(chatId, 0, true), 1000);
                if (whenDone != null) {
                    AndroidUtilities.runOnUIThread(whenDone);
                }
            } else {
                AndroidUtilities.runOnUIThread(() -> AlertsCreator.processError(currentAccount, error, parentFragment, req, isChannel));
            }
        });
    }

    public void setChannelSlowMode(long chatId, int seconds) {
        TLRPC.TL_channels_toggleSlowMode req = new TLRPC.TL_channels_toggleSlowMode();
        req.seconds = seconds;
        req.channel = getInputChannel(chatId);
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error == null) {
                getMessagesController().processUpdates((TLRPC.Updates) response, false);
                AndroidUtilities.runOnUIThread(() -> loadFullChat(chatId, 0, true), 1000);
            }
        });
    }

    public void setBoostsToUnblockRestrictions(long chatId, int boosts) {
        TLRPC.TL_channels_setBoostsToUnblockRestrictions req = new TLRPC.TL_channels_setBoostsToUnblockRestrictions();
        req.boosts = boosts;
        req.channel = getInputChannel(chatId);
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error == null) {
                getMessagesController().processUpdates((TLRPC.Updates) response, false);
                AndroidUtilities.runOnUIThread(() -> loadFullChat(chatId, 0, true), 1000);
            }
        });
    }

    public void setDefaultBannedRole(long chatId, TLRPC.TL_chatBannedRights rights, boolean isChannel, BaseFragment parentFragment) {
        if (rights == null) {
            return;
        }
        TLRPC.TL_messages_editChatDefaultBannedRights req = new TLRPC.TL_messages_editChatDefaultBannedRights();
        req.peer = getInputPeer(-chatId);
        req.banned_rights = rights;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error == null) {
                processUpdates((TLRPC.Updates) response, false);
                AndroidUtilities.runOnUIThread(() -> loadFullChat(chatId, 0, true), 1000);
            } else {
                AndroidUtilities.runOnUIThread(() -> AlertsCreator.processError(currentAccount, error, parentFragment, req, isChannel));
            }
        });
    }

    public void setUserAdminRole(long chatId, TLRPC.User user, TLRPC.TL_chatAdminRights rights, String rank, boolean isChannel, BaseFragment parentFragment, boolean addingNew, boolean forceAdmin, String botHash, Runnable onSuccess) {
        setUserAdminRole(chatId, user, rights, rank, isChannel, parentFragment, addingNew, forceAdmin, botHash, onSuccess, null);
    }

    public void setUserAdminRole(long chatId, TLRPC.User user, TLRPC.TL_chatAdminRights rights, String rank, boolean isChannel, BaseFragment parentFragment, boolean addingNew, boolean forceAdmin, String botHash, Runnable onSuccess, ErrorDelegate onError) {
        if (user == null || rights == null) {
            return;
        }
        TLRPC.Chat chat = getChat(chatId);
        if (ChatObject.isChannel(chat)) {
            TLRPC.TL_channels_editAdmin req = new TLRPC.TL_channels_editAdmin();
            req.channel = getInputChannel(chat);
            req.user_id = getInputUser(user);
            req.admin_rights = rights;
            req.rank = rank;
            RequestDelegate requestDelegate = (response, error) -> {
                if (error == null) {
                    processUpdates((TLRPC.Updates) response, false);
                    AndroidUtilities.runOnUIThread(() -> {
                        loadFullChat(chatId, 0, true);
                        if (onSuccess != null) {
                            onSuccess.run();
                        }
                    }, 1000);
                } else {
                    if (error != null && "USER_PRIVACY_RESTRICTED".equals(error.text) && ChatObject.canUserDoAdminAction(chat, ChatObject.ACTION_INVITE)) {
                        AndroidUtilities.runOnUIThread(() -> {
                            BaseFragment lastFragment = LaunchActivity.getLastFragment();
                            if (lastFragment != null && lastFragment.getParentActivity() != null) {
                                LimitReachedBottomSheet restricterdUsersBottomSheet = new LimitReachedBottomSheet(lastFragment, lastFragment.getParentActivity(), LimitReachedBottomSheet.TYPE_ADD_MEMBERS_RESTRICTED, currentAccount, null);
                                ArrayList<TLRPC.User> users = new ArrayList<TLRPC.User>();
                                users.add(user);
                                restricterdUsersBottomSheet.setRestrictedUsers(chat, users, null, null, null);
                                restricterdUsersBottomSheet.show();
                            }
                            onError.run(error);
                        });
                        return;
                    }
                    AndroidUtilities.runOnUIThread(() -> AlertsCreator.processError(currentAccount, error, parentFragment, req, isChannel));
                    if (onError != null) {
                        AndroidUtilities.runOnUIThread(() -> onError.run(error));
                    }
                }
            };
            if (!user.bot && addingNew) {
                addUserToChat(chatId, user, 0, botHash, parentFragment, true, () -> getConnectionsManager().sendRequest(req, requestDelegate), onError);
            } else {
                getConnectionsManager().sendRequest(req, requestDelegate);
            }
        } else {
            TLRPC.TL_messages_editChatAdmin req = new TLRPC.TL_messages_editChatAdmin();
            req.chat_id = chatId;
            req.user_id = getInputUser(user);
            req.is_admin = forceAdmin || rights.change_info || rights.delete_messages || rights.ban_users || rights.invite_users || rights.pin_messages || rights.add_admins || rights.manage_call;
            RequestDelegate requestDelegate = (response, error) -> {
                if (error == null) {
                    AndroidUtilities.runOnUIThread(() -> {
                        loadFullChat(chatId, 0, true);
                        if (onSuccess != null) {
                            onSuccess.run();
                        }
                    }, 1000);
                } else {
                    AndroidUtilities.runOnUIThread(() -> AlertsCreator.processError(currentAccount, error, parentFragment, req, false));
                    if (onError != null) {
                        AndroidUtilities.runOnUIThread(() -> onError.run(error));
                    }
                }
            };
            if (req.is_admin || addingNew || !TextUtils.isEmpty(botHash)) {
                addUserToChat(chatId, user, 0, botHash, parentFragment, true, () -> getConnectionsManager().sendRequest(req, requestDelegate), onError);
            } else {
                getConnectionsManager().sendRequest(req, requestDelegate);
            }
        }
    }

    public void unblockPeer(long id) {
        unblockPeer(id, null);
    }

    public void unblockPeer(long id, Runnable callback) {
        TLRPC.TL_contacts_unblock req = new TLRPC.TL_contacts_unblock();
        TLRPC.User user = null;
        TLRPC.Chat chat = null;
        if (id > 0) {
            user = getUser(id);
            if (user == null) {
                return;
            }
        } else {
            chat = getChat(-id);
            if (chat == null) {
                return;
            }
        }
        totalBlockedCount--;
        blockePeers.delete(id);
        if (user != null) {
            req.id = getInputPeer(user);
        } else {
            req.id = getInputPeer(chat);
        }
        getNotificationCenter().postNotificationName(NotificationCenter.blockedUsersDidLoad);
        getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> {
            if (callback != null) {
                callback.run();
            }
        }));
    }

    public void getBlockedPeers(boolean reset) {
        if (!getUserConfig().isClientActivated() || loadingBlockedPeers) {
            return;
        }
        loadingBlockedPeers = true;
        TLRPC.TL_contacts_getBlocked req = new TLRPC.TL_contacts_getBlocked();
        req.offset = reset ? 0 : blockePeers.size();
        req.limit = reset ? 20 : 100;
        getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> {
            if (response != null) {
                TLRPC.contacts_Blocked res = (TLRPC.contacts_Blocked) response;
                putUsers(res.users, false);
                putChats(res.chats, false);
                getMessagesStorage().putUsersAndChats(res.users, res.chats, true, true);
                if (reset) {
                    blockePeers.clear();
                }
                totalBlockedCount = Math.max(res.count, res.blocked.size());
                blockedEndReached = res.blocked.size() < req.limit;
                for (int a = 0, N = res.blocked.size(); a < N; a++) {
                    TLRPC.TL_peerBlocked blocked = res.blocked.get(a);
                    blockePeers.put(MessageObject.getPeerId(blocked.peer_id), 1);
                }
                loadingBlockedPeers = false;
                getNotificationCenter().postNotificationName(NotificationCenter.blockedUsersDidLoad);
            }
        }));
    }

    public void deleteUserPhoto(TLRPC.InputPhoto photo) {
        long dialogId = getUserConfig().getClientUserId();
        if (photo == null) {

            DialogPhotos photos = getDialogPhotos(dialogId);
            if (photos != null && photos.photos.size() > 0) {
                TLRPC.Photo removingPhoto = photos.photos.get(0);
                if (removingPhoto != null) {
                    photos.removePhoto(removingPhoto.id);
                }
            }

            TLRPC.TL_photos_updateProfilePhoto req = new TLRPC.TL_photos_updateProfilePhoto();
            req.id = new TLRPC.TL_inputPhotoEmpty();
       //     getUserConfig().getCurrentUser().photo = new TLRPC.TL_userProfilePhotoEmpty();
            TLRPC.User user = getUser(getUserConfig().getClientUserId());
            if (user == null) {
                user = getUserConfig().getCurrentUser();
            }
            if (user == null) {
                return;
            }
            if (user.photo != null) {
                getMessagesStorage().clearUserPhoto(user.id, user.photo.photo_id);
            }
         //   user.photo = getUserConfig().getCurrentUser().photo;
            getNotificationCenter().postNotificationName(NotificationCenter.mainUserInfoChanged);
            getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_ALL);

            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (error == null) {
                    AndroidUtilities.runOnUIThread(() -> {
                        TLRPC.TL_photos_photo photos_photo = (TLRPC.TL_photos_photo) response;
                        TLRPC.User user1 = getUser(getUserConfig().getClientUserId());
                        if (user1 == null) {
                            user1 = getUserConfig().getCurrentUser();
                            putUser(user1, false);
                        } else {
                            getUserConfig().setCurrentUser(user1);
                        }
                        if (user1 == null) {
                            return;
                        }
                        ArrayList<TLRPC.User> users = new ArrayList<>();
                        users.add(user1);
                        getMessagesStorage().putUsersAndChats(users, null, false, true);
                        if (photos_photo.photo instanceof TLRPC.TL_photo) {
                            user1.photo = new TLRPC.TL_userProfilePhoto();
                            user1.photo.has_video = !photos_photo.photo.video_sizes.isEmpty();
                            user1.photo.photo_id = photos_photo.photo.id;
                            user1.photo.photo_small = FileLoader.getClosestPhotoSizeWithSize(photos_photo.photo.sizes, 150).location;
                            user1.photo.photo_big = FileLoader.getClosestPhotoSizeWithSize(photos_photo.photo.sizes, 800).location;
                            user1.photo.dc_id = photos_photo.photo.dc_id;
                        } else {
                            user1.photo = new TLRPC.TL_userProfilePhotoEmpty();
                        }

                        TLRPC.UserFull userFull = getUserFull(dialogId);
                        if (userFull != null) {
                            userFull.profile_photo = photos_photo.photo;
                            getMessagesStorage().updateUserInfo(userFull, false);
                        }

                        getUserConfig().getCurrentUser().photo = user1.photo;
                        putUser(user1, false);

                        getNotificationCenter().postNotificationName(NotificationCenter.mainUserInfoChanged);
                        getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_ALL);
                        getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_AVATAR);
                        getUserConfig().saveConfig(true);
                    });
                }
            });
        } else {
            TLRPC.TL_photos_deletePhotos req = new TLRPC.TL_photos_deletePhotos();
            req.id.add(photo);
            getDialogPhotos(dialogId).removePhoto(photo.id);
            getConnectionsManager().sendRequest(req, null);
        }
    }

    public void uploadAndApplyUserAvatar(TLRPC.FileLocation location) {
        if (location == null) {
            return;
        }
        uploadingAvatar = FileLoader.getDirectory(FileLoader.MEDIA_DIR_CACHE) + "/" + location.volume_id + "_" + location.local_id + ".jpg";
        getFileLoader().uploadFile(uploadingAvatar, false, true, ConnectionsManager.FileTypePhoto);
    }

    public void saveTheme(Theme.ThemeInfo themeInfo, Theme.ThemeAccent accent, boolean night, boolean unsave) {
        TLRPC.TL_theme info = accent != null ? accent.info : themeInfo.info;
        if (info != null) {
            TL_account.saveTheme req = new TL_account.saveTheme();
            TLRPC.TL_inputTheme inputTheme = new TLRPC.TL_inputTheme();
            inputTheme.id = info.id;
            inputTheme.access_hash = info.access_hash;
            req.theme = inputTheme;
            req.unsave = unsave;
            getConnectionsManager().sendRequest(req, (response, error) -> {

            });
            getConnectionsManager().resumeNetworkMaybe();
        }
        if (!unsave) {
            installTheme(themeInfo, accent, night);
        }
    }

    public void installTheme(Theme.ThemeInfo themeInfo, Theme.ThemeAccent accent, boolean night) {
        TLRPC.TL_theme info = accent != null ? accent.info : themeInfo.info;
        String slug = accent != null ? accent.patternSlug : themeInfo.slug;
        boolean isBlured = accent == null && themeInfo.isBlured;
        boolean isMotion = accent != null ? accent.patternMotion : themeInfo.isMotion;

        TL_account.installTheme req = new TL_account.installTheme();
        req.dark = night;
        if (info != null) {
            req.format = "android";
            TLRPC.TL_inputTheme inputTheme = new TLRPC.TL_inputTheme();
            inputTheme.id = info.id;
            inputTheme.access_hash = info.access_hash;
            req.theme = inputTheme;
            req.flags |= 2;
        }
        getConnectionsManager().sendRequest(req, (response, error) -> {

        });

        if (!TextUtils.isEmpty(slug)) {
            TL_account.installWallPaper req2 = new TL_account.installWallPaper();
            TLRPC.TL_inputWallPaperSlug inputWallPaperSlug = new TLRPC.TL_inputWallPaperSlug();
            inputWallPaperSlug.slug = slug;
            req2.wallpaper = inputWallPaperSlug;
            req2.settings = new TLRPC.TL_wallPaperSettings();
            req2.settings.blur = isBlured;
            req2.settings.motion = isMotion;
            getConnectionsManager().sendRequest(req2, (response, error) -> {

            });
        }
    }

    public void saveThemeToServer(Theme.ThemeInfo themeInfo, Theme.ThemeAccent accent) {
        if (themeInfo == null) {
            return;
        }
        String key;
        File pathToWallpaper;
        if (accent != null) {
            key = accent.saveToFile().getAbsolutePath();
            pathToWallpaper = accent.getPathToWallpaper();
        } else {
            key = themeInfo.pathToFile;
            pathToWallpaper = null;
        }
        if (key == null) {
            return;
        }
        if (uploadingThemes.containsKey(key)) {
            return;
        }
        uploadingThemes.put(key, accent != null ? accent : themeInfo);
        Utilities.globalQueue.postRunnable(() -> {
            String thumbPath = Theme.createThemePreviewImage(key, pathToWallpaper != null ? pathToWallpaper.getAbsolutePath() : null, accent);
            AndroidUtilities.runOnUIThread(() -> {
                if (thumbPath == null) {
                    uploadingThemes.remove(key);
                    return;
                }
                uploadingThemes.put(thumbPath, accent != null ? accent : themeInfo);
                if (accent == null) {
                    themeInfo.uploadingFile = key;
                    themeInfo.uploadingThumb = thumbPath;
                } else {
                    accent.uploadingFile = key;
                    accent.uploadingThumb = thumbPath;
                }
                getFileLoader().uploadFile(key, false, true, ConnectionsManager.FileTypeFile);
                getFileLoader().uploadFile(thumbPath, false, true, ConnectionsManager.FileTypePhoto);
            });
        });
    }

    public void saveWallpaperToServer(File path, Theme.OverrideWallpaperInfo info, boolean install, long taskId) {
        if (uploadingWallpaper != null) {
            File finalPath = new File(ApplicationLoader.getFilesDirFixed(), info.originalFileName);
            if (path != null && (path.getAbsolutePath().equals(uploadingWallpaper) || path.equals(finalPath))) {
                uploadingWallpaperInfo = info;
                return;
            }
            getFileLoader().cancelFileUpload(uploadingWallpaper, false);
            uploadingWallpaper = null;
            uploadingWallpaperInfo = null;
        }
        if (path != null) {
            uploadingWallpaper = path.getAbsolutePath();
            uploadingWallpaperInfo = info;
            getFileLoader().uploadFile(uploadingWallpaper, false, true, ConnectionsManager.FileTypePhoto);
        } else if (!info.isDefault() && !info.isColor() && info.wallpaperId > 0 && !info.isTheme()) {
            TLRPC.InputWallPaper inputWallPaper = getInputWallpaper(info);
            TLRPC.TL_wallPaperSettings settings = getWallpaperSetting(info);

            TLObject req;
            if (install) {
                TL_account.installWallPaper request = new TL_account.installWallPaper();
                request.wallpaper = inputWallPaper;
                request.settings = settings;
                req = request;
            } else {
                TL_account.saveWallPaper request = new TL_account.saveWallPaper();
                request.wallpaper = inputWallPaper;
                request.settings = settings;
                req = request;
            }

            long newTaskId;
            if (taskId != 0) {
                newTaskId = taskId;
            } else {
                NativeByteBuffer data = null;
                try {
                    data = new NativeByteBuffer(1024);
                    data.writeInt32(21);
                    data.writeBool(info.isBlurred);
                    data.writeBool(info.isMotion);
                    data.writeInt32(info.color);
                    data.writeInt32(info.gradientColor1);
                    data.writeInt32(info.rotation);
                    data.writeDouble(info.intensity);
                    data.writeBool(install);
                    data.writeString(info.slug);
                    data.writeString(info.originalFileName);
                    data.limit(data.position());
                } catch (Exception e) {
                    FileLog.e(e);
                }
                newTaskId = getMessagesStorage().createPendingTask(data);
            }

            getConnectionsManager().sendRequest(req, (response, error) -> getMessagesStorage().removePendingTask(newTaskId));
        }
        if ((info.isColor() || info.gradientColor2 != 0) && info.wallpaperId <= 0) {
            TLRPC.WallPaper wallPaper;
            if (info.isColor()) {
                wallPaper = new TLRPC.TL_wallPaperNoFile();
            } else {
                wallPaper = new TLRPC.TL_wallPaper();
                wallPaper.slug = info.slug;
                wallPaper.document = new TLRPC.TL_documentEmpty();
            }
            if (info.wallpaperId == 0) {
                wallPaper.id = Utilities.random.nextLong();
                if (wallPaper.id > 0) {
                    wallPaper.id = -wallPaper.id;
                }
            } else {
                wallPaper.id = info.wallpaperId;
            }
            wallPaper.dark = MotionBackgroundDrawable.isDark(info.color, info.gradientColor1, info.gradientColor2, info.gradientColor3);
            wallPaper.flags |= 4;
            wallPaper.settings = new TLRPC.TL_wallPaperSettings();
            wallPaper.settings.blur = info.isBlurred;
            wallPaper.settings.motion = info.isMotion;
            if (info.color != 0) {
                wallPaper.settings.background_color = info.color;
                wallPaper.settings.flags |= 1;
                wallPaper.settings.intensity = (int) (info.intensity * 100);
                wallPaper.settings.flags |= 8;
            }
            if (info.gradientColor1 != 0) {
                wallPaper.settings.second_background_color = info.gradientColor1;
                wallPaper.settings.rotation = AndroidUtilities.getWallpaperRotation(info.rotation, true);
                wallPaper.settings.flags |= 16;
            }
            if (info.gradientColor2 != 0) {
                wallPaper.settings.third_background_color = info.gradientColor2;
                wallPaper.settings.flags |= 32;
            }
            if (info.gradientColor3 != 0) {
                wallPaper.settings.fourth_background_color = info.gradientColor3;
                wallPaper.settings.flags |= 64;
            }
            ArrayList<TLRPC.WallPaper> arrayList = new ArrayList<>();
            arrayList.add(wallPaper);
            getMessagesStorage().putWallpapers(arrayList, -3);
            getMessagesStorage().getWallpapers();
        }
    }

    public static TLRPC.TL_wallPaperSettings getWallpaperSetting(Theme.OverrideWallpaperInfo info) {
        TLRPC.TL_wallPaperSettings settings = new TLRPC.TL_wallPaperSettings();
        settings.blur = info.isBlurred;
        settings.motion = info.isMotion;
        if (info.color != 0) {
            settings.background_color = info.color & 0x00ffffff;
            settings.flags |= 1;
            settings.intensity = (int) (info.intensity * 100);
            settings.flags |= 8;
        } else if (info.intensity > 0) {
            settings.intensity = (int) (info.intensity * 100);
            settings.flags |= 8;
        }
        if (info.gradientColor1 != 0) {
            settings.second_background_color = info.gradientColor1 & 0x00ffffff;
            settings.rotation = AndroidUtilities.getWallpaperRotation(info.rotation, true);
            settings.flags |= 16;
        }
        if (info.gradientColor2 != 0) {
            settings.third_background_color = info.gradientColor2 & 0x00ffffff;
            settings.flags |= 32;
        }
        if (info.gradientColor3 != 0) {
            settings.fourth_background_color = info.gradientColor3 & 0x00ffffff;
            settings.flags |= 64;
        }
        return settings;
    }

    public static TLRPC.InputWallPaper getInputWallpaper(Theme.OverrideWallpaperInfo info) {
        TLRPC.InputWallPaper inputWallPaper;
        if (info.wallpaperId > 0) {
            TLRPC.TL_inputWallPaper inputWallPaperId = new TLRPC.TL_inputWallPaper();
            inputWallPaperId.id = info.wallpaperId;
            inputWallPaperId.access_hash = info.accessHash;
            inputWallPaper = inputWallPaperId;
        } else {
            TLRPC.TL_inputWallPaperSlug inputWallPaperSlug = new TLRPC.TL_inputWallPaperSlug();
            inputWallPaperSlug.slug = info.slug;
            inputWallPaper = inputWallPaperSlug;
        }
        return inputWallPaper;
    }

    public void markDialogMessageAsDeleted(long dialogId, ArrayList<Integer> messages) {
        ArrayList<MessageObject> objs = dialogMessage.get(dialogId);
        if (objs != null) {
            for (int i = 0; i < objs.size(); ++i) {
                MessageObject obj = objs.get(i);
                if (obj != null) {
                    for (int a = 0; a < messages.size(); a++) {
                        Integer id = messages.get(a);
                        if (obj.getId() == id) {
                            obj.deleted = true;
                            break;
                        }
                    }
                }
            }
        }
    }

    public void deleteMessages(ArrayList<Integer> messages, ArrayList<Long> randoms, TLRPC.EncryptedChat encryptedChat, long dialogId, int topicId, boolean forAll, int mode) {
        deleteMessages(messages, randoms, encryptedChat, dialogId, forAll, mode, false, 0, null, topicId);
    }

    public void deleteMessages(ArrayList<Integer> messages, ArrayList<Long> randoms, TLRPC.EncryptedChat encryptedChat, long dialogId, int topicId, boolean forAll, int mode, boolean cacheOnly) {
        deleteMessages(messages, randoms, encryptedChat, dialogId, forAll, mode, cacheOnly, 0, null, topicId);
    }

    public void deleteMessages(ArrayList<Integer> messages, ArrayList<Long> randoms, TLRPC.EncryptedChat encryptedChat, long dialogId, boolean forAll, int mode, boolean cacheOnly, long taskId, TLObject taskRequest, int topicId) {
        deleteMessages(messages, randoms, encryptedChat, dialogId, forAll, mode, cacheOnly, taskId, taskRequest, topicId, false, 0);
    }

    public void deleteMessages(ArrayList<Integer> messages, ArrayList<Long> randoms, TLRPC.EncryptedChat encryptedChat, long dialogId, boolean forAll, int mode, boolean cacheOnly, long taskId, TLObject taskRequest, int topicId, boolean movedToScheduled, int movedToScheduledMessageId) {
        final boolean scheduled = mode == ChatActivity.MODE_SCHEDULED;
        final boolean quickReplies = mode == ChatActivity.MODE_QUICK_REPLIES;
        if ((messages == null || messages.isEmpty()) && taskId == 0) {
            return;
        }
        ArrayList<Integer> toSend = null;
        long channelId;
        if (taskId == 0) {
            if (dialogId != 0 && DialogObject.isChatDialog(dialogId)) {
                TLRPC.Chat chat = getChat(-dialogId);
                channelId = ChatObject.isChannel(chat) ? chat.id : 0;
            } else {
                channelId = 0;
            }
            if (!cacheOnly) {
                toSend = new ArrayList<>();
                for (int a = 0, N = messages.size(); a < N; a++) {
                    Integer mid = messages.get(a);
                    if (mid > 0) {
                        toSend.add(mid);
                    }
                }
            }
            if (scheduled) {
                getMessagesStorage().markMessagesAsDeleted(dialogId, messages, true, false, ChatActivity.MODE_SCHEDULED, 0);
            } else if (quickReplies) {
                if (mode == ChatActivity.MODE_QUICK_REPLIES) {
                    QuickRepliesController.getInstance(currentAccount).deleteLocalMessages(messages);
                }
                getMessagesStorage().markMessagesAsDeleted(dialogId, messages, true, false, ChatActivity.MODE_QUICK_REPLIES, topicId);
            } else {
                if (channelId == 0) {
                    for (int a = 0; a < messages.size(); a++) {
                        Integer id = messages.get(a);
                        MessageObject obj = dialogMessagesByIds.get(id);
                        if (obj != null) {
                            obj.deleted = true;
                        }
                    }
                } else {
                    markDialogMessageAsDeleted(dialogId, messages);
                }
                getMessagesStorage().markMessagesAsDeleted(dialogId, messages, true, forAll, 0, topicId);
                getMessagesStorage().updateDialogsWithDeletedMessages(dialogId, channelId, messages, null, true);
            }
            getNotificationCenter().postNotificationName(NotificationCenter.messagesDeleted, messages, channelId, scheduled, false, movedToScheduled, movedToScheduledMessageId);
        } else {
            if (taskRequest instanceof TLRPC.TL_channels_deleteMessages) {
                channelId = ((TLRPC.TL_channels_deleteMessages) taskRequest).channel.channel_id;
            } else {
                channelId = 0;
            }
        }
        if (cacheOnly) {
            return;
        }

        long newTaskId;
        if (scheduled) {
            TLRPC.TL_messages_deleteScheduledMessages req;

            if (taskRequest instanceof TLRPC.TL_messages_deleteScheduledMessages) {
                req = (TLRPC.TL_messages_deleteScheduledMessages) taskRequest;
                newTaskId = taskId;
            } else {
                req = new TLRPC.TL_messages_deleteScheduledMessages();
                req.id = toSend;
                req.peer = getInputPeer(dialogId);

                NativeByteBuffer data = null;
                try {
                    data = new NativeByteBuffer(12 + req.getObjectSize());
                    data.writeInt32(24);
                    data.writeInt64(dialogId);
                    req.serializeToStream(data);
                } catch (Exception e) {
                    FileLog.e(e);
                }
                newTaskId = getMessagesStorage().createPendingTask(data);
            }

            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (error == null) {
                    TLRPC.Updates updates = (TLRPC.Updates) response;
                    processUpdates(updates, false);
                }
                if (newTaskId != 0) {
                    getMessagesStorage().removePendingTask(newTaskId);
                }
            });
        } else if (quickReplies) {
            TLRPC.TL_messages_deleteQuickReplyMessages req;
            if (taskRequest instanceof TLRPC.TL_messages_deleteQuickReplyMessages) {
                req = (TLRPC.TL_messages_deleteQuickReplyMessages) taskRequest;
                newTaskId = taskId;
            } else {
                req = new TLRPC.TL_messages_deleteQuickReplyMessages();
                req.id = toSend;
                req.shortcut_id = topicId;

                NativeByteBuffer data = null;
                try {
                    data = new NativeByteBuffer(4 + 8 + 4 + req.getObjectSize());
                    data.writeInt32(103);
                    data.writeInt64(dialogId);
                    data.writeInt32(topicId);
                    req.serializeToStream(data);
                } catch (Exception e) {
                    FileLog.e(e);
                }
                newTaskId = getMessagesStorage().createPendingTask(data);
            }

            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (error == null) {
                    TLRPC.Updates updates = (TLRPC.Updates) response;
                    processUpdates(updates, false);
                }
                if (newTaskId != 0) {
                    getMessagesStorage().removePendingTask(newTaskId);
                }
            });
        } else if (channelId != 0) {
            TLRPC.TL_channels_deleteMessages req;
            if (taskRequest != null) {
                req = (TLRPC.TL_channels_deleteMessages) taskRequest;
                newTaskId = taskId;
            } else {
                req = new TLRPC.TL_channels_deleteMessages();
                req.id = toSend;
                req.channel = getInputChannel(channelId);

                NativeByteBuffer data = null;
                try {
                    data = new NativeByteBuffer(12 + req.getObjectSize());
                    data.writeInt32(24);
                    data.writeInt64(dialogId);
                    req.serializeToStream(data);
                } catch (Exception e) {
                    FileLog.e(e);
                }
                newTaskId = getMessagesStorage().createPendingTask(data);
            }

            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (error == null) {
                    TLRPC.TL_messages_affectedMessages res = (TLRPC.TL_messages_affectedMessages) response;
                    processNewChannelDifferenceParams(res.pts, res.pts_count, channelId);
                }
                if (newTaskId != 0) {
                    getMessagesStorage().removePendingTask(newTaskId);
                }
            });
        } else {
            if (randoms != null && encryptedChat != null && !randoms.isEmpty()) {
                getSecretChatHelper().sendMessagesDeleteMessage(encryptedChat, randoms, null);
            }
            TLRPC.TL_messages_deleteMessages req;
            if (taskRequest instanceof TLRPC.TL_messages_deleteMessages) {
                req = (TLRPC.TL_messages_deleteMessages) taskRequest;
                newTaskId = taskId;
            } else {
                req = new TLRPC.TL_messages_deleteMessages();
                req.id = toSend;
                req.revoke = forAll;

                NativeByteBuffer data = null;
                try {
                    data = new NativeByteBuffer(12 + req.getObjectSize());
                    data.writeInt32(24);
                    data.writeInt64(dialogId);
                    req.serializeToStream(data);
                } catch (Exception e) {
                    FileLog.e(e);
                }
                newTaskId = getMessagesStorage().createPendingTask(data);
            }

            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (error == null) {
                    TLRPC.TL_messages_affectedMessages res = (TLRPC.TL_messages_affectedMessages) response;
                    processNewDifferenceParams(-1, res.pts, -1, res.pts_count);
                }
                if (newTaskId != 0) {
                    getMessagesStorage().removePendingTask(newTaskId);
                }
            });
        }
    }

    public void unpinAllMessages(TLRPC.Chat chat, TLRPC.User user) {
        if (chat == null && user == null) {
            return;
        }
        TLRPC.TL_messages_unpinAllMessages req = new TLRPC.TL_messages_unpinAllMessages();
        req.peer = getInputPeer(chat != null ? -chat.id : user.id);
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response != null) {
                TLRPC.TL_messages_affectedHistory res = (TLRPC.TL_messages_affectedHistory) response;
                if (ChatObject.isChannel(chat)) {
                    processNewChannelDifferenceParams(res.pts, res.pts_count, chat.id);
                } else {
                    processNewDifferenceParams(-1, res.pts, -1, res.pts_count);
                }
                ArrayList<Integer> ids = new ArrayList<>();
                getMessagesStorage().updatePinnedMessages(chat != null ? -chat.id : user.id, null, false, 0, 0, false, null);
            }
        });
    }

    public void pinMessage(TLRPC.Chat chat, TLRPC.User user, int id, boolean unpin, boolean oneSide, boolean notify) {
        if (chat == null && user == null) {
            return;
        }
        TLRPC.TL_messages_updatePinnedMessage req = new TLRPC.TL_messages_updatePinnedMessage();
        req.peer = getInputPeer(chat != null ? -chat.id : user.id);
        req.id = id;
        req.unpin = unpin;
        req.silent = !notify;
        req.pm_oneside = oneSide;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error == null) {
                ArrayList<Integer> ids = new ArrayList<>();
                ids.add(id);
                getMessagesStorage().updatePinnedMessages(chat != null ? -chat.id : user.id, ids, !unpin, -1, 0, false, null);
                TLRPC.Updates updates = (TLRPC.Updates) response;
                processUpdates(updates, false);
            }
        });
    }

    public void deleteUserChannelHistory(TLRPC.Chat currentChat, TLRPC.User fromUser, TLRPC.Chat fromChat, int offset) {
        long fromId = 0;
        if (fromUser != null) {
            fromId = fromUser.id;
        } else if (fromChat != null) {
            fromId = fromChat.id;
        }
        if (offset == 0) {
            getMessagesStorage().deleteUserChatHistory(-currentChat.id, fromId);
        }
        TLRPC.TL_channels_deleteParticipantHistory req = new TLRPC.TL_channels_deleteParticipantHistory();
        req.channel = getInputChannel(currentChat);
        req.participant = fromUser != null ? getInputPeer(fromUser) : getInputPeer(fromChat);
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error == null) {
                TLRPC.TL_messages_affectedHistory res = (TLRPC.TL_messages_affectedHistory) response;
                if (res.offset > 0) {
                    deleteUserChannelHistory(currentChat, fromUser, fromChat, res.offset);
                }
                processNewChannelDifferenceParams(res.pts, res.pts_count, currentChat.id);
            }
        });
    }

    public ArrayList<TLRPC.Dialog> getAllDialogs() {
        return allDialogs;
    }

    public void putDialogsEndReachedAfterRegistration() {
        dialogsEndReached.put(0, true);
        serverDialogsEndReached.put(0, true);
    }

    public boolean isDialogsEndReached(int folderId) {
        return dialogsEndReached.get(folderId);
    }

    public boolean isLoadingDialogs(int folderId) {
        return loadingDialogs.get(folderId);
    }

    public boolean isServerDialogsEndReached(int folderId) {
        return serverDialogsEndReached.get(folderId);
    }

    public boolean hasHiddenArchive() {
        return SharedConfig.archiveHidden && dialogs_dict.get(DialogObject.makeFolderDialogId(1)) != null;
    }

    public ArrayList<TLRPC.Dialog> getDialogs(int folderId) {
        ArrayList<TLRPC.Dialog> dialogs = dialogsByFolder.get(folderId);
        if (dialogs == null) {
            return new ArrayList<>();
        }
        return dialogs;
    }

    public int getAllFoldersDialogsCount() {
        int count = 0;
        for (int i = 0; i < dialogsByFolder.size(); i++) {
            List<TLRPC.Dialog> dialogs = dialogsByFolder.get(dialogsByFolder.keyAt(i));
            if (dialogs != null) {
                count += dialogs.size();
            }
        }
        return count;
    }

    public int getTotalDialogsCount() {
        int count = 0;
        ArrayList<TLRPC.Dialog> dialogs = dialogsByFolder.get(0);
        if (dialogs != null) {
            count += dialogs.size();
        }
        return count;
    }

    public void putAllNeededDraftDialogs() {
        LongSparseArray<LongSparseArray<TLRPC.DraftMessage>> drafts = getMediaDataController().getDrafts();
        for (int i = 0, size = drafts.size(); i < size; i++) {
            LongSparseArray<TLRPC.DraftMessage> threads = drafts.valueAt(i);
            TLRPC.DraftMessage draftMessage = threads.get(0);
            if (draftMessage == null) {
                continue;
            }
            putDraftDialogIfNeed(drafts.keyAt(i), draftMessage);
        }
    }

    public void putDraftDialogIfNeed(long dialogId, TLRPC.DraftMessage draftMessage) {
        if (dialogs_dict.indexOfKey(dialogId) < 0) {
            if (ChatObject.isMonoForum(currentAccount, dialogId) && !ChatObject.canManageMonoForum(currentAccount, dialogId)) {
                return;
            }

            MediaDataController mediaDataController = getMediaDataController();
            int dialogsCount = allDialogs.size();
            if (dialogsCount > 0) {
                TLRPC.Dialog dialog = allDialogs.get(dialogsCount - 1);
                long minDate = DialogObject.getLastMessageOrDraftDate(dialog, mediaDataController.getDraft(dialog.id, 0));
                if (draftMessage.date < minDate) {
                    return;
                }
            }
            TLRPC.TL_dialog dialog = new TLRPC.TL_dialog();
            dialog.id = dialogId;
            dialog.draft = draftMessage;
            dialog.folder_id = mediaDataController.getDraftFolderId(dialogId);
            dialog.flags = dialogId < 0 && ChatObject.isChannel(getChat(-dialogId)) ? 1 : 0;
            dialogs_dict.put(dialogId, dialog);
            allDialogs.add(dialog);
            sortDialogs(null);
        }
    }

    public void removeDraftDialogIfNeed(long dialogId) {
        TLRPC.Dialog dialog = dialogs_dict.get(dialogId);
        if (dialog != null && dialog.top_message == 0) {
            dialogs_dict.remove(dialog.id);
            allDialogs.remove(dialog);
        }
    }

    private void removeDialog(TLRPC.Dialog dialog) {
        if (dialog == null) {
            return;
        }
        long did = dialog.id;
        if (dialogsServerOnly.remove(dialog) && DialogObject.isChannel(dialog)) {
            Utilities.stageQueue.postRunnable(() -> {
                channelsPts.delete(-did);
                shortPollChannels.delete(-did);
                needShortPollChannels.delete(-did);
                shortPollOnlines.delete(-did);
                needShortPollOnlines.delete(-did);
            });
        }
        allDialogs.remove(dialog);
        dialogsMyChannels.remove(dialog);
        dialogsMyGroups.remove(dialog);
        dialogsCanAddUsers.remove(dialog);
        dialogsChannelsOnly.remove(dialog);
        dialogsGroupsOnly.remove(dialog);
        dialogsUsersOnly.remove(dialog);
        dialogsForBlock.remove(dialog);
        dialogsForward.remove(dialog);
        for (int a = 0; a < selectedDialogFilter.length; a++) {
            if (selectedDialogFilter[a] != null) {
                selectedDialogFilter[a].dialogs.remove(dialog);
                selectedDialogFilter[a].dialogsForward.remove(dialog);
            }
        }
        dialogs_dict.remove(did);

        ArrayList<TLRPC.Dialog> dialogs = dialogsByFolder.get(dialog.folder_id);
        if (dialogs != null) {
            dialogs.remove(dialog);
        }
    }

    public void hidePromoDialog() {
        if (promoDialog == null) {
            return;
        }
        TLRPC.TL_help_hidePromoData req = new TLRPC.TL_help_hidePromoData();
        req.peer = getInputPeer(promoDialog.id);
        getConnectionsManager().sendRequest(req, (response, error) -> {

        });
        Utilities.stageQueue.postRunnable(() -> {
            promoDialogId = 0;
            proxyDialogAddress = null;
            nextPromoInfoCheckTime = getConnectionsManager().getCurrentTime() + 60 * 60;
            getGlobalMainSettings().edit().putLong("proxy_dialog", promoDialogId).remove("proxyDialogAddress").putInt("nextPromoInfoCheckTime", nextPromoInfoCheckTime).commit();
        });
        removePromoDialog();
    }

    public void deleteDialog(final long did, int onlyHistory) {
        deleteDialog(did, onlyHistory, false);
    }

    public void deleteDialog(final long did, int onlyHistory, boolean revoke) {
        deleteDialog(did, 1, onlyHistory, 0, revoke, null, 0);
    }

    public void setDialogHistoryTTL(long did, int ttl) {
        TLRPC.TL_messages_setHistoryTTL req = new TLRPC.TL_messages_setHistoryTTL();
        req.peer = getInputPeer(did);
        req.period = ttl;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response != null) {
                TLRPC.Updates updates = (TLRPC.Updates) response;
                processUpdates(updates, false);
            }
        });
        TLRPC.ChatFull chatFull = null;
        TLRPC.UserFull userFull = null;
        TLRPC.Dialog dialog = getMessagesController().dialogs_dict.get(did);
        if (dialog != null) {
            dialog.ttl_period = ttl;
        }
        getMessagesStorage().setDialogTtl(did, ttl);
        if (did > 0) {
            userFull = getUserFull(did);
            if (userFull != null) {
                userFull.ttl_period = ttl;
                userFull.flags |= 16384;
            }
        } else {
            chatFull = getChatFull(-did);
            if (chatFull != null) {
                chatFull.ttl_period = ttl;
                if (chatFull instanceof TLRPC.TL_channelFull) {
                    chatFull.flags |= 16777216;
                } else {
                    chatFull.flags |= 16384;
                }
            }
        }
        if (chatFull != null) {
            getNotificationCenter().postNotificationName(NotificationCenter.chatInfoDidLoad, chatFull, 0, false, false);
        } else if (userFull != null) {
            getNotificationCenter().postNotificationName(NotificationCenter.userInfoDidLoad, did, userFull);
        }
    }

    public void setDialogsInTransaction(boolean transaction) {
        dialogsInTransaction = transaction;
        if (!transaction) {
            getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload, true);
        }
    }

    protected void deleteDialog(long did, int first, int onlyHistory, int max_id, boolean revoke, TLRPC.InputPeer peer, long taskId) {
        if (onlyHistory == 2) {
            if (did == getUserConfig().getClientUserId()) {
                getSavedMessagesController().deleteAllDialogs();
            }
            getMessagesStorage().deleteDialog(did, onlyHistory);
            return;
        }
        for (int i = 0; i < sendAsPeers.size(); i++) {
            SendAsPeersInfo sendAsInfo = sendAsPeers.valueAt(i);
            if (sendAsInfo.sendAsPeers != null) {
                for (int j = 0; j < sendAsInfo.sendAsPeers.chats.size(); j++) {
                    if (sendAsInfo.sendAsPeers.chats.get(j).id == -did) {
                        sendAsInfo.sendAsPeers.chats.remove(j);
                        break;
                    }
                }
                for (int j = 0; j < sendAsInfo.sendAsPeers.peers.size(); j++) {
                    if (sendAsInfo.sendAsPeers.peers.get(j).peer.channel_id == -did || sendAsInfo.sendAsPeers.peers.get(j).peer.chat_id == -did) {
                        sendAsInfo.sendAsPeers.peers.remove(j);
                        break;
                    }
                }
            }
        }
        sendAsPeers.remove(did);
        sendAsPeersLiveStories.remove(did);
        if (first == 1 && max_id == 0) {
            TLRPC.InputPeer peerFinal = peer;
            getMessagesStorage().getDialogMaxMessageId(did, (param) -> {
                if (did == getUserConfig().getClientUserId()) {
                    getSavedMessagesController().deleteAllDialogs();
                }
                deleteDialog(did, 2, onlyHistory, Math.max(0, param), revoke, peerFinal, taskId);
                checkIfFolderEmpty(1);
            });
            return;
        }
        if (onlyHistory == 0 || onlyHistory == 3) {
            getMediaDataController().uninstallShortcut(did, MediaDataController.SHORTCUT_TYPE_USER_OR_CHAT);
        }
        int max_id_delete = max_id;

        if (first != 0) {
            if (BuildVars.LOGS_ENABLED) {
                FileLog.d("delete dialog with id " + did);
            }
            boolean isPromoDialog = false;
            if (did == getUserConfig().getClientUserId()) {
                getSavedMessagesController().deleteAllDialogs();
            }
            getMessagesStorage().deleteDialog(did, onlyHistory);
            TLRPC.Dialog dialog = dialogs_dict.get(did);
            if (onlyHistory == 0 || onlyHistory == 3) {
                getNotificationCenter().postNotificationName(NotificationCenter.dialogDeleted, did, 0);
                getNotificationsController().deleteNotificationChannel(did, 0);
                JoinCallAlert.processDeletedChat(currentAccount, did);
            }
            if (onlyHistory == 0) {
                getMediaDataController().cleanDraft(did, 0, false);
            }
            if (dialog != null) {
                if (first == 2) {
                    max_id_delete = Math.max(0, dialog.top_message);
                    max_id_delete = Math.max(max_id_delete, dialog.read_inbox_max_id);
                    max_id_delete = Math.max(max_id_delete, dialog.read_outbox_max_id);
                }
                if (onlyHistory == 0 || onlyHistory == 3) {
                    if (isPromoDialog = (promoDialog != null && promoDialog.id == did)) {
                        isLeftPromoChannel = true;
                        if (promoDialog.id < 0) {
                            TLRPC.Chat chat = getChat(-promoDialog.id);
                            if (chat != null) {
                                chat.left = true;
                            }
                        }
                        sortDialogs(null);
                    } else {
                        removeDialog(dialog);
                        int offset = nextDialogsCacheOffset.get(dialog.folder_id, 0);
                        if (offset > 0) {
                            nextDialogsCacheOffset.put(dialog.folder_id, offset - 1);
                        }
                    }
                } else {
                    dialog.unread_count = 0;
                }
                if (!isPromoDialog) {
                    int lastMessageId;
                    ArrayList<MessageObject> objects = dialogMessage.get(dialog.id);
                    dialogMessage.remove(dialog.id);
                    if (objects != null && objects.size() > 0 && objects.get(0) != null) {
                        lastMessageId = objects.get(0).getId();
                        for (int i = 0; i < objects.size(); ++i) {
                            MessageObject object = objects.get(i);
                            if (object != null && object.getId() > lastMessageId) {
                                lastMessageId = object.getId();
                            }
                            if (object != null && object.messageOwner.peer_id.channel_id == 0) {
                                dialogMessagesByIds.remove(object.getId());
                            }
                            if (object != null && object.messageOwner.random_id != 0) {
                                dialogMessagesByRandomIds.remove(object.messageOwner.random_id);
                            }
                        }
                    } else {
                        lastMessageId = dialog.top_message;
                        MessageObject object = dialogMessagesByIds.get(dialog.top_message);
                        if (object != null && object.messageOwner.peer_id.channel_id == 0) {
                            dialogMessagesByIds.remove(dialog.top_message);
                        }
                        if (object != null && object.messageOwner.random_id != 0) {
                            dialogMessagesByRandomIds.remove(object.messageOwner.random_id);
                        }
                    }
                    if (onlyHistory == 1 && !DialogObject.isEncryptedDialog(did) && lastMessageId > 0) {
                        TLRPC.TL_messageService message = new TLRPC.TL_messageService();
                        message.id = dialog.top_message;
                        message.out = getUserConfig().getClientUserId() == did;
                        message.from_id = new TLRPC.TL_peerUser();
                        message.from_id.user_id = getUserConfig().getClientUserId();
                        message.flags |= 256;
                        message.action = new TLRPC.TL_messageActionHistoryClear();
                        message.date = dialog.last_message_date;
                        message.dialog_id = did;
                        message.peer_id = getPeer(did);
                        boolean isDialogCreated = createdDialogIds.contains(message.dialog_id);
                        MessageObject obj = new MessageObject(currentAccount, message, isDialogCreated, isDialogCreated);
                        ArrayList<MessageObject> objArr = new ArrayList<>();
                        objArr.add(obj);
                        ArrayList<TLRPC.Message> arr = new ArrayList<>();
                        arr.add(message);
                        updateInterfaceWithMessages(did, objArr, 0);
                        getMessagesStorage().putMessages(arr, false, true, false, 0, false, 0, 0);
                    } else {
                        dialog.top_message = 0;
                    }
                }
            }
            if (first == 2) {
                Integer max = dialogs_read_inbox_max.get(did);
                if (max != null) {
                    max_id_delete = Math.max(max, max_id_delete);
                }
                max = dialogs_read_outbox_max.get(did);
                if (max != null) {
                    max_id_delete = Math.max(max, max_id_delete);
                }
            }

            if (!dialogsInTransaction) {
                if (isPromoDialog) {
                    getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload, true);
                } else {
                    getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                    getNotificationCenter().postNotificationName(NotificationCenter.removeAllMessagesFromDialog, did, false, null);
                }
            }
            getMessagesStorage().getStorageQueue().postRunnable(() -> AndroidUtilities.runOnUIThread(() -> getNotificationsController().removeNotificationsForDialog(did)));
        }

        if (onlyHistory == 3) {
            return;
        }

        if (!DialogObject.isEncryptedDialog(did)) {
            if (peer == null) {
                peer = getInputPeer(did);
            }
            if (peer == null) {
                return;
            }

            long newTaskId;
            if (!(peer instanceof TLRPC.TL_inputPeerChannel) || onlyHistory != 0) {
                if (max_id_delete > 0 && max_id_delete != Integer.MAX_VALUE) {
                    int current = deletedHistory.get(did, 0);
                    deletedHistory.put(did, Math.max(current, max_id_delete));
                }

                if (taskId == 0) {
                    NativeByteBuffer data = null;
                    try {
                        data = new NativeByteBuffer(4 + 8 + 4 + 4 + 4 + 4 + peer.getObjectSize());
                        data.writeInt32(13);
                        data.writeInt64(did);
                        data.writeBool(first != 0);
                        data.writeInt32(onlyHistory);
                        data.writeInt32(max_id_delete);
                        data.writeBool(revoke);
                        peer.serializeToStream(data);
                    } catch (Exception e) {
                        FileLog.e(e);
                    }
                    newTaskId = getMessagesStorage().createPendingTask(data);
                } else {
                    newTaskId = taskId;
                }
            } else {
                newTaskId = taskId;
            }

            if (peer instanceof TLRPC.TL_inputPeerChannel) {
                if (onlyHistory == 0) {
                    if (newTaskId != 0) {
                        getMessagesStorage().removePendingTask(newTaskId);
                    }
                    return;
                }
                TLRPC.TL_channels_deleteHistory req = new TLRPC.TL_channels_deleteHistory();
                req.channel = new TLRPC.TL_inputChannel();
                req.for_everyone = revoke;
                req.channel.channel_id = peer.channel_id;
                req.channel.access_hash = peer.access_hash;
                req.max_id = max_id_delete > 0 ? max_id_delete : Integer.MAX_VALUE;
                getConnectionsManager().sendRequest(req, (response, error) -> {
                    if (newTaskId != 0) {
                        getMessagesStorage().removePendingTask(newTaskId);
                    }
                    if (response != null) {
                        processUpdates((TLRPC.Updates) response, false);
                    }
                }, ConnectionsManager.RequestFlagInvokeAfter);
            } else {
                TLRPC.TL_messages_deleteHistory req = new TLRPC.TL_messages_deleteHistory();
                req.peer = peer;
                req.max_id = max_id_delete > 0 ? max_id_delete : Integer.MAX_VALUE;
                req.just_clear = onlyHistory != 0;
                req.revoke = revoke;
                int max_id_delete_final = max_id_delete;
                TLRPC.InputPeer peerFinal = peer;
                getConnectionsManager().sendRequest(req, (response, error) -> {
                    if (newTaskId != 0) {
                        getMessagesStorage().removePendingTask(newTaskId);
                    }
                    if (error == null) {
                        TLRPC.TL_messages_affectedHistory res = (TLRPC.TL_messages_affectedHistory) response;
                        if (res.offset > 0) {
                            deleteDialog(did, 0, onlyHistory, max_id_delete_final, revoke, peerFinal, 0);
                        }
                        processNewDifferenceParams(-1, res.pts, -1, res.pts_count);
                        getMessagesStorage().onDeleteQueryComplete(did);
                    }
                }, ConnectionsManager.RequestFlagInvokeAfter);
            }
        } else {
            int encryptedId = DialogObject.getEncryptedChatId(did);
            if (onlyHistory == 1) {
                getSecretChatHelper().sendClearHistoryMessage(getEncryptedChat(encryptedId), null);
            } else {
                getSecretChatHelper().declineSecretChat(encryptedId, revoke);
            }
        }
    }

    public void deleteSavedDialog(long did) {
        deleteSavedDialog(did, 0, null);
    }

    public void deleteSavedDialog(long did, TLRPC.InputPeer monoForumPeer) {
        deleteSavedDialog(did, 0, monoForumPeer);
    }

    protected void deleteSavedDialog(long did, int input_max_id, TLRPC.InputPeer monoForumPeer) {
        final long monoForumDid = DialogObject.getPeerDialogId(monoForumPeer);
        int[] max_id = new int[] { input_max_id };
        Runnable perform = () -> {
            if (monoForumDid == 0) {
                getMessagesStorage().deleteSavedDialog(did);
            }
            TLRPC.TL_messages_deleteSavedHistory req = new TLRPC.TL_messages_deleteSavedHistory();
            req.peer = getInputPeer(did);
            req.parent_peer = monoForumPeer;
            if (input_max_id == 0 && monoForumDid == 0) {
                SavedMessagesController.SavedDialog dialog = null;
                for (int i = 0; i < getSavedMessagesController().allDialogs.size(); ++i) {
                    if (getSavedMessagesController().allDialogs.get(i).dialogId == did) {
                        dialog = getSavedMessagesController().allDialogs.get(i);
                        break;
                    }
                }
                if (dialog != null) {
                    max_id[0] = Math.max(max_id[0], dialog.top_message_id);
                    getSavedMessagesController().deleteDialog(did);
                }
                req.max_id = max_id[0] <= 0 ? Integer.MAX_VALUE : max_id[0];
            }
            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (error == null) {
                    TLRPC.TL_messages_affectedHistory res = (TLRPC.TL_messages_affectedHistory) response;
                    if (res.offset > 0) {
                        deleteSavedDialog(did, max_id[0], monoForumPeer);
                    }
                    processNewDifferenceParams(-1, res.pts, -1, res.pts_count);
                    getMessagesStorage().onDeleteQueryComplete(did);
                }
            }, ConnectionsManager.RequestFlagInvokeAfter);
        };
        if (max_id[0] <= 0 && monoForumDid == 0) {
            getMessagesStorage().getSavedDialogMaxMessageId(did, (param) -> {
                max_id[0] = param;
                perform.run();
            });
        } else {
            perform.run();
        }
    }

    public void saveGif(Object parentObject, TLRPC.Document document) {
        if (parentObject == null || !MessageObject.isGifDocument(document)) {
            return;
        }
        TLRPC.TL_messages_saveGif req = new TLRPC.TL_messages_saveGif();
        req.id = new TLRPC.TL_inputDocument();
        req.id.id = document.id;
        req.id.access_hash = document.access_hash;
        req.id.file_reference = document.file_reference;
        if (req.id.file_reference == null) {
            req.id.file_reference = new byte[0];
        }
        req.unsave = false;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error != null && FileRefController.isFileRefError(error.text)) {
                getFileRefController().requestReference(parentObject, req);
            }
        });
    }

    public void saveRecentSticker(Object parentObject, TLRPC.Document document, boolean asMask) {
        if (parentObject == null || document == null) {
            return;
        }
        TLRPC.TL_messages_saveRecentSticker req = new TLRPC.TL_messages_saveRecentSticker();
        req.id = new TLRPC.TL_inputDocument();
        req.id.id = document.id;
        req.id.access_hash = document.access_hash;
        req.id.file_reference = document.file_reference;
        if (req.id.file_reference == null) {
            req.id.file_reference = new byte[0];
        }
        req.unsave = false;
        req.attached = asMask;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error != null && FileRefController.isFileRefError(error.text)) {
                getFileRefController().requestReference(parentObject, req);
            }
        });
    }

    public void loadChannelParticipants(Long chatId) {
        loadChannelParticipants(chatId, null, 32);
    }

    public void loadChannelParticipants(Long chatId, Utilities.Callback<TLRPC.TL_channels_channelParticipants> whenDone, int count) {
        if (whenDone == null && (loadingFullParticipants.contains(chatId) || loadedFullParticipants.contains(chatId))) {
            return;
        }
        loadingFullParticipants.add(chatId);

        TLRPC.TL_channels_getParticipants req = new TLRPC.TL_channels_getParticipants();
        req.channel = getInputChannel(chatId);
        req.filter = new TLRPC.TL_channelParticipantsRecent();
        req.offset = 0;
        req.limit = count;
        getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> {
            if (error == null) {
                TLRPC.TL_channels_channelParticipants res = (TLRPC.TL_channels_channelParticipants) response;
                putUsers(res.users, false);
                putChats(res.chats, false);
                getMessagesStorage().putUsersAndChats(res.users, res.chats, true, true);
                getMessagesStorage().updateChannelUsers(chatId, res.participants);
                loadedFullParticipants.add(chatId);
            }
            loadingFullParticipants.remove(chatId);
            if (whenDone != null) {
                whenDone.run(response instanceof TLRPC.TL_channels_channelParticipants ? (TLRPC.TL_channels_channelParticipants) response : null);
            }
        }));
    }

    public void putChatFull(TLRPC.ChatFull chatFull) {
        fullChats.put(chatFull.id, chatFull);
        getTranslateController().updateDialogFull(-chatFull.id);
    }

    public void processChatInfo(long chatId, TLRPC.ChatFull info, ArrayList<TLRPC.User> usersArr, boolean fromCache, boolean force, boolean byChannelUsers, ArrayList<Integer> pinnedMessages, HashMap<Integer, MessageObject> pinnedMessagesMap, int totalPinnedCount, boolean pinnedEndReached) {
        AndroidUtilities.runOnUIThread(() -> {
            if (fromCache && chatId > 0 && !byChannelUsers) {
                long lastLoadedTime = loadedFullChats.get(chatId, 0);
                if (System.currentTimeMillis() - lastLoadedTime > 60 * 1000) {
                    loadFullChat(chatId, 0, force);
                }
            }
            if (info != null) {
                if (fullChats.get(chatId) == null) {
                    fullChats.put(chatId, info);
                    getTranslateController().updateDialogFull(-chatId);
                }
                putUsers(usersArr, fromCache);
                if (info.stickerset != null) {
                    getMediaDataController().getGroupStickerSetById(info.stickerset);
                }
                if (info.emojiset != null) {
                    getMediaDataController().getGroupStickerSetById(info.emojiset);
                }
                getNotificationCenter().postNotificationName(NotificationCenter.chatInfoDidLoad, info, 0, byChannelUsers, false);
            }
            if (pinnedMessages != null) {
                getNotificationCenter().postNotificationName(NotificationCenter.pinnedInfoDidLoad, -chatId, pinnedMessages, pinnedMessagesMap, totalPinnedCount, pinnedEndReached);
            }
        });
    }

    public void loadUserInfo(TLRPC.User user, boolean force, int classGuid) {
        loadUserInfo(user, force, classGuid, 0);
    }

    public void loadUserInfo(TLRPC.User user, boolean force, int classGuid, int fromMessageId) {
        getMessagesStorage().loadUserInfo(user, force, classGuid, fromMessageId);
    }

    public void updateUsernameActiveness(TLObject object, String username, boolean active) {
        if (TextUtils.isEmpty(username)) {
            return;
        }
        objectsByUsernames.remove(username);
        if (active) {
            objectsByUsernames.put(username.toLowerCase(), object);
        }
    }

    public void processUserInfo(TLRPC.User user, TLRPC.UserFull info, boolean fromCache, boolean force, int classGuid, ArrayList<Integer> pinnedMessages, HashMap<Integer, MessageObject> pinnedMessagesMap, int totalPinnedCount, boolean pinnedEndReached) {
        AndroidUtilities.runOnUIThread(() -> {
            if (fromCache) {
                long lastLoadedTime = loadedFullUsers.get(user.id, 0);
                if (System.currentTimeMillis() - lastLoadedTime > 60 * 1000) {
                    loadFullUser(user, classGuid, force);
                }
            }
            if (info != null) {
                if (fullUsers.get(user.id) == null) {
                    fullUsers.put(user.id, info);
                    getTranslateController().updateDialogFull(user.id);
                    StarsController.getInstance(currentAccount).invalidateProfileGifts(info);

                    int index = blockePeers.indexOfKey(user.id);
                    if (info.blocked) {
                        if (index < 0) {
                            blockePeers.put(user.id, 1);
                            getNotificationCenter().postNotificationName(NotificationCenter.blockedUsersDidLoad);
                        }
                    } else {
                        if (index >= 0) {
                            blockePeers.removeAt(index);
                            getNotificationCenter().postNotificationName(NotificationCenter.blockedUsersDidLoad);
                        }
                    }
                }
                getNotificationCenter().postNotificationName(NotificationCenter.userInfoDidLoad, user.id, info);
            }
            if (pinnedMessages != null) {
                getNotificationCenter().postNotificationName(NotificationCenter.pinnedInfoDidLoad, user.id, pinnedMessages, pinnedMessagesMap, totalPinnedCount, pinnedEndReached);
            }
        });
    }

    public void updateTimerProc() {
        long currentTime = System.currentTimeMillis();

        checkDeletingTask(false);
        checkReadTasks();

        if (getUserConfig().isClientActivated()) {
            if (!ignoreSetOnline && getConnectionsManager().getPauseTime() == 0 && ApplicationLoader.isScreenOn && !ApplicationLoader.mainInterfacePausedStageQueue) {
                if (ApplicationLoader.mainInterfacePausedStageQueueTime != 0 && Math.abs(ApplicationLoader.mainInterfacePausedStageQueueTime - System.currentTimeMillis()) > 1000) {
                    if (statusSettingState != 1 && (lastStatusUpdateTime == 0 || Math.abs(System.currentTimeMillis() - lastStatusUpdateTime) >= 55000 || offlineSent)) {
                        statusSettingState = 1;

                        if (statusRequest != 0) {
                            getConnectionsManager().cancelRequest(statusRequest, true);
                        }

                        TL_account.updateStatus req = new TL_account.updateStatus();
                        req.offline = false;
                        statusRequest = getConnectionsManager().sendRequest(req, (response, error) -> {
                            if (error == null) {
                                lastStatusUpdateTime = System.currentTimeMillis();
                                offlineSent = false;
                                statusSettingState = 0;
                            } else {
                                if (lastStatusUpdateTime != 0) {
                                    lastStatusUpdateTime += 5000;
                                }
                            }
                            statusRequest = 0;
                        });
                    }
                }
            } else if (statusSettingState != 2 && !offlineSent && Math.abs(System.currentTimeMillis() - getConnectionsManager().getPauseTime()) >= 2000) {
                statusSettingState = 2;
                if (statusRequest != 0) {
                    getConnectionsManager().cancelRequest(statusRequest, true);
                }
                TL_account.updateStatus req = new TL_account.updateStatus();
                req.offline = true;
                statusRequest = getConnectionsManager().sendRequest(req, (response, error) -> {
                    if (error == null) {
                        offlineSent = true;
                    } else {
                        if (lastStatusUpdateTime != 0) {
                            lastStatusUpdateTime += 5000;
                        }
                    }
                    statusRequest = 0;
                });
            }

            if (updatesQueueChannels.size() != 0) {
                for (int a = 0; a < updatesQueueChannels.size(); a++) {
                    long key = updatesQueueChannels.keyAt(a);
                    long updatesStartWaitTime = updatesStartWaitTimeChannels.valueAt(a);
                    if (Math.abs(currentTime - updatesStartWaitTime) >= 1500) {
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("QUEUE CHANNEL " + key + " UPDATES WAIT TIMEOUT - CHECK QUEUE");
                        }
                        processChannelsUpdatesQueue(key, 0);
                    }
                }
            }

            for (int a = 0; a < 3; a++) {
                if (getUpdatesStartTime(a) != 0 && Math.abs(currentTime - getUpdatesStartTime(a)) >= 1500) {
                    if (BuildVars.LOGS_ENABLED) {
                        FileLog.d(a + " QUEUE UPDATES WAIT TIMEOUT - CHECK QUEUE");
                    }
                    processUpdatesQueue(a, 0);
                }
            }
        }
        int currentServerTime = getConnectionsManager().getCurrentTime();
        if (Math.abs(System.currentTimeMillis() - lastViewsCheckTime) >= 5000) {
            lastViewsCheckTime = System.currentTimeMillis();
            if (channelViewsToSend.size() != 0) {
                for (int a = 0; a < channelViewsToSend.size(); a++) {
                    long key = channelViewsToSend.keyAt(a);
                    TLRPC.TL_messages_getMessagesViews req = new TLRPC.TL_messages_getMessagesViews();
                    req.peer = getInputPeer(key);
                    req.id = channelViewsToSend.valueAt(a);
                    req.increment = a == 0;
                    getConnectionsManager().sendRequest(req, (response, error) -> {
                        if (response != null) {
                            TLRPC.TL_messages_messageViews res = (TLRPC.TL_messages_messageViews) response;
                            LongSparseArray<SparseIntArray> channelViews = new LongSparseArray<>();
                            LongSparseArray<SparseIntArray> channelForwards = new LongSparseArray<>();
                            LongSparseArray<SparseArray<TLRPC.MessageReplies>> channelReplies = new LongSparseArray<>();
                            SparseIntArray views = channelViews.get(key);
                            SparseIntArray forwards = channelForwards.get(key);
                            SparseArray<TLRPC.MessageReplies> replies = channelReplies.get(key);

                            for (int a1 = 0; a1 < req.id.size(); a1++) {
                                if (a1 >= res.views.size()) {
                                    break;
                                }
                                TLRPC.TL_messageViews messageViews = res.views.get(a1);
                                if ((messageViews.flags & 1) != 0) {
                                    if (views == null) {
                                        views = new SparseIntArray();
                                        channelViews.put(key, views);
                                    }
                                    views.put(req.id.get(a1), messageViews.views);
                                }
                                if ((messageViews.flags & 2) != 0) {
                                    if (forwards == null) {
                                        forwards = new SparseIntArray();
                                        channelForwards.put(key, forwards);
                                    }
                                    forwards.put(req.id.get(a1), messageViews.forwards);
                                }
                                if ((messageViews.flags & 4) != 0) {
                                    if (replies == null) {
                                        replies = new SparseArray<>();
                                        channelReplies.put(key, replies);
                                    }
                                    replies.put(req.id.get(a1), messageViews.replies);
                                }
                            }
                            getMessagesStorage().putUsersAndChats(res.users, res.chats, true, true);
                            getMessagesStorage().putChannelViews(channelViews, channelForwards, channelReplies, false);
                            AndroidUtilities.runOnUIThread(() -> {
                                putUsers(res.users, false);
                                putChats(res.chats, false);
                                getNotificationCenter().postNotificationName(NotificationCenter.didUpdateMessagesViews, channelViews, channelForwards, channelReplies, false);
                            });
                        }
                    });
                }
                channelViewsToSend.clear();
            }
            if (pollsToCheckSize > 0) {
                AndroidUtilities.runOnUIThread(() -> {
                    long time = SystemClock.elapsedRealtime();
                    int minExpireTime = Integer.MAX_VALUE;
                    for (int a = 0, N = pollsToCheck.size(); a < N; a++) {
                        SparseArray<MessageObject> array = pollsToCheck.valueAt(a);
                        if (array == null) {
                            continue;
                        }
                        for (int b = 0, N2 = array.size(); b < N2; b++) {
                            MessageObject messageObject = array.valueAt(b);
                            TLRPC.TL_messageMediaPoll mediaPoll = (TLRPC.TL_messageMediaPoll) messageObject.messageOwner.media;
                            int timeout = 30000;
                            boolean expired;
                            if (expired = (mediaPoll.poll.close_date != 0 && !mediaPoll.poll.closed)) {
                                if (mediaPoll.poll.close_date <= currentServerTime) {
                                    timeout = 1000;
                                } else {
                                    minExpireTime = Math.min(minExpireTime, mediaPoll.poll.close_date - currentServerTime);
                                }
                            }
                            if (Math.abs(time - messageObject.pollLastCheckTime) < timeout) {
                                if (!messageObject.pollVisibleOnScreen && !expired) {
                                    array.remove(messageObject.getId());
                                    N2--;
                                    b--;
                                }
                            } else {
                                messageObject.pollLastCheckTime = time;
                                TLRPC.TL_messages_getPollResults req = new TLRPC.TL_messages_getPollResults();
                                req.peer = getInputPeer(messageObject.getDialogId());
                                req.msg_id = messageObject.getId();
                                getConnectionsManager().sendRequest(req, (response, error) -> {
                                    if (error == null) {
                                        TLRPC.Updates updates = (TLRPC.Updates) response;
                                        if (expired) {
                                            for (int i = 0; i < updates.updates.size(); i++) {
                                                TLRPC.Update update = updates.updates.get(i);
                                                if (update instanceof TLRPC.TL_updateMessagePoll) {
                                                    TLRPC.TL_updateMessagePoll messagePoll = (TLRPC.TL_updateMessagePoll) update;
                                                    if (messagePoll.poll != null && !messagePoll.poll.closed) {
                                                        lastViewsCheckTime = System.currentTimeMillis() - 4000;
                                                    }
                                                }
                                            }
                                        }
                                        processUpdates(updates, false);
                                    }
                                });
                            }
                        }
                        if (minExpireTime < 5) {
                            lastViewsCheckTime = Math.min(lastViewsCheckTime, System.currentTimeMillis() - (5 - minExpireTime) * 1000);
                        }
                        if (array.size() == 0) {
                            pollsToCheck.remove(pollsToCheck.keyAt(a));
                            N--;
                            a--;
                        }
                    }
                    pollsToCheckSize = pollsToCheck.size();
                });
            }
        }
        if (!onlinePrivacy.isEmpty()) {
            ArrayList<Long> toRemove = null;
            for (ConcurrentHashMap.Entry<Long, Integer> entry : onlinePrivacy.entrySet()) {
                if (entry.getValue() < currentServerTime - 30) {
                    if (toRemove == null) {
                        toRemove = new ArrayList<>();
                    }
                    toRemove.add(entry.getKey());
                }
            }
            if (toRemove != null) {
                for (Long uid : toRemove) {
                    onlinePrivacy.remove(uid);
                }
                AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_STATUS));
            }
        }
        if (shortPollChannels.size() != 0) {
            for (int a = 0; a < shortPollChannels.size(); a++) {
                long key = shortPollChannels.keyAt(a);
                int timeout = shortPollChannels.valueAt(a);
                if (timeout < System.currentTimeMillis() / 1000) {
                    shortPollChannels.delete(key);
                    a--;
                    if (needShortPollChannels.indexOfKey(key) >= 0) {
                        getChannelDifference(key);
                    }
                }
            }
        }
        if (shortPollOnlines.size() != 0) {
            long time = SystemClock.elapsedRealtime() / 1000;
            for (int a = 0; a < shortPollOnlines.size(); a++) {
                long key = shortPollOnlines.keyAt(a);
                int timeout = shortPollOnlines.valueAt(a);
                if (timeout < time) {
                    if (needShortPollChannels.indexOfKey(key) >= 0) {
                        shortPollOnlines.put(key, (int) (time + 60 * 5));
                    } else {
                        shortPollOnlines.delete(key);
                        a--;
                    }
                    TLRPC.TL_messages_getOnlines req = new TLRPC.TL_messages_getOnlines();
                    req.peer = getInputPeer(-key);
                    getConnectionsManager().sendRequest(req, (response, error) -> {
                        if (response != null) {
                            TLRPC.TL_chatOnlines res = (TLRPC.TL_chatOnlines) response;
                            getMessagesStorage().updateChatOnlineCount(key, res.onlines);
                            AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.chatOnlineCountDidLoad, key, res.onlines));
                        }
                    });
                }
            }
        }
        if (!printingUsers.isEmpty() || lastPrintingStringCount != printingUsers.size()) {
            boolean updated = false;
            ArrayList<Long> dialogKeys = new ArrayList<>(printingUsers.keySet());
            for (int b = 0; b < dialogKeys.size(); b++) {
                Long dialogKey = dialogKeys.get(b);
                ConcurrentHashMap<Integer, ArrayList<PrintingUser>> threads = printingUsers.get(dialogKey);
                if (threads != null) {
                    ArrayList<Integer> threadKeys = new ArrayList<>(threads.keySet());
                    for (int c = 0; c < threadKeys.size(); c++) {
                        Integer threadKey = threadKeys.get(c);
                        ArrayList<PrintingUser> arr = threads.get(threadKey);
                        if (arr != null) {
                            for (int a = 0; a < arr.size(); a++) {
                                PrintingUser user = arr.get(a);
                                int timeToRemove;
                                if (user.action instanceof TLRPC.TL_sendMessageGamePlayAction) {
                                    timeToRemove = 30000;
                                } else {
                                    timeToRemove = 5900;
                                }
                                if (user.lastTime + timeToRemove < currentTime) {
                                    updated = true;
                                    arr.remove(user);
                                    a--;
                                }
                            }
                        }
                        if (arr == null || arr.isEmpty()) {
                            threads.remove(threadKey);
                            threadKeys.remove(c);
                            c--;
                        }
                    }
                }
                if (threads == null || threads.isEmpty()) {
                    printingUsers.remove(dialogKey);
                    dialogKeys.remove(b);
                    b--;
                }
            }

            updatePrintingStrings();

            if (updated) {
                AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_USER_PRINT));
            }
        }
        if (Theme.selectedAutoNightType == Theme.AUTO_NIGHT_TYPE_SCHEDULED && Math.abs(currentTime - lastThemeCheckTime) >= 60) {
            AndroidUtilities.runOnUIThread(themeCheckRunnable);
            lastThemeCheckTime = currentTime;
        }
        if (getUserConfig().savedPasswordHash != null && Math.abs(currentTime - lastPasswordCheckTime) >= 60) {
            AndroidUtilities.runOnUIThread(passwordCheckRunnable);
            lastPasswordCheckTime = currentTime;
        }
        if (lastPushRegisterSendTime != 0 && Math.abs(SystemClock.elapsedRealtime() - lastPushRegisterSendTime) >= 3 * 60 * 60 * 1000) {
            PushListenerController.sendRegistrationToServer(SharedConfig.pushType, SharedConfig.pushString);
        }
        getLocationController().update();
        checkPromoInfoInternal(false);
        checkTosUpdate();
    }

    private void checkTosUpdate() {
        if (nextTosCheckTime > getConnectionsManager().getCurrentTime() || checkingTosUpdate || !getUserConfig().isClientActivated()) {
            return;
        }
        checkingTosUpdate = true;
        TLRPC.TL_help_getTermsOfServiceUpdate req = new TLRPC.TL_help_getTermsOfServiceUpdate();
        getConnectionsManager().sendRequest(req, (response, error) -> {
            checkingTosUpdate = false;
            if (response instanceof TLRPC.TL_help_termsOfServiceUpdateEmpty) {
                TLRPC.TL_help_termsOfServiceUpdateEmpty res = (TLRPC.TL_help_termsOfServiceUpdateEmpty) response;
                nextTosCheckTime = res.expires;
            } else if (response instanceof TLRPC.TL_help_termsOfServiceUpdate) {
                TLRPC.TL_help_termsOfServiceUpdate res = (TLRPC.TL_help_termsOfServiceUpdate) response;
                nextTosCheckTime = res.expires;
                AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.needShowAlert, 4, res.terms_of_service));
            } else {
                nextTosCheckTime = getConnectionsManager().getCurrentTime() + 60 * 60;
            }
            notificationsPreferences.edit().putInt("nextTosCheckTime", nextTosCheckTime).commit();
        });
    }

    public void checkPromoInfo(final boolean reset) {
        Utilities.stageQueue.postRunnable(() -> checkPromoInfoInternal(reset));
    }

    private long lastCheckPromoInfoTime;

    private void checkPromoInfoInternal(boolean reset) {
        if (reset && checkingPromoInfo) {
            checkingPromoInfo = false;
        }
        if (!reset && nextPromoInfoCheckTime > getConnectionsManager().getCurrentTime() || checkingPromoInfo) {
            return;
        }
        if (checkingPromoInfoRequestId != 0) {
            getConnectionsManager().cancelRequest(checkingPromoInfoRequestId, true);
            checkingPromoInfoRequestId = 0;
        }
        SharedPreferences preferences = getGlobalMainSettings();
        boolean enabled = preferences.getBoolean("proxy_enabled", false);
        String proxyAddress = preferences.getString("proxy_ip", "");
        String proxySecret = preferences.getString("proxy_secret", "");
        int removeCurrent = 0;
        if (promoDialogId != 0 && promoDialogType == PROMO_TYPE_PROXY && proxyDialogAddress != null && !proxyDialogAddress.equals(proxyAddress + proxySecret)) {
            removeCurrent = 1;
        }
        lastCheckPromoId++;

        checkingPromoInfo = true;
        int checkPromoId = lastCheckPromoId;
        TLRPC.TL_help_getPromoData req = new TLRPC.TL_help_getPromoData();
        checkingPromoInfoRequestId = getConnectionsManager().sendRequest(req, (response, error) -> {
            if (checkPromoId != lastCheckPromoId) {
                return;
            }
            boolean noDialog = false;
            if (response instanceof TLRPC.TL_help_promoDataEmpty) {
                TLRPC.TL_help_promoDataEmpty res = (TLRPC.TL_help_promoDataEmpty) response;
                nextPromoInfoCheckTime = res.expires;
                noDialog = true;
            } else if (response instanceof TLRPC.TL_help_promoData) {
                TLRPC.TL_help_promoData res = (TLRPC.TL_help_promoData) response;

                long did;
                if (res.peer == null) {
                    did = 0;
                } else if (res.peer.user_id != 0) {
                    did = res.peer.user_id;
                } else if (res.peer.chat_id != 0) {
                    did = -res.peer.chat_id;
                    for (int a = 0; a < res.chats.size(); a++) {
                        TLRPC.Chat chat = res.chats.get(a);
                        if (chat.id == res.peer.chat_id) {
                            if (chat.kicked || chat.restricted) {
                                noDialog = true;
                            }
                            break;
                        }
                    }
                } else {
                    did = -res.peer.channel_id;
                    for (int a = 0; a < res.chats.size(); a++) {
                        TLRPC.Chat chat = res.chats.get(a);
                        if (chat.id == res.peer.channel_id) {
                            if (chat.kicked || chat.restricted) {
                                noDialog = true;
                            }
                            break;
                        }
                    }
                }
                promoDialogId = did;
                if (res.proxy) {
                    promoDialogType = PROMO_TYPE_PROXY;
                } else if (!TextUtils.isEmpty(res.psa_type)) {
                    promoDialogType = PROMO_TYPE_PSA;
                    promoPsaType = res.psa_type;
                } else {
                    promoDialogType = PROMO_TYPE_OTHER;
                }
                proxyDialogAddress = proxyAddress + proxySecret;
                promoPsaMessage = res.psa_message;
                nextPromoInfoCheckTime = res.expires;
                SharedPreferences.Editor editor = getGlobalMainSettings().edit();
                editor.putLong("proxy_dialog", promoDialogId);
                editor.putString("proxyDialogAddress", proxyDialogAddress);
                editor.putInt("promo_dialog_type", promoDialogType);
                if (promoPsaMessage != null) {
                    editor.putString("promo_psa_message", promoPsaMessage);
                } else {
                    editor.remove("promo_psa_message");
                }
                if (promoPsaType != null) {
                    editor.putString("promo_psa_type", promoPsaType);
                } else {
                    editor.remove("promo_psa_type");
                }
                editor.putInt("nextPromoInfoCheckTime", nextPromoInfoCheckTime);
                editor.commit();

                if (!noDialog) {
                    AndroidUtilities.runOnUIThread(() -> {
                        lastCheckPromoInfoTime = getConnectionsManager().getCurrentTime();

                        if (promoDialog != null && did != promoDialog.id) {
                            removePromoDialog();
                        }
                        promoDialog = dialogs_dict.get(did);
                        pendingSuggestions = new HashSet<>(res.pending_suggestions);
                        dismissedSuggestions = new HashSet<>(res.dismissed_suggestions);
                        customPendingSuggestion = res.custom_pending_suggestion;
                        getNotificationCenter().postNotificationName(NotificationCenter.newSuggestionsAvailable);

                        SharedPreferences.Editor editor1 = mainPreferences.edit();
                        editor1.putStringSet("pendingSuggestions", pendingSuggestions);
                        editor1.putStringSet("dismissedSuggestions", dismissedSuggestions);
                        editor1.commit();

                        if (promoDialog != null) {
                            checkingPromoInfo = false;
                            sortDialogs(null);
                            getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload, true);
                        } else {
                            LongSparseArray<TLRPC.User> usersDict = new LongSparseArray<>();
                            LongSparseArray<TLRPC.Chat> chatsDict = new LongSparseArray<>();
                            for (int a = 0; a < res.users.size(); a++) {
                                TLRPC.User u = res.users.get(a);
                                usersDict.put(u.id, u);
                            }
                            for (int a = 0; a < res.chats.size(); a++) {
                                TLRPC.Chat c = res.chats.get(a);
                                chatsDict.put(c.id, c);
                            }

                            TLRPC.TL_messages_getPeerDialogs req1 = new TLRPC.TL_messages_getPeerDialogs();
                            TLRPC.TL_inputDialogPeer peer = new TLRPC.TL_inputDialogPeer();
                            if (res.peer == null) {
                                if (promoDialog != null) {
                                    if (promoDialog.id < 0) {
                                        TLRPC.Chat chat = getChat(-promoDialog.id);
                                        if (ChatObject.isNotInChat(chat) || chat.restricted) {
                                            removeDialog(promoDialog);
                                        }
                                    } else {
                                        removeDialog(promoDialog);
                                    }
                                    promoDialog = null;
                                    sortDialogs(null);
                                    getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                                }
                                return;
                            } else if (res.peer.user_id != 0) {
                                peer.peer = new TLRPC.TL_inputPeerUser();
                                peer.peer.user_id = res.peer.user_id;
                                TLRPC.User user = usersDict.get(res.peer.user_id);
                                if (user != null) {
                                    peer.peer.access_hash = user.access_hash;
                                }
                            } else if (res.peer.chat_id != 0) {
                                peer.peer = new TLRPC.TL_inputPeerChat();
                                peer.peer.chat_id = res.peer.chat_id;
                                TLRPC.Chat chat = chatsDict.get(res.peer.chat_id);
                                if (chat != null) {
                                    peer.peer.access_hash = chat.access_hash;
                                }
                            } else {
                                peer.peer = new TLRPC.TL_inputPeerChannel();
                                peer.peer.channel_id = res.peer.channel_id;
                                TLRPC.Chat chat = chatsDict.get(res.peer.channel_id);
                                if (chat != null) {
                                    peer.peer.access_hash = chat.access_hash;
                                }
                            }

                            req1.peers.add(peer);
                            checkingPromoInfoRequestId = getConnectionsManager().sendRequest(req1, (response1, error1) -> {
                                if (checkPromoId != lastCheckPromoId) {
                                    return;
                                }
                                checkingPromoInfoRequestId = 0;
                                TLRPC.TL_messages_peerDialogs res2 = (TLRPC.TL_messages_peerDialogs) response1;
                                if (res2 != null && !res2.dialogs.isEmpty()) {
                                    getMessagesStorage().putUsersAndChats(res.users, res.chats, true, true);
                                    TLRPC.TL_messages_dialogs dialogs = new TLRPC.TL_messages_dialogs();
                                    dialogs.chats = res2.chats;
                                    dialogs.users = res2.users;
                                    dialogs.dialogs = res2.dialogs;
                                    dialogs.messages = res2.messages;
                                    getMessagesStorage().putDialogs(dialogs, 2);
                                    AndroidUtilities.runOnUIThread(() -> {
                                        putUsers(res.users, false);
                                        putChats(res.chats, false);
                                        putUsers(res2.users, false);
                                        putChats(res2.chats, false);

                                        if (promoDialog != null) {
                                            if (promoDialog.id < 0) {
                                                TLRPC.Chat chat = getChat(-promoDialog.id);
                                                if (ChatObject.isNotInChat(chat) || chat.restricted) {
                                                    removeDialog(promoDialog);
                                                }
                                            } else {
                                                removeDialog(promoDialog);
                                            }
                                        }

                                        promoDialog = res2.dialogs.get(0);
                                        promoDialog.id = did;
                                        promoDialog.folder_id = 0;
                                        if (DialogObject.isChannel(promoDialog)) {
                                            channelsPts.put(-promoDialog.id, promoDialog.pts);
                                        }
                                        Integer value = dialogs_read_inbox_max.get(promoDialog.id);
                                        if (value == null) {
                                            value = 0;
                                        }
                                        dialogs_read_inbox_max.put(promoDialog.id, Math.max(value, promoDialog.read_inbox_max_id));
                                        value = dialogs_read_outbox_max.get(promoDialog.id);
                                        if (value == null) {
                                            value = 0;
                                        }
                                        dialogs_read_outbox_max.put(promoDialog.id, Math.max(value, promoDialog.read_outbox_max_id));
                                        dialogs_dict.put(did, promoDialog);
                                        if (!res2.messages.isEmpty()) {
                                            LongSparseArray<TLRPC.User> usersDict1 = new LongSparseArray<>();
                                            LongSparseArray<TLRPC.Chat> chatsDict1 = new LongSparseArray<>();
                                            for (int a = 0; a < res2.users.size(); a++) {
                                                TLRPC.User u = res2.users.get(a);
                                                usersDict1.put(u.id, u);
                                            }
                                            for (int a = 0; a < res2.chats.size(); a++) {
                                                TLRPC.Chat c = res2.chats.get(a);
                                                chatsDict1.put(c.id, c);
                                            }
                                            MessageObject messageObject = new MessageObject(currentAccount, res2.messages.get(0), usersDict1, chatsDict1, false, true);
                                            ArrayList<MessageObject> objects = dialogMessage.get(did);
                                            if (objects == null) {
                                                objects = new ArrayList<>(1);
                                            }
                                            if (objects.size() > 0 && objects.get(0) != null && objects.get(0).hasValidGroupId() && objects.get(0).getGroupIdForUse() != messageObject.getGroupIdForUse()) {
                                                objects.clear();
                                            }
                                            objects.add(messageObject);
                                            dialogMessage.put(did, objects);
                                            if (promoDialog.last_message_date == 0) {
                                                promoDialog.last_message_date = messageObject.messageOwner.date;
                                            }
                                            getTranslateController().checkDialogMessage(did);
                                        }
                                        sortDialogs(null);
                                        getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload, true);
                                    });
                                } else {
                                    AndroidUtilities.runOnUIThread(() -> {
                                        if (promoDialog != null) {
                                            if (promoDialog.id < 0) {
                                                TLRPC.Chat chat = getChat(-promoDialog.id);
                                                if (ChatObject.isNotInChat(chat) || chat.restricted) {
                                                    removeDialog(promoDialog);
                                                }
                                            } else {
                                                removeDialog(promoDialog);
                                            }
                                            promoDialog = null;
                                            sortDialogs(null);
                                            getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                                        }
                                    });
                                }
                                checkingPromoInfo = false;
                            });
                        }
                    });
                }
            } else {
                nextPromoInfoCheckTime = getConnectionsManager().getCurrentTime() + 60 * 60;
                noDialog = true;
            }
            if (noDialog) {
                promoDialogId = 0;
                getGlobalMainSettings().edit().putLong("proxy_dialog", promoDialogId).remove("proxyDialogAddress").putInt("nextPromoInfoCheckTime", nextPromoInfoCheckTime).commit();
                checkingPromoInfoRequestId = 0;
                checkingPromoInfo = false;
                AndroidUtilities.runOnUIThread(this::removePromoDialog);
            }
        });
        if (removeCurrent != 0) {
            promoDialogId = 0;
            proxyDialogAddress = null;
            nextPromoInfoCheckTime = getConnectionsManager().getCurrentTime() + 60 * 60;
            getGlobalMainSettings().edit().putLong("proxy_dialog", promoDialogId).remove("proxyDialogAddress").putInt("nextPromoInfoCheckTime", nextPromoInfoCheckTime).commit();
            AndroidUtilities.runOnUIThread(this::removePromoDialog);
        }
    }

    private void removePromoDialog() {
        if (promoDialog == null) {
            return;
        }
        if (promoDialog.id < 0) {
            TLRPC.Chat chat = getChat(-promoDialog.id);
            if (ChatObject.isNotInChat(chat) || chat.restricted) {
                removeDialog(promoDialog);
            }
        } else {
            removeDialog(promoDialog);
        }
        promoDialog = null;
        sortDialogs(null);
        getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
    }

    public boolean isPromoDialog(long did, boolean checkLeft) {
        return promoDialog != null && promoDialog.id == did && (!checkLeft || isLeftPromoChannel);
    }

    private String getUserNameForTyping(TLRPC.User user) {
        if (user == null) {
            return "";
        }
        if (user.first_name != null && user.first_name.length() > 0) {
            return AndroidUtilities.removeDiacritics(user.first_name);
        } else if (user.last_name != null && user.last_name.length() > 0) {
            return AndroidUtilities.removeDiacritics(user.last_name);
        }
        return "";
    }

    private void updatePrintingStrings() {
        LongSparseArray<LongSparseArray<CharSequence>> newStrings = new LongSparseArray<>();
        LongSparseArray<LongSparseArray<Integer>> newTypes = new LongSparseArray<>();

        for (HashMap.Entry<Long, ConcurrentHashMap<Integer, ArrayList<PrintingUser>>> dialogEntry : printingUsers.entrySet()) {
            Long key = dialogEntry.getKey();
            boolean isEncryptedChat = DialogObject.isEncryptedDialog(key);
            ConcurrentHashMap<Integer, ArrayList<PrintingUser>> threads = dialogEntry.getValue();

            for (HashMap.Entry<Integer, ArrayList<PrintingUser>> threadEntry : threads.entrySet()) {
                Integer threadId = threadEntry.getKey();
                ArrayList<PrintingUser> arr = threadEntry.getValue();

                LongSparseArray<CharSequence> newPrintingStrings = new LongSparseArray<>();
                LongSparseArray<Integer> newPrintingStringsTypes = new LongSparseArray<>();
                newStrings.put(key, newPrintingStrings);
                newTypes.put(key, newPrintingStringsTypes);

                int type = 0;
                CharSequence text = null;
                if (key > 0 || isEncryptedChat || arr.size() == 1) {
                    PrintingUser pu = arr.get(0);
                    TLRPC.User user = getUser(pu.userId);
                    if (user == null) {
                        continue;
                    }
                    final boolean isGroup = key < 0 && !isEncryptedChat;
                    if (pu.action instanceof TLRPC.TL_sendMessageRecordAudioAction) {
                        if (isGroup) {
                            text = LocaleController.formatString("IsRecordingAudio", R.string.IsRecordingAudio, getUserNameForTyping(user));
                        } else {
                            text = LocaleController.getString(R.string.RecordingAudio);
                        }
                        type = 1;
                    } else if (pu.action instanceof TLRPC.TL_sendMessageRecordRoundAction) {
                        if (isGroup) {
                            text = LocaleController.formatString("IsRecordingRound", R.string.IsRecordingRound, getUserNameForTyping(user));
                        } else {
                            text = LocaleController.getString(R.string.RecordingRound);
                        }
                        type = 4;
                    } else if (pu.action instanceof TLRPC.TL_sendMessageUploadRoundAction) {
                        if (isGroup) {
                            text = LocaleController.formatString("IsSendingVideo", R.string.IsSendingVideo, getUserNameForTyping(user));
                        } else {
                            text = LocaleController.getString(R.string.SendingVideoStatus);
                        }
                        type = 4;
                    } else if (pu.action instanceof TLRPC.TL_sendMessageUploadAudioAction) {
                        if (isGroup) {
                            text = LocaleController.formatString("IsSendingAudio", R.string.IsSendingAudio, getUserNameForTyping(user));
                        } else {
                            text = LocaleController.getString(R.string.SendingAudio);
                        }
                        type = 2;
                    } else if (pu.action instanceof TLRPC.TL_sendMessageUploadVideoAction) {
                        if (isGroup) {
                            text = LocaleController.formatString("IsSendingVideo", R.string.IsSendingVideo, getUserNameForTyping(user));
                        } else {
                            text = LocaleController.getString(R.string.SendingVideoStatus);
                        }
                        type = 2;
                    } else if (pu.action instanceof TLRPC.TL_sendMessageRecordVideoAction) {
                        if (isGroup) {
                            text = LocaleController.formatString("IsRecordingVideo", R.string.IsRecordingVideo, getUserNameForTyping(user));
                        } else {
                            text = LocaleController.getString(R.string.RecordingVideoStatus);
                        }
                        type = 2;
                    } else if (pu.action instanceof TLRPC.TL_sendMessageUploadDocumentAction) {
                        if (isGroup) {
                            text = LocaleController.formatString("IsSendingFile", R.string.IsSendingFile, getUserNameForTyping(user));
                        } else {
                            text = LocaleController.getString(R.string.SendingFile);
                        }
                        type = 2;
                    } else if (pu.action instanceof TLRPC.TL_sendMessageUploadPhotoAction) {
                        if (isGroup) {
                            text = LocaleController.formatString("IsSendingPhoto", R.string.IsSendingPhoto, getUserNameForTyping(user));
                        } else {
                            text = LocaleController.getString(R.string.SendingPhoto);
                        }
                        type = 2;
                    } else if (pu.action instanceof TLRPC.TL_sendMessageGamePlayAction) {
                        if (isGroup) {
                            text = LocaleController.formatString("IsSendingGame", R.string.IsSendingGame, getUserNameForTyping(user));
                        } else {
                            text = LocaleController.getString(R.string.SendingGame);
                        }
                        type = 3;
                    } else if (pu.action instanceof TLRPC.TL_sendMessageGeoLocationAction) {
                        if (isGroup) {
                            text = LocaleController.formatString("IsSelectingLocation", R.string.IsSelectingLocation, getUserNameForTyping(user));
                        } else {
                            text = LocaleController.getString(R.string.SelectingLocation);
                        }
                        type = 0;
                    } else if (pu.action instanceof TLRPC.TL_sendMessageChooseContactAction) {
                        if (isGroup) {
                            text = LocaleController.formatString("IsSelectingContact", R.string.IsSelectingContact, getUserNameForTyping(user));
                        } else {
                            text = LocaleController.getString(R.string.SelectingContact);
                        }
                        type = 0;
                    } else if (pu.action instanceof TLRPC.TL_sendMessageEmojiInteractionSeen) {
                        final String emoji = ((TLRPC.TL_sendMessageEmojiInteractionSeen) pu.action).emoticon;
                        if (isGroup) {
                            text = LocaleController.formatString("IsEnjoyngAnimations", R.string.IsEnjoyngAnimations, getUserNameForTyping(user), emoji);
                        } else {
                            text = LocaleController.formatString("EnjoyngAnimations", R.string.EnjoyngAnimations, emoji);
                        }
                        type = 5;
                    } else if (pu.action instanceof TLRPC.TL_sendMessageChooseStickerAction) {
                        if (isGroup) {
                            text = LocaleController.formatString("IsChoosingSticker", R.string.IsChoosingSticker, getUserNameForTyping(user));
                        } else {
                            text = LocaleController.getString(R.string.ChoosingSticker);
                        }
                        type = 5;
                    } else {
                        if (isGroup) {
                            text = LocaleController.formatString("IsTypingGroup", R.string.IsTypingGroup, getUserNameForTyping(user));
                        } else {
                            text = LocaleController.getString(R.string.Typing);
                        }
                        type = 0;
                    }
                } else {
                    int count = 0;
                    StringBuilder label = new StringBuilder();
                    for (PrintingUser pu : arr) {
                        TLRPC.User user = getUser(pu.userId);
                        if (user != null) {
                            if (label.length() != 0) {
                                label.append(", ");
                            }
                            label.append(getUserNameForTyping(user));
                            count++;
                        }
                        if (count == 2) {
                            break;
                        }
                    }
                    if (label.length() != 0) {
                        if (count == 1) {
                            text = LocaleController.formatString("IsTypingGroup", R.string.IsTypingGroup, label.toString());
                        } else {
                            if (arr.size() > 2) {
                                String plural = LocaleController.getPluralString("AndMoreTypingGroup", arr.size() - 2);
                                try {
                                    text = String.format(plural, label.toString(), arr.size() - 2);
                                } catch (Exception e) {
                                    text = "LOC_ERR: AndMoreTypingGroup";
                                }
                            } else {
                                text = LocaleController.formatString("AreTypingGroup", R.string.AreTypingGroup, label.toString());
                            }
                        }
                        type = 0;
                    }
                }
                if (text != null) {
                    Paint paint = Theme.dialogs_messageNamePaint;
                    if (paint == null) {
                        paint = new Paint();
                        paint.setTypeface(AndroidUtilities.bold());
                        paint.setTextSize(AndroidUtilities.dp(14));
                    }
                    text = Emoji.replaceEmoji(text, paint.getFontMetricsInt(), false);
                    newPrintingStrings.put(threadId, text);
                    newPrintingStringsTypes.put(threadId, type);
                }
            }
        }

        lastPrintingStringCount = newStrings.size();

        AndroidUtilities.runOnUIThread(() -> {
            printingStrings = newStrings;
            printingStringsTypes = newTypes;
        });
    }

    public void cancelTyping(int action, long dialogId, long threadMsgId) {
        if (action < 0 || action >= sendingTypings.length || sendingTypings[action] == null) {
            return;
        }
        LongSparseArray<LongSparseArray<Boolean>> dialogs = sendingTypings[action];
        LongSparseArray<Boolean> threads = dialogs.get(dialogId);
        if (threads == null) {
            return;
        }
        threads.remove(threadMsgId);
        if (threads.size() == 0) {
            dialogs.remove(dialogId);
        }
    }

    public boolean sendTyping(long dialogId, long threadMsgId, int action, int classGuid) {
        return sendTyping(dialogId, threadMsgId, action, null, classGuid);
    }

    public boolean sendTyping(long dialogId, long threadMsgId, int action, String emojicon, int classGuid) {
        if (action < 0 || action >= sendingTypings.length || dialogId == 0) {
            return false;
        }
        final long selfId = UserConfig.getInstance(UserConfig.selectedAccount).getClientUserId();
        if (dialogId == selfId) {
            return false;
        }
        if (dialogId < 0) {
            if (ChatObject.getSendAsPeerId(getChat(-dialogId), getChatFull(-dialogId)) != selfId) {
                return false;
            }
        } else {
            TLRPC.User user = getUser(dialogId);
            if (user != null) {
                if (user.id == getUserConfig().getClientUserId()) {
                    return false;
                }
                if (user.status != null && user.status.expires != -100 && !onlinePrivacy.containsKey(user.id)) {
                    int time = getConnectionsManager().getCurrentTime();
                    if (user.status.expires <= time - 30) {
                        return false;
                    }
                }
            }
        }
        LongSparseArray<LongSparseArray<Boolean>> dialogs = sendingTypings[action];
        if (dialogs == null) {
            dialogs = sendingTypings[action] = new LongSparseArray<>();
        }
        LongSparseArray<Boolean> threads = dialogs.get(dialogId);
        if (threads == null) {
            dialogs.put(dialogId, threads = new LongSparseArray<>());
        }
        if (threads.get(threadMsgId) != null) {
            return false;
        }
        if (!DialogObject.isEncryptedDialog(dialogId)) {
            TLRPC.TL_messages_setTyping req = new TLRPC.TL_messages_setTyping();
            if (threadMsgId != 0) {
                req.top_msg_id = (int) threadMsgId;
                req.flags |= 1;
            }
            req.peer = getInputPeer(dialogId);
            if (req.peer instanceof TLRPC.TL_inputPeerChannel) {
                TLRPC.Chat chat = getChat(req.peer.channel_id);
                if (chat == null || !chat.megagroup) {
                    return false;
                }
            }
            if (req.peer == null) {
                return false;
            }
            if (action == 0) {
                req.action = new TLRPC.TL_sendMessageTypingAction();
            } else if (action == 1) {
                req.action = new TLRPC.TL_sendMessageRecordAudioAction();
            } else if (action == 2) {
                req.action = new TLRPC.TL_sendMessageCancelAction();
            } else if (action == 3) {
                req.action = new TLRPC.TL_sendMessageUploadDocumentAction();
            } else if (action == 4) {
                req.action = new TLRPC.TL_sendMessageUploadPhotoAction();
            } else if (action == 5) {
                req.action = new TLRPC.TL_sendMessageUploadVideoAction();
            } else if (action == 6) {
                req.action = new TLRPC.TL_sendMessageGamePlayAction();
            } else if (action == 7) {
                req.action = new TLRPC.TL_sendMessageRecordRoundAction();
            } else if (action == 8) {
                req.action = new TLRPC.TL_sendMessageUploadRoundAction();
            } else if (action == 9) {
                req.action = new TLRPC.TL_sendMessageUploadAudioAction();
            } else if (action == 10) {
                req.action = new TLRPC.TL_sendMessageChooseStickerAction();
            } else if (action == 11) {
                TLRPC.TL_sendMessageEmojiInteractionSeen interactionSeen = new TLRPC.TL_sendMessageEmojiInteractionSeen();
                interactionSeen.emoticon = emojicon;
                req.action = interactionSeen;
            }
            threads.put(threadMsgId, true);
            int reqId = getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> cancelTyping(action, dialogId, threadMsgId)), ConnectionsManager.RequestFlagFailOnServerErrors);
            if (classGuid != 0) {
                getConnectionsManager().bindRequestToGuid(reqId, classGuid);
            }
        } else {
            if (action != 0) {
                return false;
            }
            TLRPC.EncryptedChat chat = getEncryptedChat(DialogObject.getEncryptedChatId(dialogId));
            if (chat.auth_key != null && chat.auth_key.length > 1 && chat instanceof TLRPC.TL_encryptedChat) {
                TLRPC.TL_messages_setEncryptedTyping req = new TLRPC.TL_messages_setEncryptedTyping();
                req.peer = new TLRPC.TL_inputEncryptedChat();
                req.peer.chat_id = chat.id;
                req.peer.access_hash = chat.access_hash;
                req.typing = true;
                threads.put(threadMsgId, true);
                int reqId = getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> cancelTyping(action, dialogId, threadMsgId)), ConnectionsManager.RequestFlagFailOnServerErrors);
                if (classGuid != 0) {
                    getConnectionsManager().bindRequestToGuid(reqId, classGuid);
                }
            }
        }
        return true;
    }

    protected void removeDeletedMessagesFromArray(final long dialogId, ArrayList<TLRPC.Message> messages) {
        int maxDeletedId = deletedHistory.get(dialogId, 0);
        if (maxDeletedId == 0) {
            return;
        }
        for (int a = 0, N = messages.size(); a < N; a++) {
            TLRPC.Message message = messages.get(a);
            if (message.id <= maxDeletedId) {
                messages.remove(a);
                a--;
                N--;
            }
        }
    }

    public final static int LOAD_BACKWARD = 0;
    public final static int LOAD_FORWARD = 1;
    public final static int LOAD_FROM_UNREAD = 2;
    public final static int LOAD_AROUND_MESSAGE = 3;
    public final static int LOAD_AROUND_DATE = 4;

    public void loadMessages(long dialogId, long mergeDialogId, boolean loadInfo, int count, int max_id, int offset_date, boolean fromCache, int midDate, int classGuid, int load_type, int last_message_id, int mode, long threadMessageId, int replyFirstUnread, int loadIndex, boolean isTopic) {
        loadMessages(dialogId, mergeDialogId, loadInfo, count, max_id, offset_date, fromCache, midDate, classGuid, load_type, last_message_id, mode, threadMessageId, loadIndex, threadMessageId != 0 ? replyFirstUnread : 0, 0, 0, false, 0, isTopic);
    }

    public void loadMessages(long dialogId, long mergeDialogId, boolean loadInfo, int count, int max_id, int offset_date, boolean fromCache, int midDate, int classGuid, int load_type, int last_message_id, int mode, long threadMessageId, int loadIndex, int first_unread, int unread_count, int last_date, boolean queryFromServer, int mentionsCount, boolean isTopic) {
        loadMessagesInternal(dialogId, mergeDialogId, loadInfo, count, max_id, offset_date, fromCache, midDate, classGuid, load_type, last_message_id, mode, threadMessageId, loadIndex, first_unread, unread_count, last_date, queryFromServer, mentionsCount, true, true, isTopic, null, 0L);
    }

    private void loadMessagesInternal(long dialogId, long mergeDialogId, boolean loadInfo, int count, int max_id, int offset_date, boolean fromCache, int minDate, int classGuid, int load_type, int last_message_id, int mode, long threadMessageId, int loadIndex, int first_unread, int unread_count, int last_date, boolean queryFromServer, int mentionsCount, boolean loadDialog, boolean processMessages, boolean isTopic, Timer loaderLogger, long hash) {
        if (BuildVars.LOGS_ENABLED) {
            FileLog.d("load messages in chat " + dialogId + " topic_id " + threadMessageId + " count " + count + " max_id " + max_id + " cache " + fromCache + " mindate = " + minDate + " guid " + classGuid + " load_type " + load_type + " last_message_id " + last_message_id + " mode " + mode + " index " + loadIndex + " firstUnread " + first_unread + " unread_count " + unread_count + " last_date " + last_date + " queryFromServer " + queryFromServer + " isTopic " + isTopic);
        }
        if (BuildVars.LOGS_ENABLED && loaderLogger == null && mode == 0) {
            loaderLogger = new Timer("MessageLoaderLogger dialogId=" + dialogId + " index=" + loadIndex + " count=" + count);
        }
        if ((threadMessageId == 0 || isTopic || mode == ChatActivity.MODE_SUGGESTIONS || mode == ChatActivity.MODE_SAVED || mode == ChatActivity.MODE_QUICK_REPLIES) && mode != ChatActivity.MODE_PINNED && (fromCache || DialogObject.isEncryptedDialog(dialogId))) {
            getMessagesStorage().getMessages(dialogId, mergeDialogId, loadInfo, count, max_id, offset_date, minDate, classGuid, load_type, mode, threadMessageId, loadIndex, processMessages, isTopic, loaderLogger);
        } else {
            final TLRPC.Chat chat = dialogId < 0 ? getChat(-dialogId): null;
            if (mode == ChatActivity.MODE_QUICK_REPLIES) {
                TLRPC.TL_messages_getQuickReplyMessages req = new TLRPC.TL_messages_getQuickReplyMessages();
                req.shortcut_id = (int) threadMessageId;
                req.hash = hash;
                int reqId = getConnectionsManager().sendRequest(req, (response, error) -> {
                    if (response != null) {
                        TLRPC.messages_Messages res = (TLRPC.messages_Messages) response;
                        if (res instanceof TLRPC.TL_messages_messagesNotModified) {
                            return;
                        }
                        processLoadedMessages(res, res.messages.size(), dialogId, mergeDialogId, count, max_id, offset_date, false, classGuid, first_unread, last_message_id, unread_count, last_date, load_type, false, mode, threadMessageId, loadIndex, queryFromServer, mentionsCount, processMessages, isTopic, null);
                    } else if (error != null) {
                        if ("SHORTCUT_INVALID".equals(error.text)) {
                            processLoadedMessages(new TLRPC.TL_messages_messages(), 0, dialogId, mergeDialogId, count, max_id, offset_date, false, classGuid, first_unread, last_message_id, unread_count, last_date, load_type, false, mode, threadMessageId, loadIndex, queryFromServer, mentionsCount, processMessages, isTopic, null);
                        }
                    }
                });
                getConnectionsManager().bindRequestToGuid(reqId, classGuid);
            } else if (threadMessageId != 0) {
                if (mode == ChatActivity.MODE_SAVED || ChatObject.isMonoForum(chat)) {
                    TLRPC.TL_messages_getSavedHistory req = new TLRPC.TL_messages_getSavedHistory();
                    req.peer = getInputPeer(threadMessageId);
                    if (ChatObject.isMonoForum(chat)) {
                        req.parent_peer = getInputPeer(dialogId);
                    }
                    if (load_type == 4) {
                        req.add_offset = -count + 5;
                    } else if (load_type == 3) {
                        req.add_offset = -count / 2;
                    } else if (load_type == 1) {
                        req.add_offset = -count - 1;
                    } else if (load_type == 2 && max_id != 0) {
                        req.add_offset = -count + 6;
                    } else {
                        if (dialogId < 0 && max_id != 0) {
                            if (ChatObject.isChannel(chat)) {
                                req.add_offset = -1;
                                req.limit += 1;
                            }
                        }
                    }
                    req.limit = count;
                    req.offset_id = max_id;
                    req.offset_date = offset_date;
                    int reqId = getConnectionsManager().sendRequest(req, (response, error) -> {
                        if (response != null) {
                            TLRPC.messages_Messages res = (TLRPC.messages_Messages) response;
                            removeDeletedMessagesFromArray(dialogId, res.messages);
                            if (res.messages.size() > count) {
                                res.messages.remove(0);
                            }
                            int mid = max_id;
                            if (offset_date != 0 && !res.messages.isEmpty()) {
                                mid = res.messages.get(res.messages.size() - 1).id;
                                for (int a = res.messages.size() - 1; a >= 0; a--) {
                                    TLRPC.Message message = res.messages.get(a);
                                    if (message.date > offset_date) {
                                        mid = message.id;
                                        break;
                                    }
                                }
                            }
                            processLoadedMessages(res, res.messages.size(), dialogId, mergeDialogId, count, mid, offset_date, false, classGuid, first_unread, last_message_id, unread_count, last_date, load_type, false, mode, threadMessageId, loadIndex, queryFromServer, mentionsCount, processMessages, isTopic, null);
                        } else {
                            AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.loadingMessagesFailed, classGuid, req, error));
                        }
                    });
                    getConnectionsManager().bindRequestToGuid(reqId, classGuid);
                    return;
                }
                if (loadDialog && isTopic && load_type == 2 && last_message_id == 0) {
                    TLRPC.TL_forumTopic topic = topicsController.findTopic(-dialogId, threadMessageId);
                    if (topic != null) {
                        loadMessagesInternal(dialogId, mergeDialogId, loadInfo, count, max_id, offset_date, false, minDate, classGuid, load_type, topic.top_message, mode, threadMessageId, loadIndex, first_unread, topic.unread_count, last_date, queryFromServer, topic.unread_mentions_count, false, processMessages, isTopic, loaderLogger, 0L);
                        return;
                    }
                }
                if (mode != 0) {
                    return;
                }
                TLRPC.TL_messages_getReplies req = new TLRPC.TL_messages_getReplies();
                req.peer = getInputPeer(dialogId);
                req.msg_id = (int) threadMessageId;
                req.offset_date = offset_date;
                if (load_type == 4) {
                    req.add_offset = -count + 5;
                } else if (load_type == 3) {
                    req.add_offset = -count / 2;
                } else if (load_type == 1) {
                    req.add_offset = -count - 1;
                } else if (load_type == 2 && max_id != 0) {
                    req.add_offset = -count + 10;
                } else {
                    if (dialogId < 0 && max_id != 0) {
                        if (ChatObject.isChannel(chat)) {
                            req.add_offset = -1;
                            req.limit += 1;
                        }
                    }
                }
                req.limit = count;
                req.offset_id = max_id;
                req.hash = hash;
                long time = System.currentTimeMillis();
                int reqId = getConnectionsManager().sendRequest(req, (response, error) -> {
                    if (response != null) {
                        TLRPC.messages_Messages res = (TLRPC.messages_Messages) response;
                        if (res.messages.size() > count) {
                            res.messages.remove(0);
                        }
                        int mid = max_id;
                        int fnid = 0;
                        if (!res.messages.isEmpty()) {
                            if (offset_date != 0) {
                                mid = res.messages.get(res.messages.size() - 1).id;
                                for (int a = res.messages.size() - 1; a >= 0; a--) {
                                    TLRPC.Message message = res.messages.get(a);
                                    if (message.date > offset_date) {
                                        mid = message.id;
                                        break;
                                    }
                                }
                            } else if (first_unread != 0 && load_type == 2 && max_id > 0) {
                                for (int a = res.messages.size() - 1; a >= 0; a--) {
                                    TLRPC.Message message = res.messages.get(a);
                                    if (message.id > first_unread && !message.out) {
                                        fnid = message.id;
                                        break;
                                    }
                                }
                            }
                        }
                        processLoadedMessages(res, res.messages.size(), dialogId, mergeDialogId, count, mid, offset_date, false, classGuid, fnid, last_message_id, unread_count, last_date, load_type, false, mode, threadMessageId, loadIndex, queryFromServer, mentionsCount, processMessages, isTopic, null);
                    } else {
                        AndroidUtilities.runOnUIThread(() -> {
                            getNotificationCenter().postNotificationName(NotificationCenter.loadingMessagesFailed, classGuid, req, error);
                        });
                    }
                });
                getConnectionsManager().bindRequestToGuid(reqId, classGuid);
            } else if (mode == ChatActivity.MODE_PINNED) {
            } else if (mode == ChatActivity.MODE_SCHEDULED) {
                final TLRPC.TL_messages_getScheduledHistory req = new TLRPC.TL_messages_getScheduledHistory();
                req.peer = getInputPeer(dialogId);
                req.hash = hash;
                int reqId = getConnectionsManager().sendRequest(req, (response, error) -> {
                    if (response != null) {
                        TLRPC.messages_Messages res = (TLRPC.messages_Messages) response;
                        if (res instanceof TLRPC.TL_messages_messagesNotModified) {
                            return;
                        }
                        int mid = max_id;
                        if (offset_date != 0 && !res.messages.isEmpty()) {
                            mid = res.messages.get(res.messages.size() - 1).id;
                            for (int a = res.messages.size() - 1; a >= 0; a--) {
                                TLRPC.Message message = res.messages.get(a);
                                if (message.date > offset_date) {
                                    mid = message.id;
                                    break;
                                }
                            }
                        }
                        processLoadedMessages(res, res.messages.size(), dialogId, mergeDialogId, count, mid, offset_date, false, classGuid, first_unread, last_message_id, unread_count, last_date, load_type, false, mode, threadMessageId, loadIndex, queryFromServer, mentionsCount, processMessages, isTopic, null);
                    }
                });
                getConnectionsManager().bindRequestToGuid(reqId, classGuid);
            } else {
                if (!ChatObject.isMonoForum(chat) && loadDialog && (load_type == LOAD_AROUND_MESSAGE || load_type == LOAD_FROM_UNREAD) && last_message_id == 0) {
                    TLRPC.TL_messages_getPeerDialogs req = new TLRPC.TL_messages_getPeerDialogs();
                    TLRPC.InputPeer inputPeer = getInputPeer(dialogId);
                    TLRPC.TL_inputDialogPeer inputDialogPeer = new TLRPC.TL_inputDialogPeer();
                    inputDialogPeer.peer = inputPeer;
                    req.peers.add(inputDialogPeer);

                    getConnectionsManager().sendRequest(req, (response, error) -> {
                        if (response != null) {
                            TLRPC.TL_messages_peerDialogs res = (TLRPC.TL_messages_peerDialogs) response;
                            if (!res.dialogs.isEmpty()) {
                                TLRPC.Dialog dialog = res.dialogs.get(0);

                                if (dialog.top_message != 0) {
                                    TLRPC.TL_messages_dialogs dialogs = new TLRPC.TL_messages_dialogs();
                                    dialogs.chats = res.chats;
                                    dialogs.users = res.users;
                                    dialogs.dialogs = res.dialogs;
                                    dialogs.messages = res.messages;
                                    getMessagesStorage().putDialogs(dialogs, 2);
                                }

                                loadMessagesInternal(dialogId, mergeDialogId, loadInfo, count, max_id, offset_date, false, minDate, classGuid, load_type, dialog.top_message, 0, threadMessageId, loadIndex, first_unread, dialog.unread_count, last_date, queryFromServer, dialog.unread_mentions_count, false, processMessages, isTopic, null, 0L);
                            }
                        } else {
                            AndroidUtilities.runOnUIThread(() -> {
                                getNotificationCenter().postNotificationName(NotificationCenter.loadingMessagesFailed, classGuid, req, error);
                            });
                        }
                    });
                    return;
                }
                TLRPC.TL_messages_getHistory req = new TLRPC.TL_messages_getHistory();
                req.peer = getInputPeer(dialogId);
                if (load_type == 4) {
                    req.add_offset = -count + 5;
                } else if (load_type == 3) {
                    req.add_offset = -count / 2;
                } else if (load_type == 1) {
                    req.add_offset = -count - 1;
                } else if (load_type == 2 && max_id != 0) {
                    req.add_offset = -count + 6;
                } else {
                    if (dialogId < 0 && max_id != 0) {
                        if (ChatObject.isChannel(chat)) {
                            req.add_offset = -1;
                            req.limit += 1;
                        }
                    }
                }
                req.limit = count;
                req.offset_id = max_id;
                req.offset_date = offset_date;
//                req.hash = hash;
                int reqId = getConnectionsManager().sendRequest(req, (response, error) -> {
                    if (response != null) {
                        TLRPC.messages_Messages res = (TLRPC.messages_Messages) response;
                        removeDeletedMessagesFromArray(dialogId, res.messages);
                        if (res.messages.size() > count) {
                            res.messages.remove(0);
                        }
                        int mid = max_id;
                        if (offset_date != 0 && !res.messages.isEmpty()) {
                            mid = res.messages.get(res.messages.size() - 1).id;
                            for (int a = res.messages.size() - 1; a >= 0; a--) {
                                TLRPC.Message message = res.messages.get(a);
                                if (message.date > offset_date) {
                                    mid = message.id;
                                    break;
                                }
                            }
                        }
                        processLoadedMessages(res, res.messages.size(), dialogId, mergeDialogId, count, mid, offset_date, false, classGuid, first_unread, last_message_id, unread_count, last_date, load_type, false, mode, threadMessageId, loadIndex, queryFromServer, mentionsCount, processMessages, isTopic, null);
                    } else {
                        AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.loadingMessagesFailed, classGuid, req, error));
                    }
                });
                getConnectionsManager().bindRequestToGuid(reqId, classGuid);
            }
        }
    }

    public void reloadWebPages(final long dialogId, HashMap<String, ArrayList<MessageObject>> webpagesToReload, int mode) {
        final boolean scheduled = mode == ChatActivity.MODE_SCHEDULED;
        final boolean saved = mode == ChatActivity.MODE_SAVED;
        HashMap<String, ArrayList<MessageObject>> map;
        LongSparseArray<ArrayList<MessageObject>> array;
        if (scheduled) {
            map = reloadingScheduledWebpages;
            array = reloadingScheduledWebpagesPending;
        } else if (saved) {
            map = reloadingSavedWebpages;
            array = reloadingSavedWebpagesPending;
        } else {
            map = reloadingWebpages;
            array = reloadingWebpagesPending;
        }

        for (HashMap.Entry<String, ArrayList<MessageObject>> entry : webpagesToReload.entrySet()) {
            String url = entry.getKey();
            ArrayList<MessageObject> messages = entry.getValue();
            ArrayList<MessageObject> arrayList = map.get(url);
            if (arrayList == null) {
                arrayList = new ArrayList<>();
                map.put(url, arrayList);
            }
            arrayList.addAll(messages);
            TL_account.getWebPagePreview req = new TL_account.getWebPagePreview();
            req.message = url;
            getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> {
                ArrayList<MessageObject> arrayList1 = map.remove(url);
                if (arrayList1 == null) {
                    return;
                }
                TLRPC.TL_messages_messages messagesRes = new TLRPC.TL_messages_messages();
                TLRPC.TL_messageMediaWebPage media = null;
                if (response instanceof TL_account.webPagePreview) {
                    final TL_account.webPagePreview preview = (TL_account.webPagePreview) response;
                    putUsers(preview.users, false);
                    putChats(preview.chats, false);
                    if (preview.media instanceof TLRPC.TL_messageMediaWebPage) {
                        media = (TLRPC.TL_messageMediaWebPage) preview.media;
                    }
                }
                if (media == null) {
                    for (int a = 0; a < arrayList1.size(); a++) {
                        arrayList1.get(a).messageOwner.media.webpage = new TLRPC.TL_webPageEmpty();
                        messagesRes.messages.add(arrayList1.get(a).messageOwner);
                    }
                } else {
                    if (media.webpage instanceof TLRPC.TL_webPage || media.webpage instanceof TLRPC.TL_webPageEmpty) {
                        for (int a = 0; a < arrayList1.size(); a++) {
                            arrayList1.get(a).messageOwner.media.webpage = media.webpage;
                            if (a == 0) {
                                ImageLoader.saveMessageThumbs(arrayList1.get(a).messageOwner);
                            }
                            messagesRes.messages.add(arrayList1.get(a).messageOwner);
                        }
                    } else {
                        array.put(media.webpage.id, arrayList1);
                    }
                }
                if (!messagesRes.messages.isEmpty()) {
                    getMessagesStorage().putMessages(messagesRes, dialogId, -2, 0, false, mode, 0);
                    getNotificationCenter().postNotificationName(NotificationCenter.replaceMessagesObjects, dialogId, arrayList1);
                }
            }));
        }
    }

    public void processLoadedMessages(TLRPC.messages_Messages messagesRes, int resCount, long dialogId, long mergeDialogId, int count, int max_id, int offset_date, boolean isCache, int classGuid,
                                      int first_unread, int last_message_id, int unread_count, int last_date, int load_type, boolean isEnd, int mode, long threadMessageId, int loadIndex, boolean queryFromServer, int mentionsCount, boolean needProcess, boolean isTopic, Timer loaderLogger) {
        if (BuildVars.LOGS_ENABLED) {
            FileLog.d("processLoadedMessages size " + messagesRes.messages.size() + " in chat " + dialogId + " topic_id " + threadMessageId + " count " + count + " max_id " + max_id + " cache " + isCache + " guid " + classGuid + " load_type " + load_type + " last_message_id " + last_message_id + " index " + loadIndex + " firstUnread " + first_unread + " unread_count " + unread_count + " last_date " + last_date + " queryFromServer " + queryFromServer + " isTopic " + isTopic + " mode " + mode);
        }
        Timer.Task t1 = Timer.start(loaderLogger, "processLoadedMessages");

        long startProcessTime = SystemClock.elapsedRealtime();
        boolean createDialog = false;
        if (messagesRes instanceof TLRPC.TL_messages_channelMessages) {
            long channelId = -dialogId;
            if (mode == 0 && threadMessageId == 0) {
                int channelPts = channelsPts.get(channelId);
                if (channelPts == 0) {
                    channelPts = getMessagesStorage().getChannelPtsSync(channelId);
                    if (channelPts == 0) {
                        channelsPts.put(channelId, messagesRes.pts);
                        createDialog = true;
                        if (needShortPollChannels.indexOfKey(channelId) >= 0 && shortPollChannels.indexOfKey(channelId) < 0) {
                            getChannelDifference(channelId, 2, 0, null);
                        } else {
                            getChannelDifference(channelId);
                        }
                    }
                }
            }
        }
        if (!isCache) {
            ImageLoader.saveMessagesThumbs(messagesRes.messages);
        }
        boolean isInitialLoading = offset_date == 0 && max_id == 0;
        boolean reload;
        LongSparseArray<TLRPC.User> usersDict = new LongSparseArray<>();
        LongSparseArray<TLRPC.Chat> chatsDict = new LongSparseArray<>();
        for (int a = 0; a < messagesRes.users.size(); a++) {
            TLRPC.User u = messagesRes.users.get(a);
            usersDict.put(u.id, u);
        }
        for (int a = 0; a < messagesRes.chats.size(); a++) {
            TLRPC.Chat c = messagesRes.chats.get(a);
            chatsDict.put(c.id, c);
        }
        if (mode == ChatActivity.MODE_SCHEDULED) {
            reload = ((SystemClock.elapsedRealtime() - lastScheduledServerQueryTime.get(dialogId, 0L)) > 60 * 1000);
        } else if (mode == ChatActivity.MODE_QUICK_REPLIES) {
            reload = ((SystemClock.elapsedRealtime() - lastQuickReplyServerQueryTime.get(threadMessageId, 0L)) > 60 * 1000);
        } else if (mode == ChatActivity.MODE_SAVED) {
            reload = resCount == 0 && (!isInitialLoading || (SystemClock.elapsedRealtime() - lastSavedServerQueryTime.get(threadMessageId, 0L)) > 60 * 1000 || isCache);
        } else {
            reload = resCount == 0 && (!isInitialLoading || (SystemClock.elapsedRealtime() - lastServerQueryTime.get(dialogId, 0L)) > 60 * 1000 || (isCache && isTopic));
        }
        if (!DialogObject.isEncryptedDialog(dialogId) && isCache && reload) {
            if (mode == ChatActivity.MODE_SCHEDULED) {
                lastScheduledServerQueryTime.put(dialogId, SystemClock.elapsedRealtime());
            } else if (mode == ChatActivity.MODE_QUICK_REPLIES) {
                lastQuickReplyServerQueryTime.put(threadMessageId, SystemClock.elapsedRealtime());
            } else if (mode == ChatActivity.MODE_SAVED) {
                lastSavedServerQueryTime.put(threadMessageId, SystemClock.elapsedRealtime());
            } else if (mode == ChatActivity.MODE_DEFAULT) {
                lastServerQueryTime.put(dialogId, SystemClock.elapsedRealtime());
            }
            long hash = 0;
            if (mode == ChatActivity.MODE_SCHEDULED) {
                for (int a = 0, N = messagesRes.messages.size(); a < N; a++) {
                    TLRPC.Message message = messagesRes.messages.get(a);
                    if (message.id < 0) {
                        continue;
                    }
                    hash = MediaDataController.calcHash(hash, message.id);
                    hash = MediaDataController.calcHash(hash, message.edit_date);
                    hash = MediaDataController.calcHash(hash, message.date);
                }
            } else if (mode == ChatActivity.MODE_DEFAULT || mode == ChatActivity.MODE_SAVED) {
                final boolean includePeers = true;
                for (int a = 0, N = messagesRes.messages.size(); a < N; a++) {
                    TLRPC.Message message = messagesRes.messages.get(a);
                    if (message.id < 0) {
                        continue;
                    }
                    if (includePeers) {
                        hash = MediaDataController.calcHash(hash, Math.abs(DialogObject.getPeerDialogId(message.peer_id)));
                    }
                    hash = MediaDataController.calcHash(hash, message.id);
                    if (message.pinned) {
                        hash = MediaDataController.calcHash(hash, 1);
                    }
                    int date = message.date;
                    if ((message.flags & TLRPC.MESSAGE_FLAG_EDITED) != 0) {
                        date = message.edit_date;
                    }
                    hash = MediaDataController.calcHash(hash, date);
                }
            } else if (mode == ChatActivity.MODE_QUICK_REPLIES) {
                for (int a = 0, N = messagesRes.messages.size(); a < N; a++) {
                    TLRPC.Message message = messagesRes.messages.get(a);
                    if (message.id < 0) {
                        continue;
                    }
                    hash = MediaDataController.calcHash(hash, message.id);
                    if ((message.flags & TLRPC.MESSAGE_FLAG_EDITED) != 0) {
                        hash = MediaDataController.calcHash(hash, message.edit_date);
                    } else {
                        hash = MediaDataController.calcHash(hash, 0);
                    }
                }
            }
            final long finalHash = hash;
            AndroidUtilities.runOnUIThread(() -> loadMessagesInternal(dialogId, mergeDialogId, false, count, load_type == LOAD_FROM_UNREAD && queryFromServer ? first_unread : max_id, offset_date, false, 0, classGuid, load_type, last_message_id, mode, threadMessageId, loadIndex, first_unread, unread_count, last_date, queryFromServer, mentionsCount, true, needProcess, isTopic, loaderLogger, finalHash));
            if (messagesRes.messages.isEmpty()) {
                return;
            }
        }
        int size = messagesRes.messages.size();
        if (!isCache) {
            Integer inboxValue = dialogs_read_inbox_max.get(dialogId);
            if (inboxValue == null) {
                inboxValue = getMessagesStorage().getDialogReadMax(false, dialogId);
                dialogs_read_inbox_max.put(dialogId, inboxValue);
            }

            Integer outboxValue = dialogs_read_outbox_max.get(dialogId);
            if (outboxValue == null) {
                outboxValue = getMessagesStorage().getDialogReadMax(true, dialogId);
                dialogs_read_outbox_max.put(dialogId, outboxValue);
            }

            for (int a = 0; a < size; a++) {
                TLRPC.Message message = messagesRes.messages.get(a);

                if (mode == 0) {
                    if (message.action instanceof TLRPC.TL_messageActionChatDeleteUser) {
                        TLRPC.User user = usersDict.get(message.action.user_id);
                        if (user != null && user.bot) {
                            message.reply_markup = new TLRPC.TL_replyKeyboardHide();
                            message.flags |= 64;
                        }
                    }

                    if (message.action instanceof TLRPC.TL_messageActionChatMigrateTo || message.action instanceof TLRPC.TL_messageActionChannelCreate) {
                        message.unread = false;
                        message.media_unread = false;
                    } else if (threadMessageId == 0) {
                        message.unread = (message.out ? outboxValue : inboxValue) < message.id;
                    } else {
                        message.unread = true;
                    }
                }
            }
            if (threadMessageId == 0 || isTopic || mode == ChatActivity.MODE_SUGGESTIONS || mode == ChatActivity.MODE_SAVED || mode == ChatActivity.MODE_QUICK_REPLIES) {
                getMessagesStorage().putMessages(messagesRes, dialogId, load_type, max_id, createDialog, mode, threadMessageId);
            }
            if (mode == ChatActivity.MODE_SAVED) {
                getSavedMessagesController().update(threadMessageId, messagesRes);
            }
        }

        if (!needProcess && DialogObject.isEncryptedDialog(dialogId)) {
            AndroidUtilities.runOnUIThread(() -> {
                getNotificationCenter().postNotificationName(NotificationCenter.messagesDidLoadWithoutProcess, classGuid, messagesRes.messages.size(), isCache, isEnd, last_message_id);
            });
            return;
        }
        ArrayList<MessageObject> objects = new ArrayList<>();
        ArrayList<Integer> messagesToReload = new ArrayList<>();
        HashMap<String, ArrayList<MessageObject>> webpagesToReload = new HashMap<>();
        for (int a = 0; a < size; a++) {
            TLRPC.Message message = messagesRes.messages.get(a);
            message.dialog_id = dialogId;
            long checkFileTime = SystemClock.elapsedRealtime();
            MessageObject messageObject = new MessageObject(currentAccount, message, usersDict, chatsDict, true, false, mode == ChatActivity.MODE_SAVED);
            messageObject.scheduled = mode == 1;
            objects.add(messageObject);
            if (isCache) {
                if (message.legacy && message.layer < TLRPC.LAYER) {
                    messagesToReload.add(message.id);
                } else if (MessageObject.getMedia(message) instanceof TLRPC.TL_messageMediaUnsupported) {
                    if (MessageObject.getMedia(message).bytes != null && (MessageObject.getMedia(message).bytes.length == 0 || MessageObject.getMedia(message).bytes.length == 1 && MessageObject.getMedia(message).bytes[0] < TLRPC.LAYER || MessageObject.getMedia(message).bytes.length == 4 && Utilities.bytesToInt(MessageObject.getMedia(message).bytes) < TLRPC.LAYER)) {
                        messagesToReload.add(message.id);
                    }
                }
                if (MessageObject.getMedia(message) instanceof TLRPC.TL_messageMediaWebPage) {
                    if (MessageObject.getMedia(message).webpage instanceof TLRPC.TL_webPagePending && MessageObject.getMedia(message).webpage.date <= getConnectionsManager().getCurrentTime()) {
                        messagesToReload.add(message.id);
                    } else if (MessageObject.getMedia(message).webpage instanceof TLRPC.TL_webPageUrlPending) {
                        ArrayList<MessageObject> arrayList = webpagesToReload.get(MessageObject.getMedia(message).webpage.url);
                        if (arrayList == null) {
                            arrayList = new ArrayList<>();
                            webpagesToReload.put(MessageObject.getMedia(message).webpage.url, arrayList);
                        }
                        arrayList.add(messageObject);
                    }
                }
            }
        }
        getFileLoader().checkMediaExistance(objects);
        if (MessageObject.canCreateStripedThubms()) {
            for (int i = 0; i < objects.size(); i++) {
                objects.get(i).createStrippedThumb();
            }
        }
        if (BuildVars.LOGS_ENABLED) {
            FileLog.d("process time=" + (SystemClock.elapsedRealtime() - startProcessTime) +  " count=" + objects.size() + " for dialog  " + dialogId);
        }
        if (mode == ChatActivity.MODE_SCHEDULED) {
            Collections.sort(objects, (o1, o2) -> {
                if (o1.messageOwner.date == o2.messageOwner.date && o1.getId() >= 0 && o2.getId() >= 0) {
                    return o2.getId() - o1.getId();
                }
                return o2.messageOwner.date - o1.messageOwner.date;
            });
        } else if (mode == ChatActivity.MODE_QUICK_REPLIES) {
            Collections.sort(objects, (a, b) -> b.getId() - a.getId());
            for (int i = 0; i < objects.size(); ++i) {
                MessageObject msg = objects.get(i);
                if (msg.isReply()) {
                    final int msgId = msg.messageOwner.reply_to.reply_to_msg_id;
                    for (int j = 0; j < objects.size(); ++j) {
                        if (i == j) continue;
                        if (objects.get(j) != msg && objects.get(j).getId() == msgId) {
                            msg.replyMessageObject = objects.get(j);
                            msg.applyTimestampsHighlightForReplyMsg();
                            if (msg.messageOwner.action instanceof TLRPC.TL_messageActionPinMessage) {
                                msg.generatePinMessageText(null, null);
                            } else if (msg.messageOwner.action instanceof TLRPC.TL_messageActionGameScore) {
                                msg.generateGameMessageText(null);
                            } else if (msg.messageOwner.action instanceof TLRPC.TL_messageActionPaymentSent) {
                                msg.generatePaymentSentMessageText(null, false);
                            } else if (msg.messageOwner.action instanceof TLRPC.TL_messageActionPaymentSentMe) {
                                msg.generatePaymentSentMessageText(null, true);
                            } else if (msg.messageOwner.action instanceof TLRPC.TL_messageActionSuggestedPostApproval) {
                                msg.generateSuggestionApprovalMessageText();
                            }
                            break;
                        }
                    }
                }
            }
        }

        Timer.done(t1);
        Timer.Task t2 = Timer.start(loaderLogger, "processLoadedMessages: runOnUIThread");
        AndroidUtilities.runOnUIThread(() -> {
            Timer.done(t2);
            Timer.Task t3 = Timer.start(loaderLogger, "processLoadedMessages: post runOnUIThread");
            putUsers(messagesRes.users, isCache);
            putChats(messagesRes.chats, isCache);

            if (messagesRes.animatedEmoji != null && needProcess) {
                AnimatedEmojiDrawable.getDocumentFetcher(currentAccount).processDocuments(messagesRes.animatedEmoji);
            }
            int first_unread_final;
            if (mode == 1) {
                first_unread_final = 0;
            } else {
                first_unread_final = Integer.MAX_VALUE;
                if (queryFromServer && load_type == LOAD_FROM_UNREAD) {
                    for (int a = 0; a < messagesRes.messages.size(); a++) {
                        TLRPC.Message message = messagesRes.messages.get(a);
                        if ((!message.out || message.from_scheduled) && message.id > first_unread && message.id < first_unread_final) {
                            first_unread_final = message.id;
                        }
                    }
                }
                if (first_unread_final == Integer.MAX_VALUE) {
                    first_unread_final = first_unread;
                }
            }
            if (mode == 1 && count == 1) {
                getNotificationCenter().postNotificationName(NotificationCenter.scheduledMessagesUpdated, dialogId, objects.size(), false);
            }

            if (!DialogObject.isEncryptedDialog(dialogId) && mode != ChatActivity.MODE_QUICK_REPLIES) {
                int finalFirst_unread_final = first_unread_final;
                Timer.Task t5 = Timer.start(loaderLogger, "loadReplyMessagesForMessages");
                getMediaDataController().loadReplyMessagesForMessages(objects, dialogId, mode, threadMessageId, () -> {
                    Timer.done(t5);
                    if (!needProcess) {
                        getNotificationCenter().postNotificationName(NotificationCenter.messagesDidLoadWithoutProcess, classGuid, resCount, isCache, isEnd, last_message_id);
                    } else {
                        getNotificationCenter().postNotificationName(NotificationCenter.messagesDidLoad, dialogId, count, objects, isCache, finalFirst_unread_final, last_message_id, unread_count, last_date, load_type, isEnd, classGuid, loadIndex, max_id, mentionsCount, mode);
                    }
                }, classGuid, loaderLogger);
            } else {
                getNotificationCenter().postNotificationName(NotificationCenter.messagesDidLoad, dialogId, count, objects, isCache, first_unread_final, last_message_id, unread_count, last_date, load_type, isEnd, classGuid, loadIndex, max_id, mentionsCount, mode);
            }

            if (!messagesToReload.isEmpty()) {
                reloadMessages(messagesToReload, dialogId, mode);
            }
            if (!webpagesToReload.isEmpty()) {
                reloadWebPages(dialogId, webpagesToReload, mode);
            }

            Timer.done(t3);
            Timer.finish(loaderLogger);
        });
    }

    public void forceNoReload(long dialogId, int mode) {
        if (mode == ChatActivity.MODE_SCHEDULED) {
            lastScheduledServerQueryTime.put(dialogId, SystemClock.elapsedRealtime());
        } else if (mode == ChatActivity.MODE_DEFAULT) {
            lastServerQueryTime.put(dialogId, SystemClock.elapsedRealtime());
        }
    }

    public void loadHintDialogs() {
        if (!hintDialogs.isEmpty() || TextUtils.isEmpty(installReferer)) {
            return;
        }
        TLRPC.TL_help_getRecentMeUrls req = new TLRPC.TL_help_getRecentMeUrls();
        req.referer = installReferer;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error == null) {
                AndroidUtilities.runOnUIThread(() -> {
                    /*installReferer = null;
                    mainPreferences.edit().remove("installReferer").commit();*/

                    TLRPC.TL_help_recentMeUrls res = (TLRPC.TL_help_recentMeUrls) response;
                    putUsers(res.users, false);
                    putChats(res.chats, false);
                    hintDialogs.clear();
                    hintDialogs.addAll(res.urls);

                    getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                });
            }
        });
    }

    public TLRPC.TL_dialogFolder ensureFolderDialogExists(int folderId, boolean[] folderCreated) {
        if (folderId == 0) {
            return null;
        }
        long folderDialogId = DialogObject.makeFolderDialogId(folderId);
        TLRPC.Dialog dialog = dialogs_dict.get(folderDialogId);
        if (dialog instanceof TLRPC.TL_dialogFolder) {
            if (folderCreated != null) {
                folderCreated[0] = false;
            }
            return (TLRPC.TL_dialogFolder) dialog;
        }
        if (folderCreated != null) {
            folderCreated[0] = true;
        }
        TLRPC.TL_dialogFolder dialogFolder = new TLRPC.TL_dialogFolder();
        dialogFolder.id = folderDialogId;
        dialogFolder.peer = new TLRPC.TL_peerUser();
        dialogFolder.folder = new TLRPC.TL_folder();
        dialogFolder.folder.id = folderId;
        dialogFolder.folder.title = LocaleController.getString(R.string.ArchivedChats);
        dialogFolder.pinned = true;

        int maxPinnedNum = 0;
        for (int a = 0; a < allDialogs.size(); a++) {
            TLRPC.Dialog d = allDialogs.get(a);
            if (!d.pinned) {
                if (d.id != promoDialogId) {
                    break;
                }
                continue;
            }
            maxPinnedNum = Math.max(d.pinnedNum, maxPinnedNum);
        }
        dialogFolder.pinnedNum = maxPinnedNum + 1;

        TLRPC.TL_messages_dialogs dialogs = new TLRPC.TL_messages_dialogs();
        dialogs.dialogs.add(dialogFolder);
        getMessagesStorage().putDialogs(dialogs, 1);

        dialogs_dict.put(folderDialogId, dialogFolder);
        allDialogs.add(0, dialogFolder);
        return dialogFolder;
    }

    private void removeFolder(int folderId) {
        long dialogId = DialogObject.makeFolderDialogId(folderId);
        TLRPC.Dialog dialog = dialogs_dict.get(dialogId);
        if (dialog == null) {
            return;
        }
        dialogs_dict.remove(dialogId);
        allDialogs.remove(dialog);
        sortDialogs(null);
        getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
        getNotificationCenter().postNotificationName(NotificationCenter.folderBecomeEmpty, folderId);
    }

    protected void onFolderEmpty(int folderId) {
        long[] dialogsLoadOffset = getUserConfig().getDialogLoadOffsets(folderId);
        if (dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetId] == Integer.MAX_VALUE) {
            if (folderId == 1) {
                hasArchivedChats = false;
                checkArchiveFolder();
            } else {
                removeFolder(folderId);
            }
        } else {
            loadDialogs(folderId, 0, 10, false, () -> {
                if (folderId == 1) {
                    hasArchivedChats = false;
                    checkArchiveFolder();
                } else {
                    removeFolder(folderId);
                }
            });
        }
    }

    public void checkArchiveFolder() {
        if (!hasArchivedChats && !getStoriesController().hasHiddenStories()) {
            removeFolder(1);
        } else {
            boolean[] created = new boolean[]{false};
            ensureFolderDialogExists(1, created);
            if (created[0]) {
                sortDialogs(null);
                getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
            }
        }
        getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, 0);
    }

    public void checkIfFolderEmpty(int folderId) {
        if (folderId == 0) {
            return;
        }
        getMessagesStorage().checkIfFolderEmpty(folderId);
    }

    public int addDialogToFolder(long dialogId, int folderId, int pinnedNum, long taskId) {
        ArrayList<Long> arrayList = new ArrayList<>(1);
        arrayList.add(dialogId);
        return addDialogToFolder(arrayList, folderId, pinnedNum, null, taskId);
    }

    public int addDialogToFolder(ArrayList<Long> dialogIds, int folderId, int pinnedNum, ArrayList<TLRPC.TL_inputFolderPeer> peers, long taskId) {
        TLRPC.TL_folders_editPeerFolders req = new TLRPC.TL_folders_editPeerFolders();
        boolean[] folderCreated = null;

        long newTaskId;
        if (taskId == 0) {
            boolean added = false;
            long selfUserId = getUserConfig().getClientUserId();
            int size = 0;
            for (int a = 0, N = dialogIds.size(); a < N; a++) {
                long dialogId = dialogIds.get(a);
                if (!DialogObject.isChatDialog(dialogId) && !DialogObject.isUserDialog(dialogId) && !DialogObject.isEncryptedDialog(dialogId)) {
                    continue;
                }
                if (folderId == 1 && (dialogId == selfUserId || dialogId == 777000 || isPromoDialog(dialogId, false))) {
                    continue;
                }
                TLRPC.Dialog dialog = dialogs_dict.get(dialogId);
                if (dialog == null) {
                    continue;
                }
                added = true;
                dialog.folder_id = folderId;
                if (pinnedNum > 0) {
                    dialog.pinned = true;
                    dialog.pinnedNum = pinnedNum;
                } else {
                    dialog.pinned = false;
                    dialog.pinnedNum = 0;
                }
                if (folderCreated == null) {
                    folderCreated = new boolean[1];
                    hasArchivedChats = true;
                    ensureFolderDialogExists(folderId, folderCreated);
                }
                if (DialogObject.isEncryptedDialog(dialogId)) {
                    getMessagesStorage().setDialogsFolderId(null, null, dialogId, folderId);
                } else {
                    TLRPC.TL_inputFolderPeer folderPeer = new TLRPC.TL_inputFolderPeer();
                    folderPeer.folder_id = folderId;
                    folderPeer.peer = getInputPeer(dialogId);
                    req.folder_peers.add(folderPeer);
                    size += folderPeer.getObjectSize();
                }
            }
            if (!added) {
                return 0;
            }
            sortDialogs(null);
            getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);

            if (size != 0) {
                NativeByteBuffer data = null;
                try {
                    data = new NativeByteBuffer(4 + 4 + 4 + size);
                    data.writeInt32(17);
                    data.writeInt32(folderId);
                    data.writeInt32(req.folder_peers.size());
                    for (int a = 0, N = req.folder_peers.size(); a < N; a++) {
                        req.folder_peers.get(a).serializeToStream(data);
                    }
                } catch (Exception e) {
                    FileLog.e(e);
                }
                newTaskId = getMessagesStorage().createPendingTask(data);
            } else {
                newTaskId = 0;
            }
        } else {
            req.folder_peers = peers;
            newTaskId = taskId;
        }
        if (!req.folder_peers.isEmpty()) {
            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (error == null) {
                    processUpdates((TLRPC.Updates) response, false);
                }
                if (newTaskId != 0) {
                    getMessagesStorage().removePendingTask(newTaskId);
                }
            });
            getMessagesStorage().setDialogsFolderId(null, req.folder_peers, 0, folderId);
        }
        return folderCreated == null ? 0 : (folderCreated[0] ? 2 : 1);
    }

    public void loadDialogs(final int folderId, int offset, int count, boolean fromCache) {
        loadDialogs(folderId, offset, count, fromCache, null);
    }

    public void loadDialogs(final int folderId, int offset, int count, boolean fromCache, Runnable onEmptyCallback) {
        if (loadingDialogs.get(folderId) || resetingDialogs) {
            return;
        }
        loadingDialogs.put(folderId, true);
        getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
        if (BuildVars.LOGS_ENABLED) {
            FileLog.d("folderId = " + folderId + " load cacheOffset = " + offset + " count = " + count + " cache = " + fromCache);
        }
        if (fromCache) {
            getMessagesStorage().getDialogs(folderId, offset == 0 ? 0 : nextDialogsCacheOffset.get(folderId, 0), count, folderId == 0 && offset == 0);
        } else {
            TLRPC.TL_messages_getDialogs req = new TLRPC.TL_messages_getDialogs();
            req.limit = count;
            req.exclude_pinned = true;
            if (folderId != 0) {
                req.flags |= 2;
                req.folder_id = folderId;
            }
            long[] dialogsLoadOffset = getUserConfig().getDialogLoadOffsets(folderId);
            if (dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetId] != -1) {
                if (dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetId] == Integer.MAX_VALUE) {
                    dialogsEndReached.put(folderId, true);
                    serverDialogsEndReached.put(folderId, true);
                    loadingDialogs.put(folderId, false);
                    getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                    return;
                }
                req.offset_id = (int) dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetId];
                req.offset_date = (int) dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetDate];
                if (req.offset_id == 0) {
                    req.offset_peer = new TLRPC.TL_inputPeerEmpty();
                } else {
                    if (dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetChannelId] != 0) {
                        req.offset_peer = new TLRPC.TL_inputPeerChannel();
                        req.offset_peer.channel_id = dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetChannelId];
                    } else if (dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetUserId] != 0) {
                        req.offset_peer = new TLRPC.TL_inputPeerUser();
                        req.offset_peer.user_id = dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetUserId];
                    } else {
                        req.offset_peer = new TLRPC.TL_inputPeerChat();
                        req.offset_peer.chat_id = dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetChatId];
                    }
                    req.offset_peer.access_hash = dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetAccess];
                }
            } else {
                boolean found = false;
                ArrayList<TLRPC.Dialog> dialogs = getDialogs(folderId);
                for (int a = dialogs.size() - 1; a >= 0; a--) {
                    TLRPC.Dialog dialog = dialogs.get(a);
                    if (dialog.pinned) {
                        continue;
                    }
                    if (!DialogObject.isEncryptedDialog(dialog.id) && dialog.top_message > 0) {
                        ArrayList<MessageObject> dialogMessages = dialogMessage.get(dialog.id);
                        MessageObject lastMessage = null;
                        if (dialogMessages != null) {
                            for (int i = 0; i < dialogMessages.size(); ++i) {
                                MessageObject message = dialogMessages.get(i);
                                if (message != null && (lastMessage == null || message.getId() > lastMessage.getId())) {
                                    lastMessage = dialogMessages.get(i);
                                }
                            }
                        }
                        if (lastMessage != null && lastMessage.getId() > 0) {
                            req.offset_date = lastMessage.messageOwner.date;
                            req.offset_id = lastMessage.messageOwner.id;
                            long id;
                            if (lastMessage.messageOwner.peer_id.channel_id != 0) {
                                id = -lastMessage.messageOwner.peer_id.channel_id;
                            } else if (lastMessage.messageOwner.peer_id.chat_id != 0) {
                                id = -lastMessage.messageOwner.peer_id.chat_id;
                            } else {
                                id = lastMessage.messageOwner.peer_id.user_id;
                            }
                            req.offset_peer = getInputPeer(id);
                            found = true;
                            break;
                        }
                    }
                }
                if (!found) {
                    req.offset_peer = new TLRPC.TL_inputPeerEmpty();
                }
            }
            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (error == null) {
                    TLRPC.messages_Dialogs dialogsRes = (TLRPC.messages_Dialogs) response;
                    processLoadedDialogs(dialogsRes, null, null, folderId, 0, count, 0, false, false, false);
                    if (onEmptyCallback != null && dialogsRes.dialogs.isEmpty()) {
                        AndroidUtilities.runOnUIThread(onEmptyCallback);
                    }
                }
            });
        }
    }

    public void loadGlobalNotificationsSettings() {
        if (loadingNotificationSettings == 0 && !getUserConfig().notificationsSettingsLoaded) {
            SharedPreferences preferences = MessagesController.getNotificationsSettings(currentAccount);
            SharedPreferences.Editor editor1 = null;
            if (preferences.contains("EnableGroup")) {
                boolean enabled = preferences.getBoolean("EnableGroup", true);
                editor1 = preferences.edit();
                if (!enabled) {
                    editor1.putInt("EnableGroup2", Integer.MAX_VALUE);
                    editor1.putInt("EnableChannel2", Integer.MAX_VALUE);
                }
                editor1.remove("EnableGroup").commit();
            }
            if (preferences.contains("EnableAll")) {
                boolean enabled = preferences.getBoolean("EnableAll", true);
                if (editor1 == null) {
                    editor1 = preferences.edit();
                }
                if (!enabled) {
                    editor1.putInt("EnableAll2", Integer.MAX_VALUE);
                }
                editor1.remove("EnableAll").commit();
            }
            if (editor1 != null) {
                editor1.commit();
            }

            loadingNotificationSettings = 4;
            for (int a = 0; a < 3; a++) {
                TL_account.getNotifySettings req = new TL_account.getNotifySettings();
                if (a == 0) {
                    req.peer = new TLRPC.TL_inputNotifyChats();
                } else if (a == 1) {
                    req.peer = new TLRPC.TL_inputNotifyUsers();
                } else {
                    req.peer = new TLRPC.TL_inputNotifyBroadcasts();
                }
                int type = a;
                getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> {
                    if (response != null) {
                        loadingNotificationSettings--;
                        TLRPC.TL_peerNotifySettings notify_settings = (TLRPC.TL_peerNotifySettings) response;
                        SharedPreferences.Editor editor = notificationsPreferences.edit();
                        if (type == 0) {
                            if ((notify_settings.flags & 1) != 0) {
                                editor.putBoolean("EnablePreviewGroup", notify_settings.show_previews);
                            }
                            if ((notify_settings.flags & 2) != 0) {
                            /*if (notify_settings.silent) {
                                editor.putString("GroupSoundPath", "NoSound");
                            } else {
                                editor.remove("GroupSoundPath");
                            }*/
                            }
                            if ((notify_settings.flags & 4) != 0) {
                                editor.putInt("EnableGroup2", notify_settings.mute_until);
                            }
                        } else if (type == 1) {
                            if ((notify_settings.flags & 1) != 0) {
                                editor.putBoolean("EnablePreviewAll", notify_settings.show_previews);
                            }
                            if ((notify_settings.flags & 64) != 0) {
                                editor.putBoolean("EnableAllStories", !notify_settings.stories_muted);
                            }
                            if ((notify_settings.flags & 128) != 0) {
                                editor.putBoolean("EnableHideStoriesSenders", notify_settings.stories_hide_sender);
                            }
                            if ((notify_settings.flags & 2) != 0) {
                            /*if (notify_settings.silent) {
                                editor.putString("GlobalSoundPath", "NoSound");
                            } else {
                                editor.remove("GlobalSoundPath");
                            }*/
                            }
                            if ((notify_settings.flags & 4) != 0) {
                                editor.putInt("EnableAll2", notify_settings.mute_until);
                            }
                            if ((notify_settings.flags & 64) != 0) {
                                editor.putBoolean("EnableAllStories", !notify_settings.stories_muted);
                            }
                        } else {
                            if ((notify_settings.flags & 1) != 0) {
                                editor.putBoolean("EnablePreviewChannel", notify_settings.show_previews);
                            }
                            if ((notify_settings.flags & 2) != 0) {
                            /*if (notify_settings.silent) {
                                editor.putString("ChannelSoundPath", "NoSound");
                            } else {
                                editor.remove("ChannelSoundPath");
                            }*/
                            }
                            if ((notify_settings.flags & 4) != 0) {
                                editor.putInt("EnableChannel2", notify_settings.mute_until);
                            }
                        }
                        getNotificationsController().getNotificationsSettingsFacade().applySoundSettings(notify_settings.android_sound, editor, 0, 0, type, false);
                        editor.apply();
                        if (loadingNotificationSettings == 0) {
                            getUserConfig().notificationsSettingsLoaded = true;
                            getUserConfig().saveConfig(false);
                        }
                    }
                }));
            }

            getConnectionsManager().sendRequest(new TL_account.getReactionsNotifySettings(), (res, err) -> AndroidUtilities.runOnUIThread(() -> {
                loadingNotificationSettings--;
                if (res instanceof TL_account.TL_reactionsNotifySettings) {
                    TL_account.TL_reactionsNotifySettings notify_settings = (TL_account.TL_reactionsNotifySettings) res;
                    SharedPreferences.Editor editor = notificationsPreferences.edit();
                    editor.putBoolean("EnableReactionsMessages", notify_settings.messages_notify_from != null);
                    if (notify_settings.messages_notify_from != null) {
                        editor.putBoolean("EnableReactionsMessagesContacts", notify_settings.messages_notify_from instanceof TL_account.TL_reactionNotificationsFromContacts);
                    }
                    editor.putBoolean("EnableReactionsStories", notify_settings.stories_notify_from != null);
                    if (notify_settings.stories_notify_from != null) {
                        editor.putBoolean("EnableReactionsStoriesContacts", notify_settings.stories_notify_from instanceof TL_account.TL_reactionNotificationsFromContacts);
                    }
                    editor.putBoolean("EnableReactionsPreview", notify_settings.show_previews);
                    getNotificationsController().getNotificationsSettingsFacade().applySoundSettings(notify_settings.sound, editor, 0, 0, TYPE_REACTIONS_MESSAGES, false);
                    editor.apply();
                }
                if (loadingNotificationSettings == 0) {
                    getUserConfig().notificationsSettingsLoaded = true;
                    getUserConfig().saveConfig(false);
                }
            }));
            sortDialogs(null);
        }
        if (!getUserConfig().notificationsSignUpSettingsLoaded) {
            loadSignUpNotificationsSettings();
        }
    }

    public void reloadReactionsNotifySettings() {
        getConnectionsManager().sendRequest(new TL_account.getReactionsNotifySettings(), (res, err) -> AndroidUtilities.runOnUIThread(() -> {
            if (res instanceof TL_account.TL_reactionsNotifySettings) {
                TL_account.TL_reactionsNotifySettings notify_settings = (TL_account.TL_reactionsNotifySettings) res;
                SharedPreferences.Editor editor = notificationsPreferences.edit();
                editor.putBoolean("EnableReactionsMessages", notify_settings.messages_notify_from != null);
                if (notify_settings.messages_notify_from != null) {
                    editor.putBoolean("EnableReactionsMessagesContacts", notify_settings.messages_notify_from instanceof TL_account.TL_reactionNotificationsFromContacts);
                }
                editor.putBoolean("EnableReactionsStories", notify_settings.stories_notify_from != null);
                if (notify_settings.stories_notify_from != null) {
                    editor.putBoolean("EnableReactionsStoriesContacts", notify_settings.stories_notify_from instanceof TL_account.TL_reactionNotificationsFromContacts);
                }
                editor.putBoolean("EnableReactionsPreview", notify_settings.show_previews);
                getNotificationsController().getNotificationsSettingsFacade().applySoundSettings(notify_settings.sound, editor, 0, 0, TYPE_REACTIONS_MESSAGES, false);
                editor.apply();

                getNotificationCenter().postNotificationName(NotificationCenter.notificationsSettingsUpdated);
            }
        }));
    }

    public void loadSignUpNotificationsSettings() {
        if (!loadingNotificationSignUpSettings) {
            loadingNotificationSignUpSettings = true;
            TL_account.getContactSignUpNotification req = new TL_account.getContactSignUpNotification();
            getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> {
                loadingNotificationSignUpSettings = false;
                SharedPreferences.Editor editor = notificationsPreferences.edit();
                enableJoined = response instanceof TLRPC.TL_boolFalse;
                editor.putBoolean("EnableContactJoined", enableJoined);
                editor.commit();
                getUserConfig().notificationsSignUpSettingsLoaded = true;
                getUserConfig().saveConfig(false);
            }));
        }
    }

    public void forceResetDialogs() {
        resetDialogs(true, getMessagesStorage().getLastSeqValue(), getMessagesStorage().getLastPtsValue(), getMessagesStorage().getLastDateValue(), getMessagesStorage().getLastQtsValue());
        getNotificationsController().deleteAllNotificationChannels();
    }

    protected void loadUnknownDialog(final TLRPC.InputPeer peer, long taskId) {
        if (peer == null) {
            return;
        }
        long dialogId = DialogObject.getPeerDialogId(peer);
        if (gettingUnknownDialogs.indexOfKey(dialogId) >= 0) {
            return;
        }
        gettingUnknownDialogs.put(dialogId, true);
        if (BuildVars.LOGS_ENABLED) {
            FileLog.d("load unknown dialog " + dialogId);
        }

        TLRPC.TL_messages_getPeerDialogs req = new TLRPC.TL_messages_getPeerDialogs();
        TLRPC.TL_inputDialogPeer inputDialogPeer = new TLRPC.TL_inputDialogPeer();
        inputDialogPeer.peer = peer;
        req.peers.add(inputDialogPeer);
        long newTaskId;
        if (taskId == 0) {
            NativeByteBuffer data = null;
            try {
                data = new NativeByteBuffer(4 + peer.getObjectSize());
                data.writeInt32(15);
                peer.serializeToStream(data);
            } catch (Exception e) {
                FileLog.e(e);
            }
            newTaskId = getMessagesStorage().createPendingTask(data);
        } else {
            newTaskId = taskId;
        }

        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response != null) {
                TLRPC.TL_messages_peerDialogs res = (TLRPC.TL_messages_peerDialogs) response;
                if (!res.dialogs.isEmpty()) {
                    TLRPC.TL_dialog dialog = (TLRPC.TL_dialog) res.dialogs.get(0);
                    TLRPC.TL_messages_dialogs dialogs = new TLRPC.TL_messages_dialogs();
                    dialogs.dialogs.addAll(res.dialogs);
                    dialogs.messages.addAll(res.messages);
                    dialogs.users.addAll(res.users);
                    dialogs.chats.addAll(res.chats);
                    processLoadedDialogs(dialogs, null, null, dialog.folder_id, 0, 1, DIALOGS_LOAD_TYPE_UNKNOWN, false, false, false);
                }
            }
            if (newTaskId != 0) {
                getMessagesStorage().removePendingTask(newTaskId);
            }
            gettingUnknownDialogs.delete(dialogId);
        });
    }

    private void fetchFolderInLoadedPinnedDialogs(TLRPC.TL_messages_peerDialogs res) {
        for (int a = 0, N = res.dialogs.size(); a < N; a++) {
            TLRPC.Dialog dialog = res.dialogs.get(a);
            if (dialog instanceof TLRPC.TL_dialogFolder) {
                TLRPC.TL_dialogFolder dialogFolder = (TLRPC.TL_dialogFolder) dialog;
                long folderTopDialogId = DialogObject.getPeerDialogId(dialog.peer);
                if (dialogFolder.top_message == 0 || folderTopDialogId == 0) {
                    res.dialogs.remove(dialogFolder);
                    continue;
                }
                for (int b = 0, N2 = res.messages.size(); b < N2; b++) {
                    TLRPC.Message message = res.messages.get(b);
                    long messageDialogId = MessageObject.getDialogId(message);
                    if (folderTopDialogId == messageDialogId && dialog.top_message == message.id) {
                        TLRPC.TL_dialog newDialog = new TLRPC.TL_dialog();
                        newDialog.peer = dialog.peer;
                        newDialog.top_message = dialog.top_message;
                        newDialog.folder_id = dialogFolder.folder.id;
                        newDialog.flags |= 16;
                        res.dialogs.add(newDialog);

                        TLRPC.InputPeer inputPeer;
                        if (dialog.peer instanceof TLRPC.TL_peerChannel) {
                            inputPeer = new TLRPC.TL_inputPeerChannel();
                            inputPeer.channel_id = dialog.peer.channel_id;
                            for (int c = 0, N3 = res.chats.size(); c < N3; c++) {
                                TLRPC.Chat chat = res.chats.get(c);
                                if (chat.id == inputPeer.channel_id) {
                                    inputPeer.access_hash = chat.access_hash;
                                    break;
                                }
                            }
                        } else if (dialog.peer instanceof TLRPC.TL_peerChat) {
                            inputPeer = new TLRPC.TL_inputPeerChat();
                            inputPeer.chat_id = dialog.peer.chat_id;
                        } else {
                            inputPeer = new TLRPC.TL_inputPeerUser();
                            inputPeer.user_id = dialog.peer.user_id;
                            for (int c = 0, N3 = res.users.size(); c < N3; c++) {
                                TLRPC.User user = res.users.get(c);
                                if (user.id == inputPeer.user_id) {
                                    inputPeer.access_hash = user.access_hash;
                                    break;
                                }
                            }
                        }
                        loadUnknownDialog(inputPeer, 0);
                        break;
                    }
                }
                break;
            }
        }
    }

    private void resetDialogs(boolean query, int seq, int newPts, int date, int qts) {
        if (query) {
            if (resetingDialogs) {
                return;
            }
            getUserConfig().setPinnedDialogsLoaded(1, false);
            resetingDialogs = true;
            TLRPC.TL_messages_getPinnedDialogs req = new TLRPC.TL_messages_getPinnedDialogs();
            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (response != null) {
                    resetDialogsPinned = (TLRPC.TL_messages_peerDialogs) response;
                    for (int a = 0; a < resetDialogsPinned.dialogs.size(); a++) {
                        TLRPC.Dialog d = resetDialogsPinned.dialogs.get(a);
                        d.pinned = true;
                    }
                    resetDialogs(false, seq, newPts, date, qts);
                }
            });
            TLRPC.TL_messages_getDialogs req2 = new TLRPC.TL_messages_getDialogs();
            req2.limit = 100;
            req2.exclude_pinned = true;
            req2.offset_peer = new TLRPC.TL_inputPeerEmpty();
            getConnectionsManager().sendRequest(req2, (response, error) -> {
                if (error == null) {
                    resetDialogsAll = (TLRPC.messages_Dialogs) response;
                    resetDialogs(false, seq, newPts, date, qts);
                }
            });
        } else if (resetDialogsPinned != null && resetDialogsAll != null) {
            int messagesCount = resetDialogsAll.messages.size();
            int dialogsCount = resetDialogsAll.dialogs.size();
            fetchFolderInLoadedPinnedDialogs(resetDialogsPinned);
            resetDialogsAll.dialogs.addAll(resetDialogsPinned.dialogs);
            resetDialogsAll.messages.addAll(resetDialogsPinned.messages);
            resetDialogsAll.users.addAll(resetDialogsPinned.users);
            resetDialogsAll.chats.addAll(resetDialogsPinned.chats);

            LongSparseArray<TLRPC.Dialog> new_dialogs_dict = new LongSparseArray<>();
            LongSparseArray<ArrayList<MessageObject>> new_dialogMessage = new LongSparseArray<>();
            LongSparseArray<TLRPC.User> usersDict = new LongSparseArray<>();
            LongSparseArray<TLRPC.Chat> chatsDict = new LongSparseArray<>();

            for (int a = 0; a < resetDialogsAll.users.size(); a++) {
                TLRPC.User u = resetDialogsAll.users.get(a);
                usersDict.put(u.id, u);
            }
            for (int a = 0; a < resetDialogsAll.chats.size(); a++) {
                TLRPC.Chat c = resetDialogsAll.chats.get(a);
                chatsDict.put(c.id, c);
            }

            TLRPC.Message lastMessage = null;
            for (int a = 0; a < resetDialogsAll.messages.size(); a++) {
                TLRPC.Message message = resetDialogsAll.messages.get(a);
                if (a < messagesCount) {
                    if (lastMessage == null || message.date < lastMessage.date) {
                        lastMessage = message;
                    }
                }
                if (message.peer_id.channel_id != 0) {
                    TLRPC.Chat chat = chatsDict.get(message.peer_id.channel_id);
                    if (chat != null && chat.left) {
                        continue;
                    }
                } else if (message.peer_id.chat_id != 0) {
                    TLRPC.Chat chat = chatsDict.get(message.peer_id.chat_id);
                    if (chat != null && chat.migrated_to != null) {
                        continue;
                    }
                }
                MessageObject messageObject = new MessageObject(currentAccount, message, usersDict, chatsDict, false, true);
                long did = messageObject.getDialogId();
                ArrayList<MessageObject> arrayList = new_dialogMessage.get(did);
                if (arrayList == null) {
                    arrayList = new ArrayList<MessageObject>(1);
                }
                arrayList.add(messageObject);
                new_dialogMessage.put(did, arrayList);
            }

            for (int a = 0; a < resetDialogsAll.dialogs.size(); a++) {
                TLRPC.Dialog d = resetDialogsAll.dialogs.get(a);
                DialogObject.initDialog(d);
                if (d.id == 0) {
                    continue;
                }
                if (d.last_message_date == 0) {
                    ArrayList<MessageObject> messages = new_dialogMessage.get(d.id);
                    if (messages != null) {
                        int maxDate = Integer.MIN_VALUE;
                        for (int i = 0; i < messages.size(); ++i) {
                            MessageObject msg = messages.get(i);
                            if (msg != null && msg.messageOwner != null && msg.messageOwner.date > maxDate) {
                                maxDate = msg.messageOwner.date;
                            }
                        }
                        if (maxDate > Integer.MIN_VALUE) {
                            d.last_message_date = maxDate;
                        }
                    }
                }
                if (DialogObject.isChannel(d)) {
                    TLRPC.Chat chat = chatsDict.get(-d.id);
                    if (chat != null && chat.left) {
                        continue;
                    }
                    channelsPts.put(-d.id, d.pts);
                } else if (DialogObject.isChatDialog(d.id)) {
                    TLRPC.Chat chat = chatsDict.get(-d.id);
                    if (chat != null && chat.migrated_to != null) {
                        continue;
                    }
                }
                new_dialogs_dict.put(d.id, d);

                Integer value = dialogs_read_inbox_max.get(d.id);
                if (value == null) {
                    value = 0;
                }
                dialogs_read_inbox_max.put(d.id, Math.max(value, d.read_inbox_max_id));

                value = dialogs_read_outbox_max.get(d.id);
                if (value == null) {
                    value = 0;
                }
                dialogs_read_outbox_max.put(d.id, Math.max(value, d.read_outbox_max_id));
            }

            ImageLoader.saveMessagesThumbs(resetDialogsAll.messages);
            for (int a = 0; a < resetDialogsAll.messages.size(); a++) {
                TLRPC.Message message = resetDialogsAll.messages.get(a);
                if (message.action instanceof TLRPC.TL_messageActionChatDeleteUser) {
                    TLRPC.User user = usersDict.get(message.action.user_id);
                    if (user != null && user.bot) {
                        message.reply_markup = new TLRPC.TL_replyKeyboardHide();
                        message.flags |= 64;
                    }
                }

                if (message.action instanceof TLRPC.TL_messageActionChatMigrateTo || message.action instanceof TLRPC.TL_messageActionChannelCreate) {
                    message.unread = false;
                    message.media_unread = false;
                } else {
                    ConcurrentHashMap<Long, Integer> read_max = message.out ? dialogs_read_outbox_max : dialogs_read_inbox_max;
                    Integer value = read_max.get(message.dialog_id);
                    if (value == null) {
                        value = getMessagesStorage().getDialogReadMax(message.out, message.dialog_id);
                        read_max.put(message.dialog_id, value);
                    }
                    message.unread = value < message.id;
                }
            }

            getMessagesStorage().resetDialogs(resetDialogsAll, messagesCount, seq, newPts, date, qts, new_dialogs_dict, new_dialogMessage, lastMessage, dialogsCount);
            resetDialogsPinned = null;
            resetDialogsAll = null;
        }
    }

    protected void completeDialogsReset(final TLRPC.messages_Dialogs dialogsRes, int messagesCount, int seq, int newPts, int date, int qts, LongSparseArray<TLRPC.Dialog> new_dialogs_dict, LongSparseArray<ArrayList<MessageObject>> new_dialogMessage, TLRPC.Message lastMessage) {
        Utilities.stageQueue.postRunnable(() -> {
            gettingDifference = false;
            getMessagesStorage().setLastPtsValue(newPts);
            getMessagesStorage().setLastDateValue(date);
            getMessagesStorage().setLastQtsValue(qts);
            getDifference();

            AndroidUtilities.runOnUIThread(() -> {
                resetingDialogs = false;
                applyDialogsNotificationsSettings(dialogsRes.dialogs);

                MediaDataController mediaDataController = getMediaDataController();
                mediaDataController.clearAllDrafts(false);
                mediaDataController.loadDraftsIfNeed();

                putUsers(dialogsRes.users, false);
                putChats(dialogsRes.chats, false);

                for (int a = 0; a < allDialogs.size(); a++) {
                    TLRPC.Dialog oldDialog = allDialogs.get(a);
                    if (!DialogObject.isEncryptedDialog(oldDialog.id)) {
                        dialogs_dict.remove(oldDialog.id);
                        ArrayList<MessageObject> messages = dialogMessage.get(oldDialog.id);
                        dialogMessage.remove(oldDialog.id);
                        if (messages != null) {
                            for (int i = 0; i < messages.size(); ++i) {
                                MessageObject message = messages.get(i);
                                if (message != null) {
                                    if (message.messageOwner.peer_id.channel_id == 0) {
                                        dialogMessagesByIds.remove(message.getId());
                                    }
                                    if (message.messageOwner.random_id != 0) {
                                        dialogMessagesByRandomIds.remove(message.messageOwner.random_id);
                                    }
                                }
                            }
                        }
                    }
                }

                for (int a = 0; a < new_dialogs_dict.size(); a++) {
                    long key = new_dialogs_dict.keyAt(a);
                    TLRPC.Dialog value = new_dialogs_dict.valueAt(a);
                    if (value.draft instanceof TLRPC.TL_draftMessage) {
                        mediaDataController.saveDraft(value.id, 0, value.draft, null, false);
                    }
                    dialogs_dict.put(key, value);
                    ArrayList<MessageObject> messageObjects = new_dialogMessage.get(value.id);
                    dialogMessage.put(key, messageObjects);
                    if (messageObjects != null) {
                        for (int i = 0; i < messageObjects.size(); ++i) {
                            MessageObject messageObject = messageObjects.get(i);
                            if (messageObject != null && messageObject.messageOwner.peer_id.channel_id == 0) {
                                dialogMessagesByIds.put(messageObject.getId(), messageObject);
                                dialogsLoadedTillDate = Math.min(dialogsLoadedTillDate, messageObject.messageOwner.date);
                                if (messageObject.messageOwner.random_id != 0) {
                                    dialogMessagesByRandomIds.put(messageObject.messageOwner.random_id, messageObject);
                                }
                            }
                        }
                    }
                    getTranslateController().checkDialogMessage(key);
                }

                allDialogs.clear();
                for (int a = 0, size = dialogs_dict.size(); a < size; a++) {
                    TLRPC.Dialog dialog = dialogs_dict.valueAt(a);
                    if (deletingDialogs.indexOfKey(dialog.id) >= 0) {
                        continue;
                    }
                    allDialogs.add(dialog);
                }
                sortDialogs(null);
                dialogsEndReached.put(0, true);
                serverDialogsEndReached.put(0, false);

                dialogsEndReached.put(1, true);
                serverDialogsEndReached.put(1, false);

                int totalDialogsLoadCount = getUserConfig().getTotalDialogsCount(0);
                long[] dialogsLoadOffset = getUserConfig().getDialogLoadOffsets(0);
                if (totalDialogsLoadCount < 400 && dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetId] != -1 && dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetId] != Integer.MAX_VALUE) {
                    loadDialogs(0, 0, 100, false);
                }
                getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
            });
        });
    }

    private void migrateDialogs(int offset, int offsetDate, long offsetUser, long offsetChat, long offsetChannel, long accessPeer) {
        if (migratingDialogs || offset == -1) {
            return;
        }
        migratingDialogs = true;

        TLRPC.TL_messages_getDialogs req = new TLRPC.TL_messages_getDialogs();
        req.exclude_pinned = true;
        req.limit = 100;
        req.offset_id = offset;
        req.offset_date = offsetDate;
        if (BuildVars.LOGS_ENABLED) {
            FileLog.d("start migrate with id " + offset + " date " + LocaleController.getInstance().getFormatterStats().format((long) offsetDate * 1000));
        }
        if (offset == 0) {
            req.offset_peer = new TLRPC.TL_inputPeerEmpty();
        } else {
            if (offsetChannel != 0) {
                req.offset_peer = new TLRPC.TL_inputPeerChannel();
                req.offset_peer.channel_id = offsetChannel;
            } else if (offsetUser != 0) {
                req.offset_peer = new TLRPC.TL_inputPeerUser();
                req.offset_peer.user_id = offsetUser;
            } else {
                req.offset_peer = new TLRPC.TL_inputPeerChat();
                req.offset_peer.chat_id = offsetChat;
            }
            req.offset_peer.access_hash = accessPeer;
        }
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error == null) {
                TLRPC.messages_Dialogs dialogsRes = (TLRPC.messages_Dialogs) response;
                getMessagesStorage().getStorageQueue().postRunnable(() -> {
                    try {
                        int offsetId;
                        int totalDialogsLoadCount = getUserConfig().getTotalDialogsCount(0);
                        getUserConfig().setTotalDialogsCount(0, totalDialogsLoadCount + dialogsRes.dialogs.size());
                        TLRPC.Message lastMessage = null;
                        for (int a = 0; a < dialogsRes.messages.size(); a++) {
                            TLRPC.Message message = dialogsRes.messages.get(a);
                            if (BuildVars.LOGS_ENABLED) {
                                FileLog.d("search migrate id " + message.id + " date " + LocaleController.getInstance().getFormatterStats().format((long) message.date * 1000));
                            }
                            if (lastMessage == null || message.date < lastMessage.date) {
                                lastMessage = message;
                            }
                        }
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("migrate step with id " + lastMessage.id + " date " + LocaleController.getInstance().getFormatterStats().format((long) lastMessage.date * 1000));
                        }
                        if (dialogsRes.dialogs.size() >= 100) {
                            offsetId = lastMessage.id;
                        } else {
                            if (BuildVars.LOGS_ENABLED) {
                                FileLog.d("migrate stop due to not 100 dialogs");
                            }
                            for (int i = 0; i < 2; i++) {
                                getUserConfig().setDialogsLoadOffset(i,
                                        Integer.MAX_VALUE,
                                        getUserConfig().migrateOffsetDate,
                                        getUserConfig().migrateOffsetUserId,
                                        getUserConfig().migrateOffsetChatId,
                                        getUserConfig().migrateOffsetChannelId,
                                        getUserConfig().migrateOffsetAccess);
                            }
                            offsetId = -1;
                        }

                        StringBuilder dids = new StringBuilder(dialogsRes.dialogs.size() * 12);
                        LongSparseArray<TLRPC.Dialog> dialogHashMap = new LongSparseArray<>();
                        for (int a = 0; a < dialogsRes.dialogs.size(); a++) {
                            TLRPC.Dialog dialog = dialogsRes.dialogs.get(a);
                            DialogObject.initDialog(dialog);
                            if (dids.length() > 0) {
                                dids.append(",");
                            }
                            dids.append(dialog.id);
                            dialogHashMap.put(dialog.id, dialog);
                        }
                        SQLiteCursor cursor = getMessagesStorage().getDatabase().queryFinalized(String.format(Locale.US, "SELECT did, folder_id FROM dialogs WHERE did IN (%s)", dids.toString()));
                        while (cursor.next()) {
                            long did = cursor.longValue(0);
                            int folder_id = cursor.intValue(1);
                            TLRPC.Dialog dialog = dialogHashMap.get(did);
                            if (dialog != null) {
                                if (dialog.folder_id != folder_id) {
                                    continue;
                                }
                                dialogsRes.dialogs.remove(dialog);
                                for (int a = 0; a < dialogsRes.messages.size(); a++) {
                                    TLRPC.Message message = dialogsRes.messages.get(a);
                                    if (MessageObject.getDialogId(message) != did) {
                                        continue;
                                    }
                                    dialogsRes.messages.remove(a);
                                    a--;
                                    if (message.id == dialog.top_message) {
                                        dialog.top_message = 0;
                                        break;
                                    }
                                }
                            }
                            dialogHashMap.remove(did);
                        }
                        cursor.dispose();
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("migrate found missing dialogs " + dialogsRes.dialogs.size());
                        }
                        cursor = getMessagesStorage().getDatabase().queryFinalized("SELECT min(date) FROM dialogs WHERE date != 0 AND did >> 32 NOT IN (536870912, 1073741824)");
                        if (cursor.next()) {
                            int date = Math.max(1441062000, cursor.intValue(0));
                            for (int a = 0; a < dialogsRes.messages.size(); a++) {
                                TLRPC.Message message = dialogsRes.messages.get(a);
                                if (message.date < date) {
                                    if (offset != -1) {
                                        for (int i = 0; i < 2; i++) {
                                            getUserConfig().setDialogsLoadOffset(i,
                                                    getUserConfig().migrateOffsetId,
                                                    getUserConfig().migrateOffsetDate,
                                                    getUserConfig().migrateOffsetUserId,
                                                    getUserConfig().migrateOffsetChatId,
                                                    getUserConfig().migrateOffsetChannelId,
                                                    getUserConfig().migrateOffsetAccess);
                                        }
                                        offsetId = -1;
                                        if (BuildVars.LOGS_ENABLED) {
                                            FileLog.d("migrate stop due to reached loaded dialogs " + LocaleController.getInstance().getFormatterStats().format((long) date * 1000));
                                        }
                                    }
                                    dialogsRes.messages.remove(a);
                                    a--;
                                    long did = MessageObject.getDialogId(message);
                                    TLRPC.Dialog dialog = dialogHashMap.get(did);
                                    dialogHashMap.remove(did);
                                    if (dialog != null) {
                                        dialogsRes.dialogs.remove(dialog);
                                    }
                                }
                            }
                            if (lastMessage != null && lastMessage.date < date && offset != -1) {
                                for (int i = 0; i < 2; i++) {
                                    getUserConfig().setDialogsLoadOffset(i,
                                            getUserConfig().migrateOffsetId,
                                            getUserConfig().migrateOffsetDate,
                                            getUserConfig().migrateOffsetUserId,
                                            getUserConfig().migrateOffsetChatId,
                                            getUserConfig().migrateOffsetChannelId,
                                            getUserConfig().migrateOffsetAccess);
                                }
                                offsetId = -1;
                                if (BuildVars.LOGS_ENABLED) {
                                    FileLog.d("migrate stop due to reached loaded dialogs " + LocaleController.getInstance().getFormatterStats().format((long) date * 1000));
                                }
                            }
                        }
                        cursor.dispose();

                        getUserConfig().migrateOffsetDate = lastMessage.date;
                        if (lastMessage.peer_id.channel_id != 0) {
                            getUserConfig().migrateOffsetChannelId = lastMessage.peer_id.channel_id;
                            getUserConfig().migrateOffsetChatId = 0;
                            getUserConfig().migrateOffsetUserId = 0;
                            for (int a = 0; a < dialogsRes.chats.size(); a++) {
                                TLRPC.Chat chat = dialogsRes.chats.get(a);
                                if (chat.id == getUserConfig().migrateOffsetChannelId) {
                                    getUserConfig().migrateOffsetAccess = chat.access_hash;
                                    break;
                                }
                            }
                        } else if (lastMessage.peer_id.chat_id != 0) {
                            getUserConfig().migrateOffsetChatId = lastMessage.peer_id.chat_id;
                            getUserConfig().migrateOffsetChannelId = 0;
                            getUserConfig().migrateOffsetUserId = 0;
                            for (int a = 0; a < dialogsRes.chats.size(); a++) {
                                TLRPC.Chat chat = dialogsRes.chats.get(a);
                                if (chat.id == getUserConfig().migrateOffsetChatId) {
                                    getUserConfig().migrateOffsetAccess = chat.access_hash;
                                    break;
                                }
                            }
                        } else if (lastMessage.peer_id.user_id != 0) {
                            getUserConfig().migrateOffsetUserId = lastMessage.peer_id.user_id;
                            getUserConfig().migrateOffsetChatId = 0;
                            getUserConfig().migrateOffsetChannelId = 0;
                            for (int a = 0; a < dialogsRes.users.size(); a++) {
                                TLRPC.User user = dialogsRes.users.get(a);
                                if (user.id == getUserConfig().migrateOffsetUserId) {
                                    getUserConfig().migrateOffsetAccess = user.access_hash;
                                    break;
                                }
                            }
                        }

                        processLoadedDialogs(dialogsRes, null, null, 0, offsetId, 0, 0, false, true, false);
                    } catch (Exception e) {
                        FileLog.e(e);
                        AndroidUtilities.runOnUIThread(() -> migratingDialogs = false);
                    }
                });
            } else {
                AndroidUtilities.runOnUIThread(() -> migratingDialogs = false);
            }
        });
    }

    private int DIALOGS_LOAD_TYPE_CACHE = 1;
    private int DIALOGS_LOAD_TYPE_CHANNEL = 2;
    private int DIALOGS_LOAD_TYPE_UNKNOWN = 3;

    public void processLoadedDialogs(final TLRPC.messages_Dialogs dialogsRes, ArrayList<TLRPC.EncryptedChat> encChats, ArrayList<TLRPC.UserFull> fullUsers, int folderId, int offset, int count, int loadType, boolean resetEnd, boolean migrate, boolean fromCache) {
        Utilities.stageQueue.postRunnable(() -> {
            if (!firstGettingTask) {
                getNewDeleteTask(null, null);
                firstGettingTask = true;
            }

            if (BuildVars.LOGS_ENABLED) {
                FileLog.d("loaded folderId " + folderId + " loadType " + loadType + " count " + dialogsRes.dialogs.size());
            }
            long[] dialogsLoadOffset = getUserConfig().getDialogLoadOffsets(folderId);
            if (loadType == DIALOGS_LOAD_TYPE_CACHE && dialogsRes.dialogs.size() == 0) {
                AndroidUtilities.runOnUIThread(() -> {
                    putUsers(dialogsRes.users, true);
                    if (fullUsers != null) {
                        for (int i = 0; i < fullUsers.size(); i++) {
                            long did = fullUsers.get(i).id;
                            this.fullUsers.put(did, fullUsers.get(i));
                            getTranslateController().updateDialogFull(did);
                        }
                    }
                    loadingDialogs.put(folderId, false);
                    if (resetEnd) {
                        dialogsEndReached.put(folderId, false);
                        serverDialogsEndReached.put(folderId, false);
                    } else if (dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetId] == Integer.MAX_VALUE) {
                        dialogsEndReached.put(folderId, true);
                        serverDialogsEndReached.put(folderId, true);
                    } else {
                        loadDialogs(folderId, 0, count, false);
                    }
                    getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                });
                return;
            }

            LongSparseArray<TLRPC.Dialog> new_dialogs_dict = new LongSparseArray<>();
            SparseArray<TLRPC.EncryptedChat> enc_chats_dict;
            LongSparseArray<ArrayList<MessageObject>> new_dialogMessage = new LongSparseArray<>();
            LongSparseArray<TLRPC.User> usersDict = new LongSparseArray<>();
            LongSparseArray<TLRPC.Chat> chatsDict = new LongSparseArray<>();

            for (int a = 0; a < dialogsRes.users.size(); a++) {
                TLRPC.User u = dialogsRes.users.get(a);
                usersDict.put(u.id, u);
            }
            for (int a = 0; a < dialogsRes.chats.size(); a++) {
                TLRPC.Chat c = dialogsRes.chats.get(a);
                chatsDict.put(c.id, c);
            }
            if (encChats != null) {
                enc_chats_dict = new SparseArray<>();
                for (int a = 0, N = encChats.size(); a < N; a++) {
                    TLRPC.EncryptedChat encryptedChat = encChats.get(a);
                    enc_chats_dict.put(encryptedChat.id, encryptedChat);
                }
            } else {
                enc_chats_dict = null;
            }
            if (loadType == DIALOGS_LOAD_TYPE_CACHE) {
                nextDialogsCacheOffset.put(folderId, offset + count);
            }

            TLRPC.Message lastMessage = null;
            ArrayList<MessageObject> newMessages = new ArrayList<>();
            for (int a = 0; a < dialogsRes.messages.size(); a++) {
                TLRPC.Message message = dialogsRes.messages.get(a);
                if (message.date == 0) {
                    continue;
                }
                if (lastMessage == null || message.date < lastMessage.date) {
                    lastMessage = message;
                }
                if (message.peer_id.channel_id != 0) {
                    TLRPC.Chat chat = chatsDict.get(message.peer_id.channel_id);
                    if (chat != null && chat.left && (promoDialogId == 0 || promoDialogId != -chat.id)) {
                        continue;
                    }
                } else if (message.peer_id.chat_id != 0) {
                    TLRPC.Chat chat = chatsDict.get(message.peer_id.chat_id);
                    if (chat != null && chat.migrated_to != null) {
                        continue;
                    }
                }
                MessageObject messageObject = new MessageObject(currentAccount, message, usersDict, chatsDict, false, false);
                newMessages.add(messageObject);
                long did = messageObject.getDialogId();
                ArrayList<MessageObject> arrayList = new_dialogMessage.get(did);
                if (arrayList == null) {
                    arrayList = new ArrayList<MessageObject>(1);
                }
                arrayList.add(messageObject);
                new_dialogMessage.put(did, arrayList);
            }
            if (!fromCache && !migrate && dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetId] != -1 && loadType == 0) {
                int totalDialogsLoadCount = getUserConfig().getTotalDialogsCount(folderId);
                int dialogsLoadOffsetId;
                int dialogsLoadOffsetDate = 0;
                long dialogsLoadOffsetChannelId = 0;
                long dialogsLoadOffsetChatId = 0;
                long dialogsLoadOffsetUserId = 0;
                long dialogsLoadOffsetAccess = 0;
                if (lastMessage != null && lastMessage.id != dialogsLoadOffset[UserConfig.i_dialogsLoadOffsetId]) {
                    totalDialogsLoadCount += dialogsRes.dialogs.size();
                    dialogsLoadOffsetId = lastMessage.id;
                    dialogsLoadOffsetDate = lastMessage.date;
                    if (lastMessage.peer_id.channel_id != 0) {
                        dialogsLoadOffsetChannelId = lastMessage.peer_id.channel_id;
                        dialogsLoadOffsetChatId = 0;
                        dialogsLoadOffsetUserId = 0;
                        for (int a = 0; a < dialogsRes.chats.size(); a++) {
                            TLRPC.Chat chat = dialogsRes.chats.get(a);
                            if (chat.id == dialogsLoadOffsetChannelId) {
                                dialogsLoadOffsetAccess = chat.access_hash;
                                break;
                            }
                        }
                    } else if (lastMessage.peer_id.chat_id != 0) {
                        dialogsLoadOffsetChatId = lastMessage.peer_id.chat_id;
                        dialogsLoadOffsetChannelId = 0;
                        dialogsLoadOffsetUserId = 0;
                        for (int a = 0; a < dialogsRes.chats.size(); a++) {
                            TLRPC.Chat chat = dialogsRes.chats.get(a);
                            if (chat.id == dialogsLoadOffsetChatId) {
                                dialogsLoadOffsetAccess = chat.access_hash;
                                break;
                            }
                        }
                    } else if (lastMessage.peer_id.user_id != 0) {
                        dialogsLoadOffsetUserId = lastMessage.peer_id.user_id;
                        dialogsLoadOffsetChatId = 0;
                        dialogsLoadOffsetChannelId = 0;
                        for (int a = 0; a < dialogsRes.users.size(); a++) {
                            TLRPC.User user = dialogsRes.users.get(a);
                            if (user.id == dialogsLoadOffsetUserId) {
                                dialogsLoadOffsetAccess = user.access_hash;
                                break;
                            }
                        }
                    }
                } else {
                    dialogsLoadOffsetId = Integer.MAX_VALUE;
                }
                getUserConfig().setDialogsLoadOffset(folderId,
                        dialogsLoadOffsetId,
                        dialogsLoadOffsetDate,
                        dialogsLoadOffsetUserId,
                        dialogsLoadOffsetChatId,
                        dialogsLoadOffsetChannelId,
                        dialogsLoadOffsetAccess);
                getUserConfig().setTotalDialogsCount(folderId, totalDialogsLoadCount);
                getUserConfig().saveConfig(false);
            }

            ArrayList<TLRPC.Dialog> dialogsToReload = new ArrayList<>();
            for (int a = 0; a < dialogsRes.dialogs.size(); a++) {
                TLRPC.Dialog d = dialogsRes.dialogs.get(a);
                DialogObject.initDialog(d);
                if (d.id == 0) {
                    continue;
                }
                if (DialogObject.isEncryptedDialog(d.id) && enc_chats_dict != null) {
                    if (enc_chats_dict.get(DialogObject.getEncryptedChatId(d.id)) == null) {
                        continue;
                    }
                }
                if (promoDialogId != 0 && promoDialogId == d.id) {
                    promoDialog = d;
                }
                if (d.last_message_date == 0) {
                    ArrayList<MessageObject> messages = new_dialogMessage.get(d.id);
                    if (messages != null) {
                        int maxDate = Integer.MIN_VALUE;
                        for (int i = 0; i < messages.size(); ++i) {
                            MessageObject msg = messages.get(i);
                            if (msg != null && msg.messageOwner != null && msg.messageOwner.date > maxDate) {
                                maxDate = msg.messageOwner.date;
                            }
                        }
                        if (maxDate > Integer.MIN_VALUE) {
                            d.last_message_date = maxDate;
                        }

                    }
                }
                boolean allowCheck = true;
                if (DialogObject.isChannel(d)) {
                    TLRPC.Chat chat = chatsDict.get(-d.id);
                    if (chat != null) {
                        if (!chat.megagroup) {
                            allowCheck = false;
                        }
                        if (ChatObject.isNotInChat(chat) && (promoDialogId == 0 || promoDialogId != d.id)) {
                            continue;
                        }
                    }
                    channelsPts.put(-d.id, d.pts);
                } else if (DialogObject.isChatDialog(d.id)) {
                    TLRPC.Chat chat = chatsDict.get(-d.id);
                    if (chat != null && (chat.migrated_to != null || ChatObject.isNotInChat(chat))) {
                        continue;
                    }
                }
                new_dialogs_dict.put(d.id, d);

                if (allowCheck && loadType == DIALOGS_LOAD_TYPE_CACHE && (d.read_outbox_max_id == 0 || d.read_inbox_max_id == 0) && d.top_message != 0) {
                    dialogsToReload.add(d);
                }

                Integer value = dialogs_read_inbox_max.get(d.id);
                if (value == null) {
                    value = 0;
                }
                dialogs_read_inbox_max.put(d.id, Math.max(value, d.read_inbox_max_id));

                value = dialogs_read_outbox_max.get(d.id);
                if (value == null) {
                    value = 0;
                }
                dialogs_read_outbox_max.put(d.id, Math.max(value, d.read_outbox_max_id));
            }

            if (loadType != DIALOGS_LOAD_TYPE_CACHE) {
                ImageLoader.saveMessagesThumbs(dialogsRes.messages);

                for (int a = 0; a < dialogsRes.messages.size(); a++) {
                    TLRPC.Message message = dialogsRes.messages.get(a);
                    if (message.action instanceof TLRPC.TL_messageActionChatDeleteUser) {
                        TLRPC.User user = usersDict.get(message.action.user_id);
                        if (user != null && user.bot) {
                            message.reply_markup = new TLRPC.TL_replyKeyboardHide();
                            message.flags |= 64;
                        }
                    }

                    if (message.action instanceof TLRPC.TL_messageActionChatMigrateTo || message.action instanceof TLRPC.TL_messageActionChannelCreate) {
                        message.unread = false;
                        message.media_unread = false;
                    } else {
                        ConcurrentHashMap<Long, Integer> read_max = message.out ? dialogs_read_outbox_max : dialogs_read_inbox_max;
                        Integer value = read_max.get(message.dialog_id);
                        if (value == null) {
                            value = getMessagesStorage().getDialogReadMax(message.out, message.dialog_id);
                            read_max.put(message.dialog_id, value);
                        }
                        message.unread = value < message.id;
                    }
                }
                getMessagesStorage().putDialogs(dialogsRes, loadType == DIALOGS_LOAD_TYPE_UNKNOWN ? 3 : 0);
            }
            if (loadType == DIALOGS_LOAD_TYPE_CHANNEL) {
                TLRPC.Chat chat = dialogsRes.chats.get(0);
                getChannelDifference(chat.id);
                AndroidUtilities.runOnUIThread(() -> checkChatInviter(chat.id, true));
            }

            TLRPC.Message lastMessageFinal = lastMessage;
            AndroidUtilities.runOnUIThread(() -> {
                if (lastMessageFinal != null) {
                    dialogsLoadedTillDate = Math.min(dialogsLoadedTillDate, lastMessageFinal.date);
                } else {
                    dialogsLoadedTillDate = Integer.MIN_VALUE;
                }
                if (loadType != DIALOGS_LOAD_TYPE_CACHE) {
                    applyDialogsNotificationsSettings(dialogsRes.dialogs);
                    getMediaDataController().loadDraftsIfNeed();
                }
                putUsers(dialogsRes.users, loadType == DIALOGS_LOAD_TYPE_CACHE);
                putChats(dialogsRes.chats, loadType == DIALOGS_LOAD_TYPE_CACHE);
                if (fullUsers != null) {
                    for (int i = 0; i < fullUsers.size(); i++) {
                        long did = fullUsers.get(i).id;
                        this.fullUsers.put(did, fullUsers.get(i));
                        getTranslateController().updateDialogFull(did);
                    }
                }

                if (encChats != null) {
                    for (int a = 0; a < encChats.size(); a++) {
                        TLRPC.EncryptedChat encryptedChat = encChats.get(a);
                        if (encryptedChat instanceof TLRPC.TL_encryptedChat && AndroidUtilities.getMyLayerVersion(encryptedChat.layer) < SecretChatHelper.CURRENT_SECRET_CHAT_LAYER) {
                            getSecretChatHelper().sendNotifyLayerMessage(encryptedChat, null);
                        }
                        putEncryptedChat(encryptedChat, true);
                    }
                }
                if (!migrate && loadType != DIALOGS_LOAD_TYPE_UNKNOWN && loadType != DIALOGS_LOAD_TYPE_CHANNEL) {
                    loadingDialogs.put(folderId, false);
                }
                boolean added = false;
                dialogsLoaded = true;

                int archivedDialogsCount = 0;
                int lastDialogDate = migrate && !allDialogs.isEmpty() ? allDialogs.get(allDialogs.size() - 1).last_message_date : 0;
                for (int a = 0; a < new_dialogs_dict.size(); a++) {
                    long key = new_dialogs_dict.keyAt(a);
                    TLRPC.Dialog value = new_dialogs_dict.valueAt(a);
                    TLRPC.Dialog currentDialog = dialogs_dict.get(key);
                    if (migrate && currentDialog != null) {
                        currentDialog.folder_id = value.folder_id;
                    }
                    if (migrate && lastDialogDate != 0 && value.last_message_date < lastDialogDate) {
                        continue;
                    }
                    if (loadType != DIALOGS_LOAD_TYPE_CACHE && value.draft instanceof TLRPC.TL_draftMessage) {
                        getMediaDataController().saveDraft(value.id, 0, value.draft, null, false);
                    }
                    if (value.folder_id != folderId) {
                        archivedDialogsCount++;
                    }
                    ArrayList<MessageObject> newMsgs = new_dialogMessage.get(value.id);
                    if (currentDialog == null) {
                        added = true;
                        dialogs_dict.put(key, value);
                        dialogMessage.put(key, newMsgs);
                        if (newMsgs != null) {
                            for (int i = 0; i < newMsgs.size(); ++i) {
                                MessageObject newMsg = newMsgs.get(i);
                                if (newMsg != null && newMsg.messageOwner.peer_id.channel_id == 0) {
                                    dialogMessagesByIds.put(newMsg.getId(), newMsg);
                                    if (newMsg.messageOwner.random_id != 0) {
                                        dialogMessagesByRandomIds.put(newMsg.messageOwner.random_id, newMsg);
                                    }
                                }
                            }
                        }
                        if (getTranslateController().isFeatureAvailable(key)) {
                            getTranslateController().checkDialogMessageSure(key);
                        }
                    } else {
                        if (loadType != DIALOGS_LOAD_TYPE_CACHE) {
                            currentDialog.notify_settings = value.notify_settings;
                        }
                        currentDialog.pinned = value.pinned;
                        currentDialog.pinnedNum = value.pinnedNum;
                        ArrayList<MessageObject> oldMsgs = dialogMessage.get(key);

                        boolean oldMsgsDeleted = false;
                        for (int i = 0; oldMsgs != null && i < oldMsgs.size(); ++i) {
                            if (oldMsgs.get(i) != null && oldMsgs.get(i).deleted) {
                                oldMsgsDeleted = true;
                                break;
                            }
                        }
                        if (oldMsgsDeleted || oldMsgs == null || currentDialog.top_message > 0) {
                            if (value.top_message >= currentDialog.top_message || (oldMsgs == null) != (newMsgs == null) || oldMsgs != null && newMsgs != null && oldMsgs.size() != newMsgs.size()) {
                                dialogs_dict.put(key, value);
                                dialogMessage.put(key, newMsgs);
                                if (oldMsgs != null) {
                                    for (int i = 0; i < oldMsgs.size(); ++i) {
                                        MessageObject oldMsg = oldMsgs.get(i);
                                        if (oldMsg == null) {
                                            continue;
                                        }
                                        if (oldMsg.messageOwner.peer_id.channel_id == 0) {
                                            dialogMessagesByIds.remove(oldMsg.getId());
                                        }
                                        if (oldMsg.messageOwner.random_id != 0) {
                                            dialogMessagesByRandomIds.remove(oldMsg.messageOwner.random_id);
                                        }
                                    }
                                }
                                if (newMsgs != null) {
                                    for (int i = 0; i < newMsgs.size(); ++i) {
                                        MessageObject newMsg = newMsgs.get(i);
                                        if (newMsg != null && newMsg.messageOwner.peer_id.channel_id == 0) {
                                            for (int j = 0; oldMsgs != null && j < oldMsgs.size(); ++j) {
                                                MessageObject oldMsg = oldMsgs.get(j);
                                                if (oldMsg != null && oldMsg.getId() == newMsg.getId()) {
                                                    newMsg.deleted = oldMsg.deleted;
                                                    break;
                                                }
                                            }
                                            dialogMessagesByIds.put(newMsg.getId(), newMsg);
                                            if (newMsg.messageOwner.random_id != 0) {
                                                dialogMessagesByRandomIds.put(newMsg.messageOwner.random_id, newMsg);
                                            }
                                        }
                                    }
                                }
                                if (getTranslateController().isFeatureAvailable(key)) {
                                    getTranslateController().checkDialogMessageSure(key);
                                }
                            }
                        } else {
//                            if (newMsg == null && oldMs.getId() > 0 || newMsg != null && newMsg.messageOwner.date > oldMsg.messageOwner.date)
                            dialogs_dict.put(key, value);
                            dialogMessage.put(key, newMsgs);
                            if (oldMsgs != null) {
                                for (int i = 0; i < oldMsgs.size(); ++i) {
                                    MessageObject oldMsg = oldMsgs.get(i);
                                    if (oldMsg == null) {
                                        continue;
                                    }
                                    if (oldMsg.messageOwner.peer_id.channel_id == 0) {
                                        dialogMessagesByIds.remove(oldMsg.getId());
                                    }
                                    if (oldMsg.messageOwner.random_id != 0) {
                                        dialogMessagesByRandomIds.remove(oldMsg.messageOwner.random_id);
                                    }
                                }
                            }
                            if (newMsgs != null) {
                                for (int i = 0; i < newMsgs.size(); ++i) {
                                    MessageObject newMsg = newMsgs.get(i);
                                    if (newMsg != null && newMsg.messageOwner.peer_id.channel_id == 0) {
                                        for (int j = 0; oldMsgs != null && j < oldMsgs.size(); ++j) {
                                            MessageObject oldMsg = oldMsgs.get(j);
                                            if (oldMsg != null && oldMsg.getId() == newMsg.getId()) {
                                                newMsg.deleted = oldMsg.deleted;
                                                break;
                                            }
                                        }
                                        dialogMessagesByIds.put(newMsg.getId(), newMsg);
                                        if (newMsg.messageOwner.random_id != 0) {
                                            dialogMessagesByRandomIds.put(newMsg.messageOwner.random_id, newMsg);
                                        }
                                    }
                                }
                            }
                            if (getTranslateController().isFeatureAvailable(key)) {
                                getTranslateController().checkDialogMessageSure(key);
                            }
                        }
                    }
                }

                allDialogs.clear();
                for (int a = 0, size = dialogs_dict.size(); a < size; a++) {
                    TLRPC.Dialog dialog = dialogs_dict.valueAt(a);
                    if (deletingDialogs.indexOfKey(dialog.id) >= 0) {
                        continue;
                    }
                    allDialogs.add(dialog);
                }
                sortDialogs(migrate ? chatsDict : null);

                putAllNeededDraftDialogs();

                if (loadType != DIALOGS_LOAD_TYPE_CHANNEL && loadType != DIALOGS_LOAD_TYPE_UNKNOWN) {
                    if (!migrate) {
                        dialogsEndReached.put(folderId, (dialogsRes.dialogs.size() == 0 || dialogsRes.dialogs.size() != count) && loadType == 0);
                        if (archivedDialogsCount > 0 && archivedDialogsCount < 20 && folderId == 0) {
                            dialogsEndReached.put(1, true);
                            long[] dialogsLoadOffsetArchived = getUserConfig().getDialogLoadOffsets(folderId);
                            if (dialogsLoadOffsetArchived[UserConfig.i_dialogsLoadOffsetId] == Integer.MAX_VALUE) {
                                serverDialogsEndReached.put(1, true);
                            }
                        }
                        if (!fromCache) {
                            serverDialogsEndReached.put(folderId, (dialogsRes.dialogs.size() == 0 || dialogsRes.dialogs.size() != count) && loadType == 0);
                        }
                    }
                }
                int totalDialogsLoadCount = getUserConfig().getTotalDialogsCount(folderId);
                long[] dialogsLoadOffset2 = getUserConfig().getDialogLoadOffsets(folderId);
                if (!fromCache && !migrate && totalDialogsLoadCount < 400 && dialogsLoadOffset2[UserConfig.i_dialogsLoadOffsetId] != -1 && dialogsLoadOffset2[UserConfig.i_dialogsLoadOffsetId] != Integer.MAX_VALUE) {
                    loadDialogs(folderId, 0, 100, false);
                }
                getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);

                if (migrate) {
                    getUserConfig().migrateOffsetId = offset;
                    getUserConfig().saveConfig(false);
                    migratingDialogs = false;
                    getNotificationCenter().postNotificationName(NotificationCenter.needReloadRecentDialogsSearch);
                } else {
                    if (!added && loadType == DIALOGS_LOAD_TYPE_CACHE && dialogsEndReached.get(folderId)) {
                        loadDialogs(folderId, 0, count, false);
                    }
                }
                migrateDialogs(getUserConfig().migrateOffsetId, getUserConfig().migrateOffsetDate, getUserConfig().migrateOffsetUserId, getUserConfig().migrateOffsetChatId, getUserConfig().migrateOffsetChannelId, getUserConfig().migrateOffsetAccess);
                if (!dialogsToReload.isEmpty()) {
                    reloadDialogsReadValue(dialogsToReload, 0);
                }
                loadUnreadDialogs();
                if (dialogsRes.dialogs != null) {
                    for (int i = 0; i < dialogsRes.dialogs.size(); i++) {
                        final long dialogId = dialogsRes.dialogs.get(i).id;
                        if (isForum(dialogId) || isMonoForumWithManageRights(dialogId)) {
                            topicsController.preloadTopics(-dialogId);
                        }
                    }
                }
            });
        });
    }

    private void applyDialogNotificationsSettings(long dialogId, long topicId, TLRPC.PeerNotifySettings notify_settings) {
        getNotificationsController().getNotificationsSettingsFacade().applyDialogNotificationsSettings(dialogId, topicId, notify_settings);
        sortDialogs(null);
    }

    private void applyDialogsNotificationsSettings(ArrayList<TLRPC.Dialog> dialogs) {
        SharedPreferences.Editor editor = getNotificationsSettings(currentAccount).edit();
        for (int a = 0; a < dialogs.size(); a++) {
            TLRPC.Dialog dialog = dialogs.get(a);
            if (dialog.peer != null && dialog.notify_settings instanceof TLRPC.TL_peerNotifySettings) {
                getNotificationsController().getNotificationsSettingsFacade().setSettingsForDialog(editor, dialog, dialog.notify_settings);
            }
        }
        editor.apply();
        sortDialogs(null);
    }

    public void reloadMentionsCountForChannel(TLRPC.InputPeer peer, long taskId) {
        long newTaskId;
        if (taskId == 0) {
            NativeByteBuffer data = null;
            try {
                data = new NativeByteBuffer(4 + peer.getObjectSize());
                data.writeInt32(22);
                peer.serializeToStream(data);
            } catch (Exception e) {
                FileLog.e(e);
            }
            newTaskId = getMessagesStorage().createPendingTask(data);
        } else {
            newTaskId = taskId;
        }
        TLRPC.TL_messages_getUnreadMentions req = new TLRPC.TL_messages_getUnreadMentions();
        req.peer = peer;
        req.limit = 1;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            TLRPC.messages_Messages res = (TLRPC.messages_Messages) response;
            if (res != null) {
                int newCount;
                if (res.count != 0) {
                    newCount = res.count;
                } else {
                    newCount = res.messages.size();
                }
                getMessagesStorage().resetMentionsCount(-peer.channel_id, 0, newCount);
            }
            if (newTaskId != 0) {
                getMessagesStorage().removePendingTask(newTaskId);
            }
        });
    }

    public void reloadMentionsCountForChannels(final ArrayList<Long> arrayList) {
        AndroidUtilities.runOnUIThread(() -> {
            for (int a = 0; a < arrayList.size(); a++) {
                long dialogId = -arrayList.get(a);
                reloadMentionsCountForChannel(getInputPeer(dialogId), 0);
            }
        });
    }

    public void processDialogsUpdateRead(final LongSparseIntArray dialogsToUpdate, LongSparseIntArray dialogsMentionsToUpdate) {
        AndroidUtilities.runOnUIThread(() -> {
            boolean filterDialogsChanged = false;
            if (dialogsToUpdate != null) {
                for (int a = 0; a < dialogsToUpdate.size(); a++) {
                    long dialogId = dialogsToUpdate.keyAt(a);
                    TLRPC.Dialog currentDialog = dialogs_dict.get(dialogId);
                    if (currentDialog == null) {
                        for (int i = 0; i < allDialogs.size(); i++) {
                            if (allDialogs.get(i).id == dialogId) {
                                dialogs_dict.put(dialogId, allDialogs.get(i));
                                currentDialog = allDialogs.get(i);
                                break;
                            }
                        }
                    }
                    if (currentDialog == null) {
                        if (BuildVars.DEBUG_PRIVATE_VERSION) {
                            FileLog.d("can't update dialog " + dialogId + " with new unread " + dialogsToUpdate.valueAt(a));
                        }
                        pendingUnreadCounter.put(dialogId, dialogsToUpdate.valueAt(a));
                    }
                    if (currentDialog != null) {
                        int prevCount = currentDialog.unread_count;
                        currentDialog.unread_count = dialogsToUpdate.valueAt(a);
                        if (BuildVars.DEBUG_PRIVATE_VERSION) {
                            FileLog.d("update dialog " + dialogId + " with new unread " + currentDialog.unread_count);
                        }
                        if (prevCount != 0 && currentDialog.unread_count == 0) {
                            if (!isDialogMuted(dialogId, 0)) {
                                unreadUnmutedDialogs--;
                            }
                            if (!filterDialogsChanged) {
                                for (int b = 0; b < selectedDialogFilter.length; b++) {
                                    if (selectedDialogFilter[b] != null && (selectedDialogFilter[b].flags & DIALOG_FILTER_FLAG_EXCLUDE_READ) != 0) {
                                        filterDialogsChanged = true;
                                        break;
                                    }
                                }
                            }
                        } else if (prevCount == 0 && !currentDialog.unread_mark && currentDialog.unread_count != 0) {
                            if (!isDialogMuted(dialogId, 0)) {
                                unreadUnmutedDialogs++;
                            }
                            if (!filterDialogsChanged) {
                                for (int b = 0; b < selectedDialogFilter.length; b++) {
                                    if (selectedDialogFilter[b] != null && (selectedDialogFilter[b].flags & DIALOG_FILTER_FLAG_EXCLUDE_READ) != 0) {
                                        filterDialogsChanged = true;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (dialogsMentionsToUpdate != null) {
                for (int a = 0; a < dialogsMentionsToUpdate.size(); a++) {
                    long dialogId = dialogsMentionsToUpdate.keyAt(a);
                    TLRPC.Dialog currentDialog = dialogs_dict.get(dialogId);
                    if (currentDialog != null) {
                        currentDialog.unread_mentions_count = dialogsMentionsToUpdate.valueAt(a);
                        if (createdDialogMainThreadIds.contains(currentDialog.id)) {
                            getNotificationCenter().postNotificationName(NotificationCenter.updateMentionsCount, currentDialog.id, 0L, currentDialog.unread_mentions_count);
                        }
                        if (!filterDialogsChanged) {
                            for (int b = 0; b < selectedDialogFilter.length; b++) {
                                if (selectedDialogFilter[b] != null && ((selectedDialogFilter[b].flags & DIALOG_FILTER_FLAG_EXCLUDE_MUTED) != 0 || (selectedDialogFilter[b].flags & DIALOG_FILTER_FLAG_EXCLUDE_READ) != 0)) {
                                    filterDialogsChanged = true;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            if (filterDialogsChanged) {
                sortDialogs(null);
                getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
            }
            getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_READ_DIALOG_MESSAGE);
            if (dialogsToUpdate != null) {
                getNotificationsController().processDialogsUpdateRead(dialogsToUpdate);
            }
        });
    }

    protected void checkLastDialogMessage(TLRPC.Dialog dialog, TLRPC.InputPeer peer, long taskId) {
        if (DialogObject.isEncryptedDialog(dialog.id) || checkingLastMessagesDialogs.indexOfKey(dialog.id) >= 0) {
            return;
        }
        TLRPC.TL_messages_getHistory req = new TLRPC.TL_messages_getHistory();
        req.peer = peer == null ? getInputPeer(dialog.id) : peer;
        if (req.peer == null) {
            return;
        }
        req.limit = 1;
        checkingLastMessagesDialogs.put(dialog.id, true);
        if (BuildVars.LOGS_ENABLED) {
            FileLog.d("checkLastDialogMessage for " + dialog.id);
        }

        long newTaskId;
        if (taskId == 0) {
            NativeByteBuffer data = null;
            try {
                data = new NativeByteBuffer(60 + req.peer.getObjectSize());
                data.writeInt32(14);
                data.writeInt64(dialog.id);
                data.writeInt32(dialog.top_message);
                data.writeInt32(dialog.read_inbox_max_id);
                data.writeInt32(dialog.read_outbox_max_id);
                data.writeInt32(dialog.unread_count);
                data.writeInt32(dialog.last_message_date);
                data.writeInt32(dialog.pts);
                data.writeInt32(dialog.flags);
                data.writeBool(dialog.pinned);
                data.writeInt32(dialog.pinnedNum);
                data.writeInt32(dialog.unread_mentions_count);
                data.writeBool(dialog.unread_mark);
                data.writeInt32(dialog.folder_id);
                req.peer.serializeToStream(data);
            } catch (Exception e) {
                FileLog.e(e);
            }
            newTaskId = getMessagesStorage().createPendingTask(data);
        } else {
            newTaskId = taskId;
        }

        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response != null) {
                TLRPC.messages_Messages res = (TLRPC.messages_Messages) response;
                removeDeletedMessagesFromArray(dialog.id, res.messages);
                if (!res.messages.isEmpty()) {
                    if (BuildVars.LOGS_ENABLED) {
                        FileLog.d("checkLastDialogMessage for " + dialog.id + " has message");
                    }
                    TLRPC.TL_messages_dialogs dialogs = new TLRPC.TL_messages_dialogs();
                    TLRPC.Message newMessage = res.messages.get(0);
                    TLRPC.Dialog newDialog = new TLRPC.TL_dialog();
                    newDialog.flags = dialog.flags;
                    newDialog.top_message = newMessage.id;
                    newDialog.last_message_date = newMessage.date;
                    newDialog.notify_settings = dialog.notify_settings;
                    newDialog.pts = dialog.pts;
                    newDialog.unread_count = dialog.unread_count;
                    newDialog.unread_mark = dialog.unread_mark;
                    newDialog.unread_mentions_count = dialog.unread_mentions_count;
                    newDialog.unread_reactions_count = dialog.unread_reactions_count;
                    newDialog.read_inbox_max_id = dialog.read_inbox_max_id;
                    newDialog.read_outbox_max_id = dialog.read_outbox_max_id;
                    newDialog.pinned = dialog.pinned;
                    newDialog.pinnedNum = dialog.pinnedNum;
                    newDialog.folder_id = dialog.folder_id;
                    newMessage.dialog_id = newDialog.id = dialog.id;
                    dialogs.users.addAll(res.users);
                    dialogs.chats.addAll(res.chats);
                    dialogs.dialogs.add(newDialog);
                    dialogs.messages.addAll(res.messages);
                    dialogs.count = 1;
                    processDialogsUpdate(dialogs, null, false);
                    getMessagesStorage().putMessages(res.messages, true, true, false, getDownloadController().getAutodownloadMask(), true, 0, 0);
                } else {
                    AndroidUtilities.runOnUIThread(() -> {
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("checkLastDialogMessage for " + dialog.id + " has not message");
                        }
                        if (getMediaDataController().getDraft(dialog.id, 0) == null) {
                            TLRPC.Dialog currentDialog = dialogs_dict.get(dialog.id);
                            if (currentDialog == null) {
                                if (BuildVars.LOGS_ENABLED) {
                                    FileLog.d("checkLastDialogMessage for " + dialog.id + " current dialog not found");
                                }
                                getMessagesStorage().isDialogHasTopMessage(dialog.id, () -> deleteDialog(dialog.id, 3));
                            } else {
                                if (BuildVars.LOGS_ENABLED) {
                                    FileLog.d("checkLastDialogMessage for " + dialog.id + " current dialog top message " + currentDialog.top_message);
                                }
                                if (currentDialog.top_message == 0) {
                                    deleteDialog(dialog.id, 3);
                                }
                            }
                        }
                    });
                }
            }
            if (newTaskId != 0) {
                getMessagesStorage().removePendingTask(newTaskId);
            }
            AndroidUtilities.runOnUIThread(() -> checkingLastMessagesDialogs.delete(dialog.id));
        });
    }

    public void processDialogsUpdate(final TLRPC.messages_Dialogs dialogsRes, ArrayList<TLRPC.EncryptedChat> encChats, boolean fromCache) {
        Utilities.stageQueue.postRunnable(() -> {
            LongSparseArray<TLRPC.Dialog> new_dialogs_dict = new LongSparseArray<>();
            LongSparseArray<ArrayList<MessageObject>> new_dialogMessage = new LongSparseArray<>();
            LongSparseArray<TLRPC.User> usersDict = new LongSparseArray<>(dialogsRes.users.size());
            LongSparseArray<TLRPC.Chat> chatsDict = new LongSparseArray<>(dialogsRes.chats.size());
            LongSparseIntArray dialogsToUpdate = new LongSparseIntArray();

            for (int a = 0; a < dialogsRes.users.size(); a++) {
                TLRPC.User u = dialogsRes.users.get(a);
                usersDict.put(u.id, u);
            }
            for (int a = 0; a < dialogsRes.chats.size(); a++) {
                TLRPC.Chat c = dialogsRes.chats.get(a);
                chatsDict.put(c.id, c);
            }

            ArrayList<MessageObject> newMessages = new ArrayList<>();
            for (int a = 0; a < dialogsRes.messages.size(); a++) {
                TLRPC.Message message = dialogsRes.messages.get(a);
                if (promoDialogId == 0 || promoDialogId != message.dialog_id) {
                    if (message.peer_id != null && message.peer_id.channel_id != 0) {
                        TLRPC.Chat chat = chatsDict.get(message.peer_id.channel_id);
                        if (chat != null && ChatObject.isNotInChat(chat)) {
                            continue;
                        }
                    } else if (message.peer_id != null && message.peer_id.chat_id != 0) {
                        TLRPC.Chat chat = chatsDict.get(message.peer_id.chat_id);
                        if (chat != null && (chat.migrated_to != null || ChatObject.isNotInChat(chat))) {
                            continue;
                        }
                    }
                }
                MessageObject messageObject = new MessageObject(currentAccount, message, usersDict, chatsDict, false, false);
                newMessages.add(messageObject);
                long did = messageObject.getDialogId();
                ArrayList<MessageObject> arrayList = new_dialogMessage.get(did);
                if (arrayList == null) {
                    arrayList = new ArrayList<MessageObject>(1);
                }
                arrayList.add(messageObject);
                new_dialogMessage.put(did, arrayList);
            }
            getFileLoader().checkMediaExistance(newMessages);

            for (int a = 0; a < dialogsRes.dialogs.size(); a++) {
                TLRPC.Dialog d = dialogsRes.dialogs.get(a);
                DialogObject.initDialog(d);
                if (promoDialogId == 0 || promoDialogId != d.id) {
                    if (DialogObject.isChannel(d)) {
                        TLRPC.Chat chat = chatsDict.get(-d.id);
                        if (chat != null && ChatObject.isNotInChat(chat)) {
                            continue;
                        }
                    } else if (DialogObject.isChatDialog(d.id)) {
                        TLRPC.Chat chat = chatsDict.get(-d.id);
                        if (chat != null && (chat.migrated_to != null || ChatObject.isNotInChat(chat))) {
                            continue;
                        }
                    }
                }
                if (d.last_message_date == 0) {
                    ArrayList<MessageObject> messages = new_dialogMessage.get(d.id);
                    if (messages != null) {
                        int maxDate = Integer.MIN_VALUE;
                        for (int i = 0; i < messages.size(); ++i) {
                            MessageObject msg = messages.get(i);
                            if (msg != null && msg.messageOwner != null && msg.messageOwner.date > maxDate) {
                                maxDate = msg.messageOwner.date;
                            }
                        }
                        if (maxDate > Integer.MIN_VALUE) {
                            d.last_message_date = maxDate;
                        }
                    }
                }
                new_dialogs_dict.put(d.id, d);
                dialogsToUpdate.put(d.id, d.unread_count);

                Integer value = dialogs_read_inbox_max.get(d.id);
                if (value == null) {
                    value = 0;
                }
                if (d.read_inbox_max_id > d.top_message) {
                    d.read_inbox_max_id = d.top_message;
                }
                if (value > d.top_message) {
                    value = d.top_message;
                }
                dialogs_read_inbox_max.put(d.id, Math.max(value, d.read_inbox_max_id));

                value = dialogs_read_outbox_max.get(d.id);
                if (value == null) {
                    value = 0;
                }
                dialogs_read_outbox_max.put(d.id, Math.max(value, d.read_outbox_max_id));
            }

            AndroidUtilities.runOnUIThread(() -> {
                putUsers(dialogsRes.users, true);
                putChats(dialogsRes.chats, true);

                for (int a = 0; a < new_dialogs_dict.size(); a++) {
                    long key = new_dialogs_dict.keyAt(a);
                    if (BuildVars.LOGS_ENABLED) {
                        FileLog.d("processDialogsUpdate " + key);
                    }
                    TLRPC.Dialog value = new_dialogs_dict.valueAt(a);
                    TLRPC.Dialog currentDialog = dialogs_dict.get(key);
                    ArrayList<MessageObject> newMsgs = new_dialogMessage.get(value.id);
                    if (currentDialog == null) {
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("processDialogsUpdate dialog null");
                        }
                        int offset = nextDialogsCacheOffset.get(value.folder_id, 0) + 1;
                        nextDialogsCacheOffset.put(value.folder_id, offset);
                        dialogs_dict.put(key, value);
                        dialogMessage.put(key, newMsgs);
                        if (newMsgs == null || newMsgs.size() <= 0) {
                            if (fromCache) {
                                checkLastDialogMessage(value, null, 0);
                            }
                            if (BuildVars.LOGS_ENABLED) {
                                FileLog.d("processDialogsUpdate new message is null");
                            }
                        } else {
                            for (int i = 0; i < newMsgs.size(); ++i) {
                                MessageObject newMsg = newMsgs.get(i);
                                if (newMsg != null && newMsg.messageOwner.peer_id.channel_id == 0) {
                                    dialogMessagesByIds.put(newMsg.getId(), newMsg);
                                    dialogsLoadedTillDate = Math.min(dialogsLoadedTillDate, newMsg.messageOwner.date);
                                    if (newMsg.messageOwner.random_id != 0) {
                                        dialogMessagesByRandomIds.put(newMsg.messageOwner.random_id, newMsg);
                                    }
                                }
                            }
                            if (BuildVars.LOGS_ENABLED) {
                                FileLog.d("processDialogsUpdate new message not null");
                            }
                        }
                        if (getTranslateController().isFeatureAvailable(key)) {
                            getTranslateController().checkDialogMessageSure(key);
                        }
                    } else {
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("processDialogsUpdate dialog not null");
                        }
                        currentDialog.unread_count = value.unread_count;
                        if (currentDialog.unread_mentions_count != value.unread_mentions_count) {
                            currentDialog.unread_mentions_count = value.unread_mentions_count;
                            if (createdDialogMainThreadIds.contains(currentDialog.id)) {
                                getNotificationCenter().postNotificationName(NotificationCenter.updateMentionsCount, currentDialog.id, 0L, currentDialog.unread_mentions_count);
                            }
                        }
                        if (currentDialog.unread_reactions_count != value.unread_reactions_count) {
                            currentDialog.unread_reactions_count = value.unread_reactions_count;
                            getNotificationCenter().postNotificationName(NotificationCenter.dialogsUnreadReactionsCounterChanged, currentDialog.id, 0L, currentDialog.unread_reactions_count, null);
                        }
                        ArrayList<MessageObject> oldMsgs = dialogMessage.get(key);
                        boolean oldMsgsDeleted = false;
                        for (int i = 0; oldMsgs != null && i < oldMsgs.size(); ++i) {
                            if (oldMsgs.get(i) != null && oldMsgs.get(i).deleted) {
                                oldMsgsDeleted = true;
                                break;
                            }
                        }
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("processDialogsUpdate oldMsgs (count = " + (oldMsgs == null ? "null" : oldMsgs.size()) + ") old top_message = " + currentDialog.top_message + " new top_message = " + value.top_message + "  unread_count =" + currentDialog.unread_count + " fromCache=" + fromCache);
                            FileLog.d("processDialogsUpdate oldMsgDeleted " + oldMsgsDeleted);
                        }
                        if (oldMsgs == null || currentDialog.top_message > 0) {
                            if (oldMsgsDeleted || value.top_message > currentDialog.top_message || (oldMsgs == null) != (newMsgs == null) || oldMsgs != null && newMsgs != null && oldMsgs.size() != newMsgs.size()) {
                                dialogs_dict.put(key, value);
                                dialogMessage.put(key, newMsgs);
                                for (int i = 0; oldMsgs != null && i < oldMsgs.size(); ++i) {
                                    MessageObject oldMsg = oldMsgs.get(i);
                                    if (oldMsg != null && oldMsg.messageOwner.peer_id.channel_id == 0) {
                                        dialogMessagesByIds.remove(oldMsg.getId());
                                        if (oldMsg.messageOwner.random_id != 0) {
                                            dialogMessagesByRandomIds.remove(oldMsg.messageOwner.random_id);
                                        }
                                    }
                                }
                                if (newMsgs != null) {
                                    for (int i = 0; i < newMsgs.size(); ++i) {
                                        MessageObject newMsg = newMsgs.get(i);
                                        for (int j = 0; oldMsgs != null && j < oldMsgs.size(); ++j) {
                                            MessageObject oldMsg = oldMsgs.get(j);
                                            if (oldMsg != null && oldMsg.getId() == newMsg.getId()) {
                                                newMsg.deleted = oldMsg.deleted;
                                                break;
                                            }
                                        }
                                        if (newMsg != null && newMsg.messageOwner.peer_id.channel_id == 0) {
                                            dialogMessagesByIds.put(newMsg.getId(), newMsg);
                                            dialogsLoadedTillDate = Math.min(dialogsLoadedTillDate, newMsg.messageOwner.date);
                                            if (newMsg.messageOwner.random_id != 0) {
                                                dialogMessagesByRandomIds.put(newMsg.messageOwner.random_id, newMsg);
                                            }
                                        }
                                    }
                                }
                                if (getTranslateController().isFeatureAvailable(key)) {
                                    getTranslateController().checkDialogMessageSure(key);
                                }
                            }
                            if (fromCache && newMsgs == null) {
                                checkLastDialogMessage(value, null, 0);
                                if (BuildVars.LOGS_ENABLED) {
                                    FileLog.d("processDialogsUpdate new messages are null");
                                }
                            }
                        } else {
                            if (oldMsgsDeleted || messagesMaxDate(newMsgs) > messagesMaxDate(oldMsgs)) {
                                dialogs_dict.put(key, value);
                                dialogMessage.put(key, newMsgs);
                                if (oldMsgs != null) {
                                    for (int i = 0; i < oldMsgs.size(); ++i) {
                                        MessageObject oldMsg = oldMsgs.get(i);
                                        if (oldMsg != null && oldMsg.messageOwner.peer_id.channel_id == 0) {
                                            dialogMessagesByIds.remove(oldMsg.getId());
                                        }
                                    }
                                }
                                if (newMsgs != null) {
                                    for (int i = 0; i < newMsgs.size(); ++i) {
                                        MessageObject newMsg = newMsgs.get(i);
                                        for (int j = 0; oldMsgs != null && j < oldMsgs.size(); ++j) {
                                            MessageObject oldMsg = oldMsgs.get(j);
                                            if (oldMsg != null && oldMsg.getId() == newMsg.getId()) {
                                                newMsg.deleted = oldMsg.deleted;
                                                break;
                                            }
                                        }
                                        if (newMsg != null && newMsg.messageOwner.peer_id.channel_id == 0) {
                                            dialogMessagesByIds.put(newMsg.getId(), newMsg);
                                            dialogsLoadedTillDate = Math.min(dialogsLoadedTillDate, newMsg.messageOwner.date);
                                            if (newMsg.messageOwner.random_id != 0) {
                                                dialogMessagesByRandomIds.put(newMsg.messageOwner.random_id, newMsg);
                                            }
                                        }
                                    }
                                }
                                if (oldMsgs != null) {
                                    for (int i = 0; i < oldMsgs.size(); ++i) {
                                        MessageObject oldMsg = oldMsgs.get(i);
                                        if (oldMsg.messageOwner.random_id != 0) {
                                            dialogMessagesByRandomIds.remove(oldMsg.messageOwner.random_id);
                                        }
                                    }
                                }
                                if (getTranslateController().isFeatureAvailable(key)) {
                                    getTranslateController().checkDialogMessageSure(key);
                                }
                            }
                        }
                    }
                }

                allDialogs.clear();
                for (int a = 0, size = dialogs_dict.size(); a < size; a++) {
                    TLRPC.Dialog dialog = dialogs_dict.valueAt(a);
                    if (deletingDialogs.indexOfKey(dialog.id) >= 0) {
                        continue;
                    }
                    allDialogs.add(dialog);
                }
                sortDialogs(null);
                getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                getNotificationsController().processDialogsUpdateRead(dialogsToUpdate);
            });
        });
    }

    private int messagesMaxDate(ArrayList<MessageObject> messages) {
        int maxDate = Integer.MIN_VALUE;
        for (int i = 0; messages != null && i < messages.size(); ++i) {
            MessageObject m = messages.get(i);
            if (m != null && m.messageOwner != null && m.messageOwner.date > maxDate) {
                maxDate = m.messageOwner.date;
            }
        }
        return maxDate;
    }

    public void addToViewsQueue(MessageObject messageObject) {
        if (messageObject == null) return;
        Utilities.stageQueue.postRunnable(() -> {
            long peer = messageObject.getDialogId();
            int id = messageObject.getId();
            ArrayList<Integer> ids = channelViewsToSend.get(peer);
            if (ids == null) {
                ids = new ArrayList<>();
                channelViewsToSend.put(peer, ids);
            }
            if (!ids.contains(id)) {
                ids.add(id);
            }
        });
    }

    public void addToPollsQueue(long dialogId, ArrayList<MessageObject> visibleObjects) {
        SparseArray<MessageObject> array = pollsToCheck.get(dialogId);
        if (array == null) {
            array = new SparseArray<>();
            pollsToCheck.put(dialogId, array);
            pollsToCheckSize++;
        }
        for (int a = 0, N = array.size(); a < N; a++) {
            MessageObject object = array.valueAt(a);
            object.pollVisibleOnScreen = false;
        }
        int time = getConnectionsManager().getCurrentTime();
        int minExpireTime = Integer.MAX_VALUE;
        boolean hasExpiredPolls = false;
        for (int a = 0, N = visibleObjects.size(); a < N; a++) {
            MessageObject messageObject = visibleObjects.get(a);
            if (messageObject.type != MessageObject.TYPE_POLL || !(messageObject.messageOwner.media instanceof TLRPC.TL_messageMediaPoll)) {
                continue;
            }
            TLRPC.TL_messageMediaPoll mediaPoll = (TLRPC.TL_messageMediaPoll) messageObject.messageOwner.media;
            if (!mediaPoll.poll.closed && mediaPoll.poll.close_date != 0) {
                if (mediaPoll.poll.close_date <= time) {
                    hasExpiredPolls = true;
                } else {
                    minExpireTime = Math.min(minExpireTime, mediaPoll.poll.close_date - time);
                }
            }
            int id = messageObject.getId();
            MessageObject object = array.get(id);
            if (object != null) {
                object.pollVisibleOnScreen = true;
            } else {
                array.put(id, messageObject);
            }
        }
        if (hasExpiredPolls) {
            lastViewsCheckTime = 0;
        } else if (minExpireTime < 5) {
            lastViewsCheckTime = Math.min(lastViewsCheckTime, System.currentTimeMillis() - (5 - minExpireTime) * 1000);
        }
    }

    public void markMessageContentAsRead(MessageObject messageObject) {
        if (messageObject.scheduled) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<>();
        if (messageObject.messageOwner.mentioned) {
            getMessagesStorage().markMentionMessageAsRead(-messageObject.messageOwner.peer_id.channel_id, messageObject.getId(), messageObject.getDialogId());
        }
        arrayList.add(messageObject.getId());
        long dialogId = messageObject.getDialogId();
        getMessagesStorage().markMessagesContentAsRead(dialogId, arrayList, 0, 0);
        getNotificationCenter().postNotificationName(NotificationCenter.messagesReadContent, dialogId, arrayList);
        if (messageObject.getId() < 0) {
            markMessageAsRead(messageObject.getDialogId(), messageObject.messageOwner.random_id, Integer.MIN_VALUE);
        } else {
            if (messageObject.messageOwner.peer_id.channel_id != 0) {
                TLRPC.TL_channels_readMessageContents req = new TLRPC.TL_channels_readMessageContents();
                req.channel = getInputChannel(messageObject.messageOwner.peer_id.channel_id);
                if (req.channel == null) {
                    return;
                }
                req.id.add(messageObject.getId());
                getConnectionsManager().sendRequest(req, (response, error) -> {

                });
            } else {
                TLRPC.TL_messages_readMessageContents req = new TLRPC.TL_messages_readMessageContents();
                req.id.add(messageObject.getId());
                getConnectionsManager().sendRequest(req, (response, error) -> {
                    if (error == null) {
                        TLRPC.TL_messages_affectedMessages res = (TLRPC.TL_messages_affectedMessages) response;
                        processNewDifferenceParams(-1, res.pts, -1, res.pts_count);
                    }
                });
            }
        }
    }

    public void markMentionMessageAsRead(int mid, long channelId, long did) {
        getMessagesStorage().markMentionMessageAsRead(-channelId, mid, did);
        if (channelId != 0) {
            TLRPC.TL_channels_readMessageContents req = new TLRPC.TL_channels_readMessageContents();
            req.channel = getInputChannel(channelId);
            if (req.channel == null) {
                return;
            }
            req.id.add(mid);
            getConnectionsManager().sendRequest(req, (response, error) -> {

            });
        } else {
            TLRPC.TL_messages_readMessageContents req = new TLRPC.TL_messages_readMessageContents();
            req.id.add(mid);
            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (error == null) {
                    TLRPC.TL_messages_affectedMessages res = (TLRPC.TL_messages_affectedMessages) response;
                    processNewDifferenceParams(-1, res.pts, -1, res.pts_count);
                }
            });
        }
    }

    public long createDeleteShowOnceTask(long dialogId, int mid) {
        NativeByteBuffer data = null;
        try {
            data = new NativeByteBuffer(16);
            data.writeInt32(102);
            data.writeInt64(dialogId);
            data.writeInt32(mid);
        } catch (Exception e) {
            FileLog.e(e);
        }
        return getMessagesStorage().createPendingTask(data);
    }

    public void doDeleteShowOnceTask(long taskId, long dialogId, int mid) {
        getMessagesStorage().removePendingTask(taskId);
        ArrayList<Integer> mids = new ArrayList<>();
        mids.add(mid);
        getMessagesStorage().emptyMessagesMedia(dialogId, mids);
    }

    public void markMessageAsRead2(long dialogId, int mid, TLRPC.InputChannel inputChannel, int ttl, long taskId) {
        markMessageAsRead2(dialogId, mid, inputChannel, ttl, taskId, true);
    }

    public void markMessageAsRead2(long dialogId, int mid, TLRPC.InputChannel inputChannel, int ttl, long taskId, boolean createDeleteTask) {
        if (mid == 0 || ttl < 0) {
            return;
        }
        if (DialogObject.isChatDialog(dialogId) && inputChannel == null) {
            inputChannel = getInputChannel(dialogId);
            if (inputChannel == null) {
                return;
            }
        }
        long newTaskId;
        if (taskId == 0) {
            NativeByteBuffer data = null;
            try {
                data = new NativeByteBuffer(20 + (inputChannel != null ? inputChannel.getObjectSize() : 0));
                data.writeInt32(createDeleteTask ? 23 : 101);
                data.writeInt64(dialogId);
                data.writeInt32(mid);
                data.writeInt32(ttl);
                if (inputChannel != null) {
                    inputChannel.serializeToStream(data);
                }
            } catch (Exception e) {
                FileLog.e(e);
            }
            newTaskId = getMessagesStorage().createPendingTask(data);
        } else {
            newTaskId = taskId;
        }
        int time = getConnectionsManager().getCurrentTime();
        if (createDeleteTask) {
            getMessagesStorage().createTaskForMid(dialogId, mid, time, time, ttl, false);
        }
        if (inputChannel != null) {
            TLRPC.TL_channels_readMessageContents req = new TLRPC.TL_channels_readMessageContents();
            req.channel = inputChannel;
            req.id.add(mid);
            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (newTaskId != 0) {
                    getMessagesStorage().removePendingTask(newTaskId);
                }
            });
        } else {
            TLRPC.TL_messages_readMessageContents req = new TLRPC.TL_messages_readMessageContents();
            req.id.add(mid);
            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (error == null) {
                    TLRPC.TL_messages_affectedMessages res = (TLRPC.TL_messages_affectedMessages) response;
                    processNewDifferenceParams(-1, res.pts, -1, res.pts_count);
                }
                if (newTaskId != 0) {
                    getMessagesStorage().removePendingTask(newTaskId);
                }
            });
        }
    }

    public void markMessageAsRead(long dialogId, long randomId, int ttl) {
        if (randomId == 0 || dialogId == 0 || ttl <= 0 && ttl != Integer.MIN_VALUE) {
            return;
        }
        if (!DialogObject.isEncryptedDialog(dialogId)) {
            return;
        }
        TLRPC.EncryptedChat chat = getEncryptedChat(DialogObject.getEncryptedChatId(dialogId));
        if (chat == null) {
            return;
        }
        ArrayList<Long> randomIds = new ArrayList<>();
        randomIds.add(randomId);
        getSecretChatHelper().sendMessagesReadMessage(chat, randomIds, null);
        if (ttl > 0) {
            int time = getConnectionsManager().getCurrentTime();
            getMessagesStorage().createTaskForSecretChat(chat.id, time, time, 0, randomIds);
        }
    }

    private void completeReadTask(ReadTask task) {
        if (task.replyId != 0 && task.monoForumPeerId == 0) {
            TLRPC.TL_messages_readDiscussion req = new TLRPC.TL_messages_readDiscussion();
            req.msg_id = (int) task.replyId;
            req.peer = getInputPeer(task.dialogId);
            req.read_max_id = task.maxId;
            getConnectionsManager().sendRequest(req, (response, error) -> {

            });
        } else if (!DialogObject.isEncryptedDialog(task.dialogId)) {
            TLRPC.InputPeer inputPeer = getInputPeer(task.dialogId);
            TLObject req;

            if (task.monoForumPeerId != 0) {
                TLRPC.TL_messages_readSavedHistory request = new TLRPC.TL_messages_readSavedHistory();
                request.parent_peer = getInputPeer(task.dialogId);
                request.peer = getInputPeer(task.monoForumPeerId);
                request.max_id = task.maxId;
                req = request;
            } else if (inputPeer instanceof TLRPC.TL_inputPeerChannel) {
                TLRPC.TL_channels_readHistory request = new TLRPC.TL_channels_readHistory();
                request.channel = getInputChannel(-task.dialogId);
                request.max_id = task.maxId;
                req = request;
            } else {
                TLRPC.TL_messages_readHistory request = new TLRPC.TL_messages_readHistory();
                request.peer = inputPeer;
                request.max_id = task.maxId;
                req = request;
            }
            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (error == null) {
                    if (response instanceof TLRPC.TL_messages_affectedMessages) {
                        TLRPC.TL_messages_affectedMessages res = (TLRPC.TL_messages_affectedMessages) response;
                        processNewDifferenceParams(-1, res.pts, -1, res.pts_count);
                    }
                }
            });
        } else {
            TLRPC.EncryptedChat chat = getEncryptedChat(DialogObject.getEncryptedChatId(task.dialogId));
            if (chat.auth_key != null && chat.auth_key.length > 1 && chat instanceof TLRPC.TL_encryptedChat) {
                TLRPC.TL_messages_readEncryptedHistory req = new TLRPC.TL_messages_readEncryptedHistory();
                req.peer = new TLRPC.TL_inputEncryptedChat();
                req.peer.chat_id = chat.id;
                req.peer.access_hash = chat.access_hash;
                req.max_date = task.maxDate;
                getConnectionsManager().sendRequest(req, (response, error) -> {

                });
            }
        }
    }

    private void checkReadTasks() {
        long time = SystemClock.elapsedRealtime();
        for (int a = 0, size = readTasks.size(); a < size; a++) {
            ReadTask task = readTasks.get(a);
            if (task.sendRequestTime > time) {
                continue;
            }
            completeReadTask(task);
            readTasks.remove(a);
            readTasksMap.remove(task.dialogId);
            a--;
            size--;
        }
        for (int a = 0, size = repliesReadTasks.size(); a < size; a++) {
            ReadTask task = repliesReadTasks.get(a);
            if (task.sendRequestTime > time) {
                continue;
            }
            completeReadTask(task);
            repliesReadTasks.remove(a);
            threadsReadTasksMap.remove(task.dialogId + "_" + task.replyId);
            a--;
            size--;
        }
    }

    public void markDialogAsReadNow(long dialogId, long replyId) {
        Utilities.stageQueue.postRunnable(() -> {
            if (replyId != 0) {
                String key = dialogId + "_" + replyId;
                ReadTask currentReadTask = threadsReadTasksMap.get(key);
                if (currentReadTask == null) {
                    return;
                }
                completeReadTask(currentReadTask);
                repliesReadTasks.remove(currentReadTask);
                threadsReadTasksMap.remove(key);
            } else {
                ReadTask currentReadTask = readTasksMap.get(dialogId);
                if (currentReadTask == null) {
                    return;
                }
                completeReadTask(currentReadTask);
                readTasks.remove(currentReadTask);
                readTasksMap.remove(dialogId);
            }
        });
    }

    public void markMentionsAsRead(long dialogId, long topicId) {
        if (DialogObject.isEncryptedDialog(dialogId) || dialogId == getUserConfig().getClientUserId()) {
            return;
        }
        getMessagesStorage().resetMentionsCount(dialogId, topicId, 0);
        TLRPC.TL_messages_readMentions req = new TLRPC.TL_messages_readMentions();
        req.peer = getInputPeer(dialogId);
        if (topicId != 0) {
            req.top_msg_id = (int) topicId;
            req.flags |= 1;
        }
        getConnectionsManager().sendRequest(req, null);
    }

    public void markDialogAsRead(long dialogId, int maxPositiveId, int maxNegativeId, int maxDate, boolean popup, long threadId, int countDiff, boolean readNow, int scheduledCount) {
        boolean createReadTask;

        if (threadId != 0) {
            createReadTask = maxPositiveId != Integer.MAX_VALUE;
        } else {
            boolean countMessages = getNotificationsController().showBadgeMessages;
            if (!DialogObject.isEncryptedDialog(dialogId)) {
                if (maxPositiveId == 0) {
                    return;
                }
                Integer value = dialogs_read_inbox_max.get(dialogId);
                if (value == null) {
                    value = 0;
                }
                dialogs_read_inbox_max.put(dialogId, Math.max(value, maxPositiveId));

                getMessagesStorage().processPendingRead(dialogId, maxPositiveId, maxNegativeId, scheduledCount);
                getMessagesStorage().getStorageQueue().postRunnable(() -> AndroidUtilities.runOnUIThread(() -> {
                    TLRPC.Dialog dialog = dialogs_dict.get(dialogId);
                    if (dialog != null) {
                        int prevCount = dialog.unread_count;
                        if (countDiff == 0 || maxPositiveId >= dialog.top_message) {
                            dialog.unread_count = 0;
                        } else {
                            dialog.unread_count = Math.max(dialog.unread_count - countDiff, 0);
                            if (maxPositiveId != Integer.MIN_VALUE && dialog.unread_count > dialog.top_message - maxPositiveId) {
                                dialog.unread_count = dialog.top_message - maxPositiveId;
                            }
                        }

                        boolean wasUnread;
                        if (wasUnread = dialog.unread_mark) {
                            dialog.unread_mark = false;
                            getMessagesStorage().setDialogUnread(dialog.id, false);
                        }
                        if ((prevCount != 0 || wasUnread) && dialog.unread_count == 0) {
                            if (!isDialogMuted(dialogId, 0)) {
                                unreadUnmutedDialogs--;
                            }
                            for (int b = 0; b < selectedDialogFilter.length; b++) {
                                if (selectedDialogFilter[b] != null && (selectedDialogFilter[b].flags & DIALOG_FILTER_FLAG_EXCLUDE_READ) != 0) {
                                    sortDialogs(null);
                                    getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                                    break;
                                }
                            }
                        }
                        getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_READ_DIALOG_MESSAGE);
                    }
                    if (!popup) {
                        getNotificationsController().processReadMessages(null, dialogId, 0, maxPositiveId, false);
                        LongSparseIntArray dialogsToUpdate = new LongSparseIntArray(1);
                        dialogsToUpdate.put(dialogId, 0);
                        getNotificationsController().processDialogsUpdateRead(dialogsToUpdate);
                    } else {
                        getNotificationsController().processReadMessages(null, dialogId, 0, maxPositiveId, true);
                        LongSparseIntArray dialogsToUpdate = new LongSparseIntArray(1);
                        dialogsToUpdate.put(dialogId, -1);
                        getNotificationsController().processDialogsUpdateRead(dialogsToUpdate);
                    }
                }));

                createReadTask = maxPositiveId != Integer.MAX_VALUE;
            } else {
                if (maxDate == 0) {
                    return;
                }
                createReadTask = true;

                TLRPC.EncryptedChat chat = getEncryptedChat(DialogObject.getEncryptedChatId(dialogId));
                getMessagesStorage().processPendingRead(dialogId, maxPositiveId, maxNegativeId, scheduledCount);
                getMessagesStorage().getStorageQueue().postRunnable(() -> AndroidUtilities.runOnUIThread(() -> {
                    getNotificationsController().processReadMessages(null, dialogId, maxDate, 0, popup);
                    TLRPC.Dialog dialog = dialogs_dict.get(dialogId);
                    if (dialog != null) {
                        int prevCount = dialog.unread_count;
                        if (countDiff == 0 || maxNegativeId <= dialog.top_message) {
                            dialog.unread_count = 0;
                        } else {
                            dialog.unread_count = Math.max(dialog.unread_count - countDiff, 0);
                            if (maxNegativeId != Integer.MAX_VALUE && dialog.unread_count > maxNegativeId - dialog.top_message) {
                                dialog.unread_count = maxNegativeId - dialog.top_message;
                            }
                        }
                        boolean wasUnread;
                        if (wasUnread = dialog.unread_mark) {
                            dialog.unread_mark = false;
                            getMessagesStorage().setDialogUnread(dialog.id, false);
                        }
                        if ((prevCount != 0 || wasUnread) && dialog.unread_count == 0) {
                            if (!isDialogMuted(dialogId, 0)) {
                                unreadUnmutedDialogs--;
                            }
                            for (int b = 0; b < selectedDialogFilter.length; b++) {
                                if (selectedDialogFilter[b] != null && (selectedDialogFilter[b].flags & DIALOG_FILTER_FLAG_EXCLUDE_READ) != 0) {
                                    sortDialogs(null);
                                    getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                                    break;
                                }
                            }
                        }
                        getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_READ_DIALOG_MESSAGE);
                    }
                    LongSparseIntArray dialogsToUpdate = new LongSparseIntArray(1);
                    dialogsToUpdate.put(dialogId, 0);
                    getNotificationsController().processDialogsUpdateRead(dialogsToUpdate);
                }));

                if (chat != null && chat.ttl > 0) {
                    int serverTime = Math.max(getConnectionsManager().getCurrentTime(), maxDate);
                    getMessagesStorage().createTaskForSecretChat(chat.id, maxDate, serverTime, 0, null);
                }
            }
        }

        final long monoForumPeerId;
        if (getMessagesStorage().isMonoForum(dialogId)) {
            monoForumPeerId = threadId;
        } else {
            monoForumPeerId = 0;
        }

        if (createReadTask) {
            Utilities.stageQueue.postRunnable(() -> {
                ReadTask currentReadTask;
                if (threadId != 0) {
                    currentReadTask = threadsReadTasksMap.get(dialogId + "_" + threadId);
                } else {
                    currentReadTask = readTasksMap.get(dialogId);
                }
                if (currentReadTask == null) {
                    currentReadTask = new ReadTask();
                    currentReadTask.dialogId = dialogId;
                    currentReadTask.replyId = threadId;
                    currentReadTask.monoForumPeerId = monoForumPeerId;
                    currentReadTask.sendRequestTime = SystemClock.elapsedRealtime() + 5000;
                    if (!readNow) {
                        if (threadId != 0) {
                            threadsReadTasksMap.put(dialogId + "_" + threadId, currentReadTask);
                            repliesReadTasks.add(currentReadTask);
                        } else {
                            readTasksMap.put(dialogId, currentReadTask);
                            readTasks.add(currentReadTask);
                        }
                    }
                }
                currentReadTask.maxDate = maxDate;
                currentReadTask.maxId = maxPositiveId;
                if (readNow) {
                    completeReadTask(currentReadTask);
                }
            });
        }
    }

    public int createChat(String title, ArrayList<Long> selectedContacts, String about, int type, boolean forImport, Location location, String locationAddress, int ttlPeriod, BaseFragment fragment) {
        if (type == ChatObject.CHAT_TYPE_CHAT && !forImport) {
            TLRPC.TL_messages_createChat req = new TLRPC.TL_messages_createChat();
            req.title = title;
            if (ttlPeriod >= 0) {
                req.ttl_period = ttlPeriod;
                req.flags |= 1;
            }
            for (int a = 0; a < selectedContacts.size(); a++) {
                TLRPC.User user = getUser(selectedContacts.get(a));
                if (user == null) {
                    continue;
                }
                req.users.add(getInputUser(user));
            }
            return getConnectionsManager().sendRequest(req, (response, error) -> {
                if (error != null) {
                    AndroidUtilities.runOnUIThread(() -> {
                        AlertsCreator.processError(currentAccount, error, fragment, req);
                        getNotificationCenter().postNotificationName(NotificationCenter.chatDidFailCreate);
                    });
                    return;
                }
                if (response instanceof TLRPC.TL_messages_invitedUsers) {
                    TLRPC.TL_messages_invitedUsers res = (TLRPC.TL_messages_invitedUsers) response;
                    processUpdates(res.updates, false);
                    AndroidUtilities.runOnUIThread(() -> {
                        putUsers(res.updates.users, false);
                        putChats(res.updates.chats, false);
                        if (res.updates.chats != null && !res.updates.chats.isEmpty()) {
                            getNotificationCenter().postNotificationName(NotificationCenter.chatDidCreated, res.updates.chats.get(0).id);
                            AlertsCreator.checkRestrictedInviteUsers(currentAccount, res.updates.chats.get(0), res);
                        } else {
                            getNotificationCenter().postNotificationName(NotificationCenter.chatDidFailCreate);
                        }
                    });
                }
            }, ConnectionsManager.RequestFlagFailOnServerErrors);
        } else if (forImport || type == ChatObject.CHAT_TYPE_CHANNEL || type == ChatObject.CHAT_TYPE_MEGAGROUP || type == ChatObject.CHAT_TYPE_FORUM) {
            TLRPC.TL_channels_createChannel req = new TLRPC.TL_channels_createChannel();
            req.title = title;
            req.about = about != null ? about : "";
            req.for_import = forImport;
            if (forImport || type == ChatObject.CHAT_TYPE_MEGAGROUP || type == ChatObject.CHAT_TYPE_FORUM) {
                req.megagroup = true;
            } else {
                req.broadcast = true;
            }
            req.forum = type == ChatObject.CHAT_TYPE_FORUM;
            if (location != null) {
                req.geo_point = new TLRPC.TL_inputGeoPoint();
                req.geo_point.lat = location.getLatitude();
                req.geo_point._long = location.getLongitude();
                req.address = locationAddress;
                req.flags |= 4;
            }
            return getConnectionsManager().sendRequest(req, (response, error) -> {
                if (error != null) {
                    AndroidUtilities.runOnUIThread(() -> {
                        AlertsCreator.processError(currentAccount, error, fragment, req);
                        getNotificationCenter().postNotificationName(NotificationCenter.chatDidFailCreate);
                    });
                    return;
                }
                TLRPC.Updates updates = (TLRPC.Updates) response;
                processUpdates(updates, false);
                AndroidUtilities.runOnUIThread(() -> {
                    putUsers(updates.users, false);
                    putChats(updates.chats, false);
                    if (updates.chats != null && !updates.chats.isEmpty()) {
                        getNotificationCenter().postNotificationName(NotificationCenter.chatDidCreated, updates.chats.get(0).id);
                    } else {
                        getNotificationCenter().postNotificationName(NotificationCenter.chatDidFailCreate);
                    }
                });
            }, ConnectionsManager.RequestFlagFailOnServerErrors);
        }
        return 0;
    }

    public void convertToMegaGroup(Context context, long chatId, BaseFragment fragment, MessagesStorage.LongCallback convertRunnable) {
        convertToMegaGroup(context, chatId, fragment, convertRunnable, null);
    }

    public void convertToMegaGroup(Context context, long chatId, BaseFragment fragment, MessagesStorage.LongCallback convertRunnable, Runnable errorRunnable) {
        TLRPC.TL_messages_migrateChat req = new TLRPC.TL_messages_migrateChat();
        req.chat_id = chatId;
        AlertDialog progressDialog = context != null ? new AlertDialog(context, AlertDialog.ALERT_TYPE_SPINNER) : null;
        int reqId = getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error == null) {
                if (context != null) {
                    AndroidUtilities.runOnUIThread(() -> {
                        if (!((Activity) context).isFinishing()) {
                            try {
                                progressDialog.dismiss();
                            } catch (Exception e) {
                                FileLog.e(e);
                            }
                        }
                    });
                }
                TLRPC.Updates updates = (TLRPC.Updates) response;
                processUpdates((TLRPC.Updates) response, false);
                AndroidUtilities.runOnUIThread(() -> {
                    if (convertRunnable != null) {
                        TLRPC.Chat prevChat = null;
                        for (int a = 0; a < updates.chats.size(); a++) {
                            TLRPC.Chat chat = updates.chats.get(a);
                            if (chatId == chat.id) {
                                prevChat = chat;
                                break;
                            }
                        }
                        if (prevChat != null && prevChat.migrated_to != null) {
                            long newChatId = prevChat.migrated_to.channel_id;
                            TLRPC.Chat newChat = null;
                            for (int a = 0; a < updates.chats.size(); a++) {
                                TLRPC.Chat chat = updates.chats.get(a);
                                if (newChatId == chat.id) {
                                    newChat = chat;
                                    break;
                                }
                            }
                            if (newChat != null) {
                                convertRunnable.run(newChatId);
                            }
                        }
                    }
                });
            } else {
                if (errorRunnable != null) {
                    errorRunnable.run();
                }
                AndroidUtilities.runOnUIThread(() -> {
                    if (convertRunnable != null) {
                        convertRunnable.run(0);
                    }
                    if (context != null) {
                        if (!((Activity) context).isFinishing()) {
                            try {
                                progressDialog.dismiss();
                            } catch (Exception e) {
                                FileLog.e(e);
                            }
                            AlertsCreator.processError(currentAccount, error, fragment, req, false);
                        }
                    }
                });
            }
        });
        if (progressDialog != null) {
            progressDialog.setOnCancelListener(dialog -> getConnectionsManager().cancelRequest(reqId, true));
            try {
                progressDialog.show();
            } catch (Exception ignore) {

            }
        }
    }

    public void convertToGigaGroup(final Context context, TLRPC.Chat chat, BaseFragment fragment, MessagesStorage.BooleanCallback convertRunnable) {
        TLRPC.TL_channels_convertToGigagroup req = new TLRPC.TL_channels_convertToGigagroup();
        req.channel = getInputChannel(chat);
        AlertDialog progressDialog = context != null ? new AlertDialog(context, AlertDialog.ALERT_TYPE_SPINNER) : null;
        int reqId = getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error == null) {
                if (context != null) {
                    AndroidUtilities.runOnUIThread(() -> {
                        if (!((Activity) context).isFinishing()) {
                            try {
                                progressDialog.dismiss();
                            } catch (Exception e) {
                                FileLog.e(e);
                            }
                        }
                    });
                }
                TLRPC.Updates updates = (TLRPC.Updates) response;
                processUpdates((TLRPC.Updates) response, false);
                AndroidUtilities.runOnUIThread(() -> {
                    if (convertRunnable != null) {
                        convertRunnable.run(true);
                    }
                });
            } else {
                AndroidUtilities.runOnUIThread(() -> {
                    if (convertRunnable != null) {
                        convertRunnable.run(false);
                    }
                    if (context != null) {
                        if (!((Activity) context).isFinishing()) {
                            try {
                                progressDialog.dismiss();
                            } catch (Exception e) {
                                FileLog.e(e);
                            }
                            AlertsCreator.processError(currentAccount, error, fragment, req, false);
                        }
                    }
                });
            }
        });
        if (progressDialog != null) {
            progressDialog.setOnCancelListener(dialog -> getConnectionsManager().cancelRequest(reqId, true));
            try {
                progressDialog.showDelayed(400);
            } catch (Exception ignore) {

            }
        }
    }

    public void addUsersToChannel(long chatId, ArrayList<TLRPC.InputUser> users, BaseFragment fragment) {
        if (users == null || users.isEmpty()) {
            return;
        }
        TLRPC.TL_channels_inviteToChannel req = new TLRPC.TL_channels_inviteToChannel();
        req.channel = getInputChannel(chatId);
        req.users = users;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error != null) {
                AndroidUtilities.runOnUIThread(() -> AlertsCreator.processError(currentAccount, error, fragment, req, true));
                return;
            }
            if (response instanceof TLRPC.TL_messages_invitedUsers) {
                TLRPC.TL_messages_invitedUsers res = (TLRPC.TL_messages_invitedUsers) response;
                processUpdates(res.updates, false);
                AndroidUtilities.runOnUIThread(() -> {
                    putUsers(res.updates.users, false);
                    putChats(res.updates.chats, false);
                    AlertsCreator.checkRestrictedInviteUsers(currentAccount, getChat(chatId), res);
                });
            }
        });
    }

    public void setDefaultSendAs(long chatId, long newPeer) {
        TLRPC.ChatFull cachedFull = getChatFull(-chatId);
        if (cachedFull != null) {
            cachedFull.default_send_as = getPeer(newPeer);
            getMessagesStorage().updateChatInfo(cachedFull, false);
            getNotificationCenter().postNotificationName(NotificationCenter.updateDefaultSendAsPeer, chatId, cachedFull.default_send_as);
        }

        final TLRPC.TL_messages_saveDefaultSendAs req = new TLRPC.TL_messages_saveDefaultSendAs();
        req.peer = getInputPeer(chatId);
        req.send_as = getInputPeer(newPeer);
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response instanceof TLRPC.TL_boolTrue) {
                TLRPC.ChatFull full = getChatFull(-chatId);
                if (full == null) loadFullChat(-chatId, 0, true);
            } else if (error != null && error.code == 400) {
                loadFullChat(-chatId, 0, true);
            }
        }, ConnectionsManager.RequestFlagInvokeAfter);
    }

    public void toggleChatNoForwards(long chatId, boolean enabled) {
        TLRPC.TL_messages_toggleNoForwards req = new TLRPC.TL_messages_toggleNoForwards();
        req.peer = getInputPeer(-chatId);
        req.enabled = enabled;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response != null) {
                processUpdates((TLRPC.Updates) response, false);
                AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_CHAT));
            }
        }, ConnectionsManager.RequestFlagInvokeAfter);
    }

    public void toggleChatJoinToSend(long chatId, boolean enabled, Runnable onSuccess, Runnable onError) {
        TLRPC.TL_channels_toggleJoinToSend req = new TLRPC.TL_channels_toggleJoinToSend();
        req.channel = getInputChannel(chatId);
        req.enabled = enabled;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response != null) {
                processUpdates((TLRPC.Updates) response, false);
                AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_CHAT));
                if (onSuccess != null) {
                    onSuccess.run();
                }
            } else if (error != null && !"CHAT_NOT_MODIFIED".equals(error.text)) {
                if (onError != null) {
                    onError.run();
                }
            } else {
                if (onSuccess != null) {
                    onSuccess.run();
                }
            }
        }, ConnectionsManager.RequestFlagInvokeAfter);
    }

    public void toggleChatJoinRequest(long chatId, boolean enabled, Runnable onSuccess, Runnable onError) {
        TLRPC.TL_channels_toggleJoinRequest req = new TLRPC.TL_channels_toggleJoinRequest();
        req.channel = getInputChannel(chatId);
        req.enabled = enabled;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response != null) {
                processUpdates((TLRPC.Updates) response, false);
                AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_CHAT));
                if (onSuccess != null) {
                    onSuccess.run();
                }
            } else if (error != null && !"CHAT_NOT_MODIFIED".equals(error.text)) {
                if (onError != null) {
                    onError.run();
                }
            } else {
                if (onSuccess != null) {
                    onSuccess.run();
                }
            }
        }, ConnectionsManager.RequestFlagInvokeAfter);
    }

    public void toggleChannelSignatures(long chatId, boolean signaturesEnabled, boolean profilesEnabled) {
        TLRPC.Chat chat = getChat(chatId);
        if (chat != null) {
            chat.signatures = signaturesEnabled;
            chat.signature_profiles = profilesEnabled;
            putChat(chat, true);
        }

        TLRPC.TL_channels_toggleSignatures req = new TLRPC.TL_channels_toggleSignatures();
        req.channel = getInputChannel(chatId);
        req.signatures_enabled = signaturesEnabled;
        req.profiles_enabled = profilesEnabled;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response != null) {
                processUpdates((TLRPC.Updates) response, false);
                AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_CHAT));
            }
        }, ConnectionsManager.RequestFlagInvokeAfter);

        getNotificationCenter().postNotificationName(NotificationCenter.updateAllMessages, -chatId);
    }

    public void toggleChannelForum(long chatId, boolean enabled, boolean tabsEnabled) {
        TLRPC.TL_channels_toggleForum req = new TLRPC.TL_channels_toggleForum();
        req.channel = getInputChannel(chatId);
        req.enabled = enabled;
        req.tabs = tabsEnabled;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response != null) {
                processUpdates((TLRPC.Updates) response, false);
                AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_CHAT));
            }
        }, ConnectionsManager.RequestFlagInvokeAfter);
        getNotificationCenter().postNotificationName(NotificationCenter.chatSwitchedForum, chatId, enabled, tabsEnabled);
    }

    public void toggleChannelInvitesHistory(long chatId, boolean enabled) {
        TLRPC.TL_channels_togglePreHistoryHidden req = new TLRPC.TL_channels_togglePreHistoryHidden();
        req.channel = getInputChannel(chatId);
        req.enabled = enabled;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response != null) {
                processUpdates((TLRPC.Updates) response, false);
                AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_CHAT));
            }
        }, ConnectionsManager.RequestFlagInvokeAfter);
    }

    public void updateChatAbout(long chatId, String about, TLRPC.ChatFull info) {
        TLRPC.TL_messages_editChatAbout req = new TLRPC.TL_messages_editChatAbout();
        req.peer = getInputPeer(-chatId);
        req.about = about;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response instanceof TLRPC.TL_boolTrue && info != null) {
                AndroidUtilities.runOnUIThread(() -> {
                    info.about = about;
                    getMessagesStorage().updateChatInfo(info, false);
                    getNotificationCenter().postNotificationName(NotificationCenter.chatInfoDidLoad, info, 0, false, false);
                });
            }
        }, ConnectionsManager.RequestFlagInvokeAfter);
    }

    public void updateChannelUserName(BaseFragment fragment, long chatId, String userName, Runnable runnable, Runnable onError) {
        TLRPC.TL_channels_updateUsername req = new TLRPC.TL_channels_updateUsername();
        req.channel = getInputChannel(chatId);
        req.username = userName;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response instanceof TLRPC.TL_boolTrue || error != null && "USERNAME_NOT_MODIFIED".equals(error.text)) {
                AndroidUtilities.runOnUIThread(() -> {
                    TLRPC.Chat chat = getChat(chatId);
                    boolean hasMain = false;
                    if (chat.usernames != null) {
                        for (int i = 0; i < chat.usernames.size(); ++i) {
                            TLRPC.TL_username u = chat.usernames.get(i);
                            if (u != null && u.editable) {
                                hasMain = true;
                                u.username = userName;
                                break;
                            }
                        }
                    }
                    if (!hasMain) {
                        if (chat.usernames == null || chat.usernames.size() >= 1) {
                            if (chat.usernames == null) {
                                chat.usernames = new ArrayList<>();
                            }
                            TLRPC.TL_username u = new TLRPC.TL_username();
                            u.username = userName;
                            u.active = true;
                            u.editable = true;
                            chat.usernames.add(0, u);
                        } else {
                            chat.username = userName;
                        }
                    }
                    ArrayList<TLRPC.Chat> arrayList = new ArrayList<>();
                    arrayList.add(chat);
                    getMessagesStorage().putUsersAndChats(null, arrayList, true, true);
                    getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_CHAT);
                    if (runnable != null) {
                        runnable.run();
                    }
                });
            } else {
                AlertsCreator.processError(UserConfig.selectedAccount, error, fragment, req);
                if (onError != null) {
                    onError.run();
                }
            }
        }, ConnectionsManager.RequestFlagInvokeAfter);
    }

    public void sendBotStart(final TLRPC.User user, String botHash) {
        if (user == null) {
            return;
        }
        TLRPC.TL_messages_startBot req = new TLRPC.TL_messages_startBot();
        req.bot = getInputUser(user);
        req.peer = getInputPeer(user.id);
        req.start_param = botHash;
        req.random_id = Utilities.random.nextLong();
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error != null) {
                return;
            }
            processUpdates((TLRPC.Updates) response, false);
        });
    }

    public boolean isJoiningChannel(long chatId) {
        return joiningToChannels.contains(chatId);
    }

    public void addUserToChat(long chatId, TLRPC.User user, int forwardCount, String botHash, BaseFragment fragment, Runnable onFinishRunnable) {
        addUserToChat(chatId, user, forwardCount, botHash, fragment, false, onFinishRunnable, null);
    }

    public interface ErrorDelegate {
        // if returns true, a delegate allows to show default alert
        public boolean run(TLRPC.TL_error error);
    }

    public void addUsersToChat(TLRPC.Chat currentChat, BaseFragment baseFragment, ArrayList<TLRPC.User> users, int fwdCount, Consumer<TLRPC.User> onAddUser, Consumer<TLRPC.User> onRestricted, Runnable onComplete) {
        final int count = users.size();
        final int[] processed = new int[1];
        processed[0] = 0;
        TLRPC.TL_messages_invitedUsers totalInvitedUsers = new TLRPC.TL_messages_invitedUsers();
        totalInvitedUsers.updates = new TLRPC.TL_updates();
        long chatId = currentChat.id;
        for (int a = 0; a < count; a++) {
            final TLRPC.User user = users.get(a);
            addUserToChat(chatId, user, fwdCount, null, baseFragment, false, () -> {
                if (onAddUser != null) {
                    onAddUser.accept(user);
                }
            }, err -> {
                if (onRestricted != null) {
                    onRestricted.accept(user);
                }
                return !(err != null && "USER_PRIVACY_RESTRICTED".equals(err.text));
            }, invitedUsers -> {
                if (invitedUsers != null) {
                    totalInvitedUsers.missing_invitees.addAll(invitedUsers.missing_invitees);
                }
                processed[0]++;
                if (processed[0] >= count) {
                    if (!totalInvitedUsers.missing_invitees.isEmpty()) {
                        AndroidUtilities.runOnUIThread(() -> {
                            AlertsCreator.checkRestrictedInviteUsers(currentAccount, currentChat, totalInvitedUsers);
                        });
                    }
                    if (onComplete != null) {
                        onComplete.run();
                    }
                }
            });
            putUser(user, false);
        }
    }


    public void addUserToChat(
        long chatId,
        TLRPC.User user,
        int forwardCount,
        String botHash,
        BaseFragment fragment,
        boolean ignoreIfAlreadyExists,
        Runnable onFinishRunnable,
        ErrorDelegate onError
    ) {
        addUserToChat(chatId, user, forwardCount, botHash, fragment, ignoreIfAlreadyExists, onFinishRunnable, onError, null);
    }

    public void addUserToChat(
        long chatId,
        TLRPC.User user,
        int forwardCount,
        String botHash,
        BaseFragment fragment,
        boolean ignoreIfAlreadyExists,
        Runnable onFinishRunnable,
        ErrorDelegate onError,
        Utilities.Callback<TLRPC.TL_messages_invitedUsers> processInvitedUsers
    ) {
        if (user == null) {
            if (onError != null) {
                onError.run(null);
            }
            if (processInvitedUsers != null) {
                processInvitedUsers.run(null);
            }
            return;
        }

        TLObject request;

        boolean isChannel = ChatObject.isChannel(chatId, currentAccount);
        boolean isMegagroup = isChannel && getChat(chatId).megagroup;
        TLRPC.InputUser inputUser = getInputUser(user);
        if (botHash == null || isChannel && !isMegagroup) {
            if (isChannel) {
                if (inputUser instanceof TLRPC.TL_inputUserSelf) {
                    if (joiningToChannels.contains(chatId)) {
                        if (onError != null) {
                            onError.run(null);
                        }
                        return;
                    }
                    TLRPC.TL_channels_joinChannel req = new TLRPC.TL_channels_joinChannel();
                    req.channel = getInputChannel(chatId);
                    request = req;
                    joiningToChannels.add(chatId);
                } else {
                    TLRPC.TL_channels_inviteToChannel req = new TLRPC.TL_channels_inviteToChannel();
                    req.channel = getInputChannel(chatId);
                    req.users.add(inputUser);
                    request = req;
                }
            } else {
                TLRPC.TL_messages_addChatUser req = new TLRPC.TL_messages_addChatUser();
                req.chat_id = chatId;
                req.fwd_limit = forwardCount;
                req.user_id = inputUser;
                request = req;
            }
        } else {
            TLRPC.TL_messages_startBot req = new TLRPC.TL_messages_startBot();
            req.bot = inputUser;
            if (isChannel) {
                req.peer = getInputPeer(-chatId);
            } else {
                req.peer = new TLRPC.TL_inputPeerChat();
                req.peer.chat_id = chatId;
            }
            req.start_param = botHash;
            req.random_id = Utilities.random.nextLong();
            request = req;
        }

        getConnectionsManager().sendRequest(request, (response, error) -> {
            if (isChannel && inputUser instanceof TLRPC.TL_inputUserSelf) {
                AndroidUtilities.runOnUIThread(() -> joiningToChannels.remove(chatId));
            }
            if (error != null) {
                if ("PRIVACY_PREMIUM_REQUIRED".equals(error.text)) {
                    TLRPC.TL_messages_invitedUsers invitedUsers = new TLRPC.TL_messages_invitedUsers();
                    invitedUsers.updates = new TLRPC.TL_updates();
                    TLRPC.TL_missingInvitee missingInvitee = new TLRPC.TL_missingInvitee();
                    missingInvitee.user_id = user.id;
                    missingInvitee.premium_would_allow_invite = true;
                    missingInvitee.premium_required_for_pm = true;
                    invitedUsers.missing_invitees.add(missingInvitee);
                    AndroidUtilities.runOnUIThread(() -> {
                        if (processInvitedUsers != null) {
                            processInvitedUsers.run(invitedUsers);
                        } else {
                            AlertsCreator.checkRestrictedInviteUsers(currentAccount, getChat(chatId), invitedUsers);
                        }
                    });
                    return;
                }
                AndroidUtilities.runOnUIThread(() -> {
                    if (processInvitedUsers != null) {
                        processInvitedUsers.run(null);
                    }
                });
                if ("USER_ALREADY_PARTICIPANT".equals(error.text) && ignoreIfAlreadyExists) {
                    if (onFinishRunnable != null) {
                        AndroidUtilities.runOnUIThread(onFinishRunnable);
                    }
                    return;
                }
                if (onError != null) {
                    AndroidUtilities.runOnUIThread(() -> {
                        boolean handleErrors = onError.run(error);
                        if (handleErrors) {
                            AlertsCreator.processError(currentAccount, error, fragment, request, isChannel && !isMegagroup);
                        }
                    });
                }
                AndroidUtilities.runOnUIThread(() -> {
                    if (onError == null) {
                        AlertsCreator.processError(currentAccount, error, fragment, request, isChannel && !isMegagroup);
                    }
                    if (isChannel && inputUser instanceof TLRPC.TL_inputUserSelf) {
                        getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_CHAT);
                    }
                });
                return;
            }
            boolean hasJoinMessage = false;
            TLRPC.Updates updates;
            TLRPC.TL_messages_invitedUsers invitedUsers;
            if (response instanceof TLRPC.TL_messages_invitedUsers) {
                invitedUsers = (TLRPC.TL_messages_invitedUsers) response;
                updates = invitedUsers.updates;
            } else if (response instanceof TLRPC.Updates) {
                invitedUsers = null;
                updates = (TLRPC.Updates) response;
            } else {
                FileLog.e("unexpected " + response + " in addUserToChat");
                AndroidUtilities.runOnUIThread(() -> {
                    if (processInvitedUsers != null) {
                        processInvitedUsers.run(null);
                    }
                });
                return;
            }
            for (int a = 0; a < updates.updates.size(); a++) {
                TLRPC.Update update = updates.updates.get(a);
                if (update instanceof TLRPC.TL_updateNewChannelMessage) {
                    if (((TLRPC.TL_updateNewChannelMessage) update).message.action instanceof TLRPC.TL_messageActionChatAddUser) {
                        hasJoinMessage = true;
                        break;
                    }
                }
            }
            processUpdates(updates, false);
            if (invitedUsers != null && !invitedUsers.missing_invitees.isEmpty()) {
                AndroidUtilities.runOnUIThread(() -> {
                    putUsers(updates.users, false);
                    putChats(updates.chats, false);
                    if (processInvitedUsers != null) {
                        processInvitedUsers.run(invitedUsers);
                    } else {
                        AlertsCreator.checkRestrictedInviteUsers(currentAccount, getChat(chatId), invitedUsers);
                    }
                });
                return;
            }
            if (isChannel) {
                if (!hasJoinMessage && inputUser instanceof TLRPC.TL_inputUserSelf) {
                    generateJoinMessage(chatId, true);
                }
                AndroidUtilities.runOnUIThread(() -> loadFullChat(chatId, 0, true), 1000);
            }
            if (isChannel && inputUser instanceof TLRPC.TL_inputUserSelf) {
                getMessagesStorage().updateDialogsWithDeletedMessages(-chatId, chatId, new ArrayList<>(), null, true);
            }
            if (onFinishRunnable != null) {
                AndroidUtilities.runOnUIThread(onFinishRunnable);
            }
            if (processInvitedUsers != null) {
                AndroidUtilities.runOnUIThread(() -> processInvitedUsers.run(null));
            }
        });
    }

    public void deleteParticipantFromChat(long chatId, TLRPC.User user) {
        deleteParticipantFromChat(chatId, user, null, false, false);
    }

    public void deleteParticipantFromChat(long chatId, TLRPC.InputPeer peer) {
        deleteParticipantFromChat(chatId, peer, false, false);
    }

    public void deleteParticipantFromChat(long chatId, TLRPC.InputPeer peer, boolean forceDelete, boolean revoke) {
        deleteParticipantFromChat(chatId, peer, forceDelete, revoke, null);
    }

    public void deleteParticipantFromChat(long chatId, TLRPC.InputPeer peer, boolean forceDelete, boolean revoke, Runnable whenDone) {
        if (peer == null) {
            return;
        }
        TLObject request;
        TLRPC.Chat ownerChat = getChat(chatId);
        boolean self = peer instanceof TLRPC.TL_inputPeerUser && UserObject.isUserSelf(getMessagesController().getUser(peer.user_id));
        boolean isChannel = ChatObject.isChannel(ownerChat);
        if (isChannel) {
            if (self) {
                if (ownerChat.creator && forceDelete) {
                    TLRPC.TL_channels_deleteChannel req = new TLRPC.TL_channels_deleteChannel();
                    req.channel = getInputChannel(ownerChat);
                    request = req;
                } else {
                    TLRPC.TL_channels_leaveChannel req = new TLRPC.TL_channels_leaveChannel();
                    req.channel = getInputChannel(ownerChat);
                    request = req;
                }
            } else {
                TLRPC.TL_channels_editBanned req = new TLRPC.TL_channels_editBanned();
                req.channel = getInputChannel(ownerChat);
                req.participant = peer;
                req.banned_rights = new TLRPC.TL_chatBannedRights();
                req.banned_rights.view_messages = true;
                req.banned_rights.send_media = true;
                req.banned_rights.send_messages = true;
                req.banned_rights.send_stickers = true;
                req.banned_rights.send_gifs = true;
                req.banned_rights.send_games = true;
                req.banned_rights.send_inline = true;
                req.banned_rights.embed_links = true;
                req.banned_rights.pin_messages = true;
                req.banned_rights.send_polls = true;
                req.banned_rights.invite_users = true;
                req.banned_rights.change_info = true;
                request = req;
            }
        } else {
            if (forceDelete) {
                TLRPC.TL_messages_deleteChat req = new TLRPC.TL_messages_deleteChat();
                req.chat_id = chatId;
                getConnectionsManager().sendRequest(req, (response, error) -> {
                });
                return;
            }
            TLRPC.TL_messages_deleteChatUser req = new TLRPC.TL_messages_deleteChatUser();
            req.chat_id = chatId;
            req.user_id = (TLRPC.InputUser) getInputUser(peer);
            req.revoke_history = true;
            request = req;
        }
        if (self) {
            deleteDialog(-chatId, 0, revoke);
        }
        getConnectionsManager().sendRequest(request, (response, error) -> {
            if (error != null) {
                return;
            }
            TLRPC.Updates updates = (TLRPC.Updates) response;
            processUpdates(updates, false);
            if (isChannel && !self) {
                AndroidUtilities.runOnUIThread(() -> loadFullChat(chatId, 0, true), 1000);
            }
            if (whenDone != null) {
                AndroidUtilities.runOnUIThread(whenDone);
            }
        }, ConnectionsManager.RequestFlagInvokeAfter);
    }

    public void deleteParticipantFromChat(long chatId, TLRPC.User user, TLRPC.Chat chat, boolean forceDelete, boolean revoke) {
        if (user == null && chat == null) {
            return;
        }
        TLRPC.InputPeer inputPeer;
        if (user != null) {
            inputPeer = getInputPeer(user);
        } else {
            inputPeer = getInputPeer(chat);
        }
        TLObject request;
        TLRPC.Chat ownerChat = getChat(chatId);
        boolean isChannel = ChatObject.isChannel(ownerChat);
        if (isChannel) {
            if (UserObject.isUserSelf(user)) {
                if (ownerChat.creator && forceDelete) {
                    TLRPC.TL_channels_deleteChannel req = new TLRPC.TL_channels_deleteChannel();
                    req.channel = getInputChannel(ownerChat);
                    request = req;
                } else {
                    TLRPC.TL_channels_leaveChannel req = new TLRPC.TL_channels_leaveChannel();
                    req.channel = getInputChannel(ownerChat);
                    request = req;
                }
            } else {
                TLRPC.TL_channels_editBanned req = new TLRPC.TL_channels_editBanned();
                req.channel = getInputChannel(ownerChat);
                req.participant = inputPeer;
                req.banned_rights = new TLRPC.TL_chatBannedRights();
                req.banned_rights.view_messages = true;
                req.banned_rights.send_media = true;
                req.banned_rights.send_messages = true;
                req.banned_rights.send_stickers = true;
                req.banned_rights.send_gifs = true;
                req.banned_rights.send_games = true;
                req.banned_rights.send_inline = true;
                req.banned_rights.embed_links = true;
                req.banned_rights.pin_messages = true;
                req.banned_rights.send_polls = true;
                req.banned_rights.invite_users = true;
                req.banned_rights.change_info = true;
                request = req;
            }
        } else {
            if (forceDelete) {
                TLRPC.TL_messages_deleteChat req = new TLRPC.TL_messages_deleteChat();
                req.chat_id = chatId;
                getConnectionsManager().sendRequest(req, (response, error) -> {

                });
                return;
            }
            TLRPC.TL_messages_deleteChatUser req = new TLRPC.TL_messages_deleteChatUser();
            req.chat_id = chatId;
            req.user_id = getInputUser(user);
            req.revoke_history = true;
            request = req;
        }
        if (UserObject.isUserSelf(user)) {
            deleteDialog(-chatId, 0, revoke);
        }
        getConnectionsManager().sendRequest(request, (response, error) -> {
            if (error != null) {
                return;
            }
            TLRPC.Updates updates = (TLRPC.Updates) response;
            processUpdates(updates, false);
            if (isChannel && !UserObject.isUserSelf(user)) {
                AndroidUtilities.runOnUIThread(() -> loadFullChat(chatId, 0, true), 1000);
            }
        }, ConnectionsManager.RequestFlagInvokeAfter);
    }

    public void changeChatTitle(long chatId, String title) {
        TLObject request;
        if (ChatObject.isChannel(chatId, currentAccount)) {
            TLRPC.TL_channels_editTitle req = new TLRPC.TL_channels_editTitle();
            req.channel = getInputChannel(chatId);
            req.title = title;
            request = req;
        } else {
            TLRPC.TL_messages_editChatTitle req = new TLRPC.TL_messages_editChatTitle();
            req.chat_id = chatId;
            req.title = title;
            request = req;
        }
        getConnectionsManager().sendRequest(request, (response, error) -> {
            if (error != null) {
                return;
            }
            processUpdates((TLRPC.Updates) response, false);
        }, ConnectionsManager.RequestFlagInvokeAfter);
    }

    public void changeChatAvatar(long chatId, TLRPC.TL_inputChatPhoto oldPhoto, TLRPC.InputFile inputPhoto, TLRPC.InputFile inputVideo, TLRPC.VideoSize emojiMarkup, double videoStartTimestamp, String videoPath, TLRPC.FileLocation smallSize, TLRPC.FileLocation bigSize, Runnable callback) {
        TLObject request;
        TLRPC.InputChatPhoto inputChatPhoto;
        if (oldPhoto != null) {
            inputChatPhoto = oldPhoto;
        } else if (inputPhoto != null || inputVideo != null || emojiMarkup != null) {
            TLRPC.TL_inputChatUploadedPhoto uploadedPhoto = new TLRPC.TL_inputChatUploadedPhoto();
            if (inputPhoto != null) {
                uploadedPhoto.file = inputPhoto;
                uploadedPhoto.flags |= 1;
            }
            if (inputVideo != null) {
                uploadedPhoto.video = inputVideo;
                uploadedPhoto.flags |= 2;
                uploadedPhoto.video_start_ts = videoStartTimestamp;
                uploadedPhoto.flags |= 4;
            }
            if (emojiMarkup != null) {
                uploadedPhoto.video_emoji_markup = emojiMarkup;
                uploadedPhoto.flags |= 8;
            }
            inputChatPhoto = uploadedPhoto;
        } else {
            inputChatPhoto = new TLRPC.TL_inputChatPhotoEmpty();
        }
        if (ChatObject.isChannel(chatId, currentAccount)) {
            TLRPC.TL_channels_editPhoto req = new TLRPC.TL_channels_editPhoto();
            req.channel = getInputChannel(chatId);
            req.photo = inputChatPhoto;
            request = req;
        } else {
            TLRPC.TL_messages_editChatPhoto req = new TLRPC.TL_messages_editChatPhoto();
            req.chat_id = chatId;
            req.photo = inputChatPhoto;
            request = req;
        }
        getConnectionsManager().sendRequest(request, (response, error) -> {
            if (error != null) {
                return;
            }
            TLRPC.Updates updates = (TLRPC.Updates) response;
            if (oldPhoto == null) {
                TLRPC.Photo photo = null;
                for (int a = 0, N = updates.updates.size(); a < N; a++) {
                    TLRPC.Update update = updates.updates.get(a);
                    if (update instanceof TLRPC.TL_updateNewChannelMessage) {
                        TLRPC.Message message = ((TLRPC.TL_updateNewChannelMessage) update).message;
                        if (message.action instanceof TLRPC.TL_messageActionChatEditPhoto && message.action.photo instanceof TLRPC.TL_photo) {
                            photo = message.action.photo;
                            break;
                        }
                    } else if (update instanceof TLRPC.TL_updateNewMessage) {
                        TLRPC.Message message = ((TLRPC.TL_updateNewMessage) update).message;
                        if (message.action instanceof TLRPC.TL_messageActionChatEditPhoto && message.action.photo instanceof TLRPC.TL_photo) {
                            photo = message.action.photo;
                            break;
                        }
                    }
                }
                if (photo != null) {
                    TLRPC.PhotoSize small = FileLoader.getClosestPhotoSizeWithSize(photo.sizes, 150);
                    TLRPC.VideoSize videoSize = photo.video_sizes.isEmpty() ? null : photo.video_sizes.get(0);
                    if (small != null && smallSize != null) {
                        File destFile = getFileLoader().getPathToAttach(small, true);
                        File src = getFileLoader().getPathToAttach(smallSize, true);
                        src.renameTo(destFile);
                        String oldKey = smallSize.volume_id + "_" + smallSize.local_id + "@50_50";
                        String newKey = small.location.volume_id + "_" + small.location.local_id + "@50_50";
                        ImageLoader.getInstance().replaceImageInCache(oldKey, newKey, ImageLocation.getForPhoto(small, photo), true);
                    }
                    TLRPC.PhotoSize big = FileLoader.getClosestPhotoSizeWithSize(photo.sizes, 800);
                    if (big != null && bigSize != null) {
                        File destFile = getFileLoader().getPathToAttach(big, true);
                        File src = getFileLoader().getPathToAttach(bigSize, true);
                        src.renameTo(destFile);
                    }
                    if (videoSize != null && videoPath != null) {
                        File destFile = getFileLoader().getPathToAttach(videoSize, "mp4", true);
                        File src = new File(videoPath);
                        src.renameTo(destFile);
                    }
                    getDialogPhotos(-chatId).addPhotoAtStart(photo);
                }
            }
            processUpdates(updates, false);
            AndroidUtilities.runOnUIThread(() -> {
                if (callback != null) {
                    callback.run();
                }
                getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, MessagesController.UPDATE_MASK_AVATAR);
                getNotificationCenter().postNotificationName(NotificationCenter.reloadDialogPhotos);
            });
        }, ConnectionsManager.RequestFlagInvokeAfter);
    }

    public void unregistedPush() {
        if (getUserConfig().registeredForPush && SharedConfig.pushString.length() == 0) {
            TL_account.unregisterDevice req = new TL_account.unregisterDevice();
            req.token = SharedConfig.pushString;
            req.token_type = SharedConfig.pushType;
            for (int a = 0; a < UserConfig.MAX_ACCOUNT_COUNT; a++) {
                UserConfig userConfig = UserConfig.getInstance(a);
                if (a != currentAccount && userConfig.isClientActivated()) {
                    req.other_uids.add(userConfig.getClientUserId());
                }
            }
            getConnectionsManager().sendRequest(req, (response, error) -> {

            });
        }
    }

    public void performLogout(int type) {
        if (type == 1) {
            unregistedPush();
            TLRPC.TL_auth_logOut req = new TLRPC.TL_auth_logOut();
            getConnectionsManager().sendRequest(req, (response, error) -> {
                getConnectionsManager().cleanup(false);
                AndroidUtilities.runOnUIThread(() -> {
                    if (response instanceof TLRPC.TL_auth_loggedOut) {
                        if (((TLRPC.TL_auth_loggedOut) response).future_auth_token != null) {
                            AuthTokensHelper.addLogOutToken((TLRPC.TL_auth_loggedOut) response);
                        }
                    }
                });
            });
        } else {
            getConnectionsManager().cleanup(type == 2);
        }
        getUserConfig().clearConfig();
        SharedPrefsHelper.cleanupAccount(currentAccount);

        boolean shouldHandle = true;
        ArrayList<NotificationCenter.NotificationCenterDelegate> observers = getNotificationCenter().getObservers(NotificationCenter.appDidLogout);
        if (observers != null) {
            for (int a = 0, N = observers.size(); a < N; a++) {
                if (observers.get(a) instanceof LaunchActivity) {
                    shouldHandle = false;
                    break;
                }
            }
        }
        if (shouldHandle) {
            if (UserConfig.selectedAccount == currentAccount) {
                int account = -1;
                for (int a = 0; a < UserConfig.MAX_ACCOUNT_COUNT; a++) {
                    if (UserConfig.getInstance(a).isClientActivated()) {
                        account = a;
                        break;
                    }
                }
                if (account != -1) {
                    UserConfig.selectedAccount = account;
                    UserConfig.getInstance(0).saveConfig(false);
                    LaunchActivity.clearFragments();
                }
            }
        }
        getNotificationCenter().postNotificationName(NotificationCenter.appDidLogout);
        getMessagesStorage().cleanup(false);
        cleanup();
        getContactsController().deleteUnknownAppAccounts();
    }

    public void registerForPush(@PushListenerController.PushType int pushType, String regid) {
        if (TextUtils.isEmpty(regid) || registeringForPush || getUserConfig().getClientUserId() == 0) {
            return;
        }
        if (getUserConfig().registeredForPush && regid.equals(SharedConfig.pushString)) {
            return;
        }
        registeringForPush = true;
        lastPushRegisterSendTime = SystemClock.elapsedRealtime();
        if (SharedConfig.pushAuthKey == null) {
            SharedConfig.pushAuthKey = new byte[256];
            Utilities.random.nextBytes(SharedConfig.pushAuthKey);
            SharedConfig.saveConfig();
        }
        TL_account.registerDevice req = new TL_account.registerDevice();
        req.token_type = pushType;
        req.token = regid;
        req.no_muted = false;
        req.secret = SharedConfig.pushAuthKey;
        for (int a = 0; a < UserConfig.MAX_ACCOUNT_COUNT; a++) {
            UserConfig userConfig = UserConfig.getInstance(a);
            if (a != currentAccount && userConfig.isClientActivated()) {
                long uid = userConfig.getClientUserId();
                req.other_uids.add(uid);
                if (BuildVars.LOGS_ENABLED) {
                    FileLog.d("add other uid = " + uid + " for account " + currentAccount);
                }
            }
        }
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response instanceof TLRPC.TL_boolTrue) {
                if (BuildVars.LOGS_ENABLED) {
                    FileLog.d("account " + currentAccount + " registered for push, push type: " + pushType);
                }
                getUserConfig().registeredForPush = true;
                SharedConfig.pushString = regid;
                SharedConfig.pushType = pushType;
                getUserConfig().saveConfig(false);
            }
            AndroidUtilities.runOnUIThread(() -> registeringForPush = false);
        });
    }

    public void loadCurrentState() {
        if (updatingState) {
            return;
        }
        updatingState = true;
        TLRPC.TL_updates_getState req = new TLRPC.TL_updates_getState();
        getConnectionsManager().sendRequest(req, (response, error) -> {
            updatingState = false;
            if (error == null) {
                TLRPC.TL_updates_state res = (TLRPC.TL_updates_state) response;
                getMessagesStorage().setLastDateValue(res.date);
                getMessagesStorage().setLastPtsValue(res.pts);
                getMessagesStorage().setLastSeqValue(res.seq);
                getMessagesStorage().setLastQtsValue(res.qts);
                for (int a = 0; a < 3; a++) {
                    processUpdatesQueue(a, 2);
                }
                getMessagesStorage().saveDiffParams(getMessagesStorage().getLastSeqValue(), getMessagesStorage().getLastPtsValue(), getMessagesStorage().getLastDateValue(), getMessagesStorage().getLastQtsValue());
            } else {
                if (error.code != 401) {
                    loadCurrentState();
                }
            }
        });
    }

    private int getUpdateSeq(TLRPC.Updates updates) {
        if (updates instanceof TLRPC.TL_updatesCombined) {
            return updates.seq_start;
        } else {
            return updates.seq;
        }
    }

    private void setUpdatesStartTime(int type, long time) {
        if (type == 0) {
            updatesStartWaitTimeSeq = time;
        } else if (type == 1) {
            updatesStartWaitTimePts = time;
        } else if (type == 2) {
            updatesStartWaitTimeQts = time;
        }
    }

    public long getUpdatesStartTime(int type) {
        if (type == 0) {
            return updatesStartWaitTimeSeq;
        } else if (type == 1) {
            return updatesStartWaitTimePts;
        } else if (type == 2) {
            return updatesStartWaitTimeQts;
        }
        return 0;
    }

    private int isValidUpdate(TLRPC.Updates updates, int type) {
        if (type == 0) {
            int seq = getUpdateSeq(updates);
            if (getMessagesStorage().getLastSeqValue() + 1 == seq || getMessagesStorage().getLastSeqValue() == seq) {
                return 0;
            } else if (getMessagesStorage().getLastSeqValue() < seq) {
                return 1;
            } else {
                return 2;
            }
        } else if (type == 1) {
            if (updates.pts <= getMessagesStorage().getLastPtsValue()) {
                return 2;
            } else if (getMessagesStorage().getLastPtsValue() + updates.pts_count == updates.pts) {
                return 0;
            } else {
                return 1;
            }
        } else if (type == 2) {
            if (updates.pts <= getMessagesStorage().getLastQtsValue()) {
                return 2;
            } else if (getMessagesStorage().getLastQtsValue() + updates.updates.size() == updates.pts) {
                return 0;
            } else {
                return 1;
            }
        }
        return 0;
    }

    private void processChannelsUpdatesQueue(long channelId, int state) {
        ArrayList<TLRPC.Updates> updatesQueue = updatesQueueChannels.get(channelId);
        if (updatesQueue == null) {
            return;
        }
        int channelPts = channelsPts.get(channelId);
        if (updatesQueue.isEmpty() || channelPts == 0) {
            updatesQueueChannels.remove(channelId);
            return;
        }
        Collections.sort(updatesQueue, (updates, updates2) -> AndroidUtilities.compare(updates.pts, updates2.pts));
        boolean anyProceed = false;
        if (state == 2) {
            channelsPts.put(channelId, updatesQueue.get(0).pts);
        }
        for (int a = 0; a < updatesQueue.size(); a++) {
            TLRPC.Updates updates = updatesQueue.get(a);
            int updateState;
            if (updates.pts <= channelPts) {
                updateState = 2;
            } else if (channelPts + updates.pts_count == updates.pts) {
                updateState = 0;
            } else {
                updateState = 1;
            }
            if (updateState == 0) {
                processUpdates(updates, true);
                anyProceed = true;
                if (a >= updatesQueue.size()) break;
                updatesQueue.remove(a);
                a--;
            } else if (updateState == 1) {
                long updatesStartWaitTime = updatesStartWaitTimeChannels.get(channelId);
                if (updatesStartWaitTime != 0 && (anyProceed || Math.abs(System.currentTimeMillis() - updatesStartWaitTime) <= 1500)) {
                    if (BuildVars.LOGS_ENABLED) {
                        FileLog.d("HOLE IN CHANNEL " + channelId + " UPDATES QUEUE - will wait more time");
                    }
                    if (anyProceed) {
                        updatesStartWaitTimeChannels.put(channelId, System.currentTimeMillis());
                    }
                } else {
                    if (BuildVars.LOGS_ENABLED) {
                        FileLog.d("HOLE IN CHANNEL " + channelId + " UPDATES QUEUE - getChannelDifference ");
                    }
                    updatesStartWaitTimeChannels.delete(channelId);
                    updatesQueueChannels.remove(channelId);
                    getChannelDifference(channelId);
                }
                return;
            } else {
                if (a >= updatesQueue.size()) break;
                updatesQueue.remove(a);
                a--;
            }
        }
        updatesQueueChannels.remove(channelId);
        updatesStartWaitTimeChannels.delete(channelId);
        if (BuildVars.LOGS_ENABLED) {
            FileLog.d("UPDATES CHANNEL " + channelId + " QUEUE PROCEED - OK");
        }
    }

    private void processUpdatesQueue(int type, int state) {
        ArrayList<TLRPC.Updates> updatesQueue = null;
        if (type == 0) {
            updatesQueue = updatesQueueSeq;
            Collections.sort(updatesQueue, (updates, updates2) -> AndroidUtilities.compare(getUpdateSeq(updates), getUpdateSeq(updates2)));
        } else if (type == 1) {
            updatesQueue = updatesQueuePts;
            Collections.sort(updatesQueue, (updates, updates2) -> AndroidUtilities.compare(updates.pts, updates2.pts));
        } else if (type == 2) {
            updatesQueue = updatesQueueQts;
            Collections.sort(updatesQueue, (updates, updates2) -> AndroidUtilities.compare(updates.pts, updates2.pts));
        }
        if (updatesQueue != null && !updatesQueue.isEmpty()) {
            boolean anyProceed = false;
            if (state == 2) {
                TLRPC.Updates updates = updatesQueue.get(0);
                if (type == 0) {
                    getMessagesStorage().setLastSeqValue(getUpdateSeq(updates));
                } else if (type == 1) {
                    getMessagesStorage().setLastPtsValue(updates.pts);
                } else {
                    getMessagesStorage().setLastQtsValue(updates.pts);
                }
            }
            for (int a = 0; a < updatesQueue.size(); a++) {
                TLRPC.Updates updates = updatesQueue.get(a);
                int updateState = isValidUpdate(updates, type);
                if (updateState == 0) {
                    processUpdates(updates, true);
                    anyProceed = true;
                    updatesQueue.remove(a);
                    a--;
                } else if (updateState == 1) {
                    if (getUpdatesStartTime(type) != 0 && (anyProceed || Math.abs(System.currentTimeMillis() - getUpdatesStartTime(type)) <= 1500)) {
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("HOLE IN UPDATES QUEUE - will wait more time");
                        }
                        if (anyProceed) {
                            setUpdatesStartTime(type, System.currentTimeMillis());
                        }
                    } else {
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("HOLE IN UPDATES QUEUE - getDifference");
                        }
                        setUpdatesStartTime(type, 0);
                        updatesQueue.clear();
                        getDifference();
                    }
                    return;
                } else {
                    updatesQueue.remove(a);
                    a--;
                }
            }
            updatesQueue.clear();
            if (BuildVars.LOGS_ENABLED) {
                FileLog.d("UPDATES QUEUE PROCEED - OK");
            }
        }
        setUpdatesStartTime(type, 0);
    }

    protected void loadUnknownChannel(final TLRPC.Chat channel, long taskId) {
        if (!(channel instanceof TLRPC.TL_channel) || gettingUnknownChannels.indexOfKey(channel.id) >= 0) {
            return;
        }
        if (channel.access_hash == 0) {
            if (taskId != 0) {
                getMessagesStorage().removePendingTask(taskId);
            }
            return;
        }
        TLRPC.TL_inputPeerChannel inputPeer = new TLRPC.TL_inputPeerChannel();
        inputPeer.channel_id = channel.id;
        inputPeer.access_hash = channel.access_hash;

        gettingUnknownChannels.put(channel.id, true);

        TLRPC.TL_messages_getPeerDialogs req = new TLRPC.TL_messages_getPeerDialogs();
        TLRPC.TL_inputDialogPeer inputDialogPeer = new TLRPC.TL_inputDialogPeer();
        inputDialogPeer.peer = inputPeer;
        req.peers.add(inputDialogPeer);
        long newTaskId;
        if (taskId == 0) {
            NativeByteBuffer data = null;
            try {
                data = new NativeByteBuffer(4 + channel.getObjectSize());
                data.writeInt32(0);
                channel.serializeToStream(data);
            } catch (Exception e) {
                FileLog.e(e);
            }
            newTaskId = getMessagesStorage().createPendingTask(data);
        } else {
            newTaskId = taskId;
        }
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response != null) {
                TLRPC.TL_messages_peerDialogs res = (TLRPC.TL_messages_peerDialogs) response;
                if (!res.dialogs.isEmpty() && !res.chats.isEmpty()) {
                    TLRPC.TL_dialog dialog = (TLRPC.TL_dialog) res.dialogs.get(0);
                    TLRPC.TL_messages_dialogs dialogs = new TLRPC.TL_messages_dialogs();
                    dialogs.dialogs.addAll(res.dialogs);
                    dialogs.messages.addAll(res.messages);
                    dialogs.users.addAll(res.users);
                    dialogs.chats.addAll(res.chats);
                    processLoadedDialogs(dialogs, null, null, dialog.folder_id, 0, 1, DIALOGS_LOAD_TYPE_CHANNEL, false, false, false);
                }
            }
            if (newTaskId != 0) {
                getMessagesStorage().removePendingTask(newTaskId);
            }
            gettingUnknownChannels.delete(channel.id);
        });
    }

    public void startShortPoll(TLRPC.Chat chat, int guid, boolean stop) {
        startShortPoll(chat, guid, stop, null);
    }
    public void startShortPoll(TLRPC.Chat chat, int guid, boolean stop, Consumer<Boolean> needPollConsumer) {
        if (chat == null) {
            return;
        }
        Utilities.stageQueue.postRunnable(() -> {
            ArrayList<Integer> guids = needShortPollChannels.get(chat.id);
            ArrayList<Integer> onlineGuids = needShortPollOnlines.get(chat.id);
            if (stop) {
                if (guids != null) {
                    guids.remove((Integer) guid);
                }
                if (guids == null || guids.isEmpty()) {
                    needShortPollChannels.delete(chat.id);
                }
                if (chat.megagroup) {
                    if (onlineGuids != null) {
                        onlineGuids.remove((Integer) guid);
                    }
                    if (onlineGuids == null || onlineGuids.isEmpty()) {
                        needShortPollOnlines.delete(chat.id);
                    }
                }
            } else {
                if (guids == null) {
                    guids = new ArrayList<>();
                    needShortPollChannels.put(chat.id, guids);
                }
                if (!guids.contains(guid)) {
                    guids.add(guid);
                }
                if (shortPollChannels.indexOfKey(chat.id) < 0) {
                    if (needPollConsumer != null) {
                        AndroidUtilities.runOnUIThread(() -> {
                            needPollConsumer.accept(true);
                        });
                    }
                    getChannelDifference(chat.id, 3, 0, null);
                } else {
                    if (needPollConsumer != null) {
                        AndroidUtilities.runOnUIThread(() -> {
                            needPollConsumer.accept(false);
                        });
                    }
                }

                if (chat.megagroup && !chat.monoforum) {
                    if (onlineGuids == null) {
                        onlineGuids = new ArrayList<>();
                        needShortPollOnlines.put(chat.id, onlineGuids);
                    }
                    if (!onlineGuids.contains(guid)) {
                        onlineGuids.add(guid);
                    }
                    if (shortPollOnlines.indexOfKey(chat.id) < 0) {
                        shortPollOnlines.put(chat.id, 0);
                    }
                }
            }
        });
    }

    private void getChannelDifference(long channelId) {
        getChannelDifference(channelId, 0, 0, null);
    }

    public static boolean isSupportUser(TLRPC.User user) {
        return user != null && (user.support || user.id == 777000 ||
                user.id == 333000 || user.id == 4240000 || user.id == 4244000 ||
                user.id == 4245000 || user.id == 4246000 || user.id == 410000 ||
                user.id == 420000 || user.id == 431000 || user.id == 431415000 ||
                user.id == 434000 || user.id == 4243000 || user.id == 439000 ||
                user.id == 449000 || user.id == 450000 || user.id == 452000 ||
                user.id == 454000 || user.id == 4254000 || user.id == 455000 ||
                user.id == 460000 || user.id == 470000 || user.id == 479000 ||
                user.id == 796000 || user.id == 482000 || user.id == 490000 ||
                user.id == 496000 || user.id == 497000 || user.id == 498000 ||
                user.id == 4298000);
    }

    protected void getChannelDifference(long channelId, int newDialogType, long taskId, TLRPC.InputChannel inputChannel) {
        boolean gettingDifferenceChannel = gettingDifferenceChannels.get(channelId, false);
        if (gettingDifferenceChannel) {
            return;
        }
        int limit = 100;
        int channelPts;
        if (newDialogType == 1) {
            channelPts = channelsPts.get(channelId);
            if (channelPts != 0) {
                AndroidUtilities.runOnUIThread(() -> {
                    NotificationCenter.getInstance(currentAccount).postNotificationName(NotificationCenter.onReceivedChannelDifference, channelId);
                });
                return;
            }
            channelPts = 1;
            limit = 1;
        } else {
            channelPts = channelsPts.get(channelId);
            if (channelPts == 0) {
                channelPts = getMessagesStorage().getChannelPtsSync(channelId);
                if (channelPts != 0) {
                    channelsPts.put(channelId, channelPts);
                }
                if (channelPts == 0 && (newDialogType == 2 || newDialogType == 3)) {
                    AndroidUtilities.runOnUIThread(() -> {
                        NotificationCenter.getInstance(currentAccount).postNotificationName(NotificationCenter.onReceivedChannelDifference, channelId);
                    });
                    return;
                }
            }
            if (channelPts == 0) {
                AndroidUtilities.runOnUIThread(() -> {
                    NotificationCenter.getInstance(currentAccount).postNotificationName(NotificationCenter.onReceivedChannelDifference, channelId);
                });
                return;
            }
        }

        if (inputChannel == null) {
            TLRPC.Chat chat = getChat(channelId);
            if (chat == null) {
                chat = getMessagesStorage().getChatSync(channelId);
                if (chat != null) {
                    putChat(chat, true);
                }
            }
            inputChannel = getInputChannel(chat);
        }
        if (inputChannel.access_hash == 0) {
            if (taskId != 0) {
                getMessagesStorage().removePendingTask(taskId);
            }
            AndroidUtilities.runOnUIThread(() -> {
                NotificationCenter.getInstance(currentAccount).postNotificationName(NotificationCenter.onReceivedChannelDifference, channelId);
            });
            return;
        }
        long newTaskId;
        if (taskId == 0) {
            NativeByteBuffer data = null;
            try {
                data = new NativeByteBuffer(16 + inputChannel.getObjectSize());
                data.writeInt32(25);
                data.writeInt64(channelId);
                data.writeInt32(newDialogType);
                inputChannel.serializeToStream(data);
            } catch (Exception e) {
                FileLog.e(e);
            }
            newTaskId = getMessagesStorage().createPendingTask(data);
        } else {
            newTaskId = taskId;
        }

        gettingDifferenceChannels.put(channelId, true);
        TLRPC.TL_updates_getChannelDifference req = new TLRPC.TL_updates_getChannelDifference();
        req.channel = inputChannel;
        req.filter = new TLRPC.TL_channelMessagesFilterEmpty();
        req.pts = channelPts;
        req.limit = limit;
        req.force = newDialogType != 3;
        if (BuildVars.LOGS_ENABLED) {
            FileLog.d("start getChannelDifference with pts = " + channelPts + " channelId = " + channelId);
        }
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response != null) {
                TLRPC.updates_ChannelDifference res = (TLRPC.updates_ChannelDifference) response;

                LongSparseArray<TLRPC.User> usersDict = new LongSparseArray<>();
                for (int a = 0; a < res.users.size(); a++) {
                    TLRPC.User user = res.users.get(a);
                    usersDict.put(user.id, user);
                }
                TLRPC.Chat channel = null;
                for (int a = 0; a < res.chats.size(); a++) {
                    TLRPC.Chat chat = res.chats.get(a);
                    if (chat.id == channelId) {
                        channel = chat;
                        break;
                    }
                }
                TLRPC.Chat channelFinal = channel;

                ArrayList<TLRPC.TL_updateMessageID> msgUpdates = new ArrayList<>();
                if (!res.other_updates.isEmpty()) {
                    for (int a = 0; a < res.other_updates.size(); a++) {
                        TLRPC.Update upd = res.other_updates.get(a);
                        if (upd instanceof TLRPC.TL_updateMessageID) {
                            msgUpdates.add((TLRPC.TL_updateMessageID) upd);
                            res.other_updates.remove(a);
                            a--;
                        }
                    }
                }

                getMessagesStorage().putUsersAndChats(res.users, res.chats, true, true);
                AndroidUtilities.runOnUIThread(() -> {
                    putUsers(res.users, false);
                    putChats(res.chats, false);
                });

                getMessagesStorage().getStorageQueue().postRunnable(() -> {
                    if (!msgUpdates.isEmpty()) {
                        SparseArray<long[]> corrected = new SparseArray<>();
                        for (TLRPC.TL_updateMessageID update : msgUpdates) {
                            long[] ids = getMessagesStorage().updateMessageStateAndId(update.random_id, -channelId, null, update.id, 0, false, -1, 0);
                            if (ids != null) {
                                corrected.put(update.id, ids);
                            }
                        }

                        if (corrected.size() != 0) {
                            AndroidUtilities.runOnUIThread(() -> {
                                for (int a = 0; a < corrected.size(); a++) {
                                    int newId = corrected.keyAt(a);
                                    long[] ids = corrected.valueAt(a);
                                    getSendMessagesHelper().processSentMessage((int) ids[1]);
                                    getNotificationCenter().postNotificationName(NotificationCenter.messageReceivedByServer, (int) ids[1], newId, null, ids[0], 0L, -1, false);
                                    getNotificationCenter().postNotificationName(NotificationCenter.messageReceivedByServer2, (int) ids[1], newId, null, ids[0], 0L, -1, false);
                                }
                            });
                        }
                    }

                    Utilities.stageQueue.postRunnable(() -> {
                        boolean notifyAbountDifference = true;
                        if (res instanceof TLRPC.TL_updates_channelDifference || res instanceof TLRPC.TL_updates_channelDifferenceEmpty) {
                            if (!res.new_messages.isEmpty()) {
                                LongSparseArray<ArrayList<MessageObject>> messages = new LongSparseArray<>();
                                ImageLoader.saveMessagesThumbs(res.new_messages);

                                ArrayList<MessageObject> pushMessages = new ArrayList<>();
                                long dialogId = -channelId;
                                Integer inboxValue = dialogs_read_inbox_max.get(dialogId);
                                if (inboxValue == null) {
                                    inboxValue = getMessagesStorage().getDialogReadMax(false, dialogId);
                                    dialogs_read_inbox_max.put(dialogId, inboxValue);
                                }

                                Integer outboxValue = dialogs_read_outbox_max.get(dialogId);
                                if (outboxValue == null) {
                                    outboxValue = getMessagesStorage().getDialogReadMax(true, dialogId);
                                    dialogs_read_outbox_max.put(dialogId, outboxValue);
                                }

                                for (int a = 0; a < res.new_messages.size(); a++) {
                                    TLRPC.Message message = res.new_messages.get(a);
                                    if (message instanceof TLRPC.TL_messageEmpty) {
                                        continue;
                                    }
                                    message.unread = !(channelFinal != null && channelFinal.left || (message.out ? outboxValue : inboxValue) >= message.id || message.action instanceof TLRPC.TL_messageActionChannelCreate);

                                    boolean isDialogCreated = createdDialogIds.contains(dialogId);
                                    MessageObject obj = new MessageObject(currentAccount, message, usersDict, isDialogCreated, isDialogCreated);
                                    if ((!obj.isOut() || obj.messageOwner.from_scheduled) && obj.isUnread()) {
                                        pushMessages.add(obj);
                                    }

                                    long uid = -channelId;
                                    ArrayList<MessageObject> arr = messages.get(uid);
                                    if (arr == null) {
                                        arr = new ArrayList<>();
                                        messages.put(uid, arr);
                                    }
                                    arr.add(obj);
                                }

                                AndroidUtilities.runOnUIThread(() -> {
                                    for (int a = 0; a < messages.size(); a++) {
                                        long key = messages.keyAt(a);
                                        ArrayList<MessageObject> value = messages.valueAt(a);
                                        updateInterfaceWithMessages(key, value, 0);
                                    }
                                    getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                                });
                                getMessagesStorage().getStorageQueue().postRunnable(() -> {
                                    if (!pushMessages.isEmpty()) {
                                        AndroidUtilities.runOnUIThread(() -> getNotificationsController().processNewMessages(pushMessages, true, false, null));
                                    }
                                    getMessagesStorage().putMessages(res.new_messages, true, false, false, getDownloadController().getAutodownloadMask(), 0, 0);
                                });
                            }

                            if (!res.other_updates.isEmpty()) {
                                processUpdateArray(res.other_updates, res.users, res.chats, true, 0);
                            }
                            processChannelsUpdatesQueue(channelId, 1);
                            getMessagesStorage().saveChannelPts(channelId, res.pts);
                        } else if (res instanceof TLRPC.TL_updates_channelDifferenceTooLong) {
                            long dialogId = -channelId;

                            Integer inboxValue = dialogs_read_inbox_max.get(dialogId);
                            if (inboxValue == null) {
                                inboxValue = getMessagesStorage().getDialogReadMax(false, dialogId);
                                dialogs_read_inbox_max.put(dialogId, inboxValue);
                            }

                            Integer outboxValue = dialogs_read_outbox_max.get(dialogId);
                            if (outboxValue == null) {
                                outboxValue = getMessagesStorage().getDialogReadMax(true, dialogId);
                                dialogs_read_outbox_max.put(dialogId, outboxValue);
                            }

                            for (int a = 0; a < res.messages.size(); a++) {
                                TLRPC.Message message = res.messages.get(a);
                                message.dialog_id = -channelId;
                                message.unread = !(message.action instanceof TLRPC.TL_messageActionChannelCreate || channelFinal != null && channelFinal.left || (message.out ? outboxValue : inboxValue) >= message.id);
                            }
                            getMessagesStorage().overwriteChannel(channelId, (TLRPC.TL_updates_channelDifferenceTooLong) res, newDialogType, () -> AndroidUtilities.runOnUIThread(() -> {
                                NotificationCenter.getInstance(currentAccount).postNotificationName(NotificationCenter.onReceivedChannelDifference, channelId);
                            }));
                            notifyAbountDifference = false;
                        }
                        gettingDifferenceChannels.delete(channelId);
                        channelsPts.put(channelId, res.pts);

                        if ((res.flags & 2) != 0) {
                            shortPollChannels.put(channelId, (int) (System.currentTimeMillis() / 1000) + res.timeout);
                        }
                        if (!res.isFinal) {
                            getChannelDifference(channelId);
                        }
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("received channel difference with pts = " + res.pts + " channelId = " + channelId);
                            FileLog.d("new_messages = " + res.new_messages.size() + " messages = " + res.messages.size() + " users = " + res.users.size() + " chats = " + res.chats.size() + " other updates = " + res.other_updates.size());
                        }

                        if (newTaskId != 0) {
                            getMessagesStorage().removePendingTask(newTaskId);
                        }
                        if (notifyAbountDifference) {
                            AndroidUtilities.runOnUIThread(() -> {
                                NotificationCenter.getInstance(currentAccount).postNotificationName(NotificationCenter.onReceivedChannelDifference, channelId);
                            });
                        }
                    });
                });
            } else if (error != null) {
                AndroidUtilities.runOnUIThread(() -> {
                    checkChannelError(error.text, channelId);
                    NotificationCenter.getInstance(currentAccount).postNotificationName(NotificationCenter.onReceivedChannelDifference, channelId);
                });
                gettingDifferenceChannels.delete(channelId);
                if (newTaskId != 0) {
                    getMessagesStorage().removePendingTask(newTaskId);
                }
            }
        });
    }

    private void checkChannelError(String text, long channelId) {
        switch (text) {
            case "CHANNEL_PRIVATE":
                getNotificationCenter().postNotificationName(NotificationCenter.chatInfoCantLoad, channelId, 0);
                break;
            case "CHANNEL_PUBLIC_GROUP_NA":
                getNotificationCenter().postNotificationName(NotificationCenter.chatInfoCantLoad, channelId, 1);
                break;
            case "USER_BANNED_IN_CHANNEL":
                getNotificationCenter().postNotificationName(NotificationCenter.chatInfoCantLoad, channelId, 2);
                break;
        }
    }

    public void getDifference() {
        getDifference(getMessagesStorage().getLastPtsValue(), getMessagesStorage().getLastDateValue(), getMessagesStorage().getLastQtsValue(), false);
    }

    public void getDifference(int pts, int date, int qts, boolean slice) {
        registerForPush(SharedConfig.pushType, SharedConfig.pushString);
        if (getMessagesStorage().getLastPtsValue() == 0) {
            loadCurrentState();
            return;
        }
        if (!slice && gettingDifference) {
            return;
        }
        gettingDifference = true;
        TLRPC.TL_updates_getDifference req = new TLRPC.TL_updates_getDifference();
        req.pts = pts;
        req.date = date;
        req.qts = qts;
        if (getDifferenceFirstSync) {
            req.flags |= 1;
            if (ApplicationLoader.isConnectedOrConnectingToWiFi()) {
                req.pts_total_limit = 5000;
            } else {
                req.pts_total_limit = 1000;
            }
            getDifferenceFirstSync = false;
        }
        if (req.date == 0) {
            req.date = getConnectionsManager().getCurrentTime();
        }
        if (BuildVars.LOGS_ENABLED) {
            FileLog.d("start getDifference with date = " + date + " pts = " + pts + " qts = " + qts);
            FileLog.d("getDifference: isUpdating = true");
        }
        getConnectionsManager().setIsUpdating(true);
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (error == null) {
                TLRPC.updates_Difference res = (TLRPC.updates_Difference) response;
                if (res instanceof TLRPC.TL_updates_differenceTooLong) {
                    AndroidUtilities.runOnUIThread(() -> {
                        loadedFullUsers.clear();
                        loadedFullChats.clear();
                        resetDialogs(true, getMessagesStorage().getLastSeqValue(), res.pts, date, qts);
                        getStoriesController().cleanup();
                    });
                } else {
                    if (res instanceof TLRPC.TL_updates_differenceSlice) {
                        getDifference(res.intermediate_state.pts, res.intermediate_state.date, res.intermediate_state.qts, true);
                    }

                    LongSparseArray<TLRPC.User> usersDict = new LongSparseArray<>();
                    LongSparseArray<TLRPC.Chat> chatsDict = new LongSparseArray<>();
                    for (int a = 0; a < res.users.size(); a++) {
                        TLRPC.User user = res.users.get(a);
                        usersDict.put(user.id, user);
                    }
                    for (int a = 0; a < res.chats.size(); a++) {
                        TLRPC.Chat chat = res.chats.get(a);
                        chatsDict.put(chat.id, chat);
                    }

                    ArrayList<TLRPC.TL_updateMessageID> msgUpdates = new ArrayList<>();
                    if (!res.other_updates.isEmpty()) {
                        for (int a = 0; a < res.other_updates.size(); a++) {
                            TLRPC.Update upd = res.other_updates.get(a);
                            if (upd instanceof TLRPC.TL_updateMessageID) {
                                msgUpdates.add((TLRPC.TL_updateMessageID) upd);
                                res.other_updates.remove(a);
                                a--;
                            } else if (getUpdateType(upd) == 2) {
                                long channelId = getUpdateChannelId(upd);
                                int channelPts = channelsPts.get(channelId);
                                if (channelPts == 0) {
                                    channelPts = getMessagesStorage().getChannelPtsSync(channelId);
                                    if (channelPts != 0) {
                                        channelsPts.put(channelId, channelPts);
                                    }
                                }
                                if (channelPts != 0 && getUpdatePts(upd) <= channelPts) {
                                    res.other_updates.remove(a);
                                    a--;
                                }
                            }
                        }
                    }

                    AndroidUtilities.runOnUIThread(() -> {
                        loadedFullUsers.clear();
                        loadedFullChats.clear();
                        putUsers(res.users, false);
                        putChats(res.chats, false);
                    });

                    getMessagesStorage().getStorageQueue().postRunnable(() -> {
                        getMessagesStorage().putUsersAndChats(res.users, res.chats, true, false);
                        if (!msgUpdates.isEmpty()) {
                            SparseArray<long[]> corrected = new SparseArray<>();
                            for (int a = 0; a < msgUpdates.size(); a++) {
                                TLRPC.TL_updateMessageID update = msgUpdates.get(a);
                                long[] ids = getMessagesStorage().updateMessageStateAndId(update.random_id, 0, null, update.id, 0, false, -1, 0);
                                if (ids != null) {
                                    corrected.put(update.id, ids);
                                }
                            }

                            if (corrected.size() != 0) {
                                AndroidUtilities.runOnUIThread(() -> {
                                    for (int a = 0; a < corrected.size(); a++) {
                                        int newId = corrected.keyAt(a);
                                        long[] ids = corrected.valueAt(a);
                                        getSendMessagesHelper().processSentMessage((int) ids[1]);
                                        getNotificationCenter().postNotificationName(NotificationCenter.messageReceivedByServer, (int) ids[1], newId, null, ids[0], 0L, -1, false);
                                        getNotificationCenter().postNotificationName(NotificationCenter.messageReceivedByServer2, (int) ids[1], newId, null, ids[0], 0L, -1, false);
                                    }
                                });
                            }
                        }

                        Utilities.stageQueue.postRunnable(() -> {
                            if (!res.new_messages.isEmpty() || !res.new_encrypted_messages.isEmpty()) {
                                LongSparseArray<ArrayList<MessageObject>> messages = new LongSparseArray<>();
                                for (int b = 0; b < res.new_encrypted_messages.size(); b++) {
                                    TLRPC.EncryptedMessage encryptedMessage = res.new_encrypted_messages.get(b);
                                    ArrayList<TLRPC.Message> decryptedMessages = getSecretChatHelper().decryptMessage(encryptedMessage);
                                    if (decryptedMessages != null && !decryptedMessages.isEmpty()) {
                                        res.new_messages.addAll(decryptedMessages);
                                    }
                                }

                                ImageLoader.saveMessagesThumbs(res.new_messages);

                                ArrayList<MessageObject> pushMessages = new ArrayList<>();
                                long clientUserId = getUserConfig().getClientUserId();
                                for (int a = 0; a < res.new_messages.size(); a++) {
                                    TLRPC.Message message = res.new_messages.get(a);
                                    if (message instanceof TLRPC.TL_messageEmpty) {
                                        continue;
                                    }
                                    MessageObject.getDialogId(message);

                                    if (!DialogObject.isEncryptedDialog(message.dialog_id)) {
                                        if (message.action instanceof TLRPC.TL_messageActionChatDeleteUser) {
                                            TLRPC.User user = usersDict.get(message.action.user_id);
                                            if (user != null && user.bot) {
                                                message.reply_markup = new TLRPC.TL_replyKeyboardHide();
                                                message.flags |= 64;
                                            }
                                        }
                                        if (message.action instanceof TLRPC.TL_messageActionChatMigrateTo || message.action instanceof TLRPC.TL_messageActionChannelCreate) {
                                            message.unread = false;
                                            message.media_unread = false;
                                        } else {
                                            ConcurrentHashMap<Long, Integer> read_max = message.out ? dialogs_read_outbox_max : dialogs_read_inbox_max;
                                            Integer value = read_max.get(message.dialog_id);
                                            if (value == null) {
                                                value = getMessagesStorage().getDialogReadMax(message.out, message.dialog_id);
                                                read_max.put(message.dialog_id, value);
                                            }
                                            message.unread = value < message.id;
                                        }
                                    }
                                    if (message.dialog_id == clientUserId) {
                                        message.unread = false;
                                        message.media_unread = false;
                                        message.out = true;
                                    }

                                    boolean isDialogCreated = createdDialogIds.contains(message.dialog_id);
                                    MessageObject obj = new MessageObject(currentAccount, message, usersDict, chatsDict, isDialogCreated, isDialogCreated);

                                    if ((!obj.isOut() || obj.messageOwner.from_scheduled) && obj.isUnread()) {
                                        pushMessages.add(obj);
                                    }

                                    ArrayList<MessageObject> arr = messages.get(message.dialog_id);
                                    if (arr == null) {
                                        arr = new ArrayList<>();
                                        messages.put(message.dialog_id, arr);
                                    }
                                    arr.add(obj);
                                }

                                getMessagesStorage().getStorageQueue().postRunnable(() -> {
                                    if (!pushMessages.isEmpty()) {
                                        AndroidUtilities.runOnUIThread(() -> getNotificationsController().processNewMessages(pushMessages, !(res instanceof TLRPC.TL_updates_differenceSlice), false, null));
                                    }
                                    getMessagesStorage().putMessages(res.new_messages, true, false, false, getDownloadController().getAutodownloadMask(), 0, 0);

                                    for (int a = 0; a < messages.size(); a++) {
                                        long dialogId = messages.keyAt(a);
                                        ArrayList<MessageObject> arr = messages.valueAt(a);
                                        getMediaDataController().loadReplyMessagesForMessages(arr, dialogId, 0, 0, () -> {
                                            AndroidUtilities.runOnUIThread(() -> {
                                                updateInterfaceWithMessages(dialogId, arr, 0);
                                                getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                                            });
                                        }, 0, null);
                                    }
                                });

                                getSecretChatHelper().processPendingEncMessages();
                            }

                            if (!res.other_updates.isEmpty()) {
                                processUpdateArray(res.other_updates, res.users, res.chats, true, 0);
                            }

                            if (res instanceof TLRPC.TL_updates_difference) {
                                gettingDifference = false;
                                getMessagesStorage().setLastSeqValue(res.state.seq);
                                getMessagesStorage().setLastDateValue(res.state.date);
                                getMessagesStorage().setLastPtsValue(res.state.pts);
                                getMessagesStorage().setLastQtsValue(res.state.qts);
                                FileLog.d("received difference: isUpdating = false");
                                getConnectionsManager().setIsUpdating(false);
                                for (int a = 0; a < 3; a++) {
                                    processUpdatesQueue(a, 1);
                                }
                            } else if (res instanceof TLRPC.TL_updates_differenceSlice) {
                                getMessagesStorage().setLastDateValue(res.intermediate_state.date);
                                getMessagesStorage().setLastPtsValue(res.intermediate_state.pts);
                                getMessagesStorage().setLastQtsValue(res.intermediate_state.qts);
                            } else if (res instanceof TLRPC.TL_updates_differenceEmpty) {
                                gettingDifference = false;
                                getMessagesStorage().setLastSeqValue(res.seq);
                                getMessagesStorage().setLastDateValue(res.date);
                                getConnectionsManager().setIsUpdating(false);
                                FileLog.d("received differenceEmpty: isUpdating = false");
                                for (int a = 0; a < 3; a++) {
                                    processUpdatesQueue(a, 1);
                                }
                            }
                            getMessagesStorage().saveDiffParams(getMessagesStorage().getLastSeqValue(), getMessagesStorage().getLastPtsValue(), getMessagesStorage().getLastDateValue(), getMessagesStorage().getLastQtsValue());
                            if (BuildVars.LOGS_ENABLED) {
                                FileLog.d("received difference with date = " + getMessagesStorage().getLastDateValue() + " pts = " + getMessagesStorage().getLastPtsValue() + " seq = " + getMessagesStorage().getLastSeqValue() + " messages = " + res.new_messages.size() + " users = " + res.users.size() + " chats = " + res.chats.size() + " other updates = " + res.other_updates.size());
                            }
                        });
                    });
                }
            } else {
                gettingDifference = false;
                getConnectionsManager().setIsUpdating(false);
                FileLog.d("received: isUpdating = false");
            }
        });
    }

    public void markDialogAsUnread(long dialogId, TLRPC.InputPeer peer, long taskId) {
        TLRPC.Dialog dialog = dialogs_dict.get(dialogId);
        if (dialog != null) {
            dialog.unread_mark = true;
            if (dialog.unread_count == 0 && !isDialogMuted(dialogId, 0)) {
                unreadUnmutedDialogs++;
            }
            getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_READ_DIALOG_MESSAGE);
            getMessagesStorage().setDialogUnread(dialogId, true);
            for (int b = 0; b < selectedDialogFilter.length; b++) {
                if (selectedDialogFilter[b] != null && (selectedDialogFilter[b].flags & DIALOG_FILTER_FLAG_EXCLUDE_READ) != 0) {
                    sortDialogs(null);
                    getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                    break;
                }
            }
        }
        if (!DialogObject.isEncryptedDialog(dialogId)) {
            TLRPC.TL_messages_markDialogUnread req = new TLRPC.TL_messages_markDialogUnread();
            req.unread = true;
            if (peer == null) {
                peer = getInputPeer(dialogId);
            }
            if (peer instanceof TLRPC.TL_inputPeerEmpty) {
                return;
            }
            TLRPC.TL_inputDialogPeer inputDialogPeer = new TLRPC.TL_inputDialogPeer();
            inputDialogPeer.peer = peer;
            req.peer = inputDialogPeer;

            long newTaskId;
            if (taskId == 0) {
                NativeByteBuffer data = null;
                try {
                    data = new NativeByteBuffer(12 + peer.getObjectSize());
                    data.writeInt32(9);
                    data.writeInt64(dialogId);
                    peer.serializeToStream(data);
                } catch (Exception e) {
                    FileLog.e(e);
                }
                newTaskId = getMessagesStorage().createPendingTask(data);
            } else {
                newTaskId = taskId;
            }

            getConnectionsManager().sendRequest(req, (response, error) -> {
                if (newTaskId != 0) {
                    getMessagesStorage().removePendingTask(newTaskId);
                }
            });
        }
    }

    public void loadUnreadDialogs() {
        if (loadingUnreadDialogs || getUserConfig().unreadDialogsLoaded) {
            return;
        }
        loadingUnreadDialogs = true;
        TLRPC.TL_messages_getDialogUnreadMarks req = new TLRPC.TL_messages_getDialogUnreadMarks();
        getConnectionsManager().sendRequest(req, (response, error) -> AndroidUtilities.runOnUIThread(() -> {
            if (response instanceof Vector) {
                final Vector vector = (Vector) response;
                for (int a = 0, size = vector.objects.size(); a < size; a++) {
                    TLRPC.DialogPeer peer = (TLRPC.DialogPeer) vector.objects.get(a);
                    if (peer instanceof TLRPC.TL_dialogPeer) {
                        TLRPC.TL_dialogPeer dialogPeer = (TLRPC.TL_dialogPeer) peer;
                        long did;
                        if (dialogPeer.peer.user_id != 0) {
                            did = dialogPeer.peer.user_id;
                        } else if (dialogPeer.peer.chat_id != 0) {
                            did = -dialogPeer.peer.chat_id;
                        } else {
                            did = -dialogPeer.peer.channel_id;
                        }
                        getMessagesStorage().setDialogUnread(did, true);
                        TLRPC.Dialog dialog = dialogs_dict.get(did);
                        if (dialog != null && !dialog.unread_mark) {
                            dialog.unread_mark = true;
                            if (dialog.unread_count == 0 && !isDialogMuted(did, 0)) {
                                unreadUnmutedDialogs++;
                            }
                        }
                    }
                }
                getUserConfig().unreadDialogsLoaded = true;
                getUserConfig().saveConfig(false);
                getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_READ_DIALOG_MESSAGE);
                loadingUnreadDialogs = false;
            }
        }));
    }

    public void reorderPinnedDialogs(int folderId, ArrayList<TLRPC.InputDialogPeer> order, long taskId) {
        TLRPC.TL_messages_reorderPinnedDialogs req = new TLRPC.TL_messages_reorderPinnedDialogs();
        req.folder_id = folderId;
        req.force = true;

        long newTaskId;
        if (taskId == 0) {
            ArrayList<TLRPC.Dialog> dialogs = getDialogs(folderId);
            if (dialogs.isEmpty()) {
                return;
            }

            int size = 0;
            ArrayList<Long> dids = new ArrayList<>();
            ArrayList<Integer> pinned = new ArrayList<>();
            for (int a = 0, N = dialogs.size(); a < N; a++) {
                TLRPC.Dialog dialog = dialogs.get(a);
                if (dialog instanceof TLRPC.TL_dialogFolder) {
                    continue;
                }
                if (!dialog.pinned) {
                    if (dialog.id != promoDialogId) {
                        break;
                    }
                    continue;
                }
                dids.add(dialog.id);
                pinned.add(dialog.pinnedNum);
                if (!DialogObject.isEncryptedDialog(dialog.id)) {
                    TLRPC.InputPeer inputPeer = getInputPeer(dialog.id);
                    TLRPC.TL_inputDialogPeer inputDialogPeer = new TLRPC.TL_inputDialogPeer();
                    inputDialogPeer.peer = inputPeer;
                    req.order.add(inputDialogPeer);
                    size += inputDialogPeer.getObjectSize();
                }
            }
            getMessagesStorage().setDialogsPinned(dids, pinned);

            NativeByteBuffer data = null;
            try {
                data = new NativeByteBuffer(4 + 4 + 4 + size);
                data.writeInt32(16);
                data.writeInt32(folderId);
                data.writeInt32(req.order.size());
                for (int a = 0, N = req.order.size(); a < N; a++) {
                    req.order.get(a).serializeToStream(data);
                }
            } catch (Exception e) {
                FileLog.e(e);
            }
            newTaskId = getMessagesStorage().createPendingTask(data);
        } else {
            req.order = order;
            newTaskId = taskId;
        }

        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (newTaskId != 0) {
                getMessagesStorage().removePendingTask(newTaskId);
            }
        });
    }

    public boolean pinDialog(long dialogId, boolean pin, TLRPC.InputPeer peer, long taskId) {
        TLRPC.Dialog dialog = dialogs_dict.get(dialogId);
        if (dialog == null || dialog.pinned == pin) {
            return dialog != null;
        }
        int folderId = dialog.folder_id;
        ArrayList<TLRPC.Dialog> dialogs = getDialogs(folderId);
        dialog.pinned = pin;
        if (pin) {
            int maxPinnedNum = 0;
            for (int a = 0; a < dialogs.size(); a++) {
                TLRPC.Dialog d = dialogs.get(a);
                if (d instanceof TLRPC.TL_dialogFolder) {
                    continue;
                }
                if (!d.pinned) {
                    if (d.id != promoDialogId) {
                        break;
                    }
                    continue;
                }
                maxPinnedNum = Math.max(d.pinnedNum, maxPinnedNum);
            }
            dialog.pinnedNum = maxPinnedNum + 1;
        } else {
            dialog.pinnedNum = 0;
        }
        sortDialogs(null);
        if (!pin && !dialogs.isEmpty() && dialogs.get(dialogs.size() - 1) == dialog && !dialogsEndReached.get(folderId)) {
            dialogs.remove(dialogs.size() - 1);
        }
        getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
        if (!DialogObject.isEncryptedDialog(dialogId)) {
            if (taskId != -1) {
                TLRPC.TL_messages_toggleDialogPin req = new TLRPC.TL_messages_toggleDialogPin();
                req.pinned = pin;
                if (peer == null) {
                    peer = getInputPeer(dialogId);
                }
                if (peer instanceof TLRPC.TL_inputPeerEmpty) {
                    return false;
                }
                TLRPC.TL_inputDialogPeer inputDialogPeer = new TLRPC.TL_inputDialogPeer();
                inputDialogPeer.peer = peer;
                req.peer = inputDialogPeer;

                long newTaskId;
                if (taskId == 0) {
                    NativeByteBuffer data = null;
                    try {
                        data = new NativeByteBuffer(16 + peer.getObjectSize());
                        data.writeInt32(4);
                        data.writeInt64(dialogId);
                        data.writeBool(pin);
                        peer.serializeToStream(data);
                    } catch (Exception e) {
                        FileLog.e(e);
                    }
                    newTaskId = getMessagesStorage().createPendingTask(data);
                } else {
                    newTaskId = taskId;
                }

                if (mainPreferences.getBoolean("syncPins", true)) {
                    getConnectionsManager().sendRequest(req, (response, error) -> {
                        if (newTaskId != 0) {
                            getMessagesStorage().removePendingTask(newTaskId);
                        }
                    });
                }
            }
        }
        getMessagesStorage().setDialogPinned(dialogId, dialog.pinnedNum);
        return true;
    }

    public void loadPinnedDialogs(final int folderId, long newDialogId, ArrayList<Long> order) {
        if (!mainPreferences.getBoolean("syncPins", true)) {
            return;
        }
        if (loadingPinnedDialogs.indexOfKey(folderId) >= 0 || getUserConfig().isPinnedDialogsLoaded(folderId)) {
            return;
        }
        loadingPinnedDialogs.put(folderId, 1);
        TLRPC.TL_messages_getPinnedDialogs req = new TLRPC.TL_messages_getPinnedDialogs();
        req.folder_id = folderId;
        getConnectionsManager().sendRequest(req, (response, error) -> {
            if (response != null) {
                TLRPC.TL_messages_peerDialogs res = (TLRPC.TL_messages_peerDialogs) response;
                ArrayList<TLRPC.Dialog> newPinnedDialogs = new ArrayList<>(res.dialogs);
                fetchFolderInLoadedPinnedDialogs(res);
                TLRPC.TL_messages_dialogs toCache = new TLRPC.TL_messages_dialogs();
                toCache.users.addAll(res.users);
                toCache.chats.addAll(res.chats);
                toCache.dialogs.addAll(res.dialogs);
                toCache.messages.addAll(res.messages);

                LongSparseArray<ArrayList<MessageObject>> new_dialogMessage = new LongSparseArray<>();
                LongSparseArray<TLRPC.User> usersDict = new LongSparseArray<>();
                LongSparseArray<TLRPC.Chat> chatsDict = new LongSparseArray<>();

                for (int a = 0; a < res.users.size(); a++) {
                    TLRPC.User u = res.users.get(a);
                    usersDict.put(u.id, u);
                }
                for (int a = 0; a < res.chats.size(); a++) {
                    TLRPC.Chat c = res.chats.get(a);
                    chatsDict.put(c.id, c);
                }

                ArrayList<MessageObject> newMessages = new ArrayList<>();
                for (int a = 0; a < res.messages.size(); a++) {
                    TLRPC.Message message = res.messages.get(a);
                    if (message.peer_id.channel_id != 0) {
                        TLRPC.Chat chat = chatsDict.get(message.peer_id.channel_id);
                        if (chat != null && chat.left) {
                            continue;
                        }
                    } else if (message.peer_id.chat_id != 0) {
                        TLRPC.Chat chat = chatsDict.get(message.peer_id.chat_id);
                        if (chat != null && chat.migrated_to != null) {
                            continue;
                        }
                    }
                    MessageObject messageObject = new MessageObject(currentAccount, message, usersDict, chatsDict, false, false);
                    newMessages.add(messageObject);
                    long did = messageObject.getDialogId();
                    ArrayList<MessageObject> arrayList = new_dialogMessage.get(did);
                    if (arrayList == null) {
                        arrayList = new ArrayList<MessageObject>();
                    }
                    arrayList.add(messageObject);
                    new_dialogMessage.put(did, arrayList);
                }
                //getFileLoader().checkMediaExistance(newMessages);
                boolean firstIsFolder = !newPinnedDialogs.isEmpty() && newPinnedDialogs.get(0) instanceof TLRPC.TL_dialogFolder;
                for (int a = 0, N = newPinnedDialogs.size(); a < N; a++) {
                    TLRPC.Dialog d = newPinnedDialogs.get(a);
                    d.pinned = true;
                    DialogObject.initDialog(d);
                    if (DialogObject.isChannel(d)) {
                        TLRPC.Chat chat = chatsDict.get(-d.id);
                        if (chat != null && chat.left) {
                            continue;
                        }
                    } else if (DialogObject.isChatDialog(d.id)) {
                        TLRPC.Chat chat = chatsDict.get(-d.id);
                        if (chat != null && chat.migrated_to != null) {
                            continue;
                        }
                    }
                    if (d.last_message_date == 0) {
                        ArrayList<MessageObject> messages = new_dialogMessage.get(d.id);
                        if (messages != null) {
                            int maxDate = Integer.MIN_VALUE;
                            for (int i = 0; i < messages.size(); ++i) {
                                MessageObject msg = messages.get(i);
                                if (msg != null && msg.messageOwner != null && msg.messageOwner.date > maxDate) {
                                    maxDate = msg.messageOwner.date;
                                }
                            }
                            if (maxDate > Integer.MIN_VALUE) {
                                d.last_message_date = maxDate;
                            }
                        }
                    }

                    Integer value = dialogs_read_inbox_max.get(d.id);
                    if (value == null) {
                        value = 0;
                    }
                    dialogs_read_inbox_max.put(d.id, Math.max(value, d.read_inbox_max_id));

                    value = dialogs_read_outbox_max.get(d.id);
                    if (value == null) {
                        value = 0;
                    }
                    dialogs_read_outbox_max.put(d.id, Math.max(value, d.read_outbox_max_id));
                }

                getMessagesStorage().getStorageQueue().postRunnable(() -> AndroidUtilities.runOnUIThread(() -> {
                    loadingPinnedDialogs.delete(folderId);
                    applyDialogsNotificationsSettings(newPinnedDialogs);
                    boolean changed = false;
                    boolean added = false;
                    int maxPinnedNum = 0;

                    ArrayList<TLRPC.Dialog> dialogs = getDialogs(folderId);

                    int pinnedNum = firstIsFolder ? 1 : 0;
                    for (int a = 0; a < dialogs.size(); a++) {
                        TLRPC.Dialog dialog = dialogs.get(a);
                        if (dialog instanceof TLRPC.TL_dialogFolder) {
                            continue;
                        }
                        if (DialogObject.isEncryptedDialog(dialog.id)) {
                            if (pinnedNum < newPinnedDialogs.size()) {
                                newPinnedDialogs.add(pinnedNum, dialog);
                            } else {
                                newPinnedDialogs.add(dialog);
                            }
                            pinnedNum++;
                            continue;
                        }
                        if (!dialog.pinned) {
                            if (dialog.id != promoDialogId) {
                                break;
                            }
                            continue;
                        }
                        maxPinnedNum = Math.max(dialog.pinnedNum, maxPinnedNum);
                        dialog.pinned = false;
                        dialog.pinnedNum = 0;
                        changed = true;
                        pinnedNum++;
                    }

                    ArrayList<Long> pinnedDialogs = new ArrayList<>();
                    if (!newPinnedDialogs.isEmpty()) {
                        putUsers(res.users, false);
                        putChats(res.chats, false);
                        ArrayList<Long> dids = new ArrayList<>();
                        ArrayList<Integer> pinned = new ArrayList<>();
                        for (int a = 0, N = newPinnedDialogs.size(); a < N; a++) {
                            TLRPC.Dialog dialog = newPinnedDialogs.get(a);
                            dialog.pinnedNum = (N - a) + maxPinnedNum;

                            pinnedDialogs.add(dialog.id);
                            TLRPC.Dialog d = dialogs_dict.get(dialog.id);
                            if (d != null) {
                                d.pinned = true;
                                d.pinnedNum = dialog.pinnedNum;
                                dids.add(dialog.id);
                                pinned.add(dialog.pinnedNum);
                            } else {
                                added = true;
                                dialogs_dict.put(dialog.id, dialog);
                                ArrayList<MessageObject> messageObjects = new_dialogMessage.get(dialog.id);
                                dialogMessage.put(dialog.id, messageObjects);
                                if (messageObjects != null) {
                                    for (int i = 0; i < messageObjects.size(); ++i) {
                                        MessageObject messageObject = messageObjects.get(i);
                                        if (messageObject != null && messageObject.messageOwner.peer_id.channel_id == 0) {
                                            dialogMessagesByIds.put(messageObject.getId(), messageObject);
                                            dialogsLoadedTillDate = Math.min(dialogsLoadedTillDate, messageObject.messageOwner.date);
                                            if (messageObject.messageOwner.random_id != 0) {
                                                dialogMessagesByRandomIds.put(messageObject.messageOwner.random_id, messageObject);
                                            }
                                        }
                                    }
                                }
                                getTranslateController().checkDialogMessage(dialog.id);
                            }

                            changed = true;
                        }
                        getMessagesStorage().setDialogsPinned(dids, pinned);
                    }
                    if (changed) {
                        if (added) {
                            allDialogs.clear();
                            for (int a = 0, size = dialogs_dict.size(); a < size; a++) {
                                TLRPC.Dialog dialog = dialogs_dict.valueAt(a);
                                if (deletingDialogs.indexOfKey(dialog.id) >= 0) {
                                    continue;
                                }
                                allDialogs.add(dialog);
                            }
                        }
                        sortDialogs(null);
                        getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                    }
                    getMessagesStorage().unpinAllDialogsExceptNew(pinnedDialogs, folderId);
                    getMessagesStorage().putDialogs(toCache, 1);
                    getUserConfig().setPinnedDialogsLoaded(folderId, true);
                    getUserConfig().saveConfig(false);
                }));
            }
        });
    }

    public void generateJoinMessage(long chatId, boolean ignoreLeft) {
        TLRPC.Chat chat = getChat(chatId);
        if (chat == null || !ChatObject.isChannel(chatId, currentAccount) || ChatObject.isNotInChat(chat) && !ignoreLeft || chat.creator) {
            return;
        }
        if (ChatObject.isMonoForum(chat)) {
            return;
        }

        TLRPC.TL_messageService message = new TLRPC.TL_messageService();
        message.flags = TLRPC.MESSAGE_FLAG_HAS_FROM_ID;
        message.local_id = message.id = getUserConfig().getNewMessageId();
        if (chat instanceof TLRPC.TL_channel && !ignoreLeft) {
            message.date = chat.date;
        } else {
            message.date = getConnectionsManager().getCurrentTime();
        }
        message.from_id = new TLRPC.TL_peerUser();
        message.from_id.user_id = getUserConfig().getClientUserId();
        message.peer_id = new TLRPC.TL_peerChannel();
        message.peer_id.channel_id = chatId;
        message.dialog_id = -chatId;
        message.post = true;
        message.action = new TLRPC.TL_messageActionChatAddUser();
        message.action.users.add(getUserConfig().getClientUserId());
        getUserConfig().saveConfig(false);

        ArrayList<MessageObject> pushMessages = new ArrayList<>();
        ArrayList<TLRPC.Message> messagesArr = new ArrayList<>();

        messagesArr.add(message);
        MessageObject obj = new MessageObject(currentAccount, message, true, false);
        pushMessages.add(obj);

        getMessagesStorage().putMessages(messagesArr, true, true, false, 0, 0, 0);

        AndroidUtilities.runOnUIThread(() -> {
            updateInterfaceWithMessages(-chatId, pushMessages, 0);
            getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
        });
    }

    protected void deleteMessagesByPush(long dialogId, ArrayList<Integer> ids, long channelId) {
        getMessagesStorage().getStorageQueue().postRunnable(() -> {
            AndroidUtilities.runOnUIThread(() -> {
                getNotificationCenter().postNotificationName(NotificationCenter.messagesDeleted, ids, channelId, false);
                if (channelId == 0) {
                    for (int b = 0, size2 = ids.size(); b < size2; b++) {
                        Integer id = ids.get(b);
                        MessageObject obj = dialogMessagesByIds.get(id);
                        if (obj != null) {
                            obj.deleted = true;
                        }
                    }
                } else {
                    ArrayList<MessageObject> objs = dialogMessage.get(-channelId);
                    if (objs != null) {
                        for (int i = 0; i < objs.size(); ++i) {
                            MessageObject obj = objs.get(i);
                            for (int b = 0, size2 = ids.size(); b < size2; b++) {
                                if (obj.getId() == ids.get(b)) {
                                    obj.deleted = true;
                                    break;
                                }
                            }
                        }
                    }
                }
            });
            getMessagesStorage().deletePushMessages(dialogId, ids);
            ArrayList<Long> dialogIds = getMessagesStorage().markMessagesAsDeleted(dialogId, ids, false, true, 0, 0);
            getMessagesStorage().updateDialogsWithDeletedMessages(dialogId, channelId, ids, dialogIds, false);
        });
    }

    public void checkChatInviter(long chatId, boolean _createMessage) {
        TLRPC.Chat chat = getChat(chatId);
        if (!ChatObject.isChannel(chat) || chat.creator || gettingChatInviters.indexOfKey(chatId) >= 0) {
            return;
        }
        if (ChatObject.isMonoForum(chat)) {
            _createMessage = false;
        }
        final boolean createMessage = _createMessage;
        gettingChatInviters.put(chatId, true);
        TLRPC.TL_channels_getParticipant req = new TLRPC.TL_channels_getParticipant();
        req.channel = getInputChannel(chatId);
        req.participant = getInputPeer(getUserConfig().getClientUserId());
        getConnectionsManager().sendRequest(req, (response, error) -> {
            TLRPC.TL_channels_channelParticipant res = (TLRPC.TL_channels_channelParticipant) response;
            if (res != null && res.participant instanceof TLRPC.TL_channelParticipantSelf) {
                TLRPC.TL_channelParticipantSelf selfParticipant = (TLRPC.TL_channelParticipantSelf) res.participant;
                if (chat.megagroup && getMessagesStorage().isMigratedChat(chat.id)) {
                    return;
                }
                AndroidUtilities.runOnUIThread(() -> {
                    putUsers(res.users, false);
                    putChats(res.chats, false);
                });
                getMessagesStorage().putUsersAndChats(res.users, res.chats, true, true);

                ArrayList<MessageObject> pushMessages;
                if (createMessage && Math.abs(getConnectionsManager().getCurrentTime() - res.participant.date) < 24 * 60 * 60 && !getMessagesStorage().hasInviteMeMessage(chatId)) {
                    TLRPC.TL_messageService message = new TLRPC.TL_messageService();
                    message.flags = TLRPC.MESSAGE_FLAG_HAS_FROM_ID;
                    message.local_id = message.id = getUserConfig().getNewMessageId();
                    message.date = res.participant.date;
                    message.from_id = new TLRPC.TL_peerUser();
                    message.from_id.user_id = res.participant.inviter_id;
                    message.peer_id = new TLRPC.TL_peerChannel();
                    message.peer_id.channel_id = chatId;
                    message.media_unread = true;
                    message.unread = true;
                    message.post = true;
                    if (!selfParticipant.via_invite || selfParticipant.inviter_id != getUserConfig().getClientUserId()) {
                        message.action = new TLRPC.TL_messageActionChatAddUser();
                    } else {
                        message.action = new TLRPC.TL_messageActionChatJoinedByRequest();
                    }
                    message.action.users.add(getUserConfig().getClientUserId());
                    message.dialog_id = -chatId;
                    getUserConfig().saveConfig(false);

                    pushMessages = new ArrayList<>();
                    ArrayList<TLRPC.Message> messagesArr = new ArrayList<>();

                    ConcurrentHashMap<Long, TLRPC.User> usersDict = new ConcurrentHashMap<>();
                    for (int a = 0; a < res.users.size(); a++) {
                        TLRPC.User user = res.users.get(a);
                        usersDict.put(user.id, user);
                    }

                    messagesArr.add(message);
                    MessageObject obj = new MessageObject(currentAccount, message, usersDict, true, false);
                    pushMessages.add(obj);
                    if (message.from_id.user_id != getUserConfig().getClientUserId()) {
                        getMessagesStorage().getStorageQueue().postRunnable(() -> AndroidUtilities.runOnUIThread(() -> getNotificationsController().processNewMessages(pushMessages, true, false, null)));
                    }
                    getMessagesStorage().putMessages(messagesArr, true, true, false, 0, 0, 0);
                } else {
                    pushMessages = null;
                }

                getMessagesStorage().saveChatInviter(chatId, res.participant.inviter_id);

                AndroidUtilities.runOnUIThread(() -> {
                    gettingChatInviters.delete(chatId);
                    if (pushMessages != null) {
                        updateInterfaceWithMessages(-chatId, pushMessages, 0);
                        getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                    }
                    getNotificationCenter().postNotificationName(NotificationCenter.didLoadChatInviter, chatId, res.participant.inviter_id);
                });
            }
        });
    }

    private int getUpdateType(TLRPC.Update update) {
        if (update instanceof TLRPC.TL_updateNewMessage || update instanceof TLRPC.TL_updateReadMessagesContents || update instanceof TLRPC.TL_updateReadHistoryInbox ||
                update instanceof TLRPC.TL_updateReadHistoryOutbox || update instanceof TLRPC.TL_updateDeleteMessages || update instanceof TLRPC.TL_updateWebPage ||
                update instanceof TLRPC.TL_updateEditMessage || update instanceof TLRPC.TL_updateFolderPeers || update instanceof TLRPC.TL_updatePinnedMessages) {
            return 0;
        } else if (update instanceof TLRPC.TL_updateNewEncryptedMessage) {
            return 1;
        } else if (update instanceof TLRPC.TL_updateNewChannelMessage || update instanceof TLRPC.TL_updateDeleteChannelMessages || update instanceof TLRPC.TL_updateEditChannelMessage ||
                update instanceof TLRPC.TL_updateChannelWebPage || update instanceof TLRPC.TL_updatePinnedChannelMessages) {
            return 2;
        } else {
            return 3;
        }
    }

    private static int getUpdatePts(TLRPC.Update update) {
        if (update instanceof TLRPC.TL_updateDeleteMessages) {
            return ((TLRPC.TL_updateDeleteMessages) update).pts;
        } else if (update instanceof TLRPC.TL_updateNewChannelMessage) {
            return ((TLRPC.TL_updateNewChannelMessage) update).pts;
        } else if (update instanceof TLRPC.TL_updateReadHistoryOutbox) {
            return ((TLRPC.TL_updateReadHistoryOutbox) update).pts;
        } else if (update instanceof TLRPC.TL_updateNewMessage) {
            return ((TLRPC.TL_updateNewMessage) update).pts;
        } else if (update instanceof TLRPC.TL_updateEditMessage) {
            return ((TLRPC.TL_updateEditMessage) update).pts;
        } else if (update instanceof TLRPC.TL_updateWebPage) {
            return ((TLRPC.TL_updateWebPage) update).pts;
        } else if (update instanceof TLRPC.TL_updateReadHistoryInbox) {
            return ((TLRPC.TL_updateReadHistoryInbox) update).pts;
        } else if (update instanceof TLRPC.TL_updateChannelWebPage) {
            return ((TLRPC.TL_updateChannelWebPage) update).pts;
        } else if (update instanceof TLRPC.TL_updateDeleteChannelMessages) {
            return ((TLRPC.TL_updateDeleteChannelMessages) update).pts;
        } else if (update instanceof TLRPC.TL_updateEditChannelMessage) {
            return ((TLRPC.TL_updateEditChannelMessage) update).pts;
        } else if (update instanceof TLRPC.TL_updateReadMessagesContents) {
            return ((TLRPC.TL_updateReadMessagesContents) update).pts;
        } else if (update instanceof TLRPC.TL_updateChannelTooLong) {
            return ((TLRPC.TL_updateChannelTooLong) update).pts;
        } else if (update instanceof TLRPC.TL_updateFolderPeers) {
            return ((TLRPC.TL_updateFolderPeers) update).pts;
        } else if (update instanceof TLRPC.TL_updatePinnedChannelMessages) {
            return ((TLRPC.TL_updatePinnedChannelMessages) update).pts;
        } else if (update instanceof TLRPC.TL_updatePinnedMessages) {
            return ((TLRPC.TL_updatePinnedMessages) update).pts;
        } else {
            return 0;
        }
    }

    private static int getUpdatePtsCount(TLRPC.Update update) {
        if (update instanceof TLRPC.TL_updateDeleteMessages) {
            return ((TLRPC.TL_updateDeleteMessages) update).pts_count;
        } else if (update instanceof TLRPC.TL_updateNewChannelMessage) {
            return ((TLRPC.TL_updateNewChannelMessage) update).pts_count;
        } else if (update instanceof TLRPC.TL_updateReadHistoryOutbox) {
            return ((TLRPC.TL_updateReadHistoryOutbox) update).pts_count;
        } else if (update instanceof TLRPC.TL_updateNewMessage) {
            return ((TLRPC.TL_updateNewMessage) update).pts_count;
        } else if (update instanceof TLRPC.TL_updateEditMessage) {
            return ((TLRPC.TL_updateEditMessage) update).pts_count;
        } else if (update instanceof TLRPC.TL_updateWebPage) {
            return ((TLRPC.TL_updateWebPage) update).pts_count;
        } else if (update instanceof TLRPC.TL_updateReadHistoryInbox) {
            return ((TLRPC.TL_updateReadHistoryInbox) update).pts_count;
        } else if (update instanceof TLRPC.TL_updateChannelWebPage) {
            return ((TLRPC.TL_updateChannelWebPage) update).pts_count;
        } else if (update instanceof TLRPC.TL_updateDeleteChannelMessages) {
            return ((TLRPC.TL_updateDeleteChannelMessages) update).pts_count;
        } else if (update instanceof TLRPC.TL_updateEditChannelMessage) {
            return ((TLRPC.TL_updateEditChannelMessage) update).pts_count;
        } else if (update instanceof TLRPC.TL_updateReadMessagesContents) {
            return ((TLRPC.TL_updateReadMessagesContents) update).pts_count;
        } else if (update instanceof TLRPC.TL_updateFolderPeers) {
            return ((TLRPC.TL_updateFolderPeers) update).pts_count;
        } else if (update instanceof TLRPC.TL_updatePinnedChannelMessages) {
            return ((TLRPC.TL_updatePinnedChannelMessages) update).pts_count;
        } else if (update instanceof TLRPC.TL_updatePinnedMessages) {
            return ((TLRPC.TL_updatePinnedMessages) update).pts_count;
        } else {
            return 0;
        }
    }

    private static int getUpdateQts(TLRPC.Update update) {
        if (update instanceof TLRPC.TL_updateNewEncryptedMessage) {
            return ((TLRPC.TL_updateNewEncryptedMessage) update).qts;
        } else {
            return 0;
        }
    }

    public static long getUpdateChannelId(TLRPC.Update update) {
        if (update instanceof TLRPC.TL_updateNewChannelMessage) {
            return ((TLRPC.TL_updateNewChannelMessage) update).message.peer_id.channel_id;
        } else if (update instanceof TLRPC.TL_updateEditChannelMessage) {
            return ((TLRPC.TL_updateEditChannelMessage) update).message.peer_id.channel_id;
        } else if (update instanceof TLRPC.TL_updateReadChannelOutbox) {
            return ((TLRPC.TL_updateReadChannelOutbox) update).channel_id;
        } else if (update instanceof TLRPC.TL_updateChannelMessageViews) {
            return ((TLRPC.TL_updateChannelMessageViews) update).channel_id;
        } else if (update instanceof TLRPC.TL_updateChannelMessageForwards) {
            return ((TLRPC.TL_updateChannelMessageForwards) update).channel_id;
        } else if (update instanceof TLRPC.TL_updateChannelTooLong) {
            return ((TLRPC.TL_updateChannelTooLong) update).channel_id;
        } else if (update instanceof TLRPC.TL_updateChannelReadMessagesContents) {
            return ((TLRPC.TL_updateChannelReadMessagesContents) update).channel_id;
        } else if (update instanceof TLRPC.TL_updateChannelAvailableMessages) {
            return ((TLRPC.TL_updateChannelAvailableMessages) update).channel_id;
        } else if (update instanceof TLRPC.TL_updateChannel) {
            return ((TLRPC.TL_updateChannel) update).channel_id;
        } else if (update instanceof TLRPC.TL_updateChannelWebPage) {
            return ((TLRPC.TL_updateChannelWebPage) update).channel_id;
        } else if (update instanceof TLRPC.TL_updateDeleteChannelMessages) {
            return ((TLRPC.TL_updateDeleteChannelMessages) update).channel_id;
        } else if (update instanceof TLRPC.TL_updateReadChannelInbox) {
            return ((TLRPC.TL_updateReadChannelInbox) update).channel_id;
        } else if (update instanceof TLRPC.TL_updatePinnedForumTopic) {
            final TLRPC.Peer peer = ((TLRPC.TL_updatePinnedForumTopic) update).peer;
            return peer.channel_id;
        } else if (update instanceof TLRPC.TL_updatePinnedForumTopics) {
            final TLRPC.Peer peer = ((TLRPC.TL_updatePinnedForumTopics) update).peer;
            return peer.channel_id;
        } else if (update instanceof TLRPC.TL_updateReadChannelDiscussionInbox) {
            return ((TLRPC.TL_updateReadChannelDiscussionInbox) update).channel_id;
        } else if (update instanceof TLRPC.TL_updateReadChannelDiscussionOutbox) {
            return ((TLRPC.TL_updateReadChannelDiscussionOutbox) update).channel_id;
        } else if (update instanceof TLRPC.TL_updateChannelUserTyping) {
            return ((TLRPC.TL_updateChannelUserTyping) update).channel_id;
        } else if (update instanceof TLRPC.TL_updatePinnedChannelMessages) {
            return ((TLRPC.TL_updatePinnedChannelMessages) update).channel_id;
        } else if (update instanceof TLRPC.TL_updateChannelViewForumAsMessages) {
            return ((TLRPC.TL_updateChannelViewForumAsMessages) update).channel_id;
        } else {
            if (BuildVars.LOGS_ENABLED) {
                FileLog.e("trying to get unknown update channel_id for " + update);
            }
            return 0;
        }
    }

    // must be run from Utilities.stageQueue
    public void processUpdates(final TLRPC.Updates updates, boolean fromQueue) {
        ArrayList<Long> needGetChannelsDiff = null;
        boolean needGetDiff = false;
        boolean needReceivedQueue = false;
        boolean updateStatus = false;
        if (updates instanceof TLRPC.TL_updateShort) {
            ArrayList<TLRPC.Update> arr = new ArrayList<>();
            arr.add(updates.update);
            processUpdateArray(arr, null, null, false, updates.date);
        } else if (updates instanceof TLRPC.TL_updateShortChatMessage || updates instanceof TLRPC.TL_updateShortMessage) {
            long userId = updates instanceof TLRPC.TL_updateShortChatMessage ? updates.from_id : updates.user_id;
            TLRPC.User user = getUser(userId);
            TLRPC.User user2 = null;
            TLRPC.User user3 = null;
            TLRPC.Chat channel = null;

            FileLog.d("update message short userId = " + userId);
            if (user == null || user.min) {
                user = getMessagesStorage().getUserSync(userId);
                if (user != null && user.min) {
                    user = null;
                }
                putUser(user, true);
            }

            boolean needFwdUser = false;
            if (updates.fwd_from != null) {
                if (updates.fwd_from.from_id instanceof TLRPC.TL_peerUser) {
                    user2 = getUser(updates.fwd_from.from_id.user_id);
                    if (user2 == null) {
                        user2 = getMessagesStorage().getUserSync(updates.fwd_from.from_id.user_id);
                        putUser(user2, true);
                    }
                    needFwdUser = true;
                } else if (updates.fwd_from.from_id instanceof TLRPC.TL_peerChannel) {
                    channel = getChat(updates.fwd_from.from_id.channel_id);
                    if (channel == null) {
                        channel = getMessagesStorage().getChatSync(updates.fwd_from.from_id.channel_id);
                        putChat(channel, true);
                    }
                    needFwdUser = true;
                } else if (updates.fwd_from.from_id instanceof TLRPC.TL_peerChat) {
                    channel = getChat(updates.fwd_from.from_id.chat_id);
                    if (channel == null) {
                        channel = getMessagesStorage().getChatSync(updates.fwd_from.from_id.chat_id);
                        putChat(channel, true);
                    }
                    needFwdUser = true;
                }
            }

            boolean needBotUser = false;
            if (updates.via_bot_id != 0) {
                user3 = getUser(updates.via_bot_id);
                if (user3 == null) {
                    user3 = getMessagesStorage().getUserSync(updates.via_bot_id);
                    putUser(user3, true);
                }
                needBotUser = true;
            }

            boolean missingData;
            if (updates instanceof TLRPC.TL_updateShortMessage) {
                missingData = user == null || needFwdUser && user2 == null && channel == null || needBotUser && user3 == null;
            } else {
                TLRPC.Chat chat = getChat(updates.chat_id);
                if (chat == null) {
                    chat = getMessagesStorage().getChatSync(updates.chat_id);
                    putChat(chat, true);
                }
                missingData = chat == null || user == null || needFwdUser && user2 == null && channel == null || needBotUser && user3 == null;
            }
            if (!missingData && !updates.entities.isEmpty()) {
                for (int a = 0; a < updates.entities.size(); a++) {
                    TLRPC.MessageEntity entity = updates.entities.get(a);
                    if (entity instanceof TLRPC.TL_messageEntityMentionName) {
                        long uid = ((TLRPC.TL_messageEntityMentionName) entity).user_id;
                        TLRPC.User entityUser = getUser(uid);
                        if (entityUser == null || entityUser.min) {
                            entityUser = getMessagesStorage().getUserSync(uid);
                            if (entityUser != null && entityUser.min) {
                                entityUser = null;
                            }
                            if (entityUser == null) {
                                missingData = true;
                                break;
                            }
                            putUser(user, true);
                        }
                    }
                }
            }
            if (!updates.out && user != null && user.status != null && user.status.expires <= 0 && Math.abs(getConnectionsManager().getCurrentTime() - updates.date) < 30) {
                onlinePrivacy.put(user.id, updates.date);
                updateStatus = true;
            }

            if (missingData) {
                needGetDiff = true;
            } else {
                if (getMessagesStorage().getLastPtsValue() + updates.pts_count == updates.pts) {
                    TLRPC.TL_message message = new TLRPC.TL_message();
                    message.id = updates.id;
                    long clientUserId = getUserConfig().getClientUserId();
                    if (updates instanceof TLRPC.TL_updateShortMessage) {
                        message.from_id = new TLRPC.TL_peerUser();
                        if (updates.out) {
                            message.from_id.user_id = clientUserId;
                        } else {
                            message.from_id.user_id = userId;
                        }
                        message.peer_id = new TLRPC.TL_peerUser();
                        message.peer_id.user_id = userId;
                        message.dialog_id = userId;
                    } else {
                        message.from_id = new TLRPC.TL_peerUser();
                        message.from_id.user_id = userId;
                        message.peer_id = new TLRPC.TL_peerChat();
                        message.peer_id.chat_id = updates.chat_id;
                        message.dialog_id = -updates.chat_id;
                    }

                    message.fwd_from = updates.fwd_from;
                    message.silent = updates.silent;
                    message.out = updates.out;
                    message.mentioned = updates.mentioned;
                    message.media_unread = updates.media_unread;
                    message.entities = updates.entities;
                    message.message = updates.message;
                    message.date = updates.date;
                    message.via_bot_id = updates.via_bot_id;
                    message.flags = updates.flags | TLRPC.MESSAGE_FLAG_HAS_FROM_ID;
                    message.reply_to = updates.reply_to;
                    message.ttl_period = updates.ttl_period;
                    message.media = new TLRPC.TL_messageMediaEmpty();

                    ConcurrentHashMap<Long, Integer> read_max = message.out ? dialogs_read_outbox_max : dialogs_read_inbox_max;
                    Integer value = read_max.get(message.dialog_id);
                    if (value == null) {
                        value = getMessagesStorage().getDialogReadMax(message.out, message.dialog_id);
                        read_max.put(message.dialog_id, value);
                    }
                    message.unread = value < message.id;

                    if (message.dialog_id == clientUserId) {
                        message.unread = false;
                        message.media_unread = false;
                        message.out = true;
                    }

                    getMessagesStorage().setLastPtsValue(updates.pts);
                    boolean isDialogCreated = createdDialogIds.contains(message.dialog_id);
                    MessageObject obj = new MessageObject(currentAccount, message, isDialogCreated, isDialogCreated);
                    ArrayList<MessageObject> objArr = new ArrayList<>();
                    objArr.add(obj);
                    ArrayList<TLRPC.Message> arr = new ArrayList<>();
                    arr.add(message);
                    if (updates instanceof TLRPC.TL_updateShortMessage) {
                        boolean printUpdate = !updates.out && updatePrintingUsersWithNewMessages(updates.user_id, objArr);
                        if (printUpdate) {
                            updatePrintingStrings();
                        }
                        AndroidUtilities.runOnUIThread(() -> {
                            if (printUpdate) {
                                getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_USER_PRINT);
                            }
                            updateInterfaceWithMessages(userId, objArr, 0);
                            getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                        });
                    } else {
                        boolean printUpdate = updatePrintingUsersWithNewMessages(-updates.chat_id, objArr);
                        if (printUpdate) {
                            updatePrintingStrings();
                        }
                        AndroidUtilities.runOnUIThread(() -> {
                            if (printUpdate) {
                                getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_USER_PRINT);
                            }

                            updateInterfaceWithMessages(-updates.chat_id, objArr, 0);
                            getNotificationCenter().postNotificationName(NotificationCenter.dialogsNeedReload);
                        });
                    }
                    if (!obj.isOut()) {
                        getMessagesStorage().getStorageQueue().postRunnable(() -> AndroidUtilities.runOnUIThread(() -> getNotificationsController().processNewMessages(objArr, true, false, null)));
                    }
                    getMessagesStorage().putMessages(arr, false, true, false, 0, 0, 0);
                } else if (getMessagesStorage().getLastPtsValue() != updates.pts) {
                    if (BuildVars.LOGS_ENABLED) {
                        FileLog.d("need get diff short message, pts: " + getMessagesStorage().getLastPtsValue() + " " + updates.pts + " count = " + updates.pts_count);
                    }
                    if (gettingDifference || updatesStartWaitTimePts == 0 || Math.abs(System.currentTimeMillis() - updatesStartWaitTimePts) <= 1500) {
                        if (updatesStartWaitTimePts == 0) {
                            updatesStartWaitTimePts = System.currentTimeMillis();
                        }
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("add to queue");
                        }
                        updatesQueuePts.add(updates);
                    } else {
                        needGetDiff = true;
                    }
                }
            }
        } else if (updates instanceof TLRPC.TL_updatesCombined || updates instanceof TLRPC.TL_updates) {
            LongSparseArray<TLRPC.Chat> minChannels = null;
            for (int a = 0; a < updates.chats.size(); a++) {
                TLRPC.Chat chat = updates.chats.get(a);
                if (chat instanceof TLRPC.TL_channel) {
                    if (chat.min) {
                        TLRPC.Chat existChat = getChat(chat.id);
                        if (existChat == null || existChat.min) {
                            TLRPC.Chat cacheChat = getMessagesStorage().getChatSync(updates.chat_id);
                            putChat(cacheChat, true);
                            existChat = cacheChat;
                        }
                        if (existChat == null || existChat.min) {
                            if (minChannels == null) {
                                minChannels = new LongSparseArray<>();
                            }
                            minChannels.put(chat.id, chat);
                        }
                    }
                }
            }
            if (minChannels != null) {
                for (int a = 0; a < updates.updates.size(); a++) {
                    TLRPC.Update update = updates.updates.get(a);
                    if (update instanceof TLRPC.TL_updateNewChannelMessage) {
                        TLRPC.Message message = ((TLRPC.TL_updateNewChannelMessage) update).message;
                        long channelId = message.peer_id.channel_id;
                        if (minChannels.indexOfKey(channelId) >= 0) {
                            if (BuildVars.LOGS_ENABLED) {
                                FileLog.d("need get diff because of min channel " + channelId);
                            }
                            needGetDiff = true;
                            break;
                        }
                        /*if (message.fwd_from != null && message.fwd_from.channel_id != 0) {
                            channelId = message.fwd_from.channel_id;
                            if (minChannels.containsKey(channelId)) {
                                if (BuildVars.LOGS_ENABLED) {
                                    FileLog.e("need get diff because of min forward channel " + channelId);
                                }
                                needGetDiff = true;
                                break;
                            }
                        }*/
                    }
                }
            }
            if (!needGetDiff) {
                getMessagesStorage().putUsersAndChats(updates.users, updates.chats, true, true);
                Collections.sort(updates.updates, updatesComparator);
                for (int a = 0; a < updates.updates.size(); a++) {
                    TLRPC.Update update = updates.updates.get(a);
                    if (getUpdateType(update) == 0) {
                        TLRPC.TL_updates updatesNew = new TLRPC.TL_updates();
                        updatesNew.updates.add(update);
                        updatesNew.pts = getUpdatePts(update);
                        updatesNew.pts_count = getUpdatePtsCount(update);
                        for (int b = a + 1; b < updates.updates.size(); b++) {
                            TLRPC.Update update2 = updates.updates.get(b);
                            int pts2 = getUpdatePts(update2);
                            int count2 = getUpdatePtsCount(update2);
                            if (getUpdateType(update2) == 0 && updatesNew.pts + count2 == pts2) {
                                updatesNew.updates.add(update2);
                                updatesNew.pts = pts2;
                                updatesNew.pts_count += count2;
                                updates.updates.remove(b);
                                b--;
                            } else {
                                break;
                            }
                        }
                        if (getMessagesStorage().getLastPtsValue() + updatesNew.pts_count == updatesNew.pts) {
                            if (!processUpdateArray(updatesNew.updates, updates.users, updates.chats, false, updates.date)) {
                                if (BuildVars.LOGS_ENABLED) {
                                    FileLog.d("need get diff inner TL_updates, pts: " + getMessagesStorage().getLastPtsValue() + " " + updates.seq);
                                }
                                needGetDiff = true;
                            } else {
                                getMessagesStorage().setLastPtsValue(updatesNew.pts);
                            }
                        } else if (getMessagesStorage().getLastPtsValue() != updatesNew.pts) {
                            if (BuildVars.LOGS_ENABLED) {
                                FileLog.d(update + " need get diff, pts: " + getMessagesStorage().getLastPtsValue() + " " + updatesNew.pts + " count = " + updatesNew.pts_count);
                            }
                            if (gettingDifference || updatesStartWaitTimePts == 0 || Math.abs(System.currentTimeMillis() - updatesStartWaitTimePts) <= 1500) {
                                if (updatesStartWaitTimePts == 0) {
                                    updatesStartWaitTimePts = System.currentTimeMillis();
                                }
                                if (BuildVars.LOGS_ENABLED) {
                                    FileLog.d("add to queue");
                                }
                                updatesQueuePts.add(updatesNew);
                            } else {
                                needGetDiff = true;
                            }
                        }
                    } else if (getUpdateType(update) == 1) {
                        TLRPC.TL_updates updatesNew = new TLRPC.TL_updates();
                        updatesNew.updates.add(update);
                        updatesNew.pts = getUpdateQts(update);
                        for (int b = a + 1; b < updates.updates.size(); b++) {
                            TLRPC.Update update2 = updates.updates.get(b);
                            int qts2 = getUpdateQts(update2);
                            if (getUpdateType(update2) == 1 && updatesNew.pts + 1 == qts2) {
                                updatesNew.updates.add(update2);
                                updatesNew.pts = qts2;
                                updates.updates.remove(b);
                                b--;
                            } else {
                                break;
                            }
                        }
                        if (getMessagesStorage().getLastQtsValue() == 0 || getMessagesStorage().getLastQtsValue() + updatesNew.updates.size() == updatesNew.pts) {
                            processUpdateArray(updatesNew.updates, updates.users, updates.chats, false, updates.date);
                            getMessagesStorage().setLastQtsValue(updatesNew.pts);
                            needReceivedQueue = true;
                        } else if (getMessagesStorage().getLastPtsValue() != updatesNew.pts) {
                            if (BuildVars.LOGS_ENABLED) {
                                FileLog.d(update + " need get diff, qts: " + getMessagesStorage().getLastQtsValue() + " " + updatesNew.pts);
                            }
                            if (gettingDifference || updatesStartWaitTimeQts == 0 || Math.abs(System.currentTimeMillis() - updatesStartWaitTimeQts) <= 1500) {
                                if (updatesStartWaitTimeQts == 0) {
                                    updatesStartWaitTimeQts = System.currentTimeMillis();
                                }
                                if (BuildVars.LOGS_ENABLED) {
                                    FileLog.d("add to queue");
                                }
                                updatesQueueQts.add(updatesNew);
                            } else {
                                needGetDiff = true;
                            }
                        }
                    } else if (getUpdateType(update) == 2) {
                        long channelId = getUpdateChannelId(update);
                        boolean skipUpdate = false;
                        int channelPts = channelsPts.get(channelId);
                        if (channelPts == 0) {
                            channelPts = getMessagesStorage().getChannelPtsSync(channelId);
                            if (channelPts == 0) {
                                for (int c = 0; c < updates.chats.size(); c++) {
                                    TLRPC.Chat chat = updates.chats.get(c);
                                    if (chat.id == channelId) {
                                        loadUnknownChannel(chat, 0);
                                        skipUpdate = true;
                                        break;
                                    }
                                }
                            } else {
                                channelsPts.put(channelId, channelPts);
                            }
                        }
                        TLRPC.TL_updates updatesNew = new TLRPC.TL_updates();
                        updatesNew.updates.add(update);
                        updatesNew.pts = getUpdatePts(update);
                        updatesNew.pts_count = getUpdatePtsCount(update);
                        for (int b = a + 1; b < updates.updates.size(); b++) {
                            TLRPC.Update update2 = updates.updates.get(b);
                            int pts2 = getUpdatePts(update2);
                            int count2 = getUpdatePtsCount(update2);
                            if (getUpdateType(update2) == 2 && channelId == getUpdateChannelId(update2) && updatesNew.pts + count2 == pts2) {
                                updatesNew.updates.add(update2);
                                updatesNew.pts = pts2;
                                updatesNew.pts_count += count2;
                                updates.updates.remove(b);
                                b--;
                            } else {
                                break;
                            }
                        }
                        if (!skipUpdate) {
                            if (channelPts + updatesNew.pts_count == updatesNew.pts) {
                                if (!processUpdateArray(updatesNew.updates, updates.users, updates.chats, false, updates.date)) {
                                    if (BuildVars.LOGS_ENABLED) {
                                        FileLog.d("need get channel diff inner TL_updates, channel_id = " + channelId);
                                    }
                                    if (needGetChannelsDiff == null) {
                                        needGetChannelsDiff = new ArrayList<>();
                                    } else if (!needGetChannelsDiff.contains(channelId)) {
                                        needGetChannelsDiff.add(channelId);
                                    }
                                } else {
                                    channelsPts.put(channelId, updatesNew.pts);
                                    getMessagesStorage().saveChannelPts(channelId, updatesNew.pts);
                                }
                            } else if (channelPts != updatesNew.pts) {
                                if (BuildVars.LOGS_ENABLED) {
                                    FileLog.d(update + " need get channel diff, pts: " + channelPts + " " + updatesNew.pts + " count = " + updatesNew.pts_count + " channelId = " + channelId);
                                }
                                long updatesStartWaitTime = updatesStartWaitTimeChannels.get(channelId);
                                boolean gettingDifferenceChannel = gettingDifferenceChannels.get(channelId, false);
                                if (gettingDifferenceChannel || updatesStartWaitTime == 0 || Math.abs(System.currentTimeMillis() - updatesStartWaitTime) <= 1500) {
                                    if (updatesStartWaitTime == 0) {
                                        updatesStartWaitTimeChannels.put(channelId, System.currentTimeMillis());
                                    }
                                    if (BuildVars.LOGS_ENABLED) {
                                        FileLog.d("add to queue");
                                    }
                                    ArrayList<TLRPC.Updates> arrayList = updatesQueueChannels.get(channelId);
                                    if (arrayList == null) {
                                        arrayList = new ArrayList<>();
                                        updatesQueueChannels.put(channelId, arrayList);
                                    }
                                    arrayList.add(updatesNew);
                                } else {
                                    if (needGetChannelsDiff == null) {
                                        needGetChannelsDiff = new ArrayList<>();
                                    } else if (!needGetChannelsDiff.contains(channelId)) {
                                        needGetChannelsDiff.add(channelId);
                                    }
                                }
                            }
                        } else {
                            if (BuildVars.LOGS_ENABLED) {
                                FileLog.d("need load unknown channel = " + channelId);
                            }
                        }
                    } else {
                        break;
                    }
                    if (updates.updates.size() <= 0) {
                        break;
                    }
                    updates.updates.remove(a);
                    a--;
                }

                boolean processUpdate;
                if (updates instanceof TLRPC.TL_updatesCombined) {
                    processUpdate = getMessagesStorage().getLastSeqValue() + 1 == updates.seq_start || getMessagesStorage().getLastSeqValue() == updates.seq_start;
                } else {
                    processUpdate = getMessagesStorage().getLastSeqValue() + 1 == updates.seq || updates.seq == 0 || updates.seq == getMessagesStorage().getLastSeqValue();
                }
                if (processUpdate) {
                    processUpdateArray(updates.updates, updates.users, updates.chats, false, updates.date);
                    if (updates.seq != 0) {
                        if (updates.date != 0) {
                            getMessagesStorage().setLastDateValue(updates.date);
                        }
                        getMessagesStorage().setLastSeqValue(updates.seq);
                    }
                } else {
                    if (BuildVars.LOGS_ENABLED) {
                        if (updates instanceof TLRPC.TL_updatesCombined) {
                            FileLog.d("need get diff TL_updatesCombined, seq: " + getMessagesStorage().getLastSeqValue() + " " + updates.seq_start);
                        } else {
                            FileLog.d("need get diff TL_updates, seq: " + getMessagesStorage().getLastSeqValue() + " " + updates.seq);
                        }
                    }

                    if (gettingDifference || updatesStartWaitTimeSeq == 0 || Math.abs(System.currentTimeMillis() - updatesStartWaitTimeSeq) <= 1500) {
                        if (updatesStartWaitTimeSeq == 0) {
                            updatesStartWaitTimeSeq = System.currentTimeMillis();
                        }
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("add TL_updates/Combined to queue");
                        }
                        updatesQueueSeq.add(updates);
                    } else {
                        needGetDiff = true;
                    }
                }
            }
        } else if (updates instanceof TLRPC.TL_updatesTooLong) {
            if (BuildVars.LOGS_ENABLED) {
                FileLog.d("need get diff TL_updatesTooLong");
            }
            needGetDiff = true;
        } else if (updates instanceof UserActionUpdatesSeq) {
            getMessagesStorage().setLastSeqValue(updates.seq);
        } else if (updates instanceof UserActionUpdatesPts) {
            if (updates.chat_id != 0) {
                channelsPts.put(updates.chat_id, updates.pts);
                getMessagesStorage().saveChannelPts(updates.chat_id, updates.pts);
            } else {
                getMessagesStorage().setLastPtsValue(updates.pts);
            }
        }
        getSecretChatHelper().processPendingEncMessages();
        if (!fromQueue) {
            for (int a = 0; a < updatesQueueChannels.size(); a++) {
                long key = updatesQueueChannels.keyAt(a);
                if (needGetChannelsDiff != null && needGetChannelsDiff.contains(key)) {
                    getChannelDifference(key);
                } else {
                    processChannelsUpdatesQueue(key, 0);
                }
            }
            if (needGetDiff) {
                getDifference();
            } else {
                for (int a = 0; a < 3; a++) {
                    processUpdatesQueue(a, 0);
                }
            }
        }
        if (needReceivedQueue) {
            TLRPC.TL_messages_receivedQueue req = new TLRPC.TL_messages_receivedQueue();
            req.max_qts = getMessagesStorage().getLastQtsValue();
            getConnectionsManager().sendRequest(req, null);
        }
        if (updateStatus) {
            AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.updateInterfaces, UPDATE_MASK_STATUS));
        }
        getMessagesStorage().saveDiffParams(getMessagesStorage().getLastSeqValue(), getMessagesStorage().getLastPtsValue(), getMessagesStorage().getLastDateValue(), getMessagesStorage().getLastQtsValue());
    }

    private boolean applyFoldersUpdates(ArrayList<TLRPC.TL_updateFolderPeers> folderUpdates) {
        if (folderUpdates == null) {
            return false;
        }
        boolean updated = false;
        for (int a = 0, size = folderUpdates.size(); a < size; a++) {
            TLRPC.TL_updateFolderPeers update = folderUpdates.get(a);
            for (int b = 0, size2 = update.folder_peers.size(); b < size2; b++) {
                TLRPC.TL_folderPeer folderPeer = update.folder_peers.get(b);
                long dialogId = DialogObject.getPeerDialogId(folderPeer.peer);
                TLRPC.Dialog dialog = dialogs_dict.get(dialogId);
                if (dialog == null) {
                    continue;
                }
                if (dialog.folder_id != folderPeer.folder_id) {
                    dialog.pinned = false;
                    dialog.pinnedNum = 0;
                    dialog.folder_id = folderPeer.folder_id;
                    hasArchivedChats = true;
                    checkArchiveFolder();
                }
            }
            updated = true;
            getMessagesStorage().setDialogsFolderId(folderUpdates.get(a).folder_peers, null, 0, 0);
        }
        return updated;
    }

    public boolean processUpdateArray(ArrayList<TLRPC.Update> updates, ArrayList<TLRPC.User> usersArr, ArrayList<TLRPC.Chat> chatsArr, boolean fromGetDifference, int date) {
        if (updates.isEmpty()) {
            if (usersArr != null || chatsArr != null) {
                AndroidUtilities.runOnUIThread(() -> {
                    putUsers(usersArr, false);
                    putChats(chatsArr, false);
                });
            }
            return true;
        }
        long currentTime = System.currentTimeMillis();
        boolean printChanged = false;

        LongSparseArray<ArrayList<MessageObject>> messages = null;
        LongSparseArray<ArrayList<MessageObject>> scheduledMessages = null;
        LongSparseArray<TLRPC.WebPage> webPages = null;
        ArrayList<MessageObject> pushMessages = null;
        ArrayList<TLRPC.Message> messagesArr = null;
        ArrayList<TLRPC.TL_sendMessageEmojiInteraction> emojiInteractions = null;
        ArrayList<TLRPC.Message> scheduledMessagesArr = null;
        LongSparseArray<ArrayList<MessageObject>> editingMessages = null;
        LongSparseArray<SparseIntArray> channelViews = null;
        LongSparseArray<SparseIntArray> channelForwards = null;
        LongSparseArray<SparseArray<TLRPC.MessageReplies>> channelReplies = null;
        LongSparseIntArray markAsReadMessagesInbox = null;
        LongSparseIntArray stillUnreadMessagesCount = null;
        LongSparseIntArray markAsReadMessagesOutbox = null;
        int markContentAsReadMessagesDate = 0;
        LongSparseArray<ArrayList<Integer>> markContentAsReadMessages = null;
        SparseIntArray markAsReadEncrypted = null;
        LongSparseArray<ArrayList<Integer>> deletedMessages = null;
        LongSparseArray<ArrayList<Integer>> deletedQuickReplyMessages = null;
        LongSparseArray<ArrayList<Integer>> scheduledDeletedMessages = null;
        LongSparseArray<ArrayList<Integer>> scheduledDeletedMessagesSent = null;
        LongSparseArray<ArrayList<Long>> groupSpeakingActions = null;
        LongSparseIntArray importingActions = null;
        LongSparseIntArray clearHistoryMessages = null;
        ArrayList<TLRPC.ChatParticipants> chatInfoToUpdate = null;
        ArrayList<TLRPC.Update> updatesOnMainThread = null;
        ArrayList<TLRPC.TL_updateFolderPeers> folderUpdates = null;
        ArrayList<TLRPC.TL_updateEncryptedMessagesRead> tasks = null;
        ArrayList<Long> contactsIds = null;
        ArrayList<ImageLoader.MessageThumb> messageThumbs = null;
        HashMap<MessagesStorage.TopicKey, Integer> topicsReadOutbox = null;
        HashMap<MessagesStorage.TopicKey, Integer> topicsReadInbox = null;
        HashMap<MessagesStorage.TopicKey, Integer> savedReadOutbox = null;
        HashMap<MessagesStorage.TopicKey, Integer> savedReadInbox = null;

        ConcurrentHashMap<Long, TLRPC.User> usersDict;
        ConcurrentHashMap<Long, TLRPC.Chat> chatsDict;
        if (usersArr != null) {
            usersDict = new ConcurrentHashMap<>();
            for (int a = 0, size = usersArr.size(); a < size; a++) {
                TLRPC.User user = usersArr.get(a);
                usersDict.put(user.id, user);
            }
        } else {
            usersDict = users;
        }
        if (chatsArr != null) {
            chatsDict = new ConcurrentHashMap<>();
            for (int a = 0, size = chatsArr.size(); a < size; a++) {
                TLRPC.Chat chat = chatsArr.get(a);
                chatsDict.put(chat.id, chat);
            }
        } else {
            chatsDict = chats;
        }

        if (usersArr != null || chatsArr != null) {
            AndroidUtilities.runOnUIThread(() -> {
                putUsers(usersArr, false);
                putChats(chatsArr, false);
            });
        }

        int interfaceUpdateMask = 0;
        long clientUserId = getUserConfig().getClientUserId();

        for (int c = 0, size3 = updates.size(); c < size3; c++) {
            TLRPC.Update baseUpdate = updates.get(c);
            if (BuildVars.LOGS_ENABLED && baseUpdate != null) {
                FileLog.d("process update " + baseUpdate.getClass().getSimpleName());
            }
            if (baseUpdate instanceof TLRPC.TL_updateNewMessage || baseUpdate instanceof TLRPC.TL_updateNewChannelMessage || baseUpdate instanceof TLRPC.TL_updateNewScheduledMessage) {
                TLRPC.Message message;
                if (baseUpdate instanceof TLRPC.TL_updateNewMessage) {
                    message = ((TLRPC.TL_updateNewMessage) baseUpdate).message;
                } else if (baseUpdate instanceof TLRPC.TL_updateNewScheduledMessage) {
                    message = ((TLRPC.TL_updateNewScheduledMessage) baseUpdate).message;
                } else {
                    message = ((TLRPC.TL_updateNewChannelMessage) baseUpdate).message;
                    if (BuildVars.LOGS_ENABLED) {
                        FileLog.d(baseUpdate + " channelId = " + message.peer_id.channel_id + " message_id = " + message.id);
                    }
                    if (!message.out && message.from_id instanceof TLRPC.TL_peerUser && message.from_id.user_id == getUserConfig().getClientUserId()) {
                        message.out = true;
                    }
                }
                if (message instanceof TLRPC.TL_messageEmpty) {
                    continue;
                }
                if (newMessageCallback != null && newMessageCallback.onMessageReceived(message)) {
                    newMessageCallback = null;
                }
                TLRPC.Chat chat = null;
                long chatId = 0;
                long userId = 0;
                if (message.peer_id.channel_id != 0) {
                    chatId = message.peer_id.channel_id;
                } else if (message.peer_id.chat_id != 0) {
                    chatId = message.peer_id.chat_id;
                } else if (message.peer_id.user_id != 0) {
                    userId = message.peer_id.user_id;
                }
                if (chatId != 0) {
                    chat = chatsDict.get(chatId);
                    if (chat == null || chat.min) {
                        chat = getChat(chatId);
                    }
                    if (chat == null || chat.min) {
                        chat = getMessagesStorage().getChatSync(chatId);
                        putChat(chat, true);
                    }
                }
                if (!fromGetDifference) {
                    if (chatId != 0) {
                        if (chat == null) {
                            if (BuildVars.LOGS_ENABLED) {
                                FileLog.d("not found chat " + chatId);
                            }
                            return false;
                        }
                    }

                    int count = 3 + message.entities.size();
                    for (int a = 0; a < count; a++) {
                        boolean allowMin = false;
                        if (a != 0) {
                            if (a == 1) {
                                userId = message.from_id instanceof TLRPC.TL_peerUser ? message.from_id.user_id : 0;
                                if (message.post) {
                                    allowMin = true;
                                }
                            } else if (a == 2) {
                                userId = message.fwd_from != null && message.fwd_from.from_id instanceof TLRPC.TL_peerUser ? message.fwd_from.from_id.user_id : 0;
                            } else {
                                TLRPC.MessageEntity entity = message.entities.get(a - 3);
                                userId = entity instanceof TLRPC.TL_messageEntityMentionName ? ((TLRPC.TL_messageEntityMentionName) entity).user_id : 0;
                            }
                        }
                        if (userId > 0) {
                            TLRPC.User user = usersDict.get(userId);
                            if (user == null || !allowMin && user.min) {
                                user = getUser(userId);
                            }
                            if (user == null || !allowMin && user.min) {
                                user = getMessagesStorage().getUserSync(userId);
                                if (user != null && !allowMin && user.min) {
                                    user = null;
                                }
                                putUser(user, true);
                            }
                            if (user == null) {
                                if (BuildVars.LOGS_ENABLED) {
                                    FileLog.d("not found user " + userId);
                                }
                                return false;
                            }
                            if (!message.out && a == 1 && user.status != null && user.status.expires <= 0 && Math.abs(getConnectionsManager().getCurrentTime() - message.date) < 30) {
                                onlinePrivacy.put(userId, message.date);
                                interfaceUpdateMask |= UPDATE_MASK_STATUS;
                            }
                        }
                    }
                }

                if (message.action instanceof TLRPC.TL_messageActionChatDeleteUser) {
                    TLRPC.User user = usersDict.get(message.action.user_id);
                    if (user != null && user.bot) {
                        message.reply_markup = new TLRPC.TL_replyKeyboardHide();
                        message.flags |= 64;
                    } else if (message.from_id instanceof TLRPC.TL_peerUser && message.from_id.user_id == clientUserId && message.action.user_id == clientUserId) {
                        continue;
                    }
                }

                ImageLoader.saveMessageThumbs(message);

                MessageObject.getDialogId(message);
                if (baseUpdate instanceof TLRPC.TL_updateNewChannelMessage && message.reply_to != null && !(message.action instanceof TLRPC.TL_messageActionPinMessage)) {
                    if (channelReplies == null) {
                        channelReplies = new LongSparseArray<>();
                    }
                    SparseArray<TLRPC.MessageReplies> replies = channelReplies.get(message.dialog_id);
                    if (replies == null) {
                        replies = new SparseArray<>();
                        channelReplies.put(message.dialog_id, replies);
                    }
                    int id = message.reply_to.reply_to_top_id != 0 ? message.reply_to.reply_to_top_id : message.reply_to.reply_to_msg_id;
                    TLRPC.MessageReplies messageReplies = replies.get(id);
                    if (messageReplies == null) {
                        messageReplies = new TLRPC.TL_messageReplies();
                        replies.put(id, messageReplies);
                    }
                    if (message.from_id != null) {
                        messageReplies.recent_repliers.add(0, message.from_id);
                    }
                    messageReplies.replies++;
                }

                if (createdDialogIds.contains(message.dialog_id) && message.grouped_id == 0) {
                    ImageLoader.MessageThumb messageThumb = ImageLoader.generateMessageThumb(message);
                    if (messageThumb != null) {
                        if (messageThumbs == null) {
                            messageThumbs = new ArrayList<>();
                        }
                        messageThumbs.add(messageThumb);
                    }
                }

                if (baseUpdate instanceof TLRPC.TL_updateNewScheduledMessage) {
                    if (scheduledMessagesArr == null) {
                        scheduledMessagesArr = new ArrayList<>();
                    }
                    scheduledMessagesArr.add(message);

                    boolean isDialogCreated = createdScheduledDialogIds.contains(message.dialog_id);
                    MessageObject obj = new MessageObject(currentAccount, message, usersDict, chatsDict, isDialogCreated, isDialogCreated);
                    obj.scheduled = true;

                    if (scheduledMessages == null) {
                        scheduledMessages = new LongSparseArray<>();
                    }
                    ArrayList<MessageObject> arr = scheduledMessages.get(message.dialog_id);
                    if (arr == null) {
                        arr = new ArrayList<>();
                        scheduledMessages.put(message.dialog_id, arr);
                    }
                    arr.add(obj);
                } else {
                    if (messagesArr == null) {
                        messagesArr = new ArrayList<>();
                    }
                    messagesArr.add(message);

                    ConcurrentHashMap<Long, Integer> read_max = message.out ? dialogs_read_outbox_max : dialogs_read_inbox_max;
                    Integer value = read_max.get(message.dialog_id);
                    if (value == null) {
                        value = getMessagesStorage().getDialogReadMax(message.out, message.dialog_id);
                        read_max.put(message.dialog_id, value);
                    }
                    message.unread = !(value >= message.id || chat != null && ChatObject.isNotInChat(chat) || message.action instanceof TLRPC.TL_messageActionChatMigrateTo || message.action instanceof TLRPC.TL_messageActionChannelCreate);
                    if (message.dialog_id == clientUserId) {
                        if (!message.from_scheduled) {
                            message.unread = false;
                        }
                        message.media_unread = false;
                        message.out = true;
                    }

                    boolean isDialogCreated = createdDialogIds.contains(message.dialog_id);
                    MessageObject obj = new MessageObject(currentAccount, message, usersDict, chatsDict, isDialogCreated, isDialogCreated);
                    if (obj.type == MessageObject.TYPE_ACTION_PHOTO) {
                        interfaceUpdateMask |= UPDATE_MASK_CHAT_AVATAR;
                    } else if (obj.type == 10) {
                        interfaceUpdateMask |= UPDATE_MASK_CHAT_NAME;
                    }
                    if (messages == null) {
                        messages = new LongSparseArray<>();
                    }
                    ArrayList<MessageObject> arr = messages.get(message.dialog_id);
                    if (arr == null) {
                        arr = new ArrayList<>();
                        messages.put(message.dialog_id, arr);
                    }
                    arr.add(obj);
                    if ((!obj.isOut() || obj.messageOwner.from_scheduled) && obj.isUnread() && (chat == null || !ChatObject.isNotInChat(chat) && !chat.min)) {
                        if (pushMessages == null) {
                            pushMessages = new ArrayList<>();
                        }
                        pushMessages.add(obj);
                    }
                }
            } else if (baseUpdate instanceof TLRPC.TL_updateGroupCallMessage) {
                final TLRPC.TL_updateGroupCallMessage u = (TLRPC.TL_updateGroupCallMessage) baseUpdate;
                GroupCallMessagesController.getInstance(currentAccount).processUpdate(u);
                AndroidUtilities.runOnUIThread(() -> {
                    getNotificationCenter().postNotificationName(NotificationCenter.liveStoryMessageUpdate, u.call.id, u, false);
                });
            } else if (baseUpdate instanceof TLRPC.TL_updateDeleteGroupCallMessages) {
                final TLRPC.TL_updateDeleteGroupCallMessages u = (TLRPC.TL_updateDeleteGroupCallMessages) baseUpdate;
                AndroidUtilities.runOnUIThread(() -> {
                    getNotificationCenter().postNotificationName(NotificationCenter.liveStoryMessageUpdate, u.call.id, u, false);
                });
            } else if (baseUpdate instanceof TLRPC.TL_updateGroupCallEncryptedMessage) {
                GroupCallMessagesController.getInstance(currentAccount)
                    .processUpdate((TLRPC.TL_updateGroupCallEncryptedMessage) baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateReadMessagesContents) {
                TLRPC.TL_updateReadMessagesContents update = (TLRPC.TL_updateReadMessagesContents) baseUpdate;
                markContentAsReadMessagesDate = update.date;
                if (markContentAsReadMessages == null) {
                    markContentAsReadMessages = new LongSparseArray<>();
                }
                ArrayList<Integer> ids = markContentAsReadMessages.get(0);
                if (ids == null) {
                    ids = new ArrayList<>();
                    markContentAsReadMessages.put(0, ids);
                }
                ids.addAll(update.messages);
            } else if (baseUpdate instanceof TLRPC.TL_updateChannelReadMessagesContents) {
                TLRPC.TL_updateChannelReadMessagesContents update = (TLRPC.TL_updateChannelReadMessagesContents) baseUpdate;
                if (markContentAsReadMessages == null) {
                    markContentAsReadMessages = new LongSparseArray<>();
                }
                long dialogId = -update.channel_id;
                ArrayList<Integer> ids = markContentAsReadMessages.get(dialogId);
                if (ids == null) {
                    ids = new ArrayList<>();
                    markContentAsReadMessages.put(dialogId, ids);
                }
                ids.addAll(update.messages);
            } else if (baseUpdate instanceof TLRPC.TL_updateStarGiftAuctionState || baseUpdate instanceof TLRPC.TL_updateStarGiftAuctionUserState) {
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateReadMonoForumInbox) {
                TLRPC.TL_updateReadMonoForumInbox update = (TLRPC.TL_updateReadMonoForumInbox) baseUpdate;
                if (savedReadInbox == null) {
                    savedReadInbox = new HashMap<>();
                }
                MessagesStorage.TopicKey topicKey = MessagesStorage.TopicKey.of(-update.channel_id, DialogObject.getPeerDialogId(update.saved_peer_id));
                savedReadInbox.put(MessagesStorage.TopicKey.of(-update.channel_id, DialogObject.getPeerDialogId(update.saved_peer_id)), Math.max(Utilities.getOrDefault(savedReadInbox, topicKey, 0), update.read_max_id));
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateReadMonoForumOutbox) {
                TLRPC.TL_updateReadMonoForumOutbox update = (TLRPC.TL_updateReadMonoForumOutbox) baseUpdate;
                if (savedReadOutbox == null) {
                    savedReadOutbox = new HashMap<>();
                }
                MessagesStorage.TopicKey topicKey = MessagesStorage.TopicKey.of(-update.channel_id, DialogObject.getPeerDialogId(update.saved_peer_id));
                savedReadOutbox.put(MessagesStorage.TopicKey.of(-update.channel_id, DialogObject.getPeerDialogId(update.saved_peer_id)), Math.max(Utilities.getOrDefault(savedReadOutbox, topicKey, 0), update.read_max_id));
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateReadHistoryInbox) {
                TLRPC.TL_updateReadHistoryInbox update = (TLRPC.TL_updateReadHistoryInbox) baseUpdate;
                long dialogId;
                if (markAsReadMessagesInbox == null) {
                    markAsReadMessagesInbox = new LongSparseIntArray();
                }
                if (update.peer.chat_id != 0) {
                    markAsReadMessagesInbox.put(-update.peer.chat_id, update.max_id);
                    dialogId = -update.peer.chat_id;
                } else {
                    markAsReadMessagesInbox.put(update.peer.user_id, update.max_id);
                    dialogId = update.peer.user_id;
                }
                Integer value = dialogs_read_inbox_max.get(dialogId);
                if (value == null) {
                    value = getMessagesStorage().getDialogReadMax(false, dialogId);
                }
                dialogs_read_inbox_max.put(dialogId, Math.max(value, update.max_id));
            } else if (baseUpdate instanceof TLRPC.TL_updateReadHistoryOutbox) {
                TLRPC.TL_updateReadHistoryOutbox update = (TLRPC.TL_updateReadHistoryOutbox) baseUpdate;
                long dialogId;
                if (markAsReadMessagesOutbox == null) {
                    markAsReadMessagesOutbox = new LongSparseIntArray();
                }
                if (update.peer.chat_id != 0) {
                    markAsReadMessagesOutbox.put(-update.peer.chat_id, update.max_id);
                    dialogId = -update.peer.chat_id;
                } else {
                    markAsReadMessagesOutbox.put(update.peer.user_id, update.max_id);
                    dialogId = update.peer.user_id;
                    TLRPC.User user = getUser(update.peer.user_id);
                    if (user != null && user.status != null && user.status.expires <= 0 && Math.abs(getConnectionsManager().getCurrentTime() - date) < 30) {
                        onlinePrivacy.put(update.peer.user_id, date);
                        interfaceUpdateMask |= UPDATE_MASK_STATUS;
                    }
                }
                Integer value = dialogs_read_outbox_max.get(dialogId);
                if (value == null) {
                    value = getMessagesStorage().getDialogReadMax(true, dialogId);
                }
                dialogs_read_outbox_max.put(dialogId, Math.max(value, update.max_id));
            } else if (baseUpdate instanceof TLRPC.TL_updateDeleteMessages) {
                TLRPC.TL_updateDeleteMessages update = (TLRPC.TL_updateDeleteMessages) baseUpdate;
                if (deletedMessages == null) {
                    deletedMessages = new LongSparseArray<>();
                }
                ArrayList<Integer> arrayList = deletedMessages.get(0);
                if (arrayList == null) {
                    arrayList = new ArrayList<>();
                    deletedMessages.put(0, arrayList);
                }
                arrayList.addAll(update.messages);
            } else if (baseUpdate instanceof TLRPC.TL_updateDeleteQuickReplyMessages) {
                TLRPC.TL_updateDeleteQuickReplyMessages update = (TLRPC.TL_updateDeleteQuickReplyMessages) baseUpdate;
                if (deletedQuickReplyMessages == null) {
                    deletedQuickReplyMessages = new LongSparseArray<>();
                }
                ArrayList<Integer> arrayList = deletedQuickReplyMessages.get(update.shortcut_id);
                if (arrayList == null) {
                    arrayList = new ArrayList<>();
                    deletedQuickReplyMessages.put(update.shortcut_id, arrayList);
                }
                arrayList.addAll(update.messages);
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateDeleteScheduledMessages) {
                TLRPC.TL_updateDeleteScheduledMessages update = (TLRPC.TL_updateDeleteScheduledMessages) baseUpdate;

                if (scheduledDeletedMessages == null) {
                    scheduledDeletedMessages = new LongSparseArray<>();
                }
                long id = MessageObject.getPeerId(update.peer);
                ArrayList<Integer> arrayList = scheduledDeletedMessages.get(id);
                if (arrayList == null) {
                    arrayList = new ArrayList<>();
                    scheduledDeletedMessages.put(id, arrayList);
                }
                arrayList.addAll(update.messages);

                if (!update.sent_messages.isEmpty()) {
                    if (scheduledDeletedMessagesSent == null) {
                        scheduledDeletedMessagesSent = new LongSparseArray<>();
                    }
                    ArrayList<Integer> arrayList2 = scheduledDeletedMessagesSent.get(id);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<>();
                        scheduledDeletedMessagesSent.put(id, arrayList2);
                    }
                    arrayList2.addAll(update.sent_messages);
                }
            } else if (baseUpdate instanceof TLRPC.TL_updateUserTyping || baseUpdate instanceof TLRPC.TL_updateChatUserTyping || baseUpdate instanceof TLRPC.TL_updateChannelUserTyping) {
                long userId;
                long chatId;
                int threadId;
                TLRPC.SendMessageAction action;
                if (baseUpdate instanceof TLRPC.TL_updateChannelUserTyping) {
                    TLRPC.TL_updateChannelUserTyping update = (TLRPC.TL_updateChannelUserTyping) baseUpdate;
                    if (update.from_id.user_id != 0) {
                        userId = update.from_id.user_id;
                    } else if (update.from_id.channel_id != 0) {
                        userId = -update.from_id.channel_id;
                    } else {
                        userId = -update.from_id.chat_id;
                    }
                    chatId = update.channel_id;
                    action = update.action;
                    threadId = update.top_msg_id;
                } else if (baseUpdate instanceof TLRPC.TL_updateUserTyping) {
                    TLRPC.TL_updateUserTyping update = (TLRPC.TL_updateUserTyping) baseUpdate;
                    userId = update.user_id;
                    action = update.action;
                    chatId = 0;
                    threadId = update.top_msg_id;
                    if (update.action instanceof TLRPC.TL_sendMessageEmojiInteraction) {
                        AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.onEmojiInteractionsReceived, update.user_id, update.action));
                        continue;
                    }
                } else {
                    TLRPC.TL_updateChatUserTyping update = (TLRPC.TL_updateChatUserTyping) baseUpdate;
                    chatId = update.chat_id;
                    if (update.from_id.user_id != 0) {
                        userId = update.from_id.user_id;
                    } else if (update.from_id.channel_id != 0) {
                        userId = -update.from_id.channel_id;
                    } else {
                        userId = -update.from_id.chat_id;
                    }
                    action = update.action;
                    threadId = 0;

                    if (update.action instanceof TLRPC.TL_sendMessageEmojiInteraction) {
                        AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.onEmojiInteractionsReceived, -update.chat_id, update.action));
                        continue;
                    }
                }
                long uid = -chatId;
                if (uid == 0) {
                    uid = userId;
                }
                if (action instanceof TLRPC.TL_sendMessageTextDraftAction) {
                    AndroidUtilities.runOnUIThread(() -> BotForumHelper.getInstance(currentAccount)
                        .onBotForumDraftUpdate(userId, threadId, ((TLRPC.TL_sendMessageTextDraftAction) action).random_id, ((TLRPC.TL_sendMessageTextDraftAction) action).text));
                } else if (action instanceof TLRPC.TL_sendMessageHistoryImportAction) {
                    if (importingActions == null) {
                        importingActions = new LongSparseIntArray();
                    }
                    TLRPC.TL_sendMessageHistoryImportAction importAction = (TLRPC.TL_sendMessageHistoryImportAction) action;
                    importingActions.put(uid, importAction.progress);
                } else if (userId != getUserConfig().getClientUserId()) {
                    if (action instanceof TLRPC.TL_speakingInGroupCallAction) {
                        if (chatId != 0) {
                            if (groupSpeakingActions == null) {
                                groupSpeakingActions = new LongSparseArray<>();
                            }
                            ArrayList<Long> uids = groupSpeakingActions.get(chatId);
                            if (uids == null) {
                                uids = new ArrayList<>();
                                groupSpeakingActions.put(chatId, uids);
                            }
                            uids.add(userId);
                        }
                    } else {
                        ConcurrentHashMap<Integer, ArrayList<PrintingUser>> threads = printingUsers.get(uid);
                        ArrayList<PrintingUser> arr = threads != null ? threads.get(threadId) : null;
                        if (action instanceof TLRPC.TL_sendMessageCancelAction) {
                            if (arr != null) {
                                for (int a = 0, size = arr.size(); a < size; a++) {
                                    PrintingUser pu = arr.get(a);
                                    if (pu.userId == userId) {
                                        arr.remove(a);
                                        printChanged = true;
                                        break;
                                    }
                                }
                                if (arr.isEmpty()) {
                                    threads.remove(threadId);
                                    if (threads.isEmpty()) {
                                        printingUsers.remove(uid);
                                    }
                                }
                            }
                        } else {
                            if (threads == null) {
                                threads = new ConcurrentHashMap<>();
                                printingUsers.put(uid, threads);
                            }
                            if (arr == null) {
                                arr = new ArrayList<>();
                                threads.put(threadId, arr);
                            }
                            boolean exist = false;
                            for (PrintingUser u : arr) {
                                if (u.userId == userId) {
                                    exist = true;
                                    u.lastTime = currentTime;
                                    if (u.action.getClass() != action.getClass()) {
                                        printChanged = true;
                                    }
                                    u.action = action;
                                    break;
                                }
                            }
                            if (!exist) {
                                PrintingUser newUser = new PrintingUser();
                                newUser.userId = userId;
                                newUser.lastTime = currentTime;
                                newUser.action = action;
                                arr.add(newUser);
                                printChanged = true;
                            }
                        }
                    }
                    if (Math.abs(getConnectionsManager().getCurrentTime() - date) < 30) {
                        onlinePrivacy.put(userId, date);
                    }
                }
            } else if (baseUpdate instanceof TLRPC.TL_updateChatParticipants) {
                TLRPC.TL_updateChatParticipants update = (TLRPC.TL_updateChatParticipants) baseUpdate;
                interfaceUpdateMask |= UPDATE_MASK_CHAT_MEMBERS;
                if (chatInfoToUpdate == null) {
                    chatInfoToUpdate = new ArrayList<>();
                }
                chatInfoToUpdate.add(update.participants);
            } else if (baseUpdate instanceof TL_stories.TL_updateStory) {
                getStoriesController().processUpdate((TL_stories.TL_updateStory) baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateUserStatus) {
                interfaceUpdateMask |= UPDATE_MASK_STATUS;
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updatePeerWallpaper) {
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateUserEmojiStatus) {
                interfaceUpdateMask |= UPDATE_MASK_EMOJI_STATUS;
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateUserName) {
                interfaceUpdateMask |= UPDATE_MASK_NAME;
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateMonoForumNoPaidException) {
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateUserPhoto) {
                TLRPC.TL_updateUserPhoto update = (TLRPC.TL_updateUserPhoto) baseUpdate;
                interfaceUpdateMask |= UPDATE_MASK_AVATAR;
                getMessagesStorage().clearUserPhotos(update.user_id);
                if (dialogPhotos.get(update.user_id) != null) {
                    dialogPhotos.get(update.user_id).reset();
                }
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateUser) {
                TLRPC.TL_updateUser update = (TLRPC.TL_updateUser) baseUpdate;
                interfaceUpdateMask |= UPDATE_MASK_AVATAR;
                getMessagesStorage().clearUserPhotos(update.user_id);
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateUserPhone) {
                interfaceUpdateMask |= UPDATE_MASK_PHONE;
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TL_stories.TL_updateReadStories) {
                TL_stories.TL_updateReadStories updateReadStories = (TL_stories.TL_updateReadStories) baseUpdate;
                long dialogId = DialogObject.getPeerDialogId(updateReadStories.peer);
                getStoriesController().markStoriesAsReadFromServer(dialogId, updateReadStories.max_id);
            } else if (baseUpdate instanceof TLRPC.TL_updatePeerSettings) {
                TLRPC.TL_updatePeerSettings update = (TLRPC.TL_updatePeerSettings) baseUpdate;
                if (contactsIds == null) {
                    contactsIds = new ArrayList<>();
                }
                if (update.peer instanceof TLRPC.TL_peerUser) {
                    TLRPC.User user = usersDict.get(update.peer.user_id);
                    if (user != null) {
                        if (user.contact) {
                            int idx = contactsIds.indexOf(-update.peer.user_id);
                            if (idx != -1) {
                                contactsIds.remove(idx);
                            }
                            if (!contactsIds.contains(update.peer.user_id)) {
                                contactsIds.add(update.peer.user_id);
                            }
                        } else {
                            int idx = contactsIds.indexOf(update.peer.user_id);
                            if (idx != -1) {
                                contactsIds.remove(idx);
                            }
                            if (!contactsIds.contains(update.peer.user_id)) {
                                contactsIds.add(-update.peer.user_id);
                            }
                        }
                    }
                }
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateNewEncryptedMessage) {
                ArrayList<TLRPC.Message> decryptedMessages = getSecretChatHelper().decryptMessage(((TLRPC.TL_updateNewEncryptedMessage) baseUpdate).message);
                if (decryptedMessages != null && !decryptedMessages.isEmpty()) {
                    int cid = ((TLRPC.TL_updateNewEncryptedMessage) baseUpdate).message.chat_id;
                    long uid = DialogObject.makeEncryptedDialogId(cid);
                    if (messages == null) {
                        messages = new LongSparseArray<>();
                    }
                    ArrayList<MessageObject> arr = messages.get(uid);
                    if (arr == null) {
                        arr = new ArrayList<>();
                        messages.put(uid, arr);
                    }
                    for (int a = 0, size = decryptedMessages.size(); a < size; a++) {
                        TLRPC.Message message = decryptedMessages.get(a);
                        ImageLoader.saveMessageThumbs(message);
                        if (messagesArr == null) {
                            messagesArr = new ArrayList<>();
                        }
                        messagesArr.add(message);
                        boolean isDialogCreated = createdDialogIds.contains(uid);
                        MessageObject obj = new MessageObject(currentAccount, message, usersDict, chatsDict, isDialogCreated, isDialogCreated);
                        arr.add(obj);
                        if (pushMessages == null) {
                            pushMessages = new ArrayList<>();
                        }
                        pushMessages.add(obj);
                    }
                }
            } else if (baseUpdate instanceof TLRPC.TL_updateEncryptedChatTyping) {
                TLRPC.TL_updateEncryptedChatTyping update = (TLRPC.TL_updateEncryptedChatTyping) baseUpdate;
                TLRPC.EncryptedChat encryptedChat = getEncryptedChatDB(update.chat_id, true);
                if (encryptedChat != null) {
                    long uid = DialogObject.makeEncryptedDialogId(update.chat_id);
                    ConcurrentHashMap<Integer, ArrayList<PrintingUser>> threads = printingUsers.get(uid);
                    if (threads == null) {
                        threads = new ConcurrentHashMap<>();
                        printingUsers.put(uid, threads);
                    }
                    ArrayList<PrintingUser> arr = threads.get(0);
                    if (arr == null) {
                        arr = new ArrayList<>();
                        threads.put(0, arr);
                    }
                    boolean exist = false;
                    for (int a = 0, size = arr.size(); a < size; a++) {
                        PrintingUser u = arr.get(a);
                        if (u.userId == encryptedChat.user_id) {
                            exist = true;
                            u.lastTime = currentTime;
                            u.action = new TLRPC.TL_sendMessageTypingAction();
                            break;
                        }
                    }
                    if (!exist) {
                        PrintingUser newUser = new PrintingUser();
                        newUser.userId = encryptedChat.user_id;
                        newUser.lastTime = currentTime;
                        newUser.action = new TLRPC.TL_sendMessageTypingAction();
                        arr.add(newUser);
                        printChanged = true;
                    }
                    if (Math.abs(getConnectionsManager().getCurrentTime() - date) < 30) {
                        onlinePrivacy.put(encryptedChat.user_id, date);
                    }
                }
            } else if (baseUpdate instanceof TLRPC.TL_updateEncryptedMessagesRead) {
                TLRPC.TL_updateEncryptedMessagesRead update = (TLRPC.TL_updateEncryptedMessagesRead) baseUpdate;
                if (markAsReadEncrypted == null) {
                    markAsReadEncrypted = new SparseIntArray();
                }
                markAsReadEncrypted.put(update.chat_id, update.max_date);
                if (tasks == null) {
                    tasks = new ArrayList<>();
                }
                tasks.add((TLRPC.TL_updateEncryptedMessagesRead) baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateChatParticipantAdd) {
                TLRPC.TL_updateChatParticipantAdd update = (TLRPC.TL_updateChatParticipantAdd) baseUpdate;
                getMessagesStorage().updateChatInfo(update.chat_id, update.user_id, 0, update.inviter_id, update.version);
            } else if (baseUpdate instanceof TLRPC.TL_updateChatParticipantDelete) {
                TLRPC.TL_updateChatParticipantDelete update = (TLRPC.TL_updateChatParticipantDelete) baseUpdate;
                getMessagesStorage().updateChatInfo(update.chat_id, update.user_id, 1, 0, update.version);
            } else if (baseUpdate instanceof TLRPC.TL_updateDcOptions || baseUpdate instanceof TLRPC.TL_updateConfig) {
                getConnectionsManager().updateDcSettings();
            } else if (baseUpdate instanceof TLRPC.TL_updateEncryption) {
                getSecretChatHelper().processUpdateEncryption((TLRPC.TL_updateEncryption) baseUpdate, usersDict);
            } else if (baseUpdate instanceof TLRPC.TL_updatePeerBlocked) {
                TLRPC.TL_updatePeerBlocked finalUpdate = (TLRPC.TL_updatePeerBlocked) baseUpdate;
                getMessagesStorage().getStorageQueue().postRunnable(() -> AndroidUtilities.runOnUIThread(() -> {
                    long id = MessageObject.getPeerId(finalUpdate.peer_id);
                    if (finalUpdate.blocked) {
                        if (blockePeers.indexOfKey(id) < 0) {
                            blockePeers.put(id, 1);
                        }
                    } else {
                        blockePeers.delete(id);
                    }
                    getNotificationCenter().postNotificationName(NotificationCenter.blockedUsersDidLoad);
                    getStoriesController().updateBlockUser(id, finalUpdate.blocked_my_stories_from, false);
                }));
            } else if (baseUpdate instanceof TLRPC.TL_updateServiceNotification) {
                TLRPC.TL_updateServiceNotification update = (TLRPC.TL_updateServiceNotification) baseUpdate;
                if (update.popup && update.message != null && update.message.length() > 0) {
                    AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.needShowAlert, 2, update.message, update.type));
                }
                if ((update.flags & 2) != 0) {
                    TLRPC.TL_message newMessage = new TLRPC.TL_message();
                    newMessage.invert_media = update.invert_media;
                    newMessage.local_id = newMessage.id = getUserConfig().getNewMessageId();
                    getUserConfig().saveConfig(false);
                    newMessage.unread = true;
                    newMessage.flags = TLRPC.MESSAGE_FLAG_HAS_FROM_ID;
                    if (update.inbox_date != 0) {
                        newMessage.date = update.inbox_date;
                    } else {
                        newMessage.date = (int) (System.currentTimeMillis() / 1000);
                    }
                    newMessage.from_id = new TLRPC.TL_peerUser();
                    newMessage.from_id.user_id = 777000;
                    newMessage.peer_id = new TLRPC.TL_peerUser();
                    newMessage.peer_id.user_id = getUserConfig().getClientUserId();
                    newMessage.dialog_id = 777000;
                    if (update.media != null) {
                        newMessage.media = update.media;
                        newMessage.flags |= TLRPC.MESSAGE_FLAG_HAS_MEDIA;
                    }
                    newMessage.message = update.message;
                    if (update.entities != null) {
                        newMessage.entities = update.entities;
                        newMessage.flags |= 128;
                    }

                    if (messagesArr == null) {
                        messagesArr = new ArrayList<>();
                    }
                    messagesArr.add(newMessage);
                    boolean isDialogCreated = createdDialogIds.contains(newMessage.dialog_id);
                    MessageObject obj = new MessageObject(currentAccount, newMessage, usersDict, chatsDict, isDialogCreated, isDialogCreated);
                    if (messages == null) {
                        messages = new LongSparseArray<>();
                    }
                    ArrayList<MessageObject> arr = messages.get(newMessage.dialog_id);
                    if (arr == null) {
                        arr = new ArrayList<>();
                        messages.put(newMessage.dialog_id, arr);
                    }
                    arr.add(obj);
                    if (pushMessages == null) {
                        pushMessages = new ArrayList<>();
                    }
                    pushMessages.add(obj);
                }
            } else if (baseUpdate instanceof TLRPC.TL_updateFolderPeers) {
                TLRPC.TL_updateFolderPeers update = (TLRPC.TL_updateFolderPeers) baseUpdate;
                if (folderUpdates == null) {
                    folderUpdates = new ArrayList<>();
                }
                folderUpdates.add(update);
            } else if (baseUpdate instanceof TLRPC.TL_updateWebPage) {
                TLRPC.TL_updateWebPage update = (TLRPC.TL_updateWebPage) baseUpdate;
                if (webPages == null) {
                    webPages = new LongSparseArray<>();
                }
                webPages.put(update.webpage.id, update.webpage);
            } else if (baseUpdate instanceof TLRPC.TL_updateChannelWebPage) {
                TLRPC.TL_updateChannelWebPage update = (TLRPC.TL_updateChannelWebPage) baseUpdate;
                if (webPages == null) {
                    webPages = new LongSparseArray<>();
                }
                webPages.put(update.webpage.id, update.webpage);
            } else if (baseUpdate instanceof TLRPC.TL_updateChannelTooLong) {
                TLRPC.TL_updateChannelTooLong update = (TLRPC.TL_updateChannelTooLong) baseUpdate;
                if (BuildVars.LOGS_ENABLED) {
                    FileLog.d(baseUpdate + " channelId = " + update.channel_id);
                }
                int channelPts = channelsPts.get(update.channel_id, 0);
                if (channelPts == 0) {
                    channelPts = getMessagesStorage().getChannelPtsSync(update.channel_id);
                    if (channelPts == 0) {
                        TLRPC.Chat chat = chatsDict.get(update.channel_id);
                        if (chat == null || chat.min) {
                            chat = getChat(update.channel_id);
                        }
                        if (chat == null || chat.min) {
                            chat = getMessagesStorage().getChatSync(update.channel_id);
                            putChat(chat, true);
                        }
                        if (chat != null && !chat.min) {
                            loadUnknownChannel(chat, 0);
                        }
                    } else {
                        channelsPts.put(update.channel_id, channelPts);
                    }
                }
                if (channelPts != 0) {
                    if ((update.flags & 1) != 0) {
                        if (update.pts > channelPts) {
                            getChannelDifference(update.channel_id);
                        }
                    } else {
                        getChannelDifference(update.channel_id);
                    }
                }
            } else if (baseUpdate instanceof TLRPC.TL_updateReadChannelInbox) {
                TLRPC.TL_updateReadChannelInbox update = (TLRPC.TL_updateReadChannelInbox) baseUpdate;

                long dialogId = -update.channel_id;
                Integer value = dialogs_read_inbox_max.get(dialogId);
                if (value == null) {
                    value = getMessagesStorage().getDialogReadMax(false, dialogId);
                }

                if (markAsReadMessagesInbox == null) {
                    markAsReadMessagesInbox = new LongSparseIntArray();
                }
                if (stillUnreadMessagesCount == null) {
                    stillUnreadMessagesCount = new LongSparseIntArray();
                }
                markAsReadMessagesInbox.put(dialogId, update.max_id);
                stillUnreadMessagesCount.put(dialogId, update.still_unread_count);
                dialogs_read_inbox_max.put(dialogId, Math.max(value, update.max_id));
                FileLog.d("TL_updateReadChannelInbox " + dialogId + "  new unread = " + update.still_unread_count + " max id = " + update.max_id + " from get diff " + fromGetDifference);
            } else if (
                baseUpdate instanceof TLRPC.TL_updatePinnedForumTopic ||
                baseUpdate instanceof TLRPC.TL_updatePinnedForumTopics
            ) {
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateReadChannelOutbox) {
                TLRPC.TL_updateReadChannelOutbox update = (TLRPC.TL_updateReadChannelOutbox) baseUpdate;
                if (BuildVars.LOGS_ENABLED) {
                    FileLog.d(baseUpdate + " channelId = " + update.channel_id);
                }
                if (markAsReadMessagesOutbox == null) {
                    markAsReadMessagesOutbox = new LongSparseIntArray();
                }
                long dialogId = -update.channel_id;
                markAsReadMessagesOutbox.put(dialogId, update.max_id);
                Integer value = dialogs_read_outbox_max.get(dialogId);
                if (value == null) {
                    value = getMessagesStorage().getDialogReadMax(true, dialogId);
                }
                dialogs_read_outbox_max.put(dialogId, Math.max(value, update.max_id));
            } else if (baseUpdate instanceof TLRPC.TL_updateDeleteChannelMessages) {
                TLRPC.TL_updateDeleteChannelMessages update = (TLRPC.TL_updateDeleteChannelMessages) baseUpdate;
                if (BuildVars.LOGS_ENABLED) {
                    FileLog.d(baseUpdate + " channelId = " + update.channel_id);
                }
                if (deletedMessages == null) {
                    deletedMessages = new LongSparseArray<>();
                }
                long dialogId = -update.channel_id;
                ArrayList<Integer> arrayList = deletedMessages.get(dialogId);
                if (arrayList == null) {
                    arrayList = new ArrayList<>();
                    deletedMessages.put(dialogId, arrayList);
                }
                arrayList.addAll(update.messages);
            } else if (baseUpdate instanceof TLRPC.TL_updateChannel) {
                if (BuildVars.LOGS_ENABLED) {
                    TLRPC.TL_updateChannel update = (TLRPC.TL_updateChannel) baseUpdate;
                    FileLog.d(baseUpdate + " channelId = " + update.channel_id);
                }
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateChat || baseUpdate instanceof TLRPC.TL_updateSentStoryReaction) {
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateChannelMessageViews) {
                TLRPC.TL_updateChannelMessageViews update = (TLRPC.TL_updateChannelMessageViews) baseUpdate;
                if (BuildVars.LOGS_ENABLED) {
                    FileLog.d(baseUpdate + " channelId = " + update.channel_id);
                }
                if (channelViews == null) {
                    channelViews = new LongSparseArray<>();
                }
                long dialogId = -update.channel_id;
                SparseIntArray array = channelViews.get(dialogId);
                if (array == null) {
                    array = new SparseIntArray();
                    channelViews.put(dialogId, array);
                }
                array.put(update.id, update.views);
            } else if (baseUpdate instanceof TLRPC.TL_updateChannelMessageForwards) {
                TLRPC.TL_updateChannelMessageForwards update = (TLRPC.TL_updateChannelMessageForwards) baseUpdate;
                if (BuildVars.LOGS_ENABLED) {
                    FileLog.d(baseUpdate + " channelId = " + update.channel_id);
                }
                if (channelForwards == null) {
                    channelForwards = new LongSparseArray<>();
                }
                long dialogId = -update.channel_id;
                SparseIntArray array = channelForwards.get(dialogId);
                if (array == null) {
                    array = new SparseIntArray();
                    channelForwards.put(dialogId, array);
                }
                array.put(update.id, update.forwards);
            } else if (baseUpdate instanceof TLRPC.TL_updateChatParticipantAdmin) {
                TLRPC.TL_updateChatParticipantAdmin update = (TLRPC.TL_updateChatParticipantAdmin) baseUpdate;
                getMessagesStorage().updateChatInfo(update.chat_id, update.user_id, 2, update.is_admin ? 1 : 0, update.version);
            } else if (baseUpdate instanceof TLRPC.TL_updateChatDefaultBannedRights) {
                TLRPC.TL_updateChatDefaultBannedRights update = (TLRPC.TL_updateChatDefaultBannedRights) baseUpdate;
                long chatId;
                if (update.peer.channel_id != 0) {
                    chatId = update.peer.channel_id;
                } else {
                    chatId = update.peer.chat_id;
                }
                getMessagesStorage().updateChatDefaultBannedRights(chatId, update.default_banned_rights, update.version);
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateEditChannelMessage || baseUpdate instanceof TLRPC.TL_updateEditMessage) {
                TLRPC.Message message;
                if (baseUpdate instanceof TLRPC.TL_updateEditChannelMessage) {
                    message = ((TLRPC.TL_updateEditChannelMessage) baseUpdate).message;
                    TLRPC.Chat chat = chatsDict.get(message.peer_id.channel_id);
                    if (chat == null) {
                        chat = getChat(message.peer_id.channel_id);
                    }
                    if (chat == null) {
                        chat = getMessagesStorage().getChatSync(message.peer_id.channel_id);
                        putChat(chat, true);
                    }
                } else {
                    message = ((TLRPC.TL_updateEditMessage) baseUpdate).message;
                    if (message.dialog_id == clientUserId) {
                        message.unread = false;
                        message.media_unread = false;
                        message.out = true;
                    }
                }
                if (!message.out) {
                    long from_id = DialogObject.getPeerDialogId(message.from_id);
                    if (from_id == clientUserId) {
                        message.out = true;
                    } else {
                        TLRPC.TL_channels_sendAsPeers peers = getSendAsPeers(MessageObject.getDialogId(message));
                        if (peers != null) {
                            for (TLRPC.TL_sendAsPeer peer : peers.peers) {
                                if (peer != null && from_id == DialogObject.getPeerDialogId(peer.peer)) {
                                    message.out = true;
                                    break;
                                }
                            }
                        }
                    }
                }
                if (!fromGetDifference) {
                    for (int a = 0, count = message.entities.size(); a < count; a++) {
                        TLRPC.MessageEntity entity = message.entities.get(a);
                        if (entity instanceof TLRPC.TL_messageEntityMentionName) {
                            long userId = ((TLRPC.TL_messageEntityMentionName) entity).user_id;
                            TLRPC.User user = usersDict.get(userId);
                            if (user == null || user.min) {
                                user = getUser(userId);
                            }
                            if (user == null || user.min) {
                                user = getMessagesStorage().getUserSync(userId);
                                if (user != null && user.min) {
                                    user = null;
                                }
                                putUser(user, true);
                            }
                            if (user == null) {
                                return false;
                            }
                        }
                    }
                }

                MessageObject.getDialogId(message);

                ConcurrentHashMap<Long, Integer> read_max = message.out ? dialogs_read_outbox_max : dialogs_read_inbox_max;
                Integer value = read_max.get(message.dialog_id);
                if (value == null) {
                    value = getMessagesStorage().getDialogReadMax(message.out, message.dialog_id);
                    read_max.put(message.dialog_id, value);
                }
                message.unread = value < message.id;
                if (message.dialog_id == clientUserId) {
                    message.out = true;
                    message.unread = false;
                    message.media_unread = false;
                }
                if (message.out && message.message == null) {
                    message.message = "";
                    message.attachPath = "";
                }

                ImageLoader.saveMessageThumbs(message);
                AndroidUtilities.runOnUIThread(()-> getSendMessagesHelper().onMessageEdited(message));

                boolean isDialogCreated = createdDialogIds.contains(message.dialog_id);
                MessageObject obj = new MessageObject(currentAccount, message, usersDict, chatsDict, isDialogCreated, isDialogCreated);
                getTranslateController().invalidateTranslation(obj);

                LongSparseArray<ArrayList<MessageObject>> array;
                if (editingMessages == null) {
                    editingMessages = new LongSparseArray<>();
                }
                array = editingMessages;
                ArrayList<MessageObject> arr = array.get(message.dialog_id);
                if (arr == null) {
                    arr = new ArrayList<>();
                    array.put(message.dialog_id, arr);
                }
                arr.add(obj);
            } else if (baseUpdate instanceof TLRPC.TL_updatePinnedChannelMessages) {
                TLRPC.TL_updatePinnedChannelMessages update = (TLRPC.TL_updatePinnedChannelMessages) baseUpdate;
                if (BuildVars.LOGS_ENABLED) {
                    FileLog.d(baseUpdate + " channelId = " + update.channel_id);
                }
                getMessagesStorage().updatePinnedMessages(-update.channel_id, update.messages, update.pinned, -1, 0, false, null);
            } else if (baseUpdate instanceof TLRPC.TL_updatePinnedMessages) {
                TLRPC.TL_updatePinnedMessages update = (TLRPC.TL_updatePinnedMessages) baseUpdate;
                getMessagesStorage().updatePinnedMessages(MessageObject.getPeerId(update.peer), update.messages, update.pinned, -1, 0, false, null);
            } else if (baseUpdate instanceof TLRPC.TL_updateGroupCallConnection) {

            } else if (baseUpdate instanceof TLRPC.TL_updateLangPack) {
                TLRPC.TL_updateLangPack update = (TLRPC.TL_updateLangPack) baseUpdate;
                AndroidUtilities.runOnUIThread(() -> LocaleController.getInstance().saveRemoteLocaleStringsForCurrentLocale(update.difference, currentAccount));
            } else if (baseUpdate instanceof TLRPC.TL_updateLangPackTooLong) {
                TLRPC.TL_updateLangPackTooLong update = (TLRPC.TL_updateLangPackTooLong) baseUpdate;
                LocaleController.getInstance().reloadCurrentRemoteLocale(currentAccount, update.lang_code, false, null);
            } else if (baseUpdate instanceof TLRPC.TL_updateChannelAvailableMessages) {
                TLRPC.TL_updateChannelAvailableMessages update = (TLRPC.TL_updateChannelAvailableMessages) baseUpdate;
                if (clearHistoryMessages == null) {
                    clearHistoryMessages = new LongSparseIntArray();
                }
                long dialogId = -update.channel_id;
                int currentValue = clearHistoryMessages.get(dialogId, 0);
                if (currentValue == 0 || currentValue < update.available_min_id) {
                    clearHistoryMessages.put(dialogId, update.available_min_id);
                }
            } else if (baseUpdate instanceof TLRPC.TL_updateMessagePoll) {
                TLRPC.TL_updateMessagePoll update = (TLRPC.TL_updateMessagePoll) baseUpdate;
                long time = getSendMessagesHelper().getVoteSendTime(update.poll_id);
                if (Math.abs(SystemClock.elapsedRealtime() - time) < 600) {
                    continue;
                }
                getMessagesStorage().updateMessagePollResults(update.poll_id, update.poll, update.results);
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateMessageReactions) {
                TLRPC.TL_updateMessageReactions update = (TLRPC.TL_updateMessageReactions) baseUpdate;
                long dialogId = MessageObject.getPeerId(update.peer);

                getMessagesStorage().updateMessageReactions(dialogId, update.msg_id, update.reactions);

                if (update.updateUnreadState) {
                    SparseBooleanArray sparseBooleanArray = new SparseBooleanArray();
                    sparseBooleanArray.put(update.msg_id, MessageObject.hasUnreadReactions(update.reactions));
                    final long topicId = isMonoForum(dialogId) && ChatObject.canManageMonoForum(currentAccount, dialogId) ? DialogObject.getPeerDialogId(update.saved_peer_id) : update.top_msg_id;
                    if (BuildVars.DEBUG_PRIVATE_VERSION) {
                        FileLog.d("check reactions for " + dialogId + " " + topicId);
                    }
                    checkUnreadReactions(dialogId, topicId, sparseBooleanArray);
                }
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateMessageExtendedMedia) {
                TLRPC.TL_updateMessageExtendedMedia extendedMedia = (TLRPC.TL_updateMessageExtendedMedia) baseUpdate;
                if (!extendedMedia.extended_media.isEmpty()) {
                    TLRPC.Message msg = getMessagesStorage().getMessage(DialogObject.getPeerDialogId(extendedMedia.peer), extendedMedia.msg_id);
                    if (msg != null) {
                        msg.media.extended_media = new ArrayList<>(extendedMedia.extended_media);
                        if (messagesArr == null) {
                            messagesArr = new ArrayList<>();
                        }
                        messagesArr.add(msg);
                    }
                    if (updatesOnMainThread == null) {
                        updatesOnMainThread = new ArrayList<>();
                    }
                    updatesOnMainThread.add(baseUpdate);
                }
            } else if (baseUpdate instanceof TLRPC.TL_updateGeoLiveViewed) {
                getLocationController().setNewLocationEndWatchTime();
            } else if (baseUpdate instanceof TLRPC.TL_updateReadChannelDiscussionInbox) {
                TLRPC.TL_updateReadChannelDiscussionInbox update = (TLRPC.TL_updateReadChannelDiscussionInbox) baseUpdate;
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                if (topicsReadInbox == null) {
                    topicsReadInbox = new HashMap<>();
                }
                MessagesStorage.TopicKey topicKey = MessagesStorage.TopicKey.of(-update.channel_id, update.top_msg_id);
                topicsReadInbox.put(topicKey, Math.max(Utilities.getOrDefault(topicsReadInbox, topicKey, 0), update.read_max_id));
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            } else if (baseUpdate instanceof TLRPC.TL_updateReadChannelDiscussionOutbox) {
                TLRPC.TL_updateReadChannelDiscussionOutbox update = (TLRPC.TL_updateReadChannelDiscussionOutbox) baseUpdate;
                if (topicsReadOutbox == null) {
                    topicsReadOutbox = new HashMap<>();
                }
                MessagesStorage.TopicKey topicKey = MessagesStorage.TopicKey.of(-update.channel_id, update.top_msg_id);
                topicsReadOutbox.put(MessagesStorage.TopicKey.of(-update.channel_id, update.top_msg_id), Math.max(Utilities.getOrDefault(topicsReadOutbox, topicKey, 0), update.read_max_id));
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
//            } else if (
//                baseUpdate instanceof TLRPC.TL_updateStickerSets ||
//                baseUpdate instanceof TLRPC.TL_updateStickerSetsOrder ||
//                baseUpdate instanceof TLRPC.TL_updateNewStickerSet ||
//                baseUpdate instanceof TLRPC.TL_updateDraftMessage ||
//                baseUpdate instanceof TLRPC.TL_updateMoveStickerSetToTop ||
//                baseUpdate instanceof TLRPC.TL_updateSavedGifs ||
//                baseUpdate instanceof TLRPC.TL_updateReadFeaturedStickers ||
//                baseUpdate instanceof TLRPC.TL_updatePhoneCallSignalingData ||
//                baseUpdate instanceof TLRPC.TL_updateBotCommands ||
//                baseUpdate instanceof TLRPC.TL_updateGroupCall ||
//                baseUpdate instanceof TLRPC.TL_updateReadFeaturedEmojiStickers ||
//                baseUpdate instanceof TLRPC.TL_updateGroupCallParticipants ||
//                baseUpdate instanceof TLRPC.TL_updatePhoneCall ||
//                baseUpdate instanceof TLRPC.TL_updateRecentReactions ||
//                baseUpdate instanceof TLRPC.TL_updateSavedReactionTags ||
//                baseUpdate instanceof TLRPC.TL_updatePeerLocated ||
//                baseUpdate instanceof TLRPC.TL_updateTheme ||
//                baseUpdate instanceof TLRPC.TL_updateDialogFilter ||
//                baseUpdate instanceof TLRPC.TL_updateDialogFilterOrder ||
//                baseUpdate instanceof TLRPC.TL_updateDialogFilters ||
//                baseUpdate instanceof TLRPC.TL_updateRecentEmojiStatuses ||
//                baseUpdate instanceof TLRPC.TL_updateWebViewResultSent ||
//                baseUpdate instanceof TLRPC.TL_updateAttachMenuBots ||
//                baseUpdate instanceof TLRPC.TL_updateBotMenuButton ||
//                baseUpdate instanceof TLRPC.TL_updatePeerHistoryTTL ||
//                baseUpdate instanceof TLRPC.TL_updatePendingJoinRequests ||
//                baseUpdate instanceof TLRPC.TL_updateSavedRingtones ||
//                baseUpdate instanceof TLRPC.TL_updateTranscribedAudio ||
//                baseUpdate instanceof TLRPC.TL_updateTranscribeAudio ||
//                baseUpdate instanceof TLRPC.TL_updateChannelViewForumAsMessages ||
//                baseUpdate instanceof TLRPC.TL_updatePinnedSavedDialogs ||
//                baseUpdate instanceof TLRPC.TL_updateSavedDialogPinned ||
//                baseUpdate instanceof TLRPC.TL_updateNewAuthorization ||
//                baseUpdate instanceof TLRPC.TL_updateNotifySettings ||
//                baseUpdate instanceof TL_stories.TL_updateStoriesStealthMode ||
//                baseUpdate instanceof TLRPC.TL_updateDialogPinned ||
//                baseUpdate instanceof TLRPC.TL_updatePinnedDialogs ||
//                baseUpdate instanceof TLRPC.TL_updatePrivacy ||
//                baseUpdate instanceof TLRPC.TL_updateDialogUnreadMark ||
//                baseUpdate instanceof TLRPC.TL_updateContactsReset ||
//                baseUpdate instanceof TLRPC.TL_updateFavedStickers
//            ) {
//                if (updatesOnMainThread == null) {
//                    updatesOnMainThread = new ArrayList<>();
//                }
//                updatesOnMainThread.add(baseUpdate);
            } else {
                if (updatesOnMainThread == null) {
                    updatesOnMainThread = new ArrayList<>();
                }
                updatesOnMainThread.add(baseUpdate);
            }
        }
        if (messages != null) {
            for (int a = 0, size = messages.size(); a < size; a++) {
                long key = messages.keyAt(a);
                ArrayList<MessageObject> value = messages.valueAt(a);
                if (updatePrintingUsersWithNewMessages(key, value)) {
                    printChanged = true;
                }
            }
        }

        if (printChanged) {
            updatePrintingStrings();
        }

        int interfaceUpdateMaskFinal = interfaceUpdateMask;
        boolean printChangedArg = printChanged;

        if (contactsIds != null) {
            getContactsController().processContactsUpdates(contactsIds, usersDict);
        }

        if (pushMessages != null) {
            ArrayList<MessageObject> pushMessagesFinal = pushMessages;
            getMessagesStorage().getStorageQueue().postRunnable(() -> AndroidUtilities.runOnUIThread(() -> getNotificationsController().processNewMessages(pushMessagesFinal, true, false, null)));
        }

        if (scheduledMessagesArr != null) {
            getMessagesStorage().putMessages(scheduledMessagesArr, true, true, false, getDownloadController().getAutodownloadMask(), 1, 0);
        }

        if (messagesArr != null) {
            getStatsController().incrementReceivedItemsCount(ApplicationLoader.getCurrentNetworkType(), StatsController.TYPE_MESSAGES, messagesArr.size());
            getMessagesStorage().putMessages(messagesArr, true, true, false, getDownloadController().getAutodownloadMask(), 0, 0);
        }
        if (editingMessages != null) {
            for (int b = 0, size = editingMessages.size(); b < size; b++) {
                TLRPC.TL_messages_messages messagesRes = new TLRPC.TL_messages_messages();
                ArrayList<MessageObject> messageObjects = editingMessages.valueAt(b);
                for (int a = 0, size2 = messageObjects.size(); a < size2; a++) {
                    messagesRes.messages.add(messageObjects.get(a).messageOwner);
                }
                getMessagesStorage().putMessages(messagesRes, editingMessages.keyAt(b), -2, 0, false, 0, 0);
            }
            LongSparseArray<ArrayList<MessageObject>> editingMessagesFinal = editingMessages;
            getMessagesStorage().getStorageQueue().postRunnable(() -> AndroidUtilities.runOnUIThread(() -> {
                getNotificationsController().processEditedMessages(editingMessagesFinal);
                getTopicsController().processEditedMessages(editingMessagesFinal);
            }));
        }

        if (channelViews != null || channelForwards != null || channelReplies != null) {
            getMessagesStorage().putChannelViews(channelViews, channelForwards, channelReplies, true);
        }
        if (folderUpdates != null) {
            for (int a = 0, size = folderUpdates.size(); a < size; a++) {
                getMessagesStorage().setDialogsFolderId(folderUpdates.get(a).folder_peers, null, 0, 0);
            }
        }

        LongSparseArray<ArrayList<MessageObject>> editingMessagesFinal = editingMessages;
        LongSparseArray<SparseIntArray> channelViewsFinal = channelViews;
        LongSparseArray<SparseIntArray> channelForwardsFinal = channelForwards;
        LongSparseArray<SparseArray<TLRPC.MessageReplies>> channelRepliesFinal = channelReplies;
        LongSparseArray<TLRPC.WebPage> webPagesFinal = webPages;
        LongSparseArray<ArrayList<MessageObject>> messagesFinal = messages;
        LongSparseArray<ArrayList<MessageObject>> scheduledMessagesFinal = scheduledMessages;
        ArrayList<TLRPC.ChatParticipants> chatInfoToUpdateFinal = chatInfoToUpdate;
        ArrayList<Long> contactsIdsFinal = contactsIds;
        ArrayList<TLRPC.Update> updatesOnMainThreadFinal = updatesOnMainThread;
        ArrayList<ImageLoader.MessageThumb> updateMessageThumbs = messageThumbs;
        ArrayList<TLRPC.TL_updateFolderPeers> folderUpdatesFinal = folderUpdates;
        LongSparseArray<ArrayList<Long>> groupSpeakingActionsFinal = groupSpeakingActions;
        LongSparseIntArray importingActionsFinal = importingActions;

        AndroidUtilities.runOnUIThread(() -> {
            int updateMask = interfaceUpdateMaskFinal;
            boolean forceDialogsUpdate = false;
            int updateDialogFiltersFlags = 0;

            if (updatesOnMainThreadFinal != null) {
                ArrayList<TLRPC.User> dbUsers = new ArrayList<>();
                ArrayList<TLRPC.User> dbUsersStatus = new ArrayList<>();
                SharedPreferences.Editor editor = null;
                for (int a = 0, size = updatesOnMainThreadFinal.size(); a < size; a++) {
                    TLRPC.Update baseUpdate = updatesOnMainThreadFinal.get(a);
                    if (baseUpdate instanceof TLRPC.TL_updatePrivacy) {
                        TLRPC.TL_updatePrivacy update = (TLRPC.TL_updatePrivacy) baseUpdate;
                        if (update.key instanceof TLRPC.TL_privacyKeyStatusTimestamp) {
                            getContactsController().setPrivacyRules(update.rules, ContactsController.PRIVACY_RULES_TYPE_LASTSEEN);
                        } else if (update.key instanceof TLRPC.TL_privacyKeyChatInvite) {
                            getContactsController().setPrivacyRules(update.rules, ContactsController.PRIVACY_RULES_TYPE_INVITE);
                        } else if (update.key instanceof TLRPC.TL_privacyKeyPhoneCall) {
                            getContactsController().setPrivacyRules(update.rules, ContactsController.PRIVACY_RULES_TYPE_CALLS);
                        } else if (update.key instanceof TLRPC.TL_privacyKeyPhoneP2P) {
                            getContactsController().setPrivacyRules(update.rules, ContactsController.PRIVACY_RULES_TYPE_P2P);
                        } else if (update.key instanceof TLRPC.TL_privacyKeyProfilePhoto) {
                            getContactsController().setPrivacyRules(update.rules, ContactsController.PRIVACY_RULES_TYPE_PHOTO);
                        } else if (update.key instanceof TLRPC.TL_privacyKeyForwards) {
                            getContactsController().setPrivacyRules(update.rules, ContactsController.PRIVACY_RULES_TYPE_FORWARDS);
                        } else if (update.key instanceof TLRPC.TL_privacyKeyPhoneNumber) {
                            getContactsController().setPrivacyRules(update.rules, ContactsController.PRIVACY_RULES_TYPE_PHONE);
                        } else if (update.key instanceof TLRPC.TL_privacyKeyAddedByPhone) {
                            getContactsController().setPrivacyRules(update.rules, ContactsController.PRIVACY_RULES_TYPE_ADDED_BY_PHONE);
                        } else if (update.key instanceof TLRPC.TL_privacyKeyVoiceMessages) {
                            getContactsController().setPrivacyRules(update.rules, ContactsController.PRIVACY_RULES_TYPE_VOICE_MESSAGES);
                        } else if (update.key instanceof TLRPC.TL_privacyKeyAbout) {
                            getContactsController().setPrivacyRules(update.rules, ContactsController.PRIVACY_RULES_TYPE_BIO);
                        } else if (update.key instanceof TLRPC.TL_privacyKeyBirthday) {
                            getContactsController().setPrivacyRules(update.rules, ContactsController.PRIVACY_RULES_TYPE_BIRTHDAY);
                        } else if (update.key instanceof TLRPC.TL_privacyKeyStarGiftsAutoSave) {
                            getContactsController().setPrivacyRules(update.rules, ContactsController.PRIVACY_RULES_TYPE_GIFTS);
                        }
                    } else if (baseUpdate instanceof TLRPC.TL_updateStarGiftAuctionState) {
                        GiftAuctionController.getInstance(currentAccount).processUpdate((TLRPC.TL_updateStarGiftAuctionState) baseUpdate);
                    } else if (baseUpdate instanceof TLRPC.TL_updateStarGiftAuctionUserState) {
                        GiftAuctionController.getInstance(currentAccount).processUpdate((TLRPC.TL_updateStarGiftAuctionUserState) baseUpdate);
                    } else if (baseUpdate instanceof TLRPC.TL_updateStarsRevenueStatus) {
                        BotStarsController.getInstance(currentAccount).onUpdate((TLRPC.TL_updateStarsRevenueStatus) baseUpdate);
                    } else if (baseUpdate instanceof TLRPC.TL_updateUserStatus) {
                        TLRPC.TL_updateUserStatus update = (TLRPC.TL_updateUserStatus) baseUpdate;
                        TLRPC.User currentUser = getUser(update.user_id);

                        if (update.status instanceof TLRPC.TL_userStatusRecently) {
                            update.status.expires = -100;
                        } else if (update.status instanceof TLRPC.TL_userStatusLastWeek) {
                            update.status.expires = -101;
                        } else if (update.status instanceof TLRPC.TL_userStatusLastMonth) {
                            update.status.expires = -102;
                        }
                        if (currentUser != null) {
                            currentUser.id = update.user_id;
                            currentUser.status = update.status;
                        }
                        TLRPC.User toDbUser = new TLRPC.TL_user();
                        toDbUser.id = update.user_id;
                        toDbUser.status = update.status;
                        dbUsersStatus.add(toDbUser);
                        if (update.user_id == getUserConfig().getClientUserId()) {
                            getNotificationsController().setLastOnlineFromOtherDevice(update.status.expires);
                        }
                    } else if (baseUpdate instanceof TLRPC.TL_updateMonoForumNoPaidException) {
                        TLRPC.TL_updateMonoForumNoPaidException update = (TLRPC.TL_updateMonoForumNoPaidException) baseUpdate;
                        StarsController.getInstance(currentAccount).processUpdateMonoForumNoPaidException(
                            update.channel_id,
                            DialogObject.getPeerDialogId(update.saved_peer_id),
                            update.exception
                        );
                    } else if (baseUpdate instanceof TLRPC.TL_updatePeerWallpaper) {
                        TLRPC.TL_updatePeerWallpaper update = (TLRPC.TL_updatePeerWallpaper) baseUpdate;
                        ChatThemeController.getInstance(currentAccount).processUpdate(update);
                    } else if (baseUpdate instanceof TLRPC.TL_updateUserEmojiStatus) {
                        TLRPC.TL_updateUserEmojiStatus update = (TLRPC.TL_updateUserEmojiStatus) baseUpdate;
                        TLRPC.User currentUser = getUser(update.user_id);

                        if (currentUser != null) {
                            currentUser.id = update.user_id;
                            currentUser.emoji_status = update.emoji_status;
                            if (UserObject.isUserSelf(currentUser)) {
                                getNotificationCenter().postNotificationName(NotificationCenter.userEmojiStatusUpdated, currentUser);
                            }
                        }
                        TLRPC.User toDbUser = new TLRPC.TL_user();
                        toDbUser.id = update.user_id;
                        toDbUser.emoji_status = update.emoji_status;
                        dbUsers.add(toDbUser);
                    } else if (baseUpdate instanceof TLRPC.TL_updateUserName) {
                        TLRPC.TL_updateUserName update = (TLRPC.TL_updateUserName) baseUpdate;
                        TLRPC.User currentUser = getUser(update.user_id);
                        if (currentUser != null) {
                            if (!UserObject.isContact(currentUser)) {
                                currentUser.first_name = update.first_name;
                                currentUser.last_name = update.last_name;
                            }
                            if (currentUser.usernames != null) {
                                for (int i = 0; i < currentUser.usernames.size(); ++i) {
                                    TLRPC.TL_username username = currentUser.usernames.get(i);
                                    if (username != null && !TextUtils.isEmpty(username.username)) {
                                        objectsByUsernames.remove(username.username);
                                    }
                                }
                            }
                            for (int i = 0; i < update.usernames.size(); ++i) {
                                String username = update.usernames.get(i).username;
                                if (!TextUtils.isEmpty(username) && update.usernames.get(i).active) {
                                    objectsByUsernames.put(username, currentUser);
                                }
                            }
                            if (update.usernames != null && update.usernames.size() > 1) {
                                currentUser.username = null;
                                currentUser.usernames = update.usernames;
                            } else {
                                currentUser.username = (update.usernames != null && update.usernames.size() == 1) ? update.usernames.get(0).username : null;
                                currentUser.usernames.clear();
                            }
                        }
                        TLRPC.User toDbUser = new TLRPC.TL_user();
                        toDbUser.id = update.user_id;
                        toDbUser.first_name = update.first_name;
                        toDbUser.last_name = update.last_name;
                        toDbUser.username = (update.usernames != null && update.usernames.size() == 1) ? update.usernames.get(0).username : null;
                        dbUsers.add(toDbUser);
                    } else if (baseUpdate instanceof TLRPC.TL_updateDialogPinned) {
                        TLRPC.TL_updateDialogPinned update = (TLRPC.TL_updateDialogPinned) baseUpdate;
                        long did;
                        if (update.peer instanceof TLRPC.TL_dialogPeer) {
                            TLRPC.TL_dialogPeer dialogPeer = (TLRPC.TL_dialogPeer) update.peer;
                            did = DialogObject.getPeerDialogId(dialogPeer.peer);
                        } else {
                            did = 0;
                        }
                        if (!pinDialog(did, update.pinned, null, -1)) {
                            getUserConfig().setPinnedDialogsLoaded(update.folder_id, false);
                            getUserConfig().saveConfig(false);
                            loadPinnedDialogs(update.folder_id, did, null);
                        }
                    } else if (baseUpdate instanceof TLRPC.TL_updatePinnedDialogs) {
                        TLRPC.TL_updatePinnedDialogs update = (TLRPC.TL_updatePinnedDialogs) baseUpdate;
                        getUserConfig().setPinnedDialogsLoaded(update.folder_id, false);
                        getUserConfig().saveConfig(false);
                        ArrayList<Long> order;
                        if ((update.flags & 1) != 0) {
                            order = new ArrayList<>();
                            ArrayList<TLRPC.DialogPeer> peers = update.order;
                            for (int b = 0, size2 = peers.size(); b < size2; b++) {
                                long did;
                                TLRPC.DialogPeer dialogPeer = peers.get(b);
                                if (dialogPeer instanceof TLRPC.TL_dialogPeer) {
                                    TLRPC.Peer peer = ((TLRPC.TL_dialogPeer) dialogPeer).peer;
                                    if (peer.user_id != 0) {
                                        did = peer.user_id;
                                    } else if (peer.chat_id != 0) {
                                        did = -peer.chat_id;
                                    } else {
                                        did = -peer.channel_id;
                                    }
                                } else {
                                    did = 0;
                                }
                                order.add(did);
                            }
                        } else {
                            order = null;
                        }
                        loadPinnedDialogs(update.folder_id, 0, order);
                    } else if (baseUpdate instanceof TLRPC.TL_updateUserPhoto) {
                        TLRPC.TL_updateUserPhoto update = (TLRPC.TL_updateUserPhoto) baseUpdate;
                        TLRPC.User currentUser = getUser(update.user_id);
                        if (currentUser != null) {
                            currentUser.photo = update.photo;
                        }
                        TLRPC.User toDbUser = new TLRPC.TL_user();
                        toDbUser.id = update.user_id;
                        toDbUser.photo = update.photo;
                        dbUsers.add(toDbUser);
                        if (UserObject.isUserSelf(currentUser)) {
                            getNotificationCenter().postNotificationName(NotificationCenter.mainUserInfoChanged);
                        }
                    } else if (baseUpdate instanceof TLRPC.TL_updateNewStoryReaction) {
                        TLRPC.TL_updateNewStoryReaction update = (TLRPC.TL_updateNewStoryReaction) baseUpdate;
                        long dialogId = DialogObject.getPeerDialogId(update.peer);
                        int story_id = update.story_id;
                        TLRPC.Message msg = new TLRPC.Message();
                        msg.id = -story_id;
                        msg.dialog_id = dialogId;
                        msg.peer_id = getPeer(dialogId);
                        msg.date = getConnectionsManager().getCurrentTime();
                        TLRPC.User user = getMessagesController().getUser(msg.dialog_id);
                        if (user != null && getNotificationsSettings(currentAccount).getBoolean("EnableReactionsPreview", true)) {
                            ReactionsLayoutInBubble.VisibleReaction reaction = ReactionsLayoutInBubble.VisibleReaction.fromTL(update.reaction).flatten();
                            if (reaction.emojicon != null) {
                                msg.message = LocaleController.formatString(R.string.PushReactStory, UserObject.getFirstName(user), reaction.emojicon);
                            } else {
                                msg.message = LocaleController.formatString(R.string.PushReactStoryHidden);
                            }
                        } else {
                            msg.message = LocaleController.formatString(R.string.PushReactStoryHidden);
                        }
                        ArrayList<MessageObject> messageObjects = new ArrayList<MessageObject>();
                        MessageObject message = new MessageObject(currentAccount, msg, false, false);
                        message.isStoryReactionPush = true;
                        message.localType = 1;
                        if (user != null && !UserObject.isDeleted(user)) {
                            message.localUserName = UserObject.getFirstName(user);
                        } else {
                            message.localUserName = LocaleController.getString(R.string.PushReactStoryHiddenSender);
                        }
                        messageObjects.add(message);
                        getNotificationsController().processNewMessages(messageObjects, true, false, null);
                    } else if (baseUpdate instanceof TLRPC.TL_updateStarsBalance) {
                        TLRPC.TL_updateStarsBalance update = (TLRPC.TL_updateStarsBalance) baseUpdate;
                        final boolean ton = update.balance instanceof TL_stars.TL_starsTonAmount;
                        StarsController.getInstance(currentAccount, ton).updateBalance(update.balance);
                        StarsController.getInstance(currentAccount, ton).invalidateTransactions(false);
                    } else if (baseUpdate instanceof TLRPC.TL_updateUser) {
                        TLRPC.TL_updateUser update = (TLRPC.TL_updateUser) baseUpdate;
                        TLRPC.User currentUser = getUser(update.user_id);
                        TLRPC.User updated = null;
                        if (usersArr != null) {
                            for (int i = 0; i < usersArr.size(); ++i) {
                                TLRPC.User user = usersArr.get(i);
                                if (user != null && user.id == update.user_id) {
                                    updated = user;
                                    break;
                                }
                            }
                        }
                        if (updated != null && updated.photo != null) {
                            if (currentUser != null) {
                                currentUser.photo = updated.photo;
                            }
                            TLRPC.User toDbUser = new TLRPC.TL_user();
                            toDbUser.id = updated.id;
                            toDbUser.photo = updated.photo;
                            dbUsers.add(toDbUser);
                        }
                        if (UserObject.isUserSelf(currentUser)) {
                            getNotificationCenter().postNotificationName(NotificationCenter.mainUserInfoChanged);
                        }
                    } else if (baseUpdate instanceof TLRPC.TL_updateUserPhone) {
                        TLRPC.TL_updateUserPhone update = (TLRPC.TL_updateUserPhone) baseUpdate;
                        TLRPC.User currentUser = getUser(update.user_id);
                        if (currentUser != null) {
                            currentUser.phone = update.phone;
                            Utilities.phoneBookQueue.postRunnable(() -> getContactsController().addContactToPhoneBook(currentUser, true));
                            if (UserObject.isUserSelf(currentUser)) {
                                getNotificationCenter().postNotificationName(NotificationCenter.mainUserInfoChanged);
                            }
                        }
                        TLRPC.User toDbUser = new TLRPC.TL_user();
                        toDbUser.id = update.user_id;
                        toDbUser.phone = update.phone;
                        dbUsers.add(toDbUser);
                        } else if (baseUpdate instanceof TLRPC.TL_updateNotifySettings) {
                        TLRPC.TL_updateNotifySettings update = (TLRPC.TL_updateNotifySettings) baseUpdate;
                        if (update.notify_settings instanceof TLRPC.TL_peerNotifySettings) {
                            updateDialogFiltersFlags |= DIALOG_FILTER_FLAG_EXCLUDE_MUTED;
                            if (editor == null) {
                                editor = notificationsPreferences.edit();
                            }
                            int currentTime1 = getConnectionsManager().getCurrentTime();
                            if (update.peer instanceof TLRPC.TL_notifyPeer || update.peer instanceof TLRPC.TL_notifyForumTopic) {
                                long dialogId;
                                long topicId = 0;
                                if (update.peer instanceof TLRPC.TL_notifyPeer) {
                                    TLRPC.TL_notifyPeer notifyPeer = (TLRPC.TL_notifyPeer) update.peer;
                                    if (notifyPeer.peer.user_id != 0) {
                                        dialogId = notifyPeer.peer.user_id;
                                    } else if (notifyPeer.peer.chat_id != 0) {
                                        dialogId = -notifyPeer.peer.chat_id;
                                    } else {
                                        dialogId = -notifyPeer.peer.channel_id;
                                    }
                                } else {
                                    TLRPC.TL_notifyForumTopic notifyPeer = (TLRPC.TL_notifyForumTopic) update.peer;
                                    if (notifyPeer.peer.user_id != 0) {
                                        dialogId = notifyPeer.peer.user_id;
                                    } else if (notifyPeer.peer.chat_id != 0) {
                                        dialogId = -notifyPeer.peer.chat_id;
                                    } else {
                                        dialogId = -notifyPeer.peer.channel_id;
                                    }
                                    topicId = notifyPeer.top_msg_id;
                                }
                                getNotificationsController().getNotificationsSettingsFacade().applyDialogNotificationsSettings(dialogId, topicId, update.notify_settings);
                            } else if (update.peer instanceof TLRPC.TL_notifyChats) {
                                if ((update.notify_settings.flags & 1) != 0) {
                                    editor.putBoolean("EnablePreviewGroup", update.notify_settings.show_previews);
                                }
                                if ((update.notify_settings.flags & 2) != 0) {
                                    /*if (update.notify_settings.silent) {
                                        editor.putString("GroupSoundPath", "NoSound");
                                    } else {
                                        editor.remove("GroupSoundPath");
                                    }*/
                                }
                                if ((update.notify_settings.flags & 4) != 0) {
                                    if (notificationsPreferences.getInt("EnableGroup2", 0) != update.notify_settings.mute_until) {
                                        editor.putInt("EnableGroup2", update.notify_settings.mute_until);
                                        editor.putBoolean("overwrite_group", true);
                                        AndroidUtilities.runOnUIThread(() -> getNotificationsController().deleteNotificationChannelGlobal(NotificationsController.TYPE_GROUP));
                                    }
                                }
                                getNotificationsController().getNotificationsSettingsFacade().applySoundSettings(update.notify_settings.android_sound, editor, 0, 0, NotificationsController.TYPE_GROUP, false);
                            } else if (update.peer instanceof TLRPC.TL_notifyUsers) {
                                if ((update.notify_settings.flags & 1) != 0) {
                                    editor.putBoolean("EnablePreviewAll", update.notify_settings.show_previews);
                                }
                                if ((update.notify_settings.flags & 2) != 0) {
                                    /*if (update.notify_settings.silent) {
                                        editor.putString("GlobalSoundPath", "NoSound");
                                    } else {
                                        editor.remove("GlobalSoundPath");
                                    }*/
                                }
                                Boolean storiesEnabled = null;
                                if (notificationsPreferences.contains("EnableAllStories")) {
                                    storiesEnabled = notificationsPreferences.getBoolean("EnableAllStories", true);
                                }
                                Boolean storiesSendersHide = null;
                                if (notificationsPreferences.contains("EnableHideStoriesSenders")) {
                                    storiesSendersHide = notificationsPreferences.getBoolean("EnableHideStoriesSenders", true);
                                }
                                Boolean newStoriesEnabled = null;
                                if ((update.notify_settings.flags & 64) != 0) {
                                    editor.putBoolean("EnableAllStories", newStoriesEnabled = !update.notify_settings.stories_muted);
                                }
                                Boolean newStoriesSendersHide = null;
                                if ((update.notify_settings.flags & 128) != 0) {
                                    editor.putBoolean("EnableHideStoriesSenders", newStoriesSendersHide = update.notify_settings.stories_hide_sender);
                                }
                                if ((storiesEnabled == null) != (newStoriesEnabled == null) || (storiesSendersHide == null) != (newStoriesSendersHide == null) ||
                                    storiesEnabled != null && storiesEnabled != newStoriesEnabled || storiesSendersHide != null && storiesSendersHide != newStoriesSendersHide) {
                                    editor.putBoolean("overwrite_stories", true);
                                }
                                getNotificationsController().getNotificationsSettingsFacade().applySoundSettings(update.notify_settings.android_sound, editor, 0, 0, TYPE_PRIVATE, false);
                                if ((update.notify_settings.flags & 4) != 0) {
                                    if (notificationsPreferences.getInt("EnableAll2", 0) != update.notify_settings.mute_until) {
                                        editor.putInt("EnableAll2", update.notify_settings.mute_until);
                                        editor.putBoolean("overwrite_private", true);
                                        AndroidUtilities.runOnUIThread(() -> getNotificationsController().deleteNotificationChannelGlobal(TYPE_PRIVATE));
                                    }
                                }
                            } else if (update.peer instanceof TLRPC.TL_notifyBroadcasts) {
                                if ((update.notify_settings.flags & 1) != 0) {
                                    editor.putBoolean("EnablePreviewChannel", update.notify_settings.show_previews);
                                }
                                if ((update.notify_settings.flags & 2) != 0) {
                                    /*if (update.notify_settings.silent) {
                                        editor.putString("ChannelSoundPath", "NoSound");
                                    } else {
                                        editor.remove("ChannelSoundPath");
                                    }*/
                                }
                                if ((update.notify_settings.flags & 4) != 0) {
                                    if (notificationsPreferences.getInt("EnableChannel2", 0) != update.notify_settings.mute_until) {
                                        editor.putInt("EnableChannel2", update.notify_settings.mute_until);
                                        editor.putBoolean("overwrite_channel", true);
                                        AndroidUtilities.runOnUIThread(() -> getNotificationsController().deleteNotificationChannelGlobal(NotificationsController.TYPE_CHANNEL));
                                    }
                                }
                                getNotificationsController().getNotificationsSettingsFacade().applySoundSettings(update.notify_settings.android_sound, editor, 0, 0, TYPE_CHANNEL, false);
                            }
                            getMessagesStorage().updateMutedDialogsFiltersCounters();
                        }
                        sortDialogs(null);
                    } else if (baseUpdate instanceof TLRPC.TL_updateNewAuthorization) {
                        getUnconfirmedAuthController().processUpdate((TLRPC.TL_updateNewAuthorization) baseUpdate);
                    } else if (baseUpdate instanceof TLRPC.TL_updateChannel) {
                        TLRPC.TL_updateChannel update = (TLRPC.TL_updateChannel) baseUpdate;
                        TLRPC.Dialog dialog = dialogs_dict.get(-update.channel_id);
                        TLRPC.Chat chat = getChat(update.channel_id);
                        if (chat != null) {
                            if (dialog == null && chat instanceof TLRPC.TL_channel && !chat.left) {
                                Utilities.stageQueue.postRunnable(() -> getChannelDifference(update.channel_id, 1, 0, null));
                            } else if (ChatObject.isNotInChat(chat) && dialog != null && (promoDialog == null || promoDialog.id != dialog.id)) {
                                deleteDialog(dialog.id, 0);
                            }
                            if (chat instanceof TLRPC.TL_channelForbidden || chat.kicked) {
                                ChatObject.Call call = getGroupCall(chat.id, false);
                                if (call != null) {
                                    TLRPC.TL_updateGroupCall updateGroupCall = new TLRPC.TL_updateGroupCall();
                                    updateGroupCall.flags |= TLObject.FLAG_1;
                                    updateGroupCall.peer = getPeer(-chat.id);
                                    updateGroupCall.call = new TLRPC.TL_groupCallDiscarded();
                                    updateGroupCall.call.id = call.call.id;
                                    updateGroupCall.call.access_hash = call.call.access_hash;
                                    call.processGroupCallUpdate(updateGroupCall);
                                    if (VoIPService.getSharedInstance() != null) {
                                        VoIPService.getSharedInstance().onGroupCallUpdated(updateGroupCall.call);
                                    }
                                }
                            }
                        }
                        updateMask |= UPDATE_MASK_CHAT;
                        loadFullChat(update.channel_id, 0, true);
                    } else if (baseUpdate instanceof TLRPC.TL_updateChat) {
                        TLRPC.TL_updateChat update = (TLRPC.TL_updateChat) baseUpdate;
                        TLRPC.Chat chat = getChat(update.chat_id);
                        if (chat != null && (chat instanceof TLRPC.TL_chatForbidden || chat.kicked)) {
                            ChatObject.Call call = getGroupCall(chat.id, false);
                            if (call != null) {
                                TLRPC.TL_updateGroupCall updateGroupCall = new TLRPC.TL_updateGroupCall();
                                updateGroupCall.flags |= TLObject.FLAG_1;
                                updateGroupCall.peer = getPeer(-chat.id);
                                updateGroupCall.call = new TLRPC.TL_groupCallDiscarded();
                                updateGroupCall.call.id = call.call.id;
                                updateGroupCall.call.access_hash = call.call.access_hash;
                                call.processGroupCallUpdate(updateGroupCall);
                                if (VoIPService.getSharedInstance() != null) {
                                    VoIPService.getSharedInstance().onGroupCallUpdated(updateGroupCall.call);
                                }
                            }
                            TLRPC.Dialog dialog = dialogs_dict.get(-chat.id);
                            if (dialog != null) {
                                deleteDialog(dialog.id, 0);
                            }
                        }
                        updateMask |= UPDATE_MASK_CHAT;
                        loadFullChat(update.chat_id, 0, true);
                    } else if (baseUpdate instanceof TLRPC.TL_updateChatDefaultBannedRights) {
                        TLRPC.TL_updateChatDefaultBannedRights update = (TLRPC.TL_updateChatDefaultBannedRights) baseUpdate;
                        long chatId;
                        if (update.peer.channel_id != 0) {
                            chatId = update.peer.channel_id;
                        } else {
                            chatId = update.peer.chat_id;
                        }
                        TLRPC.Chat chat = getChat(chatId);
                        if (chat != null) {
                            chat.default_banned_rights = update.default_banned_rights;
                            AndroidUtilities.runOnUIThread(() -> getNotificationCenter().postNotificationName(NotificationCenter.channelRightsUpdated, chat));
                        }
                    } else if (baseUpdate instanceof TLRPC.TL_updateBotCommands) {
                        TLRPC.TL_updateBotCommands update = (TLRPC.TL_updateBotCommands) baseUpdate;
                        getMediaDataController().updateBotInfo(MessageObject.getPeerId(update.peer), update);
                    } else if (baseUpdate instanceof TLRPC.TL_updateStickerSets) {
                        TLRPC.TL_updateStickerSets update = (TLRPC.TL_updateStickerSets) baseUpdate;
                        getMediaDataController().loadStickers(MediaDataController.TYPE_IMAGE, false, true);
                    } else if (baseUpdate instanceof TLRPC.TL_updateStickerSetsOrder) {
                        TLRPC.TL_updateStickerSetsOrder update = (TLRPC.TL_updateStickerSetsOrder) baseUpdate;
                        int type;
                        if (update.masks) {
                            type = MediaDataController.TYPE_MASK;
                        } else if (update.emojis) {
                            type = MediaDataController.TYPE_EMOJIPACKS;
                        } else {
                            type = MediaDataController.TYPE_IMAGE;
                        }
                        getMediaDataController().reorderStickers(type, ((TLRPC.TL_updateStickerSetsOrder) baseUpdate).order, false);
                    } else if (baseUpdate instanceof TLRPC.TL_updateRecentReactions) {
                        getMediaDataController().loadRecentAndTopReactions(true);
                    } else if (baseUpdate instanceof TLRPC.TL_updateRecentReactions) {
                        getMediaDataController().loadSavedReactions(true);
                    } else if (baseUpdate instanceof TLRPC.TL_updateSavedReactionTags) {
                        getSavedReactionTags(0, true);
                    } else if (baseUpdate instanceof TLRPC.TL_updateFavedStickers) {
                        getMediaDataController().loadRecents(MediaDataController.TYPE_FAVE, false, false, true);
                    } else if (baseUpdate instanceof TLRPC.TL_updateContactsReset) {
                        getContactsController().forceImportContacts();
                    } else if (baseUpdate instanceof TLRPC.TL_updateNewStickerSet) {
                        TLRPC.TL_updateNewStickerSet update = (TLRPC.TL_updateNewStickerSet) baseUpdate;
                        getMediaDataController().addNewStickerSet(update.stickerset);
                    } else if (baseUpdate instanceof TLRPC.TL_updateSavedGifs) {
                        SharedPreferences.Editor editor2 = emojiPreferences.edit();
                        editor2.putLong("lastGifLoadTime", 0).commit();
                    } else if (baseUpdate instanceof TLRPC.TL_updateRecentStickers) {
                        SharedPreferences.Editor editor2 = emojiPreferences.edit();
                        editor2.putLong("lastStickersLoadTime", 0).commit();
                    } else if (baseUpdate instanceof TLRPC.TL_updateDraftMessage) {
                        TLRPC.TL_updateDraftMessage update = (TLRPC.TL_updateDraftMessage) baseUpdate;
                        forceDialogsUpdate = true;
                        long did;
                        TLRPC.Peer peer = ((TLRPC.TL_updateDraftMessage) baseUpdate).peer;
                        if (peer.user_id != 0) {
                            did = peer.user_id;
                        } else if (peer.channel_id != 0) {
                            did = -peer.channel_id;
                        } else {
                            did = -peer.chat_id;
                        }
                        long threadId = update.saved_peer_id != null ?
                            DialogObject.getPeerDialogId(update.saved_peer_id): update.top_msg_id;

                        getMediaDataController().saveDraft(did, threadId, update.draft, null, true);
                    } else if (baseUpdate instanceof TL_stories.TL_updateStoriesStealthMode) {
                        TL_stories.TL_updateStoriesStealthMode storiesStealthModeUpdate = (TL_stories.TL_updateStoriesStealthMode) baseUpdate;
                        getStoriesController().setStealthMode(storiesStealthModeUpdate.stealth_mode);
                    } else if (baseUpdate instanceof TLRPC.TL_updateReadFeaturedStickers) {
                        getMediaDataController().markFeaturedStickersAsRead(false, false);
                    } else if (baseUpdate instanceof TLRPC.TL_updateReadFeaturedEmojiStickers) {
                        getMediaDataController().markFeaturedStickersAsRead(true, false);
                    } else if (baseUpdate instanceof TLRPC.TL_updateMoveStickerSetToTop) {
                        TLRPC.TL_updateMoveStickerSetToTop update = (TLRPC.TL_updateMoveStickerSetToTop) baseUpdate;
                        getMediaDataController().moveStickerSetToTop(update.stickerset, update.emojis, update.masks);
                    } else if (baseUpdate instanceof TLRPC.TL_updatePinnedForumTopic) {
                        TLRPC.TL_updatePinnedForumTopic update = (TLRPC.TL_updatePinnedForumTopic) baseUpdate;
                        final long dialogId = DialogObject.getPeerDialogId(update.peer);
                        ArrayList<Integer> newOrder = getTopicsController().getCurrentPinnedOrder(-dialogId);
                        newOrder.remove((Integer) update.topic_id);
                        if (update.pinned) {
                            newOrder.add(0, update.topic_id);
                        }
                        getTopicsController().applyPinnedOrder(-dialogId, newOrder);

                    } else if (baseUpdate instanceof TLRPC.TL_updatePinnedForumTopics) {
                        TLRPC.TL_updatePinnedForumTopics update = (TLRPC.TL_updatePinnedForumTopics) baseUpdate;
                        final long dialogId = DialogObject.getPeerDialogId(update.peer);
                        if ((update.flags & 1) != 0) {
                            getTopicsController().applyPinnedOrder(-dialogId, update.order);
                        } else {
                            getTopicsController().reloadTopics(-dialogId, false);
                        }
                    } else if (baseUpdate instanceof TLRPC.TL_updatePhoneCallSignalingData) {
                        TLRPC.TL_updatePhoneCallSignalingData data = (TLRPC.TL_updatePhoneCallSignalingData) baseUpdate;
                        VoIPService svc = VoIPService.getSharedInstance();
                        if (svc != null) {
                            svc.onSignalingData(data);
                        }
                    } else if (baseUpdate instanceof TLRPC.TL_updateGroupCallParticipants) {
                        TLRPC.TL_updateGroupCallParticipants update = (TLRPC.TL_updateGroupCallParticipants) baseUpdate;
                        ChatObject.Call call = groupCalls.get(update.call.id);
                        if (call != null) {
                            call.processParticipantsUpdate(update, false);
                        }
                        if (VoIPService.getSharedInstance() != null) {
                            VoIPService.getSharedInstance().onGroupCallParticipantsUpdate(update);
                        }
                    } else if (baseUpdate instanceof TLRPC.TL_updateGroupCall) {
                        TLRPC.TL_updateGroupCall update = (TLRPC.TL_updateGroupCall) baseUpdate;
                        if (update.live_story) {
                            getNotificationCenter().postNotificationName(NotificationCenter.storyGroupCallUpdated, DialogObject.getPeerDialogId(update.peer), update.call);
                        }
                        ChatObject.Call call = groupCalls.get(update.call.id);
                        if (call != null) {
                            call.processGroupCallUpdate(update);
                            TLRPC.Chat chat = getChat(call.chatId);
                            if (chat != null) {
                                chat.call_active = update.call instanceof TLRPC.TL_groupCall;
                            }
                        } else if (update.peer != null) {
                            final long did = DialogObject.getPeerDialogId(update.peer);
                            TLRPC.ChatFull chatFull = getChatFull(-did);
                            if (chatFull != null && (chatFull.call == null || chatFull.call != null && chatFull.call.id != update.call.id)) {
                                loadFullChat(-did, 0, true);
                            }
                        }
                        if (VoIPService.getSharedInstance() != null) {
                            VoIPService.getSharedInstance().onGroupCallUpdated(update.call);
                        }
                    } else if (baseUpdate instanceof TLRPC.TL_updatePhoneCall) {
                        TLRPC.TL_updatePhoneCall upd = (TLRPC.TL_updatePhoneCall) baseUpdate;
                        TL_phone.PhoneCall call = upd.phone_call;
                        VoIPService svc = VoIPService.getSharedInstance();
                        if (BuildVars.LOGS_ENABLED) {
                            FileLog.d("Received call in update: " + call);
                            FileLog.d("call id " + call.id);
                        }
                        if (voipDebug != null && call instanceof TL_phone.TL_phoneCallDiscarded) {
                            TL_phone.TL_phoneCallDiscarded p = (TL_phone.TL_phoneCallDiscarded) call;
                            voipDebug.done(p.id, p.need_debug);
                        }
                        if (call instanceof TL_phone.phoneCallRequested) {
                            if (call.date + callRingTimeout / 1000 < getConnectionsManager().getCurrentTime()) {
                                if (BuildVars.LOGS_ENABLED) {
                                    FileLog.d("ignoring too old call");
                                }
                                continue;
                            }
                            boolean notificationsDisabled = false;
                            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP && !NotificationManagerCompat.from(ApplicationLoader.applicationContext).areNotificationsEnabled()) {
                                notificationsDisabled = true;
                                if (ApplicationLoader.mainInterfacePaused || !ApplicationLoader.isScreenOn) {
                                    if (BuildVars.LOGS_ENABLED) {
                                        FileLog.d("Ignoring incoming call because notifications are disabled in system");
                                    }
                                    continue;
                                }
                            }
                            TelephonyManager tm = (TelephonyManager) ApplicationLoader.applicationContext.getSystemService(Context.TELEPHONY_SERVICE);
                            boolean callStateIsIdle = true;
                            try {

                                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                                    //TODO check
                                    if (ActivityCompat.checkSelfPermission(ApplicationLoader.applicationContext, Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED) {
                                        callStateIsIdle = tm.getCallStateForSubscription() == TelephonyManager.CALL_STATE_IDLE;
                                    }
                                } else {
                                    callStateIsIdle = tm.getCallState() == TelephonyManager.CALL_STATE_IDLE;
                                }
                            } catch (Throwable e) {
                                FileLog.e(e)