// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


// This file is autogenerated by
//     third_party/jni_zero/jni_generator.py
// For
//     org/webrtc/CandidatePairChangeEvent

#ifndef org_webrtc_CandidatePairChangeEvent_JNI
#define org_webrtc_CandidatePairChangeEvent_JNI

#include <jni.h>

#include "third_party/jni_zero/jni_export.h"
#include "webrtc/sdk/android/src/jni/jni_generator_helper.h"


// Step 1: Forward declarations.

JNI_ZERO_COMPONENT_BUILD_EXPORT extern const char kClassPath_org_webrtc_CandidatePairChangeEvent[];
const char kClassPath_org_webrtc_CandidatePairChangeEvent[] = "org/webrtc/CandidatePairChangeEvent";
// Leaking this jclass as we cannot use LazyInstance from some threads.
JNI_ZERO_COMPONENT_BUILD_EXPORT std::atomic<jclass>
    g_org_webrtc_CandidatePairChangeEvent_clazz(nullptr);
#ifndef org_webrtc_CandidatePairChangeEvent_clazz_defined
#define org_webrtc_CandidatePairChangeEvent_clazz_defined
inline jclass org_webrtc_CandidatePairChangeEvent_clazz(JNIEnv* env) {
  return jni_zero::LazyGetClass(env, kClassPath_org_webrtc_CandidatePairChangeEvent,
      &g_org_webrtc_CandidatePairChangeEvent_clazz);
}
#endif


// Step 2: Constants (optional).


// Step 3: Method stubs.
namespace webrtc {
namespace jni {


static std::atomic<jmethodID> g_org_webrtc_CandidatePairChangeEvent_Constructor5(nullptr);
static jni_zero::ScopedJavaLocalRef<jobject> Java_CandidatePairChangeEvent_Constructor(JNIEnv* env,
    const jni_zero::JavaRef<jobject>& local,
    const jni_zero::JavaRef<jobject>& remote,
    JniIntWrapper lastDataReceivedMs,
    const jni_zero::JavaRef<jstring>& reason,
    JniIntWrapper estimatedDisconnectedTimeMs) {
  jclass clazz = org_webrtc_CandidatePairChangeEvent_clazz(env);
  CHECK_CLAZZ(env, clazz,
      org_webrtc_CandidatePairChangeEvent_clazz(env), nullptr);

  jni_zero::JniJavaCallContextChecked call_context;
  call_context.Init<
      jni_zero::MethodID::TYPE_INSTANCE>(
          env,
          clazz,
          "<init>",
          "(Lorg/webrtc/IceCandidate;Lorg/webrtc/IceCandidate;ILjava/lang/String;I)V",
          &g_org_webrtc_CandidatePairChangeEvent_Constructor5);

  jobject ret =
      env->NewObject(clazz,
          call_context.base.method_id, local.obj(), remote.obj(), as_jint(lastDataReceivedMs),
              reason.obj(), as_jint(estimatedDisconnectedTimeMs));
  return jni_zero::ScopedJavaLocalRef<jobject>(env, ret);
}

}  // namespace jni
}  // namespace webrtc

#endif  // org_webrtc_CandidatePairChangeEvent_JNI
