package com.todoroo.astrid.repeats;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import org.fdroid.taskstrid.R;
import com.todoroo.astrid.api.Addon;
import com.todoroo.astrid.api.AstridApiConstants;

public class RepeatsPlugin extends BroadcastReceiver {

    static final String IDENTIFIER = "repeats"; //$NON-NLS-1$

    @Override
    public void onReceive(Context context, Intent intent) {
        Addon plugin = new Addon(IDENTIFIER, context.getString(R.string.repeat_plugin),
                context.getString(R.string.AOA_internal_author),
                context.getString(R.string.repeat_plugin_desc));

        Intent broadcastIntent = new Intent(AstridApiConstants.BROADCAST_SEND_ADDONS);
        broadcastIntent.putExtra(AstridApiConstants.EXTRAS_ADDON, plugin);
        context.sendBroadcast(broadcastIntent, AstridApiConstants.PERMISSION_READ);
    }

}
