/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.providers;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.os.SystemProperties;
import android.provider.BaseColumns;
import android.util.Log;
import com.google.android.collect.Maps;
import java.util.HashMap;

public final class GoogleSettings {
    public static final String AUTHORITY = "com.google.settings";
    private static final String TAG = "GoogleSettings";

    public static final class Partner
    extends NameValueTable {
        public static final String SYS_PROP_SETTING_VERSION = "sys.settings_google_version";
        private static volatile NameValueCache mNameValueCache = null;
        private static final Object mNameValueCacheLock = new Object();
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.settings/partner");
        public static final String DATA_STORE_VERSION = "data_store_version";
        public static final String CLIENT_ID = "client_id";
        public static final String VOICESEARCH_CLIENT_ID = "voicesearch_client_id";
        public static final String MAPS_CLIENT_ID = "maps_client_id";
        public static final String YOUTUBE_CLIENT_ID = "youtube_client_id";
        public static final String MARKET_CLIENT_ID = "market_client_id";
        public static final String RLZ = "rlz";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getString(ContentResolver resolver, String name) {
            Object object = mNameValueCacheLock;
            synchronized (object) {
                if (mNameValueCache == null) {
                    mNameValueCache = new NameValueCache(SYS_PROP_SETTING_VERSION, CONTENT_URI);
                }
                return mNameValueCache.getString(resolver, name);
            }
        }

        public static String getString(ContentResolver resolver, String name, String defaultValue) {
            String value = Partner.getString(resolver, name);
            if (value == null) {
                value = defaultValue;
            }
            return value;
        }

        public static boolean putString(ContentResolver resolver, String name, String value) {
            return Partner.putString(resolver, CONTENT_URI, name, value);
        }

        public static int getInt(ContentResolver resolver, String name, int defValue) {
            int value;
            String valString = Partner.getString(resolver, name);
            try {
                value = valString != null ? Integer.parseInt(valString) : defValue;
            }
            catch (NumberFormatException e) {
                value = defValue;
            }
            return value;
        }

        public static long getLong(ContentResolver resolver, String name, long defValue) {
            long value;
            String valString = Partner.getString(resolver, name);
            try {
                value = valString != null ? Long.parseLong(valString) : defValue;
            }
            catch (NumberFormatException e) {
                value = defValue;
            }
            return value;
        }

        public static Uri getUriFor(String name) {
            return Partner.getUriFor(CONTENT_URI, name);
        }
    }

    private static class NameValueCache {
        private final String mVersionSystemProperty;
        private final HashMap<String, String> mValues = Maps.newHashMap();
        private long mValuesVersion = 0L;
        private final Uri mUri;

        NameValueCache(String versionSystemProperty, Uri uri) {
            this.mVersionSystemProperty = versionSystemProperty;
            this.mUri = uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getString(ContentResolver cr, String name) {
            long newValuesVersion = SystemProperties.getLong((String)this.mVersionSystemProperty, (long)0L);
            if (this.mValuesVersion != newValuesVersion) {
                this.mValues.clear();
                this.mValuesVersion = newValuesVersion;
            }
            if (!this.mValues.containsKey(name)) {
                String value = null;
                Cursor c = null;
                try {
                    c = cr.query(this.mUri, new String[]{"value"}, "name=?", new String[]{name}, null);
                    if (c != null && c.moveToNext()) {
                        value = c.getString(0);
                    }
                    this.mValues.put(name, value);
                }
                catch (SQLException e) {
                    Log.e((String)GoogleSettings.TAG, (String)("Can't get key " + name + " from " + this.mUri), (Throwable)e);
                }
                finally {
                    if (c != null) {
                        c.close();
                    }
                }
                return value;
            }
            return this.mValues.get(name);
        }
    }

    public static class NameValueTable
    implements BaseColumns {
        public static final String NAME = "name";
        public static final String VALUE = "value";

        protected static boolean putString(ContentResolver resolver, Uri uri, String name, String value) {
            try {
                ContentValues values = new ContentValues();
                values.put(NAME, name);
                values.put(VALUE, value);
                resolver.insert(uri, values);
                return true;
            }
            catch (SQLException e) {
                Log.e((String)GoogleSettings.TAG, (String)("Can't set key " + name + " in " + uri), (Throwable)e);
                return false;
            }
        }

        public static Uri getUriFor(Uri uri, String name) {
            return Uri.withAppendedPath((Uri)uri, (String)name);
        }
    }
}

