/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.providers;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.SyncContext;
import android.content.SyncResult;
import android.content.SyncableContentProvider;
import android.content.TempProviderSyncAdapter;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.EventLog;
import android.util.Log;
import com.google.android.googlelogin.GoogleLoginServiceBlockingHelper;
import com.google.android.googlelogin.GoogleLoginServiceNotFoundException;
import com.google.wireless.gdata.client.GDataServiceClient;
import com.google.wireless.gdata.client.HttpException;
import com.google.wireless.gdata.client.QueryParams;
import com.google.wireless.gdata.data.Entry;
import com.google.wireless.gdata.data.Feed;
import com.google.wireless.gdata.parser.GDataParser;
import com.google.wireless.gdata.parser.ParseException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractGDataSyncAdapter
extends TempProviderSyncAdapter {
    public static final int ENTRY_OK = 0;
    public static final int ENTRY_DELETED = 1;
    public static final int ENTRY_INVALID = 2;
    protected static final String TAG = "Sync";
    private String mAccount = null;
    private String mAuthToken = null;
    protected volatile boolean mSyncCanceled = false;
    protected int mServerQueries;
    protected int mServerEntries;
    private static final String SCHEMA_HTTPS = "https://";
    private static final String SCHEMA_HTTP = "http://";
    private static final Uri SYNC_STATE_CONTENT_URI = Uri.parse((String)"content://syncstate/state");

    protected AbstractGDataSyncAdapter(Context context, SyncableContentProvider provider) {
        super(provider);
        this.setContext(context);
    }

    protected void logSyncDetails(long bytesSent, long bytesReceived, SyncResult result) {
        StringBuffer sb = new StringBuffer();
        this.getStatsString(sb, result);
        EventLog.writeEvent((int)2743, (Object[])new Object[]{this.getGDataServiceClient().getServiceName(), bytesSent, bytesReceived, sb.toString()});
    }

    protected void getStatsString(StringBuffer sb, SyncResult result) {
        if (this.mServerQueries > 0) {
            sb.append("Q").append(this.mServerQueries);
        }
        if (this.mServerEntries > 0) {
            sb.append("E").append(this.mServerEntries);
        }
        if (result.stats.numUpdates > 0L) {
            sb.append("u").append(result.stats.numUpdates);
        }
        if (result.stats.numInserts > 0L) {
            sb.append("i").append(result.stats.numInserts);
        }
        if (result.stats.numDeletes > 0L) {
            sb.append("d").append(result.stats.numDeletes);
        }
        sb.append(result.toDebugString());
    }

    protected abstract GDataServiceClient getGDataServiceClient();

    protected abstract void updateProvider(Feed var1, Long var2, Entry var3, ContentProvider var4, Object var5) throws ParseException;

    protected abstract String getFeedUrl(String var1);

    protected abstract Class getFeedEntryClass();

    protected void updateQueryParameters(QueryParams params) {
    }

    protected abstract Entry newEntry();

    protected abstract Cursor getCursorForTable(ContentProvider var1, Class var2);

    protected abstract Cursor getCursorForDeletedTable(ContentProvider var1, Class var2);

    protected abstract String cursorToEntry(SyncContext var1, Cursor var2, Entry var3, Object var4) throws ParseException;

    protected abstract void deletedCursorToEntry(SyncContext var1, Cursor var2, Entry var3) throws ParseException;

    protected String getAccount() {
        return this.mAccount;
    }

    protected void setAuthToken(String authToken) {
        this.mAuthToken = authToken;
    }

    protected abstract boolean handleAllDeletedUnavailable(GDataSyncData var1, String var2);

    protected String getAuthToken() {
        return this.mAuthToken;
    }

    public int getMaxEntriesPerSync() {
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GDataSyncData readSyncData(SyncableContentProvider contentProvider) {
        Cursor c = contentProvider.query(SYNC_STATE_CONTENT_URI, null, "_sync_account = ?", new String[]{this.mAccount}, null);
        try {
            if (c.moveToFirst()) {
                GDataSyncData gDataSyncData = AbstractGDataSyncAdapter.newGDataSyncDataFromBytes(c.getBlob(c.getColumnIndexOrThrow("data")));
                return gDataSyncData;
            }
        }
        finally {
            c.close();
        }
        return this.newSyncData();
    }

    public GDataSyncData newSyncData() {
        return new GDataSyncData();
    }

    public void writeSyncData(TempProviderSyncAdapter.SyncData syncData, SyncableContentProvider contentProvider) {
        contentProvider.delete(SYNC_STATE_CONTENT_URI, "_sync_account = ?", new String[]{this.mAccount});
        if (syncData == null) {
            ContentValues values = new ContentValues();
            values.put("data", (String)null);
            values.put("_sync_account", this.mAccount);
            contentProvider.insert(SYNC_STATE_CONTENT_URI, values);
            return;
        }
        ContentValues values = new ContentValues();
        values.put("data", AbstractGDataSyncAdapter.newBytesFromGDataSyncData((GDataSyncData)syncData));
        values.put("_sync_account", this.mAccount);
        contentProvider.insert(SYNC_STATE_CONTENT_URI, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GDataSyncData newGDataSyncDataFromBytes(byte[] data) {
        if (data != null) {
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall(data, 0, data.length);
            parcel.setDataPosition(0);
            try {
                GDataSyncData gDataSyncData = (GDataSyncData)((Object)GDataSyncData.CREATOR.createFromParcel(parcel));
                return gDataSyncData;
            }
            catch (RuntimeException runtimeException) {
            }
            finally {
                parcel.recycle();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] newBytesFromGDataSyncData(GDataSyncData syncData) {
        Parcel parcel = Parcel.obtain();
        try {
            syncData.writeToParcel(parcel, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            parcel.recycle();
        }
    }

    public void onSyncCanceled() {
        this.mSyncCanceled = true;
    }

    public void getServerDiffs(SyncContext context, TempProviderSyncAdapter.SyncData syncData, SyncableContentProvider tempProvider, Bundle extras, Object syncInfo, SyncResult syncResult) {
        String feedUrl = this.getFeedUrl(this.getAccount());
        if (extras != null && extras.containsKey("feed")) {
            feedUrl = (String)extras.get("feed");
        }
        context.setStatusText("Downloading\u2026");
        this.getServerDiffsImpl(context, tempProvider, this.getFeedEntryClass(), feedUrl, syncInfo, this.getMaxEntriesPerSync(), (GDataSyncData)syncData, syncResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void getServerDiffsImpl(SyncContext syncContext, SyncableContentProvider tempProvider, Class feedEntryClass, String feedUrl, Object syncInfo, int maxResults, GDataSyncData syncData, SyncResult syncResult) {
        if (this.mSyncCanceled) {
            return;
        }
        GDataSyncData.FeedData feedSyncData = syncData.feedData.get(feedUrl);
        if (feedSyncData == null) {
            String httpFeedUrl = feedUrl.replaceFirst("^https://", SCHEMA_HTTP);
            feedSyncData = syncData.feedData.get(httpFeedUrl);
        }
        long lastSyncTime = 0L;
        if (feedSyncData != null) {
            lastSyncTime = feedSyncData.lastUpdatedTime;
        }
        Time time = new Time("UTC");
        GDataServiceClient client = this.getGDataServiceClient();
        QueryParams params = client.createQueryParams();
        if (tempProvider.getContainsDiffs() && lastSyncTime > 0L) {
            time.set(lastSyncTime);
            params.setUpdatedMin(time.format3339(false));
            params.setParamValue("requirealldeleted", "true");
        }
        int startIndex = 1;
        String expectedFirstId = null;
        if (feedSyncData != null && feedSyncData.hasMoreEntriesToFetch) {
            startIndex = feedSyncData.endIndex;
            if (startIndex <= 0) {
                throw new IllegalArgumentException("bad startIndex, " + startIndex + ", it must be greater than 0, SyncData is " + feedSyncData);
            }
            params.setStartIndex(String.valueOf(startIndex));
            ++maxResults;
            expectedFirstId = feedSyncData.lastId;
        }
        params.setMaxResults(String.valueOf(maxResults));
        String lastId = null;
        int numResults = 0;
        GDataParser parser = null;
        String feedUrlToQuery = null;
        try {
            this.updateQueryParameters(params);
            feedUrlToQuery = params.generateQueryUrl(feedUrl);
            try {
                new URI(feedUrlToQuery);
            }
            catch (URISyntaxException e) {
                Log.d((String)TAG, (String)("the feed url " + feedUrlToQuery + " is not a valid URI"), (Throwable)e);
                ++syncResult.stats.numParseExceptions;
                if (parser == null) return;
                parser.close();
                return;
            }
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("Requesting feed " + feedUrlToQuery));
                Log.v((String)TAG, (String)("Using auth token " + this.getAuthToken()));
            }
            parser = client.getParserForFeed(feedEntryClass, feedUrlToQuery, this.getAuthToken());
            ++this.mServerQueries;
            Feed feed = parser.init();
            int totalResults = feed.getTotalResults();
            String feedUpdateDate = feed.getLastUpdated();
            Entry entry = null;
            long entryLastUpdated = lastSyncTime;
            while (parser.hasMoreData() && numResults < maxResults) {
                SQLiteDatabase db;
                if (this.mSyncCanceled) {
                    return;
                }
                ++this.mServerEntries;
                ++numResults;
                try {
                    entry = parser.readNextEntry(entry);
                }
                catch (ParseException e) {
                    ++syncResult.stats.numSkippedEntries;
                    Log.e((String)TAG, (String)("error while parsing entry from account " + this.getAccount() + ", feed " + feedUrl + ", skipping"), (Throwable)e);
                    continue;
                }
                int entryIndex = numResults + startIndex - 1;
                syncContext.setStatusText("Downloading " + entryIndex + "/" + totalResults + "\n" + entry.getTitle());
                if (Log.isLoggable((String)TAG, (int)2)) {
                    Log.v((String)TAG, (String)("Read entry: " + entry.getTitle()));
                }
                lastId = entry.getId();
                if (numResults == 1 && expectedFirstId != null && !expectedFirstId.equals(lastId)) {
                    Log.d((String)TAG, (String)("aborting paging since the first record is " + lastId + " instead of the expected " + expectedFirstId));
                    feedSyncData.hasMoreEntriesToFetch = false;
                    this.getServerDiffsImpl(syncContext, tempProvider, feedEntryClass, feedUrl, syncInfo, maxResults, syncData, syncResult);
                    return;
                }
                if (Log.isLoggable((String)TAG, (int)2)) {
                    Log.v((String)TAG, (String)("getServerDiffs: updating provider with entry " + entry.getEditUri()));
                }
                if ((db = tempProvider.getDatabase()).inTransaction()) {
                    throw new IllegalStateException("we should not be in a transaction");
                }
                db.beginTransaction();
                try {
                    this.updateProvider(feed, null, entry, (ContentProvider)tempProvider, syncInfo);
                    ++syncResult.stats.numEntries;
                    String updateDate = entry.getUpdateDate();
                    if (updateDate != null) {
                        time.parse3339(updateDate);
                        long updated = time.toMillis(false);
                        if (updated > entryLastUpdated) {
                            entryLastUpdated = updated;
                        }
                    }
                    db.setTransactionSuccessful();
                }
                catch (ParseException e) {
                    Log.d((String)TAG, (String)("updateProvider failed, " + entry.getEditUri()), (Throwable)e);
                    ++syncResult.stats.numSkippedEntries;
                    syncContext.setStatusText("Failure: " + numResults + "/" + totalResults + ": " + entry.getTitle());
                }
                catch (RuntimeException e) {
                    Log.d((String)TAG, (String)("updateProvider failed,  " + entry.getEditUri()), (Throwable)e);
                    ++syncResult.stats.numSkippedEntries;
                    syncContext.setStatusText("Failure: " + numResults + "/" + totalResults + ": " + entry.getTitle());
                }
                finally {
                    db.endTransaction();
                }
            }
            if (feedUpdateDate == null) {
                entryLastUpdated = 0L;
            } else {
                time.parse3339(feedUpdateDate);
                long feedUpdateMillis = time.toMillis(false);
                long currentMillis = System.currentTimeMillis();
                if (feedUpdateMillis + 300000L < currentMillis) {
                    feedUpdateMillis += 1000L;
                }
                entryLastUpdated = feedUpdateMillis;
            }
            boolean moreRecordsToGet = numResults == maxResults;
            GDataSyncData.FeedData newFeedSyncData = new GDataSyncData.FeedData(moreRecordsToGet ? lastSyncTime : entryLastUpdated, numResults, moreRecordsToGet, lastId, startIndex + numResults - 1);
            syncResult.moreRecordsToGet = newFeedSyncData.hasMoreEntriesToFetch;
            syncData.feedData.put(feedUrl, newFeedSyncData);
            if (!Log.isLoggable((String)TAG, (int)2)) return;
            Log.v((String)TAG, (String)("This call to getServerDiffsImpl for feed " + feedUrl + " is returning " + (Object)((Object)syncData)));
            return;
        }
        catch (ParseException pe) {
            Log.e((String)TAG, (String)"Unable to process gdata feed", (Throwable)pe);
            syncContext.setStatusText("Could not parse feed.");
            ++syncResult.stats.numParseExceptions;
            return;
        }
        catch (IOException ioe) {
            Log.d((String)TAG, (String)("Unable to process gdata feed: " + ioe.getMessage()));
            syncContext.setStatusText("Could not download entire feed.");
            ++syncResult.stats.numIoExceptions;
            return;
        }
        catch (HttpException e) {
            switch (e.getStatusCode()) {
                case 401: 
                case 403: {
                    try {
                        GoogleLoginServiceBlockingHelper.invalidateAuthToken(this.getContext(), this.mAuthToken);
                    }
                    catch (GoogleLoginServiceNotFoundException e1) {
                        Log.d((String)TAG, (String)"Could not invalidate auth token", (Throwable)((Object)e1));
                    }
                    Log.d((String)TAG, (String)"Bad authentication token");
                    syncContext.setStatusText("Bad authentication token");
                    ++syncResult.stats.numAuthExceptions;
                    return;
                }
                case 410: {
                    Log.d((String)TAG, (String)("The tombstones have expired for " + feedUrlToQuery));
                    if (this.handleAllDeletedUnavailable(syncData, feedUrl)) {
                        Log.d((String)TAG, (String)"handleAllDeletedUnavailable returned true, recursively calling getServerDiffsImpl");
                        this.getServerDiffsImpl(syncContext, tempProvider, feedEntryClass, feedUrl, syncInfo, maxResults, syncData, syncResult);
                        return;
                    } else {
                        Log.d((String)TAG, (String)"handleAllDeletedUnavailable returned false, setting partialSyncUnavailable");
                        syncResult.partialSyncUnavailable = true;
                        return;
                    }
                }
                default: {
                    Log.d((String)TAG, (String)("Unable to process gdata feed: " + e.getMessage()));
                    syncContext.setStatusText("Could not download entire feed.");
                    ++syncResult.stats.numIoExceptions;
                    return;
                }
            }
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public void sendClientDiffs(SyncContext context, SyncableContentProvider clientDiffs, SyncableContentProvider serverDiffs, SyncResult syncResult, boolean dontSendDeletes) {
        this.initTempProvider(clientDiffs);
        Object syncInfo = this.createSyncInfo();
        Entry entry = this.newEntry();
        this.sendClientDiffsImpl(context, clientDiffs, entry, syncInfo, serverDiffs, syncResult, dontSendDeletes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendClientDiffsImpl(SyncContext context, SyncableContentProvider clientDiffs, Entry entry, Object syncInfo, SyncableContentProvider serverDiffs, SyncResult syncResult, boolean dontSendDeletes) {
        int numRows;
        int syncLocalIDColumn;
        if (TextUtils.isEmpty((CharSequence)this.mAccount)) {
            Log.i((String)TAG, (String)"no username, so skipping the merge");
            return;
        }
        Cursor c = this.getCursorForDeletedTable((ContentProvider)clientDiffs, entry.getClass());
        Entry entryToSave = null;
        try {
            syncLocalIDColumn = c.getColumnIndexOrThrow("_sync_local_id");
            numRows = c.getCount();
            while (c.moveToNext() && !syncResult.madeSomeProgress()) {
                if (this.mSyncCanceled) {
                    Log.d((String)TAG, (String)"stopping since the sync was cancelled");
                    break;
                }
                entry.clear();
                try {
                    this.deletedCursorToEntry(context, c, entry);
                }
                catch (ParseException e) {
                    Log.d((String)TAG, (String)("unable to convert row to an Entry, skipping. " + c.getLong(c.getColumnIndexOrThrow("_id"))), (Throwable)e);
                    ++syncResult.stats.numParseExceptions;
                    continue;
                }
                context.setStatusText("Deleting, " + (numRows - 1) + " to go");
                entry.setDeleted(true);
                entryToSave = !dontSendDeletes ? this.sendSingleClientDiff(ClientDiffType.DELETE, entry.getEditUri(), entry, syncResult, true) : entry;
                if (entryToSave == null) continue;
                this.updateProviderInTransaction(serverDiffs, entryToSave, c.getLong(syncLocalIDColumn), syncInfo, syncResult);
            }
        }
        finally {
            c.deactivate();
        }
        c = this.getCursorForTable((ContentProvider)clientDiffs, entry.getClass());
        try {
            syncLocalIDColumn = c.getColumnIndexOrThrow("_sync_local_id");
            numRows = c.getCount();
            while (!syncResult.madeSomeProgress() && c.moveToNext()) {
                ClientDiffType op;
                String targetUrl;
                if (this.mSyncCanceled) {
                    Log.d((String)TAG, (String)"stopping since the sync was cancelled");
                    break;
                }
                entry.clear();
                context.setStatusText("Updating, " + (numRows - 1) + " to go");
                try {
                    targetUrl = this.cursorToEntry(context, c, entry, syncInfo);
                    if (targetUrl == null) {
                        targetUrl = entry.getEditUri();
                        op = ClientDiffType.UPDATE;
                    } else {
                        op = ClientDiffType.INSERT;
                    }
                }
                catch (ParseException e) {
                    Log.e((String)TAG, (String)("unable to convert row to an Entry, skipping. " + c.getLong(c.getColumnIndexOrThrow("_id"))), (Throwable)e);
                    ++syncResult.stats.numParseExceptions;
                    continue;
                }
                if ((entryToSave = this.sendSingleClientDiff(op, targetUrl, entry, syncResult, true)) == null) continue;
                this.updateProviderInTransaction(serverDiffs, entryToSave, c.getLong(syncLocalIDColumn), syncInfo, syncResult);
            }
        }
        finally {
            c.deactivate();
        }
    }

    public Entry sendSingleClientDiff(ClientDiffType op, String targetUrl, Entry entry, SyncResult syncResult, boolean retryAuthentication) {
        try {
            switch (op) {
                case UPDATE: {
                    if (Log.isLoggable((String)TAG, (int)2)) {
                        Log.v((String)TAG, (String)("Updating entry " + targetUrl));
                    }
                    if (entry.isDeleted()) {
                        throw new IllegalArgumentException("entry is marked as deleted but op is UPDATE");
                    }
                    entry = this.getGDataServiceClient().updateEntry(entry, this.mAuthToken);
                    ++syncResult.stats.numUpdates;
                    break;
                }
                case INSERT: {
                    if (Log.isLoggable((String)TAG, (int)2)) {
                        Log.v((String)TAG, (String)("Inserting entry " + targetUrl));
                    }
                    if (entry.isDeleted()) {
                        throw new IllegalArgumentException("entry is marked as deleted but op is INSERT");
                    }
                    entry = this.getGDataServiceClient().createEntry(targetUrl, this.mAuthToken, entry);
                    ++syncResult.stats.numInserts;
                    break;
                }
                case DELETE: {
                    if (!entry.isDeleted()) {
                        throw new IllegalArgumentException("entry is not marked as deleted but op is DELETE");
                    }
                    this.getGDataServiceClient().deleteEntry(targetUrl, this.mAuthToken);
                    ++syncResult.stats.numDeletes;
                }
            }
            return entry;
        }
        catch (ParseException e) {
            Log.e((String)TAG, (String)("parse error during " + (Object)((Object)op) + " of " + targetUrl + ", skipping"), (Throwable)e);
            ++syncResult.stats.numParseExceptions;
            return null;
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)("io error during " + op.toString() + " of " + targetUrl + ", due to " + e.getMessage() + ", skipping"));
            ++syncResult.stats.numIoExceptions;
            return null;
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)("object " + ((Object)((Object)this)).getClass().getName() + " caught an exception during " + op.toString() + " of " + targetUrl), (Throwable)e);
            ++syncResult.stats.numSkippedEntries;
            return null;
        }
        catch (HttpException e) {
            switch (e.getStatusCode()) {
                case 400: 
                case 403: {
                    if (op == ClientDiffType.UPDATE) {
                        if ((entry = this.getSingleEntry(entry.getClass(), entry.getId())) == null) {
                            ++syncResult.stats.numIoExceptions;
                            return null;
                        }
                        ++syncResult.stats.numUpdates;
                    } else if (op == ClientDiffType.INSERT) {
                        entry.setDeleted(true);
                        ++syncResult.stats.numDeletes;
                    } else if (op == ClientDiffType.DELETE) {
                        ++syncResult.stats.numDeletes;
                    }
                    return entry;
                }
                case 404: {
                    if (op == ClientDiffType.UPDATE) {
                        entry.setDeleted(true);
                    }
                    ++syncResult.stats.numDeletes;
                    return entry;
                }
                case 401: {
                    if (retryAuthentication) {
                        try {
                            this.invalidateAndUpdateAuthToken();
                            return this.sendSingleClientDiff(op, targetUrl, entry, syncResult, false);
                        }
                        catch (GoogleLoginServiceBlockingHelper.AuthenticationException e1) {
                        }
                        catch (GoogleLoginServiceNotFoundException e1) {
                            // empty catch block
                        }
                    }
                    ++syncResult.stats.numAuthExceptions;
                    return null;
                }
                case 409: {
                    if (op == ClientDiffType.INSERT) {
                        ++syncResult.stats.numConflictDetectedExceptions;
                        return null;
                    }
                    if ((entry = this.getSingleEntry(entry.getClass(), targetUrl)) == null) {
                        Log.d((String)TAG, (String)("conflict detected during " + op.toString() + " of " + targetUrl + ", skipping"), (Throwable)e);
                        ++syncResult.stats.numConflictDetectedExceptions;
                        return null;
                    }
                    ++syncResult.stats.numUpdates;
                    return entry;
                }
            }
            Log.d((String)TAG, (String)("other error during " + op.toString() + " of " + targetUrl + ", due to " + e.getMessage() + ", skipping"));
            ++syncResult.stats.numIoExceptions;
            return null;
        }
    }

    void invalidateAndUpdateAuthToken() throws GoogleLoginServiceNotFoundException, GoogleLoginServiceBlockingHelper.AuthenticationException {
        GoogleLoginServiceBlockingHelper.invalidateAuthToken(this.getContext(), this.mAuthToken);
        this.mAuthToken = GoogleLoginServiceBlockingHelper.getAuthToken(this.getContext(), this.mAccount, this.getGDataServiceClient().getServiceName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateProviderInTransaction(SyncableContentProvider provider, Entry entry, Long syncLocalId, Object syncInfo, SyncResult syncResult) {
        SQLiteDatabase db = provider.getDatabase();
        db.beginTransaction();
        try {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("sendClientDiffs: updating provider with entry " + entry));
            }
            this.updateProvider(null, syncLocalId, entry, (ContentProvider)provider, syncInfo);
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("updateProvider failed, entry " + entry), (Throwable)e);
            ++syncResult.stats.numSkippedEntries;
        }
        finally {
            db.endTransaction();
        }
    }

    private Entry getSingleEntry(Class entryClass, String url) {
        try {
            return this.getGDataServiceClient().getEntry(entryClass, url, this.mAuthToken);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("error while fetching " + url + " as type " + entryClass.getName()), (Throwable)e);
            return null;
        }
    }

    public void onSyncEnding(SyncContext context, boolean success) {
    }

    public void onSyncStarting(SyncContext context, String account, boolean forced, SyncResult result) {
        this.mSyncCanceled = false;
        this.mServerQueries = 0;
        this.mServerEntries = 0;
        try {
            this.onAccountsChanged(GoogleLoginServiceBlockingHelper.getAccounts(this.getContext()));
            context.setStatusText("Authenticating\u2026");
            this.mAccount = account;
            this.mAuthToken = GoogleLoginServiceBlockingHelper.getAuthToken(this.getContext(), this.mAccount, this.getGDataServiceClient().getServiceName());
        }
        catch (GoogleLoginServiceBlockingHelper.AuthenticationException e) {
            ++result.stats.numAuthExceptions;
            context.setStatusText("Could not authenticate user.");
        }
        catch (GoogleLoginServiceNotFoundException e) {
            Log.e((String)TAG, (String)"Google login service not found", (Throwable)((Object)e));
        }
    }

    public static String rewriteUrlforAccount(String account, String url) {
        if (TextUtils.isEmpty((CharSequence)account)) {
            throw new IllegalArgumentException("account is empty");
        }
        String[] accountComponents = account.split("@");
        if (accountComponents.length != 2) {
            throw new IllegalArgumentException("invalid account parameter, unable to find domain, " + account);
        }
        String domain = accountComponents[1];
        if ("gmail.com".equals(domain) || "googlemail.com".equals(domain)) {
            return url;
        }
        if (url.startsWith(SCHEMA_HTTPS)) {
            return url;
        }
        if (!url.startsWith(SCHEMA_HTTP)) {
            throw new IllegalArgumentException("invalid url parameter, unknown scheme: " + url);
        }
        return SCHEMA_HTTPS + url.substring(SCHEMA_HTTP.length());
    }

    public static class GDataSyncData
    extends TempProviderSyncAdapter.SyncData {
        public final Map<String, FeedData> feedData = new TreeMap<String, FeedData>();
        public static final Parcelable.Creator<GDataSyncData> CREATOR = new Parcelable.Creator<GDataSyncData>(){

            public GDataSyncData createFromParcel(Parcel in) {
                GDataSyncData gDataSyncData = new GDataSyncData();
                in.readMap(gDataSyncData.feedData, this.getClass().getClassLoader());
                return gDataSyncData;
            }

            public GDataSyncData[] newArray(int size) {
                return new GDataSyncData[size];
            }
        };

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeMap(this.feedData);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("GDataSyncData:");
            for (Map.Entry<String, FeedData> entry : this.feedData.entrySet()) {
                sb.append("[");
                sb.append(entry.getKey());
                sb.append(" -> ");
                sb.append(entry.getValue());
                sb.append("]");
            }
            return sb.toString();
        }

        public static class FeedData
        implements Parcelable {
            public long lastUpdatedTime;
            public long numEntriesFetched;
            public boolean hasMoreEntriesToFetch;
            public String lastId;
            public int endIndex;
            public static final Parcelable.Creator<FeedData> CREATOR = new Parcelable.Creator<FeedData>(){

                public FeedData createFromParcel(Parcel in) {
                    return new FeedData(in.readLong(), in.readLong(), in.readInt() != 0, in.readString(), in.readInt());
                }

                public FeedData[] newArray(int size) {
                    return new FeedData[size];
                }
            };

            public FeedData(long lastUpdatedTime, long numEntriesFetched, boolean moreEntriesToFetch, String lastId, int endIndex) {
                this.lastUpdatedTime = lastUpdatedTime;
                this.numEntriesFetched = numEntriesFetched;
                this.hasMoreEntriesToFetch = moreEntriesToFetch;
                this.lastId = lastId;
                this.endIndex = endIndex;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("FeedData:");
                sb.append(" lastUpdatedTime: " + this.lastUpdatedTime);
                sb.append(" numEntriesFetched: " + this.numEntriesFetched);
                sb.append(" moreEntriesToFetch: " + this.hasMoreEntriesToFetch);
                sb.append(" lastId: " + (this.lastId != null ? this.lastId : "<null>"));
                sb.append(" endIndex: " + this.endIndex);
                return sb.toString();
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeLong(this.lastUpdatedTime);
                dest.writeLong(this.numEntriesFetched);
                dest.writeInt(this.hasMoreEntriesToFetch ? 1 : 0);
                dest.writeString(this.lastId);
                dest.writeInt(this.endIndex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClientDiffType {
        DELETE,
        INSERT,
        UPDATE;

    }
}

