package org.epstudios.epmobile.features.riskscores.ui;

import android.widget.CheckBox;

import org.epstudios.epmobile.R;
import org.epstudios.epmobile.core.ui.base.RiskScore;

/**
 * Copyright (C) 2015 EP Studios, Inc.
 * www.epstudiossoftware.com
 * <p/>
 * Created by mannd on 11/29/15.
 * <p/>
 * This file is part of epmobile.
 * <p/>
 * epmobile is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p/>
 * epmobile is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * <p/>
 * You should have received a copy of the GNU General Public License
 * along with epmobile.  If not, see <http://www.gnu.org/licenses/>.
 */
public class AtriaBleed extends RiskScore {

    @Override
    protected void setContentView() {
        setContentView((R.layout.atriableed));
    }
    @Override
    protected void setupInsets() {
        setupInsets(R.id.atriableed_root_view);
    }

    @Override
    protected void init() {
        checkBoxes = new CheckBox[5];

        checkBoxes[0] = findViewById(R.id.anemia);
        checkBoxes[1] = findViewById(R.id.renal_disease);
        checkBoxes[2] = findViewById(R.id.age75);
        checkBoxes[3] = findViewById(R.id.prior_hemorrhage);
        checkBoxes[4] = findViewById(R.id.htn);
    }


    @Override
    protected String getFullReference() {
        return convertReferenceToText(R.string.atria_bleed_full_reference,
                R.string.atria_bleed_link);
    }

    @Override
    protected String getRiskLabel() {
        return getString(R.string.atria_bleed_risk_label);
    }

    @Override
    protected void calculateResult() {
        int result = 0;
        clearSelectedRisks();
        for (int i = 0; i < checkBoxes.length; i++) {
            if (checkBoxes[i].isChecked()) {
                addSelectedRisk(checkBoxes[i].getText().toString());
                if (i == 0 || i == 1)
                    result = result + 3;
                else if (i == 2)
                    result = result + 2;
                else
                    result++;
            }
        }
        displayResult(getResultMessage(result),
                getString(R.string.atria_bleeding_score_title));
    }

    private String getResultMessage(int result) {
        String message;
        if (result <= 3)
            message = getString(R.string.low_atria_bleed_message);
        else if (result == 4)
            message = getString(R.string.medium_atria_bleed_message);
        else
            message = getString(R.string.high_atria_bleed_message);
        message = getRiskLabel() + " score = " + result + "\n" + message;
        resultMessage = message;
        return resultWithShortReference();
    }


    @Override
    protected boolean hideReferenceMenuItem() {
        return false;
    }

    @Override
    protected void showActivityReference() {
        showReferenceAlertDialog(R.string.atria_bleed_full_reference,
                R.string.atria_bleed_link);
    }

    @Override
    protected boolean hideInstructionsMenuItem() {
        return false;
    }

    @Override
    protected  void showActivityInstructions() {
        showAlertDialog(R.string.atria_bleeding_score_title,
                R.string.atria_bleed_instructions);
    }


}
