EP Mobile =========

## Tools for electrophysiologists and cardiologists

[![Build Status](https://travis-ci.org/mannd/epmobile.svg?branch=master)](https://travis-ci.org/mannd/epmobile)

## Description
EP Mobile is an [Android](http://www.android.com)
application that provides a set of tools for electrophysiologists and
other health care workers who deal with cardiac arrhythmias.  The
program includes EP calculators, drug dose calculators, risk scores,
diagnostic tools, ECG figures, and more.

<a href="https://f-droid.org/packages/org.epstudios.epmobile/"
target="_blank"> <img src="https://f-droid.org/badge/get-it-on.png"
alt="Get it on F-Droid" height="100"/></a> <a
href="https://play.google.com/store/apps/details?id=org.epstudios.epmobile"
target="_blank"> <img
src="https://play.google.com/intl/en_us/badges/images/generic/en-play-badge.png"
alt="Get it on Google Play" height="100"/></a>

EP Mobile is free, open source, and licensed under the
[GNU GPL v3 license.](http://www.gnu.org/licenses/gpl.html)

## License
Copyright © 2011-2024 [EP Studios, Inc.](http://www.epstudiossoftware.com)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

## Sources
The [AV annulus figure](http://en.wikipedia.org/wiki/File:Gray495.png) is
modified from Gray's Anatomy 20th edition, which is in the public
domain (copyright from 1918 expired).

The wide complex tachycardia ECG patterns were redrawn and relabeled
from
[ECGpedia.org](http://en.ecgpedia.org/wiki/Approach_to_the_Wide_Complex_Tachycardia),
and the long QT ECG patterns were from
[the same source](http://en.ecgpedia.org/wiki/Long_QT_Syndrome), both
courtesy of Dr. De Voogt and ECGpedia.org.  They are licensed under
the
[Creative Commons Attribution-NonCommercial 3.0 Netherlands (CC BY-NC 3.0)](http://creativecommons.org/licenses/by-nc/3.0/nl/deed.en_GB).

The Brugada syndrome ECG pattern figure is from
[Napolitano C, Priori SG. Brugada syndrome. Orphanet J Rare Dis. 1, 35. 2006. doi:10.1186/1750-1172-1-35](http://www.ncbi.nlm.nih.gov/pubmed/16972995?dopt=Abstract).
It is licensed under the
[Creative Commons Attribution 2.0 Generic License](http://creativecommons.org/licenses/by/2.0/deed.en).

A complete set of references for the app is available
[here](https://www.epstudiossoftware.com/ep-mobile/references-2/).

The ARVC risk calculator is based on a similar calculator
[on the web](https://arvcrisk.com).  It is based on
[this paper](https://academic.oup.com/eurheartj/advance-article/doi/10.1093/eurheartj/ehz103/5419784)
and is used with the kind permission of the investigators.

Main screen icons are from [SVG Repo](https://www.svgrepo.com) and are
covered under a
[CC0](https://creativecommons.org/share-your-work/public-domain/cc0/)
license.

## Author David Mann

Email: [mannd@epstudiossoftware.com](mailto:mannd@epstudiossoftware.com)  
Website: [http://www.epstudiossoftware.com](http://www.epstudiossoftware.com)   

