// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Swahili (`sw`).
class AppLocalizationsSw extends AppLocalizations {
  AppLocalizationsSw([String locale = 'sw']) : super(locale);

  @override
  String get about => 'Kuhusu';

  @override
  String get aboutBrief => 'Pochi ya simu ya Encointer';

  @override
  String get aboutVersion => 'Toleo';

  @override
  String get acceptancePoints => 'Sehemu za makubaliano';

  @override
  String get accountDelete => 'Una uhakika unataka kufuta akaunti hii?';

  @override
  String get accountImport => 'Ingiza akaunti';

  @override
  String get accountName => 'Jina la akaunti';

  @override
  String get accountNameChoose => 'Chagua jina la akaunti.';

  @override
  String get accountNameChooseHint =>
      'Unaweza badilisha badae kwenye mipangilio ya wasifu.';

  @override
  String get accounts => 'Akaunti';

  @override
  String get accountsDelete => 'Una uhakika unataka kufuta akaunti zote?';

  @override
  String get accountsDeleteAll => 'Ondoa akaunti zote';

  @override
  String get accountShare => 'Shea akaunti';

  @override
  String get addAccount => 'Ongeza akaunti';

  @override
  String get addBusiness => 'Ongeza biashara';

  @override
  String get addContact => 'Ongeza mawasiliano';

  @override
  String get addInvoiceQrToAddress => 'Ongeza QR-invoice kwenye anuani';

  @override
  String get address => 'Anuani';

  @override
  String get addressBook => 'Kitabu cha anuani';

  @override
  String get addToContactFromQrContact => 'Ongeza Qr ya mawasiliano';

  @override
  String get alreadyEndorsedErrorBody =>
      'Akaunti hii tayari imeidhinishwa kwa ajili ya mzunguko huu';

  @override
  String get alreadyEndorsedErrorTitle => 'imeidhinishwa tayari';

  @override
  String get authenticationNeeded => 'Uthibitishaji Unahitajika';

  @override
  String get amountError => 'Kiasi kisichokubalika';

  @override
  String get amountToBeTransferred => 'Tuma kiasi';

  @override
  String get appSettings => 'Mipangilio ya app';

  @override
  String get attestNotificationBody =>
      'Kama washiriki wote wametuma uthibitisho, unaweza kudai pato lako la jamii.';

  @override
  String get attestNotificationTitle => 'Wahudhuriaji waliothibitishwa.';

  @override
  String get available => 'Inapatikana';

  @override
  String get balance => 'Kiasi';

  @override
  String get balanceTooLowBody =>
      'Hauna kiasi cha kutosha kwenye akaunti yako. Huwezi kutuma hela yote kwa sababu unahitaji kiasi cha kulipa makato ya ada.';

  @override
  String get balanceTooLowTitle => 'Kiasi kipo chini sana';

  @override
  String get balanceTransferNotificationBody => 'Mpokeaji amepokea tokeni';

  @override
  String get balanceTransferNotificationTitle => 'Muamala umekamilika';

  @override
  String get benefits => 'Faida';

  @override
  String get biometricAuth => 'Uhakiki wa kibayometriki';

  @override
  String get biometricAuthDescription =>
      'Uthibitishaji wa kibiometri unatumia taarifa za kibiometri zilizohifadhiwa kwenye simu yako kuthibitisha utambulisho wako, badala ya kutumia PIN yako. Unaweza kuwezesha au kuzima uthibitishaji wa kibiometri wakati wowote kwenye mipangilio.';

  @override
  String get biometricAuthEnableDisableDescription =>
      'Ingiza PIN yako ili kuwezesha au kuzima uthibitishaji wa kibiometri.';

  @override
  String get block => 'Zuia';

  @override
  String get bootstrapperContent =>
      'Kama una tiketi za kuidhinisha, itapendeza sana ukiwaidhinisha wanachama wapya kwenye jamii.';

  @override
  String get bootstrapperTitle =>
      'Umesajiliwa kama kamati anzilishi - nafasi yako ya ushiriki ni ya uhakika.';

  @override
  String get calendarEntryDescription => 'Kusanyika kupata pato lako la jamii.';

  @override
  String get cameraPermissionError =>
      'Kulikuwa na hitilafu katika kupata ruhusa ya kamera. Kwa namna nyingine unaweza kutoa ruhusa kwenye mipangilio ya programu(app settings).';

  @override
  String get cancel => 'Sitisha';

  @override
  String get canEndorseInRegisteringPhaseOnly =>
      'Unaweza idhinisha wakati wa usajili tu';

  @override
  String get cantEndorseBootstrapper =>
      'Wanachama waanzilishi tayari wameainishwa kama wenye kuaminika kwenye jamii.';

  @override
  String get categories => 'Kategoria';

  @override
  String get canUseFaucetOnlyWithCurrentAccount =>
      'Unaweza kutumia vipengele vya kisima tu ikiwa ukurasa huu wa akaunti unaonyesha akaunti hai kwa sasa.';

  @override
  String get changeYourPin => 'Badilisha PIN';

  @override
  String get category_all => 'Zote';

  @override
  String get category_art_music => 'Sanaa & Muziki';

  @override
  String get category_body_soul => 'Mwili & Nafsi';

  @override
  String get category_fashion_clothing => 'Mitindo & Mavazi';

  @override
  String get category_food_beverage_store => 'Duka la Chakula & Vinywaji';

  @override
  String get category_restaurants_bars => 'Migahawa & Baa';

  @override
  String get category_it_hardware => 'Vifaa vya IT';

  @override
  String get category_food => 'Chakula';

  @override
  String get category_other => 'Nyingine';

  @override
  String get emailFailedToOpen =>
      'Imeshindikana kufungua programu ya barua pepe.';

  @override
  String get chosenRightCommunity =>
      'Data ni za jamii tofauti. Tafadhali badilisha jamii ili kutuma fedha..';

  @override
  String get claim => 'Dai';

  @override
  String get claimRewardsNotificationBody =>
      'Tayari umeshapokea mapato yako ya jamii!';

  @override
  String get claimRewardsNotificationTitle => 'Umeshapata mapato yako ya jamii';

  @override
  String get claimsScannedAlready =>
      'Dai lililoskaniwa hapo awali limeboreshwa';

  @override
  String get claimsScannedDecodeFailed =>
      'Haikuweza kutafsiri dai lililoskaniwa. Wanachama wengine wanahitaji kuupdate app..';

  @override
  String get claimsScannedNew => 'Skani madai mapya';

  @override
  String get claimsSubmit => 'Wasilisha madai';

  @override
  String get closeGathering => 'Funga mkutano';

  @override
  String get communities => 'Jamii';

  @override
  String get communityChoose => 'Chagua jamii:';

  @override
  String get communityDoChoose => 'Chagua jamii';

  @override
  String get communityNotSelected =>
      'Hujachagua jamii, bonyeza alama ya picha kuchagua';

  @override
  String get confirmPin => 'Ingiza PIN yako kuhakikisha';

  @override
  String get confirmThePayment => '3. Hakikisha malipo';

  @override
  String get contactAddress => 'Anuani';

  @override
  String get contactAddressError => 'Anuani sio sahihi';

  @override
  String get contactAlreadyExists =>
      'Anuani tayari ipo, inatumiwa na mtu mwingine';

  @override
  String get contactDelete => 'Futa';

  @override
  String get contactDeleteWarn => 'una uhakika unataka kufuta anuani?';

  @override
  String get contactEndorse => 'Idhinisha kama mwanachama muaminifu.';

  @override
  String get contactMemo => 'Taarifa za mawasiliano';

  @override
  String get contactName => 'Jina';

  @override
  String get contactNameAlreadyExists => 'Jina tayari lipo';

  @override
  String get contactNameError => 'Jina haliwezi kuwa baki';

  @override
  String get contactSave => 'Hifadhi';

  @override
  String get contactUs => 'Wasiliana nasi';

  @override
  String get copy => 'Nakili';

  @override
  String get count => 'Hesabu';

  @override
  String get create => 'Tengeneza akaunti';

  @override
  String get createError =>
      'Kulikuwa na hitilafu kwenye kutengeneza akaunti yako';

  @override
  String get createHint => '(Mfano: Alice)';

  @override
  String get createPassword => 'PIN';

  @override
  String get createPassword2 => 'Thibitisha PIN';

  @override
  String get createPassword2Error => 'PIN zisizoendana';

  @override
  String get createPasswordError =>
      'PIN lazima iwe na angalau tarakimu 4 na isijumuishe ishara nyingine yoyote';

  @override
  String get deleteAccount => 'futa';

  @override
  String get democracy => 'Demokrasia';

  @override
  String get democracyFaq => 'Demokrasia inafanyeje kazi?';

  @override
  String get democracyDiscussion => 'Jadili mapendekezo kwenye foramu yetu!';

  @override
  String get democracyVotedNotificationBody => 'Umepigia kura pendekezo hili.';

  @override
  String get democracyVotedNotificationTitle => 'Umepiga kura';

  @override
  String get democracyUpdatedProposalStateNotificationBody =>
      'Umesasisha pendekezo hili';

  @override
  String get democracyUpdatedProposalStateNotificationTitle =>
      'Pendekezo limesasishwa';

  @override
  String get democracySubmitProposalNotificationBody =>
      'Ulitoa pendekezo, ambalo watu wanaweza kulipigia kura sasa.';

  @override
  String get democracySubmitProposalNotificationTitle =>
      'Pendekezo limewasilishwa';

  @override
  String get detail => 'Taarifa';

  @override
  String get detailsEnter => 'ingiza taarifa zako.';

  @override
  String get developer => 'Developer mode';

  @override
  String get done => 'Tayari';

  @override
  String get doYouAlreadyHaveAnAccount => 'Je una akaunti tayari?';

  @override
  String get enable => 'Wezesha';

  @override
  String get endorseeContent =>
      'Umeidhinishwa kama mwanachama mwaminifu wa jamii ya Nyota. Hivyo, kuna uhakika wa wewe kuteuliwa kuhudhuria kikao cha mzunguko huu.';

  @override
  String get endorseeTitle =>
      'Umesajiliwa kama muidhinishwa - nafasi yako imehakikishwa';

  @override
  String get endorseNewcomerNotificationBody =>
      'Asante kwa kumuidhinisha mwanachama mpya!';

  @override
  String get endorseNewcomerNotificationTitle =>
      'Mwanachama mpya ameidhinishwa';

  @override
  String get enterAmount => 'Ingiza kiasi';

  @override
  String get error => 'Hitilafu';

  @override
  String get errorMessageNoCommunity => 'Tafadhali chagua jamii.';

  @override
  String get errorOccurred => 'Kuna hitilafu imetokea:';

  @override
  String get errorUserNameIsRequired => 'Jina la mtumiaji haliwezi kuwa baki';

  @override
  String get event => 'ID ya tukio';

  @override
  String get swapOption => 'Chaguo la kubadilisha';

  @override
  String swapOptionRate(String amount, String asset, String cc) {
    return 'Kiwango $amount $cc/$asset';
  }

  @override
  String swapOptionCcLimit(String amount, String cc) {
    return 'Kikomo cha $cc: $amount $cc';
  }

  @override
  String swapOptionAssetToReceive(String amount, String asset) {
    return 'Unapokea: $amount $asset';
  }

  @override
  String swapOptionLimit(String amount, String asset) {
    return 'Kikomo: $amount $asset';
  }

  @override
  String exerciseSwapAssetOptionAvailable(String asset) {
    return 'Chaguo la kubadilisha linapatikana';
  }

  @override
  String get exerciseSwapNativeOptionAvailable =>
      'Chaguo la kubadilisha KSM linapatikana';

  @override
  String get exerciseSwapOption => 'Tumia chaguo la kubadilisha';

  @override
  String get export =>
      'Onyesha taarifa za siri za akaunti yako kuweza kuisafirisha';

  @override
  String get exportAccount => 'Safirisha';

  @override
  String get exportMnemonicOk => 'Maneno ya siri yamenakiliwa.';

  @override
  String get exportWarn =>
      'Andika haya maneno kwenye karatasi. Karatasi hio itunze. Maneno hayo yanamruhusu mtu yeyote kuingia kwenye akaunti na kuweza kutumia mapato yaliyomo.';

  @override
  String get fail => 'Imefeli';

  @override
  String get fee => 'Ada';

  @override
  String get finish => 'Maliza';

  @override
  String get from => 'Kutoka kwa';

  @override
  String get fundsReceived => 'Mali zimepokelewa';

  @override
  String get fundVoucher => 'Vocha ya mali';

  @override
  String get gatheringSuccessfullyCompleted => 'Mkutano umefanikiwa';

  @override
  String get hash => 'Hashi ya muamala';

  @override
  String get hintEnterCurrentPin =>
      'Kubadili PIN yako, tafadhali ingiza ya sasa.';

  @override
  String get hintThenEnterANewPin =>
      'Halafu unaweza ingiza mpya na hapo ndipo inakuwa imebadilika.';

  @override
  String get home => 'Nyumbani';

  @override
  String get howManyParticipantsShowedUp =>
      'Ni wahudhuriaji wangapi ukijumlisha na wewe?';

  @override
  String get import => 'Ingiza';

  @override
  String get importDuplicate =>
      'Akaunti ipo, Je unataka kubadili akaunti iliyopo?';

  @override
  String get importedWithRawSeedHenceNoMnemonic =>
      'Akaunti imeingizwa kwa mbegu za kriptografia hivyo haina maneno ya siri.';

  @override
  String get importInvalidMnemonic => 'Maneno ya siri yaliyoingizwa sio sahihi';

  @override
  String get importInvalidRawSeed => 'Ufunguo wa siri ulioingizwa sio sahihi';

  @override
  String get importMustNotBeEmpty => 'Lazima ujaze chochote';

  @override
  String get importPrivateKeyUnsupported =>
      'Uigizaji wa funguo za siri haujasapotiwa bado.';

  @override
  String get incomeIssuance => 'Mapato ya jamii';

  @override
  String get insufficientBalance => 'Kiasi hakitoshi';

  @override
  String get insufficientFundsErrorBody =>
      'Hauna mali za kutosha kwenye akaunti hii. Angalia kwenye tovuti ya jamii yako kuweza kupata kadhaa.';

  @override
  String get insufficientFundsErrorTitle => 'Mali hazitoshi';

  @override
  String get invalidTransactionFormatErrorBody =>
      'Transaction ilikuwa na muundo usio sahihi, ambayo inaweza kuwa hitilafu katika programu. Ikiwa unadhani hii ni hitilafu, tafadhali bonyeza uwanja unaofaa chini.';

  @override
  String get invalidTransactionFormatErrorTitle =>
      'Muundo wa Transaction Usio Sahihi';

  @override
  String get invalidCommunity => 'sio jamii sahihi';

  @override
  String get invalidNetwork => 'Mtandao sio sahihi';

  @override
  String get invoice => 'Ankara';

  @override
  String get issuanceClaimed => 'Hakuna mapato ya jamii yanayosubiriwa';

  @override
  String get issuancePending => 'Dai mapato ya jamii yanayosubiri';

  @override
  String get keySigningCycle => 'Mzunguko wa Kusaini Funguo';

  @override
  String get keystore => 'Hifadhi ya funguo (json)';

  @override
  String get kusamaFaucet => 'Kisima cha Kusama';

  @override
  String get lang => 'Lugha';

  @override
  String get leuZurichFAQ => 'leu.zuerich FAQ';

  @override
  String get like => 'Penda';

  @override
  String get loading => 'inaload...';

  @override
  String get meetingPoint => 'Sehemu ya kukutana';

  @override
  String get meetupClaimantEqualToSelf =>
      'Hitilafu: Mtoa madai ni sawa na yeye mwenyewe. Dai halijahifadhiwa';

  @override
  String get meetupClaimantInvalid =>
      'Mdai huyu sio sehemu ya mkutano. Dai halijahifadhiwa.';

  @override
  String get meetupLocation => 'Sehemu ya kukutana.';

  @override
  String meetupIndex(Object index) {
    return 'Namba ya mkusanyiko $index';
  }

  @override
  String get meetupIndexPopupExplanation =>
      'Tumia Nambari ya Mkusanyiko kupata eneo lako halisi la mkusanyiko. Kiongozi wa jamii ndiye anayehusika kubainisha maeneo ya mkusanyiko katika jamii yako. Eneo halisi linaweza kuwa tofauti kidogo na lile lililoonyeshwa hapa..';

  @override
  String get meetupNotificationOneDayBeforeContent =>
      'Mkutano unaanza ndani ya masaa 24';

  @override
  String get meetupNotificationOneDayBeforeTitle => 'Masaa 24 yamebaki';

  @override
  String get meetupNotificationOneHourBeforeContent =>
      'Mkutano unaanza ndani ya lisaa 1';

  @override
  String get meetupNotificationOneHourBeforeTitle => 'Saa 1 imebaki';

  @override
  String get mnemonic => 'Maneno ya siri';

  @override
  String get newbieContent =>
      'Kwa hali yako ya sasa, ushiriki wako katika mzunguko ujao hauhakikishiwi. Tafadhali waombe waachama wa jamii yako wakuidhinishe.';

  @override
  String get newbieTitle => 'Ushiriki wa awali';

  @override
  String get next => 'Inayofuata';

  @override
  String get nextCycleDateLabel => 'Mzunguko ujao unaanza';

  @override
  String get nextCycleTimeLeft => 'Mzunguko ujao unaisha';

  @override
  String get noCommunitiesAreYouOffline =>
      'Hakuna jamii zilizopatikana. Unaweza kuchagua moja baadaye. Je, uko mtandaoni?';

  @override
  String get noInvoice => 'Hakuna ankara';

  @override
  String get noItems => 'Hakuna vitu vilivyopatikana';

  @override
  String get noMnemonicFound => 'Hakuna maneno ya siri yaliyopatikana';

  @override
  String get notNow => 'Sio sasa';

  @override
  String get notifySubmittedQueued =>
      'Muamala uliowekwa kwenye foleni umetumwa';

  @override
  String get noTransactions => 'Hakuna muamala';

  @override
  String get noValidClaimsErrorBody =>
      'Hujatuma madai yeyote halali. Je umewaskani wahudhuriaji wengine?';

  @override
  String get noValidClaimsErrorTitle => 'Hakuna madai halali';

  @override
  String get numberOfAttendees => 'Idadi ya wahudhuriaji';

  @override
  String get observe => 'Uchunguzi';

  @override
  String get observeBrief =>
      'Weka anwani hii kwenye uchunguzi, kisha unaweza kuchagua anwani hii katika ukurasa wa kuchagua akaunti, ili kutazama mali na vitendo vyake.';

  @override
  String get observedPendingExtrinsic =>
      'Muamala unaosubiri umeonekana. Tafadhali subiri uthibitisho.!';

  @override
  String get offlineMessage =>
      'Kwa sasa hauko mtandaoni(offline). Madai yako yanaweza kutumwa baadaye kwenye Home screen yako.';

  @override
  String get ok => 'OK';

  @override
  String get onlyReputablesCanEndorseAttendGatheringToBecomeOne =>
      'Ni wanachama hai wenye sifa pekee ndio wanaoweza kuidhinisha. Hudhuria mkusanyiko/vikao ili kupata sifa!';

  @override
  String get openMapApplication => 'Programu ya Open Map';

  @override
  String get openTheEncointerApp => '1. Fungua programu \n«Encointer Wallet»';

  @override
  String get passOld => 'PIN yako ya sasa';

  @override
  String get passSuccess => 'Imefanikiwa';

  @override
  String get passSuccessTxt => 'PIN imefanikiwa kubadilishwa';

  @override
  String get payHereWithLeu => 'Lipa hapa na Leu';

  @override
  String get payment => 'Malipo';

  @override
  String get paymentDoYouWantToProceed => 'Endelea a malipo?';

  @override
  String get paymentError => 'Kuna hitilafu kwenye muamala wa malipo';

  @override
  String get paymentFinished => 'Malipo yamekamilika';

  @override
  String get paymentSubmitting => 'Malipo yanawasilishwa...';

  @override
  String get personalKey => 'Ufunguo binafsi';

  @override
  String get personalKeyEnter =>
      'Tafadhali ingiza funguo zako za kibinafsi (maneno 12) ili kuingiza akaunti mpya.';

  @override
  String get pinHint =>
      'Utahitaji PIN hii kwa ajili ya miamala na kuongeza akaunti mpya.';

  @override
  String get pinInfo =>
      'PIN inapaswa kuwa na angalau tarakimu 4. Ikiwa PIN imepotea, hakuna chaguo la kurejesha akaunti isipokuwa ikiwa ulifanya backup kupitia ukurasa wa wasifu..';

  @override
  String get pinSecure => 'Linda akaunti yako kwa kutumia PIN.';

  @override
  String get pleaseCommunityChoose => 'Tafadhali chagua jamii';

  @override
  String get pleaseConfirmYourNewPin => 'Hakikisha PIN mpya';

  @override
  String get preview => 'Onyesha';

  @override
  String get print => 'Chapisha';

  @override
  String get proposal => 'Pendekezo';

  @override
  String get proposalAye => 'Aye';

  @override
  String get proposalNay => 'Nay';

  @override
  String get proposalNew => 'Mapendekezo mapya';

  @override
  String get proposalExplainerAddLocation =>
      'Pendekezo hili linapendekeza eneo jipya la mkutano kwa jamii yako. Hakikisha kuwa liko angalau mita 100 kutoka kwa maeneo ya mikutano yaliyopo, na si zaidi ya kilomita 1.';

  @override
  String get proposalExplainerRemoveLocation =>
      'Pendekezo hili linapendekeza kuondoa eneo la mikutano lililopo kwa jamii yako.';

  @override
  String get proposalExplainerUpdateDemurrage =>
      'Pendekezo hili linapendekeza kiwango kipya cha demuraji ya kila mwezi kwa tokeni ya jamii yako.';

  @override
  String get proposalExplainerUpdateNominalIncome =>
      'Pendekezo hili linapendekeza mapato mapya ya kawaida katika mizunguko ya mikutano kwa jamii yako.';

  @override
  String get proposalExplainerSetInactivityTimeout =>
      'Pendekezo hili linapendekeza muda mpya wa kimataifa wa kutokufanya kazi. Ikiwa jamii haitafanya mikutano kwa idadi iliyopendekezwa ya mizunguko, itafutwa.';

  @override
  String get proposalExplainerPetition =>
      'Pendekezo hili linatumika kama ombi, iwe kimataifa au ndani ya jamii yako. Ingawa halina athari ya moja kwa moja kwenye mnyororo wa vizuizi, linaonyesha nia, kuruhusu jamii kuitambua na kuchukua hatua.';

  @override
  String get proposalExplainerSpendNative =>
      'Pendekezo hili linapendekeza kutumia KSM kwa faida ya mfaidi kutoka hazina ya jamii, ama kupitia kura za kimataifa au za jamii. Fedha hizi zinaweza kutumika kureward michango ya jamii au kusaidia mipango ya jamii.';

  @override
  String proposalExplainerSpendAsset(String asset) {
    return 'Pendekezo hili linapendekeza kutumia $asset kwa mnufaika kutoka hazina ya jumuiya, ama kupitia kura ya kimataifa au ya kijumuiya. Fedha hizi zinaweza kutumika kupongeza michango ya wanajumuiya au kusaidia miradi ya kijumuiya.\n\nKumbuka: Utapokea $asset moja kwa moja kwenye Asset Hub Kusama.';
  }

  @override
  String proposalExplainerIssueSwapOption(String cc, String asset) {
    return 'Pendekezo hili linamruhusu mnufaika kubadilisha $cc kuwa $asset kwa kiwango kilichowekwa, mara nyingi, hadi kufikiwa kwa kikomo cha $asset. Mnufaika kwa kawaida ni biashara ya ndani inayokubali $cc na inaweza kukusanya ziada.';
  }

  @override
  String get proposalExplainerSwapOptionComputation =>
      'Hesabu kulingana na kiasi chako';

  @override
  String get proposalExplainerRate => 'Kiwango';

  @override
  String get proposalExplainerSwapFee => 'Ada ya kubadilisha';

  @override
  String get proposalExplainerBeneficiaryWillGet => 'Mfaidika atapokea';

  @override
  String proposalExplainerPaymentWillBeOnAH(String asset) {
    return 'Kumbuka: $asset itatumwa moja kwa moja kwenye akaunti yako ya Asset Hub Kusama.';
  }

  @override
  String get proposalExplainerCannotVoteYet =>
      'Utaweza kuanza kupiga kura kwa kutumia sifa yako kuanzia mzunguko ujao!';

  @override
  String get proposalType => 'Aina ya pendekezo';

  @override
  String get proposalTypeAddLocation => 'Ongeza eneo';

  @override
  String get proposalTypeRemoveLocation => 'Ondoa eneo';

  @override
  String get proposalTypeUpdateDemurrage => 'Sasisha ada ya kuchelewesha';

  @override
  String get proposalTypeUpdateNominalIncome => 'Sasisha mapato ya kawaida';

  @override
  String get proposalTypeSetInactivityTimeout =>
      'Weka muda wa kutokufanya kazi';

  @override
  String get proposalTypePetition => 'Ombi rasmi';

  @override
  String get proposalTypeSpendNative => 'KSM asili';

  @override
  String proposalTypeIssueSwapNativeOption(String cc) {
    return 'Badilisha $cc kwa KSM';
  }

  @override
  String proposalTypeSpendAsset(String asset) {
    return 'Tumia $asset';
  }

  @override
  String proposalTypeIssueSwapAssetOption(String cc, String asset) {
    return 'Badilisha $cc kwa $asset';
  }

  @override
  String get proposalScope => 'Wigo';

  @override
  String proposalScopeLocal(String community) {
    return 'Kitaifa ($community)';
  }

  @override
  String get proposalScopeGlobal => 'Kimataifa';

  @override
  String get proposalFieldLatitude => 'Latitudo';

  @override
  String get proposalFieldLongitude => 'Longitudo';

  @override
  String get proposalFieldDemurragePerMonth =>
      'Ada ya kuchelewesha (% / mwezi)';

  @override
  String get proposalFieldNominalIncome => 'Mapato ya kawaida';

  @override
  String get proposalFieldInactivityTimeoutCycles =>
      'Muda wa kutokufanya kazi (mizunguko ya mikutano)';

  @override
  String get proposalFieldPetitionText => 'Maandishi ya ombi rasmi';

  @override
  String get proposalFieldAssetToSpend => 'Tokeni ya kutumia';

  @override
  String proposalFieldAssetToSwap(String cc) {
    return 'Rasilimali ya kupokea kwa ajili ya $cc';
  }

  @override
  String proposalFieldAmount(String asset) {
    return 'Kiasi ($asset)';
  }

  @override
  String get proposalFieldBeneficiary => 'Mnufaika';

  @override
  String proposalFieldAllowance(String asset) {
    return 'Kikomo ($asset)';
  }

  @override
  String proposalFieldRate(String asset, String cc) {
    return 'Kiwango ($cc/$asset)';
  }

  @override
  String get proposalFieldBurn => 'Teketeza';

  @override
  String get proposalFieldValidity => 'Uhalali';

  @override
  String get proposalFieldErrorEnterPetitionText =>
      'Weka maandishi ya ombi rasmi';

  @override
  String get proposalFieldErrorPetitionTextTooLong =>
      'Maandishi ya ombi rasmi ni marefu sana';

  @override
  String get proposalFieldErrorEnterLatitude => 'Weka latitudo';

  @override
  String get proposalFieldErrorLatitudeRange =>
      'Latitudo lazima iwe kati ya -90 na 90';

  @override
  String get proposalFieldErrorEnterLongitude => 'Weka longitudo';

  @override
  String get proposalFieldErrorLongitudeRange =>
      'Longitudo lazima iwe kati ya -180 na 180';

  @override
  String get proposalFieldErrorEnterDemurrage => 'Weka ada ya kuchelewesha';

  @override
  String get proposalFieldErrorDemurrageRange =>
      'Ada ya kuchelewesha lazima iwe kati ya 0 na 100';

  @override
  String get proposalFieldErrorEnterPositiveNumber => 'Weka namba chanya';

  @override
  String get proposalFieldErrorPositiveNumberRange => 'Lazima iwe namba chanya';

  @override
  String proposalFieldErrorPositiveNumberTooBig(String amount) {
    return 'Nambari ni kubwa sana (Kikomo: $amount)';
  }

  @override
  String get proposalFieldErrorEnterInactivityTimeout =>
      'Weka muda wa kutokufanya kazi';

  @override
  String get proposalFieldErrorPositiveIntegerRange =>
      'Lazima iwe namba kamili chanya';

  @override
  String get proposalOnlyBootstrappersOrReputablesCanSubmit =>
      'Ni bootstrappers au waheshimika pekee wanaoweza kuwasilisha pendekezo.';

  @override
  String get proposalOnlyBusinessOwnersCanSubmit =>
      'Ni wamiliki wa biashara pekee wanaoweza kuwasilisha pendekezo hili.';

  @override
  String get proposalCannotSubmitProposalTypePendingEnactment =>
      'Haiwezi kuwasilisha pendekezo la aina hii kwa sababu tayari kuna moja linalosubiri kutekelezwa.';

  @override
  String get proposalClose => 'Funga';

  @override
  String get proposalUpdateState => 'Sasisha';

  @override
  String get proposalUpdateExplanation =>
      'Hii itasasisha hali ya pendekezo. Ikiwa ni la zamani sana na halina kura za kutosha za \'Ndio\', litakataliwa. Ikiwa limekuwa likithibitishwa kwa muda wa kutosha, litakubaliwa.';

  @override
  String get proposalSubmit => 'Wasilisha Pendekezo';

  @override
  String get proposalSuperseded => 'Iliyopita';

  @override
  String get proposalRejected => 'Imekaataliwa';

  @override
  String get proposalEnacted => 'Imetekelezwa';

  @override
  String get proposalApproved => 'Imepitishwa';

  @override
  String get proposalTurnout => 'Mahudhurio';

  @override
  String get proposalHowVote => 'Unapigaje kura?';

  @override
  String get proposalsEmpty => 'Hakuna mapendekezo';

  @override
  String get proposalsUpForVote => 'Mapendekezo yanayopigiwa kura';

  @override
  String get proposalsPast => 'Mapendekezo yaliyopita';

  @override
  String get proposalVote => 'Piga kura';

  @override
  String get proposalVoted => 'Imepigiwa kura';

  @override
  String get proposalOngoingUntil => 'Inaendelea hadi';

  @override
  String get proposalConfirmingUntil => 'Inadhibitisha hadi';

  @override
  String get proposalPendingEnactmentAt => 'Inasubiri utekeleazaji kwenye';

  @override
  String get proposalFailedAndNeedsBump =>
      'Pendekezo limekataliwa na linaweza kufungwa.';

  @override
  String get proposalPassedAndNeedsBump =>
      'Pendekezo limepitishwa na linaweza kufungwa.';

  @override
  String get qrScan => 'Skani QR';

  @override
  String get qrScanHintAccount =>
      'Muombe mpokeaji askani QR kwenye app ya Encointer.';

  @override
  String get rawSeed => 'Mbegu za kriptografia';

  @override
  String get receive => 'Pokea';

  @override
  String get received => 'Imepokelewa';

  @override
  String get receiverAccount => 'Akaunti ya mpokeaji:';

  @override
  String get redeemFailure =>
      'Kulikuwa na hitilafu wakati wa kutumia vocha. Sababu:';

  @override
  String get redeemSuccess => 'Umefaikiwa kutumia vocha.';

  @override
  String get redeemVoucher => 'Tumia vocha';

  @override
  String get registeringPhaseReminderContent =>
      'Usajili wa kikao kijacho umeanza.';

  @override
  String get registeringPhaseReminderTitle => 'Jisajili sasa!';

  @override
  String get registerParticipantNotificationBody =>
      'Utapokea ukumbusho siku moja kabla.';

  @override
  String get registerParticipantNotificationTitle =>
      'Umejisajili kwa ajili ya kikao kijacho!';

  @override
  String get registerUntil => 'Jisajili kabla';

  @override
  String get remainingNewbieTicketsAsBootStrapper =>
      'Tiketi za wanachama wapya/wageni zilizobaki kama mwanachama anzilishi:';

  @override
  String get remainingNewbieTicketsAsReputable =>
      'Tiketi za wanachama wageni zilizobaki kama mwanachama hai:';

  @override
  String get remarkNotificationBody => 'Umetuma kumbuka.';

  @override
  String get remarkNotificationTitle => 'kumbuka imetumwa';

  @override
  String get remarks => 'Maoni ya Onchain';

  @override
  String get remarksButton => 'tuma kumbuka ya umma';

  @override
  String get remarksExplain =>
      'Unaweza kutuma kumbuka kwenye mtandao. Kumbuka hii itakuwa ya umma na isiyobadilika. Inaweza kusomwa na kuthibitishwa na kila mtu kwani itasainiwa kidijitali na wewe.';

  @override
  String get remarksNote => 'Kumbuka';

  @override
  String get remarksSubmit => 'Tuma kumbuka';

  @override
  String get reputableContent =>
      'Umetumia sifa yako kupata kiti kilicho hakikishiwa. Tahadhari: Ikiwa utajiandikisha lakini usijitokeze katika mzunguko, utarudi kuwa mwanachama mpya/mgeni tena..';

  @override
  String get reputableTitle =>
      'Umejisajili kama mwenye mwanachama hai - kiti chako kimehakikishiwa';

  @override
  String get reputationAlreadyCommittedTitle => 'Hadhi yako imetumika';

  @override
  String get reputationAlreadyCommittedContent =>
      'Umeshatumia hadhi yako kukamua kisima cha Kusama.';

  @override
  String get reputationOverall => 'Hadhi yako kwa ujumla';

  @override
  String get restartGathering => 'Anzisha mkutano tena';

  @override
  String get retry => 'Jaribu tena';

  @override
  String get rewardsAlreadyIssuedErrorBody =>
      'Mhudhuriaji mwingine ameanzisha malipo kwa ajili ya mkusanyiko huu. Unapaswa kuwa umepokea mapato yako tayari..';

  @override
  String get rewardsAlreadyIssuedErrorTitle => 'Zawadi tayari zimetolewa';

  @override
  String get scan => 'Skani';

  @override
  String get scanDescriptionForMeetup =>
      'Kila muhudhuriaji lazima askani na askaniwe na kila mtu.';

  @override
  String get scanOthers => 'Waskani wengine';

  @override
  String get scanQrCodeOnTheLeft => '2. Skani code ya QR \non the left';

  @override
  String get sendLink => 'Tuma link';

  @override
  String get sent => 'Imetumwa';

  @override
  String get setting => 'Mipangilio';

  @override
  String get settingLang => 'Lugha';

  @override
  String get settingLangAuto => 'Gundua kiotomatiki';

  @override
  String get settingNetwork => 'Chagua Wallet';

  @override
  String get settingNode => 'Nodi ya mbali';

  @override
  String get settingNodeList => 'Nodi zilizopo';

  @override
  String get settingPrefix => 'Alama za mwanzoni za anuani yako';

  @override
  String get settingPrefixList => 'Available Prefixes';

  @override
  String get share => 'Shea';

  @override
  String get shareInvoice => 'Shea Ankara';

  @override
  String get shareLinkHint => 'Au unaweza kushea link:';

  @override
  String get showRouteMeetupLocation => 'Onyesha ruti.';

  @override
  String get startGathering => 'Azisha mkutano';

  @override
  String get submittedFaucetDripTitle => 'Zawadi za kisima';

  @override
  String get submittedFaucetDripBody =>
      'Umefanikiwa kupata zawadi zako za kisima.';

  @override
  String get success => 'Umefanikiwa';

  @override
  String get switchAccount => 'Badilisha akaunti';

  @override
  String get switchCommunity => 'Badilisha Jamii';

  @override
  String get thankYou => 'Asante';

  @override
  String get title => 'Profaili';

  @override
  String get to => 'Kwa';

  @override
  String get today => 'Leo';

  @override
  String get tomorrow => 'Kesho';

  @override
  String get transactionError => 'Hitilafu kwenye muamala';

  @override
  String get transactionQueuedOffline =>
      'Programu haijaunganishwa na blockchain. Muamala uliowekwa foleni (itatumwa kiotomatiki wakati itakapounganishwa tena).';

  @override
  String get transfer => 'Tuma';

  @override
  String get transferHistory => 'Miamala';

  @override
  String get transferHistoryEnd =>
      'Kupakia miamala ya zamani haijasapotiwa bado';

  @override
  String get transferHistoryTop =>
      'Inaweza kuchukua hadi sekunde 30 kwa ajili ya uhamishaji kuonekana hapa';

  @override
  String treasuryBalanceTooLow(String balance, String cc) {
    return 'Salio la hazina ni la chini sana. Kiwango: $balance $cc';
  }

  @override
  String treasuryGlobalBalance(String balance) {
    return 'Salio huru la hazina ya kimataifa: $balance KSM.';
  }

  @override
  String treasuryLocalBalance(String balance) {
    return 'Salio huru la hazina ya jamii: $balance KSM.';
  }

  @override
  String treasuryLocalBalanceOnAHK(String balance, String asset) {
    return 'Salio huru la hazina ya jamii kwenye AHK: $balance KSM.';
  }

  @override
  String treasuryPendingSpends(String spends) {
    return 'Matumizi yanayosubiri: $spends KSM.';
  }

  @override
  String get txBroadcast => 'Muamala umetumwa.';

  @override
  String get txError => 'Kuna hitilafu kwenye muamala';

  @override
  String get txInBlock => 'Muamala uko kwenye block.';

  @override
  String get txQueued => 'Muamala upo kwenye foleni';

  @override
  String get txQueuedOffline =>
      'Haupo online. Miamala itatumwa punde tu urudipo online.';

  @override
  String get txReady => 'Muamala upo tayari.';

  @override
  String get txTooLowPriorityErrorBody =>
      'Hitilafu ya kipaumbele ya kiufundi ya muamala. Hii inaweza kutokea ikiwa utagusa mara mbili kwa haraka kwenye kitufe cha kutuma. Tafadhali subiri kwa sekunde chache.';

  @override
  String get txTooLowPriorityErrorTitle => 'Hitilafu ya kipaumbele ya muamala';

  @override
  String get unknown => 'Haijulikani';

  @override
  String get unknownAccount => 'Akaunti haijulikani';

  @override
  String get unknownError =>
      'Kuna hitilafu imetokea. Tafadhali kagua muunganisho wako wa intaneti halafu ujaribu tena.';

  @override
  String get unregister => 'Jiondoe';

  @override
  String get unregisterDialogTitle =>
      'Unataka kufuta usajili wako wa kikao kijacho?';

  @override
  String get unregisterParticipantNotificationBody =>
      'Usajili wako kwa mzunguko ujao umefutwa. Ikiwa utabadilisha maoni yako, unaweza kujisajili tena.';

  @override
  String get unregisterParticipantNotificationTitle => 'Usajili umefutwa';

  @override
  String get updatingAppState => 'Inaboresha hali ya programu...';

  @override
  String get value => 'Thamani';

  @override
  String get votesNotDependableErrorBody =>
      'Nusu au chini ya washiriki walioteuliwa ndio walithibitishwa kwa mkusanyiko huu. Inaweza pia kuwa baadhi ya wahudhuriaji hawajaweka uthibitisho wao bado. Hii inazuia malipo ya mapema, na unahitaji kusubiri kwa masaa 48.';

  @override
  String get votesNotDependableErrorTitle => 'Kura hazitegemeani';

  @override
  String get voucher => 'Vocha';

  @override
  String get voucherBalance => 'Salio la Vocha';

  @override
  String get voucherBalanceTooLow => 'Vocha haina mafao ya kutosha kutumiwa.';

  @override
  String get weHopeToSeeYouAtTheNextGathering =>
      'Tuna matumaini kukuona kwenye kikao kijacho.';

  @override
  String get wrongPin => 'PIN sio sahihi';

  @override
  String get wrongPinHint =>
      'Imeshindwa kuifungua akaunti, tafadhali cheki PIN.';

  @override
  String get youAreNotRegisteredPleaseRegisterNextTime =>
      'Hujawekwa kwenye mzunguko huu. Tafadhali jiunge na mzunguko ujao ili upokee mapato yako ya jamii.';

  @override
  String get yourNewPin => 'PIN mpya.';

  @override
  String unlockAccount(String currentAccountName) {
    return 'Fungua akaunti $currentAccountName na PIN';
  }

  @override
  String errorMessageWithStatusCode(String errorText) {
    return 'Kuna kitu hakijaenda sawa, tafadhali jaribu tena! StatusCode: $errorText';
  }

  @override
  String yourBalanceFor(String accountName) {
    return 'Salio lako, $accountName';
  }

  @override
  String incomingConfirmed(num amount, String cidSymbol, String accountName) {
    return 'Salio la $amount $cidSymbol Linaloingia kwa $accountName imethibitishwa';
  }

  @override
  String voucherDifferentNetworkAndCommunity(String network, String community) {
    return 'Vocha hii ni ya mtandao tofauti. Je, unataka kubadilisha mtandao kwenda $network na $community? Unaweza kubadilisha mtandao chini ya Wasifu > Developer mode';
  }

  @override
  String voucherDifferentCommunity(String community) {
    return 'Vocha hii ni ya jamii tofauti. Je, unataka kubadilisha jamii kwenda $community?';
  }

  @override
  String doYouWantToRedeemThisVoucher(String accountName) {
    return 'Je, unataka kutumia vocha hii kwa $accountName?';
  }

  @override
  String claimsSubmitN(int count) {
    return 'Tuma madai $count';
  }

  @override
  String claimsScanned(num amount) {
    return 'Umeskani madai $amount';
  }

  @override
  String claimsScannedNOfM(int scannedCount, int totalCount) {
    return 'Madai yaliyoskaniwa $scannedCount / madai $totalCount';
  }

  @override
  String claimsSubmitDetail(num amount) {
    return 'Inatuma madai $amount kwa mkusanyiko wa hivi karibuni';
  }

  @override
  String youAreRegisteredAs(String participantType) {
    return 'Umejisajili kwenye kikao kijacho kama $participantType.';
  }

  @override
  String youAreAssignedToAGatheringWithNParticipants(int participantsCount) {
    return 'Umewekwa kwenye mkusanyiko na watu $participantsCount';
  }

  @override
  String successfullySentNAttestations(int participantsCount) {
    return 'Umefanikiwa kuwasilisha uthibitisho wa watu $participantsCount wengine.';
  }

  @override
  String tokenSend(String symbol) {
    return 'Tuma $symbol';
  }

  @override
  String communityWithName(String name) {
    return 'Jamii ya $name';
  }

  @override
  String verifyAuthTitle(String useBioAuth) {
    String _temp0 = intl.Intl.selectLogic(
      useBioAuth,
      {
        'true': 'utambulisho wako',
        'false': 'PIN yako',
        'other': ' ',
      },
    );
    return 'Tafadhali thibitisha $_temp0.';
  }

  @override
  String offersForCommunity(String value) {
    return 'Ofa za $value';
  }

  @override
  String proposalApprovalThreshold(String percentage) {
    return 'Kiwango cha Uhakiki: $percentage%';
  }

  @override
  String proposalPassed(String percentage) {
    return 'Imepita kwa $percentage% Aye';
  }

  @override
  String proposalFailed(String percentage) {
    return 'imefeli kwa $percentage% Aye';
  }

  @override
  String proposalIsPassing(String percentage) {
    return 'Kwa sasa inapita kwa $percentage% Aye';
  }

  @override
  String proposalIsFailing(String percentage) {
    return 'Kwa sasa inafeli kwa $percentage% Aye';
  }

  @override
  String proposalSetInactivityTimeoutTo(String value) {
    return 'Kimataifa: Weka muda mpya wa kutokufanya kazi kuwa $value';
  }

  @override
  String proposalAddLocation(String cid) {
    return '$cid: Ongeza eneo jipya';
  }

  @override
  String proposalRemoveLocation(String cid) {
    return '$cid: Ondoa eneo';
  }

  @override
  String proposalUpdateNominalIncome(String value, String currency) {
    return 'Sahisha mapato ya jamii kuwa $value $currency';
  }

  @override
  String proposalUpdateDemurrage(String value) {
    return 'Sasisha demurrage kuwa $value%/mwezi';
  }

  @override
  String proposalPetition(String cid, String value) {
    return '$cid petitioni: $value';
  }

  @override
  String proposalSpendNative(String cid, String amount, String beneficiary) {
    return '$cid hazina itatuma $amount KSM kwa $beneficiary';
  }

  @override
  String proposalSpendAsset(
      String asset, String cid, String amount, String beneficiary) {
    return '$cid hazina itatuma $amount $asset kwa $beneficiary';
  }

  @override
  String proposalIssueSwapNativeOption(
      String cid, String beneficiary, String allowance, String rate) {
    return '$cid: Mruhusu $beneficiary kubadilisha hadi $allowance KSM kwa kiwango cha $rate $cid/KSM.';
  }

  @override
  String proposalIssueSwapOptionCCLimit(
      String asset, String cc, String allowance) {
    return 'Unaweza kubadilisha hadi $allowance $cc kufikia kikomo chako cha $asset kilichowekwa.';
  }

  @override
  String proposalIssueSwapAssetOption(String asset, String cid,
      String beneficiary, String allowance, String rate) {
    return '$cid: Mruhusu $beneficiary kubadilisha hadi $allowance $asset kwa kiwango cha $rate $cid/$asset.';
  }

  @override
  String proposalSupersededBy(String id) {
    return 'Imetanguliwa na: $id';
  }
}
