// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for French (`fr`).
class AppLocalizationsFr extends AppLocalizations {
  AppLocalizationsFr([String locale = 'fr']) : super(locale);

  @override
  String get about => 'About';

  @override
  String get aboutBrief => 'Wallet mobile pour Encointer';

  @override
  String get aboutVersion => 'Version';

  @override
  String get acceptancePoints => 'Points D\'acceptation';

  @override
  String get accountDelete => 'Es-tu certain de vouloir supprimer le compte?';

  @override
  String get accountImport => 'Importer un compte';

  @override
  String get accountName => 'Nom de compte';

  @override
  String get accountNameChoose => 'Choisis un nom de compte.';

  @override
  String get accountNameChooseHint =>
      'Tu pourras le changer plus tard dans les paramètres du profil.';

  @override
  String get accounts => 'Comptes';

  @override
  String get accountsDelete =>
      'Es-tu certain de vouloir supprimer tous les comptes?';

  @override
  String get accountsDeleteAll => 'Supprimer tous les comptes';

  @override
  String get accountShare => 'Partager son compte';

  @override
  String get addAccount => 'Ajouter un compte';

  @override
  String get addBusiness => 'Ajouter une entreprise';

  @override
  String get addContact => 'ajouter un contact';

  @override
  String get addInvoiceQrToAddress =>
      'Ajouter le code QR de la facture à l\'adresse';

  @override
  String get address => 'Adresse';

  @override
  String get addressBook => 'Contacts';

  @override
  String get addToContactFromQrContact => 'Add Contact-Qr';

  @override
  String get alreadyEndorsedErrorBody =>
      'Ce compte a déjà été endossé pour ce cycle';

  @override
  String get alreadyEndorsedErrorTitle => 'Déjà endossé';

  @override
  String get authenticationNeeded => 'Authentification nécessaire';

  @override
  String get amountError => 'Solde non valide';

  @override
  String get amountToBeTransferred => 'Montant';

  @override
  String get appSettings => 'Paramètres de l\'app';

  @override
  String get attestNotificationBody =>
      'Une fois que tous les participants ont envoyé les attestations, tu peux essayer d\'obtenir le revenu.';

  @override
  String get attestNotificationTitle => 'Participants attestés';

  @override
  String get available => 'Disponible';

  @override
  String get balance => 'Solde du compte';

  @override
  String get balanceTooLowBody =>
      'Tu n\'as pas assez d\'argent sur ton compte. Tu ne peux pas envoyer tout ton argent, car il t\'en faut encore un peu pour payer les frais.';

  @override
  String get balanceTooLowTitle => 'Solde trop bas';

  @override
  String get balanceTransferNotificationBody =>
      'Le destinataire a reçu les tokens.';

  @override
  String get balanceTransferNotificationTitle => 'Transaction complète';

  @override
  String get benefits => 'Bénéfices';

  @override
  String get biometricAuth => 'Authentification biométrique';

  @override
  String get biometricAuthDescription =>
      'L\'authentification biométrique utilise les informations biométriques stockées sur ton téléphone pour t\'authentifier au lieu d\'utiliser ton code PIN. Tu peux activer ou désactiver l\'authentification biométrique à tout moment dans les paramètres.';

  @override
  String get biometricAuthEnableDisableDescription =>
      'Entres ton code PIN pour activer ou désactiver l\'authentification biométrique.';

  @override
  String get block => 'Bloc';

  @override
  String get bootstrapperContent =>
      'S\'il te reste des tickets d\'endossement, n\'oublie pas de confirmer Novice comme digne de confiance.';

  @override
  String get bootstrapperTitle =>
      'Enregistré comme Bootstrapper - ta place est garantie.';

  @override
  String get calendarEntryDescription =>
      'Participe à la rencontre pour recevoir ton paiement.';

  @override
  String get cameraPermissionError =>
      'Une erreur s\'est produite lors de la vérification de l\'autorisation de la caméra Tu peux aussi donner l\'autorisation pour la caméra via les paramètres de l\'app.';

  @override
  String get cancel => 'Annuler';

  @override
  String get canEndorseInRegisteringPhaseOnly =>
      'Que pendant la phase d\'inscription tu peux marquer quelqu\'un comme crédible';

  @override
  String get cantEndorseBootstrapper =>
      'Les Bootstrappers sont déjà marqués comme fiables';

  @override
  String get categories => 'Catégories';

  @override
  String get canUseFaucetOnlyWithCurrentAccount =>
      'Tu ne peux utiliser le Faucet que si le compte affiché est le compte actuellement sélectionné.';

  @override
  String get changeYourPin => 'Changer le NIP';

  @override
  String get category_all => 'Tout';

  @override
  String get category_art_music => 'Art & Musique';

  @override
  String get category_body_soul => 'Corps & Esprit';

  @override
  String get category_fashion_clothing => 'Mode & Vêtements';

  @override
  String get category_food_beverage_store => 'Épicerie & Boissons';

  @override
  String get category_restaurants_bars => 'Restaurants & Bars';

  @override
  String get category_it_hardware => 'Matériel informatique';

  @override
  String get category_food => 'Nourriture';

  @override
  String get category_other => 'Autre';

  @override
  String get emailFailedToOpen => 'Impossible d’ouvrir l’application e-mail.';

  @override
  String get chosenRightCommunity =>
      'Les données sont destinées à une autre communauté. S\'il te plaît, change la communauté pour envoyer le paiement.';

  @override
  String get claim => 'Réclamer';

  @override
  String get claimRewardsNotificationBody =>
      'Tu as déjà reçu ton revenu communautaire.';

  @override
  String get claimRewardsNotificationTitle => 'Revenu communautaire demandé';

  @override
  String get claimsScannedAlready =>
      'La demande déjà scannée a été mise à jour';

  @override
  String get claimsScannedDecodeFailed =>
      'La demande scannée n\'a pas pu être décodée. Ton vis-à-vis doit mettre à jour l\'application.';

  @override
  String get claimsScannedNew => 'Nouvelle demande scannée';

  @override
  String get claimsSubmit => 'Déposer les demandes';

  @override
  String get closeGathering => 'Fermer la rencontre.';

  @override
  String get communities => 'Communautés';

  @override
  String get communityChoose => 'Choisis une communauté';

  @override
  String get communityDoChoose => 'Choisir communauté';

  @override
  String get communityNotSelected =>
      'Aucune communauté sélectionnée, clique sur l\'icône';

  @override
  String get confirmPin => 'Veuillez confirmer le code NIP';

  @override
  String get confirmThePayment => '3. Confirmez le paiement';

  @override
  String get contactAddress => 'Adresse';

  @override
  String get contactAddressError => 'Adresse non valide';

  @override
  String get contactAlreadyExists => 'L\'adresse existe déjà';

  @override
  String get contactDelete => 'Supprimer';

  @override
  String get contactDeleteWarn =>
      'Es-tu certain de vouloir supprimer cette adresse?';

  @override
  String get contactEndorse => 'Confirmer comme crédible';

  @override
  String get contactMemo => 'Mémo';

  @override
  String get contactName => 'Nom';

  @override
  String get contactNameAlreadyExists => 'Le nom existe déjà';

  @override
  String get contactNameError => 'Le nom doit être rempli\'.';

  @override
  String get contactSave => 'Enregistrer';

  @override
  String get contactUs => 'Contactez-nous';

  @override
  String get copy => 'Copier';

  @override
  String get count => 'Compter';

  @override
  String get create => 'Créer un compte';

  @override
  String get createError =>
      'Une erreur s\'est produite lors de la création de ton compte';

  @override
  String get createHint => '(Exemple Alice)';

  @override
  String get createPassword => 'NIP';

  @override
  String get createPassword2 => 'Confirmer le NIP';

  @override
  String get createPassword2Error => 'Les codes NIP ne correspondent pas';

  @override
  String get createPasswordError =>
      'Le code NIP doit être composé d\'au moins 4 chiffres et ne contenir aucun autre caractère';

  @override
  String get deleteAccount => 'supprimer';

  @override
  String get democracy => 'Démocratie';

  @override
  String get democracyFaq => 'Comment fonctionne la démocratie?';

  @override
  String get democracyDiscussion => 'Discute de suggestions dans le forum!';

  @override
  String get democracyVotedNotificationBody =>
      'Tu as voté pour cette proposition.';

  @override
  String get democracyVotedNotificationTitle => 'Voté';

  @override
  String get democracyUpdatedProposalStateNotificationBody =>
      'Vous avez mis à jour cette proposition';

  @override
  String get democracyUpdatedProposalStateNotificationTitle =>
      'Proposition mise à jour';

  @override
  String get democracySubmitProposalNotificationBody =>
      'Vous avez fait une proposition, sur laquelle les gens peuvent voter maintenant.';

  @override
  String get democracySubmitProposalNotificationTitle => 'Proposition soumise';

  @override
  String get detail => 'Détail';

  @override
  String get detailsEnter => 'Entre tes détails.';

  @override
  String get developer => 'Mode développeur';

  @override
  String get done => 'Finit';

  @override
  String get doYouAlreadyHaveAnAccount => 'Tu as déjà un compte?';

  @override
  String get enable => 'Activer';

  @override
  String get endorseeContent =>
      'Tu as été confirmé comme membre de confiance par un Bootstrapper. Ta place est donc garantie.';

  @override
  String get endorseeTitle =>
      'Enregistré comme Endosser - Ta place est garantie.';

  @override
  String get endorseNewcomerNotificationBody =>
      'Merci d\'avoir endossé le Novice!';

  @override
  String get endorseNewcomerNotificationTitle => 'Novice endossé';

  @override
  String get enterAmount => 'Saisir le montant';

  @override
  String get error => 'Erreur';

  @override
  String get errorMessageNoCommunity => 'Choisis une communauté.';

  @override
  String get errorOccurred => 'Une erreur est apparue:';

  @override
  String get errorUserNameIsRequired =>
      'Le nom d\'utilisateur ne doit pas être vide';

  @override
  String get event => 'ID d\'événement';

  @override
  String get swapOption => 'Option d’échange';

  @override
  String swapOptionRate(String amount, String asset, String cc) {
    return 'Taux $amount $cc/$asset';
  }

  @override
  String swapOptionCcLimit(String amount, String cc) {
    return 'Limite $cc : $amount $cc';
  }

  @override
  String swapOptionAssetToReceive(String amount, String asset) {
    return 'Vous recevez : $amount $asset';
  }

  @override
  String swapOptionLimit(String amount, String asset) {
    return 'Limite : $amount $asset';
  }

  @override
  String exerciseSwapAssetOptionAvailable(String asset) {
    return 'Option d’échange disponible';
  }

  @override
  String get exerciseSwapNativeOptionAvailable =>
      'Option d’échange KSM disponible';

  @override
  String get exerciseSwapOption => 'Exercer l’option d’échange';

  @override
  String get export => 'Activer le Bazaar';

  @override
  String get exportAccount => 'exporter';

  @override
  String get exportMnemonicOk => 'Mnémonique a été copié dans le clipboard.';

  @override
  String get exportWarn =>
      'Écris ces mots sur un papier. Garde le papier dans un endroit sûr. Ces mots donnent à n\'importe qui l\'accès au compte et à la fortune.';

  @override
  String get fail => 'Échec';

  @override
  String get fee => 'Frais';

  @override
  String get finish => 'Terminer';

  @override
  String get from => 'De';

  @override
  String get fundsReceived => 'Réception du paiement';

  @override
  String get fundVoucher => 'Recharger le bon';

  @override
  String get gatheringSuccessfullyCompleted => 'La rencontre a été un succès';

  @override
  String get hash => 'Hachage de la transaction';

  @override
  String get hintEnterCurrentPin =>
      'Entre ton code PIN actuel pour le modifier.';

  @override
  String get hintThenEnterANewPin =>
      'Tu peux ensuite saisir ton nouveau code NIP.';

  @override
  String get home => 'Écran de démarrage';

  @override
  String get howManyParticipantsShowedUp =>
      'Combien de participants y a-t-il, toi y compris ';

  @override
  String get import => 'Importer';

  @override
  String get importDuplicate => 'Ce compte existe déjà, veux-tu le remplacer ?';

  @override
  String get importedWithRawSeedHenceNoMnemonic =>
      'Le compte a été importé avec une graine brute et n\'a donc pas de mnémonique.';

  @override
  String get importInvalidMnemonic => 'Mnémonique invalide entré';

  @override
  String get importInvalidRawSeed => 'Raw seed invalide entré';

  @override
  String get importMustNotBeEmpty => 'L\'entrée ne peut pas être vide';

  @override
  String get importPrivateKeyUnsupported =>
      'Le compte d\'importation avec clé privée n\'est pas encore pris en charge';

  @override
  String get incomeIssuance => 'Revenu communautaire';

  @override
  String get insufficientBalance => 'Solde insuffisant';

  @override
  String get insufficientFundsErrorBody =>
      'Tu n\'as pas assez d\'argent sur ce compte. Regarde sur le site web de ta communauté locale pour savoir comment en obtenir.';

  @override
  String get insufficientFundsErrorTitle => 'Trop peu de crédit';

  @override
  String get invalidTransactionFormatErrorBody =>
      'La transaction avait un format invalide, ce qui pourrait être un bug dans l\'application. Si tu penses que c\'est un bug, clique sur le champ correspondant ci-dessous.';

  @override
  String get invalidTransactionFormatErrorTitle =>
      'Format de transaction invalide';

  @override
  String get invalidCommunity => 'Communauté non valide.';

  @override
  String get invalidNetwork => 'Réseau non valide';

  @override
  String get invoice => 'Montant de la facture';

  @override
  String get issuanceClaimed => 'Pas de paiement communautaire à payer';

  @override
  String get issuancePending => 'Demander paiement communautaire';

  @override
  String get keySigningCycle => 'Cycle de signature de clé';

  @override
  String get keystore => 'Keystore (json)';

  @override
  String get kusamaFaucet => 'Kusama Faucet';

  @override
  String get lang => 'Langue';

  @override
  String get leuZurichFAQ => 'leu.zuerich FAQ';

  @override
  String get like => 'J\'aime';

  @override
  String get loading => 'Chargement…';

  @override
  String get meetingPoint => 'Point de rencontre';

  @override
  String get meetupClaimantEqualToSelf =>
      'Erreur, l\'adresse est le compte actuel. La demande n\'a pas été enregistrée.';

  @override
  String get meetupClaimantInvalid =>
      'L\'auteur de la demande ne fait pas partie de ton rencontre. La demande n\'a pas été enregistrée.';

  @override
  String get meetupLocation => 'Point de rencontre';

  @override
  String meetupIndex(Object index) {
    return 'Réunion numéro: $index';
  }

  @override
  String get meetupIndexPopupExplanation =>
      'Utilise le numéro de réunion pour trouver ton lieu de réunion réel. Dans ta communauté, c\'est le responsable de la communauté qui est chargé de spécifier les lieux de réunion. Le lieu réel peut être légèrement différent de celui affiché ici.';

  @override
  String get meetupNotificationOneDayBeforeContent =>
      'Réunion commence dans 24h';

  @override
  String get meetupNotificationOneDayBeforeTitle => '24 heures restantes';

  @override
  String get meetupNotificationOneHourBeforeContent =>
      'Réunion commence dans une heure';

  @override
  String get meetupNotificationOneHourBeforeTitle => 'Encore 1 heure';

  @override
  String get mnemonic => 'Mnémonique';

  @override
  String get newbieContent =>
      'Compte tenu de ton état actuel, ta participation au prochain cycle n\'est pas garantie. Demande un endossement à tes contacts.';

  @override
  String get newbieTitle => 'Participation provisoire';

  @override
  String get next => 'Continuer';

  @override
  String get nextCycleDateLabel => 'Prochain cycle:';

  @override
  String get nextCycleTimeLeft => 'Prochain cycle: dans';

  @override
  String get noCommunitiesAreYouOffline =>
      'Aucune communauté n\'a été trouvée. Tu pourras en choisir une plus tard. Tu es hors ligne ?';

  @override
  String get noInvoice => 'Sans facture';

  @override
  String get noItems => 'Aucun objet trouvé';

  @override
  String get noMnemonicFound => 'Aucun mnémonique trouvé';

  @override
  String get notNow => 'Pas maintenant';

  @override
  String get notifySubmittedQueued =>
      'La transaction dans la file d\'attente a été soumise';

  @override
  String get noTransactions => 'Aucune transaction';

  @override
  String get noValidClaimsErrorBody =>
      'Vous n\'avez pas envoyé de confirmations valables. As-tu scanné les autres participants?';

  @override
  String get noValidClaimsErrorTitle => 'Pas de confirmations valides';

  @override
  String get numberOfAttendees => 'Nombre de participants';

  @override
  String get observe => 'Moniteur';

  @override
  String get observeBrief =>
      'Marquez cette adresse comme étant à moniteur, puis cette adresse peut être sélectionnée dans la page de sélection de compte pour surveiller ses actifs et ses actions';

  @override
  String get observedPendingExtrinsic =>
      'Une transaction non confirmée a été observée. Veuillez attendre la confirmation!';

  @override
  String get offlineMessage =>
      'Tu es hors ligne. Tes demandes peuvent être soumises plus tard sur l\'écran d\'accueil.';

  @override
  String get ok => 'OK';

  @override
  String get onlyReputablesCanEndorseAttendGatheringToBecomeOne =>
      'Seules les Reputables peuvent endosser. Participez à une réunion pour gagner de réputation!';

  @override
  String get openMapApplication => 'Ouvrer l\'application de carte';

  @override
  String get openTheEncointerApp =>
      '1. Ouvre l\'application \"Encointer Wallet\"';

  @override
  String get passOld => 'NIP actuel';

  @override
  String get passSuccess => 'Réussi';

  @override
  String get passSuccessTxt => 'Le code NIP a été modifié avec succès.';

  @override
  String get payHereWithLeu => 'Paye ici avec Leu';

  @override
  String get payment => 'Paiement';

  @override
  String get paymentDoYouWantToProceed => 'Continuer le paiement?';

  @override
  String get paymentError => 'Erreur de paiement';

  @override
  String get paymentFinished => 'Paiement effectué';

  @override
  String get paymentSubmitting => 'Le paiement est présenté';

  @override
  String get personalKey => 'Clé personnelle';

  @override
  String get personalKeyEnter =>
      'Entre ta clé personnelle (12 mots) pour importer ton compte.';

  @override
  String get pinHint =>
      'Tu auras besoin de ce code NIP pour effectuer des transactions ou ajouter de nouveaux comptes.';

  @override
  String get pinInfo =>
      'Le code NIP doit contenir au moins 4 chiffres. En cas de perte du NIP, le compte n\'est pas récupérable, sauf si tu as fait une sauvegarde sur la page de profil.';

  @override
  String get pinSecure => 'Sécurise ton compte avec un NIP.';

  @override
  String get pleaseCommunityChoose => 'Veuilles choisir une communauté';

  @override
  String get pleaseConfirmYourNewPin => 'Confirme le nouveau NIP';

  @override
  String get preview => 'Aperçu';

  @override
  String get print => 'Imprimer';

  @override
  String get proposal => 'Proposition';

  @override
  String get proposalAye => 'Aye';

  @override
  String get proposalNay => 'Nay';

  @override
  String get proposalNew => 'Nouvelle Proposition';

  @override
  String get proposalExplainerAddLocation =>
      'Cette proposition suggère un nouveau lieu de rencontre pour votre communauté. Assurez-vous qu\'il soit situé à au moins 100 mètres et à pas plus de 1 kilomètre des lieux de rencontre existants.';

  @override
  String get proposalExplainerRemoveLocation =>
      'Cette proposition suggère de supprimer un lieu de rencontre existant pour votre communauté.';

  @override
  String get proposalExplainerUpdateDemurrage =>
      'Cette proposition suggère un nouveau taux de démurrage mensuel pour le jeton de votre communauté.';

  @override
  String get proposalExplainerUpdateNominalIncome =>
      'Cette proposition suggère un nouveau revenu nominal dans les cycles de rencontre pour votre communauté.';

  @override
  String get proposalExplainerSetInactivityTimeout =>
      'Cette proposition suggère un nouveau délai global d\'inactivité. Si une communauté n\'organise pas de rencontres pendant le nombre de cycles suggéré, elle sera supprimée.';

  @override
  String get proposalExplainerPetition =>
      'Cette proposition sert de pétition, soit au niveau global, soit au sein de votre communauté. Bien qu\'elle n\'ait pas d\'effet direct sur la blockchain, elle signale une intention permettant à la communauté de la reconnaître et d\'y répondre.';

  @override
  String get proposalExplainerSpendNative =>
      'Cette proposition suggère de dépenser des KSM pour un bénéficiaire provenant du trésor de la communauté, soit par un vote global, soit par un vote de la communauté. Ces fonds peuvent récompenser les contributions à la communauté ou soutenir des initiatives communautaires.';

  @override
  String proposalExplainerSpendAsset(String asset) {
    return 'Cette proposition suggère de dépenser des $asset pour un bénéficiaire à partir du trésor de la communauté, soit par un vote global, soit par un vote communautaire. Ces fonds peuvent récompenser les contributions ou soutenir des initiatives communautaires.\n\nRemarque : Tu recevras les $asset directement sur Asset Hub Kusama.';
  }

  @override
  String proposalExplainerIssueSwapOption(String cc, String asset) {
    return 'Cette proposition permet au bénéficiaire d’échanger des $cc contre des $asset à un taux fixe, plusieurs fois, jusqu’à atteindre une limite définie de $asset. Le bénéficiaire est généralement une entreprise locale qui accepte les $cc et peut accumuler un surplus.';
  }

  @override
  String get proposalExplainerSwapOptionComputation =>
      'Calcul avec tes données';

  @override
  String get proposalExplainerRate => 'Taux';

  @override
  String get proposalExplainerSwapFee => 'Frais d’échange';

  @override
  String get proposalExplainerBeneficiaryWillGet => 'Le bénéficiaire recevra';

  @override
  String proposalExplainerPaymentWillBeOnAH(String asset) {
    return 'Remarque : Les $asset seront envoyés directement sur votre compte Asset Hub Kusama.';
  }

  @override
  String get proposalExplainerCannotVoteYet =>
      'Tu pourras commencer à voter avec ta réputation à partir du prochain cycle !';

  @override
  String get proposalType => 'Type de proposition';

  @override
  String get proposalTypeAddLocation => 'Ajouter un lieu';

  @override
  String get proposalTypeRemoveLocation => 'Retrancher un lieu';

  @override
  String get proposalTypeUpdateDemurrage => 'Mettre à jour la démurrage';

  @override
  String get proposalTypeUpdateNominalIncome =>
      'Mettre à jour le revenu nominal';

  @override
  String get proposalTypeSetInactivityTimeout =>
      'Définir le délai d\'inactivité';

  @override
  String get proposalTypePetition => 'Pétition';

  @override
  String get proposalTypeSpendNative => 'Dépenser des KSM';

  @override
  String proposalTypeIssueSwapNativeOption(String cc) {
    return 'Échanger $cc contre KSM';
  }

  @override
  String proposalTypeSpendAsset(String asset) {
    return 'Dépenser $asset';
  }

  @override
  String proposalTypeIssueSwapAssetOption(String cc, String asset) {
    return 'Échanger $cc contre $asset';
  }

  @override
  String get proposalScope => 'Portée';

  @override
  String proposalScopeLocal(String community) {
    return 'Local ($community)';
  }

  @override
  String get proposalScopeGlobal => 'Global';

  @override
  String get proposalFieldLatitude => 'Latitude';

  @override
  String get proposalFieldLongitude => 'Longitude';

  @override
  String get proposalFieldDemurragePerMonth => 'Démurrage (% / mois)';

  @override
  String get proposalFieldNominalIncome => 'Revenu nominal';

  @override
  String get proposalFieldInactivityTimeoutCycles =>
      'Délai d\'inactivité (cycles de rencontre)';

  @override
  String get proposalFieldPetitionText => 'Texte de la pétition';

  @override
  String get proposalFieldAssetToSpend => 'Jeton à dépenser';

  @override
  String proposalFieldAssetToSwap(String cc) {
    return 'Actif à recevoir pour $cc';
  }

  @override
  String proposalFieldAmount(String asset) {
    return 'Montant ($asset)';
  }

  @override
  String get proposalFieldBeneficiary => 'Bénéficiaire';

  @override
  String proposalFieldAllowance(String asset) {
    return 'Limite ($asset)';
  }

  @override
  String proposalFieldRate(String asset, String cc) {
    return 'Taux ($cc/$asset)';
  }

  @override
  String get proposalFieldBurn => 'Brûler';

  @override
  String get proposalFieldValidity => 'Validité';

  @override
  String get proposalFieldErrorEnterPetitionText =>
      'Entrez le texte de la pétition';

  @override
  String get proposalFieldErrorPetitionTextTooLong =>
      'Le texte de la pétition est trop long';

  @override
  String get proposalFieldErrorEnterLatitude => 'Entrez la latitude';

  @override
  String get proposalFieldErrorLatitudeRange =>
      'La latitude doit être comprise entre -90 et 90';

  @override
  String get proposalFieldErrorEnterLongitude => 'Entrez la longitude';

  @override
  String get proposalFieldErrorLongitudeRange =>
      'La longitude doit être comprise entre -180 et 180';

  @override
  String get proposalFieldErrorEnterDemurrage => 'Entrez la démurrage';

  @override
  String get proposalFieldErrorDemurrageRange =>
      'La démurrage doit être comprise entre 0 et 100';

  @override
  String get proposalFieldErrorEnterPositiveNumber =>
      'Entrez un nombre positif';

  @override
  String get proposalFieldErrorPositiveNumberRange =>
      'Doit être un nombre positif';

  @override
  String proposalFieldErrorPositiveNumberTooBig(String amount) {
    return 'Le nombre est trop grand (limite : $amount)';
  }

  @override
  String get proposalFieldErrorEnterInactivityTimeout =>
      'Entrez le délai d\'inactivité';

  @override
  String get proposalFieldErrorPositiveIntegerRange =>
      'Doit être un entier positif';

  @override
  String get proposalOnlyBootstrappersOrReputablesCanSubmit =>
      'Seuls les bootstrappers ou les Reputables peuvent soumettre une proposition.';

  @override
  String get proposalOnlyBusinessOwnersCanSubmit =>
      'Seuls les propriétaires d’entreprises peuvent soumettre cette proposition.';

  @override
  String get proposalCannotSubmitProposalTypePendingEnactment =>
      'Impossible de soumettre une proposition de ce type, car une autre est déjà en attente d\'adoption.';

  @override
  String get proposalClose => 'Fermer';

  @override
  String get proposalUpdateState => 'Mettre à jour';

  @override
  String get proposalUpdateExplanation =>
      'Cela mettra à jour l\'état de la proposition. Si elle est trop ancienne et n\'a pas suffisamment de votes Aye, elle sera rejetée. Si elle a été confirmée assez longtemps, elle sera acceptée.';

  @override
  String get proposalSubmit => 'Soumettre une proposition';

  @override
  String get proposalSuperseded => 'Epargné';

  @override
  String get proposalRejected => 'Refusé';

  @override
  String get proposalEnacted => 'Exécuté';

  @override
  String get proposalApproved => 'Accepté';

  @override
  String get proposalTurnout => 'Participation';

  @override
  String get proposalHowVote => 'Comment voter?';

  @override
  String get proposalsEmpty => 'Pas de propositions';

  @override
  String get proposalsUpForVote => 'Propositions soumises au vote';

  @override
  String get proposalsPast => 'Propositions antérieures';

  @override
  String get proposalVote => 'Voter';

  @override
  String get proposalVoted => 'Voté';

  @override
  String get proposalOngoingUntil => 'En cours jusqu\'à';

  @override
  String get proposalConfirmingUntil => 'En confirmation jusqu\'à';

  @override
  String get proposalPendingEnactmentAt => 'Sera exécutée le';

  @override
  String get proposalFailedAndNeedsBump =>
      'La proposition a échoué et peut être fermée.';

  @override
  String get proposalPassedAndNeedsBump =>
      'La proposition a été adoptée et peut être fermée.';

  @override
  String get qrScan => 'Scannez le code QR';

  @override
  String get qrScanHintAccount =>
      'Demande au destinataire de scanner le code QR dans l\'application Encointer.';

  @override
  String get rawSeed => 'Raw Seed';

  @override
  String get receive => 'Exiger';

  @override
  String get received => 'Reçu';

  @override
  String get receiverAccount => 'Compte de réception :';

  @override
  String get redeemFailure =>
      'Une erreur s\'est produite lors de l\'utilisation du bon d\'achat. Cause de l\'erreur :';

  @override
  String get redeemSuccess => 'Bon validé avec succès';

  @override
  String get redeemVoucher => 'Valider un bon d\'achat';

  @override
  String get registeringPhaseReminderContent =>
      'L\'inscription pour la prochaine réunion a commencé.';

  @override
  String get registeringPhaseReminderTitle => 'Inscris-tois maintenant!';

  @override
  String get registerParticipantNotificationBody =>
      'Tu recevras un rappel un jour avant.';

  @override
  String get registerParticipantNotificationTitle =>
      'Inscrit pour le prochain cycle!';

  @override
  String get registerUntil => 'Inscrive-toi avant le';

  @override
  String get remainingNewbieTicketsAsBootStrapper =>
      'Novice-Tickets restants en tant que bootstrapper';

  @override
  String get remainingNewbieTicketsAsReputable =>
      'Comme Reputable les billets pour Novice restants:';

  @override
  String get remarkNotificationBody => 'Vous avez soumis une note.';

  @override
  String get remarkNotificationTitle => 'Note soumise';

  @override
  String get remarks => 'Remarques en chaine';

  @override
  String get remarksButton => 'soumettre une note publique';

  @override
  String get remarksExplain =>
      'Vous pouvez soumettre une note au réseau. Cette note sera publique et immuable. Elle peut être lue et authentifiée par tout le monde car elle sera signée numériquement par toi.';

  @override
  String get remarksNote => 'Note';

  @override
  String get remarksSubmit => 'Soumettre la note';

  @override
  String get reputableContent =>
      '\"Tu as utilisé ta réputation pour obtenir une place garantie. Attention : si tu t\'enregistres, mais que tu ne te présentes pas à la réunion, tu redeviens un Novice\".';

  @override
  String get reputableTitle =>
      'Enregistré en tant que Reputable. Ta place est garantie';

  @override
  String get reputationAlreadyCommittedTitle => 'Réputation déjà utilisée';

  @override
  String get reputationAlreadyCommittedContent =>
      'Vous avez déjà utilisé votre réputation pour faire couler le Faucet.';

  @override
  String get reputationOverall => 'Réputation générale';

  @override
  String get restartGathering => 'Redémarrer la rencontre';

  @override
  String get retry => 'Réessayer';

  @override
  String get rewardsAlreadyIssuedErrorBody =>
      'Un autre participant a déclenché le paiement pour cette rencontre. Tu devrais avoir déjà reçu ton revenu.';

  @override
  String get rewardsAlreadyIssuedErrorTitle => 'Revenu déjà versé';

  @override
  String get scan => 'Scanner';

  @override
  String get scanDescriptionForMeetup =>
      'Chaque personne présente doit scanner toutes les autres, et être scannée par toutes.';

  @override
  String get scanOthers => 'Scanner les autres';

  @override
  String get scanQrCodeOnTheLeft => '2. Scanne le code QR sur la gauche';

  @override
  String get sendLink => 'Envoyer un lien';

  @override
  String get sent => 'Envoyé';

  @override
  String get setting => 'Paramètres';

  @override
  String get settingLang => 'Langue';

  @override
  String get settingLangAuto => 'Automatiquement';

  @override
  String get settingNetwork => 'Choisir un wallet';

  @override
  String get settingNode => 'Nœud supprimé';

  @override
  String get settingNodeList => 'Nœuds disponibles';

  @override
  String get settingPrefix => 'Préfixe d\'adresse';

  @override
  String get settingPrefixList => 'Préfixe disponible';

  @override
  String get share => 'Partager';

  @override
  String get shareInvoice => 'Partages la facture';

  @override
  String get shareLinkHint => 'Ou partager via un lien :';

  @override
  String get showRouteMeetupLocation => 'Afficher la route';

  @override
  String get startGathering => 'Démarrer la rencontre';

  @override
  String get submittedFaucetDripTitle => 'Bénéfices';

  @override
  String get submittedFaucetDripBody =>
      'Ta as réclamé avec succès tes récompenses de robinet.';

  @override
  String get success => 'Réussite';

  @override
  String get switchAccount => 'Changer de compte';

  @override
  String get switchCommunity => 'Changer de communauté';

  @override
  String get thankYou => 'Merci';

  @override
  String get title => 'Profil';

  @override
  String get to => 'A';

  @override
  String get today => 'Aujourd\'hui';

  @override
  String get tomorrow => 'Demain';

  @override
  String get transactionError => 'Erreur de transaction';

  @override
  String get transactionQueuedOffline =>
      'L\'application n\'est pas connectée à la blockchain. Les transactions dans la file d\'attente sont envoyées automatiquement en cas de connexion réussie.';

  @override
  String get transfer => 'Envoyer';

  @override
  String get transferHistory => 'Transferts';

  @override
  String get transferHistoryEnd =>
      'Le chargement des transactions plus anciennes n\'est pas encore pris en charge';

  @override
  String get transferHistoryTop =>
      'Le transfert peut prendre jusqu\'à 30 secondes avant d\'apparaître ici';

  @override
  String treasuryBalanceTooLow(String balance, String cc) {
    return 'Solde du trésor trop bas. Limite : $balance $cc';
  }

  @override
  String treasuryGlobalBalance(String balance) {
    return 'Solde libre du trésor global : $balance KSM.';
  }

  @override
  String treasuryLocalBalance(String balance) {
    return 'Solde libre du trésor communautaire : $balance KSM.';
  }

  @override
  String treasuryLocalBalanceOnAHK(String balance, String asset) {
    return 'Solde libre du trésor communautaire sur Asset Hub: $balance $asset.';
  }

  @override
  String treasuryPendingSpends(String spends) {
    return 'Dépenses en attente : $spends KSM.';
  }

  @override
  String get txBroadcast => 'La transaction a été envoyée sur le réseau';

  @override
  String get txError => 'Erreur de transaction';

  @override
  String get txInBlock => 'Transaction est dans un bloc';

  @override
  String get txQueued => 'La transaction est dans la file d\'attente.';

  @override
  String get txQueuedOffline =>
      'Tu es hors ligne. La transaction sera envoyée lorsque tu seras en ligne.';

  @override
  String get txReady => 'La transaction est prête.';

  @override
  String get txTooLowPriorityErrorBody =>
      'Erreur technique de transaction. Cela peut arriver si tu envoies deux fois une transaction dans un laps de temps très court. Veuillez patienter quelques secondes\'.';

  @override
  String get txTooLowPriorityErrorTitle => 'Erreur de priorité de transaction';

  @override
  String get unknown => 'Inconnu';

  @override
  String get unknownAccount => 'Compte inconnu';

  @override
  String get unknownError =>
      'Une erreur est survenue. Vérifie ta connexion Internet et réessaye.';

  @override
  String get unregister => 'Se désinscrire';

  @override
  String get unregisterDialogTitle => 'Se désinscrire du prochain cycle?';

  @override
  String get unregisterParticipantNotificationBody =>
      'Tu t\'es désinscrit du prochain cycle. Tu peux te réinscrire si tu changes d\'avis.';

  @override
  String get unregisterParticipantNotificationTitle => 'Inscription annulée';

  @override
  String get updatingAppState => 'L\'état de l\'app est mis à jour...';

  @override
  String get value => 'Valeur';

  @override
  String get votesNotDependableErrorBody =>
      'Seule la moitié ou moins des participants attribués ont été confirmés, ou certains participants n\'ont pas encore envoyé leurs confirmations. Cela empêche le paiement immédiat du revenu et tu dois attendre 48 heures.';

  @override
  String get votesNotDependableErrorTitle => 'Confirmations insuffisantes';

  @override
  String get voucher => 'Bon d\'achat';

  @override
  String get voucherBalance => 'Valeur du bon';

  @override
  String get voucherBalanceTooLow =>
      'Le bon a trop peu d\'argent pour être utilisé.';

  @override
  String get weHopeToSeeYouAtTheNextGathering =>
      'Nous espérons te revoir à la prochaine rencontre';

  @override
  String get wrongPin => 'Code NIP erroné';

  @override
  String get wrongPinHint =>
      'Le compte n\'a pas pu être débloqué. Veuillez vérifier le code NIP saisi.';

  @override
  String get youAreNotRegisteredPleaseRegisterNextTime =>
      'Tu n\'as pas été assigné à ce cycle de signature de clé. Si\'il te plaît, inscris-toi pour le prochain cycle pour recevoir ton paiement de communauté.';

  @override
  String get yourNewPin => 'Nouveau NIP';

  @override
  String unlockAccount(String currentAccountName) {
    return 'Débloquer le compte $currentAccountName avec un code NIP.';
  }

  @override
  String errorMessageWithStatusCode(String errorText) {
    return 'Une erreur s\'est produite. Veuillez réessayer! StatusCode: $errorText';
  }

  @override
  String yourBalanceFor(String accountName) {
    return 'Solde du compte, $accountName';
  }

  @override
  String incomingConfirmed(num amount, String cidSymbol, String accountName) {
    return 'Réception confirmée de $amount $cidSymbol pour $accountName';
  }

  @override
  String voucherDifferentNetworkAndCommunity(String network, String community) {
    return 'Le bon est pour un autre réseau. Veux-tu passer à $network et $community? Tu peux changer de réseau sous Profil > Mode développeur';
  }

  @override
  String voucherDifferentCommunity(String community) {
    return 'Le bon est pour une autre communauté. Tu veux changer pour $community?';
  }

  @override
  String doYouWantToRedeemThisVoucher(String accountName) {
    return 'Tu veux utiliser ce bon d\'achat pour $accountName?';
  }

  @override
  String claimsSubmitN(int count) {
    return 'Déposer $count des demandes.';
  }

  @override
  String claimsScanned(num amount) {
    return 'Tu as scanné $amount demandes.';
  }

  @override
  String claimsScannedNOfM(int scannedCount, int totalCount) {
    return '$scannedCount / $totalCount demandes scannées';
  }

  @override
  String claimsSubmitDetail(num amount) {
    return 'Dépose $amount affirmations pour cette assemblée';
  }

  @override
  String youAreRegisteredAs(String participantType) {
    return 'Tu t\'es inscrit comme $participantType a la prochain rencontre.';
  }

  @override
  String youAreAssignedToAGatheringWithNParticipants(int participantsCount) {
    return 'Tu es assigné à une rencontre avec des personnes de $participantsCount.';
  }

  @override
  String successfullySentNAttestations(int participantsCount) {
    return 'Tu as soumis avec succès des attestations pour $participantsCount autres personnes.';
  }

  @override
  String tokenSend(String symbol) {
    return 'Envoyer $symbol';
  }

  @override
  String communityWithName(String name) {
    return 'Communauté $name';
  }

  @override
  String verifyAuthTitle(String useBioAuth) {
    String _temp0 = intl.Intl.selectLogic(
      useBioAuth,
      {
        'true': 'ta identité',
        'false': 'ton NIP',
        'other': '',
      },
    );
    return 'Vérifie $_temp0 s\'il te plaît.';
  }

  @override
  String offersForCommunity(String value) {
    return 'Des offres pour un $value';
  }

  @override
  String proposalApprovalThreshold(String percentage) {
    return 'Valeur seuil d\'acceptation: $percentage%';
  }

  @override
  String proposalPassed(String percentage) {
    return 'Adopté avec $percentage% Aye';
  }

  @override
  String proposalFailed(String percentage) {
    return 'Rejeté avec $percentage% Aye';
  }

  @override
  String proposalIsPassing(String percentage) {
    return 'En cours d\'adoption avec $percentage% Aye';
  }

  @override
  String proposalIsFailing(String percentage) {
    return 'En cours de rejet avec $percentage% Aye';
  }

  @override
  String proposalSetInactivityTimeoutTo(String value) {
    return 'Global : Définir le nouveau délai d\'inactivité sur $value';
  }

  @override
  String proposalAddLocation(String cid) {
    return '$cid : Ajouter un nouvel emplacement';
  }

  @override
  String proposalRemoveLocation(String cid) {
    return '$cid : Supprimer un emplacement';
  }

  @override
  String proposalUpdateNominalIncome(String value, String currency) {
    return 'Ajuster le revenu communautaire à $value $currency';
  }

  @override
  String proposalUpdateDemurrage(String value) {
    return 'Ajuster demurrage à $value%/mois';
  }

  @override
  String proposalPetition(String cid, String value) {
    return '$cid petition: $value';
  }

  @override
  String proposalSpendNative(String cid, String amount, String beneficiary) {
    return '$cid trèsor enverra $amount KSM à $beneficiary';
  }

  @override
  String proposalSpendAsset(
      String asset, String cid, String amount, String beneficiary) {
    return '$cid trèsor enverra $amount $asset à $beneficiary';
  }

  @override
  String proposalIssueSwapNativeOption(
      String cid, String beneficiary, String allowance, String rate) {
    return '$cid : Permet à $beneficiary d\'échanger jusqu\'à $allowance KSM à un taux de $rate $cid/KSM.';
  }

  @override
  String proposalIssueSwapOptionCCLimit(
      String asset, String cc, String allowance) {
    return 'Tu peux échanger jusqu’à $allowance $cc pour atteindre ta limite de $asset définie.';
  }

  @override
  String proposalIssueSwapAssetOption(String asset, String cid,
      String beneficiary, String allowance, String rate) {
    return '$cid : Permet à $beneficiary d\'échanger jusqu\'à $allowance $asset à un taux de $rate $cid/$asset.';
  }

  @override
  String proposalSupersededBy(String id) {
    return 'Epargné par: $id';
  }
}
