// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for English (`en`).
class AppLocalizationsEn extends AppLocalizations {
  AppLocalizationsEn([String locale = 'en']) : super(locale);

  @override
  String get about => 'About';

  @override
  String get aboutBrief => 'Mobile Wallet for Encointer';

  @override
  String get aboutVersion => 'Version';

  @override
  String get acceptancePoints => 'Acceptance Points';

  @override
  String get accountDelete => 'Are you sure you want to delete the account?';

  @override
  String get accountImport => 'Import account';

  @override
  String get accountName => 'Account name';

  @override
  String get accountNameChoose => 'Choose an account name.';

  @override
  String get accountNameChooseHint =>
      'You can change it later in your profile settings.';

  @override
  String get accounts => 'Accounts';

  @override
  String get accountsDelete => 'Are you sure you want to delete all accounts?';

  @override
  String get accountsDeleteAll => 'Remove all Accounts';

  @override
  String get accountShare => 'Share Account';

  @override
  String get addAccount => 'Add account';

  @override
  String get addBusiness => 'Add business';

  @override
  String get addContact => 'Add contact';

  @override
  String get addInvoiceQrToAddress => 'Add QR-invoice to Address';

  @override
  String get address => 'Address';

  @override
  String get addressBook => 'Address Book';

  @override
  String get addToContactFromQrContact => 'Add Contact-Qr';

  @override
  String get alreadyEndorsedErrorBody =>
      'This account has already been endorsed for this cycle.';

  @override
  String get alreadyEndorsedErrorTitle => 'Already Endorsed';

  @override
  String get authenticationNeeded => 'Authentication Needed';

  @override
  String get amountError => 'Invalid amount';

  @override
  String get amountToBeTransferred => 'Send amount';

  @override
  String get appSettings => 'App settings';

  @override
  String get attestNotificationBody =>
      'If all participants have sent the attestations, you can try to claim the income.';

  @override
  String get attestNotificationTitle => 'Attested attendees';

  @override
  String get available => 'Available';

  @override
  String get balance => 'Balance';

  @override
  String get balanceTooLowBody =>
      'You don\'t have sufficient funds in your account. You can\'t send all your money because you need some for the fees.';

  @override
  String get balanceTooLowTitle => 'Balance too low';

  @override
  String get balanceTransferNotificationBody =>
      'The recipient has received the tokens.';

  @override
  String get balanceTransferNotificationTitle => 'Transaction completed';

  @override
  String get benefits => 'Benefits';

  @override
  String get biometricAuth => 'Biometric authentication';

  @override
  String get biometricAuthDescription =>
      'Biometric authentication uses the biometric information stored on your phone to authenticate you, instead of using your pin. You can enable and disable biometric authentication anytime in the settings.';

  @override
  String get biometricAuthEnableDisableDescription =>
      'Enter your PIN to enable or disable biometric authentication.';

  @override
  String get block => 'Block';

  @override
  String get bootstrapperContent =>
      'If you have endorsement tickets left, please consider endorsing newbies to help the community grow.';

  @override
  String get bootstrapperTitle =>
      'Registered as bootstrapper - your seat is guaranteed.';

  @override
  String get calendarEntryDescription =>
      'Gathering to get your community income';

  @override
  String get cameraPermissionError =>
      'There was an error String getting the camera permission. Alternatively, you can grant permission in the app settings.';

  @override
  String get cancel => 'Cancel';

  @override
  String get canEndorseInRegisteringPhaseOnly =>
      'Can endorse in registering phase only';

  @override
  String get cantEndorseBootstrapper =>
      'Bootstrappers are already marked as trusted';

  @override
  String get categories => 'Categories';

  @override
  String get canUseFaucetOnlyWithCurrentAccount =>
      'You can only use the faucet features if this account page shows the currently active account.';

  @override
  String get changeYourPin => 'Change PIN';

  @override
  String get category_all => 'All';

  @override
  String get category_art_music => 'Art & Music';

  @override
  String get category_body_soul => 'Body & Soul';

  @override
  String get category_fashion_clothing => 'Fashion & Clothing';

  @override
  String get category_food_beverage_store => 'Food & Beverage Store';

  @override
  String get category_restaurants_bars => 'Restaurants & Bars';

  @override
  String get category_it_hardware => 'IT Hardware';

  @override
  String get category_food => 'Food';

  @override
  String get category_other => 'Other';

  @override
  String get emailFailedToOpen => 'Could not open email client.';

  @override
  String get chosenRightCommunity =>
      'The data is for a different community. Please change the community to send funds.';

  @override
  String get claim => 'Claim';

  @override
  String get claimRewardsNotificationBody =>
      'You have already received your community income!';

  @override
  String get claimRewardsNotificationTitle => 'Claimed the community income';

  @override
  String get claimsScannedAlready => 'Updated previously scanned claim';

  @override
  String get claimsScannedDecodeFailed =>
      'Could not decode scanned claim. The other party needs to update the App.';

  @override
  String get claimsScannedNew => 'Scanned new claim';

  @override
  String get claimsSubmit => 'Submit claims';

  @override
  String get closeGathering => 'Close gathering';

  @override
  String get communities => 'Communities';

  @override
  String get communityChoose => 'Choose community:';

  @override
  String get communityDoChoose => 'Choose community';

  @override
  String get communityNotSelected =>
      'No community selected, hit the icon to select one';

  @override
  String get confirmPin => 'Input your PIN to confirm';

  @override
  String get confirmThePayment => '3. Confirm the payment';

  @override
  String get contactAddress => 'Address';

  @override
  String get contactAddressError => 'Invalid address';

  @override
  String get contactAlreadyExists => 'Address exists already';

  @override
  String get contactDelete => 'Delete';

  @override
  String get contactDeleteWarn =>
      'Are you sure you want to delete this address?';

  @override
  String get contactEndorse => 'Endorse as trusted contact';

  @override
  String get contactMemo => 'Contact information';

  @override
  String get contactName => 'Name';

  @override
  String get contactNameAlreadyExists => 'Name exists already';

  @override
  String get contactNameError => 'Name can not be empty';

  @override
  String get contactSave => 'Save';

  @override
  String get contactUs => 'Contact Us';

  @override
  String get copy => 'Copy';

  @override
  String get count => 'Count';

  @override
  String get create => 'Create Account';

  @override
  String get createError => 'There was an error creating your account';

  @override
  String get createHint => '(Example: Alice)';

  @override
  String get createPassword => 'PIN';

  @override
  String get createPassword2 => 'Confirm PIN';

  @override
  String get createPassword2Error => 'Inconsistent PINs';

  @override
  String get createPasswordError =>
      'PIN must contain at least 4 digits and no other signs';

  @override
  String get deleteAccount => 'delete';

  @override
  String get democracy => 'Democracy';

  @override
  String get democracyFaq => 'How does democracy work?';

  @override
  String get democracyDiscussion => 'Discuss proposals in the Forum!';

  @override
  String get democracyVotedNotificationBody =>
      'You have voted for this proposal.';

  @override
  String get democracyVotedNotificationTitle => 'Voted';

  @override
  String get democracyUpdatedProposalStateNotificationBody =>
      'You have updated this proposal';

  @override
  String get democracyUpdatedProposalStateNotificationTitle =>
      'Proposal Updated';

  @override
  String get democracySubmitProposalNotificationBody =>
      'You made a proposal, which people can vote on now.';

  @override
  String get democracySubmitProposalNotificationTitle => 'Proposal submitted';

  @override
  String get detail => 'Detail';

  @override
  String get detailsEnter => 'Enter your details.';

  @override
  String get developer => 'Developer mode';

  @override
  String get done => 'done';

  @override
  String get doYouAlreadyHaveAnAccount => 'Do you already have an account?';

  @override
  String get enable => 'Enable';

  @override
  String get endorseeContent =>
      'You have been endorsed as a trustworthy community member. Hence, you are guaranteed to be assigned to a gathering this cycle.';

  @override
  String get endorseeTitle =>
      'Registered as endorsee - your seat is guaranteed';

  @override
  String get endorseNewcomerNotificationBody =>
      'Thanks for endorsing the newbie!';

  @override
  String get endorseNewcomerNotificationTitle => 'Newbie endorsed';

  @override
  String get enterAmount => 'Enter amount';

  @override
  String get error => 'Error';

  @override
  String get errorMessageNoCommunity => 'Please choose a community.';

  @override
  String get errorOccurred => 'An error occurred:';

  @override
  String get errorUserNameIsRequired => 'User name cannot be blank';

  @override
  String get event => 'Event ID';

  @override
  String get swapOption => 'Swap Option';

  @override
  String swapOptionRate(String amount, String asset, String cc) {
    return 'Rate $amount $cc/$asset';
  }

  @override
  String swapOptionCcLimit(String amount, String cc) {
    return '$cc Limit: $amount $cc';
  }

  @override
  String swapOptionAssetToReceive(String amount, String asset) {
    return 'You receive: $amount $asset';
  }

  @override
  String swapOptionLimit(String amount, String asset) {
    return 'Limit: $amount $asset';
  }

  @override
  String exerciseSwapAssetOptionAvailable(String asset) {
    return 'Swap Option Available';
  }

  @override
  String get exerciseSwapNativeOptionAvailable => 'KSM Swap Option Available';

  @override
  String get exerciseSwapOption => 'Exercise Swap Option';

  @override
  String get export => 'Export Account';

  @override
  String get exportAccount => 'export';

  @override
  String get exportMnemonicOk => 'Mnemonic was copied to clipboard.';

  @override
  String get exportWarn =>
      'Write these words down on paper. Keep the backup paper safe. These words allows anyone to recover this account and access its funds.';

  @override
  String get fail => 'Failed';

  @override
  String get fee => 'Fee';

  @override
  String get finish => 'Finish';

  @override
  String get from => 'From';

  @override
  String get fundsReceived => 'funds received';

  @override
  String get fundVoucher => 'Fund voucher';

  @override
  String get gatheringSuccessfullyCompleted =>
      'Gathering successfully completed';

  @override
  String get hash => 'transaction hash';

  @override
  String get hintEnterCurrentPin =>
      'To change your PIN please enter the current one.';

  @override
  String get hintThenEnterANewPin =>
      'Then you can choose a new one and you’re all set.';

  @override
  String get home => 'Home';

  @override
  String get howManyParticipantsShowedUp =>
      'How many attendees are present including yourself?';

  @override
  String get import => 'Import';

  @override
  String get importDuplicate =>
      'Account exists, do you want to override the existing account?';

  @override
  String get importedWithRawSeedHenceNoMnemonic =>
      'Account was imported with a raw seed and therefore does not have a mnemonic';

  @override
  String get importInvalidMnemonic => 'Invalid mnemonic supplied';

  @override
  String get importInvalidRawSeed => 'Invalid raw seed supplied';

  @override
  String get importMustNotBeEmpty => 'Input must not be empty';

  @override
  String get importPrivateKeyUnsupported =>
      'Private key account import is not yet supported.';

  @override
  String get incomeIssuance => 'Community income';

  @override
  String get insufficientBalance => 'Insufficient balance';

  @override
  String get insufficientFundsErrorBody =>
      'You do not have sufficient funds on this account. See on the website of your local community how to get some.';

  @override
  String get insufficientFundsErrorTitle => 'Insufficient Funds';

  @override
  String get invalidTransactionFormatErrorBody =>
      'The transaction had an invalid format, which might be a bug. If you think this is a bug, please tap the corresponding field below.';

  @override
  String get invalidTransactionFormatErrorTitle => 'Invalid Transaction Format';

  @override
  String get invalidCommunity => 'Invalid Community';

  @override
  String get invalidNetwork => 'Invalid Network';

  @override
  String get invoice => 'Invoice';

  @override
  String get issuanceClaimed => 'No pending community income';

  @override
  String get issuancePending => 'Claim pending community income';

  @override
  String get keySigningCycle => 'Key-Signing Cycle';

  @override
  String get keystore => 'Keystore (json)';

  @override
  String get kusamaFaucet => 'Kusama Faucet';

  @override
  String get lang => 'Language';

  @override
  String get leuZurichFAQ => 'leu.zuerich FAQ';

  @override
  String get like => 'Like';

  @override
  String get loading => 'Loading...';

  @override
  String get meetingPoint => 'Meeting Point';

  @override
  String get meetupClaimantEqualToSelf =>
      'Error: Claimant is equal to self. Claim is not stored.';

  @override
  String get meetupClaimantInvalid =>
      'This claimant is not part of the gathering. Claim is not stored.';

  @override
  String get meetupLocation => 'Gathering location';

  @override
  String meetupIndex(Object index) {
    return 'Gathering Number: $index';
  }

  @override
  String get meetupIndexPopupExplanation =>
      'Use the gathering number to find your real gathering location. The community leader is responsible in your community for specifying the gathering locations. The real location could be slightly different from the one displayed here.';

  @override
  String get meetupNotificationOneDayBeforeContent =>
      'Gathering starts in 24 hours';

  @override
  String get meetupNotificationOneDayBeforeTitle => '24 hours left';

  @override
  String get meetupNotificationOneHourBeforeContent =>
      'Gathering starts in one hour';

  @override
  String get meetupNotificationOneHourBeforeTitle => '1 hour left';

  @override
  String get mnemonic => 'Mnemonic';

  @override
  String get newbieContent =>
      'With your current status the participation for the upcoming cycle is not guaranteed. Please ask your contacts for an Endorsement.';

  @override
  String get newbieTitle => 'Tentative Participation';

  @override
  String get next => 'Next';

  @override
  String get nextCycleDateLabel => 'Next cycle is on';

  @override
  String get nextCycleTimeLeft => 'Next cycle is in';

  @override
  String get noCommunitiesAreYouOffline =>
      'No communities were found. You can choose one later. Are you offline?.';

  @override
  String get noInvoice => 'No invoice';

  @override
  String get noItems => 'No items found';

  @override
  String get noMnemonicFound => 'No Mnemonic found';

  @override
  String get notNow => 'Not now';

  @override
  String get notifySubmittedQueued => 'Queued transaction Submitted';

  @override
  String get noTransactions => 'No Transactions';

  @override
  String get noValidClaimsErrorBody =>
      'You did not send any valid claims. Did you scan the other attendees?';

  @override
  String get noValidClaimsErrorTitle => 'No Valid Claims';

  @override
  String get numberOfAttendees => 'Number of attendees';

  @override
  String get observe => 'Observation';

  @override
  String get observeBrief =>
      'Mark this address as observation, then you can select this address in account select page, to watch its assets and actions';

  @override
  String get observedPendingExtrinsic =>
      'Pending transaction observed. Please wait for confirmation!';

  @override
  String get offlineMessage =>
      'You are currently offline. Your claims can be submitted later on the Home Screen.';

  @override
  String get ok => 'OK';

  @override
  String get onlyReputablesCanEndorseAttendGatheringToBecomeOne =>
      'Only reputables can endorse. Attend a gathering to get reputation!';

  @override
  String get openMapApplication => 'Open Map Application';

  @override
  String get openTheEncointerApp => '1. Open the app \n«Encointer Wallet»';

  @override
  String get passOld => 'Current PIN';

  @override
  String get passSuccess => 'Success';

  @override
  String get passSuccessTxt => 'PIN changed successfully';

  @override
  String get payHereWithLeu => 'Pay here with Leu';

  @override
  String get payment => 'Payment';

  @override
  String get paymentDoYouWantToProceed => 'Proceed with payment?';

  @override
  String get paymentError => 'Payment error';

  @override
  String get paymentFinished => 'Payment complete';

  @override
  String get paymentSubmitting => 'Payment is being submitted...';

  @override
  String get personalKey => 'Personal key';

  @override
  String get personalKeyEnter =>
      'Please enter your personal key (12 words) to import the new account.';

  @override
  String get pinHint =>
      'You will need this PIN for transactions and adding a new account.';

  @override
  String get pinInfo =>
      'PIN should consist of at least 4 digits. If the PIN is lost, there is no option to restore the account unless you made a backup via the profile page.';

  @override
  String get pinSecure => 'Secure your account with a PIN.';

  @override
  String get pleaseCommunityChoose => 'Please choose a community';

  @override
  String get pleaseConfirmYourNewPin => 'Confirm New PIN';

  @override
  String get preview => 'Preview';

  @override
  String get print => 'Print';

  @override
  String get proposal => 'Proposal';

  @override
  String get proposalAye => 'Aye';

  @override
  String get proposalNay => 'Nay';

  @override
  String get proposalNew => 'New Proposal';

  @override
  String get proposalExplainerAddLocation =>
      'This proposal suggests a new gathering location for your community. Make sure it’s at least 100m away and no more than 1km from existing locations.';

  @override
  String get proposalExplainerRemoveLocation =>
      'This proposal suggests to remove an existing gathering location for your community.';

  @override
  String get proposalExplainerUpdateDemurrage =>
      'This proposal suggest a new monthly demurrage for your community token.';

  @override
  String get proposalExplainerUpdateNominalIncome =>
      'This proposal suggests a new nominal income in the gathering cycles for your community.';

  @override
  String get proposalExplainerSetInactivityTimeout =>
      'This proposal suggests a new global inactivity timeout. If a community has not been performing gatherings for the suggested number of gathering cycles, the community will be deleted.';

  @override
  String get proposalExplainerPetition =>
      'This proposal serves as a petition, either globally or within your community. While it has no direct on-chain effect, it signals intent, allowing the community to recognize and act upon it.';

  @override
  String get proposalExplainerSpendNative =>
      'This proposal suggests spending KSM for a beneficiary from the community treasury, either through a global or community vote. These funds can reward community contributions or support community initiatives.';

  @override
  String proposalExplainerSpendAsset(String asset) {
    return 'This proposal suggests spending $asset for a beneficiary from the community treasury, either through a global or community vote. These funds can reward community contributions or support community initiatives.\n\nNote: You will receive the $asset on Asset Hub Kusama directly.';
  }

  @override
  String proposalExplainerIssueSwapOption(String cc, String asset) {
    return 'This proposal allows the beneficiary to exchange $cc for $asset at a fixed rate, multiple times, until a defined $asset limit is reached. The beneficiary is typically a local business that accepts $cc and may accumulate a surplus.';
  }

  @override
  String get proposalExplainerSwapOptionComputation =>
      'Calculation with your input';

  @override
  String get proposalExplainerRate => 'Rate';

  @override
  String get proposalExplainerSwapFee => 'Swap Fee';

  @override
  String get proposalExplainerBeneficiaryWillGet => 'Beneficiary will get';

  @override
  String proposalExplainerPaymentWillBeOnAH(String asset) {
    return 'Note: The $asset will be sent directly to your Asset Hub Kusama account.';
  }

  @override
  String get proposalExplainerCannotVoteYet =>
      'You can start voting with your reputation as of the next cycle!';

  @override
  String get proposalType => 'Proposal Type';

  @override
  String get proposalTypeAddLocation => 'Add location';

  @override
  String get proposalTypeRemoveLocation => 'Remove location';

  @override
  String get proposalTypeUpdateDemurrage => 'Update Demurrage';

  @override
  String get proposalTypeUpdateNominalIncome => 'Update Nominal Income';

  @override
  String get proposalTypeSetInactivityTimeout => 'Set Inactivity Timeout';

  @override
  String get proposalTypePetition => 'Petition';

  @override
  String get proposalTypeSpendNative => 'Spend KSM';

  @override
  String proposalTypeIssueSwapNativeOption(String cc) {
    return 'Swap $cc for KSM';
  }

  @override
  String proposalTypeSpendAsset(String asset) {
    return 'Spend $asset';
  }

  @override
  String proposalTypeIssueSwapAssetOption(String cc, String asset) {
    return 'Swap $cc for $asset';
  }

  @override
  String get proposalScope => 'Scope';

  @override
  String proposalScopeLocal(String community) {
    return 'Local ($community)';
  }

  @override
  String get proposalScopeGlobal => 'Global';

  @override
  String get proposalFieldLatitude => 'Latitude';

  @override
  String get proposalFieldLongitude => 'Longitude';

  @override
  String get proposalFieldDemurragePerMonth => 'Demurrage (% / month)';

  @override
  String get proposalFieldNominalIncome => 'Nominal Income';

  @override
  String get proposalFieldInactivityTimeoutCycles =>
      'Inactivity Timeout (gathering cycles)';

  @override
  String get proposalFieldPetitionText => 'Petition Text';

  @override
  String get proposalFieldAssetToSpend => 'Asset to spend';

  @override
  String proposalFieldAssetToSwap(String cc) {
    return 'Asset to receive for $cc';
  }

  @override
  String proposalFieldAmount(String asset) {
    return 'Amount ($asset)';
  }

  @override
  String get proposalFieldBeneficiary => 'Beneficiary';

  @override
  String proposalFieldAllowance(String asset) {
    return 'Limit ($asset)';
  }

  @override
  String proposalFieldRate(String asset, String cc) {
    return 'Rate ($cc/$asset)';
  }

  @override
  String get proposalFieldBurn => 'Burn';

  @override
  String get proposalFieldValidity => 'Validity';

  @override
  String get proposalFieldErrorEnterPetitionText => 'Enter Petition Text';

  @override
  String get proposalFieldErrorPetitionTextTooLong =>
      'Petition Text is too long';

  @override
  String get proposalFieldErrorEnterLatitude => 'Enter Latitude';

  @override
  String get proposalFieldErrorLatitudeRange =>
      'Latitude must be between -90 and 90';

  @override
  String get proposalFieldErrorEnterLongitude => 'Enter Longitude';

  @override
  String get proposalFieldErrorLongitudeRange =>
      'Longitude must be between -180 and 180';

  @override
  String get proposalFieldErrorEnterDemurrage => 'Enter Demurrage';

  @override
  String get proposalFieldErrorDemurrageRange =>
      'Demurrage must be between 0 and 100';

  @override
  String get proposalFieldErrorEnterPositiveNumber => 'Enter positive number';

  @override
  String get proposalFieldErrorPositiveNumberRange =>
      'Must be a positive number';

  @override
  String proposalFieldErrorPositiveNumberTooBig(String amount) {
    return 'Number is too big (Limit: $amount)';
  }

  @override
  String get proposalFieldErrorEnterInactivityTimeout =>
      'Enter inactivity timeout';

  @override
  String get proposalFieldErrorPositiveIntegerRange =>
      'Must be a positive integer';

  @override
  String get proposalOnlyBootstrappersOrReputablesCanSubmit =>
      'Only bootstrappers or reputables can submit a proposal.';

  @override
  String get proposalOnlyBusinessOwnersCanSubmit =>
      'Only business owners can submit this proposal.';

  @override
  String get proposalCannotSubmitProposalTypePendingEnactment =>
      'Cannot submit a proposal of this type, as there is already one pending enactment.';

  @override
  String get proposalClose => 'Close';

  @override
  String get proposalUpdateState => 'Update';

  @override
  String get proposalUpdateExplanation =>
      'This will update the proposal state. If it is too old and does not have enough Aye votes, it will be rejected. If it has been confirming long enough, it will pass.';

  @override
  String get proposalSubmit => 'Submit Proposal';

  @override
  String get proposalSuperseded => 'Superseded';

  @override
  String get proposalRejected => 'Rejected';

  @override
  String get proposalEnacted => 'Enacted';

  @override
  String get proposalApproved => 'Approved';

  @override
  String get proposalTurnout => 'Turnout';

  @override
  String get proposalHowVote => 'How do you vote?';

  @override
  String get proposalsEmpty => 'No proposals';

  @override
  String get proposalsUpForVote => 'Proposals up for vote';

  @override
  String get proposalsPast => 'Past Proposals';

  @override
  String get proposalVote => 'Vote';

  @override
  String get proposalVoted => 'Voted';

  @override
  String get proposalOngoingUntil => 'Ongoing until';

  @override
  String get proposalConfirmingUntil => 'Confirming until';

  @override
  String get proposalPendingEnactmentAt => 'Pending enactment at';

  @override
  String get proposalFailedAndNeedsBump =>
      'The proposal has failed and can be closed.';

  @override
  String get proposalPassedAndNeedsBump =>
      'The proposal has passed and can be closed.';

  @override
  String get qrScan => 'Scan QR code';

  @override
  String get qrScanHintAccount =>
      'Ask the recipient to scan the QR-code in the encointer app.';

  @override
  String get rawSeed => 'Raw Seed';

  @override
  String get receive => 'Receive';

  @override
  String get received => 'Received';

  @override
  String get receiverAccount => 'Receiving account:';

  @override
  String get redeemFailure =>
      'There was an error while redeeming the voucher. Cause:';

  @override
  String get redeemSuccess => 'Successfully redeemed voucher.';

  @override
  String get redeemVoucher => 'Redeem voucher';

  @override
  String get registeringPhaseReminderContent =>
      'Registration for the next gathering has started.';

  @override
  String get registeringPhaseReminderTitle => 'Register now!';

  @override
  String get registerParticipantNotificationBody =>
      'You will receive a reminder one day before.';

  @override
  String get registerParticipantNotificationTitle =>
      'Registered for the next cycle!';

  @override
  String get registerUntil => 'Register before';

  @override
  String get remainingNewbieTicketsAsBootStrapper =>
      'Remaining newbie tickets as bootsrapper:';

  @override
  String get remainingNewbieTicketsAsReputable =>
      'Remaining newbie tickets as reputable:';

  @override
  String get remarkNotificationBody => 'You have submitted a note.';

  @override
  String get remarkNotificationTitle => 'note submitted';

  @override
  String get remarks => 'Onchain Remarks';

  @override
  String get remarksButton => 'submit public note';

  @override
  String get remarksExplain =>
      'You can submit a note to the network. This note will be public and immutable. It can be read and authenticated by everyone as it will be digitally signed by you.';

  @override
  String get remarksNote => 'Note';

  @override
  String get remarksSubmit => 'Submit note';

  @override
  String get reputableContent =>
      'You used your reputation to get a guaranteed seat. Caution: Should you register, but not show up at the cycle, you become a newbie again.';

  @override
  String get reputableTitle =>
      'Registered as reputable - your seat is guaranteed';

  @override
  String get reputationAlreadyCommittedTitle => 'Reputation already used';

  @override
  String get reputationAlreadyCommittedContent =>
      'You have already used your reputation to drip the faucet.';

  @override
  String get reputationOverall => 'Overall reputation';

  @override
  String get restartGathering => 'Restart gathering';

  @override
  String get retry => 'Retry';

  @override
  String get rewardsAlreadyIssuedErrorBody =>
      'Another attendee has triggered the payout for this gathering. You should have received your income already.';

  @override
  String get rewardsAlreadyIssuedErrorTitle => 'Rewards already issued';

  @override
  String get scan => 'Scan';

  @override
  String get scanDescriptionForMeetup =>
      'Every attendee must scan and be scanned by everyone else.';

  @override
  String get scanOthers => 'Scan others';

  @override
  String get scanQrCodeOnTheLeft => '2. Scan the QR code \non the left';

  @override
  String get sendLink => 'Send link';

  @override
  String get sent => 'Sent';

  @override
  String get setting => 'Settings';

  @override
  String get settingLang => 'Language';

  @override
  String get settingLangAuto => 'Auto Detect';

  @override
  String get settingNetwork => 'Select Wallet';

  @override
  String get settingNode => 'Remote Node';

  @override
  String get settingNodeList => 'Available Nodes';

  @override
  String get settingPrefix => 'Address Prefix';

  @override
  String get settingPrefixList => 'Available Prefixes';

  @override
  String get share => 'Share';

  @override
  String get shareInvoice => 'Share Invoice';

  @override
  String get shareLinkHint => 'Or you can share a link:';

  @override
  String get showRouteMeetupLocation => 'Show route';

  @override
  String get startGathering => 'Start gathering';

  @override
  String get submittedFaucetDripTitle => 'Faucet rewards';

  @override
  String get submittedFaucetDripBody =>
      'You have successfully claimed your faucet rewards.';

  @override
  String get success => 'Success';

  @override
  String get switchAccount => 'Switch Account';

  @override
  String get switchCommunity => 'Switch Community';

  @override
  String get thankYou => 'Thank you';

  @override
  String get title => 'Profile';

  @override
  String get to => 'To';

  @override
  String get today => 'Today';

  @override
  String get tomorrow => 'Tomorrow';

  @override
  String get transactionError => 'Transaction error';

  @override
  String get transactionQueuedOffline =>
      'App is not connected to the blockchain. Queued transaction (will be sent automatically upon reconnection).';

  @override
  String get transfer => 'Send';

  @override
  String get transferHistory => 'Transfers';

  @override
  String get transferHistoryEnd =>
      'Loading older transactions is not yet supported';

  @override
  String get transferHistoryTop =>
      'It may take up to 30 seconds for a transfer to appear here';

  @override
  String treasuryBalanceTooLow(String balance, String cc) {
    return 'Treasury Balance too low. Limit: $balance $cc';
  }

  @override
  String treasuryGlobalBalance(String balance) {
    return 'Free global treasury balance: $balance KSM.';
  }

  @override
  String treasuryLocalBalance(String balance) {
    return 'Free community treasury balance: $balance KSM.';
  }

  @override
  String treasuryLocalBalanceOnAHK(String balance, String asset) {
    return 'Free community treasury balance on Asset Hub: $balance $asset.';
  }

  @override
  String treasuryPendingSpends(String spends) {
    return 'Pending spends: $spends KSM.';
  }

  @override
  String get txBroadcast => 'Transaction has been broadcast.';

  @override
  String get txError => 'Transaction error';

  @override
  String get txInBlock => 'Transaction is in a block.';

  @override
  String get txQueued => 'Queued Transaction';

  @override
  String get txQueuedOffline =>
      'You are offline. Transaction will be sent when you are back online.';

  @override
  String get txReady => 'Transaction is ready.';

  @override
  String get txTooLowPriorityErrorBody =>
      'Technical transaction priority error. This can happen if you tap twice on a submit button very quickly. Please wait for a few seconds.';

  @override
  String get txTooLowPriorityErrorTitle => 'Transaction priority error';

  @override
  String get unknown => 'Unknown';

  @override
  String get unknownAccount => 'Unknown account';

  @override
  String get unknownError =>
      'An error occurred. Please check your internet connection and try again.';

  @override
  String get unregister => 'Unregister';

  @override
  String get unregisterDialogTitle => 'Unregister from the next cycle?';

  @override
  String get unregisterParticipantNotificationBody =>
      'Your registration for the next cycle has been cancelled. If you change your mind, you can register again.';

  @override
  String get unregisterParticipantNotificationTitle => 'Registration cancelled';

  @override
  String get updatingAppState => 'Updating the app state...';

  @override
  String get value => 'Value';

  @override
  String get votesNotDependableErrorBody =>
      'Only half or less of the assigned participants were attested for this gathering. It could also be that some attendees haven\'t submitted their attestation yet. This prevents the early payout, and you need to wait for 48 hours.';

  @override
  String get votesNotDependableErrorTitle => 'Votes not dependable';

  @override
  String get voucher => 'Voucher';

  @override
  String get voucherBalance => 'Voucher Balance';

  @override
  String get voucherBalanceTooLow =>
      'The voucher has insufficient funds to be redeemed.';

  @override
  String get weHopeToSeeYouAtTheNextGathering =>
      'We hope to see you at the next gathering.';

  @override
  String get wrongPin => 'Wrong PIN';

  @override
  String get wrongPinHint => 'Failed to unlock account, please check PIN.';

  @override
  String get youAreNotRegisteredPleaseRegisterNextTime =>
      'You haven\'t been assigned for this key-signing cycle. Please join the next cycle to receive your community income.';

  @override
  String get yourNewPin => 'New PIN';

  @override
  String unlockAccount(String currentAccountName) {
    return 'Unlock account $currentAccountName with PIN';
  }

  @override
  String errorMessageWithStatusCode(String errorText) {
    return 'Something went wrong, please try again! StatusCode: $errorText';
  }

  @override
  String yourBalanceFor(String accountName) {
    return 'Your balance, $accountName';
  }

  @override
  String incomingConfirmed(num amount, String cidSymbol, String accountName) {
    return 'incoming $amount $cidSymbol for $accountName confirmed';
  }

  @override
  String voucherDifferentNetworkAndCommunity(String network, String community) {
    return 'The voucher is for a different network. Do you want to change to $network and $community? You can change the network back under Profile > Developer mode';
  }

  @override
  String voucherDifferentCommunity(String community) {
    return 'The voucher is for a different community. Do you want to change to $community?';
  }

  @override
  String doYouWantToRedeemThisVoucher(String accountName) {
    return 'Do you want to redeem this voucher to $accountName?';
  }

  @override
  String claimsSubmitN(int count) {
    return 'Submit $count claims';
  }

  @override
  String claimsScanned(num amount) {
    return 'You have scanned $amount claims';
  }

  @override
  String claimsScannedNOfM(int scannedCount, int totalCount) {
    return 'Scanned $scannedCount / $totalCount Claims';
  }

  @override
  String claimsSubmitDetail(num amount) {
    return 'Submitting $amount claims for the recent gathering';
  }

  @override
  String youAreRegisteredAs(String participantType) {
    return 'You have registered for the next gathering as $participantType.';
  }

  @override
  String youAreAssignedToAGatheringWithNParticipants(int participantsCount) {
    return 'You are assigned to a gathering with $participantsCount people.';
  }

  @override
  String successfullySentNAttestations(int participantsCount) {
    return 'You have successfully submitted attestations for $participantsCount other people.';
  }

  @override
  String tokenSend(String symbol) {
    return 'Send $symbol';
  }

  @override
  String communityWithName(String name) {
    return '$name Community';
  }

  @override
  String verifyAuthTitle(String useBioAuth) {
    String _temp0 = intl.Intl.selectLogic(
      useBioAuth,
      {
        'true': 'your identity',
        'false': 'your PIN',
        'other': ' ',
      },
    );
    return 'Please verify $_temp0.';
  }

  @override
  String offersForCommunity(String value) {
    return 'Offers for $value';
  }

  @override
  String proposalApprovalThreshold(String percentage) {
    return 'Approval Threshold: $percentage%';
  }

  @override
  String proposalPassed(String percentage) {
    return 'Passed with $percentage% Aye';
  }

  @override
  String proposalFailed(String percentage) {
    return 'Failed with $percentage% Aye';
  }

  @override
  String proposalIsPassing(String percentage) {
    return 'Currently passing with $percentage% Aye';
  }

  @override
  String proposalIsFailing(String percentage) {
    return 'Currently failing with $percentage% Aye';
  }

  @override
  String proposalSetInactivityTimeoutTo(String value) {
    return 'Global: Set the new inactivity timeout to $value';
  }

  @override
  String proposalAddLocation(String cid) {
    return '$cid: Add a new location';
  }

  @override
  String proposalRemoveLocation(String cid) {
    return '$cid Remove a location';
  }

  @override
  String proposalUpdateNominalIncome(String value, String currency) {
    return 'Update community income to $value $currency';
  }

  @override
  String proposalUpdateDemurrage(String value) {
    return 'Update demurrage to $value%/month';
  }

  @override
  String proposalPetition(String cid, String value) {
    return '$cid petition: $value';
  }

  @override
  String proposalSpendNative(String cid, String amount, String beneficiary) {
    return '$cid treasury shall spend $amount KSM to $beneficiary';
  }

  @override
  String proposalSpendAsset(
      String asset, String cid, String amount, String beneficiary) {
    return '$cid treasury shall spend $amount $asset to $beneficiary';
  }

  @override
  String proposalIssueSwapNativeOption(
      String cid, String beneficiary, String allowance, String rate) {
    return '$cid: Let $beneficiary exchange up to $allowance KSM at a rate of $rate $cid/KSM';
  }

  @override
  String proposalIssueSwapOptionCCLimit(
      String asset, String cc, String allowance) {
    return 'You can exchange up to $allowance $cc to reach your defined $asset limit.';
  }

  @override
  String proposalIssueSwapAssetOption(String asset, String cid,
      String beneficiary, String allowance, String rate) {
    return '$cid: Let $beneficiary exchange up to $allowance $asset at a rate of $rate $cid/$asset';
  }

  @override
  String proposalSupersededBy(String id) {
    return 'Superseded by: $id';
  }
}
