// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for German (`de`).
class AppLocalizationsDe extends AppLocalizations {
  AppLocalizationsDe([String locale = 'de']) : super(locale);

  @override
  String get about => 'Über';

  @override
  String get aboutBrief => 'Mobiles Wallet für Encointer';

  @override
  String get aboutVersion => 'Version';

  @override
  String get acceptancePoints => 'Akzeptanzstellen';

  @override
  String get accountDelete =>
      'Bist du sicher, dass du das Konto löschen möchtest?';

  @override
  String get accountImport => 'Konto importieren';

  @override
  String get accountName => 'Kontoname';

  @override
  String get accountNameChoose => 'Wähle einen Kontonamen.';

  @override
  String get accountNameChooseHint =>
      'Du kannst den Namen später ändern in den Profileinstellungen.';

  @override
  String get accounts => 'Konten';

  @override
  String get accountsDelete =>
      'Bist du sicher, dass du alle Konten löschen möchtest?';

  @override
  String get accountsDeleteAll => 'Lösche alle Konten';

  @override
  String get accountShare => 'Konto teilen';

  @override
  String get addAccount => 'Konto hinzufügen';

  @override
  String get addBusiness => 'Geschäft hinzufügen';

  @override
  String get addContact => 'Kontakt hinzufügen';

  @override
  String get addInvoiceQrToAddress => 'QR-Rechnung zu Adresse hinzufügen';

  @override
  String get address => 'Adresse';

  @override
  String get addressBook => 'Adressbuch';

  @override
  String get addToContactFromQrContact => 'Kontakt per Qr hinzufügen';

  @override
  String get alreadyEndorsedErrorBody =>
      'Dieses Konto wurde bereits für diesen Key-Signing Cycle endorsed.';

  @override
  String get alreadyEndorsedErrorTitle => 'Bereits endorsed';

  @override
  String get authenticationNeeded => 'Authentifizierung notwendig';

  @override
  String get amountError => 'Ungültiger Betrag';

  @override
  String get amountToBeTransferred => 'Betrag';

  @override
  String get appSettings => 'App-Einstellungen';

  @override
  String get attestNotificationBody =>
      'Wenn alle Teilnehmer die Attestierungen geschickt haben, kannst du versuchen das Einkommen zu erhalten.';

  @override
  String get attestNotificationTitle => 'Teilnehmer attestiert';

  @override
  String get available => 'Verfügbar';

  @override
  String get balance => 'Kontostand';

  @override
  String get balanceTooLowBody =>
      'Du hast nicht genug Geld auf dem Konto. Du kannst nicht dein ganzes Geld schicken, weil du noch ein wenig für die Gebühren brauchst.';

  @override
  String get balanceTooLowTitle => 'Kontostand zu tief';

  @override
  String get balanceTransferNotificationBody =>
      'Der Empfänger hat die Tokens erhalten.';

  @override
  String get balanceTransferNotificationTitle => 'Transaktion abgeschlossen';

  @override
  String get benefits => 'Vorteile';

  @override
  String get biometricAuth => 'Biometrische Authentifizierung';

  @override
  String get biometricAuthDescription =>
      'Die biometrische Authentifizierung verwendet die auf deinem Telefon gespeicherten biometrischen Informationen, um dich zu authentifizieren, anstatt deinen PIN zu verwenden. Du kannst die biometrische Authentifizierung jederzeit in den Einstellungen aktivieren und deaktivieren.';

  @override
  String get biometricAuthEnableDisableDescription =>
      'Gib deinen PIN ein, um die biometrische Authentifizierung zu aktivieren oder zu deaktivieren.';

  @override
  String get block => 'Block';

  @override
  String get bootstrapperContent =>
      'Wenn Du noch Endorsement-Tickets übrig hast, vergiss nicht Newbies zu als vertrauenswürdig zu bestätigen.';

  @override
  String get bootstrapperTitle =>
      'Als Bootstrapper registriert - Dein Platz ist garantiert.';

  @override
  String get calendarEntryDescription =>
      'Nimm an der Versammlung teil um dein Einkommen zu erhalten';

  @override
  String get cameraPermissionError =>
      'Es gab einen Fehler beim Überprüfen der Kameraerlaubnis. Du kannst die Erlaubnis für die Kamera auch über die App-Einstellungen erteilen.';

  @override
  String get cancel => 'Abbruch';

  @override
  String get canEndorseInRegisteringPhaseOnly =>
      'Du kannst nur in der Registrierungsphase jemanden als zuverlässig markieren';

  @override
  String get cantEndorseBootstrapper =>
      'Bootstrapper sind bereits als zuverlässig markiert';

  @override
  String get categories => 'Kategorien';

  @override
  String get canUseFaucetOnlyWithCurrentAccount =>
      'Du kannst das Faucet nur benutzen, wenn das angezeigte Konto das zurzeit gewählte Konto ist.';

  @override
  String get changeYourPin => 'PIN ändern';

  @override
  String get category_all => 'Alle';

  @override
  String get category_art_music => 'Kunst & Musik';

  @override
  String get category_body_soul => 'Körper & Seele';

  @override
  String get category_fashion_clothing => 'Mode & Kleidung';

  @override
  String get category_food_beverage_store => 'Lebensmittel- & Getränkemarkt';

  @override
  String get category_restaurants_bars => 'Restaurants & Bars';

  @override
  String get category_it_hardware => 'IT-Hardware';

  @override
  String get category_food => 'Essen';

  @override
  String get category_other => 'Andere';

  @override
  String get emailFailedToOpen => 'E-Mail-App konnte nicht geöffnet werden.';

  @override
  String get chosenRightCommunity =>
      'Die Daten sind für eine andere Gemeinschaft. Bitte wechsle die Gemeinschaft um Geld zu senden.';

  @override
  String get claim => 'Einfordern';

  @override
  String get claimRewardsNotificationBody =>
      'Du hast dein Gemeinschaftseinkommen bereits erhalten.';

  @override
  String get claimRewardsNotificationTitle =>
      'Gemeinschaftseinkommen angefordert';

  @override
  String get claimsScannedAlready =>
      'bereits gescannter Antrag wurde aktualisiert';

  @override
  String get claimsScannedDecodeFailed =>
      'Gescannter Antrag konnte nicht dekodiert werden. Dein Gegenüber muss die App updaten.';

  @override
  String get claimsScannedNew => 'Neuer Antrag gescannt';

  @override
  String get claimsSubmit => 'Anträge einreichen';

  @override
  String get closeGathering => 'Versammlung schliessen';

  @override
  String get communities => 'Gemeinschaften';

  @override
  String get communityChoose => 'Wähle eine Gemeinschaft:';

  @override
  String get communityDoChoose => 'Gemeinschaft auswählen';

  @override
  String get communityNotSelected =>
      'Keine Gemeinschaft ausgewählt, klicke auf das Icon';

  @override
  String get confirmPin => 'Bitte PIN bestätigen';

  @override
  String get confirmThePayment => '3. Bestätige die Zahlung';

  @override
  String get contactAddress => 'Addresse';

  @override
  String get contactAddressError => 'Ungültige Adresse';

  @override
  String get contactAlreadyExists => 'Adresse existiert bereits';

  @override
  String get contactDelete => 'Löschen';

  @override
  String get contactDeleteWarn =>
      'Bist du sicher, dass du diese Adresse löschen möchtest?';

  @override
  String get contactEndorse => 'Als vertrauenswürdig bestätigen';

  @override
  String get contactMemo => 'Kontaktinformationen';

  @override
  String get contactName => 'Name';

  @override
  String get contactNameAlreadyExists => 'Name existiert bereits';

  @override
  String get contactNameError => 'Name muss ausgefüllt werden';

  @override
  String get contactSave => 'Speichere';

  @override
  String get contactUs => 'Kontaktiere Uns';

  @override
  String get copy => 'Kopiere';

  @override
  String get count => 'Zähle';

  @override
  String get create => 'Konto erstellen';

  @override
  String get createError =>
      'Beim Erstellen deines Kontos ist ein Fehler aufgetreten';

  @override
  String get createHint => '(Beispiel: Alice)';

  @override
  String get createPassword => 'PIN';

  @override
  String get createPassword2 => 'PIN Bestätigen';

  @override
  String get createPassword2Error => 'Die PINs stimmen nicht überein';

  @override
  String get createPasswordError =>
      'Der PIN muss aus mindestens 4 Ziffern bestehen und darf keine anderen Zeichen enthalten';

  @override
  String get deleteAccount => 'löschen';

  @override
  String get democracy => 'Demokratie';

  @override
  String get democracyFaq => 'Wie funktioniert die Demokratie?';

  @override
  String get democracyDiscussion => 'Diskutiere Vorschläge im Forum!';

  @override
  String get democracyVotedNotificationBody =>
      'Du hast für diesen Vorschlag abgestimmt.';

  @override
  String get democracyVotedNotificationTitle => 'Abgestimmt';

  @override
  String get democracyUpdatedProposalStateNotificationBody =>
      'Du hast diesen Vorschlag aktualisiert';

  @override
  String get democracyUpdatedProposalStateNotificationTitle =>
      'Vorschlag aktualisiert';

  @override
  String get democracySubmitProposalNotificationBody =>
      'Du hast einen Vorschlag eingereicht, über den nun abgestimmt werden kann.';

  @override
  String get democracySubmitProposalNotificationTitle =>
      'Vorschlag eingereicht';

  @override
  String get detail => 'Detail';

  @override
  String get detailsEnter => 'Gib deine Details ein.';

  @override
  String get developer => 'Entwickler-Modus';

  @override
  String get done => 'Erledigt';

  @override
  String get doYouAlreadyHaveAnAccount => 'Hast du bereits ein Konto?';

  @override
  String get enable => 'Aktivieren';

  @override
  String get endorseeContent =>
      'Du wurdest von einem Bootstrapper als vertrauenswürdiges Mitglied bestätigt. Deswegen ist dein Sitz garantiert.';

  @override
  String get endorseeTitle =>
      'Als Endorsee registriert - Dein Platz is garantiert.';

  @override
  String get endorseNewcomerNotificationBody =>
      'Danke für das Endorsen des Newbies!';

  @override
  String get endorseNewcomerNotificationTitle => 'Newbie endorsed';

  @override
  String get enterAmount => 'Betrag eingeben';

  @override
  String get error => 'Fehler';

  @override
  String get errorMessageNoCommunity => 'Bitte wähle eine Gemeinschaft.';

  @override
  String get errorOccurred => 'Es ist ein Fehler aufgetreten:';

  @override
  String get errorUserNameIsRequired => 'Benutzername darf nicht leer sein';

  @override
  String get event => 'Event ID';

  @override
  String get swapOption => 'Swap-Option';

  @override
  String swapOptionRate(String amount, String asset, String cc) {
    return 'Kurs $amount $cc/$asset';
  }

  @override
  String swapOptionCcLimit(String amount, String cc) {
    return '$cc-Limit: $amount $cc';
  }

  @override
  String swapOptionAssetToReceive(String amount, String asset) {
    return 'Du erhältst: $amount $asset';
  }

  @override
  String swapOptionLimit(String amount, String asset) {
    return 'Limit: $amount $asset';
  }

  @override
  String exerciseSwapAssetOptionAvailable(String asset) {
    return 'Swap-Option verfügbar';
  }

  @override
  String get exerciseSwapNativeOptionAvailable => 'KSM-Swap-Option verfügbar';

  @override
  String get exerciseSwapOption => 'Swap-Option ausführen';

  @override
  String get export => 'Konto exportieren';

  @override
  String get exportAccount => 'exportieren';

  @override
  String get exportMnemonicOk =>
      'Mnemonik wurde in die Zwischenablage kopiert.';

  @override
  String get exportWarn =>
      'Schreibe diese Wörter auf ein Papier. Behalte das Papier an einem sicheren Ort. Diese Wörter geben jedem Zugriff auf das Konto und das Vermögen';

  @override
  String get fail => 'Fehlgeschlagen';

  @override
  String get fee => 'Gebühr';

  @override
  String get finish => 'Beenden';

  @override
  String get from => 'Von';

  @override
  String get fundsReceived => 'Zahlungseingang';

  @override
  String get fundVoucher => 'Gutschein aufladen';

  @override
  String get gatheringSuccessfullyCompleted =>
      'Versammlung erfolgreich durchgeführt';

  @override
  String get hash => 'Hash der Transaktion';

  @override
  String get hintEnterCurrentPin =>
      'Gib deinen jetzigen PIN ein um den PIN zu ändern.';

  @override
  String get hintThenEnterANewPin =>
      'Dann kannst du deinen neuen Pin eingeben.';

  @override
  String get home => 'Startbildschirm';

  @override
  String get howManyParticipantsShowedUp =>
      'Wieviele Teilnehmende sind da inklusive dir?';

  @override
  String get import => 'Importiere';

  @override
  String get importDuplicate =>
      'Dieses Konto existiert bereits, möchtest du es überschreiben?';

  @override
  String get importedWithRawSeedHenceNoMnemonic =>
      'Konto wurde mit einem Raw Seed importiert und hat deshalb keine Mnemonik';

  @override
  String get importInvalidMnemonic => 'Ungültige Mnemonik eingegeben';

  @override
  String get importInvalidRawSeed => 'Ungültigen raw seed eingegeben';

  @override
  String get importMustNotBeEmpty => 'Eingabe darf nicht leer sein';

  @override
  String get importPrivateKeyUnsupported =>
      'Konto importieren mit privatem Schlüssel wird noch nicht unterstützt';

  @override
  String get incomeIssuance => 'Gemeinschaftseinkommen';

  @override
  String get insufficientBalance => 'Ungenügender Saldo';

  @override
  String get insufficientFundsErrorBody =>
      'Du hast nicht genügend Geld auf diesem Konto. Schaue auf der Webseite deiner lokalen Gemeinschaft, wie du welches bekommen kannst.';

  @override
  String get insufficientFundsErrorTitle => 'Zu wenig Guthaben';

  @override
  String get invalidTransactionFormatErrorBody =>
      'Die Transaktion hatte ein ungültiges Format, was ein Fehler in der Anwendung sein könnte. Wenn du denkst, dass es sich um einen Bug handelt, tippe einfach auf das entsprechende Feld unten.';

  @override
  String get invalidTransactionFormatErrorTitle =>
      'Ungültiges Transaktionsformat';

  @override
  String get invalidCommunity => 'Ungültige Gemeinschaft';

  @override
  String get invalidNetwork => 'Ungültiges Netzwerk';

  @override
  String get invoice => 'Rechnungsbetrag';

  @override
  String get issuanceClaimed => 'Kein ausstehendes Gemeinschaftseinkommen';

  @override
  String get issuancePending => 'Gemeinschaftseinkommen einfordern';

  @override
  String get keySigningCycle => 'Key-Signing Cycle';

  @override
  String get keystore => 'Keystore (json)';

  @override
  String get kusamaFaucet => 'Kusama Faucet';

  @override
  String get lang => 'Sprache';

  @override
  String get leuZurichFAQ => 'leu.zuerich FAQ';

  @override
  String get like => 'Gefällt mir';

  @override
  String get loading => 'Lädt...';

  @override
  String get meetingPoint => 'Treffpunkt';

  @override
  String get meetupClaimantEqualToSelf =>
      'Fehler, Adresse ist aktueller account. Antrag wurde nicht gespeichert.';

  @override
  String get meetupClaimantInvalid =>
      'Diese* Antragssteller*in gehört nicht zu deiner Versammlung. Antrag wurde nicht gespeichert.';

  @override
  String get meetupLocation => 'Treffpunkt';

  @override
  String meetupIndex(Object index) {
    return 'Versammlungsnummer: $index';
  }

  @override
  String get meetupIndexPopupExplanation =>
      'Verwende die Versammlungsnummer, um deinen tatsächlichen Versammlungsort zu finden. Der Community-Leader ist in deiner Gemeinschaft für die Festlegung der Versammlungsorte verantwortlich. Der tatsächliche Ort kann sich leicht von dem hier angezeigten unterscheiden.';

  @override
  String get meetupNotificationOneDayBeforeContent =>
      'Treffen beginnt in 24 Stunden';

  @override
  String get meetupNotificationOneDayBeforeTitle => 'Noch 24 Stunden';

  @override
  String get meetupNotificationOneHourBeforeContent =>
      'Treffen beginnt in einer Stunde';

  @override
  String get meetupNotificationOneHourBeforeTitle => '1 Stunde übrig';

  @override
  String get mnemonic => 'Mnemonik';

  @override
  String get newbieContent =>
      'Bei deinem derzeitigen Status ist die Teilnahme am kommenden Cycle nicht garantiert. Bitte Frag in deinem Umfeld nach einem Vertrauensvorschuss.';

  @override
  String get newbieTitle => 'Teilnahme Nicht Garantiert';

  @override
  String get next => 'Weiter';

  @override
  String get nextCycleDateLabel => 'Nächster Cycle:';

  @override
  String get nextCycleTimeLeft => 'Nächster Cycle ist in';

  @override
  String get noCommunitiesAreYouOffline =>
      'Keine Gemeinschaften gefunden. Du kannst später eine auswählen. Bist du offline?';

  @override
  String get noInvoice => 'Ohne Rechnung';

  @override
  String get noItems => 'Keine Items Gefunden';

  @override
  String get noMnemonicFound => 'Keine Mnemonik gefunden';

  @override
  String get notNow => 'Nicht jetzt';

  @override
  String get notifySubmittedQueued =>
      'Die Transaktion in der Warteschlange wurde eingereicht';

  @override
  String get noTransactions => 'Keine Transaktionen';

  @override
  String get noValidClaimsErrorBody =>
      'Keine gültigen Bestätigungen wurden eingereicht. Hast du andere Teilnehmer gescannt?';

  @override
  String get noValidClaimsErrorTitle => 'Keine gültigen Bestätigungen';

  @override
  String get numberOfAttendees => 'Anzahl Teilnehmende';

  @override
  String get observe => 'Überwachen';

  @override
  String get observeBrief =>
      'Markiere diese Adresse als zu überwachen, dann kann diese Adresse in der Kontoauswahlseite ausgewählt werden, um deren Vermögen und Aktionen zu überwachen';

  @override
  String get observedPendingExtrinsic =>
      'Es wurde eine unbestätigte Transaktion beobachtet. Bitte warte auf Bestätigung!';

  @override
  String get offlineMessage =>
      'Du bist offline. Du kannst deine Ansprüche später auf dem Startbildschirm einreichen.';

  @override
  String get ok => 'OK';

  @override
  String get onlyReputablesCanEndorseAttendGatheringToBecomeOne =>
      'Nur Reputables können endorsen. Nimm an einem Treffen teil, um Reputation zu erhalten!';

  @override
  String get openMapApplication => 'In Karte öffnen';

  @override
  String get openTheEncointerApp => '1. Öffne die App \n«Encointer Wallet»';

  @override
  String get passOld => 'Aktuelle PIN';

  @override
  String get passSuccess => 'Erfolgreich';

  @override
  String get passSuccessTxt => 'PIN wurde erfolgreich geändert';

  @override
  String get payHereWithLeu => 'Zahle hier mit Leu';

  @override
  String get payment => 'Zahlung';

  @override
  String get paymentDoYouWantToProceed => 'Mit Zahlung fortfahren?';

  @override
  String get paymentError => 'Zahlungsfehler';

  @override
  String get paymentFinished => 'Zahlung erfolgt';

  @override
  String get paymentSubmitting => 'Zahlung wird eingereicht...';

  @override
  String get personalKey => 'Persönlicher Schlüssel';

  @override
  String get personalKeyEnter =>
      'Gib deinen persönlichen Key ein (12 Wörter), um dein Konto zu importieren.';

  @override
  String get pinHint =>
      'Du wirst diese PIN benötigen um Transaktionen zu tätigen oder neue Konten hinzufügen.';

  @override
  String get pinInfo =>
      'PIN muss mindestens 4 Ziffern enthalten. Bei PIN-Verlust ist der Account nicht wiederherstellbar, ausser man hat ein Backup auf der Profilseite gemacht.';

  @override
  String get pinSecure => 'Sichere dein Konto mit einem PIN.';

  @override
  String get pleaseCommunityChoose => 'Bitte wähle eine Gemeinschaft';

  @override
  String get pleaseConfirmYourNewPin => 'Bestätige neue PIN';

  @override
  String get preview => 'Vorschau';

  @override
  String get print => 'Drucken';

  @override
  String get proposal => 'Vorschlag';

  @override
  String get proposalAye => 'Aye';

  @override
  String get proposalNay => 'Nay';

  @override
  String get proposalNew => 'Neuer Vorschlag';

  @override
  String get proposalExplainerAddLocation =>
      'Dieser Vorschlag schlägt einen neuen Treffpunkt für deine Gemeinschaft vor. Achte darauf, dass er mindestens 100 Meter entfernt und nicht weiter als 1 Kilometer von bestehenden Treffpunkten liegt.';

  @override
  String get proposalExplainerRemoveLocation =>
      'Dieser Vorschlag schlägt vor, einen bestehenden Treffpunkt deiner Gemeinschaft zu entfernen.';

  @override
  String get proposalExplainerUpdateDemurrage =>
      'Dieser Vorschlag legt eine neue monatliche Demurrage für die Lokalwährung fest.';

  @override
  String get proposalExplainerUpdateNominalIncome =>
      'Dieser Vorschlag bestimmt ein neues Grundeinkommen pro Versammlungszyklus für deine Gemeinschaft.';

  @override
  String get proposalExplainerSetInactivityTimeout =>
      'Dieser Vorschlag setzt eine neue globale Inaktivitätsfrist fest. Falls eine Gemeinschaft über die vorgeschriebene Anzahl an VersammlungsZyklen keine Treffen abhält, wird sie gelöscht.';

  @override
  String get proposalExplainerPetition =>
      'Dieser Vorschlag dient als Petition – entweder global oder innerhalb deiner Gemeinschaft. Er hat keine direkte Wirkung auf der Blockchain, signalisiert jedoch ein Anliegen, auf das die Gemeinschaft reagieren kann.';

  @override
  String get proposalExplainerSpendNative =>
      'Dieser Vorschlag schlägt vor, KSM aus der Gemeinschaftsreserve für einen Begünstigten auszugeben, entweder durch eine globale oder Gemeinschaftsabstimmung. Diese Mittel können zur Belohnung von Beiträgen oder zur Unterstützung von Gemeinschaftsprojekten verwendet werden.';

  @override
  String proposalExplainerSpendAsset(String asset) {
    return 'Dieser Vorschlag schlägt vor, $asset aus der Community-Treasury für eine begünstigte Person auszugeben – entweder durch eine globale oder lokale Abstimmung. Diese Mittel können Community-Beiträge belohnen oder Initiativen unterstützen.\n\nHinweis: Du erhältst das $asset direkt auf dem Asset Hub Kusama.';
  }

  @override
  String proposalExplainerIssueSwapOption(String cc, String asset) {
    return 'Dieser Vorschlag ermöglicht es der begünstigten Person, $cc zu einem festen Kurs mehrfach gegen $asset zu tauschen, bis ein festgelegtes $asset-Limit erreicht ist. Die begünstigte Person ist typischerweise ein lokales Unternehmen, das $cc akzeptiert und möglicherweise einen Überschuss ansammelt.';
  }

  @override
  String get proposalExplainerSwapOptionComputation =>
      'Berechnung mit deinen Eingaben';

  @override
  String get proposalExplainerRate => 'Rate';

  @override
  String get proposalExplainerSwapFee => 'Swap-Gebühr';

  @override
  String get proposalExplainerBeneficiaryWillGet => 'Begünstigte/r erhält';

  @override
  String proposalExplainerPaymentWillBeOnAH(String asset) {
    return 'Hinweis: Das $asset wird direkt auf dein Asset Hub Kusama-Konto gesendet.';
  }

  @override
  String get proposalExplainerCannotVoteYet =>
      'Du kannst ab dem nächsten Zyklus mit deiner Reputation abstimmen!';

  @override
  String get proposalType => 'Vorschlagstyp';

  @override
  String get proposalTypeAddLocation => 'Standort hinzufügen';

  @override
  String get proposalTypeRemoveLocation => 'Standort entfernen';

  @override
  String get proposalTypeUpdateDemurrage => 'Demurrage aktualisieren';

  @override
  String get proposalTypeUpdateNominalIncome => 'Grundeinkommen aktualisieren';

  @override
  String get proposalTypeSetInactivityTimeout =>
      'Inaktivitätszeitlimit festlegen';

  @override
  String get proposalTypePetition => 'Petition';

  @override
  String get proposalTypeSpendNative => 'KSM ausgeben';

  @override
  String proposalTypeIssueSwapNativeOption(String cc) {
    return '$cc für KSM tauschen';
  }

  @override
  String proposalTypeSpendAsset(String asset) {
    return '$asset ausgeben';
  }

  @override
  String proposalTypeIssueSwapAssetOption(String cc, String asset) {
    return '$cc für $asset tauschen';
  }

  @override
  String get proposalScope => 'Geltungsbereich';

  @override
  String proposalScopeLocal(String community) {
    return 'Lokal ($community)';
  }

  @override
  String get proposalScopeGlobal => 'Global';

  @override
  String get proposalFieldLatitude => 'Breitengrad';

  @override
  String get proposalFieldLongitude => 'Längengrad';

  @override
  String get proposalFieldDemurragePerMonth => 'Demurrage (% / Monat)';

  @override
  String get proposalFieldNominalIncome => 'Grundeinkommen';

  @override
  String get proposalFieldInactivityTimeoutCycles =>
      'Inaktivitätszeitlimit (Versammlungszyklen)';

  @override
  String get proposalFieldPetitionText => 'Petitionstext';

  @override
  String get proposalFieldAssetToSpend => 'Zu vergebender Token';

  @override
  String proposalFieldAssetToSwap(String cc) {
    return 'Asset, das für $cc empfangen werden soll';
  }

  @override
  String proposalFieldAmount(String asset) {
    return 'Betrag ($asset)';
  }

  @override
  String get proposalFieldBeneficiary => 'Begünstigter';

  @override
  String proposalFieldAllowance(String asset) {
    return 'Limit ($asset)';
  }

  @override
  String proposalFieldRate(String asset, String cc) {
    return 'Kurs ($cc/$asset)';
  }

  @override
  String get proposalFieldBurn => 'Verbrennen';

  @override
  String get proposalFieldValidity => 'Gültigkeit';

  @override
  String get proposalFieldErrorEnterPetitionText => 'Petitionstext eingeben';

  @override
  String get proposalFieldErrorPetitionTextTooLong =>
      'Petitionstext ist zu lang';

  @override
  String get proposalFieldErrorEnterLatitude => 'Breitengrad eingeben';

  @override
  String get proposalFieldErrorLatitudeRange =>
      'Breitengrad muss zwischen -90 und 90 liegen';

  @override
  String get proposalFieldErrorEnterLongitude => 'Längengrad eingeben';

  @override
  String get proposalFieldErrorLongitudeRange =>
      'Längengrad muss zwischen -180 und 180 liegen';

  @override
  String get proposalFieldErrorEnterDemurrage => 'Demurrage eingeben';

  @override
  String get proposalFieldErrorDemurrageRange =>
      'Demurrage muss zwischen 0 und 100 liegen';

  @override
  String get proposalFieldErrorEnterPositiveNumber =>
      'Geben Sie eine positive Zahl ein';

  @override
  String get proposalFieldErrorPositiveNumberRange =>
      'Muss eine positive Zahl sein';

  @override
  String proposalFieldErrorPositiveNumberTooBig(String amount) {
    return 'Zahl ist zu groß (Limit: $amount)';
  }

  @override
  String get proposalFieldErrorEnterInactivityTimeout =>
      'Inaktivitätszeitlimit eingeben';

  @override
  String get proposalFieldErrorPositiveIntegerRange =>
      'Muss eine positive ganze Zahl sein';

  @override
  String get proposalOnlyBootstrappersOrReputablesCanSubmit =>
      'Nur Bootstrappers oder Reputables können einen Vorschlag einreichen.';

  @override
  String get proposalOnlyBusinessOwnersCanSubmit =>
      'Nur Geschäftsinhaber können diesen Vorschlag einreichen.';

  @override
  String get proposalCannotSubmitProposalTypePendingEnactment =>
      'Ein Vorschlag dieses Typs kann nicht eingereicht werden, da bereits einer auf die Umsetzung wartet.';

  @override
  String get proposalClose => 'Schliessen';

  @override
  String get proposalUpdateState => 'Aktualisieren';

  @override
  String get proposalUpdateExplanation =>
      'Dies wird den Status des Vorschlags aktualisieren. Wenn er zu alt ist und nicht genügend Aye-Stimmen hat, wird er abgelehnt. Wenn er lange genug bestätigt wurde, wird er angenommen.';

  @override
  String get proposalSubmit => 'Vorschlag einreichen';

  @override
  String get proposalSuperseded => 'Verdrängt';

  @override
  String get proposalRejected => 'Abgelehnt';

  @override
  String get proposalEnacted => 'Ausgeführt';

  @override
  String get proposalApproved => 'Angenommen';

  @override
  String get proposalTurnout => 'Wahlbeteiligung';

  @override
  String get proposalHowVote => 'Wie stimmst du ab?';

  @override
  String get proposalsEmpty => 'Keine Vorschläge';

  @override
  String get proposalsUpForVote => 'Vorschläge zum Abstimmen';

  @override
  String get proposalsPast => 'Vergangene Vorschläge';

  @override
  String get proposalVote => 'Stimmen';

  @override
  String get proposalVoted => 'Abgestimmt';

  @override
  String get proposalOngoingUntil => 'Laufend bis';

  @override
  String get proposalConfirmingUntil => 'In Bestätigung bis';

  @override
  String get proposalPendingEnactmentAt => 'Wird ausgeführt am';

  @override
  String get proposalFailedAndNeedsBump =>
      'Der Vorschlag ist gescheitert und kann geschlossen werden.';

  @override
  String get proposalPassedAndNeedsBump =>
      'Der Vorschlag wurde angenommen und kann geschlossen werden.';

  @override
  String get qrScan => 'QR-Code scannen';

  @override
  String get qrScanHintAccount =>
      'Bitte den Empfänger den QR-Code in der Encointer App zu scannen.';

  @override
  String get rawSeed => 'Raw Seed';

  @override
  String get receive => 'Fordern';

  @override
  String get received => 'Empfangen';

  @override
  String get receiverAccount => 'Empfangendes Konto:';

  @override
  String get redeemFailure =>
      'Es gab einen Fehler beim einlösen des Gutscheins. Ursache:';

  @override
  String get redeemSuccess => 'Gutschein erfolgreich eingelöst.';

  @override
  String get redeemVoucher => 'Gutschein einlösen';

  @override
  String get registeringPhaseReminderContent =>
      'Die Anmeldung für das nächste Treffen hat begonnen.';

  @override
  String get registeringPhaseReminderTitle => 'Melde dich jetzt an!';

  @override
  String get registerParticipantNotificationBody =>
      'Du erhältst eine Erinnerung einen Tag zuvor.';

  @override
  String get registerParticipantNotificationTitle =>
      'Für den nächsten Cycle angemeldet!';

  @override
  String get registerUntil => 'Registriere dich vor dem';

  @override
  String get remainingNewbieTicketsAsBootStrapper =>
      'Verbleibende Newbie Tickets als Bootstrapper:';

  @override
  String get remainingNewbieTicketsAsReputable =>
      'Verbleibende Newbie Tickets als Reputable:';

  @override
  String get remarkNotificationBody => 'Sie haben eine Notiz eingereicht.';

  @override
  String get remarkNotificationTitle => 'Notiz eingereicht';

  @override
  String get remarks => 'Onchain Notizen';

  @override
  String get remarksButton => 'Öffentliche Notiz einreichen';

  @override
  String get remarksExplain =>
      'Du kannst eine Notiz an das Netzwerk senden. Diese Notiz wird öffentlich und unveränderlich sein. Sie kann von jemensch gelesen und authentifiziert werden, da sie digital von Dir signiert wird.';

  @override
  String get remarksNote => 'Notiz';

  @override
  String get remarksSubmit => 'Notiz einreichen';

  @override
  String get reputableContent =>
      'Du hast deine Reputation genutzt um einen garantierten Platz zu erhalten. Achtung: Solltest Du dich anmelden, aber nicht zur Versammlung erscheinen, wirst du wieder ein Newbie.';

  @override
  String get reputableTitle =>
      'Als Reputable registriert. Dein Platz ist garantiert';

  @override
  String get reputationAlreadyCommittedTitle => 'Reputation bereits benutzt';

  @override
  String get reputationAlreadyCommittedContent =>
      'Du hast deine Reputation für dieses Faucet bereits benutzt.';

  @override
  String get reputationOverall => 'Allgemeine Reputation';

  @override
  String get restartGathering => 'Versammlung erneut starten';

  @override
  String get retry => 'Wiederholen';

  @override
  String get rewardsAlreadyIssuedErrorBody =>
      'Ein anderer Teilnehmer hat die Auszahlung für dieses Treffen ausgelöst. Du solltest dein Einkommen bereits erhalten haben.';

  @override
  String get rewardsAlreadyIssuedErrorTitle => 'Einkommen bereits ausgezahlt';

  @override
  String get scan => 'Scannen';

  @override
  String get scanDescriptionForMeetup =>
      'Jede* Anwesende muss alle anderen scannen, und von allen gescannt werden.';

  @override
  String get scanOthers => 'Andere scannen';

  @override
  String get scanQrCodeOnTheLeft =>
      '2. Scanne den QR-Code \nauf der linken Seite';

  @override
  String get sendLink => 'Link senden';

  @override
  String get sent => 'Gesendet';

  @override
  String get setting => 'Einstellungen';

  @override
  String get settingLang => 'Sprache';

  @override
  String get settingLangAuto => 'Automatisch';

  @override
  String get settingNetwork => 'Wähle ein Portemonnaie';

  @override
  String get settingNode => 'Entfernter Knoten';

  @override
  String get settingNodeList => 'Verfügbare Knoten';

  @override
  String get settingPrefix => 'Adressenpräfix';

  @override
  String get settingPrefixList => 'Verfügbare Präfix';

  @override
  String get share => 'Teilen';

  @override
  String get shareInvoice => 'Teile als Rechnung';

  @override
  String get shareLinkHint => 'Oder über Link teilen:';

  @override
  String get showRouteMeetupLocation => 'Route anzeigen';

  @override
  String get startGathering => 'Versammlung starten';

  @override
  String get submittedFaucetDripTitle => 'Faucet Belohnung';

  @override
  String get submittedFaucetDripBody =>
      'Du hast erfolgreich deine Faucet-Vorteile abgeholt.';

  @override
  String get success => 'Erfolgreich';

  @override
  String get switchAccount => 'Konto wechseln';

  @override
  String get switchCommunity => 'Gemeinschaft wechseln';

  @override
  String get thankYou => 'Danke';

  @override
  String get title => 'Profil';

  @override
  String get to => 'Nach';

  @override
  String get today => 'Heute';

  @override
  String get tomorrow => 'Morgen';

  @override
  String get transactionError => 'Transaktionsfehler';

  @override
  String get transactionQueuedOffline =>
      'Die App ist nicht mit der Blockchain verbunden. Die Transaktionen in der Warteschlange werden automatisch bei erfolgreicher Verbindung versendet.';

  @override
  String get transfer => 'Senden';

  @override
  String get transferHistory => 'Transfers';

  @override
  String get transferHistoryEnd =>
      'Das Laden älterer Transaktionen wird noch nicht unterstützt';

  @override
  String get transferHistoryTop =>
      'Es kann bis zu 30 Sekunden dauern, bis der Transfer hier auftaucht';

  @override
  String treasuryBalanceTooLow(String balance, String cc) {
    return 'Treasury-Guthaben zu niedrig. Limit: $balance $cc';
  }

  @override
  String treasuryGlobalBalance(String balance) {
    return 'Freies globales Schatzkammerguthaben: $balance KSM.';
  }

  @override
  String treasuryLocalBalance(String balance) {
    return 'Freies Gemeinschaftsschatzkammerguthaben: $balance KSM.';
  }

  @override
  String treasuryLocalBalanceOnAHK(String balance, String asset) {
    return 'Freies Gemeinschaftsschatzkammerguthaben auf Asset Hub: $balance $asset.';
  }

  @override
  String treasuryPendingSpends(String spends) {
    return 'Ausstehende Ausgaben: $spends KSM.';
  }

  @override
  String get txBroadcast => 'Transaktion wurde im Netzwerk';

  @override
  String get txError => 'Transaktionsfehler';

  @override
  String get txInBlock => 'Transaction ist in einem Block';

  @override
  String get txQueued => 'Transaktion is in der Warteschlange';

  @override
  String get txQueuedOffline =>
      'Du bist offline. Die Transaktion wird geschickt, wenn du wieder online bist.';

  @override
  String get txReady => 'Transaktion bereit.';

  @override
  String get txTooLowPriorityErrorBody =>
      'Technischer Transaktionsfehler. Das kann passieren, wenn du zweimal innerhalb sehr kurzer Zeit eine Transaktion abschickst. Bitte warte einige Sekunden.';

  @override
  String get txTooLowPriorityErrorTitle => 'Transaktions Prioritätsfehler';

  @override
  String get unknown => 'Unbekannt';

  @override
  String get unknownAccount => 'Unbekanntes Konto';

  @override
  String get unknownError =>
      'Es ist ein Fehler aufgetreten. Bitte überprüfe deine Internetverbindung und versuche es erneut.';

  @override
  String get unregister => 'Abmelden';

  @override
  String get unregisterDialogTitle =>
      'Vom nächsten Key-Signing Cycle abmelden?';

  @override
  String get unregisterParticipantNotificationBody =>
      'Du hast dich abgemeldet vom nächsten Cycle. Du kannst dich wieder anmelden, wenn du es dir anders überlegst.';

  @override
  String get unregisterParticipantNotificationTitle =>
      'Registrierung storniert';

  @override
  String get updatingAppState => 'App-Zustand wird aktualisiert...';

  @override
  String get value => 'Wert';

  @override
  String get votesNotDependableErrorBody =>
      'Es wurde nur die Hälfte oder weniger der zugewiesenen Teilnehmer bestätigt, oder einige Teilnehmer haben ihre Bestätigungen noch nicht eingereicht. Das verhindert das sofortige Auszahlen des Einkommens und du musst 48 Stunden warten.';

  @override
  String get votesNotDependableErrorTitle => 'Unzureichende Bestätigungen';

  @override
  String get voucher => 'Gutschein';

  @override
  String get voucherBalance => 'Gutscheinwert';

  @override
  String get voucherBalanceTooLow =>
      'Der Gutschein hat zu wenig Geld um eingelöst zu werden.';

  @override
  String get weHopeToSeeYouAtTheNextGathering =>
      'Wir hoffen dich an der nächsten Versammlung wiederzusehen.';

  @override
  String get wrongPin => 'Falscher PIN';

  @override
  String get wrongPinHint =>
      'Konto konnte nicht entsperrt werden. Bitte überprüfe die eingegebene PIN.';

  @override
  String get youAreNotRegisteredPleaseRegisterNextTime =>
      'Du wurdest nicht für diesen Key-Signing Cycle zugewiesen. Bitte registriere dich für den nächsten Cycle um dein Gemeinschaftseinkommen zu erhalten.';

  @override
  String get yourNewPin => 'Neue PIN';

  @override
  String unlockAccount(String currentAccountName) {
    return 'Entsperre Konto $currentAccountName mit PIN';
  }

  @override
  String errorMessageWithStatusCode(String errorText) {
    return 'Etwas ist schief gelaufen. Bitte versuche es erneut! StatusCode: $errorText';
  }

  @override
  String yourBalanceFor(String accountName) {
    return 'Dein Kontostand, $accountName';
  }

  @override
  String incomingConfirmed(num amount, String cidSymbol, String accountName) {
    return 'Empfang von $amount $cidSymbol für $accountName bestätigt';
  }

  @override
  String voucherDifferentNetworkAndCommunity(String network, String community) {
    return 'Der Gutschein ist für ein anderes Netzwerk. Willst du zu $network und $community wechseln? Du kannst das Netzwerk zurückändern under Profil > Developer mode.';
  }

  @override
  String voucherDifferentCommunity(String community) {
    return 'Der Gutschein ist für eine andere Gemeinschaft. Willst du zu $community wechseln?';
  }

  @override
  String doYouWantToRedeemThisVoucher(String accountName) {
    return 'Willst du diesen Gutschein für $accountName einlösen?';
  }

  @override
  String claimsSubmitN(int count) {
    return '$count Anträge einreichen';
  }

  @override
  String claimsScanned(num amount) {
    return 'Du hast $amount Anträge gescannt';
  }

  @override
  String claimsScannedNOfM(int scannedCount, int totalCount) {
    return '$scannedCount / $totalCount gescannte Anträge';
  }

  @override
  String claimsSubmitDetail(num amount) {
    return 'Reiche $amount Bezeugungen für diese Versammlung ein';
  }

  @override
  String youAreRegisteredAs(String participantType) {
    return 'Du hast dich für die nächste Versammlung als $participantType registriert.';
  }

  @override
  String youAreAssignedToAGatheringWithNParticipants(int participantsCount) {
    return 'Du bist einer Versammlung mit $participantsCount Leuten zugewiesen.';
  }

  @override
  String successfullySentNAttestations(int participantsCount) {
    return 'Du hast erfolgreich Bezeugungen für $participantsCount andere Leute eingereicht.';
  }

  @override
  String tokenSend(String symbol) {
    return '$symbol senden';
  }

  @override
  String communityWithName(String name) {
    return '$name Gemeinschaft';
  }

  @override
  String verifyAuthTitle(String useBioAuth) {
    String _temp0 = intl.Intl.selectLogic(
      useBioAuth,
      {
        'true': 'deine Identität',
        'false': 'deine PIN',
        'other': '',
      },
    );
    return 'Bitte verifiziere $_temp0.';
  }

  @override
  String offersForCommunity(String value) {
    return 'Angebote für $value';
  }

  @override
  String proposalApprovalThreshold(String percentage) {
    return 'Annahme bei $percentage% Zustimmung';
  }

  @override
  String proposalPassed(String percentage) {
    return 'Angenommen mit $percentage% Aye';
  }

  @override
  String proposalFailed(String percentage) {
    return 'Abgelehnt mit $percentage% Aye';
  }

  @override
  String proposalIsPassing(String percentage) {
    return 'Wird gerade angenommen mit $percentage% Aye';
  }

  @override
  String proposalIsFailing(String percentage) {
    return 'Wird gerade abgelehnt mit $percentage% Aye';
  }

  @override
  String proposalSetInactivityTimeoutTo(String value) {
    return 'Global: Setze das neue Inaktivitätszeitlimit auf $value';
  }

  @override
  String proposalAddLocation(String cid) {
    return '$cid: Füge einen neuen Standort hinzu';
  }

  @override
  String proposalRemoveLocation(String cid) {
    return '$cid: Entferne einen Standort';
  }

  @override
  String proposalUpdateNominalIncome(String value, String currency) {
    return 'Gemeinschaftseinkommen anpassen auf $value $currency';
  }

  @override
  String proposalUpdateDemurrage(String value) {
    return 'Demurrage anpassen auf $value%/Monat';
  }

  @override
  String proposalPetition(String cid, String value) {
    return '$cid Petition: $value';
  }

  @override
  String proposalSpendNative(String cid, String amount, String beneficiary) {
    return '$cid Die Gemeinschaftsreserve soll $amount KSM an $beneficiary senden';
  }

  @override
  String proposalSpendAsset(
      String asset, String cid, String amount, String beneficiary) {
    return '$cid Die Gemeinschaftsreserve soll $amount $asset an $beneficiary senden';
  }

  @override
  String proposalIssueSwapNativeOption(
      String cid, String beneficiary, String allowance, String rate) {
    return '$cid: Ermögliche $beneficiary, bis zu $allowance KSM zu einem Kurs von $rate $cid/KSM einzutauschen.';
  }

  @override
  String proposalIssueSwapOptionCCLimit(
      String asset, String cc, String allowance) {
    return 'Du kannst bis zu $allowance $cc tauschen, um dein festgelegtes $asset-Limit zu erreichen.';
  }

  @override
  String proposalIssueSwapAssetOption(String asset, String cid,
      String beneficiary, String allowance, String rate) {
    return '$cid: Ermögliche $beneficiary, bis zu $allowance $asset zu einem Kurs von $rate $cid/$asset einzutauschen.';
  }

  @override
  String proposalSupersededBy(String id) {
    return 'Verdrängt durch: $id';
  }
}
