import 'package:ew_test_keys/ew_test_keys.dart';
import 'package:flutter/material.dart';
import 'package:iconsax/iconsax.dart';
import 'package:provider/provider.dart';

import 'package:encointer_wallet/common/components/encointer_text_form_field.dart';
import 'package:encointer_wallet/common/components/form/scrollable_form.dart';
import 'package:encointer_wallet/common/components/gradient_elements.dart';
import 'package:encointer_wallet/theme/theme.dart';
import 'package:encointer_wallet/modules/modules.dart';
import 'package:encointer_wallet/store/app.dart';
import 'package:encointer_wallet/utils/input_validation.dart';
import 'package:ew_l10n/l10n.dart';

class CreateAccountView extends StatelessWidget {
  const CreateAccountView({super.key});

  static const String route = '/account/createAccount';

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(context.l10n.create),
        leading: const SizedBox.shrink(),
        actions: const [CloseButton()],
      ),
      body: Padding(
        padding: const EdgeInsets.symmetric(horizontal: 14),
        child: Provider(
          create: (context) => NewAccountStore(context.read<AppStore>()),
          child: CreateAccountForm(),
        ),
      ),
    );
  }
}

class CreateAccountForm extends StatelessWidget with HandleNewAccountResultMixin {
  CreateAccountForm({super.key});

  final _formKey = GlobalKey<FormState>();

  final TextEditingController _nameCtrl = TextEditingController();

  @override
  Widget build(BuildContext context) {
    final l10n = context.l10n;
    return ScrollableForm(
      formKey: _formKey,
      listViewChildren: [
        const SizedBox(height: 80),
        Center(
          child: Text(
            l10n.accountNameChoose,
            style: context.headlineSmall,
          ),
        ),
        const SizedBox(height: 10),
        Center(
          child: Text(
            l10n.accountNameChooseHint,
            textAlign: TextAlign.center,
            style: context.headlineMedium.copyWith(color: AppColors.encointerBlack),
          ),
        ),
        const SizedBox(height: 30),
        EncointerTextFormField(
          key: const Key(EWTestKeys.createAccountName),
          hintText: l10n.createHint,
          labelText: l10n.accountName,
          controller: _nameCtrl,
          validator: (v) {
            return InputValidation.validateAccountName(context, v, context.read<AppStore>().account.accountList);
          },
        ),
        const SizedBox(height: 20),
      ],
      columnChildren: [
        const SizedBox(height: 10),
        PrimaryButton(
          key: const Key(EWTestKeys.createAccountNext),
          onPressed: () {
            if (_formKey.currentState!.validate()) {
              context.read<NewAccountStore>().setName(_nameCtrl.text.trim());
              Navigator.push(
                context,
                MaterialPageRoute<void>(
                  builder: (BuildContext _) => Provider.value(
                    value: context.read<NewAccountStore>(),
                    child: const CreatePinView(),
                  ),
                ),
              );
            }
          },
          child: Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              const Icon(Iconsax.login_1),
              const SizedBox(width: 12),
              Text(
                l10n.next,
                style: context.titleMedium.copyWith(
                  color: context.colorScheme.surface,
                ),
              ),
            ],
          ),
        ),
        const SizedBox(height: 20),
      ],
    );
  }
}
