const Map<String, List<Map<String, String>>> vectors = {
  "english": [
    {
      "entropy": "00000000000000000000000000000000",
      "mnemonic":
          "abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon about",
      "passphrase": "TREZOR",
      "seed":
          "c55257c360c07c72029aebc1b53c05ed0362ada38ead3e3e9efa3708e53495531f09a6987599d18264c1e1c92f2cf141630c7a3c4ab7c81b2f001698e7463b04"
    },
    {
      "entropy": "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic":
          "legal winner thank year wave sausage worth useful legal winner thank yellow",
      "passphrase": "TREZOR",
      "seed":
          "2e8905819b8723fe2c1d161860e5ee1830318dbf49a83bd451cfb8440c28bd6fa457fe1296106559a3c80937a1c1069be3a3a5bd381ee6260e8d9739fce1f607"
    },
    {
      "entropy": "80808080808080808080808080808080",
      "mnemonic":
          "letter advice cage absurd amount doctor acoustic avoid letter advice cage above",
      "passphrase": "TREZOR",
      "seed":
          "d71de856f81a8acc65e6fc851a38d4d7ec216fd0796d0a6827a3ad6ed5511a30fa280f12eb2e47ed2ac03b5c462a0358d18d69fe4f985ec81778c1b370b652a8"
    },
    {
      "entropy": "ffffffffffffffffffffffffffffffff",
      "mnemonic": "zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo wrong",
      "passphrase": "TREZOR",
      "seed":
          "ac27495480225222079d7be181583751e86f571027b0497b5b5d11218e0a8a13332572917f0f8e5a589620c6f15b11c61dee327651a14c34e18231052e48c069"
    },
    {
      "entropy": "000000000000000000000000000000000000000000000000",
      "mnemonic":
          "abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon agent",
      "passphrase": "TREZOR",
      "seed":
          "035895f2f481b1b0f01fcf8c289c794660b289981a78f8106447707fdd9666ca06da5a9a565181599b79f53b844d8a71dd9f439c52a3d7b3e8a79c906ac845fa"
    },
    {
      "entropy": "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic":
          "legal winner thank year wave sausage worth useful legal winner thank year wave sausage worth useful legal will",
      "passphrase": "TREZOR",
      "seed":
          "f2b94508732bcbacbcc020faefecfc89feafa6649a5491b8c952cede496c214a0c7b3c392d168748f2d4a612bada0753b52a1c7ac53c1e93abd5c6320b9e95dd"
    },
    {
      "entropy": "808080808080808080808080808080808080808080808080",
      "mnemonic":
          "letter advice cage absurd amount doctor acoustic avoid letter advice cage absurd amount doctor acoustic avoid letter always",
      "passphrase": "TREZOR",
      "seed":
          "107d7c02a5aa6f38c58083ff74f04c607c2d2c0ecc55501dadd72d025b751bc27fe913ffb796f841c49b1d33b610cf0e91d3aa239027f5e99fe4ce9e5088cd65"
    },
    {
      "entropy": "ffffffffffffffffffffffffffffffffffffffffffffffff",
      "mnemonic":
          "zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo when",
      "passphrase": "TREZOR",
      "seed":
          "0cd6e5d827bb62eb8fc1e262254223817fd068a74b5b449cc2f667c3f1f985a76379b43348d952e2265b4cd129090758b3e3c2c49103b5051aac2eaeb890a528"
    },
    {
      "entropy":
          "0000000000000000000000000000000000000000000000000000000000000000",
      "mnemonic":
          "abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon abandon art",
      "passphrase": "TREZOR",
      "seed":
          "bda85446c68413707090a52022edd26a1c9462295029f2e60cd7c4f2bbd3097170af7a4d73245cafa9c3cca8d561a7c3de6f5d4a10be8ed2a5e608d68f92fcc8"
    },
    {
      "entropy":
          "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic":
          "legal winner thank year wave sausage worth useful legal winner thank year wave sausage worth useful legal winner thank year wave sausage worth title",
      "passphrase": "TREZOR",
      "seed":
          "bc09fca1804f7e69da93c2f2028eb238c227f2e9dda30cd63699232578480a4021b146ad717fbb7e451ce9eb835f43620bf5c514db0f8add49f5d121449d3e87"
    },
    {
      "entropy":
          "8080808080808080808080808080808080808080808080808080808080808080",
      "mnemonic":
          "letter advice cage absurd amount doctor acoustic avoid letter advice cage absurd amount doctor acoustic avoid letter advice cage absurd amount doctor acoustic bless",
      "passphrase": "TREZOR",
      "seed":
          "c0c519bd0e91a2ed54357d9d1ebef6f5af218a153624cf4f2da911a0ed8f7a09e2ef61af0aca007096df430022f7a2b6fb91661a9589097069720d015e4e982f"
    },
    {
      "entropy":
          "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
      "mnemonic":
          "zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo zoo vote",
      "passphrase": "TREZOR",
      "seed":
          "dd48c104698c30cfe2b6142103248622fb7bb0ff692eebb00089b32d22484e1613912f0a5b694407be899ffd31ed3992c456cdf60f5d4564b8ba3f05a69890ad"
    },
    {
      "entropy": "77c2b00716cec7213839159e404db50d",
      "mnemonic":
          "jelly better achieve collect unaware mountain thought cargo oxygen act hood bridge",
      "passphrase": "TREZOR",
      "seed":
          "b5b6d0127db1a9d2226af0c3346031d77af31e918dba64287a1b44b8ebf63cdd52676f672a290aae502472cf2d602c051f3e6f18055e84e4c43897fc4e51a6ff"
    },
    {
      "entropy": "b63a9c59a6e641f288ebc103017f1da9f8290b3da6bdef7b",
      "mnemonic":
          "renew stay biology evidence goat welcome casual join adapt armor shuffle fault little machine walk stumble urge swap",
      "passphrase": "TREZOR",
      "seed":
          "9248d83e06f4cd98debf5b6f010542760df925ce46cf38a1bdb4e4de7d21f5c39366941c69e1bdbf2966e0f6e6dbece898a0e2f0a4c2b3e640953dfe8b7bbdc5"
    },
    {
      "entropy":
          "3e141609b97933b66a060dcddc71fad1d91677db872031e85f4c015c5e7e8982",
      "mnemonic":
          "dignity pass list indicate nasty swamp pool script soccer toe leaf photo multiply desk host tomato cradle drill spread actor shine dismiss champion exotic",
      "passphrase": "TREZOR",
      "seed":
          "ff7f3184df8696d8bef94b6c03114dbee0ef89ff938712301d27ed8336ca89ef9635da20af07d4175f2bf5f3de130f39c9d9e8dd0472489c19b1a020a940da67"
    },
    {
      "entropy": "0460ef47585604c5660618db2e6a7e7f",
      "mnemonic":
          "afford alter spike radar gate glance object seek swamp infant panel yellow",
      "passphrase": "TREZOR",
      "seed":
          "65f93a9f36b6c85cbe634ffc1f99f2b82cbb10b31edc7f087b4f6cb9e976e9faf76ff41f8f27c99afdf38f7a303ba1136ee48a4c1e7fcd3dba7aa876113a36e4"
    },
    {
      "entropy": "72f60ebac5dd8add8d2a25a797102c3ce21bc029c200076f",
      "mnemonic":
          "indicate race push merry suffer human cruise dwarf pole review arch keep canvas theme poem divorce alter left",
      "passphrase": "TREZOR",
      "seed":
          "3bbf9daa0dfad8229786ace5ddb4e00fa98a044ae4c4975ffd5e094dba9e0bb289349dbe2091761f30f382d4e35c4a670ee8ab50758d2c55881be69e327117ba"
    },
    {
      "entropy":
          "2c85efc7f24ee4573d2b81a6ec66cee209b2dcbd09d8eddc51e0215b0b68e416",
      "mnemonic":
          "clutch control vehicle tonight unusual clog visa ice plunge glimpse recipe series open hour vintage deposit universe tip job dress radar refuse motion taste",
      "passphrase": "TREZOR",
      "seed":
          "fe908f96f46668b2d5b37d82f558c77ed0d69dd0e7e043a5b0511c48c2f1064694a956f86360c93dd04052a8899497ce9e985ebe0c8c52b955e6ae86d4ff4449"
    },
    {
      "entropy": "eaebabb2383351fd31d703840b32e9e2",
      "mnemonic":
          "turtle front uncle idea crush write shrug there lottery flower risk shell",
      "passphrase": "TREZOR",
      "seed":
          "bdfb76a0759f301b0b899a1e3985227e53b3f51e67e3f2a65363caedf3e32fde42a66c404f18d7b05818c95ef3ca1e5146646856c461c073169467511680876c"
    },
    {
      "entropy": "7ac45cfe7722ee6c7ba84fbc2d5bd61b45cb2fe5eb65aa78",
      "mnemonic":
          "kiss carry display unusual confirm curtain upgrade antique rotate hello void custom frequent obey nut hole price segment",
      "passphrase": "TREZOR",
      "seed":
          "ed56ff6c833c07982eb7119a8f48fd363c4a9b1601cd2de736b01045c5eb8ab4f57b079403485d1c4924f0790dc10a971763337cb9f9c62226f64fff26397c79"
    },
    {
      "entropy":
          "4fa1a8bc3e6d80ee1316050e862c1812031493212b7ec3f3bb1b08f168cabeef",
      "mnemonic":
          "exile ask congress lamp submit jacket era scheme attend cousin alcohol catch course end lucky hurt sentence oven short ball bird grab wing top",
      "passphrase": "TREZOR",
      "seed":
          "095ee6f817b4c2cb30a5a797360a81a40ab0f9a4e25ecd672a3f58a0b5ba0687c096a6b14d2c0deb3bdefce4f61d01ae07417d502429352e27695163f7447a8c"
    },
    {
      "entropy": "18ab19a9f54a9274f03e5209a2ac8a91",
      "mnemonic":
          "board flee heavy tunnel powder denial science ski answer betray cargo cat",
      "passphrase": "TREZOR",
      "seed":
          "6eff1bb21562918509c73cb990260db07c0ce34ff0e3cc4a8cb3276129fbcb300bddfe005831350efd633909f476c45c88253276d9fd0df6ef48609e8bb7dca8"
    },
    {
      "entropy": "18a2e1d81b8ecfb2a333adcb0c17a5b9eb76cc5d05db91a4",
      "mnemonic":
          "board blade invite damage undo sun mimic interest slam gaze truly inherit resist great inject rocket museum chief",
      "passphrase": "TREZOR",
      "seed":
          "f84521c777a13b61564234bf8f8b62b3afce27fc4062b51bb5e62bdfecb23864ee6ecf07c1d5a97c0834307c5c852d8ceb88e7c97923c0a3b496bedd4e5f88a9"
    },
    {
      "entropy":
          "15da872c95a13dd738fbf50e427583ad61f18fd99f628c417a61cf8343c90419",
      "mnemonic":
          "beyond stage sleep clip because twist token leaf atom beauty genius food business side grid unable middle armed observe pair crouch tonight away coconut",
      "passphrase": "TREZOR",
      "seed":
          "b15509eaa2d09d3efd3e006ef42151b30367dc6e3aa5e44caba3fe4d3e352e65101fbdb86a96776b91946ff06f8eac594dc6ee1d3e82a42dfe1b40fef6bcc3fd"
    }
  ],
  "japanese": [
    {
      "entropy": "00000000000000000000000000000000",
      "mnemonic":
          "あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あおぞら",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "a262d6fb6122ecf45be09c50492b31f92e9beb7d9a845987a02cefda57a15f9c467a17872029a9e92299b5cbdf306e3a0ee620245cbd508959b6cb7ca637bd55",
    },
    {
      "entropy": "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic": "そつう　れきだい　ほんやく　わかす　りくつ　ばいか　ろせん　やちん　そつう　れきだい　ほんやく　わかめ",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "aee025cbe6ca256862f889e48110a6a382365142f7d16f2b9545285b3af64e542143a577e9c144e101a6bdca18f8d97ec3366ebf5b088b1c1af9bc31346e60d9",
    },
    {
      "entropy": "80808080808080808080808080808080",
      "mnemonic":
          "そとづら　あまど　おおう　あこがれる　いくぶん　けいけん　あたえる　いよく　そとづら　あまど　おおう　あかちゃん",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "e51736736ebdf77eda23fa17e31475fa1d9509c78f1deb6b4aacfbd760a7e2ad769c714352c95143b5c1241985bcb407df36d64e75dd5a2b78ca5d2ba82a3544",
    },
    {
      "entropy": "ffffffffffffffffffffffffffffffff",
      "mnemonic": "われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　ろんぶん",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "4cd2ef49b479af5e1efbbd1e0bdc117f6a29b1010211df4f78e2ed40082865793e57949236c43b9fe591ec70e5bb4298b8b71dc4b267bb96ed4ed282c8f7761c",
    },
    {
      "entropy": "000000000000000000000000000000000000000000000000",
      "mnemonic":
          "あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あらいぐま",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "d99e8f1ce2d4288d30b9c815ae981edd923c01aa4ffdc5dee1ab5fe0d4a3e13966023324d119105aff266dac32e5cd11431eeca23bbd7202ff423f30d6776d69",
    },
    {
      "entropy": "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic":
          "そつう　れきだい　ほんやく　わかす　りくつ　ばいか　ろせん　やちん　そつう　れきだい　ほんやく　わかす　りくつ　ばいか　ろせん　やちん　そつう　れいぎ",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "eaaf171efa5de4838c758a93d6c86d2677d4ccda4a064a7136344e975f91fe61340ec8a615464b461d67baaf12b62ab5e742f944c7bd4ab6c341fbafba435716",
    },
    {
      "entropy": "808080808080808080808080808080808080808080808080",
      "mnemonic":
          "そとづら　あまど　おおう　あこがれる　いくぶん　けいけん　あたえる　いよく　そとづら　あまど　おおう　あこがれる　いくぶん　けいけん　あたえる　いよく　そとづら　いきなり",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "aec0f8d3167a10683374c222e6e632f2940c0826587ea0a73ac5d0493b6a632590179a6538287641a9fc9df8e6f24e01bf1be548e1f74fd7407ccd72ecebe425",
    },
    {
      "entropy": "ffffffffffffffffffffffffffffffffffffffffffffffff",
      "mnemonic":
          "われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　りんご",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "f0f738128a65b8d1854d68de50ed97ac1831fc3a978c569e415bbcb431a6a671d4377e3b56abd518daa861676c4da75a19ccb41e00c37d086941e471a4374b95",
    },
    {
      "entropy":
          "0000000000000000000000000000000000000000000000000000000000000000",
      "mnemonic":
          "あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　いってい",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "23f500eec4a563bf90cfda87b3e590b211b959985c555d17e88f46f7183590cd5793458b094a4dccc8f05807ec7bd2d19ce269e20568936a751f6f1ec7c14ddd",
    },
    {
      "entropy":
          "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic":
          "そつう　れきだい　ほんやく　わかす　りくつ　ばいか　ろせん　やちん　そつう　れきだい　ほんやく　わかす　りくつ　ばいか　ろせん　やちん　そつう　れきだい　ほんやく　わかす　りくつ　ばいか　ろせん　まんきつ",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "cd354a40aa2e241e8f306b3b752781b70dfd1c69190e510bc1297a9c5738e833bcdc179e81707d57263fb7564466f73d30bf979725ff783fb3eb4baa86560b05",
    },
    {
      "entropy":
          "8080808080808080808080808080808080808080808080808080808080808080",
      "mnemonic":
          "そとづら　あまど　おおう　あこがれる　いくぶん　けいけん　あたえる　いよく　そとづら　あまど　おおう　あこがれる　いくぶん　けいけん　あたえる　いよく　そとづら　あまど　おおう　あこがれる　いくぶん　けいけん　あたえる　うめる",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "6b7cd1b2cdfeeef8615077cadd6a0625f417f287652991c80206dbd82db17bf317d5c50a80bd9edd836b39daa1b6973359944c46d3fcc0129198dc7dc5cd0e68",
    },
    {
      "entropy":
          "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
      "mnemonic":
          "われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　われる　らいう",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "a44ba7054ac2f9226929d56505a51e13acdaa8a9097923ca07ea465c4c7e294c038f3f4e7e4b373726ba0057191aced6e48ac8d183f3a11569c426f0de414623",
    },
    {
      "entropy": "77c2b00716cec7213839159e404db50d",
      "mnemonic": "せまい　うちがわ　あずき　かろう　めずらしい　だんち　ますく　おさめる　ていぼう　あたる　すあな　えしゃく",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "344cef9efc37d0cb36d89def03d09144dd51167923487eec42c487f7428908546fa31a3c26b7391a2b3afe7db81b9f8c5007336b58e269ea0bd10749a87e0193",
    },
    {
      "entropy": "b63a9c59a6e641f288ebc103017f1da9f8290b3da6bdef7b",
      "mnemonic":
          "ぬすむ　ふっかつ　うどん　こうりつ　しつじ　りょうり　おたがい　せもたれ　あつめる　いちりゅう　はんしゃ　ごますり　そんけい　たいちょう　らしんばん　ぶんせき　やすみ　ほいく",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "b14e7d35904cb8569af0d6a016cee7066335a21c1c67891b01b83033cadb3e8a034a726e3909139ecd8b2eb9e9b05245684558f329b38480e262c1d6bc20ecc4",
    },
    {
      "entropy":
          "3e141609b97933b66a060dcddc71fad1d91677db872031e85f4c015c5e7e8982",
      "mnemonic":
          "くのう　てぬぐい　そんかい　すろっと　ちきゅう　ほあん　とさか　はくしゅ　ひびく　みえる　そざい　てんすう　たんぴん　くしょう　すいようび　みけん　きさらぎ　げざん　ふくざつ　あつかう　はやい　くろう　おやゆび　こすう",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "32e78dce2aff5db25aa7a4a32b493b5d10b4089923f3320c8b287a77e512455443298351beb3f7eb2390c4662a2e566eec5217e1a37467af43b46668d515e41b",
    },
    {
      "entropy": "0460ef47585604c5660618db2e6a7e7f",
      "mnemonic": "あみもの　いきおい　ふいうち　にげる　ざんしょ　じかん　ついか　はたん　ほあん　すんぽう　てちがい　わかめ",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "0acf902cd391e30f3f5cb0605d72a4c849342f62bd6a360298c7013d714d7e58ddf9c7fdf141d0949f17a2c9c37ced1d8cb2edabab97c4199b142c829850154b",
    },
    {
      "entropy": "72f60ebac5dd8add8d2a25a797102c3ce21bc029c200076f",
      "mnemonic":
          "すろっと　にくしみ　なやむ　たとえる　へいこう　すくう　きない　けってい　とくべつ　ねっしん　いたみ　せんせい　おくりがな　まかい　とくい　けあな　いきおい　そそぐ",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "9869e220bec09b6f0c0011f46e1f9032b269f096344028f5006a6e69ea5b0b8afabbb6944a23e11ebd021f182dd056d96e4e3657df241ca40babda532d364f73",
    },
    {
      "entropy":
          "2c85efc7f24ee4573d2b81a6ec66cee209b2dcbd09d8eddc51e0215b0b68e416",
      "mnemonic":
          "かほご　きうい　ゆたか　みすえる　もらう　がっこう　よそう　ずっと　ときどき　したうけ　にんか　はっこう　つみき　すうじつ　よけい　くげん　もくてき　まわり　せめる　げざい　にげる　にんたい　たんそく　ほそく",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "713b7e70c9fbc18c831bfd1f03302422822c3727a93a5efb9659bec6ad8d6f2c1b5c8ed8b0b77775feaf606e9d1cc0a84ac416a85514ad59f5541ff5e0382481",
    },
    {
      "entropy": "eaebabb2383351fd31d703840b32e9e2",
      "mnemonic": "めいえん　さのう　めだつ　すてる　きぬごし　ろんぱ　はんこ　まける　たいおう　さかいし　ねんいり　はぶらし",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "06e1d5289a97bcc95cb4a6360719131a786aba057d8efd603a547bd254261c2a97fcd3e8a4e766d5416437e956b388336d36c7ad2dba4ee6796f0249b10ee961",
    },
    {
      "entropy": "7ac45cfe7722ee6c7ba84fbc2d5bd61b45cb2fe5eb65aa78",
      "mnemonic":
          "せんぱい　おしえる　ぐんかん　もらう　きあい　きぼう　やおや　いせえび　のいず　じゅしん　よゆう　きみつ　さといも　ちんもく　ちわわ　しんせいじ　とめる　はちみつ",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "1fef28785d08cbf41d7a20a3a6891043395779ed74503a5652760ee8c24dfe60972105ee71d5168071a35ab7b5bd2f8831f75488078a90f0926c8e9171b2bc4a",
    },
    {
      "entropy":
          "4fa1a8bc3e6d80ee1316050e862c1812031493212b7ec3f3bb1b08f168cabeef",
      "mnemonic":
          "こころ　いどう　きあつ　そうがんきょう　へいあん　せつりつ　ごうせい　はいち　いびき　きこく　あんい　おちつく　きこえる　けんとう　たいこ　すすめる　はっけん　ていど　はんおん　いんさつ　うなぎ　しねま　れいぼう　みつかる",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "43de99b502e152d4c198542624511db3007c8f8f126a30818e856b2d8a20400d29e7a7e3fdd21f909e23be5e3c8d9aee3a739b0b65041ff0b8637276703f65c2",
    },
    {
      "entropy": "18ab19a9f54a9274f03e5209a2ac8a91",
      "mnemonic": "うりきれ　さいせい　じゆう　むろん　とどける　ぐうたら　はいれつ　ひけつ　いずれ　うちあわせ　おさめる　おたく",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "3d711f075ee44d8b535bb4561ad76d7d5350ea0b1f5d2eac054e869ff7963cdce9581097a477d697a2a9433a0c6884bea10a2193647677977c9820dd0921cbde",
    },
    {
      "entropy": "18a2e1d81b8ecfb2a333adcb0c17a5b9eb76cc5d05db91a4",
      "mnemonic":
          "うりきれ　うねる　せっさたくま　きもち　めんきょ　へいたく　たまご　ぜっく　びじゅつかん　さんそ　むせる　せいじ　ねくたい　しはらい　せおう　ねんど　たんまつ　がいけん",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "753ec9e333e616e9471482b4b70a18d413241f1e335c65cd7996f32b66cf95546612c51dcf12ead6f805f9ee3d965846b894ae99b24204954be80810d292fcdd",
    },
    {
      "entropy":
          "15da872c95a13dd738fbf50e427583ad61f18fd99f628c417a61cf8343c90419",
      "mnemonic":
          "うちゅう　ふそく　ひしょ　がちょう　うけもつ　めいそう　みかん　そざい　いばる　うけとる　さんま　さこつ　おうさま　ぱんつ　しひょう　めした　たはつ　いちぶ　つうじょう　てさぎょう　きつね　みすえる　いりぐち　かめれおん",
      "passphrase": "メートルガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "346b7321d8c04f6f37b49fdf062a2fddc8e1bf8f1d33171b65074531ec546d1d3469974beccb1a09263440fc92e1042580a557fdce314e27ee4eabb25fa5e5fe",
    },
    {
      "entropy": "00000000000000000000000000000000",
      "mnemonic":
          "あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あいこくしん　あおぞら",
      "passphrase": "㍍ガバヴァぱばぐゞちぢ十人十色",
      "seed":
          "a262d6fb6122ecf45be09c50492b31f92e9beb7d9a845987a02cefda57a15f9c467a17872029a9e92299b5cbdf306e3a0ee620245cbd508959b6cb7ca637bd55",
    }
  ],
  "spanish": [
    {
      "entropy": "00000000000000000000000000000000",
      "mnemonic":
          "ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco abierto",
      "passphrase": "TREZOR",
      "seed":
          "29a2ee16de47d07025de37e7d9c596869439f9bcd26a702d2bae64db2bf0f68383841c5444b5b3bd39dd720d2ebe59969e110e5955c8e6d32c6c3294fd87439b"
    },
    {
      "entropy": "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic":
          "ligero vista talar yogur venta queso yacer trozo ligero vista talar zafiro",
      "passphrase": "TREZOR",
      "seed":
          "1580aa5d5d67057b3a0a12253c283b93921851555529d0bbe9634349d641029216f791ddce3527819d44d833a0df3500b15fd8ba4cae7ca24e1464b9167de633"
    },
    {
      "entropy": "80808080808080808080808080808080",
      "mnemonic":
          "lino admitir bolero abrir álbum dejar acelga aprender lino admitir bolero abogado",
      "passphrase": "TREZOR",
      "seed":
          "a89366f7f9c4bd98afca8edf1242507506562b8eb8a3a60468cafcb6f3037aba1e4d9a7497f6d49fa94aca87c95703873741441a719325af371f8eda9b59dc83"
    },
    {
      "entropy": "ffffffffffffffffffffffffffffffff",
      "mnemonic":
          "zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo yodo",
      "passphrase": "TREZOR",
      "seed":
          "a9d1f751178872cc53fc5433e9b2a97526448adc4b824cedeadd8a127c2416481345dfbef2bfc78275f3498e40b4e8e2e00560100e543aba3f324e752f032bc9"
    },
    {
      "entropy": "000000000000000000000000000000000000000000000000",
      "mnemonic":
          "ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco afición",
      "passphrase": "TREZOR",
      "seed":
          "6c9f21d46c56f723cd734e308f10ebf44b5b92a2e0d80fd66a2952b8d37af5219e0b93c59e1d8e63b47ac657ec2c524e5fb951d87cac824f84a3ac6264b7aaac"
    },
    {
      "entropy": "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic":
          "ligero vista talar yogur venta queso yacer trozo ligero vista talar yogur venta queso yacer trozo ligero violín",
      "passphrase": "TREZOR",
      "seed":
          "f73b28d7e180e0a92c57276a29489c10a992c8a465ab61be0ade4708543436a682b2a3c22de57c48736ae6f29bebf3e506779c74bc1a835ad6b9f4e174126ca8"
    },
    {
      "entropy": "808080808080808080808080808080808080808080808080",
      "mnemonic":
          "lino admitir bolero abrir álbum dejar acelga aprender lino admitir bolero abrir álbum dejar acelga aprender lino alacrán",
      "passphrase": "TREZOR",
      "seed":
          "f799e5c2782b50d0eb1d25b5f94984c5b4037ade236c6aa3b48b3df01b703d8ede5f94555f4e78f87a642a9676ba052865418c469c5739b3e93acc528fad30b7"
    },
    {
      "entropy": "ffffffffffffffffffffffffffffffffffffffffffffffff",
      "mnemonic":
          "zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo viejo",
      "passphrase": "TREZOR",
      "seed":
          "2fd3964ac77c52232dc0eb2ab237fea2de9b7509005214101ecbbaeb40f34bce7735e848fca6339f76f289904c6db959fa573fc0aa607d969ac256693b4fb7af"
    },
    {
      "entropy":
          "0000000000000000000000000000000000000000000000000000000000000000",
      "mnemonic":
          "ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ábaco ancla",
      "passphrase": "TREZOR",
      "seed":
          "f600536eca941ed937318828e9ebab24b3b571558250e7a8342fc3cf16c458b2d7b36c36155a86cc308f7bef6d87b05d5dbe347f1a83c3dfbabd89e9c45b7883"
    },
    {
      "entropy":
          "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic":
          "ligero vista talar yogur venta queso yacer trozo ligero vista talar yogur venta queso yacer trozo ligero vista talar yogur venta queso yacer teatro",
      "passphrase": "TREZOR",
      "seed":
          "3d2a3aec779195f2628e800879d600cfaf2d7fcfa998657068db53906a00608fcc94fc78ceab8c97d6191389c4e468815ea0d11ffa4280c34c3cf17721a27c73"
    },
    {
      "entropy":
          "8080808080808080808080808080808080808080808080808080808080808080",
      "mnemonic":
          "lino admitir bolero abrir álbum dejar acelga aprender lino admitir bolero abrir álbum dejar acelga aprender lino admitir bolero abrir álbum dejar acelga aumento",
      "passphrase": "TREZOR",
      "seed":
          "dd095dddb50de059f5cb6932d529ad37dd32d40f72da3d0c7671ffc6bd967b4392fe233e5e9a4d9e5e60413160ae215e34375db85e95ccbab4fd4712f32216ab"
    },
    {
      "entropy":
          "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
      "mnemonic":
          "zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo zurdo varón",
      "passphrase": "TREZOR",
      "seed":
          "deea21c6902df5ef4a8efab8e14de53004c68817ea3de421cdd184f4159a6e9947376ed794c3ce67534f37f80b46674e85335555b5c53f44fdfef27991fedc0e"
    },
    {
      "entropy": "f416fbacc5be08253a9e2933d262565f",
      "mnemonic":
          "vaca policía tormenta mecha tambor aroma tonto regla clave morder mula queja",
      "passphrase": "TREZOR",
      "seed":
          "d135c762e9ce02559bc29fa516e3b3262e3961de6abb1e0c88e7fe0259e2d90de768f9771e28e576a7bdad3cd9236e7a830954d95c4812b09b0102edaa93de29"
    },
    {
      "entropy": "37d3e0448a15ed7b261b34e6b4290b003c5a4fa8bb6c86ec",
      "mnemonic":
          "conocer obvio arbusto aseo fuente puesto náusea grave tiburón oferta diablo abierto reír calle olor honor malo gota",
      "passphrase": "TREZOR",
      "seed":
          "b1c297e95aeafea6db7f6b376e4cf8d5d48756cd76dbcfc7be31c1ba59589b042a694fe5b2ce9377d76d197b9fd25d0d7722ee1ec1401c7cfc320089cb1dd0b9"
    },
    {
      "entropy":
          "bb67332fd5b6f187a90eeb198e49e0ea4152b0a48a96890852d5ef6de2a4912b",
      "mnemonic":
          "probar cráneo rodeo parir huida recto optar sultán azafrán índice júpiter seis astilla ficción momia exigir marco deuda pizca sutil sur examen directo glaciar",
      "passphrase": "TREZOR",
      "seed":
          "6080ff649d5db33c46d5969b56879d2c5128113029ad75f42483d54e7acb85c7f94295d442e7a0efff2cd96297a21de27fc2556a0e4424afc3557e86139b79bc"
    },
    {
      "entropy": "6084051230b1624fcb7d9c6873b72060",
      "mnemonic":
          "gajo bolero dinero ganga atento calma celoso pilar guía nulo resina ración",
      "passphrase": "TREZOR",
      "seed":
          "c3718658a301ebf4c52a55338ae1c0af78efffaade6ad79a898cc5746019c48fd9dbc50c86e0dc75bf2fc4a37ae94427f65b40fa435b641f54be3742d58ca6f0"
    },
    {
      "entropy": "6313544091b640192f596982a781b2eeab8dc64d626383c4",
      "mnemonic":
          "gente nieto aprobar brusco giro ancho puerta cazo lluvia cuchara historia sujeto porción tecla cojín enchufe lonja calcio",
      "passphrase": "TREZOR",
      "seed":
          "6c5cfb44e0f026b3af4f83c30cebe752984cb71e4e9929bc92b24f8c4e260de7fa4a0fca69eab4a44edcde3ef37e39eba037ce0ea0e7697d53671b6e6eb716dc"
    },
    {
      "entropy":
          "1aef3c27b3b5bcf20e9f0bf49d92dfc69d574cb5f0eaf765c2b6089ddde96f66",
      "mnemonic":
          "bajar laguna almíbar grúa foca labio crimen taquilla vago trabajo pollo merengue señal orquesta siglo baúl venda célula payaso arbusto suplir vaina puesto radical",
      "passphrase": "TREZOR",
      "seed":
          "7e5a2e4ce8580f7e001c5080863bc71449a02b560fc543ab820e6df72dad6ef12643fb5154a137a77f2e900636b1c772838d226ddfc15e4d3fdd38847ccd3a67"
    },
    {
      "entropy": "72a23bb48467c096412d00a350074938",
      "mnemonic":
          "informe arduo traje aleta lavar eludir aéreo octavo onda lindo sangre idioma",
      "passphrase": "TREZOR",
      "seed":
          "b82e20496dcdceb28a86db48b519714b54ce917ba677f54811d036edf4b4a5257e7e120efea0d85b25eb40bd4e18e3db6e0c2156740623d0a66952a7d1fd6f05"
    },
    {
      "entropy": "7a1c0c033b9e9448708506ab50769894d6a0ceeda28a7abb",
      "mnemonic":
          "laico tamaño aborto jugador toalla bufanda raspa odio pared lomo oro caña hallar grúa pluma eterno lancha simio",
      "passphrase": "TREZOR",
      "seed":
          "6fbd5cfc3a7ea4232ddc2274741940235d4675375c25e6a231b826e279dc85d77649a80a2a8e529a65802820c385460bbe92370874fddf9e67e2a22d4e181422"
    },
    {
      "entropy":
          "4693e2884e6577ff866f25aefd9d57d8c5ef3a43a0e9d81b4fa18f1cb0e631c9",
      "mnemonic":
          "dorso obvio ojo nuca fértil zumo azar tener pelea tráfico farsa persona fuerza nudo anuncio batuta sílaba solución tipo bestia ritmo inmenso renta crear",
      "passphrase": "TREZOR",
      "seed":
          "3140c5d45ad0a1a0e031384c6f7a2b52d2be3b86906f4e1d9c1d99c0fa672f6436e665d7f62024c2ad585468c96291dd17f6f9ed118091cbc6ee18e570cb43b9"
    },
    {
      "entropy": "9569ffdfdff30804ae91028fd7850c11",
      "mnemonic":
          "mujer espada venta química chivo aceptar premio bolsa minuto prole diamante brazo",
      "passphrase": "TREZOR",
      "seed":
          "e52fabcb20d2daa61f310f4e3151aef605581c21d4259f79e98974b913bf374fc735694863ee46a22d3c4e0e0553d11ee77d31fb634a420b6ef2040bdd09d75c"
    },
    {
      "entropy": "84d521ff89fa458afb411a49f30833c14746e02026e21823",
      "mnemonic":
          "lupa palabra limpio ascenso óptica rehén trago bruja eje natural andar llover iris hurto lino subir avance babor",
      "passphrase": "TREZOR",
      "seed":
          "f66995ffef09b95de41240ad8214306f5d6bbd2045c79ad61ce233ddc8a46a095d3d1ac3831fea1803578ea19bb893bd5d0e51d263cdef43528947896abfe429"
    },
    {
      "entropy":
          "b84413a0f6686d6ee4de464edf43e9619ede86dc2e8155fed9fc756e47acf021",
      "mnemonic":
          "pomelo bondad tío traer malla poesía morro retrato erizo vidrio viernes recaer trébol dibujo iglesia sacar farsa vela lidiar toque tenaz servir rabo cuento",
      "passphrase": "TREZOR",
      "seed":
          "13affea09a4b653a64894407ed63350f5cddfbe21013e2c1d0dc19ca63e7b1d9e6b711f6deaf4a24729523e89838bfeb3ebe0eaa0a48aa7f2acd2fe58f2aacb6"
    }
  ],
  "chinese_simplified": [
    {
      "entropy": "00000000000000000000000000000000",
      "mnemonic": "的 的 的 的 的 的 的 的 的 的 的 在",
      "passphrase": "TREZOR",
      "seed":
          "7f7c7f91ef81f0fb6a3b95b346c50e6472c1d554f8ba90637bad8afce4a4de87c322c1acafa2f6f5e9a8f9b2d2c40e9d389efdc2adbe4445c21a0939fb39e91f"
    },
    {
      "entropy": "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic": "枪 疫 霉 尝 俩 闹 饿 贤 枪 疫 霉 卿",
      "passphrase": "TREZOR",
      "seed":
          "816a69d6866891b246b4d33f54d6d2be624470141754396205d039bdd8003949fec4340253dde4c8e11437a181ad992f56d5b976eb9fbe48f4c5e5fec60a27e1"
    },
    {
      "entropy": "80808080808080808080808080808080",
      "mnemonic": "壤 对 据 人 三 谈 我 表 壤 对 据 不",
      "passphrase": "TREZOR",
      "seed":
          "07b6eada2601141ef9748bdf5af296a134f0f9215a946813b84338dcfba93c8247b0c3429a91e0a1b85a93bd9f1275a9524acecadc9b516c3cf4c8990f44052c"
    },
    {
      "entropy": "ffffffffffffffffffffffffffffffff",
      "mnemonic": "歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 逻",
      "passphrase": "TREZOR",
      "seed":
          "08ac5d9bed9441013b32bc317aaddeb8310011f219b48239faa4adeeb8b79cb0a3e4d1cb460d2dd37888c0a19bef6edd90ced0fd613d48899eab9ee649d77fcd"
    },
    {
      "entropy": "000000000000000000000000000000000000000000000000",
      "mnemonic": "的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 动",
      "passphrase": "TREZOR",
      "seed":
          "b8fb8047e84951d846dbfbbce3edd0c9e316dc40f35b39f03a837db85f5587ac209088e883b5d924a0a43ad154a636fb65df28fdae821226f0f014a49e773356"
    },
    {
      "entropy": "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic": "枪 疫 霉 尝 俩 闹 饿 贤 枪 疫 霉 尝 俩 闹 饿 贤 枪 殿",
      "passphrase": "TREZOR",
      "seed":
          "74187bbdce2dba25eed3b9aebdc65dcb7c61e74c58591451d47f9c7b7b17545a527880640bfb9cab36989eba1edddf57bfce7340697926de7f0b9ec1e0345c38"
    },
    {
      "entropy": "808080808080808080808080808080808080808080808080",
      "mnemonic": "壤 对 据 人 三 谈 我 表 壤 对 据 人 三 谈 我 表 壤 民",
      "passphrase": "TREZOR",
      "seed":
          "e3629a601f4b87101c4bb36496e3dbd146063351f5e47c048211faddab78efdb91910f0eea5c8e53cfb851aa3e156b0bb5c501b83baaf5f5d4a1679a5bb7d885"
    },
    {
      "entropy": "ffffffffffffffffffffffffffffffffffffffffffffffff",
      "mnemonic": "歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 裕",
      "passphrase": "TREZOR",
      "seed":
          "013c8d6868537176fac7bfa966e6219830008f03b650b0f18a12fd67d9ebf871c400c5f980aa073ddd1b23d60846e357aee193ce7644b574bf65e04cf913e39c"
    },
    {
      "entropy":
          "0000000000000000000000000000000000000000000000000000000000000000",
      "mnemonic": "的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 性",
      "passphrase": "TREZOR",
      "seed":
          "1981c3e3ddfd80f6e9ee1c5ef27ba2697df3d1468496f1d56ae3d8e0b3f0677bbbdfca954e48eb86fe6a36fc0f597bf18ea00248757a01e82182badff94abbbd"
    },
    {
      "entropy":
          "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic": "枪 疫 霉 尝 俩 闹 饿 贤 枪 疫 霉 尝 俩 闹 饿 贤 枪 疫 霉 尝 俩 闹 饿 搭",
      "passphrase": "TREZOR",
      "seed":
          "b1eb831927f1c488e233725f9c409dd9bdb9342324393fa56d958e8842623d222510c322f5ba2899428ae08ece8bd87788748c67bdfa73588669ab816c5f3555"
    },
    {
      "entropy":
          "8080808080808080808080808080808080808080808080808080808080808080",
      "mnemonic": "壤 对 据 人 三 谈 我 表 壤 对 据 人 三 谈 我 表 壤 对 据 人 三 谈 我 五",
      "passphrase": "TREZOR",
      "seed":
          "470e61f7e976fa18c7d559e842ba7f39849b2f72ef15428f4276c5160002f36416cd22c2a86bb686d69f6b91818538aa57ae1aab27b3181b92132c59be2b329b"
    },
    {
      "entropy":
          "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
      "mnemonic": "歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 佳",
      "passphrase": "TREZOR",
      "seed":
          "8e6607a07fa664d6e4ead23fcc08caf72216d6f078c3b2e5be94e4b6e8d64c784d36bf9b70144fa05840e9a49899128111be5093a2b552b6ab76c0906e9b0e65"
    },
    {
      "entropy": "c0efbcd9612edcad99245ecb363322bd",
      "mnemonic": "疗 录 府 巩 宴 突 获 托 貌 扫 侦 滑",
      "passphrase": "TREZOR",
      "seed":
          "ceb738a8a27dca2ed3178f70b0c21080fa1691a1433e0dc84fa61a51e36665320c43938141a8c9b78e74fb64328d3fe92cfd8a8bb34600c4495896c604964197"
    },
    {
      "entropy": "a7ef6e11f6ec3ca7466736dc38f4fe37c41135d3a275db05",
      "mnemonic": "壮 航 梁 宴 租 令 设 坯 仔 乃 讲 肉 含 亿 功 巴 奉 传",
      "passphrase": "TREZOR",
      "seed":
          "d09af87910d5c8a1aac83ad8121d437556ea31ba8b9292feb4b4a5b5d0aa10fda060c2edbd2a47da8aae6bacaa92f398ca1250046f86368b8478c3152f20bc59"
    },
    {
      "entropy":
          "9aed456ffcd8f33cd1f92085d994bda9b87ecdcb5a439844ace981d59fb59c63",
      "mnemonic": "亿 丰 哪 档 贯 厘 章 油 洗 署 越 承 亦 沙 步 续 岸 权 层 出 苦 番 振 顾",
      "passphrase": "TREZOR",
      "seed":
          "ef27c5937fd39c16a4d17d8a213e2a8cc59f7897649194d3342d852251a94b51a365f87656b215f11582ff16e5b6c6ab44bfe2ccdea7b70ef0667a8b75d147f2"
    },
    {
      "entropy": "2311a61b3dcf936c5b2b9934c24f4c5a",
      "mnemonic": "压 痛 忙 怀 熊 芽 松 座 劳 么 鸟 渡",
      "passphrase": "TREZOR",
      "seed":
          "710cb6122d448dace5b317078bee195185949fc73eead9e2aabda368c77931265947e53e9e1feae584dadfc6eb190e1ff9e3989e7eab4f1c8cf996d358997452"
    },
    {
      "entropy": "d809f511bccc493d4137ad97884ef6b1f11bfe648363c274",
      "mnemonic": "蒋 升 材 川 丙 芳 年 惠 昌 氧 郑 误 反 妨 遭 脸 挤 磷",
      "passphrase": "TREZOR",
      "seed":
          "58c446cdd64bd5281f20fa9ceb1ba1d14c419b4b9cb53ad05bb0b78b5a4dd9b09d2c244afec422dd409cfcc93d6c7fe92f9bd75eab5e73c93d820029c185889f"
    },
    {
      "entropy":
          "e2bfae0b5a37ac7221e7dbaa28698efeffc57a782d87f724585c46f5ca4d16f4",
      "mnemonic": "叹 钩 湿 寄 探 查 圈 摊 震 帮 急 饿 堵 铺 脏 丽 罩 导 直 君 央 更 云 瓦",
      "passphrase": "TREZOR",
      "seed":
          "00839105562ad75509fa005740d2236900ffaab1414c859182cfefa7258e1828f8bfb0950afc54d5eaf918c3f810dba5d0509b92f037acc143766bee15999456"
    },
    {
      "entropy": "1552d414c0518cbecea070662c38b411",
      "mnemonic": "无 禁 工 碳 文 游 片 些 渐 银 传 世",
      "passphrase": "TREZOR",
      "seed":
          "70e18a112e798b38bc07aa08846d80165300c619cb7bf676e02d3f3c2c252cbb76d3ade112a636dc1937ea69ce7db6ece10c8b31939f198c9566dff23b098b51"
    },
    {
      "entropy": "cb01fc0b20300bfd90579b9cdf25231b3d1a9d7d163a3e6b",
      "mnemonic": "浙 全 用 罪 了 彭 望 骑 洪 熊 试 称 庙 巴 咨 隙 液 味",
      "passphrase": "TREZOR",
      "seed":
          "5e36b0cfa228e4ed95793203d2c333ddb897250310f69935339bd4b3b0c079a680eeeaa97de0a2066edfde7fc9e6388f39164ee17f42a731d3abf43916763cad"
    },
    {
      "entropy":
          "d5b6633124ed01c4c32f5c31466329e4b26b6b6606468d18bde0be6b4dd9d407",
      "mnemonic": "劝 灾 辈 足 蚀 症 把 飘 际 技 逆 狂 单 爹 嘴 悬 尚 簧 额 归 渡 雅 初 昨",
      "passphrase": "TREZOR",
      "seed":
          "671e44da849a94c4e3c05d5502e5dcd50295143e246d6147e418cfc5de15c3634aaf67157a56fab5415f731e3292c854e3b09682369ee7116c4ee389c3d67b8a"
    },
    {
      "entropy": "6218bd1694357fcd31be062010707fd8",
      "mnemonic": "挥 簧 溶 真 绝 凸 辉 喂 取 筑 任 袋",
      "passphrase": "TREZOR",
      "seed":
          "9eaeb66494ffe45f3fdd6840e524c1a0a2f5402430361755949aa024afa0156391e3e4d810c9d13be8d93021fc3bdb78825081387b69e3f6d4287b78f4d598ff"
    },
    {
      "entropy": "d90242a4d3f0cb94b48f20900a70404d282f4b162af38838",
      "mnemonic": "辑 看 窗 壮 把 赏 摄 坑 宝 独 表 扎 暗 朋 协 室 篇 吊",
      "passphrase": "TREZOR",
      "seed":
          "988b6056c8f7ba65b06e1a3835eb19a006c3f0bc3238a776847756cdd78ba482e1d342aa7f150a6ecc389e8d8a371e8764e992a8611fd4324a766b953f54791c"
    },
    {
      "entropy":
          "f68fb4db033d94e7e3b844c5e1900aca5a5a7ca6558addbeea4f97ee3a25131d",
      "mnemonic": "剑 康 精 而 雕 娘 暴 等 簧 去 来 闭 淡 底 奴 挖 骗 霍 宋 影 锥 利 故 梅",
      "passphrase": "TREZOR",
      "seed":
          "09e546e41625a1dcdda4ff80620b59641e1e3dbcfedcf014fae2cca5635c787f9d37d22c87ea03642982ab624ba999606c0ba026e6059402c136bd69442f601d"
    }
  ],
  "chinese_traditional": [
    {
      "entropy": "00000000000000000000000000000000",
      "mnemonic": "的 的 的 的 的 的 的 的 的 的 的 在",
      "passphrase": "TREZOR",
      "seed":
          "7f7c7f91ef81f0fb6a3b95b346c50e6472c1d554f8ba90637bad8afce4a4de87c322c1acafa2f6f5e9a8f9b2d2c40e9d389efdc2adbe4445c21a0939fb39e91f"
    },
    {
      "entropy": "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic": "槍 疫 黴 嘗 倆 鬧 餓 賢 槍 疫 黴 卿",
      "passphrase": "TREZOR",
      "seed":
          "f38af46f6bc3222b0f5aa14dd5b8b506e51131510f2450ec9fb52c28617cfa59d436055fe542e25dfa01415639d2171e41796f169f8bbc18516941dfdee8fb72"
    },
    {
      "entropy": "80808080808080808080808080808080",
      "mnemonic": "壤 對 據 人 三 談 我 表 壤 對 據 不",
      "passphrase": "TREZOR",
      "seed":
          "33f373da1a6b4300dad5cc70d2329ed614512e3c8a423673c294110521326ca66753b9663bdd7c844f17d81609a410a61809dd5113823009f729e2f2f940cab9"
    },
    {
      "entropy": "ffffffffffffffffffffffffffffffff",
      "mnemonic": "歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 邏",
      "passphrase": "TREZOR",
      "seed":
          "cfd5f4fa6f2a422811951739b1dad9f5291f9cbc977a14ae9dd35dc8ab17aeec9ee6f1455b20f881838f4f945850765dd002a9abcdbe7be002ffcdaf6f63fdaa"
    },
    {
      "entropy": "000000000000000000000000000000000000000000000000",
      "mnemonic": "的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 動",
      "passphrase": "TREZOR",
      "seed":
          "717f4f70c7550da57e42c6b49ac47b5bad3249605ed2f869900596c2de7653a8528380e5c31709ed9c2d19b868bc530158712e97276886b4863d036177bcab33"
    },
    {
      "entropy": "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic": "槍 疫 黴 嘗 倆 鬧 餓 賢 槍 疫 黴 嘗 倆 鬧 餓 賢 槍 殿",
      "passphrase": "TREZOR",
      "seed":
          "2b219a8be0a8e27a6b50d0a74eb42175bd23e22cf4081518c9a74cbfe2cbace46f0adad8d390f8a2ac30feb26226db14fbc545d18ba0e56a853cbf103c92539e"
    },
    {
      "entropy": "808080808080808080808080808080808080808080808080",
      "mnemonic": "壤 對 據 人 三 談 我 表 壤 對 據 人 三 談 我 表 壤 民",
      "passphrase": "TREZOR",
      "seed":
          "d29225f73231521784d98820ebf0ae4d827c5a9e0c0f8845fd63866cdc70b3a40a2281f3f6c6181c5a53e440528dbf83947a4b2056749cb9cc9c83dcd5c91b0f"
    },
    {
      "entropy": "ffffffffffffffffffffffffffffffffffffffffffffffff",
      "mnemonic": "歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 裕",
      "passphrase": "TREZOR",
      "seed":
          "013c8d6868537176fac7bfa966e6219830008f03b650b0f18a12fd67d9ebf871c400c5f980aa073ddd1b23d60846e357aee193ce7644b574bf65e04cf913e39c"
    },
    {
      "entropy":
          "0000000000000000000000000000000000000000000000000000000000000000",
      "mnemonic": "的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 的 性",
      "passphrase": "TREZOR",
      "seed":
          "1981c3e3ddfd80f6e9ee1c5ef27ba2697df3d1468496f1d56ae3d8e0b3f0677bbbdfca954e48eb86fe6a36fc0f597bf18ea00248757a01e82182badff94abbbd"
    },
    {
      "entropy":
          "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic": "槍 疫 黴 嘗 倆 鬧 餓 賢 槍 疫 黴 嘗 倆 鬧 餓 賢 槍 疫 黴 嘗 倆 鬧 餓 搭",
      "passphrase": "TREZOR",
      "seed":
          "fd50ad67903b2046356e67e55d67309b6f0ccd7c23bfefd049a5b8a40d56c507d73a5517e2d2785f024a7794854594aaad845dd0fbd0432c25a96f2a7181a2cc"
    },
    {
      "entropy":
          "8080808080808080808080808080808080808080808080808080808080808080",
      "mnemonic": "壤 對 據 人 三 談 我 表 壤 對 據 人 三 談 我 表 壤 對 據 人 三 談 我 五",
      "passphrase": "TREZOR",
      "seed":
          "d029fc9737b801cb4f9aadf5feed02a117b76ead7058e055cc39cb44864023eb492e6a15c68569d6a03a5b11bf15a456c64e1781a553589b47ab569801239a00"
    },
    {
      "entropy":
          "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
      "mnemonic": "歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 歇 佳",
      "passphrase": "TREZOR",
      "seed":
          "8e6607a07fa664d6e4ead23fcc08caf72216d6f078c3b2e5be94e4b6e8d64c784d36bf9b70144fa05840e9a49899128111be5093a2b552b6ab76c0906e9b0e65"
    },
    {
      "entropy": "dfef8d52b9a0a958768fbd0cb7896ed3",
      "mnemonic": "桑 途 微 居 物 竹 咬 蒼 把 悲 村 泵",
      "passphrase": "TREZOR",
      "seed":
          "0a99b84f21ac72782078381abada2978b4045b94ad066320ba01607d20fb89fe95d9e320737454b2317bf6fe332b5592fb662446bbb144f46bed977c8121b27e"
    },
    {
      "entropy": "c3a10c1c8eebb4b04ed9f28925d4adc38f6533b23b76a858",
      "mnemonic": "磚 著 學 農 訊 塊 京 底 迎 林 張 獻 窩 夥 掘 皇 虛 暫",
      "passphrase": "TREZOR",
      "seed":
          "b64a979bfcd68bd09175aa347851a21e405bb71e4638e53bdecc12e9e9df0dbca80e90e4392434ddb5156b0b39dda8e9713ab754b4b16712f8737d5208f667eb"
    },
    {
      "entropy":
          "7c61375b499f6d2a9647fe2fc0f00a3ca2363a58e2aef1766e4e1e086fedf0f3",
      "mnemonic": "途 化 埋 男 堡 鍋 陳 矮 影 民 時 宗 金 角 啊 益 貪 苯 紛 包 銅 潑 租 阻",
      "passphrase": "TREZOR",
      "seed":
          "371b3edce6e703dd813667e7ff25573f3c2c0ee67934552cd3c713443c5b159a6d16d0c175e0ff17d0feca92c797c00afb2fa5366fbdc9dcec86599ecb1d350c"
    },
    {
      "entropy": "1782d8f3c97b173004181f45f4d2a141",
      "mnemonic": "展 並 照 隔 鏈 嘴 與 分 止 顏 虛 折",
      "passphrase": "TREZOR",
      "seed":
          "2a27c7b1d18ac5b9ac4632980630bbccba21b89beca51c7ed5a9866d6a1c7dcb60ad2c19f0d20d826ce204a90af1c826c64d6d5254344d7756f92b5c7445c221"
    },
    {
      "entropy": "5bbb470d4203c3f48ed4aba01a6fef14a78b33e0a9c88d8a",
      "mnemonic": "村 咬 吉 塔 火 徙 廠 救 貢 眉 屏 達 齊 恢 麥 查 奮 倒",
      "passphrase": "TREZOR",
      "seed":
          "d86b3724047047a4a6adcc781a29951a0f4796fc1ad01907b61c40c80405d4b183ec03d0a7f41d2ab22dd792145684fa735da8d883ab4119f8b80d3a33bc47fa"
    },
    {
      "entropy":
          "f5eebef6e6c7b6a247f349bebbeff0abd24667f7f9f771561ec8452f84b812b6",
      "mnemonic": "佳 陸 鄭 峽 航 換 則 煤 猛 脹 蔡 冷 極 習 桑 病 套 麗 污 旗 砍 既 黑 掘",
      "passphrase": "TREZOR",
      "seed":
          "fbe0d8d0977296a99c5c293d73031f1a486d6ba1bb495cab8e36b2a86c9fa52472dbe1f24359763f447e4f99afde31ac801691d3b72ed9b08044ed678144cf1f"
    },
    {
      "entropy": "7df55de1f2b327197228db5e79b395ad",
      "mnemonic": "錄 描 紹 膨 礦 纖 偵 少 室 峽 膨 雲",
      "passphrase": "TREZOR",
      "seed":
          "c7219ceadf06eb176867805c8466e8e0714ae449611e636fb948a699a9e2cde169796af12e8cfa49135ea89d16c04993d66dc9b7f68f2c9c3c7ca17dc05e7331"
    },
    {
      "entropy": "660b55f6ea13b1403b1731a78541b27a672e07fded7df856",
      "mnemonic": "父 靠 康 韓 狀 貢 烷 枯 授 報 喜 悟 銷 分 蒼 墨 砍 爹",
      "passphrase": "TREZOR",
      "seed":
          "3a3c77105fb629ec95598820b4ce6a74cde70aa75800e96cca5b317fa5b275139598603453e5281412005baad4fe2c7e715a7d5a1e9e9e5edb5e297df25f608c"
    },
    {
      "entropy":
          "9f2c7ca7c278759f42bdcf6e9e11a71e7aae1c5990cc88432e10e4407b721fec",
      "mnemonic": "盪 誤 聲 卡 予 芯 加 撥 倍 丟 介 照 描 然 血 設 陣 活 奇 皆 得 銳 幅 避",
      "passphrase": "TREZOR",
      "seed":
          "f194055014a520870292805fd8f6bc40e61dd07847f6be8f66adcdde59273e93e5d088dcf3949d968e466278bf4716a3c9ab1a698a29eb8045bfdc4a17b633da"
    },
    {
      "entropy": "bb8ef0a7e4c7c8b77752f89067d4aaa4",
      "mnemonic": "碧 哥 聲 鎖 滅 村 悄 侵 聞 德 離 護",
      "passphrase": "TREZOR",
      "seed":
          "6b30c02093ddcc4f5e5948cce93cec16d1c42a8826c19c84317dc00b54d416375ecb1f1be162e73bce20548fe5f99f7c36042f2888741603a4b20f68afe1f44c"
    },
    {
      "entropy": "eadccaf306837e81a5023314721fd2272f3c99c255d0cd8a",
      "mnemonic": "闢 冊 票 應 寫 呢 玻 均 結 冬 駕 漢 叢 送 裡 忠 峽 古",
      "passphrase": "TREZOR",
      "seed":
          "262d06323c214d94e7d57a4bcbfeaf597be13b1c1bfd821382209e84b93d77c4b1c0e2a2b6cbbe655f9c76356358ad13a912faa5f80f12271a77b459f839ff21"
    },
    {
      "entropy":
          "506b949cea00ddfa24bda1fc9a62c391f15ed00901358ac38cae518150413c12",
      "mnemonic": "考 央 白 硝 由 萊 隔 智 皺 鳥 麗 階 者 燃 油 單 館 組 信 健 月 南 葡 策",
      "passphrase": "TREZOR",
      "seed":
          "004cb71aeb8e34789dfca9265842361e6e19e756c09db329ce1606c0096fb357420fd15d47d82bf2c788a0d4a04a3d263f66c8dc0e72dfa058c883b83c80ceb6"
    }
  ],
  "french": [
    {
      "entropy": "00000000000000000000000000000000",
      "mnemonic":
          "abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abeille",
      "passphrase": "TREZOR",
      "seed":
          "3bf3366c40256d7e2fca716fddf8673425c7c7e444af290ee1edf1bbf095e6e78a7190253f3e46f1e2069345d4b05ac17b242faa225c0a3e4d268976744e0698"
    },
    {
      "entropy": "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic":
          "implorer visage sonnette voyage véloce pourpre volaille tribunal implorer visage sonnette voyelle",
      "passphrase": "TREZOR",
      "seed":
          "ab9180b7dfdde74e5cf8781e5692e2c0b55afa8bc1987fa8e14e3fb83c88b195c53e9f939f8febc33d2958f5fcd8add57843cb318d8886130ef9c9879c826357"
    },
    {
      "entropy": "80808080808080808080808080808080",
      "mnemonic":
          "indexer acompte bolide abrasif agréable dédale abusif appuyer indexer acompte bolide abolir",
      "passphrase": "TREZOR",
      "seed":
          "0c1ece83a464688d74744723d609e30e191d05ab8c082cf34bb2405bc4363dbcf6a9f83707b577d230728b3943920f876ec844e86dd0d117152c23802d25be3f"
    },
    {
      "entropy": "ffffffffffffffffffffffffffffffff",
      "mnemonic":
          "zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie voter",
      "passphrase": "TREZOR",
      "seed":
          "7d2f168ce71ba3e40e74baf47a072a94e49973c0dbdb33a62b3a285ab167c704a85d6ce0d15cc6a4dd3bf1311334ee0d290ae7d20115863d5f5633b8dfacf2d4"
    },
    {
      "entropy": "000000000000000000000000000000000000000000000000",
      "mnemonic":
          "abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser adéquat",
      "passphrase": "TREZOR",
      "seed":
          "93d81d146eccb7c624cc25daa4cd52736d64bdc0fe020940157e73c108a87ee34d94d7e9554e02ea0f9a7ea5574426220bae7c4959c197a6c9e2318cb252683c"
    },
    {
      "entropy": "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic":
          "implorer visage sonnette voyage véloce pourpre volaille tribunal implorer visage sonnette voyage véloce pourpre volaille tribunal implorer vinaigre",
      "passphrase": "TREZOR",
      "seed":
          "dcf42783150cdb92672c9ea7d13f145401661f10b89bfb012a803ca7713e97181ee28ac327a982060a7f8aaa6e8c649ca2c5b83c24458393fe41739ced31d987"
    },
    {
      "entropy": "808080808080808080808080808080808080808080808080",
      "mnemonic":
          "indexer acompte bolide abrasif agréable dédale abusif appuyer indexer acompte bolide abrasif agréable dédale abusif appuyer indexer agencer",
      "passphrase": "TREZOR",
      "seed":
          "b039606212ccadb0d05c7a0c08605c5137028d0253d26b9ad6ee113f9595700d9834b2eec8b224975a6d9585d7ad39e962036edcf07d5b125b0fc225d519982f"
    },
    {
      "entropy": "ffffffffffffffffffffffffffffffffffffffffffffffff",
      "mnemonic":
          "zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie viande",
      "passphrase": "TREZOR",
      "seed":
          "e12d20a535ef5e9e2f87e05b5261bdb51451e052fe484feb87543f5cb7a8822c4aa0152492be1259fba00a28c1e95518a90f0645bdd0eb822516d37ac881f7e0"
    },
    {
      "entropy":
          "0000000000000000000000000000000000000000000000000000000000000000",
      "mnemonic":
          "abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser abaisser anaphore",
      "passphrase": "TREZOR",
      "seed":
          "0f3eec3279b55f3cacdbf1aef705a086078d7eb8048e402202572e7038e9487e39104b4794e88a42192af030a176b034fa36ca6641fb8128fd23c30806b96c23"
    },
    {
      "entropy":
          "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic":
          "implorer visage sonnette voyage véloce pourpre volaille tribunal implorer visage sonnette voyage véloce pourpre volaille tribunal implorer visage sonnette voyage véloce pourpre volaille studieux",
      "passphrase": "TREZOR",
      "seed":
          "8f12b35fe92a7586dfbdab9721a91300d0dbe3185d0943021667e62fd5a643e0cf2443e544738c5234009aa50faac0dbb123ac847c31dc25d875c56fe39c6186"
    },
    {
      "entropy":
          "8080808080808080808080808080808080808080808080808080808080808080",
      "mnemonic":
          "indexer acompte bolide abrasif agréable dédale abusif appuyer indexer acompte bolide abrasif agréable dédale abusif appuyer indexer acompte bolide abrasif agréable dédale abusif axiome",
      "passphrase": "TREZOR",
      "seed":
          "53ab1d10dc8de3a80171b5f00495a3b49e2c5afd486f8111b1afd0ad24f43eb0aab4acab1d4c51126beea32405947924c237157b29dca69fcf64eb635708895f"
    },
    {
      "entropy":
          "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
      "mnemonic":
          "zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie zoologie valable",
      "passphrase": "TREZOR",
      "seed":
          "b5e96f552ba44ec827c1bc5ef362e8cea68dd6f36f2c8640aeb171cf9b66198fbdf155fdbcf7dc505431068f972a92442f33cda0065afc1e9a7f5f7097ea6c6a"
    },
    {
      "entropy": "eef72543afbc98a56b8dc19c0024187b",
      "mnemonic":
          "train pierre éluder excuse refaire encadrer orifice phobie million abreuver adresse vecteur",
      "passphrase": "TREZOR",
      "seed":
          "89975a6460dd1449e36b5a4f77053dac3f94885933084b3ecb653795b8db1890ef7e2f1e041b1f25c1d935b8a9985968804b2ec322f06271e18954b6bd176460"
    },
    {
      "entropy": "0c137769b673be79e25d917361a3a83bf3f9286203c86c63",
      "mnemonic":
          "amour mignon sensible frère cruel cultiver kayak papyrus gomme anatomie terne habitude déchirer mairie jovial hasard freiner bavarder",
      "passphrase": "TREZOR",
      "seed":
          "1e288ab9f4fd885a6b5fe678ea404858fa048ac8b10061facb5c1a249903ac76f712ee69df153eae4a29dcffba325c94feb658f39326298f959efc0113a8dd7c"
    },
    {
      "entropy":
          "7d936ea857f06257e7e625adeb1bb4295ca704ef6412b53dd9907e69d621c23e",
      "mnemonic":
          "hymne microbe octupler oxyde adroit cédille moufle punitif organe épuisant tordre encadrer réglage innocent pollen injure pélican trahir favori viticole mobile argent ajouter prétexte",
      "passphrase": "TREZOR",
      "seed":
          "ed541806471483319c877aef884bb9e27f2dff383c0d4b0c521e748010a1f5c7ce870da272b09fa0b2bfa59772dce4fe444ef7a59e2ab8d575fb81b581d78ed5"
    },
    {
      "entropy": "6dc310a08e2f4c1452114ecaf79d2912",
      "mnemonic":
          "frontal balcon camion besogne utile alliage dogme carabine rejouer poirier double bronzer",
      "passphrase": "TREZOR",
      "seed":
          "d41dc9f2316e787679fcbd933b9762cf5595ee3c4319d015d1503cf431db00c3b3c0c7c9d6acecdee583b6b67478837b105b02df03d75294b2d84108df8a2b48"
    },
    {
      "entropy": "eac1c70f1db2d2c68c829b3187177056986d1d843ef632a6",
      "mnemonic":
          "thérapie annuel psychose croire cerner fasciner citerne endroit cintrer cosmique sextuple optique jetable limer argent soleil clameur cobra",
      "passphrase": "TREZOR",
      "seed":
          "f3900473db019a0f089f51381424a9c3934198cf6dd7c955078f0cc83a6e1a482dd0e889f61b50874bc3ca2e9725da641e34634b00141d491b3f9d4354143060"
    },
    {
      "entropy":
          "6d06fcbaea98b52ded97b0419b0baa0d606c00a0644f1fa1d50fa4408721ccb3",
      "mnemonic":
          "friable corbeau chausson salade lanceur mascotte pépite valise déjeuner scrutin thème batterie affaire abdiquer informer labial bobard anormal désert domaine aiguille lombric claquer graduel",
      "passphrase": "TREZOR",
      "seed":
          "495fa440888a2c3e305479fe07fa3312b249b5a45ee4decbc06e5df10f3dfff33d803f09b7650465cc9389d73977923b25dd0d2cd88d4aea1de96473c76788e8"
    },
    {
      "entropy": "0ad05686174f47af521a2f831447c337",
      "mnemonic":
          "altesse inonder myriade chaton usine sceptre doigt dicter insigne nappe trombone garrigue",
      "passphrase": "TREZOR",
      "seed":
          "f86709542ab6d0fa0ca5565dc3feb42d0103723751b22ab29e11c7af897ea93f599fda281b225467fa15b5b750f2f7823bab4591ef725d630cb77c64240417c0"
    },
    {
      "entropy": "316ef2e8707e6bf187cb11c32b5d7e0750f6058ff7b240f5",
      "mnemonic":
          "cinéma gustatif piscine soulever tactile vérin blinder facture protéger essorer exécuter anormal aplanir accepter déclarer valve défrayer opale",
      "passphrase": "TREZOR",
      "seed":
          "46efdb0e49a35fe0807ea32941bff7ea1e4538388f01353c97a682df484b7a9f83bd8f01df6c26f629805f42b4a99a4dabd70194fa4e6f387c298290f1a7e24c"
    },
    {
      "entropy":
          "4f1c0de14b4b6094d60b7bc5bedf8e553c54cc7b1bfe233551207297eda10948",
      "mnemonic":
          "effrayer sottise hameau marqueur pensif douceur épisode gambader quiétude vaseux subtil odorant quasar ficeler tomate imputer bricoler offenser docile surprise immense risible bulletin accolade",
      "passphrase": "TREZOR",
      "seed":
          "d80ea9aae1d17d494b8b9df595a0a577b6c301dee71db31afb8ad93b27011103223069262fc4524621832e126f5f9395a6d218564ff561e9773eebabe54fd859"
    },
    {
      "entropy": "6fcef04230eb9c2e0f0564c0a62d9fb5",
      "mnemonic":
          "garnir gustatif arbuste fabuleux piquer aviser crypter opérer prélude cinéma firme fragile",
      "passphrase": "TREZOR",
      "seed":
          "6a4518f0df28e47966982827b9cdff7ebbc9972a5ba6ea4e11653ce76ec3d5c18b7c414f56bdbf371864a3ab4e782a8db0c3f37b63caa7e450d0cb7198f4cb5b"
    },
    {
      "entropy": "82a55ae2007446b7ade51c9e16d190d83f970fc0c328978d",
      "mnemonic":
          "inonder cascade phrase aboyer destrier étatique pétale néfaste monnaie perdrix fébrile palace veston journal accolade féodal maudire frapper",
      "passphrase": "TREZOR",
      "seed":
          "d8884cd81b52f8bfef8672556cdebf276cfe40f793ef2b9c852d5e9a61cd4144ab1d81f4c4894189d20a8669c7a18383801d7d876418d9768add65b50e8fa4e4"
    },
    {
      "entropy":
          "9c20436f27543af93203be7a8c09677eba46775b000de9700ee46f8d10e02608",
      "mnemonic":
          "mimique abusif sévir effectif désastre huileux réagir gyrostat histoire exiler espadon voguer neurone crotale frapper absence tendre incolore pièce soluble rivière gazelle méconnu anaphore",
      "passphrase": "TREZOR",
      "seed":
          "cf3b4f9c5b3e62c6cf6c3d990c2bf343e2c85e2f34f3589dd80ee542e7db012956b3352cf7e1ce971881aa315185265e9dc52dacb7ef68991a59a5295748ceaa"
    }
  ],
  "italian": [
    {
      "entropy": "00000000000000000000000000000000",
      "mnemonic":
          "abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abete",
      "passphrase": "TREZOR",
      "seed":
          "d2ae4bbd4efc4aba345b66dc2bfa4ea280d85810945ba4e100707694d5731c5a42ac0d0308ba9ad176966879328f1aa014fbcbeb46d671d9475c38254bf1eeb7"
    },
    {
      "entropy": "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic":
          "mimosa vita sussurro zinco vero saltare zattera ulisse mimosa vita sussurro zircone",
      "passphrase": "TREZOR",
      "seed":
          "f8c609647319a50116e9b7d1a0ec5535c6d08d6c958911fd2c8b2dfd55a61e63e9c6c60c22b5c3aec725acb41980e63cb3ed75fb80648092dee1bbbeab476a6d"
    },
    {
      "entropy": "80808080808080808080808080808080",
      "mnemonic":
          "misurare afoso bravura accadere alogeno dottore acrilico arazzo misurare afoso bravura abisso",
      "passphrase": "TREZOR",
      "seed":
          "4025269bc4f7550bbc3c61592944946b0d4ac855a5e4582bf86069cc0c9429455cc40d84ba215ed1cec28e27ffc88460c38b9c4e8c486ae878d7c85e95b222bf"
    },
    {
      "entropy": "ffffffffffffffffffffffffffffffff",
      "mnemonic":
          "zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zerbino",
      "passphrase": "TREZOR",
      "seed":
          "24182cf43f956410b5def9df90e3db0d6f3199c2ebd26e7ddef888ee3bece9101d132e449bb9e1c23dd9ccc6131d2f649c021ee591e88cef8d17cb434ef69efb"
    },
    {
      "entropy": "000000000000000000000000000000000000000000000000",
      "mnemonic":
          "abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco agitare",
      "passphrase": "TREZOR",
      "seed":
          "2161a4b869f98778b6321714e2502adb11ea120c12163b46fa34e36442ad1981b911a2f9ec82b497e7cd206fa7af2f21a94bb6e4a90159965854784e1558658b"
    },
    {
      "entropy": "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic":
          "mimosa vita sussurro zinco vero saltare zattera ulisse mimosa vita sussurro zinco vero saltare zattera ulisse mimosa virulento",
      "passphrase": "TREZOR",
      "seed":
          "d9a6205a985fde8c2337f6cc6acf77a93d6ec7dc792551c01400f5d9aaa86aa943416c99fe60be141ca27ab333d9f96648b40b266d6b2d6a6e5b07c8939568be"
    },
    {
      "entropy": "808080808080808080808080808080808080808080808080",
      "mnemonic":
          "misurare afoso bravura accadere alogeno dottore acrilico arazzo misurare afoso bravura accadere alogeno dottore acrilico arazzo misurare allievo",
      "passphrase": "TREZOR",
      "seed":
          "cfb1f800cd5a0f7a8cffb12231fc61739f5f87c963ead5e205dd48221c3417eb1173d3209d9a8ffc4f00ab291bc22c1480b4a0a4fdeef9a1f3916d0ccbed5591"
    },
    {
      "entropy": "ffffffffffffffffffffffffffffffffffffffffffffffff",
      "mnemonic":
          "zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa vile",
      "passphrase": "TREZOR",
      "seed":
          "05a43b9c258f6e83f4073fe4a66d6309e94610fe12dd5d598f4725e4e85ff1fde5ff5b1e61b40e09a481a98953f9dc818342172a460e5e6d17d9ab14874447e2"
    },
    {
      "entropy":
          "0000000000000000000000000000000000000000000000000000000000000000",
      "mnemonic":
          "abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco abaco angelo",
      "passphrase": "TREZOR",
      "seed":
          "84055239f41c182bbfe6ede6db2e8bc4a97cf86746643b7ea6910c71d67bb2a678a97ecd378cfbf59e30db720b1cfde0faaee73afd3c5deef2188e307d04442c"
    },
    {
      "entropy":
          "7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f",
      "mnemonic":
          "mimosa vita sussurro zinco vero saltare zattera ulisse mimosa vita sussurro zinco vero saltare zattera ulisse mimosa vita sussurro zinco vero saltare zattera tarpare",
      "passphrase": "TREZOR",
      "seed":
          "f0e226efcd929216020a9e8f879f06b146d28fecd2856bd401a62ecc0ece8bc6ea717e3f9df523a6a00bd4ca8965e0498d63e779e3156dbf174ebac74ad7be31"
    },
    {
      "entropy":
          "8080808080808080808080808080808080808080808080808080808080808080",
      "mnemonic":
          "misurare afoso bravura accadere alogeno dottore acrilico arazzo misurare afoso bravura accadere alogeno dottore acrilico arazzo misurare afoso bravura accadere alogeno dottore acrilico baco",
      "passphrase": "TREZOR",
      "seed":
          "ef549c1e44a7b183031b41f9f692795406de605e43ecc628911a38d7c92f392660c48313a08cf1a055a420d4a8c6b12bef7ff354c903303bc3a5dc12948ff5be"
    },
    {
      "entropy":
          "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
      "mnemonic":
          "zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa zuppa vedetta",
      "passphrase": "TREZOR",
      "seed":
          "5089f33aee7852d86a01e8afbfdc8a0ad5af51538e62e3f007d098fa4fc9817ddc990fa87b7235273798e2df52228b62738df923bc2d711fed9cc0558b3ebfec"
    },
    {
      "entropy": "49c9a39c7c138c244f4cf02bcc608f2f",
      "mnemonic":
          "esigente fabbrica tiro verticale deforme arzillo dirupo persuaso ciao guardare calmo girato",
      "passphrase": "TREZOR",
      "seed":
          "e0900f3d53d8ad1d8956e5630fecc34f4e8415c0cef4b30f1388a8baf0da37ae230de4d954a1ec593e12e472392675da273e235fa30d606df776818d8d3923c6"
    },
    {
      "entropy": "a13ddb88035fdfdca355a0953bbef84134adaddda9a80ca1",
      "mnemonic":
          "pilota tutela talismano alfa zattera tunisia obsoleto ricco oste strutto rupe mondina essenza sospiro macero cruciale anello alunno",
      "passphrase": "TREZOR",
      "seed":
          "0e91bb076791c3274e36ba198b0836d6ae65a1f79ec93336890fc953391f3481ac86a06ff2b23e6514fbd7ab5f80824472a67bb9180d6858f304a7439382da2e"
    },
    {
      "entropy":
          "ad0684c5e3b7a017ec82f97fb7eb8e693b3ef088fc2f7de0dcb51c926509466b",
      "mnemonic":
          "raccolto criceto coppia scuderia maretta anatra reprimere giudizio mini salivare tavolata smeraldo ricarica malumore caloria murale metodo aliante civile delfino capsula mucosa barlume maturo",
      "passphrase": "TREZOR",
      "seed":
          "377cdea91387a0fcfbc7958fd56f82a41bb686388d61aa3917d30b5d4fd0b6c685d986bc20c606fed2c0b29e1222d703683478080d41ed3f6ef5b7bbd391bc7b"
    },
    {
      "entropy": "cdacbe799f84735668b7617811e94379",
      "mnemonic":
          "sforzato immerso pesatore doganale epocale pudica placebo trifoglio malsano olandese fertile vagliato",
      "passphrase": "TREZOR",
      "seed":
          "82f6c9f8b3733904986d41d55081b04b20d12ed77598bc9068ae26ede3e2378b51750e901c10bec7f1d0995008d24a9c4784a12c5a2479e988366369da113131"
    },
    {
      "entropy": "820c73e21b8618e89f79c5f7e6b0735352498c5139cb0721",
      "mnemonic":
          "molosso icona vestale daniela gravoso lombare metodo definito vero cugino bilancia potassio camola scolpito emanato delta alimento ameba",
      "passphrase": "TREZOR",
      "seed":
          "11e0acb44d2988712d22d39adb08b895df04316522257bf693cf9402540f51e15dbfbefc298cfa0805c784cd6f0e63029de1ddbb2e2adf18cad9173c19c501ef"
    },
    {
      "entropy":
          "5a95455a42e5d2242d423b6dfa05f3ec6f59a268558c32b92e521c1869a816fd",
      "mnemonic":
          "galoppo proroga fracasso muovere gennaio artefice riflesso equatore labirinto simpatico mercurio spettrale varcato sipario pimpante remare cortese sella ospedale declino muto soffitto gaudio regresso",
      "passphrase": "TREZOR",
      "seed":
          "3d2acf43839156e1202e48ae1e52a82c3415d619e99017c257a2a7f216fd1c50bbd0d2f2b79370f3033d00e9a401d1f35d619e8327ec2bbac5d45f1140ac9560"
    },
    {
      "entropy": "51093ebd36eaad623e38ec9ebe4dcad3",
      "mnemonic":
          "festivo esistere rasente labbro prurito registro vetusto birbante peso uscito limpido predica",
      "passphrase": "TREZOR",
      "seed":
          "c4cb0a8b51514bdae45cb9c197fcc377b17015964200a235017d9146a893634babb9422456b60dfd906122c0e74ec8d86c5ca142a86df09cdac707b0d6e1b515"
    },
    {
      "entropy": "531609106971a3a3821ca0df5d2a7274b50200d33bd09be0",
      "mnemonic":
          "flamenco recluta eletto smussato batosta slogatura altalena orzo superbo torrone pentola tortora femmina abete evviva maretta pendice adeguato",
      "passphrase": "TREZOR",
      "seed":
          "061d0a221a57dd98d442b0f5a7e94de523a61e50d1f581654c2c93dbdbe1d669991f3e620aa745a09d302dc78c6c401fe688486958e127e30b283c18d2838b5d"
    },
    {
      "entropy":
          "0723c11525d9dd6f685be416c8e421383f09b1b5d1e6af3ecf360dc650b5efe2",
      "mnemonic":
          "alimento bisnonno emiro etilico perno riparato pineta meninge azione epocale alpestre leggero uncinetto spettrale spada diradare raschiato veicolo sfoltire benigno illogico garanzia salone druido",
      "passphrase": "TREZOR",
      "seed":
          "9590382dad190ca8c68e26399a6705c4391a45060925040d36bca1ccf453280ffffce2315429e657ac10897d8962348f0dbd0cd2cb5192ec72f416ad24431a5f"
    },
    {
      "entropy": "ed0799705118cd491348d445a1460ae2",
      "mnemonic":
          "tromba diradare gazebo piretico obbligo polpetta faccenda bava empirico ametista monile sciarpa",
      "passphrase": "TREZOR",
      "seed":
          "db1b8a9f4447b9965813e307ebf538065c01d219f57056c788d66e427f25b71438652a89c31683060d07e5fffccd991f179e9bd12ab7c63a1ba1553554b75553"
    },
    {
      "entropy": "dcfd33d6b01da0e942412db1b6d5338d7ddf141a6f0d8812",
      "mnemonic":
          "stivale toscano variante gomito spranga loquace alveolo capello remoto rincaro evviva beffa strutto nobile innesco tacciare nebulosa ostacolo",
      "passphrase": "TREZOR",
      "seed":
          "01ef1ecee14d2d7639e3102cc127c213ccba297f51d8bdc0255d6b4574f2602fdd652e5b032492af85deed0f0662dd59c42ea3285d49b65d4e8879fe1dd350a5"
    },
    {
      "entropy":
          "5e01e50f9563396da6428951762de0c1247139fb8b1e08bc23dfcd8f821d3a72",
      "mnemonic":
          "gilda aprile elencato chela creato rinforzo paprica fetta fiaba relazione malto monco episodio perbene tumulto idillio alticcio svizzera vero pavone verticale apparire tostatura etto",
      "passphrase": "TREZOR",
      "seed":
          "47088af5d8dd2c6ad9b917035027fc31e9d323c16e458aab648c369a1dd4cee1850a9ac40b8a03bb0ba1be3a8967edc5fbace94ce0e43f33707d8b615a510362"
    }
  ]
};
