part of '../bidi.dart';

const _charForms = <int, int>{
  0x30671: 0xFB50,
  0x20671: 0xFB51,
  0x3067B: 0xFB52,
  0x2067B: 0xFB53,
  0x0067B: 0xFB54,
  0x1067B: 0xFB55,
  0x3067E: 0xFB56,
  0x2067E: 0xFB57,
  0x0067E: 0xFB58,
  0x1067E: 0xFB59,
  0x30680: 0xFB5A,
  0x20680: 0xFB5B,
  0x00680: 0xFB5C,
  0x10680: 0xFB5D,
  0x3067A: 0xFB5E,
  0x2067A: 0xFB5F,
  0x0067A: 0xFB60,
  0x1067A: 0xFB61,
  0x3067F: 0xFB62,
  0x2067F: 0xFB63,
  0x0067F: 0xFB64,
  0x1067F: 0xFB65,
  0x30679: 0xFB66,
  0x20679: 0xFB67,
  0x00679: 0xFB68,
  0x10679: 0xFB69,
  0x306A4: 0xFB6A,
  0x206A4: 0xFB6B,
  0x006A4: 0xFB6C,
  0x106A4: 0xFB6D,
  0x306A6: 0xFB6E,
  0x206A6: 0xFB6F,
  0x006A6: 0xFB70,
  0x106A6: 0xFB71,
  0x30684: 0xFB72,
  0x20684: 0xFB73,
  0x00684: 0xFB74,
  0x10684: 0xFB75,
  0x30683: 0xFB76,
  0x20683: 0xFB77,
  0x00683: 0xFB78,
  0x10683: 0xFB79,
  0x30686: 0xFB7A,
  0x20686: 0xFB7B,
  0x00686: 0xFB7C,
  0x10686: 0xFB7D,
  0x30687: 0xFB7E,
  0x20687: 0xFB7F,
  0x00687: 0xFB80,
  0x10687: 0xFB81,
  0x3068D: 0xFB82,
  0x2068D: 0xFB83,
  0x3068C: 0xFB84,
  0x2068C: 0xFB85,
  0x3068E: 0xFB86,
  0x2068E: 0xFB87,
  0x30688: 0xFB88,
  0x20688: 0xFB89,
  0x30698: 0xFB8A,
  0x20698: 0xFB8B,
  0x30691: 0xFB8C,
  0x20691: 0xFB8D,
  0x306A9: 0xFB8E,
  0x206A9: 0xFB8F,
  0x006A9: 0xFB90,
  0x106A9: 0xFB91,
  0x306AF: 0xFB92,
  0x206AF: 0xFB93,
  0x006AF: 0xFB94,
  0x106AF: 0xFB95,
  0x306B3: 0xFB96,
  0x206B3: 0xFB97,
  0x006B3: 0xFB98,
  0x106B3: 0xFB99,
  0x306B1: 0xFB9A,
  0x206B1: 0xFB9B,
  0x006B1: 0xFB9C,
  0x106B1: 0xFB9D,
  0x306BA: 0xFB9E,
  0x206BA: 0xFB9F,
  0x306BB: 0xFBA0,
  0x206BB: 0xFBA1,
  0x006BB: 0xFBA2,
  0x106BB: 0xFBA3,
  0x306C0: 0xFBA4,
  0x206C0: 0xFBA5,
  0x306C1: 0xFBA6,
  0x206C1: 0xFBA7,
  0x006C1: 0xFBA8,
  0x106C1: 0xFBA9,
  0x306BE: 0xFBAA,
  0x206BE: 0xFBAB,
  0x006BE: 0xFBAC,
  0x106BE: 0xFBAD,
  0x306D2: 0xFBAE,
  0x206D2: 0xFBAF,
  0x306D3: 0xFBB0,
  0x206D3: 0xFBB1,
  0x306AD: 0xFBD3,
  0x206AD: 0xFBD4,
  0x006AD: 0xFBD5,
  0x106AD: 0xFBD6,
  0x306C7: 0xFBD7,
  0x206C7: 0xFBD8,
  0x306C6: 0xFBD9,
  0x206C6: 0xFBDA,
  0x306C8: 0xFBDB,
  0x206C8: 0xFBDC,
  0x30677: 0xFBDD,
  0x306CB: 0xFBDE,
  0x206CB: 0xFBDF,
  0x306C5: 0xFBE0,
  0x206C5: 0xFBE1,
  0x306C9: 0xFBE2,
  0x206C9: 0xFBE3,
  0x306D0: 0xFBE4,
  0x206D0: 0xFBE5,
  0x006D0: 0xFBE6,
  0x106D0: 0xFBE7,
  0x00649: 0xFBE8,
  0x10649: 0xFBE9,
  0x306CC: 0xFBFC,
  0x206CC: 0xFBFD,
  0x006CC: 0xFBFE,
  0x106CC: 0xFBFF,
  0x30621: 0xFE80,
  0x30622: 0xFE81,
  0x20622: 0xFE82,
  0x30623: 0xFE83,
  0x20623: 0xFE84,
  0x30624: 0xFE85,
  0x20624: 0xFE86,
  0x30625: 0xFE87,
  0x20625: 0xFE88,
  0x30626: 0xFE89,
  0x20626: 0xFE8A,
  0x00626: 0xFE8B,
  0x10626: 0xFE8C,
  0x30627: 0xFE8D,
  0x20627: 0xFE8E,
  0x30628: 0xFE8F,
  0x20628: 0xFE90,
  0x00628: 0xFE91,
  0x10628: 0xFE92,
  0x30629: 0xFE93,
  0x20629: 0xFE94,
  0x3062A: 0xFE95,
  0x2062A: 0xFE96,
  0x0062A: 0xFE97,
  0x1062A: 0xFE98,
  0x3062B: 0xFE99,
  0x2062B: 0xFE9A,
  0x0062B: 0xFE9B,
  0x1062B: 0xFE9C,
  0x3062C: 0xFE9D,
  0x2062C: 0xFE9E,
  0x0062C: 0xFE9F,
  0x1062C: 0xFEA0,
  0x3062D: 0xFEA1,
  0x2062D: 0xFEA2,
  0x0062D: 0xFEA3,
  0x1062D: 0xFEA4,
  0x3062E: 0xFEA5,
  0x2062E: 0xFEA6,
  0x0062E: 0xFEA7,
  0x1062E: 0xFEA8,
  0x3062F: 0xFEA9,
  0x2062F: 0xFEAA,
  0x30630: 0xFEAB,
  0x20630: 0xFEAC,
  0x30631: 0xFEAD,
  0x20631: 0xFEAE,
  0x30632: 0xFEAF,
  0x20632: 0xFEB0,
  0x30633: 0xFEB1,
  0x20633: 0xFEB2,
  0x00633: 0xFEB3,
  0x10633: 0xFEB4,
  0x30634: 0xFEB5,
  0x20634: 0xFEB6,
  0x00634: 0xFEB7,
  0x10634: 0xFEB8,
  0x30635: 0xFEB9,
  0x20635: 0xFEBA,
  0x00635: 0xFEBB,
  0x10635: 0xFEBC,
  0x30636: 0xFEBD,
  0x20636: 0xFEBE,
  0x00636: 0xFEBF,
  0x10636: 0xFEC0,
  0x30637: 0xFEC1,
  0x20637: 0xFEC2,
  0x00637: 0xFEC3,
  0x10637: 0xFEC4,
  0x30638: 0xFEC5,
  0x20638: 0xFEC6,
  0x00638: 0xFEC7,
  0x10638: 0xFEC8,
  0x30639: 0xFEC9,
  0x20639: 0xFECA,
  0x00639: 0xFECB,
  0x10639: 0xFECC,
  0x3063A: 0xFECD,
  0x2063A: 0xFECE,
  0x0063A: 0xFECF,
  0x1063A: 0xFED0,
  0x30641: 0xFED1,
  0x20641: 0xFED2,
  0x00641: 0xFED3,
  0x10641: 0xFED4,
  0x30642: 0xFED5,
  0x20642: 0xFED6,
  0x00642: 0xFED7,
  0x10642: 0xFED8,
  0x30643: 0xFED9,
  0x20643: 0xFEDA,
  0x00643: 0xFEDB,
  0x10643: 0xFEDC,
  0x30644: 0xFEDD,
  0x20644: 0xFEDE,
  0x00644: 0xFEDF,
  0x10644: 0xFEE0,
  0x30645: 0xFEE1,
  0x20645: 0xFEE2,
  0x00645: 0xFEE3,
  0x10645: 0xFEE4,
  0x30646: 0xFEE5,
  0x20646: 0xFEE6,
  0x00646: 0xFEE7,
  0x10646: 0xFEE8,
  0x30647: 0xFEE9,
  0x20647: 0xFEEA,
  0x00647: 0xFEEB,
  0x10647: 0xFEEC,
  0x30648: 0xFEED,
  0x20648: 0xFEEE,
  0x30649: 0xFEEF,
  0x20649: 0xFEF0,
  0x3064A: 0xFEF1,
  0x2064A: 0xFEF2,
  0x0064A: 0xFEF3,
  0x1064A: 0xFEF4,
};

int _getCharacterByLetterForm(int character, LetterForm form) {
  int key = (character) | (form.index) << 16;

  final f = _charForms[key];

  if (f != null) {
    return f;
  }

  return character;
}
