#!/bin/bash

# Generate a java file providing the mapping of class name to xml file
# name that Android's system requires but doesn't provide. I hate
# leaving that sort of thing to chance.

mkClass() {
	XMLFILE=$1
	NAME=${XMLFILE/.xml/}
	cat <<EOF

    class ${NAME} : BasePrefsFrag() {
        override fun getResID(): Int { return R.xml.${NAME} }
    }
EOF
}

cat <<EOF
/******************************************************************
 * file generated by $0. Changes will be overwritten!!
 ******************************************************************/

package org.eehouse.android.xw4.gen

import org.eehouse.android.xw4.PrefsActivity.BasePrefsFrag
import org.eehouse.android.xw4.R

class PrefsWrappers {
EOF

IDS=""
while [ "$#" -gt 0 ]; do
	FILE=$(basename $1)
	mkClass $FILE
	IDS="${IDS} R.xml.${FILE/.xml/}, "
	shift
done

cat <<EOF
	companion object {
        private val sIDs = arrayOf($IDS)
        @JvmStatic
        public fun getPrefsResIDs(): Array<Int> {
            return sIDs
        }
    }
}
EOF
