/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 */
"use strict"; // Type only import, no runtime dependency
// eslint-disable-next-line import/no-extraneous-dependencies

module.exports = {
  addParamsToDefineCall: require("./addParamsToDefineCall"),
  constantFoldingPlugin: require("./constant-folding-plugin"),
  importExportPlugin: require("./import-export-plugin"),
  inlinePlugin: require("./inline-plugin"),
  normalizePseudoGlobals: require("./normalizePseudoGlobals"),
  getTransformPluginCacheKeyFiles: () => [
    require.resolve(__filename),
    require.resolve("./constant-folding-plugin"),
    require.resolve("./import-export-plugin"),
    require.resolve("./inline-plugin"),
    require.resolve("./normalizePseudoGlobals")
  ]
};
