/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @format
 *
 */
"use strict";

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
  try {
    var info = gen[key](arg);
    var value = info.value;
  } catch (error) {
    reject(error);
    return;
  }

  if (info.done) {
    resolve(value);
  } else {
    Promise.resolve(value).then(_next, _throw);
  }
}

function _asyncToGenerator(fn) {
  return function() {
    var self = this,
      args = arguments;
    return new Promise(function(resolve, reject) {
      var gen = fn.apply(self, args);

      function _next(value) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
      }

      function _throw(err) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
      }

      _next(undefined);
    });
  };
}

const HttpStore = require("./HttpStore");

const _require = require("metro-core"),
  Logger = _require.Logger;

class HttpGetStore extends HttpStore {
  constructor(options) {
    super(options);
    this._warned = false;
  }

  get(key) {
    var _superprop_getGet = () => super.get,
      _this = this;

    return _asyncToGenerator(function*() {
      try {
        return yield _superprop_getGet().call(_this, key);
      } catch (err) {
        if (
          !(err instanceof HttpStore.HttpError) &&
          !(err instanceof HttpStore.NetworkError)
        ) {
          throw err;
        }

        _this._warn(err);

        return null;
      }
    })();
  }

  set() {
    return Promise.resolve(undefined);
  }

  _warn(err) {
    if (!this._warned) {
      process.emitWarning(
        [
          "Could not connect to the HTTP cache.",
          "Original error: " + err.message
        ].join(" ")
      );
      Logger.createEntry(`CACHE_ERROR: ${err.message} (${err.code})`);
      this._warned = true;
    }
  }
}

module.exports = HttpGetStore;
