package org.eagsoftware.laundrynotes.data;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;

import java.util.List;

@Dao
public interface ArticoloDAO {
    @Insert
    long creaArticolo(ArticoloEntity articolo);

    @Update
    int aggiornaArticolo(ArticoloEntity articolo);

    @Delete
    void eliminaArticolo(ArticoloEntity articolo);

    @Query("SELECT * FROM lavanderia ORDER BY nome")
    List<ArticoloEntity> listaCompleta();

    /*
    @Query("SELECT * FROM lavanderia WHERE id_articolo = :id")
    ArticoloEntity getArticolo(long id);
     */
}
