package org.eagsoftware.laundrynotes.adapters;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.List;
import java.util.Locale;

public class LanguageSpinnerAdapter extends ArrayAdapter<String> {
    private final List<String> codes;

    public LanguageSpinnerAdapter(@NonNull Context context, @NonNull List<String> codes){
        super(context, android.R.layout.simple_spinner_item, codes);
        this.codes = codes;
        setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
    }

    @NonNull
    @Override
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        return setView((TextView) super.getView(position, convertView, parent), position);

    }

    @Override
    public View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        return setView ((TextView) super.getDropDownView(position, convertView, parent), position);
    }

    /** Restituisce la posizione di una lingua a partire dal suo codice */
    public int getPositionByCode(String code) {
        for(int i = 0; i < codes.size(); i++) if (codes.get(i).equals(code)) return i;
        return -1;
    }


    /** Imposta la selezione dello spinner usando il codice lingua */
    public void setSelectionByCode(Spinner spinner, String code){
        int pos = getPositionByCode(code);
        if(pos >= 0) spinner.setSelection(pos);
        else throw new RuntimeException("Codice lingua non trovato: " + code);
    }


    private TextView setView(TextView view, int position){
        String code = codes.get(position);
        Locale locale = new Locale(code);
        view.setText(locale.getDisplayLanguage(locale)); //nome nativo
        return view;
    }
}
