package org.eagsoftware.laundrynotes.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import org.eagsoftware.laundrynotes.R;

import java.util.List;

public class DetailSpinner2IconsAdapter extends DetailSpinnerAdapter{
    private final List<Integer> icon2IDs;

    public DetailSpinner2IconsAdapter(Context context, String[] descriptions,
                                      List<Integer> icon1IDs, List<Integer> icon2IDs, int layoutItemID) {
        super(context, descriptions, icon1IDs, layoutItemID);
        this.icon2IDs = icon2IDs;
    }

    @Override
    protected View createView(int position, ViewGroup parent, int lytItemID) {
        LayoutInflater ifrSpinner =
                (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        View rowView = ifrSpinner.inflate(R.layout.spinner_item_2_ic, parent, false);
        TextView txwDesc = rowView.findViewById(R.id.txw_spi2_desc);
        ImageView imwIco1 = rowView.findViewById(R.id.imw_spi2_ico1);
        ImageView imwIco2 = rowView.findViewById(R.id.imw_spi2_ico2);

        // Imposta il testo e l'immagine (se esitente)
        // Se è il primo elemento dello spinner, imposta il testo sull'hint e non sul testo
        if (position==0) {
            txwDesc.setText("");
            txwDesc.setHint(descriptions[position]);
        } else txwDesc.setText(descriptions[position]);
        if(iconIDs.get(position) != -1) imwIco1.setImageResource(iconIDs.get(position));
        if(icon2IDs.get(position) != -1) imwIco2.setImageResource(icon2IDs.get(position));

        return rowView;
    }
}
