package org.eagsoftware.laundrynotes;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;

import java.util.Locale;

public class MyPrefMgr {
    private static final String PREFS_NAME = "a6c4a6af-8602-43a4-83cf-fb18e7926270";
    private static final String KEY_LANG = "b8e68bee-e4d9-4925-a452-8a0b4af83c64";

    public static String getPrefLng(Context context){
        SharedPreferences prefs = context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE);

        String currLng = prefs.getString(KEY_LANG, "");

        if (currLng.isEmpty()){
            currLng=getAppLanguage(context);
            setPrefLng(context, currLng);
        }

        return currLng;
    }

    public static void setPrefLng(Context context, String language) {
        SharedPreferences prefs = context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE);
        SharedPreferences.Editor edtPref = prefs.edit();
        edtPref.putString(KEY_LANG, language);
        edtPref.apply();
    }

    /** NOTA: per ottenere la lingua dell'app (e non quella di sistema) utilizzare Activity come context*/
    private static String getAppLanguage(Context context){
        if(!(context instanceof Activity || context instanceof Application))
            throw new ClassCastException("Context errato");

        Locale locale = context.getResources().getConfiguration().getLocales().get(0);
        String sysLng = locale.getLanguage();        // es. "it"
        for (String lng : Utilities.lingueDisponibiliInApp(context)) {
            if (sysLng.equals(lng)) return sysLng;
        }
        return "en";
    }
}
