package org.dydlakcloud.resticopia.ui.folders

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.BaseAdapter
import android.widget.TextView
import org.dydlakcloud.resticopia.R
import org.dydlakcloud.resticopia.config.Config
import org.dydlakcloud.resticopia.config.FolderConfig
import org.dydlakcloud.resticopia.ui.Formatters

/**
 * Custom adapter for displaying folder list items with consistent sizing.
 */
class FolderListAdapter(
    private val context: Context,
    private val folders: List<FolderConfig>,
    private val config: Config
) : BaseAdapter() {


    override fun getCount(): Int = folders.size

    override fun getItem(position: Int): FolderConfig = folders[position]

    override fun getItemId(position: Int): Long = position.toLong()

    override fun getView(position: Int, convertView: View?, parent: ViewGroup): View {
        val view = convertView ?: LayoutInflater.from(context)
            .inflate(R.layout.list_item_folder, parent, false)

        val folder = getItem(position)
        
        val nameView = view.findViewById<TextView>(R.id.folder_name)
        val detailsView = view.findViewById<TextView>(R.id.folder_details)

        // Set folder name (just the name, not full path)
        nameView.text = folder.path.name

        // Build details line: "Repository name, last backup Mar 25, 2023"
        val repoName = folder.repo(config)?.base?.name ?: "Unknown"
        val lastBackup = folder.lastBackup(filterSuccessful = true)
        
        val detailsText = if (lastBackup != null) {
            "$repoName, last backup ${Formatters.date(lastBackup.timestamp)}"
        } else {
            "$repoName, no backups yet"
        }
        
        detailsView.text = detailsText

        return view
    }
}

