/**
 * License: GPL-3.0-or-later
 * Author: veto@myridia.com
 * Description: Setting Activity Screen
 */
package org.calantas.mygeo;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.preference.PreferenceActivity;
import androidx.preference.PreferenceManager;
import android.view.MenuItem;
import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.widget.Toolbar;

public class Setting extends PreferenceActivity {
    Lib lib;
    private AppCompatDelegate mDelegate;

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        getDelegate().installViewFactory();
        getDelegate().onCreate(savedInstanceState);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.settings);

        lib = new Lib(getApplicationContext());
        log_me("...on create");

        addPreferencesFromResource(R.layout.preferences);

        Toolbar toolbar = findViewById(R.id.toolbar);
        toolbar.setTitle("myGeo - Settings");
        toolbar.inflateMenu(R.menu.menu);
        toolbar.setOnMenuItemClickListener(item -> {
            log_me("... option item select");
            Context context = getApplicationContext();
            return lib.drop_menu(item, context);
        });


        setSupportActionBar(toolbar);
        toolbar.setNavigationOnClickListener(v -> {
            log_me("...click logo icon");
            Intent intent = new Intent(getApplicationContext(), Main.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
            startActivity(intent);
        });

    }

    @Override
    protected void onPostCreate(Bundle instance) {
        super.onPostCreate(instance);
        getDelegate().onPostCreate(instance);
        log_me("...on post create");
    }

    @Override
    public void setContentView(@LayoutRes int layout_id) {
        getDelegate().setContentView(layout_id);
        //log_me("...set content view");
    }

    @Override
    protected void onPostResume() {
        super.onPostResume();
        getDelegate().onPostResume();
    }





    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        log_me("... option item select");
        return lib.drop_menu(item, this);
    }


    private void setSupportActionBar(@Nullable Toolbar toolbar) {
        getDelegate().setSupportActionBar(toolbar);
    }

    private AppCompatDelegate getDelegate() {
        if (mDelegate == null) {
            mDelegate = AppCompatDelegate.create(this, null);
        }
        return mDelegate;
    }

    private void log_me(String message) {
        lib.log_me(message, findViewById(R.id.logger_setting), false);
    }


}
