/**
 * License: GPL-3.0-or-later
 * Author: veto@myridia.com
 * Description: Collection of reused methods for this app
 */
package org.calantas.mygeo;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.MenuItem;

import android.webkit.WebView;
import android.widget.Button;
import android.widget.EditText;

import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Lib extends Main {
    private final Context context;
    private final String[] REQUIRED_PERMISSIONS = new String[]{
            "android.permission.ACCESS_COARSE_LOCATION"
            , "android.permission.ACCESS_FINE_LOCATION"
            , "android.permission.CAMERA"
            , "android.permission.READ_MEDIA_IMAGES"

    };
    Dialog dialog;


    public Lib(Context context) {
        this.context = context;

    }



    public boolean allPermissionsGranted() {
        for (String permission : REQUIRED_PERMISSIONS) {
            int x = ContextCompat.checkSelfPermission(this.context, permission);
            if (x != PackageManager.PERMISSION_GRANTED) {
                return false;
            }
        }
        return true;
    }

    public void request_permission(Activity a) {
        ActivityCompat.requestPermissions(a, REQUIRED_PERMISSIONS, 0);
        ActivityCompat.requestPermissions(a, REQUIRED_PERMISSIONS, 1);
        ActivityCompat.requestPermissions(a, REQUIRED_PERMISSIONS, 2);
        ActivityCompat.requestPermissions(a, REQUIRED_PERMISSIONS, 3);

    }

    public Boolean drop_menu(MenuItem item, Context context) {

        if (item.getItemId() == R.id.main) {
            Intent intent_main = new Intent(context, Main.class);
            intent_main.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            this.context.startActivity(intent_main);
            return true;
        } else if (item.getItemId() == R.id.settings) {
            Intent intent_setting = new Intent(context, Setting.class);
            intent_setting.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            this.context.startActivity(intent_setting);
            return true;
        } else if (item.getItemId() == R.id.edit_template) {
            Intent intent_template = new Intent(context, Editor.class);
            intent_template.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            this.context.startActivity(intent_template);
            return true;
        } else if (item.getItemId() == R.id.about) {
            create_dialog(context);
            return true;
        } else if (item.getItemId() == R.id.contact) {
            String r = send_email();
            return true;
        }

        return super.onOptionsItemSelected(item);

    }

    public Boolean get_alert(Context context) {
        SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences(context);
        return pref.getBoolean("alert", false);

    }

    public String get_saved_date_data(Context context) {
        Resources res = context.getResources();
        SharedPreferences pref = context.getSharedPreferences(res.getString(R.string.preference_file_key), Context.MODE_PRIVATE);
        return pref.getString("date", "");

    }

    public void save_date_data(Context context) {
        String date = get_date(context);
        Resources res = context.getResources();
        SharedPreferences pref = context.getSharedPreferences(res.getString(R.string.preference_file_key), Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = pref.edit();
        editor.putString("date", date);
        editor.apply();
    }

    public String get_date(Context context) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
        String b = prefs.getString("date_format", "1");
        Resources res = context.getResources();
        String[] c = res.getStringArray(R.array.date_format);
        int index = Integer.parseInt(b) - 1;
        String date_format = String.valueOf(c[index]);
        long t = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat(date_format);
        //SimpleDateFormat sdf = new SimpleDateFormat("dd MMMM yyyy");
        Date _date = new Date(t);
        return sdf.format(_date);
    }

    public void log_me(String message, EditText msg, boolean topdown) {
        String[] lines = msg.getText().toString().split("\n");
        int c = lines.length;
        String line = message;
        if (c < 100) {
            if (topdown) {
                line = msg.getText() + line + '\n';
            } else {
                line = '\n' + line + msg.getText();
            }
        }
        msg.setText(line);
        Log.e("my-geo", message);
    }

    public String send_email() {
        String r = "...send email \n";
        String[] TO = {"mygeo@myridia.com"};
        String[] CC = {""};
        Intent emailIntent = new Intent(Intent.ACTION_SEND);

        emailIntent.setDataAndType(Uri.parse("mailto:"),"test/plain");
        emailIntent.putExtra(Intent.EXTRA_EMAIL, TO);
        emailIntent.putExtra(Intent.EXTRA_CC, CC);
        emailIntent.putExtra(Intent.EXTRA_SUBJECT, "Message from myGeo App");
        emailIntent.putExtra(Intent.EXTRA_TEXT, "Hey from myGeo App");

        try {
            r +=  "... try send email \n";
            Intent intent = Intent.createChooser(emailIntent, "Send mail...");
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            this.context.startActivity(intent);
            //finish();
        } catch (android.content.ActivityNotFoundException ex) {
            r +=  "...failed  send email \n";
        }

        return r;
    }

    public void create_dialog(Context self) {
        dialog = new Dialog(self);

        dialog.setTitle("About");
        dialog.setContentView(R.layout.about);

        String t = get_about();
        WebView browser = dialog.findViewById(R.id.about_html);
        browser.loadData(t, "text/html", "UTF-8");
        browser.setBackgroundColor(0x00000000);

        Button close_btn = dialog.findViewById(R.id.btn_close);

        close_btn.setOnClickListener(v -> dialog.dismiss());
        dialog.show();
    }


    public void insert_into_editText(EditText e, String text) {
        String e_text = e.getText().toString();
        int index = Math.max(e.getSelectionStart(), 0);
        StringBuilder new_text = new StringBuilder(e_text);
        new_text.insert(index, text);
        e.setText(new_text.toString());
        e.setSelection(index + 3);
    }

    public String get_template() {
        InputStream fr = this.context.getResources().openRawResource(R.raw.template);
        return get_text(fr);
    }

    public String get_about() {
        InputStream fr = this.context.getResources().openRawResource(R.raw.about);
        return get_text(fr);
    }


    public String get_text(InputStream fr) {
        StringBuilder sb = new StringBuilder();
        String string = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(fr));
        while (true) {
            try {
                if ((string = br.readLine()) == null) break;
            } catch (IOException e) {
                //e.printStackTrace();

            }
            sb.append(string).append("\n");
        }
        return sb.toString();
    }



    String dec2DMS(double cords) {
        cords = cords > 0 ? cords : -cords;  // -105.9876543 -> 105.9876543
        String sOut = (int) cords + "/1,";   // 105/1,
        cords = (cords % 1) * 60;         // .987654321 * 60 = 59.259258
        sOut = sOut + (int) cords + "/1,";   // 105/1,59/1,
        cords = (cords % 1) * 60000;             // .259258 * 60000 = 15555
        sOut = sOut + (int) cords + "/1000";   // 105/1,59/1,15555/1000
        return sOut;
    }


}
