/**
 * License: GPL-3.0-or-later
 * Author: veto@myridia.com
 * Description: Collection of reused methods for this app
 */
package org.calantas.mygeo;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Button;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;

public class Editor extends AppCompatActivity {
    Lib lib;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        lib = new Lib(getApplicationContext());

        setContentView(R.layout.activity_editor);

        Toolbar toolbar = findViewById(R.id.my_toolbar);
        toolbar.setTitle("myGeo - Edit Template");
        setSupportActionBar(toolbar);
        toolbar.setNavigationOnClickListener(v -> {
            log_me("...click logo icon");
            Intent intent = new Intent(getApplicationContext(), Main.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
            startActivity(intent);
        });


        log_me("...get saved draft or default template");
        EditText e = findViewById(R.id.editor);
        Context context = getApplicationContext();
        SharedPreferences pref = context.getSharedPreferences(getString(R.string.preference_file_key), Context.MODE_PRIVATE);
        String t = lib.get_template();
        String template = pref.getString("template", t);
        e.setText(template);


        final Button btn_save = findViewById(R.id.btn_save);
        btn_save.setOnClickListener(v -> {
            log_me("...save to preferences");
         //   EditText e2 = findViewById(R.id.editor);
            String e_text = e.getText().toString();

            Context context1 = getApplicationContext();
            SharedPreferences pref1 = context1.getSharedPreferences(getString(R.string.preference_file_key), Context.MODE_PRIVATE);
            SharedPreferences.Editor editor = pref1.edit();
            editor.putString("template", e_text);
            editor.apply();
        });


        final Button btn_clear = findViewById(R.id.btn_clear);
        btn_clear.setOnClickListener(v -> {
            log_me("...clear editor");
            @SuppressLint("CutPasteId") EditText e1 = findViewById(R.id.editor);
            e1.setText("");
        });

        final Button btn_reset = findViewById(R.id.btn_reset);
        btn_reset.setOnClickListener(v -> {
            log_me("...reset and load default template");
            String t1 = lib.get_template();
            //EditText e3 = findViewById(R.id.editor);
            e.setText(t1);
        });


        final Button btn_latitude = findViewById(R.id.btn_latitude);
        btn_latitude.setOnClickListener(v -> {
            log_me("...insert latitude placeholder");
            //EditText e4 = findViewById(R.id.editor);
            lib.insert_into_editText(e, "{0}");
        });

        final Button btn_longitude = findViewById(R.id.btn_longitude);
        btn_longitude.setOnClickListener(v -> {
            log_me("...insert longitude placeholder");
            //EditText e5 = findViewById(R.id.editor);
            lib.insert_into_editText(e, "{1}");

        });


    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.menu, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        return lib.drop_menu(item, this);
    }

    private void log_me(String message) {
        lib.log_me(message, findViewById(R.id.logger), false);
    }


}
