# Contributing to FlexColorScheme

Thank you for your interest in contributing to **FlexColorScheme**, a Flutter package that provides flexible and easy to use color schemes and theming for Flutter applications. We welcome contributions that fix bugs, introduce enhancements or new features, and correct API documentation errors or typos.

## How to contribute

Before you start working on your contribution, please follow these steps:

- Fork the repository on GitHub and clone your fork to your local machine.
- Create a new branch from the main branch and name it according to the type and scope of your contribution. For example, `fix/issue-123` or `feature/new-color-option`.
- Make your changes in the new branch, following the code style and conventions of the project.
- Write tests for your changes, using the existing test framework. Make sure your changes do not break any existing tests or decrease the test coverage of the project.
- Commit your changes with a clear and descriptive message, referencing any relevant issues or pull requests.
- Push your changes to your fork on GitHub and create a pull request against the main branch of the original repository.
- Wait for the maintainers to review your pull request and provide feedback or approval.

## What to contribute

We appreciate any contribution that improves the quality and functionality of the package. Here are some examples of what you can contribute:

- Bug fixes: If you find a bug in the package, please report it as an issue on GitHub and provide a fix if possible.
- Enhancements: If you have an idea for a new feature or an improvement to an existing feature, please create an issue on GitHub to discuss it with the maintainers before working on it.
- Documentation: If you notice any errors or typos in the API documentation or the README file, please correct them and submit a pull request.

## What not to contribute

We value your time and effort, but we also have some guidelines for what kind of contributions we do not accept. Please do not submit contributions that:

- Introduce breaking API changes **without** prior discussion and approval from the maintainers.
- Add little or no value to the package, such as stylistic or irrelevant updates in the samples that demonstrate usage of the package. Such contributions are unlikely to be merged, as they may cause unnecessary conflicts or maintenance issues.
- Violate the code of conduct or the license of the project.

## Code of conduct

We expect all contributors to follow our code of conduct, which promotes a respectful and inclusive contribution community.

## License

By contributing to **flex_color_scheme**, you agree that your contributions will be licensed under its [BSD 3-Clause License](https://github.com/rydmike/flex_color_scheme/blob/master/LICENSE).

Thank you for your contribution! 🙏
