import java.io.FileInputStream
import java.util.Properties
import org.jetbrains.kotlin.gradle.dsl.JvmTarget
import org.jetbrains.kotlin.gradle.tasks.KotlinJvmCompile

plugins {
    id("com.android.application")
    id("kotlin-android")
    // The Flutter Gradle Plugin must be applied after the Android and Kotlin Gradle plugins.
    id("dev.flutter.flutter-gradle-plugin")
}

val localProperties = Properties()
val localPropertiesFile = rootProject.file("local.properties")
if (localPropertiesFile.exists()) {
    localPropertiesFile.bufferedReader(Charsets.UTF_8).use { reader ->
        localProperties.load(reader)
    }
}

var flutterVersionCode = localProperties.getProperty("flutter.versionCode") ?: "1"
var flutterVersionName = localProperties.getProperty("flutter.versionName") ?: "1.0"

val keystoreProperties = Properties()
val keystorePropertiesFile = rootProject.file("key.properties")
if (keystorePropertiesFile.exists()) {
    keystoreProperties.load(FileInputStream(keystorePropertiesFile))
}

val keystoreFile = System.getenv("KEY_PATH")
if (!keystoreFile.isNullOrEmpty()) {
    keystoreProperties.setProperty("storePassword", System.getenv("KEY_STORE_PASSWORD"))
    keystoreProperties.setProperty("keyPassword", System.getenv("KEY_PASSWORD"))
    keystoreProperties.setProperty("keyAlias", System.getenv("KEY_ALIAS"))
    keystoreProperties.setProperty("storeFile", keystoreFile)
}

android {
    namespace = "org.ca.squawker"
    compileSdk = 36
    ndkVersion = flutter.ndkVersion
    
    sourceSets {
        getByName("main") {
            java.srcDir("src/main/kotlin")
        }
    }

    compileOptions {
        isCoreLibraryDesugaringEnabled = true
        sourceCompatibility = JavaVersion.VERSION_1_8
        targetCompatibility = JavaVersion.VERSION_1_8
    }

    kotlinOptions {
        tasks.withType<KotlinJvmCompile>().configureEach {
            compilerOptions {
                jvmTarget.set(JvmTarget.JVM_1_8)
                freeCompilerArgs.add("-opt-in=kotlin.RequiresOptIn")
            }
        }
    }

    defaultConfig {
        // TODO: Specify your own unique Application ID (https://developer.android.com/studio/build/application-id.html).
        applicationId = "org.ca.squawker"
        // You can update the following values to match your application needs.
        // For more information, see: https://flutter.dev/to/review-gradle-config.
        minSdk = flutter.minSdkVersion
        targetSdk = 36
        multiDexEnabled = true
        versionCode = flutterVersionCode.toInt()
        versionName = flutterVersionName
    }
    

    buildTypes {
        getByName("debug") {
            applicationIdSuffix = ".debug"
            isDebuggable = true
            isJniDebuggable = true
            isMinifyEnabled = false
        }

        getByName("release") {
            // TODO: Add your own signing config for the release build.
            // Signing with the debug keys for now, so `flutter run --release` works.
            
            isMinifyEnabled = true
            isShrinkResources = true
            isDebuggable = false

            applicationVariants.all {
                outputs.configureEach {
                    val abiVersionCodes = mapOf(
                        "x86_64" to 1,
                        "armeabi-v7a" to 2,
                        "arm64-v8a" to 3
                    )

                    val abi = filters.find { it.filterType == com.android.build.OutputFile.ABI }?.identifier

                    if (abi != null && abiVersionCodes.containsKey(abi)) {
                        (this as com.android.build.gradle.internal.api.ApkVariantOutputImpl).versionCodeOverride =
                            this.versionCode + abiVersionCodes[abi]!!
                    }
                }
            }
        }
    }
}

flutter {
    source = "../.."
}

dependencies {
    implementation("androidx.multidex:multidex:2.0.1")
    coreLibraryDesugaring("com.android.tools:desugar_jdk_libs:2.1.5")
}

