/*
 * Copyright (c) 2025 S. Brett Sutton 2022+
 *
 * This software is licensed under the MIT License.
 * SPDX-License-Identifier: MIT
 */

export 'package:crypto/crypto.dart' show Digest;
export 'package:dcli_core/dcli_core.dart'
    show
        // BackupFileException,
        // MoveDirException,
        // TouchException,
        // Which,
        CancelableLineAction,
        CatException,
        CopyException,
        CreateDirException,
        DCliException,
        DCliFunction,
        DCliFunctionException,
        DeleteDirException,
        Env,
        FindItem,
        HOME,
        LineAction,
        MoveDirException,
        MoveException,
        MoveTreeException,
        // HeadException,
        PATH,
        PlatformEx,
        RunException,
        StackList,
        cat,
        copy,
        copyTree,
        createDir,
        createTempDir,
        createTempFile,
        createTempFilename,
        deleteDir,
        env,
        envs,
        exists,
        isDirectory,
        isEmpty,
        isFile,
        isLink,
        isOnPATH,
        move,
        moveDir,
        moveTree,
        privatePath,
        pwd,
        // RestoreFileException,
        rootPath,
        touch,
        truepath,
        verbose,
        withEnvironmentAsync,
        withTempDirAsync,
        withTempFileAsync
    // CatException;
    ;
export 'package:dcli_core/src/util/dev_null.dart';
export 'package:dcli_core/src/util/platform.dart';
export 'package:dcli_terminal/dcli_terminal.dart';

export 'src/functions/ask.dart';
export 'src/functions/backup.dart';
export 'src/functions/confirm.dart';
// ignore: deprecated_member_use_from_same_package
export 'src/functions/create_dir.dart' show withTempDir;
export 'src/functions/delete.dart' show DeleteException, delete;
export 'src/functions/echo.dart' show echo;
export 'src/functions/fetch.dart'
    show
        FetchData,
        FetchException,
        FetchMethod,
        FetchProgress,
        FetchStatus,
        FetchUrl,
        OnFetchProgress,
        fetch,
        fetchMultiple;
export 'src/functions/file_list.dart' show fileList;
export 'src/functions/find.dart' show Find, find;
export 'src/functions/head.dart' show head;
export 'src/functions/is.dart';
export 'src/functions/menu.dart' show menu;
export 'src/functions/read.dart' show ReadException, read, readStdin;
export 'src/functions/replace.dart' show replace;
export 'src/functions/run.dart' show run, start, startFromArgs;
export 'src/functions/sleep.dart' show Interval, sleep, sleepAsync;
export 'src/functions/tail.dart' show tail;
export 'src/functions/which.dart' show which;
export 'src/installers/installer.dart' show installFromSourceKey;
export 'src/progress/progress.dart' show Progress;
export 'src/resources/packed_resource.dart' show PackedResource;
export 'src/resources/resources.dart' show ResourceException, Resources;
export 'src/script/dart_project.dart';
export 'src/script/dart_script.dart' show DartScript;
export 'src/script/dart_sdk.dart' show DartSdk;
export 'src/settings.dart' show Settings;
export 'src/shell/shell.dart';
export 'src/shell/shell_detection.dart';
export 'src/shell/unknown_shell.dart';
export 'src/util/capture.dart' show capture;
export 'src/util/dcli_paths.dart' show DCliPaths;
export 'src/util/digest_helper.dart';
export 'src/util/editor.dart' show showEditor;
export 'src/util/exceptions.dart';
export 'src/util/file_sort.dart' show Column, FileSort, SortDirection;
export 'src/util/file_sync.dart';
export 'src/util/file_util.dart';
export 'src/util/named_lock.dart' show LockException, NamedLock;
export 'src/util/process_helper.dart' show ProcessDetails, ProcessHelper;
export 'src/util/pub_cache.dart';
export 'src/util/remote.dart' show Remote;
export 'src/util/runnable_process.dart' show printerr;
export 'src/util/string_as_process.dart';
export 'src/util/temp_file.dart';
