// Copyright 2013 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v26.1.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon
@file:Suppress("UNCHECKED_CAST", "ArrayInDataClass")

package io.flutter.plugins.videoplayer

import android.util.Log
import io.flutter.plugin.common.BasicMessageChannel
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.EventChannel
import io.flutter.plugin.common.MessageCodec
import io.flutter.plugin.common.StandardMessageCodec
import io.flutter.plugin.common.StandardMethodCodec
import java.io.ByteArrayOutputStream
import java.nio.ByteBuffer

private object MessagesPigeonUtils {

  fun wrapResult(result: Any?): List<Any?> {
    return listOf(result)
  }

  fun wrapError(exception: Throwable): List<Any?> {
    return if (exception is FlutterError) {
      listOf(exception.code, exception.message, exception.details)
    } else {
      listOf(
          exception.javaClass.simpleName,
          exception.toString(),
          "Cause: " + exception.cause + ", Stacktrace: " + Log.getStackTraceString(exception))
    }
  }

  fun deepEquals(a: Any?, b: Any?): Boolean {
    if (a is ByteArray && b is ByteArray) {
      return a.contentEquals(b)
    }
    if (a is IntArray && b is IntArray) {
      return a.contentEquals(b)
    }
    if (a is LongArray && b is LongArray) {
      return a.contentEquals(b)
    }
    if (a is DoubleArray && b is DoubleArray) {
      return a.contentEquals(b)
    }
    if (a is Array<*> && b is Array<*>) {
      return a.size == b.size && a.indices.all { deepEquals(a[it], b[it]) }
    }
    if (a is List<*> && b is List<*>) {
      return a.size == b.size && a.indices.all { deepEquals(a[it], b[it]) }
    }
    if (a is Map<*, *> && b is Map<*, *>) {
      return a.size == b.size &&
          a.all { (b as Map<Any?, Any?>).contains(it.key) && deepEquals(it.value, b[it.key]) }
    }
    return a == b
  }
}

/**
 * Error class for passing custom error details to Flutter via a thrown PlatformException.
 *
 * @property code The error code.
 * @property message The error message.
 * @property details The error details. Must be a datatype supported by the api codec.
 */
class FlutterError(
    val code: String,
    override val message: String? = null,
    val details: Any? = null
) : Throwable()

/** Pigeon equivalent of video_platform_interface's VideoFormat. */
enum class PlatformVideoFormat(val raw: Int) {
  DASH(0),
  HLS(1),
  SS(2);

  companion object {
    fun ofRaw(raw: Int): PlatformVideoFormat? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * Pigeon equivalent of Player's playback state.
 * https://developer.android.com/media/media3/exoplayer/listening-to-player-events#playback-state
 */
enum class PlatformPlaybackState(val raw: Int) {
  IDLE(0),
  BUFFERING(1),
  READY(2),
  ENDED(3),
  UNKNOWN(4);

  companion object {
    fun ofRaw(raw: Int): PlatformPlaybackState? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}

/**
 * Generated class from Pigeon that represents data sent in messages. This class should not be
 * extended by any user class outside of the generated file.
 */
sealed class PlatformVideoEvent
/**
 * Sent when the video is initialized and ready to play.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class InitializationEvent(
    /** The video duration in milliseconds. */
    val duration: Long,
    /** The width of the video in pixels. */
    val width: Long,
    /** The height of the video in pixels. */
    val height: Long,
    /** The rotation that should be applied during playback. */
    val rotationCorrection: Long
) : PlatformVideoEvent() {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): InitializationEvent {
      val duration = pigeonVar_list[0] as Long
      val width = pigeonVar_list[1] as Long
      val height = pigeonVar_list[2] as Long
      val rotationCorrection = pigeonVar_list[3] as Long
      return InitializationEvent(duration, width, height, rotationCorrection)
    }
  }

  fun toList(): List<Any?> {
    return listOf(
        duration,
        width,
        height,
        rotationCorrection,
    )
  }

  override fun equals(other: Any?): Boolean {
    if (other !is InitializationEvent) {
      return false
    }
    if (this === other) {
      return true
    }
    return MessagesPigeonUtils.deepEquals(toList(), other.toList())
  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * Sent when the video state changes.
 *
 * Corresponds to ExoPlayer's onPlaybackStateChanged.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class PlaybackStateChangeEvent(val state: PlatformPlaybackState) : PlatformVideoEvent() {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): PlaybackStateChangeEvent {
      val state = pigeonVar_list[0] as PlatformPlaybackState
      return PlaybackStateChangeEvent(state)
    }
  }

  fun toList(): List<Any?> {
    return listOf(
        state,
    )
  }

  override fun equals(other: Any?): Boolean {
    if (other !is PlaybackStateChangeEvent) {
      return false
    }
    if (this === other) {
      return true
    }
    return MessagesPigeonUtils.deepEquals(toList(), other.toList())
  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * Sent when the video starts or stops playing.
 *
 * Corresponds to ExoPlayer's onIsPlayingChanged.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class IsPlayingStateEvent(val isPlaying: Boolean) : PlatformVideoEvent() {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): IsPlayingStateEvent {
      val isPlaying = pigeonVar_list[0] as Boolean
      return IsPlayingStateEvent(isPlaying)
    }
  }

  fun toList(): List<Any?> {
    return listOf(
        isPlaying,
    )
  }

  override fun equals(other: Any?): Boolean {
    if (other !is IsPlayingStateEvent) {
      return false
    }
    if (this === other) {
      return true
    }
    return MessagesPigeonUtils.deepEquals(toList(), other.toList())
  }

  override fun hashCode(): Int = toList().hashCode()
}

/**
 * Information passed to the platform view creation.
 *
 * Generated class from Pigeon that represents data sent in messages.
 */
data class PlatformVideoViewCreationParams(val playerId: Long) {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): PlatformVideoViewCreationParams {
      val playerId = pigeonVar_list[0] as Long
      return PlatformVideoViewCreationParams(playerId)
    }
  }

  fun toList(): List<Any?> {
    return listOf(
        playerId,
    )
  }

  override fun equals(other: Any?): Boolean {
    if (other !is PlatformVideoViewCreationParams) {
      return false
    }
    if (this === other) {
      return true
    }
    return MessagesPigeonUtils.deepEquals(toList(), other.toList())
  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class CreationOptions(
    val uri: String,
    val formatHint: PlatformVideoFormat? = null,
    val httpHeaders: Map<String, String>,
    val userAgent: String? = null
) {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): CreationOptions {
      val uri = pigeonVar_list[0] as String
      val formatHint = pigeonVar_list[1] as PlatformVideoFormat?
      val httpHeaders = pigeonVar_list[2] as Map<String, String>
      val userAgent = pigeonVar_list[3] as String?
      return CreationOptions(uri, formatHint, httpHeaders, userAgent)
    }
  }

  fun toList(): List<Any?> {
    return listOf(
        uri,
        formatHint,
        httpHeaders,
        userAgent,
    )
  }

  override fun equals(other: Any?): Boolean {
    if (other !is CreationOptions) {
      return false
    }
    if (this === other) {
      return true
    }
    return MessagesPigeonUtils.deepEquals(toList(), other.toList())
  }

  override fun hashCode(): Int = toList().hashCode()
}

/** Generated class from Pigeon that represents data sent in messages. */
data class TexturePlayerIds(val playerId: Long, val textureId: Long) {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): TexturePlayerIds {
      val playerId = pigeonVar_list[0] as Long
      val textureId = pigeonVar_list[1] as Long
      return TexturePlayerIds(playerId, textureId)
    }
  }

  fun toList(): List<Any?> {
    return listOf(
        playerId,
        textureId,
    )
  }

  override fun equals(other: Any?): Boolean {
    if (other !is TexturePlayerIds) {
      return false
    }
    if (this === other) {
      return true
    }
    return MessagesPigeonUtils.deepEquals(toList(), other.toList())
  }

  override fun hashCode(): Int = toList().hashCode()
}

private open class MessagesPigeonCodec : StandardMessageCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      129.toByte() -> {
        return (readValue(buffer) as Long?)?.let { PlatformVideoFormat.ofRaw(it.toInt()) }
      }
      130.toByte() -> {
        return (readValue(buffer) as Long?)?.let { PlatformPlaybackState.ofRaw(it.toInt()) }
      }
      131.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let { InitializationEvent.fromList(it) }
      }
      132.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let { PlaybackStateChangeEvent.fromList(it) }
      }
      133.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let { IsPlayingStateEvent.fromList(it) }
      }
      134.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          PlatformVideoViewCreationParams.fromList(it)
        }
      }
      135.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let { CreationOptions.fromList(it) }
      }
      136.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let { TexturePlayerIds.fromList(it) }
      }
      else -> super.readValueOfType(type, buffer)
    }
  }

  override fun writeValue(stream: ByteArrayOutputStream, value: Any?) {
    when (value) {
      is PlatformVideoFormat -> {
        stream.write(129)
        writeValue(stream, value.raw.toLong())
      }
      is PlatformPlaybackState -> {
        stream.write(130)
        writeValue(stream, value.raw.toLong())
      }
      is InitializationEvent -> {
        stream.write(131)
        writeValue(stream, value.toList())
      }
      is PlaybackStateChangeEvent -> {
        stream.write(132)
        writeValue(stream, value.toList())
      }
      is IsPlayingStateEvent -> {
        stream.write(133)
        writeValue(stream, value.toList())
      }
      is PlatformVideoViewCreationParams -> {
        stream.write(134)
        writeValue(stream, value.toList())
      }
      is CreationOptions -> {
        stream.write(135)
        writeValue(stream, value.toList())
      }
      is TexturePlayerIds -> {
        stream.write(136)
        writeValue(stream, value.toList())
      }
      else -> super.writeValue(stream, value)
    }
  }
}

val MessagesPigeonMethodCodec = StandardMethodCodec(MessagesPigeonCodec())

/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface AndroidVideoPlayerApi {
  fun initialize()

  fun createForPlatformView(options: CreationOptions): Long

  fun createForTextureView(options: CreationOptions): TexturePlayerIds

  fun dispose(playerId: Long)

  fun setMixWithOthers(mixWithOthers: Boolean)

  fun getLookupKeyForAsset(asset: String, packageName: String?): String

  companion object {
    /** The codec used by AndroidVideoPlayerApi. */
    val codec: MessageCodec<Any?> by lazy { MessagesPigeonCodec() }
    /**
     * Sets up an instance of `AndroidVideoPlayerApi` to handle messages through the
     * `binaryMessenger`.
     */
    @JvmOverloads
    fun setUp(
        binaryMessenger: BinaryMessenger,
        api: AndroidVideoPlayerApi?,
        messageChannelSuffix: String = ""
    ) {
      val separatedMessageChannelSuffix =
          if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.video_player_android.AndroidVideoPlayerApi.initialize$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  api.initialize()
                  listOf(null)
                } catch (exception: Throwable) {
                  MessagesPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.video_player_android.AndroidVideoPlayerApi.createForPlatformView$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val optionsArg = args[0] as CreationOptions
            val wrapped: List<Any?> =
                try {
                  listOf(api.createForPlatformView(optionsArg))
                } catch (exception: Throwable) {
                  MessagesPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.video_player_android.AndroidVideoPlayerApi.createForTextureView$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val optionsArg = args[0] as CreationOptions
            val wrapped: List<Any?> =
                try {
                  listOf(api.createForTextureView(optionsArg))
                } catch (exception: Throwable) {
                  MessagesPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.video_player_android.AndroidVideoPlayerApi.dispose$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val playerIdArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.dispose(playerIdArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  MessagesPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.video_player_android.AndroidVideoPlayerApi.setMixWithOthers$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val mixWithOthersArg = args[0] as Boolean
            val wrapped: List<Any?> =
                try {
                  api.setMixWithOthers(mixWithOthersArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  MessagesPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.video_player_android.AndroidVideoPlayerApi.getLookupKeyForAsset$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val assetArg = args[0] as String
            val packageNameArg = args[1] as String?
            val wrapped: List<Any?> =
                try {
                  listOf(api.getLookupKeyForAsset(assetArg, packageNameArg))
                } catch (exception: Throwable) {
                  MessagesPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface VideoPlayerInstanceApi {
  /** Sets whether to automatically loop playback of the video. */
  fun setLooping(looping: Boolean)
  /** Sets the volume, with 0.0 being muted and 1.0 being full volume. */
  fun setVolume(volume: Double)
  /** Sets the playback speed as a multiple of normal speed. */
  fun setPlaybackSpeed(speed: Double)
  /** Begins playback if the video is not currently playing. */
  fun play()
  /** Pauses playback if the video is currently playing. */
  fun pause()
  /** Seeks to the given playback position, in milliseconds. */
  fun seekTo(position: Long)
  /** Returns the current playback position, in milliseconds. */
  fun getCurrentPosition(): Long
  /** Returns the current buffer position, in milliseconds. */
  fun getBufferedPosition(): Long

  companion object {
    /** The codec used by VideoPlayerInstanceApi. */
    val codec: MessageCodec<Any?> by lazy { MessagesPigeonCodec() }
    /**
     * Sets up an instance of `VideoPlayerInstanceApi` to handle messages through the
     * `binaryMessenger`.
     */
    @JvmOverloads
    fun setUp(
        binaryMessenger: BinaryMessenger,
        api: VideoPlayerInstanceApi?,
        messageChannelSuffix: String = ""
    ) {
      val separatedMessageChannelSuffix =
          if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.video_player_android.VideoPlayerInstanceApi.setLooping$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val loopingArg = args[0] as Boolean
            val wrapped: List<Any?> =
                try {
                  api.setLooping(loopingArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  MessagesPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.video_player_android.VideoPlayerInstanceApi.setVolume$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val volumeArg = args[0] as Double
            val wrapped: List<Any?> =
                try {
                  api.setVolume(volumeArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  MessagesPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.video_player_android.VideoPlayerInstanceApi.setPlaybackSpeed$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val speedArg = args[0] as Double
            val wrapped: List<Any?> =
                try {
                  api.setPlaybackSpeed(speedArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  MessagesPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.video_player_android.VideoPlayerInstanceApi.play$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  api.play()
                  listOf(null)
                } catch (exception: Throwable) {
                  MessagesPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.video_player_android.VideoPlayerInstanceApi.pause$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  api.pause()
                  listOf(null)
                } catch (exception: Throwable) {
                  MessagesPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.video_player_android.VideoPlayerInstanceApi.seekTo$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val positionArg = args[0] as Long
            val wrapped: List<Any?> =
                try {
                  api.seekTo(positionArg)
                  listOf(null)
                } catch (exception: Throwable) {
                  MessagesPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.video_player_android.VideoPlayerInstanceApi.getCurrentPosition$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  listOf(api.getCurrentPosition())
                } catch (exception: Throwable) {
                  MessagesPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel =
            BasicMessageChannel<Any?>(
                binaryMessenger,
                "dev.flutter.pigeon.video_player_android.VideoPlayerInstanceApi.getBufferedPosition$separatedMessageChannelSuffix",
                codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            val wrapped: List<Any?> =
                try {
                  listOf(api.getBufferedPosition())
                } catch (exception: Throwable) {
                  MessagesPigeonUtils.wrapError(exception)
                }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}

private class MessagesPigeonStreamHandler<T>(val wrapper: MessagesPigeonEventChannelWrapper<T>) :
    EventChannel.StreamHandler {
  var pigeonSink: PigeonEventSink<T>? = null

  override fun onListen(p0: Any?, sink: EventChannel.EventSink) {
    pigeonSink = PigeonEventSink<T>(sink)
    wrapper.onListen(p0, pigeonSink!!)
  }

  override fun onCancel(p0: Any?) {
    pigeonSink = null
    wrapper.onCancel(p0)
  }
}

interface MessagesPigeonEventChannelWrapper<T> {
  open fun onListen(p0: Any?, sink: PigeonEventSink<T>) {}

  open fun onCancel(p0: Any?) {}
}

class PigeonEventSink<T>(private val sink: EventChannel.EventSink) {
  fun success(value: T) {
    sink.success(value)
  }

  fun error(errorCode: String, errorMessage: String?, errorDetails: Any?) {
    sink.error(errorCode, errorMessage, errorDetails)
  }

  fun endOfStream() {
    sink.endOfStream()
  }
}

abstract class VideoEventsStreamHandler : MessagesPigeonEventChannelWrapper<PlatformVideoEvent> {
  companion object {
    fun register(
        messenger: BinaryMessenger,
        streamHandler: VideoEventsStreamHandler,
        instanceName: String = ""
    ) {
      var channelName: String =
          "dev.flutter.pigeon.video_player_android.VideoEventChannel.videoEvents"
      if (instanceName.isNotEmpty()) {
        channelName += ".$instanceName"
      }
      val internalStreamHandler = MessagesPigeonStreamHandler<PlatformVideoEvent>(streamHandler)
      EventChannel(messenger, channelName, MessagesPigeonMethodCodec)
          .setStreamHandler(internalStreamHandler)
    }
  }
}
