package info.guardianproject;

import info.guardianproject.trustedintents.ApkSignaturePin;

/**
 * This is the second Guardian Project APK signing key. It was generated since
 * RSA 1024-bit keys are deprecated. So any new Guardian Project app will be
 * signed by this key. It is used to sign these apps:
 * <ul>
 * <li>Checkey</li>
 * <li>Courier</li>
 * </ul>
 *
 * @author hans
 */
public final class GuardianProjectRSA4096 extends ApkSignaturePin {

   public GuardianProjectRSA4096() {
      fingerprints = new String[] {
              "f006a20481c71a690de02e385ab0c9fa4ac1245240f68102682703ba0656867a",
      };
      certificates = new byte[][] {
              {
                      48, -126, 5, -84, 48, -126, 3, -108, 2, 9, 0, -126, -20, 93, -43, 112, 34,
                      -87, 29, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127,
                      -105, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 17, 48, 15, 6, 3,
                      85, 4, 8, 12, 8, 78, 101, 119, 32, 89, 111, 114, 107, 49, 17, 48, 15, 6, 3,
                      85, 4, 7, 12, 8, 78, 101, 119, 32, 89, 111, 114, 107, 49, 25, 48, 23, 6, 3,
                      85, 4, 10, 12, 16, 71, 117, 97, 114, 100, 105, 97, 110, 32, 80, 114, 111,
                      106, 101, 99, 116, 49, 29, 48, 27, 6, 3, 85, 4, 3, 12, 20, 103, 117, 97,
                      114, 100, 105, 97, 110, 112, 114, 111, 106, 101, 99, 116, 46, 105, 110,
                      102, 111, 49, 40, 48, 38, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22,
                      25, 114, 111, 111, 116, 64, 103, 117, 97, 114, 100, 105, 97, 110, 112, 114,
                      111, 106, 101, 99, 116, 46, 105, 110, 102, 111, 48, 30, 23, 13, 49, 52, 48,
                      53, 49, 52, 49, 55, 53, 55, 50, 57, 90, 23, 13, 52, 49, 48, 57, 50, 56, 49,
                      55, 53, 55, 50, 57, 90, 48, -127, -105, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19,
                      2, 85, 83, 49, 17, 48, 15, 6, 3, 85, 4, 8, 12, 8, 78, 101, 119, 32, 89,
                      111, 114, 107, 49, 17, 48, 15, 6, 3, 85, 4, 7, 12, 8, 78, 101, 119, 32, 89,
                      111, 114, 107, 49, 25, 48, 23, 6, 3, 85, 4, 10, 12, 16, 71, 117, 97, 114,
                      100, 105, 97, 110, 32, 80, 114, 111, 106, 101, 99, 116, 49, 29, 48, 27, 6,
                      3, 85, 4, 3, 12, 20, 103, 117, 97, 114, 100, 105, 97, 110, 112, 114, 111,
                      106, 101, 99, 116, 46, 105, 110, 102, 111, 49, 40, 48, 38, 6, 9, 42, -122,
                      72, -122, -9, 13, 1, 9, 1, 22, 25, 114, 111, 111, 116, 64, 103, 117, 97,
                      114, 100, 105, 97, 110, 112, 114, 111, 106, 101, 99, 116, 46, 105, 110,
                      102, 111, 48, -126, 2, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1,
                      1, 5, 0, 3, -126, 2, 15, 0, 48, -126, 2, 10, 2, -126, 2, 1, 0, -51, 108,
                      83, -44, 61, 81, 46, 61, 2, -61, 46, 60, 2, -30, 44, 38, -70, -63, -93,
                      -66, -57, 1, 2, -32, -80, -82, 98, -26, -70, -34, 60, -65, -55, -43, 16,
                      -63, -89, -104, 50, 108, -26, -2, -3, -55, -77, 47, 75, 89, 99, 12, -32,
                      32, 120, -26, -81, 54, 95, -57, -114, -100, -39, -110, -4, 120, 90, 90,
                      -40, -89, -53, 63, -122, -45, -80, 32, -6, -12, -29, -107, 45, 10, -23, 76,
                      5, 112, -15, -63, 48, 35, -61, 0, -107, -110, 44, -46, -126, -30, -30, -33,
                      86, 22, 30, 8, -72, 29, 75, 121, 31, -120, 119, 59, -57, 19, -64, 31, 84,
                      -94, -38, 91, 82, 92, -95, 66, 2, 120, -37, -113, 126, 54, -83, 83, -125,
                      122, 110, -106, 80, 59, -127, -72, -23, 64, 105, 20, 25, -41, -3, -61, -44,
                      51, -28, 17, 36, -90, -18, -25, 96, 37, -93, -48, 98, 47, 27, 49, 40, -31,
                      -62, -102, -49, 28, -55, 50, -38, -70, -83, 101, 97, 96, -122, -114, 18,
                      47, 119, 117, -7, -55, -64, -1, 96, -120, 61, -89, -70, -7, -89, 113, -41,
                      88, 27, 26, 95, -52, 53, 59, 7, 11, 79, 86, 31, -109, -21, 120, -15, 38,
                      106, 33, -121, 82, 18, 45, 32, 49, 93, -26, -74, -104, 4, -122, 96, 39,
                      126, -24, 16, 119, -45, -119, 110, -31, 55, -109, 53, 53, -11, -58, -124,
                      -84, 41, -42, 64, 17, -5, -78, -57, -100, 118, -105, -38, -94, 84, -16,
                      -53, -106, -11, 76, 81, 70, -83, -56, 73, -96, -100, -18, 55, -3, -3, 34,
                      -97, -62, 59, -17, -79, 91, -9, 122, 95, -108, -121, -76, -62, -72, 61,
                      -82, 105, -99, -59, 10, 51, 52, 77, -105, -127, 37, 79, 88, -127, 27, 39,
                      44, 15, 123, -59, -118, -96, 61, -28, 23, -54, 124, 100, 57, 37, 123, -83,
                      -124, 11, 123, 73, -53, 18, 119, -39, -13, 46, 123, -55, 4, -91, 114, 93,
                      -116, -98, 21, 95, -30, -82, -108, 87, -65, -8, 30, 67, 14, 22, 79, -64,
                      86, -128, -83, 74, 69, -42, 9, -18, -120, -52, 7, 62, 78, 88, -53, -125,
                      41, -122, -91, -34, -110, 111, -118, -25, 25, -83, 90, -95, 84, -121, 95,
                      72, -53, -14, -14, -48, 65, 4, 23, 99, 56, 23, -20, 9, 46, 63, 83, -26,
                      -86, 54, -104, 79, 9, 94, -91, -69, 10, -125, -17, -28, -32, -79, 5, -11,
                      37, 103, -46, -75, 71, -119, 39, 48, -53, -51, 118, 43, 28, 68, 14, -33,
                      -82, -76, -98, 1, 41, 94, -128, -86, 51, -89, 17, -31, 38, -70, -2, -27,
                      -105, -87, 103, 93, 19, 73, -106, -82, -76, 110, -48, -124, -51, 92, -91,
                      -51, 22, 1, -48, 52, -127, -24, 26, -77, 4, 22, 33, 24, -128, -1, 9, -42,
                      23, -53, 78, 10, -39, -115, -95, 17, 100, 90, 16, -23, -127, -38, 10, -62,
                      -64, 113, -115, -114, 78, -11, -124, 113, 113, -42, -66, 114, -98, -40,
                      -41, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5,
                      0, 3, -126, 2, 1, 0, -54, 125, -113, -9, -45, 82, 2, -79, -87, 31, -17,
                      -10, 117, 16, 1, 67, -63, 57, -49, -81, -90, 48, 7, -58, 89, -29, 120, 84,
                      116, 51, 54, -94, 74, -111, -11, 53, -13, 53, -125, -76, -64, 46, -35, 19,
                      -19, 25, 36, -82, 66, 113, -14, -6, -63, 83, 15, 8, -77, -74, -94, -53,
                      -35, -61, -75, 52, 13, -128, 9, 96, 66, 46, 46, -57, 24, -28, -39, -46, 96,
                      -115, -63, 92, -70, 51, 49, -94, 96, 77, 16, 108, -59, -28, 112, -2, -3,
                      -87, 27, 56, 118, 29, -95, -76, -70, 34, -105, -24, -104, 70, 24, -88, -29,
                      -28, -101, -98, 24, -48, -32, -111, 97, 61, -70, -21, -111, 70, -55, 68,
                      -76, 125, -61, 56, -122, 48, -118, 74, 61, -101, -46, -43, -12, -114, -116,
                      -57, -108, 91, -109, -62, -117, -76, -48, 109, 81, -22, -113, -73, 64, -61,
                      102, 92, -117, -9, -100, 62, -90, 99, 102, -50, -41, -75, 31, 5, -76, -31,
                      -85, 118, -57, -21, 102, 71, 41, -34, -45, -92, 88, 82, -95, 65, -100, -31,
                      -28, -85, -37, 94, -52, 72, 39, 55, -42, 18, 29, 115, 23, -106, -2, -54,
                      -45, 61, 53, 62, 107, 109, -65, 69, 4, -123, 124, -30, -54, -44, 38, 119,
                      49, -123, -27, -50, 77, -9, -40, -114, -50, -70, -123, 86, -115, 127, 45,
                      42, 23, -25, -83, -81, -38, -84, -3, 99, -36, 12, -67, -39, -110, 21, -40,
                      -128, 6, -96, -24, -116, -62, 63, 127, 39, 57, -83, -63, 0, 127, -12, 73,
                      85, -41, -101, -70, -48, -94, -94, -73, -38, -115, -62, -34, 62, -92, 96,
                      16, 6, -19, -84, 38, -93, -117, -52, 32, 92, -21, 123, -117, 81, 50, -71,
                      103, 121, 127, 4, -3, -40, 62, 100, 22, -123, -68, -69, -54, -127, -67, 50,
                      -114, 77, -30, 26, -102, 29, 106, 48, 83, 99, 73, 96, 124, -77, 51, 8, 15,
                      40, 72, -108, 105, 62, 119, -113, -90, 57, -62, 127, -57, -21, -40, -109,
                      96, 101, 71, -40, -101, 127, 69, 110, 43, 59, -102, -8, -42, -70, -24, 51,
                      -51, 54, 42, -110, -119, 41, -101, 45, -101, -124, 56, -75, -26, 86, -65,
                      54, 21, -88, -30, 79, -26, -127, 121, -102, -48, -25, -62, 99, 76, -90,
                      -48, -37, 123, 9, 67, 51, -41, -116, 29, 69, 88, 93, -42, 23, 73, -112, 24,
                      -85, 60, 1, 3, -95, 12, -49, -55, 95, 109, -37, 10, -124, 119, -52, -31,
                      91, 55, -67, 99, 87, -55, 97, 25, -9, -119, -41, -98, 100, -14, 70, -44,
                      -63, 60, -127, -99, 15, 49, 22, -118, -49, 66, -106, 36, -34, -5, 6, -48,
                      123, -79, 115, 57, 30, -3, -34, -67, 91, 34, 3, -52, -106, 79, -63, 125,
                      123, -16, -120, -53, -98, 34, 86, -60, 94, 78, -91, -34, 0, -8, 73, -119,
                      -87, 12, -101, -112, -10, -79, 10, 105, -82, 120, -106, -9, 99, 57, -63,
                      -26, 125, -80, 102, -106, -11, -91, -1, 37, 33
              },
      };
   }
}
