/**
 * This file is part of Breezy Weather.
 *
 * Breezy Weather is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation, version 3 of the License.
 *
 * Breezy Weather is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Breezy Weather. If not, see <https://www.gnu.org/licenses/>.
 */

package breezyweather.domain.weather.model

import breezyweather.domain.weather.reference.WeatherCode
import breezyweather.domain.weather.wrappers.HalfDayWrapper
import java.io.Serializable

/**
 * Half day.
 */
data class HalfDay(
    /**
     * A short description of the weather condition
     */
    val weatherText: String? = null,

    /**
     * A long description of the weather condition. Used as a half-day summary
     */
    val weatherSummary: String? = null,
    val weatherCode: WeatherCode? = null,
    val temperature: Temperature? = null,
    val precipitation: Precipitation? = null,
    val precipitationProbability: PrecipitationProbability? = null,
    val precipitationDuration: PrecipitationDuration? = null,
    val wind: Wind? = null,
) : Serializable {

    fun toHalfDayWrapper() = HalfDayWrapper(
        weatherText = this.weatherText,
        weatherSummary = this.weatherSummary,
        weatherCode = this.weatherCode,
        temperature = this.temperature?.toTemperatureWrapper(),
        precipitation = this.precipitation,
        precipitationProbability = this.precipitationProbability,
        precipitationDuration = this.precipitationDuration,
        wind = this.wind
    )
}
