# API keys

GitHub releases contain default API keys of the project that make all weather sources work by default (until API limits are reached).

If you want to self-build, you can add your own API keys in `local.properties` for sources to be configured by default in the build:
```properties
breezy.accu.portal=developer
breezy.accu.key=myapikey
breezy.accu.days=15
breezy.accu.hours=120
breezy.atmoaura.key=myapikey
breezy.atmofrance.key=myapikey
breezy.atmograndest.key=myapikey
breezy.atmohdf.key=myapikey
breezy.atmosud.key=myapikey
breezy.baiduip.key=myapikey
breezy.eccc.key=myapikey
breezy.geonames.key=myapikey
breezy.here.key=myapikey
breezy.mf.jwtKey=myapikey
breezy.mf.key=myapikey
breezy.openweather.key=myapikey
breezy.pirateweather.key=myapikey
```

You can omit any of the following properties to let the user configure their own API key in the settings, or only use API-key-less sources (such as Open-Meteo).


# Release management

*Instructions for members of the organization.*

1) Test your debug build.
2) Run tests `./gradlew testBasicDebugUnitTest` and `./gradlew testDebugUnitTest`.
3) Try to assemble a release `./gradlew assembleBasicRelease`.
4) Update versionCode and versionName in `app/build.gradle`.
5) Write changelog in `CHANGELOG.md`.
6) Commit all changes.
7) Tag version beginning with a `v` (example: `git tag v6.0.12 -m "Version 6.0.12"`).
8) Push with `git push --tags`
9) GitHub action will run and sign the release.
10) Update GitHub release notes draft and publish.
11) Update GitHub templates in `.github/` to show the new latest version.


# Adding a new source

After merging a new source, the following things need to be done:
1) Update `CHANGELOG.md`
2) Update `docs/SOURCES.md`
3) Update `docs/COVERAGE.md`
4) Update `fastlane/metadata/android/{en-US,fr,it}/full_description.txt`


# Decode crash logs from users

1) Save crash log in a text file `stacktrace.txt` and remove things like `2023-08-14 21:28:58.229 12804-12804 View org.breezyweather.debug` if they are present.
2) From the release page, download mapping-vX.Y.Z-standard.tar.gz or mapping-vX.Y.Z-freenet.tar.gz depending on the flavor used by the user.
3) Unzip `mapping.txt`.
4) `~/Android/Sdk/cmdline-tools/latest/bin/retrace mapping.txt stacktrace.txt`


# Translations

## Updated translations

When translations are updated from Weblate, if there are new contributors, add them in `app/src/main/java/org/breezyweather/settings/activities/AboutActivity.kt`.


## Added translations

When a translation is added, add the CLDR data for this locale in the weather-unit library.


# Dependencies

## Update Gradle

Gradle must always be updated that way (replace with new version number):
```
./gradlew wrapper --gradle-version=9.2.0 --gradle-distribution-sha256-sum=df67a32e86e3276d011735facb1535f64d0d88df84fa87521e90becc2d735444
```

You can find the newer checksum of the binary-only (-bin) ZIP on https://gradle.org/release-checksums/


# Dropping support for an Android version

1. In `org.breezyweather.background.updater.AppUpdateChecker`, uncomment the relevant lines to trigger a notification on the unsupported Android versions
2. In `org.breezyweather.background.weather.WeatherUpdateJob`, uncomment the relevant lines to always enable “check for update” on these unsupported Android versions, to ensure that `freenet` users and users who disabled update check correctly receive the notification. No actual update check will be performed, so it’s safe to force it enabled.


# Adding a new Material Icon

You can find [many Material Symbols and Icons here](https://fonts.google.com/icons).


____

# Weather sources API

Weather sources API can change: some versions may become deprecated, new endpoints may be added, new countries may be supported (when documented, we filter countries in app to avoid unnecessary calls on unsupported countries).

This section keep track of endpoints and when they were last checked.

## Open-Meteo

*Last checked: 2024-04-16*

| Endpoint            | Version  | Notes                                                                                                                                                                                                                              |
|---------------------|----------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Geocoding — Search  | v1       | Partial support for Postal code, see [open-meteo/geocoding-api#8](https://github.com/open-meteo/geocoding-api/issues/8), missing admin codes, see [open-meteo/open-meteo#355](https://github.com/open-meteo/open-meteo/issues/355) |
| Weather — Forecast  | v1       |                                                                                                                                                                                                                                    |
| Air quality         | v1       |                                                                                                                                                                                                                                    |

Future additional endpoints/improvements for existing endpoints:
- Reverse geocoding, see [open-meteo/geocoding-api#6](https://github.com/open-meteo/geocoding-api/issues/6)
- Alerts, see [open-meteo/open-meteo#351](https://github.com/open-meteo/open-meteo/issues/351)
- Moon rise, set and phases, see [open-meteo/open-meteo#87](https://github.com/open-meteo/open-meteo/issues/87)
- Normals, see [open-meteo/open-meteo#361](https://github.com/open-meteo/open-meteo/issues/361)


## AccuWeather

*Last checked: 2024-04-16*

https://apidev.accuweather.com/developers/

| Endpoint               | Version | Notes                                                      |
|------------------------|---------|------------------------------------------------------------|
| Location — Translate   | v1      |                                                            |
| Location — Geoposition | v1      |                                                            |
| Current conditions     | v1      |                                                            |
| Daily                  | v1      | Up to 45 days, but useless                                 |
| Hourly                 | v1      | Up to 240 hours                                            |
| Minutely               | v1      | 1 minute precision                                         |
| Alerts by geoposition  | v1      |                                                            |
| Alerts by location     | v1      |                                                            |
| Air quality            | v2      | Up to 96 hours. TODO: Observational endpoint for SK and CN |
| Climo                  | v1      |                                                            |


## MET Norway

*Last checked: 2024-04-16*

https://api.met.no/

| Endpoint          | Version | Notes                                                                                                     |
|-------------------|---------|-----------------------------------------------------------------------------------------------------------|
| Location forecast | 2.0     |                                                                                                           |
| Sunrise           | 3.0     | It is technically feasible to retrieve data for future days, but requires two calls for each, so we avoid |
| Nowcast           | 2.0     | Norway, Sweden, Finland and Denmark only                                                                  |
| Air quality       | 0.1     | Norway only                                                                                               |

Not yet implemented in app:

| Endpoint    | Version | Notes                                                                      |
|-------------|---------|----------------------------------------------------------------------------|
| MET alerts  | 1.1     | Norway only by country code, wait for v2.0 in May to get alerts by lat,lon |

No location search endpoint exists, it uses Open-Meteo instead.


## OpenWeather

*Last checked: 2024-04-16*

https://openweathermap.org/api

| Endpoint                | Version |
|-------------------------|---------|
| Current                 | 2.5     |
| 5 Day / 3 Hour Forecast | 2.5     |
| Air Pollution           | 2.5     |


## Pirate Weather

*Last checked: 2025-10-30*

https://github.com/Pirate-Weather/pirateweather

| Endpoint | Version  | Notes                  |
|----------|----------|------------------------|
| Forecast | v2.7.11  | V2.8 is in pre-release |

We should check regularly for additional fields we could use. Latest version checked is written above, everything more recent requires to check changelog.


## Météo-France

*Last checked: 2024-02-13*

| Endpoint    | Version |
|-------------|---------|
| Forecast    | v2      |
| Observation | v2      |
| Nowcast     | v3      |
| Ephemeris   | None    |
| Warning     | v3      |

Not used:

| Endpoint | Version | Notes                                                                                |
|----------|---------|--------------------------------------------------------------------------------------|
| Places   | V2      | Doesn’t have mandatory timezone field, miss many data on countries other than France |

Uses Open-Meteo for location search.


## DMI

*To be documented*


## China

*Legacy source, undocumented*


## National Weather Service (NWS)

*To be documented*


## GeoSphere Austria

*To be documented*


## Bright Sky

*Last checked: 2024-04-16*

| Endpoint        | Version |
|-----------------|---------|
| Weather         | v2.1    |
| Current weather | v2.1    |
| Alerts          | v2.1    |


## ECCC

*Last checked: 2024-01-26*

| Endpoint    | Version |
|-------------|---------|
| Location    | v2      |


## Israel Meteorological Service

*To be documented*


## SMHI

*Last checked: 2024-01-26*

| Endpoint | Version |
|----------|---------|
| Weather  | 2       |


## MET Éireann

*To be documented*
