# ![Logo](src/main/res/drawable-hdpi/ic_launcher.png) Gridle [![.github/workflows/build.yml](https://github.com/billthefarmer/gridle/actions/workflows/build.yml/badge.svg)](https://github.com/billthefarmer/gridle/actions/workflows/build.yml)

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.svg" alt="Get it on F-Droid" height="80">](https://f-droid.org/packages/org.billthefarmer.gridle/)

Fairly simple android word game.

![Gridle](https://github.com/billthefarmer/billthefarmer.github.io/raw/master/images/Gridle.png) ![Large](https://github.com/billthefarmer/billthefarmer.github.io/raw/master/images/Gridle-large.png)

 * Multiple coloured themes

## Guess those words
Move letters in the grid to make a gridle of words. It's a good idea
to use a soft tipped stylus to see what you are doing, as it's
difficult to see past stubby fingers.

## Display colours
Letters which are in the word but in the wrong place will turn
yellow. Remember this can be in both directions. If they are in the
right place they will turn green. If they are not in the word they
will turn grey. Keep trying until you have guessed all the the
words. The colours may be changed by selecting **Highlight colours**
in the menu.

## Scoring
The seconds since the game started and the move count is displayed in
the toolbar. The timing will stop if the app is in the background and
restart when brought back.

## Refresh
Tap the **Refresh** button in the toolbar to clear the display and
generate another gridle of words. Words are chosen at random from a list,
and are checked that they haven't been used recently.

## Share
Tap the **Share** button in the toolbar to share an image or text
from the display.

### Image
Share an image of the display.

### Text
Share text from the display. Tap a letter to select a word. The
letters and colours of the word will be shared. Select the
[Crossword](https://github.com/billthefarmer/crossword) app to find
possibilities for that word. **Hint:** If the crossword app fails to
produce any suggestions, try moving any letter which might belong to
the other direction.

## Large
Solve a larger 7x7 grid of words. This may show an initial blank grid
and rotating working symbol while the larger puzzle is
created. Similarly, tapping the refresh button may not create a new
puzzle immediately.

## System gestures
Because dragging letters can inadvertently close the app if system
gestures are enabled, back gestures are disabled over most of the
letter grid. Also back gestures will refresh the display if a game is
in progress. Use the navigation menu or refresh to enable the back
gesture.

## Add accents
Long press on a letter in the solved word grid. This will show a
pop-up menu of unaccented and accented letters. Pick the required
unaccented or accented letter.

## Meaning
Once you have solved the word grid, tap on a letter that uniquely
identifies a word to display the meaning.

## Themes
Select coloured themes from the **Theme** item in the menu.

## Language
Select **Language** from the menu.

## Highlight colours
A dialog will pop up showing two guesses, one containing some letters
in the word in the wrong place and a correct guess, and three
spectrums. Change the colour of the letters in the wrong place by
tapping on the top spectrum, and the correct letters with the middle
spectrum. Change the shade of grey of the letters not in the word
with the bottom spectrum. The **Reset** button will restore the
default colours, The **Cancel** button changes nothing, and the **OK**
button accepts the changes.

## Cheat
Use my [Crossword](https://github.com/billthefarmer/crossword) or
[WordleSolver](https://github.com/billthefarmer/wordlesolver) app to
cheat.
