class GameData {
  static const Map<String, Map<String, List<String>>> templates = {
    '2x2': {
      'easy': [
        // 2x2-easy grids
        '0000001432010402',
        '0000004213204003',
        '0000040021434012',
        '0000040112340012',
        '0000123430422010',
        '0000130231004210',
        '0000140241002040',
        '0000200302010142',
        '0000203410004210',
        '0000213402403002',
        '0000230004021204',
        '0000230440023201',
        '0000312440010342',
        '0000340112304302',
        '0001002341300200',
        '0001020420103042',
        '0001030224100124',
        '0001100204100120',
        '0001134240000104',
        '0001142303040130',
        '0001203402403000',
        '0002001002433400',
        '0002241300301304',
        '0002300020041420',
        '0002304113202400',
        '0002321400400123',
        '0003021023011400',
        '0003021423004000',
        '0003030032401002',
        '0003030130040102',
        '0003030430020430',
        '0003031001200431',
        '0003032024303140',
        '0003100041003240',
        '0003231000424230',
        '0003300213002031',
        '0003301021000021',
        '0003430014003010',
        '0004010003401420',
        '0004042332010100',
        '0004341043010203',
        '0004403004200301',
        '0004430234210100',
        '0010103202004120',
        '0010140301322000',
        '0010400014300240',
        '0012013002030420',
        '0012120300344000',
        '0012200402030300',
        '0013010224300000',
        '0013130002004132',
        '0013300020300340',
        '0014000304311042',
        '0014000330001432',
        '0014002040020301',
        '0014040200404300',
        '0014143200004021',
        '0014402300020240',
        '0014410220400000',
        '0020213004001203',
        '0020231032400100',
        '0020400004013042',
        '0020420034120040',
        '0020423013020003',
        '0021200040121204',
        '0021203043001043',
        '0023001020001402',
        '0023034040300004',
        '0023201400410102',
        '0023304020340002',
        '0024003140000243',
        '0030010224000320',
        '0030040212034301',
        '0030231014030200',
        '0030234041030014',
        '0031004220103020',
        '0031030000033204',
        '0031102024000142',
        '0031314210000403',
        '0032004120100100',
        '0034340040202100',
        '0034432000402000',
        '0040021300200134',
        '0040023001242010',
        '0040043200232004',
        '0040140301322300',
        '0040142040102104',
        '0040340040012134',
        '0040430234210100',
        '0041013004232000',
        '0041040002144130',
        '0041140200130100',
        '0100001412033420',
        '0100002134120203',
        '0100201002411403',
        '0100324120040403',
        '0100420023401030',
        '0102021410200001',
        '0103300013200231',
        '0103342003021200',
        '0120021300310040',
        '0120023024031000',
        '0120201013404000',
        '0123324000001032',
        '0130042110430002',
        '0130340003120040',
        '0132200004211000',
        '0134032002403000',
        '0140001240001230',
        '0142001020301004',
        '0142243000040200',
        '0200143041230010',
        '0200410210002340',
        '0201013204001320',
        '0203032030022004',
        '0204142020010102',
        '0204300221030001',
        '0204301203000043',
        '0210013200230041',
        '0210130031402400',
        '0230000120130140',
        '0230100004033024',
        '0240403003040420',
        '0243301240010030',
        '0300210304200034',
        '0300214304020230',
        '0300410000141423',
        '0301043030244200',
        '0302004301042400',
        '0302401000040421',
        '0302420021340400',
        '0304243002033000',
        '0304412002001402',
        '0310042300414030',
        '0312000304013120',
        '0314010200003201',
        '0314140000303001',
        '0321023400033040',
        '0324200031024010',
        '0342003104030004',
        '0342023030240003',
        '0342200000030214',
        '0400024101202010',
        '0400104040303024',
        '0400124041002300',
        '0400204303120004',
        '0400320100230304',
        '0401014240100304',
        '0401100030024213',
        '0402003440010240',
        '0403002432004100',
        '0403004202344300',
        '0412000040012043',
        '0420004141022010',
        '0420200002344302',
        '0420301401300001',
        '0420324003140000',
        '0430020421400001',
        '0431302000001340',
        '1000000441032340',
        '1000001204202130',
        '1000034042030104',
        '1000040132004123',
        '1000234032040120',
        '1000300140232014',
        '1000341040002341',
        '1002001342300024',
        '1002234140003200',
        '1002421300010020',
        '1003341200004001',
        '1004201300313000',
        '1030201432400100',
        '1040000204012104',
        '1040030104022104',
        '1040032034000134',
        '1043400200303024',
        '1200000020343402',
        '1200402001303010',
        '1203001034012000',
        '1240340001000012',
        '1300000030122103',
        '1304000332410002',
        '1304040331000031',
        '1324020330000031',
        '1340403030040003',
        '1420304100300002',
        '1423024000020034',
        '1432230002010000',
        '2000030034210204',
        '2000032010033402',
        '2000032102140402',
        '2000140030414120',
        '2000402104303210',
        '2001010014303014',
        '2003040203204200',
        '2003302440300042',
        '2004102032404002',
        '2013014200040230',
        '2013030041003040',
        '2013310002000324',
        '2014412000001402',
        '2040410200101400',
        '2040413010003200',
        '2100000010024213',
        '2104041203001040',
        '2104341200010200',
        '2130001200404300',
        '2130030000403012',
        '2130400214030200',
        '2140302003001034',
        '2300002340010102',
        '2300102300023001',
        '2300410004030214',
        '2301403032000400',
        '2304003201203040',
        '2340100330100032',
        '2341042300003004',
        '2341140040320000',
        '2400104002144003',
        '2403104002310020',
        '2410030400014130',
        '2413034030000230',
        '2430300040000243',
        '3001210002344000',
        '3002000403012143',
        '3002103040200340',
        '3004003100001243',
        '3010010400201203',
        '3012203410034000',
        '3021100021034010',
        '3021210043100030',
        '3024043000101042',
        '3040040103244010',
        '3040400303100032',
        '3041140000232010',
        '3041400200202014',
        '3100043002030012',
        '3100240303404000',
        '3104020100020413',
        '3104201010400230',
        '3120000002101302',
        '3140243002000024',
        '3142000002031300',
        '3142400000300304',
        '3200003014002310',
        '3200103201200304',
        '3204002023004032',
        '3210002024010300',
        '3214000013000430',
        '3240140300340010',
        '3241400004322000',
        '3241400300022004',
        '3400020340022030',
        '3400104320340002',
        '3400210310040302',
        '3400210402004302',
        '3401103421000010',
        '3410010012404001',
        '3410214000001030',
        '3421010400021040',
        '4000014310043001',
        '4000124004010034',
        '4000124304013004',
        '4000201430211200',
        '4000204310003420',
        '4000213010033200',
        '4001012424001002',
        '4001020404103040',
        '4003000020310124',
        '4003300114020304',
        '4010004324010104',
        '4010120030042031',
        '4012014010340000',
        '4012120334002000',
        '4013310010420001',
        '4020104030022034',
        '4020214000300410',
        '4021004330020130',
        '4021103400130002',
        '4021200002303012',
        '4030302413002010',
        '4031130034020100',
        '4100201410303000',
        '4120201400320040',
        '4132200110200200',
        '4200000020011324',
        '4200010003422003',
        '4200100001420401',
        '4200100021003420',
        '4200130030102003',
        '4200304210030310',
        '4200314010000431',
        '4201030000122043',
        '4300024301303020',
        '4300203400403401',
        '4301103020430002',
        '4302013410200200',
        '4310004010043420',
        '4312100004202004',
        '4312100300200401',
      ],
      'medium': [
        // 2x2-medium grids
        '0000000102004130',
        '0000000204230204',
        '0000001204001003',
        '0000001303204000',
        '0000002013004030',
        '0000002320340000',
        '0000002402100140',
        '0000003030010140',
        '0000003030042003',
        '0000004020100104',
        '0000004100000412',
        '0000004140020300',
        '0000021330000130',
        '0000023003010020',
        '0000024320003010',
        '0000040002104002',
        '0000040102003004',
        '0000040120040300',
        '0000040200002304',
        '0000040300310340',
        '0000040303420000',
        '0000040330240200',
        '0000040343000200',
        '0000042000300042',
        '0000042002044010',
        '0000042030404002',
        '0000100003200130',
        '0000100030400103',
        '0000100030410023',
        '0000100201002030',
        '0000200010040210',
        '0000200030024003',
        '0000200100101042',
        '0000204110020000',
        '0000204300300310',
        '0000230440020000',
        '0000231000010430',
        '0000240010040030',
        '0000300220300301',
        '0000301023000420',
        '0000340000100240',
        '0000340001040010',
        '0000340002000024',
        '0000400004010324',
        '0000401004020301',
        '0000403002400003',
        '0000410002040023',
        '0000432020300002',
        '0001002302004030',
        '0001003004120100',
        '0001004030204000',
        '0001004201002000',
        '0001010040020034',
        '0001014002003000',
        '0001030400022040',
        '0001100203000003',
        '0001140001030300',
        '0001300410000200',
        '0002003000200304',
        '0002010000300301',
        '0002010040210040',
        '0002020301304000',
        '0002210030200030',
        '0002213002000300',
        '0002234030000100',
        '0002300421000000',
        '0002400004311000',
        '0002400120000104',
        '0003000003040432',
        '0003000003414002',
        '0003000010020231',
        '0003001020040400',
        '0003001021003000',
        '0003002104001000',
        '0003002400003041',
        '0003004001040300',
        '0003100440000100',
        '0003300000202004',
        '0003320100001030',
        '0004001030010400',
        '0004002040102003',
        '0004003041002000',
        '0004013002010000',
        '0004013030000020',
        '0004030104002000',
        '0004032004002000',
        '0004040001320300',
        '0004040210004300',
        '0004040340022000',
        '0004102040000201',
        '0004300210030300',
        '0004302012000000',
        '0004420030000010',
        '0010000002400120',
        '0010000430201003',
        '0010002420003100',
        '0010010010034020',
        '0010013200002040',
        '0010020423004000',
        '0012000001340400',
        '0012000430010200',
        '0012013000000401',
        '0014010030010030',
        '0020004302004002',
        '0020010300300310',
        '0023020020104000',
        '0023030000410400',
        '0024003030024000',
        '0030024104100000',
        '0030041000201003',
        '0030300124030000',
        '0030300204000024',
        '0030400001430001',
        '0031004030000403',
        '0031100000402003',
        '0032000003042003',
        '0032004001033000',
        '0032200030010200',
        '0040000301003204',
        '0040002120000102',
        '0040021001200031',
        '0040200002033004',
        '0041000032001020',
        '0041000330000204',
        '0041040030044002',
        '0042000320011000',
        '0100000043210003',
        '0100420103202000',
        '0100423000100304',
        '0102200100004003',
        '0103000240001200',
        '0103040100044000',
        '0104000020311000',
        '0104020000420001',
        '0104020120001000',
        '0104423004100000',
        '0120001400000401',
        '0120241000000001',
        '0123020010300010',
        '0124200300000031',
        '0130030100230004',
        '0130400204001200',
        '0134000110020010',
        '0143300110000000',
        '0200000213000430',
        '0200000400311002',
        '0200010013020003',
        '0200010024030040',
        '0200014000301300',
        '0200031200040030',
        '0200040201340000',
        '0200130030000043',
        '0200300020030021',
        '0200300043010003',
        '0200400001033020',
        '0201002021004000',
        '0201030204033000',
        '0203030030120000',
        '0204040000102003',
        '0210002031402000',
        '0210100020000320',
        '0230010200000013',
        '0230030400030402',
        '0240300000022130',
        '0240302000040100',
        '0243000200043000',
        '0243002004102000',
        '0300004012000401',
        '0300004020003021',
        '0300123000100003',
        '0300140200040013',
        '0300200302300401',
        '0300421021000000',
        '0301402004300000',
        '0304200040300200',
        '0304401000420001',
        '0310000300410430',
        '0310004000002034',
        '0310103001400000',
        '0312200434000000',
        '0320010000100402',
        '0320013400101000',
        '0320100000340402',
        '0340000314003200',
        '0340010232000003',
        '0340203000104000',
        '0341100000020200',
        '0400030130044200',
        '0400100001300301',
        '0400104202300004',
        '0400200100140003',
        '0400200312000021',
        '0400300420010002',
        '0402000030010103',
        '0402000142100000',
        '0403034001020000',
        '0403300040000104',
        '0403300140000100',
        '0410000240003104',
        '0420001020014100',
        '0420200101303000',
        '0421000002300002',
        '1000000330414000',
        '1000002003040032',
        '1000032000033012',
        '1000040040300102',
        '1000400220300001',
        '1002000020013020',
        '1002004100000013',
        '1002203031000003',
        '1002400320000401',
        '1002401001202000',
        '1003400120300000',
        '1004000330400401',
        '1004200000000213',
        '1023000000122030',
        '1024043100000040',
        '1030001440000240',
        '1030300401430000',
        '1030400120003400',
        '1040002040002100',
        '1200040140002010',
        '1200300003020003',
        '1204001200000420',
        '1230000000403021',
        '1300000000404210',
        '1300003040003002',
        '1302000002040100',
        '1340003120030000',
        '1400030441200000',
        '1432000003002000',
        '2000000240203240',
        '2000010014300004',
        '2000030000430012',
        '2000030002030042',
        '2000030210400020',
        '2000041200044300',
        '2001410000030014',
        '2003012002000002',
        '2003030004010200',
        '2003300400310000',
        '2010304000010300',
        '2010310000010302',
        '2010310003020200',
        '2014000010020040',
        '2014000240200001',
        '2030001012004001',
        '2030032030004000',
        '2040040000340020',
        '2040300242000000',
        '2041000001200014',
        '2041400232000000',
        '2100000242000300',
        '2100040000021040',
        '2104000000233200',
        '2104300003010000',
        '2300000300310100',
        '2300400200400001',
        '2300400202010000',
        '2304000001203040',
        '2410000410000031',
        '2410010000200201',
        '3000010003200031',
        '3000012320300040',
        '3000020041202000',
        '3000040000120034',
        '3004002000001432',
        '3012210000010040',
        '3020000340102004',
        '3040000003244001',
        '3042000000202003',
        '3100041000420200',
        '3120420100000400',
        '3200002000144002',
        '3200010300300010',
        '3210000000411030',
        '3400010313000000',
        '3410000040011040',
        '3412000000240030',
        '4000000110202400',
        '4000030000323040',
        '4000030002401020',
        '4000304120000300',
        '4001010000100324',
        '4002001400230200',
        '4002300000202013',
        '4010014020010020',
        '4012000000242000',
        '4020013000000043',
        '4020200030010400',
        '4020320100020000',
        '4030020000101023',
        '4030030200042000',
        '4030300100000310',
        '4100000400233000',
        '4100021400200300',
        '4200030204002000',
        '4201000400430010',
        '4300004302003001',
        '4320200000030002',
      ],
      'hard': [
        // 2x2-hard grids
        '0000000120400300',
        '0000000201004030',
        '0000000340000120',
        '0000000403020100',
        '0000000404021000',
        '0000000430002001',
        '0000001002400300',
        '0000001010043000',
        '0000001204030000',
        '0000002010003001',
        '0000002020400100',
        '0000002100003200',
        '0000002430010000',
        '0000003002000304',
        '0000003002003040',
        '0000004200003010',
        '0000004302000030',
        '0000010000030210',
        '0000010000043020',
        '0000010000403010',
        '0000010300004010',
        '0000014020030000',
        '0000020000030401',
        '0000020004010003',
        '0000020030200040',
        '0000020400003040',
        '0000023010040000',
        '0000030004100020',
        '0000030200001400',
        '0000032000000104',
        '0000034020100000',
        '0000100000020301',
        '0000100020010040',
        '0000120030400000',
        '0000200000030140',
        '0000200100000304',
        '0000200140300000',
        '0000230000001004',
        '0000300000100430',
        '0000300020030040',
        '0000310000100400',
        '0000400000030104',
        '0000400003200030',
        '0000400010040030',
        '0000400100000302',
        '0000400300000310',
        '0000402001300000',
        '0000430001020000',
        '0001002004000003',
        '0001004000302000',
        '0001010200004000',
        '0001040030000010',
        '0001040300000200',
        '0001043000000300',
        '0001300000000012',
        '0001400000000024',
        '0001400000200400',
        '0002000002041000',
        '0002000020301000',
        '0002000402000300',
        '0002040000030300',
        '0002040010000010',
        '0003010400004000',
        '0003030120000000',
        '0003400030000002',
        '0004010020000003',
        '0004040000030200',
        '0004100000300200',
        '0010000002040400',
        '0010000010042000',
        '0010000012404000',
        '0010000400000120',
        '0010000420003002',
        '0010003430000100',
        '0010020040000300',
        '0010030020000004',
        '0010200004000004',
        '0010300400000301',
        '0010310040000020',
        '0010400020000040',
        '0014000031000000',
        '0020000020100400',
        '0020000040000103',
        '0020000303404000',
        '0020000330000204',
        '0020010404000000',
        '0020010440020000',
        '0020020030000004',
        '0020020040000003',
        '0020100300000400',
        '0020100330000000',
        '0020200404001000',
        '0020300010000030',
        '0020300040002001',
        '0021000310000400',
        '0023000104002000',
        '0024000000010400',
        '0030000010000320',
        '0030000100024000',
        '0030004010003000',
        '0030010020000003',
        '0030020000031000',
        '0030020004100000',
        '0030200010000040',
        '0030400000020100',
        '0030400020000001',
        '0031000040000340',
        '0034000030000010',
        '0040000010033000',
        '0040000214000200',
        '0040010030000002',
        '0040030000002400',
        '0040030001000010',
        '0040030220040000',
        '0040200110000000',
        '0040300000100200',
        '0040300001000012',
        '0040400030200003',
        '0040420003000030',
        '0100000000300201',
        '0100000040030020',
        '0100000100304300',
        '0100000300020300',
        '0100000400303000',
        '0100030404030000',
        '0100300020030000',
        '0100300100230000',
        '0100400000023000',
        '0100430000020030',
        '0102000002010300',
        '0102000004000003',
        '0102030000400003',
        '0104040000000020',
        '0104300000000020',
        '0120000402000000',
        '0120040000000001',
        '0140001020000000',
        '0200000000010403',
        '0200000000030120',
        '0200000003040402',
        '0200000100420000',
        '0200000204000103',
        '0200000300000401',
        '0200000300001300',
        '0200001030000004',
        '0200004000140000',
        '0200013000000001',
        '0200014000000030',
        '0200300000200013',
        '0203000401000000',
        '0204001003200000',
        '0210000001030040',
        '0230000001040000',
        '0230004020000300',
        '0240000000001003',
        '0240000140100000',
        '0300000000040130',
        '0300000000400103',
        '0300000002300001',
        '0300000100400403',
        '0300000204000004',
        '0300000320000040',
        '0300001000044000',
        '0300002000014000',
        '0300003004000010',
        '0300004001000030',
        '0300100230100000',
        '0301000210000200',
        '0301002014000000',
        '0301003000020200',
        '0304000010020000',
        '0304002000000130',
        '0304010000300000',
        '0310000000420000',
        '0310000300400400',
        '0310002004000000',
        '0310003001400000',
        '0310004000001004',
        '0310004002000000',
        '0320000400002040',
        '0320003000001000',
        '0320040000030000',
        '0321000000000103',
        '0340000100002000',
        '0340023000200000',
        '0340400000200001',
        '0400000000303020',
        '0400000010400020',
        '0400000120100003',
        '0400000300000024',
        '0400000401000003',
        '0400001000200300',
        '0400001000300200',
        '0400004000101020',
        '0400004000300100',
        '0400004203000003',
        '0400020100000020',
        '0400104000010020',
        '0400320000000320',
        '0401100002000002',
        '0402000410000000',
        '0402020000100000',
        '0420000000001002',
        '0420000000310000',
        '0420000002003000',
        '0420001000002000',
        '0430000003420000',
        '0430300202000000',
        '1000000000020430',
        '1000000002300004',
        '1000000004200003',
        '1000000300204000',
        '1000003000000012',
        '1000003000040200',
        '1000004000204000',
        '1000004030000030',
        '1000020000400012',
        '1000030000230004',
        '1000400000020430',
        '1002000020300004',
        '1002004000002000',
        '1003000400000300',
        '1003002000003000',
        '1003200000100000',
        '1004000000000302',
        '1004020000010000',
        '1004021000002000',
        '1020000020030040',
        '1020000030100030',
        '1020000301300000',
        '1020020000000041',
        '1020300000020030',
        '1030000000003140',
        '1030000103004000',
        '1030000240010000',
        '1040000002040000',
        '1200300000002010',
        '1320000000000012',
        '1420000040100000',
        '2000000140000004',
        '2000000300014000',
        '2000000304000010',
        '2000000400000041',
        '2000002010000030',
        '2000004002000001',
        '2000010030020000',
        '2000010200400003',
        '2000030001003010',
        '2000040000100102',
        '2000100300420000',
        '2003000000001400',
        '2010000300004100',
        '2010010000030020',
        '2010300000400000',
        '2030000000004001',
        '2030000001020000',
        '2030000240000300',
        '2040000000310000',
        '3000000001020001',
        '3000000020010130',
        '3000000210030010',
        '3000000400004200',
        '3000001020000020',
        '3000003010000040',
        '3000041000000304',
        '3001000000001403',
        '3001040003000003',
        '3002000000000140',
        '3002003024000000',
        '3004000000010043',
        '3004002010300000',
        '3004003000400002',
        '3010000410000000',
        '3014000340000000',
        '3020000100002000',
        '3024000023000000',
        '3040000100004000',
        '3040001040000300',
        '3040040000310000',
        '3100000000000023',
        '3200000000004001',
        '3200000004000020',
        '3200000010000030',
        '3204000000000402',
        '3400000000031000',
        '4000000300000014',
        '4000000402000030',
        '4000003000102000',
        '4000003002001400',
        '4000010000030014',
        '4000010300000020',
        '4000020000020014',
        '4000032000300000',
        '4001000003100000',
        '4001002000001000',
        '4002000001030000',
        '4002004023000000',
        '4003000000001200',
        '4030012000000400',
        '4300000000010400',
      ],
    },
    '3x2': {
      'easy': [
        // 3x2-easy grids
        '000000046021630542402000210600364200',
        '000000415620502300034256050034300062',
        '000000540130254610030004463520125046',
        '000001061450453006006004000205510603',
        '000003203614420105001406360040140060',
        '000005251460514206600541100002300014',
        '000005256401401600365000504000032500',
        '000036006400043060562300021040400621',
        '000040100623014230026014200401450300',
        '000041104006463120050403000002602354',
        '000053310024200500541360100006602405',
        '000060025000060015540230056021213050',
        '000060065340050020023650340002510406',
        '000104010630052410300002430050100306',
        '000124010060530246040031126000403002',
        '000150020346500001240003003000412605',
        '000200621543000600005014452006136425',
        '000230100460001002206510623050005306',
        '000301005602150400060503620030500064',
        '000302002164004536500000460005215603',
        '000305003416164502030041050104601000',
        '000460260035021056003200002601106020',
        '000500453602260430300065504026026050',
        '000500543021402300065200204105056000',
        '000600600452420100516200040510100300',
        '000610500300005062042001314050250140',
        '000651050340620503300064000006261400',
        '001000040016306500425031000263060105',
        '001003023516000241042605000360604002',
        '001032026400002000460215014060030024',
        '001430420605002156000004016043530261',
        '001500000230642000013604130460060003',
        '001540560320050003006052243100015000',
        '001604006130030400200005100543403200',
        '002001501342103600056000025003010250',
        '002015600304004052210430540260106000',
        '002100001640063005054016026500015260',
        '002530000610063201120350000005406123',
        '003010210653300461040305100502002100',
        '003025000340300514405002102003500061',
        '003040042501265010000600401000056120',
        '003460046305410230000504634150200600',
        '003520000043450230020000014362030410',
        '004062006403030024100030003251250046',
        '004316000054260500305162030000402630',
        '005006600032102000300124420365060041',
        '005016031540046003300104503401010005',
        '005040100035502463006250050320243510',
        '005060401500010206206100650300032054',
        '005100210603536004000530040060053401',
        '005230004001542306631000016540053062',
        '005340410000531200246510004025000430',
        '005400600305103526062004051643000200',
        '005603000425302000050201000304630052',
        '006000400000100632362054050210203046',
        '006003230615025034340506400360160002',
        '006012020530245001003200362040001623',
        '006050245136060304104025421503000001',
        '006053520006250004000000615042030501',
        '006102021400200041100005402310013020',
        '006201000305002406600502021054000123',
        '006503032006250030000251320060165300',
        '006540045031500016401003352164000300',
        '010005320046160534000201240600536012',
        '010030000410030641400250146020520000',
        '010200540000203145001032000400600513',
        '010650650004300010060532030201201300',
        '012004534006060010120465350040000300',
        '013020026513000630600051000140201300',
        '013600250341520136300000130005645010',
        '014006650200065040400650142000036400',
        '015023306054201045534000000001000402',
        '016400053001300500145302031000020103',
        '020005506410603024040300002500305201',
        '020030063100004605200300541263600004',
        '020050005203004030060024402301106040',
        '020053004012016230005040060524502301',
        '020060501420340010610050204100006240',
        '020305053410206530000206564003102604',
        '020346403100100630006204210463600021',
        '020460643000014500350102001304400651',
        '023504051603510300346001004005105430',
        '025000600002006400543000302160461050',
        '025003103026400051001402536000000600',
        '025043004260000000063452030000050326',
        '025046006215600130000560402051500000',
        '026500035064010006053000002040500623',
        '030000652000004003503160006315315006',
        '030005005413206531300000010350503120',
        '030041040600450306300504000005510462',
        '030054500620205346400010050432004560',
        '030054504062400200000506061430305601',
        '030062200403500030341000413206625040',
        '030260000030452003061024500042000056',
        '030265205100540010013452000530351004',
        '030402000030543601620500205004004010',
        '030406005030041020050040010265000314',
        '030560540120450000002430020000614300',
        '030610000450006005053246000021510300',
        '034002010400021540060030652010040600',
        '036102215043020005654000103000002006',
        '040000000245000650156030500124400560',
        '040001260034106002420005000250532400',
        '040005065030406501021006210600050002',
        '040005503004430062000431010000050146',
        '040010020054000005051032015003302501',
        '040050305002036210000000150003263105',
        '040103010564006000500042100230362001',
        '040120601300064502152063210604000250',
        '040136010205061023003400002014100052',
        '040160610530064053520416206041030000',
        '040231130000350400060305620150415023',
        '040325005001054132000504401000020400',
        '040532000000500060403251030005051024',
        '040600050340020100513260234500105002',
        '040600260410351000400053600521002060',
        '041300025104050240460030010003004005',
        '042106031405064000000614006300010560',
        '042603030004250400003562304010501340',
        '043156000042520013316500430000060405',
        '045003613254061002032060304026100400',
        '045136600452560041034005050010320060',
        '050000000026624001305000560203432005',
        '050002102045200613306504520430004250',
        '050006064000005301102005526134400052',
        '050103003625630000100062560234304506',
        '050360230050100405503210300641610520',
        '050623002010041530065100000301500260',
        '051240026500605400040065000054064032',
        '053420042356004213020040000062200004',
        '054000106245003600620354000030000426',
        '054000200046046320300604460152512003',
        '054001100305620130413000006203030400',
        '054036060514300002405000602105041000',
        '056340043500021003305010010005532064',
        '060245000060415306200504001652052001',
        '060451100020014500352060500306406005',
        '061502023001640000030050204305350210',
        '062001140005254300010042601204405100',
        '062354354020640000230060010240000506',
        '063400045031650140014060020056036200',
        '065130003050021000054301500060436502',
        '065421010030641200023100006040034610',
        '100000302501420030036010015403240150',
        '100004054006421005630010500203200651',
        '100020602004060040234516010260300401',
        '100403003012000051251306410600506004',
        '100500350640421060030210004002203450',
        '100630620054500003306021035216260005',
        '100645600123045300000054006000502016',
        '103040000002046051012460600004034610',
        '103200020000346120050400604500510046',
        '104603050020201036305201036412410000',
        '105230400056602015000002010063530400',
        '106243000156600004320001261400040000',
        '106304320005000030602000060453503206',
        '135006462310613002200001540003020504',
        '145000006510613420504100052040460003',
        '150060320001503006002305465102201600',
        '153042020050041563000104304200002436',
        '153264460351600003010000000030501006',
        '200014145020304102012300501036403050',
        '200031150006621340040100032014000203',
        '200300054160003051510403002030600214',
        '200500500432045216001000063000150043',
        '201040004312542060310524100006005031',
        '203004040500062351030002320016014030',
        '203010100530602000035061304025000306',
        '203061006352500120001605405030030000',
        '204500160000000450040016450603320045',
        '205000100605010254542001420536003102',
        '205361010000031620050003020100100532',
        '206000500024600500025006463210152063',
        '206050030020050200002013645030120405',
        '214065530200063052052010041026000000',
        '214650306410065001120504000026002045',
        '230016000003026000145000400305563120',
        '230560600204046020521640100052050310',
        '234605005030520000003001306450452100',
        '240013310005060001153206000500504060',
        '240060600100502600460002154036000051',
        '240631603050100040500062050316000400',
        '241305503004026453030100302041010000',
        '241600635124503000000002000241012005',
        '250000010000031064060513605041003625',
        '260005513246400013100060602350351000',
        '300006520040405010000064650031134025',
        '300042210600621453503000402016000504',
        '300052000134012305435016203000000520',
        '300160040530020413030206210645504001',
        '300526025001003410000060436052500604',
        '301005000201050013040060015326632054',
        '301200062030406001000003603402120350',
        '301426246030410000602010500601160302',
        '302104041325400056265001100003000002',
        '304250056140631000040030100064060312',
        '304620000345006503013260045002100400',
        '305010000503406051150026032040040630',
        '306042004060453200102400040653005124',
        '310046045000060405250031500264020053',
        '310050600020526043134002400010260405',
        '310204500060000102120036005410031025',
        '312406005300043200206100500643630021',
        '320051651004410300032146060000040500',
        '320600056400600502042010400030030164',
        '325604001500000105150300014260063450',
        '340052250001000135510264605003000020',
        '340060102500000234400605031006650301',
        '340621612300500060426013053100000000',
        '351206064001102460040312015000620004',
        '351400020000100043030516006135503000',
        '356040214050003000040360062030135420',
        '360240000605250006040352004500530160',
        '362405100020200536000240450062603004',
        '400006106005354100012543000620001304',
        '400010206450002065563020351600624001',
        '400030230065023014104003000006346150',
        '400610605402140000002040500261061304',
        '401003030201605002300564163000054310',
        '401003053001005600610530026045504000',
        '401530003146304260602014100623000001',
        '402306006502501060300200600120205600',
        '403001125063010032002046030020206315',
        '403510165430000650004000241365030001',
        '403600025341364205050400002164040500',
        '405300062401001500503004204105150043',
        '406052002306301600000031054203123060',
        '406300235006301000654032540000100500',
        '410503500601300200052300031452045000',
        '412365630214020000000030264000351026',
        '420000050040060001000406043165605234',
        '421306360014100040046020053060604530',
        '421530635200006003513000302601160005',
        '435612000400341006250000560021000560',
        '450000000451504010162500603120005030',
        '450103030050003605504230002560005002',
        '450300003050160503530002300205200634',
        '451260006100000006560400002651010320',
        '453200201540046000025006510004000025',
        '460000000304610043054010005236030051',
        '460030030100346201012003053400620010',
        '461035205164520041000020040302052400',
        '462000050420045060023000200041510032',
        '465301002504050200216035000002501040',
        '500026004513102605600100006200400361',
        '500102120030615400000650346010000360',
        '502100316254005060600025064503000642',
        '503204200365000100602053306000150630',
        '503410040503634150210604000005402000',
        '504100013004056041430002062400040010',
        '506200204050150340040105025000401502',
        '510034463002026500050063601320000406',
        '510063000152034615000204125300063001',
        '510300002410300502245600020003150200',
        '510430230010165240042006601000000061',
        '510463040000234051650300103200025006',
        '513604040001100000324510460000201400',
        '516204420000342500105002650400030610',
        '520006360400615004000561150003406125',
        '520304030000100005653401065142004500',
        '526031401050015640040120060004054060',
        '541230003150604300300401152043000012',
        '542001310002200604160253601035030100',
        '560000200563426005005406041050052100',
        '560030240150004210125000410520302041',
        '560043302600206405100062410000600030',
        '560400003052045000630045006320024060',
        '561200034060105000300025003650002014',
        '562401140020005243230006400300006154',
        '563024100000032415000302040500001046',
        '600000210040300064065100132056546231',
        '600031530620300000125000406002253006',
        '600342030506004000010604123400046120',
        '601300030200206534354062002053063001',
        '601304302056000400030012214630503201',
        '601430002600516240020010030060064320',
        '602000000623201060006241564130023450',
        '602000103062325010460320500043004601',
        '603005005200250610361450500024400561',
        '603120021035560003000506015402046000',
        '604150300006040030560021030510002064',
        '604230023060531640046153000000060510',
        '614002030000162005050601340200506400',
        '620100135026403512201630000005000300',
        '620401431526210050063014000165000300',
        '625143041062250006000200536420400600',
        '625300430005003120210000100650356010',
        '630012000463020000006250451020003045',
        '630540005060564203003006300005200604',
        '632000040203200106100500426010315640',
        '632010004306305002040003520461416000',
        '642051100420403060201543000605010034',
        '643012100000235640060025000030010256',
        '645001100465500014304052050123001500',
        '645200001465026001000604302006100032',
        '650000204035045010102543520000006050',
        '650023103004406050030016205631060040',
        '650204020000014600300415040302200140',
        '651000230600006040143500300460405300',
        '653040400506106020230060000400300652',
      ],
      'medium': [
        // 3x2-medium grids
        '000000004163000000620034500241040356',
        '000000023056200000041005450063300004',
        '000000100304021000006000003056005413',
        '000000200300000430450102002001140203',
        '000000204350030500600013040032326000',
        '000000500063040256060000423005100002',
        '000000501000030200002130400003010542',
        '000001000050005100102300531046406010',
        '000002421000030106006230210060300021',
        '000004026005360000005260030050054106',
        '000004234601021006003500000000060020',
        '000005250001003000010036425103000004',
        '000010061050053620006300300500605032',
        '000010350040004000520004060050010403',
        '000014030065643001100036064000500003',
        '000015000032105000604100460501000040',
        '000016416000350061100003035100001000',
        '000020400100060003501640045200602005',
        '000025006430402100005002321000064200',
        '000040060530026000400000205000041253',
        '000040320010610000040060062031431200',
        '000043600500206004300120000000503400',
        '000050300010140003005240560000400005',
        '000052000630405000300245502300630000',
        '000060500300304000601003000540000236',
        '000061000000400052560314054000230005',
        '000063100002060401005206001604040305',
        '000065400000015200302000261004000120',
        '000100000035410003250060002000600542',
        '000100002040125400034200060020200016',
        '000102014050006401001520603210040000',
        '000104600030004010003405200006000201',
        '000105030400050000146203460012012000',
        '000142200500050301312006020604006000',
        '000200000016302000460030204000605304',
        '000200400065302604540000650432000006',
        '000240006003030400541000103000060100',
        '000243020000160020302001600100230004',
        '000300054002010600602500060030430000',
        '000320301000000003560200006000150032',
        '000400000061034156000043640000010634',
        '000400624003000002400001030610006005',
        '000410060002030060040200006320503000',
        '000465040300060100105030000503003000',
        '000500000010600154504063000000300045',
        '000500052600046302020000030250000004',
        '000500060034604050203000030040400305',
        '000530003060026401040020030010260340',
        '000600000040064035235000010506500314',
        '000600001045000210000004510402320150',
        '000600046003062300010002450010020035',
        '000601640002104000203415300000005306',
        '000630040010030006002143405060600405',
        '000640060000405216600030000001502004',
        '001000002053000300006015400632063500',
        '001040304061200000005600003020150436',
        '001045504203600000005120050002240060',
        '001300350000036041024030000004060100',
        '001400205001510064026103030500002000',
        '001500536041300050215030002010000400',
        '001642204053605000000200400000356020',
        '002004063010006000040360005403030056',
        '002005000610000201010000031020500134',
        '002006013040000602230050300004420160',
        '002400346010001520500300063100000003',
        '002503000001030600205104006045000300',
        '003000002536604200020000041000306021',
        '003000024350000100600240306512250000',
        '003000620503304026016004060000002400',
        '003004400350000002201500020430340620',
        '003100106003400000000230010642204300',
        '003502200000000100140023520401400000',
        '003610601000000301305240520004004002',
        '004600000000102300506420050060021500',
        '005000100042030100600025456213300000',
        '005000300004000006003020002015150243',
        '005000320001032010104063200000000304',
        '005000631050002000010020000465500032',
        '005006402050001205256000000503503600',
        '005030321040000250250000032400064005',
        '005060004513500302043100000001000605',
        '005420000003510230200000102300060502',
        '006000000462000046654000300001560030',
        '006000002463463050000030034015015000',
        '006004000630060105050460604000021000',
        '006020201000002604500231600010410500',
        '006205250030042000105000500400461000',
        '006305500100010000050201060503435010',
        '010000050041030004506020400510025000',
        '010026000004002005645003426500000402',
        '010040006100000214000006560020031400',
        '010040200035140600006400005060600500',
        '010040425010230400054000000005563004',
        '010062602010200604040200460000005300',
        '010200000000036104501003003542005360',
        '010204023000532006040300201600000002',
        '010304640015000021000053050130320000',
        '010600000003500060000054140000365041',
        '010600200010050006642003061005020400',
        '012300600001001206204003000600306054',
        '016040304100420300060005000200542000',
        '016400040612001364000201600100000020',
        '020000350061401005235040002610600000',
        '020001315064000612000000004120001340',
        '020004001020005016300040034052050000',
        '020030003105500060030050250300010002',
        '020056000000100540003010045020230065',
        '020065500230204006000300002000360400',
        '020300500026260030350004602400000602',
        '020340030500265104040060006001010003',
        '020536000400310020600350001060003000',
        '021043004060400002000310205036006020',
        '021540300000004601060400000214402050',
        '030000004050401635000102310064000013',
        '030000260004451000003005512643000500',
        '030000560043000005253000015420604300',
        '030001104200405300620010000020056030',
        '030005000210402501300006000000523100',
        '030106200003020000503061004630000500',
        '030200000006100602502104024001001400',
        '030500245603000200402030100306000050',
        '030601006320000002600000100500345200',
        '031000020060053100102000200640046005',
        '032046500000205360000000000430350001',
        '034006026031000002010060260005001620',
        '034056510300000532020401000000400200',
        '035060040200003000406035502000014000',
        '035064064000400200500006050641040003',
        '040030030002450100016503100304000015',
        '040100005000000000100203021406064021',
        '040100050300602001004203100604000502',
        '040106150430605041000600004500560000',
        '040130100400300005020010013004006301',
        '040300002000050210000450506004401625',
        '040603600000310200004001156304003000',
        '041000200000402005130020300010000342',
        '046000520046000300000502300021204630',
        '050000000251001300040102410500300004',
        '050002002435005020320040260000030010',
        '050013001500510062260000100205420000',
        '050030000006106000000003564302210004',
        '050210001006006400000002100625060300',
        '050214104006602403000002040020060005',
        '050400046253500600064000405306030004',
        '050403000620000001100050026004410500',
        '051300004065103000040200405000002050',
        '051400340000030001405020103004004200',
        '053000400350300514000230501603004005',
        '053040026500000600060004032060010305',
        '054001000050002340600000365402001063',
        '054600006452000003123064042000000045',
        '056030010605004010000403560024302050',
        '060004005200134602500000003020250060',
        '060102521000603000000036040300230640',
        '060105305000021300000010000053253401',
        '060240000160004000310050040506050004',
        '060500025046000100001000400610016200',
        '060500035016650100003004010460000321',
        '060530502010415000300000000046003005',
        '060540140200000436436000250610000050',
        '061002350041020004500210000100000036',
        '061004450021106402002300004200000140',
        '061203000001035020004300003054000002',
        '062014040562005030634100000040001000',
        '063010001260040500512040000650000000',
        '064000201040030105125400502300040500',
        '064010020300450000031000243050000234',
        '064130000600106003432000000000200304',
        '064352300000000000000630500403243501',
        '065000000506001250002000050023100640',
        '100000030002000105000243241050650001',
        '100000534000001650006032010405045006',
        '100020204310020063600005541000060001',
        '100050005001302600000000430060056034',
        '100263000005000002000300043021521400',
        '100300364200003056000423000002002541',
        '100300620501200103310624000006060000',
        '100304200065034512021000300040400200',
        '100603306150013000402000004006031405',
        '102400060120004203006010040052600340',
        '103000000600041320300104002400010250',
        '103650502003400000020010030501005200',
        '104005502010000500620041010450000160',
        '120000030060000410004502203105540000',
        '120003340000600501010630460320003000',
        '136000250600603054540000400200060405',
        '140020620000010640060201000012051063',
        '142036003000510603200010401000000100',
        '146305000460002040413600304000000504',
        '153620460150000031020000004016510000',
        '154000060000003065000040426010030620',
        '165020004056500001640000000300310060',
        '200000014000032000041003020630403120',
        '200010400600001520500160000040040206',
        '200010504320100400600053001240005630',
        '200030060000000104102653020041005060',
        '200050060034025403400020050000002345',
        '200400504260043010000000000053360100',
        '201400004600010200000501436100000040',
        '203004100005360040400601000400604000',
        '203500460210000031300050500124000305',
        '205000010560000654054003532040000020',
        '205461041500023106056000500300000020',
        '206030300602020360003214002503030000',
        '206040134006005000642000001305020000',
        '206300034002021400060120500030600045',
        '210036500000000062026403650304301000',
        '230040006030054000002600003065000013',
        '231000506002004305002000415000000504',
        '234100056324000000340002000030600205',
        '300000241003006035050426030540510000',
        '300001000600502010006230025304640050',
        '300001651000005100400205040300106504',
        '300010500032050060600040200604465001',
        '300015040300003502506103004650001004',
        '300025206030130240062001520003000500',
        '300040100635530162600050010500050004',
        '300052001600000206002040500400046005',
        '300065106040015600640510001006400000',
        '300614004320000000005140506400103200',
        '302000000040100025200100603050005203',
        '302005045003200300430050000046010000',
        '310600000043461350500000006030135004',
        '310600020001243010600004460120002000',
        '310604400530000000000106140000526000',
        '314600026030000106000002103060400013',
        '315200000510060104004060002001601420',
        '320054000230214060000402605001030000',
        '350006000534400305035001140050002010',
        '356024400500020010030600200000503240',
        '360020421500200640604030000054502000',
        '360104004030025300001065000000003410',
        '365000002000023056016004201043000001',
        '400000003010154063600140000306300020',
        '400020302006230105156040600030000012',
        '400061065000304610500243200300000004',
        '400210102005005004000021520300003000',
        '400320002501050010000630006050040200',
        '400500012060063104045230600005000640',
        '400600002005045100006300061040234060',
        '400613060000005420004005506004100250',
        '402000000000150020600310000200210543',
        '410200600104000021120000240036350002',
        '412003006001000132120500000000630010',
        '416030500000240005000304350040004100',
        '420001530400000010300204200103103002',
        '420005506040250010000002005601000034',
        '420305003024030002042000300060000053',
        '430060200304040030513600300050050020',
        '430560060000054000302050500020006430',
        '430560256000600040040000060231010600',
        '436000000000100050024000302510010230',
        '450300300240020000040502200006600020',
        '456100102000504000003401045003001600',
        '460015010000632054104300000026026000',
        '460310005640000504040100050036620400',
        '500000060403002006010305600031120004',
        '500021010530340260006000020100065000',
        '500040410300000002002403050201001060',
        '500204002035006300203040124050300001',
        '500240100536000403054010000020035104',
        '500304020000130006200150000030301500',
        '500306000054030041010230053400006013',
        '500410003000060500450136030650010020',
        '500600401502134050000100245001000025',
        '500604000005005300130006602410010000',
        '501024200005403060002000004100120036',
        '502000340506050240120605000062000300',
        '502001103520014006600040050002031000',
        '504630002051103504065010300005050000',
        '510000000610430001005023003000000356',
        '510002000004403015100406050640006001',
        '510004036025054010320450000062000300',
        '510203340000063052000304000025004030',
        '512000060250600102040506000005004020',
        '512003000010000241420030063150105000',
        '520010030000203160150320400006060401',
        '520634400200004001200060300050152300',
        '530041400002106025000100210000604203',
        '530200010600000040000021020065465030',
        '530410240006020301003040360000000620',
        '546300000540004100005604002000461005',
        '560200410000045023200000006032324060',
        '600000000356100023003064060410010000',
        '600013000050000100025060060230201500',
        '600150100602060020020006250004403005',
        '600240010005062010040502100350005000',
        '600251520003004030016020000640005300',
        '600504400000300005205301002400140053',
        '601004005600004005020000000061016450',
        '601503005000000450050010314000526100',
        '604000015000003010001060000032340650',
        '604030100005020400506301200504010000',
        '605134000500032001064005041000050003',
        '605403003000420130050004000046060300',
        '614005205040402031000000020053000000',
        '623010000060206004034652000501005006',
        '640520502000400012020406014000050200',
        '650004040005160042230000006500503061',
        '654000020060040000035001000356060002',
      ],
      'hard': [
        // 3x2-hard grids
        '000000000023000002400600035060002000',
        '000000000645030020005000020100400200',
        '000000001200502006010000400003005004',
        '000000006103210006060500400001000035',
        '000000010005045610000000050003006040',
        '000000014030032001000005000050653100',
        '000000035600210005506000062010000020',
        '000000040061000000400002052004060050',
        '000000050030000600540100000010162050',
        '000000060025500000401030000060004000',
        '000000064003430002000000600010003050',
        '000000065410020060300000050024000006',
        '000000405020060005010060040003650000',
        '000000500200000000400650010003004061',
        '000000500200000340001000005020014060',
        '000000510004000403020500100000400106',
        '000000600003004300302540000020020001',
        '000003103004200500001000006000320060',
        '000003200000030210500060460031000000',
        '000004030006200010060400104000003041',
        '000004061002020005000006005000004021',
        '000004306000500001000500010000000143',
        '000005000140000200020031060400300016',
        '000005010300360004100000000640000002',
        '000005016000103000200004300201000003',
        '000005030020600054051000500002000000',
        '000006000100300050500000106032050600',
        '000006000501010340005000300004006000',
        '000006012034000000450060000300100020',
        '000006020500050003100002300000500600',
        '000010300040010200503000600005000030',
        '000010640020000200020000005640030050',
        '000010640020100002005100002050000260',
        '000013015004000000600405030001046000',
        '000020000615150000003000046003000400',
        '000023600001031040000000500000006000',
        '000030015000000040002005600000043060',
        '000031000000002000650400006320200005',
        '000040030006002000003000605200000001',
        '000042000106000010400300000001560000',
        '000045041000000201000003104320200000',
        '000046000000206004003000100032000601',
        '000050406000000006002000001200200005',
        '000051001006006000040300260005000000',
        '000052000000004000010003500620601000',
        '000060040000300400000031054003010005',
        '000060600321000006005100503000000010',
        '000100100002000004200015005030013020',
        '000103400000000304002051024000050000',
        '000200000036060021005000500060041000',
        '000200052003040030300060631020000000',
        '000200200013002050300000000601400000',
        '000205605004401000000400300601000002',
        '000250003004000000500140000020060000',
        '000251010000030002001060000600240500',
        '000300000060060000340020006051200006',
        '000300040020600100250006000000002001',
        '000300401520000000002001200400005000',
        '000360603014005001000600031000020000',
        '000400200000000030050000010600640205',
        '000500030000320105015000042001000600',
        '000500050410205001600000004000002003',
        '000502000000013000005300000010430006',
        '000510000043004000500020600000130005',
        '000600000013030050526004600400100000',
        '000600030000400000106020500001004050',
        '000600035000406005000000020060300040',
        '000610030050000000205000064500001000',
        '001000400005003004000300530601006040',
        '001004000032600000100200043005000000',
        '001006025000463020010003200004030000',
        '001030530000000020400000250046040002',
        '001040000260030000000410503000000000',
        '001360030200002450004000010000200501',
        '001642000500000400000010002005106000',
        '002000100003004500000032406000013060',
        '002001010000051004023000000040000360',
        '002001160200001000000003004300500004',
        '002040010006040060060300500000001050',
        '002050045000030600400210010020020100',
        '002316301000005201000040100005000000',
        '002430540020600540030001000010200000',
        '002500430000000003000060010000040026',
        '002560601400023000000000040613006000',
        '003000000002000204006000030005605300',
        '003000005430000010012050040603000005',
        '003000050000060000100400005006000102',
        '003000200100060020002500001000300450',
        '003000465000004025000003300050000062',
        '003000500000052010040002030006106004',
        '003001020000400005060400600000001000',
        '003016000000000054004060200000400105',
        '003020206004030460000003004301001000',
        '003100020400010000005040032010400203',
        '003400600100050010400000034060502000',
        '003500060002600004000005100200036000',
        '003602000403400000060000032000050201',
        '004000000000300540050002260010000030',
        '004000000160042000010002056400020650',
        '004000005000001060300040000100500300',
        '004000032040300002010005000620601050',
        '004000361405010230000040000300600000',
        '004001000600200050041030020000100000',
        '004006000000020050400203050300003001',
        '004020000003320106006000000060000201',
        '004360060010010243000006300000000005',
        '004603000400010500000006400002300000',
        '005000001020000300056400460000000060',
        '005000006004020156051000000410000035',
        '005000261300043002650004006000000003',
        '005000400601103005200060000000000200',
        '005002010000040200000310300000200050',
        '005024000050000000460003004000326000',
        '005200060150030005000020003000021400',
        '006000000350000260004030065020102000',
        '006001000053000034004000062010050020',
        '006004040030002000600000000100150400',
        '006030400005020000000310100006004000',
        '006243000000005006620005000002030050',
        '006310012450004001000000400030050020',
        '006401000500000300100000020050001603',
        '006500054002000400000030005100140000',
        '010000000600600130200000500006004300',
        '010000006000302400000000403100160003',
        '010002000054600000000400030045040630',
        '010020020006000300300650004000000240',
        '010040002000040300000100200000300060',
        '010205065340000500004003000000030000',
        '010500000006000000400632204000000320',
        '012000406100000004020060005010001450',
        '014006020000000040060102001000500004',
        '015040000020030000000450006035000600',
        '016400000106050300060001000000542003',
        '020003034600400000050200001402000006',
        '020005500000014000000016100500305004',
        '020006030420064035002000000500200060',
        '020006304000010400000500001030236050',
        '020013060002004000010500006000003200',
        '020100600250004620000305502003000000',
        '020300000000043006005230030460000050',
        '020501000006460035030000000000003160',
        '024000600000050600300000001250000060',
        '025041000000010000050300000000600250',
        '025300000240040006600050103500050000',
        '026050005020043000000004050012001006',
        '030000050432000003040015060300002000',
        '030000541000024000100002000060603405',
        '030004200000623010040060065042000000',
        '030004200006300000005300400000000140',
        '030010004006050000002003240000600040',
        '030040500100053400000000106003005004',
        '030045020000006000003010500002000006',
        '030051000300400500020430051000000020',
        '030052001003006500000260500000000305',
        '030060000000000540001200002005003000',
        '030060500230000005020000002400064000',
        '035000020400040502006034004300010000',
        '035204002000500002400300050040000605',
        '036100004000010300000500403000000020',
        '040000000060203000000050304600600100',
        '040000003001005060300000051200000104',
        '040000003065600000205004060000000010',
        '040000130500400006060001002130000000',
        '040000200050000002100503403100006030',
        '040001300500000004000002010000600105',
        '040003206004000020160000000540000000',
        '040020305001000305001000400000000002',
        '040035000106520000300004062000405000',
        '040060100030500000000601000002205000',
        '040502560001430106010000000000003005',
        '040600000243060100004050000000100000',
        '042000003600020010050000060004000050',
        '043500000034000645004000000006102400',
        '050000000064200030060200000005030000',
        '050000000400005000210036043200001005',
        '050000006304060000320010000420500030',
        '050000020506000002000060001000530400',
        '050000100050010000640005000120200043',
        '050000600000260014041060400005003020',
        '050003304000000200030560501000000600',
        '050023000000030001026030003040500010',
        '050030003010030000500200040500000006',
        '050030200060006304030016010000400100',
        '050304003060002001065003000100000002',
        '050400010523000030006050001000300010',
        '050610104000000205040103300000000006',
        '051000040006005001000024000000030040',
        '051000060030003000000064004001000040',
        '051000203050000026000500000205100630',
        '053000600000036050000046001020005401',
        '054010601000503006000030006201000003',
        '056001000200061020040300010000600000',
        '056002200005002001400050000600023010',
        '056004300050005100400025040000000003',
        '056023000000000000341005600002100500',
        '060000000503604000000002105030000001',
        '060000010062026310050006005400000003',
        '060000540010230006000035003400400000',
        '060030003000050010030200000004001005',
        '060210050300003450000000020100001000',
        '062053053000506002200000640000000100',
        '064200300050000406020501005000200060',
        '065010100000503000001000006001000250',
        '100000000030500000016000030600020005',
        '100000620003010050054210000000000600',
        '100003000500020005004106452030006000',
        '100003002040000500351200000002000350',
        '100005200000003010060000000230000061',
        '100006040310060000000000006500502030',
        '100030023010000451004002000000002045',
        '100240000005020400401002002600030000',
        '103005040002001000000000300060005300',
        '104020002000000200013050500301000000',
        '120000030502000030200060301020400001',
        '130020640000400005010000060400000200',
        '136004040001000000200100400500000030',
        '200000000050400300000060000002340600',
        '200000040502120300400210310006000000',
        '200000100004060000010500004031000200',
        '200000605010530040000500001060306004',
        '200001000000640000003500000000001063',
        '200001650400000150000004130006000000',
        '200003360005650000002040000002000060',
        '200015004300000000416002000000601004',
        '200016000000006000000002000500604300',
        '200040000001000000520000010025300400',
        '200605000301503000600002000003300054',
        '203000050300040000000006001403020600',
        '203006000000400200020010050000000045',
        '204500100000051006006000000040500030',
        '206001000000301040004030000000102400',
        '206400005002000200600031000100510000',
        '210600063400305000000000000003136000',
        '210603305000030000452006000520000000',
        '230000000000010205000610020000500304',
        '300000000201630000000650020500000020',
        '300000500004000036001000000510002003',
        '300005400060603400100000200000506001',
        '300006020305015020000000000050004000',
        '300260500000002006000504000001010040',
        '300604006200000025003006000400021060',
        '300651000000000400000005120506460020',
        '305004000010000200050000046050000002',
        '306002020004005230000100030000000003',
        '340000000030605100000060000402000310',
        '340006000023001050030200560000003000',
        '340500102000000245000000400010200003',
        '350000001600410000620050030500000041',
        '360024420500000065050003500000100000',
        '400000001032000020000500030040500001',
        '400000001640000002500034100000003010',
        '400000600230000056100000000060004000',
        '400001050000040000030004000063500040',
        '400030000062340000005000000040000205',
        '400102020500000050150600230000000200',
        '400201000000000005063040001000020300',
        '400500001003000000060004003160000302',
        '400500006010604000001402000030000000',
        '405200060030000040002063620001100000',
        '406000003000000605000034004010020000',
        '406300300100000000000513004006000000',
        '410500000000000000002060001003253001',
        '416000003000200360001402040000305000',
        '430000001000502014300520040000200100',
        '430021002000040000000500000000060410',
        '450002000100000006604050006003012000',
        '460000000000002050500310000026000500',
        '461000000001010520602000003260000100',
        '500000000400000006102000000060600152',
        '500002006005040300030200200400004000',
        '500003060020000001000056310600200010',
        '500040000000403210000000051006630001',
        '500200304100000000000304052030003602',
        '500210010060000400030100000521200040',
        '502000000000004360000005030240006050',
        '504030000000000103020040010000002400',
        '504600100540006000010000001200302001',
        '534200000000023001000003000045400000',
        '536000000350000000004560200040450002',
        '600000000104500300001002060000405000',
        '600000050000006004200005000150010060',
        '600000541000000100413000120400000060',
        '600001042006000000060003000500001604',
        '600002000630000000054300520001100050',
        '600010003000065000000000200106000520',
        '600020000015340000050000031000000050',
        '600020130000000004000031000006340002',
        '600120000006023050400003010040300000',
        '600140102000000305050014000500000430',
        '600500301000100200004000030002000006',
        '601030004600026050000200000000065320',
        '604000001200150004003012300000000600',
        '604500000002400030500600000050035006',
        '610000003200120300004000030014400020',
        '610500000000001036004100000020056000',
        '630000100005060100003062000000320010',
        '640000000000405003020100000561000040',
        '643000020600310005500000000502000000',
        '650000000030001020020040010400030000',
        '650004400600000040000200001030064001',
      ],
    },
    '3x3': {
      'easy': [
        // 3x3-easy grids
        '000000000800501907195076002007800139000190000902364075709600510080010720030740098',
        '000000008080000612135080900078932500501674203040158009062700105309805000750001806',
        '000000071700000569609080403903800712005010600840206300097465008586032000000000150',
        '000000090809271064000094007902540031340120906150030800090000010710659000080412609',
        '000000209002500780047182000023094060070251030584003000700430020030607405451020073',
        '000000460096040002204609003620591034013020080400806021002087005061000240005060008',
        '000000807680000200725184309049803070070095030013706090938071025060200003000009080',
        '000001000500706000076950832800070250010305009005028007900610725200890364007502098',
        '000012800290803075100070249609724501405081000800359004000100357000435912300207060',
        '000046091960013507000050640805062903706008400000000806050920004670134285000685000',
        '000068107061900000780040600396804570208070004570000300100056023057210006603489710',
        '000070208389510470107006000800000951035091007090050024704029180003060740918705030',
        '000070300700090046260801700006020400000005208412683950090068120600100079074209680',
        '000072810003400006502036974807013529000720000205000037000304082024901000068000091',
        '000076091000901054106084200000090076609310042530700089758100000400007900901040705',
        '000080257064510083000009106470801360903005400086004020007200000509008000012900534',
        '000100300487006059100809007601305420030412700200700500000003975060007014049020060',
        '000180076200000000078030000029058010004792583057013060000005691506900308013000745',
        '000187209173400000000056701005038097024790500000040003067003004041060370930000602',
        '000200004450076208062403157740032091283010640510608000820307010097020503104800006',
        '000287900029306000708040213043058160100000548905100732032490875057023090000000024',
        '000400701100820965795160842004600107601780493370914500200508014008340200417000300',
        '000405860762908041005620370000019003020004087070200090018092050306857004257000900',
        '000409008490500010806000005972605840004920576000080902738290004000000600260103780',
        '000518629002043185500690730186400970300060508200009316820156490960020800435000060',
        '000570049050694820020830650614000008030008904500046702200709381901003475070410290',
        '000710050180406907906002300023185790018004532000307480257900003601270040800501200',
        '000742680000003000200850040510009800090080065604005179840300007025008006901060428',
        '000830092810070000309620000905402100426007908031090240240006010000080004008240607',
        '000843700006109804403006000048751620061030058050060107000015002000087940010394580',
        '000900003350802006190000750400008030205001009031509004986407312000090605023086097',
        '000902000200603014843100900028097006074860200000524870390408027760200100402006093',
        '000940028029018700005076904231709506946502871057461090000103000602804309300000452',
        '001000040027398105580000300100070450074056803653810297810742039700080620002630000',
        '001000208034100756820590431490307000300000910002000040049070380000901500680234170',
        '001000804740000620020590700405700032217400000860009047000000381902305400130070209',
        '001050364039418200205600900000200097960070850087009100508306010000800006096020500',
        '001058607508007900074931005190800372000029406462000090206010000749500003803702500',
        '001068907900013605740000083179082436683000090402006700290040060304625879060390000',
        '001284000000090105290010007003402581450160000100030070705001009010600752609057408',
        '001329750000000090502007000040083509708104006020006800203070901670002005010438607',
        '002000840091004506506020003000080901238195064900403208025638090083040005400001080',
        '002030805038040712570001940080053400605900028320008090063504087700002004000106030',
        '002043000006102438403900070008097200294308750600020981809030007740080309005069814',
        '002063840000800000863920015421680000500732460300401582087040056245076300630050000',
        '002406518006790040403100069009807600035940100081600002067000054094000806000304000',
        '002670501051000096000000040025160879040207360769830004016980050000051000570000918',
        '003010560047500390061329040306940020890000106102630009730800604600075000000000007',
        '003014802002058700805270091000802100278040530400000908004705009000601403100483200',
        '003150027092807050100032090031005040209070005800210709320006510000083076070420080',
        '003500072958072003070396000130009027007200080060734050040015208300420501521063700',
        '003672058005143760000800104701004095358000071400010020890000310000761580006930000',
        '004008005020046090639150004900013080062875940001009357073694028095087006406020730',
        '004018725050700000029304610031040097200109436907603102003890200800001569006500301',
        '004060000902300068000008009140605207609704315085003000400010690308450070006930004',
        '004085020000700543002640807900036005300859070465072009513298760209007000870000932',
        '004098020000506010506002070050619008461080000800400050945061002023000081187050904',
        '004806200671402008082073050009000040058204010100009000720900000895700420013025709',
        '004860002063500700200004038009137000700090300000086007390710460502049000600350129',
        '005000001103280795004195002007058926000000513000006800056800000831500649070963150',
        '005000004006250931304691075042030698800520703037460510070810409000302080010946307',
        '005493200024870913890216000087640031000701004400300600168500349300168705072900008',
        '006010073083020109710090000000080950000079310639152080400030095000540021152008034',
        '006017000301000075005800901240190706507206308000000012650980000108674529002000060',
        '006100340273000500405376020940003100360528090702900603509230010620480000000000208',
        '006109425504000900008402703731960502895000300060530079080700054159806230647020001',
        '006258073420900080005741002039572106700010200200400758000100060672384000100600327',
        '006427005042150908315609000401008300600030800020000091570310004230000710008004200',
        '007000024002834006346902005030009061821346059069107080200000148070008000018295037',
        '007058120546031080002007040901040000730186590600700403173802004009005000250600900',
        '007069000000700068642050700104002307900400052080907010526041903498073120731095604',
        '007102084000700600209040570574800029000200000820395047708036010010007400452010700',
        '007521360060090080030680702001450930000207050603008207046000000300809106008060475',
        '008009040164253987903000601047320060000475802230980170009030000376102058502060703',
        '009030084080000000376940251000305020200004109790002035900681070615723948800059602',
        '009040007000500603320000458076150842140702900800000501003005010200039065504010300',
        '009057062050400700000002015107080030900670050635104000491060020380040070072030806',
        '009124007872000190040800005213406800000380010684719523000008041400930068700041350',
        '009352468680940203400008700000004000000103900007529004520080309700035021001296057',
        '010030490534927806007801035000079100009380000420165309091008000000003000006794520',
        '010030504740085092000091760596300400270164350401500608100850936060210805300046071',
        '010050609200306187000020040006000704470100365003060000500600201702008950960230470',
        '010720500205006038007090001136908470980600053750430689509307800601000327800010005',
        '010790603487000120063200570150930860070080030300070901005369000036040000091025000',
        '010900680004102070500700009130207004005000730470030010041320900000408321283500007',
        '012090875708050023045028106087000040200800709004000608006001007409002531800079260',
        '012497803006025000307061005741030900200000000860074300005000038004058607000600524',
        '020004050805000000016500023008900305000248796047356180682405001530009264794162038',
        '020030805000000901090415670910807400002963050060004009047391500230506090000078000',
        '020196030790080206306702100070430028060020301083671050807300060012057093935264010',
        '020400917874901506105673800000210009648097320902004750000040000063150000481030095',
        '020436098900000600650109004480013050009000021570002463006300705805267100700050080',
        '020469308809010002160382597685034100090001875000908430000005784900006050702003900',
        '020639100600004987540000020000500003351086002472003065030948001086012540194060238',
        '023900400900005001010042003260850090080063000431020650352090000894506002100204000',
        '030201790060000250291007080324080900680900002000530860840109527002070009000005040',
        '030604987008090300590083000740006519903500008015907436000270640107009023426308795',
        '030690500700045096006703140160350000054060000003400057072034910300576000005209000',
        '038067200206040300754000906500000400629475000407080092070310009361004025000050801',
        '040005200623108407500004000012009376304016925000070008008000004700301860000002793',
        '040205790090673041000490000500007010013508000068010200006030020180050634002140085',
        '040500720025007063600002009052984030060300807080061045013048900290003000408009306',
        '040800290700090408298600001020506003560103800000470000074008356030760010650904702',
        '043027008080361000700800000291050874600008239000902065062780400350010987810430526',
        '045002080007589006608437005009600032023701604001003070592016043384070261100304090',
        '046058709900040080187000504420030197053000008700800350000793065070580012000400073',
        '046815300700040600000360000810700000390008561650093004520001409079534280403982705',
        '047089360001072090980631240000017450008000039050000870009006700016020083030100600',
        '047900050609030210005701094521300480703840000490502760010680502002190070876050900',
        '050972804020341605049065010571090200000017046400083000830020007004700000090450020',
        '051000200290865100043129500029036700300080002006241950078090300104002007900008605',
        '056000027902607384740008569370502000060089402400361708080010900594806200201400006',
        '057240096460000810300006007090482073000007100708510400900320050526800900800000024',
        '057400000043170598001020706890007415400000800172804000700390102500600074300000659',
        '058307294730500000692184705406001009010408623820050000209010376061003008307009002',
        '060000000039802014514630807400270901120596430080403500305060200091380746008907103',
        '060318524085024300243095800700040908810050607009000002500070001400060000300082400',
        '061270009903018206050369801000002050400706302302405067600003104500621003138900605',
        '062701004004593000830004007001067940040059012570140006450030021006008450020000000',
        '063490002279368401084172600040000700095084213318900560037000000020709000056003940',
        '065480027700329500008000040000690832000812704050000001280104370506038000001007206',
        '067005120052806004004000000005047001008013259609000003281370065090002047070580000',
        '067402910040001635930085247290003701300060409014000500403056192020819350000304070',
        '068030205275068913390020800809600000002080650000210700043800060087590032921346080',
        '070154903214700060090080000849021037706493002000670400320045086480367001060002000',
        '070182659096500728208700301509030200084000100302907000005870410900350876840061900',
        '072146305039205806061090024900700652000002030006039001310920560680010009004058073',
        '073800002050093080400102000380006000702009840000230760800950034500627098006004520',
        '075980623306025019290603008920306107700219030053800062047500391030190006609000040',
        '079000040001708960230000571405000016706530804190006752012907405900305020307410609',
        '080000419705030062460201500540068920600705340038042650050900200870503104294016730',
        '080045270504072960102000008308457602000010054459628130000003780893701005060084309',
        '080072050259436010007500923008703190100008370006159000070625801064817230800394060',
        '080209501901750846000106032600810725008097000710560309093608157800400293170030008',
        '081320090003006001004100035000790200609483100037052000002907604000038509018564000',
        '082007061701600350063108972106374805300016049000925000619400080058060030000080506',
        '082750310670240509305810270504000003703001608200300400030100045420537860157680902',
        '087140032094500070203008041002000004700005209038401065001070850870200006300050127',
        '090000070830794026210060400000205801081600002020831097000907200952310704070006030',
        '090260840000000900461030207012908070870500490900002180609701300004690000008025760',
        '090304060001070008503690402168400200000106850930700006056020300210043695089061000',
        '090736480006120007300049026809007003263000000700013008920601000070002091630094872',
        '090802160860500702000346000048003200639700481200000637086200010900018075010039026',
        '091426007062080309508030426024000030000510008050640000046358270003107004005000060',
        '093070002007002050250030009560890031000603527371240968009000000140329706708406093',
        '093154080700000050650080100012009070800270390900013062169547823530001047020938615',
        '094008030750000842080504109165780004020000700800019206000301420912000600300260015',
        '095002130237051908000000025000804216024609050801305009009043682102560090380297501',
        '097002061018300920526910783000281030600740810201090547800020100970008304105430098',
        '097305008256019003381040000060231074170004000503600001825103097634908050719450030',
        '098032600074016250162590830910050000003200000080970305000020506041000090605040003',
        '100000043030017950005240800790102080050000000428000170240098007509400028307521604',
        '100030706007800090090005843004500002035400900812603457721089500000001280500000070',
        '100069070089501400300074950207983010018007092093126084800742000000695008962300040',
        '104698723928000005703040081645000378302780090079000060007000219281570000400302850',
        '105700003006009014907310080800050307710034095003000820500291476200000158001405039',
        '108407000700000034090001872873050026450300008200000453010040380302006040540080260',
        '109803064000012000740596120451068090070105030003729015530080702007004900004050381',
        '140000738800063190350008624705192043980076001030580970693000007420630019000809302',
        '147080526030070000980254071300460907004013602008705010462897005859000004700046200',
        '148000200000000845072908000004870902759430068806091034207009000690004000085210090',
        '156382904703004000004065030000210803810603409035040060000408700040001000371920000',
        '170394008000070090005018600050030810912847305638000974007063020001420003009701046',
        '180000052070001004604050000003507061006430027090810005907648010000300089230000746',
        '200046580405070010060520007043060800080009763671830402104790620000600130326080905',
        '200096073639504812800010900060002080020137600513008000005680029180709506700320140',
        '200317650600200104031008020020030746005964200060002500050406801000085092987120465',
        '200506000864070520300000017721650439509710800000200700053400076070905048600027100',
        '200600000006074000487102053900061045150020306764083020370010000090000537600057090',
        '200950018009604320007000905352708641004060003000043500001039000020806154085012030',
        '203405089050080103806900254600002400000059030320046000508090007741020090932078501',
        '207006158891574620000000700028030471053420900900081205002040569039100047486700300',
        '207041093068732000314050700840017930500069007706000052009370061675100380023000470',
        '217000058560070093340605270900010705670809300405020169723000000000000500000002940',
        '230061489000437012046000000402700008050328060800010007504003801678102005319800726',
        '230081945000009076007065002700003018000500709809072004900856023050020001020090080',
        '250803000308261400000097030005784096087002040003006072700010084004329005500000600',
        '253807960090650070600193852030000046040200310180504020065081007000000685000765090',
        '260010908000287305050060000090000182680500739001920046010690250000052004020100893',
        '280315009360070500540869320070000031026138975138050200700500692650001700093720004',
        '283009160000210000090003050050071006016430072704906010600000780301068509078000021',
        '300000060400201005700964030008405010050178309900020040807009153000703680063580000',
        '300562001005100306140097008498031600700200009200000410579028100000605794604903082',
        '300870004400010209189062050640000005091000430523746891810000942006204500230951000',
        '304027095501043200200000010892070140615400720000281956006010472708002501123050800',
        '304107005916405007200968003650800000009016528700000960190204000802000050007080042',
        '307018500000062047920000380005004710401720000679003050053279000892436000700800090',
        '307090512200400386560000479086001057900580200102009800010900700639874105000310698',
        '310457260570109800096002071860940710750001300240730950985600003000090007037010090',
        '320608047700420010060197000573001008000530071416089020008302000297815364630970002',
        '326478009009015042041200030014807503000030001207040890053009014008123900192600380',
        '340000160007000430906300205060500002000002040492070050630010587200483001009600324',
        '340017925080000710010023040152060080060050091900481002600070800800205100001030050',
        '340609501600315098190000000060700054703002000489006030800591600520407319004263075',
        '397140000014206090052080314009400060123060900000719020006871402001000039000304600',
        '400001000832406910007008354054060090906200003328504000600310870570040100001675400',
        '400002030090375214002800570360197400200084063500036190085463000040721685000000347',
        '400058107028000653001639820783596012052100709090720006000905008065000070000870305',
        '405370000000041900010905070180460500050290008976000302569000820030806400040109763',
        '406258091080061020052930460067194003001070609008006700890600000003719850010502036',
        '406983127008000030170000008715020009064791280000600471031806942800009716697042050',
        '407600980390540026000000700680705394503960218042108650004059802835070400029480001',
        '408200159000054700357960004004306597003547000576190430609082015700009008020430970',
        '409003002160400350075026090058000023947001080201060074094600035020904701510387200',
        '409027058000000047857604230090082000040706080200001406004069005706805010915000064',
        '410809206093000108806043009000680021064001005180905467049007850308400012201350094',
        '412983500680174920307206000003000000009700318008010240000602000004030691030040802',
        '420039150619425000503010200200007040734080509086900300900100080361598002057042910',
        '470308605950260304003050000200005070005603142300192506530000000104586709086034251',
        '487906053010075986569320100004860000170502004605043720000600002743080690020000430',
        '490080301700001920003940705014076030030459070507013490200500810300090040841320609',
        '500021080219806504408900000004605728720304900081207400040000065856140307103000842',
        '500064203016030400000219600607580020050090060980607351700000100000008706160973040',
        '500083027726094830803572906000028103402001000008760290200000700089307562600059300',
        '500083102008506074000070003003000008105029706702000539800200690290764000037895400',
        '500090408486700050790458106040900000200000030130045807004602580058034792370509000',
        '500890627974362851002005000060921000230000006050083204890006740040200090700400300',
        '502631708730000020841700030250016003083070052000025807015400000004063005628059374',
        '506030402480050601931600070200860500300200010650090003700349008160702300890510724',
        '508076001201304000006050003743000050029645107005702040080167005010508064007003018',
        '510706000900045702402089000000030025020501070800090361189402500730610249040900000',
        '520804091008600000709352000295008100074000060681030205150046008040100950962580010',
        '540010097006587310078009600009040105450000000000700489610073008705000921900050703',
        '574023098239080064106947003860204031000000605340006280412309050000062010093805470',
        '582006003601250847034100000913000708000390421020600500000000300348905216276430905',
        '589040007032000608006080000710095204920461070050732089890304020201600035067020400',
        '600005190007000023280703654020340705040050260000000409010009342000502081302180006',
        '600039720204567000703040800006090007945000002137020680060250900570000438419000006',
        '600800002800690401190024603000046810008153000461089300280475100746310090015900247',
        '600941725059230006040580001400795360002003580030028100800359410300172008500064090',
        '601040005050000067879150430903000020010923706007500913706400058100765009502800071',
        '602503010030740080417086003854012006096070501020605000279008164040160278008427005',
        '615400700030500124040030956100047609086052473300008215408610397000084000001793802',
        '621387004080500030030290007000952600002000540006000372093070825200830091578009000',
        '630001002090628050004003160389060200002000800740209035456070310200800004010304700',
        '649035008083000029001986304060170500130050000950803007390600071700004093018090260',
        '650178490004360000010000056100830005837010264549600031980400600400290180360081040',
        '670000023400967001180000706300091085201008974900070300016509207090700008700013000',
        '691720584047518009002000170120806035030250841578300920000072390260080000700035012',
        '700029500014065000509004078000500901481096700395100000250071090060952487047680120',
        '700548001004012970003006020830070009420000300050000142000087210079001803218635704',
        '700904052094200006020860034070500091860009040950740000540020019209170400010400205',
        '703004058090065047840070190671509800000406725254300619026908401010040563000600902',
        '705908016280010950000002803056000128009003000000005000020004509698571032500089761',
        '710283049205004807498570006000800923087342065301900070000705002802109350603400091',
        '720483006018065490405090230140000070583000901290048600000927005672510009051000720',
        '730982416016004280400000053071543860309006500504290730800630002000420600090807005',
        '731005208850700000962831745403508107106070054000010006000106400210050683040003012',
        '745008000000500097320071008000207050076150203000306041290730806637814000018962370',
        '764080219090047830008000640000006481280314506041009020013072968000105370076900002',
        '786053200021006000349002586008600300070004008053200090100305600237469015060020009',
        '800004001006050400400800056281435079003176084704090130092361847007080003130507000',
        '800004520004000080956870140708065294040009075290708001387401902000000000509280007',
        '800047010045028007010305004180000752064080001003009460590004300408001070670003049',
        '800096204100200506620051030900735641050148792010060003061000378000510069000000000',
        '800790350000304709730815024001400290000980475490602030074100562300209040200040000',
        '802637904160004203073209865320946007500780402004500038000400020230090500905362700',
        '803400000674000910091020308002108090068350004039200705015006800086702400007835060',
        '804000723005720069070000001941060007500047910726005034358674002600500340410089670',
        '804209300001430085005001024008023670539800140702104003100305090000060518200010037',
        '804250931090830046170040582020080400000702059300094020010520094508610003002408165',
        '806290073001050846000860902005008094678040000904170368407030600009000050580016000',
        '806400000002007000059008763005104920040670000907020630090080070528090301061042580',
        '806531090259706003031890700168070009740000600002060500500010038683209007004000005',
        '807064210640000008092803460018700602009086301065102000026315894080247500000008020',
        '809000306076349050150062974092084500460970080701050640504008100620005098910400000',
        '809627000020043000000000080702314968013008000980762300007085193030001020000236457',
        '810009052400000693629300000008000510570200009091807204705098100900021730060073040',
        '810479005050026340260050900102004590090205410345601002528007034000003250439512800',
        '816700453050164897904380000100800240002951068705400000000000601001530904037010000',
        '819500000052900784647382100070200800205603071030090060100025498004060320708400506',
        '820195760950060300004080900078609140009571832005028690007006580596800010082053070',
        '832000400007046030090073120000520609905038240428691357080000090079315060046987012',
        '832140760000070002900200105400020600020060001700890403593014286270980004604050907',
        '840030070700402068602000400504319080921000503008200900036950021280103004090800000',
        '843106057126050400700004060580600721001205094279010036300001005000902018918503600',
        '850040369900806010071009050167000403000671005295483070580024006014960520720015940',
        '860319400435720091071004308153607289040001006700203510000806040089472000324190000',
        '865703092901502674000010358007405910049631080100097006008204031000008020300070805',
        '870420060360705020452806070607102800040950006235048719500309107003080000986070003',
        '876190003132084659005002017007810000201006000900000100760000348314900205508473961',
        '876324050320600048500008260050070906000060431109000027008250004740800002000900810',
        '891300725000000040470000900700106002140290587002008091614805009927000850538749210',
        '894756000502000009100209570947300160260075008300610092608090407700802916419000000',
        '900003002600500013051200800090605174763091200045008600400002358208307046009804720',
        '900060210500008670641050089420500860015089403380200900193005706050346100064097538',
        '900078000807653090036940805091200000368000907470369050080005006000806349609000500',
        '900480150050000300042510807120800475700090620008720900687000240200940586500208031',
        '900510000608943702704062139205384601100090040400601500367059280001000075502730910',
        '900600800507104000004900706005012680400700020002006905100269508608371490279048160',
        '903000524004020109520043678617500890200001300340298016000080900150406083702300400',
        '907023580020050090300000710700000351002501807851000900564710008089200670200605009',
        '910200000748000526003000701001090274275400003439172865007546082852010649000009350',
        '920007000107200000005301702700850200206003000008172650570620000609430120400708965',
        '920451030045026079061080045170208400294500600008040912412070308050830001703160090',
        '920635087050007096647900000060850012215479038003162050006590071500000003100306049',
        '925167300007430000400205170700980563290073410050004002602349007370856001004020609',
        '934106852000005916100080003000601708728409500650720094816093047070210000540060139',
        '950704100340896705067100489080430090500000840100070002035900274810000653002065908',
        '963000072005007000700032009100760083008903701397108020010006000536289410000510390',
      ],
      'medium': [
        // 3x3-medium grids
        '000000000000107000370284060030700480600041023248635000100903805006410902903000004',
        '000000000010649800098005100270068009100070068006001720000780250700452693005093400',
        '000000000200100683903786420380070050002010800096004000007000000435060008869020105',
        '000000209540000786080072015000025000025090370019460000000000000300146500861207943',
        '000000306305000000270003900028156000000000580017430209650870090080029030002301050',
        '000000720762010400000020060025007004693500217400230806130802040080040032006050070',
        '000003800002074010004085230400000000365020109029001680207060501100509020000712060',
        '000004000063127095402950183094060307700200040006001820010805000000010768300000050',
        '000004263000000004290010005085000120000700408060020350020430089000208731853007042',
        '000004900040700103510600820058307040000020080069800001805976412021008000704230000',
        '000005003050060208630908705000000009705090130304072086000487060173000000080321907',
        '000007300005098060360000048106584070043000096500036000010000639659000007700200080',
        '000007586000380000000006931308060105410000607570100090054078000000602700060040809',
        '000009650000006000005420070490073860601095040578260931000508090004010500000902084',
        '000040000400901028080003007041300006608000730003507400500132000024700195807050362',
        '000050000020190070036740000060400800503008704004009100601900230209007600008020917',
        '000056090060709012040200680100900560096007400274000000430692001000370000001405073',
        '000057100100290700602000000894010007501000080007080060026070309700039600359062078',
        '000071000600420087020000604504800130060509070010047205030050000000000021482100053',
        '000076285867504000009100760405090603006300800000042009500000028100005006080200900',
        '000080120000000090692007853000090240974508010200004008415000002708431009309070400',
        '000090804000018009890037010200080090000349250649075030107020500406000080050000700',
        '000109200690000008170600000005040670700062003060900100006003020530020987920815004',
        '000156002040087506506430100050000000023010407000620000002568004000009601960041350',
        '000164790017900086090008400003007518042001070870000002100045000050700030000030104',
        '000200430900607108000180002300000641081000095609005027810540000730802010090060000',
        '000203040540000600730008000410030009050174080283960001075420030600300850300000200',
        '000304010000700830100000700620137050710290040005400270207000300001000469056980100',
        '000309082384050076609487301060000893000900100001800060006071000970004008010500640',
        '000312000030905020025074100500020004203000090060001000051600800740258001600107905',
        '000362080052000000000094010901800642480006000026430050009103020300240800208000530',
        '000400010018507403004690000500970180702164090140008027000000230000240000070836940',
        '000403001940000000705109040810096004500830106490510000060350079050000002100207360',
        '000408207000156080068732050200000000590001006817500902080005620105080030040200005',
        '000463000609007300031005000000534902390100070205798100070300268000070090803000001',
        '000580623703006005580029047000900000032010900018234506871000260005000008009002000',
        '000620300300847120700010000080090640040583070093000002030070004070106030860002710',
        '000620840024300675061075000710950200532084100090030708003500000000000000050042063',
        '000690005189570264300020000400000000090050130000000609038019052070005910050246870',
        '000700003572036100630089000100500230900000050300198006080050300000300780450801060',
        '000709002500002906901800004307200000060084709405037201000000140603000007018070605',
        '000750038509000021380001000100407800600523004703100060900805700057040016402000080',
        '000805003007200058859140000300050904000300260740001300905000800400520070200936540',
        '000900000030048250080003196009306500200100004013080000000001070700590031104037620',
        '001000000093278006500601203020900087974100060300007409006004002100300800002800630',
        '001005473630910000024300000010078360250463900000590000000802000080040106040000730',
        '001020607360800400405009010000600000600072030030100046219006700070201500046087090',
        '001564072200008035000020001502800000030005090090401500725603100410050200000082750',
        '001820479000000168800091500005600200400003651600040300006174030007000806000268700',
        '002080600800050000300701040027009300083600000000430897190307000536108002008506400',
        '002350079005080340700102605000090003500203004300470506010000250058907430004030060',
        '002504000086390200009000360065800070147605900000207600004070028708050046000080730',
        '002871900001400002000000148090280003730900084608300701050008416300540820800060000',
        '002900013791300050000007860019700680603001925000006000140023090300600107000104030',
        '003001049000075000980003700070380504040502037035600800000750120500106403607004000',
        '003002060465000920800605071740020006050406002200850030000230000030098210907004500',
        '003040091504302007070001000000000829490065710100930500706009030830700050001003970',
        '003060080060508407108720003002816000651040000087000090096100320700290040004600100',
        '003200800080700000001340970000020460740980005000007200010694580054070020830512000',
        '003806204600709050290043008001500980006098100038200605800902000040005000060400507',
        '004001000090006008005900020700800310000032700000617285400198530200003060318065000',
        '004086501930502607000000008100300420390001800800207010080700060060134000721809004',
        '004200156060008042502000900050003000000926003200750684900480001378000400140070060',
        '004500790080690514030004028097050000006020000308400172900830000400015060070040059',
        '004560300010080294000100060200000000500001023869005007002000008108342570070908040',
        '004600095090400630670800124760080500500207300402003060006708000107092006200100000',
        '005000000103200050070000906030940070200030100900000235300750480000198063706300091',
        '005003269102079500003582070800006032600000008020801000438060197201400006000010300',
        '005049003614000500709002600006090080540730109192005000063000000451300006980060001',
        '005060273300512800008007195024690500003405908090008406001000059700006000900000002',
        '005103700083070020000090000800020000072450896409000003000007680000605931906012004',
        '005134800000005200700090053380900500010000920509048000000301005250089130000507480',
        '005200800007400300006390040508070039040629058000000007654802000170030084000045200',
        '005269800600510043900003062000380000000694185800000009213950000006007000508400206',
        '006000254540702300230460008401003780005000690062078010900030840010007006020000007',
        '006021805050760100030509000103000009005493701007008503000070204960045010500030008',
        '006079025010052809005008001021060934000041000050200708709004000030086097508900003',
        '006080040010904060489500700094615030027000006030008000000001390142306008003047002',
        '006300809780590023003008670172849365000050000050000007000080730000205010000060090',
        '006701000023000640009060310704020080608340702390807000060009000000070208280050970',
        '007000060200000400950140730020009183090602004070804900002473010140060350060000240',
        '007003800062091000000020000000280509654030008200050003740002965098005007020400381',
        '007018350003490201000000098620100073005300489400070020540700000781032000300560000',
        '007050000002000300040030086700940020000670140090821007025300061003004795009510038',
        '007064900859000460610000005003008791080030050700000020000082000540900072090745006',
        '007082190800051040005740000000008007500100920000023004016090530300205400459800000',
        '007504620654080970000001508478006000510000000306000489200040807090000150701000030',
        '007509000540703000200060070050607842700280109002010300074150008020000000096078504',
        '007901005100085000900000062250068301840000009371592400000003508008140000700009040',
        '008000075507008400004700002893002047700040003002900568000000706370050000401370200',
        '008007005930400706050000309000095267592078140000200000300000000049720001016084002',
        '008029300001600047000000208005300809020004000037295061100008604080756100370100900',
        '008030001157000902040002050782300060093608007461025000670800100030001000005270096',
        '008094060009053210000100900080409023003007090901000500007030100850001036014070859',
        '009300480000018500000000003903501000500024109400036702068743925005209060002060000',
        '009762000008054000240100500090576000820031069060028135086000390012000000007600420',
        '010003705000856001059071320000182900002000060041900050000700009478009600190000270',
        '010004007436280090000501643308006400009000100170800360800000700650710020000640830',
        '010009087080100069390000010563200000079608020108090604000901000850027900000040750',
        '010050403350612000028074000530000080000037150802500006795160008003000560180020009',
        '010082500000710096053609021000270650071003200026050140000030008007026900008004000',
        '010289070000034508048006000000700000100693000920845361600428105400007002000000030',
        '010450090200009174409007000001000730392080006000140980000061350600000801050304609',
        '010620500007009003000007164400006721109372000008100009200800000086050042500090076',
        '010850204940017003038209070720000010060020905809400307400592060070000009000300400',
        '012703045000200300050640008064070530701000206000020074925810000600039050040002700',
        '012807903000001080408360100240000831300006000000030009000540790974010358000070610',
        '014705090000003020093001857362104500100370206709000108005430900430000005020000000',
        '018300500020060473004520600002180005065037904130000060000608090003700000056003007',
        '020000070705040028003000509000052030050007400684090007010603702840925060030700905',
        '020000147050670308030000560541708000000000750070009006605000030097200081200840075',
        '026000040004001900890604000030007620680000003170060405008706090000198530960045700',
        '026041008000053001100609007580006200004095706001308000907000000000000602462807095',
        '027000004003084706004276300046100500001067000800400061230000100018090600009002438',
        '027030690960001000000009240049006700006000452200714060300000100700063080004580037',
        '027300005600000020035002000008250000100003907050601030406008001019024368280109000',
        '029006030006935270000840090000529000050617009000004002215700040003000715078000920',
        '030806907028000000004090815500769300082400090360000700800020160000973508003080209',
        '036005001500014703040902000102369000005420000000050006804293105019000462007046000',
        '040085129100200000800090300000006850007008000000730964275049613938600000000520700',
        '040090673000800490937564182309002006026000500010003000280400060090000000000389040',
        '040391527320640900009027000000060710060000430030210050090030140010006005076000800',
        '040602810605910000720000000400500200002030900037200004004000005290375081050140729',
        '040690071009000204106400038007260800005000007000040306600030002734806105580079000',
        '040700002020610000907028001010096420004501080580040010358000140000004256400007908',
        '042510706007030004865207000070020460008065200006000007000051090600402000109806340',
        '043005000091462000070901060189600500020800490004200001908040002700000045000396078',
        '045901028090000010670042005000500107100790053700163080418000900200000041030006002',
        '047500008003000400090008067004031050109407003008000000006204580071900600502300049',
        '049000002025309168000008497010034750634070981000100000000785200180900000200000070',
        '049003106000001050010040032000100008060702540401050370150607000070015060036029010',
        '050009070901540002802016054080000009403005760095002800208000007000007405547301090',
        '050040308192000054400001000015800009984006570007000030003004625200058000500002987',
        '050060081900000345483090000800049703394750000000008000067900030530010000200080056',
        '050072030030800000170349602614000003083700506000031098000003960500987000007006005',
        '050900720400002000273010000000400510864000302000327060500003007010275800020849001',
        '053867900780000000106432007009000005400076000010200069901650802807000300000080091',
        '054008793109500600030090000001830000003150076600000300065947032000300000090200058',
        '056087000000150000000009205593006000400900020072004008007490150040702009209030604',
        '059030000600012005070508609000300700040070010207851090015063902090000000006009307',
        '059472003400000060000030504001290630094000257000000001028003905043720100000048002',
        '060000000250840007070020800100074300402530000036090200520080690800062074600709120',
        '062180703900703520030650000720000064040320007090400238004075000608014000000000070',
        '062908000039705802048100600000000200970200068020006054400623900005010306300580007',
        '064000300950603070038200090000030000100860907002095103010520400400300002306000810',
        '068000400170002005040600731005030048030090056600001370000410590309507200001009060',
        '070000038050003016301700002860014057030080201719052080500000000000530009900870000',
        '070000085004300796008005304000598600005073000800020510059604008700209400046007050',
        '070008540900010030064300009400030600090485003003701804059046300201009000047020905',
        '070080306003000040004300059046018002957260008208030460705040003600000020409050070',
        '070100050500000419040005876100000005080614003007590024032901567019307000000400001',
        '070120600460307810002400709000001078928004000607000090001089023203000906890200050',
        '070408000001000900836010020007002830100500762000607100760000210508701003003000079',
        '070600913008920507003570000020060300064007805705000160050010089000450700480006200',
        '072600000001200800830090120700000006329840070005030900084327010010005702000061403',
        '073009560240500937800003010000010000004200096305700200090007600407800100020900704',
        '073010460690073015010096080020500038048000100060700004006004001000027806032000050',
        '074000060890040352000982000027091000030000170000036290518300009902100000740060810',
        '074012090320000840009850370008503000090000083050000709902068000006005930500030206',
        '078900010050800040900000700001005208435100060020600050006751020200380000500206093',
        '080000027023715960090060034012009075600008210034027000000901000050300600000086000',
        '080000605000800920070615400000080341800904500300500069060050700200409100000068203',
        '080000605006390080002005031060400100340160908018900306900010400831000500070509010',
        '080409050400300000006018029507000630600005910040603002260840005070500000815006700',
        '081000903000000000030786004058010000070960005040057380017092030020000059594603028',
        '081050204007200010240300008900670041750100006100800700006580300000709005005420067',
        '083009001651000008700518000007986100860000429019000006500040000906053010000007300',
        '083200510001035070090807403040000006016000708800400091102048930000000600070500104',
        '085040901000050406204300070020093085050600742076000000090032800000080000560070093',
        '086700090540091008001608203005360820320980605007502000000009400010003006400070001',
        '090000004008000900500819070409570230017930000003060719070000490920000583680090007',
        '090000085800960003020548000102000800084090300900700026030409700060003500240600901',
        '090003000040900002580100070009000050400305000875429600000631040154092706003540108',
        '090136000001040063603000900005000310000863007308915640802090004700384000010002009',
        '090300680307600200050020031083046170026108940014050000000514090070003510000000400',
        '090480500023079001006120900300060150084005603610030800501097380002000000038050009',
        '090500017702190458500000900620080300000360081000010000200000009167900002083650070',
        '093051000702300000506980020304720100200000060105006002900140056000070410450600970',
        '094082170801709030000601059005400020200500307403007000340000680008000000126803005',
        '096501300015074829200030006000000070173490000029006000601000700704903052930007000',
        '100000003000003805900500000601007000530109406270406050390075081006380002020060007',
        '100237800078600090030090701306050087000009100000080009000000000905146300020875910',
        '100672000070004800000100620050000001008016750002080903597021300400507008000349572',
        '107002506400300007003070801200598003030000080800003654010406090090127000054000700',
        '108270000006085001900001007030090400480053000609007030010830076503700804860500309',
        '149500306007900400000002970091000000420300000030720810910087600000090140650410009',
        '184090702006008100070000000030004971749321008561009003400007080008100090900000510',
        '200004090009702100000938006040185730100000500850043901080006009094300805702050040',
        '200301705300050108006798030040600503050120400700040000070000042401030000920080670',
        '200568703009173004003200000907000512000005400032700800080000001300600240720410000',
        '200800090000230007074600003408020076020976004060058201013500002700000309690700000',
        '200804005054200700097000426479350800002008003638021079000000300083000090006002008',
        '200900000050836271060000859002009017870600000095074300020091038708060090013008000',
        '207005000080040710045700300070069800600000000852070093708053100004981070509600030',
        '210007059037009401906001030079082600600504000000930010420090080103008004000000090',
        '290008003007590000008000007030056084000020000850009701000271009923400006075960400',
        '300001000900270006700050001054089000670130900090460180006900418000500369019300002',
        '300050000017000503094070681240007300050001800003240000675020130030710009100000467',
        '300405020000862370600000089030000450002000103010374000508743012000010845040009000',
        '300905187040301005501008200000063910670219400900000760000002070000000500260157340',
        '302069481060208750050007020007002300000381000013005000130000269400800037090020040',
        '308600070067342008400570016003010005506200400200805001031750800070000093000000047',
        '309005206000906070060382900500010704000004008007060000000091602603000085102638407',
        '309021007080094600041805300400958000060007900100460000036140579000030000000700036',
        '325008940400200083009005007000107060800906034007082190501000009234000000098003050',
        '370000009049000285058200301005700020703401856400005007000350090006987012000002560',
        '370020080584071000620340170000009804000132690962004500240010906006005008000000003',
        '400000020209481003007053000000002000100037805003890160004100256000306710061020080',
        '400006000000948070370150480050870003620591040708000010537080621200600508000005090',
        '400201000002300704038705001000089160000036020006100000004917080920050006500024913',
        '400600123006003470371200890600000000090004068725030010060090087037560000004002009',
        '400869105900200047050400020040708003000014072700023000001002050074500010500080294',
        '400950007090100850000006900004020090703800005180045000930418062006000109851602034',
        '400952031010000068000000520007508002150703096090026300908075610000000080670080059',
        '402090813001000702080000950307040098040002000028070000019238400030759001005006320',
        '407000000000528704000000000010800329203059640900000100020700800349286570001930060',
        '407090153002000090069518702000300086040960200700000900198400000070000805630020400',
        '407800001020001004900000620002678100104005063076400980050046207700000800261580000',
        '408006200500089600700500190809003021304008000200091053007640509905000000680005010',
        '410000290700042003020071800000005900500039006090014052000560079600000000904127635',
        '420000060097010003010480005840052300000760020062040500070000658281600730030000010',
        '420007050039650000007000269301200486600340000004106000960020517103000000045060308',
        '460102003900670000821059004600008090500290380098435207000003100200060008009000020',
        '500032016800097003309506000008003000150004300637000140701040090090670058460020000',
        '500080090008395000014600580002000005805079016060450800709000431030000008050000267',
        '502000090000625030308910026609280000200304000080560210020706380410002605076000000',
        '502781900700650000183002000401067000007205460800900150090008704378000000000300805',
        '503804200090007804048506300050060038002485067809000502000052010024600005100000000',
        '504010003010000009908006040200009000100070490093004600002000934071300820609800175',
        '506083000004005100781000530163000024400060015075001000340700000017000240002400376',
        '507010832300800574200000061001020000020148090000050007130075640600080003402006150',
        '509000046100007009230060781723000805060078392950000004800000020090000003302016008',
        '546000020320049000007300080760000000901037600254086001809600407602700108005803060',
        '560037018173040020008501704040028003000000200200304800010405000602713005050000080',
        '560374019908500067104800502300980246806040790000003000401030028090000000200000904',
        '570043016006070920000695000800100009304080501910036000043000607050907230000060000',
        '593001800006004139040029000300040078405917000000800000930478205604005380050200010',
        '594860000000073006730005200050046007403700000071059340340010002900028030208000570',
        '600000007342008100708140602030400976200000010900001040500814003003600500090205004',
        '600000008940070000178406090317940050000300000000100039701054003005000614409020085',
        '600000050059001640483020000924103708000000031100060520291035476000400000300070200',
        '600007000003945700004008000060401258000286030982003041031004802700009003000032100',
        '600009347070602000080004010751900020396120000040057109000200080100800250827000001',
        '600040009048200060791530408073190000150008900004620751005700090000302600000901280',
        '600380107079210506140605209000402073200007050000150092090001005410000000580023004',
        '601009000705006390900702060200010400010000007503208006150320609460080005007000028',
        '605280300040160098080040026000000007406503000103708400000950000000470201000831659',
        '640000035120003607090000100500496003000108406260370090000600010078001300006089504',
        '670401050903002040401900068007006009289140576006000000800560710104000095730800000',
        '700013609615700408000860700570002010190500000000137000450006100360900007027041096',
        '700096200930172050050300917073601000004709000000820005020065300410003020300207040',
        '700100095900053400400796812002370654030240908007500123009000000000080200010605040',
        '700190438000045010100060502380070900000008720500930004000003205068750000000620801',
        '700200010004900026020000890160852000002470080450693072080360740501009000003000200',
        '704009650009068040003700089005086310000170400006203508300401000501000200840052000',
        '705200003060839004083405000000000900007010302010923070020006005308190620071050400',
        '706090040201000503000008601057310069492000007060400820070000300320765004000000706',
        '708000009090000000230090187470506308000003400320000761040807015503009800017004000',
        '708003501600970400040016709000058000106090850800062900084600070002000314010500690',
        '718000906060009002302000480080036700000872064007010000070600000130407005200358070',
        '720009603000206509000000000016800005200590061080601300800715006400908100107420908',
        '720800063906700410450001000210000089800000602000008140003109000192407000084003071',
        '800000200005007004060108003000090658648070912000001430453700820900200000080350041',
        '800002001100083604403006080000710002012040830504329060948000050000530408005094010',
        '800007000403000000060000109300102864102600007050043012030074091007006430214300008',
        '800040910000009062006280005002406187005800090008102304701300520200900031060021040',
        '800050020120079050060010794596001400403900000700546930050000000607100508000700609',
        '800090000956130800030006000500000204090000605084001700160080970070965430000710560',
        '802630010003050049570004200024900000000523471100400000280106090000005084490080060',
        '806000001230670849041030005160240503374059210008000904000502000007300400600000000',
        '807620040543000000000000710072406109085092003001038602058304090100275830000001000',
        '807630000510000706000807250002450008380709005000008407709000002100502390230040000',
        '809020143004108000050003002300906701000530986068201004010059200500000408000017059',
        '809410062620890001100000000092000000310080295480529703000000030003156807000902006',
        '810000200504000081206980000760800105008012607921506034000104050190023408000000009',
        '830010400000830020040507300400000070506170000013900050081726000360489210004050080',
        '831070604002800000047903010083097005720000000065000301470050160010046008000300009',
        '837000209065792030000180060001906000900028054023500000010839040390004000000001093',
        '839500061070804002450091000000005910090078005165900270306000080500006009000410006',
        '840610023706002048321000005600200890000000634907300512463790000100060380090000000',
        '850000210097004030460802005000060027020007009179300008708000000006201783032000560',
        '851006930074100020900000641200005083715063090300720060090452000068090002020000000',
        '859007600230400589006000700000050006062003900705600830000001000524008197000000458',
        '859030000360085000010002053090063400000020708280500091034008006000059012000370904',
        '900002008064009020780000006001900384000400007207800159026095831190000000300014000',
        '900004001100389040060000078001697400040030017200005800408050090013900280700008153',
        '900054007500038602060700495635079800200085000748010000000092173000007940007800050',
        '900060080080530000317009005039001006000090400048356010403070000070008300852403060',
        '900100007200040905080005000402018006018270304039000010503091248000004100100782003',
        '900600020060000043500070106307590008800004012006720930070050000690207001010039670',
        '902000630150236907700900000600090070000042050004305200280051360001800700076420010',
        '902480730080000100005000000000140060401009007069827010003904800108700206054208009',
        '903000120520000060068020900701254600030791040000600751200310007804000030300400510',
        '905000120020870450380050000802601000039400560001090002060080900010906830490003200',
        '906007000801692000402003679298030000500001006007000035000900000700005102360214090',
        '907041000056700020000250940800009612209000450561428090005100000000000530602005089',
        '910800520000005801250060907000003000580001043170080690700200000390740258005300400',
        '930106500000080032502004910804300100290010603000008459071090060000071000020003001',
        '960530478017200095003900006231000604000004080090005237000000800300017500054090060',
        '972001004400000001003008072107080000020905000030020708046000020001063507358007469',
      ],
      'hard': [
        // 3x3-hard grids
        '000000000008020045754001006070900004009100720006002108860510000090004000400079060',
        '000000000041000000029500008290000081500040230600203975030005190000170060080600000',
        '000000000050078200000590870600200100007004500004003008500000723040000006276030401',
        '000000000090000340840900207704090000302056800005340001000501702008030000100060000',
        '000000000270438016000270890810000000426300009003000008000040050000807300002010604',
        '000000007009000016001030840090003408314587090000020030000250180050370020003014000',
        '000000009190700530650000870709430000020008046001000000400009605086300000072806004',
        '000000012240601009000300050600100020000700003320040605460008001900000008000036900',
        '000000036800900071000070805004603000260700350000402608930060080000025490400090002',
        '000000049901708002080006000000087600005000170068340900050000000200070000007800300',
        '000000090400007008170000206000700001637000029290060005060002000003040617815003900',
        '000000094400800000500009002067004018020701000048036000804050730203947600090008400',
        '000000200000300081200080396071020038090400107000003509000034000807209000023750810',
        '000000260040000000059000001008100000000732008300604917200590670704060130060340000',
        '000000426040090000006400309060703900380000764010040203700310000001920507408060000',
        '000000500009106430060090000008000050004000982300980007000035610017000090000000270',
        '000000570006920000203000004789500000002096400010080009400170260900008005100053900',
        '000000730305008000180094200600005000073840100240000085030510020000200564002060009',
        '000003060004268509600170300560810290000402050090300080000025000000700000070684100',
        '000005008000000036605093000050906100987001004010002050500068071000030609003170000',
        '000005008207403090050706000300007400008040956000200000960054003004830060080070004',
        '000006000670408513500200008700020006000003000401800035008004090000000302906782004',
        '000006380830000009000403700702000008000572010000000030460058900079001060058000004',
        '000006809000807024080300000000200495040103000065000000008045003074081000510900008',
        '000007100150003609300062080007201000060009700000000094040005200030780040706000000',
        '000008005040000020078063900000300000306080040001694530000830091000016750210700360',
        '000008035000650017780391004000067300103000009060003048092070000008002100000489700',
        '000009080001060020058000406205891307000030000060000000300004700090300005000070902',
        '000013928510020000009700000230060000000070090007045200600850000040200000080600031',
        '000040006580097004003050780700000000092000000308000000004008520019500807830100049',
        '000040603602870004300609007005700060700000005910080070087100506094000700000000498',
        '000050007300100060000006200469000023500090000000000010703060800618000079042005000',
        '000050900030008400100070000703015090008640000401090020004500069670039018095006003',
        '000060040000200000904080050806000500400705690100000000200003060008001905563400700',
        '000065900060800015000000040980206007000000030002040080300620000006570301100000402',
        '000067009000000310003128500837001090024703605000000000000000000085000243346000000',
        '000067040000008900040030500080302000009005823230000100007500001060003005415009008',
        '000070100200490070300000006040500613000080027000700580000050260008300401620140000',
        '000080700006072004370094000003000490200700060710806250007050006400000102000000048',
        '000106000752000163000000005120074600000815400830600000540007008270003004090540000',
        '000143000060020040004000830700500090492030685000000021000908007509000000006210000',
        '000300205003002090092700013078040000000010600204003000560000407300104580040000061',
        '000302000020000030530709001008010090000600100009023476010000047007460025840005000',
        '000350000000040000700000568500001000061000300387900005020073001008000004004120009',
        '000390010710050004096840053904000001108720000000000070009470005680200000000009630',
        '000460018039281000000009000070008030060750000081030275006005709290040050108000600',
        '000500400014000000600000051460023017290007000003000084021705640007031590000400078',
        '000502080740168000000479060001080230000040090905020007300700400070000918002000300',
        '000674310071805600060013207000001065006000402700050080690108000050000030480000090',
        '000700048090000700700050026005001037970805000230006190500000000380142000000009280',
        '000750904500400000703600805001560700004300060008007092030204000400006150067030020',
        '000782030214305090000109500058201000439600000007000600300410007900000403700003002',
        '000800000000093007060172583043000850809520000500308079000704020000000095302900010',
        '000800000039605400008000603005390000700006000380170004002900100004020306010000000',
        '000800054800300900000964170090030000002000401600400720540207010000003000209140800',
        '000807009600340750070602810060500100900738200830004000287010506006000000509000000',
        '000875300400013000358000010000007080070060451105009020020008045081504000030000079',
        '000890700000003019930702060080000527706005031250000940003000000800000600007104392',
        '000902060060703098000080057000100009900806410057090600042000001018020040600000002',
        '000960000070000056008004001790000040200700300054320000020491600369002000081000295',
        '001004005924000070000120300000700000006400013012800500605218009000007600100690058',
        '001009032900100700000000410000001300600043900450008020086200170007000093000000856',
        '002000008070040031500890007009200000000503040040000150610000000000368700780150003',
        '002000600060000038070000240000056007000904065906370000030001890100080056728600003',
        '002007000000000000100405009005632940004709800600508003208100705406050100501000402',
        '002107090600000320000002000020706803800004100000000560000050900063070080791300600',
        '003000605006500840000870200020000060050960700038000500590620480360008007180040000',
        '003002009000800005405001000000000402004210008200309601006000080057020100910078003',
        '003900000047080000956002378000065014800730500005200000000129000090070420021300060',
        '003900080068000005000600400005102094090400000280700003851000070000003500930500200',
        '004000000700200510106940032000007100000000890060300040070034000000100000309605000',
        '004958703500700100900301400805030900000400030010500000750000000020800090600073015',
        '005083000300006842070000603036804201700601000010075000104009000000147506600020000',
        '005208010000000809128690004000020000006900430009040208080014000004002700000009600',
        '005301800100700000002008000800000006390020475064000300000059001016200900043000000',
        '006057010910038702003200004807000500000100003000000060069020430140000200005004008',
        '006080000003001400500030001408006000000050003007203910090174800004300197700009200',
        '006091070300000104400005608000002519000000060100006400901504000570080040060027001',
        '006152904015600030200003000650201080001000000027000406502007000139006040700030005',
        '006500030000780160830920000002090050107000900009010327605000790200000000013050000',
        '007000509020908600030250700091020000700406000040190037589042071000709000000500008',
        '007403902000092103002000000040000016200510800910067300000008005020000780000105060',
        '008007090000890004009000700003006500605148023200509670801020050900400007000901800',
        '008060000000015870004000200150400908407100000000850000020900310800002007069000400',
        '008100040000080090064070000000007009009601082201000007080020014600400073415090026',
        '008760403072000610000950000800410007456079800719000006000090004937200000000130000',
        '009000000680030750000200908310020005000000300400190000050402609040000000938600200',
        '009370180080069002002840700057038000120750068000200070010600027030000001804000000',
        '009400100000000807700002056400050209900007004307000081604035000802009710093700040',
        '009460020000000609000100000210386004407020060860000005000940000000000053784050102',
        '009870035700245009025090470060012000070000040900003010090600080030000107000109620',
        '012034050000009640030600000784001300003080060000300078000002030005006000068000907',
        '015000007000036800000500109080005002059002300007084006832470500000821090090000200',
        '020000018150003079007805000260700000001208400000004720079600080000000063040100000',
        '020040307100020008807010450002000000980600504000008100248030600010000030603080245',
        '020080060007940230000730900100029370000314009000000810062001080070000040500078000',
        '020080450000670130043000860007540001000030500080910000800000706070800910005200004',
        '020390010900014050040000000600020005009003076000081920000008060064007090105002037',
        '020500603000300004009024750050200006008000200012603000034000000507000001280900070',
        '020809300090041807070000069080903000030700002000050090007086000100007400800105206',
        '020900006501000000730800015100270000000013209000608000408506000000002600360000057',
        '025607300704503698000000020008050000006470100490860057000080019000200070600000802',
        '027100058050090400903560001000900300006040009008000010002600030510070006000810000',
        '029100060570980400080004000056001090004008610000400730960200000000673000000819500',
        '030000004704000500000001000003000068005023040006900730608000001300805000402006890',
        '030000010017390020409000000068709001024806900000024806900040000580902060203080000',
        '030006040000473000900001000040000500670500003100060000050000180080290607709185300',
        '030050074600184000400700069840000301090503206200000040500000030080200010000368402',
        '030090100014087006905401027821000400000004000090000000000032080002100650100970030',
        '030290600010048070000000894500960001200070000100080000020710048050800009806039020',
        '034006002027000410800002000082000000600015000040093000070020049008931600000450008',
        '034017620006300040090050708203179400000000200007502003608000000359000000000280509',
        '036900174002000306009003500600802000000006001090007048020308007007000813500004009',
        '037000625006000000100250070000601000014070003700500001570460900402700580000000030',
        '040006000051000400000097150000780300030050800706042000674008005100070003090005720',
        '040009007038000006000280950000006830700030605003501002321090070000004020500308000',
        '040900003005308100000025078583094020060500009029003500000000700902001300700036000',
        '042061009500000030003080412000036005830400961000000800600000150005008004008925000',
        '045001000000006001000090070593180060080960100007025098070050002000810040134000800',
        '046000800500009007170060320900683000365042070000900010800000005031850006002000480',
        '047001000000000000205809000709010500000300009051297306020005610070060290010080040',
        '048007190903000400070000053820690000065008000701500048512004309000000060000210080',
        '050006002002000000060000914305017008700004039006020000670400000080071090009080103',
        '050006003007480012321005600560000008730000105004000070100590006000104000000008000',
        '050087900064920580000054600890000000020000870000000006000000008040109250700030000',
        '050709000006004700400502936000005000610320000500097163030000090248076000000050078',
        '050900003602083410800000609005270000030040002040630790400000900510060030360000000',
        '051406030300000400029703561000001000248605090000004250600100020500002018030000700',
        '053280016012300040600015000090001000576000000001009083004050320000060071080002600',
        '054170000001000740000800102179400003035060080800300005040001027600040010513000004',
        '060009000041000060000506003050000800207680010810000032000000970030002600085791304',
        '060030042432050007079100605380007006000004500200009000003800460046090800000003021',
        '060140000720000000040875060070000493092007800004050000000090740000060025058004001',
        '065000089080645000000002000506480092700000038048073160300000900090360000014009070',
        '068070000003004000000180370900407601000901007000030040009043108057000000030602090',
        '070000083010670400020000000005700009300000800000580026090304050050020030008060010',
        '070000650960308072500670098720035000000010584000400000050163009080000300632000000',
        '070000932109000000020000070200000697000700104500000000040308720000090306000612000',
        '070003000620004300403005060010007090805030027030012640006500070000008000902006014',
        '070400000081600003040100829860703400020006000000082390106000900034800010200001000',
        '072000060350700048004090500601000450020038106500040000000070000900350020000100905',
        '073002600200105008000000000729306100040000900000008004000003000007560001098200006',
        '075100800690000000138050060903201000080530201201000605067000000009000780800000500',
        '080007021005001000321900084400006300067090400803070005000400003100008600000610000',
        '080010950007050032350800160600305020020000040974102080000600000000030070000721000',
        '080030900940070081060000302006800050009604000000193426350001000004300005690040030',
        '080039070006780010001256000800000002300018090150002030093820000040500081010007003',
        '081520000000000089050009100040672001000018020120900800000230000015000000792050016',
        '087032450000900100000075000000000810709004362600310007000703094000508000000001205',
        '087305920956000010000060000500000000420030070001270000794000860800003700630000050',
        '090000100067048025050002703306005001010079004000800002500000080084000500600004000',
        '090026000000098027502037080008045000006800010920000078600002090000060801050780300',
        '090304005000200490050086302300009250900000060070050130063000710020000500010000000',
        '090603050080071030000002706003067004406100000000000962200705000307000000000236071',
        '090700500205090000761250900006000042004020006020043100078400000540000081009070050',
        '092130006000905080000008000960302007000097004030000052020000005403020700500006400',
        '094080702007060001000010900085000300000004000000300200003648010910200080048001000',
        '100000040300600001708400250030000500820006900009203807000390002010007069000100485',
        '100073400000689020007000800940000006002061000001000300000700695603094207020050000',
        '100690800094000060006005000013050082000870003000203010000000048600002075051040390',
        '100830000200070068700190300000510830300008950000000620070003000009004510500001786',
        '102000486000021030349060001400090300007000508090250610280300940950000000000900000',
        '103000004000017020000005000008094350005003400004600100530040271041709508702001000',
        '105004900000020300824000700470300000501000000062000005600070002007080500040050007',
        '108769005050001000090800400010000800000096000507180039830205900062008070900040100',
        '140000083027005140600000900700236051403050069000014000000700002000090610094000530',
        '140008076002030084003000200680000005759600432001000000000000007408070903020013048',
        '140807620056103000300004050031600970002008004500000300060200430000000000005000006',
        '180052000305016000006008000000300509703200400050860007600070021500600003032004600',
        '200000090500206700816700003400100000000050030900084520000000807000620050000000062',
        '200037501075000603000900080300700900017029305000403108652000000000000400830006710',
        '200309080007000000100758000006940100010020548000001700009086051000000000600504092',
        '200510000009006800060800090043008000500904680600072003005400010021060030400080700',
        '200679100000000000596008020639000010801050006000080730920001403105304600000800001',
        '206000004900000125407305600008030000040500000000406038001063400070000803000058700',
        '250080000000000860000104000000070008300401700900025000630042570500318004102000003',
        '250918740001700008000000020070200600090381500000607004100020080600104000004000061',
        '260001000010030460490067108700006200000050700840300000050084090900025000084010027',
        '270800590004000006000020080009000000360050002040700100007002930000390000100564000',
        '290080604063009000005302700054890000020140096006500000000074008508900002000050100',
        '290500000040090000000820300005600000080042000709000060902080057500209130100007980',
        '300000000006000342100604000908700005005829107010400006004300618000098000280046900',
        '300006000902030007400002000150283060000107095030000080000601009001420670076005241',
        '300019002000003819008520000000700050570301006403690000000900605032000000080064130',
        '300040028024758003008063005210800400045600007000005060500300014400009570800004000',
        '300400010900800000040102750080600037050003801003010000200769003000500004067384000',
        '300768400060004182005001070050103000400020008002000340000670000500300796000000000',
        '301700020257300009000290030023000608049603500100028000900000007030917000408062000',
        '302580000600007000105009602000092005000300200000005038031200970060000801290008054',
        '310906408850000020640020090080009000000003805003000619405000780798000004120807000',
        '350002800097000000001400030005760218000903740040020009160800500020307001009000000',
        '360090407920006038008370905000010382001000704050000009000203000016087000093500006',
        '364208005005607000007001000000000590050400080631080000800500016012000000906130400',
        '370280106009700020000000073068070000590430060700010490850090000930108507046000000',
        '375280096006590300200060008000743000000618903008050004097000001000000009610470030',
        '379001008001000000528000091860129005100803906000000100000300009000092000905600340',
        '380200050790063402004705800001420030000006790000000001000000180030000020640018005',
        '382000076000040000006000801200001607738004100100903000001005000000000010953210760',
        '390007801508360020040950607000000000800003910700040005000030700010000086000200040',
        '400003000000009873000520006000000060904600010607005004092104080000092035570006402',
        '400030000758400009100805002000007200940000700305000810509000461204500070860009300',
        '400207000107046900000900804000300190000090050005004063000100040006008302003020700',
        '400300106031007900070000800090501007000000690000903051620035008013006020840012060',
        '400810002010003074030050000970142350503007009020500487160200003380000000000001005',
        '401050007200000800008000402609000001000600973000007008590170080043028006780506130',
        '401500980270010050053004106002000041000941800000208790000800010000060239006103000',
        '430700200809000400127034000086010700940600000073400000300106870002340006000075100',
        '467000095085090003009004000073040201000206900021780540040070008006000010090600004',
        '470350009000008247809470500000000726000926850000700000708000105305810902000000070',
        '489000250000140900050200730200090840010060023000402600503000186070800090800030002',
        '490800600820040031003002400000026080009008000504300006630250014700009065000030800',
        '500004030124000080300820400750300801002000050000201704203400090000008072090100006',
        '500007004000643080040080009800300000001970000795000100002800000060050008070200036',
        '500009100301006040090008537200690000160030000980051000005000001420900700009080025',
        '500010007701408530040072089000800000850000603010605024400056000600007000080390076',
        '500037018001205006000080003009060000250914080010020050005002030107050062020071900',
        '500709300430610070290050800315000420004000001600000000000906000000048700900500000',
        '500890000000000030000450009070005600980160400205080000746000050002009300398007000',
        '500891607000430200800600090070200360040300028000060009053000810008512000010980040',
        '503070802760000100020000000005000680000530020100098070000089206206705038930020040',
        '504700000130060040000002735052000097900035804080070523000609000000047000800000002',
        '504700003810093200023061800701026009002300008380000501000030000049100050208000090',
        '506000000100860090748000006065020417904510000000000530000030680000104072070200005',
        '507000001000000830000002079902000005000060124003000098059048010674003080010000053',
        '508000906000500103030000000200709380700000200095803704807004000050000010469132070',
        '508340000400006000100800500900020000006130420300004001050000900030017052201500800',
        '509040078401600020700005600070000460180070500056412300042000800890000003005008700',
        '520000000000060900304500000900020470830040610000018009080009300400000000002006041',
        '524000830000003650000900041000004000000370000070206000060500080700809000019037005',
        '562730049000000200970210000000196405700400000000507600080600010049000006020050030',
        '580096034000070005400080200000000000000918050063000008712009000300107569690004000',
        '580192004420380000109070000900001053600000008210008000050900830000560009300010006',
        '581760090430005001006004200300600009050829034009000000260000010000200800045170002',
        '587069024016000000400000030600000510000000903900421000890015370030670490000030250',
        '600000079050010204020005000000204001190506420070890306700600905006000083005900042',
        '600014800000800700970063100000000017003102005080000602400001200006200000020407009',
        '600300418400856900309010650005760090100008700004930081006470030500000000000000005',
        '600372000050040300000000000842007630700003000001060802100000587020008400300459000',
        '600905030200067800097400020024050001000080950809010003000096002480300019030040700',
        '601003005974051000005060100130000002008205037050308600090070003500000000012934000',
        '603002400701080003048053006004000705100340280090007000037001000462030900000000834',
        '607000500140603020000940100200004000984057003000326408470030900508000000300401007',
        '630050001005692000900300000020100060401500000500006102184069007357008009000000008',
        '635000010017030040804000000963100200000042090040000871001053960000007400006429030',
        '640190350200000149000040026002006830006258017180903000500000400003084000060000070',
        '640920030200160790008400060500286309960300008003090046000000020009010000007045080',
        '650000309900820000000600704000306040476280000023004068000000852014000900830000000',
        '650803090230601405000007600080009000000752000040000060960080043800000001000004206',
        '670001009009008370153009480010083000320096005806000000430620000060000500000017043',
        '697005300300000870001703609002410003480090000060050000050800000930502086710040005',
        '700000000090003800040700261000208400000605010000000005070000024501070036000100050',
        '700000020015703600000290750602000040300000008000002006024017000100408030053900100',
        '700000130030005004008473000600004210002009000083001069801600502207950000059000000',
        '700003056010045730500072984007000523001030400000509070005000019072800300800000007',
        '700003090000002007090718204002000069184000000960051020436075000000800700008139005',
        '700006300002300080000000461000002506000005074000081000007000008601073020490060000',
        '700030095923050004040020800806003000100002083500106900000000056061200408007000100',
        '700400805900000060050807041107980000489075010325600790010000070200004000500760000',
        '700520400001708000060000100050000678000480210608005000000130894300040000149057002',
        '702080065860150370000020418090030700076001050050000089540070001000043000027008000',
        '702100604030004900000526008000009006100002070850071400000000000261008547540260010',
        '706050001008003000005021900000006250600000849000049600000800135430010782050002000',
        '709003000000008200200010590520800001400091060891000724080000000030740108005600000',
        '735000900400831000801000020500004000080307049943052100004508000200000030050020000',
        '740050089052800000098000000900060038034002600060407900080020701003600004416000090',
        '750016000030000000000204080085900013010000690900103000506040800800002074470890000',
        '786590014090002305005004006002001040537008000800070000253000800000200139000000400',
        '790802010004600020800130040000400200600000070200090060050014003000000100000008006',
        '800000050635007149000340600006000000024100703091076805000800000400960017900000080',
        '800000650300000080005007002108790400600050100052040060003000200000019000500003748',
        '800000670020870900300090008007100540456700280080400000000040003093610020102500060',
        '800000700060095000900401850501002074000007005070000100705203068390000002020160500',
        '800003000050001079006079003000200001900700060000010305032090506000002000087000040',
        '800003000065001000003502000600000870010070023709206015120390004407000090300004082',
        '800004305000000790001000000010805000090100000200600184700200041402006070000037026',
        '800009620030740001000620000006900003900103056073060040700090500000000000451000900',
        '800060240000140000092570061010006008000050100073901050028710000030005610100090700',
        '801000709400690001976000002002340500000062030000705090208051000010070084700004000',
        '806042003507060000040508000010000830000423507000680000250006000100090000008000600',
        '831029054200000000704000600000007009080905200006038100000100900040096038003802010',
        '845010000030080007070006002257094160009002004060005000428060390000000020516900700',
        '870602041000000009006000028009074002000905306081300407108400070007000804004030000',
        '873051004450002000000800000030200010000000320094600800100094008007530000346000907',
        '890420007700050000000018300000500009506001003910070400000006010070000002200030008',
        '900000200005403960103070084000004050710200008500907010607002000052000140001005009',
        '900000702230056009060007000000304076050200000071005200040000020090003640580000930',
        '900020006053004001120500749005006070097041000080000903700000008000072000009010260',
        '900030200320670009006000000600314950000000010000792800060800030085003420740020000',
        '900068500008002940070095008301000000045001700729054100000000000100000605206879304',
        '900286000050039816086001000020540000005000108000903705500802600010090007009004200',
        '900802105016579403008600079601007090057290008000000000000080700000005006800040050',
        '906002070071090200000067945060035810000004007200010000007040500152603400000000026',
        '906040520780020000500086000823069010600000800000400090000007605005000000000002709',
        '907000060620000501043069008070004000090057000400908070350000010060091052100006904',
        '913700008000040710000508000501004097890200003007001800000120000070405000600073280',
        '920000030060208000015030009006941005800003001000700940100307400000800503300604000',
        '927500010800004005506000009609002004013058600080000107000400506004025971008009000',
        '928000005700050004040000800006009000001270006000083100300002008007430000092105740',
        '950427600000000024824000000003805000000009100710600938070160000009000070030798406',
        '970401000600708045004500070860000000000002186400680059300174090000206700700000002',
      ],
    },
    'new': {
      'new': [
        // put new templates here
      ],
    },
  };
}
