import 'package:flutter/material.dart';

import 'package:flutter_custom_toolbox/flutter_toolbox.dart';

class ActivityButtonDeleteSaved extends StatelessWidget {
  const ActivityButtonDeleteSaved({
    super.key,
    required this.onPressed,
    this.onLongPress,
    this.color = Colors.grey,
  });

  final VoidCallback? onPressed;
  final VoidCallback? onLongPress;
  final Color color;

  @override
  Widget build(BuildContext context) {
    return StyledButton.icon(
      color: color,
      onPressed: onPressed,
      onLongPress: onLongPress,
      icon: const Icon(UniconsLine.trash_alt),
    );
  }
}
