import 'package:flutter/material.dart';

import 'package:flutter_custom_toolbox/flutter_toolbox.dart';

class ApplicationSettingsForm extends StatefulWidget {
  const ApplicationSettingsForm({super.key});

  @override
  State<ApplicationSettingsForm> createState() => _ApplicationSettingsFormState();
}

class _ApplicationSettingsFormState extends State<ApplicationSettingsForm> {
  @override
  void dispose() {
    super.dispose();
  }

  @override
  void didChangeDependencies() {
    super.didChangeDependencies();
  }

  @override
  Widget build(BuildContext context) {
    return Column(
      mainAxisAlignment: MainAxisAlignment.start,
      crossAxisAlignment: CrossAxisAlignment.start,
      mainAxisSize: MainAxisSize.max,
      children: <Widget>[
        // Light/dark theme
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: <Widget>[
            const Text('settings_label_theme').tr(),
            const Row(
              mainAxisAlignment: MainAxisAlignment.end,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                ApplicationSettingsThemeModeCard(
                  mode: ThemeMode.system,
                  icon: UniconsLine.cog,
                ),
                ApplicationSettingsThemeModeCard(
                  mode: ThemeMode.light,
                  icon: UniconsLine.sun,
                ),
                ApplicationSettingsThemeModeCard(
                  mode: ThemeMode.dark,
                  icon: UniconsLine.moon,
                )
              ],
            ),
          ],
        ),

        const SizedBox(height: 16),
      ],
    );
  }
}
