import 'package:flutter/material.dart';
import 'package:flutter_custom_toolbox/flutter_toolbox.dart';

class ScreenActivity extends StatelessWidget {
  const ScreenActivity({
    super.key,
    required this.appConfig,
  });

  final ApplicationConfigDefinition appConfig;

  ActivityPageItem getActivityPage(int pageIndex) {
    if (appConfig.navigation.activityPages.keys.contains(pageIndex)) {
      return appConfig.navigation.activityPages[pageIndex] ?? ActivityPageItem.empty();
    } else {
      return getActivityPage(appConfig.navigation.activityPages.keys.first);
    }
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<NavCubitPage, int>(
      builder: (BuildContext context, int pageIndex) {
        final ActivityPageItem page = getActivityPage(pageIndex);
        return page.builder(appConfig: appConfig);
      },
    );
  }
}
