import 'package:flutter_custom_toolbox/flutter_toolbox.dart';

class NavCubitPage extends HydratedCubit<int> {
  NavCubitPage({
    required this.appConfig,
  }) : super(0);

  final ApplicationConfigDefinition appConfig;

  void updateIndex(int index) {
    if (appConfig.navigation.isActivityPageIndexAllowed(index)) {
      emit(index);
    } else {
      emit(0);
    }
  }

  @override
  int fromJson(Map<String, dynamic> json) {
    return 0;
  }

  @override
  Map<String, dynamic>? toJson(int state) {
    return <String, int>{'index': state};
  }
}
