library;

export 'theme/theme.dart' show appTheme, darkTheme, lightTheme;

export 'utils/color_extensions.dart' show ColorExtension;
export 'utils/tools.dart' show printlog;

export 'widgets/headers.dart' show AppHeader;
export 'widgets/headers.dart' show AppTitle;
export 'widgets/outlined_text_widget.dart' show OutlinedText;
export 'widgets/show_debug.dart' show ShowDebugWidget;
export 'widgets/show_error.dart' show ShowErrorWidget;
export 'widgets/styled_button.dart' show StyledButton;
export 'widgets/styled_container.dart' show StyledContainer;

export 'widgets/activity/button_delete_saved_activity.dart'
    show ActivityButtonDeleteSaved;
export 'widgets/activity/button_quit_activity.dart' show ActivityButtonQuit;
export 'widgets/activity/button_resume_saved_activity.dart'
    show ActivityButtonResumeSaved;
export 'widgets/activity/button_start_new_activity.dart' show ActivityButtonStartNew;

export 'settings/application_settings_form.dart' show ApplicationSettingsForm;
export 'settings/application_settings_theme_card.dart'
    show ApplicationSettingsThemeModeCard;
export 'settings/application_theme_mode_cubit.dart'
    show ApplicationThemeModeCubit, ApplicationThemeModeState;

export 'parameters/application_config_definition.dart'
    show
        ApplicationConfigDefinition,
        ApplicationSettingsParameter,
        ApplicationSettingsParameterItemValue;
export 'parameters/pages/parameters.dart' show PageParameters;
export 'parameters/settings/settings_activity_cubit.dart'
    show ActivitySettingsCubit, ActivitySettingsState;
export 'parameters/models/settings/settings_activity.dart' show ActivitySettings;

export 'nav/application_navigation_definition.dart'
    show
        ScreenItem,
        ActivityPageItem,
        ApplicationNavigation,
        AppBarConfiguration,
        AppBarButton;
export 'nav/cubit/nav_cubit_screens.dart' show NavCubitScreen;
export 'nav/cubit/nav_cubit_pages.dart' show NavCubitPage;
export 'nav/ui/screens/about.dart' show ScreenAbout;
export 'nav/ui/screens/activity.dart' show ScreenActivity;
export 'nav/ui/screens/settings.dart' show ScreenSettings;
export 'nav/ui/bottom_nav_bar.dart' show BottomNavBar;
export 'nav/ui/global_app_bar.dart' show GlobalAppBar;

// dependencies

export 'package:easy_localization/easy_localization.dart'
    show
        DateFormat,
        EasyLocalization,
        BuildContextEasyLocalizationExtension,
        StringTranslateExtension,
        TextTranslateExtension,
        tr;

export 'package:equatable/equatable.dart' show Equatable;

export 'package:flutter_bloc/flutter_bloc.dart'
    show MultiBlocProvider, BlocBuilder, BlocConsumer, BlocListener, BlocProvider;

export 'package:hive/hive.dart' show Hive;

export 'package:hydrated_bloc/hydrated_bloc.dart'
    show BlocBase, HydratedBloc, HydratedCubit, HydratedStorage, HydratedStorageDirectory;

export 'package:package_info_plus/package_info_plus.dart' show PackageInfo;

export 'package:path_provider/path_provider.dart'
    show getApplicationDocumentsDirectory, getTemporaryDirectory;

export 'package:unicons/unicons.dart' show UniconsLine, UniconsSolid, UniconsThinline;
