// Code generated using SVG Painter package
// Generated in 2024-08-26T20:40:01.257608

import 'dart:math' as math;

import 'package:flutter/material.dart';

class UserExclamationIcon extends StatelessWidget {
  final Color? color;

  const UserExclamationIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: UserExclamationPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class UserExclamationPainter extends CustomPainter {
  final Color color;

  const UserExclamationPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 17.45;
    final scaleY = size.height / 16.99999987334013;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 17.45 * scale) / 2 - 3.3 * scale;
    final translationY = (size.height - 16.99999987334013 * scale) / 2 - 3.50000012665987 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      14.55 * scale + translationX,
      12.22 * scale + translationY,
    );

    path.cubicTo(
      15.629649428629815 * scale + translationX,
      11.285451604826534 * scale + translationY,
      16.25001584584799 * scale + translationX,
      9.92794391538441 * scale + translationY,
      16.250000242301358 * scale + translationX,
      8.50000012674225 * scale + translationY,
    );

    path.cubicTo(
      16.250000167638063 * scale + translationX,
      5.738576377505904 * scale + translationY,
      14.01142391679203 * scale + translationX,
      3.50000012665987 * scale + translationY,
      11.250000167638063 * scale + translationX,
      3.50000012665987 * scale + translationY,
    );

    path.cubicTo(
      8.488576418484097 * scale + translationX,
      3.50000012665987 * scale + translationY,
      6.250000167638063 * scale + translationX,
      5.738576377505902 * scale + translationY,
      6.250000167638063 * scale + translationX,
      8.500000126659868 * scale + translationY,
    );

    path.cubicTo(
      6.262492977894922 * scale + translationX,
      9.93596995921506 * scale + translationY,
      6.9017328588134355 * scale + translationX,
      11.29481130608184 * scale + translationY,
      8.000000119286822 * scale + translationX,
      12.220000182210624 * scale + translationY,
    );

    path.cubicTo(
      5.140940959363358 * scale + translationX,
      13.514637942751845 * scale + translationY,
      3.3030061001004225 * scale + translationX,
      16.361481724759116 * scale + translationY,
      3.3 * scale + translationX,
      19.5 * scale + translationY,
    );

    path.cubicTo(
      3.3 * scale + translationX,
      20.052284749830793 * scale + translationY,
      3.7477152501692066 * scale + translationX,
      20.5 * scale + translationY,
      4.3 * scale + translationX,
      20.5 * scale + translationY,
    );

    path.cubicTo(
      4.852284749830793 * scale + translationX,
      20.5 * scale + translationY,
      5.3 * scale + translationX,
      20.052284749830793 * scale + translationY,
      5.3 * scale + translationX,
      19.5 * scale + translationY,
    );

    path.cubicTo(
      5.300000336766244 * scale + translationX,
      16.186292082160527 * scale + translationY,
      7.986291837781482 * scale + translationX,
      13.500000581145287 * scale + translationY,
      11.300000336766242 * scale + translationX,
      13.500000581145287 * scale + translationY,
    );

    path.cubicTo(
      14.613708835751003 * scale + translationX,
      13.500000581145287 * scale + translationY,
      17.300000336766246 * scale + translationX,
      16.186292082160524 * scale + translationY,
      17.300000336766246 * scale + translationX,
      19.500000581145283 * scale + translationY,
    );

    path.cubicTo(
      17.3 * scale + translationX,
      20.052284749830793 * scale + translationY,
      17.747715250169207 * scale + translationX,
      20.5 * scale + translationY,
      18.3 * scale + translationX,
      20.5 * scale + translationY,
    );

    path.cubicTo(
      18.852284749830794 * scale + translationX,
      20.5 * scale + translationY,
      19.3 * scale + translationX,
      20.052284749830793 * scale + translationY,
      19.3 * scale + translationX,
      19.5 * scale + translationY,
    );

    path.cubicTo(
      19.28813889332934 * scale + translationX,
      16.34976331287993 * scale + translationY,
      17.428596811640766 * scale + translationX,
      13.49977039610249 * scale + translationY,
      14.550000000000002 * scale + translationX,
      12.219999999999999 * scale + translationY,
    );

    path.close();

    path.moveTo(
      11.25 * scale + translationX,
      11.5 * scale + translationY,
    );

    path.cubicTo(
      9.593146109060811 * scale + translationX,
      11.500000293348602 * scale + translationY,
      8.250000408223727 * scale + translationX,
      10.156854539139704 * scale + translationY,
      8.250000424683096 * scale + translationX,
      8.500000312924385 * scale + translationY,
    );

    path.cubicTo(
      8.250000441142465 * scale + translationX,
      6.843146086709067 * scale + translationY,
      9.593146168665454 * scale + translationX,
      5.500000359186077 * scale + translationY,
      11.250000394880772 * scale + translationX,
      5.500000342726709 * scale + translationY,
    );

    path.cubicTo(
      12.906854621096091 * scale + translationX,
      5.50000032626734 * scale + translationY,
      14.250000375304989 * scale + translationX,
      6.843146027104423 * scale + translationY,
      14.250000424683094 * scale + translationX,
      8.50000025331974 * scale + translationY,
    );

    path.cubicTo(
      14.250000474061201 * scale + translationX,
      10.156854572643306 * scale + translationY,
      12.906854654599693 * scale + translationX,
      11.500000392104814 * scale + translationY,
      11.250000335276127 * scale + translationX,
      11.500000342726707 * scale + translationY,
    );

    path.close();

    path.moveTo(
      19.75 * scale + translationX,
      6.5 * scale + translationY,
    );

    path.cubicTo(
      19.197715250169207 * scale + translationX,
      6.5 * scale + translationY,
      18.75 * scale + translationX,
      6.947715250169207 * scale + translationY,
      18.75 * scale + translationX,
      7.5 * scale + translationY,
    );

    path.lineTo(
      18.75 * scale + translationX,
      9.5 * scale + translationY,
    );

    path.cubicTo(
      18.75 * scale + translationX,
      10.052284749830793 * scale + translationY,
      19.197715250169207 * scale + translationX,
      10.5 * scale + translationY,
      19.75 * scale + translationX,
      10.5 * scale + translationY,
    );

    path.cubicTo(
      20.302284749830793 * scale + translationX,
      10.5 * scale + translationY,
      20.75 * scale + translationX,
      10.052284749830793 * scale + translationY,
      20.75 * scale + translationX,
      9.5 * scale + translationY,
    );

    path.lineTo(
      20.75 * scale + translationX,
      7.5 * scale + translationY,
    );

    path.cubicTo(
      20.75 * scale + translationX,
      6.947715250169207 * scale + translationY,
      20.302284749830793 * scale + translationX,
      6.5 * scale + translationY,
      19.75 * scale + translationX,
      6.5 * scale + translationY,
    );

    path.close();

    path.moveTo(
      19.0 * scale + translationX,
      11.79 * scale + translationY,
    );

    path.cubicTo(
      18.81726547491283 * scale + translationX,
      11.981633278520377 * scale + translationY,
      18.71368269501176 * scale + translationX,
      12.23523249827817 * scale + translationY,
      18.709999206081743 * scale + translationX,
      12.499999469589618 * scale + translationY,
    );

    path.cubicTo(
      18.708463241200363 * scale + translationX,
      12.76580298465003 * scale + translationY,
      18.812813485592095 * scale + translationX,
      13.021281169195307 * scale + translationY,
      19.0 * scale + translationX,
      13.21 * scale + translationY,
    );

    path.cubicTo(
      19.097199919466085 * scale + translationX,
      13.298330223509149 * scale + translationY,
      19.208814079110663 * scale + translationX,
      13.369357416010244 * scale + translationY,
      19.329998965562698 * scale + translationX,
      13.419999281834011 * scale + translationY,
    );

    path.cubicTo(
      19.57203969048739 * scale + translationX,
      13.526976654223992 * scale + translationY,
      19.847959927575175 * scale + translationX,
      13.526976654223992 * scale + translationY,
      20.089999805349493 * scale + translationX,
      13.419999869974625 * scale + translationY,
    );

    path.cubicTo(
      20.341230690927205 * scale + translationX,
      13.329076488944791 * scale + translationY,
      20.539076641744597 * scale + translationX,
      13.131230538127397 * scale + translationY,
      20.630000437206665 * scale + translationX,
      12.880000272962768 * scale + translationY,
    );

    path.cubicTo(
      20.685980510387164 * scale + translationX,
      12.761320096886973 * scale + translationY,
      20.713379263843482 * scale + translationX,
      12.631176017969448 * scale + translationY,
      20.709999155897187 * scale + translationX,
      12.499999490522208 * scale + translationY,
    );

    path.cubicTo(
      20.712362623049145 * scale + translationX,
      12.0937349276472 * scale + translationY,
      20.46869622354266 * scale + translationX,
      11.726419956048321 * scale + translationY,
      20.09348150564424 * scale + translationX,
      11.570629049786403 * scale + translationY,
    );

    path.cubicTo(
      19.718266787745822 * scale + translationX,
      11.414838143524486 * scale + translationY,
      19.286090455897597 * scale + translationX,
      11.501540051227547 * scale + translationY,
      19.0 * scale + translationX,
      11.79 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}