// Code generated using SVG Painter package
// Generated in 2024-08-26T20:40:01.179880

import 'dart:math' as math;

import 'package:flutter/material.dart';

class TwitterAltIcon extends StatelessWidget {
  final Color? color;

  const TwitterAltIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: TwitterAltPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class TwitterAltPainter extends CustomPainter {
  final Color color;

  const TwitterAltPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 22.174288212318125;
    final scaleY = size.height / 18.789411375266365;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 22.174288212318125 * scale) / 2 - 0.8917170964359966 * scale;
    final translationY = (size.height - 18.789411375266365 * scale) / 2 - 2.6371234564405186 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      22.99121 * scale + translationX,
      3.9502 * scale + translationY,
    );

    path.cubicTo(
      22.991448249942497 * scale + translationX,
      3.5906174086503184 * scale + translationY,
      22.798501055142033 * scale + translationX,
      3.2586255625423015 * scale + translationY,
      22.48594902222533 * scale + translationX,
      3.080831259056621 * scale + translationY,
    );

    path.cubicTo(
      22.173396989308625 * scale + translationX,
      2.9030369555709394 * scale + translationY,
      21.789427386308375 * scale + translationX,
      2.9068513802206155 * scale + translationY,
      21.48046917161685 * scale + translationX,
      3.0908198808041356 * scale + translationY,
    );

    path.cubicTo(
      20.895157251800875 * scale + translationX,
      3.4392052879326034 * scale + translationY,
      20.264998872787736 * scale + translationX,
      3.7060048579045306 * scale + translationY,
      19.607469636466224 * scale + translationX,
      3.883819927991742 * scale + translationY,
    );

    path.cubicTo(
      18.668445679102636 * scale + translationX,
      3.0780521659125557 * scale + translationY,
      17.47080806669338 * scale + translationX,
      2.6371234564405186 * scale + translationY,
      16.233469477787377 * scale + translationX,
      2.64162991502171 * scale + translationY,
    );

    path.cubicTo(
      13.411795540858925 * scale + translationX,
      2.644878195023547 * scale + translationY,
      11.100920847156434 * scale + translationX,
      4.884904344285399 * scale + translationY,
      11.009839639246303 * scale + translationX,
      7.705109747530672 * scale + translationY,
    );

    path.cubicTo(
      8.33382049598184 * scale + translationX,
      7.278371436027576 * scale + translationY,
      5.908472181235521 * scale + translationX,
      5.881635925419964 * scale + translationY,
      4.19629011698931 * scale + translationX,
      3.781250105418318 * scale + translationY,
    );

    path.cubicTo(
      3.9869344846805785 * scale + translationX,
      3.5272469325338114 * scale + translationY,
      3.6670808733429032 * scale + translationX,
      3.3909933677218342 * scale + translationY,
      3.3388702454656527 * scale + translationX,
      3.416000251136064 * scale + translationY,
    );

    path.cubicTo(
      3.010720705446692 * scale + translationX,
      3.443020597239418 * scale + translationY,
      2.716985640585692 * scale + translationX,
      3.6300748695285057 * scale + translationY,
      2.5537101820124053 * scale + translationX,
      3.916000279107878 * scale + translationY,
    );

    path.cubicTo(
      1.7171258845345312 * scale + translationX,
      5.37593433826982 * scale + translationY,
      1.6271564962983083 * scale + translationX,
      7.147368031955918 * scale + translationY,
      2.311519965427129 * scale + translationX,
      8.684549870107194 * scale + translationY,
    );

    path.lineTo(
      2.3095700000000003 * scale + translationX,
      8.6865 * scale + translationY,
    );

    path.cubicTo(
      2.00118572354951 * scale + translationX,
      8.8764382592259 * scale + translationY,
      1.8136750664882422 * scale + translationX,
      9.212997014107964 * scale + translationY,
      1.8144500593876454 * scale + translationX,
      9.575180313399317 * scale + translationY,
    );

    path.cubicTo(
      1.8126139975639581 * scale + translationX,
      9.722107689490427 * scale + translationY,
      1.821427074014289 * scale + translationX,
      9.868975586574155 * scale + translationY,
      1.84081994381917 * scale + translationX,
      10.014629694358913 * scale + translationY,
    );

    path.cubicTo(
      1.9429572628599268 * scale + translationX,
      11.272896503299972 * scale + translationY,
      2.5006025319208156 * scale + translationX,
      12.450687287153293 * scale + translationY,
      3.4091801094088705 * scale + translationX,
      13.32713042769999 * scale + translationY,
    );

    path.cubicTo(
      3.2846702149410683 * scale + translationX,
      13.564333958678759 * scale + translationY,
      3.260739544144987 * scale + translationX,
      13.841632092961378 * scale + translationY,
      3.3427700444112287 * scale + translationX,
      14.096660187284794 * scale + translationY,
    );

    path.cubicTo(
      3.7388844821010254 * scale + translationX,
      15.330804000006298 * scale + translationY,
      4.581268587722294 * scale + translationX,
      16.372723496893503 * scale + translationY,
      5.705079997304209 * scale + translationX,
      17.018529991958317 * scale + translationY,
    );

    path.cubicTo(
      4.563320351703038 * scale + translationX,
      17.460041570251867 * scale + translationY,
      3.3304994113762163 * scale + translationX,
      17.613978917634487 * scale + translationY,
      2.1152299240127115 * scale + translationX,
      17.466779372525327 * scale + translationY,
    );

    path.cubicTo(
      1.651976883390749 * scale + translationX,
      17.408652166074294 * scale + translationY,
      1.210173443875337 * scale + translationX,
      17.678899354500096 * scale + translationY,
      1.050945270155667 * scale + translationX,
      18.117794455895815 * scale + translationY,
    );

    path.cubicTo(
      0.8917170964359966 * scale + translationX,
      18.556689557291538 * scale + translationY,
      1.057467274457731 * scale + translationX,
      19.047353088140795 * scale + translationY,
      1.450230082211434 * scale + translationX,
      19.29978109407653 * scale + translationY,
    );

    path.cubicTo(
      3.540324651124588 * scale + translationX,
      20.64594626189643 * scale + translationY,
      5.9739063719017755 * scale + translationX,
      21.36165453712774 * scale + translationY,
      8.459999798999101 * scale + translationX,
      21.361329492476763 * scale + translationY,
    );

    path.cubicTo(
      14.257030256143384 * scale + translationX,
      21.426534831706885 * scale + translationY,
      19.372670705818557 * scale + translationX,
      17.58375920019599 * scale + translationY,
      20.924800179217257 * scale + translationX,
      11.998000102760773 * scale + translationY,
    );

    path.cubicTo(
      21.277871627305764 * scale + translationX,
      10.814636120770375 * scale + translationY,
      21.45813341923923 * scale + translationX,
      9.586471306536712 * scale + translationY,
      21.459999858341043 * scale + translationX,
      8.351559944870768 * scale + translationY,
    );

    path.cubicTo(
      21.46 * scale + translationX,
      8.28613 * scale + translationY,
      21.46 * scale + translationX,
      8.21875 * scale + translationY,
      21.459 * scale + translationX,
      8.15137 * scale + translationY,
    );

    path.cubicTo(
      22.51373450626749 * scale + translationX,
      7.013896903697739 * scale + translationY,
      23.06600530875412 * scale + translationX,
      5.499624364500906 * scale + translationY,
      22.99120942537122 * scale + translationX,
      3.950199901271025 * scale + translationY,
    );

    path.close();

    path.moveTo(
      19.68457 * scale + translationX,
      7.16211 * scale + translationY,
    );

    path.cubicTo(
      19.51940260167487 * scale + translationX,
      7.357454715665087 * scale + translationY,
      19.435817260893362 * scale + translationX,
      7.6089090731189595 * scale + translationY,
      19.451170533780925 * scale + translationX,
      7.864260215811796 * scale + translationY,
    );

    path.cubicTo(
      19.46094 * scale + translationX,
      8.02926 * scale + translationY,
      19.459960000000002 * scale + translationX,
      8.19526 * scale + translationY,
      19.459960000000002 * scale + translationX,
      8.35156 * scale + translationY,
    );

    path.cubicTo(
      19.457912057783894 * scale + translationX,
      9.395100889927404 * scale + translationY,
      19.304962495359142 * scale + translationX,
      10.432860808016827 * scale + translationY,
      19.005860684248024 * scale + translationX,
      11.432620411596613 * scale + translationY,
    );

    path.cubicTo(
      17.737085767859337 * scale + translationX,
      16.189538058450555 * scale + translationY,
      13.382151572430637 * scale + translationX,
      19.46371487329899 * scale + translationY,
      8.46000041093852 * scale + translationX,
      19.361330940462917 * scale + translationY,
    );

    path.cubicTo(
      7.600878162350051 * scale + translationX,
      19.361593773739827 * scale + translationY,
      6.744716901856365 * scale + translationX,
      19.260637915558686 * scale + translationY,
      5.909219971487191 * scale + translationX,
      19.06054990803019 * scale + translationY,
    );

    path.cubicTo(
      6.974631207679386 * scale + translationX,
      18.71720090460649 * scale + translationY,
      7.970809862772977 * scale + translationX,
      18.187865671337597 * scale + translationY,
      8.851600275559994 * scale + translationX,
      17.497070544702936 * scale + translationY,
    );

    path.cubicTo(
      9.184017223882693 * scale + translationX,
      17.235336103910498 * scale + translationY,
      9.315824204121279 * scale + translationX,
      16.792775475151565 * scale + translationY,
      9.180774519677051 * scale + translationX,
      16.39181754151398 * scale + translationY,
    );

    path.cubicTo(
      9.045724835232821 * scale + translationX,
      15.990859607876398 * scale + translationY,
      8.673027489436636 * scale + translationX,
      15.718224909784611 * scale + translationY,
      8.24999959363177 * scale + translationX,
      15.710939226130076 * scale + translationY,
    );

    path.cubicTo(
      7.418830494537041 * scale + translationX,
      15.69801587890152 * scale + translationY,
      6.6251297606820945 * scale + translationX,
      15.362960570848736 * scale + translationY,
      6.036129911753971 * scale + translationX,
      14.776369783974834 * scale + translationY,
    );

    path.cubicTo(
      6.185549999999999 * scale + translationX,
      14.748050000000001 * scale + translationY,
      6.33399 * scale + translationX,
      14.712893333333334 * scale + translationY,
      6.48145 * scale + translationX,
      14.6709 * scale + translationY,
    );

    path.cubicTo(
      6.926079636320995 * scale + translationX,
      14.544339378522809 * scale + translationY,
      7.226056137672543 * scale + translationX,
      14.129570476299625 * scale + translationY,
      7.207022666816074 * scale + translationX,
      13.667671301429117 * scale + translationY,
    );

    path.cubicTo(
      7.187989195959602 * scale + translationX,
      13.205772126558607 * scale + translationY,
      6.8549048924217555 * scale + translationX,
      12.817089749351654 * scale + translationY,
      6.401369948933085 * scale + translationX,
      12.727539898466079 * scale + translationY,
    );

    path.cubicTo(
      5.423438244270933 * scale + translationX,
      12.534410683175894 * scale + translationY,
      4.591473962860467 * scale + translationX,
      11.89635324123852 * scale + translationY,
      4.1513699189681414 * scale + translationX,
      11.001949785249579 * scale + translationY,
    );

    path.cubicTo(
      4.3320990487615605 * scale + translationX,
      11.026618174035141 * scale + translationY,
      4.513981154324301 * scale + translationX,
      11.041938567203548 * scale + translationY,
      4.69629005755357 * scale + translationX,
      11.047850135392663 * scale + translationY,
    );

    path.cubicTo(
      5.140709932701984 * scale + translationX,
      11.054564602197841 * scale + translationY,
      5.538406395558879 * scale + translationX,
      10.77297819776157 * scale + translationY,
      5.679690389499864 * scale + translationX,
      10.351560709885788 * scale + translationY,
    );

    path.cubicTo(
      5.815256067962097 * scale + translationX,
      9.925753078600303 * scale + translationY,
      5.651798056342129 * scale + translationX,
      9.461690562132231 * scale + translationY,
      5.279300103491656 * scale + translationX,
      9.214840180641193 * scale + translationY,
    );

    path.cubicTo(
      4.385849048247005 * scale + translationX,
      8.61962472960336 * scale + translationY,
      3.8509772339205166 * scale + translationX,
      7.615553470952812 * scale + translationY,
      3.85547015892874 * scale + translationX,
      6.542000269671871 * scale + translationY,
    );

    path.cubicTo(
      3.85547 * scale + translationX,
      6.4756 * scale + translationY,
      3.85742 * scale + translationX,
      6.40919 * scale + translationY,
      3.86133 * scale + translationX,
      6.34376 * scale + translationY,
    );

    path.cubicTo(
      6.102591278543341 * scale + translationX,
      8.43401410919202 * scale + translationY,
      9.00965087467846 * scale + translationX,
      9.66620862669186 * scale + translationY,
      12.07032956620849 * scale + translationX,
      9.823249646965541 * scale + translationY,
    );

    path.cubicTo(
      12.383362343469484 * scale + translationX,
      9.83558349646059 * scale + translationY,
      12.684713931079846 * scale + translationX,
      9.703450232046352 * scale + translationY,
      12.887719740343245 * scale + translationX,
      9.464849809305896 * scale + translationY,
    );

    path.cubicTo(
      13.088788865819188 * scale + translationX,
      9.223809516593782 * scale + translationY,
      13.1650612849574 * scale + translationX,
      8.902369403006263 * scale + translationY,
      13.093720549427283 * scale + translationX,
      8.596690360726823 * scale + translationY,
    );

    path.cubicTo(
      13.036529808951775 * scale + translationX,
      8.358053452917693 * scale + translationY,
      13.00736283724477 * scale + translationX,
      8.113562344552875 * scale + translationY,
      13.006809435672924 * scale + translationX,
      7.86816965862334 * scale + translationY,
    );

    path.cubicTo(
      13.008700543954257 * scale + translationX,
      6.0869604657352525 * scale + translationY,
      14.452190471039199 * scale + translationX,
      4.643479486114521 * scale + translationY,
      16.233400032966824 * scale + translationX,
      4.641600009426171 * scale + translationY,
    );

    path.cubicTo(
      17.123231132873826 * scale + translationX,
      4.6392166236550185 * scale + translationY,
      17.973466703907427 * scale + translationX,
      5.009271002256941 * scale + translationY,
      18.578120240442704 * scale + translationX,
      5.662110073280454 * scale + translationY,
    );

    path.cubicTo(
      18.81263534385517 * scale + translationX,
      5.9144055530421245 * scale + translationY,
      19.16114882491298 * scale + translationX,
      6.027144108415584 * scale + translationY,
      19.498998977887513 * scale + translationX,
      5.95999968758447 * scale + translationY,
    );

    path.cubicTo(
      19.90978360866158 * scale + translationX,
      5.880056720467018 * scale + translationY,
      20.314683016784198 * scale + translationX,
      5.7723904691784895 * scale + translationY,
      20.71091972721065 * scale + translationX,
      5.637739925743743 * scale + translationY,
    );

    path.cubicTo(
      20.440651267990912 * scale + translationX,
      6.190712548355157 * scale + translationY,
      20.095268343095185 * scale + translationX,
      6.703687039730712 * scale + translationY,
      19.68457123385965 * scale + translationX,
      7.162110448932262 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}