// Code generated using SVG Painter package
// Generated in 2024-08-26T20:40:00.901322

import 'dart:math' as math;

import 'package:flutter/material.dart';

class TelegramAltIcon extends StatelessWidget {
  final Color? color;

  const TelegramAltIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: TelegramAltPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class TelegramAltPainter extends CustomPainter {
  final Color color;

  const TelegramAltPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 22.13114303989424;
    final scaleY = size.height / 20.227277708499265;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 22.13114303989424 * scale) / 2 - 0.9775133020312116 * scale;
    final translationY = (size.height - 20.227277708499265 * scale) / 2 - 1.8205529639875324 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      22.26465 * scale + translationX,
      2.42773 * scale + translationY,
    );

    path.cubicTo(
      21.684539534872503 * scale + translationX,
      1.9451230560571713 * scale + translationY,
      20.886066799815968 * scale + translationX,
      1.8205529639875324 * scale + translationY,
      20.186519435099836 * scale + translationX,
      2.103519941135035 * scale + translationY,
    );

    path.lineTo(
      2.26562 * scale + translationX,
      9.33887 * scale + translationY,
    );

    path.cubicTo(
      1.480959388199219 * scale + translationX,
      9.661707648364597 * scale + translationY,
      0.9775133020312116 * scale + translationX,
      10.435935967173691 * scale + translationY,
      1.000725586234718 * scale + translationX,
      11.2840972830713 * scale + translationY,
    );

    path.cubicTo(
      1.0239378704382245 * scale + translationX,
      12.132258598968914 * scale + translationY,
      1.5689764527990355 * scale + translationX,
      12.877792230042628 * scale + translationY,
      2.3701199952011707 * scale + translationX,
      13.157229973360291 * scale + translationY,
    );

    path.lineTo(
      5.99512 * scale + translationX,
      14.41797 * scale + translationY,
    );

    path.lineTo(
      8.01562 * scale + translationX,
      21.09961 * scale + translationY,
    );

    path.cubicTo(
      8.043078065447201 * scale + translationX,
      21.18886499352402 * scale + translationY,
      8.082926732228346 * scale + translationX,
      21.273823643708955 * scale + translationY,
      8.134000366946813 * scale + translationX,
      21.35200096324666 * scale + translationY,
    );

    path.cubicTo(
      8.14175 * scale + translationX,
      21.364 * scale + translationY,
      8.15268 * scale + translationX,
      21.37293 * scale + translationY,
      8.16092 * scale + translationX,
      21.38459 * scale + translationY,
    );

    path.cubicTo(
      8.219924863551595 * scale + translationX,
      21.46691668885173 * scale + translationY,
      8.291234106939262 * scale + translationX,
      21.53968631640375 * scale + translationY,
      8.372349393577737 * scale + translationX,
      21.60034843545323 * scale + translationY,
    );

    path.cubicTo(
      8.395420000000001 * scale + translationX,
      21.617929999999998 * scale + translationY,
      8.41751 * scale + translationX,
      21.63441 * scale + translationY,
      8.44217 * scale + translationX,
      21.650029999999997 * scale + translationY,
    );

    path.cubicTo(
      8.53710442568872 * scale + translationX,
      21.71301161822057 * scale + translationY,
      8.642236998879305 * scale + translationX,
      21.75906315665256 * scale + translationY,
      8.752899734549297 * scale + translationX,
      21.786139339287985 * scale + translationY,
    );

    path.lineTo(
      8.76474 * scale + translationX,
      21.787139999999997 * scale + translationY,
    );

    path.lineTo(
      8.77145 * scale + translationX,
      21.79001 * scale + translationY,
    );

    path.cubicTo(
      8.837984391710087 * scale + translationX,
      21.803545371542032 * scale + translationY,
      8.905702423118464 * scale + translationX,
      21.81041599644525 * scale + translationY,
      8.973599818732211 * scale + translationX,
      21.810519559424904 * scale + translationY,
    );

    path.cubicTo(
      8.980129999999999 * scale + translationX,
      21.81052 * scale + translationY,
      8.98593 * scale + translationX,
      21.8074 * scale + translationY,
      8.9924 * scale + translationX,
      21.80728 * scale + translationY,
    );

    path.cubicTo(
      9.09486186700421 * scale + translationX,
      21.805490959414502 * scale + translationY,
      9.196428794471085 * scale + translationX,
      21.787845185805978 * scale + translationY,
      9.293489910453903 * scale + translationX,
      21.75496979038309 * scale + translationY,
    );

    path.cubicTo(
      9.31607 * scale + translationX,
      21.74728 * scale + translationY,
      9.335420000000001 * scale + translationX,
      21.73441 * scale + translationY,
      9.357330000000001 * scale + translationX,
      21.72513 * scale + translationY,
    );

    path.cubicTo(
      9.429707504503 * scale + translationX,
      21.695136174514825 * scale + translationY,
      9.498280965497958 * scale + translationX,
      21.656682135200214 * scale + translationY,
      9.5616203871695 * scale + translationX,
      21.610570875056062 * scale + translationY,
    );

    path.cubicTo(
      9.612343485379135 * scale + translationX,
      21.56782419132884 * scale + translationY,
      9.663083491701775 * scale + translationX,
      21.52509751933806 * scale + translationY,
      9.713840445722424 * scale + translationX,
      21.48239098572572 * scale + translationY,
    );

    path.lineTo(
      12.416 * scale + translationX,
      18.499 * scale + translationY,
    );

    path.lineTo(
      16.44627 * scale + translationX,
      21.62107 * scale + translationY,
    );

    path.cubicTo(
      16.80108720019403 * scale + translationX,
      21.8973023140683 * scale + translationY,
      17.237815464419295 * scale + translationX,
      22.04746075143246 * scale + translationY,
      17.687480539490586 * scale + translationX,
      22.047830672486796 * scale + translationY,
    );

    path.cubicTo(
      18.65858218492933 * scale + translationX,
      22.046586012029906 * scale + translationY,
      19.496138917844956 * scale + translationX,
      21.36545874517632 * scale + translationY,
      19.695310323710245 * scale + translationX,
      20.415000335539002 * scale + translationY,
    );

    path.lineTo(
      22.958 * scale + translationX,
      4.39844 * scale + translationY,
    );

    path.cubicTo(
      23.108656341925453 * scale + translationX,
      3.66389375884053 * scale + translationY,
      22.84205253905417 * scale + translationX,
      2.9061252719919377 * scale + translationY,
      22.264650173257 * scale + translationX,
      2.4277300188918858 * scale + translationY,
    );

    path.close();

    path.moveTo(
      9.37012 * scale + translationX,
      14.73633 * scale + translationY,
    );

    path.cubicTo(
      9.231463101447465 * scale + translationX,
      14.874437859857153 * scale + translationY,
      9.136679134521394 * scale + translationX,
      15.050417517455418 * scale + translationY,
      9.097660466101207 * scale + translationX,
      15.24219078090445 * scale + translationY,
    );

    path.lineTo(
      8.78815 * scale + translationX,
      16.746190000000002 * scale + translationY,
    );

    path.lineTo(
      8.00409 * scale + translationX,
      14.153120000000001 * scale + translationY,
    );

    path.lineTo(
      12.06934 * scale + translationX,
      12.036170000000002 * scale + translationY,
    );

    path.close();

    path.moveTo(
      17.67188 * scale + translationX,
      20.04 * scale + translationY,
    );

    path.lineTo(
      12.909180000000001 * scale + translationX,
      16.35055 * scale + translationY,
    );

    path.cubicTo(
      12.495963149487174 * scale + translationX,
      16.031253053359336 * scale + translationY,
      11.9067457323172 * scale + translationX,
      16.083117350216146 * scale + translationY,
      11.555660630191046 * scale + translationX,
      16.469690898179 * scale + translationY,
    );

    path.lineTo(
      10.69025 * scale + translationX,
      17.42489 * scale + translationY,
    );

    path.lineTo(
      10.99609 * scale + translationX,
      15.938440000000002 * scale + translationY,
    );

    path.lineTo(
      18.07909 * scale + translationX,
      8.855440000000002 * scale + translationY,
    );

    path.cubicTo(
      18.428446906206577 * scale + translationX,
      8.506554181181492 * scale + translationY,
      18.470800119317765 * scale + translationX,
      7.954882154748645 * scale + translationY,
      18.17879414589081 * scale + translationX,
      7.556756912949056 * scale + translationY,
    );

    path.cubicTo(
      17.886788172463852 * scale + translationX,
      7.158631671149468 * scale + translationY,
      17.347877106022526 * scale + translationX,
      7.033289412208455 * scale + translationY,
      16.91015095861187 * scale + translationX,
      7.26169041165467 * scale + translationY,
    );

    path.lineTo(
      6.744870000000001 * scale + translationX,
      12.55432 * scale + translationY,
    );

    path.lineTo(
      3.02051 * scale + translationX,
      11.19141 * scale + translationY,
    );

    path.lineTo(
      20.999 * scale + translationX,
      3.999 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}