// Code generated using SVG Painter package
// Generated in 2024-08-26T20:39:58.537539

import 'dart:math' as math;

import 'package:flutter/material.dart';

class HistoryAltIcon extends StatelessWidget {
  final Color? color;

  const HistoryAltIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: HistoryAltPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class HistoryAltPainter extends CustomPainter {
  final Color color;

  const HistoryAltPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 18.88000017046928;
    final scaleY = size.height / 20.000000178813934;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 18.88000017046928 * scale) / 2 - 2.5600000000000005 * scale;
    final translationY = (size.height - 20.000000178813934 * scale) / 2 - 2.0 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      11.44 * scale + translationX,
      2.0 * scale + translationY,
    );

    path.cubicTo(
      8.876385783308466 * scale + translationX,
      2.0073122074235004 * scale + translationY,
      6.413490370669944 * scale + translationX,
      2.9989139941980216 * scale + translationY,
      4.560000067949296 * scale + translationX,
      4.770000071078538 * scale + translationY,
    );

    path.lineTo(
      4.5600000000000005 * scale + translationX,
      3.0 * scale + translationY,
    );

    path.cubicTo(
      4.5600000000000005 * scale + translationX,
      2.4477152501692068 * scale + translationY,
      4.112284749830794 * scale + translationX,
      2.0 * scale + translationY,
      3.5600000000000005 * scale + translationX,
      2.0 * scale + translationY,
    );

    path.cubicTo(
      3.0077152501692073 * scale + translationX,
      2.0 * scale + translationY,
      2.5600000000000005 * scale + translationX,
      2.4477152501692068 * scale + translationY,
      2.5600000000000005 * scale + translationX,
      3.0 * scale + translationY,
    );

    path.lineTo(
      2.5600000000000005 * scale + translationX,
      7.5 * scale + translationY,
    );

    path.cubicTo(
      2.5600000000000005 * scale + translationX,
      8.052284749830793 * scale + translationY,
      3.0077152501692073 * scale + translationX,
      8.5 * scale + translationY,
      3.5600000000000005 * scale + translationX,
      8.5 * scale + translationY,
    );

    path.lineTo(
      8.06 * scale + translationX,
      8.5 * scale + translationY,
    );

    path.cubicTo(
      8.612284749830794 * scale + translationX,
      8.5 * scale + translationY,
      9.06 * scale + translationX,
      8.052284749830793 * scale + translationY,
      9.06 * scale + translationX,
      7.5 * scale + translationY,
    );

    path.cubicTo(
      9.06 * scale + translationX,
      6.947715250169207 * scale + translationY,
      8.612284749830794 * scale + translationX,
      6.5 * scale + translationY,
      8.06 * scale + translationX,
      6.5 * scale + translationY,
    );

    path.lineTo(
      5.66 * scale + translationX,
      6.5 * scale + translationY,
    );

    path.cubicTo(
      8.170519714461959 * scale + translationX,
      3.848267368773868 * scale + translationY,
      12.158034905463072 * scale + translationX,
      3.2330586203902643 * scale + translationY,
      15.351029619498247 * scale + translationX,
      5.004831726731779 * scale + translationY,
    );

    path.cubicTo(
      18.54402433353342 * scale + translationX,
      6.776604833073294 * scale + translationY,
      20.132041886579103 * scale + translationX,
      10.485642370463715 * scale + translationY,
      19.210456958503585 * scale + translationX,
      14.019065130982993 * scale + translationY,
    );

    path.cubicTo(
      18.288872030428067 * scale + translationX,
      17.552487891502274 * scale + translationY,
      15.091604414950734 * scale + translationX,
      20.013430596559072 * scale + translationY,
      11.439999999999996 * scale + translationX,
      20.0 * scale + translationY,
    );

    path.cubicTo(
      10.887715250169206 * scale + translationX,
      20.0 * scale + translationY,
      10.44 * scale + translationX,
      20.447715250169207 * scale + translationY,
      10.44 * scale + translationX,
      21.0 * scale + translationY,
    );

    path.cubicTo(
      10.44 * scale + translationX,
      21.552284749830793 * scale + translationY,
      10.887715250169206 * scale + translationX,
      22.0 * scale + translationY,
      11.44 * scale + translationX,
      22.0 * scale + translationY,
    );

    path.cubicTo(
      16.96284766877722 * scale + translationX,
      22.000000178813934 * scale + translationY,
      21.440000170469283 * scale + translationX,
      17.522847677121867 * scale + translationY,
      21.440000170469283 * scale + translationX,
      12.000000178813934 * scale + translationY,
    );

    path.cubicTo(
      21.440000170469283 * scale + translationX,
      6.477152680506001 * scale + translationY,
      16.962847668777215 * scale + translationX,
      2.0000001788139348 * scale + translationY,
      11.440000170469284 * scale + translationX,
      2.0000001788139343 * scale + translationY,
    );

    path.close();

    path.moveTo(
      11.44 * scale + translationX,
      8.0 * scale + translationY,
    );

    path.cubicTo(
      10.887715250169206 * scale + translationX,
      8.0 * scale + translationY,
      10.44 * scale + translationX,
      8.447715250169207 * scale + translationY,
      10.44 * scale + translationX,
      9.0 * scale + translationY,
    );

    path.lineTo(
      10.44 * scale + translationX,
      12.0 * scale + translationY,
    );

    path.cubicTo(
      10.44 * scale + translationX,
      12.552284749830793 * scale + translationY,
      10.887715250169206 * scale + translationX,
      13.0 * scale + translationY,
      11.44 * scale + translationX,
      13.0 * scale + translationY,
    );

    path.lineTo(
      13.44 * scale + translationX,
      13.0 * scale + translationY,
    );

    path.cubicTo(
      13.992284749830793 * scale + translationX,
      13.0 * scale + translationY,
      14.44 * scale + translationX,
      12.552284749830793 * scale + translationY,
      14.44 * scale + translationX,
      12.0 * scale + translationY,
    );

    path.cubicTo(
      14.44 * scale + translationX,
      11.447715250169207 * scale + translationY,
      13.992284749830793 * scale + translationX,
      11.0 * scale + translationY,
      13.44 * scale + translationX,
      11.0 * scale + translationY,
    );

    path.lineTo(
      12.44 * scale + translationX,
      11.0 * scale + translationY,
    );

    path.lineTo(
      12.44 * scale + translationX,
      9.0 * scale + translationY,
    );

    path.cubicTo(
      12.44 * scale + translationX,
      8.447715250169207 * scale + translationY,
      11.992284749830793 * scale + translationX,
      8.0 * scale + translationY,
      11.44 * scale + translationX,
      8.0 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}