// Code generated using SVG Painter package
// Generated in 2024-08-26T20:39:58.381723

import 'dart:math' as math;

import 'package:flutter/material.dart';

class GoogleDriveAltIcon extends StatelessWidget {
  final Color? color;

  const GoogleDriveAltIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: GoogleDriveAltPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class GoogleDriveAltPainter extends CustomPainter {
  final Color color;

  const GoogleDriveAltPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 20.04318868467509;
    final scaleY = size.height / 17.413578089793678;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 20.04318868467509 * scale) / 2 - 1.9613672050459185 * scale;
    final translationY = (size.height - 17.413578089793678 * scale) / 2 - 3.256184189402217 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      22.0 * scale + translationX,
      14.44 * scale + translationY,
    );

    path.cubicTo(
      22.004555889721008 * scale + translationX,
      14.396786610106199 * scale + translationY,
      22.004555889721008 * scale + translationX,
      14.35321381664383 * scale + translationY,
      22.000000326556545 * scale + translationX,
      14.310000212410188 * scale + translationY,
    );

    path.cubicTo(
      21.996055897872242 * scale + translationX,
      14.270097145417603 * scale + translationY,
      21.996055897872242 * scale + translationX,
      14.229902707544557 * scale + translationY,
      21.999999886497108 * scale + translationX,
      14.189999926790634 * scale + translationY,
    );

    path.lineTo(
      21.95 * scale + translationX,
      14.07 * scale + translationY,
    );

    path.lineTo(
      21.95 * scale + translationX,
      14.07 * scale + translationY,
    );

    path.lineTo(
      15.95 * scale + translationX,
      3.780000000000001 * scale + translationY,
    );

    path.cubicTo(
      15.754520419247187 * scale + translationX,
      3.4469241623340965 * scale + translationY,
      15.384718430909873 * scale + translationX,
      3.256184189402217 * scale + translationY,
      15.0 * scale + translationX,
      3.29 * scale + translationY,
    );

    path.lineTo(
      9.0 * scale + translationX,
      3.29 * scale + translationY,
    );

    path.cubicTo(
      8.824823618386143 * scale + translationX,
      3.288790167933068 * scale + translationY,
      8.652402908900296 * scale + translationX,
      3.3336195523993877 * scale + translationY,
      8.5 * scale + translationX,
      3.4199999999999995 * scale + translationY,
    );

    path.lineTo(
      8.39 * scale + translationX,
      3.5 * scale + translationY,
    );

    path.cubicTo(
      8.357848399138332 * scale + translationX,
      3.5241427824497524 * scale + translationY,
      8.327746013361416 * scale + translationX,
      3.550900458695899 * scale + translationY,
      8.300000335595383 * scale + translationX,
      3.5800001447507803 * scale + translationY,
    );

    path.cubicTo(
      8.261407765668512 * scale + translationX,
      3.6153076568232234 * scale + translationY,
      8.227769442740872 * scale + translationX,
      3.6556736443363924 * scale + translationY,
      8.199999627195561 * scale + translationX,
      3.6999998317833627 * scale + translationY,
    );

    path.cubicTo(
      8.200000000000001 * scale + translationX,
      3.7 * scale + translationY,
      8.200000000000001 * scale + translationX,
      3.7 * scale + translationY,
      8.14 * scale + translationX,
      3.7800000000000002 * scale + translationY,
    );

    path.lineTo(
      8.14 * scale + translationX,
      3.7800000000000002 * scale + translationY,
    );

    path.lineTo(
      2.1400000000000006 * scale + translationX,
      14.11 * scale + translationY,
    );

    path.cubicTo(
      1.9613672050459185 * scale + translationX,
      14.419401076758502 * scale + translationY,
      1.9613672050459185 * scale + translationX,
      14.800598923241497 * scale + translationY,
      2.14 * scale + translationX,
      15.11 * scale + translationY,
    );

    path.lineTo(
      5.140000000000001 * scale + translationX,
      20.189999999999998 * scale + translationY,
    );

    path.lineTo(
      5.140000000000001 * scale + translationX,
      20.189999999999998 * scale + translationY,
    );

    path.cubicTo(
      5.170930494164201 * scale + translationX,
      20.24396404513562 * scale + translationY,
      5.2078288160230075 * scale + translationX,
      20.294279938579447 * scale + translationY,
      5.250000088448264 * scale + translationX,
      20.340000342673836 * scale + translationY,
    );

    path.lineTo(
      5.250000000000001 * scale + translationX,
      20.399999999999995 * scale + translationY,
    );

    path.cubicTo(
      5.374220319931128 * scale + translationX,
      20.520010129144957 * scale + translationY,
      5.524955103242942 * scale + translationX,
      20.60908068292012 * scale + translationY,
      5.690000292902649 * scale + translationX,
      20.66000106350943 * scale + translationY,
    );

    path.lineTo(
      5.690000000000001 * scale + translationX,
      20.659999999999997 * scale + translationY,
    );

    path.cubicTo(
      5.763008560096464 * scale + translationX,
      20.669762279195893 * scale + translationY,
      5.836991635332079 * scale + translationX,
      20.66976227919589 * scale + translationY,
      5.9100000995674735 * scale + translationX,
      20.66000034806497 * scale + translationY,
    );

    path.lineTo(
      18.0 * scale + translationX,
      20.659999999999997 * scale + translationY,
    );

    path.cubicTo(
      18.353067291126646 * scale + translationX,
      20.65993842155442 * scale + translationY,
      18.679935684156682 * scale + translationX,
      20.47369945343265 * scale + translationY,
      18.86 * scale + translationX,
      20.169999999999998 * scale + translationY,
    );

    path.lineTo(
      21.86 * scale + translationX,
      15.029999999999998 * scale + translationY,
    );

    path.lineTo(
      21.86 * scale + translationX,
      15.029999999999998 * scale + translationY,
    );

    path.lineTo(
      21.91 * scale + translationX,
      14.909999999999998 * scale + translationY,
    );

    path.cubicTo(
      21.90605589833657 * scale + translationX,
      14.87009714232207 * scale + translationY,
      21.90605589833657 * scale + translationX,
      14.829902704449022 * scale + translationY,
      21.909999886961437 * scale + translationX,
      14.7899999236951 * scale + translationY,
    );

    path.cubicTo(
      21.915333051896248 * scale + translationX,
      14.746829805058812 * scale + translationY,
      21.915333051896248 * scale + translationX,
      14.703168113684221 * scale + translationY,
      21.909998451601354 * scale + translationX,
      14.659998963965123 * scale + translationY,
    );

    path.cubicTo(
      21.91554510422471 * scale + translationX,
      14.616843828664535 * scale + translationY,
      21.915545104224712 * scale + translationX,
      14.57315566029435 * scale + translationY,
      21.90999961641279 * scale + translationX,
      14.529999745617426 * scale + translationY,
    );

    path.cubicTo(
      21.943157156772003 * scale + translationX,
      14.503332851594912 * scale + translationY,
      21.973332697645205 * scale + translationX,
      14.47315731072171 * scale + translationY,
      21.999999546600577 * scale + translationX,
      14.439999702405103 * scale + translationY,
    );

    path.close();

    path.moveTo(
      6.0 * scale + translationX,
      17.73 * scale + translationY,
    );

    path.lineTo(
      4.21 * scale + translationX,
      14.63 * scale + translationY,
    );

    path.lineTo(
      9.0 * scale + translationX,
      6.27 * scale + translationY,
    );

    path.lineTo(
      9.870000000000001 * scale + translationX,
      7.77 * scale + translationY,
    );

    path.lineTo(
      10.870000000000001 * scale + translationX,
      9.43 * scale + translationY,
    );

    path.lineTo(
      7.0 * scale + translationX,
      15.91 * scale + translationY,
    );

    path.close();

    path.moveTo(
      12.0 * scale + translationX,
      11.41 * scale + translationY,
    );

    path.lineTo(
      13.26 * scale + translationX,
      13.57 * scale + translationY,
    );

    path.lineTo(
      10.72 * scale + translationX,
      13.57 * scale + translationY,
    );

    path.close();

    path.moveTo(
      17.43 * scale + translationX,
      18.71 * scale + translationY,
    );

    path.lineTo(
      7.7 * scale + translationX,
      18.71 * scale + translationY,
    );

    path.lineTo(
      9.540000000000001 * scale + translationX,
      15.57 * scale + translationY,
    );

    path.lineTo(
      19.26 * scale + translationX,
      15.57 * scale + translationY,
    );

    path.close();

    path.moveTo(
      15.57 * scale + translationX,
      13.57 * scale + translationY,
    );

    path.lineTo(
      10.74 * scale + translationX,
      5.29 * scale + translationY,
    );

    path.lineTo(
      14.43 * scale + translationX,
      5.29 * scale + translationY,
    );

    path.lineTo(
      19.259999999999998 * scale + translationX,
      13.57 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}