// Code generated using SVG Painter package
// Generated in 2024-08-26T20:39:58.337942

import 'dart:math' as math;

import 'package:flutter/material.dart';

class GitlabIcon extends StatelessWidget {
  final Color? color;

  const GitlabIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: GitlabPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class GitlabPainter extends CustomPainter {
  final Color color;

  const GitlabPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 20.2051434538416;
    final scaleY = size.height / 18.498733409880256;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 20.2051434538416 * scale) / 2 - 1.8952907422002871 * scale;
    final translationY = (size.height - 18.498733409880256 * scale) / 2 - 2.5012668981499107 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      21.94 * scale + translationX,
      12.865 * scale + translationY,
    );

    path.lineTo(
      20.874000000000002 * scale + translationX,
      9.585 * scale + translationY,
    );

    path.lineTo(
      20.875000000000004 * scale + translationX,
      9.590000000000002 * scale + translationY,
    );

    path.lineTo(
      20.875000000000004 * scale + translationX,
      9.585 * scale + translationY,
    );

    path.lineTo(
      18.760000000000005 * scale + translationX,
      3.075000000000001 * scale + translationY,
    );

    path.cubicTo(
      18.645760507372298 * scale + translationX,
      2.7316108134011587 * scale + translationY,
      18.32287491388853 * scale + translationX,
      2.5012668981499107 * scale + translationY,
      17.96100055073258 * scale + translationX,
      2.5050000768100396 * scale + translationY,
    );

    path.cubicTo(
      17.600430985266218 * scale + translationX,
      2.503389752194882 * scale + translationY,
      17.28090524452624 * scale + translationX,
      2.7369517149692797 * scale + translationY,
      17.173000185282337 * scale + translationX,
      3.081000033241419 * scale + translationY,
    );

    path.lineTo(
      15.166000000000006 * scale + translationX,
      9.259 * scale + translationY,
    );

    path.lineTo(
      8.834 * scale + translationX,
      9.259 * scale + translationY,
    );

    path.lineTo(
      6.824 * scale + translationX,
      3.08 * scale + translationY,
    );

    path.cubicTo(
      6.715738339849539 * scale + translationX,
      2.7363475835437123 * scale + translationY,
      6.396297939680387 * scale + translationX,
      2.503253382912669 * scale + translationY,
      6.0360000651234005 * scale + translationX,
      2.5050000270268584 * scale + translationY,
    );

    path.lineTo(
      6.03 * scale + translationX,
      2.505 * scale + translationY,
    );

    path.cubicTo(
      5.668499516932049 * scale + translationX,
      2.5051647837587954 * scale + translationY,
      5.347749796039309 * scale + translationX,
      2.7368621323936266 * scale + translationY,
      5.233999978478854 * scale + translationX,
      3.079999987335665 * scale + translationY,
    );

    path.lineTo(
      3.127 * scale + translationX,
      9.584 * scale + translationY,
    );

    path.lineTo(
      3.125 * scale + translationX,
      9.59 * scale + translationY,
    );

    path.lineTo(
      3.126 * scale + translationX,
      9.584999999999999 * scale + translationY,
    );

    path.lineTo(
      2.057 * scale + translationX,
      12.864999999999998 * scale + translationY,
    );

    path.cubicTo(
      1.8952907422002871 * scale + translationX,
      13.35873693110909 * scale + translationY,
      2.0711246860527925 * scale + translationX,
      13.900386321367382 * scale + translationY,
      2.4920000566514093 * scale + translationX,
      14.20500032292667 * scale + translationY,
    );

    path.lineTo(
      11.721 * scale + translationX,
      20.909999999999997 * scale + translationY,
    );

    path.lineTo(
      11.725 * scale + translationX,
      20.912999999999997 * scale + translationY,
    );

    path.lineTo(
      11.737 * scale + translationX,
      20.920999999999996 * scale + translationY,
    );

    path.lineTo(
      11.726 * scale + translationX,
      20.912999999999997 * scale + translationY,
    );

    path.lineTo(
      11.728000000000002 * scale + translationX,
      20.913999999999998 * scale + translationY,
    );

    path.lineTo(
      11.729000000000001 * scale + translationX,
      20.915 * scale + translationY,
    );

    path.cubicTo(
      11.743455960717009 * scale + translationX,
      20.92517821478057 * scale + translationY,
      11.75848025298703 * scale + translationX,
      20.93452666330414 * scale + translationY,
      11.773999293468083 * scale + translationX,
      20.9429987432565 * scale + translationY,
    );

    path.lineTo(
      11.780000000000001 * scale + translationX,
      20.947 * scale + translationY,
    );

    path.lineTo(
      11.784 * scale + translationX,
      20.948999999999998 * scale + translationY,
    );

    path.lineTo(
      11.787 * scale + translationX,
      20.95 * scale + translationY,
    );

    path.lineTo(
      11.789000000000001 * scale + translationX,
      20.95 * scale + translationY,
    );

    path.lineTo(
      11.794000000000002 * scale + translationX,
      20.953 * scale + translationY,
    );

    path.lineTo(
      11.819000000000003 * scale + translationX,
      20.963 * scale + translationY,
    );

    path.lineTo(
      11.842000000000002 * scale + translationX,
      20.973000000000003 * scale + translationY,
    );

    path.lineTo(
      11.843000000000002 * scale + translationX,
      20.973000000000003 * scale + translationY,
    );

    path.lineTo(
      11.847000000000001 * scale + translationX,
      20.975 * scale + translationY,
    );

    path.lineTo(
      11.852000000000002 * scale + translationX,
      20.977 * scale + translationY,
    );

    path.lineTo(
      11.854000000000003 * scale + translationX,
      20.977 * scale + translationY,
    );

    path.lineTo(
      11.860000000000003 * scale + translationX,
      20.979 * scale + translationY,
    );

    path.lineTo(
      11.863000000000003 * scale + translationX,
      20.979 * scale + translationY,
    );

    path.cubicTo(
      11.874000000000002 * scale + translationX,
      20.983 * scale + translationY,
      11.885000000000003 * scale + translationX,
      20.985 * scale + translationY,
      11.897000000000004 * scale + translationX,
      20.988 * scale + translationY,
    );

    path.lineTo(
      11.910000000000004 * scale + translationX,
      20.991 * scale + translationY,
    );

    path.lineTo(
      11.912000000000004 * scale + translationX,
      20.991 * scale + translationY,
    );

    path.lineTo(
      11.917000000000005 * scale + translationX,
      20.993 * scale + translationY,
    );

    path.lineTo(
      11.924000000000005 * scale + translationX,
      20.994 * scale + translationY,
    );

    path.lineTo(
      11.931000000000004 * scale + translationX,
      20.994 * scale + translationY,
    );

    path.cubicTo(
      11.95283032538159 * scale + translationX,
      20.99756076868207 * scale + translationY,
      11.974885846617077 * scale + translationX,
      20.999565816067115 * scale + translationY,
      11.99700017597324 * scale + translationX,
      21.000000308030167 * scale + translationY,
    );

    path.lineTo(
      11.998000000000005 * scale + translationX,
      21.0 * scale + translationY,
    );

    path.cubicTo(
      12.020424592326288 * scale + translationX,
      20.999937986032332 * scale + translationY,
      12.042815364006255 * scale + translationX,
      20.99826703292189 * scale + translationY,
      12.065000447234494 * scale + translationX,
      20.995000778258444 * scale + translationY,
    );

    path.lineTo(
      12.072000000000005 * scale + translationX,
      20.995 * scale + translationY,
    );

    path.lineTo(
      12.079000000000004 * scale + translationX,
      20.993000000000002 * scale + translationY,
    );

    path.lineTo(
      12.083000000000004 * scale + translationX,
      20.992 * scale + translationY,
    );

    path.lineTo(
      12.085000000000004 * scale + translationX,
      20.992 * scale + translationY,
    );

    path.lineTo(
      12.099000000000004 * scale + translationX,
      20.988 * scale + translationY,
    );

    path.lineTo(
      12.133000000000004 * scale + translationX,
      20.98 * scale + translationY,
    );

    path.lineTo(
      12.135000000000005 * scale + translationX,
      20.98 * scale + translationY,
    );

    path.lineTo(
      12.141000000000005 * scale + translationX,
      20.977 * scale + translationY,
    );

    path.lineTo(
      12.143000000000006 * scale + translationX,
      20.977 * scale + translationY,
    );

    path.lineTo(
      12.148000000000007 * scale + translationX,
      20.975 * scale + translationY,
    );

    path.lineTo(
      12.152000000000006 * scale + translationX,
      20.974 * scale + translationY,
    );

    path.lineTo(
      12.153000000000006 * scale + translationX,
      20.974 * scale + translationY,
    );

    path.lineTo(
      12.178000000000006 * scale + translationX,
      20.963 * scale + translationY,
    );

    path.lineTo(
      12.201000000000006 * scale + translationX,
      20.953 * scale + translationY,
    );

    path.lineTo(
      12.206000000000007 * scale + translationX,
      20.951 * scale + translationY,
    );

    path.lineTo(
      12.208000000000007 * scale + translationX,
      20.951 * scale + translationY,
    );

    path.lineTo(
      12.211000000000007 * scale + translationX,
      20.949 * scale + translationY,
    );

    path.lineTo(
      12.215000000000007 * scale + translationX,
      20.947000000000003 * scale + translationY,
    );

    path.lineTo(
      12.222000000000007 * scale + translationX,
      20.943 * scale + translationY,
    );

    path.cubicTo(
      12.237152071384337 * scale + translationX,
      20.934816073723557 * scale + translationY,
      12.251841079119753 * scale + translationX,
      20.92580236443137 * scale + translationY,
      12.265999815735148 * scale + translationX,
      20.91599968579131 * scale + translationY,
    );

    path.lineTo(
      12.270000000000007 * scale + translationX,
      20.913 * scale + translationY,
    );

    path.lineTo(
      12.275000000000007 * scale + translationX,
      20.91 * scale + translationY,
    );

    path.lineTo(
      21.50500000000001 * scale + translationX,
      14.204 * scale + translationY,
    );

    path.cubicTo(
      21.92507251334138 * scale + translationX,
      13.89925746468299 * scale + translationY,
      22.10043419604189 * scale + translationX,
      13.358222227042479 * scale + translationY,
      21.939000498746108 * scale + translationX,
      12.865000292464039 * scale + translationY,
    );

    path.close();

    path.moveTo(
      17.967000000000002 * scale + translationX,
      3.6850000000000005 * scale + translationY,
    );

    path.lineTo(
      19.777 * scale + translationX,
      9.259 * scale + translationY,
    );

    path.lineTo(
      16.157 * scale + translationX,
      9.259 * scale + translationY,
    );

    path.close();

    path.moveTo(
      6.030000000000003 * scale + translationX,
      3.6850000000000005 * scale + translationY,
    );

    path.lineTo(
      7.843 * scale + translationX,
      9.26 * scale + translationY,
    );

    path.lineTo(
      4.223 * scale + translationX,
      9.26 * scale + translationY,
    );

    path.close();

    path.moveTo(
      3.046000000000003 * scale + translationX,
      13.442 * scale + translationY,
    );

    path.cubicTo(
      2.9569019955555564 * scale + translationX,
      13.376909928529363 * scale + translationY,
      2.919775628531119 * scale + translationX,
      13.261898900247141 * scale + translationY,
      2.9539999482831325 * scale + translationX,
      13.156999769655092 * scale + translationY,
    );

    path.lineTo(
      3.748000000000003 * scale + translationX,
      10.719 * scale + translationY,
    );

    path.lineTo(
      9.570000000000004 * scale + translationX,
      18.183 * scale + translationY,
    );

    path.close();

    path.moveTo(
      4.540000000000003 * scale + translationX,
      10.202 * scale + translationY,
    );

    path.lineTo(
      8.150000000000002 * scale + translationX,
      10.202 * scale + translationY,
    );

    path.lineTo(
      10.723000000000003 * scale + translationX,
      18.128999999999998 * scale + translationY,
    );

    path.close();

    path.moveTo(
      11.705000000000002 * scale + translationX,
      20.898 * scale + translationY,
    );

    path.lineTo(
      11.699000000000002 * scale + translationX,
      20.893 * scale + translationY,
    );

    path.lineTo(
      11.688000000000002 * scale + translationX,
      20.883 * scale + translationY,
    );

    path.lineTo(
      11.668000000000003 * scale + translationX,
      20.865 * scale + translationY,
    );

    path.lineTo(
      11.670000000000003 * scale + translationX,
      20.866 * scale + translationY,
    );

    path.lineTo(
      11.672000000000004 * scale + translationX,
      20.868 * scale + translationY,
    );

    path.cubicTo(
      11.685579518376294 * scale + translationX,
      20.881181317632315 * scale + translationY,
      11.699938667717 * scale + translationX,
      20.89353686473943 * scale + translationY,
      11.714999333028196 * scale + translationX,
      20.904998809812575 * scale + translationY,
    );

    path.lineTo(
      11.717000000000004 * scale + translationX,
      20.906999999999996 * scale + translationY,
    );

    path.close();

    path.moveTo(
      11.998000000000001 * scale + translationX,
      19.003999999999998 * scale + translationY,
    );

    path.lineTo(
      10.484000000000002 * scale + translationX,
      14.338999999999999 * scale + translationY,
    );

    path.lineTo(
      9.140000000000002 * scale + translationX,
      10.200999999999999 * scale + translationY,
    );

    path.lineTo(
      14.860000000000003 * scale + translationX,
      10.200999999999999 * scale + translationY,
    );

    path.close();

    path.moveTo(
      12.308000000000002 * scale + translationX,
      20.883999999999997 * scale + translationY,
    );

    path.lineTo(
      12.298000000000002 * scale + translationX,
      20.891999999999996 * scale + translationY,
    );

    path.lineTo(
      12.296000000000001 * scale + translationX,
      20.892999999999997 * scale + translationY,
    );

    path.lineTo(
      12.291 * scale + translationX,
      20.897999999999996 * scale + translationY,
    );

    path.lineTo(
      12.279 * scale + translationX,
      20.906999999999996 * scale + translationY,
    );

    path.lineTo(
      12.281 * scale + translationX,
      20.904999999999998 * scale + translationY,
    );

    path.cubicTo(
      12.296060877767683 * scale + translationX,
      20.89389719499327 * scale + translationY,
      12.310421481955855 * scale + translationX,
      20.88187436357991 * scale + translationY,
      12.324000957521047 * scale + translationX,
      20.86900162143027 * scale + translationY,
    );

    path.lineTo(
      12.325 * scale + translationX,
      20.866999999999997 * scale + translationY,
    );

    path.lineTo(
      12.327 * scale + translationX,
      20.865 * scale + translationY,
    );

    path.close();

    path.moveTo(
      15.851 * scale + translationX,
      10.2 * scale + translationY,
    );

    path.lineTo(
      19.461000000000002 * scale + translationX,
      10.2 * scale + translationY,
    );

    path.lineTo(
      18.721000000000004 * scale + translationX,
      11.146999999999998 * scale + translationY,
    );

    path.lineTo(
      13.274000000000004 * scale + translationX,
      18.127 * scale + translationY,
    );

    path.close();

    path.moveTo(
      20.951 * scale + translationX,
      13.440999999999999 * scale + translationY,
    );

    path.lineTo(
      14.428 * scale + translationX,
      18.180999999999997 * scale + translationY,
    );

    path.lineTo(
      20.252000000000002 * scale + translationX,
      10.717999999999996 * scale + translationY,
    );

    path.lineTo(
      21.043000000000003 * scale + translationX,
      13.154999999999998 * scale + translationY,
    );

    path.cubicTo(
      21.077709003583646 * scale + translationX,
      13.26019627712977 * scale + translationY,
      21.04053174792007 * scale + translationX,
      13.375769050170888 * scale + translationY,
      20.950999633202393 * scale + translationX,
      13.440999764682989 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}