// Code generated using SVG Painter package
// Generated in 2024-08-26T20:39:57.848433

import 'dart:math' as math;

import 'package:flutter/material.dart';

class FacebookMessengerIcon extends StatelessWidget {
  final Color? color;

  const FacebookMessengerIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: FacebookMessengerPainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class FacebookMessengerPainter extends CustomPainter {
  final Color color;

  const FacebookMessengerPainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 19.747189435269917;
    final scaleY = size.height / 20.13098527863767;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 19.747189435269917 * scale) / 2 - 1.966095326019424 * scale;
    final translationY = (size.height - 20.13098527863767 * scale) / 2 - 1.9045715076554888 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      12.0 * scale + translationX,
      2.0 * scale + translationY,
    );

    path.cubicTo(
      9.371870605395001 * scale + translationX,
      1.9045715076554888 * scale + translationY,
      6.818638596746744 * scale + translationX,
      2.885893332000417 * scale + translationY,
      4.930946250454377 * scale + translationX,
      4.716954907904013 * scale + translationY,
    );

    path.cubicTo(
      3.043253904162009 * scale + translationX,
      6.548016483807609 * scale + translationY,
      1.9846417392177687 * scale + translationX,
      9.070183507847402 * scale + translationY,
      1.9999999425455985 * scale + translationX,
      11.699999663891754 * scale + translationY,
    );

    path.cubicTo(
      1.966095326019424 * scale + translationX,
      14.433388888892118 * scale + translationY,
      3.1100523014135324 * scale + translationX,
      17.049188596958903 * scale + translationY,
      5.140000210255824 * scale + translationX,
      18.88000077230156 * scale + translationY,
    );

    path.cubicTo(
      5.300904073289182 * scale + translationX,
      19.0233223727758 * scale + translationY,
      5.398069430008097 * scale + translationX,
      19.22485052004466 * scale + translationY,
      5.4099999256348905 * scale + translationX,
      19.439999732780453 * scale + translationY,
    );

    path.lineTo(
      5.41 * scale + translationX,
      21.22 * scale + translationY,
    );

    path.cubicTo(
      5.421126934917088 * scale + translationX,
      21.48637079055788 * scale + translationY,
      5.56261762255959 * scale + translationX,
      21.73020930419247 * scale + translationY,
      5.788359503632375 * scale + translationX,
      21.8720471232736 * scale + translationY,
    );

    path.cubicTo(
      6.014101384705159 * scale + translationX,
      22.01388494235473 * scale + translationY,
      6.295183519678874 * scale + translationX,
      22.03555678629316 * scale + translationY,
      6.5399999101020665 * scale + translationX,
      21.92999969855326 * scale + translationY,
    );

    path.lineTo(
      8.54 * scale + translationX,
      21.06 * scale + translationY,
    );

    path.cubicTo(
      8.710779321635911 * scale + translationX,
      20.995498114599997 * scale + translationY,
      8.899221203182982 * scale + translationX,
      20.995498114599993 * scale + translationY,
      9.070000270307062 * scale + translationX,
      21.06000062763691 * scale + translationY,
    );

    path.cubicTo(
      10.015442711141706 * scale + translationX,
      21.315189065161533 * scale + translationY,
      10.990728361588948 * scale + translationX,
      21.442985115909792 * scale + translationY,
      11.970000356733799 * scale + translationX,
      21.44000063896179 * scale + translationY,
    );

    path.cubicTo(
      17.338208196708045 * scale + translationX,
      21.448284753487002 * scale + translationY,
      21.6967162185608 * scale + translationX,
      17.10320818932871 * scale + translationY,
      21.70500048992507 * scale + translationX,
      11.735000345280973 * scale + translationY,
    );

    path.cubicTo(
      21.71328476128934 * scale + translationX,
      6.366792501233236 * scale + translationY,
      17.36820819713105 * scale + translationX,
      2.0082844793804826 * scale + translationY,
      12.000000353083312 * scale + translationX,
      2.0000002080162123 * scale + translationY,
    );

    path.close();

    path.moveTo(
      18.0 * scale + translationX,
      9.46 * scale + translationY,
    );

    path.lineTo(
      15.07 * scale + translationX,
      14.120000000000001 * scale + translationY,
    );

    path.cubicTo(
      14.84659064053998 * scale + translationX,
      14.474705003665207 * scale + translationY,
      14.484945647381913 * scale + translationX,
      14.71973901727575 * scale + translationY,
      14.07269257178046 * scale + translationX,
      14.79573036761703 * scale + translationY,
    );

    path.cubicTo(
      13.660439496179006 * scale + translationX,
      14.871721717958312 * scale + translationY,
      13.23519643162549 * scale + translationX,
      14.771736194248522 * scale + translationY,
      12.90000038444996 * scale + translationX,
      14.520000432729724 * scale + translationY,
    );

    path.lineTo(
      10.56 * scale + translationX,
      12.770000000000001 * scale + translationY,
    );

    path.cubicTo(
      10.346666829533039 * scale + translationX,
      12.610000205198912 * scale + translationY,
      10.053333494716211 * scale + translationX,
      12.610000205198912 * scale + translationY,
      9.840000156402578 * scale + translationX,
      12.770000202973673 * scale + translationY,
    );

    path.lineTo(
      6.68 * scale + translationX,
      15.170000000000002 * scale + translationY,
    );

    path.cubicTo(
      6.498270831891615 * scale + translationX,
      15.31015269809339 * scale + translationY,
      6.241897684798142 * scale + translationX,
      15.298568869198206 * scale + translationY,
      6.073548466738608 * scale + translationX,
      15.142598270113638 * scale + translationY,
    );

    path.cubicTo(
      5.905199248679073 * scale + translationX,
      14.98662767102907 * scale + translationY,
      5.874107120514273 * scale + translationX,
      14.731883377258496 * scale + translationY,
      5.999999941866449 * scale + translationX,
      14.539999859123027 * scale + translationY,
    );

    path.lineTo(
      8.93 * scale + translationX,
      9.88 * scale + translationY,
    );

    path.cubicTo(
      9.153410074715762 * scale + translationX,
      9.525295711590534 * scale + translationY,
      9.515055067873822 * scale + translationX,
      9.280261697979993 * scale + translationY,
      9.927308143475276 * scale + translationX,
      9.20427034763871 * scale + translationY,
    );

    path.cubicTo(
      10.339561219076732 * scale + translationX,
      9.128278997297429 * scale + translationY,
      10.764804283630248 * scale + translationX,
      9.228264521007219 * scale + translationY,
      11.100000330805777 * scale + translationX,
      9.480000282526017 * scale + translationY,
    );

    path.lineTo(
      13.44 * scale + translationX,
      11.23 * scale + translationY,
    );

    path.cubicTo(
      13.653333551936665 * scale + translationX,
      11.390000176270794 * scale + translationY,
      13.946666886753492 * scale + translationX,
      11.390000176270794 * scale + translationY,
      14.160000225067126 * scale + translationX,
      11.230000178496033 * scale + translationY,
    );

    path.lineTo(
      17.32 * scale + translationX,
      8.83 * scale + translationY,
    );

    path.cubicTo(
      17.501728935574178 * scale + translationX,
      8.689847069372409 * scale + translationY,
      17.75810208266765 * scale + translationX,
      8.701430898267589 * scale + translationY,
      17.926451300727184 * scale + translationX,
      8.857401497352157 * scale + translationY,
    );

    path.cubicTo(
      18.094800518786723 * scale + translationX,
      9.013372096436727 * scale + translationY,
      18.12589264695152 * scale + translationX,
      9.268116390207298 * scale + translationY,
      17.999999825599346 * scale + translationX,
      9.459999908342768 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}