// Code generated using SVG Painter package
// Generated in 2024-08-26T20:39:55.824520

import 'dart:math' as math;

import 'package:flutter/material.dart';

class ArrowsResizeIcon extends StatelessWidget {
  final Color? color;

  const ArrowsResizeIcon({
    super.key,
    this.color,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final colorScheme = Theme.of(context).colorScheme;
        final size = Size(constraints.maxWidth, constraints.maxHeight);

        return CustomPaint(
          size: size,
          painter: ArrowsResizePainter(color: color ?? colorScheme.primary),
        );
      },
    );
  }
}

class ArrowsResizePainter extends CustomPainter {
  final Color color;

  const ArrowsResizePainter({
    super.repaint,
    required this.color,
  });

  @override
  void paint(Canvas canvas, Size size) {
    final scaleX = size.width / 20.040036036299274;
    final scaleY = size.height / 10.0;
    final scale = math.min(scaleX, scaleY);

    final translationX = (size.width - 20.040036036299274 * scale) / 2 - 1.9799819818503657 * scale;
    final translationY = (size.height - 10.0 * scale) / 2 - 7.0 * scale;

    final path = Path();
    final paint = Paint()..color = color;

    path.moveTo(
      21.92 * scale + translationX,
      11.620000000000001 * scale + translationY,
    );

    path.cubicTo(
      21.87240561187003 * scale + translationX,
      11.497248682277576 * scale + translationY,
      21.801040629317033 * scale + translationX,
      11.385103709694299 * scale + translationY,
      21.71 * scale + translationX,
      11.290000000000001 * scale + translationY,
    );

    path.lineTo(
      19.21 * scale + translationX,
      8.790000000000001 * scale + translationY,
    );

    path.cubicTo(
      18.81787812505728 * scale + translationX,
      8.397877991497856 * scale + translationY,
      18.182122475413962 * scale + translationX,
      8.397877991497856 * scale + translationY,
      17.790000306486196 * scale + translationX,
      8.79000016042562 * scale + translationY,
    );

    path.cubicTo(
      17.39787813755843 * scale + translationX,
      9.182122329353387 * scale + translationY,
      17.39787813755843 * scale + translationX,
      9.817877978996709 * scale + translationY,
      17.790000306486196 * scale + translationX,
      10.210000147924475 * scale + translationY,
    );

    path.lineTo(
      18.59 * scale + translationX,
      11.0 * scale + translationY,
    );

    path.lineTo(
      13.0 * scale + translationX,
      11.0 * scale + translationY,
    );

    path.lineTo(
      13.0 * scale + translationX,
      8.0 * scale + translationY,
    );

    path.cubicTo(
      13.0 * scale + translationX,
      7.447715250169207 * scale + translationY,
      12.552284749830793 * scale + translationX,
      7.0 * scale + translationY,
      12.0 * scale + translationX,
      7.0 * scale + translationY,
    );

    path.cubicTo(
      11.447715250169207 * scale + translationX,
      7.0 * scale + translationY,
      11.0 * scale + translationX,
      7.447715250169207 * scale + translationY,
      11.0 * scale + translationX,
      8.0 * scale + translationY,
    );

    path.lineTo(
      11.0 * scale + translationX,
      11.0 * scale + translationY,
    );

    path.lineTo(
      5.41 * scale + translationX,
      11.0 * scale + translationY,
    );

    path.lineTo(
      6.21 * scale + translationX,
      10.21 * scale + translationY,
    );

    path.cubicTo(
      6.602122251936431 * scale + translationX,
      9.817877978996709 * scale + translationY,
      6.602122251936432 * scale + translationX,
      9.182122329353387 * scale + translationY,
      6.210000083008665 * scale + translationX,
      8.79000016042562 * scale + translationY,
    );

    path.cubicTo(
      5.817877914080897 * scale + translationX,
      8.397877991497856 * scale + translationY,
      5.182122264437579 * scale + translationX,
      8.397877991497856 * scale + translationY,
      4.790000095509812 * scale + translationX,
      8.79000016042562 * scale + translationY,
    );

    path.lineTo(
      2.29 * scale + translationX,
      11.29 * scale + translationY,
    );

    path.cubicTo(
      2.198959370682968 * scale + translationX,
      11.385103709694297 * scale + translationY,
      2.1275943881299737 * scale + translationX,
      11.497248682277574 * scale + translationY,
      2.0799999999999996 * scale + translationX,
      11.62 * scale + translationY,
    );

    path.cubicTo(
      1.979981981850366 * scale + translationX,
      11.863461355746574 * scale + translationY,
      1.9799819818503657 * scale + translationX,
      12.136538644253424 * scale + translationY,
      2.0799999999999996 * scale + translationX,
      12.379999999999999 * scale + translationY,
    );

    path.cubicTo(
      2.1275943881299746 * scale + translationX,
      12.502751317722424 * scale + translationY,
      2.198959370682969 * scale + translationX,
      12.614896290305701 * scale + translationY,
      2.2900000000000005 * scale + translationX,
      12.709999999999999 * scale + translationY,
    );

    path.lineTo(
      4.79 * scale + translationX,
      15.209999999999999 * scale + translationY,
    );

    path.cubicTo(
      4.977766599905556 * scale + translationX,
      15.399312650823095 * scale + translationY,
      5.233362463629442 * scale + translationX,
      15.505798324341669 * scale + translationY,
      5.5 * scale + translationX,
      15.505798324341669 * scale + translationY,
    );

    path.cubicTo(
      5.766637536370558 * scale + translationX,
      15.505798324341669 * scale + translationY,
      6.022233400094444 * scale + translationX,
      15.399312650823095 * scale + translationY,
      6.21 * scale + translationX,
      15.209999999999999 * scale + translationY,
    );

    path.cubicTo(
      6.399312650823097 * scale + translationX,
      15.022233400094443 * scale + translationY,
      6.50579832434167 * scale + translationX,
      14.766637536370558 * scale + translationY,
      6.50579832434167 * scale + translationX,
      14.5 * scale + translationY,
    );

    path.cubicTo(
      6.50579832434167 * scale + translationX,
      14.23336246362944 * scale + translationY,
      6.399312650823097 * scale + translationX,
      13.977766599905555 * scale + translationY,
      6.21 * scale + translationX,
      13.79 * scale + translationY,
    );

    path.lineTo(
      5.41 * scale + translationX,
      13.0 * scale + translationY,
    );

    path.lineTo(
      11.0 * scale + translationX,
      13.0 * scale + translationY,
    );

    path.lineTo(
      11.0 * scale + translationX,
      16.0 * scale + translationY,
    );

    path.cubicTo(
      11.0 * scale + translationX,
      16.552284749830793 * scale + translationY,
      11.447715250169207 * scale + translationX,
      17.0 * scale + translationY,
      12.0 * scale + translationX,
      17.0 * scale + translationY,
    );

    path.cubicTo(
      12.552284749830793 * scale + translationX,
      17.0 * scale + translationY,
      13.0 * scale + translationX,
      16.552284749830793 * scale + translationY,
      13.0 * scale + translationX,
      16.0 * scale + translationY,
    );

    path.lineTo(
      13.0 * scale + translationX,
      13.0 * scale + translationY,
    );

    path.lineTo(
      18.59 * scale + translationX,
      13.0 * scale + translationY,
    );

    path.lineTo(
      17.79 * scale + translationX,
      13.79 * scale + translationY,
    );

    path.cubicTo(
      17.6006873491769 * scale + translationX,
      13.977766599905555 * scale + translationY,
      17.494201675658328 * scale + translationX,
      14.233362463629442 * scale + translationY,
      17.494201675658328 * scale + translationX,
      14.5 * scale + translationY,
    );

    path.cubicTo(
      17.494201675658328 * scale + translationX,
      14.766637536370558 * scale + translationY,
      17.6006873491769 * scale + translationX,
      15.022233400094445 * scale + translationY,
      17.79 * scale + translationX,
      15.21 * scale + translationY,
    );

    path.cubicTo(
      17.977766599905554 * scale + translationX,
      15.399312650823097 * scale + translationY,
      18.23336246362944 * scale + translationX,
      15.50579832434167 * scale + translationY,
      18.5 * scale + translationX,
      15.50579832434167 * scale + translationY,
    );

    path.cubicTo(
      18.76663753637056 * scale + translationX,
      15.50579832434167 * scale + translationY,
      19.022233400094446 * scale + translationX,
      15.399312650823097 * scale + translationY,
      19.21 * scale + translationX,
      15.209999999999999 * scale + translationY,
    );

    path.lineTo(
      21.71 * scale + translationX,
      12.709999999999999 * scale + translationY,
    );

    path.cubicTo(
      21.801040629317033 * scale + translationX,
      12.614896290305701 * scale + translationY,
      21.87240561187003 * scale + translationX,
      12.502751317722424 * scale + translationY,
      21.92 * scale + translationX,
      12.379999999999999 * scale + translationY,
    );

    path.cubicTo(
      22.02001801814964 * scale + translationX,
      12.136538644253424 * scale + translationY,
      22.020018018149635 * scale + translationX,
      11.863461355746576 * scale + translationY,
      21.92 * scale + translationX,
      11.620000000000001 * scale + translationY,
    );

    path.close();

    canvas.drawPath(path, paint);
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}